(function () {

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// packages/webapp/webapp_tests.js                                           //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
                                                                             //
var url = Npm.require("url");                                                // 1
var crypto = Npm.require("crypto");                                          // 2
var http = Npm.require("http");                                              // 3
                                                                             // 4
var additionalScript = "(function () { var foo = 1; })";                     // 5
WebAppInternals.addStaticJs(additionalScript);                               // 6
var hash = crypto.createHash('sha1');                                        // 7
hash.update(additionalScript);                                               // 8
var additionalScriptPathname = hash.digest('hex') + ".js";                   // 9
                                                                             // 10
// Mock the 'res' object that gets passed to connect handlers. This mock     // 11
// just records any utf8 data written to the response and returns it         // 12
// when you call `mockResponse.getBody()`.                                   // 13
var MockResponse = function () {                                             // 14
  this.buffer = "";                                                          // 15
  this.statusCode = null;                                                    // 16
};                                                                           // 17
                                                                             // 18
MockResponse.prototype.writeHead = function (statusCode) {                   // 19
  this.statusCode = statusCode;                                              // 20
};                                                                           // 21
                                                                             // 22
MockResponse.prototype.setHeader = function (name, value) {                  // 23
  // nothing                                                                 // 24
};                                                                           // 25
                                                                             // 26
MockResponse.prototype.write = function (data, encoding) {                   // 27
  if (! encoding || encoding === "utf8") {                                   // 28
    this.buffer = this.buffer + data;                                        // 29
  }                                                                          // 30
};                                                                           // 31
                                                                             // 32
MockResponse.prototype.end = function (data, encoding) {                     // 33
  if (! encoding || encoding === "utf8") {                                   // 34
    if (data) {                                                              // 35
      this.buffer = this.buffer + data;                                      // 36
    }                                                                        // 37
  }                                                                          // 38
};                                                                           // 39
                                                                             // 40
MockResponse.prototype.getBody = function () {                               // 41
  return this.buffer;                                                        // 42
};                                                                           // 43
                                                                             // 44
                                                                             // 45
                                                                             // 46
Tinytest.add("webapp - content-type header", function (test) {               // 47
  var cssResource = _.find(                                                  // 48
    _.keys(WebAppInternals.staticFiles),                                     // 49
    function (url) {                                                         // 50
      return WebAppInternals.staticFiles[url].type === "css";                // 51
    }                                                                        // 52
  );                                                                         // 53
  var jsResource = _.find(                                                   // 54
    _.keys(WebAppInternals.staticFiles),                                     // 55
    function (url) {                                                         // 56
      return WebAppInternals.staticFiles[url].type === "js";                 // 57
    }                                                                        // 58
  );                                                                         // 59
                                                                             // 60
  var resp = HTTP.get(url.resolve(Meteor.absoluteUrl(), cssResource));       // 61
  test.equal(resp.headers["content-type"].toLowerCase(),                     // 62
             "text/css; charset=utf-8");                                     // 63
  resp = HTTP.get(url.resolve(Meteor.absoluteUrl(), jsResource));            // 64
  test.equal(resp.headers["content-type"].toLowerCase(),                     // 65
             "application/javascript; charset=utf-8");                       // 66
});                                                                          // 67
                                                                             // 68
Tinytest.add("webapp - additional static javascript", function (test) {      // 69
  var origInlineScriptsAllowed = WebAppInternals.inlineScriptsAllowed();     // 70
                                                                             // 71
  var staticFilesOpts = {                                                    // 72
    staticFiles: {},                                                         // 73
    clientDir: "/"                                                           // 74
  };                                                                         // 75
                                                                             // 76
  // It's okay to set this global state because we're not going to yield     // 77
  // before settng it back to what it was originally.                        // 78
  WebAppInternals.setInlineScriptsAllowed(true);                             // 79
                                                                             // 80
  Meteor._noYieldsAllowed(function () {                                      // 81
    var boilerplate = WebAppInternals.getBoilerplate({                       // 82
      browser: "doesn't-matter",                                             // 83
      url: "also-doesnt-matter"                                              // 84
    });                                                                      // 85
                                                                             // 86
    // When inline scripts are allowed, the script should be inlined.        // 87
    test.isTrue(boilerplate.indexOf(additionalScript) !== -1);               // 88
                                                                             // 89
    // And the script should not be served as its own separate resource,     // 90
    // meaning that the static file handler should pass on this request.     // 91
    var res = new MockResponse();                                            // 92
    var req = new http.IncomingMessage();                                    // 93
    req.headers = {};                                                        // 94
    req.method = "GET";                                                      // 95
    req.url = "/" + additionalScriptPathname;                                // 96
    var nextCalled = false;                                                  // 97
    WebAppInternals.staticFilesMiddleware(                                   // 98
      staticFilesOpts, req, res, function () {                               // 99
        nextCalled = true;                                                   // 100
      });                                                                    // 101
    test.isTrue(nextCalled);                                                 // 102
                                                                             // 103
    // When inline scripts are disallowed, the script body should not be     // 104
    // inlined, and the script should be included in a <script src="..">     // 105
    // tag.                                                                  // 106
    WebAppInternals.setInlineScriptsAllowed(false);                          // 107
    boilerplate = WebAppInternals.getBoilerplate({                           // 108
      browser: "doesn't-matter",                                             // 109
      url: "also-doesnt-matter"                                              // 110
    });                                                                      // 111
                                                                             // 112
    // The script contents itself should not be present; the pathname        // 113
    // where the script is served should be.                                 // 114
    test.isTrue(boilerplate.indexOf(additionalScript) === -1);               // 115
    test.isTrue(boilerplate.indexOf(additionalScriptPathname) !== -1);       // 116
                                                                             // 117
    // And the static file handler should serve the script at that pathname. // 118
    res = new MockResponse();                                                // 119
    WebAppInternals.staticFilesMiddleware(staticFilesOpts, req, res,         // 120
                                     function () { });                       // 121
    var resBody = res.getBody();                                             // 122
    test.isTrue(resBody.indexOf(additionalScript) !== -1);                   // 123
    test.equal(res.statusCode, 200);                                         // 124
  });                                                                        // 125
                                                                             // 126
  WebAppInternals.setInlineScriptsAllowed(origInlineScriptsAllowed);         // 127
});                                                                          // 128
                                                                             // 129
///////////////////////////////////////////////////////////////////////////////

}).call(this);
