(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/ui/render_tests.js                                                                                       //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
var toCode = BlazeTools.toJS;                                                                                        // 1
                                                                                                                     // 2
var P = HTML.P;                                                                                                      // 3
var CharRef = HTML.CharRef;                                                                                          // 4
var DIV = HTML.DIV;                                                                                                  // 5
var Comment = HTML.Comment;                                                                                          // 6
var BR = HTML.BR;                                                                                                    // 7
var A = HTML.A;                                                                                                      // 8
var UL = HTML.UL;                                                                                                    // 9
var LI = HTML.LI;                                                                                                    // 10
var SPAN = HTML.SPAN;                                                                                                // 11
var HR = HTML.HR;                                                                                                    // 12
var TEXTAREA = HTML.TEXTAREA;                                                                                        // 13
var INPUT = HTML.INPUT;                                                                                              // 14
                                                                                                                     // 15
var materialize = function (content, parent) {                                                                       // 16
  var func = content;                                                                                                // 17
  if (typeof content !== 'function') {                                                                               // 18
    func = function () {                                                                                             // 19
      return content;                                                                                                // 20
    };                                                                                                               // 21
  }                                                                                                                  // 22
  Blaze.render(func).attach(parent);                                                                                 // 23
};                                                                                                                   // 24
                                                                                                                     // 25
var toHTML = Blaze.toHTML;                                                                                           // 26
                                                                                                                     // 27
Tinytest.add("ui - render - basic", function (test) {                                                                // 28
  var run = function (input, expectedInnerHTML, expectedHTML, expectedCode) {                                        // 29
    var div = document.createElement("DIV");                                                                         // 30
    materialize(input, div);                                                                                         // 31
    test.equal(canonicalizeHtml(div.innerHTML), expectedInnerHTML);                                                  // 32
    test.equal(toHTML(input), expectedHTML);                                                                         // 33
    if (typeof expectedCode !== 'undefined')                                                                         // 34
      test.equal(toCode(input), expectedCode);                                                                       // 35
  };                                                                                                                 // 36
                                                                                                                     // 37
  run(P('Hello'),                                                                                                    // 38
      '<p>Hello</p>',                                                                                                // 39
      '<p>Hello</p>',                                                                                                // 40
      'HTML.P("Hello")');                                                                                            // 41
                                                                                                                     // 42
  run(null, '', '', 'null');                                                                                         // 43
  run([], '', '', '[]');                                                                                             // 44
  run([null, null], '', '', '[null, null]');                                                                         // 45
                                                                                                                     // 46
  // Test crazy character references                                                                                 // 47
                                                                                                                     // 48
  // `&zopf;` is "Mathematical double-struck small z" a.k.a. "open-face z"                                           // 49
  run(P(CharRef({html: '&zopf;', str: '\ud835\udd6b'})),                                                             // 50
      '<p>\ud835\udd6b</p>',                                                                                         // 51
      '<p>&zopf;</p>',                                                                                               // 52
      'HTML.P(HTML.CharRef({html: "&zopf;", str: "\\ud835\\udd6b"}))');                                              // 53
                                                                                                                     // 54
  run(P({id: CharRef({html: '&zopf;', str: '\ud835\udd6b'})}, 'Hello'),                                              // 55
      '<p id="\ud835\udd6b">Hello</p>',                                                                              // 56
      '<p id="&zopf;">Hello</p>',                                                                                    // 57
      'HTML.P({id: HTML.CharRef({html: "&zopf;", str: "\\ud835\\udd6b"})}, "Hello")');                               // 58
                                                                                                                     // 59
  run(P({id: [CharRef({html: '&zopf;', str: '\ud835\udd6b'}), '!']}, 'Hello'),                                       // 60
      '<p id="\ud835\udd6b!">Hello</p>',                                                                             // 61
      '<p id="&zopf;!">Hello</p>',                                                                                   // 62
      'HTML.P({id: [HTML.CharRef({html: "&zopf;", str: "\\ud835\\udd6b"}), "!"]}, "Hello")');                        // 63
                                                                                                                     // 64
  // Test comments                                                                                                   // 65
                                                                                                                     // 66
  run(DIV(Comment('Test')),                                                                                          // 67
      '<div><!----></div>', // our innerHTML-canonicalization function kills comment contents                        // 68
      '<div><!--Test--></div>',                                                                                      // 69
      'HTML.DIV(HTML.Comment("Test"))');                                                                             // 70
                                                                                                                     // 71
  // Test arrays                                                                                                     // 72
                                                                                                                     // 73
  run([P('Hello'), P('World')],                                                                                      // 74
      '<p>Hello</p><p>World</p>',                                                                                    // 75
      '<p>Hello</p><p>World</p>',                                                                                    // 76
      '[HTML.P("Hello"), HTML.P("World")]');                                                                         // 77
                                                                                                                     // 78
  // Test slightly more complicated structure                                                                        // 79
                                                                                                                     // 80
  run(DIV({'class': 'foo'}, UL(LI(P(A({href: '#one'}, 'One'))),                                                      // 81
                               LI(P('Two', BR(), 'Three')))),                                                        // 82
      '<div class="foo"><ul><li><p><a href="#one">One</a></p></li><li><p>Two<br>Three</p></li></ul></div>',          // 83
      '<div class="foo"><ul><li><p><a href="#one">One</a></p></li><li><p>Two<br>Three</p></li></ul></div>',          // 84
      'HTML.DIV({"class": "foo"}, HTML.UL(HTML.LI(HTML.P(HTML.A({href: "#one"}, "One"))), HTML.LI(HTML.P("Two", HTML.BR(), "Three"))))');
                                                                                                                     // 86
                                                                                                                     // 87
  // Test nully attributes                                                                                           // 88
  run(BR({x: null,                                                                                                   // 89
          y: [[], []],                                                                                               // 90
          a: [['']]}),                                                                                               // 91
      '<br a="">',                                                                                                   // 92
      '<br a="">',                                                                                                   // 93
      'HTML.BR({a: [[""]]})');                                                                                       // 94
                                                                                                                     // 95
  run(BR({                                                                                                           // 96
    x: function () { return Blaze.View(function () { return Blaze.View(function () { return []; }); }); },           // 97
    a: function () { return Blaze.View(function () { return Blaze.View(function () { return ''; }); }); }}),         // 98
      '<br a="">',                                                                                                   // 99
      '<br a="">');                                                                                                  // 100
});                                                                                                                  // 101
                                                                                                                     // 102
// test that we correctly update the 'value' property on input fields                                                // 103
// rather than the 'value' attribute. the 'value' attribute only sets                                                // 104
// the initial value.                                                                                                // 105
Tinytest.add("ui - render - input - value", function (test) {                                                        // 106
  var R = ReactiveVar("hello");                                                                                      // 107
  var div = document.createElement("DIV");                                                                           // 108
  materialize(INPUT({value: function () { return R.get(); }}), div);                                                 // 109
  var inputEl = div.querySelector('input');                                                                          // 110
  test.equal(inputEl.value, "hello");                                                                                // 111
  inputEl.value = "goodbye";                                                                                         // 112
  R.set("hola");                                                                                                     // 113
  Deps.flush();                                                                                                      // 114
  test.equal(inputEl.value, "hola");                                                                                 // 115
});                                                                                                                  // 116
                                                                                                                     // 117
// test that we correctly update the 'checked' property rather than                                                  // 118
// the 'checked' attribute on input fields of type 'checkbox'. the                                                   // 119
// 'checked' attribute only sets the initial value.                                                                  // 120
Tinytest.add("ui - render - input - checked", function (test) {                                                      // 121
  var R = ReactiveVar(null);                                                                                         // 122
  var div = document.createElement("DIV");                                                                           // 123
  materialize(INPUT({type: "checkbox", checked: function () { return R.get(); }}), div);                             // 124
  var inputEl = div.querySelector('input');                                                                          // 125
  test.equal(inputEl.checked, false);                                                                                // 126
  inputEl.checked = true;                                                                                            // 127
                                                                                                                     // 128
  R.set("checked");                                                                                                  // 129
  Deps.flush();                                                                                                      // 130
  R.set(null);                                                                                                       // 131
  Deps.flush();                                                                                                      // 132
  test.equal(inputEl.checked, false);                                                                                // 133
});                                                                                                                  // 134
                                                                                                                     // 135
Tinytest.add("ui - render - textarea", function (test) {                                                             // 136
  var run = function (optNode, text, html, code) {                                                                   // 137
    if (typeof optNode === 'string') {                                                                               // 138
      // called with args (text, html, code)                                                                         // 139
      code = html;                                                                                                   // 140
      html = text;                                                                                                   // 141
      text = optNode;                                                                                                // 142
      optNode = null;                                                                                                // 143
    }                                                                                                                // 144
    var div = document.createElement("DIV");                                                                         // 145
    var node = TEXTAREA({value: optNode || text});                                                                   // 146
    materialize(node, div);                                                                                          // 147
                                                                                                                     // 148
    var value = div.querySelector('textarea').value;                                                                 // 149
    value = value.replace(/\r\n/g, "\n"); // IE8 substitutes \n with \r\n                                            // 150
    test.equal(value, text);                                                                                         // 151
                                                                                                                     // 152
    test.equal(toHTML(node), html);                                                                                  // 153
    if (typeof code === 'string')                                                                                    // 154
      test.equal(toCode(node), code);                                                                                // 155
  };                                                                                                                 // 156
                                                                                                                     // 157
  run('Hello',                                                                                                       // 158
      '<textarea>Hello</textarea>',                                                                                  // 159
      'HTML.TEXTAREA({value: "Hello"})');                                                                            // 160
                                                                                                                     // 161
  run('\nHello',                                                                                                     // 162
      '<textarea>\n\nHello</textarea>',                                                                              // 163
      'HTML.TEXTAREA({value: "\\nHello"})');                                                                         // 164
                                                                                                                     // 165
  run('</textarea>',                                                                                                 // 166
      '<textarea>&lt;/textarea></textarea>',                                                                         // 167
      'HTML.TEXTAREA({value: "</textarea>"})');                                                                      // 168
                                                                                                                     // 169
  run(CharRef({html: '&amp;', str: '&'}),                                                                            // 170
      '&',                                                                                                           // 171
      '<textarea>&amp;</textarea>',                                                                                  // 172
      'HTML.TEXTAREA({value: HTML.CharRef({html: "&amp;", str: "&"})})');                                            // 173
                                                                                                                     // 174
  run(function () {                                                                                                  // 175
    return ['a', Blaze.View(function () { return 'b'; }), 'c'];                                                      // 176
  },                                                                                                                 // 177
      'abc',                                                                                                         // 178
      '<textarea>abc</textarea>');                                                                                   // 179
                                                                                                                     // 180
  // test that reactivity of textarea "value" attribute works...                                                     // 181
  (function () {                                                                                                     // 182
    var R = ReactiveVar('one');                                                                                      // 183
    var div = document.createElement("DIV");                                                                         // 184
    var node = TEXTAREA({value: function () {                                                                        // 185
      return Blaze.View(function () {                                                                                // 186
        return R.get();                                                                                              // 187
      });                                                                                                            // 188
    }});                                                                                                             // 189
    materialize(node, div);                                                                                          // 190
    var textarea = div.querySelector('textarea');                                                                    // 191
    test.equal(textarea.value, 'one');                                                                               // 192
    R.set('two');                                                                                                    // 193
    Deps.flush();                                                                                                    // 194
    test.equal(textarea.value, 'two');                                                                               // 195
  })();                                                                                                              // 196
                                                                                                                     // 197
  // ... while "content" reactivity simply doesn't update                                                            // 198
  // (but doesn't throw either)                                                                                      // 199
  (function () {                                                                                                     // 200
    var R = ReactiveVar('one');                                                                                      // 201
    var div = document.createElement("DIV");                                                                         // 202
    var node = TEXTAREA([Blaze.View(function () {                                                                    // 203
      return R.get();                                                                                                // 204
    })]);                                                                                                            // 205
    materialize(node, div);                                                                                          // 206
    var textarea = div.querySelector('textarea');                                                                    // 207
    test.equal(textarea.value, 'one');                                                                               // 208
    R.set('two');                                                                                                    // 209
    Deps.flush({_throwFirstError: true});                                                                            // 210
    test.equal(textarea.value, 'one');                                                                               // 211
  })();                                                                                                              // 212
});                                                                                                                  // 213
                                                                                                                     // 214
Tinytest.add("ui - render - view isolation", function (test) {                                                       // 215
                                                                                                                     // 216
  // Reactively change a text node                                                                                   // 217
  (function () {                                                                                                     // 218
    var R = ReactiveVar('Hello');                                                                                    // 219
    var test1 = function () {                                                                                        // 220
      return P(Blaze.View(function () { return R.get(); }));                                                         // 221
    };                                                                                                               // 222
                                                                                                                     // 223
    test.equal(toHTML(test1()), '<p>Hello</p>');                                                                     // 224
                                                                                                                     // 225
    var div = document.createElement("DIV");                                                                         // 226
    materialize(test1, div);                                                                                         // 227
    test.equal(canonicalizeHtml(div.innerHTML), "<p>Hello</p>");                                                     // 228
                                                                                                                     // 229
    R.set('World');                                                                                                  // 230
    Deps.flush();                                                                                                    // 231
    test.equal(canonicalizeHtml(div.innerHTML), "<p>World</p>");                                                     // 232
  })();                                                                                                              // 233
                                                                                                                     // 234
  // Reactively change an array of text nodes                                                                        // 235
  (function () {                                                                                                     // 236
    var R = ReactiveVar(['Hello', ' World']);                                                                        // 237
    var test1 = function () {                                                                                        // 238
      return P(Blaze.View(function () { return R.get(); }));                                                         // 239
    };                                                                                                               // 240
                                                                                                                     // 241
    test.equal(toHTML(test1()), '<p>Hello World</p>');                                                               // 242
                                                                                                                     // 243
    var div = document.createElement("DIV");                                                                         // 244
    materialize(test1, div);                                                                                         // 245
    test.equal(canonicalizeHtml(div.innerHTML), "<p>Hello World</p>");                                               // 246
                                                                                                                     // 247
    R.set(['Goodbye', ' World']);                                                                                    // 248
    Deps.flush();                                                                                                    // 249
    test.equal(canonicalizeHtml(div.innerHTML), "<p>Goodbye World</p>");                                             // 250
  })();                                                                                                              // 251
                                                                                                                     // 252
});                                                                                                                  // 253
                                                                                                                     // 254
// IE strips malformed styles like "bar::d" from the `style`                                                         // 255
// attribute. We detect this to adjust expectations for the StyleHandler                                             // 256
// test below.                                                                                                       // 257
var malformedStylesAllowed = function () {                                                                           // 258
  var div = document.createElement("div");                                                                           // 259
  div.setAttribute("style", "bar::d;");                                                                              // 260
  return (div.getAttribute("style") === "bar::d;");                                                                  // 261
};                                                                                                                   // 262
                                                                                                                     // 263
Tinytest.add("ui - render - view GC", function (test) {                                                              // 264
  // test that removing parent element removes listeners and stops autoruns.                                         // 265
  (function () {                                                                                                     // 266
    var R = ReactiveVar('Hello');                                                                                    // 267
    var test1 = P(Blaze.View(function () { return R.get(); }));                                                      // 268
                                                                                                                     // 269
    var div = document.createElement("DIV");                                                                         // 270
    materialize(test1, div);                                                                                         // 271
    test.equal(canonicalizeHtml(div.innerHTML), "<p>Hello</p>");                                                     // 272
                                                                                                                     // 273
    R.set('World');                                                                                                  // 274
    Deps.flush();                                                                                                    // 275
    test.equal(canonicalizeHtml(div.innerHTML), "<p>World</p>");                                                     // 276
                                                                                                                     // 277
    test.equal(R.numListeners(), 1);                                                                                 // 278
                                                                                                                     // 279
    $(div).remove();                                                                                                 // 280
                                                                                                                     // 281
    test.equal(R.numListeners(), 0);                                                                                 // 282
                                                                                                                     // 283
    R.set('Steve');                                                                                                  // 284
    Deps.flush();                                                                                                    // 285
    // should not have changed:                                                                                      // 286
    test.equal(canonicalizeHtml(div.innerHTML), "<p>World</p>");                                                     // 287
  })();                                                                                                              // 288
                                                                                                                     // 289
});                                                                                                                  // 290
                                                                                                                     // 291
Tinytest.add("ui - render - reactive attributes", function (test) {                                                  // 292
  (function () {                                                                                                     // 293
    var R = ReactiveVar({'class': ['david gre', CharRef({html: '&euml;', str: '\u00eb'}), 'nspan'],                  // 294
                         id: 'foo'});                                                                                // 295
                                                                                                                     // 296
    var spanFunc = function () {                                                                                     // 297
      return SPAN(HTML.Attrs(                                                                                        // 298
        function () { return R.get(); }));                                                                           // 299
    };                                                                                                               // 300
                                                                                                                     // 301
    test.equal(Blaze.toHTML(spanFunc()),                                                                             // 302
               '<span class="david gre&euml;nspan" id="foo"></span>');                                               // 303
                                                                                                                     // 304
    test.equal(R.numListeners(), 0);                                                                                 // 305
                                                                                                                     // 306
    var div = document.createElement("DIV");                                                                         // 307
    Blaze.render(spanFunc).attach(div);                                                                              // 308
    test.equal(canonicalizeHtml(div.innerHTML), '<span class="david gre\u00ebnspan" id="foo"></span>');              // 309
                                                                                                                     // 310
    test.equal(R.numListeners(), 1);                                                                                 // 311
                                                                                                                     // 312
    var span = div.firstChild;                                                                                       // 313
    test.equal(span.nodeName, 'SPAN');                                                                               // 314
    span.className += ' blah'; // change the element's class outside of Blaze. this simulates what a jQuery could do // 315
                                                                                                                     // 316
    R.set({'class': 'david smith', id: 'bar'});                                                                      // 317
    Deps.flush();                                                                                                    // 318
    test.equal(canonicalizeHtml(div.innerHTML), '<span class="david blah smith" id="bar"></span>');                  // 319
    test.equal(R.numListeners(), 1);                                                                                 // 320
                                                                                                                     // 321
    R.set({});                                                                                                       // 322
    Deps.flush();                                                                                                    // 323
    test.equal(canonicalizeHtml(div.innerHTML), '<span class="blah"></span>');                                       // 324
    test.equal(R.numListeners(), 1);                                                                                 // 325
                                                                                                                     // 326
    $(div).remove();                                                                                                 // 327
                                                                                                                     // 328
    test.equal(R.numListeners(), 0);                                                                                 // 329
  })();                                                                                                              // 330
                                                                                                                     // 331
  // Test styles.                                                                                                    // 332
  (function () {                                                                                                     // 333
    // Test the case where there is a semicolon in the css attribute.                                                // 334
    var R = ReactiveVar({'style': 'foo: "a;aa"; bar: b;',                                                            // 335
      id: 'foo'});                                                                                                   // 336
                                                                                                                     // 337
    var spanFunc = function () {                                                                                     // 338
      return SPAN(HTML.Attrs(function () { return R.get(); }));                                                      // 339
    };                                                                                                               // 340
                                                                                                                     // 341
    test.equal(Blaze.toHTML(spanFunc()), '<span style="foo: &quot;a;aa&quot;; bar: b;" id="foo"></span>');           // 342
                                                                                                                     // 343
    test.equal(R.numListeners(), 0);                                                                                 // 344
                                                                                                                     // 345
    var div = document.createElement("DIV");                                                                         // 346
    Blaze.render(spanFunc).attach(div);                                                                              // 347
    test.equal(canonicalizeHtml(div.innerHTML), '<span id="foo" style="foo: &quot;a;aa&quot;; bar: b"></span>');     // 348
                                                                                                                     // 349
    test.equal(R.numListeners(), 1);                                                                                 // 350
    var span = div.firstChild;                                                                                       // 351
    test.equal(span.nodeName, 'SPAN');                                                                               // 352
                                                                                                                     // 353
    span.setAttribute('style', span.getAttribute('style') + '; jquery-style: hidden');                               // 354
                                                                                                                     // 355
    R.set({'style': 'foo: "a;zz;aa";', id: 'bar'});                                                                  // 356
    Deps.flush();                                                                                                    // 357
    test.equal(canonicalizeHtml(div.innerHTML, true), '<span id="bar" style="foo: &quot;a;zz;aa&quot;; jquery-style: hidden"></span>');
    test.equal(R.numListeners(), 1);                                                                                 // 359
                                                                                                                     // 360
    R.set({});                                                                                                       // 361
    Deps.flush();                                                                                                    // 362
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="jquery-style: hidden"></span>');                       // 363
    test.equal(R.numListeners(), 1);                                                                                 // 364
                                                                                                                     // 365
    $(div).remove();                                                                                                 // 366
                                                                                                                     // 367
    test.equal(R.numListeners(), 0);                                                                                 // 368
  })();                                                                                                              // 369
                                                                                                                     // 370
  // Test that identical styles are successfully overwritten.                                                        // 371
  (function () {                                                                                                     // 372
                                                                                                                     // 373
    var R = ReactiveVar({'style': 'foo: a;'});                                                                       // 374
                                                                                                                     // 375
    var spanFunc = function () {                                                                                     // 376
      return SPAN(HTML.Attrs(function () { return R.get(); }));                                                      // 377
    };                                                                                                               // 378
                                                                                                                     // 379
    var div = document.createElement("DIV");                                                                         // 380
    document.body.appendChild(div);                                                                                  // 381
    Blaze.render(spanFunc).attach(div);                                                                              // 382
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="foo: a"></span>');                                     // 383
                                                                                                                     // 384
    var span = div.firstChild;                                                                                       // 385
    test.equal(span.nodeName, 'SPAN');                                                                               // 386
    span.setAttribute("style", 'foo: b;');                                                                           // 387
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="foo: b"></span>');                                     // 388
                                                                                                                     // 389
    R.set({'style': 'foo: c;'});                                                                                     // 390
    Deps.flush();                                                                                                    // 391
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="foo: c"></span>');                                     // 392
                                                                                                                     // 393
    // test malformed styles - different expectations in IE (which                                                   // 394
    // strips malformed styles) from other browsers                                                                  // 395
    R.set({'style': 'foo: a; bar::d;:e; baz: c;'});                                                                  // 396
    Deps.flush();                                                                                                    // 397
    test.equal(canonicalizeHtml(div.innerHTML),                                                                      // 398
      malformedStylesAllowed() ?                                                                                     // 399
               '<span style="foo: a; bar::d; baz: c"></span>' :                                                      // 400
               '<span style="foo: a; baz: c"></span>');                                                              // 401
                                                                                                                     // 402
    // Test strange styles                                                                                           // 403
    R.set({'style': ' foo: c; constructor: a; __proto__: b;'});                                                      // 404
    Deps.flush();                                                                                                    // 405
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="foo: c; constructor: a; __proto__: b"></span>');       // 406
                                                                                                                     // 407
    R.set({});                                                                                                       // 408
    Deps.flush();                                                                                                    // 409
    test.equal(canonicalizeHtml(div.innerHTML), '<span></span>');                                                    // 410
                                                                                                                     // 411
    R.set({'style': 'foo: bar;'});                                                                                   // 412
    Deps.flush();                                                                                                    // 413
    test.equal(canonicalizeHtml(div.innerHTML), '<span style="foo: bar"></span>');                                   // 414
  })();                                                                                                              // 415
                                                                                                                     // 416
  // Test `null`, `undefined`, and `[]` attributes                                                                   // 417
  (function () {                                                                                                     // 418
    var R = ReactiveVar({id: 'foo',                                                                                  // 419
                         aaa: null,                                                                                  // 420
                         bbb: undefined,                                                                             // 421
                         ccc: [],                                                                                    // 422
                         ddd: [null],                                                                                // 423
                         eee: [undefined],                                                                           // 424
                         fff: [[]],                                                                                  // 425
                         ggg: ['x', ['y', ['z']]]});                                                                 // 426
                                                                                                                     // 427
    var spanFunc = function () {                                                                                     // 428
      return SPAN(HTML.Attrs(                                                                                        // 429
        function () { return R.get(); }));                                                                           // 430
    };                                                                                                               // 431
                                                                                                                     // 432
    test.equal(Blaze.toHTML(spanFunc()), '<span id="foo" ggg="xyz"></span>');                                        // 433
    test.equal(toCode(SPAN(R.get())),                                                                                // 434
               'HTML.SPAN({id: "foo", ggg: ["x", ["y", ["z"]]]})');                                                  // 435
                                                                                                                     // 436
    var div = document.createElement("DIV");                                                                         // 437
    Blaze.render(spanFunc).attach(div);                                                                              // 438
    var span = div.firstChild;                                                                                       // 439
    test.equal(span.nodeName, 'SPAN');                                                                               // 440
                                                                                                                     // 441
    test.equal(canonicalizeHtml(div.innerHTML), '<span ggg="xyz" id="foo"></span>');                                 // 442
    R.set({id: 'foo', ggg: [[], [], []]});                                                                           // 443
    Deps.flush();                                                                                                    // 444
    test.equal(canonicalizeHtml(div.innerHTML), '<span id="foo"></span>');                                           // 445
                                                                                                                     // 446
    R.set({id: 'foo', ggg: null});                                                                                   // 447
    Deps.flush();                                                                                                    // 448
    test.equal(canonicalizeHtml(div.innerHTML), '<span id="foo"></span>');                                           // 449
                                                                                                                     // 450
    R.set({id: 'foo', ggg: ''});                                                                                     // 451
    Deps.flush();                                                                                                    // 452
    test.equal(canonicalizeHtml(div.innerHTML), '<span ggg="" id="foo"></span>');                                    // 453
                                                                                                                     // 454
    $(div).remove();                                                                                                 // 455
                                                                                                                     // 456
    test.equal(R.numListeners(), 0);                                                                                 // 457
  })();                                                                                                              // 458
});                                                                                                                  // 459
                                                                                                                     // 460
Tinytest.add("ui - render - views", function (test) {                                                                // 461
  (function () {                                                                                                     // 462
    var counter = 1;                                                                                                 // 463
    var buf = [];                                                                                                    // 464
                                                                                                                     // 465
    var makeView = function () {                                                                                     // 466
      var view = Blaze.View('myView', function () {                                                                  // 467
        return [String(this.number),                                                                                 // 468
                (this.number < 3 ? makeView() : HR())];                                                              // 469
      });                                                                                                            // 470
                                                                                                                     // 471
      var number = counter++;                                                                                        // 472
      view.number = number;                                                                                          // 473
                                                                                                                     // 474
      view.onCreated(function () {                                                                                   // 475
        var parent = Blaze.getParentView(view, 'myView');                                                            // 476
        if (parent) {                                                                                                // 477
          buf.push('parent of ' + view.number + ' is ' +                                                             // 478
                   parent.number);                                                                                   // 479
        }                                                                                                            // 480
                                                                                                                     // 481
        buf.push('created ' + Blaze.getCurrentData());                                                               // 482
      });                                                                                                            // 483
                                                                                                                     // 484
      view.onRendered(function () {                                                                                  // 485
        var nodeDescr = function (node) {                                                                            // 486
          if (node.nodeType === 8) // comment                                                                        // 487
            return '';                                                                                               // 488
          if (node.nodeType === 3) // text                                                                           // 489
            return node.nodeValue;                                                                                   // 490
                                                                                                                     // 491
          return node.nodeName;                                                                                      // 492
        };                                                                                                           // 493
                                                                                                                     // 494
        var start = this.domrange.firstNode();                                                                       // 495
        var end = this.domrange.lastNode();                                                                          // 496
        // skip marker nodes                                                                                         // 497
        while (start !== end && ! nodeDescr(start))                                                                  // 498
          start = start.nextSibling;                                                                                 // 499
        while (end !== start && ! nodeDescr(end))                                                                    // 500
          end = end.previousSibling;                                                                                 // 501
                                                                                                                     // 502
        buf.push('dom-' + Blaze.getCurrentData() +                                                                   // 503
                 ' is ' + nodeDescr(start) +'..' +                                                                   // 504
                 nodeDescr(end));                                                                                    // 505
      });                                                                                                            // 506
                                                                                                                     // 507
      view.onDestroyed(function () {                                                                                 // 508
        buf.push('destroyed ' + Blaze.getCurrentData());                                                             // 509
      });                                                                                                            // 510
                                                                                                                     // 511
      return Blaze.With(number, function () { return view; });                                                       // 512
    };                                                                                                               // 513
                                                                                                                     // 514
    var div = document.createElement("DIV");                                                                         // 515
                                                                                                                     // 516
    Blaze.render(makeView).attach(div);                                                                              // 517
    buf.push('---flush---');                                                                                         // 518
    Deps.flush();                                                                                                    // 519
    test.equal(buf, ['created 1',                                                                                    // 520
                     'parent of 2 is 1',                                                                             // 521
                     'created 2',                                                                                    // 522
                     'parent of 3 is 2',                                                                             // 523
                     'created 3',                                                                                    // 524
                     '---flush---',                                                                                  // 525
                     // (proper order for these has not be thought out:)                                             // 526
                     'dom-3 is 3..HR',                                                                               // 527
                     'dom-2 is 2..HR',                                                                               // 528
                     'dom-1 is 1..HR']);                                                                             // 529
                                                                                                                     // 530
    test.equal(canonicalizeHtml(div.innerHTML), '123<hr>');                                                          // 531
                                                                                                                     // 532
    buf.length = 0;                                                                                                  // 533
    $(div).remove();                                                                                                 // 534
    buf.sort();                                                                                                      // 535
    test.equal(buf, ['destroyed 1', 'destroyed 2', 'destroyed 3']);                                                  // 536
                                                                                                                     // 537
    // Now use toHTML.  Should still get most of the callbacks (not `rendered`).                                     // 538
                                                                                                                     // 539
    buf.length = 0;                                                                                                  // 540
    counter = 1;                                                                                                     // 541
                                                                                                                     // 542
    var html = Blaze.toHTML(makeView());                                                                             // 543
                                                                                                                     // 544
    test.equal(buf, ['created 1',                                                                                    // 545
                     'parent of 2 is 1',                                                                             // 546
                     'created 2',                                                                                    // 547
                     'parent of 3 is 2',                                                                             // 548
                     'created 3',                                                                                    // 549
                     'destroyed 3',                                                                                  // 550
                     'destroyed 2',                                                                                  // 551
                     'destroyed 1']);                                                                                // 552
                                                                                                                     // 553
    test.equal(html, '123<hr>');                                                                                     // 554
  })();                                                                                                              // 555
});                                                                                                                  // 556
                                                                                                                     // 557
Tinytest.add("ui - render - findAll", function (test) {                                                              // 558
  var found = null;                                                                                                  // 559
  var $found = null;                                                                                                 // 560
                                                                                                                     // 561
  var myTemplate = Template.__create__(                                                                              // 562
    'findAllTest',                                                                                                   // 563
    function() {                                                                                                     // 564
      return DIV([P('first'), P('second')]);                                                                         // 565
    });                                                                                                              // 566
  myTemplate.rendered = function() {                                                                                 // 567
    found = this.findAll('p');                                                                                       // 568
    $found = this.$('p');                                                                                            // 569
  };                                                                                                                 // 570
                                                                                                                     // 571
  var div = document.createElement("DIV");                                                                           // 572
                                                                                                                     // 573
  Blaze.render(myTemplate).attach(div);                                                                              // 574
  Deps.flush();                                                                                                      // 575
                                                                                                                     // 576
  test.equal(_.isArray(found), true);                                                                                // 577
  test.equal(_.isArray($found), false);                                                                              // 578
  test.equal(found.length, 2);                                                                                       // 579
  test.equal($found.length, 2);                                                                                      // 580
});                                                                                                                  // 581
                                                                                                                     // 582
Tinytest.add("ui - render - reactive attributes 2", function (test) {                                                // 583
  var R1 = ReactiveVar(['foo']);                                                                                     // 584
  var R2 = ReactiveVar(['bar']);                                                                                     // 585
                                                                                                                     // 586
  var spanFunc = function () {                                                                                       // 587
    return SPAN(HTML.Attrs(                                                                                          // 588
      { blah: function () { return R1.get(); } },                                                                    // 589
      function () { return { blah: R2.get() }; }));                                                                  // 590
  };                                                                                                                 // 591
                                                                                                                     // 592
  var div = document.createElement("DIV");                                                                           // 593
  Blaze.render(spanFunc).attach(div);                                                                                // 594
  var check = function (expected) {                                                                                  // 595
    test.equal(Blaze.toHTML(spanFunc()), expected);                                                                  // 596
    test.equal(canonicalizeHtml(div.innerHTML), expected);                                                           // 597
  };                                                                                                                 // 598
  check('<span blah="bar"></span>');                                                                                 // 599
                                                                                                                     // 600
  test.equal(R1.numListeners(), 1);                                                                                  // 601
  test.equal(R2.numListeners(), 1);                                                                                  // 602
                                                                                                                     // 603
  R2.set([[]]);                                                                                                      // 604
  Deps.flush();                                                                                                      // 605
  // We combine `['foo']` with what evaluates to `[[[]]]`, which is nully.                                           // 606
  check('<span blah="foo"></span>');                                                                                 // 607
                                                                                                                     // 608
  R2.set([['']]);                                                                                                    // 609
  Deps.flush();                                                                                                      // 610
  // We combine `['foo']` with what evaluates to `[[['']]]`, which is non-nully.                                     // 611
  check('<span blah=""></span>');                                                                                    // 612
                                                                                                                     // 613
  R2.set(null);                                                                                                      // 614
  Deps.flush();                                                                                                      // 615
  // We combine `['foo']` with `[null]`, which is nully.                                                             // 616
  check('<span blah="foo"></span>');                                                                                 // 617
                                                                                                                     // 618
  R1.set([[], []]);                                                                                                  // 619
  Deps.flush();                                                                                                      // 620
  // We combine two nully values.                                                                                    // 621
  check('<span></span>');                                                                                            // 622
                                                                                                                     // 623
  R1.set([[], ['foo']]);                                                                                             // 624
  Deps.flush();                                                                                                      // 625
  check('<span blah="foo"></span>');                                                                                 // 626
                                                                                                                     // 627
  // clean up                                                                                                        // 628
                                                                                                                     // 629
  $(div).remove();                                                                                                   // 630
                                                                                                                     // 631
  test.equal(R1.numListeners(), 0);                                                                                  // 632
  test.equal(R2.numListeners(), 0);                                                                                  // 633
});                                                                                                                  // 634
                                                                                                                     // 635
Tinytest.add("ui - render - SVG", function (test) {                                                                  // 636
  if (! document.createElementNS) {                                                                                  // 637
    // IE 8                                                                                                          // 638
    return;                                                                                                          // 639
  }                                                                                                                  // 640
                                                                                                                     // 641
  var fillColor = ReactiveVar('red');                                                                                // 642
  var classes = ReactiveVar('one two');                                                                              // 643
                                                                                                                     // 644
  var content = DIV({'class': 'container'}, HTML.SVG(                                                                // 645
    {width: 100, height: 100},                                                                                       // 646
    HTML.CIRCLE({cx: 50, cy: 50, r: 40,                                                                              // 647
                 stroke: 'black', 'stroke-width': 3,                                                                 // 648
                 'class': function () { return classes.get(); },                                                     // 649
                 fill: function () { return fillColor.get(); }})));                                                  // 650
                                                                                                                     // 651
  var div = document.createElement("DIV");                                                                           // 652
  materialize(content, div);                                                                                         // 653
                                                                                                                     // 654
  var circle = div.querySelector('.container > svg > circle');                                                       // 655
  test.equal(circle.getAttribute('fill'), 'red');                                                                    // 656
  test.equal(circle.className.baseVal, 'one two');                                                                   // 657
                                                                                                                     // 658
  fillColor.set('green');                                                                                            // 659
  classes.set('two three');                                                                                          // 660
  Deps.flush();                                                                                                      // 661
  test.equal(circle.getAttribute('fill'), 'green');                                                                  // 662
  test.equal(circle.className.baseVal, 'two three');                                                                 // 663
                                                                                                                     // 664
  test.equal(circle.nodeName, 'circle');                                                                             // 665
  test.equal(circle.namespaceURI, "http://www.w3.org/2000/svg");                                                     // 666
  test.equal(circle.parentNode.namespaceURI, "http://www.w3.org/2000/svg");                                          // 667
});                                                                                                                  // 668
                                                                                                                     // 669
Tinytest.add("ui - attributes", function (test) {                                                                    // 670
  var SPAN = HTML.SPAN;                                                                                              // 671
  var amp = HTML.CharRef({html: '&amp;', str: '&'});                                                                 // 672
                                                                                                                     // 673
  test.equal(HTML.toHTML(SPAN({title: ['M', amp, 'Ms']}, 'M', amp, 'M candies')),                                    // 674
             '<span title="M&amp;Ms">M&amp;M candies</span>');                                                       // 675
});                                                                                                                  // 676
                                                                                                                     // 677
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
