(function () {

//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //
// packages/twitter/template.twitter_configure.js                                       //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
                                                                                        //
                                                                                        // 1
Template.__define__("configureLoginServiceDialogForTwitter", (function() {              // 2
  var view = this;                                                                      // 3
  return [ HTML.Raw("<p>\n    First, you'll need to register your app on Twitter. Follow these steps:\n  </p>\n  "), HTML.OL("\n    ", HTML.Raw('<li>\n      Visit <a href="https://dev.twitter.com/apps/new" target="_blank">https://dev.twitter.com/apps/new</a>\n    </li>'), "\n    ", HTML.LI("\n      Set Callback URL to: ", HTML.SPAN({
    "class": "url"                                                                      // 5
  }, Blaze.View(function() {                                                            // 6
    return Spacebars.mustache(view.lookup("siteUrl"));                                  // 7
  }), "_oauth/twitter?close"), "\n    "), "\n    ", HTML.Raw('<li>\n      Select "Create your Twitter application".\n    </li>'), "\n    ", HTML.Raw('<li>\n      On the Settings tab, enable "Allow this application to be used to Sign in with Twitter" and click\n      "Update settings".\n    </li>'), "\n    ", HTML.Raw("<li>\n      Switch to the API Keys tab.\n    </li>"), "\n  ") ];
}));                                                                                    // 9
                                                                                        // 10
//////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //
// packages/twitter/twitter_configure.js                                                //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
                                                                                        //
Template.configureLoginServiceDialogForTwitter.siteUrl = function () {                  // 1
  // Twitter doesn't recognize localhost as a domain name                               // 2
  return Meteor.absoluteUrl({replaceLocalhost: true});                                  // 3
};                                                                                      // 4
                                                                                        // 5
Template.configureLoginServiceDialogForTwitter.fields = function () {                   // 6
  return [                                                                              // 7
    {property: 'consumerKey', label: 'API key'},                                        // 8
    {property: 'secret', label: 'API secret'}                                           // 9
  ];                                                                                    // 10
};                                                                                      // 11
                                                                                        // 12
//////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //
// packages/twitter/twitter_client.js                                                   //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
                                                                                        //
Twitter = {};                                                                           // 1
                                                                                        // 2
// Request Twitter credentials for the user                                             // 3
// @param options {optional}  XXX support options.requestPermissions                    // 4
// @param credentialRequestCompleteCallback {Function} Callback function to call on     // 5
//   completion. Takes one argument, credentialToken on success, or Error on            // 6
//   error.                                                                             // 7
Twitter.requestCredential = function (options, credentialRequestCompleteCallback) {     // 8
  // support both (options, callback) and (callback).                                   // 9
  if (!credentialRequestCompleteCallback && typeof options === 'function') {            // 10
    credentialRequestCompleteCallback = options;                                        // 11
    options = {};                                                                       // 12
  }                                                                                     // 13
                                                                                        // 14
  var config = ServiceConfiguration.configurations.findOne({service: 'twitter'});       // 15
  if (!config) {                                                                        // 16
    credentialRequestCompleteCallback && credentialRequestCompleteCallback(             // 17
      new ServiceConfiguration.ConfigError());                                          // 18
    return;                                                                             // 19
  }                                                                                     // 20
                                                                                        // 21
  var credentialToken = Random.secret();                                                // 22
  // We need to keep credentialToken across the next two 'steps' so we're adding        // 23
  // a credentialToken parameter to the url and the callback url that we'll be returned // 24
  // to by oauth provider                                                               // 25
                                                                                        // 26
  // url to app, enters "step 1" as described in                                        // 27
  // packages/accounts-oauth1-helper/oauth1_server.js                                   // 28
  var loginUrl = '/_oauth/twitter/?requestTokenAndRedirect=true'                        // 29
        + '&state=' + credentialToken;                                                  // 30
                                                                                        // 31
  OAuth.showPopup(                                                                      // 32
    loginUrl,                                                                           // 33
    _.bind(credentialRequestCompleteCallback, null, credentialToken)                    // 34
  );                                                                                    // 35
};                                                                                      // 36
                                                                                        // 37
//////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
