(function () {

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// packages/spiderable/spiderable_tests.js                                    //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
                                                                              //
var url = Npm.require("url");                                                 // 1
                                                                              // 2
Tinytest.add("spiderable - phantom url generation", function (test, expect) { // 3
  var absUrl = "http://example.com";                                          // 4
  _.each([                                                                    // 5
    {                                                                         // 6
      requestUrl: "/?_escaped_fragment_=1",                                   // 7
      expected: "/"                                                           // 8
    },                                                                        // 9
    // Test that query strings are preserved                                  // 10
    {                                                                         // 11
      requestUrl: "/?_escaped_fragment_=1&foo=bar",                           // 12
      expected: "/?foo=bar"                                                   // 13
    },                                                                        // 14
    {                                                                         // 15
      requestUrl: "/?foo=bar&_escaped_fragment_=1",                           // 16
      expected: "/?foo=bar"                                                   // 17
    },                                                                        // 18
    // Test that paths are preserved                                          // 19
    {                                                                         // 20
      requestUrl: "/foo/bar?_escaped_fragment_=1",                            // 21
      expected: "/foo/bar"                                                    // 22
    },                                                                        // 23
    {                                                                         // 24
      requestUrl: "/foo/bar?_escaped_fragment_=1&foo=bar",                    // 25
      expected: "/foo/bar?foo=bar"                                            // 26
    },                                                                        // 27
    // Test with a path on the site's absolute url                            // 28
    {                                                                         // 29
      requestUrl: "/foo/bar?_escaped_fragment_=1",                            // 30
      expected: "/foo/bar",                                                   // 31
      absUrl: "http://example.com/foo"                                        // 32
    },                                                                        // 33
    {                                                                         // 34
      requestUrl: "/bar?_escaped_fragment_=1",                                // 35
      expected: "/bar",                                                       // 36
      absUrl: "http://example.com/foo"                                        // 37
    }                                                                         // 38
  ], function (testCase) {                                                    // 39
    testCase.absUrl = testCase.absUrl || absUrl;                              // 40
                                                                              // 41
    test.equal(                                                               // 42
      Spiderable._urlForPhantom(absUrl, testCase.requestUrl),                 // 43
      absUrl + testCase.expected                                              // 44
    );                                                                        // 45
  });                                                                         // 46
});                                                                           // 47
                                                                              // 48
////////////////////////////////////////////////////////////////////////////////

}).call(this);
