(function () {

///////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           //
// packages/spacebars/template.dynamic_tests.js                                              //
//                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////
                                                                                             //
                                                                                             // 1
Template.__define__("ui_dynamic_test", (function() {                                         // 2
  var view = this;                                                                           // 3
  return Spacebars.TemplateWith(function() {                                                 // 4
    return {                                                                                 // 5
      template: Spacebars.call(view.lookup("templateName")),                                 // 6
      data: Spacebars.call(view.lookup("templateData"))                                      // 7
    };                                                                                       // 8
  }, function() {                                                                            // 9
    return Spacebars.include(function() {                                                    // 10
      return Spacebars.call(Template.__dynamic);                                             // 11
    });                                                                                      // 12
  });                                                                                        // 13
}));                                                                                         // 14
                                                                                             // 15
Template.__define__("ui_dynamic_test_no_data", (function() {                                 // 16
  var view = this;                                                                           // 17
  return Spacebars.TemplateWith(function() {                                                 // 18
    return {                                                                                 // 19
      template: Spacebars.call(view.lookup("templateName"))                                  // 20
    };                                                                                       // 21
  }, function() {                                                                            // 22
    return Spacebars.include(function() {                                                    // 23
      return Spacebars.call(Template.__dynamic);                                             // 24
    });                                                                                      // 25
  });                                                                                        // 26
}));                                                                                         // 27
                                                                                             // 28
Template.__define__("ui_dynamic_test_inherited_data", (function() {                          // 29
  var view = this;                                                                           // 30
  return Spacebars.With(function() {                                                         // 31
    return Spacebars.call(view.lookup("context"));                                           // 32
  }, function() {                                                                            // 33
    return [ "\n    ", Spacebars.TemplateWith(function() {                                   // 34
      return {                                                                               // 35
        template: Spacebars.call(view.lookup("templateName"))                                // 36
      };                                                                                     // 37
    }, function() {                                                                          // 38
      return Spacebars.include(function() {                                                  // 39
        return Spacebars.call(Template.__dynamic);                                           // 40
      });                                                                                    // 41
    }), "\n  " ];                                                                            // 42
  }, function() {                                                                            // 43
    return [ "\n    ", Spacebars.TemplateWith(function() {                                   // 44
      return {                                                                               // 45
        template: Spacebars.call(view.lookup("templateName"))                                // 46
      };                                                                                     // 47
    }, function() {                                                                          // 48
      return Spacebars.include(function() {                                                  // 49
        return Spacebars.call(Template.__dynamic);                                           // 50
      });                                                                                    // 51
    }), "\n  " ];                                                                            // 52
  });                                                                                        // 53
}));                                                                                         // 54
                                                                                             // 55
Template.__define__("ui_dynamic_test_sub", (function() {                                     // 56
  var view = this;                                                                           // 57
  return [ "test", Blaze.View(function() {                                                   // 58
    return Spacebars.mustache(view.lookup("foo"));                                           // 59
  }) ];                                                                                      // 60
}));                                                                                         // 61
                                                                                             // 62
Template.__define__("ui_dynamic_test_falsey_inner_context", (function() {                    // 63
  var view = this;                                                                           // 64
  return Spacebars.With(function() {                                                         // 65
    return {                                                                                 // 66
      foo: Spacebars.call("bar")                                                             // 67
    };                                                                                       // 68
  }, function() {                                                                            // 69
    return [ "\n    ", Spacebars.TemplateWith(function() {                                   // 70
      return {                                                                               // 71
        template: Spacebars.call(view.lookup("templateName")),                               // 72
        data: Spacebars.call(view.lookup("context"))                                         // 73
      };                                                                                     // 74
    }, function() {                                                                          // 75
      return Spacebars.include(function() {                                                  // 76
        return Spacebars.call(Template.__dynamic);                                           // 77
      });                                                                                    // 78
    }), "\n  " ];                                                                            // 79
  });                                                                                        // 80
}));                                                                                         // 81
                                                                                             // 82
Template.__define__("ui_dynamic_test_bad_args0", (function() {                               // 83
  var view = this;                                                                           // 84
  return Spacebars.include(function() {                                                      // 85
    return Spacebars.call(Template.__dynamic);                                               // 86
  });                                                                                        // 87
}));                                                                                         // 88
                                                                                             // 89
Template.__define__("ui_dynamic_test_bad_args1", (function() {                               // 90
  var view = this;                                                                           // 91
  return Spacebars.TemplateWith(function() {                                                 // 92
    return {                                                                                 // 93
      foo: Spacebars.call("bar")                                                             // 94
    };                                                                                       // 95
  }, function() {                                                                            // 96
    return Spacebars.include(function() {                                                    // 97
      return Spacebars.call(Template.__dynamic);                                             // 98
    });                                                                                      // 99
  });                                                                                        // 100
}));                                                                                         // 101
                                                                                             // 102
Template.__define__("ui_dynamic_test_bad_args2", (function() {                               // 103
  var view = this;                                                                           // 104
  return Spacebars.TemplateWith(function() {                                                 // 105
    return {                                                                                 // 106
      template: Spacebars.call("ui_dynamic_test_sub"),                                       // 107
      foo: Spacebars.call("bar")                                                             // 108
    };                                                                                       // 109
  }, function() {                                                                            // 110
    return Spacebars.include(function() {                                                    // 111
      return Spacebars.call(Template.__dynamic);                                             // 112
    });                                                                                      // 113
  });                                                                                        // 114
}));                                                                                         // 115
                                                                                             // 116
Template.__define__("ui_dynamic_test_falsey_context", (function() {                          // 117
  var view = this;                                                                           // 118
  return Spacebars.TemplateWith(function() {                                                 // 119
    return {                                                                                 // 120
      template: Spacebars.call("ui_dynamic_test_falsey_context_sub")                         // 121
    };                                                                                       // 122
  }, function() {                                                                            // 123
    return Spacebars.include(function() {                                                    // 124
      return Spacebars.call(Template.__dynamic);                                             // 125
    });                                                                                      // 126
  });                                                                                        // 127
}));                                                                                         // 128
                                                                                             // 129
Template.__define__("ui_dynamic_test_falsey_context_sub", (function() {                      // 130
  var view = this;                                                                           // 131
  return Blaze.View(function() {                                                             // 132
    return Spacebars.mustache(view.lookup("foo"));                                           // 133
  });                                                                                        // 134
}));                                                                                         // 135
                                                                                             // 136
///////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           //
// packages/spacebars/dynamic_tests.js                                                       //
//                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////
                                                                                             //
Tinytest.add(                                                                                // 1
  "spacebars - ui-dynamic-template - render template dynamically", function (test, expect) { // 2
    var tmpl = Template.ui_dynamic_test;                                                     // 3
                                                                                             // 4
    var nameVar = new ReactiveVar;                                                           // 5
    var dataVar = new ReactiveVar;                                                           // 6
    tmpl.templateName = function () {                                                        // 7
      return nameVar.get();                                                                  // 8
    };                                                                                       // 9
    tmpl.templateData = function () {                                                        // 10
      return dataVar.get();                                                                  // 11
    };                                                                                       // 12
                                                                                             // 13
    // No template chosen                                                                    // 14
    var div = renderToDiv(tmpl);                                                             // 15
    test.equal(canonicalizeHtml(div.innerHTML), "");                                         // 16
                                                                                             // 17
    // Choose the "ui-dynamic-test-sub" template, with no data context                       // 18
    // passed in.                                                                            // 19
    nameVar.set("ui_dynamic_test_sub");                                                      // 20
    Deps.flush();                                                                            // 21
    test.equal(canonicalizeHtml(div.innerHTML), "test");                                     // 22
                                                                                             // 23
    // Set a data context.                                                                   // 24
    dataVar.set({ foo: "bar" });                                                             // 25
    Deps.flush();                                                                            // 26
    test.equal(canonicalizeHtml(div.innerHTML), "testbar");                                  // 27
  });                                                                                        // 28
                                                                                             // 29
// Same test as above, but the {{> UI.dynamic}} inclusion has no                             // 30
// `dataContext` argument.                                                                   // 31
Tinytest.add(                                                                                // 32
  "spacebars - ui-dynamic-template - render template dynamically, no data context",          // 33
  function (test, expect) {                                                                  // 34
    var tmpl = Template.ui_dynamic_test_no_data;                                             // 35
                                                                                             // 36
    var nameVar = new ReactiveVar;                                                           // 37
    tmpl.templateName = function () {                                                        // 38
      return nameVar.get();                                                                  // 39
    };                                                                                       // 40
                                                                                             // 41
    var div = renderToDiv(tmpl);                                                             // 42
    test.equal(canonicalizeHtml(div.innerHTML), "");                                         // 43
                                                                                             // 44
    nameVar.set("ui_dynamic_test_sub");                                                      // 45
    Deps.flush();                                                                            // 46
    test.equal(canonicalizeHtml(div.innerHTML), "test");                                     // 47
  });                                                                                        // 48
                                                                                             // 49
                                                                                             // 50
Tinytest.add(                                                                                // 51
  "spacebars - ui-dynamic-template - render template " +                                     // 52
    "dynamically, data context gets inherited",                                              // 53
  function (test, expect) {                                                                  // 54
    var tmpl = Template.ui_dynamic_test_inherited_data;                                      // 55
                                                                                             // 56
    var nameVar = new ReactiveVar();                                                         // 57
    var dataVar = new ReactiveVar();                                                         // 58
    tmpl.templateName = function () {                                                        // 59
      return nameVar.get();                                                                  // 60
    };                                                                                       // 61
    tmpl.context = function () {                                                             // 62
      return dataVar.get();                                                                  // 63
    };                                                                                       // 64
                                                                                             // 65
    var div = renderToDiv(tmpl);                                                             // 66
    test.equal(canonicalizeHtml(div.innerHTML), "");                                         // 67
                                                                                             // 68
    nameVar.set("ui_dynamic_test_sub");                                                      // 69
    Deps.flush();                                                                            // 70
    test.equal(canonicalizeHtml(div.innerHTML), "test");                                     // 71
                                                                                             // 72
    // Set the top-level template's data context; this should be                             // 73
    // inherited by the dynamically-chosen template, since the {{>                           // 74
    // UI.dynamic}} inclusion didn't include a data argument.                                // 75
    dataVar.set({ foo: "bar" });                                                             // 76
    Deps.flush();                                                                            // 77
    test.equal(canonicalizeHtml(div.innerHTML), "testbar");                                  // 78
  }                                                                                          // 79
);                                                                                           // 80
                                                                                             // 81
Tinytest.add(                                                                                // 82
  "spacebars - ui-dynamic-template - render template " +                                     // 83
    "dynamically, data context does not get inherited if " +                                 // 84
    "falsey context is passed in",                                                           // 85
  function (test, expect) {                                                                  // 86
    var tmpl = Template.ui_dynamic_test_falsey_inner_context;                                // 87
                                                                                             // 88
    var nameVar = new ReactiveVar();                                                         // 89
    var dataVar = new ReactiveVar();                                                         // 90
    tmpl.templateName = function () {                                                        // 91
      return nameVar.get();                                                                  // 92
    };                                                                                       // 93
    tmpl.context = function () {                                                             // 94
      return dataVar.get();                                                                  // 95
    };                                                                                       // 96
                                                                                             // 97
    var div = renderToDiv(tmpl);                                                             // 98
    test.equal(canonicalizeHtml(div.innerHTML), "");                                         // 99
                                                                                             // 100
    nameVar.set("ui_dynamic_test_sub");                                                      // 101
    Deps.flush();                                                                            // 102
    // Even though the data context is falsey, we DON'T expect the                           // 103
    // subtemplate to inherit the data context from the parent template.                     // 104
    test.equal(canonicalizeHtml(div.innerHTML), "test");                                     // 105
  }                                                                                          // 106
);                                                                                           // 107
                                                                                             // 108
Tinytest.add(                                                                                // 109
  "spacebars - ui-dynamic-template - render template " +                                     // 110
    "dynamically, bad arguments",                                                            // 111
  function (test, expect) {                                                                  // 112
    var tmplPrefix = "ui_dynamic_test_bad_args";                                             // 113
    var errors = [                                                                           // 114
      "Must specify 'template' as an argument",                                              // 115
      "Must specify 'template' as an argument",                                              // 116
      "Invalid argument to {{> UI.dynamic}}"                                                 // 117
    ];                                                                                       // 118
                                                                                             // 119
    for (var i = 0; i < 3; i++) {                                                            // 120
      var tmpl = Template[tmplPrefix + i];                                                   // 121
      test.throws(function () {                                                              // 122
        Blaze._throwNextException = true;                                                    // 123
        var div = renderToDiv(tmpl);                                                         // 124
      });                                                                                    // 125
    }                                                                                        // 126
  }                                                                                          // 127
);                                                                                           // 128
                                                                                             // 129
Tinytest.add(                                                                                // 130
  "spacebars - ui-dynamic-template - render template " +                                     // 131
    "dynamically, falsey context",                                                           // 132
  function (test, expect) {                                                                  // 133
    var tmpl = Template.ui_dynamic_test_falsey_context;                                      // 134
    var subtmpl = Template.ui_dynamic_test_falsey_context_sub;                               // 135
                                                                                             // 136
    var subtmplContext;                                                                      // 137
    subtmpl.foo = function () {                                                              // 138
      subtmplContext = this;                                                                 // 139
    };                                                                                       // 140
    var div = renderToDiv(tmpl);                                                             // 141
                                                                                             // 142
    // Because `this` can only be an object, Blaze normalizes falsey                         // 143
    // data contexts to {}.                                                                  // 144
    test.equal(subtmplContext, {});                                                          // 145
  }                                                                                          // 146
);                                                                                           // 147
                                                                                             // 148
///////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
