(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                           //
// packages/spacebars-compiler/spacebars_tests.js                                                            //
//                                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                             //
Tinytest.add("spacebars-compiler - stache tags", function (test) {                                           // 1
                                                                                                             // 2
  var run = function (input, expected) {                                                                     // 3
    if (typeof expected === "string") {                                                                      // 4
      // test for error starting with string `expected`                                                      // 5
      var msg = '';                                                                                          // 6
      test.throws(function () {                                                                              // 7
        try {                                                                                                // 8
          SpacebarsCompiler.TemplateTag.parse(input);                                                        // 9
        } catch (e) {                                                                                        // 10
          msg = e.message;                                                                                   // 11
          throw e;                                                                                           // 12
        }                                                                                                    // 13
      });                                                                                                    // 14
      test.equal(msg.slice(0, expected.length), expected);                                                   // 15
    } else {                                                                                                 // 16
      var result = SpacebarsCompiler.TemplateTag.parse(input);                                               // 17
      test.equal(result, expected);                                                                          // 18
    }                                                                                                        // 19
  };                                                                                                         // 20
                                                                                                             // 21
  run('{{foo}}', {type: 'DOUBLE', path: ['foo'], args: []});                                                 // 22
  run('{{foo3}}', {type: 'DOUBLE', path: ['foo3'], args: []});                                               // 23
  run('{{{foo}}}', {type: 'TRIPLE', path: ['foo'], args: []});                                               // 24
  run('{{{foo}}', "Expected `}}}`");                                                                         // 25
  run('{{{foo', "Expected");                                                                                 // 26
  run('{{foo', "Expected");                                                                                  // 27
  run('{{ {foo}}}', "Unknown stache tag");                                                                   // 28
  run('{{{{foo}}}}', "Unknown stache tag");                                                                  // 29
  run('{{{>foo}}}', "Unknown stache tag");                                                                   // 30
  run('{{>>foo}}', "Unknown stache tag");                                                                    // 31
  run('{{! asdf }}', {type: 'COMMENT', value: ' asdf '});                                                    // 32
  run('{{ ! asdf }}', {type: 'COMMENT', value: ' asdf '});                                                   // 33
  run('{{ ! asdf }asdf', "Unclosed");                                                                        // 34
  run('{{!-- asdf --}}', {type: 'BLOCKCOMMENT', value: ' asdf '});                                           // 35
  run('{{ !-- asdf -- }}', {type: 'BLOCKCOMMENT', value: ' asdf '});                                         // 36
  run('{{ !-- {{asdf}} -- }}', {type: 'BLOCKCOMMENT', value: ' {{asdf}} '});                                 // 37
  run('{{ !-- {{as--df}} --}}', {type: 'BLOCKCOMMENT', value: ' {{as--df}} '});                              // 38
  run('{{ !-- asdf }asdf', "Unclosed");                                                                      // 39
  run('{{ !-- asdf --}asdf', "Unclosed");                                                                    // 40
  run('{{else}}', {type: 'ELSE'});                                                                           // 41
  run('{{ else }}', {type: 'ELSE'});                                                                         // 42
  run('{{else x}}', "Expected");                                                                             // 43
  run('{{else_x}}', {type: 'DOUBLE', path: ['else_x'], args: []});                                           // 44
  run('{{/if}}', {type: 'BLOCKCLOSE', path: ['if']});                                                        // 45
  run('{{ / if }}', {type: 'BLOCKCLOSE', path: ['if']});                                                     // 46
  run('{{/if x}}', "Expected");                                                                              // 47
  run('{{#if}}', {type: 'BLOCKOPEN', path: ['if'], args: []});                                               // 48
  run('{{ # if }}', {type: 'BLOCKOPEN', path: ['if'], args: []});                                            // 49
  run('{{#if_3}}', {type: 'BLOCKOPEN', path: ['if_3'], args: []});                                           // 50
  run('{{>x}}', {type: 'INCLUSION', path: ['x'], args: []});                                                 // 51
  run('{{ > x }}', {type: 'INCLUSION', path: ['x'], args: []});                                              // 52
  run('{{>x_3}}', {type: 'INCLUSION', path: ['x_3'], args: []});                                             // 53
                                                                                                             // 54
                                                                                                             // 55
                                                                                                             // 56
  run('{{foo 3}}', {type: 'DOUBLE', path: ['foo'], args: [['NUMBER', 3]]});                                  // 57
  run('{{ foo  3 }}', {type: 'DOUBLE', path: ['foo'], args: [['NUMBER', 3]]});                               // 58
  run('{{#foo 3}}', {type: 'BLOCKOPEN', path: ['foo'], args: [['NUMBER', 3]]});                              // 59
  run('{{ # foo  3 }}', {type: 'BLOCKOPEN', path: ['foo'],                                                   // 60
                         args: [['NUMBER', 3]]});                                                            // 61
  run('{{>foo 3}}', {type: 'INCLUSION', path: ['foo'], args: [['NUMBER', 3]]});                              // 62
  run('{{ > foo  3 }}', {type: 'INCLUSION', path: ['foo'],                                                   // 63
                         args: [['NUMBER', 3]]});                                                            // 64
  run('{{{foo 3}}}', {type: 'TRIPLE', path: ['foo'], args: [['NUMBER', 3]]});                                // 65
                                                                                                             // 66
  run('{{foo bar ./foo foo/bar a.b.c baz=qux x3=.}}',                                                        // 67
      {type: 'DOUBLE', path: ['foo'],                                                                        // 68
       args: [['PATH', ['bar']],                                                                             // 69
              ['PATH', ['.', 'foo']],                                                                        // 70
              ['PATH', ['foo', 'bar']],                                                                      // 71
              ['PATH', ['a', 'b', 'c']],                                                                     // 72
              ['PATH', ['qux'], 'baz'],                                                                      // 73
              ['PATH', ['.'], 'x3']]});                                                                      // 74
                                                                                                             // 75
  run('{{{x 0.3 [0].[3] .4 ./[4]}}}',                                                                        // 76
      {type: 'TRIPLE', path: ['x'],                                                                          // 77
       args: [['NUMBER', 0.3],                                                                               // 78
              ['PATH', ['0', '3']],                                                                          // 79
              ['NUMBER', .4],                                                                                // 80
              ['PATH', ['.', '4']]]});                                                                       // 81
                                                                                                             // 82
  run('{{# foo this this.x null z=null}}',                                                                   // 83
      {type: 'BLOCKOPEN', path: ['foo'],                                                                     // 84
       args: [['PATH', ['.']],                                                                               // 85
              ['PATH', ['.', 'x']],                                                                          // 86
              ['NULL', null],                                                                                // 87
              ['NULL', null, 'z']]});                                                                        // 88
                                                                                                             // 89
  run('{{./foo 3}}', {type: 'DOUBLE', path: ['.', 'foo'], args: [['NUMBER', 3]]});                           // 90
  run('{{this/foo 3}}', {type: 'DOUBLE', path: ['.', 'foo'], args: [['NUMBER', 3]]});                        // 91
  run('{{../foo 3}}', {type: 'DOUBLE', path: ['..', 'foo'], args: [['NUMBER', 3]]});                         // 92
  run('{{../../foo 3}}', {type: 'DOUBLE', path: ['...', 'foo'], args: [['NUMBER', 3]]});                     // 93
                                                                                                             // 94
  run('{{foo x/..}}', "Expected");                                                                           // 95
  run('{{foo x/.}}', "Expected");                                                                            // 96
                                                                                                             // 97
  run('{{#a.b.c}}', {type: 'BLOCKOPEN', path: ['a', 'b', 'c'],                                               // 98
                     args: []});                                                                             // 99
  run('{{> a.b.c}}', {type: 'INCLUSION', path: ['a', 'b', 'c'],                                              // 100
                      args: []});                                                                            // 101
                                                                                                             // 102
  run('{{foo.[]/[]}}', {type: 'DOUBLE', path: ['foo', '', ''],                                               // 103
                        args: []});                                                                          // 104
  run('{{x foo.[=]}}', {type: 'DOUBLE', path: ['x'],                                                         // 105
                        args: [['PATH', ['foo', '=']]]});                                                    // 106
  run('{{[].foo}}', "Path can't start with empty string");                                                   // 107
                                                                                                             // 108
  run('{{foo null}}', {type: 'DOUBLE', path: ['foo'],                                                        // 109
                       args: [['NULL', null]]});                                                             // 110
  run('{{foo false}}', {type: 'DOUBLE', path: ['foo'],                                                       // 111
                       args: [['BOOLEAN', false]]});                                                         // 112
  run('{{foo true}}', {type: 'DOUBLE', path: ['foo'],                                                        // 113
                       args: [['BOOLEAN', true]]});                                                          // 114
  run('{{foo "bar"}}', {type: 'DOUBLE', path: ['foo'],                                                       // 115
                        args: [['STRING', 'bar']]});                                                         // 116
  run("{{foo 'bar'}}", {type: 'DOUBLE', path: ['foo'],                                                       // 117
                        args: [['STRING', 'bar']]});                                                         // 118
                                                                                                             // 119
  run('{{foo -1 -2}}', {type: 'DOUBLE', path: ['foo'],                                                       // 120
                        args: [['NUMBER', -1], ['NUMBER', -2]]});                                            // 121
                                                                                                             // 122
  run('{{x "\'"}}', {type: 'DOUBLE', path: ['x'], args: [['STRING', "'"]]});                                 // 123
  run('{{x \'"\'}}', {type: 'DOUBLE', path: ['x'], args: [['STRING', '"']]});                                // 124
                                                                                                             // 125
  run('{{> foo x=1 y=2}}',                                                                                   // 126
      {type: 'INCLUSION', path: ['foo'],                                                                     // 127
       args: [['NUMBER', 1, 'x'],                                                                            // 128
              ['NUMBER', 2, 'y']]});                                                                         // 129
  // spaces around '=' are fine                                                                              // 130
  run('{{> foo x = 1 y = 2}}',                                                                               // 131
      {type: 'INCLUSION', path: ['foo'],                                                                     // 132
       args: [['NUMBER', 1, 'x'],                                                                            // 133
              ['NUMBER', 2, 'y']]});                                                                         // 134
  run('{{> foo with-dashes=1 another-one=2}}',                                                               // 135
      {type: 'INCLUSION', path: ['foo'],                                                                     // 136
       args: [['NUMBER', 1, 'with-dashes'],                                                                  // 137
              ['NUMBER', 2, 'another-one']]});                                                               // 138
  run('{{> foo 1="keyword can start with a number"}}',                                                       // 139
      {type: 'INCLUSION', path: ['foo'],                                                                     // 140
       args: [['STRING', 'keyword can start with a number', '1']]});                                         // 141
  run('{{> foo disallow-dashes-in-posarg}}',                                                                 // 142
      "Expected");                                                                                           // 143
  run('{{> foo disallow-#=1}}',                                                                              // 144
      "Expected");                                                                                           // 145
  run('{{> foo disallow->=1}}',                                                                              // 146
      "Expected");                                                                                           // 147
  run('{{> foo disallow-{=1}}',                                                                              // 148
      "Expected");                                                                                           // 149
  run('{{> foo disallow-(=1}}',                                                                              // 150
      "Expected");                                                                                           // 151
  run('{{> foo disallow-}=1}}',                                                                              // 152
      "Expected");                                                                                           // 153
  run('{{> foo disallow-)=1}}',                                                                              // 154
      "Expected");                                                                                           // 155
  run('{{> foo x=1 y=2 z}}',                                                                                 // 156
      "Can't have a non-keyword argument");                                                                  // 157
                                                                                                             // 158
  run('{{true.foo}}', "Can't use");                                                                          // 159
  run('{{foo.this}}', "Can only use");                                                                       // 160
  run('{{./this}}', "Can only use");                                                                         // 161
  run('{{../this}}', "Can only use");                                                                        // 162
                                                                                                             // 163
  run('{{foo "="}}', {type: 'DOUBLE', path: ['foo'],                                                         // 164
                        args: [['STRING', '=']]});                                                           // 165
                                                                                                             // 166
});                                                                                                          // 167
                                                                                                             // 168
                                                                                                             // 169
Tinytest.add("spacebars-compiler - Spacebars.dot", function (test) {                                         // 170
  test.equal(Spacebars.dot(null, 'foo'), null);                                                              // 171
  test.equal(Spacebars.dot('foo', 'foo'), undefined);                                                        // 172
  test.equal(Spacebars.dot({x:1}, 'x'), 1);                                                                  // 173
  test.equal(Spacebars.dot(                                                                                  // 174
    {x:1, y: function () { return this.x+1; }}, 'y')(), 2);                                                  // 175
  test.equal(Spacebars.dot(                                                                                  // 176
    function () {                                                                                            // 177
      return {x:1, y: function () { return this.x+1; }};                                                     // 178
    }, 'y')(), 2);                                                                                           // 179
                                                                                                             // 180
  var m = 1;                                                                                                 // 181
  var mget = function () {                                                                                   // 182
    return {                                                                                                 // 183
      answer: m,                                                                                             // 184
      getAnswer: function () {                                                                               // 185
        return this.answer;                                                                                  // 186
      }                                                                                                      // 187
    };                                                                                                       // 188
  };                                                                                                         // 189
  var mgetDotAnswer = Spacebars.dot(mget, 'answer');                                                         // 190
  test.equal(mgetDotAnswer, 1);                                                                              // 191
                                                                                                             // 192
  m = 3;                                                                                                     // 193
  var mgetDotGetAnswer = Spacebars.dot(mget, 'getAnswer');                                                   // 194
  test.equal(mgetDotGetAnswer(), 3);                                                                         // 195
  m = 4;                                                                                                     // 196
  test.equal(mgetDotGetAnswer(), 3);                                                                         // 197
                                                                                                             // 198
  var closet = {                                                                                             // 199
    mget: mget,                                                                                              // 200
    mget2: function () {                                                                                     // 201
      return this.mget();                                                                                    // 202
    }                                                                                                        // 203
  };                                                                                                         // 204
                                                                                                             // 205
  m = 5;                                                                                                     // 206
  var f1 = Spacebars.dot(closet, 'mget', 'answer');                                                          // 207
  m = 6;                                                                                                     // 208
  var f2 = Spacebars.dot(closet, 'mget2', 'answer');                                                         // 209
  test.equal(f2, 6);                                                                                         // 210
  m = 8;                                                                                                     // 211
  var f3 = Spacebars.dot(closet, 'mget2', 'getAnswer');                                                      // 212
  m = 9;                                                                                                     // 213
  test.equal(f3(), 8);                                                                                       // 214
                                                                                                             // 215
  test.equal(Spacebars.dot(0, 'abc', 'def'), 0);                                                             // 216
  test.equal(Spacebars.dot(function () { return null; }, 'abc', 'def'), null);                               // 217
  test.equal(Spacebars.dot(function () { return 0; }, 'abc', 'def'), 0);                                     // 218
                                                                                                             // 219
  // test that in `foo.bar`, `bar` may be a function that takes arguments.                                   // 220
  test.equal(Spacebars.dot(                                                                                  // 221
    { one: 1, inc: function (x) { return this.one + x; } }, 'inc')(6), 7);                                   // 222
  test.equal(Spacebars.dot(                                                                                  // 223
    function () {                                                                                            // 224
      return { one: 1, inc: function (x) { return this.one + x; } };                                         // 225
    }, 'inc')(8), 9);                                                                                        // 226
                                                                                                             // 227
});                                                                                                          // 228
                                                                                                             // 229
//////////////////////////////////////////////////                                                           // 230
                                                                                                             // 231
Tinytest.add("spacebars-compiler - parse", function (test) {                                                 // 232
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('{{foo}}')),                                            // 233
             'SpacebarsCompiler.TemplateTag({type: "DOUBLE", path: ["foo"]})');                              // 234
                                                                                                             // 235
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('{{!foo}}')), 'null');                                  // 236
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('x{{!foo}}y')), '"xy"');                                // 237
                                                                                                             // 238
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('{{!--foo--}}')), 'null');                              // 239
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('x{{!--foo--}}y')), '"xy"');                            // 240
                                                                                                             // 241
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('{{#foo}}x{{/foo}}')),                                  // 242
             'SpacebarsCompiler.TemplateTag({type: "BLOCKOPEN", path: ["foo"], content: "x"})');             // 243
                                                                                                             // 244
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('{{#foo}}{{#bar}}{{/bar}}{{/foo}}')),                   // 245
             'SpacebarsCompiler.TemplateTag({type: "BLOCKOPEN", path: ["foo"], content: SpacebarsCompiler.TemplateTag({type: "BLOCKOPEN", path: ["bar"]})})');
                                                                                                             // 247
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<div>hello</div> {{#foo}}<div>{{#bar}}world{{/bar}}</div>{{/foo}}')),
             '[HTML.DIV("hello"), " ", SpacebarsCompiler.TemplateTag({type: "BLOCKOPEN", path: ["foo"], content: HTML.DIV(SpacebarsCompiler.TemplateTag({type: "BLOCKOPEN", path: ["bar"], content: "world"}))})]');
                                                                                                             // 250
                                                                                                             // 251
  test.throws(function () {                                                                                  // 252
    SpacebarsCompiler.parse('<a {{{x}}}></a>');                                                              // 253
  });                                                                                                        // 254
  test.throws(function () {                                                                                  // 255
    SpacebarsCompiler.parse('<a {{#if x}}{{/if}}></a>');                                                     // 256
  });                                                                                                        // 257
  test.throws(function () {                                                                                  // 258
    SpacebarsCompiler.parse('<a {{k}}={[v}}></a>');                                                          // 259
  });                                                                                                        // 260
  test.throws(function () {                                                                                  // 261
    SpacebarsCompiler.parse('<a x{{y}}></a>');                                                               // 262
  });                                                                                                        // 263
  test.throws(function () {                                                                                  // 264
    SpacebarsCompiler.parse('<a x{{y}}=z></a>');                                                             // 265
  });                                                                                                        // 266
  test.throws(function () {                                                                                  // 267
    SpacebarsCompiler.parse('<a {{> x}}></a>');                                                              // 268
  });                                                                                                        // 269
                                                                                                             // 270
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<a {{! x--}} b=c{{! x}} {{! x}}></a>')),               // 271
             'HTML.A({b: "c"})');                                                                            // 272
                                                                                                             // 273
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<a {{!-- x--}} b=c{{ !-- x --}} {{!-- x -- }}></a>')), // 274
             'HTML.A({b: "c"})');                                                                            // 275
                                                                                                             // 276
  // currently, if there are only comments, the attribute is truthy.  This is                                // 277
  // because comments are stripped during tokenization.  If we include                                       // 278
  // comments in the token stream, these cases will become falsy for selected.                               // 279
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<input selected={{!foo}}>')),                          // 280
             'HTML.INPUT({selected: ""})');                                                                  // 281
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<input selected={{!foo}}{{!bar}}>')),                  // 282
             'HTML.INPUT({selected: ""})');                                                                  // 283
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<input selected={{!--foo--}}>')),                      // 284
    'HTML.INPUT({selected: ""})');                                                                           // 285
  test.equal(BlazeTools.toJS(SpacebarsCompiler.parse('<input selected={{!--foo--}}{{!--bar--}}>')),          // 286
    'HTML.INPUT({selected: ""})');                                                                           // 287
                                                                                                             // 288
});                                                                                                          // 289
                                                                                                             // 290
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                           //
// packages/spacebars-compiler/compile_tests.js                                                              //
//                                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                             //
Tinytest.add("spacebars-compiler - compiler output", function (test) {                                       // 1
                                                                                                             // 2
  var run = function (input, expected) {                                                                     // 3
    if (expected.fail) {                                                                                     // 4
      var expectedMessage = expected.fail;                                                                   // 5
      // test for error starting with expectedMessage                                                        // 6
      var msg = '';                                                                                          // 7
      test.throws(function () {                                                                              // 8
        try {                                                                                                // 9
          SpacebarsCompiler.compile(input, {isTemplate: true});                                              // 10
        } catch (e) {                                                                                        // 11
          msg = e.message;                                                                                   // 12
          throw e;                                                                                           // 13
        }                                                                                                    // 14
      });                                                                                                    // 15
      test.equal(msg.slice(0, expectedMessage.length),                                                       // 16
                 expectedMessage);                                                                           // 17
    } else {                                                                                                 // 18
      var output = SpacebarsCompiler.compile(input, {isTemplate: true});                                     // 19
      var postProcess = function (string) {                                                                  // 20
        // remove initial and trailing parens                                                                // 21
        string = string.replace(/^\(([\S\s]*)\)$/, '$1');                                                    // 22
        if (! (Package.minifiers && Package.minifiers.UglifyJSMinify)) {                                     // 23
          // these tests work a lot better with access to beautification,                                    // 24
          // but let's at least do some sort of test without it.                                             // 25
          // These regexes may have to be adjusted if new tests are added.                                   // 26
                                                                                                             // 27
          // Remove single-line comments, including line nums from build system.                             // 28
          string = string.replace(/\/\/.*$/mg, '');                                                          // 29
          string = string.replace(/\s+/g, ''); // kill whitespace                                            // 30
        }                                                                                                    // 31
        return string;                                                                                       // 32
      };                                                                                                     // 33
      // compare using Function .toString()!                                                                 // 34
      test._stringEqual(                                                                                     // 35
        postProcess(output.toString()),                                                                      // 36
        postProcess(                                                                                         // 37
          SpacebarsCompiler._beautify('(' + expected.toString() + ')')),                                     // 38
        input);                                                                                              // 39
    }                                                                                                        // 40
  };                                                                                                         // 41
                                                                                                             // 42
  coffee.runCompilerOutputTests(run);                                                                        // 43
});                                                                                                          // 44
                                                                                                             // 45
coffee = {                                                                                                   // 46
  runCompilerOutputTests: null // implemented in compiler_output_tests.coffee                                // 47
};                                                                                                           // 48
                                                                                                             // 49
                                                                                                             // 50
Tinytest.add("spacebars-compiler - compiler errors", function (test) {                                       // 51
                                                                                                             // 52
  var getError = function (input) {                                                                          // 53
    try {                                                                                                    // 54
      SpacebarsCompiler.compile(input);                                                                      // 55
    } catch (e) {                                                                                            // 56
      return e.message;                                                                                      // 57
    }                                                                                                        // 58
    test.fail("Didn't throw an error: " + input);                                                            // 59
  };                                                                                                         // 60
                                                                                                             // 61
  var assertStartsWith = function (a, b) {                                                                   // 62
    test.equal(a.substring(0, b.length), b);                                                                 // 63
  };                                                                                                         // 64
                                                                                                             // 65
  var isError = function (input, errorStart) {                                                               // 66
    assertStartsWith(getError(input), errorStart);                                                           // 67
  };                                                                                                         // 68
                                                                                                             // 69
  isError("<input></input>",                                                                                 // 70
          "Unexpected HTML close tag.  <input> should have no close tag.");                                  // 71
  isError("{{#each foo}}<input></input>{{/foo}}",                                                            // 72
          "Unexpected HTML close tag.  <input> should have no close tag.");                                  // 73
                                                                                                             // 74
  isError("{{#if}}{{/if}}", "#if requires an argument");                                                     // 75
  isError("{{#with}}{{/with}}", "#with requires an argument");                                               // 76
  isError("{{#each}}{{/each}}", "#each requires an argument");                                               // 77
  isError("{{#unless}}{{/unless}}", "#unless requires an argument");                                         // 78
                                                                                                             // 79
  isError("{{0 0}}", "Expected IDENTIFIER");                                                                 // 80
                                                                                                             // 81
  isError("{{> foo 0 0}}",                                                                                   // 82
          "First argument must be a function");                                                              // 83
  isError("{{> foo 0 x=0}}",                                                                                 // 84
          "First argument must be a function");                                                              // 85
  isError("{{#foo 0 0}}{{/foo}}",                                                                            // 86
          "First argument must be a function");                                                              // 87
  isError("{{#foo 0 x=0}}{{/foo}}",                                                                          // 88
          "First argument must be a function");                                                              // 89
                                                                                                             // 90
  _.each(['asdf</br>', '{{!foo}}</br>', '{{!foo}} </br>',                                                    // 91
          'asdf</a>', '{{!foo}}</a>', '{{!foo}} </a>'], function (badFrag) {                                 // 92
            isError(badFrag, "Unexpected HTML close tag");                                                   // 93
          });                                                                                                // 94
});                                                                                                          // 95
                                                                                                             // 96
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                           //
// packages/spacebars-compiler/compiler_output_tests.coffee.js                                               //
//                                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                             //
__coffeescriptShare = typeof __coffeescriptShare === 'object' ? __coffeescriptShare : {}; var share = __coffeescriptShare;
coffee.runCompilerOutputTests = function(run) {
  run("abc", "function () {\n  var view = this;\n  return \"abc\";\n}");
  run("{{foo}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"));\n  });\n}");
  run("{{foo bar}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"),\n                              view.lookup(\"bar\"));\n  });\n}");
  run("{{foo x=bar}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"), Spacebars.kw({\n      x: view.lookup(\"bar\")\n    }));\n  });\n}");
  run("{{foo.bar baz}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(Spacebars.dot(\n             view.lookup(\"foo\"), \"bar\"),\n             view.lookup(\"baz\"));\n  });\n}");
  run("{{foo bar.baz}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"),\n           Spacebars.dot(view.lookup(\"bar\"), \"baz\"));\n  });\n}");
  run("{{foo x=bar.baz}}", "function() {\n  var view = this;\n  return Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"), Spacebars.kw({\n      x: Spacebars.dot(view.lookup(\"bar\"), \"baz\")\n    }));\n  });\n}");
  run("{{#foo}}abc{{/foo}}", "function() {\n  var view = this;\n  return Spacebars.include(view.lookupTemplate(\"foo\"), (function() {\n    return \"abc\";\n  }));\n}");
  run("{{#if cond}}aaa{{else}}bbb{{/if}}", "function() {\n  var view = this;\n  return Blaze.If(function () {\n    return Spacebars.call(view.lookup(\"cond\"));\n  }, (function() {\n    return \"aaa\";\n  }), (function() {\n    return \"bbb\";\n  }));\n}");
  run("{{!-- --}}{{#if cond}}aaa{{!\n}}{{else}}{{!}}bbb{{!-- --}}{{/if}}{{!}}", "function() {\n  var view = this;\n  return Blaze.If(function () {\n    return Spacebars.call(view.lookup(\"cond\"));\n  }, (function() {\n    return \"aaa\";\n  }), (function() {\n    return \"bbb\";\n  }));\n}");
  run("{{> foo bar}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return Spacebars.call(view.lookup(\"bar\"));\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"));\n  });\n}");
  run("{{> foo x=bar}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return {\n      x: Spacebars.call(view.lookup(\"bar\"))\n    };\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"));\n  });\n}\n");
  run("{{> foo bar.baz}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return Spacebars.call(Spacebars.dot(view.lookup(\"bar\"), \"baz\"));\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"));\n  });\n}");
  run("{{> foo x=bar.baz}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return {\n      x: Spacebars.call(Spacebars.dot(view.lookup(\"bar\"), \"baz\"))\n    };\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"));\n  });\n}");
  run("{{> foo bar baz}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return Spacebars.dataMustache(view.lookup(\"bar\"), view.lookup(\"baz\"));\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"));\n  });\n}\n");
  run("{{#foo bar baz}}aaa{{/foo}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return Spacebars.dataMustache(view.lookup(\"bar\"), view.lookup(\"baz\"));\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"), (function() {\n      return \"aaa\";\n    }));\n  });\n}");
  run("{{#foo p.q r.s}}aaa{{/foo}}", "function() {\n  var view = this;\n  return Spacebars.TemplateWith(function() {\n    return Spacebars.dataMustache(Spacebars.dot(view.lookup(\"p\"), \"q\"), Spacebars.dot(view.lookup(\"r\"), \"s\"));\n  }, function() {\n    return Spacebars.include(view.lookupTemplate(\"foo\"), (function() {\n      return \"aaa\";\n    }));\n  });\n}");
  run("<a {{b}}></a>", "function() {\n  var view = this;\n  return HTML.A(HTML.Attrs(function() {\n    return Spacebars.attrMustache(view.lookup(\"b\"));\n  }));\n}");
  run("<a {{b}} c=d{{e}}f></a>", "function() {\n  var view = this;\n  return HTML.A(HTML.Attrs({\n    c: (function() { return [\n      \"d\",\n      Spacebars.mustache(view.lookup(\"e\")),\n      \"f\" ]; })\n  }, function() {\n    return Spacebars.attrMustache(view.lookup(\"b\"));\n  }));\n}");
  run("<asdf>{{foo}}</asdf>", "function() {\n  var view = this;\n  return HTML.getTag(\"asdf\")(Blaze.View(function() {\n    return Spacebars.mustache(view.lookup(\"foo\"));\n  }));\n}");
  return run("<textarea>{{foo}}</textarea>", "function() {\n  var view = this;\n  return HTML.TEXTAREA({value: (function () {\n    return Spacebars.mustache(view.lookup(\"foo\"));\n  }) });\n}");
};
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
