(function () {

//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// packages/random/random_tests.js                                              //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////
                                                                                //
Tinytest.add('random', function (test) {                                        // 1
  // Deterministic with a specified seed, which should generate the             // 2
  // same sequence in all environments.                                         // 3
  //                                                                            // 4
  // For repeatable unit test failures using deterministic random               // 5
  // number sequences it's fine if a new Meteor release changes the             // 6
  // algorithm being used and it starts generating a different                  // 7
  // sequence for a seed, as long as the sequence is consistent for             // 8
  // a particular release.                                                      // 9
  var random = Random.createWithSeeds(0);                                       // 10
  test.equal(random.id(), "cp9hWvhg8GSvuZ9os");                                 // 11
  test.equal(random.id(), "3f3k6Xo7rrHCifQhR");                                 // 12
  test.equal(random.id(), "shxDnjWWmnKPEoLhM");                                 // 13
  test.equal(random.id(), "6QTjB8C5SEqhmz4ni");                                 // 14
});                                                                             // 15
                                                                                // 16
// node crypto and window.crypto.getRandomValues() don't let us specify a seed, // 17
// but at least test that the output is in the right format.                    // 18
Tinytest.add('random - format', function (test) {                               // 19
  var idLen = 17;                                                               // 20
  test.equal(Random.id().length, idLen);                                        // 21
  test.equal(Random.id(29).length, 29);                                         // 22
  var numDigits = 9;                                                            // 23
  var hexStr = Random.hexString(numDigits);                                     // 24
  test.equal(hexStr.length, numDigits);                                         // 25
  parseInt(hexStr, 16); // should not throw                                     // 26
  var frac = Random.fraction();                                                 // 27
  test.isTrue(frac < 1.0);                                                      // 28
  test.isTrue(frac >= 0.0);                                                     // 29
                                                                                // 30
  test.equal(Random.secret().length, 43);                                       // 31
  test.equal(Random.secret(13).length, 13);                                     // 32
});                                                                             // 33
                                                                                // 34
Tinytest.add('random - Alea is last resort', function (test) {                  // 35
  if (Meteor.isServer) {                                                        // 36
    test.isTrue(Random.alea === undefined);                                     // 37
  }                                                                             // 38
  if (Meteor.isClient) {                                                        // 39
    var useGetRandomValues = !!(typeof window !== "undefined" &&                // 40
        window.crypto && window.crypto.getRandomValues);                        // 41
    test.equal(Random.alea === undefined, useGetRandomValues);                  // 42
  }                                                                             // 43
});                                                                             // 44
                                                                                // 45
Tinytest.add('random - createWithSeeds requires parameters', function (test) {  // 46
  test.throws(function () {                                                     // 47
    Random.createWithSeeds();                                                   // 48
  });                                                                           // 49
});                                                                             // 50
                                                                                // 51
//////////////////////////////////////////////////////////////////////////////////

}).call(this);
