(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/oauth2/oauth2_tests.js                                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
var testPendingCredential = function (test) {                                                                          // 1
  var http = Npm.require('http');                                                                                      // 2
  var foobookId = Random.id();                                                                                         // 3
  var foobookOption1 = Random.id();                                                                                    // 4
  var credentialToken = Random.id();                                                                                   // 5
  var serviceName = Random.id();                                                                                       // 6
                                                                                                                       // 7
  ServiceConfiguration.configurations.insert({service: serviceName});                                                  // 8
                                                                                                                       // 9
  try {                                                                                                                // 10
    // register a fake login service                                                                                   // 11
    OAuth.registerService(serviceName, 2, null, function (query) {                                                     // 12
      return {                                                                                                         // 13
        serviceData: {                                                                                                 // 14
          id: foobookId,                                                                                               // 15
          secretStuff: OAuth.sealSecret("confidential")                                                                // 16
        },                                                                                                             // 17
        options: {option1: foobookOption1}                                                                             // 18
      };                                                                                                               // 19
    });                                                                                                                // 20
                                                                                                                       // 21
    // simulate logging in using foobook                                                                               // 22
    var req = {method: "POST",                                                                                         // 23
               url: "/_oauth/" + serviceName + "?close",                                                               // 24
               query: {                                                                                                // 25
                 state: credentialToken,                                                                               // 26
                 close: 1,                                                                                             // 27
                 only_credential_secret_for_test: 1                                                                    // 28
               }};                                                                                                     // 29
    var res = new http.ServerResponse(req);                                                                            // 30
    var write = res.write;                                                                                             // 31
    var end = res.write;                                                                                               // 32
    var respData = "";                                                                                                 // 33
    res.write = function (data, encoding, callback) {                                                                  // 34
      respData += data;                                                                                                // 35
      return write.apply(this, arguments);                                                                             // 36
    };                                                                                                                 // 37
    res.end = function (data) {                                                                                        // 38
      respData += data;                                                                                                // 39
      return end.apply(this, arguments);                                                                               // 40
    };                                                                                                                 // 41
                                                                                                                       // 42
    OAuthTest.middleware(req, res);                                                                                    // 43
    var credentialSecret = respData;                                                                                   // 44
                                                                                                                       // 45
    // Test that the result for the token is available                                                                 // 46
    var result = OAuth._retrievePendingCredential(credentialToken,                                                     // 47
                                                  credentialSecret);                                                   // 48
    var serviceData = OAuth.openSecrets(result.serviceData);                                                           // 49
    test.equal(result.serviceName, serviceName);                                                                       // 50
    test.equal(serviceData.id, foobookId);                                                                             // 51
    test.equal(serviceData.secretStuff, 'confidential');                                                               // 52
    test.equal(result.options.option1, foobookOption1);                                                                // 53
                                                                                                                       // 54
    // Test that pending credential is removed after being retrieved                                                   // 55
    result = OAuth._retrievePendingCredential(credentialToken);                                                        // 56
    test.isUndefined(result);                                                                                          // 57
                                                                                                                       // 58
  } finally {                                                                                                          // 59
    OAuthTest.unregisterService(serviceName);                                                                          // 60
  }                                                                                                                    // 61
};                                                                                                                     // 62
                                                                                                                       // 63
Tinytest.add("oauth2 - pendingCredential is stored and can be retrieved (without oauth encryption)", function (test) { // 64
  OAuthEncryption.loadKey(null);                                                                                       // 65
  testPendingCredential(test);                                                                                         // 66
});                                                                                                                    // 67
                                                                                                                       // 68
Tinytest.add("oauth2 - pendingCredential is stored and can be retrieved (with oauth encryption)", function (test) {    // 69
  try {                                                                                                                // 70
    OAuthEncryption.loadKey(new Buffer([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]).toString("base64"));                  // 71
    testPendingCredential(test);                                                                                       // 72
  } finally {                                                                                                          // 73
    OAuthEncryption.loadKey(null);                                                                                     // 74
  }                                                                                                                    // 75
});                                                                                                                    // 76
                                                                                                                       // 77
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
