(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/oauth1/oauth1_tests.js                                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
var testPendingCredential = function (test) {                                                                          // 1
  var http = Npm.require('http');                                                                                      // 2
  var twitterfooId = Random.id();                                                                                      // 3
  var twitterfooName = 'nickname' + Random.id();                                                                       // 4
  var twitterfooAccessToken = Random.id();                                                                             // 5
  var twitterfooAccessTokenSecret = Random.id();                                                                       // 6
  var twitterOption1 = Random.id();                                                                                    // 7
  var credentialToken = Random.id();                                                                                   // 8
  var serviceName = Random.id();                                                                                       // 9
                                                                                                                       // 10
  var urls = {                                                                                                         // 11
    requestToken: "https://example.com/oauth/request_token",                                                           // 12
    authorize: "https://example.com/oauth/authorize",                                                                  // 13
    accessToken: "https://example.com/oauth/access_token",                                                             // 14
    authenticate: "https://example.com/oauth/authenticate"                                                             // 15
  };                                                                                                                   // 16
                                                                                                                       // 17
  OAuth1Binding.prototype.prepareRequestToken = function() {};                                                         // 18
  OAuth1Binding.prototype.prepareAccessToken = function() {                                                            // 19
    this.accessToken = twitterfooAccessToken;                                                                          // 20
    this.accessTokenSecret = twitterfooAccessTokenSecret;                                                              // 21
  };                                                                                                                   // 22
                                                                                                                       // 23
  ServiceConfiguration.configurations.insert({service: serviceName});                                                  // 24
                                                                                                                       // 25
  try {                                                                                                                // 26
    // register a fake login service                                                                                   // 27
    OAuth.registerService(serviceName, 1, urls, function (query) {                                                     // 28
      return {                                                                                                         // 29
        serviceData: {                                                                                                 // 30
          id: twitterfooId,                                                                                            // 31
          screenName: twitterfooName,                                                                                  // 32
          accessToken: OAuth.sealSecret(twitterfooAccessToken),                                                        // 33
          accessTokenSecret: OAuth.sealSecret(twitterfooAccessTokenSecret)                                             // 34
        },                                                                                                             // 35
        options: {                                                                                                     // 36
          option1: twitterOption1                                                                                      // 37
        }                                                                                                              // 38
      };                                                                                                               // 39
    });                                                                                                                // 40
                                                                                                                       // 41
    // simulate logging in using twitterfoo                                                                            // 42
    Oauth._storeRequestToken(credentialToken, twitterfooAccessToken);                                                  // 43
                                                                                                                       // 44
    var req = {                                                                                                        // 45
      method: "POST",                                                                                                  // 46
      url: "/_oauth/" + serviceName + "?close",                                                                        // 47
      query: {                                                                                                         // 48
        state: credentialToken,                                                                                        // 49
        oauth_token: twitterfooAccessToken,                                                                            // 50
        close: 1,                                                                                                      // 51
        only_credential_secret_for_test: 1                                                                             // 52
      }                                                                                                                // 53
    };                                                                                                                 // 54
    var res = new http.ServerResponse(req);                                                                            // 55
    var write = res.write;                                                                                             // 56
    var end = res.write;                                                                                               // 57
    var respData = "";                                                                                                 // 58
    res.write = function (data, encoding, callback) {                                                                  // 59
      respData += data;                                                                                                // 60
      return write.apply(this, arguments);                                                                             // 61
    };                                                                                                                 // 62
    res.end = function (data) {                                                                                        // 63
      respData += data;                                                                                                // 64
      return end.apply(this, arguments);                                                                               // 65
    };                                                                                                                 // 66
    OAuthTest.middleware(req, res);                                                                                    // 67
    var credentialSecret = respData;                                                                                   // 68
                                                                                                                       // 69
    // Test that the result for the token is available                                                                 // 70
    var result = OAuth._retrievePendingCredential(credentialToken,                                                     // 71
                                                  credentialSecret);                                                   // 72
    var serviceData = OAuth.openSecrets(result.serviceData);                                                           // 73
    test.equal(result.serviceName, serviceName);                                                                       // 74
    test.equal(serviceData.id, twitterfooId);                                                                          // 75
    test.equal(serviceData.screenName, twitterfooName);                                                                // 76
    test.equal(serviceData.accessToken, twitterfooAccessToken);                                                        // 77
    test.equal(serviceData.accessTokenSecret, twitterfooAccessTokenSecret);                                            // 78
    test.equal(result.options.option1, twitterOption1);                                                                // 79
                                                                                                                       // 80
    // Test that pending credential is removed after being retrieved                                                   // 81
    result = OAuth._retrievePendingCredential(credentialToken);                                                        // 82
    test.isUndefined(result);                                                                                          // 83
                                                                                                                       // 84
  } finally {                                                                                                          // 85
    OAuthTest.unregisterService(serviceName);                                                                          // 86
  }                                                                                                                    // 87
};                                                                                                                     // 88
                                                                                                                       // 89
Tinytest.add("oauth1 - pendingCredential is stored and can be retrieved (without oauth encryption)", function (test) { // 90
  OAuthEncryption.loadKey(null);                                                                                       // 91
  testPendingCredential(test);                                                                                         // 92
});                                                                                                                    // 93
                                                                                                                       // 94
Tinytest.add("oauth1 - pendingCredential is stored and can be retrieved (with oauth encryption)", function (test) {    // 95
  try {                                                                                                                // 96
    OAuthEncryption.loadKey(new Buffer([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]).toString("base64"));                  // 97
    testPendingCredential(test);                                                                                       // 98
  } finally {                                                                                                          // 99
    OAuthEncryption.loadKey(null);                                                                                     // 100
  }                                                                                                                    // 101
});                                                                                                                    // 102
                                                                                                                       // 103
Tinytest.add("oauth1 - duplicate key for request token", function (test) {                                             // 104
  var key = Random.id();                                                                                               // 105
  var token = Random.id();                                                                                             // 106
  var secret = Random.id();                                                                                            // 107
  OAuth._storeRequestToken(key, token, secret);                                                                        // 108
  var newToken = Random.id();                                                                                          // 109
  var newSecret = Random.id();                                                                                         // 110
  OAuth._storeRequestToken(key, newToken, newSecret);                                                                  // 111
  var result = OAuth._retrieveRequestToken(key);                                                                       // 112
  test.equal(result.requestToken, newToken);                                                                           // 113
  test.equal(result.requestTokenSecret, newSecret);                                                                    // 114
});                                                                                                                    // 115
                                                                                                                       // 116
Tinytest.add("oauth1 - null, undefined key for request token", function (test) {                                       // 117
  var token = Random.id();                                                                                             // 118
  var secret = Random.id();                                                                                            // 119
  test.throws(function () {                                                                                            // 120
    OAuth._storeRequestToken(null, token, secret);                                                                     // 121
  });                                                                                                                  // 122
  test.throws(function () {                                                                                            // 123
    OAuth._storeRequestToken(undefined, token, secret);                                                                // 124
  });                                                                                                                  // 125
});                                                                                                                    // 126
                                                                                                                       // 127
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
