(function () {

////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
// packages/oauth-encryption/encrypt_tests.js                                     //
//                                                                                //
////////////////////////////////////////////////////////////////////////////////////
                                                                                  //
Tinytest.add("oauth-encryption - loadKey", function (test) {                      // 1
  test.throws(                                                                    // 2
    function () {                                                                 // 3
      OAuthEncryption.loadKey("my encryption key");                               // 4
    },                                                                            // 5
    "The OAuth encryption key must be encoded in base64"                          // 6
  );                                                                              // 7
                                                                                  // 8
  test.throws(                                                                    // 9
    function () {                                                                 // 10
      OAuthEncryption.loadKey(new Buffer([1, 2, 3, 4, 5]).toString("base64"));    // 11
    },                                                                            // 12
    "The OAuth encryption AES-128-GCM key must be 16 bytes in length"             // 13
  );                                                                              // 14
                                                                                  // 15
  OAuthEncryption.loadKey(                                                        // 16
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 17
    toString("base64")                                                            // 18
  );                                                                              // 19
                                                                                  // 20
  OAuthEncryption.loadKey(null);                                                  // 21
});                                                                               // 22
                                                                                  // 23
Tinytest.add("oauth-encryption - seal", function (test) {                         // 24
  OAuthEncryption.loadKey(                                                        // 25
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 26
    toString("base64")                                                            // 27
  );                                                                              // 28
                                                                                  // 29
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2});                            // 30
  test.isTrue(new Buffer(ciphertext.iv, "base64").length === 12);                 // 31
  test.isTrue(OAuthEncryption._isBase64(ciphertext.ciphertext));                  // 32
  test.isTrue(ciphertext.algorithm === "aes-128-gcm");                            // 33
  test.isTrue(OAuthEncryption._isBase64(ciphertext.authTag));                     // 34
                                                                                  // 35
  OAuthEncryption.loadKey(null);                                                  // 36
});                                                                               // 37
                                                                                  // 38
Tinytest.add("oauth-encryption - open successful", function (test) {              // 39
  OAuthEncryption.loadKey(                                                        // 40
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 41
    toString("base64")                                                            // 42
  );                                                                              // 43
  var userId = "rH6rNSWd2hBTfkwcc";                                               // 44
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2}, userId);                    // 45
                                                                                  // 46
  var decrypted = OAuthEncryption.open(ciphertext, userId);                       // 47
  test.equal(decrypted, {a: 1, b: 2});                                            // 48
                                                                                  // 49
  OAuthEncryption.loadKey(null);                                                  // 50
});                                                                               // 51
                                                                                  // 52
Tinytest.add("oauth-encryption - open with wrong key", function (test) {          // 53
  OAuthEncryption.loadKey(                                                        // 54
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 55
    toString("base64")                                                            // 56
  );                                                                              // 57
  var userId = "rH6rNSWd2hBTfkwcc";                                               // 58
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2}, userId);                    // 59
                                                                                  // 60
  OAuthEncryption.loadKey(                                                        // 61
    new Buffer([9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9]).                 // 62
    toString("base64")                                                            // 63
  );                                                                              // 64
  test.throws(                                                                    // 65
    function () {                                                                 // 66
      OAuthEncryption.open(ciphertext, userId);                                   // 67
    },                                                                            // 68
    "decryption failed"                                                           // 69
  );                                                                              // 70
                                                                                  // 71
  OAuthEncryption.loadKey(null);                                                  // 72
});                                                                               // 73
                                                                                  // 74
Tinytest.add("oauth-encryption - open with wrong userId", function (test) {       // 75
  OAuthEncryption.loadKey(                                                        // 76
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 77
    toString("base64")                                                            // 78
  );                                                                              // 79
  var userId = "rH6rNSWd2hBTfkwcc";                                               // 80
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2}, userId);                    // 81
                                                                                  // 82
  var differentUser = "3FPxY2mBNeBpigm86";                                        // 83
  test.throws(                                                                    // 84
    function () {                                                                 // 85
      OAuthEncryption.open(ciphertext, differentUser);                            // 86
    },                                                                            // 87
    "decryption failed"                                                           // 88
  );                                                                              // 89
                                                                                  // 90
  OAuthEncryption.loadKey(null);                                                  // 91
});                                                                               // 92
                                                                                  // 93
Tinytest.add("oauth-encryption - seal and open with no userId", function (test) { // 94
  OAuthEncryption.loadKey(                                                        // 95
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 96
    toString("base64")                                                            // 97
  );                                                                              // 98
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2});                            // 99
  var decrypted = OAuthEncryption.open(ciphertext);                               // 100
  test.equal(decrypted, {a: 1, b: 2});                                            // 101
});                                                                               // 102
                                                                                  // 103
Tinytest.add("oauth-encryption - open modified ciphertext", function (test) {     // 104
  OAuthEncryption.loadKey(                                                        // 105
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 106
    toString("base64")                                                            // 107
  );                                                                              // 108
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2});                            // 109
                                                                                  // 110
  var b = new Buffer(ciphertext.ciphertext, "base64");                            // 111
  b[0] = b[0] ^ 1;                                                                // 112
  ciphertext.ciphertext = b.toString("base64");                                   // 113
                                                                                  // 114
  test.throws(                                                                    // 115
    function () {                                                                 // 116
      OAuthEncryption.open(ciphertext);                                           // 117
    },                                                                            // 118
    "decryption failed"                                                           // 119
  );                                                                              // 120
});                                                                               // 121
                                                                                  // 122
                                                                                  // 123
Tinytest.add("oauth-encryption - isSealed", function (test) {                     // 124
  OAuthEncryption.loadKey(                                                        // 125
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 126
    toString("base64")                                                            // 127
  );                                                                              // 128
  var userId = "rH6rNSWd2hBTfkwcc";                                               // 129
  var ciphertext = OAuthEncryption.seal({a: 1, b: 2}, userId);                    // 130
  test.isTrue(OAuthEncryption.isSealed(ciphertext));                              // 131
                                                                                  // 132
  test.isFalse(OAuthEncryption.isSealed("abcdef"));                               // 133
  test.isFalse(OAuthEncryption.isSealed({a: 1, b: 2}));                           // 134
                                                                                  // 135
  OAuthEncryption.loadKey(null);                                                  // 136
});                                                                               // 137
                                                                                  // 138
Tinytest.add("oauth-encryption - keyIsLoaded", function (test) {                  // 139
  OAuthEncryption.loadKey(null);                                                  // 140
  test.isFalse(OAuthEncryption.keyIsLoaded());                                    // 141
                                                                                  // 142
  OAuthEncryption.loadKey(                                                        // 143
    new Buffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]).          // 144
    toString("base64")                                                            // 145
  );                                                                              // 146
  test.isTrue(OAuthEncryption.keyIsLoaded());                                     // 147
                                                                                  // 148
  OAuthEncryption.loadKey(null);                                                  // 149
});                                                                               // 150
                                                                                  // 151
////////////////////////////////////////////////////////////////////////////////////

}).call(this);
