(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/mongo_livedata_tests.js                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
// This is a magic collection that fails its writes on the server when                                                 // 1
// the selector (or inserted document) contains fail: true.                                                            // 2
                                                                                                                       // 3
var TRANSFORMS = {};                                                                                                   // 4
                                                                                                                       // 5
// We keep track of the collections, so we can refer to them by name                                                   // 6
var COLLECTIONS = {};                                                                                                  // 7
                                                                                                                       // 8
if (Meteor.isServer) {                                                                                                 // 9
  Meteor.methods({                                                                                                     // 10
    createInsecureCollection: function (name, options) {                                                               // 11
      check(name, String);                                                                                             // 12
      check(options, Match.Optional({                                                                                  // 13
        transformName: Match.Optional(String),                                                                         // 14
        idGeneration: Match.Optional(String)                                                                           // 15
      }));                                                                                                             // 16
                                                                                                                       // 17
      if (options && options.transformName) {                                                                          // 18
        options.transform = TRANSFORMS[options.transformName];                                                         // 19
      }                                                                                                                // 20
      var c = new Meteor.Collection(name, options);                                                                    // 21
      COLLECTIONS[name] = c;                                                                                           // 22
      c._insecure = true;                                                                                              // 23
      Meteor.publish('c-' + name, function () {                                                                        // 24
        return c.find();                                                                                               // 25
      });                                                                                                              // 26
    },                                                                                                                 // 27
    dropInsecureCollection: function(name) {                                                                           // 28
      var c = COLLECTIONS[name];                                                                                       // 29
      c._dropCollection();                                                                                             // 30
    }                                                                                                                  // 31
  });                                                                                                                  // 32
}                                                                                                                      // 33
                                                                                                                       // 34
// We store the generated id, keyed by collection, for each insert                                                     // 35
// This is so we can test the stub and the server generate the same id                                                 // 36
var INSERTED_IDS = {};                                                                                                 // 37
                                                                                                                       // 38
Meteor.methods({                                                                                                       // 39
  insertObjects: function (collectionName, doc, count) {                                                               // 40
    var c = COLLECTIONS[collectionName];                                                                               // 41
    var ids = [];                                                                                                      // 42
    for (var i = 0; i < count; i++) {                                                                                  // 43
      var id = c.insert(doc);                                                                                          // 44
      INSERTED_IDS[collectionName] = (INSERTED_IDS[collectionName] || []).concat([id]);                                // 45
      ids.push(id);                                                                                                    // 46
    }                                                                                                                  // 47
    return ids;                                                                                                        // 48
  },                                                                                                                   // 49
  upsertObject: function (collectionName, selector, modifier) {                                                        // 50
    var c = COLLECTIONS[collectionName];                                                                               // 51
    return c.upsert(selector, modifier);                                                                               // 52
  },                                                                                                                   // 53
  doMeteorCall: function (name /*, arguments */) {                                                                     // 54
    var args = Array.prototype.slice.call(arguments);                                                                  // 55
                                                                                                                       // 56
    return Meteor.call.apply(null, args);                                                                              // 57
  }                                                                                                                    // 58
});                                                                                                                    // 59
                                                                                                                       // 60
var runInFence = function (f) {                                                                                        // 61
  if (Meteor.isClient) {                                                                                               // 62
    f();                                                                                                               // 63
  } else {                                                                                                             // 64
    var fence = new DDPServer._WriteFence;                                                                             // 65
    DDPServer._CurrentWriteFence.withValue(fence, f);                                                                  // 66
    fence.armAndWait();                                                                                                // 67
  }                                                                                                                    // 68
};                                                                                                                     // 69
                                                                                                                       // 70
// Helpers for upsert tests                                                                                            // 71
                                                                                                                       // 72
var stripId = function (obj) {                                                                                         // 73
  delete obj._id;                                                                                                      // 74
};                                                                                                                     // 75
                                                                                                                       // 76
var compareResults = function (test, skipIds, actual, expected) {                                                      // 77
  if (skipIds) {                                                                                                       // 78
    _.map(actual, stripId);                                                                                            // 79
    _.map(expected, stripId);                                                                                          // 80
  }                                                                                                                    // 81
  // (technically should ignore order in comparison)                                                                   // 82
  test.equal(actual, expected);                                                                                        // 83
};                                                                                                                     // 84
                                                                                                                       // 85
var upsert = function (coll, useUpdate, query, mod, options, callback) {                                               // 86
  if (! callback && typeof options === "function") {                                                                   // 87
    callback = options;                                                                                                // 88
    options = {};                                                                                                      // 89
  }                                                                                                                    // 90
                                                                                                                       // 91
  if (useUpdate) {                                                                                                     // 92
    if (callback)                                                                                                      // 93
      return coll.update(query, mod,                                                                                   // 94
                         _.extend({ upsert: true }, options),                                                          // 95
                         function (err, result) {                                                                      // 96
                           callback(err, ! err && {                                                                    // 97
                             numberAffected: result                                                                    // 98
                           });                                                                                         // 99
                         });                                                                                           // 100
    return {                                                                                                           // 101
      numberAffected: coll.update(query, mod,                                                                          // 102
                                  _.extend({ upsert: true }, options))                                                 // 103
    };                                                                                                                 // 104
  } else {                                                                                                             // 105
    return coll.upsert(query, mod, options, callback);                                                                 // 106
  }                                                                                                                    // 107
};                                                                                                                     // 108
                                                                                                                       // 109
var upsertTestMethod = "livedata_upsert_test_method";                                                                  // 110
var upsertTestMethodColl;                                                                                              // 111
                                                                                                                       // 112
// This is the implementation of the upsert test method on both the client and                                         // 113
// the server. On the client, we get a test object. On the server, we just throw                                       // 114
// errors if something doesn't go according to plan, and when the client                                               // 115
// receives those errors it will cause the test to fail.                                                               // 116
//                                                                                                                     // 117
// Client-side exceptions in here will NOT cause the test to fail! Because it's                                        // 118
// a stub, those exceptions will get caught and logged.                                                                // 119
var upsertTestMethodImpl = function (coll, useUpdate, test) {                                                          // 120
  coll.remove({});                                                                                                     // 121
  var result1 = upsert(coll, useUpdate, { foo: "bar" }, { foo: "bar" });                                               // 122
                                                                                                                       // 123
  if (! test) {                                                                                                        // 124
    test = {                                                                                                           // 125
      equal: function (a, b) {                                                                                         // 126
        if (! EJSON.equals(a, b))                                                                                      // 127
          throw new Error("Not equal: " +                                                                              // 128
                          JSON.stringify(a) + ", " + JSON.stringify(b));                                               // 129
      },                                                                                                               // 130
      isTrue: function (a) {                                                                                           // 131
        if (! a)                                                                                                       // 132
          throw new Error("Not truthy: " + JSON.stringify(a));                                                         // 133
      },                                                                                                               // 134
      isFalse: function (a) {                                                                                          // 135
        if (a)                                                                                                         // 136
          throw new Error("Not falsey: " + JSON.stringify(a));                                                         // 137
      }                                                                                                                // 138
    };                                                                                                                 // 139
  }                                                                                                                    // 140
                                                                                                                       // 141
  // if we don't test this, then testing result1.numberAffected will throw,                                            // 142
  // which will get caught and logged and the whole test will pass!                                                    // 143
  test.isTrue(result1);                                                                                                // 144
                                                                                                                       // 145
  test.equal(result1.numberAffected, 1);                                                                               // 146
  if (! useUpdate)                                                                                                     // 147
    test.isTrue(result1.insertedId);                                                                                   // 148
  var fooId = result1.insertedId;                                                                                      // 149
  var obj = coll.findOne({ foo: "bar" });                                                                              // 150
  test.isTrue(obj);                                                                                                    // 151
  if (! useUpdate)                                                                                                     // 152
    test.equal(obj._id, result1.insertedId);                                                                           // 153
  var result2 = upsert(coll, useUpdate, { _id: fooId },                                                                // 154
                       { $set: { foo: "baz " } });                                                                     // 155
  test.isTrue(result2);                                                                                                // 156
  test.equal(result2.numberAffected, 1);                                                                               // 157
  test.isFalse(result2.insertedId);                                                                                    // 158
};                                                                                                                     // 159
                                                                                                                       // 160
if (Meteor.isServer) {                                                                                                 // 161
  var m = {};                                                                                                          // 162
  m[upsertTestMethod] = function (run, useUpdate, options) {                                                           // 163
    check(run, String);                                                                                                // 164
    check(useUpdate, Boolean);                                                                                         // 165
    upsertTestMethodColl = new Meteor.Collection(upsertTestMethod + "_collection_" + run, options);                    // 166
    upsertTestMethodImpl(upsertTestMethodColl, useUpdate);                                                             // 167
  };                                                                                                                   // 168
  Meteor.methods(m);                                                                                                   // 169
}                                                                                                                      // 170
                                                                                                                       // 171
Meteor._FailureTestCollection =                                                                                        // 172
  new Meteor.Collection("___meteor_failure_test_collection");                                                          // 173
                                                                                                                       // 174
// For test "document with a custom type"                                                                              // 175
var Dog = function (name, color, actions) {                                                                            // 176
  var self = this;                                                                                                     // 177
  self.color = color;                                                                                                  // 178
  self.name = name;                                                                                                    // 179
  self.actions = actions || [{name: "wag"}, {name: "swim"}];                                                           // 180
};                                                                                                                     // 181
_.extend(Dog.prototype, {                                                                                              // 182
  getName: function () { return this.name;},                                                                           // 183
  getColor: function () { return this.name;},                                                                          // 184
  equals: function (other) { return other.name === this.name &&                                                        // 185
                             other.color === this.color &&                                                             // 186
                             EJSON.equals(other.actions, this.actions);},                                              // 187
  toJSONValue: function () { return {color: this.color, name: this.name, actions: this.actions};},                     // 188
  typeName: function () { return "dog"; },                                                                             // 189
  clone: function () { return new Dog(this.name, this.color); },                                                       // 190
  speak: function () { return "woof"; }                                                                                // 191
});                                                                                                                    // 192
EJSON.addType("dog", function (o) { return new Dog(o.name, o.color, o.actions);});                                     // 193
                                                                                                                       // 194
                                                                                                                       // 195
// Parameterize tests.                                                                                                 // 196
_.each( ['STRING', 'MONGO'], function(idGeneration) {                                                                  // 197
                                                                                                                       // 198
var collectionOptions = { idGeneration: idGeneration};                                                                 // 199
                                                                                                                       // 200
testAsyncMulti("mongo-livedata - database error reporting. " + idGeneration, [                                         // 201
  function (test, expect) {                                                                                            // 202
    var ftc = Meteor._FailureTestCollection;                                                                           // 203
                                                                                                                       // 204
    var exception = function (err, res) {                                                                              // 205
      test.instanceOf(err, Error);                                                                                     // 206
    };                                                                                                                 // 207
                                                                                                                       // 208
    _.each(["insert", "remove", "update"], function (op) {                                                             // 209
      var arg = (op === "insert" ? {} : 'bla');                                                                        // 210
      var arg2 = {};                                                                                                   // 211
                                                                                                                       // 212
      var callOp = function (callback) {                                                                               // 213
        if (op === "update") {                                                                                         // 214
          ftc[op](arg, arg2, callback);                                                                                // 215
        } else {                                                                                                       // 216
          ftc[op](arg, callback);                                                                                      // 217
        }                                                                                                              // 218
      };                                                                                                               // 219
                                                                                                                       // 220
      if (Meteor.isServer) {                                                                                           // 221
        test.throws(function () {                                                                                      // 222
          callOp();                                                                                                    // 223
        });                                                                                                            // 224
                                                                                                                       // 225
        callOp(expect(exception));                                                                                     // 226
      }                                                                                                                // 227
                                                                                                                       // 228
      if (Meteor.isClient) {                                                                                           // 229
        callOp(expect(exception));                                                                                     // 230
                                                                                                                       // 231
        // This would log to console in normal operation.                                                              // 232
        Meteor._suppress_log(1);                                                                                       // 233
        callOp();                                                                                                      // 234
      }                                                                                                                // 235
    });                                                                                                                // 236
  }                                                                                                                    // 237
]);                                                                                                                    // 238
                                                                                                                       // 239
                                                                                                                       // 240
Tinytest.addAsync("mongo-livedata - basics, " + idGeneration, function (test, onComplete) {                            // 241
  var run = test.runId();                                                                                              // 242
  var coll, coll2;                                                                                                     // 243
  if (Meteor.isClient) {                                                                                               // 244
    coll = new Meteor.Collection(null, collectionOptions) ; // local, unmanaged                                        // 245
    coll2 = new Meteor.Collection(null, collectionOptions); // local, unmanaged                                        // 246
  } else {                                                                                                             // 247
    coll = new Meteor.Collection("livedata_test_collection_"+run, collectionOptions);                                  // 248
    coll2 = new Meteor.Collection("livedata_test_collection_2_"+run, collectionOptions);                               // 249
  }                                                                                                                    // 250
                                                                                                                       // 251
  var log = '';                                                                                                        // 252
  var obs = coll.find({run: run}, {sort: ["x"]}).observe({                                                             // 253
    addedAt: function (doc, before_index, before) {                                                                    // 254
      log += 'a(' + doc.x + ',' + before_index + ',' + before + ')';                                                   // 255
    },                                                                                                                 // 256
    changedAt: function (new_doc, old_doc, at_index) {                                                                 // 257
      log += 'c(' + new_doc.x + ',' + at_index + ',' + old_doc.x + ')';                                                // 258
    },                                                                                                                 // 259
    movedTo: function (doc, old_index, new_index) {                                                                    // 260
      log += 'm(' + doc.x + ',' + old_index + ',' + new_index + ')';                                                   // 261
    },                                                                                                                 // 262
    removedAt: function (doc, at_index) {                                                                              // 263
      log += 'r(' + doc.x + ',' + at_index + ')';                                                                      // 264
    }                                                                                                                  // 265
  });                                                                                                                  // 266
                                                                                                                       // 267
  var captureObserve = function (f) {                                                                                  // 268
    if (Meteor.isClient) {                                                                                             // 269
      f();                                                                                                             // 270
    } else {                                                                                                           // 271
      var fence = new DDPServer._WriteFence;                                                                           // 272
      DDPServer._CurrentWriteFence.withValue(fence, f);                                                                // 273
      fence.armAndWait();                                                                                              // 274
    }                                                                                                                  // 275
                                                                                                                       // 276
    var ret = log;                                                                                                     // 277
    log = '';                                                                                                          // 278
    return ret;                                                                                                        // 279
  };                                                                                                                   // 280
                                                                                                                       // 281
  var expectObserve = function (expected, f) {                                                                         // 282
    if (!(expected instanceof Array))                                                                                  // 283
      expected = [expected];                                                                                           // 284
                                                                                                                       // 285
    test.include(expected, captureObserve(f));                                                                         // 286
  };                                                                                                                   // 287
                                                                                                                       // 288
  test.equal(coll.find({run: run}).count(), 0);                                                                        // 289
  test.equal(coll.findOne("abc"), undefined);                                                                          // 290
  test.equal(coll.findOne({run: run}), undefined);                                                                     // 291
                                                                                                                       // 292
  expectObserve('a(1,0,null)', function () {                                                                           // 293
    var id = coll.insert({run: run, x: 1});                                                                            // 294
    test.equal(coll.find({run: run}).count(), 1);                                                                      // 295
    test.equal(coll.findOne(id).x, 1);                                                                                 // 296
    test.equal(coll.findOne({run: run}).x, 1);                                                                         // 297
  });                                                                                                                  // 298
                                                                                                                       // 299
  expectObserve('a(4,1,null)', function () {                                                                           // 300
    var id2 = coll.insert({run: run, x: 4});                                                                           // 301
    test.equal(coll.find({run: run}).count(), 2);                                                                      // 302
    test.equal(coll.find({_id: id2}).count(), 1);                                                                      // 303
    test.equal(coll.findOne(id2).x, 4);                                                                                // 304
  });                                                                                                                  // 305
                                                                                                                       // 306
  test.equal(coll.findOne({run: run}, {sort: ["x"], skip: 0}).x, 1);                                                   // 307
  test.equal(coll.findOne({run: run}, {sort: ["x"], skip: 1}).x, 4);                                                   // 308
  test.equal(coll.findOne({run: run}, {sort: {x: -1}, skip: 0}).x, 4);                                                 // 309
  test.equal(coll.findOne({run: run}, {sort: {x: -1}, skip: 1}).x, 1);                                                 // 310
                                                                                                                       // 311
                                                                                                                       // 312
  var cur = coll.find({run: run}, {sort: ["x"]});                                                                      // 313
  var total = 0;                                                                                                       // 314
  var index = 0;                                                                                                       // 315
  var context = {};                                                                                                    // 316
  cur.forEach(function (doc, i, cursor) {                                                                              // 317
    test.equal(i, index++);                                                                                            // 318
    test.isTrue(cursor === cur);                                                                                       // 319
    test.isTrue(context === this);                                                                                     // 320
    total *= 10;                                                                                                       // 321
    if (Meteor.isServer) {                                                                                             // 322
      // Verify that the callbacks from forEach run sequentially and that                                              // 323
      // forEach waits for them to complete (issue# 321). If they do not run                                           // 324
      // sequentially, then the second callback could execute during the first                                         // 325
      // callback's sleep sleep and the *= 10 will occur before the += 1, then                                         // 326
      // total (at test.equal time) will be 5. If forEach does not wait for the                                        // 327
      // callbacks to complete, then total (at test.equal time) will be 0.                                             // 328
      Meteor._sleepForMs(5);                                                                                           // 329
    }                                                                                                                  // 330
    total += doc.x;                                                                                                    // 331
    // verify the meteor environment is set up here                                                                    // 332
    coll2.insert({total:total});                                                                                       // 333
  }, context);                                                                                                         // 334
  test.equal(total, 14);                                                                                               // 335
                                                                                                                       // 336
  index = 0;                                                                                                           // 337
  test.equal(cur.map(function (doc, i, cursor) {                                                                       // 338
    // XXX we could theoretically make map run its iterations in parallel or                                           // 339
    // something which would make this fail                                                                            // 340
    test.equal(i, index++);                                                                                            // 341
    test.isTrue(cursor === cur);                                                                                       // 342
    test.isTrue(context === this);                                                                                     // 343
    return doc.x * 2;                                                                                                  // 344
  }, context), [2, 8]);                                                                                                // 345
                                                                                                                       // 346
  test.equal(_.pluck(coll.find({run: run}, {sort: {x: -1}}).fetch(), "x"),                                             // 347
             [4, 1]);                                                                                                  // 348
                                                                                                                       // 349
  expectObserve('', function () {                                                                                      // 350
    var count = coll.update({run: run, x: -1}, {$inc: {x: 2}}, {multi: true});                                         // 351
    test.equal(count, 0);                                                                                              // 352
  });                                                                                                                  // 353
                                                                                                                       // 354
  expectObserve('c(3,0,1)c(6,1,4)', function () {                                                                      // 355
    var count = coll.update({run: run}, {$inc: {x: 2}}, {multi: true});                                                // 356
    test.equal(count, 2);                                                                                              // 357
    test.equal(_.pluck(coll.find({run: run}, {sort: {x: -1}}).fetch(), "x"),                                           // 358
               [6, 3]);                                                                                                // 359
  });                                                                                                                  // 360
                                                                                                                       // 361
  expectObserve(['c(13,0,3)m(13,0,1)', 'm(6,1,0)c(13,1,3)',                                                            // 362
                 'c(13,0,3)m(6,1,0)', 'm(3,0,1)c(13,1,3)'], function () {                                              // 363
    coll.update({run: run, x: 3}, {$inc: {x: 10}}, {multi: true});                                                     // 364
    test.equal(_.pluck(coll.find({run: run}, {sort: {x: -1}}).fetch(), "x"),                                           // 365
               [13, 6]);                                                                                               // 366
  });                                                                                                                  // 367
                                                                                                                       // 368
  expectObserve('r(13,1)', function () {                                                                               // 369
    var count = coll.remove({run: run, x: {$gt: 10}});                                                                 // 370
    test.equal(count, 1);                                                                                              // 371
    test.equal(coll.find({run: run}).count(), 1);                                                                      // 372
  });                                                                                                                  // 373
                                                                                                                       // 374
  expectObserve('r(6,0)', function () {                                                                                // 375
    coll.remove({run: run});                                                                                           // 376
    test.equal(coll.find({run: run}).count(), 0);                                                                      // 377
  });                                                                                                                  // 378
                                                                                                                       // 379
  expectObserve('', function () {                                                                                      // 380
    var count = coll.remove({run: run});                                                                               // 381
    test.equal(count, 0);                                                                                              // 382
    test.equal(coll.find({run: run}).count(), 0);                                                                      // 383
  });                                                                                                                  // 384
                                                                                                                       // 385
  obs.stop();                                                                                                          // 386
  onComplete();                                                                                                        // 387
});                                                                                                                    // 388
                                                                                                                       // 389
Tinytest.addAsync("mongo-livedata - fuzz test, " + idGeneration, function(test, onComplete) {                          // 390
                                                                                                                       // 391
  var run = Random.id();                                                                                               // 392
  var coll;                                                                                                            // 393
  if (Meteor.isClient) {                                                                                               // 394
    coll = new Meteor.Collection(null, collectionOptions); // local, unmanaged                                         // 395
  } else {                                                                                                             // 396
    coll = new Meteor.Collection("livedata_test_collection_"+run, collectionOptions);                                  // 397
  }                                                                                                                    // 398
                                                                                                                       // 399
  // fuzz test of observe(), especially the server-side diffing                                                        // 400
  var actual = [];                                                                                                     // 401
  var correct = [];                                                                                                    // 402
  var counters = {add: 0, change: 0, move: 0, remove: 0};                                                              // 403
                                                                                                                       // 404
  var obs = coll.find({run: run}, {sort: ["x"]}).observe({                                                             // 405
    addedAt: function (doc, before_index) {                                                                            // 406
      counters.add++;                                                                                                  // 407
      actual.splice(before_index, 0, doc.x);                                                                           // 408
    },                                                                                                                 // 409
    changedAt: function (new_doc, old_doc, at_index) {                                                                 // 410
      counters.change++;                                                                                               // 411
      test.equal(actual[at_index], old_doc.x);                                                                         // 412
      actual[at_index] = new_doc.x;                                                                                    // 413
    },                                                                                                                 // 414
    movedTo: function (doc, old_index, new_index) {                                                                    // 415
      counters.move++;                                                                                                 // 416
      test.equal(actual[old_index], doc.x);                                                                            // 417
      actual.splice(old_index, 1);                                                                                     // 418
      actual.splice(new_index, 0, doc.x);                                                                              // 419
    },                                                                                                                 // 420
    removedAt: function (doc, at_index) {                                                                              // 421
      counters.remove++;                                                                                               // 422
      test.equal(actual[at_index], doc.x);                                                                             // 423
      actual.splice(at_index, 1);                                                                                      // 424
    }                                                                                                                  // 425
  });                                                                                                                  // 426
                                                                                                                       // 427
  if (Meteor.isServer) {                                                                                               // 428
    // For now, has to be polling (not oplog) because it is ordered observe.                                           // 429
    test.isTrue(obs._multiplexer._observeDriver._suspendPolling);                                                      // 430
  }                                                                                                                    // 431
                                                                                                                       // 432
  var step = 0;                                                                                                        // 433
                                                                                                                       // 434
  // Use non-deterministic randomness so we can have a shorter fuzz                                                    // 435
  // test (fewer iterations).  For deterministic (fully seeded)                                                        // 436
  // randomness, remove the call to Random.fraction().                                                                 // 437
  var seededRandom = new SeededRandom("foobard" + Random.fraction());                                                  // 438
  // Random integer in [0,n)                                                                                           // 439
  var rnd = function (n) {                                                                                             // 440
    return seededRandom.nextIntBetween(0, n-1);                                                                        // 441
  };                                                                                                                   // 442
                                                                                                                       // 443
  var finishObserve = function (f) {                                                                                   // 444
    if (Meteor.isClient) {                                                                                             // 445
      f();                                                                                                             // 446
    } else {                                                                                                           // 447
      var fence = new DDPServer._WriteFence;                                                                           // 448
      DDPServer._CurrentWriteFence.withValue(fence, f);                                                                // 449
      fence.armAndWait();                                                                                              // 450
    }                                                                                                                  // 451
  };                                                                                                                   // 452
                                                                                                                       // 453
  var doStep = function () {                                                                                           // 454
    if (step++ === 5) { // run N random tests                                                                          // 455
      obs.stop();                                                                                                      // 456
      onComplete();                                                                                                    // 457
      return;                                                                                                          // 458
    }                                                                                                                  // 459
                                                                                                                       // 460
    var max_counters = _.clone(counters);                                                                              // 461
                                                                                                                       // 462
    finishObserve(function () {                                                                                        // 463
      if (Meteor.isServer)                                                                                             // 464
        obs._multiplexer._observeDriver._suspendPolling();                                                             // 465
                                                                                                                       // 466
      // Do a batch of 1-10 operations                                                                                 // 467
      var batch_count = rnd(10) + 1;                                                                                   // 468
      for (var i = 0; i < batch_count; i++) {                                                                          // 469
        // 25% add, 25% remove, 25% change in place, 25% change and move                                               // 470
        var op = rnd(4);                                                                                               // 471
        var which = rnd(correct.length);                                                                               // 472
        if (op === 0 || step < 2 || !correct.length) {                                                                 // 473
          // Add                                                                                                       // 474
          var x = rnd(1000000);                                                                                        // 475
          coll.insert({run: run, x: x});                                                                               // 476
          correct.push(x);                                                                                             // 477
          max_counters.add++;                                                                                          // 478
        } else if (op === 1 || op === 2) {                                                                             // 479
          var x = correct[which];                                                                                      // 480
          if (op === 1)                                                                                                // 481
            // Small change, not likely to cause a move                                                                // 482
            var val = x + (rnd(2) ? -1 : 1);                                                                           // 483
          else                                                                                                         // 484
            // Large change, likely to cause a move                                                                    // 485
            var val = rnd(1000000);                                                                                    // 486
          coll.update({run: run, x: x}, {$set: {x: val}});                                                             // 487
          correct[which] = val;                                                                                        // 488
          max_counters.change++;                                                                                       // 489
          max_counters.move++;                                                                                         // 490
        } else {                                                                                                       // 491
          coll.remove({run: run, x: correct[which]});                                                                  // 492
          correct.splice(which, 1);                                                                                    // 493
          max_counters.remove++;                                                                                       // 494
        }                                                                                                              // 495
      }                                                                                                                // 496
      if (Meteor.isServer)                                                                                             // 497
        obs._multiplexer._observeDriver._resumePolling();                                                              // 498
                                                                                                                       // 499
    });                                                                                                                // 500
                                                                                                                       // 501
    // Did we actually deliver messages that mutated the array in the                                                  // 502
    // right way?                                                                                                      // 503
    correct.sort(function (a,b) {return a-b;});                                                                        // 504
    test.equal(actual, correct);                                                                                       // 505
                                                                                                                       // 506
    // Did we limit ourselves to one 'moved' message per change,                                                       // 507
    // rather than O(results) moved messages?                                                                          // 508
    _.each(max_counters, function (v, k) {                                                                             // 509
      test.isTrue(max_counters[k] >= counters[k], k);                                                                  // 510
    });                                                                                                                // 511
                                                                                                                       // 512
    Meteor.defer(doStep);                                                                                              // 513
  };                                                                                                                   // 514
                                                                                                                       // 515
  doStep();                                                                                                            // 516
                                                                                                                       // 517
});                                                                                                                    // 518
                                                                                                                       // 519
Tinytest.addAsync("mongo-livedata - scribbling, " + idGeneration, function (test, onComplete) {                        // 520
  var run = test.runId();                                                                                              // 521
  var coll;                                                                                                            // 522
  if (Meteor.isClient) {                                                                                               // 523
    coll = new Meteor.Collection(null, collectionOptions); // local, unmanaged                                         // 524
  } else {                                                                                                             // 525
    coll = new Meteor.Collection("livedata_test_collection_"+run, collectionOptions);                                  // 526
  }                                                                                                                    // 527
                                                                                                                       // 528
  var numAddeds = 0;                                                                                                   // 529
  var handle = coll.find({run: run}).observe({                                                                         // 530
    addedAt: function (o) {                                                                                            // 531
      // test that we can scribble on the object we get back from Mongo without                                        // 532
      // breaking anything.  The worst possible scribble is messing with _id.                                          // 533
      delete o._id;                                                                                                    // 534
      numAddeds++;                                                                                                     // 535
    }                                                                                                                  // 536
  });                                                                                                                  // 537
  _.each([123, 456, 789], function (abc) {                                                                             // 538
    runInFence(function () {                                                                                           // 539
      coll.insert({run: run, abc: abc});                                                                               // 540
    });                                                                                                                // 541
  });                                                                                                                  // 542
  handle.stop();                                                                                                       // 543
  // will be 6 (1+2+3) if we broke diffing!                                                                            // 544
  test.equal(numAddeds, 3);                                                                                            // 545
                                                                                                                       // 546
  onComplete();                                                                                                        // 547
});                                                                                                                    // 548
                                                                                                                       // 549
Tinytest.addAsync("mongo-livedata - stop handle in callback, " + idGeneration, function (test, onComplete) {           // 550
  var run = Random.id();                                                                                               // 551
  var coll;                                                                                                            // 552
  if (Meteor.isClient) {                                                                                               // 553
    coll = new Meteor.Collection(null, collectionOptions); // local, unmanaged                                         // 554
  } else {                                                                                                             // 555
    coll = new Meteor.Collection("stopHandleInCallback-"+run, collectionOptions);                                      // 556
  }                                                                                                                    // 557
                                                                                                                       // 558
  var output = [];                                                                                                     // 559
                                                                                                                       // 560
  var handle = coll.find().observe({                                                                                   // 561
    added: function (doc) {                                                                                            // 562
      output.push({added: doc._id});                                                                                   // 563
    },                                                                                                                 // 564
    changed: function (newDoc) {                                                                                       // 565
      output.push('changed');                                                                                          // 566
      handle.stop();                                                                                                   // 567
    }                                                                                                                  // 568
  });                                                                                                                  // 569
                                                                                                                       // 570
  test.equal(output, []);                                                                                              // 571
                                                                                                                       // 572
  // Insert a document. Observe that the added callback is called.                                                     // 573
  var docId;                                                                                                           // 574
  runInFence(function () {                                                                                             // 575
    docId = coll.insert({foo: 42});                                                                                    // 576
  });                                                                                                                  // 577
  test.length(output, 1);                                                                                              // 578
  test.equal(output.shift(), {added: docId});                                                                          // 579
                                                                                                                       // 580
  // Update it. Observe that the changed callback is called. This should also                                          // 581
  // stop the observation.                                                                                             // 582
  runInFence(function() {                                                                                              // 583
    coll.update(docId, {$set: {bar: 10}});                                                                             // 584
  });                                                                                                                  // 585
  test.length(output, 1);                                                                                              // 586
  test.equal(output.shift(), 'changed');                                                                               // 587
                                                                                                                       // 588
  // Update again. This shouldn't call the callback because we stopped the                                             // 589
  // observation.                                                                                                      // 590
  runInFence(function() {                                                                                              // 591
    coll.update(docId, {$set: {baz: 40}});                                                                             // 592
  });                                                                                                                  // 593
  test.length(output, 0);                                                                                              // 594
                                                                                                                       // 595
  test.equal(coll.find().count(), 1);                                                                                  // 596
  test.equal(coll.findOne(docId),                                                                                      // 597
             {_id: docId, foo: 42, bar: 10, baz: 40});                                                                 // 598
                                                                                                                       // 599
  onComplete();                                                                                                        // 600
});                                                                                                                    // 601
                                                                                                                       // 602
// This behavior isn't great, but it beats deadlock.                                                                   // 603
if (Meteor.isServer) {                                                                                                 // 604
  Tinytest.addAsync("mongo-livedata - recursive observe throws, " + idGeneration, function (test, onComplete) {        // 605
    var run = test.runId();                                                                                            // 606
    var coll = new Meteor.Collection("observeInCallback-"+run, collectionOptions);                                     // 607
                                                                                                                       // 608
    var callbackCalled = false;                                                                                        // 609
    var handle = coll.find({}).observe({                                                                               // 610
      added: function (newDoc) {                                                                                       // 611
        callbackCalled = true;                                                                                         // 612
        test.throws(function () {                                                                                      // 613
          coll.find({}).observe();                                                                                     // 614
        });                                                                                                            // 615
      }                                                                                                                // 616
    });                                                                                                                // 617
    test.isFalse(callbackCalled);                                                                                      // 618
    // Insert a document. Observe that the added callback is called.                                                   // 619
    runInFence(function () {                                                                                           // 620
      coll.insert({foo: 42});                                                                                          // 621
    });                                                                                                                // 622
    test.isTrue(callbackCalled);                                                                                       // 623
                                                                                                                       // 624
    handle.stop();                                                                                                     // 625
                                                                                                                       // 626
    onComplete();                                                                                                      // 627
  });                                                                                                                  // 628
                                                                                                                       // 629
  Tinytest.addAsync("mongo-livedata - cursor dedup, " + idGeneration, function (test, onComplete) {                    // 630
    var run = test.runId();                                                                                            // 631
    var coll = new Meteor.Collection("cursorDedup-"+run, collectionOptions);                                           // 632
                                                                                                                       // 633
    var observer = function (noAdded) {                                                                                // 634
      var output = [];                                                                                                 // 635
      var callbacks = {                                                                                                // 636
        changed: function (newDoc) {                                                                                   // 637
          output.push({changed: newDoc._id});                                                                          // 638
        }                                                                                                              // 639
      };                                                                                                               // 640
      if (!noAdded) {                                                                                                  // 641
        callbacks.added = function (doc) {                                                                             // 642
          output.push({added: doc._id});                                                                               // 643
        };                                                                                                             // 644
      }                                                                                                                // 645
      var handle = coll.find({foo: 22}).observe(callbacks);                                                            // 646
      return {output: output, handle: handle};                                                                         // 647
    };                                                                                                                 // 648
                                                                                                                       // 649
    // Insert a doc and start observing.                                                                               // 650
    var docId1 = coll.insert({foo: 22});                                                                               // 651
    var o1 = observer();                                                                                               // 652
    // Initial add.                                                                                                    // 653
    test.length(o1.output, 1);                                                                                         // 654
    test.equal(o1.output.shift(), {added: docId1});                                                                    // 655
                                                                                                                       // 656
    // Insert another doc (blocking until observes have fired).                                                        // 657
    var docId2;                                                                                                        // 658
    runInFence(function () {                                                                                           // 659
      docId2 = coll.insert({foo: 22, bar: 5});                                                                         // 660
    });                                                                                                                // 661
    // Observed add.                                                                                                   // 662
    test.length(o1.output, 1);                                                                                         // 663
    test.equal(o1.output.shift(), {added: docId2});                                                                    // 664
                                                                                                                       // 665
    // Second identical observe.                                                                                       // 666
    var o2 = observer();                                                                                               // 667
    // Initial adds.                                                                                                   // 668
    test.length(o2.output, 2);                                                                                         // 669
    test.include([docId1, docId2], o2.output[0].added);                                                                // 670
    test.include([docId1, docId2], o2.output[1].added);                                                                // 671
    test.notEqual(o2.output[0].added, o2.output[1].added);                                                             // 672
    o2.output.length = 0;                                                                                              // 673
    // Original observe not affected.                                                                                  // 674
    test.length(o1.output, 0);                                                                                         // 675
                                                                                                                       // 676
    // White-box test: both observes should share an ObserveMultiplexer.                                               // 677
    var observeMultiplexer = o1.handle._multiplexer;                                                                   // 678
    test.isTrue(observeMultiplexer);                                                                                   // 679
    test.isTrue(observeMultiplexer === o2.handle._multiplexer);                                                        // 680
                                                                                                                       // 681
    // Update. Both observes fire.                                                                                     // 682
    runInFence(function () {                                                                                           // 683
      coll.update(docId1, {$set: {x: 'y'}});                                                                           // 684
    });                                                                                                                // 685
    test.length(o1.output, 1);                                                                                         // 686
    test.length(o2.output, 1);                                                                                         // 687
    test.equal(o1.output.shift(), {changed: docId1});                                                                  // 688
    test.equal(o2.output.shift(), {changed: docId1});                                                                  // 689
                                                                                                                       // 690
    // Stop first handle. Second handle still around.                                                                  // 691
    o1.handle.stop();                                                                                                  // 692
    test.length(o1.output, 0);                                                                                         // 693
    test.length(o2.output, 0);                                                                                         // 694
                                                                                                                       // 695
    // Another update. Just the second handle should fire.                                                             // 696
    runInFence(function () {                                                                                           // 697
      coll.update(docId2, {$set: {z: 'y'}});                                                                           // 698
    });                                                                                                                // 699
    test.length(o1.output, 0);                                                                                         // 700
    test.length(o2.output, 1);                                                                                         // 701
    test.equal(o2.output.shift(), {changed: docId2});                                                                  // 702
                                                                                                                       // 703
    // Stop second handle. Nothing should happen, but the multiplexer should                                           // 704
    // be stopped.                                                                                                     // 705
    test.isTrue(observeMultiplexer._handles);  // This will change.                                                    // 706
    o2.handle.stop();                                                                                                  // 707
    test.length(o1.output, 0);                                                                                         // 708
    test.length(o2.output, 0);                                                                                         // 709
    // White-box: ObserveMultiplexer has nulled its _handles so you can't                                              // 710
    // accidentally join to it.                                                                                        // 711
    test.isNull(observeMultiplexer._handles);                                                                          // 712
                                                                                                                       // 713
    // Start yet another handle on the same query.                                                                     // 714
    var o3 = observer();                                                                                               // 715
    // Initial adds.                                                                                                   // 716
    test.length(o3.output, 2);                                                                                         // 717
    test.include([docId1, docId2], o3.output[0].added);                                                                // 718
    test.include([docId1, docId2], o3.output[1].added);                                                                // 719
    test.notEqual(o3.output[0].added, o3.output[1].added);                                                             // 720
    // Old observers not called.                                                                                       // 721
    test.length(o1.output, 0);                                                                                         // 722
    test.length(o2.output, 0);                                                                                         // 723
    // White-box: Different ObserveMultiplexer.                                                                        // 724
    test.isTrue(observeMultiplexer !== o3.handle._multiplexer);                                                        // 725
                                                                                                                       // 726
    // Start another handle with no added callback. Regression test for #589.                                          // 727
    var o4 = observer(true);                                                                                           // 728
                                                                                                                       // 729
    o3.handle.stop();                                                                                                  // 730
    o4.handle.stop();                                                                                                  // 731
                                                                                                                       // 732
    onComplete();                                                                                                      // 733
  });                                                                                                                  // 734
                                                                                                                       // 735
  Tinytest.addAsync("mongo-livedata - async server-side insert, " + idGeneration, function (test, onComplete) {        // 736
    // Tests that insert returns before the callback runs. Relies on the fact                                          // 737
    // that mongo does not run the callback before spinning off the event loop.                                        // 738
    var cname = Random.id();                                                                                           // 739
    var coll = new Meteor.Collection(cname);                                                                           // 740
    var doc = { foo: "bar" };                                                                                          // 741
    var x = 0;                                                                                                         // 742
    coll.insert(doc, function (err, result) {                                                                          // 743
      test.equal(err, null);                                                                                           // 744
      test.equal(x, 1);                                                                                                // 745
      onComplete();                                                                                                    // 746
    });                                                                                                                // 747
    x++;                                                                                                               // 748
  });                                                                                                                  // 749
                                                                                                                       // 750
  Tinytest.addAsync("mongo-livedata - async server-side update, " + idGeneration, function (test, onComplete) {        // 751
    // Tests that update returns before the callback runs.                                                             // 752
    var cname = Random.id();                                                                                           // 753
    var coll = new Meteor.Collection(cname);                                                                           // 754
    var doc = { foo: "bar" };                                                                                          // 755
    var x = 0;                                                                                                         // 756
    var id = coll.insert(doc);                                                                                         // 757
    coll.update(id, { $set: { foo: "baz" } }, function (err, result) {                                                 // 758
      test.equal(err, null);                                                                                           // 759
      test.equal(result, 1);                                                                                           // 760
      test.equal(x, 1);                                                                                                // 761
      onComplete();                                                                                                    // 762
    });                                                                                                                // 763
    x++;                                                                                                               // 764
  });                                                                                                                  // 765
                                                                                                                       // 766
  Tinytest.addAsync("mongo-livedata - async server-side remove, " + idGeneration, function (test, onComplete) {        // 767
    // Tests that remove returns before the callback runs.                                                             // 768
    var cname = Random.id();                                                                                           // 769
    var coll = new Meteor.Collection(cname);                                                                           // 770
    var doc = { foo: "bar" };                                                                                          // 771
    var x = 0;                                                                                                         // 772
    var id = coll.insert(doc);                                                                                         // 773
    coll.remove(id, function (err, result) {                                                                           // 774
      test.equal(err, null);                                                                                           // 775
      test.isFalse(coll.findOne(id));                                                                                  // 776
      test.equal(x, 1);                                                                                                // 777
      onComplete();                                                                                                    // 778
    });                                                                                                                // 779
    x++;                                                                                                               // 780
  });                                                                                                                  // 781
                                                                                                                       // 782
  // compares arrays a and b w/o looking at order                                                                      // 783
  var setsEqual = function (a, b) {                                                                                    // 784
    a = _.map(a, EJSON.stringify);                                                                                     // 785
    b = _.map(b, EJSON.stringify);                                                                                     // 786
    return _.isEmpty(_.difference(a, b)) && _.isEmpty(_.difference(b, a));                                             // 787
  };                                                                                                                   // 788
                                                                                                                       // 789
  // This test mainly checks the correctness of oplog code dealing with limited                                        // 790
  // queries. Compitablity with poll-diff is added as well.                                                            // 791
  Tinytest.addAsync("mongo-livedata - observe sorted, limited " + idGeneration, function (test, onComplete) {          // 792
    var run = test.runId();                                                                                            // 793
    var coll = new Meteor.Collection("observeLimit-"+run, collectionOptions);                                          // 794
                                                                                                                       // 795
    var observer = function () {                                                                                       // 796
      var state = {};                                                                                                  // 797
      var output = [];                                                                                                 // 798
      var callbacks = {                                                                                                // 799
        changed: function (newDoc) {                                                                                   // 800
          output.push({changed: newDoc._id});                                                                          // 801
          state[newDoc._id] = newDoc;                                                                                  // 802
        },                                                                                                             // 803
        added: function (newDoc) {                                                                                     // 804
          output.push({added: newDoc._id});                                                                            // 805
          state[newDoc._id] = newDoc;                                                                                  // 806
        },                                                                                                             // 807
        removed: function (oldDoc) {                                                                                   // 808
          output.push({removed: oldDoc._id});                                                                          // 809
          delete state[oldDoc._id];                                                                                    // 810
        }                                                                                                              // 811
      };                                                                                                               // 812
      var handle = coll.find({foo: 22},                                                                                // 813
                             {sort: {bar: 1}, limit: 3}).observe(callbacks);                                           // 814
                                                                                                                       // 815
      return {output: output, handle: handle, state: state};                                                           // 816
    };                                                                                                                 // 817
    var clearOutput = function (o) { o.output.splice(0, o.output.length); };                                           // 818
                                                                                                                       // 819
    var ins = function (doc) {                                                                                         // 820
      var id; runInFence(function () { id = coll.insert(doc); });                                                      // 821
      return id;                                                                                                       // 822
    };                                                                                                                 // 823
    var rem = function (sel) { runInFence(function () { coll.remove(sel); }); };                                       // 824
    var upd = function (sel, mod, opt) {                                                                               // 825
      runInFence(function () {                                                                                         // 826
        coll.update(sel, mod, opt);                                                                                    // 827
      });                                                                                                              // 828
    };                                                                                                                 // 829
    // tests '_id' subfields for all documents in oplog buffer                                                         // 830
    var testOplogBufferIds = function (ids) {                                                                          // 831
      if (!usesOplog)                                                                                                  // 832
        return;                                                                                                        // 833
      var bufferIds = [];                                                                                              // 834
      o.handle._multiplexer._observeDriver._unpublishedBuffer.forEach(function (x, id) {                               // 835
        bufferIds.push(id);                                                                                            // 836
      });                                                                                                              // 837
                                                                                                                       // 838
      test.isTrue(setsEqual(ids, bufferIds), "expected: " + ids + "; got: " + bufferIds);                              // 839
    };                                                                                                                 // 840
    var testSafeAppendToBufferFlag = function (expected) {                                                             // 841
      if (!usesOplog)                                                                                                  // 842
        return;                                                                                                        // 843
      test.equal(o.handle._multiplexer._observeDriver._safeAppendToBuffer,                                             // 844
                 expected);                                                                                            // 845
    };                                                                                                                 // 846
                                                                                                                       // 847
    // We'll describe our state as follows.  5:1 means "the document with                                              // 848
    // _id=docId1 and bar=5".  We list documents as                                                                    // 849
    //   [ currently published | in the buffer ] outside the buffer                                                    // 850
    // If safeToAppendToBuffer is true, we'll say ]! instead.                                                          // 851
                                                                                                                       // 852
    // Insert a doc and start observing.                                                                               // 853
    var docId1 = ins({foo: 22, bar: 5});                                                                               // 854
    waitUntilOplogCaughtUp();                                                                                          // 855
                                                                                                                       // 856
    // State: [ 5:1 | ]!                                                                                               // 857
    var o = observer();                                                                                                // 858
    var usesOplog = o.handle._multiplexer._observeDriver._usesOplog;                                                   // 859
    // Initial add.                                                                                                    // 860
    test.length(o.output, 1);                                                                                          // 861
    test.equal(o.output.shift(), {added: docId1});                                                                     // 862
    testSafeAppendToBufferFlag(true);                                                                                  // 863
                                                                                                                       // 864
    // Insert another doc (blocking until observes have fired).                                                        // 865
    // State: [ 5:1 6:2 | ]!                                                                                           // 866
    var docId2 = ins({foo: 22, bar: 6});                                                                               // 867
    // Observed add.                                                                                                   // 868
    test.length(o.output, 1);                                                                                          // 869
    test.equal(o.output.shift(), {added: docId2});                                                                     // 870
    testSafeAppendToBufferFlag(true);                                                                                  // 871
                                                                                                                       // 872
    var docId3 = ins({ foo: 22, bar: 3 });                                                                             // 873
    // State: [ 3:3 5:1 6:2 | ]!                                                                                       // 874
    test.length(o.output, 1);                                                                                          // 875
    test.equal(o.output.shift(), {added: docId3});                                                                     // 876
    testSafeAppendToBufferFlag(true);                                                                                  // 877
                                                                                                                       // 878
    // Add a non-matching document                                                                                     // 879
    ins({ foo: 13 });                                                                                                  // 880
    // It shouldn't be added                                                                                           // 881
    test.length(o.output, 0);                                                                                          // 882
                                                                                                                       // 883
    // Add something that matches but is too big to fit in                                                             // 884
    var docId4 = ins({ foo: 22, bar: 7 });                                                                             // 885
    // State: [ 3:3 5:1 6:2 | 7:4 ]!                                                                                   // 886
    // It shouldn't be added but should end up in the buffer.                                                          // 887
    test.length(o.output, 0);                                                                                          // 888
    testOplogBufferIds([docId4]);                                                                                      // 889
    testSafeAppendToBufferFlag(true);                                                                                  // 890
                                                                                                                       // 891
    // Let's add something small enough to fit in                                                                      // 892
    var docId5 = ins({ foo: 22, bar: -1 });                                                                            // 893
    // State: [ -1:5 3:3 5:1 | 6:2 7:4 ]!                                                                              // 894
    // We should get an added and a removed events                                                                     // 895
    test.length(o.output, 2);                                                                                          // 896
    // doc 2 was removed from the published set as it is too big to be in                                              // 897
    test.isTrue(setsEqual(o.output, [{added: docId5}, {removed: docId2}]));                                            // 898
    clearOutput(o);                                                                                                    // 899
    testOplogBufferIds([docId2, docId4]);                                                                              // 900
    testSafeAppendToBufferFlag(true);                                                                                  // 901
                                                                                                                       // 902
    // Now remove something and that doc 2 should be right back                                                        // 903
    rem(docId5);                                                                                                       // 904
    // State: [ 3:3 5:1 6:2 | 7:4 ]!                                                                                   // 905
    test.length(o.output, 2);                                                                                          // 906
    test.isTrue(setsEqual(o.output, [{removed: docId5}, {added: docId2}]));                                            // 907
    clearOutput(o);                                                                                                    // 908
    testOplogBufferIds([docId4]);                                                                                      // 909
    testSafeAppendToBufferFlag(true);                                                                                  // 910
                                                                                                                       // 911
    // Add some negative numbers overflowing the buffer.                                                               // 912
    // New documents will take the published place, [3 5 6] will take the buffer                                       // 913
    // and 7 will be outside of the buffer in MongoDB.                                                                 // 914
    var docId6 = ins({ foo: 22, bar: -1 });                                                                            // 915
    var docId7 = ins({ foo: 22, bar: -2 });                                                                            // 916
    var docId8 = ins({ foo: 22, bar: -3 });                                                                            // 917
    // State: [ -3:8 -2:7 -1:6 | 3:3 5:1 6:2 ] 7:4                                                                     // 918
    test.length(o.output, 6);                                                                                          // 919
    var expected = [{added: docId6}, {removed: docId2},                                                                // 920
                    {added: docId7}, {removed: docId1},                                                                // 921
                    {added: docId8}, {removed: docId3}];                                                               // 922
    test.isTrue(setsEqual(o.output, expected));                                                                        // 923
    clearOutput(o);                                                                                                    // 924
    testOplogBufferIds([docId1, docId2, docId3]);                                                                      // 925
    testSafeAppendToBufferFlag(false);                                                                                 // 926
                                                                                                                       // 927
    // If we update first 3 docs (increment them by 20), it would be                                                   // 928
    // interesting.                                                                                                    // 929
    upd({ bar: { $lt: 0 }}, { $inc: { bar: 20 } }, { multi: true });                                                   // 930
    // State: [ 3:3 5:1 6:2 | ] 7:4 17:8 18:7 19:6                                                                     // 931
    //   which triggers re-poll leaving us at                                                                          // 932
    // State: [ 3:3 5:1 6:2 | 7:4 17:8 18:7 ] 19:6                                                                     // 933
                                                                                                                       // 934
    // The updated documents can't find their place in published and they can't                                        // 935
    // be buffered as we are not aware of the situation outside of the buffer.                                         // 936
    // But since our buffer becomes empty, it will be refilled partially with                                          // 937
    // updated documents.                                                                                              // 938
    test.length(o.output, 6);                                                                                          // 939
    var expectedRemoves = [{removed: docId6},                                                                          // 940
                           {removed: docId7},                                                                          // 941
                           {removed: docId8}];                                                                         // 942
    var expectedAdds = [{added: docId3},                                                                               // 943
                        {added: docId1},                                                                               // 944
                        {added: docId2}];                                                                              // 945
                                                                                                                       // 946
    test.isTrue(setsEqual(o.output, expectedAdds.concat(expectedRemoves)));                                            // 947
    clearOutput(o);                                                                                                    // 948
    testOplogBufferIds([docId4, docId7, docId8]);                                                                      // 949
    testSafeAppendToBufferFlag(false);                                                                                 // 950
                                                                                                                       // 951
    // Remove first 4 docs (3, 1, 2, 4) forcing buffer to become empty and                                             // 952
    // schedule a repoll.                                                                                              // 953
    rem({ bar: { $lt: 10 } });                                                                                         // 954
    // State: [ 17:8 18:7 19:6 | ]!                                                                                    // 955
                                                                                                                       // 956
    // XXX the oplog code analyzes the events one by one: one remove after                                             // 957
    // another. Poll-n-diff code, on the other side, analyzes the batch action                                         // 958
    // of multiple remove. Because of that difference, expected outputs differ.                                        // 959
    if (usesOplog) {                                                                                                   // 960
      var expectedRemoves = [{removed: docId3}, {removed: docId1},                                                     // 961
                             {removed: docId2}, {removed: docId4}];                                                    // 962
      var expectedAdds = [{added: docId4}, {added: docId8},                                                            // 963
                          {added: docId7}, {added: docId6}];                                                           // 964
                                                                                                                       // 965
      test.length(o.output, 8);                                                                                        // 966
    } else {                                                                                                           // 967
      var expectedRemoves = [{removed: docId3}, {removed: docId1},                                                     // 968
                             {removed: docId2}];                                                                       // 969
      var expectedAdds = [{added: docId8}, {added: docId7}, {added: docId6}];                                          // 970
                                                                                                                       // 971
      test.length(o.output, 6);                                                                                        // 972
    }                                                                                                                  // 973
                                                                                                                       // 974
    test.isTrue(setsEqual(o.output, expectedAdds.concat(expectedRemoves)));                                            // 975
    clearOutput(o);                                                                                                    // 976
    testOplogBufferIds([]);                                                                                            // 977
    testSafeAppendToBufferFlag(true);                                                                                  // 978
                                                                                                                       // 979
    var docId9 = ins({ foo: 22, bar: 21 });                                                                            // 980
    var docId10 = ins({ foo: 22, bar: 31 });                                                                           // 981
    var docId11 = ins({ foo: 22, bar: 41 });                                                                           // 982
    var docId12 = ins({ foo: 22, bar: 51 });                                                                           // 983
    // State: [ 17:8 18:7 19:6 | 21:9 31:10 41:11 ] 51:12                                                              // 984
                                                                                                                       // 985
    testOplogBufferIds([docId9, docId10, docId11]);                                                                    // 986
    testSafeAppendToBufferFlag(false);                                                                                 // 987
    test.length(o.output, 0);                                                                                          // 988
    upd({ bar: { $lt: 20 } }, { $inc: { bar: 5 } }, { multi: true });                                                  // 989
    // State: [ 21:9 22:8 23:7 | 24:6 31:10 41:11 ] 51:12                                                              // 990
    test.length(o.output, 4);                                                                                          // 991
    test.isTrue(setsEqual(o.output, [{removed: docId6},                                                                // 992
                                     {added: docId9},                                                                  // 993
                                     {changed: docId7},                                                                // 994
                                     {changed: docId8}]));                                                             // 995
    clearOutput(o);                                                                                                    // 996
    testOplogBufferIds([docId6, docId10, docId11]);                                                                    // 997
    testSafeAppendToBufferFlag(false);                                                                                 // 998
                                                                                                                       // 999
    rem(docId9);                                                                                                       // 1000
    // State: [ 22:8 23:7 24:6 | 31:10 41:11 ] 51:12                                                                   // 1001
    test.length(o.output, 2);                                                                                          // 1002
    test.isTrue(setsEqual(o.output, [{removed: docId9}, {added: docId6}]));                                            // 1003
    clearOutput(o);                                                                                                    // 1004
    testOplogBufferIds([docId10, docId11]);                                                                            // 1005
    testSafeAppendToBufferFlag(false);                                                                                 // 1006
                                                                                                                       // 1007
    upd({ bar: { $gt: 25 } }, { $inc: { bar: -7.5 } }, { multi: true });                                               // 1008
    // State: [ 22:8 23:7 23.5:10 | 24:6 ] 33.5:11 43.5:12                                                             // 1009
    // 33.5 doesn't update in-place in buffer, because it the driver is not sure                                       // 1010
    // it can do it: because the buffer does not have the safe append flag set,                                        // 1011
    // for all it knows there is a different doc which is less than 33.5.                                              // 1012
    test.length(o.output, 2);                                                                                          // 1013
    test.isTrue(setsEqual(o.output, [{removed: docId6}, {added: docId10}]));                                           // 1014
    clearOutput(o);                                                                                                    // 1015
    testOplogBufferIds([docId6]);                                                                                      // 1016
    testSafeAppendToBufferFlag(false);                                                                                 // 1017
                                                                                                                       // 1018
    // Force buffer objects to be moved into published set so we can check them                                        // 1019
    rem(docId7);                                                                                                       // 1020
    rem(docId8);                                                                                                       // 1021
    rem(docId10);                                                                                                      // 1022
    // State: [ 24:6 | ] 33.5:11 43.5:12                                                                               // 1023
    //    triggers repoll                                                                                              // 1024
    // State: [ 24:6 33.5:11 43.5:12 | ]!                                                                              // 1025
    test.length(o.output, 6);                                                                                          // 1026
    test.isTrue(setsEqual(o.output, [{removed: docId7}, {removed: docId8},                                             // 1027
                                     {removed: docId10}, {added: docId6},                                              // 1028
                                     {added: docId11}, {added: docId12}]));                                            // 1029
                                                                                                                       // 1030
    test.length(_.keys(o.state), 3);                                                                                   // 1031
    test.equal(o.state[docId6], { _id: docId6, foo: 22, bar: 24 });                                                    // 1032
    test.equal(o.state[docId11], { _id: docId11, foo: 22, bar: 33.5 });                                                // 1033
    test.equal(o.state[docId12], { _id: docId12, foo: 22, bar: 43.5 });                                                // 1034
    clearOutput(o);                                                                                                    // 1035
    testOplogBufferIds([]);                                                                                            // 1036
    testSafeAppendToBufferFlag(true);                                                                                  // 1037
                                                                                                                       // 1038
    var docId13 = ins({ foo: 22, bar: 50 });                                                                           // 1039
    var docId14 = ins({ foo: 22, bar: 51 });                                                                           // 1040
    var docId15 = ins({ foo: 22, bar: 52 });                                                                           // 1041
    var docId16 = ins({ foo: 22, bar: 53 });                                                                           // 1042
    // State: [ 24:6 33.5:11 43.5:12 | 50:13 51:14 52:15 ] 53:16                                                       // 1043
    test.length(o.output, 0);                                                                                          // 1044
    testOplogBufferIds([docId13, docId14, docId15]);                                                                   // 1045
    testSafeAppendToBufferFlag(false);                                                                                 // 1046
                                                                                                                       // 1047
    // Update something that's outside the buffer to be in the buffer, writing                                         // 1048
    // only to the sort key.                                                                                           // 1049
    upd(docId16, {$set: {bar: 10}});                                                                                   // 1050
    // State: [ 10:16 24:6 33.5:11 | 43.5:12 50:13 51:14 ] 52:15                                                       // 1051
    test.length(o.output, 2);                                                                                          // 1052
    test.isTrue(setsEqual(o.output, [{removed: docId12}, {added: docId16}]));                                          // 1053
    clearOutput(o);                                                                                                    // 1054
    testOplogBufferIds([docId12, docId13, docId14]);                                                                   // 1055
    testSafeAppendToBufferFlag(false);                                                                                 // 1056
                                                                                                                       // 1057
    o.handle.stop();                                                                                                   // 1058
    onComplete();                                                                                                      // 1059
  });                                                                                                                  // 1060
                                                                                                                       // 1061
  Tinytest.addAsync("mongo-livedata - observe sorted, limited, sort fields " + idGeneration, function (test, onComplete) {
    var run = test.runId();                                                                                            // 1063
    var coll = new Meteor.Collection("observeLimit-"+run, collectionOptions);                                          // 1064
                                                                                                                       // 1065
    var observer = function () {                                                                                       // 1066
      var state = {};                                                                                                  // 1067
      var output = [];                                                                                                 // 1068
      var callbacks = {                                                                                                // 1069
        changed: function (newDoc) {                                                                                   // 1070
          output.push({changed: newDoc._id});                                                                          // 1071
          state[newDoc._id] = newDoc;                                                                                  // 1072
        },                                                                                                             // 1073
        added: function (newDoc) {                                                                                     // 1074
          output.push({added: newDoc._id});                                                                            // 1075
          state[newDoc._id] = newDoc;                                                                                  // 1076
        },                                                                                                             // 1077
        removed: function (oldDoc) {                                                                                   // 1078
          output.push({removed: oldDoc._id});                                                                          // 1079
          delete state[oldDoc._id];                                                                                    // 1080
        }                                                                                                              // 1081
      };                                                                                                               // 1082
      var handle = coll.find({}, {sort: {x: 1},                                                                        // 1083
                                  limit: 2,                                                                            // 1084
                                  fields: {y: 1}}).observe(callbacks);                                                 // 1085
                                                                                                                       // 1086
      return {output: output, handle: handle, state: state};                                                           // 1087
    };                                                                                                                 // 1088
    var clearOutput = function (o) { o.output.splice(0, o.output.length); };                                           // 1089
    var ins = function (doc) {                                                                                         // 1090
      var id; runInFence(function () { id = coll.insert(doc); });                                                      // 1091
      return id;                                                                                                       // 1092
    };                                                                                                                 // 1093
    var rem = function (id) {                                                                                          // 1094
      runInFence(function () { coll.remove(id); });                                                                    // 1095
    };                                                                                                                 // 1096
                                                                                                                       // 1097
    var o = observer();                                                                                                // 1098
                                                                                                                       // 1099
    var docId1 = ins({ x: 1, y: 1222 });                                                                               // 1100
    var docId2 = ins({ x: 5, y: 5222 });                                                                               // 1101
                                                                                                                       // 1102
    test.length(o.output, 2);                                                                                          // 1103
    test.equal(o.output, [{added: docId1}, {added: docId2}]);                                                          // 1104
    clearOutput(o);                                                                                                    // 1105
                                                                                                                       // 1106
    var docId3 = ins({ x: 7, y: 7222 });                                                                               // 1107
    test.length(o.output, 0);                                                                                          // 1108
                                                                                                                       // 1109
    var docId4 = ins({ x: -1, y: -1222 });                                                                             // 1110
                                                                                                                       // 1111
    // Becomes [docId4 docId1 | docId2 docId3]                                                                         // 1112
    test.length(o.output, 2);                                                                                          // 1113
    test.isTrue(setsEqual(o.output, [{added: docId4}, {removed: docId2}]));                                            // 1114
                                                                                                                       // 1115
    test.equal(_.size(o.state), 2);                                                                                    // 1116
    test.equal(o.state[docId4], {_id: docId4, y: -1222});                                                              // 1117
    test.equal(o.state[docId1], {_id: docId1, y: 1222});                                                               // 1118
    clearOutput(o);                                                                                                    // 1119
                                                                                                                       // 1120
    rem(docId2);                                                                                                       // 1121
    // Becomes [docId4 docId1 | docId3]                                                                                // 1122
    test.length(o.output, 0);                                                                                          // 1123
                                                                                                                       // 1124
    rem(docId4);                                                                                                       // 1125
    // Becomes [docId1 docId3]                                                                                         // 1126
    test.length(o.output, 2);                                                                                          // 1127
    test.isTrue(setsEqual(o.output, [{added: docId3}, {removed: docId4}]));                                            // 1128
                                                                                                                       // 1129
    test.equal(_.size(o.state), 2);                                                                                    // 1130
    test.equal(o.state[docId3], {_id: docId3, y: 7222});                                                               // 1131
    test.equal(o.state[docId1], {_id: docId1, y: 1222});                                                               // 1132
    clearOutput(o);                                                                                                    // 1133
                                                                                                                       // 1134
    onComplete();                                                                                                      // 1135
  });                                                                                                                  // 1136
                                                                                                                       // 1137
  Tinytest.addAsync("mongo-livedata - observe sorted, limited, big initial set" + idGeneration, function (test, onComplete) {
    var run = test.runId();                                                                                            // 1139
    var coll = new Meteor.Collection("observeLimit-"+run, collectionOptions);                                          // 1140
                                                                                                                       // 1141
    var observer = function () {                                                                                       // 1142
      var state = {};                                                                                                  // 1143
      var output = [];                                                                                                 // 1144
      var callbacks = {                                                                                                // 1145
        changed: function (newDoc) {                                                                                   // 1146
          output.push({changed: newDoc._id});                                                                          // 1147
          state[newDoc._id] = newDoc;                                                                                  // 1148
        },                                                                                                             // 1149
        added: function (newDoc) {                                                                                     // 1150
          output.push({added: newDoc._id});                                                                            // 1151
          state[newDoc._id] = newDoc;                                                                                  // 1152
        },                                                                                                             // 1153
        removed: function (oldDoc) {                                                                                   // 1154
          output.push({removed: oldDoc._id});                                                                          // 1155
          delete state[oldDoc._id];                                                                                    // 1156
        }                                                                                                              // 1157
      };                                                                                                               // 1158
      var handle = coll.find({}, {sort: {x: 1, y: 1}, limit: 3})                                                       // 1159
                    .observe(callbacks);                                                                               // 1160
                                                                                                                       // 1161
      return {output: output, handle: handle, state: state};                                                           // 1162
    };                                                                                                                 // 1163
    var clearOutput = function (o) { o.output.splice(0, o.output.length); };                                           // 1164
    var ins = function (doc) {                                                                                         // 1165
      var id; runInFence(function () { id = coll.insert(doc); });                                                      // 1166
      return id;                                                                                                       // 1167
    };                                                                                                                 // 1168
    var rem = function (id) {                                                                                          // 1169
      runInFence(function () { coll.remove(id); });                                                                    // 1170
    };                                                                                                                 // 1171
    // tests '_id' subfields for all documents in oplog buffer                                                         // 1172
    var testOplogBufferIds = function (ids) {                                                                          // 1173
      var bufferIds = [];                                                                                              // 1174
      o.handle._multiplexer._observeDriver._unpublishedBuffer.forEach(function (x, id) {                               // 1175
        bufferIds.push(id);                                                                                            // 1176
      });                                                                                                              // 1177
                                                                                                                       // 1178
      test.isTrue(setsEqual(ids, bufferIds), "expected: " + ids + "; got: " + bufferIds);                              // 1179
    };                                                                                                                 // 1180
    var testSafeAppendToBufferFlag = function (expected) {                                                             // 1181
      if (expected)                                                                                                    // 1182
        test.isTrue(o.handle._multiplexer._observeDriver._safeAppendToBuffer);                                         // 1183
      else                                                                                                             // 1184
        test.isFalse(o.handle._multiplexer._observeDriver._safeAppendToBuffer);                                        // 1185
    };                                                                                                                 // 1186
                                                                                                                       // 1187
    var ids = {};                                                                                                      // 1188
    _.each([2, 4, 1, 3, 5, 5, 9, 1, 3, 2, 5], function (x, i) {                                                        // 1189
      ids[i] = ins({ x: x, y: i });                                                                                    // 1190
    });                                                                                                                // 1191
                                                                                                                       // 1192
    // Ensure that we are past all the 'i' entries before we run the query, so                                         // 1193
    // that we get the expected phase transitions.                                                                     // 1194
    waitUntilOplogCaughtUp();                                                                                          // 1195
                                                                                                                       // 1196
    var o = observer();                                                                                                // 1197
    var usesOplog = o.handle._multiplexer._observeDriver._usesOplog;                                                   // 1198
    //  x: [1 1 2 | 2 3 3] 4 5 5 5  9                                                                                  // 1199
    // id: [2 7 0 | 9 3 8] 1 4 5 10 6                                                                                  // 1200
                                                                                                                       // 1201
    test.length(o.output, 3);                                                                                          // 1202
    test.isTrue(setsEqual([{added: ids[2]}, {added: ids[7]}, {added: ids[0]}], o.output));                             // 1203
    usesOplog && testOplogBufferIds([ids[9], ids[3], ids[8]]);                                                         // 1204
    usesOplog && testSafeAppendToBufferFlag(false);                                                                    // 1205
    clearOutput(o);                                                                                                    // 1206
                                                                                                                       // 1207
    rem(ids[0]);                                                                                                       // 1208
    //  x: [1 1 2 | 3 3] 4 5 5 5  9                                                                                    // 1209
    // id: [2 7 9 | 3 8] 1 4 5 10 6                                                                                    // 1210
    test.length(o.output, 2);                                                                                          // 1211
    test.isTrue(setsEqual([{removed: ids[0]}, {added: ids[9]}], o.output));                                            // 1212
    usesOplog && testOplogBufferIds([ids[3], ids[8]]);                                                                 // 1213
    usesOplog && testSafeAppendToBufferFlag(false);                                                                    // 1214
    clearOutput(o);                                                                                                    // 1215
                                                                                                                       // 1216
    rem(ids[7]);                                                                                                       // 1217
    //  x: [1 2 3 | 3] 4 5 5 5  9                                                                                      // 1218
    // id: [2 9 3 | 8] 1 4 5 10 6                                                                                      // 1219
    test.length(o.output, 2);                                                                                          // 1220
    test.isTrue(setsEqual([{removed: ids[7]}, {added: ids[3]}], o.output));                                            // 1221
    usesOplog && testOplogBufferIds([ids[8]]);                                                                         // 1222
    usesOplog && testSafeAppendToBufferFlag(false);                                                                    // 1223
    clearOutput(o);                                                                                                    // 1224
                                                                                                                       // 1225
    rem(ids[3]);                                                                                                       // 1226
    //  x: [1 2 3 | 4 5 5] 5  9                                                                                        // 1227
    // id: [2 9 8 | 1 4 5] 10 6                                                                                        // 1228
    test.length(o.output, 2);                                                                                          // 1229
    test.isTrue(setsEqual([{removed: ids[3]}, {added: ids[8]}], o.output));                                            // 1230
    usesOplog && testOplogBufferIds([ids[1], ids[4], ids[5]]);                                                         // 1231
    usesOplog && testSafeAppendToBufferFlag(false);                                                                    // 1232
    clearOutput(o);                                                                                                    // 1233
                                                                                                                       // 1234
    rem({ x: {$lt: 4} });                                                                                              // 1235
    //  x: [4 5 5 | 5  9]                                                                                              // 1236
    // id: [1 4 5 | 10 6]                                                                                              // 1237
    test.length(o.output, 6);                                                                                          // 1238
    test.isTrue(setsEqual([{removed: ids[2]}, {removed: ids[9]}, {removed: ids[8]},                                    // 1239
                           {added: ids[5]}, {added: ids[4]}, {added: ids[1]}], o.output));                             // 1240
    usesOplog && testOplogBufferIds([ids[10], ids[6]]);                                                                // 1241
    usesOplog && testSafeAppendToBufferFlag(true);                                                                     // 1242
    clearOutput(o);                                                                                                    // 1243
                                                                                                                       // 1244
                                                                                                                       // 1245
    onComplete();                                                                                                      // 1246
  });                                                                                                                  // 1247
}                                                                                                                      // 1248
                                                                                                                       // 1249
                                                                                                                       // 1250
testAsyncMulti('mongo-livedata - empty documents, ' + idGeneration, [                                                  // 1251
  function (test, expect) {                                                                                            // 1252
    this.collectionName = Random.id();                                                                                 // 1253
    if (Meteor.isClient) {                                                                                             // 1254
      Meteor.call('createInsecureCollection', this.collectionName);                                                    // 1255
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1256
    }                                                                                                                  // 1257
  }, function (test, expect) {                                                                                         // 1258
    var coll = new Meteor.Collection(this.collectionName, collectionOptions);                                          // 1259
                                                                                                                       // 1260
    coll.insert({}, expect(function (err, id) {                                                                        // 1261
      test.isFalse(err);                                                                                               // 1262
      test.isTrue(id);                                                                                                 // 1263
      var cursor = coll.find();                                                                                        // 1264
      test.equal(cursor.count(), 1);                                                                                   // 1265
    }));                                                                                                               // 1266
  }                                                                                                                    // 1267
]);                                                                                                                    // 1268
                                                                                                                       // 1269
// See https://github.com/meteor/meteor/issues/594.                                                                    // 1270
testAsyncMulti('mongo-livedata - document with length, ' + idGeneration, [                                             // 1271
  function (test, expect) {                                                                                            // 1272
    this.collectionName = Random.id();                                                                                 // 1273
    if (Meteor.isClient) {                                                                                             // 1274
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1275
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1276
    }                                                                                                                  // 1277
  }, function (test, expect) {                                                                                         // 1278
    var self = this;                                                                                                   // 1279
    var coll = self.coll = new Meteor.Collection(self.collectionName, collectionOptions);                              // 1280
                                                                                                                       // 1281
    coll.insert({foo: 'x', length: 0}, expect(function (err, id) {                                                     // 1282
      test.isFalse(err);                                                                                               // 1283
      test.isTrue(id);                                                                                                 // 1284
      self.docId = id;                                                                                                 // 1285
      test.equal(coll.findOne(self.docId),                                                                             // 1286
                 {_id: self.docId, foo: 'x', length: 0});                                                              // 1287
    }));                                                                                                               // 1288
  },                                                                                                                   // 1289
  function (test, expect) {                                                                                            // 1290
    var self = this;                                                                                                   // 1291
    var coll = self.coll;                                                                                              // 1292
    coll.update(self.docId, {$set: {length: 5}}, expect(function (err) {                                               // 1293
      test.isFalse(err);                                                                                               // 1294
      test.equal(coll.findOne(self.docId),                                                                             // 1295
                 {_id: self.docId, foo: 'x', length: 5});                                                              // 1296
    }));                                                                                                               // 1297
  }                                                                                                                    // 1298
]);                                                                                                                    // 1299
                                                                                                                       // 1300
testAsyncMulti('mongo-livedata - document with a date, ' + idGeneration, [                                             // 1301
  function (test, expect) {                                                                                            // 1302
    this.collectionName = Random.id();                                                                                 // 1303
    if (Meteor.isClient) {                                                                                             // 1304
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1305
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1306
    }                                                                                                                  // 1307
  }, function (test, expect) {                                                                                         // 1308
                                                                                                                       // 1309
    var coll = new Meteor.Collection(this.collectionName, collectionOptions);                                          // 1310
    var docId;                                                                                                         // 1311
    coll.insert({d: new Date(1356152390004)}, expect(function (err, id) {                                              // 1312
      test.isFalse(err);                                                                                               // 1313
      test.isTrue(id);                                                                                                 // 1314
      docId = id;                                                                                                      // 1315
      var cursor = coll.find();                                                                                        // 1316
      test.equal(cursor.count(), 1);                                                                                   // 1317
      test.equal(coll.findOne().d.getFullYear(), 2012);                                                                // 1318
    }));                                                                                                               // 1319
  }                                                                                                                    // 1320
]);                                                                                                                    // 1321
                                                                                                                       // 1322
testAsyncMulti('mongo-livedata - document goes through a transform, ' + idGeneration, [                                // 1323
  function (test, expect) {                                                                                            // 1324
    var self = this;                                                                                                   // 1325
    var seconds = function (doc) {                                                                                     // 1326
      doc.seconds = function () {return doc.d.getSeconds();};                                                          // 1327
      return doc;                                                                                                      // 1328
    };                                                                                                                 // 1329
    TRANSFORMS["seconds"] = seconds;                                                                                   // 1330
    self.collectionOptions = {                                                                                         // 1331
      idGeneration: idGeneration,                                                                                      // 1332
      transform: seconds,                                                                                              // 1333
      transformName: "seconds"                                                                                         // 1334
    };                                                                                                                 // 1335
    this.collectionName = Random.id();                                                                                 // 1336
    if (Meteor.isClient) {                                                                                             // 1337
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1338
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1339
    }                                                                                                                  // 1340
  }, function (test, expect) {                                                                                         // 1341
    var self = this;                                                                                                   // 1342
    self.coll = new Meteor.Collection(self.collectionName, self.collectionOptions);                                    // 1343
    var obs;                                                                                                           // 1344
    var expectAdd = expect(function (doc) {                                                                            // 1345
      test.equal(doc.seconds(), 50);                                                                                   // 1346
    });                                                                                                                // 1347
    var expectRemove = expect(function (doc) {                                                                         // 1348
      test.equal(doc.seconds(), 50);                                                                                   // 1349
      obs.stop();                                                                                                      // 1350
    });                                                                                                                // 1351
    self.coll.insert({d: new Date(1356152390004)}, expect(function (err, id) {                                         // 1352
      test.isFalse(err);                                                                                               // 1353
      test.isTrue(id);                                                                                                 // 1354
      var cursor = self.coll.find();                                                                                   // 1355
      obs = cursor.observe({                                                                                           // 1356
        added: expectAdd,                                                                                              // 1357
        removed: expectRemove                                                                                          // 1358
      });                                                                                                              // 1359
      test.equal(cursor.count(), 1);                                                                                   // 1360
      test.equal(cursor.fetch()[0].seconds(), 50);                                                                     // 1361
      test.equal(self.coll.findOne().seconds(), 50);                                                                   // 1362
      test.equal(self.coll.findOne({}, {transform: null}).seconds, undefined);                                         // 1363
      test.equal(self.coll.findOne({}, {                                                                               // 1364
        transform: function (doc) {return {seconds: doc.d.getSeconds()};}                                              // 1365
      }).seconds, 50);                                                                                                 // 1366
      self.coll.remove(id);                                                                                            // 1367
    }));                                                                                                               // 1368
  },                                                                                                                   // 1369
  function (test, expect) {                                                                                            // 1370
    var self = this;                                                                                                   // 1371
    self.coll.insert({d: new Date(1356152390004)}, expect(function (err, id) {                                         // 1372
      test.isFalse(err);                                                                                               // 1373
      test.isTrue(id);                                                                                                 // 1374
      self.id1 = id;                                                                                                   // 1375
    }));                                                                                                               // 1376
    self.coll.insert({d: new Date(1356152391004)}, expect(function (err, id) {                                         // 1377
      test.isFalse(err);                                                                                               // 1378
      test.isTrue(id);                                                                                                 // 1379
      self.id2 = id;                                                                                                   // 1380
    }));                                                                                                               // 1381
  }                                                                                                                    // 1382
]);                                                                                                                    // 1383
                                                                                                                       // 1384
testAsyncMulti('mongo-livedata - transform sets _id if not present, ' + idGeneration, [                                // 1385
  function (test, expect) {                                                                                            // 1386
    var self = this;                                                                                                   // 1387
    var justId = function (doc) {                                                                                      // 1388
      return _.omit(doc, '_id');                                                                                       // 1389
    };                                                                                                                 // 1390
    TRANSFORMS["justId"] = justId;                                                                                     // 1391
    var collectionOptions = {                                                                                          // 1392
      idGeneration: idGeneration,                                                                                      // 1393
      transform: justId,                                                                                               // 1394
      transformName: "justId"                                                                                          // 1395
    };                                                                                                                 // 1396
    this.collectionName = Random.id();                                                                                 // 1397
    if (Meteor.isClient) {                                                                                             // 1398
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1399
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1400
    }                                                                                                                  // 1401
  }, function (test, expect) {                                                                                         // 1402
    var self = this;                                                                                                   // 1403
    self.coll = new Meteor.Collection(this.collectionName, collectionOptions);                                         // 1404
    self.coll.insert({}, expect(function (err, id) {                                                                   // 1405
      test.isFalse(err);                                                                                               // 1406
      test.isTrue(id);                                                                                                 // 1407
      test.equal(self.coll.findOne()._id, id);                                                                         // 1408
    }));                                                                                                               // 1409
  }                                                                                                                    // 1410
]);                                                                                                                    // 1411
                                                                                                                       // 1412
var bin = EJSONTest.base64Decode(                                                                                      // 1413
  "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyBy" +                                                             // 1414
    "ZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJv" +                                                           // 1415
    "bSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhl" +                                                           // 1416
    "IG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdo" +                                                           // 1417
    "dCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdl" +                                                           // 1418
    "bmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9y" +                                                           // 1419
    "dCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=");                                                               // 1420
                                                                                                                       // 1421
testAsyncMulti('mongo-livedata - document with binary data, ' + idGeneration, [                                        // 1422
  function (test, expect) {                                                                                            // 1423
    // XXX probably shouldn't use EJSON's private test symbols                                                         // 1424
    this.collectionName = Random.id();                                                                                 // 1425
    if (Meteor.isClient) {                                                                                             // 1426
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1427
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1428
    }                                                                                                                  // 1429
  }, function (test, expect) {                                                                                         // 1430
    var coll = new Meteor.Collection(this.collectionName, collectionOptions);                                          // 1431
    var docId;                                                                                                         // 1432
    coll.insert({b: bin}, expect(function (err, id) {                                                                  // 1433
      test.isFalse(err);                                                                                               // 1434
      test.isTrue(id);                                                                                                 // 1435
      docId = id;                                                                                                      // 1436
      var cursor = coll.find();                                                                                        // 1437
      test.equal(cursor.count(), 1);                                                                                   // 1438
      var inColl = coll.findOne();                                                                                     // 1439
      test.isTrue(EJSON.isBinary(inColl.b));                                                                           // 1440
      test.equal(inColl.b, bin);                                                                                       // 1441
    }));                                                                                                               // 1442
  }                                                                                                                    // 1443
]);                                                                                                                    // 1444
                                                                                                                       // 1445
testAsyncMulti('mongo-livedata - document with a custom type, ' + idGeneration, [                                      // 1446
  function (test, expect) {                                                                                            // 1447
    this.collectionName = Random.id();                                                                                 // 1448
    if (Meteor.isClient) {                                                                                             // 1449
      Meteor.call('createInsecureCollection', this.collectionName, collectionOptions);                                 // 1450
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 1451
    }                                                                                                                  // 1452
  }, function (test, expect) {                                                                                         // 1453
    var self = this;                                                                                                   // 1454
    self.coll = new Meteor.Collection(this.collectionName, collectionOptions);                                         // 1455
    var docId;                                                                                                         // 1456
    // Dog is implemented at the top of the file, outside of the idGeneration                                          // 1457
    // loop (so that we only call EJSON.addType once).                                                                 // 1458
    var d = new Dog("reginald", "purple");                                                                             // 1459
    self.coll.insert({d: d}, expect(function (err, id) {                                                               // 1460
      test.isFalse(err);                                                                                               // 1461
      test.isTrue(id);                                                                                                 // 1462
      docId = id;                                                                                                      // 1463
      var cursor = self.coll.find();                                                                                   // 1464
      test.equal(cursor.count(), 1);                                                                                   // 1465
      var inColl = self.coll.findOne();                                                                                // 1466
      test.isTrue(inColl);                                                                                             // 1467
      inColl && test.equal(inColl.d.speak(), "woof");                                                                  // 1468
    }));                                                                                                               // 1469
  }, function (test, expect) {                                                                                         // 1470
    var self = this;                                                                                                   // 1471
    self.coll.insert(new Dog("rover", "orange"), expect(function (err, id) {                                           // 1472
      test.isTrue(err);                                                                                                // 1473
      test.isFalse(id);                                                                                                // 1474
    }));                                                                                                               // 1475
  }                                                                                                                    // 1476
]);                                                                                                                    // 1477
                                                                                                                       // 1478
if (Meteor.isServer) {                                                                                                 // 1479
  Tinytest.addAsync("mongo-livedata - update return values, " + idGeneration, function (test, onComplete) {            // 1480
    var run = test.runId();                                                                                            // 1481
    var coll = new Meteor.Collection("livedata_update_result_"+run, collectionOptions);                                // 1482
                                                                                                                       // 1483
    coll.insert({ foo: "bar" });                                                                                       // 1484
    coll.insert({ foo: "baz" });                                                                                       // 1485
    test.equal(coll.update({}, { $set: { foo: "qux" } }, { multi: true }),                                             // 1486
               2);                                                                                                     // 1487
    coll.update({}, { $set: { foo: "quux" } }, { multi: true }, function (err, result) {                               // 1488
      test.isFalse(err);                                                                                               // 1489
      test.equal(result, 2);                                                                                           // 1490
      onComplete();                                                                                                    // 1491
    });                                                                                                                // 1492
  });                                                                                                                  // 1493
                                                                                                                       // 1494
  Tinytest.addAsync("mongo-livedata - remove return values, " + idGeneration, function (test, onComplete) {            // 1495
    var run = test.runId();                                                                                            // 1496
    var coll = new Meteor.Collection("livedata_update_result_"+run, collectionOptions);                                // 1497
                                                                                                                       // 1498
    coll.insert({ foo: "bar" });                                                                                       // 1499
    coll.insert({ foo: "baz" });                                                                                       // 1500
    test.equal(coll.remove({}), 2);                                                                                    // 1501
    coll.insert({ foo: "bar" });                                                                                       // 1502
    coll.insert({ foo: "baz" });                                                                                       // 1503
    coll.remove({}, function (err, result) {                                                                           // 1504
      test.isFalse(err);                                                                                               // 1505
      test.equal(result, 2);                                                                                           // 1506
      onComplete();                                                                                                    // 1507
    });                                                                                                                // 1508
  });                                                                                                                  // 1509
                                                                                                                       // 1510
                                                                                                                       // 1511
  Tinytest.addAsync("mongo-livedata - id-based invalidation, " + idGeneration, function (test, onComplete) {           // 1512
    var run = test.runId();                                                                                            // 1513
    var coll = new Meteor.Collection("livedata_invalidation_collection_"+run, collectionOptions);                      // 1514
                                                                                                                       // 1515
    coll.allow({                                                                                                       // 1516
      update: function () {return true;},                                                                              // 1517
      remove: function () {return true;}                                                                               // 1518
    });                                                                                                                // 1519
                                                                                                                       // 1520
    var id1 = coll.insert({x: 42, is1: true});                                                                         // 1521
    var id2 = coll.insert({x: 50, is2: true});                                                                         // 1522
                                                                                                                       // 1523
    var polls = {};                                                                                                    // 1524
    var handlesToStop = [];                                                                                            // 1525
    var observe = function (name, query) {                                                                             // 1526
      var handle = coll.find(query).observeChanges({                                                                   // 1527
        // Make sure that we only poll on invalidation, not due to time, and                                           // 1528
        // keep track of when we do. Note: this option disables the use of                                             // 1529
        // oplogs (which admittedly is somewhat irrelevant to this feature).                                           // 1530
        _testOnlyPollCallback: function () {                                                                           // 1531
          polls[name] = (name in polls ? polls[name] + 1 : 1);                                                         // 1532
        }                                                                                                              // 1533
      });                                                                                                              // 1534
      handlesToStop.push(handle);                                                                                      // 1535
    };                                                                                                                 // 1536
                                                                                                                       // 1537
    observe("all", {});                                                                                                // 1538
    observe("id1Direct", id1);                                                                                         // 1539
    observe("id1InQuery", {_id: id1, z: null});                                                                        // 1540
    observe("id2Direct", id2);                                                                                         // 1541
    observe("id2InQuery", {_id: id2, z: null});                                                                        // 1542
    observe("bothIds", {_id: {$in: [id1, id2]}});                                                                      // 1543
                                                                                                                       // 1544
    var resetPollsAndRunInFence = function (f) {                                                                       // 1545
      polls = {};                                                                                                      // 1546
      runInFence(f);                                                                                                   // 1547
    };                                                                                                                 // 1548
                                                                                                                       // 1549
    // Update id1 directly. This should poll all but the "id2" queries. "all"                                          // 1550
    // and "bothIds" increment by 2 because they are looking at both.                                                  // 1551
    resetPollsAndRunInFence(function () {                                                                              // 1552
      coll.update(id1, {$inc: {x: 1}});                                                                                // 1553
    });                                                                                                                // 1554
    test.equal(                                                                                                        // 1555
      polls,                                                                                                           // 1556
      {all: 1, id1Direct: 1, id1InQuery: 1, bothIds: 1});                                                              // 1557
                                                                                                                       // 1558
    // Update id2 using a funny query. This should poll all but the "id1"                                              // 1559
    // queries.                                                                                                        // 1560
    resetPollsAndRunInFence(function () {                                                                              // 1561
      coll.update({_id: id2, q: null}, {$inc: {x: 1}});                                                                // 1562
    });                                                                                                                // 1563
    test.equal(                                                                                                        // 1564
      polls,                                                                                                           // 1565
      {all: 1, id2Direct: 1, id2InQuery: 1, bothIds: 1});                                                              // 1566
                                                                                                                       // 1567
    // Update both using a $in query. Should poll each of them exactly once.                                           // 1568
    resetPollsAndRunInFence(function () {                                                                              // 1569
      coll.update({_id: {$in: [id1, id2]}, q: null}, {$inc: {x: 1}});                                                  // 1570
    });                                                                                                                // 1571
    test.equal(                                                                                                        // 1572
      polls,                                                                                                           // 1573
      {all: 1, id1Direct: 1, id1InQuery: 1, id2Direct: 1, id2InQuery: 1,                                               // 1574
       bothIds: 1});                                                                                                   // 1575
                                                                                                                       // 1576
    _.each(handlesToStop, function (h) {h.stop();});                                                                   // 1577
    onComplete();                                                                                                      // 1578
  });                                                                                                                  // 1579
                                                                                                                       // 1580
  Tinytest.add("mongo-livedata - upsert error parse, " + idGeneration, function (test) {                               // 1581
    var run = test.runId();                                                                                            // 1582
    var coll = new Meteor.Collection("livedata_upsert_errorparse_collection_"+run, collectionOptions);                 // 1583
                                                                                                                       // 1584
    coll.insert({_id: 'foobar'});                                                                                      // 1585
    var err;                                                                                                           // 1586
    try {                                                                                                              // 1587
      coll.update({_id: 'foobar'}, {_id: 'cowbar'});                                                                   // 1588
    } catch (e) {                                                                                                      // 1589
      err = e;                                                                                                         // 1590
    }                                                                                                                  // 1591
    test.isTrue(err);                                                                                                  // 1592
    test.isTrue(MongoInternals.Connection._isCannotChangeIdError(err));                                                // 1593
                                                                                                                       // 1594
    try {                                                                                                              // 1595
      coll.insert({_id: 'foobar'});                                                                                    // 1596
    } catch (e) {                                                                                                      // 1597
      err = e;                                                                                                         // 1598
    }                                                                                                                  // 1599
    test.isTrue(err);                                                                                                  // 1600
    // duplicate id error is not same as change id error                                                               // 1601
    test.isFalse(MongoInternals.Connection._isCannotChangeIdError(err));                                               // 1602
  });                                                                                                                  // 1603
                                                                                                                       // 1604
} // end Meteor.isServer                                                                                               // 1605
                                                                                                                       // 1606
// This test is duplicated below (with some changes) for async upserts that go                                         // 1607
// over the network.                                                                                                   // 1608
_.each(Meteor.isServer ? [true, false] : [true], function (minimongo) {                                                // 1609
  _.each([true, false], function (useUpdate) {                                                                         // 1610
    _.each([true, false], function (useDirectCollection) {                                                             // 1611
      Tinytest.add("mongo-livedata - " + (useUpdate ? "update " : "") + "upsert" + (minimongo ? " minimongo" : "") + (useDirectCollection ? " direct collection " : "") + ", " + idGeneration, function (test) {
        var run = test.runId();                                                                                        // 1613
        var options = collectionOptions;                                                                               // 1614
        // We don't get ids back when we use update() to upsert, or when we are                                        // 1615
        // directly calling MongoConnection.upsert().                                                                  // 1616
        var skipIds = useUpdate || (! minimongo && useDirectCollection);                                               // 1617
        if (minimongo)                                                                                                 // 1618
          options = _.extend({}, collectionOptions, { connection: null });                                             // 1619
        var coll = new Meteor.Collection(                                                                              // 1620
          "livedata_upsert_collection_"+run+                                                                           // 1621
            (useUpdate ? "_update_" : "") +                                                                            // 1622
            (minimongo ? "_minimongo_" : "") +                                                                         // 1623
            (useDirectCollection ? "_direct_" : "") + "",                                                              // 1624
          options                                                                                                      // 1625
        );                                                                                                             // 1626
        if (useDirectCollection)                                                                                       // 1627
          coll = coll._collection;                                                                                     // 1628
                                                                                                                       // 1629
        var result1 = upsert(coll, useUpdate, {foo: 'bar'}, {foo: 'bar'});                                             // 1630
        test.equal(result1.numberAffected, 1);                                                                         // 1631
        if (! skipIds)                                                                                                 // 1632
          test.isTrue(result1.insertedId);                                                                             // 1633
        compareResults(test, skipIds, coll.find().fetch(), [{foo: 'bar', _id: result1.insertedId}]);                   // 1634
                                                                                                                       // 1635
        var result2 = upsert(coll, useUpdate, {foo: 'bar'}, {foo: 'baz'});                                             // 1636
        test.equal(result2.numberAffected, 1);                                                                         // 1637
        if (! skipIds)                                                                                                 // 1638
          test.isFalse(result2.insertedId);                                                                            // 1639
        compareResults(test, skipIds, coll.find().fetch(), [{foo: 'baz', _id: result1.insertedId}]);                   // 1640
                                                                                                                       // 1641
        coll.remove({});                                                                                               // 1642
                                                                                                                       // 1643
        // Test values that require transformation to go into Mongo:                                                   // 1644
                                                                                                                       // 1645
        var t1 = new Meteor.Collection.ObjectID();                                                                     // 1646
        var t2 = new Meteor.Collection.ObjectID();                                                                     // 1647
        var result3 = upsert(coll, useUpdate, {foo: t1}, {foo: t1});                                                   // 1648
        test.equal(result3.numberAffected, 1);                                                                         // 1649
        if (! skipIds)                                                                                                 // 1650
          test.isTrue(result3.insertedId);                                                                             // 1651
        compareResults(test, skipIds, coll.find().fetch(), [{foo: t1, _id: result3.insertedId}]);                      // 1652
                                                                                                                       // 1653
        var result4 = upsert(coll, useUpdate, {foo: t1}, {foo: t2});                                                   // 1654
        test.equal(result2.numberAffected, 1);                                                                         // 1655
        if (! skipIds)                                                                                                 // 1656
          test.isFalse(result2.insertedId);                                                                            // 1657
        compareResults(test, skipIds, coll.find().fetch(), [{foo: t2, _id: result3.insertedId}]);                      // 1658
                                                                                                                       // 1659
        coll.remove({});                                                                                               // 1660
                                                                                                                       // 1661
        // Test modification by upsert                                                                                 // 1662
                                                                                                                       // 1663
        var result5 = upsert(coll, useUpdate, {name: 'David'}, {$set: {foo: 1}});                                      // 1664
        test.equal(result5.numberAffected, 1);                                                                         // 1665
        if (! skipIds)                                                                                                 // 1666
          test.isTrue(result5.insertedId);                                                                             // 1667
        var davidId = result5.insertedId;                                                                              // 1668
        compareResults(test, skipIds, coll.find().fetch(), [{name: 'David', foo: 1, _id: davidId}]);                   // 1669
                                                                                                                       // 1670
        test.throws(function () {                                                                                      // 1671
          // test that bad modifier fails fast                                                                         // 1672
          upsert(coll, useUpdate, {name: 'David'}, {$blah: {foo: 2}});                                                 // 1673
        });                                                                                                            // 1674
                                                                                                                       // 1675
                                                                                                                       // 1676
        var result6 = upsert(coll, useUpdate, {name: 'David'}, {$set: {foo: 2}});                                      // 1677
        test.equal(result6.numberAffected, 1);                                                                         // 1678
        if (! skipIds)                                                                                                 // 1679
          test.isFalse(result6.insertedId);                                                                            // 1680
        compareResults(test, skipIds, coll.find().fetch(), [{name: 'David', foo: 2,                                    // 1681
                                                               _id: result5.insertedId}]);                             // 1682
                                                                                                                       // 1683
        var emilyId = coll.insert({name: 'Emily', foo: 2});                                                            // 1684
        compareResults(test, skipIds, coll.find().fetch(), [{name: 'David', foo: 2, _id: davidId},                     // 1685
                                                              {name: 'Emily', foo: 2, _id: emilyId}]);                 // 1686
                                                                                                                       // 1687
        // multi update by upsert                                                                                      // 1688
        var result7 = upsert(coll, useUpdate, {foo: 2},                                                                // 1689
                             {$set: {bar: 7},                                                                          // 1690
                              $setOnInsert: {name: 'Fred', foo: 2}},                                                   // 1691
                             {multi: true});                                                                           // 1692
        test.equal(result7.numberAffected, 2);                                                                         // 1693
        if (! skipIds)                                                                                                 // 1694
          test.isFalse(result7.insertedId);                                                                            // 1695
        compareResults(test, skipIds, coll.find().fetch(), [{name: 'David', foo: 2, bar: 7, _id: davidId},             // 1696
                                                              {name: 'Emily', foo: 2, bar: 7, _id: emilyId}]);         // 1697
                                                                                                                       // 1698
        // insert by multi upsert                                                                                      // 1699
        var result8 = upsert(coll, useUpdate, {foo: 3},                                                                // 1700
                             {$set: {bar: 7},                                                                          // 1701
                              $setOnInsert: {name: 'Fred', foo: 2}},                                                   // 1702
                             {multi: true});                                                                           // 1703
        test.equal(result8.numberAffected, 1);                                                                         // 1704
        if (! skipIds)                                                                                                 // 1705
          test.isTrue(result8.insertedId);                                                                             // 1706
        var fredId = result8.insertedId;                                                                               // 1707
        compareResults(test, skipIds, coll.find().fetch(),                                                             // 1708
                       [{name: 'David', foo: 2, bar: 7, _id: davidId},                                                 // 1709
                        {name: 'Emily', foo: 2, bar: 7, _id: emilyId},                                                 // 1710
                        {name: 'Fred', foo: 2, bar: 7, _id: fredId}]);                                                 // 1711
                                                                                                                       // 1712
        // test `insertedId` option                                                                                    // 1713
        var result9 = upsert(coll, useUpdate, {name: 'Steve'},                                                         // 1714
                             {name: 'Steve'},                                                                          // 1715
                             {insertedId: 'steve'});                                                                   // 1716
        test.equal(result9.numberAffected, 1);                                                                         // 1717
        if (! skipIds)                                                                                                 // 1718
          test.equal(result9.insertedId, 'steve');                                                                     // 1719
        compareResults(test, skipIds, coll.find().fetch(),                                                             // 1720
                       [{name: 'David', foo: 2, bar: 7, _id: davidId},                                                 // 1721
                        {name: 'Emily', foo: 2, bar: 7, _id: emilyId},                                                 // 1722
                        {name: 'Fred', foo: 2, bar: 7, _id: fredId},                                                   // 1723
                        {name: 'Steve', _id: 'steve'}]);                                                               // 1724
        test.isTrue(coll.findOne('steve'));                                                                            // 1725
        test.isFalse(coll.findOne('fred'));                                                                            // 1726
                                                                                                                       // 1727
        // Test $ operator in selectors.                                                                               // 1728
                                                                                                                       // 1729
        var result10 = upsert(coll, useUpdate,                                                                         // 1730
                              {$or: [{name: 'David'}, {name: 'Emily'}]},                                               // 1731
                              {$set: {foo: 3}}, {multi: true});                                                        // 1732
        test.equal(result10.numberAffected, 2);                                                                        // 1733
        if (! skipIds)                                                                                                 // 1734
          test.isFalse(result10.insertedId);                                                                           // 1735
        compareResults(test, skipIds,                                                                                  // 1736
                       [coll.findOne({name: 'David'}), coll.findOne({name: 'Emily'})],                                 // 1737
                       [{name: 'David', foo: 3, bar: 7, _id: davidId},                                                 // 1738
                        {name: 'Emily', foo: 3, bar: 7, _id: emilyId}]                                                 // 1739
                      );                                                                                               // 1740
                                                                                                                       // 1741
        var result11 = upsert(                                                                                         // 1742
          coll, useUpdate,                                                                                             // 1743
          {                                                                                                            // 1744
            name: 'Charlie',                                                                                           // 1745
            $or: [{ foo: 2}, { bar: 7 }]                                                                               // 1746
          },                                                                                                           // 1747
          { $set: { foo: 3 } }                                                                                         // 1748
        );                                                                                                             // 1749
        test.equal(result11.numberAffected, 1);                                                                        // 1750
        if (! skipIds)                                                                                                 // 1751
          test.isTrue(result11.insertedId);                                                                            // 1752
        var charlieId = result11.insertedId;                                                                           // 1753
        compareResults(test, skipIds,                                                                                  // 1754
                       coll.find({ name: 'Charlie' }).fetch(),                                                         // 1755
                       [{name: 'Charlie', foo: 3, _id: charlieId}]);                                                   // 1756
      });                                                                                                              // 1757
    });                                                                                                                // 1758
  });                                                                                                                  // 1759
});                                                                                                                    // 1760
                                                                                                                       // 1761
var asyncUpsertTestName = function (useNetwork, useDirectCollection,                                                   // 1762
                                    useUpdate, idGeneration) {                                                         // 1763
  return "mongo-livedata - async " +                                                                                   // 1764
    (useUpdate ? "update " : "") +                                                                                     // 1765
    "upsert " +                                                                                                        // 1766
    (useNetwork ? "over network " : "") +                                                                              // 1767
    (useDirectCollection ? ", direct collection " : "") +                                                              // 1768
    idGeneration;                                                                                                      // 1769
};                                                                                                                     // 1770
                                                                                                                       // 1771
// This is a duplicate of the test above, with some changes to make it work for                                        // 1772
// callback style. On the client, we test server-backed and in-memory                                                  // 1773
// collections, and run the tests for both the Meteor.Collection and the                                               // 1774
// LocalCollection. On the server, we test mongo-backed collections, for both                                          // 1775
// the Meteor.Collection and the MongoConnection.                                                                      // 1776
//                                                                                                                     // 1777
// XXX Rewrite with testAsyncMulti, that would simplify things a lot!                                                  // 1778
_.each(Meteor.isServer ? [false] : [true, false], function (useNetwork) {                                              // 1779
  _.each(useNetwork ? [false] : [true, false], function (useDirectCollection) {                                        // 1780
    _.each([true, false], function (useUpdate) {                                                                       // 1781
      Tinytest.addAsync(asyncUpsertTestName(useNetwork, useDirectCollection, useUpdate, idGeneration), function (test, onComplete) {
        var coll;                                                                                                      // 1783
        var run = test.runId();                                                                                        // 1784
        var collName = "livedata_upsert_collection_"+run+                                                              // 1785
              (useUpdate ? "_update_" : "") +                                                                          // 1786
              (useNetwork ? "_network_" : "") +                                                                        // 1787
              (useDirectCollection ? "_direct_" : "");                                                                 // 1788
                                                                                                                       // 1789
        var next0 = function () {                                                                                      // 1790
          // Test starts here.                                                                                         // 1791
          upsert(coll, useUpdate, {_id: 'foo'}, {_id: 'foo', foo: 'bar'}, next1);                                      // 1792
        };                                                                                                             // 1793
                                                                                                                       // 1794
        if (useNetwork) {                                                                                              // 1795
          Meteor.call("createInsecureCollection", collName, collectionOptions);                                        // 1796
          coll = new Meteor.Collection(collName, collectionOptions);                                                   // 1797
          Meteor.subscribe("c-" + collName, next0);                                                                    // 1798
        } else {                                                                                                       // 1799
          var opts = _.clone(collectionOptions);                                                                       // 1800
          if (Meteor.isClient)                                                                                         // 1801
            opts.connection = null;                                                                                    // 1802
          coll = new Meteor.Collection(collName, opts);                                                                // 1803
          if (useDirectCollection)                                                                                     // 1804
            coll = coll._collection;                                                                                   // 1805
        }                                                                                                              // 1806
                                                                                                                       // 1807
        var result1;                                                                                                   // 1808
        var next1 = function (err, result) {                                                                           // 1809
          result1 = result;                                                                                            // 1810
          test.equal(result1.numberAffected, 1);                                                                       // 1811
          if (! useUpdate) {                                                                                           // 1812
            test.isTrue(result1.insertedId);                                                                           // 1813
            test.equal(result1.insertedId, 'foo');                                                                     // 1814
          }                                                                                                            // 1815
          compareResults(test, useUpdate, coll.find().fetch(), [{foo: 'bar', _id: 'foo'}]);                            // 1816
          upsert(coll, useUpdate, {_id: 'foo'}, {foo: 'baz'}, next2);                                                  // 1817
        };                                                                                                             // 1818
                                                                                                                       // 1819
        if (! useNetwork) {                                                                                            // 1820
          next0();                                                                                                     // 1821
        }                                                                                                              // 1822
                                                                                                                       // 1823
        var t1, t2, result2;                                                                                           // 1824
        var next2 = function (err, result) {                                                                           // 1825
          result2 = result;                                                                                            // 1826
          test.equal(result2.numberAffected, 1);                                                                       // 1827
          if (! useUpdate)                                                                                             // 1828
            test.isFalse(result2.insertedId);                                                                          // 1829
          compareResults(test, useUpdate, coll.find().fetch(), [{foo: 'baz', _id: result1.insertedId}]);               // 1830
          coll.remove({_id: 'foo'});                                                                                   // 1831
          compareResults(test, useUpdate, coll.find().fetch(), []);                                                    // 1832
                                                                                                                       // 1833
          // Test values that require transformation to go into Mongo:                                                 // 1834
                                                                                                                       // 1835
          t1 = new Meteor.Collection.ObjectID();                                                                       // 1836
          t2 = new Meteor.Collection.ObjectID();                                                                       // 1837
          upsert(coll, useUpdate, {_id: t1}, {_id: t1, foo: 'bar'}, next3);                                            // 1838
        };                                                                                                             // 1839
                                                                                                                       // 1840
        var result3;                                                                                                   // 1841
        var next3 = function (err, result) {                                                                           // 1842
          result3 = result;                                                                                            // 1843
          test.equal(result3.numberAffected, 1);                                                                       // 1844
          if (! useUpdate) {                                                                                           // 1845
            test.isTrue(result3.insertedId);                                                                           // 1846
            test.equal(t1, result3.insertedId);                                                                        // 1847
          }                                                                                                            // 1848
          compareResults(test, useUpdate, coll.find().fetch(), [{_id: t1, foo: 'bar'}]);                               // 1849
                                                                                                                       // 1850
          upsert(coll, useUpdate, {_id: t1}, {foo: t2}, next4);                                                        // 1851
        };                                                                                                             // 1852
                                                                                                                       // 1853
        var next4 = function (err, result4) {                                                                          // 1854
          test.equal(result2.numberAffected, 1);                                                                       // 1855
          if (! useUpdate)                                                                                             // 1856
            test.isFalse(result2.insertedId);                                                                          // 1857
          compareResults(test, useUpdate, coll.find().fetch(), [{foo: t2, _id: result3.insertedId}]);                  // 1858
                                                                                                                       // 1859
          coll.remove({_id: t1});                                                                                      // 1860
                                                                                                                       // 1861
          // Test modification by upsert                                                                               // 1862
          upsert(coll, useUpdate, {_id: 'David'}, {$set: {foo: 1}}, next5);                                            // 1863
        };                                                                                                             // 1864
                                                                                                                       // 1865
        var result5;                                                                                                   // 1866
        var next5 = function (err, result) {                                                                           // 1867
          result5 = result;                                                                                            // 1868
          test.equal(result5.numberAffected, 1);                                                                       // 1869
          if (! useUpdate) {                                                                                           // 1870
            test.isTrue(result5.insertedId);                                                                           // 1871
            test.equal(result5.insertedId, 'David');                                                                   // 1872
          }                                                                                                            // 1873
          var davidId = result5.insertedId;                                                                            // 1874
          compareResults(test, useUpdate, coll.find().fetch(), [{foo: 1, _id: davidId}]);                              // 1875
                                                                                                                       // 1876
          if (! Meteor.isClient && useDirectCollection) {                                                              // 1877
            // test that bad modifier fails                                                                            // 1878
            // The stub throws an exception about the invalid modifier, which                                          // 1879
            // livedata logs (so we suppress it).                                                                      // 1880
            Meteor._suppress_log(1);                                                                                   // 1881
            upsert(coll, useUpdate, {_id: 'David'}, {$blah: {foo: 2}}, function (err) {                                // 1882
              if (! (Meteor.isClient && useDirectCollection))                                                          // 1883
                test.isTrue(err);                                                                                      // 1884
              upsert(coll, useUpdate, {_id: 'David'}, {$set: {foo: 2}}, next6);                                        // 1885
            });                                                                                                        // 1886
          } else {                                                                                                     // 1887
            // XXX skip this test for now for LocalCollection; the fact that                                           // 1888
            // we're in a nested sequence of callbacks means we're inside a                                            // 1889
            // Meteor.defer, which means the exception just gets                                                       // 1890
            // logged. Something should be done about this at some point?  Maybe                                       // 1891
            // LocalCollection callbacks don't really have to be deferred.                                             // 1892
            upsert(coll, useUpdate, {_id: 'David'}, {$set: {foo: 2}}, next6);                                          // 1893
          }                                                                                                            // 1894
        };                                                                                                             // 1895
                                                                                                                       // 1896
        var result6;                                                                                                   // 1897
        var next6 = function (err, result) {                                                                           // 1898
          result6 = result;                                                                                            // 1899
          test.equal(result6.numberAffected, 1);                                                                       // 1900
          if (! useUpdate)                                                                                             // 1901
            test.isFalse(result6.insertedId);                                                                          // 1902
          compareResults(test, useUpdate, coll.find().fetch(), [{_id: 'David', foo: 2}]);                              // 1903
                                                                                                                       // 1904
          var emilyId = coll.insert({_id: 'Emily', foo: 2});                                                           // 1905
          compareResults(test, useUpdate, coll.find().fetch(), [{_id: 'David', foo: 2},                                // 1906
                                                                {_id: 'Emily', foo: 2}]);                              // 1907
                                                                                                                       // 1908
          // multi update by upsert.                                                                                   // 1909
          // We can't actually update multiple documents since we have to do it by                                     // 1910
          // id, but at least make sure the multi flag doesn't mess anything up.                                       // 1911
          upsert(coll, useUpdate, {_id: 'Emily'},                                                                      // 1912
                 {$set: {bar: 7},                                                                                      // 1913
                  $setOnInsert: {name: 'Fred', foo: 2}},                                                               // 1914
                 {multi: true}, next7);                                                                                // 1915
        };                                                                                                             // 1916
                                                                                                                       // 1917
        var result7;                                                                                                   // 1918
        var next7 = function (err, result) {                                                                           // 1919
          result7 = result;                                                                                            // 1920
          test.equal(result7.numberAffected, 1);                                                                       // 1921
          if (! useUpdate)                                                                                             // 1922
            test.isFalse(result7.insertedId);                                                                          // 1923
          compareResults(test, useUpdate, coll.find().fetch(), [{_id: 'David', foo: 2},                                // 1924
                                                                {_id: 'Emily', foo: 2, bar: 7}]);                      // 1925
                                                                                                                       // 1926
          // insert by multi upsert                                                                                    // 1927
          upsert(coll, useUpdate, {_id: 'Fred'},                                                                       // 1928
                 {$set: {bar: 7},                                                                                      // 1929
                  $setOnInsert: {name: 'Fred', foo: 2}},                                                               // 1930
                 {multi: true}, next8);                                                                                // 1931
                                                                                                                       // 1932
        };                                                                                                             // 1933
                                                                                                                       // 1934
        var result8;                                                                                                   // 1935
        var next8 = function (err, result) {                                                                           // 1936
          result8 = result;                                                                                            // 1937
                                                                                                                       // 1938
          test.equal(result8.numberAffected, 1);                                                                       // 1939
          if (! useUpdate) {                                                                                           // 1940
            test.isTrue(result8.insertedId);                                                                           // 1941
            test.equal(result8.insertedId, 'Fred');                                                                    // 1942
          }                                                                                                            // 1943
          var fredId = result8.insertedId;                                                                             // 1944
          compareResults(test, useUpdate,  coll.find().fetch(),                                                        // 1945
                         [{_id: 'David', foo: 2},                                                                      // 1946
                          {_id: 'Emily', foo: 2, bar: 7},                                                              // 1947
                          {name: 'Fred', foo: 2, bar: 7, _id: fredId}]);                                               // 1948
          onComplete();                                                                                                // 1949
        };                                                                                                             // 1950
      });                                                                                                              // 1951
    });                                                                                                                // 1952
  });                                                                                                                  // 1953
});                                                                                                                    // 1954
                                                                                                                       // 1955
if (Meteor.isClient) {                                                                                                 // 1956
  Tinytest.addAsync("mongo-livedata - async update/remove return values over network " + idGeneration, function (test, onComplete) {
    var coll;                                                                                                          // 1958
    var run = test.runId();                                                                                            // 1959
    var collName = "livedata_upsert_collection_"+run;                                                                  // 1960
    Meteor.call("createInsecureCollection", collName, collectionOptions);                                              // 1961
    coll = new Meteor.Collection(collName, collectionOptions);                                                         // 1962
    Meteor.subscribe("c-" + collName, function () {                                                                    // 1963
      coll.insert({ _id: "foo" });                                                                                     // 1964
      coll.insert({ _id: "bar" });                                                                                     // 1965
      coll.update({ _id: "foo" }, { $set: { foo: 1 } }, { multi: true }, function (err, result) {                      // 1966
        test.isFalse(err);                                                                                             // 1967
        test.equal(result, 1);                                                                                         // 1968
        coll.update({ _id: "foo" }, { _id: "foo", foo: 2 }, function (err, result) {                                   // 1969
          test.isFalse(err);                                                                                           // 1970
          test.equal(result, 1);                                                                                       // 1971
          coll.update({ _id: "baz" }, { $set: { foo: 1 } }, function (err, result) {                                   // 1972
            test.isFalse(err);                                                                                         // 1973
            test.equal(result, 0);                                                                                     // 1974
            coll.remove({ _id: "foo" }, function (err, result) {                                                       // 1975
              test.equal(result, 1);                                                                                   // 1976
              coll.remove({ _id: "baz" }, function (err, result) {                                                     // 1977
                test.equal(result, 0);                                                                                 // 1978
                onComplete();                                                                                          // 1979
              });                                                                                                      // 1980
            });                                                                                                        // 1981
          });                                                                                                          // 1982
        });                                                                                                            // 1983
      });                                                                                                              // 1984
    });                                                                                                                // 1985
  });                                                                                                                  // 1986
}                                                                                                                      // 1987
                                                                                                                       // 1988
// Runs a method and its stub which do some upserts. The method throws an error                                        // 1989
// if we don't get the right return values.                                                                            // 1990
if (Meteor.isClient) {                                                                                                 // 1991
  _.each([true, false], function (useUpdate) {                                                                         // 1992
    Tinytest.addAsync("mongo-livedata - " + (useUpdate ? "update " : "") + "upsert in method, " + idGeneration, function (test, onComplete) {
      var run = test.runId();                                                                                          // 1994
      upsertTestMethodColl = new Meteor.Collection(upsertTestMethod + "_collection_" + run, collectionOptions);        // 1995
      var m = {};                                                                                                      // 1996
      delete Meteor.connection._methodHandlers[upsertTestMethod];                                                      // 1997
      m[upsertTestMethod] = function (run, useUpdate, options) {                                                       // 1998
        upsertTestMethodImpl(upsertTestMethodColl, useUpdate, test);                                                   // 1999
      };                                                                                                               // 2000
      Meteor.methods(m);                                                                                               // 2001
      Meteor.call(upsertTestMethod, run, useUpdate, collectionOptions, function (err, result) {                        // 2002
        test.isFalse(err);                                                                                             // 2003
        onComplete();                                                                                                  // 2004
      });                                                                                                              // 2005
    });                                                                                                                // 2006
  });                                                                                                                  // 2007
}                                                                                                                      // 2008
                                                                                                                       // 2009
_.each(Meteor.isServer ? [true, false] : [true], function (minimongo) {                                                // 2010
  _.each([true, false], function (useUpdate) {                                                                         // 2011
    Tinytest.add("mongo-livedata - " + (useUpdate ? "update " : "") + "upsert by id" + (minimongo ? " minimongo" : "") + ", " + idGeneration, function (test) {
      var run = test.runId();                                                                                          // 2013
      var options = collectionOptions;                                                                                 // 2014
      if (minimongo)                                                                                                   // 2015
        options = _.extend({}, collectionOptions, { connection: null });                                               // 2016
      var coll = new Meteor.Collection("livedata_upsert_by_id_collection_"+run, options);                              // 2017
                                                                                                                       // 2018
      var ret;                                                                                                         // 2019
      ret = upsert(coll, useUpdate, {_id: 'foo'}, {$set: {x: 1}});                                                     // 2020
      test.equal(ret.numberAffected, 1);                                                                               // 2021
      if (! useUpdate)                                                                                                 // 2022
        test.equal(ret.insertedId, 'foo');                                                                             // 2023
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2024
                     [{_id: 'foo', x: 1}]);                                                                            // 2025
                                                                                                                       // 2026
      ret = upsert(coll, useUpdate, {_id: 'foo'}, {$set: {x: 2}});                                                     // 2027
      test.equal(ret.numberAffected, 1);                                                                               // 2028
      if (! useUpdate)                                                                                                 // 2029
        test.isFalse(ret.insertedId);                                                                                  // 2030
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2031
                     [{_id: 'foo', x: 2}]);                                                                            // 2032
                                                                                                                       // 2033
      ret = upsert(coll, useUpdate, {_id: 'bar'}, {$set: {x: 1}});                                                     // 2034
      test.equal(ret.numberAffected, 1);                                                                               // 2035
      if (! useUpdate)                                                                                                 // 2036
        test.equal(ret.insertedId, 'bar');                                                                             // 2037
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2038
                     [{_id: 'foo', x: 2},                                                                              // 2039
                      {_id: 'bar', x: 1}]);                                                                            // 2040
                                                                                                                       // 2041
      coll.remove({});                                                                                                 // 2042
                                                                                                                       // 2043
      ret = upsert(coll, useUpdate, {_id: 'traz'}, {x: 1});                                                            // 2044
      test.equal(ret.numberAffected, 1);                                                                               // 2045
      var myId = ret.insertedId;                                                                                       // 2046
      if (! useUpdate) {                                                                                               // 2047
        test.isTrue(myId);                                                                                             // 2048
        // upsert with entire document does NOT take _id from                                                          // 2049
        // the query.                                                                                                  // 2050
        test.notEqual(myId, 'traz');                                                                                   // 2051
      } else {                                                                                                         // 2052
        myId = coll.findOne()._id;                                                                                     // 2053
      }                                                                                                                // 2054
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2055
                     [{x: 1, _id: myId}]);                                                                             // 2056
                                                                                                                       // 2057
      // this time, insert as _id 'traz'                                                                               // 2058
      ret = upsert(coll, useUpdate, {_id: 'traz'}, {_id: 'traz', x: 2});                                               // 2059
      test.equal(ret.numberAffected, 1);                                                                               // 2060
      if (! useUpdate)                                                                                                 // 2061
        test.equal(ret.insertedId, 'traz');                                                                            // 2062
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2063
                     [{x: 1, _id: myId},                                                                               // 2064
                      {x: 2, _id: 'traz'}]);                                                                           // 2065
                                                                                                                       // 2066
      // now update _id 'traz'                                                                                         // 2067
      ret = upsert(coll, useUpdate, {_id: 'traz'}, {x: 3});                                                            // 2068
      test.equal(ret.numberAffected, 1);                                                                               // 2069
      test.isFalse(ret.insertedId);                                                                                    // 2070
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2071
                     [{x: 1, _id: myId},                                                                               // 2072
                      {x: 3, _id: 'traz'}]);                                                                           // 2073
                                                                                                                       // 2074
      // now update, passing _id (which is ok as long as it's the same)                                                // 2075
      ret = upsert(coll, useUpdate, {_id: 'traz'}, {_id: 'traz', x: 4});                                               // 2076
      test.equal(ret.numberAffected, 1);                                                                               // 2077
      test.isFalse(ret.insertedId);                                                                                    // 2078
      compareResults(test, useUpdate, coll.find().fetch(),                                                             // 2079
                     [{x: 1, _id: myId},                                                                               // 2080
                      {x: 4, _id: 'traz'}]);                                                                           // 2081
                                                                                                                       // 2082
    });                                                                                                                // 2083
  });                                                                                                                  // 2084
});                                                                                                                    // 2085
                                                                                                                       // 2086
});  // end idGeneration parametrization                                                                               // 2087
                                                                                                                       // 2088
Tinytest.add('mongo-livedata - rewrite selector', function (test) {                                                    // 2089
  test.equal(Meteor.Collection._rewriteSelector({x: /^o+B/im}),                                                        // 2090
             {x: {$regex: '^o+B', $options: 'im'}});                                                                   // 2091
  test.equal(Meteor.Collection._rewriteSelector({x: {$regex: /^o+B/im}}),                                              // 2092
             {x: {$regex: '^o+B', $options: 'im'}});                                                                   // 2093
  test.equal(Meteor.Collection._rewriteSelector({x: /^o+B/}),                                                          // 2094
             {x: {$regex: '^o+B'}});                                                                                   // 2095
  test.equal(Meteor.Collection._rewriteSelector({x: {$regex: /^o+B/}}),                                                // 2096
             {x: {$regex: '^o+B'}});                                                                                   // 2097
  test.equal(Meteor.Collection._rewriteSelector('foo'),                                                                // 2098
             {_id: 'foo'});                                                                                            // 2099
                                                                                                                       // 2100
  test.equal(                                                                                                          // 2101
    Meteor.Collection._rewriteSelector(                                                                                // 2102
      {'$or': [                                                                                                        // 2103
        {x: /^o/},                                                                                                     // 2104
        {y: /^p/},                                                                                                     // 2105
        {z: 'q'},                                                                                                      // 2106
        {w: {$regex: /^r/}}                                                                                            // 2107
      ]}                                                                                                               // 2108
    ),                                                                                                                 // 2109
    {'$or': [                                                                                                          // 2110
      {x: {$regex: '^o'}},                                                                                             // 2111
      {y: {$regex: '^p'}},                                                                                             // 2112
      {z: 'q'},                                                                                                        // 2113
      {w: {$regex: '^r'}}                                                                                              // 2114
    ]}                                                                                                                 // 2115
  );                                                                                                                   // 2116
                                                                                                                       // 2117
  test.equal(                                                                                                          // 2118
    Meteor.Collection._rewriteSelector(                                                                                // 2119
      {'$or': [                                                                                                        // 2120
        {'$and': [                                                                                                     // 2121
          {x: /^a/i},                                                                                                  // 2122
          {y: /^b/},                                                                                                   // 2123
          {z: {$regex: /^c/i}},                                                                                        // 2124
          {w: {$regex: '^[abc]', $options: 'i'}}, // make sure we don't break vanilla selectors                        // 2125
          {v: {$regex: /O/, $options: 'i'}}, // $options should override the ones on the RegExp object                 // 2126
          {u: {$regex: /O/m, $options: 'i'}} // $options should override the ones on the RegExp object                 // 2127
        ]},                                                                                                            // 2128
        {'$nor': [                                                                                                     // 2129
          {s: /^d/},                                                                                                   // 2130
          {t: /^e/i},                                                                                                  // 2131
          {u: {$regex: /^f/i}},                                                                                        // 2132
          // even empty string overrides built-in flags                                                                // 2133
          {v: {$regex: /^g/i, $options: ''}}                                                                           // 2134
        ]}                                                                                                             // 2135
      ]}                                                                                                               // 2136
    ),                                                                                                                 // 2137
    {'$or': [                                                                                                          // 2138
      {'$and': [                                                                                                       // 2139
        {x: {$regex: '^a', $options: 'i'}},                                                                            // 2140
        {y: {$regex: '^b'}},                                                                                           // 2141
        {z: {$regex: '^c', $options: 'i'}},                                                                            // 2142
        {w: {$regex: '^[abc]', $options: 'i'}},                                                                        // 2143
        {v: {$regex: 'O', $options: 'i'}},                                                                             // 2144
        {u: {$regex: 'O', $options: 'i'}}                                                                              // 2145
      ]},                                                                                                              // 2146
      {'$nor': [                                                                                                       // 2147
        {s: {$regex: '^d'}},                                                                                           // 2148
        {t: {$regex: '^e', $options: 'i'}},                                                                            // 2149
        {u: {$regex: '^f', $options: 'i'}},                                                                            // 2150
        {v: {$regex: '^g', $options: ''}}                                                                              // 2151
      ]}                                                                                                               // 2152
    ]}                                                                                                                 // 2153
  );                                                                                                                   // 2154
                                                                                                                       // 2155
  var oid = new Meteor.Collection.ObjectID();                                                                          // 2156
  test.equal(Meteor.Collection._rewriteSelector(oid),                                                                  // 2157
             {_id: oid});                                                                                              // 2158
});                                                                                                                    // 2159
                                                                                                                       // 2160
testAsyncMulti('mongo-livedata - specified _id', [                                                                     // 2161
  function (test, expect) {                                                                                            // 2162
    this.collectionName = Random.id();                                                                                 // 2163
    if (Meteor.isClient) {                                                                                             // 2164
      Meteor.call('createInsecureCollection', this.collectionName);                                                    // 2165
      Meteor.subscribe('c-' + this.collectionName, expect());                                                          // 2166
    }                                                                                                                  // 2167
  }, function (test, expect) {                                                                                         // 2168
    var expectError = expect(function (err, result) {                                                                  // 2169
      test.isTrue(err);                                                                                                // 2170
      var doc = coll.findOne();                                                                                        // 2171
      test.equal(doc.name, "foo");                                                                                     // 2172
    });                                                                                                                // 2173
    var coll = new Meteor.Collection(this.collectionName);                                                             // 2174
    coll.insert({_id: "foo", name: "foo"}, expect(function (err1, id) {                                                // 2175
      test.equal(id, "foo");                                                                                           // 2176
      var doc = coll.findOne();                                                                                        // 2177
      test.equal(doc._id, "foo");                                                                                      // 2178
      Meteor._suppress_log(1);                                                                                         // 2179
      coll.insert({_id: "foo", name: "bar"}, expectError);                                                             // 2180
    }));                                                                                                               // 2181
  }                                                                                                                    // 2182
]);                                                                                                                    // 2183
                                                                                                                       // 2184
                                                                                                                       // 2185
// Consistent id generation tests                                                                                      // 2186
function collectionInsert (test, expect, coll, index) {                                                                // 2187
  var clientSideId = coll.insert({name: "foo"}, expect(function (err1, id) {                                           // 2188
    test.equal(id, clientSideId);                                                                                      // 2189
    var o = coll.findOne(id);                                                                                          // 2190
    test.isTrue(_.isObject(o));                                                                                        // 2191
    test.equal(o.name, 'foo');                                                                                         // 2192
  }));                                                                                                                 // 2193
};                                                                                                                     // 2194
                                                                                                                       // 2195
function collectionUpsert (test, expect, coll, index) {                                                                // 2196
  var upsertId = '123456' + index;                                                                                     // 2197
                                                                                                                       // 2198
  coll.upsert(upsertId, {$set: {name: "foo"}}, expect(function (err1, result) {                                        // 2199
    test.equal(result.insertedId, upsertId);                                                                           // 2200
    test.equal(result.numberAffected, 1);                                                                              // 2201
                                                                                                                       // 2202
    var o = coll.findOne(upsertId);                                                                                    // 2203
    test.isTrue(_.isObject(o));                                                                                        // 2204
    test.equal(o.name, 'foo');                                                                                         // 2205
  }));                                                                                                                 // 2206
};                                                                                                                     // 2207
                                                                                                                       // 2208
function collectionUpsertExisting (test, expect, coll, index) {                                                        // 2209
  var clientSideId = coll.insert({name: "foo"}, expect(function (err1, id) {                                           // 2210
    test.equal(id, clientSideId);                                                                                      // 2211
                                                                                                                       // 2212
    var o = coll.findOne(id);                                                                                          // 2213
    test.isTrue(_.isObject(o));                                                                                        // 2214
    // We're not testing sequencing/visibility rules here, so skip this check                                          // 2215
    // test.equal(o.name, 'foo');                                                                                      // 2216
  }));                                                                                                                 // 2217
                                                                                                                       // 2218
  coll.upsert(clientSideId, {$set: {name: "bar"}}, expect(function (err1, result) {                                    // 2219
    test.equal(result.insertedId, clientSideId);                                                                       // 2220
    test.equal(result.numberAffected, 1);                                                                              // 2221
                                                                                                                       // 2222
    var o = coll.findOne(clientSideId);                                                                                // 2223
    test.isTrue(_.isObject(o));                                                                                        // 2224
    test.equal(o.name, 'bar');                                                                                         // 2225
  }));                                                                                                                 // 2226
};                                                                                                                     // 2227
                                                                                                                       // 2228
function functionCallsInsert (test, expect, coll, index) {                                                             // 2229
  Meteor.call("insertObjects", coll._name, {name: "foo"}, 1, expect(function (err1, ids) {                             // 2230
    test.notEqual((INSERTED_IDS[coll._name] || []).length, 0);                                                         // 2231
    var stubId = INSERTED_IDS[coll._name][index];                                                                      // 2232
                                                                                                                       // 2233
    test.equal(ids.length, 1);                                                                                         // 2234
    test.equal(ids[0], stubId);                                                                                        // 2235
                                                                                                                       // 2236
    var o = coll.findOne(stubId);                                                                                      // 2237
    test.isTrue(_.isObject(o));                                                                                        // 2238
    test.equal(o.name, 'foo');                                                                                         // 2239
  }));                                                                                                                 // 2240
};                                                                                                                     // 2241
                                                                                                                       // 2242
function functionCallsUpsert (test, expect, coll, index) {                                                             // 2243
  var upsertId = '123456' + index;                                                                                     // 2244
  Meteor.call("upsertObject", coll._name, upsertId, {$set:{name: "foo"}}, expect(function (err1, result) {             // 2245
    test.equal(result.insertedId, upsertId);                                                                           // 2246
    test.equal(result.numberAffected, 1);                                                                              // 2247
                                                                                                                       // 2248
    var o = coll.findOne(upsertId);                                                                                    // 2249
    test.isTrue(_.isObject(o));                                                                                        // 2250
    test.equal(o.name, 'foo');                                                                                         // 2251
  }));                                                                                                                 // 2252
};                                                                                                                     // 2253
                                                                                                                       // 2254
function functionCallsUpsertExisting (test, expect, coll, index) {                                                     // 2255
  var id = coll.insert({name: "foo"});                                                                                 // 2256
                                                                                                                       // 2257
  var o = coll.findOne(id);                                                                                            // 2258
  test.notEqual(null, o);                                                                                              // 2259
  test.equal(o.name, 'foo');                                                                                           // 2260
                                                                                                                       // 2261
  Meteor.call("upsertObject", coll._name, id, {$set:{name: "bar"}}, expect(function (err1, result) {                   // 2262
    test.equal(result.numberAffected, 1);                                                                              // 2263
    test.equal(result.insertedId, undefined);                                                                          // 2264
                                                                                                                       // 2265
    var o = coll.findOne(id);                                                                                          // 2266
    test.isTrue(_.isObject(o));                                                                                        // 2267
    test.equal(o.name, 'bar');                                                                                         // 2268
  }));                                                                                                                 // 2269
};                                                                                                                     // 2270
                                                                                                                       // 2271
function functionCalls3Inserts (test, expect, coll, index) {                                                           // 2272
  Meteor.call("insertObjects", coll._name, {name: "foo"}, 3, expect(function (err1, ids) {                             // 2273
    test.notEqual((INSERTED_IDS[coll._name] || []).length, 0);                                                         // 2274
    test.equal(ids.length, 3);                                                                                         // 2275
                                                                                                                       // 2276
    for (var i = 0; i < 3; i++) {                                                                                      // 2277
      var stubId = INSERTED_IDS[coll._name][(3 * index) + i];                                                          // 2278
      test.equal(ids[i], stubId);                                                                                      // 2279
                                                                                                                       // 2280
      var o = coll.findOne(stubId);                                                                                    // 2281
      test.isTrue(_.isObject(o));                                                                                      // 2282
      test.equal(o.name, 'foo');                                                                                       // 2283
    }                                                                                                                  // 2284
  }));                                                                                                                 // 2285
};                                                                                                                     // 2286
                                                                                                                       // 2287
function functionChainInsert (test, expect, coll, index) {                                                             // 2288
  Meteor.call("doMeteorCall", "insertObjects", coll._name, {name: "foo"}, 1, expect(function (err1, ids) {             // 2289
    test.notEqual((INSERTED_IDS[coll._name] || []).length, 0);                                                         // 2290
    var stubId = INSERTED_IDS[coll._name][index];                                                                      // 2291
                                                                                                                       // 2292
    test.equal(ids.length, 1);                                                                                         // 2293
    test.equal(ids[0], stubId);                                                                                        // 2294
                                                                                                                       // 2295
    var o = coll.findOne(stubId);                                                                                      // 2296
    test.isTrue(_.isObject(o));                                                                                        // 2297
    test.equal(o.name, 'foo');                                                                                         // 2298
  }));                                                                                                                 // 2299
};                                                                                                                     // 2300
                                                                                                                       // 2301
function functionChain2Insert (test, expect, coll, index) {                                                            // 2302
  Meteor.call("doMeteorCall", "doMeteorCall", "insertObjects", coll._name, {name: "foo"}, 1, expect(function (err1, ids) {
    test.notEqual((INSERTED_IDS[coll._name] || []).length, 0);                                                         // 2304
    var stubId = INSERTED_IDS[coll._name][index];                                                                      // 2305
                                                                                                                       // 2306
    test.equal(ids.length, 1);                                                                                         // 2307
    test.equal(ids[0], stubId);                                                                                        // 2308
                                                                                                                       // 2309
    var o = coll.findOne(stubId);                                                                                      // 2310
    test.isTrue(_.isObject(o));                                                                                        // 2311
    test.equal(o.name, 'foo');                                                                                         // 2312
  }));                                                                                                                 // 2313
};                                                                                                                     // 2314
                                                                                                                       // 2315
function functionChain2Upsert (test, expect, coll, index) {                                                            // 2316
  var upsertId = '123456' + index;                                                                                     // 2317
  Meteor.call("doMeteorCall", "doMeteorCall", "upsertObject", coll._name, upsertId, {$set:{name: "foo"}}, expect(function (err1, result) {
    test.equal(result.insertedId, upsertId);                                                                           // 2319
    test.equal(result.numberAffected, 1);                                                                              // 2320
                                                                                                                       // 2321
    var o = coll.findOne(upsertId);                                                                                    // 2322
    test.isTrue(_.isObject(o));                                                                                        // 2323
    test.equal(o.name, 'foo');                                                                                         // 2324
  }));                                                                                                                 // 2325
};                                                                                                                     // 2326
                                                                                                                       // 2327
_.each( {collectionInsert: collectionInsert,                                                                           // 2328
         collectionUpsert: collectionUpsert,                                                                           // 2329
         functionCallsInsert: functionCallsInsert,                                                                     // 2330
         functionCallsUpsert: functionCallsUpsert,                                                                     // 2331
         functionCallsUpsertExisting: functionCallsUpsertExisting,                                                     // 2332
         functionCalls3Insert: functionCalls3Inserts,                                                                  // 2333
         functionChainInsert: functionChainInsert,                                                                     // 2334
         functionChain2Insert: functionChain2Insert,                                                                   // 2335
         functionChain2Upsert: functionChain2Upsert}, function (fn, name) {                                            // 2336
_.each( [1, 3], function (repetitions) {                                                                               // 2337
_.each( [1, 3], function (collectionCount) {                                                                           // 2338
_.each( ['STRING', 'MONGO'], function (idGeneration) {                                                                 // 2339
                                                                                                                       // 2340
  testAsyncMulti('mongo-livedata - consistent _id generation ' + name + ', ' + repetitions + ' repetitions on ' + collectionCount + ' collections, idGeneration=' + idGeneration, [ function (test, expect) {
    var collectionOptions = { idGeneration: idGeneration };                                                            // 2342
                                                                                                                       // 2343
    var cleanups = this.cleanups = [];                                                                                 // 2344
    this.collections = _.times(collectionCount, function () {                                                          // 2345
      var collectionName = "consistentid_" + Random.id();                                                              // 2346
      if (Meteor.isClient) {                                                                                           // 2347
        Meteor.call('createInsecureCollection', collectionName, collectionOptions);                                    // 2348
        Meteor.subscribe('c-' + collectionName, expect());                                                             // 2349
        cleanups.push(function (expect) { Meteor.call('dropInsecureCollection', collectionName, expect(function () {})); });
      }                                                                                                                // 2351
                                                                                                                       // 2352
      var collection = new Meteor.Collection(collectionName, collectionOptions);                                       // 2353
      if (Meteor.isServer) {                                                                                           // 2354
        cleanups.push(function () { collection._dropCollection(); });                                                  // 2355
      }                                                                                                                // 2356
      COLLECTIONS[collectionName] = collection;                                                                        // 2357
      return collection;                                                                                               // 2358
    });                                                                                                                // 2359
  }, function (test, expect) {                                                                                         // 2360
    // now run the actual test                                                                                         // 2361
    for (var i = 0; i < repetitions; i++) {                                                                            // 2362
      for (var j = 0; j < collectionCount; j++) {                                                                      // 2363
        fn(test, expect, this.collections[j], i);                                                                      // 2364
      }                                                                                                                // 2365
    }                                                                                                                  // 2366
  }, function (test, expect) {                                                                                         // 2367
    // Run any registered cleanup functions (e.g. to drop collections)                                                 // 2368
    _.each(this.cleanups, function(cleanup) {                                                                          // 2369
      cleanup(expect);                                                                                                 // 2370
    });                                                                                                                // 2371
  }]);                                                                                                                 // 2372
                                                                                                                       // 2373
});                                                                                                                    // 2374
});                                                                                                                    // 2375
});                                                                                                                    // 2376
});                                                                                                                    // 2377
                                                                                                                       // 2378
                                                                                                                       // 2379
                                                                                                                       // 2380
testAsyncMulti('mongo-livedata - empty string _id', [                                                                  // 2381
  function (test, expect) {                                                                                            // 2382
    var self = this;                                                                                                   // 2383
    self.collectionName = Random.id();                                                                                 // 2384
    if (Meteor.isClient) {                                                                                             // 2385
      Meteor.call('createInsecureCollection', self.collectionName);                                                    // 2386
      Meteor.subscribe('c-' + self.collectionName, expect());                                                          // 2387
    }                                                                                                                  // 2388
    self.coll = new Meteor.Collection(self.collectionName);                                                            // 2389
    try {                                                                                                              // 2390
      self.coll.insert({_id: "", f: "foo"});                                                                           // 2391
      test.fail("Insert with an empty _id should fail");                                                               // 2392
    } catch (e) {                                                                                                      // 2393
      // ok                                                                                                            // 2394
    }                                                                                                                  // 2395
    self.coll.insert({_id: "realid", f: "bar"}, expect(function (err, res) {                                           // 2396
      test.equal(res, "realid");                                                                                       // 2397
    }));                                                                                                               // 2398
  },                                                                                                                   // 2399
  function (test, expect) {                                                                                            // 2400
    var self = this;                                                                                                   // 2401
    var docs = self.coll.find().fetch();                                                                               // 2402
    test.equal(docs, [{_id: "realid", f: "bar"}]);                                                                     // 2403
  },                                                                                                                   // 2404
  function (test, expect) {                                                                                            // 2405
    var self = this;                                                                                                   // 2406
    if (Meteor.isServer) {                                                                                             // 2407
      self.coll._collection.insert({_id: "", f: "baz"});                                                               // 2408
      test.equal(self.coll.find().fetch().length, 2);                                                                  // 2409
    }                                                                                                                  // 2410
  }                                                                                                                    // 2411
]);                                                                                                                    // 2412
                                                                                                                       // 2413
                                                                                                                       // 2414
if (Meteor.isServer) {                                                                                                 // 2415
                                                                                                                       // 2416
  testAsyncMulti("mongo-livedata - minimongo on server to server connection", [                                        // 2417
    function (test, expect) {                                                                                          // 2418
      var self = this;                                                                                                 // 2419
      Meteor._debug("connection setup");                                                                               // 2420
      self.id = Random.id();                                                                                           // 2421
      var C = self.C = new Meteor.Collection("ServerMinimongo_" + self.id);                                            // 2422
      C.allow({                                                                                                        // 2423
        insert: function () {return true;},                                                                            // 2424
        update: function () {return true;},                                                                            // 2425
        remove: function () {return true;}                                                                             // 2426
      });                                                                                                              // 2427
      C.insert({a: 0, b: 1});                                                                                          // 2428
      C.insert({a: 0, b: 2});                                                                                          // 2429
      C.insert({a: 1, b: 3});                                                                                          // 2430
      Meteor.publish(self.id, function () {                                                                            // 2431
        return C.find({a: 0});                                                                                         // 2432
      });                                                                                                              // 2433
                                                                                                                       // 2434
      self.conn = DDP.connect(Meteor.absoluteUrl());                                                                   // 2435
      pollUntil(expect, function () {                                                                                  // 2436
        return self.conn.status().connected;                                                                           // 2437
      }, 10000);                                                                                                       // 2438
    },                                                                                                                 // 2439
                                                                                                                       // 2440
    function (test, expect) {                                                                                          // 2441
      var self = this;                                                                                                 // 2442
      if (self.conn.status().connected) {                                                                              // 2443
        self.miniC = new Meteor.Collection("ServerMinimongo_" + self.id, {                                             // 2444
          connection: self.conn                                                                                        // 2445
        });                                                                                                            // 2446
        var exp = expect(function (err) {                                                                              // 2447
          test.isFalse(err);                                                                                           // 2448
        });                                                                                                            // 2449
        self.conn.subscribe(self.id, {                                                                                 // 2450
          onError: exp,                                                                                                // 2451
          onReady: exp                                                                                                 // 2452
        });                                                                                                            // 2453
      }                                                                                                                // 2454
    },                                                                                                                 // 2455
                                                                                                                       // 2456
    function (test, expect) {                                                                                          // 2457
      var self = this;                                                                                                 // 2458
      if (self.miniC) {                                                                                                // 2459
        var contents = self.miniC.find().fetch();                                                                      // 2460
        test.equal(contents.length, 2);                                                                                // 2461
        test.equal(contents[0].a, 0);                                                                                  // 2462
      }                                                                                                                // 2463
    },                                                                                                                 // 2464
                                                                                                                       // 2465
    function (test, expect) {                                                                                          // 2466
      var self = this;                                                                                                 // 2467
      if (!self.miniC)                                                                                                 // 2468
        return;                                                                                                        // 2469
      self.miniC.insert({a:0, b:3});                                                                                   // 2470
      var contents = self.miniC.find({b:3}).fetch();                                                                   // 2471
      test.equal(contents.length, 1);                                                                                  // 2472
      test.equal(contents[0].a, 0);                                                                                    // 2473
    }                                                                                                                  // 2474
  ]);                                                                                                                  // 2475
                                                                                                                       // 2476
  testAsyncMulti("mongo-livedata - minimongo observe on server", [                                                     // 2477
    function (test, expect) {                                                                                          // 2478
      var self = this;                                                                                                 // 2479
      self.id = Random.id();                                                                                           // 2480
      self.C = new Meteor.Collection("ServerMinimongoObserve_" + self.id);                                             // 2481
      self.events = [];                                                                                                // 2482
                                                                                                                       // 2483
      Meteor.publish(self.id, function () {                                                                            // 2484
        return self.C.find();                                                                                          // 2485
      });                                                                                                              // 2486
                                                                                                                       // 2487
      self.conn = DDP.connect(Meteor.absoluteUrl());                                                                   // 2488
      pollUntil(expect, function () {                                                                                  // 2489
        return self.conn.status().connected;                                                                           // 2490
      }, 10000);                                                                                                       // 2491
    },                                                                                                                 // 2492
                                                                                                                       // 2493
    function (test, expect) {                                                                                          // 2494
      var self = this;                                                                                                 // 2495
      if (self.conn.status().connected) {                                                                              // 2496
        self.miniC = new Meteor.Collection("ServerMinimongoObserve_" + self.id, {                                      // 2497
          connection: self.conn                                                                                        // 2498
        });                                                                                                            // 2499
        var exp = expect(function (err) {                                                                              // 2500
          test.isFalse(err);                                                                                           // 2501
        });                                                                                                            // 2502
        self.conn.subscribe(self.id, {                                                                                 // 2503
          onError: exp,                                                                                                // 2504
          onReady: exp                                                                                                 // 2505
        });                                                                                                            // 2506
      }                                                                                                                // 2507
    },                                                                                                                 // 2508
                                                                                                                       // 2509
    function (test, expect) {                                                                                          // 2510
      var self = this;                                                                                                 // 2511
      if (self.miniC) {                                                                                                // 2512
        self.obs = self.miniC.find().observeChanges({                                                                  // 2513
          added: function (id, fields) {                                                                               // 2514
            self.events.push({evt: "a", id: id});                                                                      // 2515
            Meteor._sleepForMs(200);                                                                                   // 2516
            self.events.push({evt: "b", id: id});                                                                      // 2517
          }                                                                                                            // 2518
        });                                                                                                            // 2519
        self.one = self.C.insert({});                                                                                  // 2520
        self.two = self.C.insert({});                                                                                  // 2521
        pollUntil(expect, function () {                                                                                // 2522
          return self.events.length === 4;                                                                             // 2523
        }, 10000);                                                                                                     // 2524
      }                                                                                                                // 2525
    },                                                                                                                 // 2526
                                                                                                                       // 2527
    function (test, expect) {                                                                                          // 2528
      var self = this;                                                                                                 // 2529
      if (self.miniC) {                                                                                                // 2530
        test.equal(self.events, [                                                                                      // 2531
          {evt: "a", id: self.one},                                                                                    // 2532
          {evt: "b", id: self.one},                                                                                    // 2533
          {evt: "a", id: self.two},                                                                                    // 2534
          {evt: "b", id: self.two}                                                                                     // 2535
        ]);                                                                                                            // 2536
      }                                                                                                                // 2537
      self.obs && self.obs.stop();                                                                                     // 2538
    }                                                                                                                  // 2539
  ]);                                                                                                                  // 2540
}                                                                                                                      // 2541
                                                                                                                       // 2542
Tinytest.addAsync("mongo-livedata - local collections with different connections", function (test, onComplete) {       // 2543
  var cname = Random.id();                                                                                             // 2544
  var cname2 = Random.id();                                                                                            // 2545
  var coll1 = new Meteor.Collection(cname);                                                                            // 2546
  var doc = { foo: "bar" };                                                                                            // 2547
  var coll2 = new Meteor.Collection(cname2, { connection: null });                                                     // 2548
  coll2.insert(doc, function (err, id) {                                                                               // 2549
    test.equal(coll1.find(doc).count(), 0);                                                                            // 2550
    test.equal(coll2.find(doc).count(), 1);                                                                            // 2551
    onComplete();                                                                                                      // 2552
  });                                                                                                                  // 2553
});                                                                                                                    // 2554
                                                                                                                       // 2555
Tinytest.addAsync("mongo-livedata - local collection with null connection, w/ callback", function (test, onComplete) { // 2556
  var cname = Random.id();                                                                                             // 2557
  var coll1 = new Meteor.Collection(cname, { connection: null });                                                      // 2558
  var doc = { foo: "bar" };                                                                                            // 2559
  var docId = coll1.insert(doc, function (err, id) {                                                                   // 2560
    test.equal(docId, id);                                                                                             // 2561
    test.equal(coll1.findOne(doc)._id, id);                                                                            // 2562
    onComplete();                                                                                                      // 2563
  });                                                                                                                  // 2564
});                                                                                                                    // 2565
                                                                                                                       // 2566
Tinytest.addAsync("mongo-livedata - local collection with null connection, w/o callback", function (test, onComplete) {
  var cname = Random.id();                                                                                             // 2568
  var coll1 = new Meteor.Collection(cname, { connection: null });                                                      // 2569
  var doc = { foo: "bar" };                                                                                            // 2570
  var docId = coll1.insert(doc);                                                                                       // 2571
  test.equal(coll1.findOne(doc)._id, docId);                                                                           // 2572
  onComplete();                                                                                                        // 2573
});                                                                                                                    // 2574
                                                                                                                       // 2575
testAsyncMulti("mongo-livedata - update handles $push with $each correctly", [                                         // 2576
  function (test, expect) {                                                                                            // 2577
    var self = this;                                                                                                   // 2578
    var collectionName = Random.id();                                                                                  // 2579
    if (Meteor.isClient) {                                                                                             // 2580
      Meteor.call('createInsecureCollection', collectionName);                                                         // 2581
      Meteor.subscribe('c-' + collectionName, expect());                                                               // 2582
    }                                                                                                                  // 2583
                                                                                                                       // 2584
    self.collection = new Meteor.Collection(collectionName);                                                           // 2585
                                                                                                                       // 2586
    self.id = self.collection.insert(                                                                                  // 2587
      {name: 'jens', elements: ['X', 'Y']}, expect(function (err, res) {                                               // 2588
        test.isFalse(err);                                                                                             // 2589
        test.equal(self.id, res);                                                                                      // 2590
        }));                                                                                                           // 2591
  },                                                                                                                   // 2592
  function (test, expect) {                                                                                            // 2593
    var self = this;                                                                                                   // 2594
    self.collection.update(self.id, {                                                                                  // 2595
      $push: {                                                                                                         // 2596
        elements: {                                                                                                    // 2597
          $each: ['A', 'B', 'C'],                                                                                      // 2598
          $slice: -4                                                                                                   // 2599
        }}}, expect(function (err, res) {                                                                              // 2600
          test.isFalse(err);                                                                                           // 2601
          test.equal(                                                                                                  // 2602
            self.collection.findOne(self.id),                                                                          // 2603
            {_id: self.id, name: 'jens', elements: ['Y', 'A', 'B', 'C']});                                             // 2604
        }));                                                                                                           // 2605
  }                                                                                                                    // 2606
]);                                                                                                                    // 2607
                                                                                                                       // 2608
if (Meteor.isServer) {                                                                                                 // 2609
  Tinytest.add("mongo-livedata - upsert handles $push with $each correctly", function (test) {                         // 2610
    var collection = new Meteor.Collection(Random.id());                                                               // 2611
                                                                                                                       // 2612
    var result = collection.upsert(                                                                                    // 2613
      {name: 'jens'},                                                                                                  // 2614
      {$push: {                                                                                                        // 2615
        elements: {                                                                                                    // 2616
          $each: ['A', 'B', 'C'],                                                                                      // 2617
          $slice: -4                                                                                                   // 2618
        }}});                                                                                                          // 2619
                                                                                                                       // 2620
    test.equal(collection.findOne(result.insertedId),                                                                  // 2621
               {_id: result.insertedId,                                                                                // 2622
                name: 'jens',                                                                                          // 2623
                elements: ['A', 'B', 'C']});                                                                           // 2624
                                                                                                                       // 2625
    var id = collection.insert({name: "david", elements: ['X', 'Y']});                                                 // 2626
    result = collection.upsert(                                                                                        // 2627
      {name: 'david'},                                                                                                 // 2628
      {$push: {                                                                                                        // 2629
        elements: {                                                                                                    // 2630
          $each: ['A', 'B', 'C'],                                                                                      // 2631
          $slice: -4                                                                                                   // 2632
        }}});                                                                                                          // 2633
                                                                                                                       // 2634
    test.equal(collection.findOne(id),                                                                                 // 2635
               {_id: id,                                                                                               // 2636
                name: 'david',                                                                                         // 2637
                elements: ['Y', 'A', 'B', 'C']});                                                                      // 2638
  });                                                                                                                  // 2639
}                                                                                                                      // 2640
                                                                                                                       // 2641
// This is a VERY white-box test.                                                                                      // 2642
Meteor.isServer && Tinytest.add("mongo-livedata - oplog - _disableOplog", function (test) {                            // 2643
  var collName = Random.id();                                                                                          // 2644
  var coll = new Meteor.Collection(collName);                                                                          // 2645
  if (MongoInternals.defaultRemoteCollectionDriver().mongo._oplogHandle) {                                             // 2646
    var observeWithOplog = coll.find({x: 5})                                                                           // 2647
          .observeChanges({added: function () {}});                                                                    // 2648
    test.isTrue(observeWithOplog._multiplexer._observeDriver._usesOplog);                                              // 2649
    observeWithOplog.stop();                                                                                           // 2650
  }                                                                                                                    // 2651
  var observeWithoutOplog = coll.find({x: 6}, {_disableOplog: true})                                                   // 2652
        .observeChanges({added: function () {}});                                                                      // 2653
  test.isFalse(observeWithoutOplog._multiplexer._observeDriver._usesOplog);                                            // 2654
  observeWithoutOplog.stop();                                                                                          // 2655
});                                                                                                                    // 2656
                                                                                                                       // 2657
Meteor.isServer && Tinytest.add("mongo-livedata - oplog - include selector fields", function (test) {                  // 2658
  var collName = "includeSelector" + Random.id();                                                                      // 2659
  var coll = new Meteor.Collection(collName);                                                                          // 2660
                                                                                                                       // 2661
  var docId = coll.insert({a: 1, b: [3, 2], c: 'foo'});                                                                // 2662
  test.isTrue(docId);                                                                                                  // 2663
                                                                                                                       // 2664
  // Wait until we've processed the insert oplog entry. (If the insert shows up                                        // 2665
  // during the observeChanges, the bug in question is not consistently                                                // 2666
  // reproduced.) We don't have to do this for polling observe (eg                                                     // 2667
  // --disable-oplog).                                                                                                 // 2668
  waitUntilOplogCaughtUp();                                                                                            // 2669
                                                                                                                       // 2670
  var output = [];                                                                                                     // 2671
  var handle = coll.find({a: 1, b: 2}, {fields: {c: 1}}).observeChanges({                                              // 2672
    added: function (id, fields) {                                                                                     // 2673
      output.push(['added', id, fields]);                                                                              // 2674
    },                                                                                                                 // 2675
    changed: function (id, fields) {                                                                                   // 2676
      output.push(['changed', id, fields]);                                                                            // 2677
    },                                                                                                                 // 2678
    removed: function (id) {                                                                                           // 2679
      output.push(['removed', id]);                                                                                    // 2680
    }                                                                                                                  // 2681
  });                                                                                                                  // 2682
  // Initially should match the document.                                                                              // 2683
  test.length(output, 1);                                                                                              // 2684
  test.equal(output.shift(), ['added', docId, {c: 'foo'}]);                                                            // 2685
                                                                                                                       // 2686
  // Update in such a way that, if we only knew about the published field 'c'                                          // 2687
  // and the changed field 'b' (but not the field 'a'), we would think it didn't                                       // 2688
  // match any more.  (This is a regression test for a bug that existed because                                        // 2689
  // we used to not use the shared projection in the initial query.)                                                   // 2690
  runInFence(function () {                                                                                             // 2691
    coll.update(docId, {$set: {'b.0': 2, c: 'bar'}});                                                                  // 2692
  });                                                                                                                  // 2693
  test.length(output, 1);                                                                                              // 2694
  test.equal(output.shift(), ['changed', docId, {c: 'bar'}]);                                                          // 2695
                                                                                                                       // 2696
  handle.stop();                                                                                                       // 2697
});                                                                                                                    // 2698
                                                                                                                       // 2699
Meteor.isServer && Tinytest.add("mongo-livedata - oplog - transform", function (test) {                                // 2700
  var collName = "oplogTransform" + Random.id();                                                                       // 2701
  var coll = new Meteor.Collection(collName);                                                                          // 2702
                                                                                                                       // 2703
  var docId = coll.insert({a: 25, x: {x: 5, y: 9}});                                                                   // 2704
  test.isTrue(docId);                                                                                                  // 2705
                                                                                                                       // 2706
  // Wait until we've processed the insert oplog entry. (If the insert shows up                                        // 2707
  // during the observeChanges, the bug in question is not consistently                                                // 2708
  // reproduced.) We don't have to do this for polling observe (eg                                                     // 2709
  // --disable-oplog).                                                                                                 // 2710
  waitUntilOplogCaughtUp();                                                                                            // 2711
                                                                                                                       // 2712
  var cursor = coll.find({}, {transform: function (doc) {                                                              // 2713
    return doc.x;                                                                                                      // 2714
  }});                                                                                                                 // 2715
                                                                                                                       // 2716
  var changesOutput = [];                                                                                              // 2717
  var changesHandle = cursor.observeChanges({                                                                          // 2718
    added: function (id, fields) {                                                                                     // 2719
      changesOutput.push(['added', fields]);                                                                           // 2720
    }                                                                                                                  // 2721
  });                                                                                                                  // 2722
  // We should get untransformed fields via observeChanges.                                                            // 2723
  test.length(changesOutput, 1);                                                                                       // 2724
  test.equal(changesOutput.shift(), ['added', {a: 25, x: {x: 5, y: 9}}]);                                              // 2725
  changesHandle.stop();                                                                                                // 2726
                                                                                                                       // 2727
  var transformedOutput = [];                                                                                          // 2728
  var transformedHandle = cursor.observe({                                                                             // 2729
    added: function (doc) {                                                                                            // 2730
      transformedOutput.push(['added', doc]);                                                                          // 2731
    }                                                                                                                  // 2732
  });                                                                                                                  // 2733
  test.length(transformedOutput, 1);                                                                                   // 2734
  test.equal(transformedOutput.shift(), ['added', {x: 5, y: 9}]);                                                      // 2735
  transformedHandle.stop();                                                                                            // 2736
});                                                                                                                    // 2737
                                                                                                                       // 2738
                                                                                                                       // 2739
Meteor.isServer && Tinytest.add("mongo-livedata - oplog - drop collection", function (test) {                          // 2740
  var collName = "dropCollection" + Random.id();                                                                       // 2741
  var coll = new Meteor.Collection(collName);                                                                          // 2742
                                                                                                                       // 2743
  var doc1Id = coll.insert({a: 'foo', c: 1});                                                                          // 2744
  var doc2Id = coll.insert({b: 'bar'});                                                                                // 2745
  var doc3Id = coll.insert({a: 'foo', c: 2});                                                                          // 2746
  var tmp;                                                                                                             // 2747
                                                                                                                       // 2748
  var output = [];                                                                                                     // 2749
  var handle = coll.find({a: 'foo'}).observeChanges({                                                                  // 2750
    added: function (id, fields) {                                                                                     // 2751
      output.push(['added', id, fields]);                                                                              // 2752
    },                                                                                                                 // 2753
    changed: function (id) {                                                                                           // 2754
      output.push(['changed']);                                                                                        // 2755
    },                                                                                                                 // 2756
    removed: function (id) {                                                                                           // 2757
      output.push(['removed', id]);                                                                                    // 2758
    }                                                                                                                  // 2759
  });                                                                                                                  // 2760
  test.length(output, 2);                                                                                              // 2761
  // make order consistent                                                                                             // 2762
  if (output.length === 2 && output[0][1] === doc3Id) {                                                                // 2763
    tmp = output[0];                                                                                                   // 2764
    output[0] = output[1];                                                                                             // 2765
    output[1] = tmp;                                                                                                   // 2766
  }                                                                                                                    // 2767
  test.equal(output.shift(), ['added', doc1Id, {a: 'foo', c: 1}]);                                                     // 2768
  test.equal(output.shift(), ['added', doc3Id, {a: 'foo', c: 2}]);                                                     // 2769
                                                                                                                       // 2770
  // Wait until we've processed the insert oplog entry, so that we are in a                                            // 2771
  // steady state (and we don't see the dropped docs because we are FETCHING).                                         // 2772
  waitUntilOplogCaughtUp();                                                                                            // 2773
                                                                                                                       // 2774
  // Drop the collection. Should remove all docs.                                                                      // 2775
  runInFence(function () {                                                                                             // 2776
    coll._dropCollection();                                                                                            // 2777
  });                                                                                                                  // 2778
                                                                                                                       // 2779
  test.length(output, 2);                                                                                              // 2780
  // make order consistent                                                                                             // 2781
  if (output.length === 2 && output[0][1] === doc3Id) {                                                                // 2782
    tmp = output[0];                                                                                                   // 2783
    output[0] = output[1];                                                                                             // 2784
    output[1] = tmp;                                                                                                   // 2785
  }                                                                                                                    // 2786
  test.equal(output.shift(), ['removed', doc1Id]);                                                                     // 2787
  test.equal(output.shift(), ['removed', doc3Id]);                                                                     // 2788
                                                                                                                       // 2789
  // Put something back in.                                                                                            // 2790
  var doc4Id;                                                                                                          // 2791
  runInFence(function () {                                                                                             // 2792
    doc4Id = coll.insert({a: 'foo', c: 3});                                                                            // 2793
  });                                                                                                                  // 2794
                                                                                                                       // 2795
  test.length(output, 1);                                                                                              // 2796
  test.equal(output.shift(), ['added', doc4Id, {a: 'foo', c: 3}]);                                                     // 2797
                                                                                                                       // 2798
  handle.stop();                                                                                                       // 2799
});                                                                                                                    // 2800
                                                                                                                       // 2801
var TestCustomType = function (head, tail) {                                                                           // 2802
  // use different field names on the object than in JSON, to ensure we are                                            // 2803
  // actually treating this as an opaque object.                                                                       // 2804
  this.myHead = head;                                                                                                  // 2805
  this.myTail = tail;                                                                                                  // 2806
};                                                                                                                     // 2807
_.extend(TestCustomType.prototype, {                                                                                   // 2808
  clone: function () {                                                                                                 // 2809
    return new TestCustomType(this.myHead, this.myTail);                                                               // 2810
  },                                                                                                                   // 2811
  equals: function (other) {                                                                                           // 2812
    return other instanceof TestCustomType                                                                             // 2813
      && EJSON.equals(this.myHead, other.myHead)                                                                       // 2814
      && EJSON.equals(this.myTail, other.myTail);                                                                      // 2815
  },                                                                                                                   // 2816
  typeName: function () {                                                                                              // 2817
    return 'someCustomType';                                                                                           // 2818
  },                                                                                                                   // 2819
  toJSONValue: function () {                                                                                           // 2820
    return {head: this.myHead, tail: this.myTail};                                                                     // 2821
  }                                                                                                                    // 2822
});                                                                                                                    // 2823
                                                                                                                       // 2824
EJSON.addType('someCustomType', function (json) {                                                                      // 2825
  return new TestCustomType(json.head, json.tail);                                                                     // 2826
});                                                                                                                    // 2827
                                                                                                                       // 2828
testAsyncMulti("mongo-livedata - oplog - update EJSON", [                                                              // 2829
  function (test, expect) {                                                                                            // 2830
    var self = this;                                                                                                   // 2831
    var collectionName = "ejson" + Random.id();                                                                        // 2832
    if (Meteor.isClient) {                                                                                             // 2833
      Meteor.call('createInsecureCollection', collectionName);                                                         // 2834
      Meteor.subscribe('c-' + collectionName, expect());                                                               // 2835
    }                                                                                                                  // 2836
                                                                                                                       // 2837
    self.collection = new Meteor.Collection(collectionName);                                                           // 2838
    self.date = new Date;                                                                                              // 2839
    self.objId = new Meteor.Collection.ObjectID;                                                                       // 2840
                                                                                                                       // 2841
    self.id = self.collection.insert(                                                                                  // 2842
      {d: self.date, oi: self.objId,                                                                                   // 2843
       custom: new TestCustomType('a', 'b')},                                                                          // 2844
      expect(function (err, res) {                                                                                     // 2845
        test.isFalse(err);                                                                                             // 2846
        test.equal(self.id, res);                                                                                      // 2847
      }));                                                                                                             // 2848
  },                                                                                                                   // 2849
  function (test, expect) {                                                                                            // 2850
    var self = this;                                                                                                   // 2851
    self.changes = [];                                                                                                 // 2852
    self.handle = self.collection.find({}).observeChanges({                                                            // 2853
      added: function (id, fields) {                                                                                   // 2854
        self.changes.push(['a', id, fields]);                                                                          // 2855
      },                                                                                                               // 2856
      changed: function (id, fields) {                                                                                 // 2857
        self.changes.push(['c', id, fields]);                                                                          // 2858
      },                                                                                                               // 2859
      removed: function (id) {                                                                                         // 2860
        self.changes.push(['r', id]);                                                                                  // 2861
      }                                                                                                                // 2862
    });                                                                                                                // 2863
    test.length(self.changes, 1);                                                                                      // 2864
    test.equal(self.changes.shift(),                                                                                   // 2865
               ['a', self.id,                                                                                          // 2866
                {d: self.date, oi: self.objId,                                                                         // 2867
                 custom: new TestCustomType('a', 'b')}]);                                                              // 2868
                                                                                                                       // 2869
    // First, replace the entire custom object.                                                                        // 2870
    // (runInFence is useful for the server, using expect() is useful for the                                          // 2871
    // client)                                                                                                         // 2872
    runInFence(function () {                                                                                           // 2873
      self.collection.update(                                                                                          // 2874
        self.id, {$set: {custom: new TestCustomType('a', 'c')}},                                                       // 2875
        expect(function (err) {                                                                                        // 2876
          test.isFalse(err);                                                                                           // 2877
        }));                                                                                                           // 2878
    });                                                                                                                // 2879
  },                                                                                                                   // 2880
  function (test, expect) {                                                                                            // 2881
    var self = this;                                                                                                   // 2882
    test.length(self.changes, 1);                                                                                      // 2883
    test.equal(self.changes.shift(),                                                                                   // 2884
               ['c', self.id, {custom: new TestCustomType('a', 'c')}]);                                                // 2885
                                                                                                                       // 2886
    // Now, sneakily replace just a piece of it. Meteor won't do this, but                                             // 2887
    // perhaps you are accessing Mongo directly.                                                                       // 2888
    runInFence(function () {                                                                                           // 2889
      self.collection.update(                                                                                          // 2890
        self.id, {$set: {'custom.EJSON$value.EJSONtail': 'd'}},                                                        // 2891
      expect(function (err) {                                                                                          // 2892
        test.isFalse(err);                                                                                             // 2893
      }));                                                                                                             // 2894
    });                                                                                                                // 2895
  },                                                                                                                   // 2896
  function (test, expect) {                                                                                            // 2897
    var self = this;                                                                                                   // 2898
    test.length(self.changes, 1);                                                                                      // 2899
    test.equal(self.changes.shift(),                                                                                   // 2900
               ['c', self.id, {custom: new TestCustomType('a', 'd')}]);                                                // 2901
                                                                                                                       // 2902
    // Update a date and an ObjectID too.                                                                              // 2903
    self.date2 = new Date(self.date.valueOf() + 1000);                                                                 // 2904
    self.objId2 = new Meteor.Collection.ObjectID;                                                                      // 2905
    runInFence(function () {                                                                                           // 2906
      self.collection.update(                                                                                          // 2907
        self.id, {$set: {d: self.date2, oi: self.objId2}},                                                             // 2908
      expect(function (err) {                                                                                          // 2909
        test.isFalse(err);                                                                                             // 2910
      }));                                                                                                             // 2911
    });                                                                                                                // 2912
  },                                                                                                                   // 2913
  function (test, expect) {                                                                                            // 2914
    var self = this;                                                                                                   // 2915
    test.length(self.changes, 1);                                                                                      // 2916
    test.equal(self.changes.shift(),                                                                                   // 2917
               ['c', self.id, {d: self.date2, oi: self.objId2}]);                                                      // 2918
                                                                                                                       // 2919
    self.handle.stop();                                                                                                // 2920
  }                                                                                                                    // 2921
]);                                                                                                                    // 2922
                                                                                                                       // 2923
                                                                                                                       // 2924
var waitUntilOplogCaughtUp = function () {                                                                             // 2925
  var oplogHandle =                                                                                                    // 2926
        MongoInternals.defaultRemoteCollectionDriver().mongo._oplogHandle;                                             // 2927
  if (oplogHandle)                                                                                                     // 2928
    oplogHandle.waitUntilCaughtUp();                                                                                   // 2929
};                                                                                                                     // 2930
                                                                                                                       // 2931
                                                                                                                       // 2932
Meteor.isServer && Tinytest.add("mongo-livedata - cursor dedup stop", function (test) {                                // 2933
  var coll = new Meteor.Collection(Random.id());                                                                       // 2934
  _.times(100, function () {                                                                                           // 2935
    coll.insert({foo: 'baz'});                                                                                         // 2936
  });                                                                                                                  // 2937
  var handler = coll.find({}).observeChanges({                                                                         // 2938
    added: function (id) {                                                                                             // 2939
      coll.update(id, {$set: {foo: 'bar'}});                                                                           // 2940
    }                                                                                                                  // 2941
  });                                                                                                                  // 2942
  handler.stop();                                                                                                      // 2943
  // Previously, this would print                                                                                      // 2944
  //    Exception in queued task: TypeError: Object.keys called on non-object                                          // 2945
  // Unfortunately, this test didn't fail before the bugfix, but it at least                                           // 2946
  // would print the error and no longer does.                                                                         // 2947
  // See https://github.com/meteor/meteor/issues/2070                                                                  // 2948
});                                                                                                                    // 2949
                                                                                                                       // 2950
testAsyncMulti("mongo-livedata - undefined find options", [                                                            // 2951
  function (test, expect) {                                                                                            // 2952
    var self = this;                                                                                                   // 2953
    self.collName = Random.id();                                                                                       // 2954
    if (Meteor.isClient) {                                                                                             // 2955
      Meteor.call("createInsecureCollection", self.collName);                                                          // 2956
      Meteor.subscribe("c-" + self.collName, expect());                                                                // 2957
    }                                                                                                                  // 2958
  },                                                                                                                   // 2959
  function (test, expect) {                                                                                            // 2960
    var self = this;                                                                                                   // 2961
    self.coll = new Meteor.Collection(self.collName);                                                                  // 2962
    self.doc = { foo: 1, bar: 2, _id: "foobar" };                                                                      // 2963
    self.coll.insert(self.doc, expect(function (err, id) {                                                             // 2964
      test.isFalse(err);                                                                                               // 2965
    }));                                                                                                               // 2966
  },                                                                                                                   // 2967
  function (test, expect) {                                                                                            // 2968
    var self = this;                                                                                                   // 2969
    var result = self.coll.findOne({ foo: 1 }, {                                                                       // 2970
      fields: undefined,                                                                                               // 2971
      sort: undefined,                                                                                                 // 2972
      limit: undefined,                                                                                                // 2973
      skip: undefined                                                                                                  // 2974
    });                                                                                                                // 2975
    test.equal(result, self.doc);                                                                                      // 2976
  }                                                                                                                    // 2977
]);                                                                                                                    // 2978
                                                                                                                       // 2979
// Regression test for #2274.                                                                                          // 2980
Meteor.isServer && testAsyncMulti("mongo-livedata - observe limit bug", [                                              // 2981
  function (test, expect) {                                                                                            // 2982
    var self = this;                                                                                                   // 2983
    self.coll = new Meteor.Collection(Random.id());                                                                    // 2984
    var state = {};                                                                                                    // 2985
    var callbacks = {                                                                                                  // 2986
      changed: function (newDoc) {                                                                                     // 2987
        state[newDoc._id] = newDoc;                                                                                    // 2988
      },                                                                                                               // 2989
      added: function (newDoc) {                                                                                       // 2990
        state[newDoc._id] = newDoc;                                                                                    // 2991
      },                                                                                                               // 2992
      removed: function (oldDoc) {                                                                                     // 2993
        delete state[oldDoc._id];                                                                                      // 2994
      }                                                                                                                // 2995
    };                                                                                                                 // 2996
    self.observe = self.coll.find(                                                                                     // 2997
      {}, {limit: 1, sort: {sortField: -1}}).observe(callbacks);                                                       // 2998
                                                                                                                       // 2999
    // Insert some documents.                                                                                          // 3000
    runInFence(function () {                                                                                           // 3001
      self.id0 = self.coll.insert({sortField: 0, toDelete: true});                                                     // 3002
      self.id1 = self.coll.insert({sortField: 1, toDelete: true});                                                     // 3003
      self.id2 = self.coll.insert({sortField: 2, toDelete: true});                                                     // 3004
    });                                                                                                                // 3005
    test.equal(_.keys(state), [self.id2]);                                                                             // 3006
                                                                                                                       // 3007
    // Mutate the one in the unpublished buffer and the one below the                                                  // 3008
    // buffer. Before the fix for #2274, this left the observe state machine in                                        // 3009
    // a broken state where the buffer was empty but it wasn't try to re-fill                                          // 3010
    // it.                                                                                                             // 3011
    runInFence(function () {                                                                                           // 3012
      self.coll.update({_id: {$ne: self.id2}},                                                                         // 3013
                       {$set: {toDelete: false}},                                                                      // 3014
                       {multi: 1});                                                                                    // 3015
    });                                                                                                                // 3016
    test.equal(_.keys(state), [self.id2]);                                                                             // 3017
                                                                                                                       // 3018
    // Now remove the one published document. This should slide up id1 from the                                        // 3019
    // buffer, but this didn't work before the #2274 fix.                                                              // 3020
    runInFence(function () {                                                                                           // 3021
      self.coll.remove({toDelete: true});                                                                              // 3022
    });                                                                                                                // 3023
    test.equal(_.keys(state), [self.id1]);                                                                             // 3024
  }                                                                                                                    // 3025
]);                                                                                                                    // 3026
                                                                                                                       // 3027
                                                                                                                       // 3028
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/allow_tests.js                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
if (Meteor.isServer) {                                                                                                 // 1
  // Set up allow/deny rules for test collections                                                                      // 2
                                                                                                                       // 3
  var allowCollections = {};                                                                                           // 4
                                                                                                                       // 5
  // We create the collections in the publisher (instead of using a method or                                          // 6
  // something) because if we made them with a method, we'd need to follow the                                         // 7
  // method with some subscribes, and it's possible that the method call would                                         // 8
  // be delayed by a wait method and the subscribe messages would be sent before                                       // 9
  // it and fail due to the collection not yet existing. So we are very hacky                                          // 10
  // and use a publish.                                                                                                // 11
  Meteor.publish("allowTests", function (nonce, idGeneration) {                                                        // 12
    check(nonce, String);                                                                                              // 13
    check(idGeneration, String);                                                                                       // 14
    var cursors = [];                                                                                                  // 15
    var needToConfigure = undefined;                                                                                   // 16
                                                                                                                       // 17
    // helper for defining a collection. we are careful to create just one                                             // 18
    // Meteor.Collection even if the sub body is rerun, by caching them.                                               // 19
    var defineCollection = function(name, insecure, transform) {                                                       // 20
      var fullName = name + idGeneration + nonce;                                                                      // 21
                                                                                                                       // 22
      var collection;                                                                                                  // 23
      if (_.has(allowCollections, fullName)) {                                                                         // 24
        collection = allowCollections[fullName];                                                                       // 25
        if (needToConfigure === true)                                                                                  // 26
          throw new Error("collections inconsistently exist");                                                         // 27
        needToConfigure = false;                                                                                       // 28
      } else {                                                                                                         // 29
        collection = new Meteor.Collection(                                                                            // 30
          fullName, {idGeneration: idGeneration, transform: transform});                                               // 31
        allowCollections[fullName] = collection;                                                                       // 32
        if (needToConfigure === false)                                                                                 // 33
          throw new Error("collections inconsistently don't exist");                                                   // 34
        needToConfigure = true;                                                                                        // 35
        collection._insecure = insecure;                                                                               // 36
        var m = {};                                                                                                    // 37
        m["clear-collection-" + fullName] = function() {                                                               // 38
          collection.remove({});                                                                                       // 39
        };                                                                                                             // 40
        Meteor.methods(m);                                                                                             // 41
      }                                                                                                                // 42
                                                                                                                       // 43
      cursors.push(collection.find());                                                                                 // 44
      return collection;                                                                                               // 45
    };                                                                                                                 // 46
                                                                                                                       // 47
    var insecureCollection = defineCollection(                                                                         // 48
      "collection-insecure", true /*insecure*/);                                                                       // 49
    // totally locked down collection                                                                                  // 50
    var lockedDownCollection = defineCollection(                                                                       // 51
      "collection-locked-down", false /*insecure*/);                                                                   // 52
    // restricted collection with same allowed modifications, both with and                                            // 53
    // without the `insecure` package                                                                                  // 54
    var restrictedCollectionDefaultSecure = defineCollection(                                                          // 55
      "collection-restrictedDefaultSecure", false /*insecure*/);                                                       // 56
    var restrictedCollectionDefaultInsecure = defineCollection(                                                        // 57
      "collection-restrictedDefaultInsecure", true /*insecure*/);                                                      // 58
    var restrictedCollectionForUpdateOptionsTest = defineCollection(                                                   // 59
      "collection-restrictedForUpdateOptionsTest", true /*insecure*/);                                                 // 60
    var restrictedCollectionForPartialAllowTest = defineCollection(                                                    // 61
      "collection-restrictedForPartialAllowTest", true /*insecure*/);                                                  // 62
    var restrictedCollectionForPartialDenyTest = defineCollection(                                                     // 63
      "collection-restrictedForPartialDenyTest", true /*insecure*/);                                                   // 64
    var restrictedCollectionForFetchTest = defineCollection(                                                           // 65
      "collection-restrictedForFetchTest", true /*insecure*/);                                                         // 66
    var restrictedCollectionForFetchAllTest = defineCollection(                                                        // 67
      "collection-restrictedForFetchAllTest", true /*insecure*/);                                                      // 68
    var restrictedCollectionWithTransform = defineCollection(                                                          // 69
      "withTransform", false, function (doc) {                                                                         // 70
        return doc.a;                                                                                                  // 71
      });                                                                                                              // 72
    var restrictedCollectionForInvalidTransformTest = defineCollection(                                                // 73
      "collection-restrictedForInvalidTransform", false /*insecure*/);                                                 // 74
    var restrictedCollectionForClientIdTest = defineCollection(                                                        // 75
      "collection-restrictedForClientIdTest", false /*insecure*/);                                                     // 76
                                                                                                                       // 77
    if (needToConfigure) {                                                                                             // 78
      restrictedCollectionWithTransform.allow({                                                                        // 79
        insert: function (userId, doc) {                                                                               // 80
          return doc.foo === "foo";                                                                                    // 81
        },                                                                                                             // 82
        update: function (userId, doc) {                                                                               // 83
          return doc.foo === "foo";                                                                                    // 84
        },                                                                                                             // 85
        remove: function (userId, doc) {                                                                               // 86
          return doc.bar === "bar";                                                                                    // 87
        }                                                                                                              // 88
      });                                                                                                              // 89
      restrictedCollectionWithTransform.allow({                                                                        // 90
        // transform: null means that doc here is the top level, not the 'a'                                           // 91
        // element.                                                                                                    // 92
        transform: null,                                                                                               // 93
        insert: function (userId, doc) {                                                                               // 94
          return !!doc.topLevelField;                                                                                  // 95
        }                                                                                                              // 96
      });                                                                                                              // 97
      restrictedCollectionForInvalidTransformTest.allow({                                                              // 98
        // transform must return an object which is not a mongo id                                                     // 99
        transform: function (doc) { return doc._id; },                                                                 // 100
        insert: function () { return true; }                                                                           // 101
      });                                                                                                              // 102
      restrictedCollectionForClientIdTest.allow({                                                                      // 103
        // This test just requires the collection to trigger the restricted                                            // 104
        // case.                                                                                                       // 105
        insert: function () { return true; }                                                                           // 106
      });                                                                                                              // 107
                                                                                                                       // 108
      // two calls to allow to verify that either validator is sufficient.                                             // 109
      var allows = [{                                                                                                  // 110
        insert: function(userId, doc) {                                                                                // 111
          return doc.canInsert;                                                                                        // 112
        },                                                                                                             // 113
        update: function(userId, doc) {                                                                                // 114
          return doc.canUpdate;                                                                                        // 115
        },                                                                                                             // 116
        remove: function (userId, doc) {                                                                               // 117
          return doc.canRemove;                                                                                        // 118
        }                                                                                                              // 119
      }, {                                                                                                             // 120
        insert: function(userId, doc) {                                                                                // 121
          return doc.canInsert2;                                                                                       // 122
        },                                                                                                             // 123
        update: function(userId, doc, fields, modifier) {                                                              // 124
          return -1 !== _.indexOf(fields, 'canUpdate2');                                                               // 125
        },                                                                                                             // 126
        remove: function(userId, doc) {                                                                                // 127
          return doc.canRemove2;                                                                                       // 128
        }                                                                                                              // 129
      }];                                                                                                              // 130
                                                                                                                       // 131
      // two calls to deny to verify that either one blocks the change.                                                // 132
      var denies = [{                                                                                                  // 133
        insert: function(userId, doc) {                                                                                // 134
          return doc.cantInsert;                                                                                       // 135
        },                                                                                                             // 136
        remove: function (userId, doc) {                                                                               // 137
          return doc.cantRemove;                                                                                       // 138
        }                                                                                                              // 139
      }, {                                                                                                             // 140
        insert: function(userId, doc) {                                                                                // 141
          // Don't allow explicit ID to be set by the client.                                                          // 142
          return _.has(doc, '_id');                                                                                    // 143
        },                                                                                                             // 144
        update: function(userId, doc, fields, modifier) {                                                              // 145
          return -1 !== _.indexOf(fields, 'verySecret');                                                               // 146
        }                                                                                                              // 147
      }];                                                                                                              // 148
                                                                                                                       // 149
      _.each([                                                                                                         // 150
        restrictedCollectionDefaultSecure,                                                                             // 151
        restrictedCollectionDefaultInsecure,                                                                           // 152
        restrictedCollectionForUpdateOptionsTest                                                                       // 153
      ], function (collection) {                                                                                       // 154
        _.each(allows, function (allow) {                                                                              // 155
          collection.allow(allow);                                                                                     // 156
        });                                                                                                            // 157
        _.each(denies, function (deny) {                                                                               // 158
          collection.deny(deny);                                                                                       // 159
        });                                                                                                            // 160
      });                                                                                                              // 161
                                                                                                                       // 162
      // just restrict one operation so that we can verify that others                                                 // 163
      // fail                                                                                                          // 164
      restrictedCollectionForPartialAllowTest.allow({                                                                  // 165
        insert: function() {}                                                                                          // 166
      });                                                                                                              // 167
      restrictedCollectionForPartialDenyTest.deny({                                                                    // 168
        insert: function() {}                                                                                          // 169
      });                                                                                                              // 170
                                                                                                                       // 171
      // verify that we only fetch the fields specified - we should                                                    // 172
      // be fetching just field1, field2, and field3.                                                                  // 173
      restrictedCollectionForFetchTest.allow({                                                                         // 174
        insert: function() { return true; },                                                                           // 175
        update: function(userId, doc) {                                                                                // 176
          // throw fields in doc so that we can inspect them in test                                                   // 177
          throw new Meteor.Error(                                                                                      // 178
            999, "Test: Fields in doc: " + _.keys(doc).join(','));                                                     // 179
        },                                                                                                             // 180
        remove: function(userId, doc) {                                                                                // 181
          // throw fields in doc so that we can inspect them in test                                                   // 182
          throw new Meteor.Error(                                                                                      // 183
            999, "Test: Fields in doc: " + _.keys(doc).join(','));                                                     // 184
        },                                                                                                             // 185
        fetch: ['field1']                                                                                              // 186
      });                                                                                                              // 187
      restrictedCollectionForFetchTest.allow({                                                                         // 188
        fetch: ['field2']                                                                                              // 189
      });                                                                                                              // 190
      restrictedCollectionForFetchTest.deny({                                                                          // 191
        fetch: ['field3']                                                                                              // 192
      });                                                                                                              // 193
                                                                                                                       // 194
      // verify that not passing fetch to one of the calls to allow                                                    // 195
      // causes all fields to be fetched                                                                               // 196
      restrictedCollectionForFetchAllTest.allow({                                                                      // 197
        insert: function() { return true; },                                                                           // 198
        update: function(userId, doc) {                                                                                // 199
          // throw fields in doc so that we can inspect them in test                                                   // 200
          throw new Meteor.Error(                                                                                      // 201
            999, "Test: Fields in doc: " + _.keys(doc).join(','));                                                     // 202
        },                                                                                                             // 203
        remove: function(userId, doc) {                                                                                // 204
          // throw fields in doc so that we can inspect them in test                                                   // 205
          throw new Meteor.Error(                                                                                      // 206
            999, "Test: Fields in doc: " + _.keys(doc).join(','));                                                     // 207
        },                                                                                                             // 208
        fetch: ['field1']                                                                                              // 209
      });                                                                                                              // 210
      restrictedCollectionForFetchAllTest.allow({                                                                      // 211
        update: function() { return true; }                                                                            // 212
      });                                                                                                              // 213
    }                                                                                                                  // 214
                                                                                                                       // 215
    return cursors;                                                                                                    // 216
  });                                                                                                                  // 217
}                                                                                                                      // 218
                                                                                                                       // 219
if (Meteor.isClient) {                                                                                                 // 220
  _.each(['STRING', 'MONGO'], function (idGeneration) {                                                                // 221
    // Set up a bunch of test collections... on the client! They match the ones                                        // 222
    // created by setUpAllowTestsCollections.                                                                          // 223
                                                                                                                       // 224
    var nonce = Random.id();                                                                                           // 225
    // Tell the server to make, configure, and publish a set of collections unique                                     // 226
    // to our test run. Since the method does not unblock, this will complete                                          // 227
    // running on the server before anything else happens.                                                             // 228
    Meteor.subscribe('allowTests', nonce, idGeneration);                                                               // 229
                                                                                                                       // 230
    // helper for defining a collection, subscribing to it, and defining                                               // 231
    // a method to clear it                                                                                            // 232
    var defineCollection = function(name, transform) {                                                                 // 233
      var fullName = name + idGeneration + nonce;                                                                      // 234
      var collection = new Meteor.Collection(                                                                          // 235
        fullName, {idGeneration: idGeneration, transform: transform});                                                 // 236
                                                                                                                       // 237
      collection.callClearMethod = function (callback) {                                                               // 238
        Meteor.call("clear-collection-" + fullName, callback);                                                         // 239
      };                                                                                                               // 240
      collection.unnoncedName = name + idGeneration;                                                                   // 241
      return collection;                                                                                               // 242
    };                                                                                                                 // 243
                                                                                                                       // 244
    // totally insecure collection                                                                                     // 245
    var insecureCollection = defineCollection("collection-insecure");                                                  // 246
                                                                                                                       // 247
    // totally locked down collection                                                                                  // 248
    var lockedDownCollection = defineCollection("collection-locked-down");                                             // 249
                                                                                                                       // 250
    // restricted collection with same allowed modifications, both with and                                            // 251
    // without the `insecure` package                                                                                  // 252
    var restrictedCollectionDefaultSecure = defineCollection(                                                          // 253
      "collection-restrictedDefaultSecure");                                                                           // 254
    var restrictedCollectionDefaultInsecure = defineCollection(                                                        // 255
      "collection-restrictedDefaultInsecure");                                                                         // 256
    var restrictedCollectionForUpdateOptionsTest = defineCollection(                                                   // 257
      "collection-restrictedForUpdateOptionsTest");                                                                    // 258
    var restrictedCollectionForPartialAllowTest = defineCollection(                                                    // 259
      "collection-restrictedForPartialAllowTest");                                                                     // 260
    var restrictedCollectionForPartialDenyTest = defineCollection(                                                     // 261
      "collection-restrictedForPartialDenyTest");                                                                      // 262
    var restrictedCollectionForFetchTest = defineCollection(                                                           // 263
      "collection-restrictedForFetchTest");                                                                            // 264
    var restrictedCollectionForFetchAllTest = defineCollection(                                                        // 265
      "collection-restrictedForFetchAllTest");                                                                         // 266
    var restrictedCollectionWithTransform = defineCollection(                                                          // 267
      "withTransform", function (doc) {                                                                                // 268
        return doc.a;                                                                                                  // 269
      });                                                                                                              // 270
    var restrictedCollectionForInvalidTransformTest = defineCollection(                                                // 271
      "collection-restrictedForInvalidTransform");                                                                     // 272
    var restrictedCollectionForClientIdTest = defineCollection(                                                        // 273
      "collection-restrictedForClientIdTest");                                                                         // 274
                                                                                                                       // 275
    // test that if allow is called once then the collection is                                                        // 276
    // restricted, and that other mutations aren't allowed                                                             // 277
    testAsyncMulti("collection - partial allow, " + idGeneration, [                                                    // 278
      function (test, expect) {                                                                                        // 279
        restrictedCollectionForPartialAllowTest.update(                                                                // 280
          'foo', {$set: {updated: true}}, expect(function (err, res) {                                                 // 281
            test.equal(err.error, 403);                                                                                // 282
          }));                                                                                                         // 283
      }                                                                                                                // 284
    ]);                                                                                                                // 285
                                                                                                                       // 286
    // test that if deny is called once then the collection is                                                         // 287
    // restricted, and that other mutations aren't allowed                                                             // 288
    testAsyncMulti("collection - partial deny, " + idGeneration, [                                                     // 289
      function (test, expect) {                                                                                        // 290
        restrictedCollectionForPartialDenyTest.update(                                                                 // 291
          'foo', {$set: {updated: true}}, expect(function (err, res) {                                                 // 292
            test.equal(err.error, 403);                                                                                // 293
          }));                                                                                                         // 294
      }                                                                                                                // 295
    ]);                                                                                                                // 296
                                                                                                                       // 297
                                                                                                                       // 298
    // test that we only fetch the fields specified                                                                    // 299
    testAsyncMulti("collection - fetch, " + idGeneration, [                                                            // 300
      function (test, expect) {                                                                                        // 301
        var fetchId = restrictedCollectionForFetchTest.insert(                                                         // 302
          {field1: 1, field2: 1, field3: 1, field4: 1});                                                               // 303
        var fetchAllId = restrictedCollectionForFetchAllTest.insert(                                                   // 304
          {field1: 1, field2: 1, field3: 1, field4: 1});                                                               // 305
        restrictedCollectionForFetchTest.update(                                                                       // 306
          fetchId, {$set: {updated: true}}, expect(function (err, res) {                                               // 307
            test.equal(err.reason,                                                                                     // 308
                       "Test: Fields in doc: field1,field2,field3,_id");                                               // 309
          }));                                                                                                         // 310
        restrictedCollectionForFetchTest.remove(                                                                       // 311
          fetchId, expect(function (err, res) {                                                                        // 312
            test.equal(err.reason,                                                                                     // 313
                       "Test: Fields in doc: field1,field2,field3,_id");                                               // 314
          }));                                                                                                         // 315
                                                                                                                       // 316
        restrictedCollectionForFetchAllTest.update(                                                                    // 317
          fetchAllId, {$set: {updated: true}}, expect(function (err, res) {                                            // 318
            test.equal(err.reason,                                                                                     // 319
                       "Test: Fields in doc: field1,field2,field3,field4,_id");                                        // 320
          }));                                                                                                         // 321
        restrictedCollectionForFetchAllTest.remove(                                                                    // 322
          fetchAllId, expect(function (err, res) {                                                                     // 323
            test.equal(err.reason,                                                                                     // 324
                       "Test: Fields in doc: field1,field2,field3,field4,_id");                                        // 325
          }));                                                                                                         // 326
      }                                                                                                                // 327
    ]);                                                                                                                // 328
                                                                                                                       // 329
    (function(){                                                                                                       // 330
      var item1;                                                                                                       // 331
      var item2;                                                                                                       // 332
      testAsyncMulti("collection - restricted factories " + idGeneration, [                                            // 333
        function (test, expect) {                                                                                      // 334
          restrictedCollectionWithTransform.callClearMethod(expect(function () {                                       // 335
            test.equal(restrictedCollectionWithTransform.find().count(), 0);                                           // 336
          }));                                                                                                         // 337
        },                                                                                                             // 338
        function (test, expect) {                                                                                      // 339
          restrictedCollectionWithTransform.insert({                                                                   // 340
            a: {foo: "foo", bar: "bar", baz: "baz"}                                                                    // 341
          }, expect(function (e, res) {                                                                                // 342
            test.isFalse(e);                                                                                           // 343
            test.isTrue(res);                                                                                          // 344
            item1 = res;                                                                                               // 345
          }));                                                                                                         // 346
          restrictedCollectionWithTransform.insert({                                                                   // 347
            a: {foo: "foo", bar: "quux", baz: "quux"},                                                                 // 348
            b: "potato"                                                                                                // 349
          }, expect(function (e, res) {                                                                                // 350
            test.isFalse(e);                                                                                           // 351
            test.isTrue(res);                                                                                          // 352
            item2 = res;                                                                                               // 353
          }));                                                                                                         // 354
          restrictedCollectionWithTransform.insert({                                                                   // 355
            a: {foo: "adsfadf", bar: "quux", baz: "quux"},                                                             // 356
            b: "potato"                                                                                                // 357
          }, expect(function (e, res) {                                                                                // 358
            test.isTrue(e);                                                                                            // 359
          }));                                                                                                         // 360
          restrictedCollectionWithTransform.insert({                                                                   // 361
            a: {foo: "bar"},                                                                                           // 362
            topLevelField: true                                                                                        // 363
          }, expect(function (e, res) {                                                                                // 364
            test.isFalse(e);                                                                                           // 365
            test.isTrue(res);                                                                                          // 366
          }));                                                                                                         // 367
        },                                                                                                             // 368
        function (test, expect) {                                                                                      // 369
          test.equal(                                                                                                  // 370
            _.omit(restrictedCollectionWithTransform.findOne({"a.bar": "bar"}), '_id'),                                // 371
            {foo: "foo", bar: "bar", baz: "baz"});                                                                     // 372
          restrictedCollectionWithTransform.remove(item1, expect(function (e, res) {                                   // 373
            test.isFalse(e);                                                                                           // 374
          }));                                                                                                         // 375
          restrictedCollectionWithTransform.remove(item2, expect(function (e, res) {                                   // 376
            test.isTrue(e);                                                                                            // 377
          }));                                                                                                         // 378
        }                                                                                                              // 379
      ]);                                                                                                              // 380
    })();                                                                                                              // 381
                                                                                                                       // 382
    testAsyncMulti("collection - insecure, " + idGeneration, [                                                         // 383
      function (test, expect) {                                                                                        // 384
        insecureCollection.callClearMethod(expect(function () {                                                        // 385
          test.equal(insecureCollection.find().count(), 0);                                                            // 386
        }));                                                                                                           // 387
      },                                                                                                               // 388
      function (test, expect) {                                                                                        // 389
        var id = insecureCollection.insert({foo: 'bar'}, expect(function(err, res) {                                   // 390
          test.equal(res, id);                                                                                         // 391
          test.equal(insecureCollection.find(id).count(), 1);                                                          // 392
          test.equal(insecureCollection.findOne(id).foo, 'bar');                                                       // 393
        }));                                                                                                           // 394
        test.equal(insecureCollection.find(id).count(), 1);                                                            // 395
        test.equal(insecureCollection.findOne(id).foo, 'bar');                                                         // 396
      }                                                                                                                // 397
    ]);                                                                                                                // 398
                                                                                                                       // 399
    testAsyncMulti("collection - locked down, " + idGeneration, [                                                      // 400
      function (test, expect) {                                                                                        // 401
        lockedDownCollection.callClearMethod(expect(function() {                                                       // 402
          test.equal(lockedDownCollection.find().count(), 0);                                                          // 403
        }));                                                                                                           // 404
      },                                                                                                               // 405
      function (test, expect) {                                                                                        // 406
        lockedDownCollection.insert({foo: 'bar'}, expect(function (err, res) {                                         // 407
          test.equal(err.error, 403);                                                                                  // 408
          test.equal(lockedDownCollection.find().count(), 0);                                                          // 409
        }));                                                                                                           // 410
      }                                                                                                                // 411
    ]);                                                                                                                // 412
                                                                                                                       // 413
    (function () {                                                                                                     // 414
      var collection = restrictedCollectionForUpdateOptionsTest;                                                       // 415
      var id1, id2;                                                                                                    // 416
      testAsyncMulti("collection - update options, " + idGeneration, [                                                 // 417
        // init                                                                                                        // 418
        function (test, expect) {                                                                                      // 419
          collection.callClearMethod(expect(function () {                                                              // 420
            test.equal(collection.find().count(), 0);                                                                  // 421
          }));                                                                                                         // 422
        },                                                                                                             // 423
        // put a few objects                                                                                           // 424
        function (test, expect) {                                                                                      // 425
          var doc = {canInsert: true, canUpdate: true};                                                                // 426
          id1 = collection.insert(doc);                                                                                // 427
          id2 = collection.insert(doc);                                                                                // 428
          collection.insert(doc);                                                                                      // 429
          collection.insert(doc, expect(function (err, res) {                                                          // 430
            test.isFalse(err);                                                                                         // 431
            test.equal(collection.find().count(), 4);                                                                  // 432
          }));                                                                                                         // 433
        },                                                                                                             // 434
        // update by id                                                                                                // 435
        function (test, expect) {                                                                                      // 436
          collection.update(                                                                                           // 437
            id1,                                                                                                       // 438
            {$set: {updated: true}},                                                                                   // 439
            expect(function (err, res) {                                                                               // 440
              test.isFalse(err);                                                                                       // 441
              test.equal(res, 1);                                                                                      // 442
              test.equal(collection.find({updated: true}).count(), 1);                                                 // 443
            }));                                                                                                       // 444
        },                                                                                                             // 445
        // update by id in an object                                                                                   // 446
        function (test, expect) {                                                                                      // 447
          collection.update(                                                                                           // 448
            {_id: id2},                                                                                                // 449
            {$set: {updated: true}},                                                                                   // 450
            expect(function (err, res) {                                                                               // 451
              test.isFalse(err);                                                                                       // 452
              test.equal(res, 1);                                                                                      // 453
              test.equal(collection.find({updated: true}).count(), 2);                                                 // 454
            }));                                                                                                       // 455
        },                                                                                                             // 456
        // update with replacement operator not allowed, and has nice error.                                           // 457
        function (test, expect) {                                                                                      // 458
          collection.update(                                                                                           // 459
            {_id: id2},                                                                                                // 460
            {_id: id2, updated: true},                                                                                 // 461
            expect(function (err, res) {                                                                               // 462
              test.equal(err.error, 403);                                                                              // 463
              test.matches(err.reason, /In a restricted/);                                                             // 464
              // unchanged                                                                                             // 465
              test.equal(collection.find({updated: true}).count(), 2);                                                 // 466
            }));                                                                                                       // 467
        },                                                                                                             // 468
        // upsert not allowed, and has nice error.                                                                     // 469
        function (test, expect) {                                                                                      // 470
          collection.update(                                                                                           // 471
            {_id: id2},                                                                                                // 472
            {$set: { upserted: true }},                                                                                // 473
            { upsert: true },                                                                                          // 474
            expect(function (err, res) {                                                                               // 475
              test.equal(err.error, 403);                                                                              // 476
              test.matches(err.reason, /in a restricted/);                                                             // 477
              test.equal(collection.find({ upserted: true }).count(), 0);                                              // 478
            }));                                                                                                       // 479
        },                                                                                                             // 480
        // update with rename operator not allowed, and has nice error.                                                // 481
        function (test, expect) {                                                                                      // 482
          collection.update(                                                                                           // 483
            {_id: id2},                                                                                                // 484
            {$rename: {updated: 'asdf'}},                                                                              // 485
            expect(function (err, res) {                                                                               // 486
              test.equal(err.error, 403);                                                                              // 487
              test.matches(err.reason, /not allowed/);                                                                 // 488
              // unchanged                                                                                             // 489
              test.equal(collection.find({updated: true}).count(), 2);                                                 // 490
            }));                                                                                                       // 491
        },                                                                                                             // 492
        // update method with a non-ID selector is not allowed                                                         // 493
        function (test, expect) {                                                                                      // 494
          // We shouldn't even send the method...                                                                      // 495
          test.throws(function () {                                                                                    // 496
            collection.update(                                                                                         // 497
              {updated: {$exists: false}},                                                                             // 498
              {$set: {updated: true}});                                                                                // 499
          });                                                                                                          // 500
          // ... but if we did, the server would reject it too.                                                        // 501
          Meteor.call(                                                                                                 // 502
            '/' + collection._name + '/update',                                                                        // 503
            {updated: {$exists: false}},                                                                               // 504
            {$set: {updated: true}},                                                                                   // 505
            expect(function (err, res) {                                                                               // 506
              test.equal(err.error, 403);                                                                              // 507
              // unchanged                                                                                             // 508
              test.equal(collection.find({updated: true}).count(), 2);                                                 // 509
            }));                                                                                                       // 510
        },                                                                                                             // 511
        // make sure it doesn't think that {_id: 'foo', something: else} is ok.                                        // 512
        function (test, expect) {                                                                                      // 513
          test.throws(function () {                                                                                    // 514
            collection.update(                                                                                         // 515
              {_id: id1, updated: {$exists: false}},                                                                   // 516
              {$set: {updated: true}});                                                                                // 517
          });                                                                                                          // 518
        },                                                                                                             // 519
        // remove method with a non-ID selector is not allowed                                                         // 520
        function (test, expect) {                                                                                      // 521
          // We shouldn't even send the method...                                                                      // 522
          test.throws(function () {                                                                                    // 523
            collection.remove({updated: true});                                                                        // 524
          });                                                                                                          // 525
          // ... but if we did, the server would reject it too.                                                        // 526
          Meteor.call(                                                                                                 // 527
            '/' + collection._name + '/remove',                                                                        // 528
            {updated: true},                                                                                           // 529
            expect(function (err, res) {                                                                               // 530
              test.equal(err.error, 403);                                                                              // 531
              // unchanged                                                                                             // 532
              test.equal(collection.find({updated: true}).count(), 2);                                                 // 533
            }));                                                                                                       // 534
        }                                                                                                              // 535
      ]);                                                                                                              // 536
    }) ();                                                                                                             // 537
                                                                                                                       // 538
    _.each(                                                                                                            // 539
      [restrictedCollectionDefaultInsecure, restrictedCollectionDefaultSecure],                                        // 540
      function(collection) {                                                                                           // 541
        var canUpdateId, canRemoveId;                                                                                  // 542
                                                                                                                       // 543
        testAsyncMulti("collection - " + collection.unnoncedName, [                                                    // 544
          // init                                                                                                      // 545
          function (test, expect) {                                                                                    // 546
            collection.callClearMethod(expect(function () {                                                            // 547
              test.equal(collection.find().count(), 0);                                                                // 548
            }));                                                                                                       // 549
          },                                                                                                           // 550
                                                                                                                       // 551
          // insert with no allows passing. request is denied.                                                         // 552
          function (test, expect) {                                                                                    // 553
            collection.insert(                                                                                         // 554
              {},                                                                                                      // 555
              expect(function (err, res) {                                                                             // 556
                test.equal(err.error, 403);                                                                            // 557
                test.equal(collection.find().count(), 0);                                                              // 558
              }));                                                                                                     // 559
          },                                                                                                           // 560
          // insert with one allow and one deny. denied.                                                               // 561
          function (test, expect) {                                                                                    // 562
            collection.insert(                                                                                         // 563
              {canInsert: true, cantInsert: true},                                                                     // 564
              expect(function (err, res) {                                                                             // 565
                test.equal(err.error, 403);                                                                            // 566
                test.equal(collection.find().count(), 0);                                                              // 567
              }));                                                                                                     // 568
          },                                                                                                           // 569
          // insert with one allow and other deny. denied.                                                             // 570
          function (test, expect) {                                                                                    // 571
            collection.insert(                                                                                         // 572
              {canInsert: true, _id: Random.id()},                                                                     // 573
              expect(function (err, res) {                                                                             // 574
                test.equal(err.error, 403);                                                                            // 575
                test.equal(collection.find().count(), 0);                                                              // 576
              }));                                                                                                     // 577
          },                                                                                                           // 578
          // insert one allow passes. allowed.                                                                         // 579
          function (test, expect) {                                                                                    // 580
            collection.insert(                                                                                         // 581
              {canInsert: true},                                                                                       // 582
              expect(function (err, res) {                                                                             // 583
                test.isFalse(err);                                                                                     // 584
                test.equal(collection.find().count(), 1);                                                              // 585
              }));                                                                                                     // 586
          },                                                                                                           // 587
          // insert other allow passes. allowed.                                                                       // 588
          // includes canUpdate for later.                                                                             // 589
          function (test, expect) {                                                                                    // 590
            canUpdateId = collection.insert(                                                                           // 591
              {canInsert2: true, canUpdate: true},                                                                     // 592
              expect(function (err, res) {                                                                             // 593
                test.isFalse(err);                                                                                     // 594
                test.equal(collection.find().count(), 2);                                                              // 595
              }));                                                                                                     // 596
          },                                                                                                           // 597
          // yet a third insert executes. this one has canRemove and                                                   // 598
          // cantRemove set for later.                                                                                 // 599
          function (test, expect) {                                                                                    // 600
            canRemoveId = collection.insert(                                                                           // 601
              {canInsert: true, canRemove: true, cantRemove: true},                                                    // 602
              expect(function (err, res) {                                                                             // 603
                test.isFalse(err);                                                                                     // 604
                test.equal(collection.find().count(), 3);                                                              // 605
              }));                                                                                                     // 606
          },                                                                                                           // 607
                                                                                                                       // 608
          // can't update with a non-operator mutation                                                                 // 609
          function (test, expect) {                                                                                    // 610
            collection.update(                                                                                         // 611
              canUpdateId, {newObject: 1},                                                                             // 612
              expect(function (err, res) {                                                                             // 613
                test.equal(err.error, 403);                                                                            // 614
                test.equal(collection.find().count(), 3);                                                              // 615
              }));                                                                                                     // 616
          },                                                                                                           // 617
                                                                                                                       // 618
          // updating dotted fields works as if we are changing their                                                  // 619
          // top part                                                                                                  // 620
          function (test, expect) {                                                                                    // 621
            collection.update(                                                                                         // 622
              canUpdateId, {$set: {"dotted.field": 1}},                                                                // 623
              expect(function (err, res) {                                                                             // 624
                test.isFalse(err);                                                                                     // 625
                test.equal(res, 1);                                                                                    // 626
                test.equal(collection.findOne(canUpdateId).dotted.field, 1);                                           // 627
              }));                                                                                                     // 628
          },                                                                                                           // 629
          function (test, expect) {                                                                                    // 630
            collection.update(                                                                                         // 631
              canUpdateId, {$set: {"verySecret.field": 1}},                                                            // 632
              expect(function (err, res) {                                                                             // 633
                test.equal(err.error, 403);                                                                            // 634
                test.equal(collection.find({verySecret: {$exists: true}}).count(), 0);                                 // 635
              }));                                                                                                     // 636
          },                                                                                                           // 637
                                                                                                                       // 638
          // update doesn't do anything if no docs match                                                               // 639
          function (test, expect) {                                                                                    // 640
            collection.update(                                                                                         // 641
              "doesn't exist",                                                                                         // 642
              {$set: {updated: true}},                                                                                 // 643
              expect(function (err, res) {                                                                             // 644
                test.isFalse(err);                                                                                     // 645
                test.equal(res, 0);                                                                                    // 646
                // nothing has changed                                                                                 // 647
                test.equal(collection.find().count(), 3);                                                              // 648
                test.equal(collection.find({updated: true}).count(), 0);                                               // 649
              }));                                                                                                     // 650
          },                                                                                                           // 651
          // update fails when access is denied trying to set `verySecret`                                             // 652
          function (test, expect) {                                                                                    // 653
            collection.update(                                                                                         // 654
              canUpdateId, {$set: {verySecret: true}},                                                                 // 655
              expect(function (err, res) {                                                                             // 656
                test.equal(err.error, 403);                                                                            // 657
                // nothing has changed                                                                                 // 658
                test.equal(collection.find().count(), 3);                                                              // 659
                test.equal(collection.find({updated: true}).count(), 0);                                               // 660
              }));                                                                                                     // 661
          },                                                                                                           // 662
          // update fails when trying to set two fields, one of which is                                               // 663
          // `verySecret`                                                                                              // 664
          function (test, expect) {                                                                                    // 665
            collection.update(                                                                                         // 666
              canUpdateId, {$set: {updated: true, verySecret: true}},                                                  // 667
              expect(function (err, res) {                                                                             // 668
                test.equal(err.error, 403);                                                                            // 669
                // nothing has changed                                                                                 // 670
                test.equal(collection.find().count(), 3);                                                              // 671
                test.equal(collection.find({updated: true}).count(), 0);                                               // 672
              }));                                                                                                     // 673
          },                                                                                                           // 674
          // update fails when trying to modify docs that don't                                                        // 675
          // have `canUpdate` set                                                                                      // 676
          function (test, expect) {                                                                                    // 677
            collection.update(                                                                                         // 678
              canRemoveId,                                                                                             // 679
              {$set: {updated: true}},                                                                                 // 680
              expect(function (err, res) {                                                                             // 681
                test.equal(err.error, 403);                                                                            // 682
                // nothing has changed                                                                                 // 683
                test.equal(collection.find().count(), 3);                                                              // 684
                test.equal(collection.find({updated: true}).count(), 0);                                               // 685
              }));                                                                                                     // 686
          },                                                                                                           // 687
          // update executes when it should                                                                            // 688
          function (test, expect) {                                                                                    // 689
            collection.update(                                                                                         // 690
              canUpdateId,                                                                                             // 691
              {$set: {updated: true}},                                                                                 // 692
              expect(function (err, res) {                                                                             // 693
                test.isFalse(err);                                                                                     // 694
                test.equal(res, 1);                                                                                    // 695
                test.equal(collection.find({updated: true}).count(), 1);                                               // 696
              }));                                                                                                     // 697
          },                                                                                                           // 698
                                                                                                                       // 699
          // remove fails when trying to modify a doc with no `canRemove` set                                          // 700
          function (test, expect) {                                                                                    // 701
            collection.remove(canUpdateId,                                                                             // 702
                              expect(function (err, res) {                                                             // 703
              test.equal(err.error, 403);                                                                              // 704
              // nothing has changed                                                                                   // 705
              test.equal(collection.find().count(), 3);                                                                // 706
            }));                                                                                                       // 707
          },                                                                                                           // 708
          // remove fails when trying to modify an doc with `cantRemove`                                               // 709
          // set                                                                                                       // 710
          function (test, expect) {                                                                                    // 711
            collection.remove(canRemoveId,                                                                             // 712
                              expect(function (err, res) {                                                             // 713
              test.equal(err.error, 403);                                                                              // 714
              // nothing has changed                                                                                   // 715
              test.equal(collection.find().count(), 3);                                                                // 716
            }));                                                                                                       // 717
          },                                                                                                           // 718
                                                                                                                       // 719
          // update the doc to remove cantRemove.                                                                      // 720
          function (test, expect) {                                                                                    // 721
            collection.update(                                                                                         // 722
              canRemoveId,                                                                                             // 723
              {$set: {cantRemove: false, canUpdate2: true}},                                                           // 724
              expect(function (err, res) {                                                                             // 725
                test.isFalse(err);                                                                                     // 726
                test.equal(res, 1);                                                                                    // 727
                test.equal(collection.find({cantRemove: true}).count(), 0);                                            // 728
              }));                                                                                                     // 729
          },                                                                                                           // 730
                                                                                                                       // 731
          // now remove can remove it.                                                                                 // 732
          function (test, expect) {                                                                                    // 733
            collection.remove(canRemoveId,                                                                             // 734
                              expect(function (err, res) {                                                             // 735
              test.isFalse(err);                                                                                       // 736
              test.equal(res, 1);                                                                                      // 737
              // successfully removed                                                                                  // 738
              test.equal(collection.find().count(), 2);                                                                // 739
            }));                                                                                                       // 740
          },                                                                                                           // 741
                                                                                                                       // 742
          // try to remove a doc that doesn't exist. see we remove no docs.                                            // 743
          function (test, expect) {                                                                                    // 744
            collection.remove('some-random-id-that-never-matches',                                                     // 745
                              expect(function (err, res) {                                                             // 746
              test.isFalse(err);                                                                                       // 747
              test.equal(res, 0);                                                                                      // 748
              // nothing removed                                                                                       // 749
              test.equal(collection.find().count(), 2);                                                                // 750
            }));                                                                                                       // 751
          },                                                                                                           // 752
                                                                                                                       // 753
          // methods can still bypass restrictions                                                                     // 754
          function (test, expect) {                                                                                    // 755
            collection.callClearMethod(                                                                                // 756
              expect(function (err, res) {                                                                             // 757
                test.isFalse(err);                                                                                     // 758
                // successfully removed                                                                                // 759
                test.equal(collection.find().count(), 0);                                                              // 760
            }));                                                                                                       // 761
          }                                                                                                            // 762
        ]);                                                                                                            // 763
      });                                                                                                              // 764
    testAsyncMulti(                                                                                                    // 765
      "collection - allow/deny transform must return object, " + idGeneration,                                         // 766
      [function (test, expect) {                                                                                       // 767
        restrictedCollectionForInvalidTransformTest.insert({}, expect(function (err, res) {                            // 768
          test.isTrue(err);                                                                                            // 769
        }));                                                                                                           // 770
      }]);                                                                                                             // 771
    testAsyncMulti(                                                                                                    // 772
      "collection - restricted collection allows client-side id, " + idGeneration,                                     // 773
      [function (test, expect) {                                                                                       // 774
        var self = this;                                                                                               // 775
        self.id = Random.id();                                                                                         // 776
        restrictedCollectionForClientIdTest.insert({_id: self.id}, expect(function (err, res) {                        // 777
          test.isFalse(err);                                                                                           // 778
          test.equal(res, self.id);                                                                                    // 779
          test.equal(restrictedCollectionForClientIdTest.findOne(self.id),                                             // 780
                     {_id: self.id});                                                                                  // 781
        }));                                                                                                           // 782
      }]);                                                                                                             // 783
  });  // end idGeneration loop                                                                                        // 784
}  // end if isClient                                                                                                  // 785
                                                                                                                       // 786
                                                                                                                       // 787
                                                                                                                       // 788
// A few simple server-only tests which don't need to coordinate collections                                           // 789
// with the client..                                                                                                   // 790
if (Meteor.isServer) {                                                                                                 // 791
  Tinytest.add("collection - allow and deny validate options", function (test) {                                       // 792
    var collection = new Meteor.Collection(null);                                                                      // 793
                                                                                                                       // 794
    test.throws(function () {                                                                                          // 795
      collection.allow({invalidOption: true});                                                                         // 796
    });                                                                                                                // 797
    test.throws(function () {                                                                                          // 798
      collection.deny({invalidOption: true});                                                                          // 799
    });                                                                                                                // 800
                                                                                                                       // 801
    _.each(['insert', 'update', 'remove', 'fetch'], function (key) {                                                   // 802
      var options = {};                                                                                                // 803
      options[key] = true;                                                                                             // 804
      test.throws(function () {                                                                                        // 805
        collection.allow(options);                                                                                     // 806
      });                                                                                                              // 807
      test.throws(function () {                                                                                        // 808
        collection.deny(options);                                                                                      // 809
      });                                                                                                              // 810
    });                                                                                                                // 811
                                                                                                                       // 812
    _.each(['insert', 'update', 'remove'], function (key) {                                                            // 813
      var options = {};                                                                                                // 814
      options[key] = ['an array']; // this should be a function, not an array                                          // 815
      test.throws(function () {                                                                                        // 816
        collection.allow(options);                                                                                     // 817
      });                                                                                                              // 818
      test.throws(function () {                                                                                        // 819
        collection.deny(options);                                                                                      // 820
      });                                                                                                              // 821
    });                                                                                                                // 822
                                                                                                                       // 823
    test.throws(function () {                                                                                          // 824
      collection.allow({fetch: function () {}}); // this should be an array                                            // 825
    });                                                                                                                // 826
  });                                                                                                                  // 827
                                                                                                                       // 828
  Tinytest.add("collection - calling allow restricts", function (test) {                                               // 829
    var collection = new Meteor.Collection(null);                                                                      // 830
    test.equal(collection._restricted, false);                                                                         // 831
    collection.allow({                                                                                                 // 832
      insert: function() {}                                                                                            // 833
    });                                                                                                                // 834
    test.equal(collection._restricted, true);                                                                          // 835
  });                                                                                                                  // 836
                                                                                                                       // 837
  Tinytest.add("collection - global insecure", function (test) {                                                       // 838
    // note: This test alters the global insecure status, by sneakily hacking                                          // 839
    // the global Package object!                                                                                      // 840
    var insecurePackage = Package.insecure;                                                                            // 841
                                                                                                                       // 842
    Package.insecure = {};                                                                                             // 843
    var collection = new Meteor.Collection(null);                                                                      // 844
    test.equal(collection._isInsecure(), true);                                                                        // 845
                                                                                                                       // 846
    Package.insecure = undefined;                                                                                      // 847
    test.equal(collection._isInsecure(), false);                                                                       // 848
                                                                                                                       // 849
    delete Package.insecure;                                                                                           // 850
    test.equal(collection._isInsecure(), false);                                                                       // 851
                                                                                                                       // 852
    collection._insecure = true;                                                                                       // 853
    test.equal(collection._isInsecure(), true);                                                                        // 854
                                                                                                                       // 855
    if (insecurePackage)                                                                                               // 856
      Package.insecure = insecurePackage;                                                                              // 857
    else                                                                                                               // 858
      delete Package.insecure;                                                                                         // 859
  });                                                                                                                  // 860
}                                                                                                                      // 861
                                                                                                                       // 862
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/collection_tests.js                                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
Tinytest.add(                                                                                                          // 1
  'collection - call Meteor.Collection without new',                                                                   // 2
  function (test) {                                                                                                    // 3
    test.throws(                                                                                                       // 4
      function () {                                                                                                    // 5
        Meteor.Collection(null);                                                                                       // 6
      },                                                                                                               // 7
      /use "new" to construct a Meteor\.Collection/                                                                    // 8
    );                                                                                                                 // 9
  }                                                                                                                    // 10
);                                                                                                                     // 11
                                                                                                                       // 12
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/observe_changes_tests.js                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
var makeCollection = function () {                                                                                     // 1
  if (Meteor.isServer)                                                                                                 // 2
    return new Meteor.Collection(Random.id());                                                                         // 3
  else                                                                                                                 // 4
    return new Meteor.Collection(null);                                                                                // 5
};                                                                                                                     // 6
                                                                                                                       // 7
_.each ([{added:'added', forceOrdered: true},                                                                          // 8
         {added:'added', forceOrdered: false},                                                                         // 9
         {added: 'addedBefore', forceOrdered: false}], function (options) {                                            // 10
           var added = options.added;                                                                                  // 11
           var forceOrdered = options.forceOrdered;                                                                    // 12
  Tinytest.addAsync("observeChanges - single id - basics "                                                             // 13
                    + added                                                                                            // 14
                    + (forceOrdered ? " force ordered" : ""),                                                          // 15
                    function (test, onComplete) {                                                                      // 16
    var c = makeCollection();                                                                                          // 17
    var counter = 0;                                                                                                   // 18
    var callbacks = [added, "changed", "removed"];                                                                     // 19
    if (forceOrdered)                                                                                                  // 20
      callbacks.push("movedBefore");                                                                                   // 21
    withCallbackLogger(test,                                                                                           // 22
                       callbacks,                                                                                      // 23
                       Meteor.isServer,                                                                                // 24
                       function (logger) {                                                                             // 25
    var barid = c.insert({thing: "stuff"});                                                                            // 26
    var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                               // 27
                                                                                                                       // 28
    var handle = c.find(fooid).observeChanges(logger);                                                                 // 29
    if (added === 'added')                                                                                             // 30
      logger.expectResult(added, [fooid, {noodles: "good", bacon: "bad",apples: "ok"}]);                               // 31
    else                                                                                                               // 32
      logger.expectResult(added,                                                                                       // 33
                          [fooid, {noodles: "good", bacon: "bad", apples: "ok"}, null]);                               // 34
    c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok"});                                            // 35
    logger.expectResult("changed",                                                                                     // 36
                        [fooid, {noodles: "alright", potatoes: "tasty", bacon: undefined}]);                           // 37
                                                                                                                       // 38
    c.remove(fooid);                                                                                                   // 39
    logger.expectResult("removed", [fooid]);                                                                           // 40
                                                                                                                       // 41
    c.remove(barid);                                                                                                   // 42
                                                                                                                       // 43
    c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                           // 44
    logger.expectNoResult();                                                                                           // 45
    handle.stop();                                                                                                     // 46
                                                                                                                       // 47
    var badCursor = c.find({}, {fields: {noodles: 1, _id: false}});                                                    // 48
    test.throws(function () {                                                                                          // 49
      badCursor.observeChanges(logger);                                                                                // 50
    });                                                                                                                // 51
                                                                                                                       // 52
    onComplete();                                                                                                      // 53
    });                                                                                                                // 54
  });                                                                                                                  // 55
});                                                                                                                    // 56
                                                                                                                       // 57
Tinytest.addAsync("observeChanges - callback isolation", function (test, onComplete) {                                 // 58
  var c = makeCollection();                                                                                            // 59
  withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                       // 60
    var handles = [];                                                                                                  // 61
    var cursor = c.find();                                                                                             // 62
    handles.push(cursor.observeChanges(logger));                                                                       // 63
    // fields-tampering observer                                                                                       // 64
    handles.push(cursor.observeChanges({                                                                               // 65
      added: function(id, fields) {                                                                                    // 66
        fields.apples = 'green';                                                                                       // 67
      },                                                                                                               // 68
      changed: function(id, fields) {                                                                                  // 69
        fields.apples = 'green';                                                                                       // 70
      },                                                                                                               // 71
    }));                                                                                                               // 72
                                                                                                                       // 73
    var fooid = c.insert({apples: "ok"});                                                                              // 74
    logger.expectResult("added", [fooid, {apples: "ok"}]);                                                             // 75
                                                                                                                       // 76
    c.update(fooid, {apples: "not ok"})                                                                                // 77
    logger.expectResult("changed", [fooid, {apples: "not ok"}]);                                                       // 78
                                                                                                                       // 79
    test.equal(c.findOne(fooid).apples, "not ok");                                                                     // 80
                                                                                                                       // 81
    _.each(handles, function(handle) { handle.stop(); });                                                              // 82
    onComplete();                                                                                                      // 83
  });                                                                                                                  // 84
                                                                                                                       // 85
});                                                                                                                    // 86
                                                                                                                       // 87
Tinytest.addAsync("observeChanges - single id - initial adds", function (test, onComplete) {                           // 88
  var c = makeCollection();                                                                                            // 89
  withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                       // 90
  var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                 // 91
  var handle = c.find(fooid).observeChanges(logger);                                                                   // 92
  logger.expectResult("added", [fooid, {noodles: "good", bacon: "bad", apples: "ok"}]);                                // 93
  logger.expectNoResult();                                                                                             // 94
  handle.stop();                                                                                                       // 95
  onComplete();                                                                                                        // 96
  });                                                                                                                  // 97
});                                                                                                                    // 98
                                                                                                                       // 99
                                                                                                                       // 100
                                                                                                                       // 101
Tinytest.addAsync("observeChanges - unordered - initial adds", function (test, onComplete) {                           // 102
  var c = makeCollection();                                                                                            // 103
  withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                       // 104
  var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                 // 105
  var barid = c.insert({noodles: "good", bacon: "weird", apples: "ok"});                                               // 106
  var handle = c.find().observeChanges(logger);                                                                        // 107
  logger.expectResultUnordered([                                                                                       // 108
    {callback: "added",                                                                                                // 109
     args: [fooid, {noodles: "good", bacon: "bad", apples: "ok"}]},                                                    // 110
    {callback: "added",                                                                                                // 111
     args: [barid, {noodles: "good", bacon: "weird", apples: "ok"}]}                                                   // 112
  ]);                                                                                                                  // 113
  logger.expectNoResult();                                                                                             // 114
  handle.stop();                                                                                                       // 115
  onComplete();                                                                                                        // 116
  });                                                                                                                  // 117
});                                                                                                                    // 118
                                                                                                                       // 119
Tinytest.addAsync("observeChanges - unordered - basics", function (test, onComplete) {                                 // 120
  var c = makeCollection();                                                                                            // 121
  withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                       // 122
  var handle = c.find().observeChanges(logger);                                                                        // 123
  var barid = c.insert({thing: "stuff"});                                                                              // 124
  logger.expectResultOnly("added", [barid, {thing: "stuff"}]);                                                         // 125
                                                                                                                       // 126
  var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                 // 127
                                                                                                                       // 128
  logger.expectResultOnly("added", [fooid, {noodles: "good", bacon: "bad", apples: "ok"}]);                            // 129
                                                                                                                       // 130
  c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok"});                                              // 131
  c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok"});                                              // 132
  logger.expectResultOnly("changed",                                                                                   // 133
                      [fooid, {noodles: "alright", potatoes: "tasty", bacon: undefined}]);                             // 134
  c.remove(fooid);                                                                                                     // 135
  logger.expectResultOnly("removed", [fooid]);                                                                         // 136
  c.remove(barid);                                                                                                     // 137
  logger.expectResultOnly("removed", [barid]);                                                                         // 138
                                                                                                                       // 139
  fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                     // 140
                                                                                                                       // 141
  logger.expectResult("added", [fooid, {noodles: "good", bacon: "bad", apples: "ok"}]);                                // 142
  logger.expectNoResult();                                                                                             // 143
  handle.stop();                                                                                                       // 144
  onComplete();                                                                                                        // 145
  });                                                                                                                  // 146
});                                                                                                                    // 147
                                                                                                                       // 148
if (Meteor.isServer) {                                                                                                 // 149
  Tinytest.addAsync("observeChanges - unordered - specific fields", function (test, onComplete) {                      // 150
    var c = makeCollection();                                                                                          // 151
    withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                     // 152
      var handle = c.find({}, {fields:{noodles: 1, bacon: 1}}).observeChanges(logger);                                 // 153
      var barid = c.insert({thing: "stuff"});                                                                          // 154
      logger.expectResultOnly("added", [barid, {}]);                                                                   // 155
                                                                                                                       // 156
      var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                             // 157
                                                                                                                       // 158
      logger.expectResultOnly("added", [fooid, {noodles: "good", bacon: "bad"}]);                                      // 159
                                                                                                                       // 160
      c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok"});                                          // 161
      logger.expectResultOnly("changed",                                                                               // 162
                              [fooid, {noodles: "alright", bacon: undefined}]);                                        // 163
      c.update(fooid, {noodles: "alright", potatoes: "meh", apples: "ok"});                                            // 164
      c.remove(fooid);                                                                                                 // 165
      logger.expectResultOnly("removed", [fooid]);                                                                     // 166
      c.remove(barid);                                                                                                 // 167
      logger.expectResultOnly("removed", [barid]);                                                                     // 168
                                                                                                                       // 169
      fooid = c.insert({noodles: "good", bacon: "bad"});                                                               // 170
                                                                                                                       // 171
      logger.expectResult("added", [fooid, {noodles: "good", bacon: "bad"}]);                                          // 172
      logger.expectNoResult();                                                                                         // 173
      handle.stop();                                                                                                   // 174
      onComplete();                                                                                                    // 175
    });                                                                                                                // 176
  });                                                                                                                  // 177
                                                                                                                       // 178
  Tinytest.addAsync("observeChanges - unordered - specific fields + selector on excluded fields", function (test, onComplete) {
    var c = makeCollection();                                                                                          // 180
    withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                     // 181
      var handle = c.find({ mac: 1, cheese: 2 },                                                                       // 182
                          {fields:{noodles: 1, bacon: 1, eggs: 1}}).observeChanges(logger);                            // 183
      var barid = c.insert({thing: "stuff", mac: 1, cheese: 2});                                                       // 184
      logger.expectResultOnly("added", [barid, {}]);                                                                   // 185
                                                                                                                       // 186
      var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok", mac: 1, cheese: 2});                          // 187
                                                                                                                       // 188
      logger.expectResultOnly("added", [fooid, {noodles: "good", bacon: "bad"}]);                                      // 189
                                                                                                                       // 190
      c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok", mac: 1, cheese: 2});                       // 191
      logger.expectResultOnly("changed",                                                                               // 192
                              [fooid, {noodles: "alright", bacon: undefined}]);                                        // 193
                                                                                                                       // 194
      // Doesn't get update event, since modifies only hidden fields                                                   // 195
      c.update(fooid, {noodles: "alright", potatoes: "meh", apples: "ok", mac: 1, cheese: 2});                         // 196
      logger.expectNoResult();                                                                                         // 197
                                                                                                                       // 198
      c.remove(fooid);                                                                                                 // 199
      logger.expectResultOnly("removed", [fooid]);                                                                     // 200
      c.remove(barid);                                                                                                 // 201
      logger.expectResultOnly("removed", [barid]);                                                                     // 202
                                                                                                                       // 203
      fooid = c.insert({noodles: "good", bacon: "bad", mac: 1, cheese: 2});                                            // 204
                                                                                                                       // 205
      logger.expectResult("added", [fooid, {noodles: "good", bacon: "bad"}]);                                          // 206
      logger.expectNoResult();                                                                                         // 207
      handle.stop();                                                                                                   // 208
      onComplete();                                                                                                    // 209
    });                                                                                                                // 210
  });                                                                                                                  // 211
                                                                                                                       // 212
  Tinytest.addAsync("observeChanges - unordered - specific fields + modify on excluded fields", function (test, onComplete) {
    var c = makeCollection();                                                                                          // 214
    withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                     // 215
      var handle = c.find({ mac: 1, cheese: 2 },                                                                       // 216
                          {fields:{noodles: 1, bacon: 1, eggs: 1}}).observeChanges(logger);                            // 217
      var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok", mac: 1, cheese: 2});                          // 218
                                                                                                                       // 219
      logger.expectResultOnly("added", [fooid, {noodles: "good", bacon: "bad"}]);                                      // 220
                                                                                                                       // 221
                                                                                                                       // 222
      // Noodles go into shadow, mac appears as eggs                                                                   // 223
      c.update(fooid, {$rename: { noodles: 'shadow', apples: 'eggs' }});                                               // 224
      logger.expectResultOnly("changed",                                                                               // 225
                              [fooid, {eggs:"ok", noodles: undefined}]);                                               // 226
                                                                                                                       // 227
      c.remove(fooid);                                                                                                 // 228
      logger.expectResultOnly("removed", [fooid]);                                                                     // 229
      logger.expectNoResult();                                                                                         // 230
      handle.stop();                                                                                                   // 231
      onComplete();                                                                                                    // 232
    });                                                                                                                // 233
  });                                                                                                                  // 234
}                                                                                                                      // 235
                                                                                                                       // 236
                                                                                                                       // 237
Tinytest.addAsync("observeChanges - unordered - enters and exits result set through change", function (test, onComplete) {
  var c = makeCollection();                                                                                            // 239
  withCallbackLogger(test, ["added", "changed", "removed"], Meteor.isServer, function (logger) {                       // 240
  var handle = c.find({noodles: "good"}).observeChanges(logger);                                                       // 241
  var barid = c.insert({thing: "stuff"});                                                                              // 242
                                                                                                                       // 243
  var fooid = c.insert({noodles: "good", bacon: "bad", apples: "ok"});                                                 // 244
  logger.expectResultOnly("added", [fooid, {noodles: "good", bacon: "bad", apples: "ok"}]);                            // 245
                                                                                                                       // 246
  c.update(fooid, {noodles: "alright", potatoes: "tasty", apples: "ok"});                                              // 247
  logger.expectResultOnly("removed",                                                                                   // 248
                      [fooid]);                                                                                        // 249
  c.remove(fooid);                                                                                                     // 250
  c.remove(barid);                                                                                                     // 251
                                                                                                                       // 252
  fooid = c.insert({noodles: "ok", bacon: "bad", apples: "ok"});                                                       // 253
  c.update(fooid, {noodles: "good", potatoes: "tasty", apples: "ok"});                                                 // 254
  logger.expectResult("added", [fooid, {noodles: "good", potatoes: "tasty", apples: "ok"}]);                           // 255
  logger.expectNoResult();                                                                                             // 256
  handle.stop();                                                                                                       // 257
  onComplete();                                                                                                        // 258
  });                                                                                                                  // 259
});                                                                                                                    // 260
                                                                                                                       // 261
                                                                                                                       // 262
if (Meteor.isServer) {                                                                                                 // 263
  testAsyncMulti("observeChanges - tailable", [                                                                        // 264
    function (test, expect) {                                                                                          // 265
      var self = this;                                                                                                 // 266
      var collName = "cap_" + Random.id();                                                                             // 267
      var coll = new Meteor.Collection(collName);                                                                      // 268
      coll._createCappedCollection(1000000);                                                                           // 269
      self.xs = [];                                                                                                    // 270
      self.expects = [];                                                                                               // 271
      self.insert = function (fields) {                                                                                // 272
        coll.insert(_.extend({ts: new MongoInternals.MongoTimestamp(0, 0)},                                            // 273
                             fields));                                                                                 // 274
      };                                                                                                               // 275
                                                                                                                       // 276
      // Tailable observe shouldn't show things that are in the initial                                                // 277
      // contents.                                                                                                     // 278
      self.insert({x: 1});                                                                                             // 279
      // Wait for one added call before going to the next test function.                                               // 280
      self.expects.push(expect());                                                                                     // 281
                                                                                                                       // 282
      var cursor = coll.find({y: {$ne: 7}}, {tailable: true});                                                         // 283
      self.handle = cursor.observeChanges({                                                                            // 284
        added: function (id, fields) {                                                                                 // 285
          self.xs.push(fields.x);                                                                                      // 286
          test.notEqual(self.expects.length, 0);                                                                       // 287
          self.expects.pop()();                                                                                        // 288
        },                                                                                                             // 289
        changed: function () {                                                                                         // 290
          test.fail({unexpected: "changed"});                                                                          // 291
        },                                                                                                             // 292
        removed: function () {                                                                                         // 293
          test.fail({unexpected: "removed"});                                                                          // 294
        }                                                                                                              // 295
      });                                                                                                              // 296
                                                                                                                       // 297
      // Nothing happens synchronously.                                                                                // 298
      test.equal(self.xs, []);                                                                                         // 299
    },                                                                                                                 // 300
    function (test, expect) {                                                                                          // 301
      var self = this;                                                                                                 // 302
      // The cursors sees the first element.                                                                           // 303
      test.equal(self.xs, [1]);                                                                                        // 304
      self.xs = [];                                                                                                    // 305
                                                                                                                       // 306
      self.insert({x: 2, y: 3});                                                                                       // 307
      self.insert({x: 3, y: 7});  // filtered out by the query                                                         // 308
      self.insert({x: 4});                                                                                             // 309
      // Expect two added calls to happen.                                                                             // 310
      self.expects = [expect(), expect()];                                                                             // 311
    },                                                                                                                 // 312
    function (test, expect) {                                                                                          // 313
      var self = this;                                                                                                 // 314
      test.equal(self.xs, [2, 4]);                                                                                     // 315
      self.xs = [];                                                                                                    // 316
      self.handle.stop();                                                                                              // 317
                                                                                                                       // 318
      self.insert({x: 5});                                                                                             // 319
      // XXX This timeout isn't perfect but it's pretty hard to prove that an                                          // 320
      // event WON'T happen without something like a write fence.                                                      // 321
      Meteor.setTimeout(expect(), 1000);                                                                               // 322
    },                                                                                                                 // 323
    function (test, expect) {                                                                                          // 324
      var self = this;                                                                                                 // 325
      test.equal(self.xs, []);                                                                                         // 326
    }                                                                                                                  // 327
  ]);                                                                                                                  // 328
}                                                                                                                      // 329
                                                                                                                       // 330
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/oplog_tests.js                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
var OplogCollection = new Meteor.Collection("oplog-" + Random.id());                                                   // 1
                                                                                                                       // 2
Tinytest.add("mongo-livedata - oplog - cursorSupported", function (test) {                                             // 3
  var oplogEnabled =                                                                                                   // 4
        !!MongoInternals.defaultRemoteCollectionDriver().mongo._oplogHandle;                                           // 5
                                                                                                                       // 6
  var supported = function (expected, selector, options) {                                                             // 7
    var cursor = OplogCollection.find(selector, options);                                                              // 8
    var handle = cursor.observeChanges({added: function () {}});                                                       // 9
    // If there's no oplog at all, we shouldn't ever use it.                                                           // 10
    if (!oplogEnabled)                                                                                                 // 11
      expected = false;                                                                                                // 12
    test.equal(!!handle._multiplexer._observeDriver._usesOplog, expected);                                             // 13
    handle.stop();                                                                                                     // 14
  };                                                                                                                   // 15
                                                                                                                       // 16
  supported(true, "asdf");                                                                                             // 17
  supported(true, 1234);                                                                                               // 18
  supported(true, new Meteor.Collection.ObjectID());                                                                   // 19
                                                                                                                       // 20
  supported(true, {_id: "asdf"});                                                                                      // 21
  supported(true, {_id: 1234});                                                                                        // 22
  supported(true, {_id: new Meteor.Collection.ObjectID()});                                                            // 23
                                                                                                                       // 24
  supported(true, {foo: "asdf",                                                                                        // 25
                   bar: 1234,                                                                                          // 26
                   baz: new Meteor.Collection.ObjectID(),                                                              // 27
                   eeney: true,                                                                                        // 28
                   miney: false,                                                                                       // 29
                   moe: null});                                                                                        // 30
                                                                                                                       // 31
  supported(true, {});                                                                                                 // 32
                                                                                                                       // 33
  supported(true, {$and: [{foo: "asdf"}, {bar: "baz"}]});                                                              // 34
  supported(true, {foo: {x: 1}});                                                                                      // 35
  supported(true, {foo: {$gt: 1}});                                                                                    // 36
  supported(true, {foo: [1, 2, 3]});                                                                                   // 37
                                                                                                                       // 38
  // No $where.                                                                                                        // 39
  supported(false, {$where: "xxx"});                                                                                   // 40
  supported(false, {$and: [{foo: "adsf"}, {$where: "xxx"}]});                                                          // 41
  // No geoqueries.                                                                                                    // 42
  supported(false, {x: {$near: [1,1]}});                                                                               // 43
  // Nothing Minimongo doesn't understand.  (Minimongo happens to fail to                                              // 44
  // implement $elemMatch inside $all which MongoDB supports.)                                                         // 45
  supported(false, {x: {$all: [{$elemMatch: {y: 2}}]}});                                                               // 46
                                                                                                                       // 47
  supported(true, {}, { sort: {x:1} });                                                                                // 48
  supported(true, {}, { sort: {x:1}, limit: 5 });                                                                      // 49
  supported(false, {}, { sort: {$natural:1}, limit: 5 });                                                              // 50
  supported(false, {}, { limit: 5 });                                                                                  // 51
  supported(false, {}, { skip: 2, limit: 5 });                                                                         // 52
  supported(false, {}, { skip: 2 });                                                                                   // 53
});                                                                                                                    // 54
                                                                                                                       // 55
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/mongo-livedata/doc_fetcher_tests.js                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
var Fiber = Npm.require('fibers');                                                                                     // 1
var Future = Npm.require('fibers/future');                                                                             // 2
                                                                                                                       // 3
testAsyncMulti("mongo-livedata - doc fetcher", [                                                                       // 4
  function (test, expect) {                                                                                            // 5
    var self = this;                                                                                                   // 6
    var collName = "docfetcher-" + Random.id();                                                                        // 7
    var collection = new Meteor.Collection(collName);                                                                  // 8
    var id1 = collection.insert({x: 1});                                                                               // 9
    var id2 = collection.insert({y: 2});                                                                               // 10
                                                                                                                       // 11
    var fetcher = new MongoTest.DocFetcher(                                                                            // 12
      MongoInternals.defaultRemoteCollectionDriver().mongo);                                                           // 13
                                                                                                                       // 14
    // Test basic operation.                                                                                           // 15
    fetcher.fetch(collName, id1, Random.id(), expect(null, {_id: id1, x: 1}));                                         // 16
    fetcher.fetch(collName, "nonexistent!", Random.id(), expect(null, null));                                          // 17
                                                                                                                       // 18
    var fetched = false;                                                                                               // 19
    var cacheKey = Random.id();                                                                                        // 20
    var expected = {_id: id2, y: 2};                                                                                   // 21
    fetcher.fetch(collName, id2, cacheKey, expect(function (e, d) {                                                    // 22
      fetched = true;                                                                                                  // 23
      test.isFalse(e);                                                                                                 // 24
      test.equal(d, expected);                                                                                         // 25
    }));                                                                                                               // 26
    // The fetcher yields.                                                                                             // 27
    test.isFalse(fetched);                                                                                             // 28
                                                                                                                       // 29
    // Now ask for another document with the same cache key. Because a fetch for                                       // 30
    // that cache key is in flight, we will get the other fetch's document, not                                        // 31
    // this random document.                                                                                           // 32
    fetcher.fetch(collName, Random.id(), cacheKey, expect(function (e, d) {                                            // 33
      test.isFalse(e);                                                                                                 // 34
      test.equal(d, expected);                                                                                         // 35
    }));                                                                                                               // 36
  }                                                                                                                    // 37
]);                                                                                                                    // 38
                                                                                                                       // 39
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
