(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                          //
// packages/minimongo/minimongo_tests.js                                                                    //
//                                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                            //
                                                                                                            // 1
// Hack to make LocalCollection generate ObjectIDs by default.                                              // 2
LocalCollection._useOID = true;                                                                             // 3
                                                                                                            // 4
// assert that f is a strcmp-style comparison function that puts                                            // 5
// 'values' in the provided order                                                                           // 6
                                                                                                            // 7
var assert_ordering = function (test, f, values) {                                                          // 8
  for (var i = 0; i < values.length; i++) {                                                                 // 9
    var x = f(values[i], values[i]);                                                                        // 10
    if (x !== 0) {                                                                                          // 11
      // XXX super janky                                                                                    // 12
      test.fail({type: "minimongo-ordering",                                                                // 13
                 message: "value doesn't order as equal to itself",                                         // 14
                 value: JSON.stringify(values[i]),                                                          // 15
                 should_be_zero_but_got: JSON.stringify(x)});                                               // 16
    }                                                                                                       // 17
    if (i + 1 < values.length) {                                                                            // 18
      var less = values[i];                                                                                 // 19
      var more = values[i + 1];                                                                             // 20
      var x = f(less, more);                                                                                // 21
      if (!(x < 0)) {                                                                                       // 22
        // XXX super janky                                                                                  // 23
        test.fail({type: "minimongo-ordering",                                                              // 24
                   message: "ordering test failed",                                                         // 25
                   first: JSON.stringify(less),                                                             // 26
                   second: JSON.stringify(more),                                                            // 27
                   should_be_negative_but_got: JSON.stringify(x)});                                         // 28
      }                                                                                                     // 29
      x = f(more, less);                                                                                    // 30
      if (!(x > 0)) {                                                                                       // 31
        // XXX super janky                                                                                  // 32
        test.fail({type: "minimongo-ordering",                                                              // 33
                   message: "ordering test failed",                                                         // 34
                   first: JSON.stringify(less),                                                             // 35
                   second: JSON.stringify(more),                                                            // 36
                   should_be_positive_but_got: JSON.stringify(x)});                                         // 37
      }                                                                                                     // 38
    }                                                                                                       // 39
  }                                                                                                         // 40
};                                                                                                          // 41
                                                                                                            // 42
var log_callbacks = function (operations) {                                                                 // 43
  return {                                                                                                  // 44
    addedAt: function (obj, idx, before) {                                                                  // 45
      delete obj._id;                                                                                       // 46
      operations.push(EJSON.clone(['added', obj, idx, before]));                                            // 47
    },                                                                                                      // 48
    changedAt: function (obj, old_obj, at) {                                                                // 49
      delete obj._id;                                                                                       // 50
      delete old_obj._id;                                                                                   // 51
      operations.push(EJSON.clone(['changed', obj, at, old_obj]));                                          // 52
    },                                                                                                      // 53
    movedTo: function (obj, old_at, new_at, before) {                                                       // 54
      delete obj._id;                                                                                       // 55
      operations.push(EJSON.clone(['moved', obj, old_at, new_at, before]));                                 // 56
    },                                                                                                      // 57
    removedAt: function (old_obj, at) {                                                                     // 58
      var id = old_obj._id;                                                                                 // 59
      delete old_obj._id;                                                                                   // 60
      operations.push(EJSON.clone(['removed', id, at, old_obj]));                                           // 61
    }                                                                                                       // 62
  };                                                                                                        // 63
};                                                                                                          // 64
                                                                                                            // 65
// XXX test shared structure in all MM entrypoints                                                          // 66
Tinytest.add("minimongo - basics", function (test) {                                                        // 67
  var c = new LocalCollection(),                                                                            // 68
      fluffyKitten_id,                                                                                      // 69
      count;                                                                                                // 70
                                                                                                            // 71
  fluffyKitten_id = c.insert({type: "kitten", name: "fluffy"});                                             // 72
  c.insert({type: "kitten", name: "snookums"});                                                             // 73
  c.insert({type: "cryptographer", name: "alice"});                                                         // 74
  c.insert({type: "cryptographer", name: "bob"});                                                           // 75
  c.insert({type: "cryptographer", name: "cara"});                                                          // 76
  test.equal(c.find().count(), 5);                                                                          // 77
  test.equal(c.find({type: "kitten"}).count(), 2);                                                          // 78
  test.equal(c.find({type: "cryptographer"}).count(), 3);                                                   // 79
  test.length(c.find({type: "kitten"}).fetch(), 2);                                                         // 80
  test.length(c.find({type: "cryptographer"}).fetch(), 3);                                                  // 81
  test.equal(fluffyKitten_id, c.findOne({type: "kitten", name: "fluffy"})._id);                             // 82
                                                                                                            // 83
  c.remove({name: "cara"});                                                                                 // 84
  test.equal(c.find().count(), 4);                                                                          // 85
  test.equal(c.find({type: "kitten"}).count(), 2);                                                          // 86
  test.equal(c.find({type: "cryptographer"}).count(), 2);                                                   // 87
  test.length(c.find({type: "kitten"}).fetch(), 2);                                                         // 88
  test.length(c.find({type: "cryptographer"}).fetch(), 2);                                                  // 89
                                                                                                            // 90
  count = c.update({name: "snookums"}, {$set: {type: "cryptographer"}});                                    // 91
  test.equal(count, 1);                                                                                     // 92
  test.equal(c.find().count(), 4);                                                                          // 93
  test.equal(c.find({type: "kitten"}).count(), 1);                                                          // 94
  test.equal(c.find({type: "cryptographer"}).count(), 3);                                                   // 95
  test.length(c.find({type: "kitten"}).fetch(), 1);                                                         // 96
  test.length(c.find({type: "cryptographer"}).fetch(), 3);                                                  // 97
                                                                                                            // 98
  c.remove(null);                                                                                           // 99
  c.remove(false);                                                                                          // 100
  c.remove(undefined);                                                                                      // 101
  test.equal(c.find().count(), 4);                                                                          // 102
                                                                                                            // 103
  c.remove({_id: null});                                                                                    // 104
  c.remove({_id: false});                                                                                   // 105
  c.remove({_id: undefined});                                                                               // 106
  count = c.remove();                                                                                       // 107
  test.equal(count, 0);                                                                                     // 108
  test.equal(c.find().count(), 4);                                                                          // 109
                                                                                                            // 110
  count = c.remove({});                                                                                     // 111
  test.equal(count, 4);                                                                                     // 112
  test.equal(c.find().count(), 0);                                                                          // 113
                                                                                                            // 114
  c.insert({_id: 1, name: "strawberry", tags: ["fruit", "red", "squishy"]});                                // 115
  c.insert({_id: 2, name: "apple", tags: ["fruit", "red", "hard"]});                                        // 116
  c.insert({_id: 3, name: "rose", tags: ["flower", "red", "squishy"]});                                     // 117
                                                                                                            // 118
  test.equal(c.find({tags: "flower"}).count(), 1);                                                          // 119
  test.equal(c.find({tags: "fruit"}).count(), 2);                                                           // 120
  test.equal(c.find({tags: "red"}).count(), 3);                                                             // 121
  test.length(c.find({tags: "flower"}).fetch(), 1);                                                         // 122
  test.length(c.find({tags: "fruit"}).fetch(), 2);                                                          // 123
  test.length(c.find({tags: "red"}).fetch(), 3);                                                            // 124
                                                                                                            // 125
  test.equal(c.findOne(1).name, "strawberry");                                                              // 126
  test.equal(c.findOne(2).name, "apple");                                                                   // 127
  test.equal(c.findOne(3).name, "rose");                                                                    // 128
  test.equal(c.findOne(4), undefined);                                                                      // 129
  test.equal(c.findOne("abc"), undefined);                                                                  // 130
  test.equal(c.findOne(undefined), undefined);                                                              // 131
                                                                                                            // 132
  test.equal(c.find(1).count(), 1);                                                                         // 133
  test.equal(c.find(4).count(), 0);                                                                         // 134
  test.equal(c.find("abc").count(), 0);                                                                     // 135
  test.equal(c.find(undefined).count(), 0);                                                                 // 136
  test.equal(c.find().count(), 3);                                                                          // 137
  test.equal(c.find(1, {skip: 1}).count(), 0);                                                              // 138
  test.equal(c.find({_id: 1}, {skip: 1}).count(), 0);                                                       // 139
  test.equal(c.find({}, {skip: 1}).count(), 2);                                                             // 140
  test.equal(c.find({}, {skip: 2}).count(), 1);                                                             // 141
  test.equal(c.find({}, {limit: 2}).count(), 2);                                                            // 142
  test.equal(c.find({}, {limit: 1}).count(), 1);                                                            // 143
  test.equal(c.find({}, {skip: 1, limit: 1}).count(), 1);                                                   // 144
  test.equal(c.find({tags: "fruit"}, {skip: 1}).count(), 1);                                                // 145
  test.equal(c.find({tags: "fruit"}, {limit: 1}).count(), 1);                                               // 146
  test.equal(c.find({tags: "fruit"}, {skip: 1, limit: 1}).count(), 1);                                      // 147
  test.equal(c.find(1, {sort: ['_id','desc'], skip: 1}).count(), 0);                                        // 148
  test.equal(c.find({_id: 1}, {sort: ['_id','desc'], skip: 1}).count(), 0);                                 // 149
  test.equal(c.find({}, {sort: ['_id','desc'], skip: 1}).count(), 2);                                       // 150
  test.equal(c.find({}, {sort: ['_id','desc'], skip: 2}).count(), 1);                                       // 151
  test.equal(c.find({}, {sort: ['_id','desc'], limit: 2}).count(), 2);                                      // 152
  test.equal(c.find({}, {sort: ['_id','desc'], limit: 1}).count(), 1);                                      // 153
  test.equal(c.find({}, {sort: ['_id','desc'], skip: 1, limit: 1}).count(), 1);                             // 154
  test.equal(c.find({tags: "fruit"}, {sort: ['_id','desc'], skip: 1}).count(), 1);                          // 155
  test.equal(c.find({tags: "fruit"}, {sort: ['_id','desc'], limit: 1}).count(), 1);                         // 156
  test.equal(c.find({tags: "fruit"}, {sort: ['_id','desc'], skip: 1, limit: 1}).count(), 1);                // 157
                                                                                                            // 158
  // Regression test for #455.                                                                              // 159
  c.insert({foo: {bar: 'baz'}});                                                                            // 160
  test.equal(c.find({foo: {bam: 'baz'}}).count(), 0);                                                       // 161
  test.equal(c.find({foo: {bar: 'baz'}}).count(), 1);                                                       // 162
                                                                                                            // 163
});                                                                                                         // 164
                                                                                                            // 165
Tinytest.add("minimongo - cursors", function (test) {                                                       // 166
  var c = new LocalCollection();                                                                            // 167
  var res;                                                                                                  // 168
                                                                                                            // 169
  for (var i = 0; i < 20; i++)                                                                              // 170
    c.insert({i: i});                                                                                       // 171
                                                                                                            // 172
  var q = c.find();                                                                                         // 173
  test.equal(q.count(), 20);                                                                                // 174
                                                                                                            // 175
  // fetch                                                                                                  // 176
  res = q.fetch();                                                                                          // 177
  test.length(res, 20);                                                                                     // 178
  for (var i = 0; i < 20; i++) {                                                                            // 179
    test.equal(res[i].i, i);                                                                                // 180
  }                                                                                                         // 181
  // call it again, it still works                                                                          // 182
  test.length(q.fetch(), 20);                                                                               // 183
                                                                                                            // 184
  // forEach                                                                                                // 185
  var count = 0;                                                                                            // 186
  var context = {};                                                                                         // 187
  q.forEach(function (obj, i, cursor) {                                                                     // 188
    test.equal(obj.i, count++);                                                                             // 189
    test.equal(obj.i, i);                                                                                   // 190
    test.isTrue(context === this);                                                                          // 191
    test.isTrue(cursor === q);                                                                              // 192
  }, context);                                                                                              // 193
  test.equal(count, 20);                                                                                    // 194
  // call it again, it still works                                                                          // 195
  test.length(q.fetch(), 20);                                                                               // 196
                                                                                                            // 197
  // map                                                                                                    // 198
  res = q.map(function (obj, i, cursor) {                                                                   // 199
    test.equal(obj.i, i);                                                                                   // 200
    test.isTrue(context === this);                                                                          // 201
    test.isTrue(cursor === q);                                                                              // 202
    return obj.i * 2;                                                                                       // 203
  }, context);                                                                                              // 204
  test.length(res, 20);                                                                                     // 205
  for (var i = 0; i < 20; i++)                                                                              // 206
    test.equal(res[i], i * 2);                                                                              // 207
  // call it again, it still works                                                                          // 208
  test.length(q.fetch(), 20);                                                                               // 209
                                                                                                            // 210
  // findOne (and no rewind first)                                                                          // 211
  test.equal(c.findOne({i: 0}).i, 0);                                                                       // 212
  test.equal(c.findOne({i: 1}).i, 1);                                                                       // 213
  var id = c.findOne({i: 2})._id;                                                                           // 214
  test.equal(c.findOne(id).i, 2);                                                                           // 215
});                                                                                                         // 216
                                                                                                            // 217
Tinytest.add("minimongo - transform", function (test) {                                                     // 218
  var c = new LocalCollection;                                                                              // 219
  c.insert({});                                                                                             // 220
  // transform functions must return objects                                                                // 221
  var invalidTransform = function (doc) { return doc._id; };                                                // 222
  test.throws(function () {                                                                                 // 223
    c.findOne({}, {transform: invalidTransform});                                                           // 224
  });                                                                                                       // 225
                                                                                                            // 226
  // transformed documents get _id field transplanted if not present                                        // 227
  var transformWithoutId = function (doc) { return _.omit(doc, '_id'); };                                   // 228
  test.equal(c.findOne({}, {transform: transformWithoutId})._id,                                            // 229
             c.findOne()._id);                                                                              // 230
});                                                                                                         // 231
                                                                                                            // 232
Tinytest.add("minimongo - misc", function (test) {                                                          // 233
  // deepcopy                                                                                               // 234
  var a = {a: [1, 2, 3], b: "x", c: true, d: {x: 12, y: [12]},                                              // 235
           f: null, g: new Date()};                                                                         // 236
  var b = EJSON.clone(a);                                                                                   // 237
  test.equal(a, b);                                                                                         // 238
  test.isTrue(LocalCollection._f._equal(a, b));                                                             // 239
  a.a.push(4);                                                                                              // 240
  test.length(b.a, 3);                                                                                      // 241
  a.c = false;                                                                                              // 242
  test.isTrue(b.c);                                                                                         // 243
  b.d.z = 15;                                                                                               // 244
  a.d.z = 14;                                                                                               // 245
  test.equal(b.d.z, 15);                                                                                    // 246
  a.d.y.push(88);                                                                                           // 247
  test.length(b.d.y, 1);                                                                                    // 248
  test.equal(a.g, b.g);                                                                                     // 249
  b.g.setDate(b.g.getDate() + 1);                                                                           // 250
  test.notEqual(a.g, b.g);                                                                                  // 251
                                                                                                            // 252
  a = {x: function () {}};                                                                                  // 253
  b = EJSON.clone(a);                                                                                       // 254
  a.x.a = 14;                                                                                               // 255
  test.equal(b.x.a, 14); // just to document current behavior                                               // 256
});                                                                                                         // 257
                                                                                                            // 258
Tinytest.add("minimongo - lookup", function (test) {                                                        // 259
  var lookupA = MinimongoTest.makeLookupFunction('a');                                                      // 260
  test.equal(lookupA({}), [{value: undefined}]);                                                            // 261
  test.equal(lookupA({a: 1}), [{value: 1}]);                                                                // 262
  test.equal(lookupA({a: [1]}), [{value: [1]}]);                                                            // 263
                                                                                                            // 264
  var lookupAX = MinimongoTest.makeLookupFunction('a.x');                                                   // 265
  test.equal(lookupAX({a: {x: 1}}), [{value: 1}]);                                                          // 266
  test.equal(lookupAX({a: {x: [1]}}), [{value: [1]}]);                                                      // 267
  test.equal(lookupAX({a: 5}), [{value: undefined}]);                                                       // 268
  test.equal(lookupAX({a: [{x: 1}, {x: [2]}, {y: 3}]}),                                                     // 269
             [{value: 1, arrayIndices: [0]},                                                                // 270
              {value: [2], arrayIndices: [1]},                                                              // 271
              {value: undefined, arrayIndices: [2]}]);                                                      // 272
                                                                                                            // 273
  var lookupA0X = MinimongoTest.makeLookupFunction('a.0.x');                                                // 274
  test.equal(lookupA0X({a: [{x: 1}]}), [                                                                    // 275
    // From interpreting '0' as "0th array element".                                                        // 276
    {value: 1, arrayIndices: [0, 'x']},                                                                     // 277
    // From interpreting '0' as "after branching in the array, look in the                                  // 278
    // object {x:1} for a field named 0".                                                                   // 279
    {value: undefined, arrayIndices: [0]}]);                                                                // 280
  test.equal(lookupA0X({a: [{x: [1]}]}), [                                                                  // 281
    {value: [1], arrayIndices: [0, 'x']},                                                                   // 282
    {value: undefined, arrayIndices: [0]}]);                                                                // 283
  test.equal(lookupA0X({a: 5}), [{value: undefined}]);                                                      // 284
  test.equal(lookupA0X({a: [{x: 1}, {x: [2]}, {y: 3}]}), [                                                  // 285
    // From interpreting '0' as "0th array element".                                                        // 286
    {value: 1, arrayIndices: [0, 'x']},                                                                     // 287
    // From interpreting '0' as "after branching in the array, look in the                                  // 288
    // object {x:1} for a field named 0".                                                                   // 289
    {value: undefined, arrayIndices: [0]},                                                                  // 290
    {value: undefined, arrayIndices: [1]},                                                                  // 291
    {value: undefined, arrayIndices: [2]}                                                                   // 292
  ]);                                                                                                       // 293
                                                                                                            // 294
  test.equal(                                                                                               // 295
    MinimongoTest.makeLookupFunction('w.x.0.z')({                                                           // 296
      w: [{x: [{z: 5}]}]}), [                                                                               // 297
        // From interpreting '0' as "0th array element".                                                    // 298
        {value: 5, arrayIndices: [0, 0, 'x']},                                                              // 299
        // From interpreting '0' as "after branching in the array, look in the                              // 300
        // object {z:5} for a field named "0".                                                              // 301
        {value: undefined, arrayIndices: [0, 0]}                                                            // 302
      ]);                                                                                                   // 303
});                                                                                                         // 304
                                                                                                            // 305
Tinytest.add("minimongo - selector_compiler", function (test) {                                             // 306
  var matches = function (shouldMatch, selector, doc) {                                                     // 307
    var doesMatch = new Minimongo.Matcher(selector).documentMatches(doc).result;                            // 308
    if (doesMatch != shouldMatch) {                                                                         // 309
      // XXX super janky                                                                                    // 310
      test.fail({message: "minimongo match failure: document " +                                            // 311
                 (shouldMatch ? "should match, but doesn't" :                                               // 312
                  "shouldn't match, but does"),                                                             // 313
                 selector: JSON.stringify(selector),                                                        // 314
                 document: JSON.stringify(doc)                                                              // 315
                });                                                                                         // 316
    }                                                                                                       // 317
  };                                                                                                        // 318
                                                                                                            // 319
  var match = _.bind(matches, null, true);                                                                  // 320
  var nomatch = _.bind(matches, null, false);                                                               // 321
                                                                                                            // 322
  // XXX blog post about what I learned while writing these tests (weird                                    // 323
  // mongo edge cases)                                                                                      // 324
                                                                                                            // 325
  // empty selectors                                                                                        // 326
  match({}, {});                                                                                            // 327
  match({}, {a: 12});                                                                                       // 328
                                                                                                            // 329
  // scalars                                                                                                // 330
  match(1, {_id: 1, a: 'foo'});                                                                             // 331
  nomatch(1, {_id: 2, a: 'foo'});                                                                           // 332
  match('a', {_id: 'a', a: 'foo'});                                                                         // 333
  nomatch('a', {_id: 'b', a: 'foo'});                                                                       // 334
                                                                                                            // 335
  // safety                                                                                                 // 336
  nomatch(undefined, {});                                                                                   // 337
  nomatch(undefined, {_id: 'foo'});                                                                         // 338
  nomatch(false, {_id: 'foo'});                                                                             // 339
  nomatch(null, {_id: 'foo'});                                                                              // 340
  nomatch({_id: undefined}, {_id: 'foo'});                                                                  // 341
  nomatch({_id: false}, {_id: 'foo'});                                                                      // 342
  nomatch({_id: null}, {_id: 'foo'});                                                                       // 343
                                                                                                            // 344
  // matching one or more keys                                                                              // 345
  nomatch({a: 12}, {});                                                                                     // 346
  match({a: 12}, {a: 12});                                                                                  // 347
  match({a: 12}, {a: 12, b: 13});                                                                           // 348
  match({a: 12, b: 13}, {a: 12, b: 13});                                                                    // 349
  match({a: 12, b: 13}, {a: 12, b: 13, c: 14});                                                             // 350
  nomatch({a: 12, b: 13, c: 14}, {a: 12, b: 13});                                                           // 351
  nomatch({a: 12, b: 13}, {b: 13, c: 14});                                                                  // 352
                                                                                                            // 353
  match({a: 12}, {a: [12]});                                                                                // 354
  match({a: 12}, {a: [11, 12, 13]});                                                                        // 355
  nomatch({a: 12}, {a: [11, 13]});                                                                          // 356
  match({a: 12, b: 13}, {a: [11, 12, 13], b: [13, 14, 15]});                                                // 357
  nomatch({a: 12, b: 13}, {a: [11, 12, 13], b: [14, 15]});                                                  // 358
                                                                                                            // 359
  // dates                                                                                                  // 360
  var date1 = new Date;                                                                                     // 361
  var date2 = new Date(date1.getTime() + 1000);                                                             // 362
  match({a: date1}, {a: date1});                                                                            // 363
  nomatch({a: date1}, {a: date2});                                                                          // 364
                                                                                                            // 365
                                                                                                            // 366
  // arrays                                                                                                 // 367
  match({a: [1,2]}, {a: [1, 2]});                                                                           // 368
  match({a: [1,2]}, {a: [[1, 2]]});                                                                         // 369
  match({a: [1,2]}, {a: [[3, 4], [1, 2]]});                                                                 // 370
  nomatch({a: [1,2]}, {a: [3, 4]});                                                                         // 371
  nomatch({a: [1,2]}, {a: [[[1, 2]]]});                                                                     // 372
                                                                                                            // 373
  // literal documents                                                                                      // 374
  match({a: {b: 12}}, {a: {b: 12}});                                                                        // 375
  nomatch({a: {b: 12, c: 13}}, {a: {b: 12}});                                                               // 376
  nomatch({a: {b: 12}}, {a: {b: 12, c: 13}});                                                               // 377
  match({a: {b: 12, c: 13}}, {a: {b: 12, c: 13}});                                                          // 378
  nomatch({a: {b: 12, c: 13}}, {a: {c: 13, b: 12}}); // tested on mongodb                                   // 379
  nomatch({a: {}}, {a: {b: 12}});                                                                           // 380
  nomatch({a: {b:12}}, {a: {}});                                                                            // 381
  match(                                                                                                    // 382
    {a: {b: 12, c: [13, true, false, 2.2, "a", null, {d: 14}]}},                                            // 383
    {a: {b: 12, c: [13, true, false, 2.2, "a", null, {d: 14}]}});                                           // 384
  match({a: {b: 12}}, {a: {b: 12}, k: 99});                                                                 // 385
                                                                                                            // 386
  match({a: {b: 12}}, {a: [{b: 12}]});                                                                      // 387
  nomatch({a: {b: 12}}, {a: [[{b: 12}]]});                                                                  // 388
  match({a: {b: 12}}, {a: [{b: 11}, {b: 12}, {b: 13}]});                                                    // 389
  nomatch({a: {b: 12}}, {a: [{b: 11}, {b: 12, c: 20}, {b: 13}]});                                           // 390
  nomatch({a: {b: 12, c: 20}}, {a: [{b: 11}, {b: 12}, {c: 20}]});                                           // 391
  match({a: {b: 12, c: 20}}, {a: [{b: 11}, {b: 12, c: 20}, {b: 13}]});                                      // 392
                                                                                                            // 393
  // null                                                                                                   // 394
  match({a: null}, {a: null});                                                                              // 395
  match({a: null}, {b: 12});                                                                                // 396
  nomatch({a: null}, {a: 12});                                                                              // 397
  match({a: null}, {a: [1, 2, null, 3]}); // tested on mongodb                                              // 398
  nomatch({a: null}, {a: [1, 2, {}, 3]}); // tested on mongodb                                              // 399
                                                                                                            // 400
  // order comparisons: $lt, $gt, $lte, $gte                                                                // 401
  match({a: {$lt: 10}}, {a: 9});                                                                            // 402
  nomatch({a: {$lt: 10}}, {a: 10});                                                                         // 403
  nomatch({a: {$lt: 10}}, {a: 11});                                                                         // 404
                                                                                                            // 405
  match({a: {$gt: 10}}, {a: 11});                                                                           // 406
  nomatch({a: {$gt: 10}}, {a: 10});                                                                         // 407
  nomatch({a: {$gt: 10}}, {a: 9});                                                                          // 408
                                                                                                            // 409
  match({a: {$lte: 10}}, {a: 9});                                                                           // 410
  match({a: {$lte: 10}}, {a: 10});                                                                          // 411
  nomatch({a: {$lte: 10}}, {a: 11});                                                                        // 412
                                                                                                            // 413
  match({a: {$gte: 10}}, {a: 11});                                                                          // 414
  match({a: {$gte: 10}}, {a: 10});                                                                          // 415
  nomatch({a: {$gte: 10}}, {a: 9});                                                                         // 416
                                                                                                            // 417
  match({a: {$lt: 10}}, {a: [11, 9, 12]});                                                                  // 418
  nomatch({a: {$lt: 10}}, {a: [11, 12]});                                                                   // 419
                                                                                                            // 420
  // (there's a full suite of ordering test elsewhere)                                                      // 421
  nomatch({a: {$lt: "null"}}, {a: null});                                                                   // 422
  match({a: {$lt: {x: [2, 3, 4]}}}, {a: {x: [1, 3, 4]}});                                                   // 423
  match({a: {$gt: {x: [2, 3, 4]}}}, {a: {x: [3, 3, 4]}});                                                   // 424
  nomatch({a: {$gt: {x: [2, 3, 4]}}}, {a: {x: [1, 3, 4]}});                                                 // 425
  nomatch({a: {$gt: {x: [2, 3, 4]}}}, {a: {x: [2, 3, 4]}});                                                 // 426
  nomatch({a: {$lt: {x: [2, 3, 4]}}}, {a: {x: [2, 3, 4]}});                                                 // 427
  match({a: {$gte: {x: [2, 3, 4]}}}, {a: {x: [2, 3, 4]}});                                                  // 428
  match({a: {$lte: {x: [2, 3, 4]}}}, {a: {x: [2, 3, 4]}});                                                  // 429
                                                                                                            // 430
  nomatch({a: {$gt: [2, 3]}}, {a: [1, 2]}); // tested against mongodb                                       // 431
                                                                                                            // 432
  // composition of two qualifiers                                                                          // 433
  nomatch({a: {$lt: 11, $gt: 9}}, {a: 8});                                                                  // 434
  nomatch({a: {$lt: 11, $gt: 9}}, {a: 9});                                                                  // 435
  match({a: {$lt: 11, $gt: 9}}, {a: 10});                                                                   // 436
  nomatch({a: {$lt: 11, $gt: 9}}, {a: 11});                                                                 // 437
  nomatch({a: {$lt: 11, $gt: 9}}, {a: 12});                                                                 // 438
                                                                                                            // 439
  match({a: {$lt: 11, $gt: 9}}, {a: [8, 9, 10, 11, 12]});                                                   // 440
  match({a: {$lt: 11, $gt: 9}}, {a: [8, 9, 11, 12]}); // tested against mongodb                             // 441
                                                                                                            // 442
  // $all                                                                                                   // 443
  match({a: {$all: [1, 2]}}, {a: [1, 2]});                                                                  // 444
  nomatch({a: {$all: [1, 2, 3]}}, {a: [1, 2]});                                                             // 445
  match({a: {$all: [1, 2]}}, {a: [3, 2, 1]});                                                               // 446
  match({a: {$all: [1, "x"]}}, {a: [3, "x", 1]});                                                           // 447
  nomatch({a: {$all: ['2']}}, {a: 2});                                                                      // 448
  nomatch({a: {$all: [2]}}, {a: '2'});                                                                      // 449
  match({a: {$all: [[1, 2], [1, 3]]}}, {a: [[1, 3], [1, 2], [1, 4]]});                                      // 450
  nomatch({a: {$all: [[1, 2], [1, 3]]}}, {a: [[1, 4], [1, 2], [1, 4]]});                                    // 451
  match({a: {$all: [2, 2]}}, {a: [2]}); // tested against mongodb                                           // 452
  nomatch({a: {$all: [2, 3]}}, {a: [2, 2]});                                                                // 453
                                                                                                            // 454
  nomatch({a: {$all: [1, 2]}}, {a: [[1, 2]]}); // tested against mongodb                                    // 455
  nomatch({a: {$all: [1, 2]}}, {}); // tested against mongodb, field doesn't exist                          // 456
  nomatch({a: {$all: [1, 2]}}, {a: {foo: 'bar'}}); // tested against mongodb, field is not an object        // 457
  nomatch({a: {$all: []}}, {a: []});                                                                        // 458
  nomatch({a: {$all: []}}, {a: [5]});                                                                       // 459
  match({a: {$all: [/i/, /e/i]}}, {a: ["foo", "bEr", "biz"]});                                              // 460
  nomatch({a: {$all: [/i/, /e/i]}}, {a: ["foo", "bar", "biz"]});                                            // 461
  match({a: {$all: [{b: 3}]}}, {a: [{b: 3}]});                                                              // 462
  // Members of $all other than regexps are *equality matches*, not document                                // 463
  // matches.                                                                                               // 464
  nomatch({a: {$all: [{b: 3}]}}, {a: [{b: 3, k: 4}]});                                                      // 465
  test.throws(function () {                                                                                 // 466
    match({a: {$all: [{$gt: 4}]}}, {});                                                                     // 467
  });                                                                                                       // 468
                                                                                                            // 469
  // $exists                                                                                                // 470
  match({a: {$exists: true}}, {a: 12});                                                                     // 471
  nomatch({a: {$exists: true}}, {b: 12});                                                                   // 472
  nomatch({a: {$exists: false}}, {a: 12});                                                                  // 473
  match({a: {$exists: false}}, {b: 12});                                                                    // 474
                                                                                                            // 475
  match({a: {$exists: true}}, {a: []});                                                                     // 476
  nomatch({a: {$exists: true}}, {b: []});                                                                   // 477
  nomatch({a: {$exists: false}}, {a: []});                                                                  // 478
  match({a: {$exists: false}}, {b: []});                                                                    // 479
                                                                                                            // 480
  match({a: {$exists: true}}, {a: [1]});                                                                    // 481
  nomatch({a: {$exists: true}}, {b: [1]});                                                                  // 482
  nomatch({a: {$exists: false}}, {a: [1]});                                                                 // 483
  match({a: {$exists: false}}, {b: [1]});                                                                   // 484
                                                                                                            // 485
  match({a: {$exists: 1}}, {a: 5});                                                                         // 486
  match({a: {$exists: 0}}, {b: 5});                                                                         // 487
                                                                                                            // 488
  nomatch({'a.x':{$exists: false}}, {a: [{}, {x: 5}]});                                                     // 489
  match({'a.x':{$exists: true}}, {a: [{}, {x: 5}]});                                                        // 490
  match({'a.x':{$exists: true}}, {a: [{}, {x: 5}]});                                                        // 491
  match({'a.x':{$exists: true}}, {a: {x: []}});                                                             // 492
  match({'a.x':{$exists: true}}, {a: {x: null}});                                                           // 493
                                                                                                            // 494
  // $mod                                                                                                   // 495
  match({a: {$mod: [10, 1]}}, {a: 11});                                                                     // 496
  nomatch({a: {$mod: [10, 1]}}, {a: 12});                                                                   // 497
  match({a: {$mod: [10, 1]}}, {a: [10, 11, 12]});                                                           // 498
  nomatch({a: {$mod: [10, 1]}}, {a: [10, 12]});                                                             // 499
  _.each([                                                                                                  // 500
    5,                                                                                                      // 501
    [10],                                                                                                   // 502
    [10, 1, 2],                                                                                             // 503
    "foo",                                                                                                  // 504
    {bar: 1},                                                                                               // 505
    []                                                                                                      // 506
  ], function (badMod) {                                                                                    // 507
    test.throws(function () {                                                                               // 508
      match({a: {$mod: badMod}}, {a: 11});                                                                  // 509
    });                                                                                                     // 510
  });                                                                                                       // 511
                                                                                                            // 512
  // $ne                                                                                                    // 513
  match({a: {$ne: 1}}, {a: 2});                                                                             // 514
  nomatch({a: {$ne: 2}}, {a: 2});                                                                           // 515
  match({a: {$ne: [1]}}, {a: [2]});                                                                         // 516
                                                                                                            // 517
  nomatch({a: {$ne: [1, 2]}}, {a: [1, 2]}); // all tested against mongodb                                   // 518
  nomatch({a: {$ne: 1}}, {a: [1, 2]});                                                                      // 519
  nomatch({a: {$ne: 2}}, {a: [1, 2]});                                                                      // 520
  match({a: {$ne: 3}}, {a: [1, 2]});                                                                        // 521
  nomatch({'a.b': {$ne: 1}}, {a: [{b: 1}, {b: 2}]});                                                        // 522
  nomatch({'a.b': {$ne: 2}}, {a: [{b: 1}, {b: 2}]});                                                        // 523
  match({'a.b': {$ne: 3}}, {a: [{b: 1}, {b: 2}]});                                                          // 524
                                                                                                            // 525
  nomatch({a: {$ne: {x: 1}}}, {a: {x: 1}});                                                                 // 526
  match({a: {$ne: {x: 1}}}, {a: {x: 2}});                                                                   // 527
  match({a: {$ne: {x: 1}}}, {a: {x: 1, y: 2}});                                                             // 528
                                                                                                            // 529
  // This query means: All 'a.b' must be non-5, and some 'a.b' must be >6.                                  // 530
  match({'a.b': {$ne: 5, $gt: 6}}, {a: [{b: 2}, {b: 10}]});                                                 // 531
  nomatch({'a.b': {$ne: 5, $gt: 6}}, {a: [{b: 2}, {b: 4}]});                                                // 532
  nomatch({'a.b': {$ne: 5, $gt: 6}}, {a: [{b: 2}, {b: 5}]});                                                // 533
  nomatch({'a.b': {$ne: 5, $gt: 6}}, {a: [{b: 10}, {b: 5}]});                                               // 534
  // Should work the same if the branch is at the bottom.                                                   // 535
  match({a: {$ne: 5, $gt: 6}}, {a: [2, 10]});                                                               // 536
  nomatch({a: {$ne: 5, $gt: 6}}, {a: [2, 4]});                                                              // 537
  nomatch({a: {$ne: 5, $gt: 6}}, {a: [2, 5]});                                                              // 538
  nomatch({a: {$ne: 5, $gt: 6}}, {a: [10, 5]});                                                             // 539
                                                                                                            // 540
  // $in                                                                                                    // 541
  match({a: {$in: [1, 2, 3]}}, {a: 2});                                                                     // 542
  nomatch({a: {$in: [1, 2, 3]}}, {a: 4});                                                                   // 543
  match({a: {$in: [[1], [2], [3]]}}, {a: [2]});                                                             // 544
  nomatch({a: {$in: [[1], [2], [3]]}}, {a: [4]});                                                           // 545
  match({a: {$in: [{b: 1}, {b: 2}, {b: 3}]}}, {a: {b: 2}});                                                 // 546
  nomatch({a: {$in: [{b: 1}, {b: 2}, {b: 3}]}}, {a: {b: 4}});                                               // 547
                                                                                                            // 548
  match({a: {$in: [1, 2, 3]}}, {a: [2]}); // tested against mongodb                                         // 549
  match({a: {$in: [{x: 1}, {x: 2}, {x: 3}]}}, {a: [{x: 2}]});                                               // 550
  match({a: {$in: [1, 2, 3]}}, {a: [4, 2]});                                                                // 551
  nomatch({a: {$in: [1, 2, 3]}}, {a: [4]});                                                                 // 552
                                                                                                            // 553
  match({a: {$in: ['x', /foo/i]}}, {a: 'x'});                                                               // 554
  match({a: {$in: ['x', /foo/i]}}, {a: 'fOo'});                                                             // 555
  match({a: {$in: ['x', /foo/i]}}, {a: ['f', 'fOo']});                                                      // 556
  nomatch({a: {$in: ['x', /foo/i]}}, {a: ['f', 'fOx']});                                                    // 557
                                                                                                            // 558
  match({a: {$in: [1, null]}}, {});                                                                         // 559
  match({'a.b': {$in: [1, null]}}, {});                                                                     // 560
  match({'a.b': {$in: [1, null]}}, {a: {}});                                                                // 561
  match({'a.b': {$in: [1, null]}}, {a: {b: null}});                                                         // 562
  nomatch({'a.b': {$in: [1, null]}}, {a: {b: 5}});                                                          // 563
  nomatch({'a.b': {$in: [1]}}, {a: {b: null}});                                                             // 564
  nomatch({'a.b': {$in: [1]}}, {a: {}});                                                                    // 565
  nomatch({'a.b': {$in: [1, null]}}, {a: [{b: 5}]});                                                        // 566
  match({'a.b': {$in: [1, null]}}, {a: [{b: 5}, {}]});                                                      // 567
  nomatch({'a.b': {$in: [1, null]}}, {a: [{b: 5}, []]});                                                    // 568
  nomatch({'a.b': {$in: [1, null]}}, {a: [{b: 5}, 5]});                                                     // 569
                                                                                                            // 570
  // $nin                                                                                                   // 571
  nomatch({a: {$nin: [1, 2, 3]}}, {a: 2});                                                                  // 572
  match({a: {$nin: [1, 2, 3]}}, {a: 4});                                                                    // 573
  nomatch({a: {$nin: [[1], [2], [3]]}}, {a: [2]});                                                          // 574
  match({a: {$nin: [[1], [2], [3]]}}, {a: [4]});                                                            // 575
  nomatch({a: {$nin: [{b: 1}, {b: 2}, {b: 3}]}}, {a: {b: 2}});                                              // 576
  match({a: {$nin: [{b: 1}, {b: 2}, {b: 3}]}}, {a: {b: 4}});                                                // 577
                                                                                                            // 578
  nomatch({a: {$nin: [1, 2, 3]}}, {a: [2]}); // tested against mongodb                                      // 579
  nomatch({a: {$nin: [{x: 1}, {x: 2}, {x: 3}]}}, {a: [{x: 2}]});                                            // 580
  nomatch({a: {$nin: [1, 2, 3]}}, {a: [4, 2]});                                                             // 581
  nomatch({'a.b': {$nin: [1, 2, 3]}}, {a: [{b:4}, {b:2}]});                                                 // 582
  match({a: {$nin: [1, 2, 3]}}, {a: [4]});                                                                  // 583
  match({'a.b': {$nin: [1, 2, 3]}}, {a: [{b:4}]});                                                          // 584
                                                                                                            // 585
  nomatch({a: {$nin: ['x', /foo/i]}}, {a: 'x'});                                                            // 586
  nomatch({a: {$nin: ['x', /foo/i]}}, {a: 'fOo'});                                                          // 587
  nomatch({a: {$nin: ['x', /foo/i]}}, {a: ['f', 'fOo']});                                                   // 588
  match({a: {$nin: ['x', /foo/i]}}, {a: ['f', 'fOx']});                                                     // 589
                                                                                                            // 590
  nomatch({a: {$nin: [1, null]}}, {});                                                                      // 591
  nomatch({'a.b': {$nin: [1, null]}}, {});                                                                  // 592
  nomatch({'a.b': {$nin: [1, null]}}, {a: {}});                                                             // 593
  nomatch({'a.b': {$nin: [1, null]}}, {a: {b: null}});                                                      // 594
  match({'a.b': {$nin: [1, null]}}, {a: {b: 5}});                                                           // 595
  match({'a.b': {$nin: [1]}}, {a: {b: null}});                                                              // 596
  match({'a.b': {$nin: [1]}}, {a: {}});                                                                     // 597
  match({'a.b': {$nin: [1, null]}}, {a: [{b: 5}]});                                                         // 598
  nomatch({'a.b': {$nin: [1, null]}}, {a: [{b: 5}, {}]});                                                   // 599
  match({'a.b': {$nin: [1, null]}}, {a: [{b: 5}, []]});                                                     // 600
  match({'a.b': {$nin: [1, null]}}, {a: [{b: 5}, 5]});                                                      // 601
                                                                                                            // 602
  // $size                                                                                                  // 603
  match({a: {$size: 0}}, {a: []});                                                                          // 604
  match({a: {$size: 1}}, {a: [2]});                                                                         // 605
  match({a: {$size: 2}}, {a: [2, 2]});                                                                      // 606
  nomatch({a: {$size: 0}}, {a: [2]});                                                                       // 607
  nomatch({a: {$size: 1}}, {a: []});                                                                        // 608
  nomatch({a: {$size: 1}}, {a: [2, 2]});                                                                    // 609
  nomatch({a: {$size: 0}}, {a: "2"});                                                                       // 610
  nomatch({a: {$size: 1}}, {a: "2"});                                                                       // 611
  nomatch({a: {$size: 2}}, {a: "2"});                                                                       // 612
                                                                                                            // 613
  nomatch({a: {$size: 2}}, {a: [[2,2]]}); // tested against mongodb                                         // 614
                                                                                                            // 615
  // $type                                                                                                  // 616
  match({a: {$type: 1}}, {a: 1.1});                                                                         // 617
  match({a: {$type: 1}}, {a: 1});                                                                           // 618
  nomatch({a: {$type: 1}}, {a: "1"});                                                                       // 619
  match({a: {$type: 2}}, {a: "1"});                                                                         // 620
  nomatch({a: {$type: 2}}, {a: 1});                                                                         // 621
  match({a: {$type: 3}}, {a: {}});                                                                          // 622
  match({a: {$type: 3}}, {a: {b: 2}});                                                                      // 623
  nomatch({a: {$type: 3}}, {a: []});                                                                        // 624
  nomatch({a: {$type: 3}}, {a: [1]});                                                                       // 625
  nomatch({a: {$type: 3}}, {a: null});                                                                      // 626
  match({a: {$type: 5}}, {a: EJSON.newBinary(0)});                                                          // 627
  match({a: {$type: 5}}, {a: EJSON.newBinary(4)});                                                          // 628
  nomatch({a: {$type: 5}}, {a: []});                                                                        // 629
  nomatch({a: {$type: 5}}, {a: [42]});                                                                      // 630
  match({a: {$type: 7}}, {a: new LocalCollection._ObjectID()});                                             // 631
  nomatch({a: {$type: 7}}, {a: "1234567890abcd1234567890"});                                                // 632
  match({a: {$type: 8}}, {a: true});                                                                        // 633
  match({a: {$type: 8}}, {a: false});                                                                       // 634
  nomatch({a: {$type: 8}}, {a: "true"});                                                                    // 635
  nomatch({a: {$type: 8}}, {a: 0});                                                                         // 636
  nomatch({a: {$type: 8}}, {a: null});                                                                      // 637
  nomatch({a: {$type: 8}}, {a: ''});                                                                        // 638
  nomatch({a: {$type: 8}}, {});                                                                             // 639
  match({a: {$type: 9}}, {a: (new Date)});                                                                  // 640
  nomatch({a: {$type: 9}}, {a: +(new Date)});                                                               // 641
  match({a: {$type: 10}}, {a: null});                                                                       // 642
  nomatch({a: {$type: 10}}, {a: false});                                                                    // 643
  nomatch({a: {$type: 10}}, {a: ''});                                                                       // 644
  nomatch({a: {$type: 10}}, {a: 0});                                                                        // 645
  nomatch({a: {$type: 10}}, {});                                                                            // 646
  match({a: {$type: 11}}, {a: /x/});                                                                        // 647
  nomatch({a: {$type: 11}}, {a: 'x'});                                                                      // 648
  nomatch({a: {$type: 11}}, {});                                                                            // 649
                                                                                                            // 650
  // The normal rule for {$type:4} (4 means array) is that it NOT good enough to                            // 651
  // just have an array that's the leaf that matches the path.  (An array inside                            // 652
  // that array is good, though.)                                                                           // 653
  nomatch({a: {$type: 4}}, {a: []});                                                                        // 654
  nomatch({a: {$type: 4}}, {a: [1]}); // tested against mongodb                                             // 655
  match({a: {$type: 1}}, {a: [1]});                                                                         // 656
  nomatch({a: {$type: 2}}, {a: [1]});                                                                       // 657
  match({a: {$type: 1}}, {a: ["1", 1]});                                                                    // 658
  match({a: {$type: 2}}, {a: ["1", 1]});                                                                    // 659
  nomatch({a: {$type: 3}}, {a: ["1", 1]});                                                                  // 660
  nomatch({a: {$type: 4}}, {a: ["1", 1]});                                                                  // 661
  nomatch({a: {$type: 1}}, {a: ["1", []]});                                                                 // 662
  match({a: {$type: 2}}, {a: ["1", []]});                                                                   // 663
  match({a: {$type: 4}}, {a: ["1", []]}); // tested against mongodb                                         // 664
  // An exception to the normal rule is that an array found via numeric index is                            // 665
  // examined itself, and its elements are not.                                                             // 666
  match({'a.0': {$type: 4}}, {a: [[0]]});                                                                   // 667
  nomatch({'a.0': {$type: 1}}, {a: [[0]]});                                                                 // 668
                                                                                                            // 669
  // regular expressions                                                                                    // 670
  match({a: /a/}, {a: 'cat'});                                                                              // 671
  nomatch({a: /a/}, {a: 'cut'});                                                                            // 672
  nomatch({a: /a/}, {a: 'CAT'});                                                                            // 673
  match({a: /a/i}, {a: 'CAT'});                                                                             // 674
  match({a: /a/}, {a: ['foo', 'bar']});  // search within array...                                          // 675
  nomatch({a: /,/}, {a: ['foo', 'bar']});  // but not by stringifying                                       // 676
  match({a: {$regex: 'a'}}, {a: ['foo', 'bar']});                                                           // 677
  nomatch({a: {$regex: ','}}, {a: ['foo', 'bar']});                                                         // 678
  match({a: {$regex: /a/}}, {a: 'cat'});                                                                    // 679
  nomatch({a: {$regex: /a/}}, {a: 'cut'});                                                                  // 680
  nomatch({a: {$regex: /a/}}, {a: 'CAT'});                                                                  // 681
  match({a: {$regex: /a/i}}, {a: 'CAT'});                                                                   // 682
  match({a: {$regex: /a/, $options: 'i'}}, {a: 'CAT'}); // tested                                           // 683
  match({a: {$regex: /a/i, $options: 'i'}}, {a: 'CAT'}); // tested                                          // 684
  nomatch({a: {$regex: /a/i, $options: ''}}, {a: 'CAT'}); // tested                                         // 685
  match({a: {$regex: 'a'}}, {a: 'cat'});                                                                    // 686
  nomatch({a: {$regex: 'a'}}, {a: 'cut'});                                                                  // 687
  nomatch({a: {$regex: 'a'}}, {a: 'CAT'});                                                                  // 688
  match({a: {$regex: 'a', $options: 'i'}}, {a: 'CAT'});                                                     // 689
  match({a: {$regex: '', $options: 'i'}}, {a: 'foo'});                                                      // 690
  nomatch({a: {$regex: '', $options: 'i'}}, {});                                                            // 691
  nomatch({a: {$regex: '', $options: 'i'}}, {a: 5});                                                        // 692
  nomatch({a: /undefined/}, {});                                                                            // 693
  nomatch({a: {$regex: 'undefined'}}, {});                                                                  // 694
  nomatch({a: /xxx/}, {});                                                                                  // 695
  nomatch({a: {$regex: 'xxx'}}, {});                                                                        // 696
                                                                                                            // 697
  test.throws(function () {                                                                                 // 698
    match({a: {$options: 'i'}}, {a: 12});                                                                   // 699
  });                                                                                                       // 700
                                                                                                            // 701
  match({a: /a/}, {a: ['dog', 'cat']});                                                                     // 702
  nomatch({a: /a/}, {a: ['dog', 'puppy']});                                                                 // 703
                                                                                                            // 704
  // we don't support regexps in minimongo very well (eg, there's no EJSON                                  // 705
  // encoding so it won't go over the wire), but run these tests anyway                                     // 706
  match({a: /a/}, {a: /a/});                                                                                // 707
  match({a: /a/}, {a: ['x', /a/]});                                                                         // 708
  nomatch({a: /a/}, {a: /a/i});                                                                             // 709
  nomatch({a: /a/m}, {a: /a/});                                                                             // 710
  nomatch({a: /a/}, {a: /b/});                                                                              // 711
  nomatch({a: /5/}, {a: 5});                                                                                // 712
  nomatch({a: /t/}, {a: true});                                                                             // 713
  match({a: /m/i}, {a: ['x', 'xM']});                                                                       // 714
                                                                                                            // 715
  test.throws(function () {                                                                                 // 716
    match({a: {$regex: /a/, $options: 'x'}}, {a: 'cat'});                                                   // 717
  });                                                                                                       // 718
  test.throws(function () {                                                                                 // 719
    match({a: {$regex: /a/, $options: 's'}}, {a: 'cat'});                                                   // 720
  });                                                                                                       // 721
                                                                                                            // 722
  // $not                                                                                                   // 723
  match({x: {$not: {$gt: 7}}}, {x: 6});                                                                     // 724
  nomatch({x: {$not: {$gt: 7}}}, {x: 8});                                                                   // 725
  match({x: {$not: {$lt: 10, $gt: 7}}}, {x: 11});                                                           // 726
  nomatch({x: {$not: {$lt: 10, $gt: 7}}}, {x: 9});                                                          // 727
  match({x: {$not: {$lt: 10, $gt: 7}}}, {x: 6});                                                            // 728
                                                                                                            // 729
  match({x: {$not: {$gt: 7}}}, {x: [2, 3, 4]});                                                             // 730
  match({'x.y': {$not: {$gt: 7}}}, {x: [{y:2}, {y:3}, {y:4}]});                                             // 731
  nomatch({x: {$not: {$gt: 7}}}, {x: [2, 3, 4, 10]});                                                       // 732
  nomatch({'x.y': {$not: {$gt: 7}}}, {x: [{y:2}, {y:3}, {y:4}, {y:10}]});                                   // 733
                                                                                                            // 734
  match({x: {$not: /a/}}, {x: "dog"});                                                                      // 735
  nomatch({x: {$not: /a/}}, {x: "cat"});                                                                    // 736
  match({x: {$not: /a/}}, {x: ["dog", "puppy"]});                                                           // 737
  nomatch({x: {$not: /a/}}, {x: ["kitten", "cat"]});                                                        // 738
                                                                                                            // 739
  // dotted keypaths: bare values                                                                           // 740
  match({"a.b": 1}, {a: {b: 1}});                                                                           // 741
  nomatch({"a.b": 1}, {a: {b: 2}});                                                                         // 742
  match({"a.b": [1,2,3]}, {a: {b: [1,2,3]}});                                                               // 743
  nomatch({"a.b": [1,2,3]}, {a: {b: [4]}});                                                                 // 744
  match({"a.b": /a/}, {a: {b: "cat"}});                                                                     // 745
  nomatch({"a.b": /a/}, {a: {b: "dog"}});                                                                   // 746
  match({"a.b.c": null}, {});                                                                               // 747
  match({"a.b.c": null}, {a: 1});                                                                           // 748
  match({"a.b": null}, {a: 1});                                                                             // 749
  match({"a.b.c": null}, {a: {b: 4}});                                                                      // 750
                                                                                                            // 751
  // dotted keypaths, nulls, numeric indices, arrays                                                        // 752
  nomatch({"a.b": null}, {a: [1]});                                                                         // 753
  match({"a.b": []}, {a: {b: []}});                                                                         // 754
  var big = {a: [{b: 1}, 2, {}, {b: [3, 4]}]};                                                              // 755
  match({"a.b": 1}, big);                                                                                   // 756
  match({"a.b": [3, 4]}, big);                                                                              // 757
  match({"a.b": 3}, big);                                                                                   // 758
  match({"a.b": 4}, big);                                                                                   // 759
  match({"a.b": null}, big);  // matches on slot 2                                                          // 760
  match({'a.1': 8}, {a: [7, 8, 9]});                                                                        // 761
  nomatch({'a.1': 7}, {a: [7, 8, 9]});                                                                      // 762
  nomatch({'a.1': null}, {a: [7, 8, 9]});                                                                   // 763
  match({'a.1': [8, 9]}, {a: [7, [8, 9]]});                                                                 // 764
  nomatch({'a.1': 6}, {a: [[6, 7], [8, 9]]});                                                               // 765
  nomatch({'a.1': 7}, {a: [[6, 7], [8, 9]]});                                                               // 766
  nomatch({'a.1': 8}, {a: [[6, 7], [8, 9]]});                                                               // 767
  nomatch({'a.1': 9}, {a: [[6, 7], [8, 9]]});                                                               // 768
  match({"a.1": 2}, {a: [0, {1: 2}, 3]});                                                                   // 769
  match({"a.1": {1: 2}}, {a: [0, {1: 2}, 3]});                                                              // 770
  match({"x.1.y": 8}, {x: [7, {y: 8}, 9]});                                                                 // 771
  // comes from trying '1' as key in the plain object                                                       // 772
  match({"x.1.y": null}, {x: [7, {y: 8}, 9]});                                                              // 773
  match({"a.1.b": 9}, {a: [7, {b: 9}, {1: {b: 'foo'}}]});                                                   // 774
  match({"a.1.b": 'foo'}, {a: [7, {b: 9}, {1: {b: 'foo'}}]});                                               // 775
  match({"a.1.b": null}, {a: [7, {b: 9}, {1: {b: 'foo'}}]});                                                // 776
  match({"a.1.b": 2}, {a: [1, [{b: 2}], 3]});                                                               // 777
  nomatch({"a.1.b": null}, {a: [1, [{b: 2}], 3]});                                                          // 778
  // this is new behavior in mongo 2.5                                                                      // 779
  nomatch({"a.0.b": null}, {a: [5]});                                                                       // 780
  match({"a.1": 4}, {a: [{1: 4}, 5]});                                                                      // 781
  match({"a.1": 5}, {a: [{1: 4}, 5]});                                                                      // 782
  nomatch({"a.1": null}, {a: [{1: 4}, 5]});                                                                 // 783
  match({"a.1.foo": 4}, {a: [{1: {foo: 4}}, {foo: 5}]});                                                    // 784
  match({"a.1.foo": 5}, {a: [{1: {foo: 4}}, {foo: 5}]});                                                    // 785
  match({"a.1.foo": null}, {a: [{1: {foo: 4}}, {foo: 5}]});                                                 // 786
                                                                                                            // 787
  // trying to access a dotted field that is undefined at some point                                        // 788
  // down the chain                                                                                         // 789
  nomatch({"a.b": 1}, {x: 2});                                                                              // 790
  nomatch({"a.b.c": 1}, {a: {x: 2}});                                                                       // 791
  nomatch({"a.b.c": 1}, {a: {b: {x: 2}}});                                                                  // 792
  nomatch({"a.b.c": 1}, {a: {b: 1}});                                                                       // 793
  nomatch({"a.b.c": 1}, {a: {b: 0}});                                                                       // 794
                                                                                                            // 795
  // dotted keypaths: literal objects                                                                       // 796
  match({"a.b": {c: 1}}, {a: {b: {c: 1}}});                                                                 // 797
  nomatch({"a.b": {c: 1}}, {a: {b: {c: 2}}});                                                               // 798
  nomatch({"a.b": {c: 1}}, {a: {b: 2}});                                                                    // 799
  match({"a.b": {c: 1, d: 2}}, {a: {b: {c: 1, d: 2}}});                                                     // 800
  nomatch({"a.b": {c: 1, d: 2}}, {a: {b: {c: 1, d: 1}}});                                                   // 801
  nomatch({"a.b": {c: 1, d: 2}}, {a: {b: {d: 2}}});                                                         // 802
                                                                                                            // 803
  // dotted keypaths: $ operators                                                                           // 804
  match({"a.b": {$in: [1, 2, 3]}}, {a: {b: [2]}}); // tested against mongodb                                // 805
  match({"a.b": {$in: [{x: 1}, {x: 2}, {x: 3}]}}, {a: {b: [{x: 2}]}});                                      // 806
  match({"a.b": {$in: [1, 2, 3]}}, {a: {b: [4, 2]}});                                                       // 807
  nomatch({"a.b": {$in: [1, 2, 3]}}, {a: {b: [4]}});                                                        // 808
                                                                                                            // 809
  // $or                                                                                                    // 810
  test.throws(function () {                                                                                 // 811
    match({$or: []}, {});                                                                                   // 812
  });                                                                                                       // 813
  test.throws(function () {                                                                                 // 814
    match({$or: [5]}, {});                                                                                  // 815
  });                                                                                                       // 816
  test.throws(function () {                                                                                 // 817
    match({$or: []}, {a: 1});                                                                               // 818
  });                                                                                                       // 819
  match({$or: [{a: 1}]}, {a: 1});                                                                           // 820
  nomatch({$or: [{b: 2}]}, {a: 1});                                                                         // 821
  match({$or: [{a: 1}, {b: 2}]}, {a: 1});                                                                   // 822
  nomatch({$or: [{c: 3}, {d: 4}]}, {a: 1});                                                                 // 823
  match({$or: [{a: 1}, {b: 2}]}, {a: [1, 2, 3]});                                                           // 824
  nomatch({$or: [{a: 1}, {b: 2}]}, {c: [1, 2, 3]});                                                         // 825
  nomatch({$or: [{a: 1}, {b: 2}]}, {a: [2, 3, 4]});                                                         // 826
  match({$or: [{a: 1}, {a: 2}]}, {a: 1});                                                                   // 827
  match({$or: [{a: 1}, {a: 2}], b: 2}, {a: 1, b: 2});                                                       // 828
  nomatch({$or: [{a: 2}, {a: 3}], b: 2}, {a: 1, b: 2});                                                     // 829
  nomatch({$or: [{a: 1}, {a: 2}], b: 3}, {a: 1, b: 2});                                                     // 830
                                                                                                            // 831
  // Combining $or with equality                                                                            // 832
  match({x: 1, $or: [{a: 1}, {b: 1}]}, {x: 1, b: 1});                                                       // 833
  match({$or: [{a: 1}, {b: 1}], x: 1}, {x: 1, b: 1});                                                       // 834
  nomatch({x: 1, $or: [{a: 1}, {b: 1}]}, {b: 1});                                                           // 835
  nomatch({x: 1, $or: [{a: 1}, {b: 1}]}, {x: 1});                                                           // 836
                                                                                                            // 837
  // $or and $lt, $lte, $gt, $gte                                                                           // 838
  match({$or: [{a: {$lte: 1}}, {a: 2}]}, {a: 1});                                                           // 839
  nomatch({$or: [{a: {$lt: 1}}, {a: 2}]}, {a: 1});                                                          // 840
  match({$or: [{a: {$gte: 1}}, {a: 2}]}, {a: 1});                                                           // 841
  nomatch({$or: [{a: {$gt: 1}}, {a: 2}]}, {a: 1});                                                          // 842
  match({$or: [{b: {$gt: 1}}, {b: {$lt: 3}}]}, {b: 2});                                                     // 843
  nomatch({$or: [{b: {$lt: 1}}, {b: {$gt: 3}}]}, {b: 2});                                                   // 844
                                                                                                            // 845
  // $or and $in                                                                                            // 846
  match({$or: [{a: {$in: [1, 2, 3]}}]}, {a: 1});                                                            // 847
  nomatch({$or: [{a: {$in: [4, 5, 6]}}]}, {a: 1});                                                          // 848
  match({$or: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {a: 1});                                                    // 849
  match({$or: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {b: 2});                                                    // 850
  nomatch({$or: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {c: 3});                                                  // 851
  match({$or: [{a: {$in: [1, 2, 3]}}, {b: {$in: [1, 2, 3]}}]}, {b: 2});                                     // 852
  nomatch({$or: [{a: {$in: [1, 2, 3]}}, {b: {$in: [4, 5, 6]}}]}, {b: 2});                                   // 853
                                                                                                            // 854
  // $or and $nin                                                                                           // 855
  nomatch({$or: [{a: {$nin: [1, 2, 3]}}]}, {a: 1});                                                         // 856
  match({$or: [{a: {$nin: [4, 5, 6]}}]}, {a: 1});                                                           // 857
  nomatch({$or: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {a: 1});                                                 // 858
  match({$or: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {b: 2});                                                   // 859
  match({$or: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {c: 3});                                                   // 860
  match({$or: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [1, 2, 3]}}]}, {b: 2});                                   // 861
  nomatch({$or: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [1, 2, 3]}}]}, {a: 1, b: 2});                           // 862
  match({$or: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [4, 5, 6]}}]}, {b: 2});                                   // 863
                                                                                                            // 864
  // $or and dot-notation                                                                                   // 865
  match({$or: [{"a.b": 1}, {"a.b": 2}]}, {a: {b: 1}});                                                      // 866
  match({$or: [{"a.b": 1}, {"a.c": 1}]}, {a: {b: 1}});                                                      // 867
  nomatch({$or: [{"a.b": 2}, {"a.c": 1}]}, {a: {b: 1}});                                                    // 868
                                                                                                            // 869
  // $or and nested objects                                                                                 // 870
  match({$or: [{a: {b: 1, c: 2}}, {a: {b: 2, c: 1}}]}, {a: {b: 1, c: 2}});                                  // 871
  nomatch({$or: [{a: {b: 1, c: 3}}, {a: {b: 2, c: 1}}]}, {a: {b: 1, c: 2}});                                // 872
                                                                                                            // 873
  // $or and regexes                                                                                        // 874
  match({$or: [{a: /a/}]}, {a: "cat"});                                                                     // 875
  nomatch({$or: [{a: /o/}]}, {a: "cat"});                                                                   // 876
  match({$or: [{a: /a/}, {a: /o/}]}, {a: "cat"});                                                           // 877
  nomatch({$or: [{a: /i/}, {a: /o/}]}, {a: "cat"});                                                         // 878
  match({$or: [{a: /i/}, {b: /o/}]}, {a: "cat", b: "dog"});                                                 // 879
                                                                                                            // 880
  // $or and $ne                                                                                            // 881
  match({$or: [{a: {$ne: 1}}]}, {});                                                                        // 882
  nomatch({$or: [{a: {$ne: 1}}]}, {a: 1});                                                                  // 883
  match({$or: [{a: {$ne: 1}}]}, {a: 2});                                                                    // 884
  match({$or: [{a: {$ne: 1}}]}, {b: 1});                                                                    // 885
  match({$or: [{a: {$ne: 1}}, {a: {$ne: 2}}]}, {a: 1});                                                     // 886
  match({$or: [{a: {$ne: 1}}, {b: {$ne: 1}}]}, {a: 1});                                                     // 887
  nomatch({$or: [{a: {$ne: 1}}, {b: {$ne: 2}}]}, {a: 1, b: 2});                                             // 888
                                                                                                            // 889
  // $or and $not                                                                                           // 890
  match({$or: [{a: {$not: {$mod: [10, 1]}}}]}, {});                                                         // 891
  nomatch({$or: [{a: {$not: {$mod: [10, 1]}}}]}, {a: 1});                                                   // 892
  match({$or: [{a: {$not: {$mod: [10, 1]}}}]}, {a: 2});                                                     // 893
  match({$or: [{a: {$not: {$mod: [10, 1]}}}, {a: {$not: {$mod: [10, 2]}}}]}, {a: 1});                       // 894
  nomatch({$or: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 1});                             // 895
  match({$or: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 2});                               // 896
  match({$or: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 3});                               // 897
  // this is possibly an open-ended task, so we stop here ...                                               // 898
                                                                                                            // 899
  // $nor                                                                                                   // 900
  test.throws(function () {                                                                                 // 901
    match({$nor: []}, {});                                                                                  // 902
  });                                                                                                       // 903
  test.throws(function () {                                                                                 // 904
    match({$nor: [5]}, {});                                                                                 // 905
  });                                                                                                       // 906
  test.throws(function () {                                                                                 // 907
    match({$nor: []}, {a: 1});                                                                              // 908
  });                                                                                                       // 909
  nomatch({$nor: [{a: 1}]}, {a: 1});                                                                        // 910
  match({$nor: [{b: 2}]}, {a: 1});                                                                          // 911
  nomatch({$nor: [{a: 1}, {b: 2}]}, {a: 1});                                                                // 912
  match({$nor: [{c: 3}, {d: 4}]}, {a: 1});                                                                  // 913
  nomatch({$nor: [{a: 1}, {b: 2}]}, {a: [1, 2, 3]});                                                        // 914
  match({$nor: [{a: 1}, {b: 2}]}, {c: [1, 2, 3]});                                                          // 915
  match({$nor: [{a: 1}, {b: 2}]}, {a: [2, 3, 4]});                                                          // 916
  nomatch({$nor: [{a: 1}, {a: 2}]}, {a: 1});                                                                // 917
                                                                                                            // 918
  // $nor and $lt, $lte, $gt, $gte                                                                          // 919
  nomatch({$nor: [{a: {$lte: 1}}, {a: 2}]}, {a: 1});                                                        // 920
  match({$nor: [{a: {$lt: 1}}, {a: 2}]}, {a: 1});                                                           // 921
  nomatch({$nor: [{a: {$gte: 1}}, {a: 2}]}, {a: 1});                                                        // 922
  match({$nor: [{a: {$gt: 1}}, {a: 2}]}, {a: 1});                                                           // 923
  nomatch({$nor: [{b: {$gt: 1}}, {b: {$lt: 3}}]}, {b: 2});                                                  // 924
  match({$nor: [{b: {$lt: 1}}, {b: {$gt: 3}}]}, {b: 2});                                                    // 925
                                                                                                            // 926
  // $nor and $in                                                                                           // 927
  nomatch({$nor: [{a: {$in: [1, 2, 3]}}]}, {a: 1});                                                         // 928
  match({$nor: [{a: {$in: [4, 5, 6]}}]}, {a: 1});                                                           // 929
  nomatch({$nor: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {a: 1});                                                 // 930
  nomatch({$nor: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {b: 2});                                                 // 931
  match({$nor: [{a: {$in: [1, 2, 3]}}, {b: 2}]}, {c: 3});                                                   // 932
  nomatch({$nor: [{a: {$in: [1, 2, 3]}}, {b: {$in: [1, 2, 3]}}]}, {b: 2});                                  // 933
  match({$nor: [{a: {$in: [1, 2, 3]}}, {b: {$in: [4, 5, 6]}}]}, {b: 2});                                    // 934
                                                                                                            // 935
  // $nor and $nin                                                                                          // 936
  match({$nor: [{a: {$nin: [1, 2, 3]}}]}, {a: 1});                                                          // 937
  nomatch({$nor: [{a: {$nin: [4, 5, 6]}}]}, {a: 1});                                                        // 938
  match({$nor: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {a: 1});                                                  // 939
  nomatch({$nor: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {b: 2});                                                // 940
  nomatch({$nor: [{a: {$nin: [1, 2, 3]}}, {b: 2}]}, {c: 3});                                                // 941
  nomatch({$nor: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [1, 2, 3]}}]}, {b: 2});                                // 942
  match({$nor: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [1, 2, 3]}}]}, {a: 1, b: 2});                            // 943
  nomatch({$nor: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [4, 5, 6]}}]}, {b: 2});                                // 944
                                                                                                            // 945
  // $nor and dot-notation                                                                                  // 946
  nomatch({$nor: [{"a.b": 1}, {"a.b": 2}]}, {a: {b: 1}});                                                   // 947
  nomatch({$nor: [{"a.b": 1}, {"a.c": 1}]}, {a: {b: 1}});                                                   // 948
  match({$nor: [{"a.b": 2}, {"a.c": 1}]}, {a: {b: 1}});                                                     // 949
                                                                                                            // 950
  // $nor and nested objects                                                                                // 951
  nomatch({$nor: [{a: {b: 1, c: 2}}, {a: {b: 2, c: 1}}]}, {a: {b: 1, c: 2}});                               // 952
  match({$nor: [{a: {b: 1, c: 3}}, {a: {b: 2, c: 1}}]}, {a: {b: 1, c: 2}});                                 // 953
                                                                                                            // 954
  // $nor and regexes                                                                                       // 955
  nomatch({$nor: [{a: /a/}]}, {a: "cat"});                                                                  // 956
  match({$nor: [{a: /o/}]}, {a: "cat"});                                                                    // 957
  nomatch({$nor: [{a: /a/}, {a: /o/}]}, {a: "cat"});                                                        // 958
  match({$nor: [{a: /i/}, {a: /o/}]}, {a: "cat"});                                                          // 959
  nomatch({$nor: [{a: /i/}, {b: /o/}]}, {a: "cat", b: "dog"});                                              // 960
                                                                                                            // 961
  // $nor and $ne                                                                                           // 962
  nomatch({$nor: [{a: {$ne: 1}}]}, {});                                                                     // 963
  match({$nor: [{a: {$ne: 1}}]}, {a: 1});                                                                   // 964
  nomatch({$nor: [{a: {$ne: 1}}]}, {a: 2});                                                                 // 965
  nomatch({$nor: [{a: {$ne: 1}}]}, {b: 1});                                                                 // 966
  nomatch({$nor: [{a: {$ne: 1}}, {a: {$ne: 2}}]}, {a: 1});                                                  // 967
  nomatch({$nor: [{a: {$ne: 1}}, {b: {$ne: 1}}]}, {a: 1});                                                  // 968
  match({$nor: [{a: {$ne: 1}}, {b: {$ne: 2}}]}, {a: 1, b: 2});                                              // 969
                                                                                                            // 970
  // $nor and $not                                                                                          // 971
  nomatch({$nor: [{a: {$not: {$mod: [10, 1]}}}]}, {});                                                      // 972
  match({$nor: [{a: {$not: {$mod: [10, 1]}}}]}, {a: 1});                                                    // 973
  nomatch({$nor: [{a: {$not: {$mod: [10, 1]}}}]}, {a: 2});                                                  // 974
  nomatch({$nor: [{a: {$not: {$mod: [10, 1]}}}, {a: {$not: {$mod: [10, 2]}}}]}, {a: 1});                    // 975
  match({$nor: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 1});                              // 976
  nomatch({$nor: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 2});                            // 977
  nomatch({$nor: [{a: {$not: {$mod: [10, 1]}}}, {a: {$mod: [10, 2]}}]}, {a: 3});                            // 978
                                                                                                            // 979
  // $and                                                                                                   // 980
                                                                                                            // 981
  test.throws(function () {                                                                                 // 982
    match({$and: []}, {});                                                                                  // 983
  });                                                                                                       // 984
  test.throws(function () {                                                                                 // 985
    match({$and: [5]}, {});                                                                                 // 986
  });                                                                                                       // 987
  test.throws(function () {                                                                                 // 988
    match({$and: []}, {a: 1});                                                                              // 989
  });                                                                                                       // 990
  match({$and: [{a: 1}]}, {a: 1});                                                                          // 991
  nomatch({$and: [{a: 1}, {a: 2}]}, {a: 1});                                                                // 992
  nomatch({$and: [{a: 1}, {b: 1}]}, {a: 1});                                                                // 993
  match({$and: [{a: 1}, {b: 2}]}, {a: 1, b: 2});                                                            // 994
  nomatch({$and: [{a: 1}, {b: 1}]}, {a: 1, b: 2});                                                          // 995
  match({$and: [{a: 1}, {b: 2}], c: 3}, {a: 1, b: 2, c: 3});                                                // 996
  nomatch({$and: [{a: 1}, {b: 2}], c: 4}, {a: 1, b: 2, c: 3});                                              // 997
                                                                                                            // 998
  // $and and regexes                                                                                       // 999
  match({$and: [{a: /a/}]}, {a: "cat"});                                                                    // 1000
  match({$and: [{a: /a/i}]}, {a: "CAT"});                                                                   // 1001
  nomatch({$and: [{a: /o/}]}, {a: "cat"});                                                                  // 1002
  nomatch({$and: [{a: /a/}, {a: /o/}]}, {a: "cat"});                                                        // 1003
  match({$and: [{a: /a/}, {b: /o/}]}, {a: "cat", b: "dog"});                                                // 1004
  nomatch({$and: [{a: /a/}, {b: /a/}]}, {a: "cat", b: "dog"});                                              // 1005
                                                                                                            // 1006
  // $and, dot-notation, and nested objects                                                                 // 1007
  match({$and: [{"a.b": 1}]}, {a: {b: 1}});                                                                 // 1008
  match({$and: [{a: {b: 1}}]}, {a: {b: 1}});                                                                // 1009
  nomatch({$and: [{"a.b": 2}]}, {a: {b: 1}});                                                               // 1010
  nomatch({$and: [{"a.c": 1}]}, {a: {b: 1}});                                                               // 1011
  nomatch({$and: [{"a.b": 1}, {"a.b": 2}]}, {a: {b: 1}});                                                   // 1012
  nomatch({$and: [{"a.b": 1}, {a: {b: 2}}]}, {a: {b: 1}});                                                  // 1013
  match({$and: [{"a.b": 1}, {"c.d": 2}]}, {a: {b: 1}, c: {d: 2}});                                          // 1014
  nomatch({$and: [{"a.b": 1}, {"c.d": 1}]}, {a: {b: 1}, c: {d: 2}});                                        // 1015
  match({$and: [{"a.b": 1}, {c: {d: 2}}]}, {a: {b: 1}, c: {d: 2}});                                         // 1016
  nomatch({$and: [{"a.b": 1}, {c: {d: 1}}]}, {a: {b: 1}, c: {d: 2}});                                       // 1017
  nomatch({$and: [{"a.b": 2}, {c: {d: 2}}]}, {a: {b: 1}, c: {d: 2}});                                       // 1018
  match({$and: [{a: {b: 1}}, {c: {d: 2}}]}, {a: {b: 1}, c: {d: 2}});                                        // 1019
  nomatch({$and: [{a: {b: 2}}, {c: {d: 2}}]}, {a: {b: 1}, c: {d: 2}});                                      // 1020
                                                                                                            // 1021
  // $and and $in                                                                                           // 1022
  nomatch({$and: [{a: {$in: []}}]}, {});                                                                    // 1023
  match({$and: [{a: {$in: [1, 2, 3]}}]}, {a: 1});                                                           // 1024
  nomatch({$and: [{a: {$in: [4, 5, 6]}}]}, {a: 1});                                                         // 1025
  nomatch({$and: [{a: {$in: [1, 2, 3]}}, {a: {$in: [4, 5, 6]}}]}, {a: 1});                                  // 1026
  nomatch({$and: [{a: {$in: [1, 2, 3]}}, {b: {$in: [1, 2, 3]}}]}, {a: 1, b: 4});                            // 1027
  match({$and: [{a: {$in: [1, 2, 3]}}, {b: {$in: [4, 5, 6]}}]}, {a: 1, b: 4});                              // 1028
                                                                                                            // 1029
                                                                                                            // 1030
  // $and and $nin                                                                                          // 1031
  match({$and: [{a: {$nin: []}}]}, {});                                                                     // 1032
  nomatch({$and: [{a: {$nin: [1, 2, 3]}}]}, {a: 1});                                                        // 1033
  match({$and: [{a: {$nin: [4, 5, 6]}}]}, {a: 1});                                                          // 1034
  nomatch({$and: [{a: {$nin: [1, 2, 3]}}, {a: {$nin: [4, 5, 6]}}]}, {a: 1});                                // 1035
  nomatch({$and: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [1, 2, 3]}}]}, {a: 1, b: 4});                          // 1036
  nomatch({$and: [{a: {$nin: [1, 2, 3]}}, {b: {$nin: [4, 5, 6]}}]}, {a: 1, b: 4});                          // 1037
                                                                                                            // 1038
  // $and and $lt, $lte, $gt, $gte                                                                          // 1039
  match({$and: [{a: {$lt: 2}}]}, {a: 1});                                                                   // 1040
  nomatch({$and: [{a: {$lt: 1}}]}, {a: 1});                                                                 // 1041
  match({$and: [{a: {$lte: 1}}]}, {a: 1});                                                                  // 1042
  match({$and: [{a: {$gt: 0}}]}, {a: 1});                                                                   // 1043
  nomatch({$and: [{a: {$gt: 1}}]}, {a: 1});                                                                 // 1044
  match({$and: [{a: {$gte: 1}}]}, {a: 1});                                                                  // 1045
  match({$and: [{a: {$gt: 0}}, {a: {$lt: 2}}]}, {a: 1});                                                    // 1046
  nomatch({$and: [{a: {$gt: 1}}, {a: {$lt: 2}}]}, {a: 1});                                                  // 1047
  nomatch({$and: [{a: {$gt: 0}}, {a: {$lt: 1}}]}, {a: 1});                                                  // 1048
  match({$and: [{a: {$gte: 1}}, {a: {$lte: 1}}]}, {a: 1});                                                  // 1049
  nomatch({$and: [{a: {$gte: 2}}, {a: {$lte: 0}}]}, {a: 1});                                                // 1050
                                                                                                            // 1051
  // $and and $ne                                                                                           // 1052
  match({$and: [{a: {$ne: 1}}]}, {});                                                                       // 1053
  nomatch({$and: [{a: {$ne: 1}}]}, {a: 1});                                                                 // 1054
  match({$and: [{a: {$ne: 1}}]}, {a: 2});                                                                   // 1055
  nomatch({$and: [{a: {$ne: 1}}, {a: {$ne: 2}}]}, {a: 2});                                                  // 1056
  match({$and: [{a: {$ne: 1}}, {a: {$ne: 3}}]}, {a: 2});                                                    // 1057
                                                                                                            // 1058
  // $and and $not                                                                                          // 1059
  match({$and: [{a: {$not: {$gt: 2}}}]}, {a: 1});                                                           // 1060
  nomatch({$and: [{a: {$not: {$lt: 2}}}]}, {a: 1});                                                         // 1061
  match({$and: [{a: {$not: {$lt: 0}}}, {a: {$not: {$gt: 2}}}]}, {a: 1});                                    // 1062
  nomatch({$and: [{a: {$not: {$lt: 2}}}, {a: {$not: {$gt: 0}}}]}, {a: 1});                                  // 1063
                                                                                                            // 1064
  // $where                                                                                                 // 1065
  match({$where: "this.a === 1"}, {a: 1});                                                                  // 1066
  match({$where: "obj.a === 1"}, {a: 1});                                                                   // 1067
  nomatch({$where: "this.a !== 1"}, {a: 1});                                                                // 1068
  nomatch({$where: "obj.a !== 1"}, {a: 1});                                                                 // 1069
  nomatch({$where: "this.a === 1", a: 2}, {a: 1});                                                          // 1070
  match({$where: "this.a === 1", b: 2}, {a: 1, b: 2});                                                      // 1071
  match({$where: "this.a === 1 && this.b === 2"}, {a: 1, b: 2});                                            // 1072
  match({$where: "this.a instanceof Array"}, {a: []});                                                      // 1073
  nomatch({$where: "this.a instanceof Array"}, {a: 1});                                                     // 1074
                                                                                                            // 1075
  // reaching into array                                                                                    // 1076
  match({"dogs.0.name": "Fido"}, {dogs: [{name: "Fido"}, {name: "Rex"}]});                                  // 1077
  match({"dogs.1.name": "Rex"}, {dogs: [{name: "Fido"}, {name: "Rex"}]});                                   // 1078
  nomatch({"dogs.1.name": "Fido"}, {dogs: [{name: "Fido"}, {name: "Rex"}]});                                // 1079
  match({"room.1b": "bla"}, {room: {"1b": "bla"}});                                                         // 1080
                                                                                                            // 1081
  match({"dogs.name": "Fido"}, {dogs: [{name: "Fido"}, {name: "Rex"}]});                                    // 1082
  match({"dogs.name": "Rex"}, {dogs: [{name: "Fido"}, {name: "Rex"}]});                                     // 1083
  match({"animals.dogs.name": "Fido"},                                                                      // 1084
        {animals: [{dogs: [{name: "Rover"}]},                                                               // 1085
                   {},                                                                                      // 1086
                   {dogs: [{name: "Fido"}, {name: "Rex"}]}]});                                              // 1087
  match({"animals.dogs.name": "Fido"},                                                                      // 1088
        {animals: [{dogs: {name: "Rex"}},                                                                   // 1089
                   {dogs: {name: "Fido"}}]});                                                               // 1090
  match({"animals.dogs.name": "Fido"},                                                                      // 1091
        {animals: [{dogs: [{name: "Rover"}]},                                                               // 1092
                   {},                                                                                      // 1093
                   {dogs: [{name: ["Fido"]}, {name: "Rex"}]}]});                                            // 1094
  nomatch({"dogs.name": "Fido"}, {dogs: []});                                                               // 1095
                                                                                                            // 1096
  // $elemMatch                                                                                             // 1097
  match({dogs: {$elemMatch: {name: /e/}}},                                                                  // 1098
        {dogs: [{name: "Fido"}, {name: "Rex"}]});                                                           // 1099
  nomatch({dogs: {$elemMatch: {name: /a/}}},                                                                // 1100
          {dogs: [{name: "Fido"}, {name: "Rex"}]});                                                         // 1101
  match({dogs: {$elemMatch: {age: {$gt: 4}}}},                                                              // 1102
        {dogs: [{name: "Fido", age: 5}, {name: "Rex", age: 3}]});                                           // 1103
  match({dogs: {$elemMatch: {name: "Fido", age: {$gt: 4}}}},                                                // 1104
        {dogs: [{name: "Fido", age: 5}, {name: "Rex", age: 3}]});                                           // 1105
  nomatch({dogs: {$elemMatch: {name: "Fido", age: {$gt: 5}}}},                                              // 1106
          {dogs: [{name: "Fido", age: 5}, {name: "Rex", age: 3}]});                                         // 1107
  match({dogs: {$elemMatch: {name: /i/, age: {$gt: 4}}}},                                                   // 1108
        {dogs: [{name: "Fido", age: 5}, {name: "Rex", age: 3}]});                                           // 1109
  nomatch({dogs: {$elemMatch: {name: /e/, age: 5}}},                                                        // 1110
          {dogs: [{name: "Fido", age: 5}, {name: "Rex", age: 3}]});                                         // 1111
  match({x: {$elemMatch: {y: 9}}}, {x: [{y: 9}]});                                                          // 1112
  nomatch({x: {$elemMatch: {y: 9}}}, {x: [[{y: 9}]]});                                                      // 1113
  match({x: {$elemMatch: {$gt: 5, $lt: 9}}}, {x: [8]});                                                     // 1114
  nomatch({x: {$elemMatch: {$gt: 5, $lt: 9}}}, {x: [[8]]});                                                 // 1115
  match({'a.x': {$elemMatch: {y: 9}}},                                                                      // 1116
        {a: [{x: []}, {x: [{y: 9}]}]});                                                                     // 1117
  nomatch({a: {$elemMatch: {x: 5}}}, {a: {x: 5}});                                                          // 1118
  match({a: {$elemMatch: {0: {$gt: 5, $lt: 9}}}}, {a: [[6]]});                                              // 1119
  match({a: {$elemMatch: {'0.b': {$gt: 5, $lt: 9}}}}, {a: [[{b:6}]]});                                      // 1120
  match({a: {$elemMatch: {x: 1, $or: [{a: 1}, {b: 1}]}}},                                                   // 1121
        {a: [{x: 1, b: 1}]});                                                                               // 1122
  match({a: {$elemMatch: {$or: [{a: 1}, {b: 1}], x: 1}}},                                                   // 1123
        {a: [{x: 1, b: 1}]});                                                                               // 1124
  nomatch({a: {$elemMatch: {x: 1, $or: [{a: 1}, {b: 1}]}}},                                                 // 1125
          {a: [{b: 1}]});                                                                                   // 1126
  nomatch({a: {$elemMatch: {x: 1, $or: [{a: 1}, {b: 1}]}}},                                                 // 1127
          {a: [{x: 1}]});                                                                                   // 1128
  nomatch({a: {$elemMatch: {x: 1, $or: [{a: 1}, {b: 1}]}}},                                                 // 1129
          {a: [{x: 1}, {b: 1}]});                                                                           // 1130
                                                                                                            // 1131
  // $comment                                                                                               // 1132
  match({a: 5, $comment: "asdf"}, {a: 5});                                                                  // 1133
  nomatch({a: 6, $comment: "asdf"}, {a: 5});                                                                // 1134
                                                                                                            // 1135
  // XXX still needs tests:                                                                                 // 1136
  // - non-scalar arguments to $gt, $lt, etc                                                                // 1137
});                                                                                                         // 1138
                                                                                                            // 1139
Tinytest.add("minimongo - projection_compiler", function (test) {                                           // 1140
  var testProjection = function (projection, tests) {                                                       // 1141
    var projection_f = LocalCollection._compileProjection(projection);                                      // 1142
    var equalNonStrict = function (a, b, desc) {                                                            // 1143
      test.isTrue(_.isEqual(a, b), desc);                                                                   // 1144
    };                                                                                                      // 1145
                                                                                                            // 1146
    _.each(tests, function (testCase) {                                                                     // 1147
      equalNonStrict(projection_f(testCase[0]), testCase[1], testCase[2]);                                  // 1148
    });                                                                                                     // 1149
  };                                                                                                        // 1150
                                                                                                            // 1151
  testProjection({ 'foo': 1, 'bar': 1 }, [                                                                  // 1152
    [{ foo: 42, bar: "something", baz: "else" },                                                            // 1153
     { foo: 42, bar: "something" },                                                                         // 1154
     "simplest - whitelist"],                                                                               // 1155
                                                                                                            // 1156
    [{ foo: { nested: 17 }, baz: {} },                                                                      // 1157
     { foo: { nested: 17 } },                                                                               // 1158
     "nested whitelisted field"],                                                                           // 1159
                                                                                                            // 1160
    [{ _id: "uid", bazbaz: 42 },                                                                            // 1161
     { _id: "uid" },                                                                                        // 1162
     "simplest whitelist - preserve _id"]                                                                   // 1163
  ]);                                                                                                       // 1164
                                                                                                            // 1165
  testProjection({ 'foo': 0, 'bar': 0 }, [                                                                  // 1166
    [{ foo: 42, bar: "something", baz: "else" },                                                            // 1167
     { baz: "else" },                                                                                       // 1168
     "simplest - blacklist"],                                                                               // 1169
                                                                                                            // 1170
    [{ foo: { nested: 17 }, baz: { foo: "something" } },                                                    // 1171
     { baz: { foo: "something" } },                                                                         // 1172
     "nested blacklisted field"],                                                                           // 1173
                                                                                                            // 1174
    [{ _id: "uid", bazbaz: 42 },                                                                            // 1175
     { _id: "uid", bazbaz: 42 },                                                                            // 1176
     "simplest blacklist - preserve _id"]                                                                   // 1177
  ]);                                                                                                       // 1178
                                                                                                            // 1179
  testProjection({ _id: 0, foo: 1 }, [                                                                      // 1180
    [{ foo: 42, bar: 33, _id: "uid" },                                                                      // 1181
     { foo: 42 },                                                                                           // 1182
     "whitelist - _id blacklisted"]                                                                         // 1183
  ]);                                                                                                       // 1184
                                                                                                            // 1185
  testProjection({ _id: 0, foo: 0 }, [                                                                      // 1186
    [{ foo: 42, bar: 33, _id: "uid" },                                                                      // 1187
     { bar: 33 },                                                                                           // 1188
     "blacklist - _id blacklisted"]                                                                         // 1189
  ]);                                                                                                       // 1190
                                                                                                            // 1191
  testProjection({ 'foo.bar.baz': 1 }, [                                                                    // 1192
    [{ foo: { meh: "fur", bar: { baz: 42 }, tr: 1 }, bar: 33, baz: 'trolololo' },                           // 1193
     { foo: { bar: { baz: 42 } } },                                                                         // 1194
     "whitelist nested"],                                                                                   // 1195
                                                                                                            // 1196
    // Behavior of this test is looked up in actual mongo                                                   // 1197
    [{ foo: { meh: "fur", bar: "nope", tr: 1 }, bar: 33, baz: 'trolololo' },                                // 1198
     { foo: {} },                                                                                           // 1199
     "whitelist nested - path not found in doc, different type"],                                           // 1200
                                                                                                            // 1201
    // Behavior of this test is looked up in actual mongo                                                   // 1202
    [{ foo: { meh: "fur", bar: [], tr: 1 }, bar: 33, baz: 'trolololo' },                                    // 1203
     { foo: { bar: [] } },                                                                                  // 1204
     "whitelist nested - path not found in doc"]                                                            // 1205
  ]);                                                                                                       // 1206
                                                                                                            // 1207
  testProjection({ 'hope.humanity': 0, 'hope.people': 0 }, [                                                // 1208
    [{ hope: { humanity: "lost", people: 'broken', candies: 'long live!' } },                               // 1209
     { hope: { candies: 'long live!' } },                                                                   // 1210
     "blacklist nested"],                                                                                   // 1211
                                                                                                            // 1212
    [{ hope: "new" },                                                                                       // 1213
     { hope: "new" },                                                                                       // 1214
     "blacklist nested - path not found in doc"]                                                            // 1215
  ]);                                                                                                       // 1216
                                                                                                            // 1217
  testProjection({ _id: 1 }, [                                                                              // 1218
    [{ _id: 42, x: 1, y: { z: "2" } },                                                                      // 1219
     { _id: 42 },                                                                                           // 1220
     "_id whitelisted"],                                                                                    // 1221
    [{ _id: 33 },                                                                                           // 1222
     { _id: 33 },                                                                                           // 1223
     "_id whitelisted, _id only"],                                                                          // 1224
    [{ x: 1 },                                                                                              // 1225
     {},                                                                                                    // 1226
     "_id whitelisted, no _id"]                                                                             // 1227
  ]);                                                                                                       // 1228
                                                                                                            // 1229
  testProjection({ _id: 0 }, [                                                                              // 1230
    [{ _id: 42, x: 1, y: { z: "2" } },                                                                      // 1231
     { x: 1, y: { z: "2" } },                                                                               // 1232
     "_id blacklisted"],                                                                                    // 1233
    [{ _id: 33 },                                                                                           // 1234
     {},                                                                                                    // 1235
     "_id blacklisted, _id only"],                                                                          // 1236
    [{ x: 1 },                                                                                              // 1237
     { x: 1 },                                                                                              // 1238
     "_id blacklisted, no _id"]                                                                             // 1239
  ]);                                                                                                       // 1240
                                                                                                            // 1241
  testProjection({}, [                                                                                      // 1242
    [{ a: 1, b: 2, c: "3" },                                                                                // 1243
     { a: 1, b: 2, c: "3" },                                                                                // 1244
     "empty projection"]                                                                                    // 1245
  ]);                                                                                                       // 1246
                                                                                                            // 1247
  test.throws(function () {                                                                                 // 1248
    testProjection({ 'inc': 1, 'excl': 0 }, [                                                               // 1249
      [ { inc: 42, excl: 42 }, { inc: 42 }, "Can't combine incl/excl rules" ]                               // 1250
    ]);                                                                                                     // 1251
  });                                                                                                       // 1252
                                                                                                            // 1253
  test.throws(function () {                                                                                 // 1254
    testProjection({ 'a': 1, 'a.b': 1 }, [                                                                  // 1255
      [ { a: { b: 42 } }, { a: { b: 42 } }, "Can't have ambiguous rules (one is prefix of another)" ]       // 1256
    ]);                                                                                                     // 1257
  });                                                                                                       // 1258
  test.throws(function () {                                                                                 // 1259
    testProjection({ 'a.b.c': 1, 'a.b': 1, 'a': 1 }, [                                                      // 1260
      [ { a: { b: 42 } }, { a: { b: 42 } }, "Can't have ambiguous rules (one is prefix of another)" ]       // 1261
    ]);                                                                                                     // 1262
  });                                                                                                       // 1263
                                                                                                            // 1264
  test.throws(function () {                                                                                 // 1265
    testProjection("some string", [                                                                         // 1266
      [ { a: { b: 42 } }, { a: { b: 42 } }, "Projection is not a hash" ]                                    // 1267
    ]);                                                                                                     // 1268
  });                                                                                                       // 1269
});                                                                                                         // 1270
                                                                                                            // 1271
Tinytest.add("minimongo - fetch with fields", function (test) {                                             // 1272
  var c = new LocalCollection();                                                                            // 1273
  _.times(30, function (i) {                                                                                // 1274
    c.insert({                                                                                              // 1275
      something: Random.id(),                                                                               // 1276
      anything: {                                                                                           // 1277
        foo: "bar",                                                                                         // 1278
        cool: "hot"                                                                                         // 1279
      },                                                                                                    // 1280
      nothing: i,                                                                                           // 1281
      i: i                                                                                                  // 1282
    });                                                                                                     // 1283
  });                                                                                                       // 1284
                                                                                                            // 1285
  // Test just a regular fetch with some projection                                                         // 1286
  var fetchResults = c.find({}, { fields: {                                                                 // 1287
    'something': 1,                                                                                         // 1288
    'anything.foo': 1                                                                                       // 1289
  } }).fetch();                                                                                             // 1290
                                                                                                            // 1291
  test.isTrue(_.all(fetchResults, function (x) {                                                            // 1292
    return x &&                                                                                             // 1293
           x.something &&                                                                                   // 1294
           x.anything &&                                                                                    // 1295
           x.anything.foo &&                                                                                // 1296
           x.anything.foo === "bar" &&                                                                      // 1297
           !_.has(x, 'nothing') &&                                                                          // 1298
           !_.has(x.anything, 'cool');                                                                      // 1299
  }));                                                                                                      // 1300
                                                                                                            // 1301
  // Test with a selector, even field used in the selector is excluded in the                               // 1302
  // projection                                                                                             // 1303
  fetchResults = c.find({                                                                                   // 1304
    nothing: { $gte: 5 }                                                                                    // 1305
  }, {                                                                                                      // 1306
    fields: { nothing: 0 }                                                                                  // 1307
  }).fetch();                                                                                               // 1308
                                                                                                            // 1309
  test.isTrue(_.all(fetchResults, function (x) {                                                            // 1310
    return x &&                                                                                             // 1311
           x.something &&                                                                                   // 1312
           x.anything &&                                                                                    // 1313
           x.anything.foo === "bar" &&                                                                      // 1314
           x.anything.cool === "hot" &&                                                                     // 1315
           !_.has(x, 'nothing') &&                                                                          // 1316
           x.i &&                                                                                           // 1317
           x.i >= 5;                                                                                        // 1318
  }));                                                                                                      // 1319
                                                                                                            // 1320
  test.isTrue(fetchResults.length === 25);                                                                  // 1321
                                                                                                            // 1322
  // Test that we can sort, based on field excluded from the projection, use                                // 1323
  // skip and limit as well!                                                                                // 1324
  // following find will get indexes [10..20) sorted by nothing                                             // 1325
  fetchResults = c.find({}, {                                                                               // 1326
    sort: {                                                                                                 // 1327
      nothing: 1                                                                                            // 1328
    },                                                                                                      // 1329
    limit: 10,                                                                                              // 1330
    skip: 10,                                                                                               // 1331
    fields: {                                                                                               // 1332
      i: 1,                                                                                                 // 1333
      something: 1                                                                                          // 1334
    }                                                                                                       // 1335
  }).fetch();                                                                                               // 1336
                                                                                                            // 1337
  test.isTrue(_.all(fetchResults, function (x) {                                                            // 1338
    return x &&                                                                                             // 1339
           x.something &&                                                                                   // 1340
           x.i >= 10 && x.i < 20;                                                                           // 1341
  }));                                                                                                      // 1342
                                                                                                            // 1343
  _.each(fetchResults, function (x, i, arr) {                                                               // 1344
    if (!i) return;                                                                                         // 1345
    test.isTrue(x.i === arr[i-1].i + 1);                                                                    // 1346
  });                                                                                                       // 1347
                                                                                                            // 1348
  // Temporary unsupported operators                                                                        // 1349
  // queries are taken from MongoDB docs examples                                                           // 1350
  test.throws(function () {                                                                                 // 1351
    c.find({}, { fields: { 'grades.$': 1 } });                                                              // 1352
  });                                                                                                       // 1353
  test.throws(function () {                                                                                 // 1354
    c.find({}, { fields: { grades: { $elemMatch: { mean: 70 } } } });                                       // 1355
  });                                                                                                       // 1356
  test.throws(function () {                                                                                 // 1357
    c.find({}, { fields: { grades: { $slice: [20, 10] } } });                                               // 1358
  });                                                                                                       // 1359
});                                                                                                         // 1360
                                                                                                            // 1361
Tinytest.add("minimongo - fetch with projection, subarrays", function (test) {                              // 1362
  // Apparently projection of type 'foo.bar.x' for                                                          // 1363
  // { foo: [ { bar: { x: 42 } }, { bar: { x: 3 } } ] }                                                     // 1364
  // should return exactly this object. More precisely, arrays are considered as                            // 1365
  // sets and are queried separately and then merged back to result set                                     // 1366
  var c = new LocalCollection();                                                                            // 1367
                                                                                                            // 1368
  // Insert a test object with two set fields                                                               // 1369
  c.insert({                                                                                                // 1370
    setA: [{                                                                                                // 1371
      fieldA: 42,                                                                                           // 1372
      fieldB: 33                                                                                            // 1373
    }, {                                                                                                    // 1374
      fieldA: "the good",                                                                                   // 1375
      fieldB: "the bad",                                                                                    // 1376
      fieldC: "the ugly"                                                                                    // 1377
    }],                                                                                                     // 1378
    setB: [{                                                                                                // 1379
      anotherA: { },                                                                                        // 1380
      anotherB: "meh"                                                                                       // 1381
    }, {                                                                                                    // 1382
      anotherA: 1234,                                                                                       // 1383
      anotherB: 431                                                                                         // 1384
    }]                                                                                                      // 1385
  });                                                                                                       // 1386
                                                                                                            // 1387
  var equalNonStrict = function (a, b, desc) {                                                              // 1388
    test.isTrue(_.isEqual(a, b), desc);                                                                     // 1389
  };                                                                                                        // 1390
                                                                                                            // 1391
  var testForProjection = function (projection, expected) {                                                 // 1392
    var fetched = c.find({}, { fields: projection }).fetch()[0];                                            // 1393
    equalNonStrict(fetched, expected, "failed sub-set projection: " +                                       // 1394
                                      JSON.stringify(projection));                                          // 1395
  };                                                                                                        // 1396
                                                                                                            // 1397
  testForProjection({ 'setA.fieldA': 1, 'setB.anotherB': 1, _id: 0 },                                       // 1398
                    {                                                                                       // 1399
                      setA: [{ fieldA: 42 }, { fieldA: "the good" }],                                       // 1400
                      setB: [{ anotherB: "meh" }, { anotherB: 431 }]                                        // 1401
                    });                                                                                     // 1402
                                                                                                            // 1403
  testForProjection({ 'setA.fieldA': 0, 'setB.anotherA': 0, _id: 0 },                                       // 1404
                    {                                                                                       // 1405
                      setA: [{fieldB:33}, {fieldB:"the bad",fieldC:"the ugly"}],                            // 1406
                      setB: [{ anotherB: "meh" }, { anotherB: 431 }]                                        // 1407
                    });                                                                                     // 1408
                                                                                                            // 1409
  c.remove({});                                                                                             // 1410
  c.insert({a:[[{b:1,c:2},{b:2,c:4}],{b:3,c:5},[{b:4, c:9}]]});                                             // 1411
                                                                                                            // 1412
  testForProjection({ 'a.b': 1, _id: 0 },                                                                   // 1413
                    {a: [ [ { b: 1 }, { b: 2 } ], { b: 3 }, [ { b: 4 } ] ] });                              // 1414
  testForProjection({ 'a.b': 0, _id: 0 },                                                                   // 1415
                    {a: [ [ { c: 2 }, { c: 4 } ], { c: 5 }, [ { c: 9 } ] ] });                              // 1416
});                                                                                                         // 1417
                                                                                                            // 1418
Tinytest.add("minimongo - fetch with projection, deep copy", function (test) {                              // 1419
  // Compiled fields projection defines the contract: returned document doesn't                             // 1420
  // retain anything from the passed argument.                                                              // 1421
  var doc = {                                                                                               // 1422
    a: { x: 42 },                                                                                           // 1423
    b: {                                                                                                    // 1424
      y: { z: 33 }                                                                                          // 1425
    },                                                                                                      // 1426
    c: "asdf"                                                                                               // 1427
  };                                                                                                        // 1428
                                                                                                            // 1429
  var fields = {                                                                                            // 1430
    'a': 1,                                                                                                 // 1431
    'b.y': 1                                                                                                // 1432
  };                                                                                                        // 1433
                                                                                                            // 1434
  var projectionFn = LocalCollection._compileProjection(fields);                                            // 1435
  var filteredDoc = projectionFn(doc);                                                                      // 1436
  doc.a.x++;                                                                                                // 1437
  doc.b.y.z--;                                                                                              // 1438
  test.equal(filteredDoc.a.x, 42, "projection returning deep copy - including");                            // 1439
  test.equal(filteredDoc.b.y.z, 33, "projection returning deep copy - including");                          // 1440
                                                                                                            // 1441
  fields = { c: 0 };                                                                                        // 1442
  projectionFn = LocalCollection._compileProjection(fields);                                                // 1443
  filteredDoc = projectionFn(doc);                                                                          // 1444
                                                                                                            // 1445
  doc.a.x = 5;                                                                                              // 1446
  test.equal(filteredDoc.a.x, 43, "projection returning deep copy - excluding");                            // 1447
});                                                                                                         // 1448
                                                                                                            // 1449
Tinytest.add("minimongo - observe ordered with projection", function (test) {                               // 1450
  // These tests are copy-paste from "minimongo -observe ordered",                                          // 1451
  // slightly modified to test projection                                                                   // 1452
  var operations = [];                                                                                      // 1453
  var cbs = log_callbacks(operations);                                                                      // 1454
  var handle;                                                                                               // 1455
                                                                                                            // 1456
  var c = new LocalCollection();                                                                            // 1457
  handle = c.find({}, {sort: {a: 1}, fields: { a: 1 }}).observe(cbs);                                       // 1458
  test.isTrue(handle.collection === c);                                                                     // 1459
                                                                                                            // 1460
  c.insert({_id: 'foo', a:1, b:2});                                                                         // 1461
  test.equal(operations.shift(), ['added', {a:1}, 0, null]);                                                // 1462
  c.update({a:1}, {$set: {a: 2, b: 1}});                                                                    // 1463
  test.equal(operations.shift(), ['changed', {a:2}, 0, {a:1}]);                                             // 1464
  c.insert({_id: 'bar', a:10, c: 33});                                                                      // 1465
  test.equal(operations.shift(), ['added', {a:10}, 1, null]);                                               // 1466
  c.update({}, {$inc: {a: 1}}, {multi: true});                                                              // 1467
  c.update({}, {$inc: {c: 1}}, {multi: true});                                                              // 1468
  test.equal(operations.shift(), ['changed', {a:3}, 0, {a:2}]);                                             // 1469
  test.equal(operations.shift(), ['changed', {a:11}, 1, {a:10}]);                                           // 1470
  c.update({a:11}, {a:1, b:44});                                                                            // 1471
  test.equal(operations.shift(), ['changed', {a:1}, 1, {a:11}]);                                            // 1472
  test.equal(operations.shift(), ['moved', {a:1}, 1, 0, 'foo']);                                            // 1473
  c.remove({a:2});                                                                                          // 1474
  test.equal(operations.shift(), undefined);                                                                // 1475
  c.remove({a:3});                                                                                          // 1476
  test.equal(operations.shift(), ['removed', 'foo', 1, {a:3}]);                                             // 1477
                                                                                                            // 1478
  // test stop                                                                                              // 1479
  handle.stop();                                                                                            // 1480
  var idA2 = Random.id();                                                                                   // 1481
  c.insert({_id: idA2, a:2});                                                                               // 1482
  test.equal(operations.shift(), undefined);                                                                // 1483
                                                                                                            // 1484
  var cursor = c.find({}, {fields: {a: 1, _id: 0}});                                                        // 1485
  test.throws(function () {                                                                                 // 1486
    cursor.observeChanges({added: function () {}});                                                         // 1487
  });                                                                                                       // 1488
  test.throws(function () {                                                                                 // 1489
    cursor.observe({added: function () {}});                                                                // 1490
  });                                                                                                       // 1491
                                                                                                            // 1492
  // test initial inserts (and backwards sort)                                                              // 1493
  handle = c.find({}, {sort: {a: -1}, fields: { a: 1 } }).observe(cbs);                                     // 1494
  test.equal(operations.shift(), ['added', {a:2}, 0, null]);                                                // 1495
  test.equal(operations.shift(), ['added', {a:1}, 1, null]);                                                // 1496
  handle.stop();                                                                                            // 1497
                                                                                                            // 1498
  // test _suppress_initial                                                                                 // 1499
  handle = c.find({}, {sort: {a: -1}, fields: { a: 1 }}).observe(_.extend(cbs, {_suppress_initial: true})); // 1500
  test.equal(operations.shift(), undefined);                                                                // 1501
  c.insert({a:100, b: { foo: "bar" }});                                                                     // 1502
  test.equal(operations.shift(), ['added', {a:100}, 0, idA2]);                                              // 1503
  handle.stop();                                                                                            // 1504
                                                                                                            // 1505
  // test skip and limit.                                                                                   // 1506
  c.remove({});                                                                                             // 1507
  handle = c.find({}, {sort: {a: 1}, skip: 1, limit: 2, fields: { 'blacklisted': 0 }}).observe(cbs);        // 1508
  test.equal(operations.shift(), undefined);                                                                // 1509
  c.insert({a:1, blacklisted:1324});                                                                        // 1510
  test.equal(operations.shift(), undefined);                                                                // 1511
  c.insert({_id: 'foo', a:2, blacklisted:["something"]});                                                   // 1512
  test.equal(operations.shift(), ['added', {a:2}, 0, null]);                                                // 1513
  c.insert({a:3, blacklisted: { 2: 3 }});                                                                   // 1514
  test.equal(operations.shift(), ['added', {a:3}, 1, null]);                                                // 1515
  c.insert({a:4, blacklisted: 6});                                                                          // 1516
  test.equal(operations.shift(), undefined);                                                                // 1517
  c.update({a:1}, {a:0, blacklisted:4444});                                                                 // 1518
  test.equal(operations.shift(), undefined);                                                                // 1519
  c.update({a:0}, {a:5, blacklisted:11111});                                                                // 1520
  test.equal(operations.shift(), ['removed', 'foo', 0, {a:2}]);                                             // 1521
  test.equal(operations.shift(), ['added', {a:4}, 1, null]);                                                // 1522
  c.update({a:3}, {a:3.5, blacklisted:333.4444});                                                           // 1523
  test.equal(operations.shift(), ['changed', {a:3.5}, 0, {a:3}]);                                           // 1524
  handle.stop();                                                                                            // 1525
                                                                                                            // 1526
  // test _no_indices                                                                                       // 1527
                                                                                                            // 1528
  c.remove({});                                                                                             // 1529
  handle = c.find({}, {sort: {a: 1}, fields: { a: 1 }}).observe(_.extend(cbs, {_no_indices: true}));        // 1530
  c.insert({_id: 'foo', a:1, zoo: "crazy"});                                                                // 1531
  test.equal(operations.shift(), ['added', {a:1}, -1, null]);                                               // 1532
  c.update({a:1}, {$set: {a: 2, foobar: "player"}});                                                        // 1533
  test.equal(operations.shift(), ['changed', {a:2}, -1, {a:1}]);                                            // 1534
  c.insert({a:10, b:123.45});                                                                               // 1535
  test.equal(operations.shift(), ['added', {a:10}, -1, null]);                                              // 1536
  c.update({}, {$inc: {a: 1, b:2}}, {multi: true});                                                         // 1537
  test.equal(operations.shift(), ['changed', {a:3}, -1, {a:2}]);                                            // 1538
  test.equal(operations.shift(), ['changed', {a:11}, -1, {a:10}]);                                          // 1539
  c.update({a:11, b:125.45}, {a:1, b:444});                                                                 // 1540
  test.equal(operations.shift(), ['changed', {a:1}, -1, {a:11}]);                                           // 1541
  test.equal(operations.shift(), ['moved', {a:1}, -1, -1, 'foo']);                                          // 1542
  c.remove({a:2});                                                                                          // 1543
  test.equal(operations.shift(), undefined);                                                                // 1544
  c.remove({a:3});                                                                                          // 1545
  test.equal(operations.shift(), ['removed', 'foo', -1, {a:3}]);                                            // 1546
  handle.stop();                                                                                            // 1547
});                                                                                                         // 1548
                                                                                                            // 1549
                                                                                                            // 1550
Tinytest.add("minimongo - ordering", function (test) {                                                      // 1551
  var shortBinary = EJSON.newBinary(1);                                                                     // 1552
  shortBinary[0] = 128;                                                                                     // 1553
  var longBinary1 = EJSON.newBinary(2);                                                                     // 1554
  longBinary1[1] = 42;                                                                                      // 1555
  var longBinary2 = EJSON.newBinary(2);                                                                     // 1556
  longBinary2[1] = 50;                                                                                      // 1557
                                                                                                            // 1558
  var date1 = new Date;                                                                                     // 1559
  var date2 = new Date(date1.getTime() + 1000);                                                             // 1560
                                                                                                            // 1561
  // value ordering                                                                                         // 1562
  assert_ordering(test, LocalCollection._f._cmp, [                                                          // 1563
    null,                                                                                                   // 1564
    1, 2.2, 3,                                                                                              // 1565
    "03", "1", "11", "2", "a", "aaa",                                                                       // 1566
    {}, {a: 2}, {a: 3}, {a: 3, b: 4}, {b: 4}, {b: 4, a: 3},                                                 // 1567
    {b: {}}, {b: [1, 2, 3]}, {b: [1, 2, 4]},                                                                // 1568
    [], [1, 2], [1, 2, 3], [1, 2, 4], [1, 2, "4"], [1, 2, [4]],                                             // 1569
    shortBinary, longBinary1, longBinary2,                                                                  // 1570
    new LocalCollection._ObjectID("1234567890abcd1234567890"),                                              // 1571
    new LocalCollection._ObjectID("abcd1234567890abcd123456"),                                              // 1572
    false, true,                                                                                            // 1573
    date1, date2                                                                                            // 1574
  ]);                                                                                                       // 1575
                                                                                                            // 1576
  // document ordering under a sort specification                                                           // 1577
  var verify = function (sorts, docs) {                                                                     // 1578
    _.each(_.isArray(sorts) ? sorts : [sorts], function (sort) {                                            // 1579
      var sorter = new Minimongo.Sorter(sort);                                                              // 1580
      assert_ordering(test, sorter.getComparator(), docs);                                                  // 1581
    });                                                                                                     // 1582
  };                                                                                                        // 1583
                                                                                                            // 1584
  // note: [] doesn't sort with "arrays", it sorts as "undefined". the position                             // 1585
  // of arrays in _typeorder only matters for things like $lt. (This behavior                               // 1586
  // verified with MongoDB 2.2.1.) We don't define the relative order of {a: []}                            // 1587
  // and {c: 1} is undefined (MongoDB does seem to care but it's not clear how                              // 1588
  // or why).                                                                                               // 1589
  verify([{"a" : 1}, ["a"], [["a", "asc"]]],                                                                // 1590
         [{a: []}, {a: 1}, {a: {}}, {a: true}]);                                                            // 1591
  verify([{"a" : 1}, ["a"], [["a", "asc"]]],                                                                // 1592
         [{c: 1}, {a: 1}, {a: {}}, {a: true}]);                                                             // 1593
  verify([{"a" : -1}, [["a", "desc"]]],                                                                     // 1594
         [{a: true}, {a: {}}, {a: 1}, {c: 1}]);                                                             // 1595
  verify([{"a" : -1}, [["a", "desc"]]],                                                                     // 1596
         [{a: true}, {a: {}}, {a: 1}, {a: []}]);                                                            // 1597
                                                                                                            // 1598
  verify([{"a" : 1, "b": -1}, ["a", ["b", "desc"]],                                                         // 1599
          [["a", "asc"], ["b", "desc"]]],                                                                   // 1600
         [{c: 1}, {a: 1, b: 3}, {a: 1, b: 2}, {a: 2, b: 0}]);                                               // 1601
                                                                                                            // 1602
  verify([{"a" : 1, "b": 1}, ["a", "b"],                                                                    // 1603
          [["a", "asc"], ["b", "asc"]]],                                                                    // 1604
         [{c: 1}, {a: 1, b: 2}, {a: 1, b: 3}, {a: 2, b: 0}]);                                               // 1605
                                                                                                            // 1606
  test.throws(function () {                                                                                 // 1607
    new Minimongo.Sorter("a");                                                                              // 1608
  });                                                                                                       // 1609
                                                                                                            // 1610
  test.throws(function () {                                                                                 // 1611
    new Minimongo.Sorter(123);                                                                              // 1612
  });                                                                                                       // 1613
                                                                                                            // 1614
  // We don't support $natural:1 (since we don't actually have Mongo's on-disk                              // 1615
  // ordering available!)                                                                                   // 1616
  test.throws(function () {                                                                                 // 1617
    new Minimongo.Sorter({$natural: 1});                                                                    // 1618
  });                                                                                                       // 1619
                                                                                                            // 1620
  // No sort spec implies everything equal.                                                                 // 1621
  test.equal(new Minimongo.Sorter({}).getComparator()({a:1}, {a:2}), 0);                                    // 1622
                                                                                                            // 1623
  // All sorts of array edge cases!                                                                         // 1624
  // Increasing sort sorts by the smallest element it finds; 1 < 2.                                         // 1625
  verify({a: 1}, [                                                                                          // 1626
    {a: [1, 10, 20]},                                                                                       // 1627
    {a: [5, 2, 99]}                                                                                         // 1628
  ]);                                                                                                       // 1629
  // Decreasing sorts by largest it finds; 99 > 20.                                                         // 1630
  verify({a: -1}, [                                                                                         // 1631
    {a: [5, 2, 99]},                                                                                        // 1632
    {a: [1, 10, 20]}                                                                                        // 1633
  ]);                                                                                                       // 1634
  // Can also sort by specific array indices.                                                               // 1635
  verify({'a.1': 1}, [                                                                                      // 1636
    {a: [5, 2, 99]},                                                                                        // 1637
    {a: [1, 10, 20]}                                                                                        // 1638
  ]);                                                                                                       // 1639
  // We do NOT expand sub-arrays, so the minimum in the second doc is 5, not                                // 1640
  // -20. (Numbers always sort before arrays.)                                                              // 1641
  verify({a: 1}, [                                                                                          // 1642
    {a: [1, [10, 15], 20]},                                                                                 // 1643
    {a: [5, [-5, -20], 18]}                                                                                 // 1644
  ]);                                                                                                       // 1645
  // The maximum in each of these is the array, since arrays are "greater" than                             // 1646
  // numbers. And [10, 15] is greater than [-5, -20].                                                       // 1647
  verify({a: -1}, [                                                                                         // 1648
    {a: [1, [10, 15], 20]},                                                                                 // 1649
    {a: [5, [-5, -20], 18]}                                                                                 // 1650
  ]);                                                                                                       // 1651
  // 'a.0' here ONLY means "first element of a", not "first element of something                            // 1652
  // found in a", so it CANNOT find the 10 or -5.                                                           // 1653
  verify({'a.0': 1}, [                                                                                      // 1654
    {a: [1, [10, 15], 20]},                                                                                 // 1655
    {a: [5, [-5, -20], 18]}                                                                                 // 1656
  ]);                                                                                                       // 1657
  verify({'a.0': -1}, [                                                                                     // 1658
    {a: [5, [-5, -20], 18]},                                                                                // 1659
    {a: [1, [10, 15], 20]}                                                                                  // 1660
  ]);                                                                                                       // 1661
  // Similarly, this is just comparing [-5,-20] to [10, 15].                                                // 1662
  verify({'a.1': 1}, [                                                                                      // 1663
    {a: [5, [-5, -20], 18]},                                                                                // 1664
    {a: [1, [10, 15], 20]}                                                                                  // 1665
  ]);                                                                                                       // 1666
  verify({'a.1': -1}, [                                                                                     // 1667
    {a: [1, [10, 15], 20]},                                                                                 // 1668
    {a: [5, [-5, -20], 18]}                                                                                 // 1669
  ]);                                                                                                       // 1670
  // Here we are just comparing [10,15] directly to [19,3] (and NOT also                                    // 1671
  // iterating over the numbers; this is implemented by setting dontIterate in                              // 1672
  // makeLookupFunction).  So [10,15]<[19,3] even though 3 is the smallest                                  // 1673
  // number you can find there.                                                                             // 1674
  verify({'a.1': 1}, [                                                                                      // 1675
    {a: [1, [10, 15], 20]},                                                                                 // 1676
    {a: [5, [19, 3], 18]}                                                                                   // 1677
  ]);                                                                                                       // 1678
  verify({'a.1': -1}, [                                                                                     // 1679
    {a: [5, [19, 3], 18]},                                                                                  // 1680
    {a: [1, [10, 15], 20]}                                                                                  // 1681
  ]);                                                                                                       // 1682
  // Minimal elements are 1 and 5.                                                                          // 1683
  verify({a: 1}, [                                                                                          // 1684
    {a: [1, [10, 15], 20]},                                                                                 // 1685
    {a: [5, [19, 3], 18]}                                                                                   // 1686
  ]);                                                                                                       // 1687
  // Maximal elements are [19,3] and [10,15] (because arrays sort higher than                               // 1688
  // numbers), even though there's a 20 floating around.                                                    // 1689
  verify({a: -1}, [                                                                                         // 1690
    {a: [5, [19, 3], 18]},                                                                                  // 1691
    {a: [1, [10, 15], 20]}                                                                                  // 1692
  ]);                                                                                                       // 1693
  // Maximal elements are [10,15] and [3,19].  [10,15] is bigger even though 19                             // 1694
  // is the biggest number in them, because array comparison is lexicographic.                              // 1695
  verify({a: -1}, [                                                                                         // 1696
    {a: [1, [10, 15], 20]},                                                                                 // 1697
    {a: [5, [3, 19], 18]}                                                                                   // 1698
  ]);                                                                                                       // 1699
                                                                                                            // 1700
  // (0,4) < (0,5), so they go in this order.  It's not correct to consider                                 // 1701
  // (0,3) as a sort key for the second document because they come from                                     // 1702
  // different a-branches.                                                                                  // 1703
  verify({'a.x': 1, 'a.y': 1}, [                                                                            // 1704
    {a: [{x: 0, y: 4}]},                                                                                    // 1705
    {a: [{x: 0, y: 5}, {x: 1, y: 3}]}                                                                       // 1706
  ]);                                                                                                       // 1707
});                                                                                                         // 1708
                                                                                                            // 1709
Tinytest.add("minimongo - sort", function (test) {                                                          // 1710
  var c = new LocalCollection();                                                                            // 1711
  for (var i = 0; i < 50; i++)                                                                              // 1712
    for (var j = 0; j < 2; j++)                                                                             // 1713
      c.insert({a: i, b: j, _id: i + "_" + j});                                                             // 1714
                                                                                                            // 1715
  test.equal(                                                                                               // 1716
    c.find({a: {$gt: 10}}, {sort: {b: -1, a: 1}, limit: 5}).fetch(), [                                      // 1717
      {a: 11, b: 1, _id: "11_1"},                                                                           // 1718
      {a: 12, b: 1, _id: "12_1"},                                                                           // 1719
      {a: 13, b: 1, _id: "13_1"},                                                                           // 1720
      {a: 14, b: 1, _id: "14_1"},                                                                           // 1721
      {a: 15, b: 1, _id: "15_1"}]);                                                                         // 1722
                                                                                                            // 1723
  test.equal(                                                                                               // 1724
    c.find({a: {$gt: 10}}, {sort: {b: -1, a: 1}, skip: 3, limit: 5}).fetch(), [                             // 1725
      {a: 14, b: 1, _id: "14_1"},                                                                           // 1726
      {a: 15, b: 1, _id: "15_1"},                                                                           // 1727
      {a: 16, b: 1, _id: "16_1"},                                                                           // 1728
      {a: 17, b: 1, _id: "17_1"},                                                                           // 1729
      {a: 18, b: 1, _id: "18_1"}]);                                                                         // 1730
                                                                                                            // 1731
  test.equal(                                                                                               // 1732
    c.find({a: {$gte: 20}}, {sort: {a: 1, b: -1}, skip: 50, limit: 5}).fetch(), [                           // 1733
      {a: 45, b: 1, _id: "45_1"},                                                                           // 1734
      {a: 45, b: 0, _id: "45_0"},                                                                           // 1735
      {a: 46, b: 1, _id: "46_1"},                                                                           // 1736
      {a: 46, b: 0, _id: "46_0"},                                                                           // 1737
      {a: 47, b: 1, _id: "47_1"}]);                                                                         // 1738
});                                                                                                         // 1739
                                                                                                            // 1740
Tinytest.add("minimongo - subkey sort", function (test) {                                                   // 1741
  var c = new LocalCollection();                                                                            // 1742
                                                                                                            // 1743
  // normal case                                                                                            // 1744
  c.insert({a: {b: 2}});                                                                                    // 1745
  c.insert({a: {b: 1}});                                                                                    // 1746
  c.insert({a: {b: 3}});                                                                                    // 1747
  test.equal(                                                                                               // 1748
    _.pluck(c.find({}, {sort: {'a.b': -1}}).fetch(), 'a'),                                                  // 1749
    [{b: 3}, {b: 2}, {b: 1}]);                                                                              // 1750
                                                                                                            // 1751
  // isn't an object                                                                                        // 1752
  c.insert({a: 1});                                                                                         // 1753
  test.equal(                                                                                               // 1754
    _.pluck(c.find({}, {sort: {'a.b': 1}}).fetch(), 'a'),                                                   // 1755
    [1, {b: 1}, {b: 2}, {b: 3}]);                                                                           // 1756
                                                                                                            // 1757
  // complex object                                                                                         // 1758
  c.insert({a: {b: {c: 1}}});                                                                               // 1759
  test.equal(                                                                                               // 1760
    _.pluck(c.find({}, {sort: {'a.b': -1}}).fetch(), 'a'),                                                  // 1761
    [{b: {c: 1}}, {b: 3}, {b: 2}, {b: 1}, 1]);                                                              // 1762
                                                                                                            // 1763
  // no such top level prop                                                                                 // 1764
  c.insert({c: 1});                                                                                         // 1765
  test.equal(                                                                                               // 1766
    _.pluck(c.find({}, {sort: {'a.b': -1}}).fetch(), 'a'),                                                  // 1767
    [{b: {c: 1}}, {b: 3}, {b: 2}, {b: 1}, 1, undefined]);                                                   // 1768
                                                                                                            // 1769
  // no such mid level prop. just test that it doesn't throw.                                               // 1770
  test.equal(c.find({}, {sort: {'a.nope.c': -1}}).count(), 6);                                              // 1771
});                                                                                                         // 1772
                                                                                                            // 1773
Tinytest.add("minimongo - array sort", function (test) {                                                    // 1774
  var c = new LocalCollection();                                                                            // 1775
                                                                                                            // 1776
  // "up" and "down" are the indices that the docs should have when sorted                                  // 1777
  // ascending and descending by "a.x" respectively. They are not reverses of                               // 1778
  // each other: when sorting ascending, you use the minimum value you can find                             // 1779
  // in the document, and when sorting descending, you use the maximum value you                            // 1780
  // can find. So [1, 4] shows up in the 1 slot when sorting ascending and the 4                            // 1781
  // slot when sorting descending.                                                                          // 1782
  //                                                                                                        // 1783
  // Similarly, "selected" is the index that the doc should have in the query                               // 1784
  // that sorts ascending on "a.x" and selects {'a.x': {$gt: 1}}. In this case,                             // 1785
  // the 1 in [1, 4] may not be used as a sort key.                                                         // 1786
  c.insert({up: 1, down: 1, selected: 2, a: {x: [1, 4]}});                                                  // 1787
  c.insert({up: 2, down: 2, selected: 0, a: [{x: [2]}, {x: 3}]});                                           // 1788
  c.insert({up: 0, down: 4,              a: {x: 0}});                                                       // 1789
  c.insert({up: 3, down: 3, selected: 1, a: {x: 2.5}});                                                     // 1790
  c.insert({up: 4, down: 0, selected: 3, a: {x: 5}});                                                       // 1791
                                                                                                            // 1792
  // Test that the the documents in "cursor" contain values with the name                                   // 1793
  // "field" running from 0 to the max value of that name in the collection.                                // 1794
  var testCursorMatchesField = function (cursor, field) {                                                   // 1795
    var fieldValues = [];                                                                                   // 1796
    c.find().forEach(function (doc) {                                                                       // 1797
      if (_.has(doc, field))                                                                                // 1798
        fieldValues.push(doc[field]);                                                                       // 1799
    });                                                                                                     // 1800
    test.equal(_.pluck(cursor.fetch(), field),                                                              // 1801
               _.range(_.max(fieldValues) + 1));                                                            // 1802
  };                                                                                                        // 1803
                                                                                                            // 1804
  testCursorMatchesField(c.find({}, {sort: {'a.x': 1}}), 'up');                                             // 1805
  testCursorMatchesField(c.find({}, {sort: {'a.x': -1}}), 'down');                                          // 1806
  testCursorMatchesField(c.find({'a.x': {$gt: 1}}, {sort: {'a.x': 1}}),                                     // 1807
                         'selected');                                                                       // 1808
});                                                                                                         // 1809
                                                                                                            // 1810
Tinytest.add("minimongo - sort keys", function (test) {                                                     // 1811
  var keyListToObject = function (keyList) {                                                                // 1812
    var obj = {};                                                                                           // 1813
    _.each(keyList, function (key) {                                                                        // 1814
      obj[EJSON.stringify(key)] = true;                                                                     // 1815
    });                                                                                                     // 1816
    return obj;                                                                                             // 1817
  };                                                                                                        // 1818
                                                                                                            // 1819
  var testKeys = function (sortSpec, doc, expectedKeyList) {                                                // 1820
    var expectedKeys = keyListToObject(expectedKeyList);                                                    // 1821
    var sorter = new Minimongo.Sorter(sortSpec);                                                            // 1822
                                                                                                            // 1823
    var actualKeyList = [];                                                                                 // 1824
    sorter._generateKeysFromDoc(doc, function (key) {                                                       // 1825
      actualKeyList.push(key);                                                                              // 1826
    });                                                                                                     // 1827
    var actualKeys = keyListToObject(actualKeyList);                                                        // 1828
    test.equal(actualKeys, expectedKeys);                                                                   // 1829
  };                                                                                                        // 1830
                                                                                                            // 1831
  var testParallelError = function (sortSpec, doc) {                                                        // 1832
    var sorter = new Minimongo.Sorter(sortSpec);                                                            // 1833
    test.throws(function () {                                                                               // 1834
      sorter._generateKeysFromDoc(doc, function (){});                                                      // 1835
    }, /parallel arrays/);                                                                                  // 1836
  };                                                                                                        // 1837
                                                                                                            // 1838
  // Just non-array fields.                                                                                 // 1839
  testKeys({'a.x': 1, 'a.y': 1},                                                                            // 1840
           {a: {x: 0, y: 5}},                                                                               // 1841
           [[0,5]]);                                                                                        // 1842
                                                                                                            // 1843
  // Ensure that we don't get [0,3] and [1,5].                                                              // 1844
  testKeys({'a.x': 1, 'a.y': 1},                                                                            // 1845
           {a: [{x: 0, y: 5}, {x: 1, y: 3}]},                                                               // 1846
           [[0,5], [1,3]]);                                                                                 // 1847
                                                                                                            // 1848
  // Ensure we can combine "array fields" with "non-array fields".                                          // 1849
  testKeys({'a.x': 1, 'a.y': 1, b: -1},                                                                     // 1850
           {a: [{x: 0, y: 5}, {x: 1, y: 3}], b: 42},                                                        // 1851
           [[0,5,42], [1,3,42]]);                                                                           // 1852
  testKeys({b: -1, 'a.x': 1, 'a.y': 1},                                                                     // 1853
           {a: [{x: 0, y: 5}, {x: 1, y: 3}], b: 42},                                                        // 1854
           [[42,0,5], [42,1,3]]);                                                                           // 1855
  testKeys({'a.x': 1, b: -1, 'a.y': 1},                                                                     // 1856
           {a: [{x: 0, y: 5}, {x: 1, y: 3}], b: 42},                                                        // 1857
           [[0,42,5], [1,42,3]]);                                                                           // 1858
  testKeys({a: 1, b: 1},                                                                                    // 1859
           {a: [1, 2, 3], b: 42},                                                                           // 1860
           [[1,42], [2,42], [3,42]]);                                                                       // 1861
                                                                                                            // 1862
  // Don't support multiple arrays at the same level.                                                       // 1863
  testParallelError({a: 1, b: 1},                                                                           // 1864
                    {a: [1, 2, 3], b: [42]});                                                               // 1865
                                                                                                            // 1866
  // We are MORE STRICT than Mongo here; Mongo supports this!                                               // 1867
  // XXX support this too  #NestedArraySort                                                                 // 1868
  testParallelError({'a.x': 1, 'a.y': 1},                                                                   // 1869
                    {a: [{x: 1, y: [2, 3]},                                                                 // 1870
                         {x: 2, y: [4, 5]}]});                                                              // 1871
});                                                                                                         // 1872
                                                                                                            // 1873
Tinytest.add("minimongo - sort key filter", function (test) {                                               // 1874
  var testOrder = function (sortSpec, selector, doc1, doc2) {                                               // 1875
    var matcher = new Minimongo.Matcher(selector);                                                          // 1876
    var sorter = new Minimongo.Sorter(sortSpec, {matcher: matcher});                                        // 1877
    var comparator = sorter.getComparator();                                                                // 1878
    var comparison = comparator(doc1, doc2);                                                                // 1879
    test.isTrue(comparison < 0);                                                                            // 1880
  };                                                                                                        // 1881
                                                                                                            // 1882
  testOrder({'a.x': 1}, {'a.x': {$gt: 1}},                                                                  // 1883
            {a: {x: 3}},                                                                                    // 1884
            {a: {x: [1, 4]}});                                                                              // 1885
  testOrder({'a.x': 1}, {'a.x': {$gt: 0}},                                                                  // 1886
            {a: {x: [1, 4]}},                                                                               // 1887
            {a: {x: 3}});                                                                                   // 1888
                                                                                                            // 1889
  var keyCompatible = function (sortSpec, selector, key, compatible) {                                      // 1890
    var matcher = new Minimongo.Matcher(selector);                                                          // 1891
    var sorter = new Minimongo.Sorter(sortSpec, {matcher: matcher});                                        // 1892
    var actual = sorter._keyCompatibleWithSelector(key);                                                    // 1893
    test.equal(actual, compatible);                                                                         // 1894
  };                                                                                                        // 1895
                                                                                                            // 1896
  keyCompatible({a: 1}, {a: 5}, [5], true);                                                                 // 1897
  keyCompatible({a: 1}, {a: 5}, [8], false);                                                                // 1898
  keyCompatible({a: 1}, {a: {x: 5}}, [{x: 5}], true);                                                       // 1899
  keyCompatible({a: 1}, {a: {x: 5}}, [{x: 5, y: 9}], false);                                                // 1900
  keyCompatible({'a.x': 1}, {a: {x: 5}}, [5], true);                                                        // 1901
  // To confirm this:                                                                                       // 1902
  //   > db.x.insert({_id: "q", a: [{x:1}, {x:5}], b: 2})                                                   // 1903
  //   > db.x.insert({_id: "w", a: [{x:5}, {x:10}], b: 1})                                                  // 1904
  //   > db.x.find({}).sort({'a.x': 1, b: 1})                                                               // 1905
  //   { "_id" : "q", "a" : [  {  "x" : 1 },  {  "x" : 5 } ], "b" : 2 }                                     // 1906
  //   { "_id" : "w", "a" : [  {  "x" : 5 },  {  "x" : 10 } ], "b" : 1 }                                    // 1907
  //   > db.x.find({a: {x:5}}).sort({'a.x': 1, b: 1})                                                       // 1908
  //   { "_id" : "q", "a" : [  {  "x" : 1 },  {  "x" : 5 } ], "b" : 2 }                                     // 1909
  //   { "_id" : "w", "a" : [  {  "x" : 5 },  {  "x" : 10 } ], "b" : 1 }                                    // 1910
  //   > db.x.find({'a.x': 5}).sort({'a.x': 1, b: 1})                                                       // 1911
  //   { "_id" : "w", "a" : [  {  "x" : 5 },  {  "x" : 10 } ], "b" : 1 }                                    // 1912
  //   { "_id" : "q", "a" : [  {  "x" : 1 },  {  "x" : 5 } ], "b" : 2 }                                     // 1913
  // ie, only the last one manages to trigger the key compatibility code,                                   // 1914
  // not the previous one.  (The "b" sort is necessary because when the key                                 // 1915
  // compatibility code *does* kick in, both documents only end up with "5"                                 // 1916
  // for the first field as their only sort key, and we need to differentiate                               // 1917
  // somehow...)                                                                                            // 1918
  keyCompatible({'a.x': 1}, {a: {x: 5}}, [1], true);                                                        // 1919
  keyCompatible({'a.x': 1}, {'a.x': 5}, [5], true);                                                         // 1920
  keyCompatible({'a.x': 1}, {'a.x': 5}, [1], false);                                                        // 1921
                                                                                                            // 1922
  // Regex key check.                                                                                       // 1923
  keyCompatible({a: 1}, {a: /^foo+/}, ['foo'], true);                                                       // 1924
  keyCompatible({a: 1}, {a: /^foo+/}, ['foooo'], true);                                                     // 1925
  keyCompatible({a: 1}, {a: /^foo+/}, ['foooobar'], true);                                                  // 1926
  keyCompatible({a: 1}, {a: /^foo+/}, ['afoooo'], false);                                                   // 1927
  keyCompatible({a: 1}, {a: /^foo+/}, [''], false);                                                         // 1928
  keyCompatible({a: 1}, {a: {$regex: "^foo+"}}, ['foo'], true);                                             // 1929
  keyCompatible({a: 1}, {a: {$regex: "^foo+"}}, ['foooo'], true);                                           // 1930
  keyCompatible({a: 1}, {a: {$regex: "^foo+"}}, ['foooobar'], true);                                        // 1931
  keyCompatible({a: 1}, {a: {$regex: "^foo+"}}, ['afoooo'], false);                                         // 1932
  keyCompatible({a: 1}, {a: {$regex: "^foo+"}}, [''], false);                                               // 1933
                                                                                                            // 1934
  keyCompatible({a: 1}, {a: /^foo+/i}, ['foo'], true);                                                      // 1935
  // Key compatibility check appears to be turned off for regexps with flags.                               // 1936
  keyCompatible({a: 1}, {a: /^foo+/i}, ['bar'], true);                                                      // 1937
  keyCompatible({a: 1}, {a: /^foo+/m}, ['bar'], true);                                                      // 1938
  keyCompatible({a: 1}, {a: {$regex: "^foo+", $options: "i"}}, ['bar'], true);                              // 1939
  keyCompatible({a: 1}, {a: {$regex: "^foo+", $options: "m"}}, ['bar'], true);                              // 1940
                                                                                                            // 1941
  // Multiple keys!                                                                                         // 1942
  keyCompatible({a: 1, b: 1, c: 1},                                                                         // 1943
                {a: {$gt: 5}, c: {$lt: 3}}, [6, "bla", 2], true);                                           // 1944
  keyCompatible({a: 1, b: 1, c: 1},                                                                         // 1945
                {a: {$gt: 5}, c: {$lt: 3}}, [6, "bla", 4], false);                                          // 1946
  keyCompatible({a: 1, b: 1, c: 1},                                                                         // 1947
                {a: {$gt: 5}, c: {$lt: 3}}, [3, "bla", 1], false);                                          // 1948
  // No filtering is done (ie, all keys are compatible) if the first key isn't                              // 1949
  // constrained.                                                                                           // 1950
  keyCompatible({a: 1, b: 1, c: 1},                                                                         // 1951
                {c: {$lt: 3}}, [3, "bla", 4], true);                                                        // 1952
});                                                                                                         // 1953
                                                                                                            // 1954
Tinytest.add("minimongo - binary search", function (test) {                                                 // 1955
  var forwardCmp = function (a, b) {                                                                        // 1956
    return a - b;                                                                                           // 1957
  };                                                                                                        // 1958
                                                                                                            // 1959
  var backwardCmp = function (a, b) {                                                                       // 1960
    return -1 * forwardCmp(a, b);                                                                           // 1961
  };                                                                                                        // 1962
                                                                                                            // 1963
  var checkSearch = function (cmp, array, value, expected, message) {                                       // 1964
    var actual = LocalCollection._binarySearch(cmp, array, value);                                          // 1965
    if (expected != actual) {                                                                               // 1966
      test.fail({type: "minimongo-binary-search",                                                           // 1967
                 message: message + " : Expected index " + expected +                                       // 1968
                 " but had " + actual                                                                       // 1969
      });                                                                                                   // 1970
    }                                                                                                       // 1971
  };                                                                                                        // 1972
                                                                                                            // 1973
  var checkSearchForward = function (array, value, expected, message) {                                     // 1974
    checkSearch(forwardCmp, array, value, expected, message);                                               // 1975
  };                                                                                                        // 1976
  var checkSearchBackward = function (array, value, expected, message) {                                    // 1977
    checkSearch(backwardCmp, array, value, expected, message);                                              // 1978
  };                                                                                                        // 1979
                                                                                                            // 1980
  checkSearchForward([1, 2, 5, 7], 4, 2, "Inner insert");                                                   // 1981
  checkSearchForward([1, 2, 3, 4], 3, 3, "Inner insert, equal value");                                      // 1982
  checkSearchForward([1, 2, 5], 4, 2, "Inner insert, odd length");                                          // 1983
  checkSearchForward([1, 3, 5, 6], 9, 4, "End insert");                                                     // 1984
  checkSearchForward([1, 3, 5, 6], 0, 0, "Beginning insert");                                               // 1985
  checkSearchForward([1], 0, 0, "Single array, less than.");                                                // 1986
  checkSearchForward([1], 1, 1, "Single array, equal.");                                                    // 1987
  checkSearchForward([1], 2, 1, "Single array, greater than.");                                             // 1988
  checkSearchForward([], 1, 0, "Empty array");                                                              // 1989
  checkSearchForward([1, 1, 1, 2, 2, 2, 2], 1, 3, "Highly degenerate array, lower");                        // 1990
  checkSearchForward([1, 1, 1, 2, 2, 2, 2], 2, 7, "Highly degenerate array, upper");                        // 1991
  checkSearchForward([2, 2, 2, 2, 2, 2, 2], 1, 0, "Highly degenerate array, lower");                        // 1992
  checkSearchForward([2, 2, 2, 2, 2, 2, 2], 2, 7, "Highly degenerate array, equal");                        // 1993
  checkSearchForward([2, 2, 2, 2, 2, 2, 2], 3, 7, "Highly degenerate array, upper");                        // 1994
                                                                                                            // 1995
  checkSearchBackward([7, 5, 2, 1], 4, 2, "Backward: Inner insert");                                        // 1996
  checkSearchBackward([4, 3, 2, 1], 3, 2, "Backward: Inner insert, equal value");                           // 1997
  checkSearchBackward([5, 2, 1], 4, 1, "Backward: Inner insert, odd length");                               // 1998
  checkSearchBackward([6, 5, 3, 1], 9, 0, "Backward: Beginning insert");                                    // 1999
  checkSearchBackward([6, 5, 3, 1], 0, 4, "Backward: End insert");                                          // 2000
  checkSearchBackward([1], 0, 1, "Backward: Single array, less than.");                                     // 2001
  checkSearchBackward([1], 1, 1, "Backward: Single array, equal.");                                         // 2002
  checkSearchBackward([1], 2, 0, "Backward: Single array, greater than.");                                  // 2003
  checkSearchBackward([], 1, 0, "Backward: Empty array");                                                   // 2004
  checkSearchBackward([2, 2, 2, 2, 1, 1, 1], 1, 7, "Backward: Degenerate array, lower");                    // 2005
  checkSearchBackward([2, 2, 2, 2, 1, 1, 1], 2, 4, "Backward: Degenerate array, upper");                    // 2006
  checkSearchBackward([2, 2, 2, 2, 2, 2, 2], 1, 7, "Backward: Highly degenerate array, upper");             // 2007
  checkSearchBackward([2, 2, 2, 2, 2, 2, 2], 2, 7, "Backward: Highly degenerate array, upper");             // 2008
  checkSearchBackward([2, 2, 2, 2, 2, 2, 2], 3, 0, "Backward: Highly degenerate array, upper");             // 2009
});                                                                                                         // 2010
                                                                                                            // 2011
Tinytest.add("minimongo - modify", function (test) {                                                        // 2012
  var modifyWithQuery = function (doc, query, mod, expected) {                                              // 2013
    var coll = new LocalCollection;                                                                         // 2014
    coll.insert(doc);                                                                                       // 2015
    // The query is relevant for 'a.$.b'.                                                                   // 2016
    coll.update(query, mod);                                                                                // 2017
    var actual = coll.findOne();                                                                            // 2018
    delete actual._id;  // added by insert                                                                  // 2019
    test.equal(actual, expected, EJSON.stringify({input: doc, mod: mod}));                                  // 2020
  };                                                                                                        // 2021
  var modify = function (doc, mod, expected) {                                                              // 2022
    modifyWithQuery(doc, {}, mod, expected);                                                                // 2023
  };                                                                                                        // 2024
  var exceptionWithQuery = function (doc, query, mod) {                                                     // 2025
    var coll = new LocalCollection;                                                                         // 2026
    coll.insert(doc);                                                                                       // 2027
    test.throws(function () {                                                                               // 2028
      coll.update(query, mod);                                                                              // 2029
    });                                                                                                     // 2030
  };                                                                                                        // 2031
  var exception = function (doc, mod) {                                                                     // 2032
    exceptionWithQuery(doc, {}, mod);                                                                       // 2033
  };                                                                                                        // 2034
                                                                                                            // 2035
  // document replacement                                                                                   // 2036
  modify({}, {}, {});                                                                                       // 2037
  modify({a: 12}, {}, {}); // tested against mongodb                                                        // 2038
  modify({a: 12}, {a: 13}, {a:13});                                                                         // 2039
  modify({a: 12, b: 99}, {a: 13}, {a:13});                                                                  // 2040
  exception({a: 12}, {a: 13, $set: {b: 13}});                                                               // 2041
  exception({a: 12}, {$set: {b: 13}, a: 13});                                                               // 2042
                                                                                                            // 2043
  // keys                                                                                                   // 2044
  modify({}, {$set: {'a': 12}}, {a: 12});                                                                   // 2045
  modify({}, {$set: {'a.b': 12}}, {a: {b: 12}});                                                            // 2046
  modify({}, {$set: {'a.b.c': 12}}, {a: {b: {c: 12}}});                                                     // 2047
  modify({a: {d: 99}}, {$set: {'a.b.c': 12}}, {a: {d: 99, b: {c: 12}}});                                    // 2048
  modify({}, {$set: {'a.b.3.c': 12}}, {a: {b: {3: {c: 12}}}});                                              // 2049
  modify({a: {b: []}}, {$set: {'a.b.3.c': 12}}, {                                                           // 2050
    a: {b: [null, null, null, {c: 12}]}});                                                                  // 2051
  exception({a: [null, null, null]}, {$set: {'a.1.b': 12}});                                                // 2052
  exception({a: [null, 1, null]}, {$set: {'a.1.b': 12}});                                                   // 2053
  exception({a: [null, "x", null]}, {$set: {'a.1.b': 12}});                                                 // 2054
  exception({a: [null, [], null]}, {$set: {'a.1.b': 12}});                                                  // 2055
  modify({a: [null, null, null]}, {$set: {'a.3.b': 12}}, {                                                  // 2056
    a: [null, null, null, {b: 12}]});                                                                       // 2057
  exception({a: []}, {$set: {'a.b': 12}});                                                                  // 2058
  exception({a: 12}, {$set: {'a.b': 99}}); // tested on mongo                                               // 2059
  exception({a: 'x'}, {$set: {'a.b': 99}});                                                                 // 2060
  exception({a: true}, {$set: {'a.b': 99}});                                                                // 2061
  exception({a: null}, {$set: {'a.b': 99}});                                                                // 2062
  modify({a: {}}, {$set: {'a.3': 12}}, {a: {'3': 12}});                                                     // 2063
  modify({a: []}, {$set: {'a.3': 12}}, {a: [null, null, null, 12]});                                        // 2064
  modify({}, {$set: {'': 12}}, {'': 12}); // tested on mongo                                                // 2065
  exception({}, {$set: {'.': 12}}); // tested on mongo                                                      // 2066
  modify({}, {$set: {'. ': 12}}, {'': {' ': 12}}); // tested on mongo                                       // 2067
  modify({}, {$inc: {'... ': 12}}, {'': {'': {'': {' ': 12}}}}); // tested                                  // 2068
  modify({}, {$set: {'a..b': 12}}, {a: {'': {b: 12}}});                                                     // 2069
  modify({a: [1,2,3]}, {$set: {'a.01': 99}}, {a: [1, 99, 3]});                                              // 2070
  modify({a: [1,{a: 98},3]}, {$set: {'a.01.b': 99}}, {a: [1,{a:98, b: 99},3]});                             // 2071
  modify({}, {$set: {'2.a.b': 12}}, {'2': {'a': {'b': 12}}}); // tested                                     // 2072
  modify({x: []}, {$set: {'x.2..a': 99}}, {x: [null, null, {'': {a: 99}}]});                                // 2073
  modify({x: [null, null]}, {$set: {'x.2.a': 1}}, {x: [null, null, {a: 1}]});                               // 2074
  exception({x: [null, null]}, {$set: {'x.1.a': 1}});                                                       // 2075
                                                                                                            // 2076
  // a.$.b                                                                                                  // 2077
  modifyWithQuery({a: [{x: 2}, {x: 4}]}, {'a.x': 4}, {$set: {'a.$.z': 9}},                                  // 2078
                  {a: [{x: 2}, {x: 4, z: 9}]});                                                             // 2079
  exception({a: [{x: 2}, {x: 4}]}, {$set: {'a.$.z': 9}});                                                   // 2080
  exceptionWithQuery({a: [{x: 2}, {x: 4}], b: 5}, {b: 5}, {$set: {'a.$.z': 9}});                            // 2081
  // can't have two $                                                                                       // 2082
  exceptionWithQuery({a: [{x: [2]}]}, {'a.x': 2}, {$set: {'a.$.x.$': 9}});                                  // 2083
  modifyWithQuery({a: [5, 6, 7]}, {a: 6}, {$set: {'a.$': 9}}, {a: [5, 9, 7]});                              // 2084
  modifyWithQuery({a: [{b: [{c: 9}, {c: 10}]}, {b: {c: 11}}]}, {'a.b.c': 10},                               // 2085
                  {$unset: {'a.$.b': 1}}, {a: [{}, {b: {c: 11}}]});                                         // 2086
  modifyWithQuery({a: [{b: [{c: 9}, {c: 10}]}, {b: {c: 11}}]}, {'a.b.c': 11},                               // 2087
                  {$unset: {'a.$.b': 1}},                                                                   // 2088
                  {a: [{b: [{c: 9}, {c: 10}]}, {}]});                                                       // 2089
  modifyWithQuery({a: [1]}, {'a.0': 1}, {$set: {'a.$': 5}}, {a: [5]});                                      // 2090
  modifyWithQuery({a: [9]}, {a: {$mod: [2, 1]}}, {$set: {'a.$': 5}}, {a: [5]});                             // 2091
  // Negatives don't set '$'.                                                                               // 2092
  exceptionWithQuery({a: [1]}, {$not: {a: 2}}, {$set: {'a.$': 5}});                                         // 2093
  exceptionWithQuery({a: [1]}, {'a.0': {$ne: 2}}, {$set: {'a.$': 5}});                                      // 2094
  // One $or clause works.                                                                                  // 2095
  modifyWithQuery({a: [{x: 2}, {x: 4}]},                                                                    // 2096
                  {$or: [{'a.x': 4}]}, {$set: {'a.$.z': 9}},                                                // 2097
                  {a: [{x: 2}, {x: 4, z: 9}]});                                                             // 2098
  // More $or clauses throw.                                                                                // 2099
  exceptionWithQuery({a: [{x: 2}, {x: 4}]},                                                                 // 2100
                     {$or: [{'a.x': 4}, {'a.x': 4}]},                                                       // 2101
                     {$set: {'a.$.z': 9}});                                                                 // 2102
  // $and uses the last one.                                                                                // 2103
  modifyWithQuery({a: [{x: 1}, {x: 3}]},                                                                    // 2104
                  {$and: [{'a.x': 1}, {'a.x': 3}]},                                                         // 2105
                  {$set: {'a.$.x': 5}},                                                                     // 2106
                  {a: [{x: 1}, {x: 5}]});                                                                   // 2107
  modifyWithQuery({a: [{x: 1}, {x: 3}]},                                                                    // 2108
                  {$and: [{'a.x': 3}, {'a.x': 1}]},                                                         // 2109
                  {$set: {'a.$.x': 5}},                                                                     // 2110
                  {a: [{x: 5}, {x: 3}]});                                                                   // 2111
  // Same goes for the implicit AND of a document selector.                                                 // 2112
  modifyWithQuery({a: [{x: 1}, {y: 3}]},                                                                    // 2113
                  {'a.x': 1, 'a.y': 3},                                                                     // 2114
                  {$set: {'a.$.z': 5}},                                                                     // 2115
                  {a: [{x: 1}, {y: 3, z: 5}]});                                                             // 2116
  // with $near, make sure it finds the closest one                                                         // 2117
  modifyWithQuery({a: [{b: [1,1]},                                                                          // 2118
                       {b: [ [3,3], [4,4] ]},                                                               // 2119
                       {b: [9,9]}]},                                                                        // 2120
                  {'a.b': {$near: [5, 5]}},                                                                 // 2121
                  {$set: {'a.$.b': 'k'}},                                                                   // 2122
                  {a: [{b: [1,1]}, {b: 'k'}, {b: [9,9]}]});                                                 // 2123
  modifyWithQuery({a: [{x: 1}, {y: 1}, {x: 1, y: 1}]},                                                      // 2124
                  {a: {$elemMatch: {x: 1, y: 1}}},                                                          // 2125
                  {$set: {'a.$.x': 2}},                                                                     // 2126
                  {a: [{x: 1}, {y: 1}, {x: 2, y: 1}]});                                                     // 2127
  modifyWithQuery({a: [{b: [{x: 1}, {y: 1}, {x: 1, y: 1}]}]},                                               // 2128
                  {'a.b': {$elemMatch: {x: 1, y: 1}}},                                                      // 2129
                  {$set: {'a.$.b': 3}},                                                                     // 2130
                  {a: [{b: 3}]});                                                                           // 2131
                                                                                                            // 2132
  // $inc                                                                                                   // 2133
  modify({a: 1, b: 2}, {$inc: {a: 10}}, {a: 11, b: 2});                                                     // 2134
  modify({a: 1, b: 2}, {$inc: {c: 10}}, {a: 1, b: 2, c: 10});                                               // 2135
  exception({a: 1}, {$inc: {a: '10'}});                                                                     // 2136
  exception({a: 1}, {$inc: {a: true}});                                                                     // 2137
  exception({a: 1}, {$inc: {a: [10]}});                                                                     // 2138
  exception({a: '1'}, {$inc: {a: 10}});                                                                     // 2139
  exception({a: [1]}, {$inc: {a: 10}});                                                                     // 2140
  exception({a: {}}, {$inc: {a: 10}});                                                                      // 2141
  exception({a: false}, {$inc: {a: 10}});                                                                   // 2142
  exception({a: null}, {$inc: {a: 10}});                                                                    // 2143
  modify({a: [1, 2]}, {$inc: {'a.1': 10}}, {a: [1, 12]});                                                   // 2144
  modify({a: [1, 2]}, {$inc: {'a.2': 10}}, {a: [1, 2, 10]});                                                // 2145
  modify({a: [1, 2]}, {$inc: {'a.3': 10}}, {a: [1, 2, null, 10]});                                          // 2146
  modify({a: {b: 2}}, {$inc: {'a.b': 10}}, {a: {b: 12}});                                                   // 2147
  modify({a: {b: 2}}, {$inc: {'a.c': 10}}, {a: {b: 2, c: 10}});                                             // 2148
  exception({}, {$inc: {_id: 1}});                                                                          // 2149
                                                                                                            // 2150
  // $set                                                                                                   // 2151
  modify({a: 1, b: 2}, {$set: {a: 10}}, {a: 10, b: 2});                                                     // 2152
  modify({a: 1, b: 2}, {$set: {c: 10}}, {a: 1, b: 2, c: 10});                                               // 2153
  modify({a: 1, b: 2}, {$set: {a: {c: 10}}}, {a: {c: 10}, b: 2});                                           // 2154
  modify({a: [1, 2], b: 2}, {$set: {a: [3, 4]}}, {a: [3, 4], b: 2});                                        // 2155
  modify({a: [1, 2, 3], b: 2}, {$set: {'a.1': [3, 4]}},                                                     // 2156
         {a: [1, [3, 4], 3], b:2});                                                                         // 2157
  modify({a: [1], b: 2}, {$set: {'a.1': 9}}, {a: [1, 9], b: 2});                                            // 2158
  modify({a: [1], b: 2}, {$set: {'a.2': 9}}, {a: [1, null, 9], b: 2});                                      // 2159
  modify({a: {b: 1}}, {$set: {'a.c': 9}}, {a: {b: 1, c: 9}});                                               // 2160
  modify({}, {$set: {'x._id': 4}}, {x: {_id: 4}});                                                          // 2161
  exception({}, {$set: {_id: 4}});                                                                          // 2162
  exception({_id: 4}, {$set: {_id: 4}});  // even not-changing _id is bad                                   // 2163
                                                                                                            // 2164
  // $unset                                                                                                 // 2165
  modify({}, {$unset: {a: 1}}, {});                                                                         // 2166
  modify({a: 1}, {$unset: {a: 1}}, {});                                                                     // 2167
  modify({a: 1, b: 2}, {$unset: {a: 1}}, {b: 2});                                                           // 2168
  modify({a: 1, b: 2}, {$unset: {a: 0}}, {b: 2});                                                           // 2169
  modify({a: 1, b: 2}, {$unset: {a: false}}, {b: 2});                                                       // 2170
  modify({a: 1, b: 2}, {$unset: {a: null}}, {b: 2});                                                        // 2171
  modify({a: 1, b: 2}, {$unset: {a: [1]}}, {b: 2});                                                         // 2172
  modify({a: 1, b: 2}, {$unset: {a: {}}}, {b: 2});                                                          // 2173
  modify({a: {b: 2, c: 3}}, {$unset: {'a.b': 1}}, {a: {c: 3}});                                             // 2174
  modify({a: [1, 2, 3]}, {$unset: {'a.1': 1}}, {a: [1, null, 3]}); // tested                                // 2175
  modify({a: [1, 2, 3]}, {$unset: {'a.2': 1}}, {a: [1, 2, null]}); // tested                                // 2176
  modify({a: [1, 2, 3]}, {$unset: {'a.x': 1}}, {a: [1, 2, 3]}); // tested                                   // 2177
  modify({a: {b: 1}}, {$unset: {'a.b.c.d': 1}}, {a: {b: 1}});                                               // 2178
  modify({a: {b: 1}}, {$unset: {'a.x.c.d': 1}}, {a: {b: 1}});                                               // 2179
  modify({a: {b: {c: 1}}}, {$unset: {'a.b.c': 1}}, {a: {b: {}}});                                           // 2180
  exception({}, {$unset: {_id: 1}});                                                                        // 2181
                                                                                                            // 2182
  // $push                                                                                                  // 2183
  modify({}, {$push: {a: 1}}, {a: [1]});                                                                    // 2184
  modify({a: []}, {$push: {a: 1}}, {a: [1]});                                                               // 2185
  modify({a: [1]}, {$push: {a: 2}}, {a: [1, 2]});                                                           // 2186
  exception({a: true}, {$push: {a: 1}});                                                                    // 2187
  modify({a: [1]}, {$push: {a: [2]}}, {a: [1, [2]]});                                                       // 2188
  modify({a: []}, {$push: {'a.1': 99}}, {a: [null, [99]]}); // tested                                       // 2189
  modify({a: {}}, {$push: {'a.x': 99}}, {a: {x: [99]}});                                                    // 2190
  modify({}, {$push: {a: {$each: [1, 2, 3]}}},                                                              // 2191
         {a: [1, 2, 3]});                                                                                   // 2192
  modify({a: []}, {$push: {a: {$each: [1, 2, 3]}}},                                                         // 2193
         {a: [1, 2, 3]});                                                                                   // 2194
  modify({a: [true]}, {$push: {a: {$each: [1, 2, 3]}}},                                                     // 2195
         {a: [true, 1, 2, 3]});                                                                             // 2196
  // No positive numbers for $slice                                                                         // 2197
  exception({}, {$push: {a: {$each: [], $slice: 5}}});                                                      // 2198
  modify({a: [true]}, {$push: {a: {$each: [1, 2, 3], $slice: -2}}},                                         // 2199
         {a: [2, 3]});                                                                                      // 2200
  modify({a: [false, true]}, {$push: {a: {$each: [1], $slice: -2}}},                                        // 2201
         {a: [true, 1]});                                                                                   // 2202
  modify(                                                                                                   // 2203
    {a: [{x: 3}, {x: 1}]},                                                                                  // 2204
    {$push: {a: {                                                                                           // 2205
      $each: [{x: 4}, {x: 2}],                                                                              // 2206
      $slice: -2,                                                                                           // 2207
      $sort: {x: 1}                                                                                         // 2208
    }}},                                                                                                    // 2209
    {a: [{x: 3}, {x: 4}]});                                                                                 // 2210
  modify({}, {$push: {a: {$each: [1, 2, 3], $slice: 0}}}, {a: []});                                         // 2211
  modify({a: [1, 2]}, {$push: {a: {$each: [1, 2, 3], $slice: 0}}}, {a: []});                                // 2212
                                                                                                            // 2213
  // $pushAll                                                                                               // 2214
  modify({}, {$pushAll: {a: [1]}}, {a: [1]});                                                               // 2215
  modify({a: []}, {$pushAll: {a: [1]}}, {a: [1]});                                                          // 2216
  modify({a: [1]}, {$pushAll: {a: [2]}}, {a: [1, 2]});                                                      // 2217
  modify({}, {$pushAll: {a: [1, 2]}}, {a: [1, 2]});                                                         // 2218
  modify({a: []}, {$pushAll: {a: [1, 2]}}, {a: [1, 2]});                                                    // 2219
  modify({a: [1]}, {$pushAll: {a: [2, 3]}}, {a: [1, 2, 3]});                                                // 2220
  modify({}, {$pushAll: {a: []}}, {a: []});                                                                 // 2221
  modify({a: []}, {$pushAll: {a: []}}, {a: []});                                                            // 2222
  modify({a: [1]}, {$pushAll: {a: []}}, {a: [1]});                                                          // 2223
  exception({a: true}, {$pushAll: {a: [1]}});                                                               // 2224
  exception({a: []}, {$pushAll: {a: 1}});                                                                   // 2225
  modify({a: []}, {$pushAll: {'a.1': [99]}}, {a: [null, [99]]});                                            // 2226
  modify({a: []}, {$pushAll: {'a.1': []}}, {a: [null, []]});                                                // 2227
  modify({a: {}}, {$pushAll: {'a.x': [99]}}, {a: {x: [99]}});                                               // 2228
  modify({a: {}}, {$pushAll: {'a.x': []}}, {a: {x: []}});                                                   // 2229
                                                                                                            // 2230
  // $addToSet                                                                                              // 2231
  modify({}, {$addToSet: {a: 1}}, {a: [1]});                                                                // 2232
  modify({a: []}, {$addToSet: {a: 1}}, {a: [1]});                                                           // 2233
  modify({a: [1]}, {$addToSet: {a: 2}}, {a: [1, 2]});                                                       // 2234
  modify({a: [1, 2]}, {$addToSet: {a: 1}}, {a: [1, 2]});                                                    // 2235
  modify({a: [1, 2]}, {$addToSet: {a: 2}}, {a: [1, 2]});                                                    // 2236
  modify({a: [1, 2]}, {$addToSet: {a: 3}}, {a: [1, 2, 3]});                                                 // 2237
  exception({a: true}, {$addToSet: {a: 1}});                                                                // 2238
  modify({a: [1]}, {$addToSet: {a: [2]}}, {a: [1, [2]]});                                                   // 2239
  modify({}, {$addToSet: {a: {x: 1}}}, {a: [{x: 1}]});                                                      // 2240
  modify({a: [{x: 1}]}, {$addToSet: {a: {x: 1}}}, {a: [{x: 1}]});                                           // 2241
  modify({a: [{x: 1}]}, {$addToSet: {a: {x: 2}}}, {a: [{x: 1}, {x: 2}]});                                   // 2242
  modify({a: [{x: 1, y: 2}]}, {$addToSet: {a: {x: 1, y: 2}}},                                               // 2243
         {a: [{x: 1, y: 2}]});                                                                              // 2244
  modify({a: [{x: 1, y: 2}]}, {$addToSet: {a: {y: 2, x: 1}}},                                               // 2245
         {a: [{x: 1, y: 2}, {y: 2, x: 1}]});                                                                // 2246
  modify({a: [1, 2]}, {$addToSet: {a: {$each: [3, 1, 4]}}}, {a: [1, 2, 3, 4]});                             // 2247
  modify({a: [1, 2]}, {$addToSet: {a: {$each: [3, 1, 4], b: 12}}},                                          // 2248
         {a: [1, 2, 3, 4]}); // tested                                                                      // 2249
  modify({a: [1, 2]}, {$addToSet: {a: {b: 12, $each: [3, 1, 4]}}},                                          // 2250
         {a: [1, 2, {b: 12, $each: [3, 1, 4]}]}); // tested                                                 // 2251
  modify({a: []}, {$addToSet: {'a.1': 99}}, {a: [null, [99]]});                                             // 2252
  modify({a: {}}, {$addToSet: {'a.x': 99}}, {a: {x: [99]}});                                                // 2253
                                                                                                            // 2254
  // $pop                                                                                                   // 2255
  modify({}, {$pop: {a: 1}}, {}); // tested                                                                 // 2256
  modify({}, {$pop: {a: -1}}, {}); // tested                                                                // 2257
  modify({a: []}, {$pop: {a: 1}}, {a: []});                                                                 // 2258
  modify({a: []}, {$pop: {a: -1}}, {a: []});                                                                // 2259
  modify({a: [1, 2, 3]}, {$pop: {a: 1}}, {a: [1, 2]});                                                      // 2260
  modify({a: [1, 2, 3]}, {$pop: {a: 10}}, {a: [1, 2]});                                                     // 2261
  modify({a: [1, 2, 3]}, {$pop: {a: .001}}, {a: [1, 2]});                                                   // 2262
  modify({a: [1, 2, 3]}, {$pop: {a: 0}}, {a: [1, 2]});                                                      // 2263
  modify({a: [1, 2, 3]}, {$pop: {a: "stuff"}}, {a: [1, 2]});                                                // 2264
  modify({a: [1, 2, 3]}, {$pop: {a: -1}}, {a: [2, 3]});                                                     // 2265
  modify({a: [1, 2, 3]}, {$pop: {a: -10}}, {a: [2, 3]});                                                    // 2266
  modify({a: [1, 2, 3]}, {$pop: {a: -.001}}, {a: [2, 3]});                                                  // 2267
  exception({a: true}, {$pop: {a: 1}});                                                                     // 2268
  exception({a: true}, {$pop: {a: -1}});                                                                    // 2269
  modify({a: []}, {$pop: {'a.1': 1}}, {a: []}); // tested                                                   // 2270
  modify({a: [1, [2, 3], 4]}, {$pop: {'a.1': 1}}, {a: [1, [2], 4]});                                        // 2271
  modify({a: {}}, {$pop: {'a.x': 1}}, {a: {}}); // tested                                                   // 2272
  modify({a: {x: [2, 3]}}, {$pop: {'a.x': 1}}, {a: {x: [2]}});                                              // 2273
                                                                                                            // 2274
  // $pull                                                                                                  // 2275
  modify({}, {$pull: {a: 1}}, {});                                                                          // 2276
  modify({}, {$pull: {'a.x': 1}}, {});                                                                      // 2277
  modify({a: {}}, {$pull: {'a.x': 1}}, {a: {}});                                                            // 2278
  exception({a: true}, {$pull: {a: 1}});                                                                    // 2279
  modify({a: [2, 1, 2]}, {$pull: {a: 1}}, {a: [2, 2]});                                                     // 2280
  modify({a: [2, 1, 2]}, {$pull: {a: 2}}, {a: [1]});                                                        // 2281
  modify({a: [2, 1, 2]}, {$pull: {a: 3}}, {a: [2, 1, 2]});                                                  // 2282
  modify({a: []}, {$pull: {a: 3}}, {a: []});                                                                // 2283
  modify({a: [[2], [2, 1], [3]]}, {$pull: {a: [2, 1]}},                                                     // 2284
         {a: [[2], [3]]}); // tested                                                                        // 2285
  modify({a: [{b: 1, c: 2}, {b: 2, c: 2}]}, {$pull: {a: {b: 1}}},                                           // 2286
         {a: [{b: 2, c: 2}]});                                                                              // 2287
  modify({a: [{b: 1, c: 2}, {b: 2, c: 2}]}, {$pull: {a: {c: 2}}},                                           // 2288
         {a: []});                                                                                          // 2289
  // XXX implement this functionality!                                                                      // 2290
  // probably same refactoring as $elemMatch?                                                               // 2291
  // modify({a: [1, 2, 3, 4]}, {$pull: {$gt: 2}}, {a: [1,2]}); fails!                                       // 2292
                                                                                                            // 2293
  // $pullAll                                                                                               // 2294
  modify({}, {$pullAll: {a: [1]}}, {});                                                                     // 2295
  modify({a: [1, 2, 3]}, {$pullAll: {a: []}}, {a: [1, 2, 3]});                                              // 2296
  modify({a: [1, 2, 3]}, {$pullAll: {a: [2]}}, {a: [1, 3]});                                                // 2297
  modify({a: [1, 2, 3]}, {$pullAll: {a: [2, 1]}}, {a: [3]});                                                // 2298
  modify({a: [1, 2, 3]}, {$pullAll: {a: [1, 2]}}, {a: [3]});                                                // 2299
  modify({}, {$pullAll: {'a.b.c': [2]}}, {});                                                               // 2300
  exception({a: true}, {$pullAll: {a: [1]}});                                                               // 2301
  exception({a: [1, 2, 3]}, {$pullAll: {a: 1}});                                                            // 2302
  modify({x: [{a: 1}, {a: 1, b: 2}]}, {$pullAll: {x: [{a: 1}]}},                                            // 2303
         {x: [{a: 1, b: 2}]});                                                                              // 2304
                                                                                                            // 2305
  // $rename                                                                                                // 2306
  modify({}, {$rename: {a: 'b'}}, {});                                                                      // 2307
  modify({a: [12]}, {$rename: {a: 'b'}}, {b: [12]});                                                        // 2308
  modify({a: {b: 12}}, {$rename: {a: 'c'}}, {c: {b: 12}});                                                  // 2309
  modify({a: {b: 12}}, {$rename: {'a.b': 'a.c'}}, {a: {c: 12}});                                            // 2310
  modify({a: {b: 12}}, {$rename: {'a.b': 'x'}}, {a: {}, x: 12}); // tested                                  // 2311
  modify({a: {b: 12}}, {$rename: {'a.b': 'q.r'}}, {a: {}, q: {r: 12}});                                     // 2312
  modify({a: {b: 12}}, {$rename: {'a.b': 'q.2.r'}}, {a: {}, q: {2: {r: 12}}});                              // 2313
  modify({a: {b: 12}, q: {}}, {$rename: {'a.b': 'q.2.r'}},                                                  // 2314
         {a: {}, q: {2: {r: 12}}});                                                                         // 2315
  exception({a: {b: 12}, q: []}, {$rename: {'a.b': 'q.2'}}); // tested                                      // 2316
  exception({a: {b: 12}, q: []}, {$rename: {'a.b': 'q.2.r'}}); // tested                                    // 2317
  // These strange MongoDB behaviors throw.                                                                 // 2318
  // modify({a: {b: 12}, q: []}, {$rename: {'q.1': 'x'}},                                                   // 2319
  //        {a: {b: 12}, x: []}); // tested                                                                 // 2320
  // modify({a: {b: 12}, q: []}, {$rename: {'q.1.j': 'x'}},                                                 // 2321
  //        {a: {b: 12}, x: []}); // tested                                                                 // 2322
  exception({}, {$rename: {'a': 'a'}});                                                                     // 2323
  exception({}, {$rename: {'a.b': 'a.b'}});                                                                 // 2324
  modify({a: 12, b: 13}, {$rename: {a: 'b'}}, {b: 12});                                                     // 2325
                                                                                                            // 2326
  // $bit                                                                                                   // 2327
  // unimplemented                                                                                          // 2328
                                                                                                            // 2329
  // XXX test case sensitivity of modops                                                                    // 2330
  // XXX for each (most) modop, test that it performs a deep copy                                           // 2331
});                                                                                                         // 2332
                                                                                                            // 2333
// XXX test update() (selecting docs, multi, upsert..)                                                      // 2334
                                                                                                            // 2335
Tinytest.add("minimongo - observe ordered", function (test) {                                               // 2336
  var operations = [];                                                                                      // 2337
  var cbs = log_callbacks(operations);                                                                      // 2338
  var handle;                                                                                               // 2339
                                                                                                            // 2340
  var c = new LocalCollection();                                                                            // 2341
  handle = c.find({}, {sort: {a: 1}}).observe(cbs);                                                         // 2342
  test.isTrue(handle.collection === c);                                                                     // 2343
                                                                                                            // 2344
  c.insert({_id: 'foo', a:1});                                                                              // 2345
  test.equal(operations.shift(), ['added', {a:1}, 0, null]);                                                // 2346
  c.update({a:1}, {$set: {a: 2}});                                                                          // 2347
  test.equal(operations.shift(), ['changed', {a:2}, 0, {a:1}]);                                             // 2348
  c.insert({a:10});                                                                                         // 2349
  test.equal(operations.shift(), ['added', {a:10}, 1, null]);                                               // 2350
  c.update({}, {$inc: {a: 1}}, {multi: true});                                                              // 2351
  test.equal(operations.shift(), ['changed', {a:3}, 0, {a:2}]);                                             // 2352
  test.equal(operations.shift(), ['changed', {a:11}, 1, {a:10}]);                                           // 2353
  c.update({a:11}, {a:1});                                                                                  // 2354
  test.equal(operations.shift(), ['changed', {a:1}, 1, {a:11}]);                                            // 2355
  test.equal(operations.shift(), ['moved', {a:1}, 1, 0, 'foo']);                                            // 2356
  c.remove({a:2});                                                                                          // 2357
  test.equal(operations.shift(), undefined);                                                                // 2358
  c.remove({a:3});                                                                                          // 2359
  test.equal(operations.shift(), ['removed', 'foo', 1, {a:3}]);                                             // 2360
                                                                                                            // 2361
  // test stop                                                                                              // 2362
  handle.stop();                                                                                            // 2363
  var idA2 = Random.id();                                                                                   // 2364
  c.insert({_id: idA2, a:2});                                                                               // 2365
  test.equal(operations.shift(), undefined);                                                                // 2366
                                                                                                            // 2367
  // test initial inserts (and backwards sort)                                                              // 2368
  handle = c.find({}, {sort: {a: -1}}).observe(cbs);                                                        // 2369
  test.equal(operations.shift(), ['added', {a:2}, 0, null]);                                                // 2370
  test.equal(operations.shift(), ['added', {a:1}, 1, null]);                                                // 2371
  handle.stop();                                                                                            // 2372
                                                                                                            // 2373
  // test _suppress_initial                                                                                 // 2374
  handle = c.find({}, {sort: {a: -1}}).observe(_.extend({                                                   // 2375
    _suppress_initial: true}, cbs));                                                                        // 2376
  test.equal(operations.shift(), undefined);                                                                // 2377
  c.insert({a:100});                                                                                        // 2378
  test.equal(operations.shift(), ['added', {a:100}, 0, idA2]);                                              // 2379
  handle.stop();                                                                                            // 2380
                                                                                                            // 2381
  // test skip and limit.                                                                                   // 2382
  c.remove({});                                                                                             // 2383
  handle = c.find({}, {sort: {a: 1}, skip: 1, limit: 2}).observe(cbs);                                      // 2384
  test.equal(operations.shift(), undefined);                                                                // 2385
  c.insert({a:1});                                                                                          // 2386
  test.equal(operations.shift(), undefined);                                                                // 2387
  c.insert({_id: 'foo', a:2});                                                                              // 2388
  test.equal(operations.shift(), ['added', {a:2}, 0, null]);                                                // 2389
  c.insert({a:3});                                                                                          // 2390
  test.equal(operations.shift(), ['added', {a:3}, 1, null]);                                                // 2391
  c.insert({a:4});                                                                                          // 2392
  test.equal(operations.shift(), undefined);                                                                // 2393
  c.update({a:1}, {a:0});                                                                                   // 2394
  test.equal(operations.shift(), undefined);                                                                // 2395
  c.update({a:0}, {a:5});                                                                                   // 2396
  test.equal(operations.shift(), ['removed', 'foo', 0, {a:2}]);                                             // 2397
  test.equal(operations.shift(), ['added', {a:4}, 1, null]);                                                // 2398
  c.update({a:3}, {a:3.5});                                                                                 // 2399
  test.equal(operations.shift(), ['changed', {a:3.5}, 0, {a:3}]);                                           // 2400
  handle.stop();                                                                                            // 2401
                                                                                                            // 2402
  // test observe limit with pre-existing docs                                                              // 2403
  c.remove({});                                                                                             // 2404
  c.insert({a: 1});                                                                                         // 2405
  c.insert({_id: 'two', a: 2});                                                                             // 2406
  c.insert({a: 3});                                                                                         // 2407
  handle = c.find({}, {sort: {a: 1}, limit: 2}).observe(cbs);                                               // 2408
  test.equal(operations.shift(), ['added', {a:1}, 0, null]);                                                // 2409
  test.equal(operations.shift(), ['added', {a:2}, 1, null]);                                                // 2410
  test.equal(operations.shift(), undefined);                                                                // 2411
  c.remove({a: 2});                                                                                         // 2412
  test.equal(operations.shift(), ['removed', 'two', 1, {a:2}]);                                             // 2413
  test.equal(operations.shift(), ['added', {a:3}, 1, null]);                                                // 2414
  test.equal(operations.shift(), undefined);                                                                // 2415
  handle.stop();                                                                                            // 2416
                                                                                                            // 2417
  // test _no_indices                                                                                       // 2418
                                                                                                            // 2419
  c.remove({});                                                                                             // 2420
  handle = c.find({}, {sort: {a: 1}}).observe(_.extend(cbs, {_no_indices: true}));                          // 2421
  c.insert({_id: 'foo', a:1});                                                                              // 2422
  test.equal(operations.shift(), ['added', {a:1}, -1, null]);                                               // 2423
  c.update({a:1}, {$set: {a: 2}});                                                                          // 2424
  test.equal(operations.shift(), ['changed', {a:2}, -1, {a:1}]);                                            // 2425
  c.insert({a:10});                                                                                         // 2426
  test.equal(operations.shift(), ['added', {a:10}, -1, null]);                                              // 2427
  c.update({}, {$inc: {a: 1}}, {multi: true});                                                              // 2428
  test.equal(operations.shift(), ['changed', {a:3}, -1, {a:2}]);                                            // 2429
  test.equal(operations.shift(), ['changed', {a:11}, -1, {a:10}]);                                          // 2430
  c.update({a:11}, {a:1});                                                                                  // 2431
  test.equal(operations.shift(), ['changed', {a:1}, -1, {a:11}]);                                           // 2432
  test.equal(operations.shift(), ['moved', {a:1}, -1, -1, 'foo']);                                          // 2433
  c.remove({a:2});                                                                                          // 2434
  test.equal(operations.shift(), undefined);                                                                // 2435
  c.remove({a:3});                                                                                          // 2436
  test.equal(operations.shift(), ['removed', 'foo', -1, {a:3}]);                                            // 2437
  handle.stop();                                                                                            // 2438
});                                                                                                         // 2439
                                                                                                            // 2440
_.each([true, false], function (ordered) {                                                                  // 2441
  Tinytest.add("minimongo - observe ordered: " + ordered, function (test) {                                 // 2442
    var c = new LocalCollection();                                                                          // 2443
                                                                                                            // 2444
    var ev = "";                                                                                            // 2445
    var makecb = function (tag) {                                                                           // 2446
      var ret = {};                                                                                         // 2447
      _.each(["added", "changed", "removed"], function (fn) {                                               // 2448
        var fnName = ordered ? fn + "At" : fn;                                                              // 2449
        ret[fnName] = function (doc) {                                                                      // 2450
          ev = (ev + fn.substr(0, 1) + tag + doc._id + "_");                                                // 2451
        };                                                                                                  // 2452
      });                                                                                                   // 2453
      return ret;                                                                                           // 2454
    };                                                                                                      // 2455
    var expect = function (x) {                                                                             // 2456
      test.equal(ev, x);                                                                                    // 2457
      ev = "";                                                                                              // 2458
    };                                                                                                      // 2459
                                                                                                            // 2460
    c.insert({_id: 1, name: "strawberry", tags: ["fruit", "red", "squishy"]});                              // 2461
    c.insert({_id: 2, name: "apple", tags: ["fruit", "red", "hard"]});                                      // 2462
    c.insert({_id: 3, name: "rose", tags: ["flower", "red", "squishy"]});                                   // 2463
                                                                                                            // 2464
    // This should work equally well for ordered and unordered observations                                 // 2465
    // (because the callbacks don't look at indices and there's no 'moved'                                  // 2466
    // callback).                                                                                           // 2467
    var handle = c.find({tags: "flower"}).observe(makecb('a'));                                             // 2468
    expect("aa3_");                                                                                         // 2469
    c.update({name: "rose"}, {$set: {tags: ["bloom", "red", "squishy"]}});                                  // 2470
    expect("ra3_");                                                                                         // 2471
    c.update({name: "rose"}, {$set: {tags: ["flower", "red", "squishy"]}});                                 // 2472
    expect("aa3_");                                                                                         // 2473
    c.update({name: "rose"}, {$set: {food: false}});                                                        // 2474
    expect("ca3_");                                                                                         // 2475
    c.remove({});                                                                                           // 2476
    expect("ra3_");                                                                                         // 2477
    c.insert({_id: 4, name: "daisy", tags: ["flower"]});                                                    // 2478
    expect("aa4_");                                                                                         // 2479
    handle.stop();                                                                                          // 2480
    // After calling stop, no more callbacks are called.                                                    // 2481
    c.insert({_id: 5, name: "iris", tags: ["flower"]});                                                     // 2482
    expect("");                                                                                             // 2483
                                                                                                            // 2484
    // Test that observing a lookup by ID works.                                                            // 2485
    handle = c.find(4).observe(makecb('b'));                                                                // 2486
    expect('ab4_');                                                                                         // 2487
    c.update(4, {$set: {eek: 5}});                                                                          // 2488
    expect('cb4_');                                                                                         // 2489
    handle.stop();                                                                                          // 2490
                                                                                                            // 2491
    // Test observe with reactive: false.                                                                   // 2492
    handle = c.find({tags: "flower"}, {reactive: false}).observe(makecb('c'));                              // 2493
    expect('ac4_ac5_');                                                                                     // 2494
    // This insert shouldn't trigger a callback because it's not reactive.                                  // 2495
    c.insert({_id: 6, name: "river", tags: ["flower"]});                                                    // 2496
    expect('');                                                                                             // 2497
    handle.stop();                                                                                          // 2498
  });                                                                                                       // 2499
});                                                                                                         // 2500
                                                                                                            // 2501
                                                                                                            // 2502
Tinytest.add("minimongo - diff changes ordering", function (test) {                                         // 2503
  var makeDocs = function (ids) {                                                                           // 2504
    return _.map(ids, function (id) { return {_id: id};});                                                  // 2505
  };                                                                                                        // 2506
  var testMutation = function (a, b) {                                                                      // 2507
    var aa = makeDocs(a);                                                                                   // 2508
    var bb = makeDocs(b);                                                                                   // 2509
    var aaCopy = EJSON.clone(aa);                                                                           // 2510
    LocalCollection._diffQueryOrderedChanges(aa, bb, {                                                      // 2511
                                                                                                            // 2512
      addedBefore: function (id, doc, before) {                                                             // 2513
        if (before === null) {                                                                              // 2514
          aaCopy.push( _.extend({_id: id}, doc));                                                           // 2515
          return;                                                                                           // 2516
        }                                                                                                   // 2517
        for (var i = 0; i < aaCopy.length; i++) {                                                           // 2518
          if (aaCopy[i]._id === before) {                                                                   // 2519
            aaCopy.splice(i, 0, _.extend({_id: id}, doc));                                                  // 2520
            return;                                                                                         // 2521
          }                                                                                                 // 2522
        }                                                                                                   // 2523
      },                                                                                                    // 2524
      movedBefore: function (id, before) {                                                                  // 2525
        var found;                                                                                          // 2526
        for (var i = 0; i < aaCopy.length; i++) {                                                           // 2527
          if (aaCopy[i]._id === id) {                                                                       // 2528
            found = aaCopy[i];                                                                              // 2529
            aaCopy.splice(i, 1);                                                                            // 2530
          }                                                                                                 // 2531
        }                                                                                                   // 2532
        if (before === null) {                                                                              // 2533
          aaCopy.push( _.extend({_id: id}, found));                                                         // 2534
          return;                                                                                           // 2535
        }                                                                                                   // 2536
        for (i = 0; i < aaCopy.length; i++) {                                                               // 2537
          if (aaCopy[i]._id === before) {                                                                   // 2538
            aaCopy.splice(i, 0, _.extend({_id: id}, found));                                                // 2539
            return;                                                                                         // 2540
          }                                                                                                 // 2541
        }                                                                                                   // 2542
      },                                                                                                    // 2543
      removed: function (id) {                                                                              // 2544
        var found;                                                                                          // 2545
        for (var i = 0; i < aaCopy.length; i++) {                                                           // 2546
          if (aaCopy[i]._id === id) {                                                                       // 2547
            found = aaCopy[i];                                                                              // 2548
            aaCopy.splice(i, 1);                                                                            // 2549
          }                                                                                                 // 2550
        }                                                                                                   // 2551
      }                                                                                                     // 2552
    });                                                                                                     // 2553
    test.equal(aaCopy, bb);                                                                                 // 2554
  };                                                                                                        // 2555
                                                                                                            // 2556
  var testBothWays = function (a, b) {                                                                      // 2557
    testMutation(a, b);                                                                                     // 2558
    testMutation(b, a);                                                                                     // 2559
  };                                                                                                        // 2560
                                                                                                            // 2561
  testBothWays(["a", "b", "c"], ["c", "b", "a"]);                                                           // 2562
  testBothWays(["a", "b", "c"], []);                                                                        // 2563
  testBothWays(["a", "b", "c"], ["e","f"]);                                                                 // 2564
  testBothWays(["a", "b", "c", "d"], ["c", "b", "a"]);                                                      // 2565
  testBothWays(['A','B','C','D','E','F','G','H','I'],                                                       // 2566
               ['A','B','F','G','C','D','I','L','M','N','H']);                                              // 2567
  testBothWays(['A','B','C','D','E','F','G','H','I'],['A','B','C','D','F','G','H','E','I']);                // 2568
});                                                                                                         // 2569
                                                                                                            // 2570
Tinytest.add("minimongo - diff", function (test) {                                                          // 2571
                                                                                                            // 2572
  // test correctness                                                                                       // 2573
                                                                                                            // 2574
  var diffTest = function(origLen, newOldIdx) {                                                             // 2575
    var oldResults = new Array(origLen);                                                                    // 2576
    for (var i = 1; i <= origLen; i++)                                                                      // 2577
      oldResults[i-1] = {_id: i};                                                                           // 2578
                                                                                                            // 2579
    var newResults = _.map(newOldIdx, function(n) {                                                         // 2580
      var doc = {_id: Math.abs(n)};                                                                         // 2581
      if (n < 0)                                                                                            // 2582
        doc.changed = true;                                                                                 // 2583
      return doc;                                                                                           // 2584
    });                                                                                                     // 2585
    var find = function (arr, id) {                                                                         // 2586
      for (var i = 0; i < arr.length; i++) {                                                                // 2587
        if (EJSON.equals(arr[i]._id, id))                                                                   // 2588
          return i;                                                                                         // 2589
      }                                                                                                     // 2590
      return -1;                                                                                            // 2591
    };                                                                                                      // 2592
                                                                                                            // 2593
    var results = _.clone(oldResults);                                                                      // 2594
    var observer = {                                                                                        // 2595
      addedBefore: function(id, fields, before) {                                                           // 2596
        var before_idx;                                                                                     // 2597
        if (before === null)                                                                                // 2598
          before_idx = results.length;                                                                      // 2599
        else                                                                                                // 2600
          before_idx = find (results, before);                                                              // 2601
        var doc = _.extend({_id: id}, fields);                                                              // 2602
        test.isFalse(before_idx < 0 || before_idx > results.length);                                        // 2603
        results.splice(before_idx, 0, doc);                                                                 // 2604
      },                                                                                                    // 2605
      removed: function(id) {                                                                               // 2606
        var at_idx = find (results, id);                                                                    // 2607
        test.isFalse(at_idx < 0 || at_idx >= results.length);                                               // 2608
        results.splice(at_idx, 1);                                                                          // 2609
      },                                                                                                    // 2610
      changed: function(id, fields) {                                                                       // 2611
        var at_idx = find (results, id);                                                                    // 2612
        var oldDoc = results[at_idx];                                                                       // 2613
        var doc = EJSON.clone(oldDoc);                                                                      // 2614
        LocalCollection._applyChanges(doc, fields);                                                         // 2615
        test.isFalse(at_idx < 0 || at_idx >= results.length);                                               // 2616
        test.equal(doc._id, oldDoc._id);                                                                    // 2617
        results[at_idx] = doc;                                                                              // 2618
      },                                                                                                    // 2619
      movedBefore: function(id, before) {                                                                   // 2620
        var old_idx = find(results, id);                                                                    // 2621
        var new_idx;                                                                                        // 2622
        if (before === null)                                                                                // 2623
          new_idx = results.length;                                                                         // 2624
        else                                                                                                // 2625
          new_idx = find (results, before);                                                                 // 2626
        if (new_idx > old_idx)                                                                              // 2627
          new_idx--;                                                                                        // 2628
        test.isFalse(old_idx < 0 || old_idx >= results.length);                                             // 2629
        test.isFalse(new_idx < 0 || new_idx >= results.length);                                             // 2630
        results.splice(new_idx, 0, results.splice(old_idx, 1)[0]);                                          // 2631
      }                                                                                                     // 2632
    };                                                                                                      // 2633
                                                                                                            // 2634
    LocalCollection._diffQueryOrderedChanges(oldResults, newResults, observer);                             // 2635
    test.equal(results, newResults);                                                                        // 2636
  };                                                                                                        // 2637
                                                                                                            // 2638
  // edge cases and cases run into during debugging                                                         // 2639
  diffTest(5, [5, 1, 2, 3, 4]);                                                                             // 2640
  diffTest(0, [1, 2, 3, 4]);                                                                                // 2641
  diffTest(4, []);                                                                                          // 2642
  diffTest(7, [4, 5, 6, 7, 1, 2, 3]);                                                                       // 2643
  diffTest(7, [5, 6, 7, 1, 2, 3, 4]);                                                                       // 2644
  diffTest(10, [7, 4, 11, 6, 12, 1, 5]);                                                                    // 2645
  diffTest(3, [3, 2, 1]);                                                                                   // 2646
  diffTest(10, [2, 7, 4, 6, 11, 3, 8, 9]);                                                                  // 2647
  diffTest(0, []);                                                                                          // 2648
  diffTest(1, []);                                                                                          // 2649
  diffTest(0, [1]);                                                                                         // 2650
  diffTest(1, [1]);                                                                                         // 2651
  diffTest(5, [1, 2, 3, 4, 5]);                                                                             // 2652
                                                                                                            // 2653
  // interaction between "changed" and other ops                                                            // 2654
  diffTest(5, [-5, -1, 2, -3, 4]);                                                                          // 2655
  diffTest(7, [-4, -5, 6, 7, -1, 2, 3]);                                                                    // 2656
  diffTest(7, [5, 6, -7, 1, 2, -3, 4]);                                                                     // 2657
  diffTest(10, [7, -4, 11, 6, 12, -1, 5]);                                                                  // 2658
  diffTest(3, [-3, -2, -1]);                                                                                // 2659
  diffTest(10, [-2, 7, 4, 6, 11, -3, -8, 9]);                                                               // 2660
});                                                                                                         // 2661
                                                                                                            // 2662
                                                                                                            // 2663
Tinytest.add("minimongo - saveOriginals", function (test) {                                                 // 2664
  // set up some data                                                                                       // 2665
  var c = new LocalCollection(),                                                                            // 2666
      count;                                                                                                // 2667
  c.insert({_id: 'foo', x: 'untouched'});                                                                   // 2668
  c.insert({_id: 'bar', x: 'updateme'});                                                                    // 2669
  c.insert({_id: 'baz', x: 'updateme'});                                                                    // 2670
  c.insert({_id: 'quux', y: 'removeme'});                                                                   // 2671
  c.insert({_id: 'whoa', y: 'removeme'});                                                                   // 2672
                                                                                                            // 2673
  // Save originals and make some changes.                                                                  // 2674
  c.saveOriginals();                                                                                        // 2675
  c.insert({_id: "hooray", z: 'insertme'});                                                                 // 2676
  c.remove({y: 'removeme'});                                                                                // 2677
  count = c.update({x: 'updateme'}, {$set: {z: 5}}, {multi: true});                                         // 2678
  c.update('bar', {$set: {k: 7}});  // update same doc twice                                                // 2679
                                                                                                            // 2680
  // Verify returned count is correct                                                                       // 2681
  test.equal(count, 2);                                                                                     // 2682
                                                                                                            // 2683
  // Verify the originals.                                                                                  // 2684
  var originals = c.retrieveOriginals();                                                                    // 2685
  var affected = ['bar', 'baz', 'quux', 'whoa', 'hooray'];                                                  // 2686
  test.equal(originals.size(), _.size(affected));                                                           // 2687
  _.each(affected, function (id) {                                                                          // 2688
    test.isTrue(originals.has(id));                                                                         // 2689
  });                                                                                                       // 2690
  test.equal(originals.get('bar'), {_id: 'bar', x: 'updateme'});                                            // 2691
  test.equal(originals.get('baz'), {_id: 'baz', x: 'updateme'});                                            // 2692
  test.equal(originals.get('quux'), {_id: 'quux', y: 'removeme'});                                          // 2693
  test.equal(originals.get('whoa'), {_id: 'whoa', y: 'removeme'});                                          // 2694
  test.equal(originals.get('hooray'), undefined);                                                           // 2695
                                                                                                            // 2696
  // Verify that changes actually occured.                                                                  // 2697
  test.equal(c.find().count(), 4);                                                                          // 2698
  test.equal(c.findOne('foo'), {_id: 'foo', x: 'untouched'});                                               // 2699
  test.equal(c.findOne('bar'), {_id: 'bar', x: 'updateme', z: 5, k: 7});                                    // 2700
  test.equal(c.findOne('baz'), {_id: 'baz', x: 'updateme', z: 5});                                          // 2701
  test.equal(c.findOne('hooray'), {_id: 'hooray', z: 'insertme'});                                          // 2702
                                                                                                            // 2703
  // The next call doesn't get the same originals again.                                                    // 2704
  c.saveOriginals();                                                                                        // 2705
  originals = c.retrieveOriginals();                                                                        // 2706
  test.isTrue(originals);                                                                                   // 2707
  test.isTrue(originals.empty());                                                                           // 2708
                                                                                                            // 2709
  // Insert and remove a document during the period.                                                        // 2710
  c.saveOriginals();                                                                                        // 2711
  c.insert({_id: 'temp', q: 8});                                                                            // 2712
  c.remove('temp');                                                                                         // 2713
  originals = c.retrieveOriginals();                                                                        // 2714
  test.equal(originals.size(), 1);                                                                          // 2715
  test.isTrue(originals.has('temp'));                                                                       // 2716
  test.equal(originals.get('temp'), undefined);                                                             // 2717
});                                                                                                         // 2718
                                                                                                            // 2719
Tinytest.add("minimongo - saveOriginals errors", function (test) {                                          // 2720
  var c = new LocalCollection();                                                                            // 2721
  // Can't call retrieve before save.                                                                       // 2722
  test.throws(function () { c.retrieveOriginals(); });                                                      // 2723
  c.saveOriginals();                                                                                        // 2724
  // Can't call save twice.                                                                                 // 2725
  test.throws(function () { c.saveOriginals(); });                                                          // 2726
});                                                                                                         // 2727
                                                                                                            // 2728
Tinytest.add("minimongo - objectid transformation", function (test) {                                       // 2729
  var testId = function (item) {                                                                            // 2730
    test.equal(item, LocalCollection._idParse(LocalCollection._idStringify(item)));                         // 2731
  };                                                                                                        // 2732
  var randomOid = new LocalCollection._ObjectID();                                                          // 2733
  testId(randomOid);                                                                                        // 2734
  testId("FOO");                                                                                            // 2735
  testId("ffffffffffff");                                                                                   // 2736
  testId("0987654321abcdef09876543");                                                                       // 2737
  testId(new LocalCollection._ObjectID());                                                                  // 2738
  testId("--a string");                                                                                     // 2739
                                                                                                            // 2740
  test.equal("ffffffffffff", LocalCollection._idParse(LocalCollection._idStringify("ffffffffffff")));       // 2741
});                                                                                                         // 2742
                                                                                                            // 2743
                                                                                                            // 2744
Tinytest.add("minimongo - objectid", function (test) {                                                      // 2745
  var randomOid = new LocalCollection._ObjectID();                                                          // 2746
  var anotherRandomOid = new LocalCollection._ObjectID();                                                   // 2747
  test.notEqual(randomOid, anotherRandomOid);                                                               // 2748
  test.throws(function() { new LocalCollection._ObjectID("qqqqqqqqqqqqqqqqqqqqqqqq");});                    // 2749
  test.throws(function() { new LocalCollection._ObjectID("ABCDEF"); });                                     // 2750
  test.equal(randomOid, new LocalCollection._ObjectID(randomOid.valueOf()));                                // 2751
});                                                                                                         // 2752
                                                                                                            // 2753
Tinytest.add("minimongo - pause", function (test) {                                                         // 2754
  var operations = [];                                                                                      // 2755
  var cbs = log_callbacks(operations);                                                                      // 2756
                                                                                                            // 2757
  var c = new LocalCollection();                                                                            // 2758
  var h = c.find({}).observe(cbs);                                                                          // 2759
                                                                                                            // 2760
  // remove and add cancel out.                                                                             // 2761
  c.insert({_id: 1, a: 1});                                                                                 // 2762
  test.equal(operations.shift(), ['added', {a:1}, 0, null]);                                                // 2763
                                                                                                            // 2764
  c.pauseObservers();                                                                                       // 2765
                                                                                                            // 2766
  c.remove({_id: 1});                                                                                       // 2767
  test.length(operations, 0);                                                                               // 2768
  c.insert({_id: 1, a: 1});                                                                                 // 2769
  test.length(operations, 0);                                                                               // 2770
                                                                                                            // 2771
  c.resumeObservers();                                                                                      // 2772
  test.length(operations, 0);                                                                               // 2773
                                                                                                            // 2774
                                                                                                            // 2775
  // two modifications become one                                                                           // 2776
  c.pauseObservers();                                                                                       // 2777
                                                                                                            // 2778
  c.update({_id: 1}, {a: 2});                                                                               // 2779
  c.update({_id: 1}, {a: 3});                                                                               // 2780
                                                                                                            // 2781
  c.resumeObservers();                                                                                      // 2782
  test.equal(operations.shift(), ['changed', {a:3}, 0, {a:1}]);                                             // 2783
  test.length(operations, 0);                                                                               // 2784
                                                                                                            // 2785
  // test special case for remove({})                                                                       // 2786
  c.pauseObservers();                                                                                       // 2787
  test.equal(c.remove({}), 1);                                                                              // 2788
  test.length(operations, 0);                                                                               // 2789
  c.resumeObservers();                                                                                      // 2790
  test.equal(operations.shift(), ['removed', 1, 0, {a:3}]);                                                 // 2791
  test.length(operations, 0);                                                                               // 2792
                                                                                                            // 2793
  h.stop();                                                                                                 // 2794
});                                                                                                         // 2795
                                                                                                            // 2796
Tinytest.add("minimongo - ids matched by selector", function (test) {                                       // 2797
  var check = function (selector, ids) {                                                                    // 2798
    var idsFromSelector = LocalCollection._idsMatchedBySelector(selector);                                  // 2799
    // XXX normalize order, in a way that also works for ObjectIDs?                                         // 2800
    test.equal(idsFromSelector, ids);                                                                       // 2801
  };                                                                                                        // 2802
  check("foo", ["foo"]);                                                                                    // 2803
  check({_id: "foo"}, ["foo"]);                                                                             // 2804
  var oid1 = new LocalCollection._ObjectID();                                                               // 2805
  check(oid1, [oid1]);                                                                                      // 2806
  check({_id: oid1}, [oid1]);                                                                               // 2807
  check({_id: "foo", x: 42}, ["foo"]);                                                                      // 2808
  check({}, null);                                                                                          // 2809
  check({_id: {$in: ["foo", oid1]}}, ["foo", oid1]);                                                        // 2810
  check({_id: {$ne: "foo"}}, null);                                                                         // 2811
  // not actually valid, but works for now...                                                               // 2812
  check({$and: ["foo"]}, ["foo"]);                                                                          // 2813
  check({$and: [{x: 42}, {_id: oid1}]}, [oid1]);                                                            // 2814
  check({$and: [{x: 42}, {_id: {$in: [oid1]}}]}, [oid1]);                                                   // 2815
});                                                                                                         // 2816
                                                                                                            // 2817
Tinytest.add("minimongo - reactive stop", function (test) {                                                 // 2818
  var coll = new LocalCollection();                                                                         // 2819
  coll.insert({_id: 'A'});                                                                                  // 2820
  coll.insert({_id: 'B'});                                                                                  // 2821
  coll.insert({_id: 'C'});                                                                                  // 2822
                                                                                                            // 2823
  var addBefore = function (str, newChar, before) {                                                         // 2824
    var idx = str.indexOf(before);                                                                          // 2825
    if (idx === -1)                                                                                         // 2826
      return str + newChar;                                                                                 // 2827
    return str.slice(0, idx) + newChar + str.slice(idx);                                                    // 2828
  };                                                                                                        // 2829
                                                                                                            // 2830
  var x, y;                                                                                                 // 2831
  var sortOrder = ReactiveVar(1);                                                                           // 2832
                                                                                                            // 2833
  var c = Deps.autorun(function () {                                                                        // 2834
    var q = coll.find({}, {sort: {_id: sortOrder.get()}});                                                  // 2835
    x = "";                                                                                                 // 2836
    q.observe({ addedAt: function (doc, atIndex, before) {                                                  // 2837
      x = addBefore(x, doc._id, before);                                                                    // 2838
    }});                                                                                                    // 2839
    y = "";                                                                                                 // 2840
    q.observeChanges({ addedBefore: function (id, fields, before) {                                         // 2841
      y = addBefore(y, id, before);                                                                         // 2842
    }});                                                                                                    // 2843
  });                                                                                                       // 2844
                                                                                                            // 2845
  test.equal(x, "ABC");                                                                                     // 2846
  test.equal(y, "ABC");                                                                                     // 2847
                                                                                                            // 2848
  sortOrder.set(-1);                                                                                        // 2849
  test.equal(x, "ABC");                                                                                     // 2850
  test.equal(y, "ABC");                                                                                     // 2851
  Deps.flush();                                                                                             // 2852
  test.equal(x, "CBA");                                                                                     // 2853
  test.equal(y, "CBA");                                                                                     // 2854
                                                                                                            // 2855
  coll.insert({_id: 'D'});                                                                                  // 2856
  coll.insert({_id: 'E'});                                                                                  // 2857
  test.equal(x, "EDCBA");                                                                                   // 2858
  test.equal(y, "EDCBA");                                                                                   // 2859
                                                                                                            // 2860
  c.stop();                                                                                                 // 2861
  // stopping kills the observes immediately                                                                // 2862
  coll.insert({_id: 'F'});                                                                                  // 2863
  test.equal(x, "EDCBA");                                                                                   // 2864
  test.equal(y, "EDCBA");                                                                                   // 2865
});                                                                                                         // 2866
                                                                                                            // 2867
Tinytest.add("minimongo - immediate invalidate", function (test) {                                          // 2868
  var coll = new LocalCollection();                                                                         // 2869
  coll.insert({_id: 'A'});                                                                                  // 2870
                                                                                                            // 2871
  // This has two separate findOnes.  findOne() uses skip/limit, which means                                // 2872
  // that its response to an update() call involves a recompute. We used to have                            // 2873
  // a bug where we would first calculate all the calls that need to be                                     // 2874
  // recomputed, then recompute them one by one, without checking to see if the                             // 2875
  // callbacks from recomputing one query stopped the second query, which                                   // 2876
  // crashed.                                                                                               // 2877
  var c = Deps.autorun(function () {                                                                        // 2878
    coll.findOne('A');                                                                                      // 2879
    coll.findOne('A');                                                                                      // 2880
  });                                                                                                       // 2881
                                                                                                            // 2882
  coll.update('A', {$set: {x: 42}});                                                                        // 2883
                                                                                                            // 2884
  c.stop();                                                                                                 // 2885
});                                                                                                         // 2886
                                                                                                            // 2887
                                                                                                            // 2888
Tinytest.add("minimongo - count on cursor with limit", function(test){                                      // 2889
  var coll = new LocalCollection(), count;                                                                  // 2890
                                                                                                            // 2891
  coll.insert({_id: 'A'});                                                                                  // 2892
  coll.insert({_id: 'B'});                                                                                  // 2893
  coll.insert({_id: 'C'});                                                                                  // 2894
  coll.insert({_id: 'D'});                                                                                  // 2895
                                                                                                            // 2896
  var c = Deps.autorun(function (c) {                                                                       // 2897
    var cursor = coll.find({_id: {$exists: true}}, {sort: {_id: 1}, limit: 3});                             // 2898
    count = cursor.count();                                                                                 // 2899
  });                                                                                                       // 2900
                                                                                                            // 2901
  test.equal(count, 3);                                                                                     // 2902
                                                                                                            // 2903
  coll.remove('A'); // still 3 in the collection                                                            // 2904
  Deps.flush();                                                                                             // 2905
  test.equal(count, 3);                                                                                     // 2906
                                                                                                            // 2907
  coll.remove('B'); // expect count now 2                                                                   // 2908
  Deps.flush();                                                                                             // 2909
  test.equal(count, 2);                                                                                     // 2910
                                                                                                            // 2911
                                                                                                            // 2912
  coll.insert({_id: 'A'}); // now 3 again                                                                   // 2913
  Deps.flush();                                                                                             // 2914
  test.equal(count, 3);                                                                                     // 2915
                                                                                                            // 2916
  coll.insert({_id: 'B'}); // now 4 entries, but count should be 3 still                                    // 2917
  Deps.flush();                                                                                             // 2918
  test.equal(count, 3);                                                                                     // 2919
                                                                                                            // 2920
  c.stop();                                                                                                 // 2921
});                                                                                                         // 2922
                                                                                                            // 2923
Tinytest.add("minimongo - reactive count with cached cursor", function (test) {                             // 2924
  var coll = new LocalCollection;                                                                           // 2925
  var cursor = coll.find({});                                                                               // 2926
  var firstAutorunCount, secondAutorunCount;                                                                // 2927
  Deps.autorun(function(){                                                                                  // 2928
    firstAutorunCount = cursor.count();                                                                     // 2929
  });                                                                                                       // 2930
  Deps.autorun(function(){                                                                                  // 2931
    secondAutorunCount = coll.find({}).count();                                                             // 2932
  });                                                                                                       // 2933
  test.equal(firstAutorunCount, 0);                                                                         // 2934
  test.equal(secondAutorunCount, 0);                                                                        // 2935
  coll.insert({i: 1});                                                                                      // 2936
  coll.insert({i: 2});                                                                                      // 2937
  coll.insert({i: 3});                                                                                      // 2938
  Deps.flush();                                                                                             // 2939
  test.equal(firstAutorunCount, 3);                                                                         // 2940
  test.equal(secondAutorunCount, 3);                                                                        // 2941
});                                                                                                         // 2942
                                                                                                            // 2943
Tinytest.add("minimongo - $near operator tests", function (test) {                                          // 2944
  var coll = new LocalCollection();                                                                         // 2945
  coll.insert({ rest: { loc: [2, 3] } });                                                                   // 2946
  coll.insert({ rest: { loc: [-3, 3] } });                                                                  // 2947
  coll.insert({ rest: { loc: [5, 5] } });                                                                   // 2948
                                                                                                            // 2949
  test.equal(coll.find({ 'rest.loc': { $near: [0, 0], $maxDistance: 30 } }).count(), 3);                    // 2950
  test.equal(coll.find({ 'rest.loc': { $near: [0, 0], $maxDistance: 4 } }).count(), 1);                     // 2951
  var points = coll.find({ 'rest.loc': { $near: [0, 0], $maxDistance: 6 } }).fetch();                       // 2952
  _.each(points, function (point, i, points) {                                                              // 2953
    test.isTrue(!i || distance([0, 0], point.rest.loc) >= distance([0, 0], points[i - 1].rest.loc));        // 2954
  });                                                                                                       // 2955
                                                                                                            // 2956
  function distance(a, b) {                                                                                 // 2957
    var x = a[0] - b[0];                                                                                    // 2958
    var y = a[1] - b[1];                                                                                    // 2959
    return Math.sqrt(x * x + y * y);                                                                        // 2960
  }                                                                                                         // 2961
                                                                                                            // 2962
  // GeoJSON tests                                                                                          // 2963
  coll = new LocalCollection();                                                                             // 2964
  var data = [{ "category" : "BURGLARY", "descript" : "BURGLARY OF STORE, FORCIBLE ENTRY", "address" : "100 Block of 10TH ST", "location" : { "type" : "Point", "coordinates" : [  -122.415449723856,  37.7749518087273 ] } },
    { "category" : "WEAPON LAWS", "descript" : "POSS OF PROHIBITED WEAPON", "address" : "900 Block of MINNA ST", "location" : { "type" : "Point", "coordinates" : [  -122.415386041221,  37.7747879744156 ] } },
    { "category" : "LARCENY/THEFT", "descript" : "GRAND THEFT OF PROPERTY", "address" : "900 Block of MINNA ST", "location" : { "type" : "Point", "coordinates" : [  -122.41538270191,  37.774683628213 ] } },
    { "category" : "LARCENY/THEFT", "descript" : "PETTY THEFT FROM LOCKED AUTO", "address" : "900 Block of MINNA ST", "location" : { "type" : "Point", "coordinates" : [  -122.415396041221,  37.7747879744156 ] } },
    { "category" : "OTHER OFFENSES", "descript" : "POSSESSION OF BURGLARY TOOLS", "address" : "900 Block of MINNA ST", "location" : { "type" : "Point", "coordinates" : [  -122.415386041221,  37.7747879734156 ] } }
  ];                                                                                                        // 2970
                                                                                                            // 2971
  _.each(data, function (x, i) { coll.insert(_.extend(x, { x: i })); });                                    // 2972
                                                                                                            // 2973
  var close15 = coll.find({ location: { $near: {                                                            // 2974
    $geometry: { type: "Point",                                                                             // 2975
                 coordinates: [-122.4154282, 37.7746115] },                                                 // 2976
    $maxDistance: 15 } } }).fetch();                                                                        // 2977
  test.length(close15, 1);                                                                                  // 2978
  test.equal(close15[0].descript, "GRAND THEFT OF PROPERTY");                                               // 2979
                                                                                                            // 2980
  var close20 = coll.find({ location: { $near: {                                                            // 2981
    $geometry: { type: "Point",                                                                             // 2982
                 coordinates: [-122.4154282, 37.7746115] },                                                 // 2983
    $maxDistance: 20 } } }).fetch();                                                                        // 2984
  test.length(close20, 4);                                                                                  // 2985
  test.equal(close20[0].descript, "GRAND THEFT OF PROPERTY");                                               // 2986
  test.equal(close20[1].descript, "PETTY THEFT FROM LOCKED AUTO");                                          // 2987
  test.equal(close20[2].descript, "POSSESSION OF BURGLARY TOOLS");                                          // 2988
  test.equal(close20[3].descript, "POSS OF PROHIBITED WEAPON");                                             // 2989
                                                                                                            // 2990
  // Any combinations of $near with $or/$and/$nor/$not should throw an error                                // 2991
  test.throws(function () {                                                                                 // 2992
    coll.find({ location: {                                                                                 // 2993
      $not: {                                                                                               // 2994
        $near: {                                                                                            // 2995
          $geometry: {                                                                                      // 2996
            type: "Point",                                                                                  // 2997
            coordinates: [-122.4154282, 37.7746115]                                                         // 2998
          }, $maxDistance: 20 } } } });                                                                     // 2999
  });                                                                                                       // 3000
  test.throws(function () {                                                                                 // 3001
    coll.find({                                                                                             // 3002
      $and: [ { location: { $near: { $geometry: { type: "Point", coordinates: [-122.4154282, 37.7746115] }, $maxDistance: 20 }}},
              { x: 0 }]                                                                                     // 3004
    });                                                                                                     // 3005
  });                                                                                                       // 3006
  test.throws(function () {                                                                                 // 3007
    coll.find({                                                                                             // 3008
      $or: [ { location: { $near: { $geometry: { type: "Point", coordinates: [-122.4154282, 37.7746115] }, $maxDistance: 20 }}},
             { x: 0 }]                                                                                      // 3010
    });                                                                                                     // 3011
  });                                                                                                       // 3012
  test.throws(function () {                                                                                 // 3013
    coll.find({                                                                                             // 3014
      $nor: [ { location: { $near: { $geometry: { type: "Point", coordinates: [-122.4154282, 37.7746115] }, $maxDistance: 1 }}},
              { x: 0 }]                                                                                     // 3016
    });                                                                                                     // 3017
  });                                                                                                       // 3018
  test.throws(function () {                                                                                 // 3019
    coll.find({                                                                                             // 3020
      $and: [{                                                                                              // 3021
        $and: [{                                                                                            // 3022
          location: {                                                                                       // 3023
            $near: {                                                                                        // 3024
              $geometry: {                                                                                  // 3025
                type: "Point",                                                                              // 3026
                coordinates: [-122.4154282, 37.7746115]                                                     // 3027
              },                                                                                            // 3028
              $maxDistance: 1                                                                               // 3029
            }                                                                                               // 3030
          }                                                                                                 // 3031
        }]                                                                                                  // 3032
      }]                                                                                                    // 3033
    });                                                                                                     // 3034
  });                                                                                                       // 3035
                                                                                                            // 3036
  // array tests                                                                                            // 3037
  coll = new LocalCollection();                                                                             // 3038
  coll.insert({                                                                                             // 3039
    _id: "x",                                                                                               // 3040
    k: 9,                                                                                                   // 3041
    a: [                                                                                                    // 3042
      {b: [                                                                                                 // 3043
        [100, 100],                                                                                         // 3044
        [1,  1]]},                                                                                          // 3045
      {b: [150,  150]}]});                                                                                  // 3046
  coll.insert({                                                                                             // 3047
    _id: "y",                                                                                               // 3048
    k: 9,                                                                                                   // 3049
    a: {b: [5, 5]}});                                                                                       // 3050
  var testNear = function (near, md, expected) {                                                            // 3051
    test.equal(                                                                                             // 3052
      _.pluck(                                                                                              // 3053
        coll.find({'a.b': {$near: near, $maxDistance: md}}).fetch(), '_id'),                                // 3054
      expected);                                                                                            // 3055
  };                                                                                                        // 3056
  testNear([149, 149], 4, ['x']);                                                                           // 3057
  testNear([149, 149], 1000, ['x', 'y']);                                                                   // 3058
  // It's important that we figure out that 'x' is closer than 'y' to [2,2] even                            // 3059
  // though the first within-1000 point in 'x' (ie, [100,100]) is farther than                              // 3060
  // 'y'.                                                                                                   // 3061
  testNear([2, 2], 1000, ['x', 'y']);                                                                       // 3062
                                                                                                            // 3063
  // Ensure that distance is used as a tie-breaker for sort.                                                // 3064
  test.equal(                                                                                               // 3065
    _.pluck(coll.find({'a.b': {$near: [1, 1]}}, {sort: {k: 1}}).fetch(), '_id'),                            // 3066
    ['x', 'y']);                                                                                            // 3067
  test.equal(                                                                                               // 3068
    _.pluck(coll.find({'a.b': {$near: [5, 5]}}, {sort: {k: 1}}).fetch(), '_id'),                            // 3069
    ['y', 'x']);                                                                                            // 3070
                                                                                                            // 3071
  var operations = [];                                                                                      // 3072
  var cbs = log_callbacks(operations);                                                                      // 3073
  var handle = coll.find({'a.b': {$near: [7,7]}}).observe(cbs);                                             // 3074
                                                                                                            // 3075
  test.length(operations, 2);                                                                               // 3076
  test.equal(operations.shift(), ['added', {k:9, a:{b:[5,5]}}, 0, null]);                                   // 3077
  test.equal(operations.shift(),                                                                            // 3078
             ['added', {k: 9, a:[{b:[[100,100],[1,1]]},{b:[150,150]}]},                                     // 3079
              1, null]);                                                                                    // 3080
  // This needs to be inserted in the MIDDLE of the two existing ones.                                      // 3081
  coll.insert({a: {b: [3,3]}});                                                                             // 3082
  test.length(operations, 1);                                                                               // 3083
  test.equal(operations.shift(), ['added', {a: {b: [3, 3]}}, 1, 'x']);                                      // 3084
                                                                                                            // 3085
  handle.stop();                                                                                            // 3086
});                                                                                                         // 3087
                                                                                                            // 3088
// See #2275.                                                                                               // 3089
Tinytest.add("minimongo - fetch in observe", function (test) {                                              // 3090
  var coll = new LocalCollection;                                                                           // 3091
  var callbackInvoked = false;                                                                              // 3092
  var observe = coll.find().observeChanges({                                                                // 3093
    added: function (id, fields) {                                                                          // 3094
      callbackInvoked = true;                                                                               // 3095
      test.equal(fields, {foo: 1});                                                                         // 3096
      var doc = coll.findOne({foo: 1});                                                                     // 3097
      test.isTrue(doc);                                                                                     // 3098
      test.equal(doc.foo, 1);                                                                               // 3099
    }                                                                                                       // 3100
  });                                                                                                       // 3101
  test.isFalse(callbackInvoked);                                                                            // 3102
  var computation = Deps.autorun(function (computation) {                                                   // 3103
    if (computation.firstRun) {                                                                             // 3104
      coll.insert({foo: 1});                                                                                // 3105
    }                                                                                                       // 3106
  });                                                                                                       // 3107
  test.isTrue(callbackInvoked);                                                                             // 3108
  observe.stop();                                                                                           // 3109
  computation.stop();                                                                                       // 3110
});                                                                                                         // 3111
                                                                                                            // 3112
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                          //
// packages/minimongo/wrap_transform_tests.js                                                               //
//                                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                            //
Tinytest.add("minimongo - wrapTransform", function (test) {                                                 // 1
  var wrap = LocalCollection.wrapTransform;                                                                 // 2
                                                                                                            // 3
  // Transforming no function gives falsey.                                                                 // 4
  test.isFalse(wrap(undefined));                                                                            // 5
  test.isFalse(wrap(null));                                                                                 // 6
                                                                                                            // 7
  // It's OK if you don't change the ID.                                                                    // 8
  var validTransform = function (doc) {                                                                     // 9
    delete doc.x;                                                                                           // 10
    doc.y = 42;                                                                                             // 11
    doc.z = function () { return 43; };                                                                     // 12
    return doc;                                                                                             // 13
  };                                                                                                        // 14
  var transformed = wrap(validTransform)({_id: "asdf", x: 54});                                             // 15
  test.equal(_.keys(transformed), ['_id', 'y', 'z']);                                                       // 16
  test.equal(transformed.y, 42);                                                                            // 17
  test.equal(transformed.z(), 43);                                                                          // 18
                                                                                                            // 19
  // Ensure that ObjectIDs work (even if the _ids in question are not ===-equal)                            // 20
  var oid1 = new LocalCollection._ObjectID();                                                               // 21
  var oid2 = new LocalCollection._ObjectID(oid1.toHexString());                                             // 22
  test.equal(wrap(function () {return {_id: oid2};})({_id: oid1}),                                          // 23
             {_id: oid2});                                                                                  // 24
                                                                                                            // 25
  // transform functions must return objects                                                                // 26
  var invalidObjects = [                                                                                    // 27
    "asdf", new LocalCollection._ObjectID(), false, null, true,                                             // 28
    27, [123], /adsf/, new Date, function () {}, undefined                                                  // 29
  ];                                                                                                        // 30
  _.each(invalidObjects, function (invalidObject) {                                                         // 31
    var wrapped = wrap(function () { return invalidObject; });                                              // 32
    test.throws(function () {                                                                               // 33
      wrapped({_id: "asdf"});                                                                               // 34
    });                                                                                                     // 35
  }, /transform must return object/);                                                                       // 36
                                                                                                            // 37
  // transform functions may not change _ids                                                                // 38
  var wrapped = wrap(function (doc) { doc._id = 'x'; return doc; });                                        // 39
  test.throws(function () {                                                                                 // 40
    wrapped({_id: 'y'});                                                                                    // 41
  }, /can't have different _id/);                                                                           // 42
                                                                                                            // 43
  // transform functions may remove _ids                                                                    // 44
  test.equal({_id: 'a', x: 2},                                                                              // 45
             wrap(function (d) {delete d._id; return d;})({_id: 'a', x: 2}));                               // 46
                                                                                                            // 47
  // test that wrapped transform functions are nonreactive                                                  // 48
  var unwrapped = function (doc) {                                                                          // 49
    test.isFalse(Deps.active);                                                                              // 50
    return doc;                                                                                             // 51
  };                                                                                                        // 52
  var handle = Deps.autorun(function () {                                                                   // 53
    test.isTrue(Deps.active);                                                                               // 54
    wrap(unwrapped)({_id: "xxx"});                                                                          // 55
  });                                                                                                       // 56
  handle.stop();                                                                                            // 57
});                                                                                                         // 58
                                                                                                            // 59
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
