(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                      //
// packages/minifiers/beautify-tests.js                                                                 //
//                                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                        //
                                                                                                        // 1
// The UglifyJSMinify API can also be used for beautification.  Test that it                            // 2
// behaves as expected.                                                                                 // 3
                                                                                                        // 4
Tinytest.add('minifiers - uglify beautify', function (test) {                                           // 5
  // See <https://github.com/mishoo/UglifyJS2#the-simple-way> and                                       // 6
  // <http://lisperator.net/uglifyjs/codegen> for the API we're calling.                                // 7
  test.equal(UglifyJSMinify('one = function () { return 1; };',                                         // 8
                            { fromString: true,                                                         // 9
                              output: { beautify: true,                                                 // 10
                                        indent_level: 2,                                                // 11
                                        width: 80 } }).code,                                            // 12
             'one = function() {\n' +                                                                   // 13
             '  return 1;\n' +                                                                          // 14
             '};');                                                                                     // 15
});                                                                                                     // 16
                                                                                                        // 17
//////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                      //
// packages/minifiers/minifiers-tests.js                                                                //
//                                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                        //
                                                                                                        // 1
Tinytest.add("minifiers - simple css minification", function (test) {                                   // 2
  var t = function (css, expected, desc) {                                                              // 3
    test.equal(CssTools.minifyCss(css), expected, desc);                                                // 4
  }                                                                                                     // 5
                                                                                                        // 6
  t('a \t\n{ color: red } \n', 'a{color:red}', 'whitespace check');                                     // 7
  t('a \t\n{ color: red; margin: 1; } \n', 'a{color:red;margin:1}', 'only last one loses semicolon');   // 8
  t('a \t\n{ color: red;;; margin: 1;;; } \n', 'a{color:red;margin:1}', 'more semicolons than needed'); // 9
  t('a , p \t\n{ color: red; } \n', 'a,p{color:red}', 'multiple selectors');                            // 10
  t('body {}', '', 'removing empty rules');                                                             // 11
  t('*.my-class { color: #fff; }', '.my-class{color:#fff}', 'removing universal selector');             // 12
  t('p > *.my-class { color: #fff; }', 'p>.my-class{color:#fff}', 'removing optional whitespace around ">" in selector');
  t('p +  *.my-class { color: #fff; }', 'p+.my-class{color:#fff}', 'removing optional whitespace around "+" in selector');
  // XXX url parsing is difficult to support at the moment                                              // 15
  t('a {\n\
  font:12px \'Helvetica\',"Arial",\'Nautica\';\n\
  background:url("/some/nice/picture.png");\n}',                                                        // 18
  'a{font:12px Helvetica,Arial,Nautica;background:url("/some/nice/picture.png")}',  'removing quotes in font and url (if possible)');
  t('/* no comments */ a { color: red; }', 'a{color:red}', 'remove comments');                          // 20
});                                                                                                     // 21
                                                                                                        // 22
//////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                      //
// packages/minifiers/urlrewriting-tests.js                                                             //
//                                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                        //
                                                                                                        // 1
Tinytest.add("minifiers - url rewriting when merging", function (test) {                                // 2
  var stylesheet = function(backgroundPath) {                                                           // 3
    return "body { color: green; background: top center url(" + backgroundPath + ") black, bottom center url(" + backgroundPath + "); }"
  };                                                                                                    // 5
                                                                                                        // 6
  var parseOptions = { source: null, position: true };                                                  // 7
                                                                                                        // 8
  var t = function(relativeUrl, absoluteUrl, desc) {                                                    // 9
    var ast1 = CssTools.parseCss(stylesheet(relativeUrl), parseOptions);                                // 10
    var ast2 = CssTools.parseCss(stylesheet(absoluteUrl), parseOptions);                                // 11
    CssTools.rewriteCssUrls(ast1);                                                                      // 12
                                                                                                        // 13
    test.equal(CssTools.stringifyCss(ast1), CssTools.stringifyCss(ast2), desc);                         // 14
  };                                                                                                    // 15
                                                                                                        // 16
  parseOptions.source = 'packages/nameOfPackage/style.css';                                             // 17
  t('../image.png', 'packages/image.png', 'parent directory');                                          // 18
  t('./../image.png', 'packages/image.png', 'parent directory');                                        // 19
  t('../nameOfPackage2/image.png', 'packages/nameOfPackage2/image.png', 'cousin directory');            // 20
  t('../../image.png', 'image.png', 'grand parent directory');                                          // 21
  t('./image.png', 'packages/nameOfPackage/image.png', 'current directory');                            // 22
  t('./child/image.png', 'packages/nameOfPackage/child/image.png', 'child directory');                  // 23
  t('child/image.png', 'packages/nameOfPackage/child/image.png', 'child directory');                    // 24
  t('/image.png', '/image.png', 'absolute url');                                                        // 25
  t('"/image.png"', '"/image.png"', 'double quoted url');                                               // 26
  t("'/image.png'", "'/image.png'", 'single quoted url');                                               // 27
  t('"./../image.png"', '"packages/image.png"', 'quoted parent directory');                             // 28
  t('http://i.imgur.com/fBcdJIh.gif', 'http://i.imgur.com/fBcdJIh.gif', 'complete URL');                // 29
  t('"http://i.imgur.com/fBcdJIh.gif"', '"http://i.imgur.com/fBcdJIh.gif"', 'complete quoted URL');     // 30
  t('data:image/png;base64,iVBORw0K=', 'data:image/png;base64,iVBORw0K=', 'data URI');                  // 31
  t('http://', 'http://', 'malformed URL');                                                             // 32
                                                                                                        // 33
  parseOptions.source = 'application/client/dir/other-style.css';                                       // 34
  t('./image.png', '/image.png', 'base path is root');                                                  // 35
  t('./child/image.png', '/child/image.png', 'child directory from root');                              // 36
  t('child/image.png', '/child/image.png', 'child directory from root');                                // 37
  t('/image.png', '/image.png', 'absolute url');                                                        // 38
  t('"/image.png"', '"/image.png"', 'double quoted url');                                               // 39
  t("'/image.png'", "'/image.png'", 'single quoted url');                                               // 40
  t('http://i.imgur.com/fBcdJIh.gif', 'http://i.imgur.com/fBcdJIh.gif', 'complete URL');                // 41
  t('"http://i.imgur.com/fBcdJIh.gif"', '"http://i.imgur.com/fBcdJIh.gif"', 'complete quoted URL');     // 42
  t('data:image/png;base64,iVBORw0K=', 'data:image/png;base64,iVBORw0K=', 'data URI');                  // 43
  t('http://', 'http://', 'malformed URL');                                                             // 44
});                                                                                                     // 45
                                                                                                        // 46
//////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
