(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/stub_stream.js                                                                                  //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
StubStream = function () {                                                                                           // 1
  var self = this;                                                                                                   // 2
                                                                                                                     // 3
  self.sent = [];                                                                                                    // 4
  self.callbacks = {};                                                                                               // 5
};                                                                                                                   // 6
                                                                                                                     // 7
                                                                                                                     // 8
_.extend(StubStream.prototype, {                                                                                     // 9
  // Methods from Stream                                                                                             // 10
  on: function (name, callback) {                                                                                    // 11
    var self = this;                                                                                                 // 12
                                                                                                                     // 13
    if (!self.callbacks[name])                                                                                       // 14
      self.callbacks[name] = [callback];                                                                             // 15
    else                                                                                                             // 16
      self.callbacks[name].push(callback);                                                                           // 17
  },                                                                                                                 // 18
                                                                                                                     // 19
  send: function (data) {                                                                                            // 20
    var self = this;                                                                                                 // 21
    self.sent.push(data);                                                                                            // 22
  },                                                                                                                 // 23
                                                                                                                     // 24
  status: function () {                                                                                              // 25
    return {status: "connected", fake: true};                                                                        // 26
  },                                                                                                                 // 27
                                                                                                                     // 28
  reconnect: function () {                                                                                           // 29
    // no-op                                                                                                         // 30
  },                                                                                                                 // 31
                                                                                                                     // 32
  _lostConnection: function () {                                                                                     // 33
    // no-op                                                                                                         // 34
  },                                                                                                                 // 35
                                                                                                                     // 36
  // Methods for tests                                                                                               // 37
  receive: function (data) {                                                                                         // 38
    var self = this;                                                                                                 // 39
                                                                                                                     // 40
    if (typeof data === 'object') {                                                                                  // 41
      data = EJSON.stringify(data);                                                                                  // 42
    }                                                                                                                // 43
                                                                                                                     // 44
    _.each(self.callbacks['message'], function (cb) {                                                                // 45
      cb(data);                                                                                                      // 46
    });                                                                                                              // 47
  },                                                                                                                 // 48
                                                                                                                     // 49
  reset: function () {                                                                                               // 50
    var self = this;                                                                                                 // 51
    _.each(self.callbacks['reset'], function (cb) {                                                                  // 52
      cb();                                                                                                          // 53
    });                                                                                                              // 54
  },                                                                                                                 // 55
                                                                                                                     // 56
  // Provide a tag to detect stub streams.                                                                           // 57
  // We don't log heartbeat failures on stub streams, for example.                                                   // 58
  _isStub: true                                                                                                      // 59
});                                                                                                                  // 60
                                                                                                                     // 61
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/livedata_connection_tests.js                                                                    //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
var newConnection = function (stream) {                                                                              // 1
  // Some of these tests leave outstanding methods with no result yet                                                // 2
  // returned. This should not block us from re-running tests when sources                                           // 3
  // change.                                                                                                         // 4
  return new LivedataTest.Connection(stream, {reloadWithOutstanding: true});                                         // 5
};                                                                                                                   // 6
                                                                                                                     // 7
var makeConnectMessage = function (session) {                                                                        // 8
  var msg = {                                                                                                        // 9
    msg: 'connect',                                                                                                  // 10
    version: LivedataTest.SUPPORTED_DDP_VERSIONS[0],                                                                 // 11
    support: LivedataTest.SUPPORTED_DDP_VERSIONS                                                                     // 12
  };                                                                                                                 // 13
                                                                                                                     // 14
  if (session)                                                                                                       // 15
    msg.session = session;                                                                                           // 16
  return msg;                                                                                                        // 17
}                                                                                                                    // 18
                                                                                                                     // 19
// Tests that stream got a message that matches expected.                                                            // 20
// Expected is normally an object, and allows a wildcard value of '*',                                               // 21
// which will then match any value.                                                                                  // 22
// Returns the message (parsed as a JSON object if expected is an object);                                           // 23
// which is particularly handy if you want to extract a value that was                                               // 24
// matched as a wildcard.                                                                                            // 25
var testGotMessage = function (test, stream, expected) {                                                             // 26
  if (stream.sent.length === 0) {                                                                                    // 27
    test.fail({error: 'no message received', expected: expected});                                                   // 28
    return undefined;                                                                                                // 29
  }                                                                                                                  // 30
                                                                                                                     // 31
  var got = stream.sent.shift();                                                                                     // 32
                                                                                                                     // 33
  if (typeof got === 'string' && typeof expected === 'object')                                                       // 34
    got = JSON.parse(got);                                                                                           // 35
                                                                                                                     // 36
  // An expected value of '*' matches any value, and the matching value (or                                          // 37
  // array of matching values, if there are multiple) is returned from this                                          // 38
  // function.                                                                                                       // 39
  if (typeof expected === 'object') {                                                                                // 40
    var keysWithStarValues = [];                                                                                     // 41
    _.each(expected, function (v, k) {                                                                               // 42
      if (v === '*')                                                                                                 // 43
        keysWithStarValues.push(k);                                                                                  // 44
    });                                                                                                              // 45
    _.each(keysWithStarValues, function (k) {                                                                        // 46
      expected[k] = got[k];                                                                                          // 47
    });                                                                                                              // 48
  }                                                                                                                  // 49
                                                                                                                     // 50
  test.equal(got, expected);                                                                                         // 51
  return got;                                                                                                        // 52
};                                                                                                                   // 53
                                                                                                                     // 54
var startAndConnect = function(test, stream) {                                                                       // 55
  stream.reset(); // initial connection start.                                                                       // 56
                                                                                                                     // 57
  testGotMessage(test, stream, makeConnectMessage());                                                                // 58
  test.length(stream.sent, 0);                                                                                       // 59
                                                                                                                     // 60
  stream.receive({msg: 'connected', session: SESSION_ID});                                                           // 61
  test.length(stream.sent, 0);                                                                                       // 62
};                                                                                                                   // 63
                                                                                                                     // 64
var SESSION_ID = '17';                                                                                               // 65
                                                                                                                     // 66
Tinytest.add("livedata stub - receive data", function (test) {                                                       // 67
  var stream = new StubStream();                                                                                     // 68
  var conn = newConnection(stream);                                                                                  // 69
                                                                                                                     // 70
  startAndConnect(test, stream);                                                                                     // 71
                                                                                                                     // 72
  // data comes in for unknown collection.                                                                           // 73
  var coll_name = Random.id();                                                                                       // 74
  stream.receive({msg: 'added', collection: coll_name, id: '1234',                                                   // 75
                  fields: {a: 1}});                                                                                  // 76
  // break throught the black box and test internal state                                                            // 77
  test.length(conn._updatesForUnknownStores[coll_name], 1);                                                          // 78
                                                                                                                     // 79
  // XXX: Test that the old signature of passing manager directly instead of in                                      // 80
  // options works.                                                                                                  // 81
  var coll = new Meteor.Collection(coll_name, conn);                                                                 // 82
                                                                                                                     // 83
  // queue has been emptied and doc is in db.                                                                        // 84
  test.isUndefined(conn._updatesForUnknownStores[coll_name]);                                                        // 85
  test.equal(coll.find({}).fetch(), [{_id:'1234', a:1}]);                                                            // 86
                                                                                                                     // 87
  // second message. applied directly to the db.                                                                     // 88
  stream.receive({msg: 'changed', collection: coll_name, id: '1234',                                                 // 89
                  fields: {a:2}});                                                                                   // 90
  test.equal(coll.find({}).fetch(), [{_id:'1234', a:2}]);                                                            // 91
  test.isUndefined(conn._updatesForUnknownStores[coll_name]);                                                        // 92
});                                                                                                                  // 93
                                                                                                                     // 94
Tinytest.add("livedata stub - subscribe", function (test) {                                                          // 95
  var stream = new StubStream();                                                                                     // 96
  var conn = newConnection(stream);                                                                                  // 97
                                                                                                                     // 98
  startAndConnect(test, stream);                                                                                     // 99
                                                                                                                     // 100
  // subscribe                                                                                                       // 101
  var callback_fired = false;                                                                                        // 102
  var sub = conn.subscribe('my_data', function () {                                                                  // 103
    callback_fired = true;                                                                                           // 104
  });                                                                                                                // 105
  test.isFalse(callback_fired);                                                                                      // 106
                                                                                                                     // 107
  test.length(stream.sent, 1);                                                                                       // 108
  var message = JSON.parse(stream.sent.shift());                                                                     // 109
  var id = message.id;                                                                                               // 110
  delete message.id;                                                                                                 // 111
  test.equal(message, {msg: 'sub', name: 'my_data', params: []});                                                    // 112
                                                                                                                     // 113
  var reactivelyReady = false;                                                                                       // 114
  var autorunHandle = Deps.autorun(function () {                                                                     // 115
    reactivelyReady = sub.ready();                                                                                   // 116
  });                                                                                                                // 117
  test.isFalse(reactivelyReady);                                                                                     // 118
                                                                                                                     // 119
  // get the sub satisfied. callback fires.                                                                          // 120
  stream.receive({msg: 'ready', 'subs': [id]});                                                                      // 121
  test.isTrue(callback_fired);                                                                                       // 122
  Deps.flush();                                                                                                      // 123
  test.isTrue(reactivelyReady);                                                                                      // 124
                                                                                                                     // 125
  // Unsubscribe.                                                                                                    // 126
  sub.stop();                                                                                                        // 127
  test.length(stream.sent, 1);                                                                                       // 128
  message = JSON.parse(stream.sent.shift());                                                                         // 129
  test.equal(message, {msg: 'unsub', id: id});                                                                       // 130
  Deps.flush();                                                                                                      // 131
  test.isFalse(reactivelyReady);                                                                                     // 132
                                                                                                                     // 133
  // Resubscribe.                                                                                                    // 134
  conn.subscribe('my_data');                                                                                         // 135
  test.length(stream.sent, 1);                                                                                       // 136
  message = JSON.parse(stream.sent.shift());                                                                         // 137
  var id2 = message.id;                                                                                              // 138
  test.notEqual(id, id2);                                                                                            // 139
  delete message.id;                                                                                                 // 140
  test.equal(message, {msg: 'sub', name: 'my_data', params: []});                                                    // 141
});                                                                                                                  // 142
                                                                                                                     // 143
                                                                                                                     // 144
Tinytest.add("livedata stub - reactive subscribe", function (test) {                                                 // 145
  var stream = new StubStream();                                                                                     // 146
  var conn = newConnection(stream);                                                                                  // 147
                                                                                                                     // 148
  startAndConnect(test, stream);                                                                                     // 149
                                                                                                                     // 150
  var rFoo = new ReactiveVar('foo1');                                                                                // 151
  var rBar = new ReactiveVar('bar1');                                                                                // 152
                                                                                                                     // 153
  var onReadyCount = {};                                                                                             // 154
  var onReady = function (tag) {                                                                                     // 155
    return function () {                                                                                             // 156
      if (_.has(onReadyCount, tag))                                                                                  // 157
        ++onReadyCount[tag];                                                                                         // 158
      else                                                                                                           // 159
        onReadyCount[tag] = 1;                                                                                       // 160
    };                                                                                                               // 161
  };                                                                                                                 // 162
                                                                                                                     // 163
  // Subscribe to some subs.                                                                                         // 164
  var stopperHandle, completerHandle;                                                                                // 165
  var autorunHandle = Deps.autorun(function () {                                                                     // 166
    conn.subscribe("foo", rFoo.get(), onReady(rFoo.get()));                                                          // 167
    conn.subscribe("bar", rBar.get(), onReady(rBar.get()));                                                          // 168
    completerHandle = conn.subscribe("completer", onReady("completer"));                                             // 169
    stopperHandle = conn.subscribe("stopper", onReady("stopper"));                                                   // 170
  });                                                                                                                // 171
                                                                                                                     // 172
  var completerReady;                                                                                                // 173
  var readyAutorunHandle = Deps.autorun(function() {                                                                 // 174
    completerReady = completerHandle.ready();                                                                        // 175
  });                                                                                                                // 176
                                                                                                                     // 177
  // Check sub messages. (Assume they are sent in the order executed.)                                               // 178
  test.length(stream.sent, 4);                                                                                       // 179
  var message = JSON.parse(stream.sent.shift());                                                                     // 180
  var idFoo1 = message.id;                                                                                           // 181
  delete message.id;                                                                                                 // 182
  test.equal(message, {msg: 'sub', name: 'foo', params: ['foo1']});                                                  // 183
                                                                                                                     // 184
  message = JSON.parse(stream.sent.shift());                                                                         // 185
  var idBar1 = message.id;                                                                                           // 186
  delete message.id;                                                                                                 // 187
  test.equal(message, {msg: 'sub', name: 'bar', params: ['bar1']});                                                  // 188
                                                                                                                     // 189
  message = JSON.parse(stream.sent.shift());                                                                         // 190
  var idCompleter = message.id;                                                                                      // 191
  delete message.id;                                                                                                 // 192
  test.equal(message, {msg: 'sub', name: 'completer', params: []});                                                  // 193
                                                                                                                     // 194
  message = JSON.parse(stream.sent.shift());                                                                         // 195
  var idStopper = message.id;                                                                                        // 196
  delete message.id;                                                                                                 // 197
  test.equal(message, {msg: 'sub', name: 'stopper', params: []});                                                    // 198
                                                                                                                     // 199
  // Haven't hit onReady yet.                                                                                        // 200
  test.equal(onReadyCount, {});                                                                                      // 201
  Deps.flush();                                                                                                      // 202
  test.isFalse(completerReady);                                                                                      // 203
                                                                                                                     // 204
  // "completer" gets ready now. its callback should fire.                                                           // 205
  stream.receive({msg: 'ready', 'subs': [idCompleter]});                                                             // 206
  test.equal(onReadyCount, {completer: 1});                                                                          // 207
  test.length(stream.sent, 0);                                                                                       // 208
  Deps.flush();                                                                                                      // 209
  test.isTrue(completerReady);                                                                                       // 210
                                                                                                                     // 211
  // Stop 'stopper'.                                                                                                 // 212
  stopperHandle.stop();                                                                                              // 213
  test.length(stream.sent, 1);                                                                                       // 214
  message = JSON.parse(stream.sent.shift());                                                                         // 215
  test.equal(message, {msg: 'unsub', id: idStopper});                                                                // 216
                                                                                                                     // 217
  test.equal(onReadyCount, {completer: 1});                                                                          // 218
  Deps.flush();                                                                                                      // 219
  test.isTrue(completerReady);                                                                                       // 220
                                                                                                                     // 221
  // Change the foo subscription and flush. We should sub to the new foo                                             // 222
  // subscription, re-sub to the stopper subscription, and then unsub from the old                                   // 223
  // foo subscription.  The bar subscription should be unaffected. The completer                                     // 224
  // subscription should *NOT* call its new onReady callback, because we only                                        // 225
  // call at most one onReady for a given reactively-saved subscription.                                             // 226
  // The completerHandle should have been reestablished to the ready handle.                                         // 227
  rFoo.set("foo2");                                                                                                  // 228
  Deps.flush();                                                                                                      // 229
  test.length(stream.sent, 3);                                                                                       // 230
                                                                                                                     // 231
  message = JSON.parse(stream.sent.shift());                                                                         // 232
  var idFoo2 = message.id;                                                                                           // 233
  delete message.id;                                                                                                 // 234
  test.equal(message, {msg: 'sub', name: 'foo', params: ['foo2']});                                                  // 235
                                                                                                                     // 236
  message = JSON.parse(stream.sent.shift());                                                                         // 237
  var idStopperAgain = message.id;                                                                                   // 238
  delete message.id;                                                                                                 // 239
  test.equal(message, {msg: 'sub', name: 'stopper', params: []});                                                    // 240
                                                                                                                     // 241
  message = JSON.parse(stream.sent.shift());                                                                         // 242
  test.equal(message, {msg: 'unsub', id: idFoo1});                                                                   // 243
                                                                                                                     // 244
  test.equal(onReadyCount, {completer: 1});                                                                          // 245
  test.isTrue(completerReady);                                                                                       // 246
                                                                                                                     // 247
  // Ready the stopper and bar subs. Completing stopper should call only the                                         // 248
  // onReady from the new subscription because they were separate subscriptions                                      // 249
  // started at different times and the first one was explicitly torn down by                                        // 250
  // the client; completing bar should call only the onReady from the new                                            // 251
  // subscription because we only call at most one onReady per reactively-saved                                      // 252
  // subscription.                                                                                                   // 253
  stream.receive({msg: 'ready', 'subs': [idStopperAgain, idBar1]});                                                  // 254
  test.equal(onReadyCount, {completer: 1, bar1: 1, stopper: 1});                                                     // 255
                                                                                                                     // 256
  // Shut down the autorun. This should unsub us from all current subs at flush                                      // 257
  // time.                                                                                                           // 258
  autorunHandle.stop();                                                                                              // 259
  Deps.flush();                                                                                                      // 260
  test.isFalse(completerReady);                                                                                      // 261
  readyAutorunHandle.stop();                                                                                         // 262
                                                                                                                     // 263
  test.length(stream.sent, 4);                                                                                       // 264
  // The order of unsubs here is not important.                                                                      // 265
  var unsubMessages = _.map(stream.sent, JSON.parse);                                                                // 266
  stream.sent.length = 0;                                                                                            // 267
  test.equal(_.unique(_.pluck(unsubMessages, 'msg')), ['unsub']);                                                    // 268
  var actualIds = _.pluck(unsubMessages, 'id');                                                                      // 269
  var expectedIds = [idFoo2, idBar1, idCompleter, idStopperAgain];                                                   // 270
  actualIds.sort();                                                                                                  // 271
  expectedIds.sort();                                                                                                // 272
  test.equal(actualIds, expectedIds);                                                                                // 273
});                                                                                                                  // 274
                                                                                                                     // 275
Tinytest.add("livedata stub - reactive subscribe handle correct", function (test) {                                  // 276
  var stream = new StubStream();                                                                                     // 277
  var conn = newConnection(stream);                                                                                  // 278
                                                                                                                     // 279
  startAndConnect(test, stream);                                                                                     // 280
                                                                                                                     // 281
  var rFoo = new ReactiveVar('foo1');                                                                                // 282
                                                                                                                     // 283
  // Subscribe to some subs.                                                                                         // 284
  var fooHandle, fooReady;                                                                                           // 285
  var autorunHandle = Deps.autorun(function () {                                                                     // 286
    fooHandle = conn.subscribe("foo", rFoo.get());                                                                   // 287
    Deps.autorun(function() {                                                                                        // 288
      fooReady = fooHandle.ready();                                                                                  // 289
    });                                                                                                              // 290
  });                                                                                                                // 291
                                                                                                                     // 292
  var message = JSON.parse(stream.sent.shift());                                                                     // 293
  var idFoo1 = message.id;                                                                                           // 294
  delete message.id;                                                                                                 // 295
  test.equal(message, {msg: 'sub', name: 'foo', params: ['foo1']});                                                  // 296
                                                                                                                     // 297
  // Not ready yet                                                                                                   // 298
  Deps.flush();                                                                                                      // 299
  test.isFalse(fooHandle.ready());                                                                                   // 300
  test.isFalse(fooReady);                                                                                            // 301
                                                                                                                     // 302
  // change the argument to foo. This will make a new handle, which isn't ready                                      // 303
  // the ready autorun should invalidate, reading the new false value, and                                           // 304
  // setting up a new dep which goes true soon                                                                       // 305
  rFoo.set("foo2");                                                                                                  // 306
  Deps.flush();                                                                                                      // 307
  test.length(stream.sent, 2);                                                                                       // 308
                                                                                                                     // 309
  message = JSON.parse(stream.sent.shift());                                                                         // 310
  var idFoo2 = message.id;                                                                                           // 311
  delete message.id;                                                                                                 // 312
  test.equal(message, {msg: 'sub', name: 'foo', params: ['foo2']});                                                  // 313
                                                                                                                     // 314
  message = JSON.parse(stream.sent.shift());                                                                         // 315
  test.equal(message, {msg: 'unsub', id: idFoo1});                                                                   // 316
                                                                                                                     // 317
  Deps.flush();                                                                                                      // 318
  test.isFalse(fooHandle.ready());                                                                                   // 319
  test.isFalse(fooReady);                                                                                            // 320
                                                                                                                     // 321
  // "foo" gets ready now. The handle should be ready and the autorun rerun                                          // 322
  stream.receive({msg: 'ready', 'subs': [idFoo2]});                                                                  // 323
  test.length(stream.sent, 0);                                                                                       // 324
  Deps.flush();                                                                                                      // 325
  test.isTrue(fooHandle.ready());                                                                                    // 326
  test.isTrue(fooReady);                                                                                             // 327
                                                                                                                     // 328
  // change the argument to foo. This will make a new handle, which isn't ready                                      // 329
  // the ready autorun should invalidate, making fooReady false too                                                  // 330
  rFoo.set("foo3");                                                                                                  // 331
  Deps.flush();                                                                                                      // 332
  test.length(stream.sent, 2);                                                                                       // 333
                                                                                                                     // 334
  message = JSON.parse(stream.sent.shift());                                                                         // 335
  var idFoo3 = message.id;                                                                                           // 336
  delete message.id;                                                                                                 // 337
  test.equal(message, {msg: 'sub', name: 'foo', params: ['foo3']});                                                  // 338
                                                                                                                     // 339
  message = JSON.parse(stream.sent.shift());                                                                         // 340
  test.equal(message, {msg: 'unsub', id: idFoo2});                                                                   // 341
                                                                                                                     // 342
  Deps.flush();                                                                                                      // 343
  test.isFalse(fooHandle.ready());                                                                                   // 344
  test.isFalse(fooReady);                                                                                            // 345
                                                                                                                     // 346
  // "foo" gets ready again                                                                                          // 347
  stream.receive({msg: 'ready', 'subs': [idFoo3]});                                                                  // 348
  test.length(stream.sent, 0);                                                                                       // 349
  Deps.flush();                                                                                                      // 350
  test.isTrue(fooHandle.ready());                                                                                    // 351
  test.isTrue(fooReady);                                                                                             // 352
                                                                                                                     // 353
  autorunHandle.stop();                                                                                              // 354
});                                                                                                                  // 355
                                                                                                                     // 356
Tinytest.add("livedata stub - this", function (test) {                                                               // 357
  var stream = new StubStream();                                                                                     // 358
  var conn = newConnection(stream);                                                                                  // 359
                                                                                                                     // 360
  startAndConnect(test, stream);                                                                                     // 361
  conn.methods({test_this: function() {                                                                              // 362
    test.isTrue(this.isSimulation);                                                                                  // 363
    this.unblock(); // should be a no-op                                                                             // 364
  }});                                                                                                               // 365
                                                                                                                     // 366
  // should throw no exceptions                                                                                      // 367
  conn.call('test_this', _.identity);                                                                                // 368
  // satisfy method, quiesce connection                                                                              // 369
  var message = JSON.parse(stream.sent.shift());                                                                     // 370
  test.isUndefined(message.randomSeed);                                                                              // 371
  test.equal(message, {msg: 'method', method: 'test_this',                                                           // 372
                       params: [], id:message.id});                                                                  // 373
  test.length(stream.sent, 0);                                                                                       // 374
                                                                                                                     // 375
  stream.receive({msg: 'result', id:message.id, result:null});                                                       // 376
  stream.receive({msg: 'updated', 'methods': [message.id]});                                                         // 377
                                                                                                                     // 378
});                                                                                                                  // 379
                                                                                                                     // 380
if (Meteor.isClient) {                                                                                               // 381
  Tinytest.add("livedata stub - methods", function (test) {                                                          // 382
    var stream = new StubStream();                                                                                   // 383
    var conn = newConnection(stream);                                                                                // 384
                                                                                                                     // 385
    startAndConnect(test, stream);                                                                                   // 386
                                                                                                                     // 387
    var collName = Random.id();                                                                                      // 388
    var coll = new Meteor.Collection(collName, {connection: conn});                                                  // 389
                                                                                                                     // 390
    // setup method                                                                                                  // 391
    conn.methods({do_something: function (x) {                                                                       // 392
      coll.insert({value: x});                                                                                       // 393
    }});                                                                                                             // 394
                                                                                                                     // 395
    // setup observers                                                                                               // 396
    var counts = {added: 0, removed: 0, changed: 0, moved: 0};                                                       // 397
    var handle = coll.find({}).observe(                                                                              // 398
      { addedAt: function () { counts.added += 1; },                                                                 // 399
        removedAt: function () { counts.removed += 1; },                                                             // 400
        changedAt: function () { counts.changed += 1; },                                                             // 401
        movedTo: function () { counts.moved += 1; }                                                                  // 402
      });                                                                                                            // 403
                                                                                                                     // 404
                                                                                                                     // 405
    // call method with results callback                                                                             // 406
    var callback1Fired = false;                                                                                      // 407
    conn.call('do_something', 'friday!', function (err, res) {                                                       // 408
      test.isUndefined(err);                                                                                         // 409
      test.equal(res, '1234');                                                                                       // 410
      callback1Fired = true;                                                                                         // 411
    });                                                                                                              // 412
    test.isFalse(callback1Fired);                                                                                    // 413
                                                                                                                     // 414
    // observers saw the method run.                                                                                 // 415
    test.equal(counts, {added: 1, removed: 0, changed: 0, moved: 0});                                                // 416
                                                                                                                     // 417
    // get response from server                                                                                      // 418
    var message = testGotMessage(test, stream, {msg: 'method',                                                       // 419
                                                method: 'do_something',                                              // 420
                                                params: ['friday!'],                                                 // 421
                                                id: '*',                                                             // 422
                                                randomSeed: '*'});                                                   // 423
                                                                                                                     // 424
    test.equal(coll.find({}).count(), 1);                                                                            // 425
    test.equal(coll.find({value: 'friday!'}).count(), 1);                                                            // 426
    var docId = coll.findOne({value: 'friday!'})._id;                                                                // 427
                                                                                                                     // 428
    // results does not yet result in callback, because data is not                                                  // 429
    // ready.                                                                                                        // 430
    stream.receive({msg: 'result', id:message.id, result: "1234"});                                                  // 431
    test.isFalse(callback1Fired);                                                                                    // 432
                                                                                                                     // 433
    // result message doesn't affect data                                                                            // 434
    test.equal(coll.find({}).count(), 1);                                                                            // 435
    test.equal(coll.find({value: 'friday!'}).count(), 1);                                                            // 436
    test.equal(counts, {added: 1, removed: 0, changed: 0, moved: 0});                                                // 437
                                                                                                                     // 438
    // data methods do not show up (not quiescent yet)                                                               // 439
    stream.receive({msg: 'added', collection: collName, id: LocalCollection._idStringify(docId),                     // 440
                    fields: {value: 'tuesday'}});                                                                    // 441
    test.equal(coll.find({}).count(), 1);                                                                            // 442
    test.equal(coll.find({value: 'friday!'}).count(), 1);                                                            // 443
    test.equal(counts, {added: 1, removed: 0, changed: 0, moved: 0});                                                // 444
                                                                                                                     // 445
    // send another methods (unknown on client)                                                                      // 446
    var callback2Fired = false;                                                                                      // 447
    conn.call('do_something_else', 'monday', function (err, res) {                                                   // 448
      callback2Fired = true;                                                                                         // 449
    });                                                                                                              // 450
    test.isFalse(callback1Fired);                                                                                    // 451
    test.isFalse(callback2Fired);                                                                                    // 452
                                                                                                                     // 453
    // test we still send a method request to server                                                                 // 454
    var message2 = JSON.parse(stream.sent.shift());                                                                  // 455
    test.isUndefined(message2.randomSeed);                                                                           // 456
    test.equal(message2, {msg: 'method', method: 'do_something_else',                                                // 457
                          params: ['monday'], id: message2.id});                                                     // 458
                                                                                                                     // 459
    // get the first data satisfied message. changes are applied to database even                                    // 460
    // though another method is outstanding, because the other method didn't have                                    // 461
    // a stub. and its callback is called.                                                                           // 462
    stream.receive({msg: 'updated', 'methods': [message.id]});                                                       // 463
    test.isTrue(callback1Fired);                                                                                     // 464
    test.isFalse(callback2Fired);                                                                                    // 465
                                                                                                                     // 466
    test.equal(coll.find({}).count(), 1);                                                                            // 467
    test.equal(coll.find({value: 'tuesday'}).count(), 1);                                                            // 468
    test.equal(counts, {added: 1, removed: 0, changed: 1, moved: 0});                                                // 469
                                                                                                                     // 470
    // second result                                                                                                 // 471
    stream.receive({msg: 'result', id:message2.id, result:"bupkis"});                                                // 472
    test.isFalse(callback2Fired);                                                                                    // 473
                                                                                                                     // 474
    // get second satisfied; no new changes are applied.                                                             // 475
    stream.receive({msg: 'updated', 'methods': [message2.id]});                                                      // 476
    test.isTrue(callback2Fired);                                                                                     // 477
                                                                                                                     // 478
    test.equal(coll.find({}).count(), 1);                                                                            // 479
    test.equal(coll.find({value: 'tuesday', _id: docId}).count(), 1);                                                // 480
    test.equal(counts, {added: 1, removed: 0, changed: 1, moved: 0});                                                // 481
                                                                                                                     // 482
    handle.stop();                                                                                                   // 483
  });                                                                                                                // 484
}                                                                                                                    // 485
                                                                                                                     // 486
Tinytest.add("livedata stub - mutating method args", function (test) {                                               // 487
  var stream = new StubStream();                                                                                     // 488
  var conn = newConnection(stream);                                                                                  // 489
                                                                                                                     // 490
  startAndConnect(test, stream);                                                                                     // 491
                                                                                                                     // 492
  conn.methods({mutateArgs: function (arg) {                                                                         // 493
    arg.foo = 42;                                                                                                    // 494
  }});                                                                                                               // 495
                                                                                                                     // 496
  conn.call('mutateArgs', {foo: 50}, _.identity);                                                                    // 497
                                                                                                                     // 498
  // Method should be called with original arg, not mutated arg.                                                     // 499
  var message = JSON.parse(stream.sent.shift());                                                                     // 500
  test.isUndefined(message.randomSeed);                                                                              // 501
  test.equal(message, {msg: 'method', method: 'mutateArgs',                                                          // 502
                       params: [{foo: 50}], id: message.id});                                                        // 503
  test.length(stream.sent, 0);                                                                                       // 504
});                                                                                                                  // 505
                                                                                                                     // 506
var observeCursor = function (test, cursor) {                                                                        // 507
  var counts = {added: 0, removed: 0, changed: 0, moved: 0};                                                         // 508
  var expectedCounts = _.clone(counts);                                                                              // 509
  var handle = cursor.observe(                                                                                       // 510
    { addedAt: function () { counts.added += 1; },                                                                   // 511
      removedAt: function () { counts.removed += 1; },                                                               // 512
      changedAt: function () { counts.changed += 1; },                                                               // 513
      movedTo: function () { counts.moved += 1; }                                                                    // 514
    });                                                                                                              // 515
  return {                                                                                                           // 516
    stop: _.bind(handle.stop, handle),                                                                               // 517
    expectCallbacks: function (delta) {                                                                              // 518
      _.each(delta, function (mod, field) {                                                                          // 519
        expectedCounts[field] += mod;                                                                                // 520
      });                                                                                                            // 521
      test.equal(counts, expectedCounts);                                                                            // 522
    }                                                                                                                // 523
  };                                                                                                                 // 524
};                                                                                                                   // 525
                                                                                                                     // 526
// method calls another method in simulation. see not sent.                                                          // 527
if (Meteor.isClient) {                                                                                               // 528
  Tinytest.add("livedata stub - methods calling methods", function (test) {                                          // 529
    var stream = new StubStream();                                                                                   // 530
    var conn = newConnection(stream);                                                                                // 531
                                                                                                                     // 532
    startAndConnect(test, stream);                                                                                   // 533
                                                                                                                     // 534
    var coll_name = Random.id();                                                                                     // 535
    var coll = new Meteor.Collection(coll_name, {connection: conn});                                                 // 536
                                                                                                                     // 537
    // setup methods                                                                                                 // 538
    conn.methods({                                                                                                   // 539
      do_something: function () {                                                                                    // 540
        conn.call('do_something_else');                                                                              // 541
      },                                                                                                             // 542
      do_something_else: function () {                                                                               // 543
        coll.insert({a: 1});                                                                                         // 544
      }                                                                                                              // 545
    });                                                                                                              // 546
                                                                                                                     // 547
    var o = observeCursor(test, coll.find());                                                                        // 548
                                                                                                                     // 549
    // call method.                                                                                                  // 550
    conn.call('do_something', _.identity);                                                                           // 551
                                                                                                                     // 552
    // see we only send message for outer methods                                                                    // 553
    var message = testGotMessage(test, stream, {msg: 'method',                                                       // 554
                                                method: 'do_something',                                              // 555
                                                params: [],                                                          // 556
                                                id: '*',                                                             // 557
                                                randomSeed: '*'});                                                   // 558
    test.length(stream.sent, 0);                                                                                     // 559
                                                                                                                     // 560
    // but inner method runs locally.                                                                                // 561
    o.expectCallbacks({added: 1});                                                                                   // 562
    test.equal(coll.find().count(), 1);                                                                              // 563
    var docId = coll.findOne()._id;                                                                                  // 564
    test.equal(coll.findOne(), {_id: docId, a: 1});                                                                  // 565
                                                                                                                     // 566
    // we get the results                                                                                            // 567
    stream.receive({msg: 'result', id:message.id, result:"1234"});                                                   // 568
                                                                                                                     // 569
    // get data from the method. data from this doc does not show up yet, but data                                   // 570
    // from another doc does.                                                                                        // 571
    stream.receive({msg: 'added', collection: coll_name, id: LocalCollection._idStringify(docId),                    // 572
                    fields: {value: 'tuesday'}});                                                                    // 573
    o.expectCallbacks();                                                                                             // 574
    test.equal(coll.findOne(docId), {_id: docId, a: 1});                                                             // 575
    stream.receive({msg: 'added', collection: coll_name, id: 'monkey',                                               // 576
                    fields: {value: 'bla'}});                                                                        // 577
    o.expectCallbacks({added: 1});                                                                                   // 578
    test.equal(coll.findOne(docId), {_id: docId, a: 1});                                                             // 579
    var newDoc = coll.findOne({value: 'bla'});                                                                       // 580
    test.isTrue(newDoc);                                                                                             // 581
    test.equal(newDoc, {_id: newDoc._id, value: 'bla'});                                                             // 582
                                                                                                                     // 583
    // get method satisfied. all data shows up. the 'a' field is reverted and                                        // 584
    // 'value' field is set.                                                                                         // 585
    stream.receive({msg: 'updated', 'methods': [message.id]});                                                       // 586
    o.expectCallbacks({changed: 1});                                                                                 // 587
    test.equal(coll.findOne(docId), {_id: docId, value: 'tuesday'});                                                 // 588
    test.equal(coll.findOne(newDoc._id), {_id: newDoc._id, value: 'bla'});                                           // 589
                                                                                                                     // 590
    o.stop();                                                                                                        // 591
  });                                                                                                                // 592
}                                                                                                                    // 593
Tinytest.add("livedata stub - method call before connect", function (test) {                                         // 594
  var stream = new StubStream;                                                                                       // 595
  var conn = newConnection(stream);                                                                                  // 596
                                                                                                                     // 597
  var callbackOutput = [];                                                                                           // 598
  conn.call('someMethod', function (err, result) {                                                                   // 599
    callbackOutput.push(result);                                                                                     // 600
  });                                                                                                                // 601
  test.equal(callbackOutput, []);                                                                                    // 602
                                                                                                                     // 603
  // the real stream drops all output pre-connection                                                                 // 604
  stream.sent.length = 0;                                                                                            // 605
                                                                                                                     // 606
  // Now connect.                                                                                                    // 607
  stream.reset();                                                                                                    // 608
                                                                                                                     // 609
  testGotMessage(test, stream, makeConnectMessage());                                                                // 610
  testGotMessage(test, stream, {msg: 'method', method: 'someMethod',                                                 // 611
                                params: [], id: '*'});                                                               // 612
});                                                                                                                  // 613
                                                                                                                     // 614
Tinytest.add("livedata stub - reconnect", function (test) {                                                          // 615
  var stream = new StubStream();                                                                                     // 616
  var conn = newConnection(stream);                                                                                  // 617
                                                                                                                     // 618
  startAndConnect(test, stream);                                                                                     // 619
                                                                                                                     // 620
  var collName = Random.id();                                                                                        // 621
  var coll = new Meteor.Collection(collName, {connection: conn});                                                    // 622
                                                                                                                     // 623
  var o = observeCursor(test, coll.find());                                                                          // 624
                                                                                                                     // 625
  // subscribe                                                                                                       // 626
  var subCallbackFired = false;                                                                                      // 627
  var sub = conn.subscribe('my_data', function () {                                                                  // 628
    subCallbackFired = true;                                                                                         // 629
  });                                                                                                                // 630
  test.isFalse(subCallbackFired);                                                                                    // 631
                                                                                                                     // 632
  var subMessage = JSON.parse(stream.sent.shift());                                                                  // 633
  test.equal(subMessage, {msg: 'sub', name: 'my_data', params: [],                                                   // 634
                          id: subMessage.id});                                                                       // 635
                                                                                                                     // 636
  // get some data. it shows up.                                                                                     // 637
  stream.receive({msg: 'added', collection: collName,                                                                // 638
                  id: '1234', fields: {a:1}});                                                                       // 639
                                                                                                                     // 640
  test.equal(coll.find({}).count(), 1);                                                                              // 641
  o.expectCallbacks({added: 1});                                                                                     // 642
  test.isFalse(subCallbackFired);                                                                                    // 643
                                                                                                                     // 644
  stream.receive({msg: 'changed', collection: collName,                                                              // 645
                  id: '1234', fields: {b:2}});                                                                       // 646
  stream.receive({msg: 'ready',                                                                                      // 647
                  subs: [subMessage.id] // satisfy sub                                                               // 648
                 });                                                                                                 // 649
  test.isTrue(subCallbackFired);                                                                                     // 650
  subCallbackFired = false; // re-arm for test that it doesn't fire again.                                           // 651
                                                                                                                     // 652
  test.equal(coll.find({a:1, b:2}).count(), 1);                                                                      // 653
  o.expectCallbacks({changed: 1});                                                                                   // 654
                                                                                                                     // 655
  // call method.                                                                                                    // 656
  var methodCallbackFired = false;                                                                                   // 657
  conn.call('do_something', function () {                                                                            // 658
    methodCallbackFired = true;                                                                                      // 659
  });                                                                                                                // 660
                                                                                                                     // 661
  conn.apply('do_something_else', [], {wait: true}, _.identity);                                                     // 662
  conn.apply('do_something_later', [], _.identity);                                                                  // 663
                                                                                                                     // 664
  test.isFalse(methodCallbackFired);                                                                                 // 665
                                                                                                                     // 666
  // The non-wait method should send, but not the wait method.                                                       // 667
  var methodMessage = JSON.parse(stream.sent.shift());                                                               // 668
  test.isUndefined(methodMessage.randomSeed);                                                                        // 669
  test.equal(methodMessage, {msg: 'method', method: 'do_something',                                                  // 670
                             params: [], id:methodMessage.id});                                                      // 671
  test.equal(stream.sent.length, 0);                                                                                 // 672
                                                                                                                     // 673
  // more data. shows up immediately because there was no relevant method stub.                                      // 674
  stream.receive({msg: 'changed', collection: collName,                                                              // 675
                  id: '1234', fields: {c:3}});                                                                       // 676
  test.equal(coll.findOne('1234'), {_id: '1234', a: 1, b: 2, c: 3});                                                 // 677
  o.expectCallbacks({changed: 1});                                                                                   // 678
                                                                                                                     // 679
  // stream reset. reconnect!  we send a connect, our pending method, and our                                        // 680
  // sub. The wait method still is blocked.                                                                          // 681
  stream.reset();                                                                                                    // 682
                                                                                                                     // 683
  testGotMessage(test, stream, makeConnectMessage(SESSION_ID));                                                      // 684
  testGotMessage(test, stream, methodMessage);                                                                       // 685
  testGotMessage(test, stream, subMessage);                                                                          // 686
                                                                                                                     // 687
  // reconnect with different session id                                                                             // 688
  stream.receive({msg: 'connected', session: SESSION_ID + 1});                                                       // 689
                                                                                                                     // 690
  // resend data. doesn't show up: we're in reconnect quiescence.                                                    // 691
  stream.receive({msg: 'added', collection: collName,                                                                // 692
                  id: '1234', fields: {a:1, b:2, c:3, d: 4}});                                                       // 693
  stream.receive({msg: 'added', collection: collName,                                                                // 694
                  id: '2345', fields: {e: 5}});                                                                      // 695
  test.equal(coll.findOne('1234'), {_id: '1234', a: 1, b: 2, c: 3});                                                 // 696
  test.isFalse(coll.findOne('2345'));                                                                                // 697
  o.expectCallbacks();                                                                                               // 698
                                                                                                                     // 699
  // satisfy and return the method                                                                                   // 700
  stream.receive({msg: 'updated',                                                                                    // 701
                  methods: [methodMessage.id]});                                                                     // 702
  test.isFalse(methodCallbackFired);                                                                                 // 703
  stream.receive({msg: 'result', id:methodMessage.id, result:"bupkis"});                                             // 704
  // The callback still doesn't fire (and we don't send the wait method): we're                                      // 705
  // still in global quiescence                                                                                      // 706
  test.isFalse(methodCallbackFired);                                                                                 // 707
  test.equal(stream.sent.length, 0);                                                                                 // 708
                                                                                                                     // 709
  // still no update.                                                                                                // 710
  test.equal(coll.findOne('1234'), {_id: '1234', a: 1, b: 2, c: 3});                                                 // 711
  test.isFalse(coll.findOne('2345'));                                                                                // 712
  o.expectCallbacks();                                                                                               // 713
                                                                                                                     // 714
  // re-satisfy sub                                                                                                  // 715
  stream.receive({msg: 'ready', subs: [subMessage.id]});                                                             // 716
                                                                                                                     // 717
  // now the doc changes and method callback is called, and the wait method is                                       // 718
  // sent. the sub callback isn't re-called.                                                                         // 719
  test.isTrue(methodCallbackFired);                                                                                  // 720
  test.isFalse(subCallbackFired);                                                                                    // 721
  test.equal(coll.findOne('1234'), {_id: '1234', a: 1, b: 2, c: 3, d: 4});                                           // 722
  test.equal(coll.findOne('2345'), {_id: '2345', e: 5});                                                             // 723
  o.expectCallbacks({added: 1, changed: 1});                                                                         // 724
                                                                                                                     // 725
  var waitMethodMessage = JSON.parse(stream.sent.shift());                                                           // 726
  test.isUndefined(waitMethodMessage.randomSeed);                                                                    // 727
  test.equal(waitMethodMessage, {msg: 'method', method: 'do_something_else',                                         // 728
                                 params: [], id: waitMethodMessage.id});                                             // 729
  test.equal(stream.sent.length, 0);                                                                                 // 730
  stream.receive({msg: 'result', id: waitMethodMessage.id, result: "bupkis"});                                       // 731
  test.equal(stream.sent.length, 0);                                                                                 // 732
  stream.receive({msg: 'updated', methods: [waitMethodMessage.id]});                                                 // 733
                                                                                                                     // 734
  // wait method done means we can send the third method                                                             // 735
  test.equal(stream.sent.length, 1);                                                                                 // 736
  var laterMethodMessage = JSON.parse(stream.sent.shift());                                                          // 737
  test.isUndefined(laterMethodMessage.randomSeed);                                                                   // 738
  test.equal(laterMethodMessage, {msg: 'method', method: 'do_something_later',                                       // 739
                                  params: [], id: laterMethodMessage.id});                                           // 740
                                                                                                                     // 741
  o.stop();                                                                                                          // 742
});                                                                                                                  // 743
                                                                                                                     // 744
                                                                                                                     // 745
if (Meteor.isClient) {                                                                                               // 746
  Tinytest.add("livedata stub - reconnect method which only got result", function (test) {                           // 747
    var stream = new StubStream;                                                                                     // 748
    var conn = newConnection(stream);                                                                                // 749
    startAndConnect(test, stream);                                                                                   // 750
                                                                                                                     // 751
    var collName = Random.id();                                                                                      // 752
    var coll = new Meteor.Collection(collName, {connection: conn});                                                  // 753
    var o = observeCursor(test, coll.find());                                                                        // 754
                                                                                                                     // 755
    conn.methods({writeSomething: function () {                                                                      // 756
      // stub write                                                                                                  // 757
      coll.insert({foo: 'bar'});                                                                                     // 758
    }});                                                                                                             // 759
                                                                                                                     // 760
    test.equal(coll.find({foo: 'bar'}).count(), 0);                                                                  // 761
                                                                                                                     // 762
    // Call a method. We'll get the result but not data-done before reconnect.                                       // 763
    var callbackOutput = [];                                                                                         // 764
    var onResultReceivedOutput = [];                                                                                 // 765
    conn.apply('writeSomething', [],                                                                                 // 766
               {onResultReceived: function (err, result) {                                                           // 767
                 onResultReceivedOutput.push(result);                                                                // 768
               }},                                                                                                   // 769
               function (err, result) {                                                                              // 770
                 callbackOutput.push(result);                                                                        // 771
               });                                                                                                   // 772
    // Stub write is visible.                                                                                        // 773
    test.equal(coll.find({foo: 'bar'}).count(), 1);                                                                  // 774
    var stubWrittenId = coll.findOne({foo: 'bar'})._id;                                                              // 775
    o.expectCallbacks({added: 1});                                                                                   // 776
    // Callback not called.                                                                                          // 777
    test.equal(callbackOutput, []);                                                                                  // 778
    test.equal(onResultReceivedOutput, []);                                                                          // 779
    // Method sent.                                                                                                  // 780
    var methodId = testGotMessage(                                                                                   // 781
      test, stream, {msg: 'method', method: 'writeSomething',                                                        // 782
                     params: [], id: '*', randomSeed: '*'}).id;                                                      // 783
    test.equal(stream.sent.length, 0);                                                                               // 784
                                                                                                                     // 785
    // Get some data.                                                                                                // 786
    stream.receive({msg: 'added', collection: collName,                                                              // 787
                    id: LocalCollection._idStringify(stubWrittenId), fields: {baz: 42}});                            // 788
    // It doesn't show up yet.                                                                                       // 789
    test.equal(coll.find().count(), 1);                                                                              // 790
    test.equal(coll.findOne(stubWrittenId), {_id: stubWrittenId, foo: 'bar'});                                       // 791
    o.expectCallbacks();                                                                                             // 792
                                                                                                                     // 793
    // Get the result.                                                                                               // 794
    stream.receive({msg: 'result', id: methodId, result: 'bla'});                                                    // 795
    // Data unaffected.                                                                                              // 796
    test.equal(coll.find().count(), 1);                                                                              // 797
    test.equal(coll.findOne(stubWrittenId), {_id: stubWrittenId, foo: 'bar'});                                       // 798
    o.expectCallbacks();                                                                                             // 799
    // Callback not called, but onResultReceived is.                                                                 // 800
    test.equal(callbackOutput, []);                                                                                  // 801
    test.equal(onResultReceivedOutput, ['bla']);                                                                     // 802
                                                                                                                     // 803
    // Reset stream. Method does NOT get resent, because its result is already                                       // 804
    // in. Reconnect quiescence happens as soon as 'connected' is received because                                   // 805
    // there are no pending methods or subs in need of revival.                                                      // 806
    stream.reset();                                                                                                  // 807
    testGotMessage(test, stream, makeConnectMessage(SESSION_ID));                                                    // 808
    // Still holding out hope for session resumption, so nothing updated yet.                                        // 809
    test.equal(coll.find().count(), 1);                                                                              // 810
    test.equal(coll.findOne(stubWrittenId), {_id: stubWrittenId, foo: 'bar'});                                       // 811
    o.expectCallbacks();                                                                                             // 812
    test.equal(callbackOutput, []);                                                                                  // 813
                                                                                                                     // 814
    // Receive 'connected': time for reconnect quiescence! Data gets updated                                         // 815
    // locally (ie, data is reset) and callback gets called.                                                         // 816
    stream.receive({msg: 'connected', session: SESSION_ID + 1});                                                     // 817
    test.equal(coll.find().count(), 0);                                                                              // 818
    o.expectCallbacks({removed: 1});                                                                                 // 819
    test.equal(callbackOutput, ['bla']);                                                                             // 820
    test.equal(onResultReceivedOutput, ['bla']);                                                                     // 821
    stream.receive({msg: 'added', collection: collName,                                                              // 822
                    id: LocalCollection._idStringify(stubWrittenId), fields: {baz: 42}});                            // 823
    test.equal(coll.findOne(stubWrittenId), {_id: stubWrittenId, baz: 42});                                          // 824
    o.expectCallbacks({added: 1});                                                                                   // 825
                                                                                                                     // 826
                                                                                                                     // 827
                                                                                                                     // 828
                                                                                                                     // 829
    // Run method again. We're going to do the same thing this time, except we're                                    // 830
    // also going to use an onReconnect to insert another method at reconnect                                        // 831
    // time, which will delay reconnect quiescence.                                                                  // 832
    conn.apply('writeSomething', [],                                                                                 // 833
               {onResultReceived: function (err, result) {                                                           // 834
                 onResultReceivedOutput.push(result);                                                                // 835
               }},                                                                                                   // 836
               function (err, result) {                                                                              // 837
                 callbackOutput.push(result);                                                                        // 838
               });                                                                                                   // 839
    // Stub write is visible.                                                                                        // 840
    test.equal(coll.find({foo: 'bar'}).count(), 1);                                                                  // 841
    var stubWrittenId2 = coll.findOne({foo: 'bar'})._id;                                                             // 842
    o.expectCallbacks({added: 1});                                                                                   // 843
    // Callback not called.                                                                                          // 844
    test.equal(callbackOutput, ['bla']);                                                                             // 845
    test.equal(onResultReceivedOutput, ['bla']);                                                                     // 846
    // Method sent.                                                                                                  // 847
    var methodId2 = testGotMessage(                                                                                  // 848
      test, stream, {msg: 'method', method: 'writeSomething',                                                        // 849
                     params: [], id: '*', randomSeed: '*'}).id;                                                      // 850
    test.equal(stream.sent.length, 0);                                                                               // 851
                                                                                                                     // 852
    // Get some data.                                                                                                // 853
    stream.receive({msg: 'added', collection: collName,                                                              // 854
                    id: LocalCollection._idStringify(stubWrittenId2), fields: {baz: 42}});                           // 855
    // It doesn't show up yet.                                                                                       // 856
    test.equal(coll.find().count(), 2);                                                                              // 857
    test.equal(coll.findOne(stubWrittenId2), {_id: stubWrittenId2, foo: 'bar'});                                     // 858
    o.expectCallbacks();                                                                                             // 859
                                                                                                                     // 860
    // Get the result.                                                                                               // 861
    stream.receive({msg: 'result', id: methodId2, result: 'blab'});                                                  // 862
    // Data unaffected.                                                                                              // 863
    test.equal(coll.find().count(), 2);                                                                              // 864
    test.equal(coll.findOne(stubWrittenId2), {_id: stubWrittenId2, foo: 'bar'});                                     // 865
    o.expectCallbacks();                                                                                             // 866
    // Callback not called, but onResultReceived is.                                                                 // 867
    test.equal(callbackOutput, ['bla']);                                                                             // 868
    test.equal(onResultReceivedOutput, ['bla', 'blab']);                                                             // 869
    conn.onReconnect = function () {                                                                                 // 870
      conn.call('slowMethod', function (err, result) {                                                               // 871
        callbackOutput.push(result);                                                                                 // 872
      });                                                                                                            // 873
    };                                                                                                               // 874
                                                                                                                     // 875
    // Reset stream. Method does NOT get resent, because its result is already in,                                   // 876
    // but slowMethod gets called via onReconnect. Reconnect quiescence is now                                       // 877
    // blocking on slowMethod.                                                                                       // 878
    stream.reset();                                                                                                  // 879
    testGotMessage(test, stream, makeConnectMessage(SESSION_ID + 1));                                                // 880
    var slowMethodId = testGotMessage(                                                                               // 881
      test, stream,                                                                                                  // 882
      {msg: 'method', method: 'slowMethod', params: [], id: '*'}).id;                                                // 883
    // Still holding out hope for session resumption, so nothing updated yet.                                        // 884
    test.equal(coll.find().count(), 2);                                                                              // 885
    test.equal(coll.findOne(stubWrittenId2), {_id: stubWrittenId2, foo: 'bar'});                                     // 886
    o.expectCallbacks();                                                                                             // 887
    test.equal(callbackOutput, ['bla']);                                                                             // 888
                                                                                                                     // 889
    // Receive 'connected'... but no reconnect quiescence yet due to slowMethod.                                     // 890
    stream.receive({msg: 'connected', session: SESSION_ID + 2});                                                     // 891
    test.equal(coll.find().count(), 2);                                                                              // 892
    test.equal(coll.findOne(stubWrittenId2), {_id: stubWrittenId2, foo: 'bar'});                                     // 893
    o.expectCallbacks();                                                                                             // 894
    test.equal(callbackOutput, ['bla']);                                                                             // 895
                                                                                                                     // 896
    // Receive data matching our stub. It doesn't take effect yet.                                                   // 897
    stream.receive({msg: 'added', collection: collName,                                                              // 898
                    id: LocalCollection._idStringify(stubWrittenId2), fields: {foo: 'bar'}});                        // 899
    o.expectCallbacks();                                                                                             // 900
                                                                                                                     // 901
    // slowMethod is done writing, so we get full reconnect quiescence (but no                                       // 902
    // slowMethod callback)... ie, a reset followed by applying the data we just                                     // 903
    // got, as well as calling the callback from the method that half-finished                                       // 904
    // before reset. The net effect is deleting doc 'stubWrittenId'.                                                 // 905
    stream.receive({msg: 'updated', methods: [slowMethodId]});                                                       // 906
    test.equal(coll.find().count(), 1);                                                                              // 907
    test.equal(coll.findOne(stubWrittenId2), {_id: stubWrittenId2, foo: 'bar'});                                     // 908
    o.expectCallbacks({removed: 1});                                                                                 // 909
    test.equal(callbackOutput, ['bla', 'blab']);                                                                     // 910
                                                                                                                     // 911
    // slowMethod returns a value now.                                                                               // 912
    stream.receive({msg: 'result', id: slowMethodId, result: 'slow'});                                               // 913
    o.expectCallbacks();                                                                                             // 914
    test.equal(callbackOutput, ['bla', 'blab', 'slow']);                                                             // 915
                                                                                                                     // 916
    o.stop();                                                                                                        // 917
  });                                                                                                                // 918
}                                                                                                                    // 919
Tinytest.add("livedata stub - reconnect method which only got data", function (test) {                               // 920
  var stream = new StubStream;                                                                                       // 921
  var conn = newConnection(stream);                                                                                  // 922
  startAndConnect(test, stream);                                                                                     // 923
                                                                                                                     // 924
  var collName = Random.id();                                                                                        // 925
  var coll = new Meteor.Collection(collName, {connection: conn});                                                    // 926
  var o = observeCursor(test, coll.find());                                                                          // 927
                                                                                                                     // 928
  // Call a method. We'll get the data-done message but not the result before                                        // 929
  // reconnect.                                                                                                      // 930
  var callbackOutput = [];                                                                                           // 931
  var onResultReceivedOutput = [];                                                                                   // 932
  conn.apply('doLittle', [],                                                                                         // 933
             {onResultReceived: function (err, result) {                                                             // 934
               onResultReceivedOutput.push(result);                                                                  // 935
             }},                                                                                                     // 936
             function (err, result) {                                                                                // 937
               callbackOutput.push(result);                                                                          // 938
             });                                                                                                     // 939
  // Callbacks not called.                                                                                           // 940
  test.equal(callbackOutput, []);                                                                                    // 941
  test.equal(onResultReceivedOutput, []);                                                                            // 942
  // Method sent.                                                                                                    // 943
  var methodId = testGotMessage(                                                                                     // 944
    test, stream, {msg: 'method', method: 'doLittle',                                                                // 945
                   params: [], id: '*'}).id;                                                                         // 946
  test.equal(stream.sent.length, 0);                                                                                 // 947
                                                                                                                     // 948
  // Get some data.                                                                                                  // 949
  stream.receive({msg: 'added', collection: collName,                                                                // 950
                  id: 'photo', fields: {baz: 42}});                                                                  // 951
  // It shows up instantly because the stub didn't write anything.                                                   // 952
  test.equal(coll.find().count(), 1);                                                                                // 953
  test.equal(coll.findOne('photo'), {_id: 'photo', baz: 42});                                                        // 954
  o.expectCallbacks({added: 1});                                                                                     // 955
                                                                                                                     // 956
  // Get the data-done message.                                                                                      // 957
  stream.receive({msg: 'updated', methods: [methodId]});                                                             // 958
  // Data still here.                                                                                                // 959
  test.equal(coll.find().count(), 1);                                                                                // 960
  test.equal(coll.findOne('photo'), {_id: 'photo', baz: 42});                                                        // 961
  o.expectCallbacks();                                                                                               // 962
  // Method callback not called yet (no result yet).                                                                 // 963
  test.equal(callbackOutput, []);                                                                                    // 964
  test.equal(onResultReceivedOutput, []);                                                                            // 965
                                                                                                                     // 966
  // Reset stream. Method gets resent (with same ID), and blocks reconnect                                           // 967
  // quiescence.                                                                                                     // 968
  stream.reset();                                                                                                    // 969
  testGotMessage(test, stream, makeConnectMessage(SESSION_ID));                                                      // 970
  testGotMessage(                                                                                                    // 971
    test, stream, {msg: 'method', method: 'doLittle',                                                                // 972
                   params: [], id: methodId});                                                                       // 973
  // Still holding out hope for session resumption, so nothing updated yet.                                          // 974
  test.equal(coll.find().count(), 1);                                                                                // 975
  test.equal(coll.findOne('photo'), {_id: 'photo', baz: 42});                                                        // 976
  o.expectCallbacks();                                                                                               // 977
  test.equal(callbackOutput, []);                                                                                    // 978
  test.equal(onResultReceivedOutput, []);                                                                            // 979
                                                                                                                     // 980
  // Receive 'connected'. Still blocking on reconnect quiescence.                                                    // 981
  stream.receive({msg: 'connected', session: SESSION_ID + 1});                                                       // 982
  test.equal(coll.find().count(), 1);                                                                                // 983
  test.equal(coll.findOne('photo'), {_id: 'photo', baz: 42});                                                        // 984
  o.expectCallbacks();                                                                                               // 985
  test.equal(callbackOutput, []);                                                                                    // 986
  test.equal(onResultReceivedOutput, []);                                                                            // 987
                                                                                                                     // 988
  // Receive method result. onResultReceived is called but the main callback                                         // 989
  // isn't (ie, we don't get confused by the fact that we got data-done the                                          // 990
  // *FIRST* time through).                                                                                          // 991
  stream.receive({msg: 'result', id: methodId, result: 'res'});                                                      // 992
  test.equal(callbackOutput, []);                                                                                    // 993
  test.equal(onResultReceivedOutput, ['res']);                                                                       // 994
                                                                                                                     // 995
  // Now we get data-done. Collection is reset and callback is called.                                               // 996
  stream.receive({msg: 'updated', methods: [methodId]});                                                             // 997
  test.equal(coll.find().count(), 0);                                                                                // 998
  o.expectCallbacks({removed: 1});                                                                                   // 999
  test.equal(callbackOutput, ['res']);                                                                               // 1000
  test.equal(onResultReceivedOutput, ['res']);                                                                       // 1001
                                                                                                                     // 1002
  o.stop();                                                                                                          // 1003
});                                                                                                                  // 1004
if (Meteor.isClient) {                                                                                               // 1005
  Tinytest.add("livedata stub - multiple stubs same doc", function (test) {                                          // 1006
    var stream = new StubStream;                                                                                     // 1007
    var conn = newConnection(stream);                                                                                // 1008
    startAndConnect(test, stream);                                                                                   // 1009
                                                                                                                     // 1010
    var collName = Random.id();                                                                                      // 1011
    var coll = new Meteor.Collection(collName, {connection: conn});                                                  // 1012
    var o = observeCursor(test, coll.find());                                                                        // 1013
                                                                                                                     // 1014
    conn.methods({                                                                                                   // 1015
      insertSomething: function () {                                                                                 // 1016
        // stub write                                                                                                // 1017
        coll.insert({foo: 'bar'});                                                                                   // 1018
      },                                                                                                             // 1019
      updateIt: function (id) {                                                                                      // 1020
        coll.update(id, {$set: {baz: 42}});                                                                          // 1021
      }                                                                                                              // 1022
    });                                                                                                              // 1023
                                                                                                                     // 1024
    test.equal(coll.find().count(), 0);                                                                              // 1025
                                                                                                                     // 1026
    // Call the insert method.                                                                                       // 1027
    conn.call('insertSomething', _.identity);                                                                        // 1028
    // Stub write is visible.                                                                                        // 1029
    test.equal(coll.find({foo: 'bar'}).count(), 1);                                                                  // 1030
    var stubWrittenId = coll.findOne({foo: 'bar'})._id;                                                              // 1031
    o.expectCallbacks({added: 1});                                                                                   // 1032
    // Method sent.                                                                                                  // 1033
    var insertMethodId = testGotMessage(                                                                             // 1034
      test, stream, {msg: 'method', method: 'insertSomething',                                                       // 1035
                     params: [], id: '*', randomSeed: '*'}).id;                                                      // 1036
    test.equal(stream.sent.length, 0);                                                                               // 1037
                                                                                                                     // 1038
    // Call update method.                                                                                           // 1039
    conn.call('updateIt', stubWrittenId, _.identity);                                                                // 1040
    // This stub write is visible too.                                                                               // 1041
    test.equal(coll.find().count(), 1);                                                                              // 1042
    test.equal(coll.findOne(stubWrittenId),                                                                          // 1043
               {_id: stubWrittenId, foo: 'bar', baz: 42});                                                           // 1044
    o.expectCallbacks({changed: 1});                                                                                 // 1045
    // Method sent.                                                                                                  // 1046
    var updateMethodId = testGotMessage(                                                                             // 1047
      test, stream, {msg: 'method', method: 'updateIt',                                                              // 1048
                     params: [stubWrittenId], id: '*'}).id;                                                          // 1049
    test.equal(stream.sent.length, 0);                                                                               // 1050
                                                                                                                     // 1051
    // Get some data... slightly different than what we wrote.                                                       // 1052
    stream.receive({msg: 'added', collection: collName,                                                              // 1053
                    id: LocalCollection._idStringify(stubWrittenId), fields: {foo: 'barb', other: 'field',           // 1054
                                                                    other2: 'bla'}});                                // 1055
    // It doesn't show up yet.                                                                                       // 1056
    test.equal(coll.find().count(), 1);                                                                              // 1057
    test.equal(coll.findOne(stubWrittenId),                                                                          // 1058
               {_id: stubWrittenId, foo: 'bar', baz: 42});                                                           // 1059
    o.expectCallbacks();                                                                                             // 1060
                                                                                                                     // 1061
    // And get the first method-done. Still no updates to minimongo: we can't                                        // 1062
    // quiesce the doc until the second method is done.                                                              // 1063
    stream.receive({msg: 'updated', methods: [insertMethodId]});                                                     // 1064
    test.equal(coll.find().count(), 1);                                                                              // 1065
    test.equal(coll.findOne(stubWrittenId),                                                                          // 1066
               {_id: stubWrittenId, foo: 'bar', baz: 42});                                                           // 1067
    o.expectCallbacks();                                                                                             // 1068
                                                                                                                     // 1069
    // More data. Not quite what we wrote. Also ignored for now.                                                     // 1070
    stream.receive({msg: 'changed', collection: collName,                                                            // 1071
                    id: LocalCollection._idStringify(stubWrittenId), fields: {baz: 43}, cleared: ['other']});        // 1072
    test.equal(coll.find().count(), 1);                                                                              // 1073
    test.equal(coll.findOne(stubWrittenId),                                                                          // 1074
               {_id: stubWrittenId, foo: 'bar', baz: 42});                                                           // 1075
    o.expectCallbacks();                                                                                             // 1076
                                                                                                                     // 1077
    // Second data-ready. Now everything takes effect!                                                               // 1078
    stream.receive({msg: 'updated', methods: [updateMethodId]});                                                     // 1079
    test.equal(coll.find().count(), 1);                                                                              // 1080
    test.equal(coll.findOne(stubWrittenId),                                                                          // 1081
               {_id: stubWrittenId, foo: 'barb', other2: 'bla',                                                      // 1082
                baz: 43});                                                                                           // 1083
    o.expectCallbacks({changed: 1});                                                                                 // 1084
                                                                                                                     // 1085
    o.stop();                                                                                                        // 1086
  });                                                                                                                // 1087
}                                                                                                                    // 1088
                                                                                                                     // 1089
if (Meteor.isClient) {                                                                                               // 1090
  Tinytest.add("livedata stub - unsent methods don't block quiescence", function (test) {                            // 1091
    // This test is for https://github.com/meteor/meteor/issues/555                                                  // 1092
                                                                                                                     // 1093
    var stream = new StubStream;                                                                                     // 1094
    var conn = newConnection(stream);                                                                                // 1095
    startAndConnect(test, stream);                                                                                   // 1096
                                                                                                                     // 1097
    var collName = Random.id();                                                                                      // 1098
    var coll = new Meteor.Collection(collName, {connection: conn});                                                  // 1099
                                                                                                                     // 1100
    conn.methods({                                                                                                   // 1101
      insertSomething: function () {                                                                                 // 1102
        // stub write                                                                                                // 1103
        coll.insert({foo: 'bar'});                                                                                   // 1104
      }                                                                                                              // 1105
    });                                                                                                              // 1106
                                                                                                                     // 1107
    test.equal(coll.find().count(), 0);                                                                              // 1108
                                                                                                                     // 1109
    // Call a random method (no-op)                                                                                  // 1110
    conn.call('no-op', _.identity);                                                                                  // 1111
    // Call a wait method                                                                                            // 1112
    conn.apply('no-op', [], {wait: true}, _.identity);                                                               // 1113
    // Call a method with a stub that writes.                                                                        // 1114
    conn.call('insertSomething', _.identity);                                                                        // 1115
                                                                                                                     // 1116
                                                                                                                     // 1117
    // Stub write is visible.                                                                                        // 1118
    test.equal(coll.find({foo: 'bar'}).count(), 1);                                                                  // 1119
    var stubWrittenId = coll.findOne({foo: 'bar'})._id;                                                              // 1120
                                                                                                                     // 1121
    // first method sent                                                                                             // 1122
    var firstMethodId = testGotMessage(                                                                              // 1123
      test, stream, {msg: 'method', method: 'no-op',                                                                 // 1124
                     params: [], id: '*'}).id;                                                                       // 1125
    test.equal(stream.sent.length, 0);                                                                               // 1126
                                                                                                                     // 1127
    // ack the first method                                                                                          // 1128
    stream.receive({msg: 'updated', methods: [firstMethodId]});                                                      // 1129
    stream.receive({msg: 'result', id: firstMethodId});                                                              // 1130
                                                                                                                     // 1131
    // Wait method sent.                                                                                             // 1132
    var waitMethodId = testGotMessage(                                                                               // 1133
      test, stream, {msg: 'method', method: 'no-op',                                                                 // 1134
                     params: [], id: '*'}).id;                                                                       // 1135
    test.equal(stream.sent.length, 0);                                                                               // 1136
                                                                                                                     // 1137
    // ack the wait method                                                                                           // 1138
    stream.receive({msg: 'updated', methods: [waitMethodId]});                                                       // 1139
    stream.receive({msg: 'result', id: waitMethodId});                                                               // 1140
                                                                                                                     // 1141
    // insert method sent.                                                                                           // 1142
    var insertMethodId = testGotMessage(                                                                             // 1143
      test, stream, {msg: 'method', method: 'insertSomething',                                                       // 1144
                     params: [], id: '*', randomSeed: '*'}).id;                                                      // 1145
    test.equal(stream.sent.length, 0);                                                                               // 1146
                                                                                                                     // 1147
    // ack the insert method                                                                                         // 1148
    stream.receive({msg: 'updated', methods: [insertMethodId]});                                                     // 1149
    stream.receive({msg: 'result', id: insertMethodId});                                                             // 1150
                                                                                                                     // 1151
    // simulation reverted.                                                                                          // 1152
    test.equal(coll.find({foo: 'bar'}).count(), 0);                                                                  // 1153
                                                                                                                     // 1154
  });                                                                                                                // 1155
}                                                                                                                    // 1156
Tinytest.add("livedata stub - reactive resub", function (test) {                                                     // 1157
  var stream = new StubStream();                                                                                     // 1158
  var conn = newConnection(stream);                                                                                  // 1159
                                                                                                                     // 1160
  startAndConnect(test, stream);                                                                                     // 1161
                                                                                                                     // 1162
  var readiedSubs = {};                                                                                              // 1163
  var markAllReady = function () {                                                                                   // 1164
    // synthesize a "ready" message in response to any "sub"                                                         // 1165
    // message with an id we haven't seen before                                                                     // 1166
    _.each(stream.sent, function (msg) {                                                                             // 1167
      msg = JSON.parse(msg);                                                                                         // 1168
      if (msg.msg === 'sub' && ! _.has(readiedSubs, msg.id)) {                                                       // 1169
        stream.receive({msg: 'ready', subs: [msg.id]});                                                              // 1170
        readiedSubs[msg.id] = true;                                                                                  // 1171
      }                                                                                                              // 1172
    });                                                                                                              // 1173
  };                                                                                                                 // 1174
                                                                                                                     // 1175
  var fooArg = new ReactiveVar('A');                                                                                 // 1176
  var fooReady = 0;                                                                                                  // 1177
                                                                                                                     // 1178
  var inner;                                                                                                         // 1179
  var outer = Deps.autorun(function () {                                                                             // 1180
    inner = Deps.autorun(function () {                                                                               // 1181
      conn.subscribe("foo-sub", fooArg.get(),                                                                        // 1182
                     function () { fooReady++; });                                                                   // 1183
    });                                                                                                              // 1184
  });                                                                                                                // 1185
                                                                                                                     // 1186
  markAllReady();                                                                                                    // 1187
  test.equal(fooReady, 1);                                                                                           // 1188
                                                                                                                     // 1189
  // Rerun the inner autorun with different subscription                                                             // 1190
  // arguments.  Detect the re-sub via onReady.                                                                      // 1191
  fooArg.set('B');                                                                                                   // 1192
  test.isTrue(inner.invalidated);                                                                                    // 1193
  Deps.flush();                                                                                                      // 1194
  test.isFalse(inner.invalidated);                                                                                   // 1195
  markAllReady();                                                                                                    // 1196
  test.equal(fooReady, 2);                                                                                           // 1197
                                                                                                                     // 1198
  // Rerun inner again with same args; should be no re-sub.                                                          // 1199
  inner.invalidate();                                                                                                // 1200
  test.isTrue(inner.invalidated);                                                                                    // 1201
  Deps.flush();                                                                                                      // 1202
  test.isFalse(inner.invalidated);                                                                                   // 1203
  markAllReady();                                                                                                    // 1204
  test.equal(fooReady, 2);                                                                                           // 1205
                                                                                                                     // 1206
  // Rerun outer!  Should still be no re-sub even though                                                             // 1207
  // the inner computation is stopped and a new one is                                                               // 1208
  // started.                                                                                                        // 1209
  outer.invalidate();                                                                                                // 1210
  test.isTrue(inner.invalidated);                                                                                    // 1211
  Deps.flush();                                                                                                      // 1212
  test.isFalse(inner.invalidated);                                                                                   // 1213
  markAllReady();                                                                                                    // 1214
  test.equal(fooReady, 2);                                                                                           // 1215
                                                                                                                     // 1216
  // Change the subscription.  Now we should get an onReady.                                                         // 1217
  fooArg.set('C');                                                                                                   // 1218
  Deps.flush();                                                                                                      // 1219
  markAllReady();                                                                                                    // 1220
  test.equal(fooReady, 3);                                                                                           // 1221
});                                                                                                                  // 1222
                                                                                                                     // 1223
                                                                                                                     // 1224
                                                                                                                     // 1225
Tinytest.add("livedata connection - reactive userId", function (test) {                                              // 1226
  var stream = new StubStream();                                                                                     // 1227
  var conn = newConnection(stream);                                                                                  // 1228
                                                                                                                     // 1229
  test.equal(conn.userId(), null);                                                                                   // 1230
  conn.setUserId(1337);                                                                                              // 1231
  test.equal(conn.userId(), 1337);                                                                                   // 1232
});                                                                                                                  // 1233
                                                                                                                     // 1234
Tinytest.add("livedata connection - two wait methods", function (test) {                                             // 1235
  var stream = new StubStream();                                                                                     // 1236
  var conn = newConnection(stream);                                                                                  // 1237
  startAndConnect(test, stream);                                                                                     // 1238
                                                                                                                     // 1239
  var collName = Random.id();                                                                                        // 1240
  var coll = new Meteor.Collection(collName, {connection: conn});                                                    // 1241
                                                                                                                     // 1242
  // setup method                                                                                                    // 1243
  conn.methods({do_something: function (x) {}});                                                                     // 1244
                                                                                                                     // 1245
  var responses = [];                                                                                                // 1246
  conn.apply('do_something', ['one!'], function() { responses.push('one'); });                                       // 1247
  var one_message = JSON.parse(stream.sent.shift());                                                                 // 1248
  test.equal(one_message.params, ['one!']);                                                                          // 1249
                                                                                                                     // 1250
  conn.apply('do_something', ['two!'], {wait: true}, function() {                                                    // 1251
    responses.push('two');                                                                                           // 1252
  });                                                                                                                // 1253
  // 'two!' isn't sent yet, because it's a wait method.                                                              // 1254
  test.equal(stream.sent.length, 0);                                                                                 // 1255
                                                                                                                     // 1256
  conn.apply('do_something', ['three!'], function() {                                                                // 1257
    responses.push('three');                                                                                         // 1258
  });                                                                                                                // 1259
  conn.apply('do_something', ['four!'], function() {                                                                 // 1260
    responses.push('four');                                                                                          // 1261
  });                                                                                                                // 1262
                                                                                                                     // 1263
  conn.apply('do_something', ['five!'], {wait: true}, function() {                                                   // 1264
    responses.push('five');                                                                                          // 1265
  });                                                                                                                // 1266
                                                                                                                     // 1267
  conn.apply('do_something', ['six!'], function() { responses.push('six'); });                                       // 1268
                                                                                                                     // 1269
  // Verify that we did not send any more methods since we are still waiting on                                      // 1270
  // 'one!'.                                                                                                         // 1271
  test.equal(stream.sent.length, 0);                                                                                 // 1272
                                                                                                                     // 1273
  // Receive some data. "one" is not a wait method and there are no stubs, so it                                     // 1274
  // gets applied immediately.                                                                                       // 1275
  test.equal(coll.find().count(), 0);                                                                                // 1276
  stream.receive({msg: 'added', collection: collName,                                                                // 1277
                  id: 'foo', fields: {x: 1}});                                                                       // 1278
  test.equal(coll.find().count(), 1);                                                                                // 1279
  test.equal(coll.findOne('foo'), {_id: 'foo', x: 1});                                                               // 1280
                                                                                                                     // 1281
  // Let "one!" finish. Both messages are required to fire the callback.                                             // 1282
  stream.receive({msg: 'result', id: one_message.id});                                                               // 1283
  test.equal(responses, []);                                                                                         // 1284
  stream.receive({msg: 'updated', methods: [one_message.id]});                                                       // 1285
  test.equal(responses, ['one']);                                                                                    // 1286
                                                                                                                     // 1287
  // Now we've send out "two!".                                                                                      // 1288
  var two_message = JSON.parse(stream.sent.shift());                                                                 // 1289
  test.equal(two_message.params, ['two!']);                                                                          // 1290
                                                                                                                     // 1291
  // But still haven't sent "three!".                                                                                // 1292
  test.equal(stream.sent.length, 0);                                                                                 // 1293
                                                                                                                     // 1294
  // Receive more data. "two" is a wait method, so the data doesn't get applied                                      // 1295
  // yet.                                                                                                            // 1296
  stream.receive({msg: 'changed', collection: collName,                                                              // 1297
                  id: 'foo', fields: {y: 3}});                                                                       // 1298
  test.equal(coll.find().count(), 1);                                                                                // 1299
  test.equal(coll.findOne('foo'), {_id: 'foo', x: 1});                                                               // 1300
                                                                                                                     // 1301
  // Let "two!" finish, with its end messages in the opposite order to "one!".                                       // 1302
  stream.receive({msg: 'updated', methods: [two_message.id]});                                                       // 1303
  test.equal(responses, ['one']);                                                                                    // 1304
  test.equal(stream.sent.length, 0);                                                                                 // 1305
  // data-done message is enough to allow data to be written.                                                        // 1306
  test.equal(coll.find().count(), 1);                                                                                // 1307
  test.equal(coll.findOne('foo'), {_id: 'foo', x: 1, y: 3});                                                         // 1308
  stream.receive({msg: 'result', id: two_message.id});                                                               // 1309
  test.equal(responses, ['one', 'two']);                                                                             // 1310
                                                                                                                     // 1311
  // Verify that we just sent "three!" and "four!" now that we got                                                   // 1312
  // responses for "one!" and "two!"                                                                                 // 1313
  test.equal(stream.sent.length, 2);                                                                                 // 1314
  var three_message = JSON.parse(stream.sent.shift());                                                               // 1315
  test.equal(three_message.params, ['three!']);                                                                      // 1316
  var four_message = JSON.parse(stream.sent.shift());                                                                // 1317
  test.equal(four_message.params, ['four!']);                                                                        // 1318
                                                                                                                     // 1319
  // Out of order response is OK for non-wait methods.                                                               // 1320
  stream.receive({msg: 'result', id: three_message.id});                                                             // 1321
  stream.receive({msg: 'result', id: four_message.id});                                                              // 1322
  stream.receive({msg: 'updated', methods: [four_message.id]});                                                      // 1323
  test.equal(responses, ['one', 'two', 'four']);                                                                     // 1324
  test.equal(stream.sent.length, 0);                                                                                 // 1325
                                                                                                                     // 1326
  // Let three finish too.                                                                                           // 1327
  stream.receive({msg: 'updated', methods: [three_message.id]});                                                     // 1328
  test.equal(responses, ['one', 'two', 'four', 'three']);                                                            // 1329
                                                                                                                     // 1330
  // Verify that we just sent "five!" (the next wait method).                                                        // 1331
  test.equal(stream.sent.length, 1);                                                                                 // 1332
  var five_message = JSON.parse(stream.sent.shift());                                                                // 1333
  test.equal(five_message.params, ['five!']);                                                                        // 1334
  test.equal(responses, ['one', 'two', 'four', 'three']);                                                            // 1335
                                                                                                                     // 1336
  // Let five finish.                                                                                                // 1337
  stream.receive({msg: 'result', id: five_message.id});                                                              // 1338
  stream.receive({msg: 'updated', methods: [five_message.id]});                                                      // 1339
  test.equal(responses, ['one', 'two', 'four', 'three', 'five']);                                                    // 1340
                                                                                                                     // 1341
  var six_message = JSON.parse(stream.sent.shift());                                                                 // 1342
  test.equal(six_message.params, ['six!']);                                                                          // 1343
});                                                                                                                  // 1344
                                                                                                                     // 1345
Tinytest.add("livedata connection - onReconnect prepends messages correctly with a wait method", function(test) {    // 1346
  var stream = new StubStream();                                                                                     // 1347
  var conn = newConnection(stream);                                                                                  // 1348
  startAndConnect(test, stream);                                                                                     // 1349
                                                                                                                     // 1350
  // setup method                                                                                                    // 1351
  conn.methods({do_something: function (x) {}});                                                                     // 1352
                                                                                                                     // 1353
  conn.onReconnect = function() {                                                                                    // 1354
    conn.apply('do_something', ['reconnect zero'], _.identity);                                                      // 1355
    conn.apply('do_something', ['reconnect one'], _.identity);                                                       // 1356
    conn.apply('do_something', ['reconnect two'], {wait: true}, _.identity);                                         // 1357
    conn.apply('do_something', ['reconnect three'], _.identity);                                                     // 1358
  };                                                                                                                 // 1359
                                                                                                                     // 1360
  conn.apply('do_something', ['one'], _.identity);                                                                   // 1361
  conn.apply('do_something', ['two'], {wait: true}, _.identity);                                                     // 1362
  conn.apply('do_something', ['three'], _.identity);                                                                 // 1363
                                                                                                                     // 1364
  // reconnect                                                                                                       // 1365
  stream.sent = [];                                                                                                  // 1366
  stream.reset();                                                                                                    // 1367
  testGotMessage(test, stream, makeConnectMessage(conn._lastSessionId));                                             // 1368
                                                                                                                     // 1369
  // Test that we sent what we expect to send, and we're blocked on                                                  // 1370
  // what we expect to be blocked. The subsequent logic to correctly                                                 // 1371
  // read the wait flag is tested separately.                                                                        // 1372
  test.equal(_.map(stream.sent, function(msg) {                                                                      // 1373
    return JSON.parse(msg).params[0];                                                                                // 1374
  }), ['reconnect zero', 'reconnect one']);                                                                          // 1375
                                                                                                                     // 1376
  // white-box test:                                                                                                 // 1377
  test.equal(_.map(conn._outstandingMethodBlocks, function (block) {                                                 // 1378
    return [block.wait, _.map(block.methods, function (method) {                                                     // 1379
      return method._message.params[0];                                                                              // 1380
    })];                                                                                                             // 1381
  }), [                                                                                                              // 1382
    [false, ['reconnect zero', 'reconnect one']],                                                                    // 1383
    [true, ['reconnect two']],                                                                                       // 1384
    [false, ['reconnect three', 'one']],                                                                             // 1385
    [true, ['two']],                                                                                                 // 1386
    [false, ['three']]                                                                                               // 1387
  ]);                                                                                                                // 1388
});                                                                                                                  // 1389
                                                                                                                     // 1390
Tinytest.add("livedata connection - ping without id", function (test) {                                              // 1391
  var stream = new StubStream();                                                                                     // 1392
  var conn = newConnection(stream);                                                                                  // 1393
  startAndConnect(test, stream);                                                                                     // 1394
                                                                                                                     // 1395
  stream.receive({msg: 'ping'});                                                                                     // 1396
  testGotMessage(test, stream, {msg: 'pong'});                                                                       // 1397
});                                                                                                                  // 1398
                                                                                                                     // 1399
Tinytest.add("livedata connection - ping with id", function (test) {                                                 // 1400
  var stream = new StubStream();                                                                                     // 1401
  var conn = newConnection(stream);                                                                                  // 1402
  startAndConnect(test, stream);                                                                                     // 1403
                                                                                                                     // 1404
  var id = Random.id();                                                                                              // 1405
  stream.receive({msg: 'ping', id: id});                                                                             // 1406
  testGotMessage(test, stream, {msg: 'pong', id: id});                                                               // 1407
});                                                                                                                  // 1408
                                                                                                                     // 1409
var getSelfConnectionUrl = function () {                                                                             // 1410
  if (Meteor.isClient) {                                                                                             // 1411
    return Meteor._relativeToSiteRootUrl("/");                                                                       // 1412
  } else {                                                                                                           // 1413
    return Meteor.absoluteUrl();                                                                                     // 1414
  }                                                                                                                  // 1415
};                                                                                                                   // 1416
                                                                                                                     // 1417
if (Meteor.isServer) {                                                                                               // 1418
  Meteor.methods({                                                                                                   // 1419
    reverse: function (arg) {                                                                                        // 1420
      // Return something notably different from reverse.meteor.com.                                                 // 1421
      return arg.split("").reverse().join("") + " LOCAL";                                                            // 1422
    }                                                                                                                // 1423
  });                                                                                                                // 1424
}                                                                                                                    // 1425
                                                                                                                     // 1426
testAsyncMulti("livedata connection - reconnect to a different server", [                                            // 1427
  function (test, expect) {                                                                                          // 1428
    var self = this;                                                                                                 // 1429
    self.conn = DDP.connect("reverse.meteor.com");                                                                   // 1430
    pollUntil(expect, function () {                                                                                  // 1431
      return self.conn.status().connected;                                                                           // 1432
    }, 5000, 100, true); // poll until connected, but don't fail if we don't connect                                 // 1433
  },                                                                                                                 // 1434
  function (test, expect) {                                                                                          // 1435
    var self = this;                                                                                                 // 1436
    self.doTest = self.conn.status().connected;                                                                      // 1437
    if (self.doTest) {                                                                                               // 1438
      self.conn.call("reverse", "foo", expect(function (err, res) {                                                  // 1439
        test.equal(res, "oof");                                                                                      // 1440
      }));                                                                                                           // 1441
    }                                                                                                                // 1442
  },                                                                                                                 // 1443
  function (test, expect) {                                                                                          // 1444
    var self = this;                                                                                                 // 1445
    if (self.doTest) {                                                                                               // 1446
      self.conn.reconnect({url: getSelfConnectionUrl()});                                                            // 1447
      self.conn.call("reverse", "bar", expect(function (err, res) {                                                  // 1448
        test.equal(res, "rab LOCAL");                                                                                // 1449
      }));                                                                                                           // 1450
    }                                                                                                                // 1451
  }                                                                                                                  // 1452
]);                                                                                                                  // 1453
                                                                                                                     // 1454
Tinytest.addAsync("livedata connection - version negotiation requires renegotiating",                                // 1455
                  function (test, onComplete) {                                                                      // 1456
  var connection = new LivedataTest.Connection(getSelfConnectionUrl(), {                                             // 1457
    reloadWithOutstanding: true,                                                                                     // 1458
    supportedDDPVersions: ["garbled", LivedataTest.SUPPORTED_DDP_VERSIONS[0]],                                       // 1459
    onDDPVersionNegotiationFailure: function () { test.fail(); onComplete(); },                                      // 1460
    onConnected: function () {                                                                                       // 1461
      test.equal(connection._version, LivedataTest.SUPPORTED_DDP_VERSIONS[0]);                                       // 1462
      connection._stream.disconnect({_permanent: true});                                                             // 1463
      onComplete();                                                                                                  // 1464
    }                                                                                                                // 1465
  });                                                                                                                // 1466
});                                                                                                                  // 1467
                                                                                                                     // 1468
Tinytest.addAsync("livedata connection - version negotiation error",                                                 // 1469
                  function (test, onComplete) {                                                                      // 1470
  var connection = new LivedataTest.Connection(getSelfConnectionUrl(), {                                             // 1471
    reloadWithOutstanding: true,                                                                                     // 1472
    supportedDDPVersions: ["garbled", "more garbled"],                                                               // 1473
    onDDPVersionNegotiationFailure: function () {                                                                    // 1474
      test.equal(connection.status().status, "failed");                                                              // 1475
      test.matches(connection.status().reason, /DDP version negotiation failed/);                                    // 1476
      test.isFalse(connection.status().connected);                                                                   // 1477
      onComplete();                                                                                                  // 1478
    },                                                                                                               // 1479
    onConnected: function () {                                                                                       // 1480
      test.fail();                                                                                                   // 1481
      onComplete();                                                                                                  // 1482
    }                                                                                                                // 1483
  });                                                                                                                // 1484
});                                                                                                                  // 1485
                                                                                                                     // 1486
Tinytest.add("livedata connection - onReconnect prepends messages correctly without a wait method", function(test) { // 1487
  var stream = new StubStream();                                                                                     // 1488
  var conn = newConnection(stream);                                                                                  // 1489
  startAndConnect(test, stream);                                                                                     // 1490
                                                                                                                     // 1491
  // setup method                                                                                                    // 1492
  conn.methods({do_something: function (x) {}});                                                                     // 1493
                                                                                                                     // 1494
  conn.onReconnect = function() {                                                                                    // 1495
    conn.apply('do_something', ['reconnect one'], _.identity);                                                       // 1496
    conn.apply('do_something', ['reconnect two'], _.identity);                                                       // 1497
    conn.apply('do_something', ['reconnect three'], _.identity);                                                     // 1498
  };                                                                                                                 // 1499
                                                                                                                     // 1500
  conn.apply('do_something', ['one'], _.identity);                                                                   // 1501
  conn.apply('do_something', ['two'], {wait: true}, _.identity);                                                     // 1502
  conn.apply('do_something', ['three'], {wait: true}, _.identity);                                                   // 1503
  conn.apply('do_something', ['four'], _.identity);                                                                  // 1504
                                                                                                                     // 1505
  // reconnect                                                                                                       // 1506
  stream.sent = [];                                                                                                  // 1507
  stream.reset();                                                                                                    // 1508
  testGotMessage(test, stream, makeConnectMessage(conn._lastSessionId));                                             // 1509
                                                                                                                     // 1510
  // Test that we sent what we expect to send, and we're blocked on                                                  // 1511
  // what we expect to be blocked. The subsequent logic to correctly                                                 // 1512
  // read the wait flag is tested separately.                                                                        // 1513
  test.equal(_.map(stream.sent, function(msg) {                                                                      // 1514
    return JSON.parse(msg).params[0];                                                                                // 1515
  }), ['reconnect one', 'reconnect two', 'reconnect three', 'one']);                                                 // 1516
                                                                                                                     // 1517
  // white-box test:                                                                                                 // 1518
  test.equal(_.map(conn._outstandingMethodBlocks, function (block) {                                                 // 1519
    return [block.wait, _.map(block.methods, function (method) {                                                     // 1520
      return method._message.params[0];                                                                              // 1521
    })];                                                                                                             // 1522
  }), [                                                                                                              // 1523
    [false, ['reconnect one', 'reconnect two', 'reconnect three', 'one']],                                           // 1524
    [true, ['two']],                                                                                                 // 1525
    [true, ['three']],                                                                                               // 1526
    [false, ['four']]                                                                                                // 1527
  ]);                                                                                                                // 1528
});                                                                                                                  // 1529
                                                                                                                     // 1530
Tinytest.add("livedata connection - onReconnect with sent messages", function(test) {                                // 1531
  var stream = new StubStream();                                                                                     // 1532
  var conn = newConnection(stream);                                                                                  // 1533
  startAndConnect(test, stream);                                                                                     // 1534
                                                                                                                     // 1535
  // setup method                                                                                                    // 1536
  conn.methods({do_something: function (x) {}});                                                                     // 1537
                                                                                                                     // 1538
  conn.onReconnect = function() {                                                                                    // 1539
    conn.apply('do_something', ['login'], {wait: true}, _.identity);                                                 // 1540
  };                                                                                                                 // 1541
                                                                                                                     // 1542
  conn.apply('do_something', ['one'], _.identity);                                                                   // 1543
                                                                                                                     // 1544
  // initial connect                                                                                                 // 1545
  stream.sent = [];                                                                                                  // 1546
  stream.reset();                                                                                                    // 1547
  testGotMessage(                                                                                                    // 1548
    test, stream, makeConnectMessage(conn._lastSessionId));                                                          // 1549
                                                                                                                     // 1550
  // Test that we sent just the login message.                                                                       // 1551
  var loginId = testGotMessage(                                                                                      // 1552
    test, stream, {msg: 'method', method: 'do_something',                                                            // 1553
                   params: ['login'], id: '*'}).id;                                                                  // 1554
                                                                                                                     // 1555
  // we connect.                                                                                                     // 1556
  stream.receive({msg: 'connected', session: Random.id()});                                                          // 1557
  test.length(stream.sent, 0);                                                                                       // 1558
                                                                                                                     // 1559
  // login got result (but not yet data)                                                                             // 1560
  stream.receive({msg: 'result', id: loginId, result: 'foo'});                                                       // 1561
  test.length(stream.sent, 0);                                                                                       // 1562
                                                                                                                     // 1563
  // login got data. now we send next method.                                                                        // 1564
  stream.receive({msg: 'updated', methods: [loginId]});                                                              // 1565
                                                                                                                     // 1566
  testGotMessage(                                                                                                    // 1567
    test, stream, {msg: 'method', method: 'do_something',                                                            // 1568
                   params: ['one'], id: '*'}).id;                                                                    // 1569
});                                                                                                                  // 1570
                                                                                                                     // 1571
                                                                                                                     // 1572
                                                                                                                     // 1573
Tinytest.add("livedata stub - reconnect double wait method", function (test) {                                       // 1574
  var stream = new StubStream;                                                                                       // 1575
  var conn = newConnection(stream);                                                                                  // 1576
  startAndConnect(test, stream);                                                                                     // 1577
                                                                                                                     // 1578
  var output = [];                                                                                                   // 1579
  conn.onReconnect = function () {                                                                                   // 1580
    conn.apply('reconnectMethod', [], {wait: true}, function (err, result) {                                         // 1581
      output.push('reconnect');                                                                                      // 1582
    });                                                                                                              // 1583
  };                                                                                                                 // 1584
                                                                                                                     // 1585
  conn.apply('halfwayMethod', [], {wait: true}, function (err, result) {                                             // 1586
    output.push('halfway');                                                                                          // 1587
  });                                                                                                                // 1588
                                                                                                                     // 1589
  test.equal(output, []);                                                                                            // 1590
  // Method sent.                                                                                                    // 1591
  var halfwayId = testGotMessage(                                                                                    // 1592
    test, stream, {msg: 'method', method: 'halfwayMethod',                                                           // 1593
                   params: [], id: '*'}).id;                                                                         // 1594
  test.equal(stream.sent.length, 0);                                                                                 // 1595
                                                                                                                     // 1596
  // Get the result. This means it will not be resent.                                                               // 1597
  stream.receive({msg: 'result', id: halfwayId, result: 'bla'});                                                     // 1598
  // Callback not called.                                                                                            // 1599
  test.equal(output, []);                                                                                            // 1600
                                                                                                                     // 1601
  // Reset stream. halfwayMethod does NOT get resent, but reconnectMethod does!                                      // 1602
  // Reconnect quiescence happens when reconnectMethod is done.                                                      // 1603
  stream.reset();                                                                                                    // 1604
  testGotMessage(test, stream, makeConnectMessage(SESSION_ID));                                                      // 1605
  var reconnectId = testGotMessage(                                                                                  // 1606
    test, stream, {msg: 'method', method: 'reconnectMethod',                                                         // 1607
                   params: [], id: '*'}).id;                                                                         // 1608
  test.length(stream.sent, 0);                                                                                       // 1609
  // Still holding out hope for session resumption, so no callbacks yet.                                             // 1610
  test.equal(output, []);                                                                                            // 1611
                                                                                                                     // 1612
  // Receive 'connected', but reconnect quiescence is blocking on                                                    // 1613
  // reconnectMethod.                                                                                                // 1614
  stream.receive({msg: 'connected', session: SESSION_ID + 1});                                                       // 1615
  test.equal(output, []);                                                                                            // 1616
                                                                                                                     // 1617
  // Data-done for reconnectMethod. This gets us to reconnect quiescence, so                                         // 1618
  // halfwayMethod's callback fires. reconnectMethod's is still waiting on its                                       // 1619
  // result.                                                                                                         // 1620
  stream.receive({msg: 'updated', methods: [reconnectId]});                                                          // 1621
  test.equal(output.shift(), 'halfway');                                                                             // 1622
  test.equal(output, []);                                                                                            // 1623
                                                                                                                     // 1624
  // Get result of reconnectMethod. Its callback fires.                                                              // 1625
  stream.receive({msg: 'result', id: reconnectId, result: 'foo'});                                                   // 1626
  test.equal(output.shift(), 'reconnect');                                                                           // 1627
  test.equal(output, []);                                                                                            // 1628
                                                                                                                     // 1629
  // Call another method. It should be delivered immediately. This is a                                              // 1630
  // regression test for a case where it never got delivered because there was                                       // 1631
  // an empty block in _outstandingMethodBlocks blocking it from being sent.                                         // 1632
  conn.call('lastMethod', _.identity);                                                                               // 1633
  testGotMessage(test, stream,                                                                                       // 1634
                 {msg: 'method', method: 'lastMethod', params: [], id: '*'});                                        // 1635
});                                                                                                                  // 1636
                                                                                                                     // 1637
Tinytest.add("livedata stub - subscribe errors", function (test) {                                                   // 1638
  var stream = new StubStream();                                                                                     // 1639
  var conn = newConnection(stream);                                                                                  // 1640
                                                                                                                     // 1641
  startAndConnect(test, stream);                                                                                     // 1642
                                                                                                                     // 1643
  // subscribe                                                                                                       // 1644
  var onReadyFired = false;                                                                                          // 1645
  var subError = null;                                                                                               // 1646
  var sub = conn.subscribe('unknownSub', {                                                                           // 1647
    onReady: function () {                                                                                           // 1648
      onReadyFired = true;                                                                                           // 1649
    },                                                                                                               // 1650
    onError: function (error) {                                                                                      // 1651
      subError = error;                                                                                              // 1652
    }                                                                                                                // 1653
  });                                                                                                                // 1654
  test.isFalse(onReadyFired);                                                                                        // 1655
  test.equal(subError, null);                                                                                        // 1656
                                                                                                                     // 1657
  var subMessage = JSON.parse(stream.sent.shift());                                                                  // 1658
  test.equal(subMessage, {msg: 'sub', name: 'unknownSub', params: [],                                                // 1659
                          id: subMessage.id});                                                                       // 1660
                                                                                                                     // 1661
  // Reject the sub.                                                                                                 // 1662
  stream.receive({msg: 'nosub', id: subMessage.id,                                                                   // 1663
                  error: new Meteor.Error(404, "Subscription not found")});                                          // 1664
  test.isFalse(onReadyFired);                                                                                        // 1665
  test.instanceOf(subError, Meteor.Error);                                                                           // 1666
  test.equal(subError.error, 404);                                                                                   // 1667
  test.equal(subError.reason, "Subscription not found");                                                             // 1668
                                                                                                                     // 1669
  // stream reset: reconnect!                                                                                        // 1670
  stream.reset();                                                                                                    // 1671
  // We send a connect.                                                                                              // 1672
  testGotMessage(test, stream, makeConnectMessage(SESSION_ID));                                                      // 1673
  // We should NOT re-sub to the sub, because we processed the error.                                                // 1674
  test.length(stream.sent, 0);                                                                                       // 1675
  test.isFalse(onReadyFired);                                                                                        // 1676
});                                                                                                                  // 1677
                                                                                                                     // 1678
if (Meteor.isClient) {                                                                                               // 1679
  Tinytest.add("livedata stub - stubs before connected", function (test) {                                           // 1680
    var stream = new StubStream();                                                                                   // 1681
    var conn = newConnection(stream);                                                                                // 1682
                                                                                                                     // 1683
    var collName = Random.id();                                                                                      // 1684
    var coll = new Meteor.Collection(collName, {connection: conn});                                                  // 1685
                                                                                                                     // 1686
    // Start and send "connect", but DON'T get 'connected' quite yet.                                                // 1687
    stream.reset(); // initial connection start.                                                                     // 1688
                                                                                                                     // 1689
    testGotMessage(test, stream, makeConnectMessage());                                                              // 1690
    test.length(stream.sent, 0);                                                                                     // 1691
                                                                                                                     // 1692
    // Insert a document. The stub updates "conn" directly.                                                          // 1693
    coll.insert({_id: "foo", bar: 42}, _.identity);                                                                  // 1694
    test.equal(coll.find().count(), 1);                                                                              // 1695
    test.equal(coll.findOne(), {_id: "foo", bar: 42});                                                               // 1696
    // It also sends the method message.                                                                             // 1697
    var methodMessage = JSON.parse(stream.sent.shift());                                                             // 1698
    test.isUndefined(methodMessage.randomSeed);                                                                      // 1699
    test.equal(methodMessage, {msg: 'method', method: '/' + collName + '/insert',                                    // 1700
                               params: [{_id: "foo", bar: 42}],                                                      // 1701
                               id: methodMessage.id});                                                               // 1702
    test.length(stream.sent, 0);                                                                                     // 1703
                                                                                                                     // 1704
    // Now receive a connected message. This should not clear the                                                    // 1705
    // _documentsWrittenByStub state!                                                                                // 1706
    stream.receive({msg: 'connected', session: SESSION_ID});                                                         // 1707
    test.length(stream.sent, 0);                                                                                     // 1708
    test.equal(coll.find().count(), 1);                                                                              // 1709
                                                                                                                     // 1710
    // Now receive the "updated" message for the method. This should revert the                                      // 1711
    // insert.                                                                                                       // 1712
    stream.receive({msg: 'updated', methods: [methodMessage.id]});                                                   // 1713
    test.length(stream.sent, 0);                                                                                     // 1714
    test.equal(coll.find().count(), 0);                                                                              // 1715
  });                                                                                                                // 1716
}                                                                                                                    // 1717
// XXX also test:                                                                                                    // 1718
// - reconnect, with session resume.                                                                                 // 1719
// - restart on update flag                                                                                          // 1720
// - on_update event                                                                                                 // 1721
// - reloading when the app changes, including session migration                                                     // 1722
                                                                                                                     // 1723
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/livedata_tests.js                                                                               //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
// XXX should check error codes                                                                                      // 1
var failure = function (test, code, reason) {                                                                        // 2
  return function (error, result) {                                                                                  // 3
    test.equal(result, undefined);                                                                                   // 4
    test.isTrue(error && typeof error === "object");                                                                 // 5
    if (error && typeof error === "object") {                                                                        // 6
      if (typeof code === "number") {                                                                                // 7
        test.instanceOf(error, Meteor.Error);                                                                        // 8
        code && test.equal(error.error, code);                                                                       // 9
        reason && test.equal(error.reason, reason);                                                                  // 10
        // XXX should check that other keys aren't present.. should                                                  // 11
        // probably use something like the Matcher we used to have                                                   // 12
      } else {                                                                                                       // 13
        // for normal Javascript errors                                                                              // 14
        test.instanceOf(error, Error);                                                                               // 15
        test.equal(error.message, code);                                                                             // 16
      }                                                                                                              // 17
    }                                                                                                                // 18
  };                                                                                                                 // 19
};                                                                                                                   // 20
                                                                                                                     // 21
Tinytest.add("livedata - Meteor.Error", function (test) {                                                            // 22
  var error = new Meteor.Error(123, "kittens", "puppies");                                                           // 23
  test.instanceOf(error, Meteor.Error);                                                                              // 24
  test.instanceOf(error, Error);                                                                                     // 25
  test.equal(error.error, 123);                                                                                      // 26
  test.equal(error.reason, "kittens");                                                                               // 27
  test.equal(error.details, "puppies");                                                                              // 28
});                                                                                                                  // 29
                                                                                                                     // 30
if (Meteor.isServer) {                                                                                               // 31
  Tinytest.add("livedata - version negotiation", function (test) {                                                   // 32
    var versionCheck = function (clientVersions, serverVersions, expected) {                                         // 33
      test.equal(                                                                                                    // 34
        LivedataTest.calculateVersion(clientVersions, serverVersions),                                               // 35
        expected);                                                                                                   // 36
    };                                                                                                               // 37
                                                                                                                     // 38
    versionCheck(["A", "B", "C"], ["A", "B", "C"], "A");                                                             // 39
    versionCheck(["B", "C"], ["A", "B", "C"], "B");                                                                  // 40
    versionCheck(["A", "B", "C"], ["B", "C"], "B");                                                                  // 41
    versionCheck(["foo", "bar", "baz"], ["A", "B", "C"], "A");                                                       // 42
  });                                                                                                                // 43
}                                                                                                                    // 44
                                                                                                                     // 45
Tinytest.add("livedata - methods with colliding names", function (test) {                                            // 46
  var x = Random.id();                                                                                               // 47
  var m = {};                                                                                                        // 48
  m[x] = function () {};                                                                                             // 49
  Meteor.methods(m);                                                                                                 // 50
                                                                                                                     // 51
  test.throws(function () {                                                                                          // 52
    Meteor.methods(m);                                                                                               // 53
  });                                                                                                                // 54
});                                                                                                                  // 55
                                                                                                                     // 56
var echoTest = function (item) {                                                                                     // 57
  return function (test, expect) {                                                                                   // 58
    if (Meteor.isServer) {                                                                                           // 59
      test.equal(Meteor.call("echo", item), [item]);                                                                 // 60
      test.equal(Meteor.call("echoOne", item), item);                                                                // 61
    }                                                                                                                // 62
    if (Meteor.isClient)                                                                                             // 63
      test.equal(Meteor.call("echo", item), undefined);                                                              // 64
                                                                                                                     // 65
    test.equal(Meteor.call("echo", item, expect(undefined, [item])), undefined);                                     // 66
    test.equal(Meteor.call("echoOne", item, expect(undefined, item)), undefined);                                    // 67
  };                                                                                                                 // 68
};                                                                                                                   // 69
                                                                                                                     // 70
testAsyncMulti("livedata - basic method invocation", [                                                               // 71
  // Unknown methods                                                                                                 // 72
  function (test, expect) {                                                                                          // 73
    if (Meteor.isServer) {                                                                                           // 74
      // On server, with no callback, throws exception                                                               // 75
      try {                                                                                                          // 76
        var ret = Meteor.call("unknown method");                                                                     // 77
      } catch (e) {                                                                                                  // 78
        test.equal(e.error, 404);                                                                                    // 79
        var threw = true;                                                                                            // 80
      }                                                                                                              // 81
      test.isTrue(threw);                                                                                            // 82
      test.equal(ret, undefined);                                                                                    // 83
    }                                                                                                                // 84
                                                                                                                     // 85
    if (Meteor.isClient) {                                                                                           // 86
      // On client, with no callback, just returns undefined                                                         // 87
      var ret = Meteor.call("unknown method");                                                                       // 88
      test.equal(ret, undefined);                                                                                    // 89
    }                                                                                                                // 90
                                                                                                                     // 91
    // On either, with a callback, calls the callback and does not throw                                             // 92
    var ret = Meteor.call("unknown method",                                                                          // 93
                          expect(failure(test, 404, "Method not found")));                                           // 94
    test.equal(ret, undefined);                                                                                      // 95
  },                                                                                                                 // 96
                                                                                                                     // 97
  function (test, expect) {                                                                                          // 98
    // make sure 'undefined' is preserved as such, instead of turning                                                // 99
    // into null (JSON does not have 'undefined' so there is special                                                 // 100
    // code for this)                                                                                                // 101
    if (Meteor.isServer)                                                                                             // 102
      test.equal(Meteor.call("nothing"), undefined);                                                                 // 103
    if (Meteor.isClient)                                                                                             // 104
      test.equal(Meteor.call("nothing"), undefined);                                                                 // 105
                                                                                                                     // 106
    test.equal(Meteor.call("nothing", expect(undefined, undefined)), undefined);                                     // 107
  },                                                                                                                 // 108
                                                                                                                     // 109
  function (test, expect) {                                                                                          // 110
    if (Meteor.isServer)                                                                                             // 111
      test.equal(Meteor.call("echo"), []);                                                                           // 112
    if (Meteor.isClient)                                                                                             // 113
      test.equal(Meteor.call("echo"), undefined);                                                                    // 114
                                                                                                                     // 115
    test.equal(Meteor.call("echo", expect(undefined, [])), undefined);                                               // 116
  },                                                                                                                 // 117
                                                                                                                     // 118
  echoTest(new Date()),                                                                                              // 119
  echoTest({d: new Date(), s: "foobarbaz"}),                                                                         // 120
  echoTest([new Date(), "foobarbaz"]),                                                                               // 121
  echoTest(new Meteor.Collection.ObjectID()),                                                                        // 122
  echoTest({o: new Meteor.Collection.ObjectID()}),                                                                   // 123
  echoTest({$date: 30}), // literal                                                                                  // 124
  echoTest({$literal: {$date: 30}}),                                                                                 // 125
  echoTest(12),                                                                                                      // 126
  echoTest(Infinity),                                                                                                // 127
  echoTest(-Infinity),                                                                                               // 128
                                                                                                                     // 129
  function (test, expect) {                                                                                          // 130
    if (Meteor.isServer)                                                                                             // 131
      test.equal(Meteor.call("echo", 12, {x: 13}), [12, {x: 13}]);                                                   // 132
    if (Meteor.isClient)                                                                                             // 133
      test.equal(Meteor.call("echo", 12, {x: 13}), undefined);                                                       // 134
                                                                                                                     // 135
    test.equal(Meteor.call("echo", 12, {x: 13},                                                                      // 136
                           expect(undefined, [12, {x: 13}])), undefined);                                            // 137
  },                                                                                                                 // 138
                                                                                                                     // 139
  // test that `wait: false` is respected                                                                            // 140
  function (test, expect) {                                                                                          // 141
    if (Meteor.isClient) {                                                                                           // 142
      // For test isolation                                                                                          // 143
      var token = Random.id();                                                                                       // 144
      Meteor.apply(                                                                                                  // 145
        "delayedTrue", [token], {wait: false}, expect(function(err, res) {                                           // 146
          test.equal(res, false);                                                                                    // 147
        }));                                                                                                         // 148
      Meteor.apply("makeDelayedTrueImmediatelyReturnFalse", [token]);                                                // 149
    }                                                                                                                // 150
  },                                                                                                                 // 151
                                                                                                                     // 152
  // test that `wait: true` is respected                                                                             // 153
  function(test, expect) {                                                                                           // 154
    if (Meteor.isClient) {                                                                                           // 155
      var token = Random.id();                                                                                       // 156
      Meteor.apply(                                                                                                  // 157
        "delayedTrue", [token], {wait: true}, expect(function(err, res) {                                            // 158
          test.equal(res, true);                                                                                     // 159
        }));                                                                                                         // 160
      Meteor.apply("makeDelayedTrueImmediatelyReturnFalse", [token]);                                                // 161
    }                                                                                                                // 162
  },                                                                                                                 // 163
                                                                                                                     // 164
  function (test, expect) {                                                                                          // 165
    // No callback                                                                                                   // 166
                                                                                                                     // 167
    if (Meteor.isServer) {                                                                                           // 168
      test.throws(function () {                                                                                      // 169
        Meteor.call("exception", "both");                                                                            // 170
      });                                                                                                            // 171
      test.throws(function () {                                                                                      // 172
        Meteor.call("exception", "server");                                                                          // 173
      });                                                                                                            // 174
      // No exception, because no code will run on the client                                                        // 175
      test.equal(Meteor.call("exception", "client"), undefined);                                                     // 176
    }                                                                                                                // 177
                                                                                                                     // 178
    if (Meteor.isClient) {                                                                                           // 179
      // The client exception is thrown away because it's in the                                                     // 180
      // stub. The server exception is throw away because we didn't                                                  // 181
      // give a callback.                                                                                            // 182
      test.equal(Meteor.call("exception", "both"), undefined);                                                       // 183
      test.equal(Meteor.call("exception", "server"), undefined);                                                     // 184
      test.equal(Meteor.call("exception", "client"), undefined);                                                     // 185
    }                                                                                                                // 186
                                                                                                                     // 187
    // With callback                                                                                                 // 188
                                                                                                                     // 189
    if (Meteor.isClient) {                                                                                           // 190
      test.equal(                                                                                                    // 191
        Meteor.call("exception", "both",                                                                             // 192
                    expect(failure(test, 500, "Internal server error"))),                                            // 193
        undefined);                                                                                                  // 194
      test.equal(                                                                                                    // 195
        Meteor.call("exception", "server",                                                                           // 196
                    expect(failure(test, 500, "Internal server error"))),                                            // 197
        undefined);                                                                                                  // 198
      test.equal(Meteor.call("exception", "client"), undefined);                                                     // 199
    }                                                                                                                // 200
                                                                                                                     // 201
    if (Meteor.isServer) {                                                                                           // 202
      test.equal(                                                                                                    // 203
        Meteor.call("exception", "both",                                                                             // 204
                    expect(failure(test, "Test method throwing an exception"))),                                     // 205
        undefined);                                                                                                  // 206
      test.equal(                                                                                                    // 207
        Meteor.call("exception", "server",                                                                           // 208
                    expect(failure(test, "Test method throwing an exception"))),                                     // 209
        undefined);                                                                                                  // 210
      test.equal(Meteor.call("exception", "client"), undefined);                                                     // 211
    }                                                                                                                // 212
  },                                                                                                                 // 213
                                                                                                                     // 214
  function (test, expect) {                                                                                          // 215
    if (Meteor.isServer) {                                                                                           // 216
      var threw = false;                                                                                             // 217
      try {                                                                                                          // 218
        Meteor.call("exception", "both", {intended: true});                                                          // 219
      } catch (e) {                                                                                                  // 220
        threw = true;                                                                                                // 221
        test.equal(e.error, 999);                                                                                    // 222
        test.equal(e.reason, "Client-visible test exception");                                                       // 223
      }                                                                                                              // 224
      test.isTrue(threw);                                                                                            // 225
      threw = false;                                                                                                 // 226
      try {                                                                                                          // 227
        Meteor.call("exception", "both", {intended: true,                                                            // 228
                                          throwThroughFuture: true});                                                // 229
      } catch (e) {                                                                                                  // 230
        threw = true;                                                                                                // 231
        test.equal(e.error, 999);                                                                                    // 232
        test.equal(e.reason, "Client-visible test exception");                                                       // 233
      }                                                                                                              // 234
      test.isTrue(threw);                                                                                            // 235
    }                                                                                                                // 236
                                                                                                                     // 237
    if (Meteor.isClient) {                                                                                           // 238
      test.equal(                                                                                                    // 239
        Meteor.call("exception", "both", {intended: true},                                                           // 240
                    expect(failure(test, 999,                                                                        // 241
                                   "Client-visible test exception"))),                                               // 242
        undefined);                                                                                                  // 243
      test.equal(                                                                                                    // 244
        Meteor.call("exception", "server", {intended: true},                                                         // 245
                    expect(failure(test, 999,                                                                        // 246
                                   "Client-visible test exception"))),                                               // 247
        undefined);                                                                                                  // 248
      test.equal(                                                                                                    // 249
        Meteor.call("exception", "server", {intended: true,                                                          // 250
                                            throwThroughFuture: true},                                               // 251
                    expect(failure(test, 999,                                                                        // 252
                                   "Client-visible test exception"))),                                               // 253
        undefined);                                                                                                  // 254
    }                                                                                                                // 255
  }                                                                                                                  // 256
]);                                                                                                                  // 257
                                                                                                                     // 258
                                                                                                                     // 259
                                                                                                                     // 260
                                                                                                                     // 261
var checkBalances = function (test, a, b) {                                                                          // 262
  var alice = Ledger.findOne({name: "alice", world: test.runId()});                                                  // 263
  var bob = Ledger.findOne({name: "bob", world: test.runId()});                                                      // 264
  test.equal(alice.balance, a);                                                                                      // 265
  test.equal(bob.balance, b);                                                                                        // 266
};                                                                                                                   // 267
                                                                                                                     // 268
// would be nice to have a database-aware test harness of some kind --                                               // 269
// this is a big hack (and XXX pollutes the global test namespace)                                                   // 270
testAsyncMulti("livedata - compound methods", [                                                                      // 271
  function (test, expect) {                                                                                          // 272
    if (Meteor.isClient)                                                                                             // 273
      Meteor.subscribe("ledger", test.runId(), expect());                                                            // 274
                                                                                                                     // 275
    Ledger.insert({name: "alice", balance: 100, world: test.runId()},                                                // 276
                  expect(function () {}));                                                                           // 277
    Ledger.insert({name: "bob", balance: 50, world: test.runId()},                                                   // 278
                  expect(function () {}));                                                                           // 279
  },                                                                                                                 // 280
  function (test, expect) {                                                                                          // 281
    Meteor.call('ledger/transfer', test.runId(), "alice", "bob", 10,                                                 // 282
                expect(function(err, result) {                                                                       // 283
                  test.equal(err, undefined);                                                                        // 284
                  test.equal(result, undefined);                                                                     // 285
                  checkBalances(test, 90, 60);                                                                       // 286
                }));                                                                                                 // 287
    checkBalances(test, 90, 60);                                                                                     // 288
  },                                                                                                                 // 289
  function (test, expect) {                                                                                          // 290
    Meteor.call('ledger/transfer', test.runId(), "alice", "bob", 100, true,                                          // 291
                expect(function (err, result) {                                                                      // 292
                  failure(test, 409)(err, result);                                                                   // 293
                  // Balances are reverted back to pre-stub values.                                                  // 294
                  checkBalances(test, 90, 60);                                                                       // 295
                }));                                                                                                 // 296
                                                                                                                     // 297
    if (Meteor.isClient)                                                                                             // 298
      // client can fool itself by cheating, but only until the sync                                                 // 299
      // finishes                                                                                                    // 300
      checkBalances(test, -10, 160);                                                                                 // 301
    else                                                                                                             // 302
      checkBalances(test, 90, 60);                                                                                   // 303
  }                                                                                                                  // 304
]);                                                                                                                  // 305
                                                                                                                     // 306
// Replaces the Connection's `_livedata_data` method to push incoming                                                // 307
// messages on a given collection to an array. This can be used to                                                   // 308
// verify that the right data is sent on the wire                                                                    // 309
//                                                                                                                   // 310
// @param messages {Array} The array to which to append the messages                                                 // 311
// @return {Function} A function to call to undo the eavesdropping                                                   // 312
var eavesdropOnCollection = function(livedata_connection,                                                            // 313
                                     collection_name, messages) {                                                    // 314
  var old_livedata_data = _.bind(                                                                                    // 315
    livedata_connection._livedata_data, livedata_connection);                                                        // 316
                                                                                                                     // 317
  // Kind of gross since all tests past this one will run with this                                                  // 318
  // hook set up. That's probably fine since we only check a specific                                                // 319
  // collection but still...                                                                                         // 320
  //                                                                                                                 // 321
  // Should we consider having a separate connection per Tinytest or                                                 // 322
  // some similar scheme?                                                                                            // 323
  livedata_connection._livedata_data = function(msg) {                                                               // 324
    if (msg.collection && msg.collection === collection_name) {                                                      // 325
      messages.push(msg);                                                                                            // 326
    }                                                                                                                // 327
    old_livedata_data(msg);                                                                                          // 328
  };                                                                                                                 // 329
                                                                                                                     // 330
  return function() {                                                                                                // 331
    livedata_connection._livedata_data = old_livedata_data;                                                          // 332
  };                                                                                                                 // 333
};                                                                                                                   // 334
                                                                                                                     // 335
if (Meteor.isClient) {                                                                                               // 336
  testAsyncMulti("livedata - changing userid reruns subscriptions without flapping data on the wire", [              // 337
    function(test, expect) {                                                                                         // 338
      var messages = [];                                                                                             // 339
      var undoEavesdrop = eavesdropOnCollection(                                                                     // 340
        Meteor.connection, "objectsWithUsers", messages);                                                            // 341
                                                                                                                     // 342
      // A helper for testing incoming set and unset messages                                                        // 343
      // XXX should this be extracted as a general helper together with                                              // 344
      // eavesdropOnCollection?                                                                                      // 345
      var expectMessages = function(expectedAddedMessageCount,                                                       // 346
                                    expectedRemovedMessageCount,                                                     // 347
                                    expectedNamesInCollection) {                                                     // 348
        var actualAddedMessageCount = 0;                                                                             // 349
        var actualRemovedMessageCount = 0;                                                                           // 350
        _.each(messages, function (msg) {                                                                            // 351
          if (msg.msg === 'added')                                                                                   // 352
            ++actualAddedMessageCount;                                                                               // 353
          else if (msg.msg === 'removed')                                                                            // 354
            ++actualRemovedMessageCount;                                                                             // 355
          else                                                                                                       // 356
            test.fail({unexpected: JSON.stringify(msg)});                                                            // 357
        });                                                                                                          // 358
        test.equal(actualAddedMessageCount, expectedAddedMessageCount);                                              // 359
        test.equal(actualRemovedMessageCount, expectedRemovedMessageCount);                                          // 360
        expectedNamesInCollection.sort();                                                                            // 361
        test.equal(_.pluck(objectsWithUsers.find({}, {sort: ['name']}).fetch(),                                      // 362
                           'name'),                                                                                  // 363
                   expectedNamesInCollection);                                                                       // 364
        messages.length = 0; // clear messages without creating a new object                                         // 365
      };                                                                                                             // 366
                                                                                                                     // 367
      // make sure we're not already logged in. can happen if accounts                                               // 368
      // tests fail oddly.                                                                                           // 369
      Meteor.apply("setUserId", [null], {wait: true}, expect(function () {}));                                       // 370
                                                                                                                     // 371
      Meteor.subscribe("objectsWithUsers", expect(function() {                                                       // 372
        expectMessages(1, 0, ["owned by none"]);                                                                     // 373
        Meteor.apply("setUserId", ["1"], {wait: true}, afterFirstSetUserId);                                         // 374
      }));                                                                                                           // 375
                                                                                                                     // 376
      var afterFirstSetUserId = expect(function() {                                                                  // 377
        expectMessages(3, 1, [                                                                                       // 378
          "owned by one - a",                                                                                        // 379
          "owned by one/two - a",                                                                                    // 380
          "owned by one/two - b"]);                                                                                  // 381
        Meteor.apply("setUserId", ["2"], {wait: true}, afterSecondSetUserId);                                        // 382
      });                                                                                                            // 383
                                                                                                                     // 384
      var afterSecondSetUserId = expect(function() {                                                                 // 385
        expectMessages(2, 1, [                                                                                       // 386
          "owned by one/two - a",                                                                                    // 387
          "owned by one/two - b",                                                                                    // 388
          "owned by two - a",                                                                                        // 389
          "owned by two - b"]);                                                                                      // 390
        Meteor.apply("setUserId", ["2"], {wait: true}, afterThirdSetUserId);                                         // 391
      });                                                                                                            // 392
                                                                                                                     // 393
      var afterThirdSetUserId = expect(function() {                                                                  // 394
        // Nothing should have been sent since the results of the                                                    // 395
        // query are the same ("don't flap data on the wire")                                                        // 396
        expectMessages(0, 0, [                                                                                       // 397
          "owned by one/two - a",                                                                                    // 398
          "owned by one/two - b",                                                                                    // 399
          "owned by two - a",                                                                                        // 400
          "owned by two - b"]);                                                                                      // 401
        undoEavesdrop();                                                                                             // 402
      });                                                                                                            // 403
    }, function(test, expect) {                                                                                      // 404
      var key = Random.id();                                                                                         // 405
      Meteor.subscribe("recordUserIdOnStop", key);                                                                   // 406
      Meteor.apply("setUserId", ["100"], {wait: true}, expect(function () {}));                                      // 407
      Meteor.apply("setUserId", ["101"], {wait: true}, expect(function () {}));                                      // 408
      Meteor.call("userIdWhenStopped", key, expect(function (err, result) {                                          // 409
        test.isFalse(err);                                                                                           // 410
        test.equal(result, "100");                                                                                   // 411
      }));                                                                                                           // 412
      // clean up                                                                                                    // 413
      Meteor.apply("setUserId", [null], {wait: true}, expect(function () {}));                                       // 414
    }                                                                                                                // 415
  ]);                                                                                                                // 416
}                                                                                                                    // 417
                                                                                                                     // 418
Tinytest.add("livedata - setUserId error when called from server", function(test) {                                  // 419
  if (Meteor.isServer) {                                                                                             // 420
    test.equal(errorThrownWhenCallingSetUserIdDirectlyOnServer.message,                                              // 421
               "Can't call setUserId on a server initiated method call");                                            // 422
  }                                                                                                                  // 423
});                                                                                                                  // 424
                                                                                                                     // 425
                                                                                                                     // 426
if (Meteor.isServer) {                                                                                               // 427
  var pubHandles = {};                                                                                               // 428
};                                                                                                                   // 429
Meteor.methods({                                                                                                     // 430
  "livedata/setup" : function (id) {                                                                                 // 431
    check(id, String);                                                                                               // 432
    if (Meteor.isServer) {                                                                                           // 433
      pubHandles[id] = {};                                                                                           // 434
      Meteor.publish("pub1"+id, function () {                                                                        // 435
        pubHandles[id].pub1 = this;                                                                                  // 436
        this.ready();                                                                                                // 437
      });                                                                                                            // 438
      Meteor.publish("pub2"+id, function () {                                                                        // 439
        pubHandles[id].pub2 = this;                                                                                  // 440
        this.ready();                                                                                                // 441
      });                                                                                                            // 442
                                                                                                                     // 443
    }                                                                                                                // 444
  },                                                                                                                 // 445
  "livedata/pub1go" : function (id) {                                                                                // 446
    check(id, String);                                                                                               // 447
    if (Meteor.isServer) {                                                                                           // 448
                                                                                                                     // 449
      pubHandles[id].pub1.added("MultiPubCollection" + id, "foo", {a: "aa"});                                        // 450
      return 1;                                                                                                      // 451
    }                                                                                                                // 452
    return 0;                                                                                                        // 453
  },                                                                                                                 // 454
  "livedata/pub2go" : function (id) {                                                                                // 455
    check(id, String);                                                                                               // 456
    if (Meteor.isServer) {                                                                                           // 457
      pubHandles[id].pub2.added("MultiPubCollection" + id , "foo", {b: "bb"});                                       // 458
      return 2;                                                                                                      // 459
    }                                                                                                                // 460
    return 0;                                                                                                        // 461
  }                                                                                                                  // 462
});                                                                                                                  // 463
                                                                                                                     // 464
if (Meteor.isClient) {                                                                                               // 465
  (function () {                                                                                                     // 466
    var MultiPub;                                                                                                    // 467
    var id = Random.id();                                                                                            // 468
    testAsyncMulti("livedata - added from two different subs", [                                                     // 469
      function (test, expect) {                                                                                      // 470
        Meteor.call('livedata/setup', id, expect(function () {}));                                                   // 471
      },                                                                                                             // 472
      function (test, expect) {                                                                                      // 473
        MultiPub = new Meteor.Collection("MultiPubCollection" + id);                                                 // 474
        var sub1 = Meteor.subscribe("pub1"+id, expect(function () {}));                                              // 475
        var sub2 = Meteor.subscribe("pub2"+id, expect(function () {}));                                              // 476
      },                                                                                                             // 477
      function (test, expect) {                                                                                      // 478
        Meteor.call("livedata/pub1go", id, expect(function (err, res) {test.equal(res, 1);}));                       // 479
      },                                                                                                             // 480
      function (test, expect) {                                                                                      // 481
        test.equal(MultiPub.findOne("foo"), {_id: "foo", a: "aa"});                                                  // 482
      },                                                                                                             // 483
      function (test, expect) {                                                                                      // 484
        Meteor.call("livedata/pub2go", id, expect(function (err, res) {test.equal(res, 2);}));                       // 485
      },                                                                                                             // 486
      function (test, expect) {                                                                                      // 487
        test.equal(MultiPub.findOne("foo"), {_id: "foo", a: "aa", b: "bb"});                                         // 488
      }                                                                                                              // 489
    ]);                                                                                                              // 490
  })();                                                                                                              // 491
};                                                                                                                   // 492
                                                                                                                     // 493
if (Meteor.isClient) {                                                                                               // 494
  testAsyncMulti("livedata - overlapping universal subs", [                                                          // 495
    function (test, expect) {                                                                                        // 496
      var coll = new Meteor.Collection("overlappingUniversalSubs");                                                  // 497
      var token = Random.id();                                                                                       // 498
      test.isFalse(coll.findOne(token));                                                                             // 499
      Meteor.call("testOverlappingSubs", token, expect(function (err) {                                              // 500
        test.isFalse(err);                                                                                           // 501
        test.isTrue(coll.findOne(token));                                                                            // 502
      }));                                                                                                           // 503
    }                                                                                                                // 504
  ]);                                                                                                                // 505
                                                                                                                     // 506
  testAsyncMulti("livedata - runtime universal sub creation", [                                                      // 507
    function (test, expect) {                                                                                        // 508
      var coll = new Meteor.Collection("runtimeSubCreation");                                                        // 509
      var token = Random.id();                                                                                       // 510
      test.isFalse(coll.findOne(token));                                                                             // 511
      Meteor.call("runtimeUniversalSubCreation", token, expect(function (err) {                                      // 512
        test.isFalse(err);                                                                                           // 513
        test.isTrue(coll.findOne(token));                                                                            // 514
      }));                                                                                                           // 515
    }                                                                                                                // 516
  ]);                                                                                                                // 517
                                                                                                                     // 518
  testAsyncMulti("livedata - no setUserId after unblock", [                                                          // 519
    function (test, expect) {                                                                                        // 520
      Meteor.call("setUserIdAfterUnblock", expect(function (err, result) {                                           // 521
        test.isFalse(err);                                                                                           // 522
        test.isTrue(result);                                                                                         // 523
      }));                                                                                                           // 524
    }                                                                                                                // 525
  ]);                                                                                                                // 526
                                                                                                                     // 527
  testAsyncMulti("livedata - publisher errors", (function () {                                                       // 528
    var conn, collName, coll;                                                                                        // 529
    var errorFromRerun;                                                                                              // 530
    var gotErrorFromStopper = false;                                                                                 // 531
    return [                                                                                                         // 532
      function (test, expect) {                                                                                      // 533
        // Use a separate connection so that we can safely check to see if                                           // 534
        // conn._subscriptions is empty.                                                                             // 535
        conn = new LivedataTest.Connection('/',                                                                      // 536
                                           {reloadWithOutstanding: true});                                           // 537
        collName = Random.id();                                                                                      // 538
        coll = new Meteor.Collection(collName, {connection: conn});                                                  // 539
                                                                                                                     // 540
        var testSubError = function (options) {                                                                      // 541
          conn.subscribe("publisherErrors", collName, options, {                                                     // 542
            onReady: expect(),                                                                                       // 543
            onError: expect(                                                                                         // 544
              failure(test,                                                                                          // 545
                      options.internalError ? 500 : 412,                                                             // 546
                      options.internalError ? "Internal server error"                                                // 547
                                            : "Explicit error"))                                                     // 548
          });                                                                                                        // 549
        };                                                                                                           // 550
        testSubError({throwInHandler: true});                                                                        // 551
        testSubError({throwInHandler: true, internalError: true});                                                   // 552
        testSubError({errorInHandler: true});                                                                        // 553
        testSubError({errorInHandler: true, internalError: true});                                                   // 554
        testSubError({errorLater: true});                                                                            // 555
        testSubError({errorLater: true, internalError: true});                                                       // 556
      },                                                                                                             // 557
      function (test, expect) {                                                                                      // 558
        test.equal(coll.find().count(), 0);                                                                          // 559
        test.equal(_.size(conn._subscriptions), 0);  // white-box test                                               // 560
                                                                                                                     // 561
        conn.subscribe("publisherErrors",                                                                            // 562
                       collName, {throwWhenUserIdSet: true}, {                                                       // 563
          onReady: expect(),                                                                                         // 564
          onError: function (error) {                                                                                // 565
            errorFromRerun = error;                                                                                  // 566
          }                                                                                                          // 567
        });                                                                                                          // 568
      },                                                                                                             // 569
      function (test, expect) {                                                                                      // 570
        // Because the last subscription is ready, we should have a document.                                        // 571
        test.equal(coll.find().count(), 1);                                                                          // 572
        test.isFalse(errorFromRerun);                                                                                // 573
        test.equal(_.size(conn._subscriptions), 1);  // white-box test                                               // 574
        conn.call('setUserId', 'bla', expect(function(){}));                                                         // 575
      },                                                                                                             // 576
      function (test, expect) {                                                                                      // 577
        // Now that we've re-run, we should have stopped the subscription,                                           // 578
        // gotten a error, and lost the document.                                                                    // 579
        test.equal(coll.find().count(), 0);                                                                          // 580
        test.isTrue(errorFromRerun);                                                                                 // 581
        test.instanceOf(errorFromRerun, Meteor.Error);                                                               // 582
        test.equal(errorFromRerun.error, 412);                                                                       // 583
        test.equal(errorFromRerun.reason, "Explicit error");                                                         // 584
        test.equal(_.size(conn._subscriptions), 0);  // white-box test                                               // 585
                                                                                                                     // 586
        conn.subscribe("publisherErrors", collName, {stopInHandler: true}, {                                         // 587
          onError: function() { gotErrorFromStopper = true; }                                                        // 588
        });                                                                                                          // 589
        // Call a method. This method won't be processed until the publisher's                                       // 590
        // function returns, so blocking on it being done ensures that we've                                         // 591
        // gotten the removed/nosub/etc.                                                                             // 592
        conn.call('nothing', expect(function(){}));                                                                  // 593
      },                                                                                                             // 594
      function (test, expect) {                                                                                      // 595
        test.equal(coll.find().count(), 0);                                                                          // 596
        // sub.stop does NOT call onError.                                                                           // 597
        test.isFalse(gotErrorFromStopper);                                                                           // 598
        test.equal(_.size(conn._subscriptions), 0);  // white-box test                                               // 599
        conn._stream.disconnect({_permanent: true});                                                                 // 600
      }                                                                                                              // 601
    ];})());                                                                                                         // 602
                                                                                                                     // 603
    testAsyncMulti("livedata - publish multiple cursors", [                                                          // 604
      function (test, expect) {                                                                                      // 605
        Meteor.subscribe("multiPublish", {normal: 1}, {                                                              // 606
          onReady: expect(function () {                                                                              // 607
            test.equal(One.find().count(), 2);                                                                       // 608
            test.equal(Two.find().count(), 3);                                                                       // 609
          }),                                                                                                        // 610
          onError: failure()                                                                                         // 611
        });                                                                                                          // 612
      },                                                                                                             // 613
      function (test, expect) {                                                                                      // 614
        Meteor.subscribe("multiPublish", {dup: 1}, {                                                                 // 615
          onReady: failure(),                                                                                        // 616
          onError: expect(failure(test, 500, "Internal server error"))                                               // 617
        });                                                                                                          // 618
      },                                                                                                             // 619
      function (test, expect) {                                                                                      // 620
        Meteor.subscribe("multiPublish", {notCursor: 1}, {                                                           // 621
          onReady: failure(),                                                                                        // 622
          onError: expect(failure(test, 500, "Internal server error"))                                               // 623
        });                                                                                                          // 624
      }                                                                                                              // 625
    ]);                                                                                                              // 626
}                                                                                                                    // 627
                                                                                                                     // 628
var selfUrl = Meteor.isServer                                                                                        // 629
      ? Meteor.absoluteUrl() : Meteor._relativeToSiteRootUrl('/');                                                   // 630
                                                                                                                     // 631
if (Meteor.isServer) {                                                                                               // 632
  Meteor.methods({                                                                                                   // 633
    "s2s": function (arg) {                                                                                          // 634
      check(arg, String);                                                                                            // 635
      return "s2s " + arg;                                                                                           // 636
    }                                                                                                                // 637
  });                                                                                                                // 638
}                                                                                                                    // 639
(function () {                                                                                                       // 640
  testAsyncMulti("livedata - connect works from both client and server", [                                           // 641
    function (test, expect) {                                                                                        // 642
      var self = this;                                                                                               // 643
      self.conn = DDP.connect(selfUrl);                                                                              // 644
      pollUntil(expect, function () {                                                                                // 645
        return self.conn.status().connected;                                                                         // 646
      }, 10000);                                                                                                     // 647
    },                                                                                                               // 648
                                                                                                                     // 649
    function (test, expect) {                                                                                        // 650
      var self = this;                                                                                               // 651
      if (self.conn.status().connected) {                                                                            // 652
        self.conn.call('s2s', 'foo', expect(function (err, res) {                                                    // 653
          if (err)                                                                                                   // 654
            throw err;                                                                                               // 655
          test.equal(res, "s2s foo");                                                                                // 656
        }));                                                                                                         // 657
      }                                                                                                              // 658
    }                                                                                                                // 659
  ]);                                                                                                                // 660
})();                                                                                                                // 661
                                                                                                                     // 662
if (Meteor.isServer) {                                                                                               // 663
  (function () {                                                                                                     // 664
    testAsyncMulti("livedata - method call on server blocks in a fiber way", [                                       // 665
      function (test, expect) {                                                                                      // 666
        var self = this;                                                                                             // 667
        self.conn = DDP.connect(selfUrl);                                                                            // 668
        pollUntil(expect, function () {                                                                              // 669
          return self.conn.status().connected;                                                                       // 670
        }, 10000);                                                                                                   // 671
      },                                                                                                             // 672
                                                                                                                     // 673
      function (test, expect) {                                                                                      // 674
        var self = this;                                                                                             // 675
        if (self.conn.status().connected) {                                                                          // 676
          test.equal(self.conn.call('s2s', 'foo'), "s2s foo");                                                       // 677
        }                                                                                                            // 678
      }                                                                                                              // 679
    ]);                                                                                                              // 680
  })();                                                                                                              // 681
}                                                                                                                    // 682
                                                                                                                     // 683
(function () {                                                                                                       // 684
  testAsyncMulti("livedata - connect fails to unknown place", [                                                      // 685
    function (test, expect) {                                                                                        // 686
      var self = this;                                                                                               // 687
      self.conn = DDP.connect("example.com", {_dontPrintErrors: true});                                              // 688
      Meteor.setTimeout(expect(function () {                                                                         // 689
        test.isFalse(self.conn.status().connected, "Not connected");                                                 // 690
        self.conn.close();                                                                                           // 691
      }), 500);                                                                                                      // 692
    }                                                                                                                // 693
  ]);                                                                                                                // 694
})();                                                                                                                // 695
                                                                                                                     // 696
if (Meteor.isServer) {                                                                                               // 697
  Meteor.publish("publisherCloning", function () {                                                                   // 698
    var self = this;                                                                                                 // 699
    var fields = {x: {y: 42}};                                                                                       // 700
    self.added("publisherCloning", "a", fields);                                                                     // 701
    fields.x.y = 43;                                                                                                 // 702
    self.changed("publisherCloning", "a", fields);                                                                   // 703
    self.ready();                                                                                                    // 704
  });                                                                                                                // 705
} else {                                                                                                             // 706
  var PublisherCloningCollection = new Meteor.Collection("publisherCloning");                                        // 707
  testAsyncMulti("livedata - publish callbacks clone", [                                                             // 708
    function (test, expect) {                                                                                        // 709
      Meteor.subscribe("publisherCloning", {normal: 1}, {                                                            // 710
        onReady: expect(function () {                                                                                // 711
          test.equal(PublisherCloningCollection.findOne(), {                                                         // 712
            _id: "a",                                                                                                // 713
            x: {y: 43}});                                                                                            // 714
        }),                                                                                                          // 715
        onError: failure()                                                                                           // 716
      });                                                                                                            // 717
    }                                                                                                                // 718
  ]);                                                                                                                // 719
}                                                                                                                    // 720
                                                                                                                     // 721
                                                                                                                     // 722
// XXX some things to test in greater detail:                                                                        // 723
// staying in simulation mode                                                                                        // 724
// time warp                                                                                                         // 725
// serialization / beginAsync(true) / beginAsync(false)                                                              // 726
// malformed messages (need raw wire access)                                                                         // 727
// method completion/satisfaction                                                                                    // 728
// subscriptions (multiple APIs, including autorun?)                                                                 // 729
// subscription completion                                                                                           // 730
// subscription attribute shadowing                                                                                  // 731
// server method calling methods on other server (eg, should simulate)                                               // 732
// subscriptions and methods being idempotent                                                                        // 733
// reconnection                                                                                                      // 734
// reconnection not resulting in method re-execution                                                                 // 735
// reconnection tolerating all kinds of lost messages (including data)                                               // 736
// [probably lots more]                                                                                              // 737
                                                                                                                     // 738
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/livedata_test_service.js                                                                        //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
Meteor.methods({                                                                                                     // 1
  nothing: function () {                                                                                             // 2
    // No need to check if there are no arguments.                                                                   // 3
  },                                                                                                                 // 4
  echo: function (/* arguments */) {                                                                                 // 5
    check(arguments, [Match.Any]);                                                                                   // 6
    return _.toArray(arguments);                                                                                     // 7
  },                                                                                                                 // 8
  echoOne: function (/*arguments*/) {                                                                                // 9
    check(arguments, [Match.Any]);                                                                                   // 10
    return arguments[0];                                                                                             // 11
  },                                                                                                                 // 12
  exception: function (where, options) {                                                                             // 13
    check(where, String);                                                                                            // 14
    check(options, Match.Optional({                                                                                  // 15
      intended: Match.Optional(Boolean),                                                                             // 16
      throwThroughFuture: Match.Optional(Boolean)                                                                    // 17
    }));                                                                                                             // 18
    options = options || {};                                                                                         // 19
    var shouldThrow =                                                                                                // 20
      (Meteor.isServer && where === "server") ||                                                                     // 21
      (Meteor.isClient && where === "client") ||                                                                     // 22
      where === "both";                                                                                              // 23
                                                                                                                     // 24
    if (shouldThrow) {                                                                                               // 25
      var e;                                                                                                         // 26
      if (options.intended)                                                                                          // 27
        e = new Meteor.Error(999, "Client-visible test exception");                                                  // 28
      else                                                                                                           // 29
        e = new Error("Test method throwing an exception");                                                          // 30
      e.expected = true;                                                                                             // 31
                                                                                                                     // 32
      // We used to improperly serialize errors that were thrown through a                                           // 33
      // future first.                                                                                               // 34
      if (Meteor.isServer && options.throwThroughFuture) {                                                           // 35
        var Future = Npm.require('fibers/future');                                                                   // 36
        var f = new Future;                                                                                          // 37
        f['throw'](e);                                                                                               // 38
        e = f.wait();                                                                                                // 39
      }                                                                                                              // 40
      throw e;                                                                                                       // 41
    }                                                                                                                // 42
  },                                                                                                                 // 43
  setUserId: function(userId) {                                                                                      // 44
    check(userId, Match.OneOf(String, null));                                                                        // 45
    this.setUserId(userId);                                                                                          // 46
  }                                                                                                                  // 47
});                                                                                                                  // 48
                                                                                                                     // 49
// Methods to help test applying methods with `wait: true`: delayedTrue returns                                      // 50
// true 1s after being run unless makeDelayedTrueImmediatelyReturnFalse was run                                      // 51
// in the meanwhile. Increasing the timeout makes the "wait: true" test slower;                                      // 52
// decreasing the timeout makes the "wait: false" test flakier (ie, the timeout                                      // 53
// could fire before processing the second method).                                                                  // 54
if (Meteor.isServer) {                                                                                               // 55
  // Keys are random tokens, used to isolate multiple test invocations from each                                     // 56
  // other.                                                                                                          // 57
  var waiters = {};                                                                                                  // 58
                                                                                                                     // 59
  var path = Npm.require('path');                                                                                    // 60
  var Future = Npm.require(path.join('fibers', 'future'));                                                           // 61
                                                                                                                     // 62
  var returnThroughFuture = function (token, returnValue) {                                                          // 63
    // Make sure that when we call return, the fields are already cleared.                                           // 64
    var record = waiters[token];                                                                                     // 65
    if (!record)                                                                                                     // 66
      return;                                                                                                        // 67
    delete waiters[token];                                                                                           // 68
    record.future['return'](returnValue);                                                                            // 69
  };                                                                                                                 // 70
                                                                                                                     // 71
  Meteor.methods({                                                                                                   // 72
    delayedTrue: function(token) {                                                                                   // 73
      check(token, String);                                                                                          // 74
      var record = waiters[token] = {                                                                                // 75
        future: new Future(),                                                                                        // 76
        timer: Meteor.setTimeout(function() {                                                                        // 77
          returnThroughFuture(token, true);                                                                          // 78
        }, 1000)                                                                                                     // 79
      };                                                                                                             // 80
                                                                                                                     // 81
      this.unblock();                                                                                                // 82
      return record.future.wait();                                                                                   // 83
    },                                                                                                               // 84
    makeDelayedTrueImmediatelyReturnFalse: function(token) {                                                         // 85
      check(token, String);                                                                                          // 86
      var record = waiters[token];                                                                                   // 87
      if (!record)                                                                                                   // 88
        return; // since delayedTrue's timeout had already run                                                       // 89
      clearTimeout(record.timer);                                                                                    // 90
      returnThroughFuture(token, false);                                                                             // 91
    }                                                                                                                // 92
  });                                                                                                                // 93
}                                                                                                                    // 94
                                                                                                                     // 95
/*****/                                                                                                              // 96
                                                                                                                     // 97
Ledger = new Meteor.Collection("ledger");                                                                            // 98
Ledger.allow({                                                                                                       // 99
  insert: function() { return true; },                                                                               // 100
  update: function() { return true; },                                                                               // 101
  remove: function() { return true; },                                                                               // 102
  fetch: []                                                                                                          // 103
});                                                                                                                  // 104
                                                                                                                     // 105
Meteor.startup(function () {                                                                                         // 106
  if (Meteor.isServer)                                                                                               // 107
    Ledger.remove({}); // XXX can this please be Ledger.remove()?                                                    // 108
});                                                                                                                  // 109
                                                                                                                     // 110
if (Meteor.isServer)                                                                                                 // 111
  Meteor.publish('ledger', function (world) {                                                                        // 112
    check(world, String);                                                                                            // 113
    return Ledger.find({world: world});                                                                              // 114
  });                                                                                                                // 115
                                                                                                                     // 116
Meteor.methods({                                                                                                     // 117
  'ledger/transfer': function (world, from_name, to_name, amount, cheat) {                                           // 118
    check(world, String);                                                                                            // 119
    check(from_name, String);                                                                                        // 120
    check(to_name, String);                                                                                          // 121
    check(amount, Number);                                                                                           // 122
    check(cheat, Match.Optional(Boolean));                                                                           // 123
    var from = Ledger.findOne({name: from_name, world: world});                                                      // 124
    var to = Ledger.findOne({name: to_name, world: world});                                                          // 125
                                                                                                                     // 126
    if (Meteor.isServer)                                                                                             // 127
      cheat = false;                                                                                                 // 128
                                                                                                                     // 129
    if (!from)                                                                                                       // 130
      throw new Meteor.Error(404,                                                                                    // 131
                             "No such account " + from_name + " in " + world);                                       // 132
                                                                                                                     // 133
    if (!to)                                                                                                         // 134
      throw new Meteor.Error(404,                                                                                    // 135
                             "No such account " + to_name + " in " + world);                                         // 136
                                                                                                                     // 137
    if (from.balance < amount && !cheat)                                                                             // 138
      throw new Meteor.Error(409, "Insufficient funds");                                                             // 139
                                                                                                                     // 140
    Ledger.update(from._id, {$inc: {balance: -amount}});                                                             // 141
    Ledger.update(to._id, {$inc: {balance: amount}});                                                                // 142
  }                                                                                                                  // 143
});                                                                                                                  // 144
                                                                                                                     // 145
/*****/                                                                                                              // 146
                                                                                                                     // 147
/// Helpers for "livedata - changing userid reruns subscriptions..."                                                 // 148
                                                                                                                     // 149
objectsWithUsers = new Meteor.Collection("objectsWithUsers");                                                        // 150
                                                                                                                     // 151
if (Meteor.isServer) {                                                                                               // 152
  objectsWithUsers.remove({});                                                                                       // 153
  objectsWithUsers.insert({name: "owned by none", ownerUserIds: [null]});                                            // 154
  objectsWithUsers.insert({name: "owned by one - a", ownerUserIds: ["1"]});                                          // 155
  objectsWithUsers.insert({name: "owned by one/two - a", ownerUserIds: ["1", "2"]});                                 // 156
  objectsWithUsers.insert({name: "owned by one/two - b", ownerUserIds: ["1", "2"]});                                 // 157
  objectsWithUsers.insert({name: "owned by two - a", ownerUserIds: ["2"]});                                          // 158
  objectsWithUsers.insert({name: "owned by two - b", ownerUserIds: ["2"]});                                          // 159
                                                                                                                     // 160
  Meteor.publish("objectsWithUsers", function() {                                                                    // 161
    return objectsWithUsers.find({ownerUserIds: this.userId},                                                        // 162
                                 {fields: {ownerUserIds: 0}});                                                       // 163
  });                                                                                                                // 164
                                                                                                                     // 165
  (function () {                                                                                                     // 166
    var userIdWhenStopped = {};                                                                                      // 167
    Meteor.publish("recordUserIdOnStop", function (key) {                                                            // 168
      check(key, String);                                                                                            // 169
      var self = this;                                                                                               // 170
      self.onStop(function() {                                                                                       // 171
        userIdWhenStopped[key] = self.userId;                                                                        // 172
      });                                                                                                            // 173
    });                                                                                                              // 174
                                                                                                                     // 175
    Meteor.methods({                                                                                                 // 176
      userIdWhenStopped: function (key) {                                                                            // 177
        check(key, String);                                                                                          // 178
        return userIdWhenStopped[key];                                                                               // 179
      }                                                                                                              // 180
    });                                                                                                              // 181
  })();                                                                                                              // 182
}                                                                                                                    // 183
                                                                                                                     // 184
/*****/                                                                                                              // 185
                                                                                                                     // 186
/// Helper for "livedata - setUserId fails when called on server"                                                    // 187
                                                                                                                     // 188
if (Meteor.isServer) {                                                                                               // 189
  Meteor.startup(function() {                                                                                        // 190
    errorThrownWhenCallingSetUserIdDirectlyOnServer = null;                                                          // 191
    try {                                                                                                            // 192
      Meteor.call("setUserId", "1000");                                                                              // 193
    } catch (e) {                                                                                                    // 194
      errorThrownWhenCallingSetUserIdDirectlyOnServer = e;                                                           // 195
    }                                                                                                                // 196
  });                                                                                                                // 197
}                                                                                                                    // 198
                                                                                                                     // 199
/// Helper for "livedata - no setUserId after unblock"                                                               // 200
                                                                                                                     // 201
if (Meteor.isServer) {                                                                                               // 202
  Meteor.methods({                                                                                                   // 203
    setUserIdAfterUnblock: function () {                                                                             // 204
      this.unblock();                                                                                                // 205
      var threw = false;                                                                                             // 206
      var originalUserId = this.userId;                                                                              // 207
      try {                                                                                                          // 208
        // Calling setUserId after unblock should throw an error (and not mutate                                     // 209
        // userId).                                                                                                  // 210
        this.setUserId(originalUserId + "bla");                                                                      // 211
      } catch (e) {                                                                                                  // 212
        threw = true;                                                                                                // 213
      }                                                                                                              // 214
      return threw && this.userId === originalUserId;                                                                // 215
    }                                                                                                                // 216
  });                                                                                                                // 217
}                                                                                                                    // 218
                                                                                                                     // 219
/*****/                                                                                                              // 220
                                                                                                                     // 221
/// Helper for "livedata - overlapping universal subs"                                                               // 222
                                                                                                                     // 223
if (Meteor.isServer) {                                                                                               // 224
  (function(){                                                                                                       // 225
    var collName = "overlappingUniversalSubs";                                                                       // 226
    var universalSubscribers = [[], []];                                                                             // 227
                                                                                                                     // 228
    _.each([0, 1], function (index) {                                                                                // 229
      Meteor.publish(null, function () {                                                                             // 230
        var sub = this;                                                                                              // 231
        universalSubscribers[index].push(sub);                                                                       // 232
        sub.onStop(function () {                                                                                     // 233
          universalSubscribers[index] = _.without(                                                                   // 234
            universalSubscribers[index], sub);                                                                       // 235
        });                                                                                                          // 236
      });                                                                                                            // 237
    });                                                                                                              // 238
                                                                                                                     // 239
    Meteor.methods({                                                                                                 // 240
      testOverlappingSubs: function (token) {                                                                        // 241
        check(token, String);                                                                                        // 242
        _.each(universalSubscribers[0], function (sub) {                                                             // 243
          sub.added(collName, token, {});                                                                            // 244
        });                                                                                                          // 245
        _.each(universalSubscribers[1], function (sub) {                                                             // 246
          sub.added(collName, token, {});                                                                            // 247
        });                                                                                                          // 248
        _.each(universalSubscribers[0], function (sub) {                                                             // 249
          sub.removed(collName, token);                                                                              // 250
        });                                                                                                          // 251
      }                                                                                                              // 252
    });                                                                                                              // 253
  })();                                                                                                              // 254
}                                                                                                                    // 255
                                                                                                                     // 256
/// Helper for "livedata - runtime universal sub creation"                                                           // 257
                                                                                                                     // 258
if (Meteor.isServer) {                                                                                               // 259
  Meteor.methods({                                                                                                   // 260
    runtimeUniversalSubCreation: function (token) {                                                                  // 261
      check(token, String);                                                                                          // 262
      Meteor.publish(null, function () {                                                                             // 263
        this.added("runtimeSubCreation", token, {});                                                                 // 264
      });                                                                                                            // 265
    }                                                                                                                // 266
  });                                                                                                                // 267
}                                                                                                                    // 268
                                                                                                                     // 269
/// Helper for "livedata - publisher errors"                                                                         // 270
                                                                                                                     // 271
if (Meteor.isServer) {                                                                                               // 272
  Meteor.publish("publisherErrors", function (collName, options) {                                                   // 273
    check(collName, String);                                                                                         // 274
    // See below to see what options are accepted.                                                                   // 275
    check(options, Object);                                                                                          // 276
    var sub = this;                                                                                                  // 277
                                                                                                                     // 278
    // First add a random item, which should be cleaned up. We use ready/onReady                                     // 279
    // to make sure that the second test block is only called after the added is                                     // 280
    // processed, so that there's any chance of the coll.find().count() failing.                                     // 281
    sub.added(collName, Random.id(), {foo: 42});                                                                     // 282
    sub.ready();                                                                                                     // 283
                                                                                                                     // 284
    if (options.stopInHandler) {                                                                                     // 285
      sub.stop();                                                                                                    // 286
      return;                                                                                                        // 287
    }                                                                                                                // 288
                                                                                                                     // 289
    var error;                                                                                                       // 290
    if (options.internalError) {                                                                                     // 291
      error = new Error("Egads!");                                                                                   // 292
      error.expected = true;  // don't log                                                                           // 293
    } else {                                                                                                         // 294
      error = new Meteor.Error(412, "Explicit error");                                                               // 295
    }                                                                                                                // 296
    if (options.throwInHandler) {                                                                                    // 297
      throw error;                                                                                                   // 298
    } else if (options.errorInHandler) {                                                                             // 299
      sub.error(error);                                                                                              // 300
    } else if (options.throwWhenUserIdSet) {                                                                         // 301
      if (sub.userId)                                                                                                // 302
        throw error;                                                                                                 // 303
    } else if (options.errorLater) {                                                                                 // 304
      Meteor.defer(function () {                                                                                     // 305
        sub.error(error);                                                                                            // 306
      });                                                                                                            // 307
    }                                                                                                                // 308
  });                                                                                                                // 309
}                                                                                                                    // 310
                                                                                                                     // 311
                                                                                                                     // 312
/*****/                                                                                                              // 313
                                                                                                                     // 314
/// Helpers for "livedata - publish multiple cursors"                                                                // 315
One = new Meteor.Collection("collectionOne");                                                                        // 316
Two = new Meteor.Collection("collectionTwo");                                                                        // 317
                                                                                                                     // 318
if (Meteor.isServer) {                                                                                               // 319
  One.remove({});                                                                                                    // 320
  One.insert({name: "value1"});                                                                                      // 321
  One.insert({name: "value2"});                                                                                      // 322
                                                                                                                     // 323
  Two.remove({});                                                                                                    // 324
  Two.insert({name: "value3"});                                                                                      // 325
  Two.insert({name: "value4"});                                                                                      // 326
  Two.insert({name: "value5"});                                                                                      // 327
                                                                                                                     // 328
  Meteor.publish("multiPublish", function (options) {                                                                // 329
    // See below to see what options are accepted.                                                                   // 330
    check(options, Object);                                                                                          // 331
    if (options.normal) {                                                                                            // 332
      return [                                                                                                       // 333
        One.find(),                                                                                                  // 334
        Two.find()                                                                                                   // 335
      ];                                                                                                             // 336
    } else if (options.dup) {                                                                                        // 337
      // Suppress the log of the expected internal error.                                                            // 338
      Meteor._suppress_log(1);                                                                                       // 339
      return [                                                                                                       // 340
        One.find(),                                                                                                  // 341
        One.find({name: "value2"}), // multiple cursors for one collection - error                                   // 342
        Two.find()                                                                                                   // 343
      ];                                                                                                             // 344
    } else if (options.notCursor) {                                                                                  // 345
      // Suppress the log of the expected internal error.                                                            // 346
      Meteor._suppress_log(1);                                                                                       // 347
      return [                                                                                                       // 348
        One.find(),                                                                                                  // 349
        "not a cursor",                                                                                              // 350
        Two.find()                                                                                                   // 351
      ];                                                                                                             // 352
    } else                                                                                                           // 353
      throw "unexpected options";                                                                                    // 354
  });                                                                                                                // 355
}                                                                                                                    // 356
                                                                                                                     // 357
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/random_stream_tests.js                                                                          //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
Tinytest.add("livedata - DDP.randomStream", function (test) {                                                        // 1
  var randomSeed = Random.id();                                                                                      // 2
  var context = { randomSeed: randomSeed };                                                                          // 3
                                                                                                                     // 4
  var sequence = DDP._CurrentInvocation.withValue(context, function () {                                             // 5
    return DDP.randomStream('1');                                                                                    // 6
  });                                                                                                                // 7
                                                                                                                     // 8
  var seeds = sequence.alea.args;                                                                                    // 9
                                                                                                                     // 10
  test.equal(seeds.length, 2);                                                                                       // 11
  test.equal(seeds[0], randomSeed);                                                                                  // 12
  test.equal(seeds[1], '1');                                                                                         // 13
                                                                                                                     // 14
  var id1 = sequence.id();                                                                                           // 15
                                                                                                                     // 16
  // Clone the sequence by building it the same way RandomStream.get does                                            // 17
  var sequenceClone = Random.createWithSeeds.apply(null, seeds);                                                     // 18
  var id1Cloned = sequenceClone.id();                                                                                // 19
  var id2Cloned = sequenceClone.id();                                                                                // 20
  test.equal(id1, id1Cloned);                                                                                        // 21
                                                                                                                     // 22
  // We should get the same sequence when we use the same key                                                        // 23
  sequence = DDP._CurrentInvocation.withValue(context, function () {                                                 // 24
    return DDP.randomStream('1');                                                                                    // 25
  });                                                                                                                // 26
  seeds = sequence.alea.args;                                                                                        // 27
  test.equal(seeds.length, 2);                                                                                       // 28
  test.equal(seeds[0], randomSeed);                                                                                  // 29
  test.equal(seeds[1], '1');                                                                                         // 30
                                                                                                                     // 31
  // But we should be at the 'next' position in the stream                                                           // 32
  var id2 = sequence.id();                                                                                           // 33
                                                                                                                     // 34
  // Technically these could be equal, but likely to be a bug if hit                                                 // 35
  // http://search.dilbert.com/comic/Random%20Number%20Generator                                                     // 36
  test.notEqual(id1, id2);                                                                                           // 37
                                                                                                                     // 38
  test.equal(id2, id2Cloned);                                                                                        // 39
});                                                                                                                  // 40
                                                                                                                     // 41
Tinytest.add("livedata - DDP.randomStream with no-args", function (test) {                                           // 42
  DDP.randomStream().id();                                                                                           // 43
});                                                                                                                  // 44
                                                                                                                     // 45
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/livedata/stream_tests.js                                                                                 //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
Tinytest.add("stream - status", function (test) {                                                                    // 1
  // Very basic test. Just see that it runs and returns something. Not a                                             // 2
  // lot of coverage, but enough that it would have caught a recent bug.                                             // 3
  var status = Meteor.status();                                                                                      // 4
  test.equal(typeof status, "object");                                                                               // 5
  test.isTrue(status.status);                                                                                        // 6
  // Make sure backward-compatiblity names are defined.                                                              // 7
  test.equal(status.retryCount, status.retryCount);                                                                  // 8
  test.equal(status.retryTime, status.retryTime);                                                                    // 9
});                                                                                                                  // 10
                                                                                                                     // 11
testAsyncMulti("stream - reconnect", [                                                                               // 12
  function (test, expect) {                                                                                          // 13
    var callback = _.once(expect(function() {                                                                        // 14
      var status;                                                                                                    // 15
      status = Meteor.status();                                                                                      // 16
      test.equal(status.status, "connected");                                                                        // 17
                                                                                                                     // 18
      Meteor.reconnect();                                                                                            // 19
      status = Meteor.status();                                                                                      // 20
      test.equal(status.status, "connected");                                                                        // 21
                                                                                                                     // 22
      Meteor.reconnect({_force: true});                                                                              // 23
      status = Meteor.status();                                                                                      // 24
      test.equal(status.status, "waiting");                                                                          // 25
    }));                                                                                                             // 26
                                                                                                                     // 27
    if (Meteor.status().status !== "connected")                                                                      // 28
      Meteor.connection._stream.on('reset', callback);                                                               // 29
    else                                                                                                             // 30
      callback();                                                                                                    // 31
  }                                                                                                                  // 32
]);                                                                                                                  // 33
                                                                                                                     // 34
// Disconnecting and reconnecting transitions through the correct statuses.                                          // 35
testAsyncMulti("stream - basic disconnect", [                                                                        // 36
  function (test, expect) {                                                                                          // 37
    var history = [];                                                                                                // 38
    var stream = new LivedataTest.ClientStream("/");                                                                 // 39
    var onTestComplete = expect(function (unexpectedHistory) {                                                       // 40
      stream.disconnect();                                                                                           // 41
      if (unexpectedHistory) {                                                                                       // 42
        test.fail("Unexpected status history: " +                                                                    // 43
                  JSON.stringify(unexpectedHistory));                                                                // 44
      }                                                                                                              // 45
    });                                                                                                              // 46
                                                                                                                     // 47
    Deps.autorun(function() {                                                                                        // 48
      var status = stream.status();                                                                                  // 49
                                                                                                                     // 50
      if (_.last(history) !== status.status) {                                                                       // 51
        history.push(status.status);                                                                                 // 52
                                                                                                                     // 53
        if (_.isEqual(history, ["connecting"])) {                                                                    // 54
          // do nothing; wait for the next state                                                                     // 55
        } else if (_.isEqual(history, ["connecting", "connected"])) {                                                // 56
          stream.disconnect();                                                                                       // 57
        } else if (_.isEqual(history, ["connecting", "connected", "offline"])) {                                     // 58
          stream.reconnect();                                                                                        // 59
        } else if (_.isEqual(history, ["connecting", "connected", "offline",                                         // 60
                                       "connecting"])) {                                                             // 61
          // do nothing; wait for the next state                                                                     // 62
        } else if (_.isEqual(history, ["connecting", "connected", "offline",                                         // 63
                                "connecting", "connected"])) {                                                       // 64
          onTestComplete();                                                                                          // 65
        } else {                                                                                                     // 66
          onTestComplete(history);                                                                                   // 67
        }                                                                                                            // 68
      }                                                                                                              // 69
    });                                                                                                              // 70
  }                                                                                                                  // 71
]);                                                                                                                  // 72
                                                                                                                     // 73
// Remain offline if the online event is received while offline.                                                     // 74
testAsyncMulti("stream - disconnect remains offline", [                                                              // 75
  function (test, expect) {                                                                                          // 76
    var history = [];                                                                                                // 77
    var stream = new LivedataTest.ClientStream("/");                                                                 // 78
    var onTestComplete = expect(function (unexpectedHistory) {                                                       // 79
      stream.disconnect();                                                                                           // 80
      if (unexpectedHistory) {                                                                                       // 81
        test.fail("Unexpected status history: " +                                                                    // 82
                  JSON.stringify(unexpectedHistory));                                                                // 83
      }                                                                                                              // 84
    });                                                                                                              // 85
                                                                                                                     // 86
    Deps.autorun(function() {                                                                                        // 87
      var status = stream.status();                                                                                  // 88
                                                                                                                     // 89
      if (_.last(history) !== status.status) {                                                                       // 90
        history.push(status.status);                                                                                 // 91
                                                                                                                     // 92
        if (_.isEqual(history, ["connecting"])) {                                                                    // 93
          // do nothing; wait for the next status                                                                    // 94
        } else if (_.isEqual(history, ["connecting", "connected"])) {                                                // 95
          stream.disconnect();                                                                                       // 96
        } else if (_.isEqual(history, ["connecting", "connected", "offline"])) {                                     // 97
          stream._online();                                                                                          // 98
          test.isTrue(status.status === "offline");                                                                  // 99
          onTestComplete();                                                                                          // 100
        } else {                                                                                                     // 101
          onTestComplete(history);                                                                                   // 102
        }                                                                                                            // 103
      }                                                                                                              // 104
    });                                                                                                              // 105
  }                                                                                                                  // 106
]);                                                                                                                  // 107
                                                                                                                     // 108
Tinytest.add("stream - sockjs urls are computed correctly", function(test) {                                         // 109
  var testHasSockjsUrl = function(raw, expectedSockjsUrl) {                                                          // 110
    var actual = LivedataTest.toSockjsUrl(raw);                                                                      // 111
    if (expectedSockjsUrl instanceof RegExp)                                                                         // 112
      test.isTrue(actual.match(expectedSockjsUrl), actual);                                                          // 113
    else                                                                                                             // 114
      test.equal(actual, expectedSockjsUrl);                                                                         // 115
  };                                                                                                                 // 116
                                                                                                                     // 117
  testHasSockjsUrl("http://subdomain.meteor.com/",                                                                   // 118
                   "http://subdomain.meteor.com/sockjs");                                                            // 119
  testHasSockjsUrl("http://subdomain.meteor.com",                                                                    // 120
                   "http://subdomain.meteor.com/sockjs");                                                            // 121
  testHasSockjsUrl("subdomain.meteor.com/",                                                                          // 122
                   "http://subdomain.meteor.com/sockjs");                                                            // 123
  testHasSockjsUrl("subdomain.meteor.com",                                                                           // 124
                   "http://subdomain.meteor.com/sockjs");                                                            // 125
  testHasSockjsUrl("/", Meteor._relativeToSiteRootUrl("/sockjs"));                                                   // 126
                                                                                                                     // 127
  testHasSockjsUrl("http://localhost:3000/", "http://localhost:3000/sockjs");                                        // 128
  testHasSockjsUrl("http://localhost:3000", "http://localhost:3000/sockjs");                                         // 129
  testHasSockjsUrl("localhost:3000", "http://localhost:3000/sockjs");                                                // 130
                                                                                                                     // 131
  testHasSockjsUrl("https://subdomain.meteor.com/",                                                                  // 132
                   "https://subdomain.meteor.com/sockjs");                                                           // 133
  testHasSockjsUrl("https://subdomain.meteor.com",                                                                   // 134
                   "https://subdomain.meteor.com/sockjs");                                                           // 135
                                                                                                                     // 136
  testHasSockjsUrl("ddp+sockjs://ddp--****-foo.meteor.com/sockjs",                                                   // 137
                   /^https:\/\/ddp--\d\d\d\d-foo\.meteor\.com\/sockjs$/);                                            // 138
  testHasSockjsUrl("ddpi+sockjs://ddp--****-foo.meteor.com/sockjs",                                                  // 139
                   /^http:\/\/ddp--\d\d\d\d-foo\.meteor\.com\/sockjs$/);                                             // 140
});                                                                                                                  // 141
                                                                                                                     // 142
testAsyncMulti("stream - /websocket is a websocket endpoint", [                                                      // 143
  function(test, expect) {                                                                                           // 144
    //                                                                                                               // 145
    // Verify that /websocket and /websocket/ don't return the main page                                             // 146
    //                                                                                                               // 147
    _.each(['/websocket', '/websocket/'], function(path) {                                                           // 148
      HTTP.get(Meteor._relativeToSiteRootUrl(path), expect(function(error, result) {                                 // 149
        test.isNotNull(error);                                                                                       // 150
        test.equal('Can "Upgrade" only to "WebSocket".', result.content);                                            // 151
      }));                                                                                                           // 152
    });                                                                                                              // 153
                                                                                                                     // 154
    //                                                                                                               // 155
    // For sanity, also verify that /websockets and /websockets/ return                                              // 156
    // the main page                                                                                                 // 157
    //                                                                                                               // 158
                                                                                                                     // 159
    // Somewhat contorted but we can't call nested expects (XXX why?)                                                // 160
    var pageContent;                                                                                                 // 161
    var wrappedCallback = expect(function(error, result) {                                                           // 162
      test.isNull(error);                                                                                            // 163
      test.equal(pageContent, result.content);                                                                       // 164
    });                                                                                                              // 165
                                                                                                                     // 166
    HTTP.get(Meteor._relativeToSiteRootUrl('/'), expect(function(error, result) {                                    // 167
      test.isNull(error);                                                                                            // 168
      pageContent = result.content;                                                                                  // 169
                                                                                                                     // 170
      _.each(['/websockets', '/websockets/'], function(path) {                                                       // 171
        HTTP.get(Meteor._relativeToSiteRootUrl(path), wrappedCallback);                                              // 172
      });                                                                                                            // 173
    }));                                                                                                             // 174
  }                                                                                                                  // 175
]);                                                                                                                  // 176
                                                                                                                     // 177
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
