(function () {

(function () {

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// plugin/compile-less.js                                                   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
                                                                            //
var fs = Npm.require('fs');                                                 // 1
var path = Npm.require('path');                                             // 2
var less = Npm.require('less');                                             // 3
var Future = Npm.require('fibers/future');                                  // 4
                                                                            // 5
Plugin.registerSourceHandler("less", function (compileStep) {               // 6
  // XXX annoying that this is replicated in .css, .less, and .styl         // 7
  if (! compileStep.archMatches('browser')) {                               // 8
    // XXX in the future, might be better to emit some kind of a            // 9
    // warning if a stylesheet is included on the server, rather than       // 10
    // silently ignoring it. but that would mean you can't stick .css       // 11
    // at the top level of your app, which is kind of silly.                // 12
    return;                                                                 // 13
  }                                                                         // 14
                                                                            // 15
  var source = compileStep.read().toString('utf8');                         // 16
  var options = {                                                           // 17
    filename: compileStep.inputPath,                                        // 18
    // Use fs.readFileSync to process @imports. This is the bundler, so     // 19
    // that's not going to cause concurrency issues, and it means that (a)  // 20
    // we don't have to use Futures and (b) errors thrown by bugs in less   // 21
    // actually get caught.                                                 // 22
    syncImport: true,                                                       // 23
    paths: [path.dirname(compileStep._fullInputPath)] // for @import        // 24
  };                                                                        // 25
                                                                            // 26
  var parser = new less.Parser(options);                                    // 27
  var astFuture = new Future;                                               // 28
  var sourceMap = null;                                                     // 29
  try {                                                                     // 30
    parser.parse(source, astFuture.resolver());                             // 31
    var ast = astFuture.wait();                                             // 32
                                                                            // 33
    var css = ast.toCSS({                                                   // 34
      sourceMap: true,                                                      // 35
      writeSourceMap: function (sm) {                                       // 36
        sourceMap = JSON.parse(sm);                                         // 37
      }                                                                     // 38
    });                                                                     // 39
  } catch (e) {                                                             // 40
    // less.Parser.parse is supposed to report any errors via its           // 41
    // callback. But sometimes, it throws them instead. This is             // 42
    // probably a bug in less. Be prepared for either behavior.             // 43
    compileStep.error({                                                     // 44
      message: "Less compiler error: " + e.message,                         // 45
      sourcePath: e.filename || compileStep.inputPath,                      // 46
      line: e.line,                                                         // 47
      column: e.column + 1                                                  // 48
    });                                                                     // 49
    return;                                                                 // 50
  }                                                                         // 51
                                                                            // 52
                                                                            // 53
  if (sourceMap) {                                                          // 54
    sourceMap.sources = [compileStep.inputPath];                            // 55
    sourceMap.sourcesContent = [source];                                    // 56
    sourceMap = JSON.stringify(sourceMap);                                  // 57
  }                                                                         // 58
                                                                            // 59
  compileStep.addStylesheet({                                               // 60
    path: compileStep.inputPath + ".css",                                   // 61
    data: css,                                                              // 62
    sourceMap: sourceMap                                                    // 63
  });                                                                       // 64
});;                                                                        // 65
                                                                            // 66
// Register import.less files with the dependency watcher, without actually // 67
// processing them. There is a similar rule in the stylus package.          // 68
Plugin.registerSourceHandler("import.less", function () {                   // 69
  // Do nothing                                                             // 70
});                                                                         // 71
                                                                            // 72
// Backward compatibility with Meteor 0.7                                   // 73
Plugin.registerSourceHandler("lessimport", function () {});                 // 74
                                                                            // 75
//////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package.compileLess = {};

})();

//# sourceMappingURL=compileLessplugin.js.map
