(function () {

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/jquery/jquery.js                                                                                         //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
/*!                                                                                                                  // 1
 * jQuery JavaScript Library v1.11.0                                                                                 // 2
 * http://jquery.com/                                                                                                // 3
 *                                                                                                                   // 4
 * Includes Sizzle.js                                                                                                // 5
 * http://sizzlejs.com/                                                                                              // 6
 *                                                                                                                   // 7
 * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors                                               // 8
 * Released under the MIT license                                                                                    // 9
 * http://jquery.org/license                                                                                         // 10
 *                                                                                                                   // 11
 * Date: 2014-01-23T21:02Z                                                                                           // 12
 */                                                                                                                  // 13
                                                                                                                     // 14
(function( global, factory ) {                                                                                       // 15
                                                                                                                     // 16
	if ( typeof module === "object" && typeof module.exports === "object" ) {                                           // 17
		// For CommonJS and CommonJS-like environments where a proper window is present,                                   // 18
		// execute the factory and get jQuery                                                                              // 19
		// For environments that do not inherently posses a window with a document                                         // 20
		// (such as Node.js), expose a jQuery-making factory as module.exports                                             // 21
		// This accentuates the need for the creation of a real window                                                     // 22
		// e.g. var jQuery = require("jquery")(window);                                                                    // 23
		// See ticket #14549 for more info                                                                                 // 24
		module.exports = global.document ?                                                                                 // 25
			factory( global, true ) :                                                                                         // 26
			function( w ) {                                                                                                   // 27
				if ( !w.document ) {                                                                                             // 28
					throw new Error( "jQuery requires a window with a document" );                                                  // 29
				}                                                                                                                // 30
				return factory( w );                                                                                             // 31
			};                                                                                                                // 32
	} else {                                                                                                            // 33
		factory( global );                                                                                                 // 34
	}                                                                                                                   // 35
                                                                                                                     // 36
// Pass this if window is not defined yet                                                                            // 37
}(typeof window !== "undefined" ? window : this, function( window, noGlobal ) {                                      // 38
                                                                                                                     // 39
// Can't do this because several apps including ASP.NET trace                                                        // 40
// the stack via arguments.caller.callee and Firefox dies if                                                         // 41
// you try to trace through "use strict" call chains. (#13335)                                                       // 42
// Support: Firefox 18+                                                                                              // 43
//                                                                                                                   // 44
                                                                                                                     // 45
var deletedIds = [];                                                                                                 // 46
                                                                                                                     // 47
var slice = deletedIds.slice;                                                                                        // 48
                                                                                                                     // 49
var concat = deletedIds.concat;                                                                                      // 50
                                                                                                                     // 51
var push = deletedIds.push;                                                                                          // 52
                                                                                                                     // 53
var indexOf = deletedIds.indexOf;                                                                                    // 54
                                                                                                                     // 55
var class2type = {};                                                                                                 // 56
                                                                                                                     // 57
var toString = class2type.toString;                                                                                  // 58
                                                                                                                     // 59
var hasOwn = class2type.hasOwnProperty;                                                                              // 60
                                                                                                                     // 61
var trim = "".trim;                                                                                                  // 62
                                                                                                                     // 63
var support = {};                                                                                                    // 64
                                                                                                                     // 65
                                                                                                                     // 66
                                                                                                                     // 67
var                                                                                                                  // 68
	version = "1.11.0",                                                                                                 // 69
                                                                                                                     // 70
	// Define a local copy of jQuery                                                                                    // 71
	jQuery = function( selector, context ) {                                                                            // 72
		// The jQuery object is actually just the init constructor 'enhanced'                                              // 73
		// Need init if jQuery is called (just allow error to be thrown if not included)                                   // 74
		return new jQuery.fn.init( selector, context );                                                                    // 75
	},                                                                                                                  // 76
                                                                                                                     // 77
	// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)                                        // 78
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,                                                                       // 79
                                                                                                                     // 80
	// Matches dashed string for camelizing                                                                             // 81
	rmsPrefix = /^-ms-/,                                                                                                // 82
	rdashAlpha = /-([\da-z])/gi,                                                                                        // 83
                                                                                                                     // 84
	// Used by jQuery.camelCase as callback to replace()                                                                // 85
	fcamelCase = function( all, letter ) {                                                                              // 86
		return letter.toUpperCase();                                                                                       // 87
	};                                                                                                                  // 88
                                                                                                                     // 89
jQuery.fn = jQuery.prototype = {                                                                                     // 90
	// The current version of jQuery being used                                                                         // 91
	jquery: version,                                                                                                    // 92
                                                                                                                     // 93
	constructor: jQuery,                                                                                                // 94
                                                                                                                     // 95
	// Start with an empty selector                                                                                     // 96
	selector: "",                                                                                                       // 97
                                                                                                                     // 98
	// The default length of a jQuery object is 0                                                                       // 99
	length: 0,                                                                                                          // 100
                                                                                                                     // 101
	toArray: function() {                                                                                               // 102
		return slice.call( this );                                                                                         // 103
	},                                                                                                                  // 104
                                                                                                                     // 105
	// Get the Nth element in the matched element set OR                                                                // 106
	// Get the whole matched element set as a clean array                                                               // 107
	get: function( num ) {                                                                                              // 108
		return num != null ?                                                                                               // 109
                                                                                                                     // 110
			// Return a 'clean' array                                                                                         // 111
			( num < 0 ? this[ num + this.length ] : this[ num ] ) :                                                           // 112
                                                                                                                     // 113
			// Return just the object                                                                                         // 114
			slice.call( this );                                                                                               // 115
	},                                                                                                                  // 116
                                                                                                                     // 117
	// Take an array of elements and push it onto the stack                                                             // 118
	// (returning the new matched element set)                                                                          // 119
	pushStack: function( elems ) {                                                                                      // 120
                                                                                                                     // 121
		// Build a new jQuery matched element set                                                                          // 122
		var ret = jQuery.merge( this.constructor(), elems );                                                               // 123
                                                                                                                     // 124
		// Add the old object onto the stack (as a reference)                                                              // 125
		ret.prevObject = this;                                                                                             // 126
		ret.context = this.context;                                                                                        // 127
                                                                                                                     // 128
		// Return the newly-formed element set                                                                             // 129
		return ret;                                                                                                        // 130
	},                                                                                                                  // 131
                                                                                                                     // 132
	// Execute a callback for every element in the matched set.                                                         // 133
	// (You can seed the arguments with an array of args, but this is                                                   // 134
	// only used internally.)                                                                                           // 135
	each: function( callback, args ) {                                                                                  // 136
		return jQuery.each( this, callback, args );                                                                        // 137
	},                                                                                                                  // 138
                                                                                                                     // 139
	map: function( callback ) {                                                                                         // 140
		return this.pushStack( jQuery.map(this, function( elem, i ) {                                                      // 141
			return callback.call( elem, i, elem );                                                                            // 142
		}));                                                                                                               // 143
	},                                                                                                                  // 144
                                                                                                                     // 145
	slice: function() {                                                                                                 // 146
		return this.pushStack( slice.apply( this, arguments ) );                                                           // 147
	},                                                                                                                  // 148
                                                                                                                     // 149
	first: function() {                                                                                                 // 150
		return this.eq( 0 );                                                                                               // 151
	},                                                                                                                  // 152
                                                                                                                     // 153
	last: function() {                                                                                                  // 154
		return this.eq( -1 );                                                                                              // 155
	},                                                                                                                  // 156
                                                                                                                     // 157
	eq: function( i ) {                                                                                                 // 158
		var len = this.length,                                                                                             // 159
			j = +i + ( i < 0 ? len : 0 );                                                                                     // 160
		return this.pushStack( j >= 0 && j < len ? [ this[j] ] : [] );                                                     // 161
	},                                                                                                                  // 162
                                                                                                                     // 163
	end: function() {                                                                                                   // 164
		return this.prevObject || this.constructor(null);                                                                  // 165
	},                                                                                                                  // 166
                                                                                                                     // 167
	// For internal use only.                                                                                           // 168
	// Behaves like an Array's method, not like a jQuery method.                                                        // 169
	push: push,                                                                                                         // 170
	sort: deletedIds.sort,                                                                                              // 171
	splice: deletedIds.splice                                                                                           // 172
};                                                                                                                   // 173
                                                                                                                     // 174
jQuery.extend = jQuery.fn.extend = function() {                                                                      // 175
	var src, copyIsArray, copy, name, options, clone,                                                                   // 176
		target = arguments[0] || {},                                                                                       // 177
		i = 1,                                                                                                             // 178
		length = arguments.length,                                                                                         // 179
		deep = false;                                                                                                      // 180
                                                                                                                     // 181
	// Handle a deep copy situation                                                                                     // 182
	if ( typeof target === "boolean" ) {                                                                                // 183
		deep = target;                                                                                                     // 184
                                                                                                                     // 185
		// skip the boolean and the target                                                                                 // 186
		target = arguments[ i ] || {};                                                                                     // 187
		i++;                                                                                                               // 188
	}                                                                                                                   // 189
                                                                                                                     // 190
	// Handle case when target is a string or something (possible in deep copy)                                         // 191
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {                                                   // 192
		target = {};                                                                                                       // 193
	}                                                                                                                   // 194
                                                                                                                     // 195
	// extend jQuery itself if only one argument is passed                                                              // 196
	if ( i === length ) {                                                                                               // 197
		target = this;                                                                                                     // 198
		i--;                                                                                                               // 199
	}                                                                                                                   // 200
                                                                                                                     // 201
	for ( ; i < length; i++ ) {                                                                                         // 202
		// Only deal with non-null/undefined values                                                                        // 203
		if ( (options = arguments[ i ]) != null ) {                                                                        // 204
			// Extend the base object                                                                                         // 205
			for ( name in options ) {                                                                                         // 206
				src = target[ name ];                                                                                            // 207
				copy = options[ name ];                                                                                          // 208
                                                                                                                     // 209
				// Prevent never-ending loop                                                                                     // 210
				if ( target === copy ) {                                                                                         // 211
					continue;                                                                                                       // 212
				}                                                                                                                // 213
                                                                                                                     // 214
				// Recurse if we're merging plain objects or arrays                                                              // 215
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {                  // 216
					if ( copyIsArray ) {                                                                                            // 217
						copyIsArray = false;                                                                                           // 218
						clone = src && jQuery.isArray(src) ? src : [];                                                                 // 219
                                                                                                                     // 220
					} else {                                                                                                        // 221
						clone = src && jQuery.isPlainObject(src) ? src : {};                                                           // 222
					}                                                                                                               // 223
                                                                                                                     // 224
					// Never move original objects, clone them                                                                      // 225
					target[ name ] = jQuery.extend( deep, clone, copy );                                                            // 226
                                                                                                                     // 227
				// Don't bring in undefined values                                                                               // 228
				} else if ( copy !== undefined ) {                                                                               // 229
					target[ name ] = copy;                                                                                          // 230
				}                                                                                                                // 231
			}                                                                                                                 // 232
		}                                                                                                                  // 233
	}                                                                                                                   // 234
                                                                                                                     // 235
	// Return the modified object                                                                                       // 236
	return target;                                                                                                      // 237
};                                                                                                                   // 238
                                                                                                                     // 239
jQuery.extend({                                                                                                      // 240
	// Unique for each copy of jQuery on the page                                                                       // 241
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),                                               // 242
                                                                                                                     // 243
	// Assume jQuery is ready without the ready module                                                                  // 244
	isReady: true,                                                                                                      // 245
                                                                                                                     // 246
	error: function( msg ) {                                                                                            // 247
		throw new Error( msg );                                                                                            // 248
	},                                                                                                                  // 249
                                                                                                                     // 250
	noop: function() {},                                                                                                // 251
                                                                                                                     // 252
	// See test/unit/core.js for details concerning isFunction.                                                         // 253
	// Since version 1.3, DOM methods and functions like alert                                                          // 254
	// aren't supported. They return false on IE (#2968).                                                               // 255
	isFunction: function( obj ) {                                                                                       // 256
		return jQuery.type(obj) === "function";                                                                            // 257
	},                                                                                                                  // 258
                                                                                                                     // 259
	isArray: Array.isArray || function( obj ) {                                                                         // 260
		return jQuery.type(obj) === "array";                                                                               // 261
	},                                                                                                                  // 262
                                                                                                                     // 263
	isWindow: function( obj ) {                                                                                         // 264
		/* jshint eqeqeq: false */                                                                                         // 265
		return obj != null && obj == obj.window;                                                                           // 266
	},                                                                                                                  // 267
                                                                                                                     // 268
	isNumeric: function( obj ) {                                                                                        // 269
		// parseFloat NaNs numeric-cast false positives (null|true|false|"")                                               // 270
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")                                // 271
		// subtraction forces infinities to NaN                                                                            // 272
		return obj - parseFloat( obj ) >= 0;                                                                               // 273
	},                                                                                                                  // 274
                                                                                                                     // 275
	isEmptyObject: function( obj ) {                                                                                    // 276
		var name;                                                                                                          // 277
		for ( name in obj ) {                                                                                              // 278
			return false;                                                                                                     // 279
		}                                                                                                                  // 280
		return true;                                                                                                       // 281
	},                                                                                                                  // 282
                                                                                                                     // 283
	isPlainObject: function( obj ) {                                                                                    // 284
		var key;                                                                                                           // 285
                                                                                                                     // 286
		// Must be an Object.                                                                                              // 287
		// Because of IE, we also have to check the presence of the constructor property.                                  // 288
		// Make sure that DOM nodes and window objects don't pass through, as well                                         // 289
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {                           // 290
			return false;                                                                                                     // 291
		}                                                                                                                  // 292
                                                                                                                     // 293
		try {                                                                                                              // 294
			// Not own constructor property must be Object                                                                    // 295
			if ( obj.constructor &&                                                                                           // 296
				!hasOwn.call(obj, "constructor") &&                                                                              // 297
				!hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {                                                     // 298
				return false;                                                                                                    // 299
			}                                                                                                                 // 300
		} catch ( e ) {                                                                                                    // 301
			// IE8,9 Will throw exceptions on certain host objects #9897                                                      // 302
			return false;                                                                                                     // 303
		}                                                                                                                  // 304
                                                                                                                     // 305
		// Support: IE<9                                                                                                   // 306
		// Handle iteration over inherited properties before own properties.                                               // 307
		if ( support.ownLast ) {                                                                                           // 308
			for ( key in obj ) {                                                                                              // 309
				return hasOwn.call( obj, key );                                                                                  // 310
			}                                                                                                                 // 311
		}                                                                                                                  // 312
                                                                                                                     // 313
		// Own properties are enumerated firstly, so to speed up,                                                          // 314
		// if last one is own, then all properties are own.                                                                // 315
		for ( key in obj ) {}                                                                                              // 316
                                                                                                                     // 317
		return key === undefined || hasOwn.call( obj, key );                                                               // 318
	},                                                                                                                  // 319
                                                                                                                     // 320
	type: function( obj ) {                                                                                             // 321
		if ( obj == null ) {                                                                                               // 322
			return obj + "";                                                                                                  // 323
		}                                                                                                                  // 324
		return typeof obj === "object" || typeof obj === "function" ?                                                      // 325
			class2type[ toString.call(obj) ] || "object" :                                                                    // 326
			typeof obj;                                                                                                       // 327
	},                                                                                                                  // 328
                                                                                                                     // 329
	// Evaluates a script in a global context                                                                           // 330
	// Workarounds based on findings by Jim Driscoll                                                                    // 331
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context                          // 332
	globalEval: function( data ) {                                                                                      // 333
		if ( data && jQuery.trim( data ) ) {                                                                               // 334
			// We use execScript on Internet Explorer                                                                         // 335
			// We use an anonymous function so that context is window                                                         // 336
			// rather than jQuery in Firefox                                                                                  // 337
			( window.execScript || function( data ) {                                                                         // 338
				window[ "eval" ].call( window, data );                                                                           // 339
			} )( data );                                                                                                      // 340
		}                                                                                                                  // 341
	},                                                                                                                  // 342
                                                                                                                     // 343
	// Convert dashed to camelCase; used by the css and data modules                                                    // 344
	// Microsoft forgot to hump their vendor prefix (#9572)                                                             // 345
	camelCase: function( string ) {                                                                                     // 346
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );                                       // 347
	},                                                                                                                  // 348
                                                                                                                     // 349
	nodeName: function( elem, name ) {                                                                                  // 350
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();                                        // 351
	},                                                                                                                  // 352
                                                                                                                     // 353
	// args is for internal usage only                                                                                  // 354
	each: function( obj, callback, args ) {                                                                             // 355
		var value,                                                                                                         // 356
			i = 0,                                                                                                            // 357
			length = obj.length,                                                                                              // 358
			isArray = isArraylike( obj );                                                                                     // 359
                                                                                                                     // 360
		if ( args ) {                                                                                                      // 361
			if ( isArray ) {                                                                                                  // 362
				for ( ; i < length; i++ ) {                                                                                      // 363
					value = callback.apply( obj[ i ], args );                                                                       // 364
                                                                                                                     // 365
					if ( value === false ) {                                                                                        // 366
						break;                                                                                                         // 367
					}                                                                                                               // 368
				}                                                                                                                // 369
			} else {                                                                                                          // 370
				for ( i in obj ) {                                                                                               // 371
					value = callback.apply( obj[ i ], args );                                                                       // 372
                                                                                                                     // 373
					if ( value === false ) {                                                                                        // 374
						break;                                                                                                         // 375
					}                                                                                                               // 376
				}                                                                                                                // 377
			}                                                                                                                 // 378
                                                                                                                     // 379
		// A special, fast, case for the most common use of each                                                           // 380
		} else {                                                                                                           // 381
			if ( isArray ) {                                                                                                  // 382
				for ( ; i < length; i++ ) {                                                                                      // 383
					value = callback.call( obj[ i ], i, obj[ i ] );                                                                 // 384
                                                                                                                     // 385
					if ( value === false ) {                                                                                        // 386
						break;                                                                                                         // 387
					}                                                                                                               // 388
				}                                                                                                                // 389
			} else {                                                                                                          // 390
				for ( i in obj ) {                                                                                               // 391
					value = callback.call( obj[ i ], i, obj[ i ] );                                                                 // 392
                                                                                                                     // 393
					if ( value === false ) {                                                                                        // 394
						break;                                                                                                         // 395
					}                                                                                                               // 396
				}                                                                                                                // 397
			}                                                                                                                 // 398
		}                                                                                                                  // 399
                                                                                                                     // 400
		return obj;                                                                                                        // 401
	},                                                                                                                  // 402
                                                                                                                     // 403
	// Use native String.trim function wherever possible                                                                // 404
	trim: trim && !trim.call("\uFEFF\xA0") ?                                                                            // 405
		function( text ) {                                                                                                 // 406
			return text == null ?                                                                                             // 407
				"" :                                                                                                             // 408
				trim.call( text );                                                                                               // 409
		} :                                                                                                                // 410
                                                                                                                     // 411
		// Otherwise use our own trimming functionality                                                                    // 412
		function( text ) {                                                                                                 // 413
			return text == null ?                                                                                             // 414
				"" :                                                                                                             // 415
				( text + "" ).replace( rtrim, "" );                                                                              // 416
		},                                                                                                                 // 417
                                                                                                                     // 418
	// results is for internal usage only                                                                               // 419
	makeArray: function( arr, results ) {                                                                               // 420
		var ret = results || [];                                                                                           // 421
                                                                                                                     // 422
		if ( arr != null ) {                                                                                               // 423
			if ( isArraylike( Object(arr) ) ) {                                                                               // 424
				jQuery.merge( ret,                                                                                               // 425
					typeof arr === "string" ?                                                                                       // 426
					[ arr ] : arr                                                                                                   // 427
				);                                                                                                               // 428
			} else {                                                                                                          // 429
				push.call( ret, arr );                                                                                           // 430
			}                                                                                                                 // 431
		}                                                                                                                  // 432
                                                                                                                     // 433
		return ret;                                                                                                        // 434
	},                                                                                                                  // 435
                                                                                                                     // 436
	inArray: function( elem, arr, i ) {                                                                                 // 437
		var len;                                                                                                           // 438
                                                                                                                     // 439
		if ( arr ) {                                                                                                       // 440
			if ( indexOf ) {                                                                                                  // 441
				return indexOf.call( arr, elem, i );                                                                             // 442
			}                                                                                                                 // 443
                                                                                                                     // 444
			len = arr.length;                                                                                                 // 445
			i = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;                                                                   // 446
                                                                                                                     // 447
			for ( ; i < len; i++ ) {                                                                                          // 448
				// Skip accessing in sparse arrays                                                                               // 449
				if ( i in arr && arr[ i ] === elem ) {                                                                           // 450
					return i;                                                                                                       // 451
				}                                                                                                                // 452
			}                                                                                                                 // 453
		}                                                                                                                  // 454
                                                                                                                     // 455
		return -1;                                                                                                         // 456
	},                                                                                                                  // 457
                                                                                                                     // 458
	merge: function( first, second ) {                                                                                  // 459
		var len = +second.length,                                                                                          // 460
			j = 0,                                                                                                            // 461
			i = first.length;                                                                                                 // 462
                                                                                                                     // 463
		while ( j < len ) {                                                                                                // 464
			first[ i++ ] = second[ j++ ];                                                                                     // 465
		}                                                                                                                  // 466
                                                                                                                     // 467
		// Support: IE<9                                                                                                   // 468
		// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)                           // 469
		if ( len !== len ) {                                                                                               // 470
			while ( second[j] !== undefined ) {                                                                               // 471
				first[ i++ ] = second[ j++ ];                                                                                    // 472
			}                                                                                                                 // 473
		}                                                                                                                  // 474
                                                                                                                     // 475
		first.length = i;                                                                                                  // 476
                                                                                                                     // 477
		return first;                                                                                                      // 478
	},                                                                                                                  // 479
                                                                                                                     // 480
	grep: function( elems, callback, invert ) {                                                                         // 481
		var callbackInverse,                                                                                               // 482
			matches = [],                                                                                                     // 483
			i = 0,                                                                                                            // 484
			length = elems.length,                                                                                            // 485
			callbackExpect = !invert;                                                                                         // 486
                                                                                                                     // 487
		// Go through the array, only saving the items                                                                     // 488
		// that pass the validator function                                                                                // 489
		for ( ; i < length; i++ ) {                                                                                        // 490
			callbackInverse = !callback( elems[ i ], i );                                                                     // 491
			if ( callbackInverse !== callbackExpect ) {                                                                       // 492
				matches.push( elems[ i ] );                                                                                      // 493
			}                                                                                                                 // 494
		}                                                                                                                  // 495
                                                                                                                     // 496
		return matches;                                                                                                    // 497
	},                                                                                                                  // 498
                                                                                                                     // 499
	// arg is for internal usage only                                                                                   // 500
	map: function( elems, callback, arg ) {                                                                             // 501
		var value,                                                                                                         // 502
			i = 0,                                                                                                            // 503
			length = elems.length,                                                                                            // 504
			isArray = isArraylike( elems ),                                                                                   // 505
			ret = [];                                                                                                         // 506
                                                                                                                     // 507
		// Go through the array, translating each of the items to their new values                                         // 508
		if ( isArray ) {                                                                                                   // 509
			for ( ; i < length; i++ ) {                                                                                       // 510
				value = callback( elems[ i ], i, arg );                                                                          // 511
                                                                                                                     // 512
				if ( value != null ) {                                                                                           // 513
					ret.push( value );                                                                                              // 514
				}                                                                                                                // 515
			}                                                                                                                 // 516
                                                                                                                     // 517
		// Go through every key on the object,                                                                             // 518
		} else {                                                                                                           // 519
			for ( i in elems ) {                                                                                              // 520
				value = callback( elems[ i ], i, arg );                                                                          // 521
                                                                                                                     // 522
				if ( value != null ) {                                                                                           // 523
					ret.push( value );                                                                                              // 524
				}                                                                                                                // 525
			}                                                                                                                 // 526
		}                                                                                                                  // 527
                                                                                                                     // 528
		// Flatten any nested arrays                                                                                       // 529
		return concat.apply( [], ret );                                                                                    // 530
	},                                                                                                                  // 531
                                                                                                                     // 532
	// A global GUID counter for objects                                                                                // 533
	guid: 1,                                                                                                            // 534
                                                                                                                     // 535
	// Bind a function to a context, optionally partially applying any                                                  // 536
	// arguments.                                                                                                       // 537
	proxy: function( fn, context ) {                                                                                    // 538
		var args, proxy, tmp;                                                                                              // 539
                                                                                                                     // 540
		if ( typeof context === "string" ) {                                                                               // 541
			tmp = fn[ context ];                                                                                              // 542
			context = fn;                                                                                                     // 543
			fn = tmp;                                                                                                         // 544
		}                                                                                                                  // 545
                                                                                                                     // 546
		// Quick check to determine if target is callable, in the spec                                                     // 547
		// this throws a TypeError, but we will just return undefined.                                                     // 548
		if ( !jQuery.isFunction( fn ) ) {                                                                                  // 549
			return undefined;                                                                                                 // 550
		}                                                                                                                  // 551
                                                                                                                     // 552
		// Simulated bind                                                                                                  // 553
		args = slice.call( arguments, 2 );                                                                                 // 554
		proxy = function() {                                                                                               // 555
			return fn.apply( context || this, args.concat( slice.call( arguments ) ) );                                       // 556
		};                                                                                                                 // 557
                                                                                                                     // 558
		// Set the guid of unique handler to the same of original handler, so it can be removed                            // 559
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;                                                                   // 560
                                                                                                                     // 561
		return proxy;                                                                                                      // 562
	},                                                                                                                  // 563
                                                                                                                     // 564
	now: function() {                                                                                                   // 565
		return +( new Date() );                                                                                            // 566
	},                                                                                                                  // 567
                                                                                                                     // 568
	// jQuery.support is not used in Core but other projects attach their                                               // 569
	// properties to it so it needs to exist.                                                                           // 570
	support: support                                                                                                    // 571
});                                                                                                                  // 572
                                                                                                                     // 573
// Populate the class2type map                                                                                       // 574
jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {          // 575
	class2type[ "[object " + name + "]" ] = name.toLowerCase();                                                         // 576
});                                                                                                                  // 577
                                                                                                                     // 578
function isArraylike( obj ) {                                                                                        // 579
	var length = obj.length,                                                                                            // 580
		type = jQuery.type( obj );                                                                                         // 581
                                                                                                                     // 582
	if ( type === "function" || jQuery.isWindow( obj ) ) {                                                              // 583
		return false;                                                                                                      // 584
	}                                                                                                                   // 585
                                                                                                                     // 586
	if ( obj.nodeType === 1 && length ) {                                                                               // 587
		return true;                                                                                                       // 588
	}                                                                                                                   // 589
                                                                                                                     // 590
	return type === "array" || length === 0 ||                                                                          // 591
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;                                                 // 592
}                                                                                                                    // 593
var Sizzle =                                                                                                         // 594
/*!                                                                                                                  // 595
 * Sizzle CSS Selector Engine v1.10.16                                                                               // 596
 * http://sizzlejs.com/                                                                                              // 597
 *                                                                                                                   // 598
 * Copyright 2013 jQuery Foundation, Inc. and other contributors                                                     // 599
 * Released under the MIT license                                                                                    // 600
 * http://jquery.org/license                                                                                         // 601
 *                                                                                                                   // 602
 * Date: 2014-01-13                                                                                                  // 603
 */                                                                                                                  // 604
(function( window ) {                                                                                                // 605
                                                                                                                     // 606
var i,                                                                                                               // 607
	support,                                                                                                            // 608
	Expr,                                                                                                               // 609
	getText,                                                                                                            // 610
	isXML,                                                                                                              // 611
	compile,                                                                                                            // 612
	outermostContext,                                                                                                   // 613
	sortInput,                                                                                                          // 614
	hasDuplicate,                                                                                                       // 615
                                                                                                                     // 616
	// Local document vars                                                                                              // 617
	setDocument,                                                                                                        // 618
	document,                                                                                                           // 619
	docElem,                                                                                                            // 620
	documentIsHTML,                                                                                                     // 621
	rbuggyQSA,                                                                                                          // 622
	rbuggyMatches,                                                                                                      // 623
	matches,                                                                                                            // 624
	contains,                                                                                                           // 625
                                                                                                                     // 626
	// Instance-specific data                                                                                           // 627
	expando = "sizzle" + -(new Date()),                                                                                 // 628
	preferredDoc = window.document,                                                                                     // 629
	dirruns = 0,                                                                                                        // 630
	done = 0,                                                                                                           // 631
	classCache = createCache(),                                                                                         // 632
	tokenCache = createCache(),                                                                                         // 633
	compilerCache = createCache(),                                                                                      // 634
	sortOrder = function( a, b ) {                                                                                      // 635
		if ( a === b ) {                                                                                                   // 636
			hasDuplicate = true;                                                                                              // 637
		}                                                                                                                  // 638
		return 0;                                                                                                          // 639
	},                                                                                                                  // 640
                                                                                                                     // 641
	// General-purpose constants                                                                                        // 642
	strundefined = typeof undefined,                                                                                    // 643
	MAX_NEGATIVE = 1 << 31,                                                                                             // 644
                                                                                                                     // 645
	// Instance methods                                                                                                 // 646
	hasOwn = ({}).hasOwnProperty,                                                                                       // 647
	arr = [],                                                                                                           // 648
	pop = arr.pop,                                                                                                      // 649
	push_native = arr.push,                                                                                             // 650
	push = arr.push,                                                                                                    // 651
	slice = arr.slice,                                                                                                  // 652
	// Use a stripped-down indexOf if we can't use a native one                                                         // 653
	indexOf = arr.indexOf || function( elem ) {                                                                         // 654
		var i = 0,                                                                                                         // 655
			len = this.length;                                                                                                // 656
		for ( ; i < len; i++ ) {                                                                                           // 657
			if ( this[i] === elem ) {                                                                                         // 658
				return i;                                                                                                        // 659
			}                                                                                                                 // 660
		}                                                                                                                  // 661
		return -1;                                                                                                         // 662
	},                                                                                                                  // 663
                                                                                                                     // 664
	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",
                                                                                                                     // 666
	// Regular expressions                                                                                              // 667
                                                                                                                     // 668
	// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace                                            // 669
	whitespace = "[\\x20\\t\\r\\n\\f]",                                                                                 // 670
	// http://www.w3.org/TR/css3-syntax/#characters                                                                     // 671
	characterEncoding = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",                                                             // 672
                                                                                                                     // 673
	// Loosely modeled on CSS identifier characters                                                                     // 674
	// An unquoted value should be a CSS identifier http://www.w3.org/TR/css3-selectors/#attribute-selectors            // 675
	// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier                                      // 676
	identifier = characterEncoding.replace( "w", "w#" ),                                                                // 677
                                                                                                                     // 678
	// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors                                         // 679
	attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +                                     // 680
		"*(?:([*^$|!~]?=)" + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",
                                                                                                                     // 682
	// Prefer arguments quoted,                                                                                         // 683
	//   then not containing pseudos/brackets,                                                                          // 684
	//   then attribute selectors/non-parenthetical expressions,                                                        // 685
	//   then anything else                                                                                             // 686
	// These preferences are here to reduce the number of selectors                                                     // 687
	//   needing tokenize in the PSEUDO preFilter                                                                       // 688
	pseudos = ":(" + characterEncoding + ")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|" + attributes.replace( 3, 8 ) + ")*)|.*)\\)|)",
                                                                                                                     // 690
	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter       // 691
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),                    // 692
                                                                                                                     // 693
	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),                                                  // 694
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),                   // 695
                                                                                                                     // 696
	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),                    // 697
                                                                                                                     // 698
	rpseudo = new RegExp( pseudos ),                                                                                    // 699
	ridentifier = new RegExp( "^" + identifier + "$" ),                                                                 // 700
                                                                                                                     // 701
	matchExpr = {                                                                                                       // 702
		"ID": new RegExp( "^#(" + characterEncoding + ")" ),                                                               // 703
		"CLASS": new RegExp( "^\\.(" + characterEncoding + ")" ),                                                          // 704
		"TAG": new RegExp( "^(" + characterEncoding.replace( "w", "w*" ) + ")" ),                                          // 705
		"ATTR": new RegExp( "^" + attributes ),                                                                            // 706
		"PSEUDO": new RegExp( "^" + pseudos ),                                                                             // 707
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +                       // 708
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +                                        // 709
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),                                                                      // 710
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),                                                               // 711
		// For use in libraries implementing .is()                                                                         // 712
		// We use this for POS matching in `select`                                                                        // 713
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +                // 714
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )                                          // 715
	},                                                                                                                  // 716
                                                                                                                     // 717
	rinputs = /^(?:input|select|textarea|button)$/i,                                                                    // 718
	rheader = /^h\d$/i,                                                                                                 // 719
                                                                                                                     // 720
	rnative = /^[^{]+\{\s*\[native \w/,                                                                                 // 721
                                                                                                                     // 722
	// Easily-parseable/retrievable ID or TAG or CLASS selectors                                                        // 723
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,                                                                    // 724
                                                                                                                     // 725
	rsibling = /[+~]/,                                                                                                  // 726
	rescape = /'|\\/g,                                                                                                  // 727
                                                                                                                     // 728
	// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters                                           // 729
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),                    // 730
	funescape = function( _, escaped, escapedWhitespace ) {                                                             // 731
		var high = "0x" + escaped - 0x10000;                                                                               // 732
		// NaN means non-codepoint                                                                                         // 733
		// Support: Firefox                                                                                                // 734
		// Workaround erroneous numeric interpretation of +"0x"                                                            // 735
		return high !== high || escapedWhitespace ?                                                                        // 736
			escaped :                                                                                                         // 737
			high < 0 ?                                                                                                        // 738
				// BMP codepoint                                                                                                 // 739
				String.fromCharCode( high + 0x10000 ) :                                                                          // 740
				// Supplemental Plane codepoint (surrogate pair)                                                                 // 741
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );                                               // 742
	};                                                                                                                  // 743
                                                                                                                     // 744
// Optimize for push.apply( _, NodeList )                                                                            // 745
try {                                                                                                                // 746
	push.apply(                                                                                                         // 747
		(arr = slice.call( preferredDoc.childNodes )),                                                                     // 748
		preferredDoc.childNodes                                                                                            // 749
	);                                                                                                                  // 750
	// Support: Android<4.0                                                                                             // 751
	// Detect silently failing push.apply                                                                               // 752
	arr[ preferredDoc.childNodes.length ].nodeType;                                                                     // 753
} catch ( e ) {                                                                                                      // 754
	push = { apply: arr.length ?                                                                                        // 755
                                                                                                                     // 756
		// Leverage slice if possible                                                                                      // 757
		function( target, els ) {                                                                                          // 758
			push_native.apply( target, slice.call(els) );                                                                     // 759
		} :                                                                                                                // 760
                                                                                                                     // 761
		// Support: IE<9                                                                                                   // 762
		// Otherwise append directly                                                                                       // 763
		function( target, els ) {                                                                                          // 764
			var j = target.length,                                                                                            // 765
				i = 0;                                                                                                           // 766
			// Can't trust NodeList.length                                                                                    // 767
			while ( (target[j++] = els[i++]) ) {}                                                                             // 768
			target.length = j - 1;                                                                                            // 769
		}                                                                                                                  // 770
	};                                                                                                                  // 771
}                                                                                                                    // 772
                                                                                                                     // 773
function Sizzle( selector, context, results, seed ) {                                                                // 774
	var match, elem, m, nodeType,                                                                                       // 775
		// QSA vars                                                                                                        // 776
		i, groups, old, nid, newContext, newSelector;                                                                      // 777
                                                                                                                     // 778
	if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {                                 // 779
		setDocument( context );                                                                                            // 780
	}                                                                                                                   // 781
                                                                                                                     // 782
	context = context || document;                                                                                      // 783
	results = results || [];                                                                                            // 784
                                                                                                                     // 785
	if ( !selector || typeof selector !== "string" ) {                                                                  // 786
		return results;                                                                                                    // 787
	}                                                                                                                   // 788
                                                                                                                     // 789
	if ( (nodeType = context.nodeType) !== 1 && nodeType !== 9 ) {                                                      // 790
		return [];                                                                                                         // 791
	}                                                                                                                   // 792
                                                                                                                     // 793
	if ( documentIsHTML && !seed ) {                                                                                    // 794
                                                                                                                     // 795
		// Shortcuts                                                                                                       // 796
		if ( (match = rquickExpr.exec( selector )) ) {                                                                     // 797
			// Speed-up: Sizzle("#ID")                                                                                        // 798
			if ( (m = match[1]) ) {                                                                                           // 799
				if ( nodeType === 9 ) {                                                                                          // 800
					elem = context.getElementById( m );                                                                             // 801
					// Check parentNode to catch when Blackberry 4.6 returns                                                        // 802
					// nodes that are no longer in the document (jQuery #6963)                                                      // 803
					if ( elem && elem.parentNode ) {                                                                                // 804
						// Handle the case where IE, Opera, and Webkit return items                                                    // 805
						// by name instead of ID                                                                                       // 806
						if ( elem.id === m ) {                                                                                         // 807
							results.push( elem );                                                                                         // 808
							return results;                                                                                               // 809
						}                                                                                                              // 810
					} else {                                                                                                        // 811
						return results;                                                                                                // 812
					}                                                                                                               // 813
				} else {                                                                                                         // 814
					// Context is not a document                                                                                    // 815
					if ( context.ownerDocument && (elem = context.ownerDocument.getElementById( m )) &&                             // 816
						contains( context, elem ) && elem.id === m ) {                                                                 // 817
						results.push( elem );                                                                                          // 818
						return results;                                                                                                // 819
					}                                                                                                               // 820
				}                                                                                                                // 821
                                                                                                                     // 822
			// Speed-up: Sizzle("TAG")                                                                                        // 823
			} else if ( match[2] ) {                                                                                          // 824
				push.apply( results, context.getElementsByTagName( selector ) );                                                 // 825
				return results;                                                                                                  // 826
                                                                                                                     // 827
			// Speed-up: Sizzle(".CLASS")                                                                                     // 828
			} else if ( (m = match[3]) && support.getElementsByClassName && context.getElementsByClassName ) {                // 829
				push.apply( results, context.getElementsByClassName( m ) );                                                      // 830
				return results;                                                                                                  // 831
			}                                                                                                                 // 832
		}                                                                                                                  // 833
                                                                                                                     // 834
		// QSA path                                                                                                        // 835
		if ( support.qsa && (!rbuggyQSA || !rbuggyQSA.test( selector )) ) {                                                // 836
			nid = old = expando;                                                                                              // 837
			newContext = context;                                                                                             // 838
			newSelector = nodeType === 9 && selector;                                                                         // 839
                                                                                                                     // 840
			// qSA works strangely on Element-rooted queries                                                                  // 841
			// We can work around this by specifying an extra ID on the root                                                  // 842
			// and working up from there (Thanks to Andrew Dupont for the technique)                                          // 843
			// IE 8 doesn't work on object elements                                                                           // 844
			if ( nodeType === 1 && context.nodeName.toLowerCase() !== "object" ) {                                            // 845
				groups = tokenize( selector );                                                                                   // 846
                                                                                                                     // 847
				if ( (old = context.getAttribute("id")) ) {                                                                      // 848
					nid = old.replace( rescape, "\\$&" );                                                                           // 849
				} else {                                                                                                         // 850
					context.setAttribute( "id", nid );                                                                              // 851
				}                                                                                                                // 852
				nid = "[id='" + nid + "'] ";                                                                                     // 853
                                                                                                                     // 854
				i = groups.length;                                                                                               // 855
				while ( i-- ) {                                                                                                  // 856
					groups[i] = nid + toSelector( groups[i] );                                                                      // 857
				}                                                                                                                // 858
				newContext = rsibling.test( selector ) && testContext( context.parentNode ) || context;                          // 859
				newSelector = groups.join(",");                                                                                  // 860
			}                                                                                                                 // 861
                                                                                                                     // 862
			if ( newSelector ) {                                                                                              // 863
				try {                                                                                                            // 864
					push.apply( results,                                                                                            // 865
						newContext.querySelectorAll( newSelector )                                                                     // 866
					);                                                                                                              // 867
					return results;                                                                                                 // 868
				} catch(qsaError) {                                                                                              // 869
				} finally {                                                                                                      // 870
					if ( !old ) {                                                                                                   // 871
						context.removeAttribute("id");                                                                                 // 872
					}                                                                                                               // 873
				}                                                                                                                // 874
			}                                                                                                                 // 875
		}                                                                                                                  // 876
	}                                                                                                                   // 877
                                                                                                                     // 878
	// All others                                                                                                       // 879
	return select( selector.replace( rtrim, "$1" ), context, results, seed );                                           // 880
}                                                                                                                    // 881
                                                                                                                     // 882
/**                                                                                                                  // 883
 * Create key-value caches of limited size                                                                           // 884
 * @returns {Function(string, Object)} Returns the Object data after storing it on itself with                       // 885
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)                      // 886
 *	deleting the oldest entry                                                                                         // 887
 */                                                                                                                  // 888
function createCache() {                                                                                             // 889
	var keys = [];                                                                                                      // 890
                                                                                                                     // 891
	function cache( key, value ) {                                                                                      // 892
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)                            // 893
		if ( keys.push( key + " " ) > Expr.cacheLength ) {                                                                 // 894
			// Only keep the most recent entries                                                                              // 895
			delete cache[ keys.shift() ];                                                                                     // 896
		}                                                                                                                  // 897
		return (cache[ key + " " ] = value);                                                                               // 898
	}                                                                                                                   // 899
	return cache;                                                                                                       // 900
}                                                                                                                    // 901
                                                                                                                     // 902
/**                                                                                                                  // 903
 * Mark a function for special use by Sizzle                                                                         // 904
 * @param {Function} fn The function to mark                                                                         // 905
 */                                                                                                                  // 906
function markFunction( fn ) {                                                                                        // 907
	fn[ expando ] = true;                                                                                               // 908
	return fn;                                                                                                          // 909
}                                                                                                                    // 910
                                                                                                                     // 911
/**                                                                                                                  // 912
 * Support testing using an element                                                                                  // 913
 * @param {Function} fn Passed the created div and expects a boolean result                                          // 914
 */                                                                                                                  // 915
function assert( fn ) {                                                                                              // 916
	var div = document.createElement("div");                                                                            // 917
                                                                                                                     // 918
	try {                                                                                                               // 919
		return !!fn( div );                                                                                                // 920
	} catch (e) {                                                                                                       // 921
		return false;                                                                                                      // 922
	} finally {                                                                                                         // 923
		// Remove from its parent by default                                                                               // 924
		if ( div.parentNode ) {                                                                                            // 925
			div.parentNode.removeChild( div );                                                                                // 926
		}                                                                                                                  // 927
		// release memory in IE                                                                                            // 928
		div = null;                                                                                                        // 929
	}                                                                                                                   // 930
}                                                                                                                    // 931
                                                                                                                     // 932
/**                                                                                                                  // 933
 * Adds the same handler for all of the specified attrs                                                              // 934
 * @param {String} attrs Pipe-separated list of attributes                                                           // 935
 * @param {Function} handler The method that will be applied                                                         // 936
 */                                                                                                                  // 937
function addHandle( attrs, handler ) {                                                                               // 938
	var arr = attrs.split("|"),                                                                                         // 939
		i = attrs.length;                                                                                                  // 940
                                                                                                                     // 941
	while ( i-- ) {                                                                                                     // 942
		Expr.attrHandle[ arr[i] ] = handler;                                                                               // 943
	}                                                                                                                   // 944
}                                                                                                                    // 945
                                                                                                                     // 946
/**                                                                                                                  // 947
 * Checks document order of two siblings                                                                             // 948
 * @param {Element} a                                                                                                // 949
 * @param {Element} b                                                                                                // 950
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b                              // 951
 */                                                                                                                  // 952
function siblingCheck( a, b ) {                                                                                      // 953
	var cur = b && a,                                                                                                   // 954
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&                                                              // 955
			( ~b.sourceIndex || MAX_NEGATIVE ) -                                                                              // 956
			( ~a.sourceIndex || MAX_NEGATIVE );                                                                               // 957
                                                                                                                     // 958
	// Use IE sourceIndex if available on both nodes                                                                    // 959
	if ( diff ) {                                                                                                       // 960
		return diff;                                                                                                       // 961
	}                                                                                                                   // 962
                                                                                                                     // 963
	// Check if b follows a                                                                                             // 964
	if ( cur ) {                                                                                                        // 965
		while ( (cur = cur.nextSibling) ) {                                                                                // 966
			if ( cur === b ) {                                                                                                // 967
				return -1;                                                                                                       // 968
			}                                                                                                                 // 969
		}                                                                                                                  // 970
	}                                                                                                                   // 971
                                                                                                                     // 972
	return a ? 1 : -1;                                                                                                  // 973
}                                                                                                                    // 974
                                                                                                                     // 975
/**                                                                                                                  // 976
 * Returns a function to use in pseudos for input types                                                              // 977
 * @param {String} type                                                                                              // 978
 */                                                                                                                  // 979
function createInputPseudo( type ) {                                                                                 // 980
	return function( elem ) {                                                                                           // 981
		var name = elem.nodeName.toLowerCase();                                                                            // 982
		return name === "input" && elem.type === type;                                                                     // 983
	};                                                                                                                  // 984
}                                                                                                                    // 985
                                                                                                                     // 986
/**                                                                                                                  // 987
 * Returns a function to use in pseudos for buttons                                                                  // 988
 * @param {String} type                                                                                              // 989
 */                                                                                                                  // 990
function createButtonPseudo( type ) {                                                                                // 991
	return function( elem ) {                                                                                           // 992
		var name = elem.nodeName.toLowerCase();                                                                            // 993
		return (name === "input" || name === "button") && elem.type === type;                                              // 994
	};                                                                                                                  // 995
}                                                                                                                    // 996
                                                                                                                     // 997
/**                                                                                                                  // 998
 * Returns a function to use in pseudos for positionals                                                              // 999
 * @param {Function} fn                                                                                              // 1000
 */                                                                                                                  // 1001
function createPositionalPseudo( fn ) {                                                                              // 1002
	return markFunction(function( argument ) {                                                                          // 1003
		argument = +argument;                                                                                              // 1004
		return markFunction(function( seed, matches ) {                                                                    // 1005
			var j,                                                                                                            // 1006
				matchIndexes = fn( [], seed.length, argument ),                                                                  // 1007
				i = matchIndexes.length;                                                                                         // 1008
                                                                                                                     // 1009
			// Match elements found at the specified indexes                                                                  // 1010
			while ( i-- ) {                                                                                                   // 1011
				if ( seed[ (j = matchIndexes[i]) ] ) {                                                                           // 1012
					seed[j] = !(matches[j] = seed[j]);                                                                              // 1013
				}                                                                                                                // 1014
			}                                                                                                                 // 1015
		});                                                                                                                // 1016
	});                                                                                                                 // 1017
}                                                                                                                    // 1018
                                                                                                                     // 1019
/**                                                                                                                  // 1020
 * Checks a node for validity as a Sizzle context                                                                    // 1021
 * @param {Element|Object=} context                                                                                  // 1022
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value                           // 1023
 */                                                                                                                  // 1024
function testContext( context ) {                                                                                    // 1025
	return context && typeof context.getElementsByTagName !== strundefined && context;                                  // 1026
}                                                                                                                    // 1027
                                                                                                                     // 1028
// Expose support vars for convenience                                                                               // 1029
support = Sizzle.support = {};                                                                                       // 1030
                                                                                                                     // 1031
/**                                                                                                                  // 1032
 * Detects XML nodes                                                                                                 // 1033
 * @param {Element|Object} elem An element or a document                                                             // 1034
 * @returns {Boolean} True iff elem is a non-HTML XML node                                                           // 1035
 */                                                                                                                  // 1036
isXML = Sizzle.isXML = function( elem ) {                                                                            // 1037
	// documentElement is verified for cases where it doesn't yet exist                                                 // 1038
	// (such as loading iframes in IE - #4833)                                                                          // 1039
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;                                         // 1040
	return documentElement ? documentElement.nodeName !== "HTML" : false;                                               // 1041
};                                                                                                                   // 1042
                                                                                                                     // 1043
/**                                                                                                                  // 1044
 * Sets document-related variables once based on the current document                                                // 1045
 * @param {Element|Object} [doc] An element or document object to use to set the document                            // 1046
 * @returns {Object} Returns the current document                                                                    // 1047
 */                                                                                                                  // 1048
setDocument = Sizzle.setDocument = function( node ) {                                                                // 1049
	var hasCompare,                                                                                                     // 1050
		doc = node ? node.ownerDocument || node : preferredDoc,                                                            // 1051
		parent = doc.defaultView;                                                                                          // 1052
                                                                                                                     // 1053
	// If no document and documentElement is available, return                                                          // 1054
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {                                             // 1055
		return document;                                                                                                   // 1056
	}                                                                                                                   // 1057
                                                                                                                     // 1058
	// Set our document                                                                                                 // 1059
	document = doc;                                                                                                     // 1060
	docElem = doc.documentElement;                                                                                      // 1061
                                                                                                                     // 1062
	// Support tests                                                                                                    // 1063
	documentIsHTML = !isXML( doc );                                                                                     // 1064
                                                                                                                     // 1065
	// Support: IE>8                                                                                                    // 1066
	// If iframe document is assigned to "document" variable and if iframe has been reloaded,                           // 1067
	// IE will throw "permission denied" error when accessing "document" variable, see jQuery #13936                    // 1068
	// IE6-8 do not support the defaultView property so parent will be undefined                                        // 1069
	if ( parent && parent !== parent.top ) {                                                                            // 1070
		// IE11 does not have attachEvent, so all must suffer                                                              // 1071
		if ( parent.addEventListener ) {                                                                                   // 1072
			parent.addEventListener( "unload", function() {                                                                   // 1073
				setDocument();                                                                                                   // 1074
			}, false );                                                                                                       // 1075
		} else if ( parent.attachEvent ) {                                                                                 // 1076
			parent.attachEvent( "onunload", function() {                                                                      // 1077
				setDocument();                                                                                                   // 1078
			});                                                                                                               // 1079
		}                                                                                                                  // 1080
	}                                                                                                                   // 1081
                                                                                                                     // 1082
	/* Attributes                                                                                                       // 1083
	---------------------------------------------------------------------- */                                           // 1084
                                                                                                                     // 1085
	// Support: IE<8                                                                                                    // 1086
	// Verify that getAttribute really returns attributes and not properties (excepting IE8 booleans)                   // 1087
	support.attributes = assert(function( div ) {                                                                       // 1088
		div.className = "i";                                                                                               // 1089
		return !div.getAttribute("className");                                                                             // 1090
	});                                                                                                                 // 1091
                                                                                                                     // 1092
	/* getElement(s)By*                                                                                                 // 1093
	---------------------------------------------------------------------- */                                           // 1094
                                                                                                                     // 1095
	// Check if getElementsByTagName("*") returns only elements                                                         // 1096
	support.getElementsByTagName = assert(function( div ) {                                                             // 1097
		div.appendChild( doc.createComment("") );                                                                          // 1098
		return !div.getElementsByTagName("*").length;                                                                      // 1099
	});                                                                                                                 // 1100
                                                                                                                     // 1101
	// Check if getElementsByClassName can be trusted                                                                   // 1102
	support.getElementsByClassName = rnative.test( doc.getElementsByClassName ) && assert(function( div ) {             // 1103
		div.innerHTML = "<div class='a'></div><div class='a i'></div>";                                                    // 1104
                                                                                                                     // 1105
		// Support: Safari<4                                                                                               // 1106
		// Catch class over-caching                                                                                        // 1107
		div.firstChild.className = "i";                                                                                    // 1108
		// Support: Opera<10                                                                                               // 1109
		// Catch gEBCN failure to find non-leading classes                                                                 // 1110
		return div.getElementsByClassName("i").length === 2;                                                               // 1111
	});                                                                                                                 // 1112
                                                                                                                     // 1113
	// Support: IE<10                                                                                                   // 1114
	// Check if getElementById returns elements by name                                                                 // 1115
	// The broken getElementById methods don't pick up programatically-set names,                                       // 1116
	// so use a roundabout getElementsByName test                                                                       // 1117
	support.getById = assert(function( div ) {                                                                          // 1118
		docElem.appendChild( div ).id = expando;                                                                           // 1119
		return !doc.getElementsByName || !doc.getElementsByName( expando ).length;                                         // 1120
	});                                                                                                                 // 1121
                                                                                                                     // 1122
	// ID find and filter                                                                                               // 1123
	if ( support.getById ) {                                                                                            // 1124
		Expr.find["ID"] = function( id, context ) {                                                                        // 1125
			if ( typeof context.getElementById !== strundefined && documentIsHTML ) {                                         // 1126
				var m = context.getElementById( id );                                                                            // 1127
				// Check parentNode to catch when Blackberry 4.6 returns                                                         // 1128
				// nodes that are no longer in the document #6963                                                                // 1129
				return m && m.parentNode ? [m] : [];                                                                             // 1130
			}                                                                                                                 // 1131
		};                                                                                                                 // 1132
		Expr.filter["ID"] = function( id ) {                                                                               // 1133
			var attrId = id.replace( runescape, funescape );                                                                  // 1134
			return function( elem ) {                                                                                         // 1135
				return elem.getAttribute("id") === attrId;                                                                       // 1136
			};                                                                                                                // 1137
		};                                                                                                                 // 1138
	} else {                                                                                                            // 1139
		// Support: IE6/7                                                                                                  // 1140
		// getElementById is not reliable as a find shortcut                                                               // 1141
		delete Expr.find["ID"];                                                                                            // 1142
                                                                                                                     // 1143
		Expr.filter["ID"] =  function( id ) {                                                                              // 1144
			var attrId = id.replace( runescape, funescape );                                                                  // 1145
			return function( elem ) {                                                                                         // 1146
				var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");                         // 1147
				return node && node.value === attrId;                                                                            // 1148
			};                                                                                                                // 1149
		};                                                                                                                 // 1150
	}                                                                                                                   // 1151
                                                                                                                     // 1152
	// Tag                                                                                                              // 1153
	Expr.find["TAG"] = support.getElementsByTagName ?                                                                   // 1154
		function( tag, context ) {                                                                                         // 1155
			if ( typeof context.getElementsByTagName !== strundefined ) {                                                     // 1156
				return context.getElementsByTagName( tag );                                                                      // 1157
			}                                                                                                                 // 1158
		} :                                                                                                                // 1159
		function( tag, context ) {                                                                                         // 1160
			var elem,                                                                                                         // 1161
				tmp = [],                                                                                                        // 1162
				i = 0,                                                                                                           // 1163
				results = context.getElementsByTagName( tag );                                                                   // 1164
                                                                                                                     // 1165
			// Filter out possible comments                                                                                   // 1166
			if ( tag === "*" ) {                                                                                              // 1167
				while ( (elem = results[i++]) ) {                                                                                // 1168
					if ( elem.nodeType === 1 ) {                                                                                    // 1169
						tmp.push( elem );                                                                                              // 1170
					}                                                                                                               // 1171
				}                                                                                                                // 1172
                                                                                                                     // 1173
				return tmp;                                                                                                      // 1174
			}                                                                                                                 // 1175
			return results;                                                                                                   // 1176
		};                                                                                                                 // 1177
                                                                                                                     // 1178
	// Class                                                                                                            // 1179
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {                             // 1180
		if ( typeof context.getElementsByClassName !== strundefined && documentIsHTML ) {                                  // 1181
			return context.getElementsByClassName( className );                                                               // 1182
		}                                                                                                                  // 1183
	};                                                                                                                  // 1184
                                                                                                                     // 1185
	/* QSA/matchesSelector                                                                                              // 1186
	---------------------------------------------------------------------- */                                           // 1187
                                                                                                                     // 1188
	// QSA and matchesSelector support                                                                                  // 1189
                                                                                                                     // 1190
	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)                                                // 1191
	rbuggyMatches = [];                                                                                                 // 1192
                                                                                                                     // 1193
	// qSa(:focus) reports false when true (Chrome 21)                                                                  // 1194
	// We allow this because of a bug in IE8/9 that throws an error                                                     // 1195
	// whenever `document.activeElement` is accessed on an iframe                                                       // 1196
	// So, we allow :focus to pass through QSA all the time to avoid the IE error                                       // 1197
	// See http://bugs.jquery.com/ticket/13378                                                                          // 1198
	rbuggyQSA = [];                                                                                                     // 1199
                                                                                                                     // 1200
	if ( (support.qsa = rnative.test( doc.querySelectorAll )) ) {                                                       // 1201
		// Build QSA regex                                                                                                 // 1202
		// Regex strategy adopted from Diego Perini                                                                        // 1203
		assert(function( div ) {                                                                                           // 1204
			// Select is set to empty string on purpose                                                                       // 1205
			// This is to test IE's treatment of not explicitly                                                               // 1206
			// setting a boolean content attribute,                                                                           // 1207
			// since its presence should be enough                                                                            // 1208
			// http://bugs.jquery.com/ticket/12359                                                                            // 1209
			div.innerHTML = "<select t=''><option selected=''></option></select>";                                            // 1210
                                                                                                                     // 1211
			// Support: IE8, Opera 10-12                                                                                      // 1212
			// Nothing should be selected when empty strings follow ^= or $= or *=                                            // 1213
			if ( div.querySelectorAll("[t^='']").length ) {                                                                   // 1214
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );                                                        // 1215
			}                                                                                                                 // 1216
                                                                                                                     // 1217
			// Support: IE8                                                                                                   // 1218
			// Boolean attributes and "value" are not treated correctly                                                       // 1219
			if ( !div.querySelectorAll("[selected]").length ) {                                                               // 1220
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );                                            // 1221
			}                                                                                                                 // 1222
                                                                                                                     // 1223
			// Webkit/Opera - :checked should return selected option elements                                                 // 1224
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked                                                 // 1225
			// IE8 throws error here and will not see later tests                                                             // 1226
			if ( !div.querySelectorAll(":checked").length ) {                                                                 // 1227
				rbuggyQSA.push(":checked");                                                                                      // 1228
			}                                                                                                                 // 1229
		});                                                                                                                // 1230
                                                                                                                     // 1231
		assert(function( div ) {                                                                                           // 1232
			// Support: Windows 8 Native Apps                                                                                 // 1233
			// The type and name attributes are restricted during .innerHTML assignment                                       // 1234
			var input = doc.createElement("input");                                                                           // 1235
			input.setAttribute( "type", "hidden" );                                                                           // 1236
			div.appendChild( input ).setAttribute( "name", "D" );                                                             // 1237
                                                                                                                     // 1238
			// Support: IE8                                                                                                   // 1239
			// Enforce case-sensitivity of name attribute                                                                     // 1240
			if ( div.querySelectorAll("[name=d]").length ) {                                                                  // 1241
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );                                                           // 1242
			}                                                                                                                 // 1243
                                                                                                                     // 1244
			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)                            // 1245
			// IE8 throws error here and will not see later tests                                                             // 1246
			if ( !div.querySelectorAll(":enabled").length ) {                                                                 // 1247
				rbuggyQSA.push( ":enabled", ":disabled" );                                                                       // 1248
			}                                                                                                                 // 1249
                                                                                                                     // 1250
			// Opera 10-11 does not throw on post-comma invalid pseudos                                                       // 1251
			div.querySelectorAll("*,:x");                                                                                     // 1252
			rbuggyQSA.push(",.*:");                                                                                           // 1253
		});                                                                                                                // 1254
	}                                                                                                                   // 1255
                                                                                                                     // 1256
	if ( (support.matchesSelector = rnative.test( (matches = docElem.webkitMatchesSelector ||                           // 1257
		docElem.mozMatchesSelector ||                                                                                      // 1258
		docElem.oMatchesSelector ||                                                                                        // 1259
		docElem.msMatchesSelector) )) ) {                                                                                  // 1260
                                                                                                                     // 1261
		assert(function( div ) {                                                                                           // 1262
			// Check to see if it's possible to do matchesSelector                                                            // 1263
			// on a disconnected node (IE 9)                                                                                  // 1264
			support.disconnectedMatch = matches.call( div, "div" );                                                           // 1265
                                                                                                                     // 1266
			// This should fail with an exception                                                                             // 1267
			// Gecko does not error, returns false instead                                                                    // 1268
			matches.call( div, "[s!='']:x" );                                                                                 // 1269
			rbuggyMatches.push( "!=", pseudos );                                                                              // 1270
		});                                                                                                                // 1271
	}                                                                                                                   // 1272
                                                                                                                     // 1273
	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );                                                  // 1274
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );                                      // 1275
                                                                                                                     // 1276
	/* Contains                                                                                                         // 1277
	---------------------------------------------------------------------- */                                           // 1278
	hasCompare = rnative.test( docElem.compareDocumentPosition );                                                       // 1279
                                                                                                                     // 1280
	// Element contains another                                                                                         // 1281
	// Purposefully does not implement inclusive descendent                                                             // 1282
	// As in, an element does not contain itself                                                                        // 1283
	contains = hasCompare || rnative.test( docElem.contains ) ?                                                         // 1284
		function( a, b ) {                                                                                                 // 1285
			var adown = a.nodeType === 9 ? a.documentElement : a,                                                             // 1286
				bup = b && b.parentNode;                                                                                         // 1287
			return a === bup || !!( bup && bup.nodeType === 1 && (                                                            // 1288
				adown.contains ?                                                                                                 // 1289
					adown.contains( bup ) :                                                                                         // 1290
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16                                              // 1291
			));                                                                                                               // 1292
		} :                                                                                                                // 1293
		function( a, b ) {                                                                                                 // 1294
			if ( b ) {                                                                                                        // 1295
				while ( (b = b.parentNode) ) {                                                                                   // 1296
					if ( b === a ) {                                                                                                // 1297
						return true;                                                                                                   // 1298
					}                                                                                                               // 1299
				}                                                                                                                // 1300
			}                                                                                                                 // 1301
			return false;                                                                                                     // 1302
		};                                                                                                                 // 1303
                                                                                                                     // 1304
	/* Sorting                                                                                                          // 1305
	---------------------------------------------------------------------- */                                           // 1306
                                                                                                                     // 1307
	// Document order sorting                                                                                           // 1308
	sortOrder = hasCompare ?                                                                                            // 1309
	function( a, b ) {                                                                                                  // 1310
                                                                                                                     // 1311
		// Flag for duplicate removal                                                                                      // 1312
		if ( a === b ) {                                                                                                   // 1313
			hasDuplicate = true;                                                                                              // 1314
			return 0;                                                                                                         // 1315
		}                                                                                                                  // 1316
                                                                                                                     // 1317
		// Sort on method existence if only one input has compareDocumentPosition                                          // 1318
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;                                             // 1319
		if ( compare ) {                                                                                                   // 1320
			return compare;                                                                                                   // 1321
		}                                                                                                                  // 1322
                                                                                                                     // 1323
		// Calculate position if both inputs belong to the same document                                                   // 1324
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?                                                  // 1325
			a.compareDocumentPosition( b ) :                                                                                  // 1326
                                                                                                                     // 1327
			// Otherwise we know they are disconnected                                                                        // 1328
			1;                                                                                                                // 1329
                                                                                                                     // 1330
		// Disconnected nodes                                                                                              // 1331
		if ( compare & 1 ||                                                                                                // 1332
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {                                         // 1333
                                                                                                                     // 1334
			// Choose the first element that is related to our preferred document                                             // 1335
			if ( a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {                               // 1336
				return -1;                                                                                                       // 1337
			}                                                                                                                 // 1338
			if ( b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {                               // 1339
				return 1;                                                                                                        // 1340
			}                                                                                                                 // 1341
                                                                                                                     // 1342
			// Maintain original order                                                                                        // 1343
			return sortInput ?                                                                                                // 1344
				( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :                                                // 1345
				0;                                                                                                               // 1346
		}                                                                                                                  // 1347
                                                                                                                     // 1348
		return compare & 4 ? -1 : 1;                                                                                       // 1349
	} :                                                                                                                 // 1350
	function( a, b ) {                                                                                                  // 1351
		// Exit early if the nodes are identical                                                                           // 1352
		if ( a === b ) {                                                                                                   // 1353
			hasDuplicate = true;                                                                                              // 1354
			return 0;                                                                                                         // 1355
		}                                                                                                                  // 1356
                                                                                                                     // 1357
		var cur,                                                                                                           // 1358
			i = 0,                                                                                                            // 1359
			aup = a.parentNode,                                                                                               // 1360
			bup = b.parentNode,                                                                                               // 1361
			ap = [ a ],                                                                                                       // 1362
			bp = [ b ];                                                                                                       // 1363
                                                                                                                     // 1364
		// Parentless nodes are either documents or disconnected                                                           // 1365
		if ( !aup || !bup ) {                                                                                              // 1366
			return a === doc ? -1 :                                                                                           // 1367
				b === doc ? 1 :                                                                                                  // 1368
				aup ? -1 :                                                                                                       // 1369
				bup ? 1 :                                                                                                        // 1370
				sortInput ?                                                                                                      // 1371
				( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :                                                // 1372
				0;                                                                                                               // 1373
                                                                                                                     // 1374
		// If the nodes are siblings, we can do a quick check                                                              // 1375
		} else if ( aup === bup ) {                                                                                        // 1376
			return siblingCheck( a, b );                                                                                      // 1377
		}                                                                                                                  // 1378
                                                                                                                     // 1379
		// Otherwise we need full lists of their ancestors for comparison                                                  // 1380
		cur = a;                                                                                                           // 1381
		while ( (cur = cur.parentNode) ) {                                                                                 // 1382
			ap.unshift( cur );                                                                                                // 1383
		}                                                                                                                  // 1384
		cur = b;                                                                                                           // 1385
		while ( (cur = cur.parentNode) ) {                                                                                 // 1386
			bp.unshift( cur );                                                                                                // 1387
		}                                                                                                                  // 1388
                                                                                                                     // 1389
		// Walk down the tree looking for a discrepancy                                                                    // 1390
		while ( ap[i] === bp[i] ) {                                                                                        // 1391
			i++;                                                                                                              // 1392
		}                                                                                                                  // 1393
                                                                                                                     // 1394
		return i ?                                                                                                         // 1395
			// Do a sibling check if the nodes have a common ancestor                                                         // 1396
			siblingCheck( ap[i], bp[i] ) :                                                                                    // 1397
                                                                                                                     // 1398
			// Otherwise nodes in our document sort first                                                                     // 1399
			ap[i] === preferredDoc ? -1 :                                                                                     // 1400
			bp[i] === preferredDoc ? 1 :                                                                                      // 1401
			0;                                                                                                                // 1402
	};                                                                                                                  // 1403
                                                                                                                     // 1404
	return doc;                                                                                                         // 1405
};                                                                                                                   // 1406
                                                                                                                     // 1407
Sizzle.matches = function( expr, elements ) {                                                                        // 1408
	return Sizzle( expr, null, null, elements );                                                                        // 1409
};                                                                                                                   // 1410
                                                                                                                     // 1411
Sizzle.matchesSelector = function( elem, expr ) {                                                                    // 1412
	// Set document vars if needed                                                                                      // 1413
	if ( ( elem.ownerDocument || elem ) !== document ) {                                                                // 1414
		setDocument( elem );                                                                                               // 1415
	}                                                                                                                   // 1416
                                                                                                                     // 1417
	// Make sure that attribute selectors are quoted                                                                    // 1418
	expr = expr.replace( rattributeQuotes, "='$1']" );                                                                  // 1419
                                                                                                                     // 1420
	if ( support.matchesSelector && documentIsHTML &&                                                                   // 1421
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&                                                               // 1422
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {                                                                  // 1423
                                                                                                                     // 1424
		try {                                                                                                              // 1425
			var ret = matches.call( elem, expr );                                                                             // 1426
                                                                                                                     // 1427
			// IE 9's matchesSelector returns false on disconnected nodes                                                     // 1428
			if ( ret || support.disconnectedMatch ||                                                                          // 1429
					// As well, disconnected nodes are said to be in a document                                                     // 1430
					// fragment in IE 9                                                                                             // 1431
					elem.document && elem.document.nodeType !== 11 ) {                                                              // 1432
				return ret;                                                                                                      // 1433
			}                                                                                                                 // 1434
		} catch(e) {}                                                                                                      // 1435
	}                                                                                                                   // 1436
                                                                                                                     // 1437
	return Sizzle( expr, document, null, [elem] ).length > 0;                                                           // 1438
};                                                                                                                   // 1439
                                                                                                                     // 1440
Sizzle.contains = function( context, elem ) {                                                                        // 1441
	// Set document vars if needed                                                                                      // 1442
	if ( ( context.ownerDocument || context ) !== document ) {                                                          // 1443
		setDocument( context );                                                                                            // 1444
	}                                                                                                                   // 1445
	return contains( context, elem );                                                                                   // 1446
};                                                                                                                   // 1447
                                                                                                                     // 1448
Sizzle.attr = function( elem, name ) {                                                                               // 1449
	// Set document vars if needed                                                                                      // 1450
	if ( ( elem.ownerDocument || elem ) !== document ) {                                                                // 1451
		setDocument( elem );                                                                                               // 1452
	}                                                                                                                   // 1453
                                                                                                                     // 1454
	var fn = Expr.attrHandle[ name.toLowerCase() ],                                                                     // 1455
		// Don't get fooled by Object.prototype properties (jQuery #13807)                                                 // 1456
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?                                                   // 1457
			fn( elem, name, !documentIsHTML ) :                                                                               // 1458
			undefined;                                                                                                        // 1459
                                                                                                                     // 1460
	return val !== undefined ?                                                                                          // 1461
		val :                                                                                                              // 1462
		support.attributes || !documentIsHTML ?                                                                            // 1463
			elem.getAttribute( name ) :                                                                                       // 1464
			(val = elem.getAttributeNode(name)) && val.specified ?                                                            // 1465
				val.value :                                                                                                      // 1466
				null;                                                                                                            // 1467
};                                                                                                                   // 1468
                                                                                                                     // 1469
Sizzle.error = function( msg ) {                                                                                     // 1470
	throw new Error( "Syntax error, unrecognized expression: " + msg );                                                 // 1471
};                                                                                                                   // 1472
                                                                                                                     // 1473
/**                                                                                                                  // 1474
 * Document sorting and removing duplicates                                                                          // 1475
 * @param {ArrayLike} results                                                                                        // 1476
 */                                                                                                                  // 1477
Sizzle.uniqueSort = function( results ) {                                                                            // 1478
	var elem,                                                                                                           // 1479
		duplicates = [],                                                                                                   // 1480
		j = 0,                                                                                                             // 1481
		i = 0;                                                                                                             // 1482
                                                                                                                     // 1483
	// Unless we *know* we can detect duplicates, assume their presence                                                 // 1484
	hasDuplicate = !support.detectDuplicates;                                                                           // 1485
	sortInput = !support.sortStable && results.slice( 0 );                                                              // 1486
	results.sort( sortOrder );                                                                                          // 1487
                                                                                                                     // 1488
	if ( hasDuplicate ) {                                                                                               // 1489
		while ( (elem = results[i++]) ) {                                                                                  // 1490
			if ( elem === results[ i ] ) {                                                                                    // 1491
				j = duplicates.push( i );                                                                                        // 1492
			}                                                                                                                 // 1493
		}                                                                                                                  // 1494
		while ( j-- ) {                                                                                                    // 1495
			results.splice( duplicates[ j ], 1 );                                                                             // 1496
		}                                                                                                                  // 1497
	}                                                                                                                   // 1498
                                                                                                                     // 1499
	// Clear input after sorting to release objects                                                                     // 1500
	// See https://github.com/jquery/sizzle/pull/225                                                                    // 1501
	sortInput = null;                                                                                                   // 1502
                                                                                                                     // 1503
	return results;                                                                                                     // 1504
};                                                                                                                   // 1505
                                                                                                                     // 1506
/**                                                                                                                  // 1507
 * Utility function for retrieving the text value of an array of DOM nodes                                           // 1508
 * @param {Array|Element} elem                                                                                       // 1509
 */                                                                                                                  // 1510
getText = Sizzle.getText = function( elem ) {                                                                        // 1511
	var node,                                                                                                           // 1512
		ret = "",                                                                                                          // 1513
		i = 0,                                                                                                             // 1514
		nodeType = elem.nodeType;                                                                                          // 1515
                                                                                                                     // 1516
	if ( !nodeType ) {                                                                                                  // 1517
		// If no nodeType, this is expected to be an array                                                                 // 1518
		while ( (node = elem[i++]) ) {                                                                                     // 1519
			// Do not traverse comment nodes                                                                                  // 1520
			ret += getText( node );                                                                                           // 1521
		}                                                                                                                  // 1522
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {                                                 // 1523
		// Use textContent for elements                                                                                    // 1524
		// innerText usage removed for consistency of new lines (jQuery #11153)                                            // 1525
		if ( typeof elem.textContent === "string" ) {                                                                      // 1526
			return elem.textContent;                                                                                          // 1527
		} else {                                                                                                           // 1528
			// Traverse its children                                                                                          // 1529
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {                                                   // 1530
				ret += getText( elem );                                                                                          // 1531
			}                                                                                                                 // 1532
		}                                                                                                                  // 1533
	} else if ( nodeType === 3 || nodeType === 4 ) {                                                                    // 1534
		return elem.nodeValue;                                                                                             // 1535
	}                                                                                                                   // 1536
	// Do not include comment or processing instruction nodes                                                           // 1537
                                                                                                                     // 1538
	return ret;                                                                                                         // 1539
};                                                                                                                   // 1540
                                                                                                                     // 1541
Expr = Sizzle.selectors = {                                                                                          // 1542
                                                                                                                     // 1543
	// Can be adjusted by the user                                                                                      // 1544
	cacheLength: 50,                                                                                                    // 1545
                                                                                                                     // 1546
	createPseudo: markFunction,                                                                                         // 1547
                                                                                                                     // 1548
	match: matchExpr,                                                                                                   // 1549
                                                                                                                     // 1550
	attrHandle: {},                                                                                                     // 1551
                                                                                                                     // 1552
	find: {},                                                                                                           // 1553
                                                                                                                     // 1554
	relative: {                                                                                                         // 1555
		">": { dir: "parentNode", first: true },                                                                           // 1556
		" ": { dir: "parentNode" },                                                                                        // 1557
		"+": { dir: "previousSibling", first: true },                                                                      // 1558
		"~": { dir: "previousSibling" }                                                                                    // 1559
	},                                                                                                                  // 1560
                                                                                                                     // 1561
	preFilter: {                                                                                                        // 1562
		"ATTR": function( match ) {                                                                                        // 1563
			match[1] = match[1].replace( runescape, funescape );                                                              // 1564
                                                                                                                     // 1565
			// Move the given value to match[3] whether quoted or unquoted                                                    // 1566
			match[3] = ( match[4] || match[5] || "" ).replace( runescape, funescape );                                        // 1567
                                                                                                                     // 1568
			if ( match[2] === "~=" ) {                                                                                        // 1569
				match[3] = " " + match[3] + " ";                                                                                 // 1570
			}                                                                                                                 // 1571
                                                                                                                     // 1572
			return match.slice( 0, 4 );                                                                                       // 1573
		},                                                                                                                 // 1574
                                                                                                                     // 1575
		"CHILD": function( match ) {                                                                                       // 1576
			/* matches from matchExpr["CHILD"]                                                                                // 1577
				1 type (only|nth|...)                                                                                            // 1578
				2 what (child|of-type)                                                                                           // 1579
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)                                                                     // 1580
				4 xn-component of xn+y argument ([+-]?\d*n|)                                                                     // 1581
				5 sign of xn-component                                                                                           // 1582
				6 x of xn-component                                                                                              // 1583
				7 sign of y-component                                                                                            // 1584
				8 y of y-component                                                                                               // 1585
			*/                                                                                                                // 1586
			match[1] = match[1].toLowerCase();                                                                                // 1587
                                                                                                                     // 1588
			if ( match[1].slice( 0, 3 ) === "nth" ) {                                                                         // 1589
				// nth-* requires argument                                                                                       // 1590
				if ( !match[3] ) {                                                                                               // 1591
					Sizzle.error( match[0] );                                                                                       // 1592
				}                                                                                                                // 1593
                                                                                                                     // 1594
				// numeric x and y parameters for Expr.filter.CHILD                                                              // 1595
				// remember that false/true cast respectively to 0/1                                                             // 1596
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );       // 1597
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );                                                   // 1598
                                                                                                                     // 1599
			// other types prohibit arguments                                                                                 // 1600
			} else if ( match[3] ) {                                                                                          // 1601
				Sizzle.error( match[0] );                                                                                        // 1602
			}                                                                                                                 // 1603
                                                                                                                     // 1604
			return match;                                                                                                     // 1605
		},                                                                                                                 // 1606
                                                                                                                     // 1607
		"PSEUDO": function( match ) {                                                                                      // 1608
			var excess,                                                                                                       // 1609
				unquoted = !match[5] && match[2];                                                                                // 1610
                                                                                                                     // 1611
			if ( matchExpr["CHILD"].test( match[0] ) ) {                                                                      // 1612
				return null;                                                                                                     // 1613
			}                                                                                                                 // 1614
                                                                                                                     // 1615
			// Accept quoted arguments as-is                                                                                  // 1616
			if ( match[3] && match[4] !== undefined ) {                                                                       // 1617
				match[2] = match[4];                                                                                             // 1618
                                                                                                                     // 1619
			// Strip excess characters from unquoted arguments                                                                // 1620
			} else if ( unquoted && rpseudo.test( unquoted ) &&                                                               // 1621
				// Get excess from tokenize (recursively)                                                                        // 1622
				(excess = tokenize( unquoted, true )) &&                                                                         // 1623
				// advance to the next closing parenthesis                                                                       // 1624
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {                               // 1625
                                                                                                                     // 1626
				// excess is a negative index                                                                                    // 1627
				match[0] = match[0].slice( 0, excess );                                                                          // 1628
				match[2] = unquoted.slice( 0, excess );                                                                          // 1629
			}                                                                                                                 // 1630
                                                                                                                     // 1631
			// Return only captures needed by the pseudo filter method (type and argument)                                    // 1632
			return match.slice( 0, 3 );                                                                                       // 1633
		}                                                                                                                  // 1634
	},                                                                                                                  // 1635
                                                                                                                     // 1636
	filter: {                                                                                                           // 1637
                                                                                                                     // 1638
		"TAG": function( nodeNameSelector ) {                                                                              // 1639
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();                                    // 1640
			return nodeNameSelector === "*" ?                                                                                 // 1641
				function() { return true; } :                                                                                    // 1642
				function( elem ) {                                                                                               // 1643
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;                                               // 1644
				};                                                                                                               // 1645
		},                                                                                                                 // 1646
                                                                                                                     // 1647
		"CLASS": function( className ) {                                                                                   // 1648
			var pattern = classCache[ className + " " ];                                                                      // 1649
                                                                                                                     // 1650
			return pattern ||                                                                                                 // 1651
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&                     // 1652
				classCache( className, function( elem ) {                                                                        // 1653
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute("class") || "" );
				});                                                                                                              // 1655
		},                                                                                                                 // 1656
                                                                                                                     // 1657
		"ATTR": function( name, operator, check ) {                                                                        // 1658
			return function( elem ) {                                                                                         // 1659
				var result = Sizzle.attr( elem, name );                                                                          // 1660
                                                                                                                     // 1661
				if ( result == null ) {                                                                                          // 1662
					return operator === "!=";                                                                                       // 1663
				}                                                                                                                // 1664
				if ( !operator ) {                                                                                               // 1665
					return true;                                                                                                    // 1666
				}                                                                                                                // 1667
                                                                                                                     // 1668
				result += "";                                                                                                    // 1669
                                                                                                                     // 1670
				return operator === "=" ? result === check :                                                                     // 1671
					operator === "!=" ? result !== check :                                                                          // 1672
					operator === "^=" ? check && result.indexOf( check ) === 0 :                                                    // 1673
					operator === "*=" ? check && result.indexOf( check ) > -1 :                                                     // 1674
					operator === "$=" ? check && result.slice( -check.length ) === check :                                          // 1675
					operator === "~=" ? ( " " + result + " " ).indexOf( check ) > -1 :                                              // 1676
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :                   // 1677
					false;                                                                                                          // 1678
			};                                                                                                                // 1679
		},                                                                                                                 // 1680
                                                                                                                     // 1681
		"CHILD": function( type, what, argument, first, last ) {                                                           // 1682
			var simple = type.slice( 0, 3 ) !== "nth",                                                                        // 1683
				forward = type.slice( -4 ) !== "last",                                                                           // 1684
				ofType = what === "of-type";                                                                                     // 1685
                                                                                                                     // 1686
			return first === 1 && last === 0 ?                                                                                // 1687
                                                                                                                     // 1688
				// Shortcut for :nth-*(n)                                                                                        // 1689
				function( elem ) {                                                                                               // 1690
					return !!elem.parentNode;                                                                                       // 1691
				} :                                                                                                              // 1692
                                                                                                                     // 1693
				function( elem, context, xml ) {                                                                                 // 1694
					var cache, outerCache, node, diff, nodeIndex, start,                                                            // 1695
						dir = simple !== forward ? "nextSibling" : "previousSibling",                                                  // 1696
						parent = elem.parentNode,                                                                                      // 1697
						name = ofType && elem.nodeName.toLowerCase(),                                                                  // 1698
						useCache = !xml && !ofType;                                                                                    // 1699
                                                                                                                     // 1700
					if ( parent ) {                                                                                                 // 1701
                                                                                                                     // 1702
						// :(first|last|only)-(child|of-type)                                                                          // 1703
						if ( simple ) {                                                                                                // 1704
							while ( dir ) {                                                                                               // 1705
								node = elem;                                                                                                 // 1706
								while ( (node = node[ dir ]) ) {                                                                             // 1707
									if ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) {                                // 1708
										return false;                                                                                              // 1709
									}                                                                                                           // 1710
								}                                                                                                            // 1711
								// Reverse direction for :only-* (if we haven't yet done so)                                                 // 1712
								start = dir = type === "only" && !start && "nextSibling";                                                    // 1713
							}                                                                                                             // 1714
							return true;                                                                                                  // 1715
						}                                                                                                              // 1716
                                                                                                                     // 1717
						start = [ forward ? parent.firstChild : parent.lastChild ];                                                    // 1718
                                                                                                                     // 1719
						// non-xml :nth-child(...) stores cache data on `parent`                                                       // 1720
						if ( forward && useCache ) {                                                                                   // 1721
							// Seek `elem` from a previously-cached index                                                                 // 1722
							outerCache = parent[ expando ] || (parent[ expando ] = {});                                                   // 1723
							cache = outerCache[ type ] || [];                                                                             // 1724
							nodeIndex = cache[0] === dirruns && cache[1];                                                                 // 1725
							diff = cache[0] === dirruns && cache[2];                                                                      // 1726
							node = nodeIndex && parent.childNodes[ nodeIndex ];                                                           // 1727
                                                                                                                     // 1728
							while ( (node = ++nodeIndex && node && node[ dir ] ||                                                         // 1729
                                                                                                                     // 1730
								// Fallback to seeking `elem` from the start                                                                 // 1731
								(diff = nodeIndex = 0) || start.pop()) ) {                                                                   // 1732
                                                                                                                     // 1733
								// When found, cache indexes on `parent` and break                                                           // 1734
								if ( node.nodeType === 1 && ++diff && node === elem ) {                                                      // 1735
									outerCache[ type ] = [ dirruns, nodeIndex, diff ];                                                          // 1736
									break;                                                                                                      // 1737
								}                                                                                                            // 1738
							}                                                                                                             // 1739
                                                                                                                     // 1740
						// Use previously-cached element index if available                                                            // 1741
						} else if ( useCache && (cache = (elem[ expando ] || (elem[ expando ] = {}))[ type ]) && cache[0] === dirruns ) {
							diff = cache[1];                                                                                              // 1743
                                                                                                                     // 1744
						// xml :nth-child(...) or :nth-last-child(...) or :nth(-last)?-of-type(...)                                    // 1745
						} else {                                                                                                       // 1746
							// Use the same loop as above to seek `elem` from the start                                                   // 1747
							while ( (node = ++nodeIndex && node && node[ dir ] ||                                                         // 1748
								(diff = nodeIndex = 0) || start.pop()) ) {                                                                   // 1749
                                                                                                                     // 1750
								if ( ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) && ++diff ) {                   // 1751
									// Cache the index of each encountered element                                                              // 1752
									if ( useCache ) {                                                                                           // 1753
										(node[ expando ] || (node[ expando ] = {}))[ type ] = [ dirruns, diff ];                                   // 1754
									}                                                                                                           // 1755
                                                                                                                     // 1756
									if ( node === elem ) {                                                                                      // 1757
										break;                                                                                                     // 1758
									}                                                                                                           // 1759
								}                                                                                                            // 1760
							}                                                                                                             // 1761
						}                                                                                                              // 1762
                                                                                                                     // 1763
						// Incorporate the offset, then check against cycle size                                                       // 1764
						diff -= last;                                                                                                  // 1765
						return diff === first || ( diff % first === 0 && diff / first >= 0 );                                          // 1766
					}                                                                                                               // 1767
				};                                                                                                               // 1768
		},                                                                                                                 // 1769
                                                                                                                     // 1770
		"PSEUDO": function( pseudo, argument ) {                                                                           // 1771
			// pseudo-class names are case-insensitive                                                                        // 1772
			// http://www.w3.org/TR/selectors/#pseudo-classes                                                                 // 1773
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters                         // 1774
			// Remember that setFilters inherits from pseudos                                                                 // 1775
			var args,                                                                                                         // 1776
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||                                        // 1777
					Sizzle.error( "unsupported pseudo: " + pseudo );                                                                // 1778
                                                                                                                     // 1779
			// The user may use createPseudo to indicate that                                                                 // 1780
			// arguments are needed to create the filter function                                                             // 1781
			// just as Sizzle does                                                                                            // 1782
			if ( fn[ expando ] ) {                                                                                            // 1783
				return fn( argument );                                                                                           // 1784
			}                                                                                                                 // 1785
                                                                                                                     // 1786
			// But maintain support for old signatures                                                                        // 1787
			if ( fn.length > 1 ) {                                                                                            // 1788
				args = [ pseudo, pseudo, "", argument ];                                                                         // 1789
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?                                                  // 1790
					markFunction(function( seed, matches ) {                                                                        // 1791
						var idx,                                                                                                       // 1792
							matched = fn( seed, argument ),                                                                               // 1793
							i = matched.length;                                                                                           // 1794
						while ( i-- ) {                                                                                                // 1795
							idx = indexOf.call( seed, matched[i] );                                                                       // 1796
							seed[ idx ] = !( matches[ idx ] = matched[i] );                                                               // 1797
						}                                                                                                              // 1798
					}) :                                                                                                            // 1799
					function( elem ) {                                                                                              // 1800
						return fn( elem, 0, args );                                                                                    // 1801
					};                                                                                                              // 1802
			}                                                                                                                 // 1803
                                                                                                                     // 1804
			return fn;                                                                                                        // 1805
		}                                                                                                                  // 1806
	},                                                                                                                  // 1807
                                                                                                                     // 1808
	pseudos: {                                                                                                          // 1809
		// Potentially complex pseudos                                                                                     // 1810
		"not": markFunction(function( selector ) {                                                                         // 1811
			// Trim the selector passed to compile                                                                            // 1812
			// to avoid treating leading and trailing                                                                         // 1813
			// spaces as combinators                                                                                          // 1814
			var input = [],                                                                                                   // 1815
				results = [],                                                                                                    // 1816
				matcher = compile( selector.replace( rtrim, "$1" ) );                                                            // 1817
                                                                                                                     // 1818
			return matcher[ expando ] ?                                                                                       // 1819
				markFunction(function( seed, matches, context, xml ) {                                                           // 1820
					var elem,                                                                                                       // 1821
						unmatched = matcher( seed, null, xml, [] ),                                                                    // 1822
						i = seed.length;                                                                                               // 1823
                                                                                                                     // 1824
					// Match elements unmatched by `matcher`                                                                        // 1825
					while ( i-- ) {                                                                                                 // 1826
						if ( (elem = unmatched[i]) ) {                                                                                 // 1827
							seed[i] = !(matches[i] = elem);                                                                               // 1828
						}                                                                                                              // 1829
					}                                                                                                               // 1830
				}) :                                                                                                             // 1831
				function( elem, context, xml ) {                                                                                 // 1832
					input[0] = elem;                                                                                                // 1833
					matcher( input, null, xml, results );                                                                           // 1834
					return !results.pop();                                                                                          // 1835
				};                                                                                                               // 1836
		}),                                                                                                                // 1837
                                                                                                                     // 1838
		"has": markFunction(function( selector ) {                                                                         // 1839
			return function( elem ) {                                                                                         // 1840
				return Sizzle( selector, elem ).length > 0;                                                                      // 1841
			};                                                                                                                // 1842
		}),                                                                                                                // 1843
                                                                                                                     // 1844
		"contains": markFunction(function( text ) {                                                                        // 1845
			return function( elem ) {                                                                                         // 1846
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;                           // 1847
			};                                                                                                                // 1848
		}),                                                                                                                // 1849
                                                                                                                     // 1850
		// "Whether an element is represented by a :lang() selector                                                        // 1851
		// is based solely on the element's language value                                                                 // 1852
		// being equal to the identifier C,                                                                                // 1853
		// or beginning with the identifier C immediately followed by "-".                                                 // 1854
		// The matching of C against the element's language value is performed case-insensitively.                         // 1855
		// The identifier C does not have to be a valid language name."                                                    // 1856
		// http://www.w3.org/TR/selectors/#lang-pseudo                                                                     // 1857
		"lang": markFunction( function( lang ) {                                                                           // 1858
			// lang value must be a valid identifier                                                                          // 1859
			if ( !ridentifier.test(lang || "") ) {                                                                            // 1860
				Sizzle.error( "unsupported lang: " + lang );                                                                     // 1861
			}                                                                                                                 // 1862
			lang = lang.replace( runescape, funescape ).toLowerCase();                                                        // 1863
			return function( elem ) {                                                                                         // 1864
				var elemLang;                                                                                                    // 1865
				do {                                                                                                             // 1866
					if ( (elemLang = documentIsHTML ?                                                                               // 1867
						elem.lang :                                                                                                    // 1868
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {                                                // 1869
                                                                                                                     // 1870
						elemLang = elemLang.toLowerCase();                                                                             // 1871
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;                                              // 1872
					}                                                                                                               // 1873
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );                                                     // 1874
				return false;                                                                                                    // 1875
			};                                                                                                                // 1876
		}),                                                                                                                // 1877
                                                                                                                     // 1878
		// Miscellaneous                                                                                                   // 1879
		"target": function( elem ) {                                                                                       // 1880
			var hash = window.location && window.location.hash;                                                               // 1881
			return hash && hash.slice( 1 ) === elem.id;                                                                       // 1882
		},                                                                                                                 // 1883
                                                                                                                     // 1884
		"root": function( elem ) {                                                                                         // 1885
			return elem === docElem;                                                                                          // 1886
		},                                                                                                                 // 1887
                                                                                                                     // 1888
		"focus": function( elem ) {                                                                                        // 1889
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},                                                                                                                 // 1891
                                                                                                                     // 1892
		// Boolean properties                                                                                              // 1893
		"enabled": function( elem ) {                                                                                      // 1894
			return elem.disabled === false;                                                                                   // 1895
		},                                                                                                                 // 1896
                                                                                                                     // 1897
		"disabled": function( elem ) {                                                                                     // 1898
			return elem.disabled === true;                                                                                    // 1899
		},                                                                                                                 // 1900
                                                                                                                     // 1901
		"checked": function( elem ) {                                                                                      // 1902
			// In CSS3, :checked should return both checked and selected elements                                             // 1903
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked                                                 // 1904
			var nodeName = elem.nodeName.toLowerCase();                                                                       // 1905
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);                    // 1906
		},                                                                                                                 // 1907
                                                                                                                     // 1908
		"selected": function( elem ) {                                                                                     // 1909
			// Accessing this property makes selected-by-default                                                              // 1910
			// options in Safari work properly                                                                                // 1911
			if ( elem.parentNode ) {                                                                                          // 1912
				elem.parentNode.selectedIndex;                                                                                   // 1913
			}                                                                                                                 // 1914
                                                                                                                     // 1915
			return elem.selected === true;                                                                                    // 1916
		},                                                                                                                 // 1917
                                                                                                                     // 1918
		// Contents                                                                                                        // 1919
		"empty": function( elem ) {                                                                                        // 1920
			// http://www.w3.org/TR/selectors/#empty-pseudo                                                                   // 1921
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),                          // 1922
			//   but not by others (comment: 8; processing instruction: 7; etc.)                                              // 1923
			// nodeType < 6 works because attributes (2) do not appear as children                                            // 1924
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {                                                   // 1925
				if ( elem.nodeType < 6 ) {                                                                                       // 1926
					return false;                                                                                                   // 1927
				}                                                                                                                // 1928
			}                                                                                                                 // 1929
			return true;                                                                                                      // 1930
		},                                                                                                                 // 1931
                                                                                                                     // 1932
		"parent": function( elem ) {                                                                                       // 1933
			return !Expr.pseudos["empty"]( elem );                                                                            // 1934
		},                                                                                                                 // 1935
                                                                                                                     // 1936
		// Element/input types                                                                                             // 1937
		"header": function( elem ) {                                                                                       // 1938
			return rheader.test( elem.nodeName );                                                                             // 1939
		},                                                                                                                 // 1940
                                                                                                                     // 1941
		"input": function( elem ) {                                                                                        // 1942
			return rinputs.test( elem.nodeName );                                                                             // 1943
		},                                                                                                                 // 1944
                                                                                                                     // 1945
		"button": function( elem ) {                                                                                       // 1946
			var name = elem.nodeName.toLowerCase();                                                                           // 1947
			return name === "input" && elem.type === "button" || name === "button";                                           // 1948
		},                                                                                                                 // 1949
                                                                                                                     // 1950
		"text": function( elem ) {                                                                                         // 1951
			var attr;                                                                                                         // 1952
			return elem.nodeName.toLowerCase() === "input" &&                                                                 // 1953
				elem.type === "text" &&                                                                                          // 1954
                                                                                                                     // 1955
				// Support: IE<8                                                                                                 // 1956
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"                                  // 1957
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );                                 // 1958
		},                                                                                                                 // 1959
                                                                                                                     // 1960
		// Position-in-collection                                                                                          // 1961
		"first": createPositionalPseudo(function() {                                                                       // 1962
			return [ 0 ];                                                                                                     // 1963
		}),                                                                                                                // 1964
                                                                                                                     // 1965
		"last": createPositionalPseudo(function( matchIndexes, length ) {                                                  // 1966
			return [ length - 1 ];                                                                                            // 1967
		}),                                                                                                                // 1968
                                                                                                                     // 1969
		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {                                          // 1970
			return [ argument < 0 ? argument + length : argument ];                                                           // 1971
		}),                                                                                                                // 1972
                                                                                                                     // 1973
		"even": createPositionalPseudo(function( matchIndexes, length ) {                                                  // 1974
			var i = 0;                                                                                                        // 1975
			for ( ; i < length; i += 2 ) {                                                                                    // 1976
				matchIndexes.push( i );                                                                                          // 1977
			}                                                                                                                 // 1978
			return matchIndexes;                                                                                              // 1979
		}),                                                                                                                // 1980
                                                                                                                     // 1981
		"odd": createPositionalPseudo(function( matchIndexes, length ) {                                                   // 1982
			var i = 1;                                                                                                        // 1983
			for ( ; i < length; i += 2 ) {                                                                                    // 1984
				matchIndexes.push( i );                                                                                          // 1985
			}                                                                                                                 // 1986
			return matchIndexes;                                                                                              // 1987
		}),                                                                                                                // 1988
                                                                                                                     // 1989
		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {                                          // 1990
			var i = argument < 0 ? argument + length : argument;                                                              // 1991
			for ( ; --i >= 0; ) {                                                                                             // 1992
				matchIndexes.push( i );                                                                                          // 1993
			}                                                                                                                 // 1994
			return matchIndexes;                                                                                              // 1995
		}),                                                                                                                // 1996
                                                                                                                     // 1997
		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {                                          // 1998
			var i = argument < 0 ? argument + length : argument;                                                              // 1999
			for ( ; ++i < length; ) {                                                                                         // 2000
				matchIndexes.push( i );                                                                                          // 2001
			}                                                                                                                 // 2002
			return matchIndexes;                                                                                              // 2003
		})                                                                                                                 // 2004
	}                                                                                                                   // 2005
};                                                                                                                   // 2006
                                                                                                                     // 2007
Expr.pseudos["nth"] = Expr.pseudos["eq"];                                                                            // 2008
                                                                                                                     // 2009
// Add button/input type pseudos                                                                                     // 2010
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {                              // 2011
	Expr.pseudos[ i ] = createInputPseudo( i );                                                                         // 2012
}                                                                                                                    // 2013
for ( i in { submit: true, reset: true } ) {                                                                         // 2014
	Expr.pseudos[ i ] = createButtonPseudo( i );                                                                        // 2015
}                                                                                                                    // 2016
                                                                                                                     // 2017
// Easy API for creating new setFilters                                                                              // 2018
function setFilters() {}                                                                                             // 2019
setFilters.prototype = Expr.filters = Expr.pseudos;                                                                  // 2020
Expr.setFilters = new setFilters();                                                                                  // 2021
                                                                                                                     // 2022
function tokenize( selector, parseOnly ) {                                                                           // 2023
	var matched, match, tokens, type,                                                                                   // 2024
		soFar, groups, preFilters,                                                                                         // 2025
		cached = tokenCache[ selector + " " ];                                                                             // 2026
                                                                                                                     // 2027
	if ( cached ) {                                                                                                     // 2028
		return parseOnly ? 0 : cached.slice( 0 );                                                                          // 2029
	}                                                                                                                   // 2030
                                                                                                                     // 2031
	soFar = selector;                                                                                                   // 2032
	groups = [];                                                                                                        // 2033
	preFilters = Expr.preFilter;                                                                                        // 2034
                                                                                                                     // 2035
	while ( soFar ) {                                                                                                   // 2036
                                                                                                                     // 2037
		// Comma and first run                                                                                             // 2038
		if ( !matched || (match = rcomma.exec( soFar )) ) {                                                                // 2039
			if ( match ) {                                                                                                    // 2040
				// Don't consume trailing commas as valid                                                                        // 2041
				soFar = soFar.slice( match[0].length ) || soFar;                                                                 // 2042
			}                                                                                                                 // 2043
			groups.push( (tokens = []) );                                                                                     // 2044
		}                                                                                                                  // 2045
                                                                                                                     // 2046
		matched = false;                                                                                                   // 2047
                                                                                                                     // 2048
		// Combinators                                                                                                     // 2049
		if ( (match = rcombinators.exec( soFar )) ) {                                                                      // 2050
			matched = match.shift();                                                                                          // 2051
			tokens.push({                                                                                                     // 2052
				value: matched,                                                                                                  // 2053
				// Cast descendant combinators to space                                                                          // 2054
				type: match[0].replace( rtrim, " " )                                                                             // 2055
			});                                                                                                               // 2056
			soFar = soFar.slice( matched.length );                                                                            // 2057
		}                                                                                                                  // 2058
                                                                                                                     // 2059
		// Filters                                                                                                         // 2060
		for ( type in Expr.filter ) {                                                                                      // 2061
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||                                         // 2062
				(match = preFilters[ type ]( match ))) ) {                                                                       // 2063
				matched = match.shift();                                                                                         // 2064
				tokens.push({                                                                                                    // 2065
					value: matched,                                                                                                 // 2066
					type: type,                                                                                                     // 2067
					matches: match                                                                                                  // 2068
				});                                                                                                              // 2069
				soFar = soFar.slice( matched.length );                                                                           // 2070
			}                                                                                                                 // 2071
		}                                                                                                                  // 2072
                                                                                                                     // 2073
		if ( !matched ) {                                                                                                  // 2074
			break;                                                                                                            // 2075
		}                                                                                                                  // 2076
	}                                                                                                                   // 2077
                                                                                                                     // 2078
	// Return the length of the invalid excess                                                                          // 2079
	// if we're just parsing                                                                                            // 2080
	// Otherwise, throw an error or return tokens                                                                       // 2081
	return parseOnly ?                                                                                                  // 2082
		soFar.length :                                                                                                     // 2083
		soFar ?                                                                                                            // 2084
			Sizzle.error( selector ) :                                                                                        // 2085
			// Cache the tokens                                                                                               // 2086
			tokenCache( selector, groups ).slice( 0 );                                                                        // 2087
}                                                                                                                    // 2088
                                                                                                                     // 2089
function toSelector( tokens ) {                                                                                      // 2090
	var i = 0,                                                                                                          // 2091
		len = tokens.length,                                                                                               // 2092
		selector = "";                                                                                                     // 2093
	for ( ; i < len; i++ ) {                                                                                            // 2094
		selector += tokens[i].value;                                                                                       // 2095
	}                                                                                                                   // 2096
	return selector;                                                                                                    // 2097
}                                                                                                                    // 2098
                                                                                                                     // 2099
function addCombinator( matcher, combinator, base ) {                                                                // 2100
	var dir = combinator.dir,                                                                                           // 2101
		checkNonElements = base && dir === "parentNode",                                                                   // 2102
		doneName = done++;                                                                                                 // 2103
                                                                                                                     // 2104
	return combinator.first ?                                                                                           // 2105
		// Check against closest ancestor/preceding element                                                                // 2106
		function( elem, context, xml ) {                                                                                   // 2107
			while ( (elem = elem[ dir ]) ) {                                                                                  // 2108
				if ( elem.nodeType === 1 || checkNonElements ) {                                                                 // 2109
					return matcher( elem, context, xml );                                                                           // 2110
				}                                                                                                                // 2111
			}                                                                                                                 // 2112
		} :                                                                                                                // 2113
                                                                                                                     // 2114
		// Check against all ancestor/preceding elements                                                                   // 2115
		function( elem, context, xml ) {                                                                                   // 2116
			var oldCache, outerCache,                                                                                         // 2117
				newCache = [ dirruns, doneName ];                                                                                // 2118
                                                                                                                     // 2119
			// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching                               // 2120
			if ( xml ) {                                                                                                      // 2121
				while ( (elem = elem[ dir ]) ) {                                                                                 // 2122
					if ( elem.nodeType === 1 || checkNonElements ) {                                                                // 2123
						if ( matcher( elem, context, xml ) ) {                                                                         // 2124
							return true;                                                                                                  // 2125
						}                                                                                                              // 2126
					}                                                                                                               // 2127
				}                                                                                                                // 2128
			} else {                                                                                                          // 2129
				while ( (elem = elem[ dir ]) ) {                                                                                 // 2130
					if ( elem.nodeType === 1 || checkNonElements ) {                                                                // 2131
						outerCache = elem[ expando ] || (elem[ expando ] = {});                                                        // 2132
						if ( (oldCache = outerCache[ dir ]) &&                                                                         // 2133
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {                                                   // 2134
                                                                                                                     // 2135
							// Assign to newCache so results back-propagate to previous elements                                          // 2136
							return (newCache[ 2 ] = oldCache[ 2 ]);                                                                       // 2137
						} else {                                                                                                       // 2138
							// Reuse newcache so results back-propagate to previous elements                                              // 2139
							outerCache[ dir ] = newCache;                                                                                 // 2140
                                                                                                                     // 2141
							// A match means we're done; a fail means we have to keep checking                                            // 2142
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {                                                      // 2143
								return true;                                                                                                 // 2144
							}                                                                                                             // 2145
						}                                                                                                              // 2146
					}                                                                                                               // 2147
				}                                                                                                                // 2148
			}                                                                                                                 // 2149
		};                                                                                                                 // 2150
}                                                                                                                    // 2151
                                                                                                                     // 2152
function elementMatcher( matchers ) {                                                                                // 2153
	return matchers.length > 1 ?                                                                                        // 2154
		function( elem, context, xml ) {                                                                                   // 2155
			var i = matchers.length;                                                                                          // 2156
			while ( i-- ) {                                                                                                   // 2157
				if ( !matchers[i]( elem, context, xml ) ) {                                                                      // 2158
					return false;                                                                                                   // 2159
				}                                                                                                                // 2160
			}                                                                                                                 // 2161
			return true;                                                                                                      // 2162
		} :                                                                                                                // 2163
		matchers[0];                                                                                                       // 2164
}                                                                                                                    // 2165
                                                                                                                     // 2166
function condense( unmatched, map, filter, context, xml ) {                                                          // 2167
	var elem,                                                                                                           // 2168
		newUnmatched = [],                                                                                                 // 2169
		i = 0,                                                                                                             // 2170
		len = unmatched.length,                                                                                            // 2171
		mapped = map != null;                                                                                              // 2172
                                                                                                                     // 2173
	for ( ; i < len; i++ ) {                                                                                            // 2174
		if ( (elem = unmatched[i]) ) {                                                                                     // 2175
			if ( !filter || filter( elem, context, xml ) ) {                                                                  // 2176
				newUnmatched.push( elem );                                                                                       // 2177
				if ( mapped ) {                                                                                                  // 2178
					map.push( i );                                                                                                  // 2179
				}                                                                                                                // 2180
			}                                                                                                                 // 2181
		}                                                                                                                  // 2182
	}                                                                                                                   // 2183
                                                                                                                     // 2184
	return newUnmatched;                                                                                                // 2185
}                                                                                                                    // 2186
                                                                                                                     // 2187
function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {                          // 2188
	if ( postFilter && !postFilter[ expando ] ) {                                                                       // 2189
		postFilter = setMatcher( postFilter );                                                                             // 2190
	}                                                                                                                   // 2191
	if ( postFinder && !postFinder[ expando ] ) {                                                                       // 2192
		postFinder = setMatcher( postFinder, postSelector );                                                               // 2193
	}                                                                                                                   // 2194
	return markFunction(function( seed, results, context, xml ) {                                                       // 2195
		var temp, i, elem,                                                                                                 // 2196
			preMap = [],                                                                                                      // 2197
			postMap = [],                                                                                                     // 2198
			preexisting = results.length,                                                                                     // 2199
                                                                                                                     // 2200
			// Get initial elements from seed or context                                                                      // 2201
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),                // 2202
                                                                                                                     // 2203
			// Prefilter to get matcher input, preserving a map for seed-results synchronization                              // 2204
			matcherIn = preFilter && ( seed || !selector ) ?                                                                  // 2205
				condense( elems, preMap, preFilter, context, xml ) :                                                             // 2206
				elems,                                                                                                           // 2207
                                                                                                                     // 2208
			matcherOut = matcher ?                                                                                            // 2209
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,                     // 2210
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?                                                 // 2211
                                                                                                                     // 2212
					// ...intermediate processing is necessary                                                                      // 2213
					[] :                                                                                                            // 2214
                                                                                                                     // 2215
					// ...otherwise use results directly                                                                            // 2216
					results :                                                                                                       // 2217
				matcherIn;                                                                                                       // 2218
                                                                                                                     // 2219
		// Find primary matches                                                                                            // 2220
		if ( matcher ) {                                                                                                   // 2221
			matcher( matcherIn, matcherOut, context, xml );                                                                   // 2222
		}                                                                                                                  // 2223
                                                                                                                     // 2224
		// Apply postFilter                                                                                                // 2225
		if ( postFilter ) {                                                                                                // 2226
			temp = condense( matcherOut, postMap );                                                                           // 2227
			postFilter( temp, [], context, xml );                                                                             // 2228
                                                                                                                     // 2229
			// Un-match failing elements by moving them back to matcherIn                                                     // 2230
			i = temp.length;                                                                                                  // 2231
			while ( i-- ) {                                                                                                   // 2232
				if ( (elem = temp[i]) ) {                                                                                        // 2233
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);                                                   // 2234
				}                                                                                                                // 2235
			}                                                                                                                 // 2236
		}                                                                                                                  // 2237
                                                                                                                     // 2238
		if ( seed ) {                                                                                                      // 2239
			if ( postFinder || preFilter ) {                                                                                  // 2240
				if ( postFinder ) {                                                                                              // 2241
					// Get the final matcherOut by condensing this intermediate into postFinder contexts                            // 2242
					temp = [];                                                                                                      // 2243
					i = matcherOut.length;                                                                                          // 2244
					while ( i-- ) {                                                                                                 // 2245
						if ( (elem = matcherOut[i]) ) {                                                                                // 2246
							// Restore matcherIn since elem is not yet a final match                                                      // 2247
							temp.push( (matcherIn[i] = elem) );                                                                           // 2248
						}                                                                                                              // 2249
					}                                                                                                               // 2250
					postFinder( null, (matcherOut = []), temp, xml );                                                               // 2251
				}                                                                                                                // 2252
                                                                                                                     // 2253
				// Move matched elements from seed to results to keep them synchronized                                          // 2254
				i = matcherOut.length;                                                                                           // 2255
				while ( i-- ) {                                                                                                  // 2256
					if ( (elem = matcherOut[i]) &&                                                                                  // 2257
						(temp = postFinder ? indexOf.call( seed, elem ) : preMap[i]) > -1 ) {                                          // 2258
                                                                                                                     // 2259
						seed[temp] = !(results[temp] = elem);                                                                          // 2260
					}                                                                                                               // 2261
				}                                                                                                                // 2262
			}                                                                                                                 // 2263
                                                                                                                     // 2264
		// Add elements to results, through postFinder if defined                                                          // 2265
		} else {                                                                                                           // 2266
			matcherOut = condense(                                                                                            // 2267
				matcherOut === results ?                                                                                         // 2268
					matcherOut.splice( preexisting, matcherOut.length ) :                                                           // 2269
					matcherOut                                                                                                      // 2270
			);                                                                                                                // 2271
			if ( postFinder ) {                                                                                               // 2272
				postFinder( null, results, matcherOut, xml );                                                                    // 2273
			} else {                                                                                                          // 2274
				push.apply( results, matcherOut );                                                                               // 2275
			}                                                                                                                 // 2276
		}                                                                                                                  // 2277
	});                                                                                                                 // 2278
}                                                                                                                    // 2279
                                                                                                                     // 2280
function matcherFromTokens( tokens ) {                                                                               // 2281
	var checkContext, matcher, j,                                                                                       // 2282
		len = tokens.length,                                                                                               // 2283
		leadingRelative = Expr.relative[ tokens[0].type ],                                                                 // 2284
		implicitRelative = leadingRelative || Expr.relative[" "],                                                          // 2285
		i = leadingRelative ? 1 : 0,                                                                                       // 2286
                                                                                                                     // 2287
		// The foundational matcher ensures that elements are reachable from top-level context(s)                          // 2288
		matchContext = addCombinator( function( elem ) {                                                                   // 2289
			return elem === checkContext;                                                                                     // 2290
		}, implicitRelative, true ),                                                                                       // 2291
		matchAnyContext = addCombinator( function( elem ) {                                                                // 2292
			return indexOf.call( checkContext, elem ) > -1;                                                                   // 2293
		}, implicitRelative, true ),                                                                                       // 2294
		matchers = [ function( elem, context, xml ) {                                                                      // 2295
			return ( !leadingRelative && ( xml || context !== outermostContext ) ) || (                                       // 2296
				(checkContext = context).nodeType ?                                                                              // 2297
					matchContext( elem, context, xml ) :                                                                            // 2298
					matchAnyContext( elem, context, xml ) );                                                                        // 2299
		} ];                                                                                                               // 2300
                                                                                                                     // 2301
	for ( ; i < len; i++ ) {                                                                                            // 2302
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {                                                               // 2303
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];                                                // 2304
		} else {                                                                                                           // 2305
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );                                         // 2306
                                                                                                                     // 2307
			// Return special upon seeing a positional matcher                                                                // 2308
			if ( matcher[ expando ] ) {                                                                                       // 2309
				// Find the next relative operator (if any) for proper handling                                                  // 2310
				j = ++i;                                                                                                         // 2311
				for ( ; j < len; j++ ) {                                                                                         // 2312
					if ( Expr.relative[ tokens[j].type ] ) {                                                                        // 2313
						break;                                                                                                         // 2314
					}                                                                                                               // 2315
				}                                                                                                                // 2316
				return setMatcher(                                                                                               // 2317
					i > 1 && elementMatcher( matchers ),                                                                            // 2318
					i > 1 && toSelector(                                                                                            // 2319
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`                      // 2320
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })                            // 2321
					).replace( rtrim, "$1" ),                                                                                       // 2322
					matcher,                                                                                                        // 2323
					i < j && matcherFromTokens( tokens.slice( i, j ) ),                                                             // 2324
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),                                                   // 2325
					j < len && toSelector( tokens )                                                                                 // 2326
				);                                                                                                               // 2327
			}                                                                                                                 // 2328
			matchers.push( matcher );                                                                                         // 2329
		}                                                                                                                  // 2330
	}                                                                                                                   // 2331
                                                                                                                     // 2332
	return elementMatcher( matchers );                                                                                  // 2333
}                                                                                                                    // 2334
                                                                                                                     // 2335
function matcherFromGroupMatchers( elementMatchers, setMatchers ) {                                                  // 2336
	var bySet = setMatchers.length > 0,                                                                                 // 2337
		byElement = elementMatchers.length > 0,                                                                            // 2338
		superMatcher = function( seed, context, xml, results, outermost ) {                                                // 2339
			var elem, j, matcher,                                                                                             // 2340
				matchedCount = 0,                                                                                                // 2341
				i = "0",                                                                                                         // 2342
				unmatched = seed && [],                                                                                          // 2343
				setMatched = [],                                                                                                 // 2344
				contextBackup = outermostContext,                                                                                // 2345
				// We must always have either seed elements or outermost context                                                 // 2346
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),                                                 // 2347
				// Use integer dirruns iff this is the outermost matcher                                                         // 2348
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),                                   // 2349
				len = elems.length;                                                                                              // 2350
                                                                                                                     // 2351
			if ( outermost ) {                                                                                                // 2352
				outermostContext = context !== document && context;                                                              // 2353
			}                                                                                                                 // 2354
                                                                                                                     // 2355
			// Add elements passing elementMatchers directly to results                                                       // 2356
			// Keep `i` a string if there are no elements so `matchedCount` will be "00" below                                // 2357
			// Support: IE<9, Safari                                                                                          // 2358
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id                          // 2359
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {                                                           // 2360
				if ( byElement && elem ) {                                                                                       // 2361
					j = 0;                                                                                                          // 2362
					while ( (matcher = elementMatchers[j++]) ) {                                                                    // 2363
						if ( matcher( elem, context, xml ) ) {                                                                         // 2364
							results.push( elem );                                                                                         // 2365
							break;                                                                                                        // 2366
						}                                                                                                              // 2367
					}                                                                                                               // 2368
					if ( outermost ) {                                                                                              // 2369
						dirruns = dirrunsUnique;                                                                                       // 2370
					}                                                                                                               // 2371
				}                                                                                                                // 2372
                                                                                                                     // 2373
				// Track unmatched elements for set filters                                                                      // 2374
				if ( bySet ) {                                                                                                   // 2375
					// They will have gone through all possible matchers                                                            // 2376
					if ( (elem = !matcher && elem) ) {                                                                              // 2377
						matchedCount--;                                                                                                // 2378
					}                                                                                                               // 2379
                                                                                                                     // 2380
					// Lengthen the array for every element, matched or not                                                         // 2381
					if ( seed ) {                                                                                                   // 2382
						unmatched.push( elem );                                                                                        // 2383
					}                                                                                                               // 2384
				}                                                                                                                // 2385
			}                                                                                                                 // 2386
                                                                                                                     // 2387
			// Apply set filters to unmatched elements                                                                        // 2388
			matchedCount += i;                                                                                                // 2389
			if ( bySet && i !== matchedCount ) {                                                                              // 2390
				j = 0;                                                                                                           // 2391
				while ( (matcher = setMatchers[j++]) ) {                                                                         // 2392
					matcher( unmatched, setMatched, context, xml );                                                                 // 2393
				}                                                                                                                // 2394
                                                                                                                     // 2395
				if ( seed ) {                                                                                                    // 2396
					// Reintegrate element matches to eliminate the need for sorting                                                // 2397
					if ( matchedCount > 0 ) {                                                                                       // 2398
						while ( i-- ) {                                                                                                // 2399
							if ( !(unmatched[i] || setMatched[i]) ) {                                                                     // 2400
								setMatched[i] = pop.call( results );                                                                         // 2401
							}                                                                                                             // 2402
						}                                                                                                              // 2403
					}                                                                                                               // 2404
                                                                                                                     // 2405
					// Discard index placeholder values to get only actual matches                                                  // 2406
					setMatched = condense( setMatched );                                                                            // 2407
				}                                                                                                                // 2408
                                                                                                                     // 2409
				// Add matches to results                                                                                        // 2410
				push.apply( results, setMatched );                                                                               // 2411
                                                                                                                     // 2412
				// Seedless set matches succeeding multiple successful matchers stipulate sorting                                // 2413
				if ( outermost && !seed && setMatched.length > 0 &&                                                              // 2414
					( matchedCount + setMatchers.length ) > 1 ) {                                                                   // 2415
                                                                                                                     // 2416
					Sizzle.uniqueSort( results );                                                                                   // 2417
				}                                                                                                                // 2418
			}                                                                                                                 // 2419
                                                                                                                     // 2420
			// Override manipulation of globals by nested matchers                                                            // 2421
			if ( outermost ) {                                                                                                // 2422
				dirruns = dirrunsUnique;                                                                                         // 2423
				outermostContext = contextBackup;                                                                                // 2424
			}                                                                                                                 // 2425
                                                                                                                     // 2426
			return unmatched;                                                                                                 // 2427
		};                                                                                                                 // 2428
                                                                                                                     // 2429
	return bySet ?                                                                                                      // 2430
		markFunction( superMatcher ) :                                                                                     // 2431
		superMatcher;                                                                                                      // 2432
}                                                                                                                    // 2433
                                                                                                                     // 2434
compile = Sizzle.compile = function( selector, group /* Internal Use Only */ ) {                                     // 2435
	var i,                                                                                                              // 2436
		setMatchers = [],                                                                                                  // 2437
		elementMatchers = [],                                                                                              // 2438
		cached = compilerCache[ selector + " " ];                                                                          // 2439
                                                                                                                     // 2440
	if ( !cached ) {                                                                                                    // 2441
		// Generate a function of recursive functions that can be used to check each element                               // 2442
		if ( !group ) {                                                                                                    // 2443
			group = tokenize( selector );                                                                                     // 2444
		}                                                                                                                  // 2445
		i = group.length;                                                                                                  // 2446
		while ( i-- ) {                                                                                                    // 2447
			cached = matcherFromTokens( group[i] );                                                                           // 2448
			if ( cached[ expando ] ) {                                                                                        // 2449
				setMatchers.push( cached );                                                                                      // 2450
			} else {                                                                                                          // 2451
				elementMatchers.push( cached );                                                                                  // 2452
			}                                                                                                                 // 2453
		}                                                                                                                  // 2454
                                                                                                                     // 2455
		// Cache the compiled function                                                                                     // 2456
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );                      // 2457
	}                                                                                                                   // 2458
	return cached;                                                                                                      // 2459
};                                                                                                                   // 2460
                                                                                                                     // 2461
function multipleContexts( selector, contexts, results ) {                                                           // 2462
	var i = 0,                                                                                                          // 2463
		len = contexts.length;                                                                                             // 2464
	for ( ; i < len; i++ ) {                                                                                            // 2465
		Sizzle( selector, contexts[i], results );                                                                          // 2466
	}                                                                                                                   // 2467
	return results;                                                                                                     // 2468
}                                                                                                                    // 2469
                                                                                                                     // 2470
function select( selector, context, results, seed ) {                                                                // 2471
	var i, tokens, token, type, find,                                                                                   // 2472
		match = tokenize( selector );                                                                                      // 2473
                                                                                                                     // 2474
	if ( !seed ) {                                                                                                      // 2475
		// Try to minimize operations if there is only one group                                                           // 2476
		if ( match.length === 1 ) {                                                                                        // 2477
                                                                                                                     // 2478
			// Take a shortcut and set the context if the root selector is an ID                                              // 2479
			tokens = match[0] = match[0].slice( 0 );                                                                          // 2480
			if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&                                                    // 2481
					support.getById && context.nodeType === 9 && documentIsHTML &&                                                  // 2482
					Expr.relative[ tokens[1].type ] ) {                                                                             // 2483
                                                                                                                     // 2484
				context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];               // 2485
				if ( !context ) {                                                                                                // 2486
					return results;                                                                                                 // 2487
				}                                                                                                                // 2488
				selector = selector.slice( tokens.shift().value.length );                                                        // 2489
			}                                                                                                                 // 2490
                                                                                                                     // 2491
			// Fetch a seed set for right-to-left matching                                                                    // 2492
			i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;                                               // 2493
			while ( i-- ) {                                                                                                   // 2494
				token = tokens[i];                                                                                               // 2495
                                                                                                                     // 2496
				// Abort if we hit a combinator                                                                                  // 2497
				if ( Expr.relative[ (type = token.type) ] ) {                                                                    // 2498
					break;                                                                                                          // 2499
				}                                                                                                                // 2500
				if ( (find = Expr.find[ type ]) ) {                                                                              // 2501
					// Search, expanding context for leading sibling combinators                                                    // 2502
					if ( (seed = find(                                                                                              // 2503
						token.matches[0].replace( runescape, funescape ),                                                              // 2504
						rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context                                // 2505
					)) ) {                                                                                                          // 2506
                                                                                                                     // 2507
						// If seed is empty or no tokens remain, we can return early                                                   // 2508
						tokens.splice( i, 1 );                                                                                         // 2509
						selector = seed.length && toSelector( tokens );                                                                // 2510
						if ( !selector ) {                                                                                             // 2511
							push.apply( results, seed );                                                                                  // 2512
							return results;                                                                                               // 2513
						}                                                                                                              // 2514
                                                                                                                     // 2515
						break;                                                                                                         // 2516
					}                                                                                                               // 2517
				}                                                                                                                // 2518
			}                                                                                                                 // 2519
		}                                                                                                                  // 2520
	}                                                                                                                   // 2521
                                                                                                                     // 2522
	// Compile and execute a filtering function                                                                         // 2523
	// Provide `match` to avoid retokenization if we modified the selector above                                        // 2524
	compile( selector, match )(                                                                                         // 2525
		seed,                                                                                                              // 2526
		context,                                                                                                           // 2527
		!documentIsHTML,                                                                                                   // 2528
		results,                                                                                                           // 2529
		rsibling.test( selector ) && testContext( context.parentNode ) || context                                          // 2530
	);                                                                                                                  // 2531
	return results;                                                                                                     // 2532
}                                                                                                                    // 2533
                                                                                                                     // 2534
// One-time assignments                                                                                              // 2535
                                                                                                                     // 2536
// Sort stability                                                                                                    // 2537
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;                                       // 2538
                                                                                                                     // 2539
// Support: Chrome<14                                                                                                // 2540
// Always assume duplicates if they aren't passed to the comparison function                                         // 2541
support.detectDuplicates = !!hasDuplicate;                                                                           // 2542
                                                                                                                     // 2543
// Initialize against the default document                                                                           // 2544
setDocument();                                                                                                       // 2545
                                                                                                                     // 2546
// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)                                              // 2547
// Detached nodes confoundingly follow *each other*                                                                  // 2548
support.sortDetached = assert(function( div1 ) {                                                                     // 2549
	// Should return 1, but returns 4 (following)                                                                       // 2550
	return div1.compareDocumentPosition( document.createElement("div") ) & 1;                                           // 2551
});                                                                                                                  // 2552
                                                                                                                     // 2553
// Support: IE<8                                                                                                     // 2554
// Prevent attribute/property "interpolation"                                                                        // 2555
// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx                                                  // 2556
if ( !assert(function( div ) {                                                                                       // 2557
	div.innerHTML = "<a href='#'></a>";                                                                                 // 2558
	return div.firstChild.getAttribute("href") === "#" ;                                                                // 2559
}) ) {                                                                                                               // 2560
	addHandle( "type|href|height|width", function( elem, name, isXML ) {                                                // 2561
		if ( !isXML ) {                                                                                                    // 2562
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );                                          // 2563
		}                                                                                                                  // 2564
	});                                                                                                                 // 2565
}                                                                                                                    // 2566
                                                                                                                     // 2567
// Support: IE<9                                                                                                     // 2568
// Use defaultValue in place of getAttribute("value")                                                                // 2569
if ( !support.attributes || !assert(function( div ) {                                                                // 2570
	div.innerHTML = "<input/>";                                                                                         // 2571
	div.firstChild.setAttribute( "value", "" );                                                                         // 2572
	return div.firstChild.getAttribute( "value" ) === "";                                                               // 2573
}) ) {                                                                                                               // 2574
	addHandle( "value", function( elem, name, isXML ) {                                                                 // 2575
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {                                                         // 2576
			return elem.defaultValue;                                                                                         // 2577
		}                                                                                                                  // 2578
	});                                                                                                                 // 2579
}                                                                                                                    // 2580
                                                                                                                     // 2581
// Support: IE<9                                                                                                     // 2582
// Use getAttributeNode to fetch booleans when getAttribute lies                                                     // 2583
if ( !assert(function( div ) {                                                                                       // 2584
	return div.getAttribute("disabled") == null;                                                                        // 2585
}) ) {                                                                                                               // 2586
	addHandle( booleans, function( elem, name, isXML ) {                                                                // 2587
		var val;                                                                                                           // 2588
		if ( !isXML ) {                                                                                                    // 2589
			return elem[ name ] === true ? name.toLowerCase() :                                                               // 2590
					(val = elem.getAttributeNode( name )) && val.specified ?                                                        // 2591
					val.value :                                                                                                     // 2592
				null;                                                                                                            // 2593
		}                                                                                                                  // 2594
	});                                                                                                                 // 2595
}                                                                                                                    // 2596
                                                                                                                     // 2597
return Sizzle;                                                                                                       // 2598
                                                                                                                     // 2599
})( window );                                                                                                        // 2600
                                                                                                                     // 2601
                                                                                                                     // 2602
                                                                                                                     // 2603
jQuery.find = Sizzle;                                                                                                // 2604
jQuery.expr = Sizzle.selectors;                                                                                      // 2605
jQuery.expr[":"] = jQuery.expr.pseudos;                                                                              // 2606
jQuery.unique = Sizzle.uniqueSort;                                                                                   // 2607
jQuery.text = Sizzle.getText;                                                                                        // 2608
jQuery.isXMLDoc = Sizzle.isXML;                                                                                      // 2609
jQuery.contains = Sizzle.contains;                                                                                   // 2610
                                                                                                                     // 2611
                                                                                                                     // 2612
                                                                                                                     // 2613
var rneedsContext = jQuery.expr.match.needsContext;                                                                  // 2614
                                                                                                                     // 2615
var rsingleTag = (/^<(\w+)\s*\/?>(?:<\/\1>|)$/);                                                                     // 2616
                                                                                                                     // 2617
                                                                                                                     // 2618
                                                                                                                     // 2619
var risSimple = /^.[^:#\[\.,]*$/;                                                                                    // 2620
                                                                                                                     // 2621
// Implement the identical functionality for filter and not                                                          // 2622
function winnow( elements, qualifier, not ) {                                                                        // 2623
	if ( jQuery.isFunction( qualifier ) ) {                                                                             // 2624
		return jQuery.grep( elements, function( elem, i ) {                                                                // 2625
			/* jshint -W018 */                                                                                                // 2626
			return !!qualifier.call( elem, i, elem ) !== not;                                                                 // 2627
		});                                                                                                                // 2628
                                                                                                                     // 2629
	}                                                                                                                   // 2630
                                                                                                                     // 2631
	if ( qualifier.nodeType ) {                                                                                         // 2632
		return jQuery.grep( elements, function( elem ) {                                                                   // 2633
			return ( elem === qualifier ) !== not;                                                                            // 2634
		});                                                                                                                // 2635
                                                                                                                     // 2636
	}                                                                                                                   // 2637
                                                                                                                     // 2638
	if ( typeof qualifier === "string" ) {                                                                              // 2639
		if ( risSimple.test( qualifier ) ) {                                                                               // 2640
			return jQuery.filter( qualifier, elements, not );                                                                 // 2641
		}                                                                                                                  // 2642
                                                                                                                     // 2643
		qualifier = jQuery.filter( qualifier, elements );                                                                  // 2644
	}                                                                                                                   // 2645
                                                                                                                     // 2646
	return jQuery.grep( elements, function( elem ) {                                                                    // 2647
		return ( jQuery.inArray( elem, qualifier ) >= 0 ) !== not;                                                         // 2648
	});                                                                                                                 // 2649
}                                                                                                                    // 2650
                                                                                                                     // 2651
jQuery.filter = function( expr, elems, not ) {                                                                       // 2652
	var elem = elems[ 0 ];                                                                                              // 2653
                                                                                                                     // 2654
	if ( not ) {                                                                                                        // 2655
		expr = ":not(" + expr + ")";                                                                                       // 2656
	}                                                                                                                   // 2657
                                                                                                                     // 2658
	return elems.length === 1 && elem.nodeType === 1 ?                                                                  // 2659
		jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :                                                        // 2660
		jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {                                                  // 2661
			return elem.nodeType === 1;                                                                                       // 2662
		}));                                                                                                               // 2663
};                                                                                                                   // 2664
                                                                                                                     // 2665
jQuery.fn.extend({                                                                                                   // 2666
	find: function( selector ) {                                                                                        // 2667
		var i,                                                                                                             // 2668
			ret = [],                                                                                                         // 2669
			self = this,                                                                                                      // 2670
			len = self.length;                                                                                                // 2671
                                                                                                                     // 2672
		if ( typeof selector !== "string" ) {                                                                              // 2673
			return this.pushStack( jQuery( selector ).filter(function() {                                                     // 2674
				for ( i = 0; i < len; i++ ) {                                                                                    // 2675
					if ( jQuery.contains( self[ i ], this ) ) {                                                                     // 2676
						return true;                                                                                                   // 2677
					}                                                                                                               // 2678
				}                                                                                                                // 2679
			}) );                                                                                                             // 2680
		}                                                                                                                  // 2681
                                                                                                                     // 2682
		for ( i = 0; i < len; i++ ) {                                                                                      // 2683
			jQuery.find( selector, self[ i ], ret );                                                                          // 2684
		}                                                                                                                  // 2685
                                                                                                                     // 2686
		// Needed because $( selector, context ) becomes $( context ).find( selector )                                     // 2687
		ret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );                                                      // 2688
		ret.selector = this.selector ? this.selector + " " + selector : selector;                                          // 2689
		return ret;                                                                                                        // 2690
	},                                                                                                                  // 2691
	filter: function( selector ) {                                                                                      // 2692
		return this.pushStack( winnow(this, selector || [], false) );                                                      // 2693
	},                                                                                                                  // 2694
	not: function( selector ) {                                                                                         // 2695
		return this.pushStack( winnow(this, selector || [], true) );                                                       // 2696
	},                                                                                                                  // 2697
	is: function( selector ) {                                                                                          // 2698
		return !!winnow(                                                                                                   // 2699
			this,                                                                                                             // 2700
                                                                                                                     // 2701
			// If this is a positional/relative selector, check membership in the returned set                                // 2702
			// so $("p:first").is("p:last") won't return true for a doc with two "p".                                         // 2703
			typeof selector === "string" && rneedsContext.test( selector ) ?                                                  // 2704
				jQuery( selector ) :                                                                                             // 2705
				selector || [],                                                                                                  // 2706
			false                                                                                                             // 2707
		).length;                                                                                                          // 2708
	}                                                                                                                   // 2709
});                                                                                                                  // 2710
                                                                                                                     // 2711
                                                                                                                     // 2712
// Initialize a jQuery object                                                                                        // 2713
                                                                                                                     // 2714
                                                                                                                     // 2715
// A central reference to the root jQuery(document)                                                                  // 2716
var rootjQuery,                                                                                                      // 2717
                                                                                                                     // 2718
	// Use the correct document accordingly with window argument (sandbox)                                              // 2719
	document = window.document,                                                                                         // 2720
                                                                                                                     // 2721
	// A simple way to check for HTML strings                                                                           // 2722
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)                                                 // 2723
	// Strict HTML recognition (#11290: must start with <)                                                              // 2724
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,                                                                 // 2725
                                                                                                                     // 2726
	init = jQuery.fn.init = function( selector, context ) {                                                             // 2727
		var match, elem;                                                                                                   // 2728
                                                                                                                     // 2729
		// HANDLE: $(""), $(null), $(undefined), $(false)                                                                  // 2730
		if ( !selector ) {                                                                                                 // 2731
			return this;                                                                                                      // 2732
		}                                                                                                                  // 2733
                                                                                                                     // 2734
		// Handle HTML strings                                                                                             // 2735
		if ( typeof selector === "string" ) {                                                                              // 2736
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {     // 2737
				// Assume that strings that start and end with <> are HTML and skip the regex check                              // 2738
				match = [ null, selector, null ];                                                                                // 2739
                                                                                                                     // 2740
			} else {                                                                                                          // 2741
				match = rquickExpr.exec( selector );                                                                             // 2742
			}                                                                                                                 // 2743
                                                                                                                     // 2744
			// Match html or make sure no context is specified for #id                                                        // 2745
			if ( match && (match[1] || !context) ) {                                                                          // 2746
                                                                                                                     // 2747
				// HANDLE: $(html) -> $(array)                                                                                   // 2748
				if ( match[1] ) {                                                                                                // 2749
					context = context instanceof jQuery ? context[0] : context;                                                     // 2750
                                                                                                                     // 2751
					// scripts is true for back-compat                                                                              // 2752
					// Intentionally let the error be thrown if parseHTML is not present                                            // 2753
					jQuery.merge( this, jQuery.parseHTML(                                                                           // 2754
						match[1],                                                                                                      // 2755
						context && context.nodeType ? context.ownerDocument || context : document,                                     // 2756
						true                                                                                                           // 2757
					) );                                                                                                            // 2758
                                                                                                                     // 2759
					// HANDLE: $(html, props)                                                                                       // 2760
					if ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {                                         // 2761
						for ( match in context ) {                                                                                     // 2762
							// Properties of context are called as methods if possible                                                    // 2763
							if ( jQuery.isFunction( this[ match ] ) ) {                                                                   // 2764
								this[ match ]( context[ match ] );                                                                           // 2765
                                                                                                                     // 2766
							// ...and otherwise set as attributes                                                                         // 2767
							} else {                                                                                                      // 2768
								this.attr( match, context[ match ] );                                                                        // 2769
							}                                                                                                             // 2770
						}                                                                                                              // 2771
					}                                                                                                               // 2772
                                                                                                                     // 2773
					return this;                                                                                                    // 2774
                                                                                                                     // 2775
				// HANDLE: $(#id)                                                                                                // 2776
				} else {                                                                                                         // 2777
					elem = document.getElementById( match[2] );                                                                     // 2778
                                                                                                                     // 2779
					// Check parentNode to catch when Blackberry 4.6 returns                                                        // 2780
					// nodes that are no longer in the document #6963                                                               // 2781
					if ( elem && elem.parentNode ) {                                                                                // 2782
						// Handle the case where IE and Opera return items                                                             // 2783
						// by name instead of ID                                                                                       // 2784
						if ( elem.id !== match[2] ) {                                                                                  // 2785
							return rootjQuery.find( selector );                                                                           // 2786
						}                                                                                                              // 2787
                                                                                                                     // 2788
						// Otherwise, we inject the element directly into the jQuery object                                            // 2789
						this.length = 1;                                                                                               // 2790
						this[0] = elem;                                                                                                // 2791
					}                                                                                                               // 2792
                                                                                                                     // 2793
					this.context = document;                                                                                        // 2794
					this.selector = selector;                                                                                       // 2795
					return this;                                                                                                    // 2796
				}                                                                                                                // 2797
                                                                                                                     // 2798
			// HANDLE: $(expr, $(...))                                                                                        // 2799
			} else if ( !context || context.jquery ) {                                                                        // 2800
				return ( context || rootjQuery ).find( selector );                                                               // 2801
                                                                                                                     // 2802
			// HANDLE: $(expr, context)                                                                                       // 2803
			// (which is just equivalent to: $(context).find(expr)                                                            // 2804
			} else {                                                                                                          // 2805
				return this.constructor( context ).find( selector );                                                             // 2806
			}                                                                                                                 // 2807
                                                                                                                     // 2808
		// HANDLE: $(DOMElement)                                                                                           // 2809
		} else if ( selector.nodeType ) {                                                                                  // 2810
			this.context = this[0] = selector;                                                                                // 2811
			this.length = 1;                                                                                                  // 2812
			return this;                                                                                                      // 2813
                                                                                                                     // 2814
		// HANDLE: $(function)                                                                                             // 2815
		// Shortcut for document ready                                                                                     // 2816
		} else if ( jQuery.isFunction( selector ) ) {                                                                      // 2817
			return typeof rootjQuery.ready !== "undefined" ?                                                                  // 2818
				rootjQuery.ready( selector ) :                                                                                   // 2819
				// Execute immediately if ready is not present                                                                   // 2820
				selector( jQuery );                                                                                              // 2821
		}                                                                                                                  // 2822
                                                                                                                     // 2823
		if ( selector.selector !== undefined ) {                                                                           // 2824
			this.selector = selector.selector;                                                                                // 2825
			this.context = selector.context;                                                                                  // 2826
		}                                                                                                                  // 2827
                                                                                                                     // 2828
		return jQuery.makeArray( selector, this );                                                                         // 2829
	};                                                                                                                  // 2830
                                                                                                                     // 2831
// Give the init function the jQuery prototype for later instantiation                                               // 2832
init.prototype = jQuery.fn;                                                                                          // 2833
                                                                                                                     // 2834
// Initialize central reference                                                                                      // 2835
rootjQuery = jQuery( document );                                                                                     // 2836
                                                                                                                     // 2837
                                                                                                                     // 2838
var rparentsprev = /^(?:parents|prev(?:Until|All))/,                                                                 // 2839
	// methods guaranteed to produce a unique set when starting from a unique set                                       // 2840
	guaranteedUnique = {                                                                                                // 2841
		children: true,                                                                                                    // 2842
		contents: true,                                                                                                    // 2843
		next: true,                                                                                                        // 2844
		prev: true                                                                                                         // 2845
	};                                                                                                                  // 2846
                                                                                                                     // 2847
jQuery.extend({                                                                                                      // 2848
	dir: function( elem, dir, until ) {                                                                                 // 2849
		var matched = [],                                                                                                  // 2850
			cur = elem[ dir ];                                                                                                // 2851
                                                                                                                     // 2852
		while ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) { // 2853
			if ( cur.nodeType === 1 ) {                                                                                       // 2854
				matched.push( cur );                                                                                             // 2855
			}                                                                                                                 // 2856
			cur = cur[dir];                                                                                                   // 2857
		}                                                                                                                  // 2858
		return matched;                                                                                                    // 2859
	},                                                                                                                  // 2860
                                                                                                                     // 2861
	sibling: function( n, elem ) {                                                                                      // 2862
		var r = [];                                                                                                        // 2863
                                                                                                                     // 2864
		for ( ; n; n = n.nextSibling ) {                                                                                   // 2865
			if ( n.nodeType === 1 && n !== elem ) {                                                                           // 2866
				r.push( n );                                                                                                     // 2867
			}                                                                                                                 // 2868
		}                                                                                                                  // 2869
                                                                                                                     // 2870
		return r;                                                                                                          // 2871
	}                                                                                                                   // 2872
});                                                                                                                  // 2873
                                                                                                                     // 2874
jQuery.fn.extend({                                                                                                   // 2875
	has: function( target ) {                                                                                           // 2876
		var i,                                                                                                             // 2877
			targets = jQuery( target, this ),                                                                                 // 2878
			len = targets.length;                                                                                             // 2879
                                                                                                                     // 2880
		return this.filter(function() {                                                                                    // 2881
			for ( i = 0; i < len; i++ ) {                                                                                     // 2882
				if ( jQuery.contains( this, targets[i] ) ) {                                                                     // 2883
					return true;                                                                                                    // 2884
				}                                                                                                                // 2885
			}                                                                                                                 // 2886
		});                                                                                                                // 2887
	},                                                                                                                  // 2888
                                                                                                                     // 2889
	closest: function( selectors, context ) {                                                                           // 2890
		var cur,                                                                                                           // 2891
			i = 0,                                                                                                            // 2892
			l = this.length,                                                                                                  // 2893
			matched = [],                                                                                                     // 2894
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?                                          // 2895
				jQuery( selectors, context || this.context ) :                                                                   // 2896
				0;                                                                                                               // 2897
                                                                                                                     // 2898
		for ( ; i < l; i++ ) {                                                                                             // 2899
			for ( cur = this[i]; cur && cur !== context; cur = cur.parentNode ) {                                             // 2900
				// Always skip document fragments                                                                                // 2901
				if ( cur.nodeType < 11 && (pos ?                                                                                 // 2902
					pos.index(cur) > -1 :                                                                                           // 2903
                                                                                                                     // 2904
					// Don't pass non-elements to Sizzle                                                                            // 2905
					cur.nodeType === 1 &&                                                                                           // 2906
						jQuery.find.matchesSelector(cur, selectors)) ) {                                                               // 2907
                                                                                                                     // 2908
					matched.push( cur );                                                                                            // 2909
					break;                                                                                                          // 2910
				}                                                                                                                // 2911
			}                                                                                                                 // 2912
		}                                                                                                                  // 2913
                                                                                                                     // 2914
		return this.pushStack( matched.length > 1 ? jQuery.unique( matched ) : matched );                                  // 2915
	},                                                                                                                  // 2916
                                                                                                                     // 2917
	// Determine the position of an element within                                                                      // 2918
	// the matched set of elements                                                                                      // 2919
	index: function( elem ) {                                                                                           // 2920
                                                                                                                     // 2921
		// No argument, return index in parent                                                                             // 2922
		if ( !elem ) {                                                                                                     // 2923
			return ( this[0] && this[0].parentNode ) ? this.first().prevAll().length : -1;                                    // 2924
		}                                                                                                                  // 2925
                                                                                                                     // 2926
		// index in selector                                                                                               // 2927
		if ( typeof elem === "string" ) {                                                                                  // 2928
			return jQuery.inArray( this[0], jQuery( elem ) );                                                                 // 2929
		}                                                                                                                  // 2930
                                                                                                                     // 2931
		// Locate the position of the desired element                                                                      // 2932
		return jQuery.inArray(                                                                                             // 2933
			// If it receives a jQuery object, the first element is used                                                      // 2934
			elem.jquery ? elem[0] : elem, this );                                                                             // 2935
	},                                                                                                                  // 2936
                                                                                                                     // 2937
	add: function( selector, context ) {                                                                                // 2938
		return this.pushStack(                                                                                             // 2939
			jQuery.unique(                                                                                                    // 2940
				jQuery.merge( this.get(), jQuery( selector, context ) )                                                          // 2941
			)                                                                                                                 // 2942
		);                                                                                                                 // 2943
	},                                                                                                                  // 2944
                                                                                                                     // 2945
	addBack: function( selector ) {                                                                                     // 2946
		return this.add( selector == null ?                                                                                // 2947
			this.prevObject : this.prevObject.filter(selector)                                                                // 2948
		);                                                                                                                 // 2949
	}                                                                                                                   // 2950
});                                                                                                                  // 2951
                                                                                                                     // 2952
function sibling( cur, dir ) {                                                                                       // 2953
	do {                                                                                                                // 2954
		cur = cur[ dir ];                                                                                                  // 2955
	} while ( cur && cur.nodeType !== 1 );                                                                              // 2956
                                                                                                                     // 2957
	return cur;                                                                                                         // 2958
}                                                                                                                    // 2959
                                                                                                                     // 2960
jQuery.each({                                                                                                        // 2961
	parent: function( elem ) {                                                                                          // 2962
		var parent = elem.parentNode;                                                                                      // 2963
		return parent && parent.nodeType !== 11 ? parent : null;                                                           // 2964
	},                                                                                                                  // 2965
	parents: function( elem ) {                                                                                         // 2966
		return jQuery.dir( elem, "parentNode" );                                                                           // 2967
	},                                                                                                                  // 2968
	parentsUntil: function( elem, i, until ) {                                                                          // 2969
		return jQuery.dir( elem, "parentNode", until );                                                                    // 2970
	},                                                                                                                  // 2971
	next: function( elem ) {                                                                                            // 2972
		return sibling( elem, "nextSibling" );                                                                             // 2973
	},                                                                                                                  // 2974
	prev: function( elem ) {                                                                                            // 2975
		return sibling( elem, "previousSibling" );                                                                         // 2976
	},                                                                                                                  // 2977
	nextAll: function( elem ) {                                                                                         // 2978
		return jQuery.dir( elem, "nextSibling" );                                                                          // 2979
	},                                                                                                                  // 2980
	prevAll: function( elem ) {                                                                                         // 2981
		return jQuery.dir( elem, "previousSibling" );                                                                      // 2982
	},                                                                                                                  // 2983
	nextUntil: function( elem, i, until ) {                                                                             // 2984
		return jQuery.dir( elem, "nextSibling", until );                                                                   // 2985
	},                                                                                                                  // 2986
	prevUntil: function( elem, i, until ) {                                                                             // 2987
		return jQuery.dir( elem, "previousSibling", until );                                                               // 2988
	},                                                                                                                  // 2989
	siblings: function( elem ) {                                                                                        // 2990
		return jQuery.sibling( ( elem.parentNode || {} ).firstChild, elem );                                               // 2991
	},                                                                                                                  // 2992
	children: function( elem ) {                                                                                        // 2993
		return jQuery.sibling( elem.firstChild );                                                                          // 2994
	},                                                                                                                  // 2995
	contents: function( elem ) {                                                                                        // 2996
		return jQuery.nodeName( elem, "iframe" ) ?                                                                         // 2997
			elem.contentDocument || elem.contentWindow.document :                                                             // 2998
			jQuery.merge( [], elem.childNodes );                                                                              // 2999
	}                                                                                                                   // 3000
}, function( name, fn ) {                                                                                            // 3001
	jQuery.fn[ name ] = function( until, selector ) {                                                                   // 3002
		var ret = jQuery.map( this, fn, until );                                                                           // 3003
                                                                                                                     // 3004
		if ( name.slice( -5 ) !== "Until" ) {                                                                              // 3005
			selector = until;                                                                                                 // 3006
		}                                                                                                                  // 3007
                                                                                                                     // 3008
		if ( selector && typeof selector === "string" ) {                                                                  // 3009
			ret = jQuery.filter( selector, ret );                                                                             // 3010
		}                                                                                                                  // 3011
                                                                                                                     // 3012
		if ( this.length > 1 ) {                                                                                           // 3013
			// Remove duplicates                                                                                              // 3014
			if ( !guaranteedUnique[ name ] ) {                                                                                // 3015
				ret = jQuery.unique( ret );                                                                                      // 3016
			}                                                                                                                 // 3017
                                                                                                                     // 3018
			// Reverse order for parents* and prev-derivatives                                                                // 3019
			if ( rparentsprev.test( name ) ) {                                                                                // 3020
				ret = ret.reverse();                                                                                             // 3021
			}                                                                                                                 // 3022
		}                                                                                                                  // 3023
                                                                                                                     // 3024
		return this.pushStack( ret );                                                                                      // 3025
	};                                                                                                                  // 3026
});                                                                                                                  // 3027
var rnotwhite = (/\S+/g);                                                                                            // 3028
                                                                                                                     // 3029
                                                                                                                     // 3030
                                                                                                                     // 3031
// String to Object options format cache                                                                             // 3032
var optionsCache = {};                                                                                               // 3033
                                                                                                                     // 3034
// Convert String-formatted options into Object-formatted ones and store in cache                                    // 3035
function createOptions( options ) {                                                                                  // 3036
	var object = optionsCache[ options ] = {};                                                                          // 3037
	jQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {                                                // 3038
		object[ flag ] = true;                                                                                             // 3039
	});                                                                                                                 // 3040
	return object;                                                                                                      // 3041
}                                                                                                                    // 3042
                                                                                                                     // 3043
/*                                                                                                                   // 3044
 * Create a callback list using the following parameters:                                                            // 3045
 *                                                                                                                   // 3046
 *	options: an optional list of space-separated options that will change how                                         // 3047
 *			the callback list behaves or a more traditional option object                                                   // 3048
 *                                                                                                                   // 3049
 * By default a callback list will act like an event callback list and can be                                        // 3050
 * "fired" multiple times.                                                                                           // 3051
 *                                                                                                                   // 3052
 * Possible options:                                                                                                 // 3053
 *                                                                                                                   // 3054
 *	once:			will ensure the callback list can only be fired once (like a Deferred)                                    // 3055
 *                                                                                                                   // 3056
 *	memory:			will keep track of previous values and will call any callback added                                     // 3057
 *					after the list has been fired right away with the latest "memorized"                                          // 3058
 *					values (like a Deferred)                                                                                      // 3059
 *                                                                                                                   // 3060
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)                                // 3061
 *                                                                                                                   // 3062
 *	stopOnFalse:	interrupt callings when a callback returns false                                                     // 3063
 *                                                                                                                   // 3064
 */                                                                                                                  // 3065
jQuery.Callbacks = function( options ) {                                                                             // 3066
                                                                                                                     // 3067
	// Convert options from String-formatted to Object-formatted if needed                                              // 3068
	// (we check in cache first)                                                                                        // 3069
	options = typeof options === "string" ?                                                                             // 3070
		( optionsCache[ options ] || createOptions( options ) ) :                                                          // 3071
		jQuery.extend( {}, options );                                                                                      // 3072
                                                                                                                     // 3073
	var // Flag to know if list is currently firing                                                                     // 3074
		firing,                                                                                                            // 3075
		// Last fire value (for non-forgettable lists)                                                                     // 3076
		memory,                                                                                                            // 3077
		// Flag to know if list was already fired                                                                          // 3078
		fired,                                                                                                             // 3079
		// End of the loop when firing                                                                                     // 3080
		firingLength,                                                                                                      // 3081
		// Index of currently firing callback (modified by remove if needed)                                               // 3082
		firingIndex,                                                                                                       // 3083
		// First callback to fire (used internally by add and fireWith)                                                    // 3084
		firingStart,                                                                                                       // 3085
		// Actual callback list                                                                                            // 3086
		list = [],                                                                                                         // 3087
		// Stack of fire calls for repeatable lists                                                                        // 3088
		stack = !options.once && [],                                                                                       // 3089
		// Fire callbacks                                                                                                  // 3090
		fire = function( data ) {                                                                                          // 3091
			memory = options.memory && data;                                                                                  // 3092
			fired = true;                                                                                                     // 3093
			firingIndex = firingStart || 0;                                                                                   // 3094
			firingStart = 0;                                                                                                  // 3095
			firingLength = list.length;                                                                                       // 3096
			firing = true;                                                                                                    // 3097
			for ( ; list && firingIndex < firingLength; firingIndex++ ) {                                                     // 3098
				if ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {                      // 3099
					memory = false; // To prevent further calls using add                                                           // 3100
					break;                                                                                                          // 3101
				}                                                                                                                // 3102
			}                                                                                                                 // 3103
			firing = false;                                                                                                   // 3104
			if ( list ) {                                                                                                     // 3105
				if ( stack ) {                                                                                                   // 3106
					if ( stack.length ) {                                                                                           // 3107
						fire( stack.shift() );                                                                                         // 3108
					}                                                                                                               // 3109
				} else if ( memory ) {                                                                                           // 3110
					list = [];                                                                                                      // 3111
				} else {                                                                                                         // 3112
					self.disable();                                                                                                 // 3113
				}                                                                                                                // 3114
			}                                                                                                                 // 3115
		},                                                                                                                 // 3116
		// Actual Callbacks object                                                                                         // 3117
		self = {                                                                                                           // 3118
			// Add a callback or a collection of callbacks to the list                                                        // 3119
			add: function() {                                                                                                 // 3120
				if ( list ) {                                                                                                    // 3121
					// First, we save the current length                                                                            // 3122
					var start = list.length;                                                                                        // 3123
					(function add( args ) {                                                                                         // 3124
						jQuery.each( args, function( _, arg ) {                                                                        // 3125
							var type = jQuery.type( arg );                                                                                // 3126
							if ( type === "function" ) {                                                                                  // 3127
								if ( !options.unique || !self.has( arg ) ) {                                                                 // 3128
									list.push( arg );                                                                                           // 3129
								}                                                                                                            // 3130
							} else if ( arg && arg.length && type !== "string" ) {                                                        // 3131
								// Inspect recursively                                                                                       // 3132
								add( arg );                                                                                                  // 3133
							}                                                                                                             // 3134
						});                                                                                                            // 3135
					})( arguments );                                                                                                // 3136
					// Do we need to add the callbacks to the                                                                       // 3137
					// current firing batch?                                                                                        // 3138
					if ( firing ) {                                                                                                 // 3139
						firingLength = list.length;                                                                                    // 3140
					// With memory, if we're not firing then                                                                        // 3141
					// we should call right away                                                                                    // 3142
					} else if ( memory ) {                                                                                          // 3143
						firingStart = start;                                                                                           // 3144
						fire( memory );                                                                                                // 3145
					}                                                                                                               // 3146
				}                                                                                                                // 3147
				return this;                                                                                                     // 3148
			},                                                                                                                // 3149
			// Remove a callback from the list                                                                                // 3150
			remove: function() {                                                                                              // 3151
				if ( list ) {                                                                                                    // 3152
					jQuery.each( arguments, function( _, arg ) {                                                                    // 3153
						var index;                                                                                                     // 3154
						while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {                                                // 3155
							list.splice( index, 1 );                                                                                      // 3156
							// Handle firing indexes                                                                                      // 3157
							if ( firing ) {                                                                                               // 3158
								if ( index <= firingLength ) {                                                                               // 3159
									firingLength--;                                                                                             // 3160
								}                                                                                                            // 3161
								if ( index <= firingIndex ) {                                                                                // 3162
									firingIndex--;                                                                                              // 3163
								}                                                                                                            // 3164
							}                                                                                                             // 3165
						}                                                                                                              // 3166
					});                                                                                                             // 3167
				}                                                                                                                // 3168
				return this;                                                                                                     // 3169
			},                                                                                                                // 3170
			// Check if a given callback is in the list.                                                                      // 3171
			// If no argument is given, return whether or not list has callbacks attached.                                    // 3172
			has: function( fn ) {                                                                                             // 3173
				return fn ? jQuery.inArray( fn, list ) > -1 : !!( list && list.length );                                         // 3174
			},                                                                                                                // 3175
			// Remove all callbacks from the list                                                                             // 3176
			empty: function() {                                                                                               // 3177
				list = [];                                                                                                       // 3178
				firingLength = 0;                                                                                                // 3179
				return this;                                                                                                     // 3180
			},                                                                                                                // 3181
			// Have the list do nothing anymore                                                                               // 3182
			disable: function() {                                                                                             // 3183
				list = stack = memory = undefined;                                                                               // 3184
				return this;                                                                                                     // 3185
			},                                                                                                                // 3186
			// Is it disabled?                                                                                                // 3187
			disabled: function() {                                                                                            // 3188
				return !list;                                                                                                    // 3189
			},                                                                                                                // 3190
			// Lock the list in its current state                                                                             // 3191
			lock: function() {                                                                                                // 3192
				stack = undefined;                                                                                               // 3193
				if ( !memory ) {                                                                                                 // 3194
					self.disable();                                                                                                 // 3195
				}                                                                                                                // 3196
				return this;                                                                                                     // 3197
			},                                                                                                                // 3198
			// Is it locked?                                                                                                  // 3199
			locked: function() {                                                                                              // 3200
				return !stack;                                                                                                   // 3201
			},                                                                                                                // 3202
			// Call all callbacks with the given context and arguments                                                        // 3203
			fireWith: function( context, args ) {                                                                             // 3204
				if ( list && ( !fired || stack ) ) {                                                                             // 3205
					args = args || [];                                                                                              // 3206
					args = [ context, args.slice ? args.slice() : args ];                                                           // 3207
					if ( firing ) {                                                                                                 // 3208
						stack.push( args );                                                                                            // 3209
					} else {                                                                                                        // 3210
						fire( args );                                                                                                  // 3211
					}                                                                                                               // 3212
				}                                                                                                                // 3213
				return this;                                                                                                     // 3214
			},                                                                                                                // 3215
			// Call all the callbacks with the given arguments                                                                // 3216
			fire: function() {                                                                                                // 3217
				self.fireWith( this, arguments );                                                                                // 3218
				return this;                                                                                                     // 3219
			},                                                                                                                // 3220
			// To know if the callbacks have already been called at least once                                                // 3221
			fired: function() {                                                                                               // 3222
				return !!fired;                                                                                                  // 3223
			}                                                                                                                 // 3224
		};                                                                                                                 // 3225
                                                                                                                     // 3226
	return self;                                                                                                        // 3227
};                                                                                                                   // 3228
                                                                                                                     // 3229
                                                                                                                     // 3230
jQuery.extend({                                                                                                      // 3231
                                                                                                                     // 3232
	Deferred: function( func ) {                                                                                        // 3233
		var tuples = [                                                                                                     // 3234
				// action, add listener, listener list, final state                                                              // 3235
				[ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ],                                              // 3236
				[ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ],                                               // 3237
				[ "notify", "progress", jQuery.Callbacks("memory") ]                                                             // 3238
			],                                                                                                                // 3239
			state = "pending",                                                                                                // 3240
			promise = {                                                                                                       // 3241
				state: function() {                                                                                              // 3242
					return state;                                                                                                   // 3243
				},                                                                                                               // 3244
				always: function() {                                                                                             // 3245
					deferred.done( arguments ).fail( arguments );                                                                   // 3246
					return this;                                                                                                    // 3247
				},                                                                                                               // 3248
				then: function( /* fnDone, fnFail, fnProgress */ ) {                                                             // 3249
					var fns = arguments;                                                                                            // 3250
					return jQuery.Deferred(function( newDefer ) {                                                                   // 3251
						jQuery.each( tuples, function( i, tuple ) {                                                                    // 3252
							var fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];                                                           // 3253
							// deferred[ done | fail | progress ] for forwarding actions to newDefer                                      // 3254
							deferred[ tuple[1] ](function() {                                                                             // 3255
								var returned = fn && fn.apply( this, arguments );                                                            // 3256
								if ( returned && jQuery.isFunction( returned.promise ) ) {                                                   // 3257
									returned.promise()                                                                                          // 3258
										.done( newDefer.resolve )                                                                                  // 3259
										.fail( newDefer.reject )                                                                                   // 3260
										.progress( newDefer.notify );                                                                              // 3261
								} else {                                                                                                     // 3262
									newDefer[ tuple[ 0 ] + "With" ]( this === promise ? newDefer.promise() : this, fn ? [ returned ] : arguments );
								}                                                                                                            // 3264
							});                                                                                                           // 3265
						});                                                                                                            // 3266
						fns = null;                                                                                                    // 3267
					}).promise();                                                                                                   // 3268
				},                                                                                                               // 3269
				// Get a promise for this deferred                                                                               // 3270
				// If obj is provided, the promise aspect is added to the object                                                 // 3271
				promise: function( obj ) {                                                                                       // 3272
					return obj != null ? jQuery.extend( obj, promise ) : promise;                                                   // 3273
				}                                                                                                                // 3274
			},                                                                                                                // 3275
			deferred = {};                                                                                                    // 3276
                                                                                                                     // 3277
		// Keep pipe for back-compat                                                                                       // 3278
		promise.pipe = promise.then;                                                                                       // 3279
                                                                                                                     // 3280
		// Add list-specific methods                                                                                       // 3281
		jQuery.each( tuples, function( i, tuple ) {                                                                        // 3282
			var list = tuple[ 2 ],                                                                                            // 3283
				stateString = tuple[ 3 ];                                                                                        // 3284
                                                                                                                     // 3285
			// promise[ done | fail | progress ] = list.add                                                                   // 3286
			promise[ tuple[1] ] = list.add;                                                                                   // 3287
                                                                                                                     // 3288
			// Handle state                                                                                                   // 3289
			if ( stateString ) {                                                                                              // 3290
				list.add(function() {                                                                                            // 3291
					// state = [ resolved | rejected ]                                                                              // 3292
					state = stateString;                                                                                            // 3293
                                                                                                                     // 3294
				// [ reject_list | resolve_list ].disable; progress_list.lock                                                    // 3295
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );                                                        // 3296
			}                                                                                                                 // 3297
                                                                                                                     // 3298
			// deferred[ resolve | reject | notify ]                                                                          // 3299
			deferred[ tuple[0] ] = function() {                                                                               // 3300
				deferred[ tuple[0] + "With" ]( this === deferred ? promise : this, arguments );                                  // 3301
				return this;                                                                                                     // 3302
			};                                                                                                                // 3303
			deferred[ tuple[0] + "With" ] = list.fireWith;                                                                    // 3304
		});                                                                                                                // 3305
                                                                                                                     // 3306
		// Make the deferred a promise                                                                                     // 3307
		promise.promise( deferred );                                                                                       // 3308
                                                                                                                     // 3309
		// Call given func if any                                                                                          // 3310
		if ( func ) {                                                                                                      // 3311
			func.call( deferred, deferred );                                                                                  // 3312
		}                                                                                                                  // 3313
                                                                                                                     // 3314
		// All done!                                                                                                       // 3315
		return deferred;                                                                                                   // 3316
	},                                                                                                                  // 3317
                                                                                                                     // 3318
	// Deferred helper                                                                                                  // 3319
	when: function( subordinate /* , ..., subordinateN */ ) {                                                           // 3320
		var i = 0,                                                                                                         // 3321
			resolveValues = slice.call( arguments ),                                                                          // 3322
			length = resolveValues.length,                                                                                    // 3323
                                                                                                                     // 3324
			// the count of uncompleted subordinates                                                                          // 3325
			remaining = length !== 1 || ( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,             // 3326
                                                                                                                     // 3327
			// the master Deferred. If resolveValues consist of only a single Deferred, just use that.                        // 3328
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),                                                     // 3329
                                                                                                                     // 3330
			// Update function for both resolve and progress values                                                           // 3331
			updateFunc = function( i, contexts, values ) {                                                                    // 3332
				return function( value ) {                                                                                       // 3333
					contexts[ i ] = this;                                                                                           // 3334
					values[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;                                           // 3335
					if ( values === progressValues ) {                                                                              // 3336
						deferred.notifyWith( contexts, values );                                                                       // 3337
                                                                                                                     // 3338
					} else if ( !(--remaining) ) {                                                                                  // 3339
						deferred.resolveWith( contexts, values );                                                                      // 3340
					}                                                                                                               // 3341
				};                                                                                                               // 3342
			},                                                                                                                // 3343
                                                                                                                     // 3344
			progressValues, progressContexts, resolveContexts;                                                                // 3345
                                                                                                                     // 3346
		// add listeners to Deferred subordinates; treat others as resolved                                                // 3347
		if ( length > 1 ) {                                                                                                // 3348
			progressValues = new Array( length );                                                                             // 3349
			progressContexts = new Array( length );                                                                           // 3350
			resolveContexts = new Array( length );                                                                            // 3351
			for ( ; i < length; i++ ) {                                                                                       // 3352
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {                                   // 3353
					resolveValues[ i ].promise()                                                                                    // 3354
						.done( updateFunc( i, resolveContexts, resolveValues ) )                                                       // 3355
						.fail( deferred.reject )                                                                                       // 3356
						.progress( updateFunc( i, progressContexts, progressValues ) );                                                // 3357
				} else {                                                                                                         // 3358
					--remaining;                                                                                                    // 3359
				}                                                                                                                // 3360
			}                                                                                                                 // 3361
		}                                                                                                                  // 3362
                                                                                                                     // 3363
		// if we're not waiting on anything, resolve the master                                                            // 3364
		if ( !remaining ) {                                                                                                // 3365
			deferred.resolveWith( resolveContexts, resolveValues );                                                           // 3366
		}                                                                                                                  // 3367
                                                                                                                     // 3368
		return deferred.promise();                                                                                         // 3369
	}                                                                                                                   // 3370
});                                                                                                                  // 3371
                                                                                                                     // 3372
                                                                                                                     // 3373
// The deferred used on DOM ready                                                                                    // 3374
var readyList;                                                                                                       // 3375
                                                                                                                     // 3376
jQuery.fn.ready = function( fn ) {                                                                                   // 3377
	// Add the callback                                                                                                 // 3378
	jQuery.ready.promise().done( fn );                                                                                  // 3379
                                                                                                                     // 3380
	return this;                                                                                                        // 3381
};                                                                                                                   // 3382
                                                                                                                     // 3383
jQuery.extend({                                                                                                      // 3384
	// Is the DOM ready to be used? Set to true once it occurs.                                                         // 3385
	isReady: false,                                                                                                     // 3386
                                                                                                                     // 3387
	// A counter to track how many items to wait for before                                                             // 3388
	// the ready event fires. See #6781                                                                                 // 3389
	readyWait: 1,                                                                                                       // 3390
                                                                                                                     // 3391
	// Hold (or release) the ready event                                                                                // 3392
	holdReady: function( hold ) {                                                                                       // 3393
		if ( hold ) {                                                                                                      // 3394
			jQuery.readyWait++;                                                                                               // 3395
		} else {                                                                                                           // 3396
			jQuery.ready( true );                                                                                             // 3397
		}                                                                                                                  // 3398
	},                                                                                                                  // 3399
                                                                                                                     // 3400
	// Handle when the DOM is ready                                                                                     // 3401
	ready: function( wait ) {                                                                                           // 3402
                                                                                                                     // 3403
		// Abort if there are pending holds or we're already ready                                                         // 3404
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {                                                       // 3405
			return;                                                                                                           // 3406
		}                                                                                                                  // 3407
                                                                                                                     // 3408
		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).                           // 3409
		if ( !document.body ) {                                                                                            // 3410
			return setTimeout( jQuery.ready );                                                                                // 3411
		}                                                                                                                  // 3412
                                                                                                                     // 3413
		// Remember that the DOM is ready                                                                                  // 3414
		jQuery.isReady = true;                                                                                             // 3415
                                                                                                                     // 3416
		// If a normal DOM Ready event fired, decrement, and wait if need be                                               // 3417
		if ( wait !== true && --jQuery.readyWait > 0 ) {                                                                   // 3418
			return;                                                                                                           // 3419
		}                                                                                                                  // 3420
                                                                                                                     // 3421
		// If there are functions bound, to execute                                                                        // 3422
		readyList.resolveWith( document, [ jQuery ] );                                                                     // 3423
                                                                                                                     // 3424
		// Trigger any bound ready events                                                                                  // 3425
		if ( jQuery.fn.trigger ) {                                                                                         // 3426
			jQuery( document ).trigger("ready").off("ready");                                                                 // 3427
		}                                                                                                                  // 3428
	}                                                                                                                   // 3429
});                                                                                                                  // 3430
                                                                                                                     // 3431
/**                                                                                                                  // 3432
 * Clean-up method for dom ready events                                                                              // 3433
 */                                                                                                                  // 3434
function detach() {                                                                                                  // 3435
	if ( document.addEventListener ) {                                                                                  // 3436
		document.removeEventListener( "DOMContentLoaded", completed, false );                                              // 3437
		window.removeEventListener( "load", completed, false );                                                            // 3438
                                                                                                                     // 3439
	} else {                                                                                                            // 3440
		document.detachEvent( "onreadystatechange", completed );                                                           // 3441
		window.detachEvent( "onload", completed );                                                                         // 3442
	}                                                                                                                   // 3443
}                                                                                                                    // 3444
                                                                                                                     // 3445
/**                                                                                                                  // 3446
 * The ready event handler and self cleanup method                                                                   // 3447
 */                                                                                                                  // 3448
function completed() {                                                                                               // 3449
	// readyState === "complete" is good enough for us to call the dom ready in oldIE                                   // 3450
	if ( document.addEventListener || event.type === "load" || document.readyState === "complete" ) {                   // 3451
		detach();                                                                                                          // 3452
		jQuery.ready();                                                                                                    // 3453
	}                                                                                                                   // 3454
}                                                                                                                    // 3455
                                                                                                                     // 3456
jQuery.ready.promise = function( obj ) {                                                                             // 3457
	if ( !readyList ) {                                                                                                 // 3458
                                                                                                                     // 3459
		readyList = jQuery.Deferred();                                                                                     // 3460
                                                                                                                     // 3461
		// Catch cases where $(document).ready() is called after the browser event has already occurred.                   // 3462
		// we once tried to use readyState "interactive" here, but it caused issues like the one                           // 3463
		// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15                                       // 3464
		if ( document.readyState === "complete" ) {                                                                        // 3465
			// Handle it asynchronously to allow scripts the opportunity to delay ready                                       // 3466
			setTimeout( jQuery.ready );                                                                                       // 3467
                                                                                                                     // 3468
		// Standards-based browsers support DOMContentLoaded                                                               // 3469
		} else if ( document.addEventListener ) {                                                                          // 3470
			// Use the handy event callback                                                                                   // 3471
			document.addEventListener( "DOMContentLoaded", completed, false );                                                // 3472
                                                                                                                     // 3473
			// A fallback to window.onload, that will always work                                                             // 3474
			window.addEventListener( "load", completed, false );                                                              // 3475
                                                                                                                     // 3476
		// If IE event model is used                                                                                       // 3477
		} else {                                                                                                           // 3478
			// Ensure firing before onload, maybe late but safe also for iframes                                              // 3479
			document.attachEvent( "onreadystatechange", completed );                                                          // 3480
                                                                                                                     // 3481
			// A fallback to window.onload, that will always work                                                             // 3482
			window.attachEvent( "onload", completed );                                                                        // 3483
                                                                                                                     // 3484
			// If IE and not a frame                                                                                          // 3485
			// continually check to see if the document is ready                                                              // 3486
			var top = false;                                                                                                  // 3487
                                                                                                                     // 3488
			try {                                                                                                             // 3489
				top = window.frameElement == null && document.documentElement;                                                   // 3490
			} catch(e) {}                                                                                                     // 3491
                                                                                                                     // 3492
			if ( top && top.doScroll ) {                                                                                      // 3493
				(function doScrollCheck() {                                                                                      // 3494
					if ( !jQuery.isReady ) {                                                                                        // 3495
                                                                                                                     // 3496
						try {                                                                                                          // 3497
							// Use the trick by Diego Perini                                                                              // 3498
							// http://javascript.nwbox.com/IEContentLoaded/                                                               // 3499
							top.doScroll("left");                                                                                         // 3500
						} catch(e) {                                                                                                   // 3501
							return setTimeout( doScrollCheck, 50 );                                                                       // 3502
						}                                                                                                              // 3503
                                                                                                                     // 3504
						// detach all dom ready events                                                                                 // 3505
						detach();                                                                                                      // 3506
                                                                                                                     // 3507
						// and execute any waiting functions                                                                           // 3508
						jQuery.ready();                                                                                                // 3509
					}                                                                                                               // 3510
				})();                                                                                                            // 3511
			}                                                                                                                 // 3512
		}                                                                                                                  // 3513
	}                                                                                                                   // 3514
	return readyList.promise( obj );                                                                                    // 3515
};                                                                                                                   // 3516
                                                                                                                     // 3517
                                                                                                                     // 3518
var strundefined = typeof undefined;                                                                                 // 3519
                                                                                                                     // 3520
                                                                                                                     // 3521
                                                                                                                     // 3522
// Support: IE<9                                                                                                     // 3523
// Iteration over object's inherited properties before its own                                                       // 3524
var i;                                                                                                               // 3525
for ( i in jQuery( support ) ) {                                                                                     // 3526
	break;                                                                                                              // 3527
}                                                                                                                    // 3528
support.ownLast = i !== "0";                                                                                         // 3529
                                                                                                                     // 3530
// Note: most support tests are defined in their respective modules.                                                 // 3531
// false until the test is run                                                                                       // 3532
support.inlineBlockNeedsLayout = false;                                                                              // 3533
                                                                                                                     // 3534
jQuery(function() {                                                                                                  // 3535
	// We need to execute this one support test ASAP because we need to know                                            // 3536
	// if body.style.zoom needs to be set.                                                                              // 3537
                                                                                                                     // 3538
	var container, div,                                                                                                 // 3539
		body = document.getElementsByTagName("body")[0];                                                                   // 3540
                                                                                                                     // 3541
	if ( !body ) {                                                                                                      // 3542
		// Return for frameset docs that don't have a body                                                                 // 3543
		return;                                                                                                            // 3544
	}                                                                                                                   // 3545
                                                                                                                     // 3546
	// Setup                                                                                                            // 3547
	container = document.createElement( "div" );                                                                        // 3548
	container.style.cssText = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px";          // 3549
                                                                                                                     // 3550
	div = document.createElement( "div" );                                                                              // 3551
	body.appendChild( container ).appendChild( div );                                                                   // 3552
                                                                                                                     // 3553
	if ( typeof div.style.zoom !== strundefined ) {                                                                     // 3554
		// Support: IE<8                                                                                                   // 3555
		// Check if natively block-level elements act like inline-block                                                    // 3556
		// elements when setting their display to 'inline' and giving                                                      // 3557
		// them layout                                                                                                     // 3558
		div.style.cssText = "border:0;margin:0;width:1px;padding:1px;display:inline;zoom:1";                               // 3559
                                                                                                                     // 3560
		if ( (support.inlineBlockNeedsLayout = ( div.offsetWidth === 3 )) ) {                                              // 3561
			// Prevent IE 6 from affecting layout for positioned elements #11048                                              // 3562
			// Prevent IE from shrinking the body in IE 7 mode #12869                                                         // 3563
			// Support: IE<8                                                                                                  // 3564
			body.style.zoom = 1;                                                                                              // 3565
		}                                                                                                                  // 3566
	}                                                                                                                   // 3567
                                                                                                                     // 3568
	body.removeChild( container );                                                                                      // 3569
                                                                                                                     // 3570
	// Null elements to avoid leaks in IE                                                                               // 3571
	container = div = null;                                                                                             // 3572
});                                                                                                                  // 3573
                                                                                                                     // 3574
                                                                                                                     // 3575
                                                                                                                     // 3576
                                                                                                                     // 3577
(function() {                                                                                                        // 3578
	var div = document.createElement( "div" );                                                                          // 3579
                                                                                                                     // 3580
	// Execute the test only if not already executed in another module.                                                 // 3581
	if (support.deleteExpando == null) {                                                                                // 3582
		// Support: IE<9                                                                                                   // 3583
		support.deleteExpando = true;                                                                                      // 3584
		try {                                                                                                              // 3585
			delete div.test;                                                                                                  // 3586
		} catch( e ) {                                                                                                     // 3587
			support.deleteExpando = false;                                                                                    // 3588
		}                                                                                                                  // 3589
	}                                                                                                                   // 3590
                                                                                                                     // 3591
	// Null elements to avoid leaks in IE.                                                                              // 3592
	div = null;                                                                                                         // 3593
})();                                                                                                                // 3594
                                                                                                                     // 3595
                                                                                                                     // 3596
/**                                                                                                                  // 3597
 * Determines whether an object can have data                                                                        // 3598
 */                                                                                                                  // 3599
jQuery.acceptData = function( elem ) {                                                                               // 3600
	var noData = jQuery.noData[ (elem.nodeName + " ").toLowerCase() ],                                                  // 3601
		nodeType = +elem.nodeType || 1;                                                                                    // 3602
                                                                                                                     // 3603
	// Do not set data on non-element DOM nodes because it will not be cleared (#8335).                                 // 3604
	return nodeType !== 1 && nodeType !== 9 ?                                                                           // 3605
		false :                                                                                                            // 3606
                                                                                                                     // 3607
		// Nodes accept data unless otherwise specified; rejection can be conditional                                      // 3608
		!noData || noData !== true && elem.getAttribute("classid") === noData;                                             // 3609
};                                                                                                                   // 3610
                                                                                                                     // 3611
                                                                                                                     // 3612
var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,                                                                        // 3613
	rmultiDash = /([A-Z])/g;                                                                                            // 3614
                                                                                                                     // 3615
function dataAttr( elem, key, data ) {                                                                               // 3616
	// If nothing was found internally, try to fetch any                                                                // 3617
	// data from the HTML5 data-* attribute                                                                             // 3618
	if ( data === undefined && elem.nodeType === 1 ) {                                                                  // 3619
                                                                                                                     // 3620
		var name = "data-" + key.replace( rmultiDash, "-$1" ).toLowerCase();                                               // 3621
                                                                                                                     // 3622
		data = elem.getAttribute( name );                                                                                  // 3623
                                                                                                                     // 3624
		if ( typeof data === "string" ) {                                                                                  // 3625
			try {                                                                                                             // 3626
				data = data === "true" ? true :                                                                                  // 3627
					data === "false" ? false :                                                                                      // 3628
					data === "null" ? null :                                                                                        // 3629
					// Only convert to a number if it doesn't change the string                                                     // 3630
					+data + "" === data ? +data :                                                                                   // 3631
					rbrace.test( data ) ? jQuery.parseJSON( data ) :                                                                // 3632
					data;                                                                                                           // 3633
			} catch( e ) {}                                                                                                   // 3634
                                                                                                                     // 3635
			// Make sure we set the data so it isn't changed later                                                            // 3636
			jQuery.data( elem, key, data );                                                                                   // 3637
                                                                                                                     // 3638
		} else {                                                                                                           // 3639
			data = undefined;                                                                                                 // 3640
		}                                                                                                                  // 3641
	}                                                                                                                   // 3642
                                                                                                                     // 3643
	return data;                                                                                                        // 3644
}                                                                                                                    // 3645
                                                                                                                     // 3646
// checks a cache object for emptiness                                                                               // 3647
function isEmptyDataObject( obj ) {                                                                                  // 3648
	var name;                                                                                                           // 3649
	for ( name in obj ) {                                                                                               // 3650
                                                                                                                     // 3651
		// if the public data object is empty, the private is still empty                                                  // 3652
		if ( name === "data" && jQuery.isEmptyObject( obj[name] ) ) {                                                      // 3653
			continue;                                                                                                         // 3654
		}                                                                                                                  // 3655
		if ( name !== "toJSON" ) {                                                                                         // 3656
			return false;                                                                                                     // 3657
		}                                                                                                                  // 3658
	}                                                                                                                   // 3659
                                                                                                                     // 3660
	return true;                                                                                                        // 3661
}                                                                                                                    // 3662
                                                                                                                     // 3663
function internalData( elem, name, data, pvt /* Internal Use Only */ ) {                                             // 3664
	if ( !jQuery.acceptData( elem ) ) {                                                                                 // 3665
		return;                                                                                                            // 3666
	}                                                                                                                   // 3667
                                                                                                                     // 3668
	var ret, thisCache,                                                                                                 // 3669
		internalKey = jQuery.expando,                                                                                      // 3670
                                                                                                                     // 3671
		// We have to handle DOM nodes and JS objects differently because IE6-7                                            // 3672
		// can't GC object references properly across the DOM-JS boundary                                                  // 3673
		isNode = elem.nodeType,                                                                                            // 3674
                                                                                                                     // 3675
		// Only DOM nodes need the global jQuery cache; JS object data is                                                  // 3676
		// attached directly to the object so GC can occur automatically                                                   // 3677
		cache = isNode ? jQuery.cache : elem,                                                                              // 3678
                                                                                                                     // 3679
		// Only defining an ID for JS objects if its cache already exists allows                                           // 3680
		// the code to shortcut on the same path as a DOM node with no cache                                               // 3681
		id = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;                                            // 3682
                                                                                                                     // 3683
	// Avoid doing any more work than we need to when trying to get data on an                                          // 3684
	// object that has no data at all                                                                                   // 3685
	if ( (!id || !cache[id] || (!pvt && !cache[id].data)) && data === undefined && typeof name === "string" ) {         // 3686
		return;                                                                                                            // 3687
	}                                                                                                                   // 3688
                                                                                                                     // 3689
	if ( !id ) {                                                                                                        // 3690
		// Only DOM nodes need a new unique ID for each element since their data                                           // 3691
		// ends up in the global cache                                                                                     // 3692
		if ( isNode ) {                                                                                                    // 3693
			id = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;                                                     // 3694
		} else {                                                                                                           // 3695
			id = internalKey;                                                                                                 // 3696
		}                                                                                                                  // 3697
	}                                                                                                                   // 3698
                                                                                                                     // 3699
	if ( !cache[ id ] ) {                                                                                               // 3700
		// Avoid exposing jQuery metadata on plain JS objects when the object                                              // 3701
		// is serialized using JSON.stringify                                                                              // 3702
		cache[ id ] = isNode ? {} : { toJSON: jQuery.noop };                                                               // 3703
	}                                                                                                                   // 3704
                                                                                                                     // 3705
	// An object can be passed to jQuery.data instead of a key/value pair; this gets                                    // 3706
	// shallow copied over onto the existing cache                                                                      // 3707
	if ( typeof name === "object" || typeof name === "function" ) {                                                     // 3708
		if ( pvt ) {                                                                                                       // 3709
			cache[ id ] = jQuery.extend( cache[ id ], name );                                                                 // 3710
		} else {                                                                                                           // 3711
			cache[ id ].data = jQuery.extend( cache[ id ].data, name );                                                       // 3712
		}                                                                                                                  // 3713
	}                                                                                                                   // 3714
                                                                                                                     // 3715
	thisCache = cache[ id ];                                                                                            // 3716
                                                                                                                     // 3717
	// jQuery data() is stored in a separate object inside the object's internal data                                   // 3718
	// cache in order to avoid key collisions between internal data and user-defined                                    // 3719
	// data.                                                                                                            // 3720
	if ( !pvt ) {                                                                                                       // 3721
		if ( !thisCache.data ) {                                                                                           // 3722
			thisCache.data = {};                                                                                              // 3723
		}                                                                                                                  // 3724
                                                                                                                     // 3725
		thisCache = thisCache.data;                                                                                        // 3726
	}                                                                                                                   // 3727
                                                                                                                     // 3728
	if ( data !== undefined ) {                                                                                         // 3729
		thisCache[ jQuery.camelCase( name ) ] = data;                                                                      // 3730
	}                                                                                                                   // 3731
                                                                                                                     // 3732
	// Check for both converted-to-camel and non-converted data property names                                          // 3733
	// If a data property was specified                                                                                 // 3734
	if ( typeof name === "string" ) {                                                                                   // 3735
                                                                                                                     // 3736
		// First Try to find as-is property data                                                                           // 3737
		ret = thisCache[ name ];                                                                                           // 3738
                                                                                                                     // 3739
		// Test for null|undefined property data                                                                           // 3740
		if ( ret == null ) {                                                                                               // 3741
                                                                                                                     // 3742
			// Try to find the camelCased property                                                                            // 3743
			ret = thisCache[ jQuery.camelCase( name ) ];                                                                      // 3744
		}                                                                                                                  // 3745
	} else {                                                                                                            // 3746
		ret = thisCache;                                                                                                   // 3747
	}                                                                                                                   // 3748
                                                                                                                     // 3749
	return ret;                                                                                                         // 3750
}                                                                                                                    // 3751
                                                                                                                     // 3752
function internalRemoveData( elem, name, pvt ) {                                                                     // 3753
	if ( !jQuery.acceptData( elem ) ) {                                                                                 // 3754
		return;                                                                                                            // 3755
	}                                                                                                                   // 3756
                                                                                                                     // 3757
	var thisCache, i,                                                                                                   // 3758
		isNode = elem.nodeType,                                                                                            // 3759
                                                                                                                     // 3760
		// See jQuery.data for more information                                                                            // 3761
		cache = isNode ? jQuery.cache : elem,                                                                              // 3762
		id = isNode ? elem[ jQuery.expando ] : jQuery.expando;                                                             // 3763
                                                                                                                     // 3764
	// If there is already no cache entry for this object, there is no                                                  // 3765
	// purpose in continuing                                                                                            // 3766
	if ( !cache[ id ] ) {                                                                                               // 3767
		return;                                                                                                            // 3768
	}                                                                                                                   // 3769
                                                                                                                     // 3770
	if ( name ) {                                                                                                       // 3771
                                                                                                                     // 3772
		thisCache = pvt ? cache[ id ] : cache[ id ].data;                                                                  // 3773
                                                                                                                     // 3774
		if ( thisCache ) {                                                                                                 // 3775
                                                                                                                     // 3776
			// Support array or space separated string names for data keys                                                    // 3777
			if ( !jQuery.isArray( name ) ) {                                                                                  // 3778
                                                                                                                     // 3779
				// try the string as a key before any manipulation                                                               // 3780
				if ( name in thisCache ) {                                                                                       // 3781
					name = [ name ];                                                                                                // 3782
				} else {                                                                                                         // 3783
                                                                                                                     // 3784
					// split the camel cased version by spaces unless a key with the spaces exists                                  // 3785
					name = jQuery.camelCase( name );                                                                                // 3786
					if ( name in thisCache ) {                                                                                      // 3787
						name = [ name ];                                                                                               // 3788
					} else {                                                                                                        // 3789
						name = name.split(" ");                                                                                        // 3790
					}                                                                                                               // 3791
				}                                                                                                                // 3792
			} else {                                                                                                          // 3793
				// If "name" is an array of keys...                                                                              // 3794
				// When data is initially created, via ("key", "val") signature,                                                 // 3795
				// keys will be converted to camelCase.                                                                          // 3796
				// Since there is no way to tell _how_ a key was added, remove                                                   // 3797
				// both plain key and camelCase key. #12786                                                                      // 3798
				// This will only penalize the array argument path.                                                              // 3799
				name = name.concat( jQuery.map( name, jQuery.camelCase ) );                                                      // 3800
			}                                                                                                                 // 3801
                                                                                                                     // 3802
			i = name.length;                                                                                                  // 3803
			while ( i-- ) {                                                                                                   // 3804
				delete thisCache[ name[i] ];                                                                                     // 3805
			}                                                                                                                 // 3806
                                                                                                                     // 3807
			// If there is no data left in the cache, we want to continue                                                     // 3808
			// and let the cache object itself get destroyed                                                                  // 3809
			if ( pvt ? !isEmptyDataObject(thisCache) : !jQuery.isEmptyObject(thisCache) ) {                                   // 3810
				return;                                                                                                          // 3811
			}                                                                                                                 // 3812
		}                                                                                                                  // 3813
	}                                                                                                                   // 3814
                                                                                                                     // 3815
	// See jQuery.data for more information                                                                             // 3816
	if ( !pvt ) {                                                                                                       // 3817
		delete cache[ id ].data;                                                                                           // 3818
                                                                                                                     // 3819
		// Don't destroy the parent cache unless the internal data object                                                  // 3820
		// had been the only thing left in it                                                                              // 3821
		if ( !isEmptyDataObject( cache[ id ] ) ) {                                                                         // 3822
			return;                                                                                                           // 3823
		}                                                                                                                  // 3824
	}                                                                                                                   // 3825
                                                                                                                     // 3826
	// Destroy the cache                                                                                                // 3827
	if ( isNode ) {                                                                                                     // 3828
		jQuery.cleanData( [ elem ], true );                                                                                // 3829
                                                                                                                     // 3830
	// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)                          // 3831
	/* jshint eqeqeq: false */                                                                                          // 3832
	} else if ( support.deleteExpando || cache != cache.window ) {                                                      // 3833
		/* jshint eqeqeq: true */                                                                                          // 3834
		delete cache[ id ];                                                                                                // 3835
                                                                                                                     // 3836
	// When all else fails, null                                                                                        // 3837
	} else {                                                                                                            // 3838
		cache[ id ] = null;                                                                                                // 3839
	}                                                                                                                   // 3840
}                                                                                                                    // 3841
                                                                                                                     // 3842
jQuery.extend({                                                                                                      // 3843
	cache: {},                                                                                                          // 3844
                                                                                                                     // 3845
	// The following elements (space-suffixed to avoid Object.prototype collisions)                                     // 3846
	// throw uncatchable exceptions if you attempt to set expando properties                                            // 3847
	noData: {                                                                                                           // 3848
		"applet ": true,                                                                                                   // 3849
		"embed ": true,                                                                                                    // 3850
		// ...but Flash objects (which have this classid) *can* handle expandos                                            // 3851
		"object ": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"                                                            // 3852
	},                                                                                                                  // 3853
                                                                                                                     // 3854
	hasData: function( elem ) {                                                                                         // 3855
		elem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];                              // 3856
		return !!elem && !isEmptyDataObject( elem );                                                                       // 3857
	},                                                                                                                  // 3858
                                                                                                                     // 3859
	data: function( elem, name, data ) {                                                                                // 3860
		return internalData( elem, name, data );                                                                           // 3861
	},                                                                                                                  // 3862
                                                                                                                     // 3863
	removeData: function( elem, name ) {                                                                                // 3864
		return internalRemoveData( elem, name );                                                                           // 3865
	},                                                                                                                  // 3866
                                                                                                                     // 3867
	// For internal use only.                                                                                           // 3868
	_data: function( elem, name, data ) {                                                                               // 3869
		return internalData( elem, name, data, true );                                                                     // 3870
	},                                                                                                                  // 3871
                                                                                                                     // 3872
	_removeData: function( elem, name ) {                                                                               // 3873
		return internalRemoveData( elem, name, true );                                                                     // 3874
	}                                                                                                                   // 3875
});                                                                                                                  // 3876
                                                                                                                     // 3877
jQuery.fn.extend({                                                                                                   // 3878
	data: function( key, value ) {                                                                                      // 3879
		var i, name, data,                                                                                                 // 3880
			elem = this[0],                                                                                                   // 3881
			attrs = elem && elem.attributes;                                                                                  // 3882
                                                                                                                     // 3883
		// Special expections of .data basically thwart jQuery.access,                                                     // 3884
		// so implement the relevant behavior ourselves                                                                    // 3885
                                                                                                                     // 3886
		// Gets all values                                                                                                 // 3887
		if ( key === undefined ) {                                                                                         // 3888
			if ( this.length ) {                                                                                              // 3889
				data = jQuery.data( elem );                                                                                      // 3890
                                                                                                                     // 3891
				if ( elem.nodeType === 1 && !jQuery._data( elem, "parsedAttrs" ) ) {                                             // 3892
					i = attrs.length;                                                                                               // 3893
					while ( i-- ) {                                                                                                 // 3894
						name = attrs[i].name;                                                                                          // 3895
                                                                                                                     // 3896
						if ( name.indexOf("data-") === 0 ) {                                                                           // 3897
							name = jQuery.camelCase( name.slice(5) );                                                                     // 3898
                                                                                                                     // 3899
							dataAttr( elem, name, data[ name ] );                                                                         // 3900
						}                                                                                                              // 3901
					}                                                                                                               // 3902
					jQuery._data( elem, "parsedAttrs", true );                                                                      // 3903
				}                                                                                                                // 3904
			}                                                                                                                 // 3905
                                                                                                                     // 3906
			return data;                                                                                                      // 3907
		}                                                                                                                  // 3908
                                                                                                                     // 3909
		// Sets multiple values                                                                                            // 3910
		if ( typeof key === "object" ) {                                                                                   // 3911
			return this.each(function() {                                                                                     // 3912
				jQuery.data( this, key );                                                                                        // 3913
			});                                                                                                               // 3914
		}                                                                                                                  // 3915
                                                                                                                     // 3916
		return arguments.length > 1 ?                                                                                      // 3917
                                                                                                                     // 3918
			// Sets one value                                                                                                 // 3919
			this.each(function() {                                                                                            // 3920
				jQuery.data( this, key, value );                                                                                 // 3921
			}) :                                                                                                              // 3922
                                                                                                                     // 3923
			// Gets one value                                                                                                 // 3924
			// Try to fetch any internally stored data first                                                                  // 3925
			elem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;                                               // 3926
	},                                                                                                                  // 3927
                                                                                                                     // 3928
	removeData: function( key ) {                                                                                       // 3929
		return this.each(function() {                                                                                      // 3930
			jQuery.removeData( this, key );                                                                                   // 3931
		});                                                                                                                // 3932
	}                                                                                                                   // 3933
});                                                                                                                  // 3934
                                                                                                                     // 3935
                                                                                                                     // 3936
jQuery.extend({                                                                                                      // 3937
	queue: function( elem, type, data ) {                                                                               // 3938
		var queue;                                                                                                         // 3939
                                                                                                                     // 3940
		if ( elem ) {                                                                                                      // 3941
			type = ( type || "fx" ) + "queue";                                                                                // 3942
			queue = jQuery._data( elem, type );                                                                               // 3943
                                                                                                                     // 3944
			// Speed up dequeue by getting out quickly if this is just a lookup                                               // 3945
			if ( data ) {                                                                                                     // 3946
				if ( !queue || jQuery.isArray(data) ) {                                                                          // 3947
					queue = jQuery._data( elem, type, jQuery.makeArray(data) );                                                     // 3948
				} else {                                                                                                         // 3949
					queue.push( data );                                                                                             // 3950
				}                                                                                                                // 3951
			}                                                                                                                 // 3952
			return queue || [];                                                                                               // 3953
		}                                                                                                                  // 3954
	},                                                                                                                  // 3955
                                                                                                                     // 3956
	dequeue: function( elem, type ) {                                                                                   // 3957
		type = type || "fx";                                                                                               // 3958
                                                                                                                     // 3959
		var queue = jQuery.queue( elem, type ),                                                                            // 3960
			startLength = queue.length,                                                                                       // 3961
			fn = queue.shift(),                                                                                               // 3962
			hooks = jQuery._queueHooks( elem, type ),                                                                         // 3963
			next = function() {                                                                                               // 3964
				jQuery.dequeue( elem, type );                                                                                    // 3965
			};                                                                                                                // 3966
                                                                                                                     // 3967
		// If the fx queue is dequeued, always remove the progress sentinel                                                // 3968
		if ( fn === "inprogress" ) {                                                                                       // 3969
			fn = queue.shift();                                                                                               // 3970
			startLength--;                                                                                                    // 3971
		}                                                                                                                  // 3972
                                                                                                                     // 3973
		if ( fn ) {                                                                                                        // 3974
                                                                                                                     // 3975
			// Add a progress sentinel to prevent the fx queue from being                                                     // 3976
			// automatically dequeued                                                                                         // 3977
			if ( type === "fx" ) {                                                                                            // 3978
				queue.unshift( "inprogress" );                                                                                   // 3979
			}                                                                                                                 // 3980
                                                                                                                     // 3981
			// clear up the last queue stop function                                                                          // 3982
			delete hooks.stop;                                                                                                // 3983
			fn.call( elem, next, hooks );                                                                                     // 3984
		}                                                                                                                  // 3985
                                                                                                                     // 3986
		if ( !startLength && hooks ) {                                                                                     // 3987
			hooks.empty.fire();                                                                                               // 3988
		}                                                                                                                  // 3989
	},                                                                                                                  // 3990
                                                                                                                     // 3991
	// not intended for public consumption - generates a queueHooks object, or returns the current one                  // 3992
	_queueHooks: function( elem, type ) {                                                                               // 3993
		var key = type + "queueHooks";                                                                                     // 3994
		return jQuery._data( elem, key ) || jQuery._data( elem, key, {                                                     // 3995
			empty: jQuery.Callbacks("once memory").add(function() {                                                           // 3996
				jQuery._removeData( elem, type + "queue" );                                                                      // 3997
				jQuery._removeData( elem, key );                                                                                 // 3998
			})                                                                                                                // 3999
		});                                                                                                                // 4000
	}                                                                                                                   // 4001
});                                                                                                                  // 4002
                                                                                                                     // 4003
jQuery.fn.extend({                                                                                                   // 4004
	queue: function( type, data ) {                                                                                     // 4005
		var setter = 2;                                                                                                    // 4006
                                                                                                                     // 4007
		if ( typeof type !== "string" ) {                                                                                  // 4008
			data = type;                                                                                                      // 4009
			type = "fx";                                                                                                      // 4010
			setter--;                                                                                                         // 4011
		}                                                                                                                  // 4012
                                                                                                                     // 4013
		if ( arguments.length < setter ) {                                                                                 // 4014
			return jQuery.queue( this[0], type );                                                                             // 4015
		}                                                                                                                  // 4016
                                                                                                                     // 4017
		return data === undefined ?                                                                                        // 4018
			this :                                                                                                            // 4019
			this.each(function() {                                                                                            // 4020
				var queue = jQuery.queue( this, type, data );                                                                    // 4021
                                                                                                                     // 4022
				// ensure a hooks for this queue                                                                                 // 4023
				jQuery._queueHooks( this, type );                                                                                // 4024
                                                                                                                     // 4025
				if ( type === "fx" && queue[0] !== "inprogress" ) {                                                              // 4026
					jQuery.dequeue( this, type );                                                                                   // 4027
				}                                                                                                                // 4028
			});                                                                                                               // 4029
	},                                                                                                                  // 4030
	dequeue: function( type ) {                                                                                         // 4031
		return this.each(function() {                                                                                      // 4032
			jQuery.dequeue( this, type );                                                                                     // 4033
		});                                                                                                                // 4034
	},                                                                                                                  // 4035
	clearQueue: function( type ) {                                                                                      // 4036
		return this.queue( type || "fx", [] );                                                                             // 4037
	},                                                                                                                  // 4038
	// Get a promise resolved when queues of a certain type                                                             // 4039
	// are emptied (fx is the type by default)                                                                          // 4040
	promise: function( type, obj ) {                                                                                    // 4041
		var tmp,                                                                                                           // 4042
			count = 1,                                                                                                        // 4043
			defer = jQuery.Deferred(),                                                                                        // 4044
			elements = this,                                                                                                  // 4045
			i = this.length,                                                                                                  // 4046
			resolve = function() {                                                                                            // 4047
				if ( !( --count ) ) {                                                                                            // 4048
					defer.resolveWith( elements, [ elements ] );                                                                    // 4049
				}                                                                                                                // 4050
			};                                                                                                                // 4051
                                                                                                                     // 4052
		if ( typeof type !== "string" ) {                                                                                  // 4053
			obj = type;                                                                                                       // 4054
			type = undefined;                                                                                                 // 4055
		}                                                                                                                  // 4056
		type = type || "fx";                                                                                               // 4057
                                                                                                                     // 4058
		while ( i-- ) {                                                                                                    // 4059
			tmp = jQuery._data( elements[ i ], type + "queueHooks" );                                                         // 4060
			if ( tmp && tmp.empty ) {                                                                                         // 4061
				count++;                                                                                                         // 4062
				tmp.empty.add( resolve );                                                                                        // 4063
			}                                                                                                                 // 4064
		}                                                                                                                  // 4065
		resolve();                                                                                                         // 4066
		return defer.promise( obj );                                                                                       // 4067
	}                                                                                                                   // 4068
});                                                                                                                  // 4069
var pnum = (/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/).source;                                                           // 4070
                                                                                                                     // 4071
var cssExpand = [ "Top", "Right", "Bottom", "Left" ];                                                                // 4072
                                                                                                                     // 4073
var isHidden = function( elem, el ) {                                                                                // 4074
		// isHidden might be called from jQuery#filter function;                                                           // 4075
		// in that case, element will be second argument                                                                   // 4076
		elem = el || elem;                                                                                                 // 4077
		return jQuery.css( elem, "display" ) === "none" || !jQuery.contains( elem.ownerDocument, elem );                   // 4078
	};                                                                                                                  // 4079
                                                                                                                     // 4080
                                                                                                                     // 4081
                                                                                                                     // 4082
// Multifunctional method to get and set values of a collection                                                      // 4083
// The value/s can optionally be executed if it's a function                                                         // 4084
var access = jQuery.access = function( elems, fn, key, value, chainable, emptyGet, raw ) {                           // 4085
	var i = 0,                                                                                                          // 4086
		length = elems.length,                                                                                             // 4087
		bulk = key == null;                                                                                                // 4088
                                                                                                                     // 4089
	// Sets many values                                                                                                 // 4090
	if ( jQuery.type( key ) === "object" ) {                                                                            // 4091
		chainable = true;                                                                                                  // 4092
		for ( i in key ) {                                                                                                 // 4093
			jQuery.access( elems, fn, i, key[i], true, emptyGet, raw );                                                       // 4094
		}                                                                                                                  // 4095
                                                                                                                     // 4096
	// Sets one value                                                                                                   // 4097
	} else if ( value !== undefined ) {                                                                                 // 4098
		chainable = true;                                                                                                  // 4099
                                                                                                                     // 4100
		if ( !jQuery.isFunction( value ) ) {                                                                               // 4101
			raw = true;                                                                                                       // 4102
		}                                                                                                                  // 4103
                                                                                                                     // 4104
		if ( bulk ) {                                                                                                      // 4105
			// Bulk operations run against the entire set                                                                     // 4106
			if ( raw ) {                                                                                                      // 4107
				fn.call( elems, value );                                                                                         // 4108
				fn = null;                                                                                                       // 4109
                                                                                                                     // 4110
			// ...except when executing function values                                                                       // 4111
			} else {                                                                                                          // 4112
				bulk = fn;                                                                                                       // 4113
				fn = function( elem, key, value ) {                                                                              // 4114
					return bulk.call( jQuery( elem ), value );                                                                      // 4115
				};                                                                                                               // 4116
			}                                                                                                                 // 4117
		}                                                                                                                  // 4118
                                                                                                                     // 4119
		if ( fn ) {                                                                                                        // 4120
			for ( ; i < length; i++ ) {                                                                                       // 4121
				fn( elems[i], key, raw ? value : value.call( elems[i], i, fn( elems[i], key ) ) );                               // 4122
			}                                                                                                                 // 4123
		}                                                                                                                  // 4124
	}                                                                                                                   // 4125
                                                                                                                     // 4126
	return chainable ?                                                                                                  // 4127
		elems :                                                                                                            // 4128
                                                                                                                     // 4129
		// Gets                                                                                                            // 4130
		bulk ?                                                                                                             // 4131
			fn.call( elems ) :                                                                                                // 4132
			length ? fn( elems[0], key ) : emptyGet;                                                                          // 4133
};                                                                                                                   // 4134
var rcheckableType = (/^(?:checkbox|radio)$/i);                                                                      // 4135
                                                                                                                     // 4136
                                                                                                                     // 4137
                                                                                                                     // 4138
(function() {                                                                                                        // 4139
	var fragment = document.createDocumentFragment(),                                                                   // 4140
		div = document.createElement("div"),                                                                               // 4141
		input = document.createElement("input");                                                                           // 4142
                                                                                                                     // 4143
	// Setup                                                                                                            // 4144
	div.setAttribute( "className", "t" );                                                                               // 4145
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a>";                                                       // 4146
                                                                                                                     // 4147
	// IE strips leading whitespace when .innerHTML is used                                                             // 4148
	support.leadingWhitespace = div.firstChild.nodeType === 3;                                                          // 4149
                                                                                                                     // 4150
	// Make sure that tbody elements aren't automatically inserted                                                      // 4151
	// IE will insert them into empty tables                                                                            // 4152
	support.tbody = !div.getElementsByTagName( "tbody" ).length;                                                        // 4153
                                                                                                                     // 4154
	// Make sure that link elements get serialized correctly by innerHTML                                               // 4155
	// This requires a wrapper element in IE                                                                            // 4156
	support.htmlSerialize = !!div.getElementsByTagName( "link" ).length;                                                // 4157
                                                                                                                     // 4158
	// Makes sure cloning an html5 element does not cause problems                                                      // 4159
	// Where outerHTML is undefined, this still works                                                                   // 4160
	support.html5Clone =                                                                                                // 4161
		document.createElement( "nav" ).cloneNode( true ).outerHTML !== "<:nav></:nav>";                                   // 4162
                                                                                                                     // 4163
	// Check if a disconnected checkbox will retain its checked                                                         // 4164
	// value of true after appended to the DOM (IE6/7)                                                                  // 4165
	input.type = "checkbox";                                                                                            // 4166
	input.checked = true;                                                                                               // 4167
	fragment.appendChild( input );                                                                                      // 4168
	support.appendChecked = input.checked;                                                                              // 4169
                                                                                                                     // 4170
	// Make sure textarea (and checkbox) defaultValue is properly cloned                                                // 4171
	// Support: IE6-IE11+                                                                                               // 4172
	div.innerHTML = "<textarea>x</textarea>";                                                                           // 4173
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;                                            // 4174
                                                                                                                     // 4175
	// #11217 - WebKit loses check when the name is after the checked attribute                                         // 4176
	fragment.appendChild( div );                                                                                        // 4177
	div.innerHTML = "<input type='radio' checked='checked' name='t'/>";                                                 // 4178
                                                                                                                     // 4179
	// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3                                                           // 4180
	// old WebKit doesn't clone checked state correctly in fragments                                                    // 4181
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;                                     // 4182
                                                                                                                     // 4183
	// Support: IE<9                                                                                                    // 4184
	// Opera does not clone events (and typeof div.attachEvent === undefined).                                          // 4185
	// IE9-10 clones events bound via attachEvent, but they don't trigger with .click()                                 // 4186
	support.noCloneEvent = true;                                                                                        // 4187
	if ( div.attachEvent ) {                                                                                            // 4188
		div.attachEvent( "onclick", function() {                                                                           // 4189
			support.noCloneEvent = false;                                                                                     // 4190
		});                                                                                                                // 4191
                                                                                                                     // 4192
		div.cloneNode( true ).click();                                                                                     // 4193
	}                                                                                                                   // 4194
                                                                                                                     // 4195
	// Execute the test only if not already executed in another module.                                                 // 4196
	if (support.deleteExpando == null) {                                                                                // 4197
		// Support: IE<9                                                                                                   // 4198
		support.deleteExpando = true;                                                                                      // 4199
		try {                                                                                                              // 4200
			delete div.test;                                                                                                  // 4201
		} catch( e ) {                                                                                                     // 4202
			support.deleteExpando = false;                                                                                    // 4203
		}                                                                                                                  // 4204
	}                                                                                                                   // 4205
                                                                                                                     // 4206
	// Null elements to avoid leaks in IE.                                                                              // 4207
	fragment = div = input = null;                                                                                      // 4208
})();                                                                                                                // 4209
                                                                                                                     // 4210
                                                                                                                     // 4211
(function() {                                                                                                        // 4212
	var i, eventName,                                                                                                   // 4213
		div = document.createElement( "div" );                                                                             // 4214
                                                                                                                     // 4215
	// Support: IE<9 (lack submit/change bubble), Firefox 23+ (lack focusin event)                                      // 4216
	for ( i in { submit: true, change: true, focusin: true }) {                                                         // 4217
		eventName = "on" + i;                                                                                              // 4218
                                                                                                                     // 4219
		if ( !(support[ i + "Bubbles" ] = eventName in window) ) {                                                         // 4220
			// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)                                     // 4221
			div.setAttribute( eventName, "t" );                                                                               // 4222
			support[ i + "Bubbles" ] = div.attributes[ eventName ].expando === false;                                         // 4223
		}                                                                                                                  // 4224
	}                                                                                                                   // 4225
                                                                                                                     // 4226
	// Null elements to avoid leaks in IE.                                                                              // 4227
	div = null;                                                                                                         // 4228
})();                                                                                                                // 4229
                                                                                                                     // 4230
                                                                                                                     // 4231
var rformElems = /^(?:input|select|textarea)$/i,                                                                     // 4232
	rkeyEvent = /^key/,                                                                                                 // 4233
	rmouseEvent = /^(?:mouse|contextmenu)|click/,                                                                       // 4234
	rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,                                                                    // 4235
	rtypenamespace = /^([^.]*)(?:\.(.+)|)$/;                                                                            // 4236
                                                                                                                     // 4237
function returnTrue() {                                                                                              // 4238
	return true;                                                                                                        // 4239
}                                                                                                                    // 4240
                                                                                                                     // 4241
function returnFalse() {                                                                                             // 4242
	return false;                                                                                                       // 4243
}                                                                                                                    // 4244
                                                                                                                     // 4245
function safeActiveElement() {                                                                                       // 4246
	try {                                                                                                               // 4247
		return document.activeElement;                                                                                     // 4248
	} catch ( err ) { }                                                                                                 // 4249
}                                                                                                                    // 4250
                                                                                                                     // 4251
/*                                                                                                                   // 4252
 * Helper functions for managing events -- not part of the public interface.                                         // 4253
 * Props to Dean Edwards' addEvent library for many of the ideas.                                                    // 4254
 */                                                                                                                  // 4255
jQuery.event = {                                                                                                     // 4256
                                                                                                                     // 4257
	global: {},                                                                                                         // 4258
                                                                                                                     // 4259
	add: function( elem, types, handler, data, selector ) {                                                             // 4260
		var tmp, events, t, handleObjIn,                                                                                   // 4261
			special, eventHandle, handleObj,                                                                                  // 4262
			handlers, type, namespaces, origType,                                                                             // 4263
			elemData = jQuery._data( elem );                                                                                  // 4264
                                                                                                                     // 4265
		// Don't attach events to noData or text/comment nodes (but allow plain objects)                                   // 4266
		if ( !elemData ) {                                                                                                 // 4267
			return;                                                                                                           // 4268
		}                                                                                                                  // 4269
                                                                                                                     // 4270
		// Caller can pass in an object of custom data in lieu of the handler                                              // 4271
		if ( handler.handler ) {                                                                                           // 4272
			handleObjIn = handler;                                                                                            // 4273
			handler = handleObjIn.handler;                                                                                    // 4274
			selector = handleObjIn.selector;                                                                                  // 4275
		}                                                                                                                  // 4276
                                                                                                                     // 4277
		// Make sure that the handler has a unique ID, used to find/remove it later                                        // 4278
		if ( !handler.guid ) {                                                                                             // 4279
			handler.guid = jQuery.guid++;                                                                                     // 4280
		}                                                                                                                  // 4281
                                                                                                                     // 4282
		// Init the element's event structure and main handler, if this is the first                                       // 4283
		if ( !(events = elemData.events) ) {                                                                               // 4284
			events = elemData.events = {};                                                                                    // 4285
		}                                                                                                                  // 4286
		if ( !(eventHandle = elemData.handle) ) {                                                                          // 4287
			eventHandle = elemData.handle = function( e ) {                                                                   // 4288
				// Discard the second event of a jQuery.event.trigger() and                                                      // 4289
				// when an event is called after a page has unloaded                                                             // 4290
				return typeof jQuery !== strundefined && (!e || jQuery.event.triggered !== e.type) ?                             // 4291
					jQuery.event.dispatch.apply( eventHandle.elem, arguments ) :                                                    // 4292
					undefined;                                                                                                      // 4293
			};                                                                                                                // 4294
			// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events                     // 4295
			eventHandle.elem = elem;                                                                                          // 4296
		}                                                                                                                  // 4297
                                                                                                                     // 4298
		// Handle multiple events separated by a space                                                                     // 4299
		types = ( types || "" ).match( rnotwhite ) || [ "" ];                                                              // 4300
		t = types.length;                                                                                                  // 4301
		while ( t-- ) {                                                                                                    // 4302
			tmp = rtypenamespace.exec( types[t] ) || [];                                                                      // 4303
			type = origType = tmp[1];                                                                                         // 4304
			namespaces = ( tmp[2] || "" ).split( "." ).sort();                                                                // 4305
                                                                                                                     // 4306
			// There *must* be a type, no attaching namespace-only handlers                                                   // 4307
			if ( !type ) {                                                                                                    // 4308
				continue;                                                                                                        // 4309
			}                                                                                                                 // 4310
                                                                                                                     // 4311
			// If event changes its type, use the special event handlers for the changed type                                 // 4312
			special = jQuery.event.special[ type ] || {};                                                                     // 4313
                                                                                                                     // 4314
			// If selector defined, determine special event api type, otherwise given type                                    // 4315
			type = ( selector ? special.delegateType : special.bindType ) || type;                                            // 4316
                                                                                                                     // 4317
			// Update special based on newly reset type                                                                       // 4318
			special = jQuery.event.special[ type ] || {};                                                                     // 4319
                                                                                                                     // 4320
			// handleObj is passed to all event handlers                                                                      // 4321
			handleObj = jQuery.extend({                                                                                       // 4322
				type: type,                                                                                                      // 4323
				origType: origType,                                                                                              // 4324
				data: data,                                                                                                      // 4325
				handler: handler,                                                                                                // 4326
				guid: handler.guid,                                                                                              // 4327
				selector: selector,                                                                                              // 4328
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),                                       // 4329
				namespace: namespaces.join(".")                                                                                  // 4330
			}, handleObjIn );                                                                                                 // 4331
                                                                                                                     // 4332
			// Init the event handler queue if we're the first                                                                // 4333
			if ( !(handlers = events[ type ]) ) {                                                                             // 4334
				handlers = events[ type ] = [];                                                                                  // 4335
				handlers.delegateCount = 0;                                                                                      // 4336
                                                                                                                     // 4337
				// Only use addEventListener/attachEvent if the special events handler returns false                             // 4338
				if ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {                   // 4339
					// Bind the global event handler to the element                                                                 // 4340
					if ( elem.addEventListener ) {                                                                                  // 4341
						elem.addEventListener( type, eventHandle, false );                                                             // 4342
                                                                                                                     // 4343
					} else if ( elem.attachEvent ) {                                                                                // 4344
						elem.attachEvent( "on" + type, eventHandle );                                                                  // 4345
					}                                                                                                               // 4346
				}                                                                                                                // 4347
			}                                                                                                                 // 4348
                                                                                                                     // 4349
			if ( special.add ) {                                                                                              // 4350
				special.add.call( elem, handleObj );                                                                             // 4351
                                                                                                                     // 4352
				if ( !handleObj.handler.guid ) {                                                                                 // 4353
					handleObj.handler.guid = handler.guid;                                                                          // 4354
				}                                                                                                                // 4355
			}                                                                                                                 // 4356
                                                                                                                     // 4357
			// Add to the element's handler list, delegates in front                                                          // 4358
			if ( selector ) {                                                                                                 // 4359
				handlers.splice( handlers.delegateCount++, 0, handleObj );                                                       // 4360
			} else {                                                                                                          // 4361
				handlers.push( handleObj );                                                                                      // 4362
			}                                                                                                                 // 4363
                                                                                                                     // 4364
			// Keep track of which events have ever been used, for event optimization                                         // 4365
			jQuery.event.global[ type ] = true;                                                                               // 4366
		}                                                                                                                  // 4367
                                                                                                                     // 4368
		// Nullify elem to prevent memory leaks in IE                                                                      // 4369
		elem = null;                                                                                                       // 4370
	},                                                                                                                  // 4371
                                                                                                                     // 4372
	// Detach an event or set of events from an element                                                                 // 4373
	remove: function( elem, types, handler, selector, mappedTypes ) {                                                   // 4374
		var j, handleObj, tmp,                                                                                             // 4375
			origCount, t, events,                                                                                             // 4376
			special, handlers, type,                                                                                          // 4377
			namespaces, origType,                                                                                             // 4378
			elemData = jQuery.hasData( elem ) && jQuery._data( elem );                                                        // 4379
                                                                                                                     // 4380
		if ( !elemData || !(events = elemData.events) ) {                                                                  // 4381
			return;                                                                                                           // 4382
		}                                                                                                                  // 4383
                                                                                                                     // 4384
		// Once for each type.namespace in types; type may be omitted                                                      // 4385
		types = ( types || "" ).match( rnotwhite ) || [ "" ];                                                              // 4386
		t = types.length;                                                                                                  // 4387
		while ( t-- ) {                                                                                                    // 4388
			tmp = rtypenamespace.exec( types[t] ) || [];                                                                      // 4389
			type = origType = tmp[1];                                                                                         // 4390
			namespaces = ( tmp[2] || "" ).split( "." ).sort();                                                                // 4391
                                                                                                                     // 4392
			// Unbind all events (on this namespace, if provided) for the element                                             // 4393
			if ( !type ) {                                                                                                    // 4394
				for ( type in events ) {                                                                                         // 4395
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );                                        // 4396
				}                                                                                                                // 4397
				continue;                                                                                                        // 4398
			}                                                                                                                 // 4399
                                                                                                                     // 4400
			special = jQuery.event.special[ type ] || {};                                                                     // 4401
			type = ( selector ? special.delegateType : special.bindType ) || type;                                            // 4402
			handlers = events[ type ] || [];                                                                                  // 4403
			tmp = tmp[2] && new RegExp( "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)" );                           // 4404
                                                                                                                     // 4405
			// Remove matching events                                                                                         // 4406
			origCount = j = handlers.length;                                                                                  // 4407
			while ( j-- ) {                                                                                                   // 4408
				handleObj = handlers[ j ];                                                                                       // 4409
                                                                                                                     // 4410
				if ( ( mappedTypes || origType === handleObj.origType ) &&                                                       // 4411
					( !handler || handler.guid === handleObj.guid ) &&                                                              // 4412
					( !tmp || tmp.test( handleObj.namespace ) ) &&                                                                  // 4413
					( !selector || selector === handleObj.selector || selector === "**" && handleObj.selector ) ) {                 // 4414
					handlers.splice( j, 1 );                                                                                        // 4415
                                                                                                                     // 4416
					if ( handleObj.selector ) {                                                                                     // 4417
						handlers.delegateCount--;                                                                                      // 4418
					}                                                                                                               // 4419
					if ( special.remove ) {                                                                                         // 4420
						special.remove.call( elem, handleObj );                                                                        // 4421
					}                                                                                                               // 4422
				}                                                                                                                // 4423
			}                                                                                                                 // 4424
                                                                                                                     // 4425
			// Remove generic event handler if we removed something and no more handlers exist                                // 4426
			// (avoids potential for endless recursion during removal of special event handlers)                              // 4427
			if ( origCount && !handlers.length ) {                                                                            // 4428
				if ( !special.teardown || special.teardown.call( elem, namespaces, elemData.handle ) === false ) {               // 4429
					jQuery.removeEvent( elem, type, elemData.handle );                                                              // 4430
				}                                                                                                                // 4431
                                                                                                                     // 4432
				delete events[ type ];                                                                                           // 4433
			}                                                                                                                 // 4434
		}                                                                                                                  // 4435
                                                                                                                     // 4436
		// Remove the expando if it's no longer used                                                                       // 4437
		if ( jQuery.isEmptyObject( events ) ) {                                                                            // 4438
			delete elemData.handle;                                                                                           // 4439
                                                                                                                     // 4440
			// removeData also checks for emptiness and clears the expando if empty                                           // 4441
			// so use it instead of delete                                                                                    // 4442
			jQuery._removeData( elem, "events" );                                                                             // 4443
		}                                                                                                                  // 4444
	},                                                                                                                  // 4445
                                                                                                                     // 4446
	trigger: function( event, data, elem, onlyHandlers ) {                                                              // 4447
		var handle, ontype, cur,                                                                                           // 4448
			bubbleType, special, tmp, i,                                                                                      // 4449
			eventPath = [ elem || document ],                                                                                 // 4450
			type = hasOwn.call( event, "type" ) ? event.type : event,                                                         // 4451
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split(".") : [];                                 // 4452
                                                                                                                     // 4453
		cur = tmp = elem = elem || document;                                                                               // 4454
                                                                                                                     // 4455
		// Don't do events on text and comment nodes                                                                       // 4456
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {                                                                // 4457
			return;                                                                                                           // 4458
		}                                                                                                                  // 4459
                                                                                                                     // 4460
		// focus/blur morphs to focusin/out; ensure we're not firing them right now                                        // 4461
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {                                                         // 4462
			return;                                                                                                           // 4463
		}                                                                                                                  // 4464
                                                                                                                     // 4465
		if ( type.indexOf(".") >= 0 ) {                                                                                    // 4466
			// Namespaced trigger; create a regexp to match event type in handle()                                            // 4467
			namespaces = type.split(".");                                                                                     // 4468
			type = namespaces.shift();                                                                                        // 4469
			namespaces.sort();                                                                                                // 4470
		}                                                                                                                  // 4471
		ontype = type.indexOf(":") < 0 && "on" + type;                                                                     // 4472
                                                                                                                     // 4473
		// Caller can pass in a jQuery.Event object, Object, or just an event type string                                  // 4474
		event = event[ jQuery.expando ] ?                                                                                  // 4475
			event :                                                                                                           // 4476
			new jQuery.Event( type, typeof event === "object" && event );                                                     // 4477
                                                                                                                     // 4478
		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)                                          // 4479
		event.isTrigger = onlyHandlers ? 2 : 3;                                                                            // 4480
		event.namespace = namespaces.join(".");                                                                            // 4481
		event.namespace_re = event.namespace ?                                                                             // 4482
			new RegExp( "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)" ) :                                          // 4483
			null;                                                                                                             // 4484
                                                                                                                     // 4485
		// Clean up the event in case it is being reused                                                                   // 4486
		event.result = undefined;                                                                                          // 4487
		if ( !event.target ) {                                                                                             // 4488
			event.target = elem;                                                                                              // 4489
		}                                                                                                                  // 4490
                                                                                                                     // 4491
		// Clone any incoming data and prepend the event, creating the handler arg list                                    // 4492
		data = data == null ?                                                                                              // 4493
			[ event ] :                                                                                                       // 4494
			jQuery.makeArray( data, [ event ] );                                                                              // 4495
                                                                                                                     // 4496
		// Allow special events to draw outside the lines                                                                  // 4497
		special = jQuery.event.special[ type ] || {};                                                                      // 4498
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {                         // 4499
			return;                                                                                                           // 4500
		}                                                                                                                  // 4501
                                                                                                                     // 4502
		// Determine event propagation path in advance, per W3C events spec (#9951)                                        // 4503
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)                             // 4504
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {                                            // 4505
                                                                                                                     // 4506
			bubbleType = special.delegateType || type;                                                                        // 4507
			if ( !rfocusMorph.test( bubbleType + type ) ) {                                                                   // 4508
				cur = cur.parentNode;                                                                                            // 4509
			}                                                                                                                 // 4510
			for ( ; cur; cur = cur.parentNode ) {                                                                             // 4511
				eventPath.push( cur );                                                                                           // 4512
				tmp = cur;                                                                                                       // 4513
			}                                                                                                                 // 4514
                                                                                                                     // 4515
			// Only add window if we got to document (e.g., not plain obj or detached DOM)                                    // 4516
			if ( tmp === (elem.ownerDocument || document) ) {                                                                 // 4517
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );                                                 // 4518
			}                                                                                                                 // 4519
		}                                                                                                                  // 4520
                                                                                                                     // 4521
		// Fire handlers on the event path                                                                                 // 4522
		i = 0;                                                                                                             // 4523
		while ( (cur = eventPath[i++]) && !event.isPropagationStopped() ) {                                                // 4524
                                                                                                                     // 4525
			event.type = i > 1 ?                                                                                              // 4526
				bubbleType :                                                                                                     // 4527
				special.bindType || type;                                                                                        // 4528
                                                                                                                     // 4529
			// jQuery handler                                                                                                 // 4530
			handle = ( jQuery._data( cur, "events" ) || {} )[ event.type ] && jQuery._data( cur, "handle" );                  // 4531
			if ( handle ) {                                                                                                   // 4532
				handle.apply( cur, data );                                                                                       // 4533
			}                                                                                                                 // 4534
                                                                                                                     // 4535
			// Native handler                                                                                                 // 4536
			handle = ontype && cur[ ontype ];                                                                                 // 4537
			if ( handle && handle.apply && jQuery.acceptData( cur ) ) {                                                       // 4538
				event.result = handle.apply( cur, data );                                                                        // 4539
				if ( event.result === false ) {                                                                                  // 4540
					event.preventDefault();                                                                                         // 4541
				}                                                                                                                // 4542
			}                                                                                                                 // 4543
		}                                                                                                                  // 4544
		event.type = type;                                                                                                 // 4545
                                                                                                                     // 4546
		// If nobody prevented the default action, do it now                                                               // 4547
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {                                                              // 4548
                                                                                                                     // 4549
			if ( (!special._default || special._default.apply( eventPath.pop(), data ) === false) &&                          // 4550
				jQuery.acceptData( elem ) ) {                                                                                    // 4551
                                                                                                                     // 4552
				// Call a native DOM method on the target with the same name name as the event.                                  // 4553
				// Can't use an .isFunction() check here because IE6/7 fails that test.                                          // 4554
				// Don't do default actions on window, that's where global variables be (#6170)                                  // 4555
				if ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {                                                      // 4556
                                                                                                                     // 4557
					// Don't re-trigger an onFOO event when we call its FOO() method                                                // 4558
					tmp = elem[ ontype ];                                                                                           // 4559
                                                                                                                     // 4560
					if ( tmp ) {                                                                                                    // 4561
						elem[ ontype ] = null;                                                                                         // 4562
					}                                                                                                               // 4563
                                                                                                                     // 4564
					// Prevent re-triggering of the same event, since we already bubbled it above                                   // 4565
					jQuery.event.triggered = type;                                                                                  // 4566
					try {                                                                                                           // 4567
						elem[ type ]();                                                                                                // 4568
					} catch ( e ) {                                                                                                 // 4569
						// IE<9 dies on focus/blur to hidden element (#1486,#12518)                                                    // 4570
						// only reproducible on winXP IE8 native, not IE9 in IE8 mode                                                  // 4571
					}                                                                                                               // 4572
					jQuery.event.triggered = undefined;                                                                             // 4573
                                                                                                                     // 4574
					if ( tmp ) {                                                                                                    // 4575
						elem[ ontype ] = tmp;                                                                                          // 4576
					}                                                                                                               // 4577
				}                                                                                                                // 4578
			}                                                                                                                 // 4579
		}                                                                                                                  // 4580
                                                                                                                     // 4581
		return event.result;                                                                                               // 4582
	},                                                                                                                  // 4583
                                                                                                                     // 4584
	dispatch: function( event ) {                                                                                       // 4585
                                                                                                                     // 4586
		// Make a writable jQuery.Event from the native event object                                                       // 4587
		event = jQuery.event.fix( event );                                                                                 // 4588
                                                                                                                     // 4589
		var i, ret, handleObj, matched, j,                                                                                 // 4590
			handlerQueue = [],                                                                                                // 4591
			args = slice.call( arguments ),                                                                                   // 4592
			handlers = ( jQuery._data( this, "events" ) || {} )[ event.type ] || [],                                          // 4593
			special = jQuery.event.special[ event.type ] || {};                                                               // 4594
                                                                                                                     // 4595
		// Use the fix-ed jQuery.Event rather than the (read-only) native event                                            // 4596
		args[0] = event;                                                                                                   // 4597
		event.delegateTarget = this;                                                                                       // 4598
                                                                                                                     // 4599
		// Call the preDispatch hook for the mapped type, and let it bail if desired                                       // 4600
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {                                  // 4601
			return;                                                                                                           // 4602
		}                                                                                                                  // 4603
                                                                                                                     // 4604
		// Determine handlers                                                                                              // 4605
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );                                                // 4606
                                                                                                                     // 4607
		// Run delegates first; they may want to stop propagation beneath us                                               // 4608
		i = 0;                                                                                                             // 4609
		while ( (matched = handlerQueue[ i++ ]) && !event.isPropagationStopped() ) {                                       // 4610
			event.currentTarget = matched.elem;                                                                               // 4611
                                                                                                                     // 4612
			j = 0;                                                                                                            // 4613
			while ( (handleObj = matched.handlers[ j++ ]) && !event.isImmediatePropagationStopped() ) {                       // 4614
                                                                                                                     // 4615
				// Triggered event must either 1) have no namespace, or                                                          // 4616
				// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).              // 4617
				if ( !event.namespace_re || event.namespace_re.test( handleObj.namespace ) ) {                                   // 4618
                                                                                                                     // 4619
					event.handleObj = handleObj;                                                                                    // 4620
					event.data = handleObj.data;                                                                                    // 4621
                                                                                                                     // 4622
					ret = ( (jQuery.event.special[ handleObj.origType ] || {}).handle || handleObj.handler )                        // 4623
							.apply( matched.elem, args );                                                                                 // 4624
                                                                                                                     // 4625
					if ( ret !== undefined ) {                                                                                      // 4626
						if ( (event.result = ret) === false ) {                                                                        // 4627
							event.preventDefault();                                                                                       // 4628
							event.stopPropagation();                                                                                      // 4629
						}                                                                                                              // 4630
					}                                                                                                               // 4631
				}                                                                                                                // 4632
			}                                                                                                                 // 4633
		}                                                                                                                  // 4634
                                                                                                                     // 4635
		// Call the postDispatch hook for the mapped type                                                                  // 4636
		if ( special.postDispatch ) {                                                                                      // 4637
			special.postDispatch.call( this, event );                                                                         // 4638
		}                                                                                                                  // 4639
                                                                                                                     // 4640
		return event.result;                                                                                               // 4641
	},                                                                                                                  // 4642
                                                                                                                     // 4643
	handlers: function( event, handlers ) {                                                                             // 4644
		var sel, handleObj, matches, i,                                                                                    // 4645
			handlerQueue = [],                                                                                                // 4646
			delegateCount = handlers.delegateCount,                                                                           // 4647
			cur = event.target;                                                                                               // 4648
                                                                                                                     // 4649
		// Find delegate handlers                                                                                          // 4650
		// Black-hole SVG <use> instance trees (#13180)                                                                    // 4651
		// Avoid non-left-click bubbling in Firefox (#3861)                                                                // 4652
		if ( delegateCount && cur.nodeType && (!event.button || event.type !== "click") ) {                                // 4653
                                                                                                                     // 4654
			/* jshint eqeqeq: false */                                                                                        // 4655
			for ( ; cur != this; cur = cur.parentNode || this ) {                                                             // 4656
				/* jshint eqeqeq: true */                                                                                        // 4657
                                                                                                                     // 4658
				// Don't check non-elements (#13208)                                                                             // 4659
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)                                      // 4660
				if ( cur.nodeType === 1 && (cur.disabled !== true || event.type !== "click") ) {                                 // 4661
					matches = [];                                                                                                   // 4662
					for ( i = 0; i < delegateCount; i++ ) {                                                                         // 4663
						handleObj = handlers[ i ];                                                                                     // 4664
                                                                                                                     // 4665
						// Don't conflict with Object.prototype properties (#13203)                                                    // 4666
						sel = handleObj.selector + " ";                                                                                // 4667
                                                                                                                     // 4668
						if ( matches[ sel ] === undefined ) {                                                                          // 4669
							matches[ sel ] = handleObj.needsContext ?                                                                     // 4670
								jQuery( sel, this ).index( cur ) >= 0 :                                                                      // 4671
								jQuery.find( sel, this, null, [ cur ] ).length;                                                              // 4672
						}                                                                                                              // 4673
						if ( matches[ sel ] ) {                                                                                        // 4674
							matches.push( handleObj );                                                                                    // 4675
						}                                                                                                              // 4676
					}                                                                                                               // 4677
					if ( matches.length ) {                                                                                         // 4678
						handlerQueue.push({ elem: cur, handlers: matches });                                                           // 4679
					}                                                                                                               // 4680
				}                                                                                                                // 4681
			}                                                                                                                 // 4682
		}                                                                                                                  // 4683
                                                                                                                     // 4684
		// Add the remaining (directly-bound) handlers                                                                     // 4685
		if ( delegateCount < handlers.length ) {                                                                           // 4686
			handlerQueue.push({ elem: this, handlers: handlers.slice( delegateCount ) });                                     // 4687
		}                                                                                                                  // 4688
                                                                                                                     // 4689
		return handlerQueue;                                                                                               // 4690
	},                                                                                                                  // 4691
                                                                                                                     // 4692
	fix: function( event ) {                                                                                            // 4693
		if ( event[ jQuery.expando ] ) {                                                                                   // 4694
			return event;                                                                                                     // 4695
		}                                                                                                                  // 4696
                                                                                                                     // 4697
		// Create a writable copy of the event object and normalize some properties                                        // 4698
		var i, prop, copy,                                                                                                 // 4699
			type = event.type,                                                                                                // 4700
			originalEvent = event,                                                                                            // 4701
			fixHook = this.fixHooks[ type ];                                                                                  // 4702
                                                                                                                     // 4703
		if ( !fixHook ) {                                                                                                  // 4704
			this.fixHooks[ type ] = fixHook =                                                                                 // 4705
				rmouseEvent.test( type ) ? this.mouseHooks :                                                                     // 4706
				rkeyEvent.test( type ) ? this.keyHooks :                                                                         // 4707
				{};                                                                                                              // 4708
		}                                                                                                                  // 4709
		copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;                                            // 4710
                                                                                                                     // 4711
		event = new jQuery.Event( originalEvent );                                                                         // 4712
                                                                                                                     // 4713
		i = copy.length;                                                                                                   // 4714
		while ( i-- ) {                                                                                                    // 4715
			prop = copy[ i ];                                                                                                 // 4716
			event[ prop ] = originalEvent[ prop ];                                                                            // 4717
		}                                                                                                                  // 4718
                                                                                                                     // 4719
		// Support: IE<9                                                                                                   // 4720
		// Fix target property (#1925)                                                                                     // 4721
		if ( !event.target ) {                                                                                             // 4722
			event.target = originalEvent.srcElement || document;                                                              // 4723
		}                                                                                                                  // 4724
                                                                                                                     // 4725
		// Support: Chrome 23+, Safari?                                                                                    // 4726
		// Target should not be a text node (#504, #13143)                                                                 // 4727
		if ( event.target.nodeType === 3 ) {                                                                               // 4728
			event.target = event.target.parentNode;                                                                           // 4729
		}                                                                                                                  // 4730
                                                                                                                     // 4731
		// Support: IE<9                                                                                                   // 4732
		// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)                                          // 4733
		event.metaKey = !!event.metaKey;                                                                                   // 4734
                                                                                                                     // 4735
		return fixHook.filter ? fixHook.filter( event, originalEvent ) : event;                                            // 4736
	},                                                                                                                  // 4737
                                                                                                                     // 4738
	// Includes some event props shared by KeyEvent and MouseEvent                                                      // 4739
	props: "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),
                                                                                                                     // 4741
	fixHooks: {},                                                                                                       // 4742
                                                                                                                     // 4743
	keyHooks: {                                                                                                         // 4744
		props: "char charCode key keyCode".split(" "),                                                                     // 4745
		filter: function( event, original ) {                                                                              // 4746
                                                                                                                     // 4747
			// Add which for key events                                                                                       // 4748
			if ( event.which == null ) {                                                                                      // 4749
				event.which = original.charCode != null ? original.charCode : original.keyCode;                                  // 4750
			}                                                                                                                 // 4751
                                                                                                                     // 4752
			return event;                                                                                                     // 4753
		}                                                                                                                  // 4754
	},                                                                                                                  // 4755
                                                                                                                     // 4756
	mouseHooks: {                                                                                                       // 4757
		props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
		filter: function( event, original ) {                                                                              // 4759
			var body, eventDoc, doc,                                                                                          // 4760
				button = original.button,                                                                                        // 4761
				fromElement = original.fromElement;                                                                              // 4762
                                                                                                                     // 4763
			// Calculate pageX/Y if missing and clientX/Y available                                                           // 4764
			if ( event.pageX == null && original.clientX != null ) {                                                          // 4765
				eventDoc = event.target.ownerDocument || document;                                                               // 4766
				doc = eventDoc.documentElement;                                                                                  // 4767
				body = eventDoc.body;                                                                                            // 4768
                                                                                                                     // 4769
				event.pageX = original.clientX + ( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) - ( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY + ( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) - ( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}                                                                                                                 // 4772
                                                                                                                     // 4773
			// Add relatedTarget, if necessary                                                                                // 4774
			if ( !event.relatedTarget && fromElement ) {                                                                      // 4775
				event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;                           // 4776
			}                                                                                                                 // 4777
                                                                                                                     // 4778
			// Add which for click: 1 === left; 2 === middle; 3 === right                                                     // 4779
			// Note: button is not normalized, so don't use it                                                                // 4780
			if ( !event.which && button !== undefined ) {                                                                     // 4781
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );                                  // 4782
			}                                                                                                                 // 4783
                                                                                                                     // 4784
			return event;                                                                                                     // 4785
		}                                                                                                                  // 4786
	},                                                                                                                  // 4787
                                                                                                                     // 4788
	special: {                                                                                                          // 4789
		load: {                                                                                                            // 4790
			// Prevent triggered image.load events from bubbling to window.load                                               // 4791
			noBubble: true                                                                                                    // 4792
		},                                                                                                                 // 4793
		focus: {                                                                                                           // 4794
			// Fire native event if possible so blur/focus sequence is correct                                                // 4795
			trigger: function() {                                                                                             // 4796
				if ( this !== safeActiveElement() && this.focus ) {                                                              // 4797
					try {                                                                                                           // 4798
						this.focus();                                                                                                  // 4799
						return false;                                                                                                  // 4800
					} catch ( e ) {                                                                                                 // 4801
						// Support: IE<9                                                                                               // 4802
						// If we error on focus to hidden element (#1486, #12518),                                                     // 4803
						// let .trigger() run the handlers                                                                             // 4804
					}                                                                                                               // 4805
				}                                                                                                                // 4806
			},                                                                                                                // 4807
			delegateType: "focusin"                                                                                           // 4808
		},                                                                                                                 // 4809
		blur: {                                                                                                            // 4810
			trigger: function() {                                                                                             // 4811
				if ( this === safeActiveElement() && this.blur ) {                                                               // 4812
					this.blur();                                                                                                    // 4813
					return false;                                                                                                   // 4814
				}                                                                                                                // 4815
			},                                                                                                                // 4816
			delegateType: "focusout"                                                                                          // 4817
		},                                                                                                                 // 4818
		click: {                                                                                                           // 4819
			// For checkbox, fire native event so checked state will be right                                                 // 4820
			trigger: function() {                                                                                             // 4821
				if ( jQuery.nodeName( this, "input" ) && this.type === "checkbox" && this.click ) {                              // 4822
					this.click();                                                                                                   // 4823
					return false;                                                                                                   // 4824
				}                                                                                                                // 4825
			},                                                                                                                // 4826
                                                                                                                     // 4827
			// For cross-browser consistency, don't fire native .click() on links                                             // 4828
			_default: function( event ) {                                                                                     // 4829
				return jQuery.nodeName( event.target, "a" );                                                                     // 4830
			}                                                                                                                 // 4831
		},                                                                                                                 // 4832
                                                                                                                     // 4833
		beforeunload: {                                                                                                    // 4834
			postDispatch: function( event ) {                                                                                 // 4835
                                                                                                                     // 4836
				// Even when returnValue equals to undefined Firefox will still show alert                                       // 4837
				if ( event.result !== undefined ) {                                                                              // 4838
					event.originalEvent.returnValue = event.result;                                                                 // 4839
				}                                                                                                                // 4840
			}                                                                                                                 // 4841
		}                                                                                                                  // 4842
	},                                                                                                                  // 4843
                                                                                                                     // 4844
	simulate: function( type, elem, event, bubble ) {                                                                   // 4845
		// Piggyback on a donor event to simulate a different one.                                                         // 4846
		// Fake originalEvent to avoid donor's stopPropagation, but if the                                                 // 4847
		// simulated event prevents default then we do the same on the donor.                                              // 4848
		var e = jQuery.extend(                                                                                             // 4849
			new jQuery.Event(),                                                                                               // 4850
			event,                                                                                                            // 4851
			{                                                                                                                 // 4852
				type: type,                                                                                                      // 4853
				isSimulated: true,                                                                                               // 4854
				originalEvent: {}                                                                                                // 4855
			}                                                                                                                 // 4856
		);                                                                                                                 // 4857
		if ( bubble ) {                                                                                                    // 4858
			jQuery.event.trigger( e, null, elem );                                                                            // 4859
		} else {                                                                                                           // 4860
			jQuery.event.dispatch.call( elem, e );                                                                            // 4861
		}                                                                                                                  // 4862
		if ( e.isDefaultPrevented() ) {                                                                                    // 4863
			event.preventDefault();                                                                                           // 4864
		}                                                                                                                  // 4865
	}                                                                                                                   // 4866
};                                                                                                                   // 4867
                                                                                                                     // 4868
jQuery.removeEvent = document.removeEventListener ?                                                                  // 4869
	function( elem, type, handle ) {                                                                                    // 4870
		if ( elem.removeEventListener ) {                                                                                  // 4871
			elem.removeEventListener( type, handle, false );                                                                  // 4872
		}                                                                                                                  // 4873
	} :                                                                                                                 // 4874
	function( elem, type, handle ) {                                                                                    // 4875
		var name = "on" + type;                                                                                            // 4876
                                                                                                                     // 4877
		if ( elem.detachEvent ) {                                                                                          // 4878
                                                                                                                     // 4879
			// #8545, #7054, preventing memory leaks for custom events in IE6-8                                               // 4880
			// detachEvent needed property on element, by name of that event, to properly expose it to GC                     // 4881
			if ( typeof elem[ name ] === strundefined ) {                                                                     // 4882
				elem[ name ] = null;                                                                                             // 4883
			}                                                                                                                 // 4884
                                                                                                                     // 4885
			elem.detachEvent( name, handle );                                                                                 // 4886
		}                                                                                                                  // 4887
	};                                                                                                                  // 4888
                                                                                                                     // 4889
jQuery.Event = function( src, props ) {                                                                              // 4890
	// Allow instantiation without the 'new' keyword                                                                    // 4891
	if ( !(this instanceof jQuery.Event) ) {                                                                            // 4892
		return new jQuery.Event( src, props );                                                                             // 4893
	}                                                                                                                   // 4894
                                                                                                                     // 4895
	// Event object                                                                                                     // 4896
	if ( src && src.type ) {                                                                                            // 4897
		this.originalEvent = src;                                                                                          // 4898
		this.type = src.type;                                                                                              // 4899
                                                                                                                     // 4900
		// Events bubbling up the document may have been marked as prevented                                               // 4901
		// by a handler lower down the tree; reflect the correct value.                                                    // 4902
		this.isDefaultPrevented = src.defaultPrevented ||                                                                  // 4903
				src.defaultPrevented === undefined && (                                                                          // 4904
				// Support: IE < 9                                                                                               // 4905
				src.returnValue === false ||                                                                                     // 4906
				// Support: Android < 4.0                                                                                        // 4907
				src.getPreventDefault && src.getPreventDefault() ) ?                                                             // 4908
			returnTrue :                                                                                                      // 4909
			returnFalse;                                                                                                      // 4910
                                                                                                                     // 4911
	// Event type                                                                                                       // 4912
	} else {                                                                                                            // 4913
		this.type = src;                                                                                                   // 4914
	}                                                                                                                   // 4915
                                                                                                                     // 4916
	// Put explicitly provided properties onto the event object                                                         // 4917
	if ( props ) {                                                                                                      // 4918
		jQuery.extend( this, props );                                                                                      // 4919
	}                                                                                                                   // 4920
                                                                                                                     // 4921
	// Create a timestamp if incoming event doesn't have one                                                            // 4922
	this.timeStamp = src && src.timeStamp || jQuery.now();                                                              // 4923
                                                                                                                     // 4924
	// Mark it as fixed                                                                                                 // 4925
	this[ jQuery.expando ] = true;                                                                                      // 4926
};                                                                                                                   // 4927
                                                                                                                     // 4928
// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding                              // 4929
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html                                 // 4930
jQuery.Event.prototype = {                                                                                           // 4931
	isDefaultPrevented: returnFalse,                                                                                    // 4932
	isPropagationStopped: returnFalse,                                                                                  // 4933
	isImmediatePropagationStopped: returnFalse,                                                                         // 4934
                                                                                                                     // 4935
	preventDefault: function() {                                                                                        // 4936
		var e = this.originalEvent;                                                                                        // 4937
                                                                                                                     // 4938
		this.isDefaultPrevented = returnTrue;                                                                              // 4939
		if ( !e ) {                                                                                                        // 4940
			return;                                                                                                           // 4941
		}                                                                                                                  // 4942
                                                                                                                     // 4943
		// If preventDefault exists, run it on the original event                                                          // 4944
		if ( e.preventDefault ) {                                                                                          // 4945
			e.preventDefault();                                                                                               // 4946
                                                                                                                     // 4947
		// Support: IE                                                                                                     // 4948
		// Otherwise set the returnValue property of the original event to false                                           // 4949
		} else {                                                                                                           // 4950
			e.returnValue = false;                                                                                            // 4951
		}                                                                                                                  // 4952
	},                                                                                                                  // 4953
	stopPropagation: function() {                                                                                       // 4954
		var e = this.originalEvent;                                                                                        // 4955
                                                                                                                     // 4956
		this.isPropagationStopped = returnTrue;                                                                            // 4957
		if ( !e ) {                                                                                                        // 4958
			return;                                                                                                           // 4959
		}                                                                                                                  // 4960
		// If stopPropagation exists, run it on the original event                                                         // 4961
		if ( e.stopPropagation ) {                                                                                         // 4962
			e.stopPropagation();                                                                                              // 4963
		}                                                                                                                  // 4964
                                                                                                                     // 4965
		// Support: IE                                                                                                     // 4966
		// Set the cancelBubble property of the original event to true                                                     // 4967
		e.cancelBubble = true;                                                                                             // 4968
	},                                                                                                                  // 4969
	stopImmediatePropagation: function() {                                                                              // 4970
		this.isImmediatePropagationStopped = returnTrue;                                                                   // 4971
		this.stopPropagation();                                                                                            // 4972
	}                                                                                                                   // 4973
};                                                                                                                   // 4974
                                                                                                                     // 4975
// Create mouseenter/leave events using mouseover/out and event-time checks                                          // 4976
jQuery.each({                                                                                                        // 4977
	mouseenter: "mouseover",                                                                                            // 4978
	mouseleave: "mouseout"                                                                                              // 4979
}, function( orig, fix ) {                                                                                           // 4980
	jQuery.event.special[ orig ] = {                                                                                    // 4981
		delegateType: fix,                                                                                                 // 4982
		bindType: fix,                                                                                                     // 4983
                                                                                                                     // 4984
		handle: function( event ) {                                                                                        // 4985
			var ret,                                                                                                          // 4986
				target = this,                                                                                                   // 4987
				related = event.relatedTarget,                                                                                   // 4988
				handleObj = event.handleObj;                                                                                     // 4989
                                                                                                                     // 4990
			// For mousenter/leave call the handler if related is outside the target.                                         // 4991
			// NB: No relatedTarget if the mouse left/entered the browser window                                              // 4992
			if ( !related || (related !== target && !jQuery.contains( target, related )) ) {                                  // 4993
				event.type = handleObj.origType;                                                                                 // 4994
				ret = handleObj.handler.apply( this, arguments );                                                                // 4995
				event.type = fix;                                                                                                // 4996
			}                                                                                                                 // 4997
			return ret;                                                                                                       // 4998
		}                                                                                                                  // 4999
	};                                                                                                                  // 5000
});                                                                                                                  // 5001
                                                                                                                     // 5002
// IE submit delegation                                                                                              // 5003
if ( !support.submitBubbles ) {                                                                                      // 5004
                                                                                                                     // 5005
	jQuery.event.special.submit = {                                                                                     // 5006
		setup: function() {                                                                                                // 5007
			// Only need this for delegated form submit events                                                                // 5008
			if ( jQuery.nodeName( this, "form" ) ) {                                                                          // 5009
				return false;                                                                                                    // 5010
			}                                                                                                                 // 5011
                                                                                                                     // 5012
			// Lazy-add a submit handler when a descendant form may potentially be submitted                                  // 5013
			jQuery.event.add( this, "click._submit keypress._submit", function( e ) {                                         // 5014
				// Node name check avoids a VML-related crash in IE (#9807)                                                      // 5015
				var elem = e.target,                                                                                             // 5016
					form = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.form : undefined;           // 5017
				if ( form && !jQuery._data( form, "submitBubbles" ) ) {                                                          // 5018
					jQuery.event.add( form, "submit._submit", function( event ) {                                                   // 5019
						event._submit_bubble = true;                                                                                   // 5020
					});                                                                                                             // 5021
					jQuery._data( form, "submitBubbles", true );                                                                    // 5022
				}                                                                                                                // 5023
			});                                                                                                               // 5024
			// return undefined since we don't need an event listener                                                         // 5025
		},                                                                                                                 // 5026
                                                                                                                     // 5027
		postDispatch: function( event ) {                                                                                  // 5028
			// If form was submitted by the user, bubble the event up the tree                                                // 5029
			if ( event._submit_bubble ) {                                                                                     // 5030
				delete event._submit_bubble;                                                                                     // 5031
				if ( this.parentNode && !event.isTrigger ) {                                                                     // 5032
					jQuery.event.simulate( "submit", this.parentNode, event, true );                                                // 5033
				}                                                                                                                // 5034
			}                                                                                                                 // 5035
		},                                                                                                                 // 5036
                                                                                                                     // 5037
		teardown: function() {                                                                                             // 5038
			// Only need this for delegated form submit events                                                                // 5039
			if ( jQuery.nodeName( this, "form" ) ) {                                                                          // 5040
				return false;                                                                                                    // 5041
			}                                                                                                                 // 5042
                                                                                                                     // 5043
			// Remove delegated handlers; cleanData eventually reaps submit handlers attached above                           // 5044
			jQuery.event.remove( this, "._submit" );                                                                          // 5045
		}                                                                                                                  // 5046
	};                                                                                                                  // 5047
}                                                                                                                    // 5048
                                                                                                                     // 5049
// IE change delegation and checkbox/radio fix                                                                       // 5050
if ( !support.changeBubbles ) {                                                                                      // 5051
                                                                                                                     // 5052
	jQuery.event.special.change = {                                                                                     // 5053
                                                                                                                     // 5054
		setup: function() {                                                                                                // 5055
                                                                                                                     // 5056
			if ( rformElems.test( this.nodeName ) ) {                                                                         // 5057
				// IE doesn't fire change on a check/radio until blur; trigger it on click                                       // 5058
				// after a propertychange. Eat the blur-change in special.change.handle.                                         // 5059
				// This still fires onchange a second time for check/radio after blur.                                           // 5060
				if ( this.type === "checkbox" || this.type === "radio" ) {                                                       // 5061
					jQuery.event.add( this, "propertychange._change", function( event ) {                                           // 5062
						if ( event.originalEvent.propertyName === "checked" ) {                                                        // 5063
							this._just_changed = true;                                                                                    // 5064
						}                                                                                                              // 5065
					});                                                                                                             // 5066
					jQuery.event.add( this, "click._change", function( event ) {                                                    // 5067
						if ( this._just_changed && !event.isTrigger ) {                                                                // 5068
							this._just_changed = false;                                                                                   // 5069
						}                                                                                                              // 5070
						// Allow triggered, simulated change events (#11500)                                                           // 5071
						jQuery.event.simulate( "change", this, event, true );                                                          // 5072
					});                                                                                                             // 5073
				}                                                                                                                // 5074
				return false;                                                                                                    // 5075
			}                                                                                                                 // 5076
			// Delegated event; lazy-add a change handler on descendant inputs                                                // 5077
			jQuery.event.add( this, "beforeactivate._change", function( e ) {                                                 // 5078
				var elem = e.target;                                                                                             // 5079
                                                                                                                     // 5080
				if ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, "changeBubbles" ) ) {                              // 5081
					jQuery.event.add( elem, "change._change", function( event ) {                                                   // 5082
						if ( this.parentNode && !event.isSimulated && !event.isTrigger ) {                                             // 5083
							jQuery.event.simulate( "change", this.parentNode, event, true );                                              // 5084
						}                                                                                                              // 5085
					});                                                                                                             // 5086
					jQuery._data( elem, "changeBubbles", true );                                                                    // 5087
				}                                                                                                                // 5088
			});                                                                                                               // 5089
		},                                                                                                                 // 5090
                                                                                                                     // 5091
		handle: function( event ) {                                                                                        // 5092
			var elem = event.target;                                                                                          // 5093
                                                                                                                     // 5094
			// Swallow native change events from checkbox/radio, we already triggered them above                              // 5095
			if ( this !== elem || event.isSimulated || event.isTrigger || (elem.type !== "radio" && elem.type !== "checkbox") ) {
				return event.handleObj.handler.apply( this, arguments );                                                         // 5097
			}                                                                                                                 // 5098
		},                                                                                                                 // 5099
                                                                                                                     // 5100
		teardown: function() {                                                                                             // 5101
			jQuery.event.remove( this, "._change" );                                                                          // 5102
                                                                                                                     // 5103
			return !rformElems.test( this.nodeName );                                                                         // 5104
		}                                                                                                                  // 5105
	};                                                                                                                  // 5106
}                                                                                                                    // 5107
                                                                                                                     // 5108
// Create "bubbling" focus and blur events                                                                           // 5109
if ( !support.focusinBubbles ) {                                                                                     // 5110
	jQuery.each({ focus: "focusin", blur: "focusout" }, function( orig, fix ) {                                         // 5111
                                                                                                                     // 5112
		// Attach a single capturing handler on the document while someone wants focusin/focusout                          // 5113
		var handler = function( event ) {                                                                                  // 5114
				jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ), true );                                     // 5115
			};                                                                                                                // 5116
                                                                                                                     // 5117
		jQuery.event.special[ fix ] = {                                                                                    // 5118
			setup: function() {                                                                                               // 5119
				var doc = this.ownerDocument || this,                                                                            // 5120
					attaches = jQuery._data( doc, fix );                                                                            // 5121
                                                                                                                     // 5122
				if ( !attaches ) {                                                                                               // 5123
					doc.addEventListener( orig, handler, true );                                                                    // 5124
				}                                                                                                                // 5125
				jQuery._data( doc, fix, ( attaches || 0 ) + 1 );                                                                 // 5126
			},                                                                                                                // 5127
			teardown: function() {                                                                                            // 5128
				var doc = this.ownerDocument || this,                                                                            // 5129
					attaches = jQuery._data( doc, fix ) - 1;                                                                        // 5130
                                                                                                                     // 5131
				if ( !attaches ) {                                                                                               // 5132
					doc.removeEventListener( orig, handler, true );                                                                 // 5133
					jQuery._removeData( doc, fix );                                                                                 // 5134
				} else {                                                                                                         // 5135
					jQuery._data( doc, fix, attaches );                                                                             // 5136
				}                                                                                                                // 5137
			}                                                                                                                 // 5138
		};                                                                                                                 // 5139
	});                                                                                                                 // 5140
}                                                                                                                    // 5141
                                                                                                                     // 5142
jQuery.fn.extend({                                                                                                   // 5143
                                                                                                                     // 5144
	on: function( types, selector, data, fn, /*INTERNAL*/ one ) {                                                       // 5145
		var type, origFn;                                                                                                  // 5146
                                                                                                                     // 5147
		// Types can be a map of types/handlers                                                                            // 5148
		if ( typeof types === "object" ) {                                                                                 // 5149
			// ( types-Object, selector, data )                                                                               // 5150
			if ( typeof selector !== "string" ) {                                                                             // 5151
				// ( types-Object, data )                                                                                        // 5152
				data = data || selector;                                                                                         // 5153
				selector = undefined;                                                                                            // 5154
			}                                                                                                                 // 5155
			for ( type in types ) {                                                                                           // 5156
				this.on( type, selector, data, types[ type ], one );                                                             // 5157
			}                                                                                                                 // 5158
			return this;                                                                                                      // 5159
		}                                                                                                                  // 5160
                                                                                                                     // 5161
		if ( data == null && fn == null ) {                                                                                // 5162
			// ( types, fn )                                                                                                  // 5163
			fn = selector;                                                                                                    // 5164
			data = selector = undefined;                                                                                      // 5165
		} else if ( fn == null ) {                                                                                         // 5166
			if ( typeof selector === "string" ) {                                                                             // 5167
				// ( types, selector, fn )                                                                                       // 5168
				fn = data;                                                                                                       // 5169
				data = undefined;                                                                                                // 5170
			} else {                                                                                                          // 5171
				// ( types, data, fn )                                                                                           // 5172
				fn = data;                                                                                                       // 5173
				data = selector;                                                                                                 // 5174
				selector = undefined;                                                                                            // 5175
			}                                                                                                                 // 5176
		}                                                                                                                  // 5177
		if ( fn === false ) {                                                                                              // 5178
			fn = returnFalse;                                                                                                 // 5179
		} else if ( !fn ) {                                                                                                // 5180
			return this;                                                                                                      // 5181
		}                                                                                                                  // 5182
                                                                                                                     // 5183
		if ( one === 1 ) {                                                                                                 // 5184
			origFn = fn;                                                                                                      // 5185
			fn = function( event ) {                                                                                          // 5186
				// Can use an empty set, since event contains the info                                                           // 5187
				jQuery().off( event );                                                                                           // 5188
				return origFn.apply( this, arguments );                                                                          // 5189
			};                                                                                                                // 5190
			// Use same guid so caller can remove using origFn                                                                // 5191
			fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );                                                         // 5192
		}                                                                                                                  // 5193
		return this.each( function() {                                                                                     // 5194
			jQuery.event.add( this, types, fn, data, selector );                                                              // 5195
		});                                                                                                                // 5196
	},                                                                                                                  // 5197
	one: function( types, selector, data, fn ) {                                                                        // 5198
		return this.on( types, selector, data, fn, 1 );                                                                    // 5199
	},                                                                                                                  // 5200
	off: function( types, selector, fn ) {                                                                              // 5201
		var handleObj, type;                                                                                               // 5202
		if ( types && types.preventDefault && types.handleObj ) {                                                          // 5203
			// ( event )  dispatched jQuery.Event                                                                             // 5204
			handleObj = types.handleObj;                                                                                      // 5205
			jQuery( types.delegateTarget ).off(                                                                               // 5206
				handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,                       // 5207
				handleObj.selector,                                                                                              // 5208
				handleObj.handler                                                                                                // 5209
			);                                                                                                                // 5210
			return this;                                                                                                      // 5211
		}                                                                                                                  // 5212
		if ( typeof types === "object" ) {                                                                                 // 5213
			// ( types-object [, selector] )                                                                                  // 5214
			for ( type in types ) {                                                                                           // 5215
				this.off( type, selector, types[ type ] );                                                                       // 5216
			}                                                                                                                 // 5217
			return this;                                                                                                      // 5218
		}                                                                                                                  // 5219
		if ( selector === false || typeof selector === "function" ) {                                                      // 5220
			// ( types [, fn] )                                                                                               // 5221
			fn = selector;                                                                                                    // 5222
			selector = undefined;                                                                                             // 5223
		}                                                                                                                  // 5224
		if ( fn === false ) {                                                                                              // 5225
			fn = returnFalse;                                                                                                 // 5226
		}                                                                                                                  // 5227
		return this.each(function() {                                                                                      // 5228
			jQuery.event.remove( this, types, fn, selector );                                                                 // 5229
		});                                                                                                                // 5230
	},                                                                                                                  // 5231
                                                                                                                     // 5232
	trigger: function( type, data ) {                                                                                   // 5233
		return this.each(function() {                                                                                      // 5234
			jQuery.event.trigger( type, data, this );                                                                         // 5235
		});                                                                                                                // 5236
	},                                                                                                                  // 5237
	triggerHandler: function( type, data ) {                                                                            // 5238
		var elem = this[0];                                                                                                // 5239
		if ( elem ) {                                                                                                      // 5240
			return jQuery.event.trigger( type, data, elem, true );                                                            // 5241
		}                                                                                                                  // 5242
	}                                                                                                                   // 5243
});                                                                                                                  // 5244
                                                                                                                     // 5245
                                                                                                                     // 5246
function createSafeFragment( document ) {                                                                            // 5247
	var list = nodeNames.split( "|" ),                                                                                  // 5248
		safeFrag = document.createDocumentFragment();                                                                      // 5249
                                                                                                                     // 5250
	if ( safeFrag.createElement ) {                                                                                     // 5251
		while ( list.length ) {                                                                                            // 5252
			safeFrag.createElement(                                                                                           // 5253
				list.pop()                                                                                                       // 5254
			);                                                                                                                // 5255
		}                                                                                                                  // 5256
	}                                                                                                                   // 5257
	return safeFrag;                                                                                                    // 5258
}                                                                                                                    // 5259
                                                                                                                     // 5260
var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +              // 5261
		"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",                                         // 5262
	rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g,                                                                       // 5263
	rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),                                                    // 5264
	rleadingWhitespace = /^\s+/,                                                                                        // 5265
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,                              // 5266
	rtagName = /<([\w:]+)/,                                                                                             // 5267
	rtbody = /<tbody/i,                                                                                                 // 5268
	rhtml = /<|&#?\w+;/,                                                                                                // 5269
	rnoInnerhtml = /<(?:script|style|link)/i,                                                                           // 5270
	// checked="checked" or checked                                                                                     // 5271
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,                                                                     // 5272
	rscriptType = /^$|\/(?:java|ecma)script/i,                                                                          // 5273
	rscriptTypeMasked = /^true\/(.*)/,                                                                                  // 5274
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,                                                          // 5275
                                                                                                                     // 5276
	// We have to close these tags to support XHTML (#13200)                                                            // 5277
	wrapMap = {                                                                                                         // 5278
		option: [ 1, "<select multiple='multiple'>", "</select>" ],                                                        // 5279
		legend: [ 1, "<fieldset>", "</fieldset>" ],                                                                        // 5280
		area: [ 1, "<map>", "</map>" ],                                                                                    // 5281
		param: [ 1, "<object>", "</object>" ],                                                                             // 5282
		thead: [ 1, "<table>", "</table>" ],                                                                               // 5283
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],                                                                   // 5284
		col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],                                             // 5285
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],                                                          // 5286
                                                                                                                     // 5287
		// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,                                         // 5288
		// unless wrapped in a div with non-breaking characters in front of it.                                            // 5289
		_default: support.htmlSerialize ? [ 0, "", "" ] : [ 1, "X<div>", "</div>"  ]                                       // 5290
	},                                                                                                                  // 5291
	safeFragment = createSafeFragment( document ),                                                                      // 5292
	fragmentDiv = safeFragment.appendChild( document.createElement("div") );                                            // 5293
                                                                                                                     // 5294
wrapMap.optgroup = wrapMap.option;                                                                                   // 5295
wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;                                  // 5296
wrapMap.th = wrapMap.td;                                                                                             // 5297
                                                                                                                     // 5298
function getAll( context, tag ) {                                                                                    // 5299
	var elems, elem,                                                                                                    // 5300
		i = 0,                                                                                                             // 5301
		found = typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName( tag || "*" ) :        // 5302
			typeof context.querySelectorAll !== strundefined ? context.querySelectorAll( tag || "*" ) :                       // 5303
			undefined;                                                                                                        // 5304
                                                                                                                     // 5305
	if ( !found ) {                                                                                                     // 5306
		for ( found = [], elems = context.childNodes || context; (elem = elems[i]) != null; i++ ) {                        // 5307
			if ( !tag || jQuery.nodeName( elem, tag ) ) {                                                                     // 5308
				found.push( elem );                                                                                              // 5309
			} else {                                                                                                          // 5310
				jQuery.merge( found, getAll( elem, tag ) );                                                                      // 5311
			}                                                                                                                 // 5312
		}                                                                                                                  // 5313
	}                                                                                                                   // 5314
                                                                                                                     // 5315
	return tag === undefined || tag && jQuery.nodeName( context, tag ) ?                                                // 5316
		jQuery.merge( [ context ], found ) :                                                                               // 5317
		found;                                                                                                             // 5318
}                                                                                                                    // 5319
                                                                                                                     // 5320
// Used in buildFragment, fixes the defaultChecked property                                                          // 5321
function fixDefaultChecked( elem ) {                                                                                 // 5322
	if ( rcheckableType.test( elem.type ) ) {                                                                           // 5323
		elem.defaultChecked = elem.checked;                                                                                // 5324
	}                                                                                                                   // 5325
}                                                                                                                    // 5326
                                                                                                                     // 5327
// Support: IE<8                                                                                                     // 5328
// Manipulating tables requires a tbody                                                                              // 5329
function manipulationTarget( elem, content ) {                                                                       // 5330
	return jQuery.nodeName( elem, "table" ) &&                                                                          // 5331
		jQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ?                                  // 5332
                                                                                                                     // 5333
		elem.getElementsByTagName("tbody")[0] ||                                                                           // 5334
			elem.appendChild( elem.ownerDocument.createElement("tbody") ) :                                                   // 5335
		elem;                                                                                                              // 5336
}                                                                                                                    // 5337
                                                                                                                     // 5338
// Replace/restore the type attribute of script elements for safe DOM manipulation                                   // 5339
function disableScript( elem ) {                                                                                     // 5340
	elem.type = (jQuery.find.attr( elem, "type" ) !== null) + "/" + elem.type;                                          // 5341
	return elem;                                                                                                        // 5342
}                                                                                                                    // 5343
function restoreScript( elem ) {                                                                                     // 5344
	var match = rscriptTypeMasked.exec( elem.type );                                                                    // 5345
	if ( match ) {                                                                                                      // 5346
		elem.type = match[1];                                                                                              // 5347
	} else {                                                                                                            // 5348
		elem.removeAttribute("type");                                                                                      // 5349
	}                                                                                                                   // 5350
	return elem;                                                                                                        // 5351
}                                                                                                                    // 5352
                                                                                                                     // 5353
// Mark scripts as having already been evaluated                                                                     // 5354
function setGlobalEval( elems, refElements ) {                                                                       // 5355
	var elem,                                                                                                           // 5356
		i = 0;                                                                                                             // 5357
	for ( ; (elem = elems[i]) != null; i++ ) {                                                                          // 5358
		jQuery._data( elem, "globalEval", !refElements || jQuery._data( refElements[i], "globalEval" ) );                  // 5359
	}                                                                                                                   // 5360
}                                                                                                                    // 5361
                                                                                                                     // 5362
function cloneCopyEvent( src, dest ) {                                                                               // 5363
                                                                                                                     // 5364
	if ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {                                                              // 5365
		return;                                                                                                            // 5366
	}                                                                                                                   // 5367
                                                                                                                     // 5368
	var type, i, l,                                                                                                     // 5369
		oldData = jQuery._data( src ),                                                                                     // 5370
		curData = jQuery._data( dest, oldData ),                                                                           // 5371
		events = oldData.events;                                                                                           // 5372
                                                                                                                     // 5373
	if ( events ) {                                                                                                     // 5374
		delete curData.handle;                                                                                             // 5375
		curData.events = {};                                                                                               // 5376
                                                                                                                     // 5377
		for ( type in events ) {                                                                                           // 5378
			for ( i = 0, l = events[ type ].length; i < l; i++ ) {                                                            // 5379
				jQuery.event.add( dest, type, events[ type ][ i ] );                                                             // 5380
			}                                                                                                                 // 5381
		}                                                                                                                  // 5382
	}                                                                                                                   // 5383
                                                                                                                     // 5384
	// make the cloned public data object a copy from the original                                                      // 5385
	if ( curData.data ) {                                                                                               // 5386
		curData.data = jQuery.extend( {}, curData.data );                                                                  // 5387
	}                                                                                                                   // 5388
}                                                                                                                    // 5389
                                                                                                                     // 5390
function fixCloneNodeIssues( src, dest ) {                                                                           // 5391
	var nodeName, e, data;                                                                                              // 5392
                                                                                                                     // 5393
	// We do not need to do anything for non-Elements                                                                   // 5394
	if ( dest.nodeType !== 1 ) {                                                                                        // 5395
		return;                                                                                                            // 5396
	}                                                                                                                   // 5397
                                                                                                                     // 5398
	nodeName = dest.nodeName.toLowerCase();                                                                             // 5399
                                                                                                                     // 5400
	// IE6-8 copies events bound via attachEvent when using cloneNode.                                                  // 5401
	if ( !support.noCloneEvent && dest[ jQuery.expando ] ) {                                                            // 5402
		data = jQuery._data( dest );                                                                                       // 5403
                                                                                                                     // 5404
		for ( e in data.events ) {                                                                                         // 5405
			jQuery.removeEvent( dest, e, data.handle );                                                                       // 5406
		}                                                                                                                  // 5407
                                                                                                                     // 5408
		// Event data gets referenced instead of copied if the expando gets copied too                                     // 5409
		dest.removeAttribute( jQuery.expando );                                                                            // 5410
	}                                                                                                                   // 5411
                                                                                                                     // 5412
	// IE blanks contents when cloning scripts, and tries to evaluate newly-set text                                    // 5413
	if ( nodeName === "script" && dest.text !== src.text ) {                                                            // 5414
		disableScript( dest ).text = src.text;                                                                             // 5415
		restoreScript( dest );                                                                                             // 5416
                                                                                                                     // 5417
	// IE6-10 improperly clones children of object elements using classid.                                              // 5418
	// IE10 throws NoModificationAllowedError if parent is null, #12132.                                                // 5419
	} else if ( nodeName === "object" ) {                                                                               // 5420
		if ( dest.parentNode ) {                                                                                           // 5421
			dest.outerHTML = src.outerHTML;                                                                                   // 5422
		}                                                                                                                  // 5423
                                                                                                                     // 5424
		// This path appears unavoidable for IE9. When cloning an object                                                   // 5425
		// element in IE9, the outerHTML strategy above is not sufficient.                                                 // 5426
		// If the src has innerHTML and the destination does not,                                                          // 5427
		// copy the src.innerHTML into the dest.innerHTML. #10324                                                          // 5428
		if ( support.html5Clone && ( src.innerHTML && !jQuery.trim(dest.innerHTML) ) ) {                                   // 5429
			dest.innerHTML = src.innerHTML;                                                                                   // 5430
		}                                                                                                                  // 5431
                                                                                                                     // 5432
	} else if ( nodeName === "input" && rcheckableType.test( src.type ) ) {                                             // 5433
		// IE6-8 fails to persist the checked state of a cloned checkbox                                                   // 5434
		// or radio button. Worse, IE6-7 fail to give the cloned element                                                   // 5435
		// a checked appearance if the defaultChecked value isn't also set                                                 // 5436
                                                                                                                     // 5437
		dest.defaultChecked = dest.checked = src.checked;                                                                  // 5438
                                                                                                                     // 5439
		// IE6-7 get confused and end up setting the value of a cloned                                                     // 5440
		// checkbox/radio button to an empty string instead of "on"                                                        // 5441
		if ( dest.value !== src.value ) {                                                                                  // 5442
			dest.value = src.value;                                                                                           // 5443
		}                                                                                                                  // 5444
                                                                                                                     // 5445
	// IE6-8 fails to return the selected option to the default selected                                                // 5446
	// state when cloning options                                                                                       // 5447
	} else if ( nodeName === "option" ) {                                                                               // 5448
		dest.defaultSelected = dest.selected = src.defaultSelected;                                                        // 5449
                                                                                                                     // 5450
	// IE6-8 fails to set the defaultValue to the correct value when                                                    // 5451
	// cloning other types of input fields                                                                              // 5452
	} else if ( nodeName === "input" || nodeName === "textarea" ) {                                                     // 5453
		dest.defaultValue = src.defaultValue;                                                                              // 5454
	}                                                                                                                   // 5455
}                                                                                                                    // 5456
                                                                                                                     // 5457
jQuery.extend({                                                                                                      // 5458
	clone: function( elem, dataAndEvents, deepDataAndEvents ) {                                                         // 5459
		var destElements, node, clone, i, srcElements,                                                                     // 5460
			inPage = jQuery.contains( elem.ownerDocument, elem );                                                             // 5461
                                                                                                                     // 5462
		if ( support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test( "<" + elem.nodeName + ">" ) ) {            // 5463
			clone = elem.cloneNode( true );                                                                                   // 5464
                                                                                                                     // 5465
		// IE<=8 does not properly clone detached, unknown element nodes                                                   // 5466
		} else {                                                                                                           // 5467
			fragmentDiv.innerHTML = elem.outerHTML;                                                                           // 5468
			fragmentDiv.removeChild( clone = fragmentDiv.firstChild );                                                        // 5469
		}                                                                                                                  // 5470
                                                                                                                     // 5471
		if ( (!support.noCloneEvent || !support.noCloneChecked) &&                                                         // 5472
				(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {                                      // 5473
                                                                                                                     // 5474
			// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2                            // 5475
			destElements = getAll( clone );                                                                                   // 5476
			srcElements = getAll( elem );                                                                                     // 5477
                                                                                                                     // 5478
			// Fix all IE cloning issues                                                                                      // 5479
			for ( i = 0; (node = srcElements[i]) != null; ++i ) {                                                             // 5480
				// Ensure that the destination node is not null; Fixes #9587                                                     // 5481
				if ( destElements[i] ) {                                                                                         // 5482
					fixCloneNodeIssues( node, destElements[i] );                                                                    // 5483
				}                                                                                                                // 5484
			}                                                                                                                 // 5485
		}                                                                                                                  // 5486
                                                                                                                     // 5487
		// Copy the events from the original to the clone                                                                  // 5488
		if ( dataAndEvents ) {                                                                                             // 5489
			if ( deepDataAndEvents ) {                                                                                        // 5490
				srcElements = srcElements || getAll( elem );                                                                     // 5491
				destElements = destElements || getAll( clone );                                                                  // 5492
                                                                                                                     // 5493
				for ( i = 0; (node = srcElements[i]) != null; i++ ) {                                                            // 5494
					cloneCopyEvent( node, destElements[i] );                                                                        // 5495
				}                                                                                                                // 5496
			} else {                                                                                                          // 5497
				cloneCopyEvent( elem, clone );                                                                                   // 5498
			}                                                                                                                 // 5499
		}                                                                                                                  // 5500
                                                                                                                     // 5501
		// Preserve script evaluation history                                                                              // 5502
		destElements = getAll( clone, "script" );                                                                          // 5503
		if ( destElements.length > 0 ) {                                                                                   // 5504
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );                                               // 5505
		}                                                                                                                  // 5506
                                                                                                                     // 5507
		destElements = srcElements = node = null;                                                                          // 5508
                                                                                                                     // 5509
		// Return the cloned set                                                                                           // 5510
		return clone;                                                                                                      // 5511
	},                                                                                                                  // 5512
                                                                                                                     // 5513
	buildFragment: function( elems, context, scripts, selection ) {                                                     // 5514
		var j, elem, contains,                                                                                             // 5515
			tmp, tag, tbody, wrap,                                                                                            // 5516
			l = elems.length,                                                                                                 // 5517
                                                                                                                     // 5518
			// Ensure a safe fragment                                                                                         // 5519
			safe = createSafeFragment( context ),                                                                             // 5520
                                                                                                                     // 5521
			nodes = [],                                                                                                       // 5522
			i = 0;                                                                                                            // 5523
                                                                                                                     // 5524
		for ( ; i < l; i++ ) {                                                                                             // 5525
			elem = elems[ i ];                                                                                                // 5526
                                                                                                                     // 5527
			if ( elem || elem === 0 ) {                                                                                       // 5528
                                                                                                                     // 5529
				// Add nodes directly                                                                                            // 5530
				if ( jQuery.type( elem ) === "object" ) {                                                                        // 5531
					jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );                                                         // 5532
                                                                                                                     // 5533
				// Convert non-html into a text node                                                                             // 5534
				} else if ( !rhtml.test( elem ) ) {                                                                              // 5535
					nodes.push( context.createTextNode( elem ) );                                                                   // 5536
                                                                                                                     // 5537
				// Convert html into DOM nodes                                                                                   // 5538
				} else {                                                                                                         // 5539
					tmp = tmp || safe.appendChild( context.createElement("div") );                                                  // 5540
                                                                                                                     // 5541
					// Deserialize a standard representation                                                                        // 5542
					tag = (rtagName.exec( elem ) || [ "", "" ])[ 1 ].toLowerCase();                                                 // 5543
					wrap = wrapMap[ tag ] || wrapMap._default;                                                                      // 5544
                                                                                                                     // 5545
					tmp.innerHTML = wrap[1] + elem.replace( rxhtmlTag, "<$1></$2>" ) + wrap[2];                                     // 5546
                                                                                                                     // 5547
					// Descend through wrappers to the right content                                                                // 5548
					j = wrap[0];                                                                                                    // 5549
					while ( j-- ) {                                                                                                 // 5550
						tmp = tmp.lastChild;                                                                                           // 5551
					}                                                                                                               // 5552
                                                                                                                     // 5553
					// Manually add leading whitespace removed by IE                                                                // 5554
					if ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {                                          // 5555
						nodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[0] ) );                                    // 5556
					}                                                                                                               // 5557
                                                                                                                     // 5558
					// Remove IE's autoinserted <tbody> from table fragments                                                        // 5559
					if ( !support.tbody ) {                                                                                         // 5560
                                                                                                                     // 5561
						// String was a <table>, *may* have spurious <tbody>                                                           // 5562
						elem = tag === "table" && !rtbody.test( elem ) ?                                                               // 5563
							tmp.firstChild :                                                                                              // 5564
                                                                                                                     // 5565
							// String was a bare <thead> or <tfoot>                                                                       // 5566
							wrap[1] === "<table>" && !rtbody.test( elem ) ?                                                               // 5567
								tmp :                                                                                                        // 5568
								0;                                                                                                           // 5569
                                                                                                                     // 5570
						j = elem && elem.childNodes.length;                                                                            // 5571
						while ( j-- ) {                                                                                                // 5572
							if ( jQuery.nodeName( (tbody = elem.childNodes[j]), "tbody" ) && !tbody.childNodes.length ) {                 // 5573
								elem.removeChild( tbody );                                                                                   // 5574
							}                                                                                                             // 5575
						}                                                                                                              // 5576
					}                                                                                                               // 5577
                                                                                                                     // 5578
					jQuery.merge( nodes, tmp.childNodes );                                                                          // 5579
                                                                                                                     // 5580
					// Fix #12392 for WebKit and IE > 9                                                                             // 5581
					tmp.textContent = "";                                                                                           // 5582
                                                                                                                     // 5583
					// Fix #12392 for oldIE                                                                                         // 5584
					while ( tmp.firstChild ) {                                                                                      // 5585
						tmp.removeChild( tmp.firstChild );                                                                             // 5586
					}                                                                                                               // 5587
                                                                                                                     // 5588
					// Remember the top-level container for proper cleanup                                                          // 5589
					tmp = safe.lastChild;                                                                                           // 5590
				}                                                                                                                // 5591
			}                                                                                                                 // 5592
		}                                                                                                                  // 5593
                                                                                                                     // 5594
		// Fix #11356: Clear elements from fragment                                                                        // 5595
		if ( tmp ) {                                                                                                       // 5596
			safe.removeChild( tmp );                                                                                          // 5597
		}                                                                                                                  // 5598
                                                                                                                     // 5599
		// Reset defaultChecked for any radios and checkboxes                                                              // 5600
		// about to be appended to the DOM in IE 6/7 (#8060)                                                               // 5601
		if ( !support.appendChecked ) {                                                                                    // 5602
			jQuery.grep( getAll( nodes, "input" ), fixDefaultChecked );                                                       // 5603
		}                                                                                                                  // 5604
                                                                                                                     // 5605
		i = 0;                                                                                                             // 5606
		while ( (elem = nodes[ i++ ]) ) {                                                                                  // 5607
                                                                                                                     // 5608
			// #4087 - If origin and destination elements are the same, and this is                                           // 5609
			// that element, do not do anything                                                                               // 5610
			if ( selection && jQuery.inArray( elem, selection ) !== -1 ) {                                                    // 5611
				continue;                                                                                                        // 5612
			}                                                                                                                 // 5613
                                                                                                                     // 5614
			contains = jQuery.contains( elem.ownerDocument, elem );                                                           // 5615
                                                                                                                     // 5616
			// Append to fragment                                                                                             // 5617
			tmp = getAll( safe.appendChild( elem ), "script" );                                                               // 5618
                                                                                                                     // 5619
			// Preserve script evaluation history                                                                             // 5620
			if ( contains ) {                                                                                                 // 5621
				setGlobalEval( tmp );                                                                                            // 5622
			}                                                                                                                 // 5623
                                                                                                                     // 5624
			// Capture executables                                                                                            // 5625
			if ( scripts ) {                                                                                                  // 5626
				j = 0;                                                                                                           // 5627
				while ( (elem = tmp[ j++ ]) ) {                                                                                  // 5628
					if ( rscriptType.test( elem.type || "" ) ) {                                                                    // 5629
						scripts.push( elem );                                                                                          // 5630
					}                                                                                                               // 5631
				}                                                                                                                // 5632
			}                                                                                                                 // 5633
		}                                                                                                                  // 5634
                                                                                                                     // 5635
		tmp = null;                                                                                                        // 5636
                                                                                                                     // 5637
		return safe;                                                                                                       // 5638
	},                                                                                                                  // 5639
                                                                                                                     // 5640
	cleanData: function( elems, /* internal */ acceptData ) {                                                           // 5641
		var elem, type, id, data,                                                                                          // 5642
			i = 0,                                                                                                            // 5643
			internalKey = jQuery.expando,                                                                                     // 5644
			cache = jQuery.cache,                                                                                             // 5645
			deleteExpando = support.deleteExpando,                                                                            // 5646
			special = jQuery.event.special;                                                                                   // 5647
                                                                                                                     // 5648
		for ( ; (elem = elems[i]) != null; i++ ) {                                                                         // 5649
			if ( acceptData || jQuery.acceptData( elem ) ) {                                                                  // 5650
                                                                                                                     // 5651
				id = elem[ internalKey ];                                                                                        // 5652
				data = id && cache[ id ];                                                                                        // 5653
                                                                                                                     // 5654
				if ( data ) {                                                                                                    // 5655
					if ( data.events ) {                                                                                            // 5656
						for ( type in data.events ) {                                                                                  // 5657
							if ( special[ type ] ) {                                                                                      // 5658
								jQuery.event.remove( elem, type );                                                                           // 5659
                                                                                                                     // 5660
							// This is a shortcut to avoid jQuery.event.remove's overhead                                                 // 5661
							} else {                                                                                                      // 5662
								jQuery.removeEvent( elem, type, data.handle );                                                               // 5663
							}                                                                                                             // 5664
						}                                                                                                              // 5665
					}                                                                                                               // 5666
                                                                                                                     // 5667
					// Remove cache only if it was not already removed by jQuery.event.remove                                       // 5668
					if ( cache[ id ] ) {                                                                                            // 5669
                                                                                                                     // 5670
						delete cache[ id ];                                                                                            // 5671
                                                                                                                     // 5672
						// IE does not allow us to delete expando properties from nodes,                                               // 5673
						// nor does it have a removeAttribute function on Document nodes;                                              // 5674
						// we must handle all of these cases                                                                           // 5675
						if ( deleteExpando ) {                                                                                         // 5676
							delete elem[ internalKey ];                                                                                   // 5677
                                                                                                                     // 5678
						} else if ( typeof elem.removeAttribute !== strundefined ) {                                                   // 5679
							elem.removeAttribute( internalKey );                                                                          // 5680
                                                                                                                     // 5681
						} else {                                                                                                       // 5682
							elem[ internalKey ] = null;                                                                                   // 5683
						}                                                                                                              // 5684
                                                                                                                     // 5685
						deletedIds.push( id );                                                                                         // 5686
					}                                                                                                               // 5687
				}                                                                                                                // 5688
			}                                                                                                                 // 5689
		}                                                                                                                  // 5690
	}                                                                                                                   // 5691
});                                                                                                                  // 5692
                                                                                                                     // 5693
jQuery.fn.extend({                                                                                                   // 5694
	text: function( value ) {                                                                                           // 5695
		return access( this, function( value ) {                                                                           // 5696
			return value === undefined ?                                                                                      // 5697
				jQuery.text( this ) :                                                                                            // 5698
				this.empty().append( ( this[0] && this[0].ownerDocument || document ).createTextNode( value ) );                 // 5699
		}, null, value, arguments.length );                                                                                // 5700
	},                                                                                                                  // 5701
                                                                                                                     // 5702
	append: function() {                                                                                                // 5703
		return this.domManip( arguments, function( elem ) {                                                                // 5704
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {                                       // 5705
				var target = manipulationTarget( this, elem );                                                                   // 5706
				target.appendChild( elem );                                                                                      // 5707
			}                                                                                                                 // 5708
		});                                                                                                                // 5709
	},                                                                                                                  // 5710
                                                                                                                     // 5711
	prepend: function() {                                                                                               // 5712
		return this.domManip( arguments, function( elem ) {                                                                // 5713
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {                                       // 5714
				var target = manipulationTarget( this, elem );                                                                   // 5715
				target.insertBefore( elem, target.firstChild );                                                                  // 5716
			}                                                                                                                 // 5717
		});                                                                                                                // 5718
	},                                                                                                                  // 5719
                                                                                                                     // 5720
	before: function() {                                                                                                // 5721
		return this.domManip( arguments, function( elem ) {                                                                // 5722
			if ( this.parentNode ) {                                                                                          // 5723
				this.parentNode.insertBefore( elem, this );                                                                      // 5724
			}                                                                                                                 // 5725
		});                                                                                                                // 5726
	},                                                                                                                  // 5727
                                                                                                                     // 5728
	after: function() {                                                                                                 // 5729
		return this.domManip( arguments, function( elem ) {                                                                // 5730
			if ( this.parentNode ) {                                                                                          // 5731
				this.parentNode.insertBefore( elem, this.nextSibling );                                                          // 5732
			}                                                                                                                 // 5733
		});                                                                                                                // 5734
	},                                                                                                                  // 5735
                                                                                                                     // 5736
	remove: function( selector, keepData /* Internal Use Only */ ) {                                                    // 5737
		var elem,                                                                                                          // 5738
			elems = selector ? jQuery.filter( selector, this ) : this,                                                        // 5739
			i = 0;                                                                                                            // 5740
                                                                                                                     // 5741
		for ( ; (elem = elems[i]) != null; i++ ) {                                                                         // 5742
                                                                                                                     // 5743
			if ( !keepData && elem.nodeType === 1 ) {                                                                         // 5744
				jQuery.cleanData( getAll( elem ) );                                                                              // 5745
			}                                                                                                                 // 5746
                                                                                                                     // 5747
			if ( elem.parentNode ) {                                                                                          // 5748
				if ( keepData && jQuery.contains( elem.ownerDocument, elem ) ) {                                                 // 5749
					setGlobalEval( getAll( elem, "script" ) );                                                                      // 5750
				}                                                                                                                // 5751
				elem.parentNode.removeChild( elem );                                                                             // 5752
			}                                                                                                                 // 5753
		}                                                                                                                  // 5754
                                                                                                                     // 5755
		return this;                                                                                                       // 5756
	},                                                                                                                  // 5757
                                                                                                                     // 5758
	empty: function() {                                                                                                 // 5759
		var elem,                                                                                                          // 5760
			i = 0;                                                                                                            // 5761
                                                                                                                     // 5762
		for ( ; (elem = this[i]) != null; i++ ) {                                                                          // 5763
			// Remove element nodes and prevent memory leaks                                                                  // 5764
			if ( elem.nodeType === 1 ) {                                                                                      // 5765
				jQuery.cleanData( getAll( elem, false ) );                                                                       // 5766
			}                                                                                                                 // 5767
                                                                                                                     // 5768
			// Remove any remaining nodes                                                                                     // 5769
			while ( elem.firstChild ) {                                                                                       // 5770
				elem.removeChild( elem.firstChild );                                                                             // 5771
			}                                                                                                                 // 5772
                                                                                                                     // 5773
			// If this is a select, ensure that it displays empty (#12336)                                                    // 5774
			// Support: IE<9                                                                                                  // 5775
			if ( elem.options && jQuery.nodeName( elem, "select" ) ) {                                                        // 5776
				elem.options.length = 0;                                                                                         // 5777
			}                                                                                                                 // 5778
		}                                                                                                                  // 5779
                                                                                                                     // 5780
		return this;                                                                                                       // 5781
	},                                                                                                                  // 5782
                                                                                                                     // 5783
	clone: function( dataAndEvents, deepDataAndEvents ) {                                                               // 5784
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;                                                     // 5785
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;                                 // 5786
                                                                                                                     // 5787
		return this.map(function() {                                                                                       // 5788
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );                                                    // 5789
		});                                                                                                                // 5790
	},                                                                                                                  // 5791
                                                                                                                     // 5792
	html: function( value ) {                                                                                           // 5793
		return access( this, function( value ) {                                                                           // 5794
			var elem = this[ 0 ] || {},                                                                                       // 5795
				i = 0,                                                                                                           // 5796
				l = this.length;                                                                                                 // 5797
                                                                                                                     // 5798
			if ( value === undefined ) {                                                                                      // 5799
				return elem.nodeType === 1 ?                                                                                     // 5800
					elem.innerHTML.replace( rinlinejQuery, "" ) :                                                                   // 5801
					undefined;                                                                                                      // 5802
			}                                                                                                                 // 5803
                                                                                                                     // 5804
			// See if we can take a shortcut and just use innerHTML                                                           // 5805
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&                                                  // 5806
				( support.htmlSerialize || !rnoshimcache.test( value )  ) &&                                                     // 5807
				( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&                                            // 5808
				!wrapMap[ (rtagName.exec( value ) || [ "", "" ])[ 1 ].toLowerCase() ] ) {                                        // 5809
                                                                                                                     // 5810
				value = value.replace( rxhtmlTag, "<$1></$2>" );                                                                 // 5811
                                                                                                                     // 5812
				try {                                                                                                            // 5813
					for (; i < l; i++ ) {                                                                                           // 5814
						// Remove element nodes and prevent memory leaks                                                               // 5815
						elem = this[i] || {};                                                                                          // 5816
						if ( elem.nodeType === 1 ) {                                                                                   // 5817
							jQuery.cleanData( getAll( elem, false ) );                                                                    // 5818
							elem.innerHTML = value;                                                                                       // 5819
						}                                                                                                              // 5820
					}                                                                                                               // 5821
                                                                                                                     // 5822
					elem = 0;                                                                                                       // 5823
                                                                                                                     // 5824
				// If using innerHTML throws an exception, use the fallback method                                               // 5825
				} catch(e) {}                                                                                                    // 5826
			}                                                                                                                 // 5827
                                                                                                                     // 5828
			if ( elem ) {                                                                                                     // 5829
				this.empty().append( value );                                                                                    // 5830
			}                                                                                                                 // 5831
		}, null, value, arguments.length );                                                                                // 5832
	},                                                                                                                  // 5833
                                                                                                                     // 5834
	replaceWith: function() {                                                                                           // 5835
		var arg = arguments[ 0 ];                                                                                          // 5836
                                                                                                                     // 5837
		// Make the changes, replacing each context element with the new content                                           // 5838
		this.domManip( arguments, function( elem ) {                                                                       // 5839
			arg = this.parentNode;                                                                                            // 5840
                                                                                                                     // 5841
			jQuery.cleanData( getAll( this ) );                                                                               // 5842
                                                                                                                     // 5843
			if ( arg ) {                                                                                                      // 5844
				arg.replaceChild( elem, this );                                                                                  // 5845
			}                                                                                                                 // 5846
		});                                                                                                                // 5847
                                                                                                                     // 5848
		// Force removal if there was no new content (e.g., from empty arguments)                                          // 5849
		return arg && (arg.length || arg.nodeType) ? this : this.remove();                                                 // 5850
	},                                                                                                                  // 5851
                                                                                                                     // 5852
	detach: function( selector ) {                                                                                      // 5853
		return this.remove( selector, true );                                                                              // 5854
	},                                                                                                                  // 5855
                                                                                                                     // 5856
	domManip: function( args, callback ) {                                                                              // 5857
                                                                                                                     // 5858
		// Flatten any nested arrays                                                                                       // 5859
		args = concat.apply( [], args );                                                                                   // 5860
                                                                                                                     // 5861
		var first, node, hasScripts,                                                                                       // 5862
			scripts, doc, fragment,                                                                                           // 5863
			i = 0,                                                                                                            // 5864
			l = this.length,                                                                                                  // 5865
			set = this,                                                                                                       // 5866
			iNoClone = l - 1,                                                                                                 // 5867
			value = args[0],                                                                                                  // 5868
			isFunction = jQuery.isFunction( value );                                                                          // 5869
                                                                                                                     // 5870
		// We can't cloneNode fragments that contain checked, in WebKit                                                    // 5871
		if ( isFunction ||                                                                                                 // 5872
				( l > 1 && typeof value === "string" &&                                                                          // 5873
					!support.checkClone && rchecked.test( value ) ) ) {                                                             // 5874
			return this.each(function( index ) {                                                                              // 5875
				var self = set.eq( index );                                                                                      // 5876
				if ( isFunction ) {                                                                                              // 5877
					args[0] = value.call( this, index, self.html() );                                                               // 5878
				}                                                                                                                // 5879
				self.domManip( args, callback );                                                                                 // 5880
			});                                                                                                               // 5881
		}                                                                                                                  // 5882
                                                                                                                     // 5883
		if ( l ) {                                                                                                         // 5884
			fragment = jQuery.buildFragment( args, this[ 0 ].ownerDocument, false, this );                                    // 5885
			first = fragment.firstChild;                                                                                      // 5886
                                                                                                                     // 5887
			if ( fragment.childNodes.length === 1 ) {                                                                         // 5888
				fragment = first;                                                                                                // 5889
			}                                                                                                                 // 5890
                                                                                                                     // 5891
			if ( first ) {                                                                                                    // 5892
				scripts = jQuery.map( getAll( fragment, "script" ), disableScript );                                             // 5893
				hasScripts = scripts.length;                                                                                     // 5894
                                                                                                                     // 5895
				// Use the original fragment for the last item instead of the first because it can end up                        // 5896
				// being emptied incorrectly in certain situations (#8070).                                                      // 5897
				for ( ; i < l; i++ ) {                                                                                           // 5898
					node = fragment;                                                                                                // 5899
                                                                                                                     // 5900
					if ( i !== iNoClone ) {                                                                                         // 5901
						node = jQuery.clone( node, true, true );                                                                       // 5902
                                                                                                                     // 5903
						// Keep references to cloned scripts for later restoration                                                     // 5904
						if ( hasScripts ) {                                                                                            // 5905
							jQuery.merge( scripts, getAll( node, "script" ) );                                                            // 5906
						}                                                                                                              // 5907
					}                                                                                                               // 5908
                                                                                                                     // 5909
					callback.call( this[i], node, i );                                                                              // 5910
				}                                                                                                                // 5911
                                                                                                                     // 5912
				if ( hasScripts ) {                                                                                              // 5913
					doc = scripts[ scripts.length - 1 ].ownerDocument;                                                              // 5914
                                                                                                                     // 5915
					// Reenable scripts                                                                                             // 5916
					jQuery.map( scripts, restoreScript );                                                                           // 5917
                                                                                                                     // 5918
					// Evaluate executable scripts on first document insertion                                                      // 5919
					for ( i = 0; i < hasScripts; i++ ) {                                                                            // 5920
						node = scripts[ i ];                                                                                           // 5921
						if ( rscriptType.test( node.type || "" ) &&                                                                    // 5922
							!jQuery._data( node, "globalEval" ) && jQuery.contains( doc, node ) ) {                                       // 5923
                                                                                                                     // 5924
							if ( node.src ) {                                                                                             // 5925
								// Optional AJAX dependency, but won't run scripts if not present                                            // 5926
								if ( jQuery._evalUrl ) {                                                                                     // 5927
									jQuery._evalUrl( node.src );                                                                                // 5928
								}                                                                                                            // 5929
							} else {                                                                                                      // 5930
								jQuery.globalEval( ( node.text || node.textContent || node.innerHTML || "" ).replace( rcleanScript, "" ) );  // 5931
							}                                                                                                             // 5932
						}                                                                                                              // 5933
					}                                                                                                               // 5934
				}                                                                                                                // 5935
                                                                                                                     // 5936
				// Fix #11809: Avoid leaking memory                                                                              // 5937
				fragment = first = null;                                                                                         // 5938
			}                                                                                                                 // 5939
		}                                                                                                                  // 5940
                                                                                                                     // 5941
		return this;                                                                                                       // 5942
	}                                                                                                                   // 5943
});                                                                                                                  // 5944
                                                                                                                     // 5945
jQuery.each({                                                                                                        // 5946
	appendTo: "append",                                                                                                 // 5947
	prependTo: "prepend",                                                                                               // 5948
	insertBefore: "before",                                                                                             // 5949
	insertAfter: "after",                                                                                               // 5950
	replaceAll: "replaceWith"                                                                                           // 5951
}, function( name, original ) {                                                                                      // 5952
	jQuery.fn[ name ] = function( selector ) {                                                                          // 5953
		var elems,                                                                                                         // 5954
			i = 0,                                                                                                            // 5955
			ret = [],                                                                                                         // 5956
			insert = jQuery( selector ),                                                                                      // 5957
			last = insert.length - 1;                                                                                         // 5958
                                                                                                                     // 5959
		for ( ; i <= last; i++ ) {                                                                                         // 5960
			elems = i === last ? this : this.clone(true);                                                                     // 5961
			jQuery( insert[i] )[ original ]( elems );                                                                         // 5962
                                                                                                                     // 5963
			// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()                               // 5964
			push.apply( ret, elems.get() );                                                                                   // 5965
		}                                                                                                                  // 5966
                                                                                                                     // 5967
		return this.pushStack( ret );                                                                                      // 5968
	};                                                                                                                  // 5969
});                                                                                                                  // 5970
                                                                                                                     // 5971
                                                                                                                     // 5972
var iframe,                                                                                                          // 5973
	elemdisplay = {};                                                                                                   // 5974
                                                                                                                     // 5975
/**                                                                                                                  // 5976
 * Retrieve the actual display of a element                                                                          // 5977
 * @param {String} name nodeName of the element                                                                      // 5978
 * @param {Object} doc Document object                                                                               // 5979
 */                                                                                                                  // 5980
// Called only from within defaultDisplay                                                                            // 5981
function actualDisplay( name, doc ) {                                                                                // 5982
	var elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),                                                // 5983
                                                                                                                     // 5984
		// getDefaultComputedStyle might be reliably used only on attached element                                         // 5985
		display = window.getDefaultComputedStyle ?                                                                         // 5986
                                                                                                                     // 5987
			// Use of this method is a temporary fix (more like optmization) until something better comes along,              // 5988
			// since it was removed from specification and supported only in FF                                               // 5989
			window.getDefaultComputedStyle( elem[ 0 ] ).display : jQuery.css( elem[ 0 ], "display" );                         // 5990
                                                                                                                     // 5991
	// We don't have any data stored on the element,                                                                    // 5992
	// so use "detach" method as fast way to get rid of the element                                                     // 5993
	elem.detach();                                                                                                      // 5994
                                                                                                                     // 5995
	return display;                                                                                                     // 5996
}                                                                                                                    // 5997
                                                                                                                     // 5998
/**                                                                                                                  // 5999
 * Try to determine the default display value of an element                                                          // 6000
 * @param {String} nodeName                                                                                          // 6001
 */                                                                                                                  // 6002
function defaultDisplay( nodeName ) {                                                                                // 6003
	var doc = document,                                                                                                 // 6004
		display = elemdisplay[ nodeName ];                                                                                 // 6005
                                                                                                                     // 6006
	if ( !display ) {                                                                                                   // 6007
		display = actualDisplay( nodeName, doc );                                                                          // 6008
                                                                                                                     // 6009
		// If the simple way fails, read from inside an iframe                                                             // 6010
		if ( display === "none" || !display ) {                                                                            // 6011
                                                                                                                     // 6012
			// Use the already-created iframe if possible                                                                     // 6013
			iframe = (iframe || jQuery( "<iframe frameborder='0' width='0' height='0'/>" )).appendTo( doc.documentElement );  // 6014
                                                                                                                     // 6015
			// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse                                    // 6016
			doc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;                                      // 6017
                                                                                                                     // 6018
			// Support: IE                                                                                                    // 6019
			doc.write();                                                                                                      // 6020
			doc.close();                                                                                                      // 6021
                                                                                                                     // 6022
			display = actualDisplay( nodeName, doc );                                                                         // 6023
			iframe.detach();                                                                                                  // 6024
		}                                                                                                                  // 6025
                                                                                                                     // 6026
		// Store the correct default display                                                                               // 6027
		elemdisplay[ nodeName ] = display;                                                                                 // 6028
	}                                                                                                                   // 6029
                                                                                                                     // 6030
	return display;                                                                                                     // 6031
}                                                                                                                    // 6032
                                                                                                                     // 6033
                                                                                                                     // 6034
(function() {                                                                                                        // 6035
	var a, shrinkWrapBlocksVal,                                                                                         // 6036
		div = document.createElement( "div" ),                                                                             // 6037
		divReset =                                                                                                         // 6038
			"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" +                            // 6039
			"display:block;padding:0;margin:0;border:0";                                                                      // 6040
                                                                                                                     // 6041
	// Setup                                                                                                            // 6042
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";                               // 6043
	a = div.getElementsByTagName( "a" )[ 0 ];                                                                           // 6044
                                                                                                                     // 6045
	a.style.cssText = "float:left;opacity:.5";                                                                          // 6046
                                                                                                                     // 6047
	// Make sure that element opacity exists                                                                            // 6048
	// (IE uses filter instead)                                                                                         // 6049
	// Use a regex to work around a WebKit issue. See #5145                                                             // 6050
	support.opacity = /^0.5/.test( a.style.opacity );                                                                   // 6051
                                                                                                                     // 6052
	// Verify style float existence                                                                                     // 6053
	// (IE uses styleFloat instead of cssFloat)                                                                         // 6054
	support.cssFloat = !!a.style.cssFloat;                                                                              // 6055
                                                                                                                     // 6056
	div.style.backgroundClip = "content-box";                                                                           // 6057
	div.cloneNode( true ).style.backgroundClip = "";                                                                    // 6058
	support.clearCloneStyle = div.style.backgroundClip === "content-box";                                               // 6059
                                                                                                                     // 6060
	// Null elements to avoid leaks in IE.                                                                              // 6061
	a = div = null;                                                                                                     // 6062
                                                                                                                     // 6063
	support.shrinkWrapBlocks = function() {                                                                             // 6064
		var body, container, div, containerStyles;                                                                         // 6065
                                                                                                                     // 6066
		if ( shrinkWrapBlocksVal == null ) {                                                                               // 6067
			body = document.getElementsByTagName( "body" )[ 0 ];                                                              // 6068
			if ( !body ) {                                                                                                    // 6069
				// Test fired too early or in an unsupported environment, exit.                                                  // 6070
				return;                                                                                                          // 6071
			}                                                                                                                 // 6072
                                                                                                                     // 6073
			containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px";                               // 6074
			container = document.createElement( "div" );                                                                      // 6075
			div = document.createElement( "div" );                                                                            // 6076
                                                                                                                     // 6077
			body.appendChild( container ).appendChild( div );                                                                 // 6078
                                                                                                                     // 6079
			// Will be changed later if needed.                                                                               // 6080
			shrinkWrapBlocksVal = false;                                                                                      // 6081
                                                                                                                     // 6082
			if ( typeof div.style.zoom !== strundefined ) {                                                                   // 6083
				// Support: IE6                                                                                                  // 6084
				// Check if elements with layout shrink-wrap their children                                                      // 6085
				div.style.cssText = divReset + ";width:1px;padding:1px;zoom:1";                                                  // 6086
				div.innerHTML = "<div></div>";                                                                                   // 6087
				div.firstChild.style.width = "5px";                                                                              // 6088
				shrinkWrapBlocksVal = div.offsetWidth !== 3;                                                                     // 6089
			}                                                                                                                 // 6090
                                                                                                                     // 6091
			body.removeChild( container );                                                                                    // 6092
                                                                                                                     // 6093
			// Null elements to avoid leaks in IE.                                                                            // 6094
			body = container = div = null;                                                                                    // 6095
		}                                                                                                                  // 6096
                                                                                                                     // 6097
		return shrinkWrapBlocksVal;                                                                                        // 6098
	};                                                                                                                  // 6099
                                                                                                                     // 6100
})();                                                                                                                // 6101
var rmargin = (/^margin/);                                                                                           // 6102
                                                                                                                     // 6103
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );                                                  // 6104
                                                                                                                     // 6105
                                                                                                                     // 6106
                                                                                                                     // 6107
var getStyles, curCSS,                                                                                               // 6108
	rposition = /^(top|right|bottom|left)$/;                                                                            // 6109
                                                                                                                     // 6110
if ( window.getComputedStyle ) {                                                                                     // 6111
	getStyles = function( elem ) {                                                                                      // 6112
		return elem.ownerDocument.defaultView.getComputedStyle( elem, null );                                              // 6113
	};                                                                                                                  // 6114
                                                                                                                     // 6115
	curCSS = function( elem, name, computed ) {                                                                         // 6116
		var width, minWidth, maxWidth, ret,                                                                                // 6117
			style = elem.style;                                                                                               // 6118
                                                                                                                     // 6119
		computed = computed || getStyles( elem );                                                                          // 6120
                                                                                                                     // 6121
		// getPropertyValue is only needed for .css('filter') in IE9, see #12537                                           // 6122
		ret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;                                // 6123
                                                                                                                     // 6124
		if ( computed ) {                                                                                                  // 6125
                                                                                                                     // 6126
			if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {                                               // 6127
				ret = jQuery.style( elem, name );                                                                                // 6128
			}                                                                                                                 // 6129
                                                                                                                     // 6130
			// A tribute to the "awesome hack by Dean Edwards"                                                                // 6131
			// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right                      // 6132
			// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels   // 6133
			// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values                           // 6134
			if ( rnumnonpx.test( ret ) && rmargin.test( name ) ) {                                                            // 6135
                                                                                                                     // 6136
				// Remember the original values                                                                                  // 6137
				width = style.width;                                                                                             // 6138
				minWidth = style.minWidth;                                                                                       // 6139
				maxWidth = style.maxWidth;                                                                                       // 6140
                                                                                                                     // 6141
				// Put in the new values to get a computed value out                                                             // 6142
				style.minWidth = style.maxWidth = style.width = ret;                                                             // 6143
				ret = computed.width;                                                                                            // 6144
                                                                                                                     // 6145
				// Revert the changed values                                                                                     // 6146
				style.width = width;                                                                                             // 6147
				style.minWidth = minWidth;                                                                                       // 6148
				style.maxWidth = maxWidth;                                                                                       // 6149
			}                                                                                                                 // 6150
		}                                                                                                                  // 6151
                                                                                                                     // 6152
		// Support: IE                                                                                                     // 6153
		// IE returns zIndex value as an integer.                                                                          // 6154
		return ret === undefined ?                                                                                         // 6155
			ret :                                                                                                             // 6156
			ret + "";                                                                                                         // 6157
	};                                                                                                                  // 6158
} else if ( document.documentElement.currentStyle ) {                                                                // 6159
	getStyles = function( elem ) {                                                                                      // 6160
		return elem.currentStyle;                                                                                          // 6161
	};                                                                                                                  // 6162
                                                                                                                     // 6163
	curCSS = function( elem, name, computed ) {                                                                         // 6164
		var left, rs, rsLeft, ret,                                                                                         // 6165
			style = elem.style;                                                                                               // 6166
                                                                                                                     // 6167
		computed = computed || getStyles( elem );                                                                          // 6168
		ret = computed ? computed[ name ] : undefined;                                                                     // 6169
                                                                                                                     // 6170
		// Avoid setting ret to empty string here                                                                          // 6171
		// so we don't default to auto                                                                                     // 6172
		if ( ret == null && style && style[ name ] ) {                                                                     // 6173
			ret = style[ name ];                                                                                              // 6174
		}                                                                                                                  // 6175
                                                                                                                     // 6176
		// From the awesome hack by Dean Edwards                                                                           // 6177
		// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291                                                // 6178
                                                                                                                     // 6179
		// If we're not dealing with a regular pixel number                                                                // 6180
		// but a number that has a weird ending, we need to convert it to pixels                                           // 6181
		// but not position css attributes, as those are proportional to the parent element instead                        // 6182
		// and we can't measure the parent instead because it might trigger a "stacking dolls" problem                     // 6183
		if ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {                                                          // 6184
                                                                                                                     // 6185
			// Remember the original values                                                                                   // 6186
			left = style.left;                                                                                                // 6187
			rs = elem.runtimeStyle;                                                                                           // 6188
			rsLeft = rs && rs.left;                                                                                           // 6189
                                                                                                                     // 6190
			// Put in the new values to get a computed value out                                                              // 6191
			if ( rsLeft ) {                                                                                                   // 6192
				rs.left = elem.currentStyle.left;                                                                                // 6193
			}                                                                                                                 // 6194
			style.left = name === "fontSize" ? "1em" : ret;                                                                   // 6195
			ret = style.pixelLeft + "px";                                                                                     // 6196
                                                                                                                     // 6197
			// Revert the changed values                                                                                      // 6198
			style.left = left;                                                                                                // 6199
			if ( rsLeft ) {                                                                                                   // 6200
				rs.left = rsLeft;                                                                                                // 6201
			}                                                                                                                 // 6202
		}                                                                                                                  // 6203
                                                                                                                     // 6204
		// Support: IE                                                                                                     // 6205
		// IE returns zIndex value as an integer.                                                                          // 6206
		return ret === undefined ?                                                                                         // 6207
			ret :                                                                                                             // 6208
			ret + "" || "auto";                                                                                               // 6209
	};                                                                                                                  // 6210
}                                                                                                                    // 6211
                                                                                                                     // 6212
                                                                                                                     // 6213
                                                                                                                     // 6214
                                                                                                                     // 6215
function addGetHookIf( conditionFn, hookFn ) {                                                                       // 6216
	// Define the hook, we'll check on the first run if it's really needed.                                             // 6217
	return {                                                                                                            // 6218
		get: function() {                                                                                                  // 6219
			var condition = conditionFn();                                                                                    // 6220
                                                                                                                     // 6221
			if ( condition == null ) {                                                                                        // 6222
				// The test was not ready at this point; screw the hook this time                                                // 6223
				// but check again when needed next time.                                                                        // 6224
				return;                                                                                                          // 6225
			}                                                                                                                 // 6226
                                                                                                                     // 6227
			if ( condition ) {                                                                                                // 6228
				// Hook not needed (or it's not possible to use it due to missing dependency),                                   // 6229
				// remove it.                                                                                                    // 6230
				// Since there are no other hooks for marginRight, remove the whole object.                                      // 6231
				delete this.get;                                                                                                 // 6232
				return;                                                                                                          // 6233
			}                                                                                                                 // 6234
                                                                                                                     // 6235
			// Hook needed; redefine it so that the support test is not executed again.                                       // 6236
                                                                                                                     // 6237
			return (this.get = hookFn).apply( this, arguments );                                                              // 6238
		}                                                                                                                  // 6239
	};                                                                                                                  // 6240
}                                                                                                                    // 6241
                                                                                                                     // 6242
                                                                                                                     // 6243
(function() {                                                                                                        // 6244
	var a, reliableHiddenOffsetsVal, boxSizingVal, boxSizingReliableVal,                                                // 6245
		pixelPositionVal, reliableMarginRightVal,                                                                          // 6246
		div = document.createElement( "div" ),                                                                             // 6247
		containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px",                                // 6248
		divReset =                                                                                                         // 6249
			"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" +                            // 6250
			"display:block;padding:0;margin:0;border:0";                                                                      // 6251
                                                                                                                     // 6252
	// Setup                                                                                                            // 6253
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";                               // 6254
	a = div.getElementsByTagName( "a" )[ 0 ];                                                                           // 6255
                                                                                                                     // 6256
	a.style.cssText = "float:left;opacity:.5";                                                                          // 6257
                                                                                                                     // 6258
	// Make sure that element opacity exists                                                                            // 6259
	// (IE uses filter instead)                                                                                         // 6260
	// Use a regex to work around a WebKit issue. See #5145                                                             // 6261
	support.opacity = /^0.5/.test( a.style.opacity );                                                                   // 6262
                                                                                                                     // 6263
	// Verify style float existence                                                                                     // 6264
	// (IE uses styleFloat instead of cssFloat)                                                                         // 6265
	support.cssFloat = !!a.style.cssFloat;                                                                              // 6266
                                                                                                                     // 6267
	div.style.backgroundClip = "content-box";                                                                           // 6268
	div.cloneNode( true ).style.backgroundClip = "";                                                                    // 6269
	support.clearCloneStyle = div.style.backgroundClip === "content-box";                                               // 6270
                                                                                                                     // 6271
	// Null elements to avoid leaks in IE.                                                                              // 6272
	a = div = null;                                                                                                     // 6273
                                                                                                                     // 6274
	jQuery.extend(support, {                                                                                            // 6275
		reliableHiddenOffsets: function() {                                                                                // 6276
			if ( reliableHiddenOffsetsVal != null ) {                                                                         // 6277
				return reliableHiddenOffsetsVal;                                                                                 // 6278
			}                                                                                                                 // 6279
                                                                                                                     // 6280
			var container, tds, isSupported,                                                                                  // 6281
				div = document.createElement( "div" ),                                                                           // 6282
				body = document.getElementsByTagName( "body" )[ 0 ];                                                             // 6283
                                                                                                                     // 6284
			if ( !body ) {                                                                                                    // 6285
				// Return for frameset docs that don't have a body                                                               // 6286
				return;                                                                                                          // 6287
			}                                                                                                                 // 6288
                                                                                                                     // 6289
			// Setup                                                                                                          // 6290
			div.setAttribute( "className", "t" );                                                                             // 6291
			div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";                             // 6292
                                                                                                                     // 6293
			container = document.createElement( "div" );                                                                      // 6294
			container.style.cssText = containerStyles;                                                                        // 6295
                                                                                                                     // 6296
			body.appendChild( container ).appendChild( div );                                                                 // 6297
                                                                                                                     // 6298
			// Support: IE8                                                                                                   // 6299
			// Check if table cells still have offsetWidth/Height when they are set                                           // 6300
			// to display:none and there are still other visible table cells in a                                             // 6301
			// table row; if so, offsetWidth/Height are not reliable for use when                                             // 6302
			// determining if an element has been hidden directly using                                                       // 6303
			// display:none (it is still safe to use offsets if a parent element is                                           // 6304
			// hidden; don safety goggles and see bug #4512 for more information).                                            // 6305
			div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";                                                    // 6306
			tds = div.getElementsByTagName( "td" );                                                                           // 6307
			tds[ 0 ].style.cssText = "padding:0;margin:0;border:0;display:none";                                              // 6308
			isSupported = ( tds[ 0 ].offsetHeight === 0 );                                                                    // 6309
                                                                                                                     // 6310
			tds[ 0 ].style.display = "";                                                                                      // 6311
			tds[ 1 ].style.display = "none";                                                                                  // 6312
                                                                                                                     // 6313
			// Support: IE8                                                                                                   // 6314
			// Check if empty table cells still have offsetWidth/Height                                                       // 6315
			reliableHiddenOffsetsVal = isSupported && ( tds[ 0 ].offsetHeight === 0 );                                        // 6316
                                                                                                                     // 6317
			body.removeChild( container );                                                                                    // 6318
                                                                                                                     // 6319
			// Null elements to avoid leaks in IE.                                                                            // 6320
			div = body = null;                                                                                                // 6321
                                                                                                                     // 6322
			return reliableHiddenOffsetsVal;                                                                                  // 6323
		},                                                                                                                 // 6324
                                                                                                                     // 6325
		boxSizing: function() {                                                                                            // 6326
			if ( boxSizingVal == null ) {                                                                                     // 6327
				computeStyleTests();                                                                                             // 6328
			}                                                                                                                 // 6329
			return boxSizingVal;                                                                                              // 6330
		},                                                                                                                 // 6331
                                                                                                                     // 6332
		boxSizingReliable: function() {                                                                                    // 6333
			if ( boxSizingReliableVal == null ) {                                                                             // 6334
				computeStyleTests();                                                                                             // 6335
			}                                                                                                                 // 6336
			return boxSizingReliableVal;                                                                                      // 6337
		},                                                                                                                 // 6338
                                                                                                                     // 6339
		pixelPosition: function() {                                                                                        // 6340
			if ( pixelPositionVal == null ) {                                                                                 // 6341
				computeStyleTests();                                                                                             // 6342
			}                                                                                                                 // 6343
			return pixelPositionVal;                                                                                          // 6344
		},                                                                                                                 // 6345
                                                                                                                     // 6346
		reliableMarginRight: function() {                                                                                  // 6347
			var body, container, div, marginDiv;                                                                              // 6348
                                                                                                                     // 6349
			// Use window.getComputedStyle because jsdom on node.js will break without it.                                    // 6350
			if ( reliableMarginRightVal == null && window.getComputedStyle ) {                                                // 6351
				body = document.getElementsByTagName( "body" )[ 0 ];                                                             // 6352
				if ( !body ) {                                                                                                   // 6353
					// Test fired too early or in an unsupported environment, exit.                                                 // 6354
					return;                                                                                                         // 6355
				}                                                                                                                // 6356
                                                                                                                     // 6357
				container = document.createElement( "div" );                                                                     // 6358
				div = document.createElement( "div" );                                                                           // 6359
				container.style.cssText = containerStyles;                                                                       // 6360
                                                                                                                     // 6361
				body.appendChild( container ).appendChild( div );                                                                // 6362
                                                                                                                     // 6363
				// Check if div with explicit width and no margin-right incorrectly                                              // 6364
				// gets computed margin-right based on width of container. (#3333)                                               // 6365
				// Fails in WebKit before Feb 2011 nightlies                                                                     // 6366
				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right                                      // 6367
				marginDiv = div.appendChild( document.createElement( "div" ) );                                                  // 6368
				marginDiv.style.cssText = div.style.cssText = divReset;                                                          // 6369
				marginDiv.style.marginRight = marginDiv.style.width = "0";                                                       // 6370
				div.style.width = "1px";                                                                                         // 6371
                                                                                                                     // 6372
				reliableMarginRightVal =                                                                                         // 6373
					!parseFloat( ( window.getComputedStyle( marginDiv, null ) || {} ).marginRight );                                // 6374
                                                                                                                     // 6375
				body.removeChild( container );                                                                                   // 6376
			}                                                                                                                 // 6377
                                                                                                                     // 6378
			return reliableMarginRightVal;                                                                                    // 6379
		}                                                                                                                  // 6380
	});                                                                                                                 // 6381
                                                                                                                     // 6382
	function computeStyleTests() {                                                                                      // 6383
		var container, div,                                                                                                // 6384
			body = document.getElementsByTagName( "body" )[ 0 ];                                                              // 6385
                                                                                                                     // 6386
		if ( !body ) {                                                                                                     // 6387
			// Test fired too early or in an unsupported environment, exit.                                                   // 6388
			return;                                                                                                           // 6389
		}                                                                                                                  // 6390
                                                                                                                     // 6391
		container = document.createElement( "div" );                                                                       // 6392
		div = document.createElement( "div" );                                                                             // 6393
		container.style.cssText = containerStyles;                                                                         // 6394
                                                                                                                     // 6395
		body.appendChild( container ).appendChild( div );                                                                  // 6396
                                                                                                                     // 6397
		div.style.cssText =                                                                                                // 6398
			"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;" +                               // 6399
				"position:absolute;display:block;padding:1px;border:1px;width:4px;" +                                            // 6400
				"margin-top:1%;top:1%";                                                                                          // 6401
                                                                                                                     // 6402
		// Workaround failing boxSizing test due to offsetWidth returning wrong value                                      // 6403
		// with some non-1 values of body zoom, ticket #13543                                                              // 6404
		jQuery.swap( body, body.style.zoom != null ? { zoom: 1 } : {}, function() {                                        // 6405
			boxSizingVal = div.offsetWidth === 4;                                                                             // 6406
		});                                                                                                                // 6407
                                                                                                                     // 6408
		// Will be changed later if needed.                                                                                // 6409
		boxSizingReliableVal = true;                                                                                       // 6410
		pixelPositionVal = false;                                                                                          // 6411
		reliableMarginRightVal = true;                                                                                     // 6412
                                                                                                                     // 6413
		// Use window.getComputedStyle because jsdom on node.js will break without it.                                     // 6414
		if ( window.getComputedStyle ) {                                                                                   // 6415
			pixelPositionVal = ( window.getComputedStyle( div, null ) || {} ).top !== "1%";                                   // 6416
			boxSizingReliableVal =                                                                                            // 6417
				( window.getComputedStyle( div, null ) || { width: "4px" } ).width === "4px";                                    // 6418
		}                                                                                                                  // 6419
                                                                                                                     // 6420
		body.removeChild( container );                                                                                     // 6421
                                                                                                                     // 6422
		// Null elements to avoid leaks in IE.                                                                             // 6423
		div = body = null;                                                                                                 // 6424
	}                                                                                                                   // 6425
                                                                                                                     // 6426
})();                                                                                                                // 6427
                                                                                                                     // 6428
                                                                                                                     // 6429
// A method for quickly swapping in/out CSS properties to get correct calculations.                                  // 6430
jQuery.swap = function( elem, options, callback, args ) {                                                            // 6431
	var ret, name,                                                                                                      // 6432
		old = {};                                                                                                          // 6433
                                                                                                                     // 6434
	// Remember the old values, and insert the new ones                                                                 // 6435
	for ( name in options ) {                                                                                           // 6436
		old[ name ] = elem.style[ name ];                                                                                  // 6437
		elem.style[ name ] = options[ name ];                                                                              // 6438
	}                                                                                                                   // 6439
                                                                                                                     // 6440
	ret = callback.apply( elem, args || [] );                                                                           // 6441
                                                                                                                     // 6442
	// Revert the old values                                                                                            // 6443
	for ( name in options ) {                                                                                           // 6444
		elem.style[ name ] = old[ name ];                                                                                  // 6445
	}                                                                                                                   // 6446
                                                                                                                     // 6447
	return ret;                                                                                                         // 6448
};                                                                                                                   // 6449
                                                                                                                     // 6450
                                                                                                                     // 6451
var                                                                                                                  // 6452
		ralpha = /alpha\([^)]*\)/i,                                                                                        // 6453
	ropacity = /opacity\s*=\s*([^)]*)/,                                                                                 // 6454
                                                                                                                     // 6455
	// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"               // 6456
	// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display                                // 6457
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,                                                                         // 6458
	rnumsplit = new RegExp( "^(" + pnum + ")(.*)$", "i" ),                                                              // 6459
	rrelNum = new RegExp( "^([+-])=(" + pnum + ")", "i" ),                                                              // 6460
                                                                                                                     // 6461
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },                                         // 6462
	cssNormalTransform = {                                                                                              // 6463
		letterSpacing: 0,                                                                                                  // 6464
		fontWeight: 400                                                                                                    // 6465
	},                                                                                                                  // 6466
                                                                                                                     // 6467
	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ];                                                                       // 6468
                                                                                                                     // 6469
                                                                                                                     // 6470
// return a css property mapped to a potentially vendor prefixed property                                            // 6471
function vendorPropName( style, name ) {                                                                             // 6472
                                                                                                                     // 6473
	// shortcut for names that are not vendor prefixed                                                                  // 6474
	if ( name in style ) {                                                                                              // 6475
		return name;                                                                                                       // 6476
	}                                                                                                                   // 6477
                                                                                                                     // 6478
	// check for vendor prefixed names                                                                                  // 6479
	var capName = name.charAt(0).toUpperCase() + name.slice(1),                                                         // 6480
		origName = name,                                                                                                   // 6481
		i = cssPrefixes.length;                                                                                            // 6482
                                                                                                                     // 6483
	while ( i-- ) {                                                                                                     // 6484
		name = cssPrefixes[ i ] + capName;                                                                                 // 6485
		if ( name in style ) {                                                                                             // 6486
			return name;                                                                                                      // 6487
		}                                                                                                                  // 6488
	}                                                                                                                   // 6489
                                                                                                                     // 6490
	return origName;                                                                                                    // 6491
}                                                                                                                    // 6492
                                                                                                                     // 6493
function showHide( elements, show ) {                                                                                // 6494
	var display, elem, hidden,                                                                                          // 6495
		values = [],                                                                                                       // 6496
		index = 0,                                                                                                         // 6497
		length = elements.length;                                                                                          // 6498
                                                                                                                     // 6499
	for ( ; index < length; index++ ) {                                                                                 // 6500
		elem = elements[ index ];                                                                                          // 6501
		if ( !elem.style ) {                                                                                               // 6502
			continue;                                                                                                         // 6503
		}                                                                                                                  // 6504
                                                                                                                     // 6505
		values[ index ] = jQuery._data( elem, "olddisplay" );                                                              // 6506
		display = elem.style.display;                                                                                      // 6507
		if ( show ) {                                                                                                      // 6508
			// Reset the inline display of this element to learn if it is                                                     // 6509
			// being hidden by cascaded rules or not                                                                          // 6510
			if ( !values[ index ] && display === "none" ) {                                                                   // 6511
				elem.style.display = "";                                                                                         // 6512
			}                                                                                                                 // 6513
                                                                                                                     // 6514
			// Set elements which have been overridden with display: none                                                     // 6515
			// in a stylesheet to whatever the default browser style is                                                       // 6516
			// for such an element                                                                                            // 6517
			if ( elem.style.display === "" && isHidden( elem ) ) {                                                            // 6518
				values[ index ] = jQuery._data( elem, "olddisplay", defaultDisplay(elem.nodeName) );                             // 6519
			}                                                                                                                 // 6520
		} else {                                                                                                           // 6521
                                                                                                                     // 6522
			if ( !values[ index ] ) {                                                                                         // 6523
				hidden = isHidden( elem );                                                                                       // 6524
                                                                                                                     // 6525
				if ( display && display !== "none" || !hidden ) {                                                                // 6526
					jQuery._data( elem, "olddisplay", hidden ? display : jQuery.css( elem, "display" ) );                           // 6527
				}                                                                                                                // 6528
			}                                                                                                                 // 6529
		}                                                                                                                  // 6530
	}                                                                                                                   // 6531
                                                                                                                     // 6532
	// Set the display of most of the elements in a second loop                                                         // 6533
	// to avoid the constant reflow                                                                                     // 6534
	for ( index = 0; index < length; index++ ) {                                                                        // 6535
		elem = elements[ index ];                                                                                          // 6536
		if ( !elem.style ) {                                                                                               // 6537
			continue;                                                                                                         // 6538
		}                                                                                                                  // 6539
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {                                       // 6540
			elem.style.display = show ? values[ index ] || "" : "none";                                                       // 6541
		}                                                                                                                  // 6542
	}                                                                                                                   // 6543
                                                                                                                     // 6544
	return elements;                                                                                                    // 6545
}                                                                                                                    // 6546
                                                                                                                     // 6547
function setPositiveNumber( elem, value, subtract ) {                                                                // 6548
	var matches = rnumsplit.exec( value );                                                                              // 6549
	return matches ?                                                                                                    // 6550
		// Guard against undefined "subtract", e.g., when used as in cssHooks                                              // 6551
		Math.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || "px" ) :                                       // 6552
		value;                                                                                                             // 6553
}                                                                                                                    // 6554
                                                                                                                     // 6555
function augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {                                            // 6556
	var i = extra === ( isBorderBox ? "border" : "content" ) ?                                                          // 6557
		// If we already have the right measurement, avoid augmentation                                                    // 6558
		4 :                                                                                                                // 6559
		// Otherwise initialize for horizontal or vertical properties                                                      // 6560
		name === "width" ? 1 : 0,                                                                                          // 6561
                                                                                                                     // 6562
		val = 0;                                                                                                           // 6563
                                                                                                                     // 6564
	for ( ; i < 4; i += 2 ) {                                                                                           // 6565
		// both box models exclude margin, so add it if we want it                                                         // 6566
		if ( extra === "margin" ) {                                                                                        // 6567
			val += jQuery.css( elem, extra + cssExpand[ i ], true, styles );                                                  // 6568
		}                                                                                                                  // 6569
                                                                                                                     // 6570
		if ( isBorderBox ) {                                                                                               // 6571
			// border-box includes padding, so remove it if we want content                                                   // 6572
			if ( extra === "content" ) {                                                                                      // 6573
				val -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );                                             // 6574
			}                                                                                                                 // 6575
                                                                                                                     // 6576
			// at this point, extra isn't border nor margin, so remove border                                                 // 6577
			if ( extra !== "margin" ) {                                                                                       // 6578
				val -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );                                    // 6579
			}                                                                                                                 // 6580
		} else {                                                                                                           // 6581
			// at this point, extra isn't content, so add padding                                                             // 6582
			val += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );                                              // 6583
                                                                                                                     // 6584
			// at this point, extra isn't content nor padding, so add border                                                  // 6585
			if ( extra !== "padding" ) {                                                                                      // 6586
				val += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );                                    // 6587
			}                                                                                                                 // 6588
		}                                                                                                                  // 6589
	}                                                                                                                   // 6590
                                                                                                                     // 6591
	return val;                                                                                                         // 6592
}                                                                                                                    // 6593
                                                                                                                     // 6594
function getWidthOrHeight( elem, name, extra ) {                                                                     // 6595
                                                                                                                     // 6596
	// Start with offset property, which is equivalent to the border-box value                                          // 6597
	var valueIsBorderBox = true,                                                                                        // 6598
		val = name === "width" ? elem.offsetWidth : elem.offsetHeight,                                                     // 6599
		styles = getStyles( elem ),                                                                                        // 6600
		isBorderBox = support.boxSizing() && jQuery.css( elem, "boxSizing", false, styles ) === "border-box";              // 6601
                                                                                                                     // 6602
	// some non-html elements return undefined for offsetWidth, so check for null/undefined                             // 6603
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285                                                        // 6604
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668                                                     // 6605
	if ( val <= 0 || val == null ) {                                                                                    // 6606
		// Fall back to computed then uncomputed css if necessary                                                          // 6607
		val = curCSS( elem, name, styles );                                                                                // 6608
		if ( val < 0 || val == null ) {                                                                                    // 6609
			val = elem.style[ name ];                                                                                         // 6610
		}                                                                                                                  // 6611
                                                                                                                     // 6612
		// Computed unit is not pixels. Stop here and return.                                                              // 6613
		if ( rnumnonpx.test(val) ) {                                                                                       // 6614
			return val;                                                                                                       // 6615
		}                                                                                                                  // 6616
                                                                                                                     // 6617
		// we need the check for style in case a browser which returns unreliable values                                   // 6618
		// for getComputedStyle silently falls back to the reliable elem.style                                             // 6619
		valueIsBorderBox = isBorderBox && ( support.boxSizingReliable() || val === elem.style[ name ] );                   // 6620
                                                                                                                     // 6621
		// Normalize "", auto, and prepare for extra                                                                       // 6622
		val = parseFloat( val ) || 0;                                                                                      // 6623
	}                                                                                                                   // 6624
                                                                                                                     // 6625
	// use the active box-sizing model to add/subtract irrelevant styles                                                // 6626
	return ( val +                                                                                                      // 6627
		augmentWidthOrHeight(                                                                                              // 6628
			elem,                                                                                                             // 6629
			name,                                                                                                             // 6630
			extra || ( isBorderBox ? "border" : "content" ),                                                                  // 6631
			valueIsBorderBox,                                                                                                 // 6632
			styles                                                                                                            // 6633
		)                                                                                                                  // 6634
	) + "px";                                                                                                           // 6635
}                                                                                                                    // 6636
                                                                                                                     // 6637
jQuery.extend({                                                                                                      // 6638
	// Add in style property hooks for overriding the default                                                           // 6639
	// behavior of getting and setting a style property                                                                 // 6640
	cssHooks: {                                                                                                         // 6641
		opacity: {                                                                                                         // 6642
			get: function( elem, computed ) {                                                                                 // 6643
				if ( computed ) {                                                                                                // 6644
					// We should always get a number back from opacity                                                              // 6645
					var ret = curCSS( elem, "opacity" );                                                                            // 6646
					return ret === "" ? "1" : ret;                                                                                  // 6647
				}                                                                                                                // 6648
			}                                                                                                                 // 6649
		}                                                                                                                  // 6650
	},                                                                                                                  // 6651
                                                                                                                     // 6652
	// Don't automatically add "px" to these possibly-unitless properties                                               // 6653
	cssNumber: {                                                                                                        // 6654
		"columnCount": true,                                                                                               // 6655
		"fillOpacity": true,                                                                                               // 6656
		"fontWeight": true,                                                                                                // 6657
		"lineHeight": true,                                                                                                // 6658
		"opacity": true,                                                                                                   // 6659
		"order": true,                                                                                                     // 6660
		"orphans": true,                                                                                                   // 6661
		"widows": true,                                                                                                    // 6662
		"zIndex": true,                                                                                                    // 6663
		"zoom": true                                                                                                       // 6664
	},                                                                                                                  // 6665
                                                                                                                     // 6666
	// Add in properties whose names you wish to fix before                                                             // 6667
	// setting or getting the value                                                                                     // 6668
	cssProps: {                                                                                                         // 6669
		// normalize float css property                                                                                    // 6670
		"float": support.cssFloat ? "cssFloat" : "styleFloat"                                                              // 6671
	},                                                                                                                  // 6672
                                                                                                                     // 6673
	// Get and set the style property on a DOM Node                                                                     // 6674
	style: function( elem, name, value, extra ) {                                                                       // 6675
		// Don't set styles on text and comment nodes                                                                      // 6676
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {                                        // 6677
			return;                                                                                                           // 6678
		}                                                                                                                  // 6679
                                                                                                                     // 6680
		// Make sure that we're working with the right name                                                                // 6681
		var ret, type, hooks,                                                                                              // 6682
			origName = jQuery.camelCase( name ),                                                                              // 6683
			style = elem.style;                                                                                               // 6684
                                                                                                                     // 6685
		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( style, origName ) );         // 6686
                                                                                                                     // 6687
		// gets hook for the prefixed version                                                                              // 6688
		// followed by the unprefixed version                                                                              // 6689
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];                                                    // 6690
                                                                                                                     // 6691
		// Check if we're setting a value                                                                                  // 6692
		if ( value !== undefined ) {                                                                                       // 6693
			type = typeof value;                                                                                              // 6694
                                                                                                                     // 6695
			// convert relative number strings (+= or -=) to relative numbers. #7345                                          // 6696
			if ( type === "string" && (ret = rrelNum.exec( value )) ) {                                                       // 6697
				value = ( ret[1] + 1 ) * ret[2] + parseFloat( jQuery.css( elem, name ) );                                        // 6698
				// Fixes bug #9237                                                                                               // 6699
				type = "number";                                                                                                 // 6700
			}                                                                                                                 // 6701
                                                                                                                     // 6702
			// Make sure that null and NaN values aren't set. See: #7116                                                      // 6703
			if ( value == null || value !== value ) {                                                                         // 6704
				return;                                                                                                          // 6705
			}                                                                                                                 // 6706
                                                                                                                     // 6707
			// If a number was passed in, add 'px' to the (except for certain CSS properties)                                 // 6708
			if ( type === "number" && !jQuery.cssNumber[ origName ] ) {                                                       // 6709
				value += "px";                                                                                                   // 6710
			}                                                                                                                 // 6711
                                                                                                                     // 6712
			// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,                                   // 6713
			// but it would mean to define eight (for every problematic property) identical functions                         // 6714
			if ( !support.clearCloneStyle && value === "" && name.indexOf("background") === 0 ) {                             // 6715
				style[ name ] = "inherit";                                                                                       // 6716
			}                                                                                                                 // 6717
                                                                                                                     // 6718
			// If a hook was provided, use that value, otherwise just set the specified value                                 // 6719
			if ( !hooks || !("set" in hooks) || (value = hooks.set( elem, value, extra )) !== undefined ) {                   // 6720
                                                                                                                     // 6721
				// Support: IE                                                                                                   // 6722
				// Swallow errors from 'invalid' CSS values (#5509)                                                              // 6723
				try {                                                                                                            // 6724
					// Support: Chrome, Safari                                                                                      // 6725
					// Setting style to blank string required to delete "style: x !important;"                                      // 6726
					style[ name ] = "";                                                                                             // 6727
					style[ name ] = value;                                                                                          // 6728
				} catch(e) {}                                                                                                    // 6729
			}                                                                                                                 // 6730
                                                                                                                     // 6731
		} else {                                                                                                           // 6732
			// If a hook was provided get the non-computed value from there                                                   // 6733
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {                         // 6734
				return ret;                                                                                                      // 6735
			}                                                                                                                 // 6736
                                                                                                                     // 6737
			// Otherwise just get the value from the style object                                                             // 6738
			return style[ name ];                                                                                             // 6739
		}                                                                                                                  // 6740
	},                                                                                                                  // 6741
                                                                                                                     // 6742
	css: function( elem, name, extra, styles ) {                                                                        // 6743
		var num, val, hooks,                                                                                               // 6744
			origName = jQuery.camelCase( name );                                                                              // 6745
                                                                                                                     // 6746
		// Make sure that we're working with the right name                                                                // 6747
		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( elem.style, origName ) );    // 6748
                                                                                                                     // 6749
		// gets hook for the prefixed version                                                                              // 6750
		// followed by the unprefixed version                                                                              // 6751
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];                                                    // 6752
                                                                                                                     // 6753
		// If a hook was provided get the computed value from there                                                        // 6754
		if ( hooks && "get" in hooks ) {                                                                                   // 6755
			val = hooks.get( elem, true, extra );                                                                             // 6756
		}                                                                                                                  // 6757
                                                                                                                     // 6758
		// Otherwise, if a way to get the computed value exists, use that                                                  // 6759
		if ( val === undefined ) {                                                                                         // 6760
			val = curCSS( elem, name, styles );                                                                               // 6761
		}                                                                                                                  // 6762
                                                                                                                     // 6763
		//convert "normal" to computed value                                                                               // 6764
		if ( val === "normal" && name in cssNormalTransform ) {                                                            // 6765
			val = cssNormalTransform[ name ];                                                                                 // 6766
		}                                                                                                                  // 6767
                                                                                                                     // 6768
		// Return, converting to number if forced or a qualifier was provided and val looks numeric                        // 6769
		if ( extra === "" || extra ) {                                                                                     // 6770
			num = parseFloat( val );                                                                                          // 6771
			return extra === true || jQuery.isNumeric( num ) ? num || 0 : val;                                                // 6772
		}                                                                                                                  // 6773
		return val;                                                                                                        // 6774
	}                                                                                                                   // 6775
});                                                                                                                  // 6776
                                                                                                                     // 6777
jQuery.each([ "height", "width" ], function( i, name ) {                                                             // 6778
	jQuery.cssHooks[ name ] = {                                                                                         // 6779
		get: function( elem, computed, extra ) {                                                                           // 6780
			if ( computed ) {                                                                                                 // 6781
				// certain elements can have dimension info if we invisibly show them                                            // 6782
				// however, it must have a current display style that would benefit from this                                    // 6783
				return elem.offsetWidth === 0 && rdisplayswap.test( jQuery.css( elem, "display" ) ) ?                            // 6784
					jQuery.swap( elem, cssShow, function() {                                                                        // 6785
						return getWidthOrHeight( elem, name, extra );                                                                  // 6786
					}) :                                                                                                            // 6787
					getWidthOrHeight( elem, name, extra );                                                                          // 6788
			}                                                                                                                 // 6789
		},                                                                                                                 // 6790
                                                                                                                     // 6791
		set: function( elem, value, extra ) {                                                                              // 6792
			var styles = extra && getStyles( elem );                                                                          // 6793
			return setPositiveNumber( elem, value, extra ?                                                                    // 6794
				augmentWidthOrHeight(                                                                                            // 6795
					elem,                                                                                                           // 6796
					name,                                                                                                           // 6797
					extra,                                                                                                          // 6798
					support.boxSizing() && jQuery.css( elem, "boxSizing", false, styles ) === "border-box",                         // 6799
					styles                                                                                                          // 6800
				) : 0                                                                                                            // 6801
			);                                                                                                                // 6802
		}                                                                                                                  // 6803
	};                                                                                                                  // 6804
});                                                                                                                  // 6805
                                                                                                                     // 6806
if ( !support.opacity ) {                                                                                            // 6807
	jQuery.cssHooks.opacity = {                                                                                         // 6808
		get: function( elem, computed ) {                                                                                  // 6809
			// IE uses filters for opacity                                                                                    // 6810
			return ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "" ) ?    // 6811
				( 0.01 * parseFloat( RegExp.$1 ) ) + "" :                                                                        // 6812
				computed ? "1" : "";                                                                                             // 6813
		},                                                                                                                 // 6814
                                                                                                                     // 6815
		set: function( elem, value ) {                                                                                     // 6816
			var style = elem.style,                                                                                           // 6817
				currentStyle = elem.currentStyle,                                                                                // 6818
				opacity = jQuery.isNumeric( value ) ? "alpha(opacity=" + value * 100 + ")" : "",                                 // 6819
				filter = currentStyle && currentStyle.filter || style.filter || "";                                              // 6820
                                                                                                                     // 6821
			// IE has trouble with opacity if it does not have layout                                                         // 6822
			// Force it by setting the zoom level                                                                             // 6823
			style.zoom = 1;                                                                                                   // 6824
                                                                                                                     // 6825
			// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652                 // 6826
			// if value === "", then remove inline opacity #12685                                                             // 6827
			if ( ( value >= 1 || value === "" ) &&                                                                            // 6828
					jQuery.trim( filter.replace( ralpha, "" ) ) === "" &&                                                           // 6829
					style.removeAttribute ) {                                                                                       // 6830
                                                                                                                     // 6831
				// Setting style.filter to null, "" & " " still leave "filter:" in the cssText                                   // 6832
				// if "filter:" is present at all, clearType is disabled, we want to avoid this                                  // 6833
				// style.removeAttribute is IE Only, but so apparently is this code path...                                      // 6834
				style.removeAttribute( "filter" );                                                                               // 6835
                                                                                                                     // 6836
				// if there is no filter style applied in a css rule or unset inline opacity, we are done                        // 6837
				if ( value === "" || currentStyle && !currentStyle.filter ) {                                                    // 6838
					return;                                                                                                         // 6839
				}                                                                                                                // 6840
			}                                                                                                                 // 6841
                                                                                                                     // 6842
			// otherwise, set new filter values                                                                               // 6843
			style.filter = ralpha.test( filter ) ?                                                                            // 6844
				filter.replace( ralpha, opacity ) :                                                                              // 6845
				filter + " " + opacity;                                                                                          // 6846
		}                                                                                                                  // 6847
	};                                                                                                                  // 6848
}                                                                                                                    // 6849
                                                                                                                     // 6850
jQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,                                             // 6851
	function( elem, computed ) {                                                                                        // 6852
		if ( computed ) {                                                                                                  // 6853
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right                                       // 6854
			// Work around by temporarily setting element display to inline-block                                             // 6855
			return jQuery.swap( elem, { "display": "inline-block" },                                                          // 6856
				curCSS, [ elem, "marginRight" ] );                                                                               // 6857
		}                                                                                                                  // 6858
	}                                                                                                                   // 6859
);                                                                                                                   // 6860
                                                                                                                     // 6861
// These hooks are used by animate to expand properties                                                              // 6862
jQuery.each({                                                                                                        // 6863
	margin: "",                                                                                                         // 6864
	padding: "",                                                                                                        // 6865
	border: "Width"                                                                                                     // 6866
}, function( prefix, suffix ) {                                                                                      // 6867
	jQuery.cssHooks[ prefix + suffix ] = {                                                                              // 6868
		expand: function( value ) {                                                                                        // 6869
			var i = 0,                                                                                                        // 6870
				expanded = {},                                                                                                   // 6871
                                                                                                                     // 6872
				// assumes a single number if not a string                                                                       // 6873
				parts = typeof value === "string" ? value.split(" ") : [ value ];                                                // 6874
                                                                                                                     // 6875
			for ( ; i < 4; i++ ) {                                                                                            // 6876
				expanded[ prefix + cssExpand[ i ] + suffix ] =                                                                   // 6877
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];                                                                     // 6878
			}                                                                                                                 // 6879
                                                                                                                     // 6880
			return expanded;                                                                                                  // 6881
		}                                                                                                                  // 6882
	};                                                                                                                  // 6883
                                                                                                                     // 6884
	if ( !rmargin.test( prefix ) ) {                                                                                    // 6885
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;                                                        // 6886
	}                                                                                                                   // 6887
});                                                                                                                  // 6888
                                                                                                                     // 6889
jQuery.fn.extend({                                                                                                   // 6890
	css: function( name, value ) {                                                                                      // 6891
		return access( this, function( elem, name, value ) {                                                               // 6892
			var styles, len,                                                                                                  // 6893
				map = {},                                                                                                        // 6894
				i = 0;                                                                                                           // 6895
                                                                                                                     // 6896
			if ( jQuery.isArray( name ) ) {                                                                                   // 6897
				styles = getStyles( elem );                                                                                      // 6898
				len = name.length;                                                                                               // 6899
                                                                                                                     // 6900
				for ( ; i < len; i++ ) {                                                                                         // 6901
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );                                                // 6902
				}                                                                                                                // 6903
                                                                                                                     // 6904
				return map;                                                                                                      // 6905
			}                                                                                                                 // 6906
                                                                                                                     // 6907
			return value !== undefined ?                                                                                      // 6908
				jQuery.style( elem, name, value ) :                                                                              // 6909
				jQuery.css( elem, name );                                                                                        // 6910
		}, name, value, arguments.length > 1 );                                                                            // 6911
	},                                                                                                                  // 6912
	show: function() {                                                                                                  // 6913
		return showHide( this, true );                                                                                     // 6914
	},                                                                                                                  // 6915
	hide: function() {                                                                                                  // 6916
		return showHide( this );                                                                                           // 6917
	},                                                                                                                  // 6918
	toggle: function( state ) {                                                                                         // 6919
		if ( typeof state === "boolean" ) {                                                                                // 6920
			return state ? this.show() : this.hide();                                                                         // 6921
		}                                                                                                                  // 6922
                                                                                                                     // 6923
		return this.each(function() {                                                                                      // 6924
			if ( isHidden( this ) ) {                                                                                         // 6925
				jQuery( this ).show();                                                                                           // 6926
			} else {                                                                                                          // 6927
				jQuery( this ).hide();                                                                                           // 6928
			}                                                                                                                 // 6929
		});                                                                                                                // 6930
	}                                                                                                                   // 6931
});                                                                                                                  // 6932
                                                                                                                     // 6933
                                                                                                                     // 6934
function Tween( elem, options, prop, end, easing ) {                                                                 // 6935
	return new Tween.prototype.init( elem, options, prop, end, easing );                                                // 6936
}                                                                                                                    // 6937
jQuery.Tween = Tween;                                                                                                // 6938
                                                                                                                     // 6939
Tween.prototype = {                                                                                                  // 6940
	constructor: Tween,                                                                                                 // 6941
	init: function( elem, options, prop, end, easing, unit ) {                                                          // 6942
		this.elem = elem;                                                                                                  // 6943
		this.prop = prop;                                                                                                  // 6944
		this.easing = easing || "swing";                                                                                   // 6945
		this.options = options;                                                                                            // 6946
		this.start = this.now = this.cur();                                                                                // 6947
		this.end = end;                                                                                                    // 6948
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );                                                      // 6949
	},                                                                                                                  // 6950
	cur: function() {                                                                                                   // 6951
		var hooks = Tween.propHooks[ this.prop ];                                                                          // 6952
                                                                                                                     // 6953
		return hooks && hooks.get ?                                                                                        // 6954
			hooks.get( this ) :                                                                                               // 6955
			Tween.propHooks._default.get( this );                                                                             // 6956
	},                                                                                                                  // 6957
	run: function( percent ) {                                                                                          // 6958
		var eased,                                                                                                         // 6959
			hooks = Tween.propHooks[ this.prop ];                                                                             // 6960
                                                                                                                     // 6961
		if ( this.options.duration ) {                                                                                     // 6962
			this.pos = eased = jQuery.easing[ this.easing ](                                                                  // 6963
				percent, this.options.duration * percent, 0, 1, this.options.duration                                            // 6964
			);                                                                                                                // 6965
		} else {                                                                                                           // 6966
			this.pos = eased = percent;                                                                                       // 6967
		}                                                                                                                  // 6968
		this.now = ( this.end - this.start ) * eased + this.start;                                                         // 6969
                                                                                                                     // 6970
		if ( this.options.step ) {                                                                                         // 6971
			this.options.step.call( this.elem, this.now, this );                                                              // 6972
		}                                                                                                                  // 6973
                                                                                                                     // 6974
		if ( hooks && hooks.set ) {                                                                                        // 6975
			hooks.set( this );                                                                                                // 6976
		} else {                                                                                                           // 6977
			Tween.propHooks._default.set( this );                                                                             // 6978
		}                                                                                                                  // 6979
		return this;                                                                                                       // 6980
	}                                                                                                                   // 6981
};                                                                                                                   // 6982
                                                                                                                     // 6983
Tween.prototype.init.prototype = Tween.prototype;                                                                    // 6984
                                                                                                                     // 6985
Tween.propHooks = {                                                                                                  // 6986
	_default: {                                                                                                         // 6987
		get: function( tween ) {                                                                                           // 6988
			var result;                                                                                                       // 6989
                                                                                                                     // 6990
			if ( tween.elem[ tween.prop ] != null &&                                                                          // 6991
				(!tween.elem.style || tween.elem.style[ tween.prop ] == null) ) {                                                // 6992
				return tween.elem[ tween.prop ];                                                                                 // 6993
			}                                                                                                                 // 6994
                                                                                                                     // 6995
			// passing an empty string as a 3rd parameter to .css will automatically                                          // 6996
			// attempt a parseFloat and fallback to a string if the parse fails                                               // 6997
			// so, simple values such as "10px" are parsed to Float.                                                          // 6998
			// complex values such as "rotate(1rad)" are returned as is.                                                      // 6999
			result = jQuery.css( tween.elem, tween.prop, "" );                                                                // 7000
			// Empty strings, null, undefined and "auto" are converted to 0.                                                  // 7001
			return !result || result === "auto" ? 0 : result;                                                                 // 7002
		},                                                                                                                 // 7003
		set: function( tween ) {                                                                                           // 7004
			// use step hook for back compat - use cssHook if its there - use .style if its                                   // 7005
			// available and use plain properties where available                                                             // 7006
			if ( jQuery.fx.step[ tween.prop ] ) {                                                                             // 7007
				jQuery.fx.step[ tween.prop ]( tween );                                                                           // 7008
			} else if ( tween.elem.style && ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null || jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );                                                  // 7010
			} else {                                                                                                          // 7011
				tween.elem[ tween.prop ] = tween.now;                                                                            // 7012
			}                                                                                                                 // 7013
		}                                                                                                                  // 7014
	}                                                                                                                   // 7015
};                                                                                                                   // 7016
                                                                                                                     // 7017
// Support: IE <=9                                                                                                   // 7018
// Panic based approach to setting things on disconnected nodes                                                      // 7019
                                                                                                                     // 7020
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {                                                           // 7021
	set: function( tween ) {                                                                                            // 7022
		if ( tween.elem.nodeType && tween.elem.parentNode ) {                                                              // 7023
			tween.elem[ tween.prop ] = tween.now;                                                                             // 7024
		}                                                                                                                  // 7025
	}                                                                                                                   // 7026
};                                                                                                                   // 7027
                                                                                                                     // 7028
jQuery.easing = {                                                                                                    // 7029
	linear: function( p ) {                                                                                             // 7030
		return p;                                                                                                          // 7031
	},                                                                                                                  // 7032
	swing: function( p ) {                                                                                              // 7033
		return 0.5 - Math.cos( p * Math.PI ) / 2;                                                                          // 7034
	}                                                                                                                   // 7035
};                                                                                                                   // 7036
                                                                                                                     // 7037
jQuery.fx = Tween.prototype.init;                                                                                    // 7038
                                                                                                                     // 7039
// Back Compat <1.8 extension point                                                                                  // 7040
jQuery.fx.step = {};                                                                                                 // 7041
                                                                                                                     // 7042
                                                                                                                     // 7043
                                                                                                                     // 7044
                                                                                                                     // 7045
var                                                                                                                  // 7046
	fxNow, timerId,                                                                                                     // 7047
	rfxtypes = /^(?:toggle|show|hide)$/,                                                                                // 7048
	rfxnum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" ),                                                // 7049
	rrun = /queueHooks$/,                                                                                               // 7050
	animationPrefilters = [ defaultPrefilter ],                                                                         // 7051
	tweeners = {                                                                                                        // 7052
		"*": [ function( prop, value ) {                                                                                   // 7053
			var tween = this.createTween( prop, value ),                                                                      // 7054
				target = tween.cur(),                                                                                            // 7055
				parts = rfxnum.exec( value ),                                                                                    // 7056
				unit = parts && parts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),                                          // 7057
                                                                                                                     // 7058
				// Starting value computation is required for potential unit mismatches                                          // 7059
				start = ( jQuery.cssNumber[ prop ] || unit !== "px" && +target ) &&                                              // 7060
					rfxnum.exec( jQuery.css( tween.elem, prop ) ),                                                                  // 7061
				scale = 1,                                                                                                       // 7062
				maxIterations = 20;                                                                                              // 7063
                                                                                                                     // 7064
			if ( start && start[ 3 ] !== unit ) {                                                                             // 7065
				// Trust units reported by jQuery.css                                                                            // 7066
				unit = unit || start[ 3 ];                                                                                       // 7067
                                                                                                                     // 7068
				// Make sure we update the tween properties later on                                                             // 7069
				parts = parts || [];                                                                                             // 7070
                                                                                                                     // 7071
				// Iteratively approximate from a nonzero starting point                                                         // 7072
				start = +target || 1;                                                                                            // 7073
                                                                                                                     // 7074
				do {                                                                                                             // 7075
					// If previous iteration zeroed out, double until we get *something*                                            // 7076
					// Use a string for doubling factor so we don't accidentally see scale as unchanged below                       // 7077
					scale = scale || ".5";                                                                                          // 7078
                                                                                                                     // 7079
					// Adjust and apply                                                                                             // 7080
					start = start / scale;                                                                                          // 7081
					jQuery.style( tween.elem, prop, start + unit );                                                                 // 7082
                                                                                                                     // 7083
				// Update scale, tolerating zero or NaN from tween.cur()                                                         // 7084
				// And breaking the loop if scale is unchanged or perfect, or if we've just had enough                           // 7085
				} while ( scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations );                          // 7086
			}                                                                                                                 // 7087
                                                                                                                     // 7088
			// Update tween properties                                                                                        // 7089
			if ( parts ) {                                                                                                    // 7090
				start = tween.start = +start || +target || 0;                                                                    // 7091
				tween.unit = unit;                                                                                               // 7092
				// If a +=/-= token was provided, we're doing a relative animation                                               // 7093
				tween.end = parts[ 1 ] ?                                                                                         // 7094
					start + ( parts[ 1 ] + 1 ) * parts[ 2 ] :                                                                       // 7095
					+parts[ 2 ];                                                                                                    // 7096
			}                                                                                                                 // 7097
                                                                                                                     // 7098
			return tween;                                                                                                     // 7099
		} ]                                                                                                                // 7100
	};                                                                                                                  // 7101
                                                                                                                     // 7102
// Animations created synchronously will run synchronously                                                           // 7103
function createFxNow() {                                                                                             // 7104
	setTimeout(function() {                                                                                             // 7105
		fxNow = undefined;                                                                                                 // 7106
	});                                                                                                                 // 7107
	return ( fxNow = jQuery.now() );                                                                                    // 7108
}                                                                                                                    // 7109
                                                                                                                     // 7110
// Generate parameters to create a standard animation                                                                // 7111
function genFx( type, includeWidth ) {                                                                               // 7112
	var which,                                                                                                          // 7113
		attrs = { height: type },                                                                                          // 7114
		i = 0;                                                                                                             // 7115
                                                                                                                     // 7116
	// if we include width, step value is 1 to do all cssExpand values,                                                 // 7117
	// if we don't include width, step value is 2 to skip over Left and Right                                           // 7118
	includeWidth = includeWidth ? 1 : 0;                                                                                // 7119
	for ( ; i < 4 ; i += 2 - includeWidth ) {                                                                           // 7120
		which = cssExpand[ i ];                                                                                            // 7121
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;                                                     // 7122
	}                                                                                                                   // 7123
                                                                                                                     // 7124
	if ( includeWidth ) {                                                                                               // 7125
		attrs.opacity = attrs.width = type;                                                                                // 7126
	}                                                                                                                   // 7127
                                                                                                                     // 7128
	return attrs;                                                                                                       // 7129
}                                                                                                                    // 7130
                                                                                                                     // 7131
function createTween( value, prop, animation ) {                                                                     // 7132
	var tween,                                                                                                          // 7133
		collection = ( tweeners[ prop ] || [] ).concat( tweeners[ "*" ] ),                                                 // 7134
		index = 0,                                                                                                         // 7135
		length = collection.length;                                                                                        // 7136
	for ( ; index < length; index++ ) {                                                                                 // 7137
		if ( (tween = collection[ index ].call( animation, prop, value )) ) {                                              // 7138
                                                                                                                     // 7139
			// we're done with this property                                                                                  // 7140
			return tween;                                                                                                     // 7141
		}                                                                                                                  // 7142
	}                                                                                                                   // 7143
}                                                                                                                    // 7144
                                                                                                                     // 7145
function defaultPrefilter( elem, props, opts ) {                                                                     // 7146
	/* jshint validthis: true */                                                                                        // 7147
	var prop, value, toggle, tween, hooks, oldfire, display, dDisplay,                                                  // 7148
		anim = this,                                                                                                       // 7149
		orig = {},                                                                                                         // 7150
		style = elem.style,                                                                                                // 7151
		hidden = elem.nodeType && isHidden( elem ),                                                                        // 7152
		dataShow = jQuery._data( elem, "fxshow" );                                                                         // 7153
                                                                                                                     // 7154
	// handle queue: false promises                                                                                     // 7155
	if ( !opts.queue ) {                                                                                                // 7156
		hooks = jQuery._queueHooks( elem, "fx" );                                                                          // 7157
		if ( hooks.unqueued == null ) {                                                                                    // 7158
			hooks.unqueued = 0;                                                                                               // 7159
			oldfire = hooks.empty.fire;                                                                                       // 7160
			hooks.empty.fire = function() {                                                                                   // 7161
				if ( !hooks.unqueued ) {                                                                                         // 7162
					oldfire();                                                                                                      // 7163
				}                                                                                                                // 7164
			};                                                                                                                // 7165
		}                                                                                                                  // 7166
		hooks.unqueued++;                                                                                                  // 7167
                                                                                                                     // 7168
		anim.always(function() {                                                                                           // 7169
			// doing this makes sure that the complete handler will be called                                                 // 7170
			// before this completes                                                                                          // 7171
			anim.always(function() {                                                                                          // 7172
				hooks.unqueued--;                                                                                                // 7173
				if ( !jQuery.queue( elem, "fx" ).length ) {                                                                      // 7174
					hooks.empty.fire();                                                                                             // 7175
				}                                                                                                                // 7176
			});                                                                                                               // 7177
		});                                                                                                                // 7178
	}                                                                                                                   // 7179
                                                                                                                     // 7180
	// height/width overflow pass                                                                                       // 7181
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {                                           // 7182
		// Make sure that nothing sneaks out                                                                               // 7183
		// Record all 3 overflow attributes because IE does not                                                            // 7184
		// change the overflow attribute when overflowX and                                                                // 7185
		// overflowY are set to the same value                                                                             // 7186
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];                                              // 7187
                                                                                                                     // 7188
		// Set display property to inline-block for height/width                                                           // 7189
		// animations on inline elements that are having width/height animated                                             // 7190
		display = jQuery.css( elem, "display" );                                                                           // 7191
		dDisplay = defaultDisplay( elem.nodeName );                                                                        // 7192
		if ( display === "none" ) {                                                                                        // 7193
			display = dDisplay;                                                                                               // 7194
		}                                                                                                                  // 7195
		if ( display === "inline" &&                                                                                       // 7196
				jQuery.css( elem, "float" ) === "none" ) {                                                                       // 7197
                                                                                                                     // 7198
			// inline-level elements accept inline-block;                                                                     // 7199
			// block-level elements need to be inline with layout                                                             // 7200
			if ( !support.inlineBlockNeedsLayout || dDisplay === "inline" ) {                                                 // 7201
				style.display = "inline-block";                                                                                  // 7202
			} else {                                                                                                          // 7203
				style.zoom = 1;                                                                                                  // 7204
			}                                                                                                                 // 7205
		}                                                                                                                  // 7206
	}                                                                                                                   // 7207
                                                                                                                     // 7208
	if ( opts.overflow ) {                                                                                              // 7209
		style.overflow = "hidden";                                                                                         // 7210
		if ( !support.shrinkWrapBlocks() ) {                                                                               // 7211
			anim.always(function() {                                                                                          // 7212
				style.overflow = opts.overflow[ 0 ];                                                                             // 7213
				style.overflowX = opts.overflow[ 1 ];                                                                            // 7214
				style.overflowY = opts.overflow[ 2 ];                                                                            // 7215
			});                                                                                                               // 7216
		}                                                                                                                  // 7217
	}                                                                                                                   // 7218
                                                                                                                     // 7219
	// show/hide pass                                                                                                   // 7220
	for ( prop in props ) {                                                                                             // 7221
		value = props[ prop ];                                                                                             // 7222
		if ( rfxtypes.exec( value ) ) {                                                                                    // 7223
			delete props[ prop ];                                                                                             // 7224
			toggle = toggle || value === "toggle";                                                                            // 7225
			if ( value === ( hidden ? "hide" : "show" ) ) {                                                                   // 7226
                                                                                                                     // 7227
				// If there is dataShow left over from a stopped hide or show and we are going to proceed with show, we should pretend to be hidden
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {                                          // 7229
					hidden = true;                                                                                                  // 7230
				} else {                                                                                                         // 7231
					continue;                                                                                                       // 7232
				}                                                                                                                // 7233
			}                                                                                                                 // 7234
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );                                        // 7235
		}                                                                                                                  // 7236
	}                                                                                                                   // 7237
                                                                                                                     // 7238
	if ( !jQuery.isEmptyObject( orig ) ) {                                                                              // 7239
		if ( dataShow ) {                                                                                                  // 7240
			if ( "hidden" in dataShow ) {                                                                                     // 7241
				hidden = dataShow.hidden;                                                                                        // 7242
			}                                                                                                                 // 7243
		} else {                                                                                                           // 7244
			dataShow = jQuery._data( elem, "fxshow", {} );                                                                    // 7245
		}                                                                                                                  // 7246
                                                                                                                     // 7247
		// store state if its toggle - enables .stop().toggle() to "reverse"                                               // 7248
		if ( toggle ) {                                                                                                    // 7249
			dataShow.hidden = !hidden;                                                                                        // 7250
		}                                                                                                                  // 7251
		if ( hidden ) {                                                                                                    // 7252
			jQuery( elem ).show();                                                                                            // 7253
		} else {                                                                                                           // 7254
			anim.done(function() {                                                                                            // 7255
				jQuery( elem ).hide();                                                                                           // 7256
			});                                                                                                               // 7257
		}                                                                                                                  // 7258
		anim.done(function() {                                                                                             // 7259
			var prop;                                                                                                         // 7260
			jQuery._removeData( elem, "fxshow" );                                                                             // 7261
			for ( prop in orig ) {                                                                                            // 7262
				jQuery.style( elem, prop, orig[ prop ] );                                                                        // 7263
			}                                                                                                                 // 7264
		});                                                                                                                // 7265
		for ( prop in orig ) {                                                                                             // 7266
			tween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );                                                 // 7267
                                                                                                                     // 7268
			if ( !( prop in dataShow ) ) {                                                                                    // 7269
				dataShow[ prop ] = tween.start;                                                                                  // 7270
				if ( hidden ) {                                                                                                  // 7271
					tween.end = tween.start;                                                                                        // 7272
					tween.start = prop === "width" || prop === "height" ? 1 : 0;                                                    // 7273
				}                                                                                                                // 7274
			}                                                                                                                 // 7275
		}                                                                                                                  // 7276
	}                                                                                                                   // 7277
}                                                                                                                    // 7278
                                                                                                                     // 7279
function propFilter( props, specialEasing ) {                                                                        // 7280
	var index, name, easing, value, hooks;                                                                              // 7281
                                                                                                                     // 7282
	// camelCase, specialEasing and expand cssHook pass                                                                 // 7283
	for ( index in props ) {                                                                                            // 7284
		name = jQuery.camelCase( index );                                                                                  // 7285
		easing = specialEasing[ name ];                                                                                    // 7286
		value = props[ index ];                                                                                            // 7287
		if ( jQuery.isArray( value ) ) {                                                                                   // 7288
			easing = value[ 1 ];                                                                                              // 7289
			value = props[ index ] = value[ 0 ];                                                                              // 7290
		}                                                                                                                  // 7291
                                                                                                                     // 7292
		if ( index !== name ) {                                                                                            // 7293
			props[ name ] = value;                                                                                            // 7294
			delete props[ index ];                                                                                            // 7295
		}                                                                                                                  // 7296
                                                                                                                     // 7297
		hooks = jQuery.cssHooks[ name ];                                                                                   // 7298
		if ( hooks && "expand" in hooks ) {                                                                                // 7299
			value = hooks.expand( value );                                                                                    // 7300
			delete props[ name ];                                                                                             // 7301
                                                                                                                     // 7302
			// not quite $.extend, this wont overwrite keys already present.                                                  // 7303
			// also - reusing 'index' from above because we have the correct "name"                                           // 7304
			for ( index in value ) {                                                                                          // 7305
				if ( !( index in props ) ) {                                                                                     // 7306
					props[ index ] = value[ index ];                                                                                // 7307
					specialEasing[ index ] = easing;                                                                                // 7308
				}                                                                                                                // 7309
			}                                                                                                                 // 7310
		} else {                                                                                                           // 7311
			specialEasing[ name ] = easing;                                                                                   // 7312
		}                                                                                                                  // 7313
	}                                                                                                                   // 7314
}                                                                                                                    // 7315
                                                                                                                     // 7316
function Animation( elem, properties, options ) {                                                                    // 7317
	var result,                                                                                                         // 7318
		stopped,                                                                                                           // 7319
		index = 0,                                                                                                         // 7320
		length = animationPrefilters.length,                                                                               // 7321
		deferred = jQuery.Deferred().always( function() {                                                                  // 7322
			// don't match elem in the :animated selector                                                                     // 7323
			delete tick.elem;                                                                                                 // 7324
		}),                                                                                                                // 7325
		tick = function() {                                                                                                // 7326
			if ( stopped ) {                                                                                                  // 7327
				return false;                                                                                                    // 7328
			}                                                                                                                 // 7329
			var currentTime = fxNow || createFxNow(),                                                                         // 7330
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),                               // 7331
				// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)                                             // 7332
				temp = remaining / animation.duration || 0,                                                                      // 7333
				percent = 1 - temp,                                                                                              // 7334
				index = 0,                                                                                                       // 7335
				length = animation.tweens.length;                                                                                // 7336
                                                                                                                     // 7337
			for ( ; index < length ; index++ ) {                                                                              // 7338
				animation.tweens[ index ].run( percent );                                                                        // 7339
			}                                                                                                                 // 7340
                                                                                                                     // 7341
			deferred.notifyWith( elem, [ animation, percent, remaining ]);                                                    // 7342
                                                                                                                     // 7343
			if ( percent < 1 && length ) {                                                                                    // 7344
				return remaining;                                                                                                // 7345
			} else {                                                                                                          // 7346
				deferred.resolveWith( elem, [ animation ] );                                                                     // 7347
				return false;                                                                                                    // 7348
			}                                                                                                                 // 7349
		},                                                                                                                 // 7350
		animation = deferred.promise({                                                                                     // 7351
			elem: elem,                                                                                                       // 7352
			props: jQuery.extend( {}, properties ),                                                                           // 7353
			opts: jQuery.extend( true, { specialEasing: {} }, options ),                                                      // 7354
			originalProperties: properties,                                                                                   // 7355
			originalOptions: options,                                                                                         // 7356
			startTime: fxNow || createFxNow(),                                                                                // 7357
			duration: options.duration,                                                                                       // 7358
			tweens: [],                                                                                                       // 7359
			createTween: function( prop, end ) {                                                                              // 7360
				var tween = jQuery.Tween( elem, animation.opts, prop, end,                                                       // 7361
						animation.opts.specialEasing[ prop ] || animation.opts.easing );                                               // 7362
				animation.tweens.push( tween );                                                                                  // 7363
				return tween;                                                                                                    // 7364
			},                                                                                                                // 7365
			stop: function( gotoEnd ) {                                                                                       // 7366
				var index = 0,                                                                                                   // 7367
					// if we are going to the end, we want to run all the tweens                                                    // 7368
					// otherwise we skip this part                                                                                  // 7369
					length = gotoEnd ? animation.tweens.length : 0;                                                                 // 7370
				if ( stopped ) {                                                                                                 // 7371
					return this;                                                                                                    // 7372
				}                                                                                                                // 7373
				stopped = true;                                                                                                  // 7374
				for ( ; index < length ; index++ ) {                                                                             // 7375
					animation.tweens[ index ].run( 1 );                                                                             // 7376
				}                                                                                                                // 7377
                                                                                                                     // 7378
				// resolve when we played the last frame                                                                         // 7379
				// otherwise, reject                                                                                             // 7380
				if ( gotoEnd ) {                                                                                                 // 7381
					deferred.resolveWith( elem, [ animation, gotoEnd ] );                                                           // 7382
				} else {                                                                                                         // 7383
					deferred.rejectWith( elem, [ animation, gotoEnd ] );                                                            // 7384
				}                                                                                                                // 7385
				return this;                                                                                                     // 7386
			}                                                                                                                 // 7387
		}),                                                                                                                // 7388
		props = animation.props;                                                                                           // 7389
                                                                                                                     // 7390
	propFilter( props, animation.opts.specialEasing );                                                                  // 7391
                                                                                                                     // 7392
	for ( ; index < length ; index++ ) {                                                                                // 7393
		result = animationPrefilters[ index ].call( animation, elem, props, animation.opts );                              // 7394
		if ( result ) {                                                                                                    // 7395
			return result;                                                                                                    // 7396
		}                                                                                                                  // 7397
	}                                                                                                                   // 7398
                                                                                                                     // 7399
	jQuery.map( props, createTween, animation );                                                                        // 7400
                                                                                                                     // 7401
	if ( jQuery.isFunction( animation.opts.start ) ) {                                                                  // 7402
		animation.opts.start.call( elem, animation );                                                                      // 7403
	}                                                                                                                   // 7404
                                                                                                                     // 7405
	jQuery.fx.timer(                                                                                                    // 7406
		jQuery.extend( tick, {                                                                                             // 7407
			elem: elem,                                                                                                       // 7408
			anim: animation,                                                                                                  // 7409
			queue: animation.opts.queue                                                                                       // 7410
		})                                                                                                                 // 7411
	);                                                                                                                  // 7412
                                                                                                                     // 7413
	// attach callbacks from options                                                                                    // 7414
	return animation.progress( animation.opts.progress )                                                                // 7415
		.done( animation.opts.done, animation.opts.complete )                                                              // 7416
		.fail( animation.opts.fail )                                                                                       // 7417
		.always( animation.opts.always );                                                                                  // 7418
}                                                                                                                    // 7419
                                                                                                                     // 7420
jQuery.Animation = jQuery.extend( Animation, {                                                                       // 7421
	tweener: function( props, callback ) {                                                                              // 7422
		if ( jQuery.isFunction( props ) ) {                                                                                // 7423
			callback = props;                                                                                                 // 7424
			props = [ "*" ];                                                                                                  // 7425
		} else {                                                                                                           // 7426
			props = props.split(" ");                                                                                         // 7427
		}                                                                                                                  // 7428
                                                                                                                     // 7429
		var prop,                                                                                                          // 7430
			index = 0,                                                                                                        // 7431
			length = props.length;                                                                                            // 7432
                                                                                                                     // 7433
		for ( ; index < length ; index++ ) {                                                                               // 7434
			prop = props[ index ];                                                                                            // 7435
			tweeners[ prop ] = tweeners[ prop ] || [];                                                                        // 7436
			tweeners[ prop ].unshift( callback );                                                                             // 7437
		}                                                                                                                  // 7438
	},                                                                                                                  // 7439
                                                                                                                     // 7440
	prefilter: function( callback, prepend ) {                                                                          // 7441
		if ( prepend ) {                                                                                                   // 7442
			animationPrefilters.unshift( callback );                                                                          // 7443
		} else {                                                                                                           // 7444
			animationPrefilters.push( callback );                                                                             // 7445
		}                                                                                                                  // 7446
	}                                                                                                                   // 7447
});                                                                                                                  // 7448
                                                                                                                     // 7449
jQuery.speed = function( speed, easing, fn ) {                                                                       // 7450
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {                                       // 7451
		complete: fn || !fn && easing ||                                                                                   // 7452
			jQuery.isFunction( speed ) && speed,                                                                              // 7453
		duration: speed,                                                                                                   // 7454
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing                                           // 7455
	};                                                                                                                  // 7456
                                                                                                                     // 7457
	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :                                // 7458
		opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;                   // 7459
                                                                                                                     // 7460
	// normalize opt.queue - true/undefined/null -> "fx"                                                                // 7461
	if ( opt.queue == null || opt.queue === true ) {                                                                    // 7462
		opt.queue = "fx";                                                                                                  // 7463
	}                                                                                                                   // 7464
                                                                                                                     // 7465
	// Queueing                                                                                                         // 7466
	opt.old = opt.complete;                                                                                             // 7467
                                                                                                                     // 7468
	opt.complete = function() {                                                                                         // 7469
		if ( jQuery.isFunction( opt.old ) ) {                                                                              // 7470
			opt.old.call( this );                                                                                             // 7471
		}                                                                                                                  // 7472
                                                                                                                     // 7473
		if ( opt.queue ) {                                                                                                 // 7474
			jQuery.dequeue( this, opt.queue );                                                                                // 7475
		}                                                                                                                  // 7476
	};                                                                                                                  // 7477
                                                                                                                     // 7478
	return opt;                                                                                                         // 7479
};                                                                                                                   // 7480
                                                                                                                     // 7481
jQuery.fn.extend({                                                                                                   // 7482
	fadeTo: function( speed, to, easing, callback ) {                                                                   // 7483
                                                                                                                     // 7484
		// show any hidden elements after setting opacity to 0                                                             // 7485
		return this.filter( isHidden ).css( "opacity", 0 ).show()                                                          // 7486
                                                                                                                     // 7487
			// animate to the value specified                                                                                 // 7488
			.end().animate({ opacity: to }, speed, easing, callback );                                                        // 7489
	},                                                                                                                  // 7490
	animate: function( prop, speed, easing, callback ) {                                                                // 7491
		var empty = jQuery.isEmptyObject( prop ),                                                                          // 7492
			optall = jQuery.speed( speed, easing, callback ),                                                                 // 7493
			doAnimation = function() {                                                                                        // 7494
				// Operate on a copy of prop so per-property easing won't be lost                                                // 7495
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );                                                 // 7496
                                                                                                                     // 7497
				// Empty animations, or finishing resolves immediately                                                           // 7498
				if ( empty || jQuery._data( this, "finish" ) ) {                                                                 // 7499
					anim.stop( true );                                                                                              // 7500
				}                                                                                                                // 7501
			};                                                                                                                // 7502
			doAnimation.finish = doAnimation;                                                                                 // 7503
                                                                                                                     // 7504
		return empty || optall.queue === false ?                                                                           // 7505
			this.each( doAnimation ) :                                                                                        // 7506
			this.queue( optall.queue, doAnimation );                                                                          // 7507
	},                                                                                                                  // 7508
	stop: function( type, clearQueue, gotoEnd ) {                                                                       // 7509
		var stopQueue = function( hooks ) {                                                                                // 7510
			var stop = hooks.stop;                                                                                            // 7511
			delete hooks.stop;                                                                                                // 7512
			stop( gotoEnd );                                                                                                  // 7513
		};                                                                                                                 // 7514
                                                                                                                     // 7515
		if ( typeof type !== "string" ) {                                                                                  // 7516
			gotoEnd = clearQueue;                                                                                             // 7517
			clearQueue = type;                                                                                                // 7518
			type = undefined;                                                                                                 // 7519
		}                                                                                                                  // 7520
		if ( clearQueue && type !== false ) {                                                                              // 7521
			this.queue( type || "fx", [] );                                                                                   // 7522
		}                                                                                                                  // 7523
                                                                                                                     // 7524
		return this.each(function() {                                                                                      // 7525
			var dequeue = true,                                                                                               // 7526
				index = type != null && type + "queueHooks",                                                                     // 7527
				timers = jQuery.timers,                                                                                          // 7528
				data = jQuery._data( this );                                                                                     // 7529
                                                                                                                     // 7530
			if ( index ) {                                                                                                    // 7531
				if ( data[ index ] && data[ index ].stop ) {                                                                     // 7532
					stopQueue( data[ index ] );                                                                                     // 7533
				}                                                                                                                // 7534
			} else {                                                                                                          // 7535
				for ( index in data ) {                                                                                          // 7536
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {                                              // 7537
						stopQueue( data[ index ] );                                                                                    // 7538
					}                                                                                                               // 7539
				}                                                                                                                // 7540
			}                                                                                                                 // 7541
                                                                                                                     // 7542
			for ( index = timers.length; index--; ) {                                                                         // 7543
				if ( timers[ index ].elem === this && (type == null || timers[ index ].queue === type) ) {                       // 7544
					timers[ index ].anim.stop( gotoEnd );                                                                           // 7545
					dequeue = false;                                                                                                // 7546
					timers.splice( index, 1 );                                                                                      // 7547
				}                                                                                                                // 7548
			}                                                                                                                 // 7549
                                                                                                                     // 7550
			// start the next in the queue if the last step wasn't forced                                                     // 7551
			// timers currently will call their complete callbacks, which will dequeue                                        // 7552
			// but only if they were gotoEnd                                                                                  // 7553
			if ( dequeue || !gotoEnd ) {                                                                                      // 7554
				jQuery.dequeue( this, type );                                                                                    // 7555
			}                                                                                                                 // 7556
		});                                                                                                                // 7557
	},                                                                                                                  // 7558
	finish: function( type ) {                                                                                          // 7559
		if ( type !== false ) {                                                                                            // 7560
			type = type || "fx";                                                                                              // 7561
		}                                                                                                                  // 7562
		return this.each(function() {                                                                                      // 7563
			var index,                                                                                                        // 7564
				data = jQuery._data( this ),                                                                                     // 7565
				queue = data[ type + "queue" ],                                                                                  // 7566
				hooks = data[ type + "queueHooks" ],                                                                             // 7567
				timers = jQuery.timers,                                                                                          // 7568
				length = queue ? queue.length : 0;                                                                               // 7569
                                                                                                                     // 7570
			// enable finishing flag on private data                                                                          // 7571
			data.finish = true;                                                                                               // 7572
                                                                                                                     // 7573
			// empty the queue first                                                                                          // 7574
			jQuery.queue( this, type, [] );                                                                                   // 7575
                                                                                                                     // 7576
			if ( hooks && hooks.stop ) {                                                                                      // 7577
				hooks.stop.call( this, true );                                                                                   // 7578
			}                                                                                                                 // 7579
                                                                                                                     // 7580
			// look for any active animations, and finish them                                                                // 7581
			for ( index = timers.length; index--; ) {                                                                         // 7582
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {                                         // 7583
					timers[ index ].anim.stop( true );                                                                              // 7584
					timers.splice( index, 1 );                                                                                      // 7585
				}                                                                                                                // 7586
			}                                                                                                                 // 7587
                                                                                                                     // 7588
			// look for any animations in the old queue and finish them                                                       // 7589
			for ( index = 0; index < length; index++ ) {                                                                      // 7590
				if ( queue[ index ] && queue[ index ].finish ) {                                                                 // 7591
					queue[ index ].finish.call( this );                                                                             // 7592
				}                                                                                                                // 7593
			}                                                                                                                 // 7594
                                                                                                                     // 7595
			// turn off finishing flag                                                                                        // 7596
			delete data.finish;                                                                                               // 7597
		});                                                                                                                // 7598
	}                                                                                                                   // 7599
});                                                                                                                  // 7600
                                                                                                                     // 7601
jQuery.each([ "toggle", "show", "hide" ], function( i, name ) {                                                      // 7602
	var cssFn = jQuery.fn[ name ];                                                                                      // 7603
	jQuery.fn[ name ] = function( speed, easing, callback ) {                                                           // 7604
		return speed == null || typeof speed === "boolean" ?                                                               // 7605
			cssFn.apply( this, arguments ) :                                                                                  // 7606
			this.animate( genFx( name, true ), speed, easing, callback );                                                     // 7607
	};                                                                                                                  // 7608
});                                                                                                                  // 7609
                                                                                                                     // 7610
// Generate shortcuts for custom animations                                                                          // 7611
jQuery.each({                                                                                                        // 7612
	slideDown: genFx("show"),                                                                                           // 7613
	slideUp: genFx("hide"),                                                                                             // 7614
	slideToggle: genFx("toggle"),                                                                                       // 7615
	fadeIn: { opacity: "show" },                                                                                        // 7616
	fadeOut: { opacity: "hide" },                                                                                       // 7617
	fadeToggle: { opacity: "toggle" }                                                                                   // 7618
}, function( name, props ) {                                                                                         // 7619
	jQuery.fn[ name ] = function( speed, easing, callback ) {                                                           // 7620
		return this.animate( props, speed, easing, callback );                                                             // 7621
	};                                                                                                                  // 7622
});                                                                                                                  // 7623
                                                                                                                     // 7624
jQuery.timers = [];                                                                                                  // 7625
jQuery.fx.tick = function() {                                                                                        // 7626
	var timer,                                                                                                          // 7627
		timers = jQuery.timers,                                                                                            // 7628
		i = 0;                                                                                                             // 7629
                                                                                                                     // 7630
	fxNow = jQuery.now();                                                                                               // 7631
                                                                                                                     // 7632
	for ( ; i < timers.length; i++ ) {                                                                                  // 7633
		timer = timers[ i ];                                                                                               // 7634
		// Checks the timer has not already been removed                                                                   // 7635
		if ( !timer() && timers[ i ] === timer ) {                                                                         // 7636
			timers.splice( i--, 1 );                                                                                          // 7637
		}                                                                                                                  // 7638
	}                                                                                                                   // 7639
                                                                                                                     // 7640
	if ( !timers.length ) {                                                                                             // 7641
		jQuery.fx.stop();                                                                                                  // 7642
	}                                                                                                                   // 7643
	fxNow = undefined;                                                                                                  // 7644
};                                                                                                                   // 7645
                                                                                                                     // 7646
jQuery.fx.timer = function( timer ) {                                                                                // 7647
	jQuery.timers.push( timer );                                                                                        // 7648
	if ( timer() ) {                                                                                                    // 7649
		jQuery.fx.start();                                                                                                 // 7650
	} else {                                                                                                            // 7651
		jQuery.timers.pop();                                                                                               // 7652
	}                                                                                                                   // 7653
};                                                                                                                   // 7654
                                                                                                                     // 7655
jQuery.fx.interval = 13;                                                                                             // 7656
                                                                                                                     // 7657
jQuery.fx.start = function() {                                                                                       // 7658
	if ( !timerId ) {                                                                                                   // 7659
		timerId = setInterval( jQuery.fx.tick, jQuery.fx.interval );                                                       // 7660
	}                                                                                                                   // 7661
};                                                                                                                   // 7662
                                                                                                                     // 7663
jQuery.fx.stop = function() {                                                                                        // 7664
	clearInterval( timerId );                                                                                           // 7665
	timerId = null;                                                                                                     // 7666
};                                                                                                                   // 7667
                                                                                                                     // 7668
jQuery.fx.speeds = {                                                                                                 // 7669
	slow: 600,                                                                                                          // 7670
	fast: 200,                                                                                                          // 7671
	// Default speed                                                                                                    // 7672
	_default: 400                                                                                                       // 7673
};                                                                                                                   // 7674
                                                                                                                     // 7675
                                                                                                                     // 7676
// Based off of the plugin by Clint Helfers, with permission.                                                        // 7677
// http://blindsignals.com/index.php/2009/07/jquery-delay/                                                           // 7678
jQuery.fn.delay = function( time, type ) {                                                                           // 7679
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;                                                         // 7680
	type = type || "fx";                                                                                                // 7681
                                                                                                                     // 7682
	return this.queue( type, function( next, hooks ) {                                                                  // 7683
		var timeout = setTimeout( next, time );                                                                            // 7684
		hooks.stop = function() {                                                                                          // 7685
			clearTimeout( timeout );                                                                                          // 7686
		};                                                                                                                 // 7687
	});                                                                                                                 // 7688
};                                                                                                                   // 7689
                                                                                                                     // 7690
                                                                                                                     // 7691
(function() {                                                                                                        // 7692
	var a, input, select, opt,                                                                                          // 7693
		div = document.createElement("div" );                                                                              // 7694
                                                                                                                     // 7695
	// Setup                                                                                                            // 7696
	div.setAttribute( "className", "t" );                                                                               // 7697
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";                               // 7698
	a = div.getElementsByTagName("a")[ 0 ];                                                                             // 7699
                                                                                                                     // 7700
	// First batch of tests.                                                                                            // 7701
	select = document.createElement("select");                                                                          // 7702
	opt = select.appendChild( document.createElement("option") );                                                       // 7703
	input = div.getElementsByTagName("input")[ 0 ];                                                                     // 7704
                                                                                                                     // 7705
	a.style.cssText = "top:1px";                                                                                        // 7706
                                                                                                                     // 7707
	// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)         // 7708
	support.getSetAttribute = div.className !== "t";                                                                    // 7709
                                                                                                                     // 7710
	// Get the style information from getAttribute                                                                      // 7711
	// (IE uses .cssText instead)                                                                                       // 7712
	support.style = /top/.test( a.getAttribute("style") );                                                              // 7713
                                                                                                                     // 7714
	// Make sure that URLs aren't manipulated                                                                           // 7715
	// (IE normalizes it by default)                                                                                    // 7716
	support.hrefNormalized = a.getAttribute("href") === "/a";                                                           // 7717
                                                                                                                     // 7718
	// Check the default checkbox/radio value ("" on WebKit; "on" elsewhere)                                            // 7719
	support.checkOn = !!input.value;                                                                                    // 7720
                                                                                                                     // 7721
	// Make sure that a selected-by-default option has a working selected property.                                     // 7722
	// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)                                       // 7723
	support.optSelected = opt.selected;                                                                                 // 7724
                                                                                                                     // 7725
	// Tests for enctype support on a form (#6743)                                                                      // 7726
	support.enctype = !!document.createElement("form").enctype;                                                         // 7727
                                                                                                                     // 7728
	// Make sure that the options inside disabled selects aren't marked as disabled                                     // 7729
	// (WebKit marks them as disabled)                                                                                  // 7730
	select.disabled = true;                                                                                             // 7731
	support.optDisabled = !opt.disabled;                                                                                // 7732
                                                                                                                     // 7733
	// Support: IE8 only                                                                                                // 7734
	// Check if we can trust getAttribute("value")                                                                      // 7735
	input = document.createElement( "input" );                                                                          // 7736
	input.setAttribute( "value", "" );                                                                                  // 7737
	support.input = input.getAttribute( "value" ) === "";                                                               // 7738
                                                                                                                     // 7739
	// Check if an input maintains its value after becoming a radio                                                     // 7740
	input.value = "t";                                                                                                  // 7741
	input.setAttribute( "type", "radio" );                                                                              // 7742
	support.radioValue = input.value === "t";                                                                           // 7743
                                                                                                                     // 7744
	// Null elements to avoid leaks in IE.                                                                              // 7745
	a = input = select = opt = div = null;                                                                              // 7746
})();                                                                                                                // 7747
                                                                                                                     // 7748
                                                                                                                     // 7749
var rreturn = /\r/g;                                                                                                 // 7750
                                                                                                                     // 7751
jQuery.fn.extend({                                                                                                   // 7752
	val: function( value ) {                                                                                            // 7753
		var hooks, ret, isFunction,                                                                                        // 7754
			elem = this[0];                                                                                                   // 7755
                                                                                                                     // 7756
		if ( !arguments.length ) {                                                                                         // 7757
			if ( elem ) {                                                                                                     // 7758
				hooks = jQuery.valHooks[ elem.type ] || jQuery.valHooks[ elem.nodeName.toLowerCase() ];                          // 7759
                                                                                                                     // 7760
				if ( hooks && "get" in hooks && (ret = hooks.get( elem, "value" )) !== undefined ) {                             // 7761
					return ret;                                                                                                     // 7762
				}                                                                                                                // 7763
                                                                                                                     // 7764
				ret = elem.value;                                                                                                // 7765
                                                                                                                     // 7766
				return typeof ret === "string" ?                                                                                 // 7767
					// handle most common string cases                                                                              // 7768
					ret.replace(rreturn, "") :                                                                                      // 7769
					// handle cases where value is null/undef or number                                                             // 7770
					ret == null ? "" : ret;                                                                                         // 7771
			}                                                                                                                 // 7772
                                                                                                                     // 7773
			return;                                                                                                           // 7774
		}                                                                                                                  // 7775
                                                                                                                     // 7776
		isFunction = jQuery.isFunction( value );                                                                           // 7777
                                                                                                                     // 7778
		return this.each(function( i ) {                                                                                   // 7779
			var val;                                                                                                          // 7780
                                                                                                                     // 7781
			if ( this.nodeType !== 1 ) {                                                                                      // 7782
				return;                                                                                                          // 7783
			}                                                                                                                 // 7784
                                                                                                                     // 7785
			if ( isFunction ) {                                                                                               // 7786
				val = value.call( this, i, jQuery( this ).val() );                                                               // 7787
			} else {                                                                                                          // 7788
				val = value;                                                                                                     // 7789
			}                                                                                                                 // 7790
                                                                                                                     // 7791
			// Treat null/undefined as ""; convert numbers to string                                                          // 7792
			if ( val == null ) {                                                                                              // 7793
				val = "";                                                                                                        // 7794
			} else if ( typeof val === "number" ) {                                                                           // 7795
				val += "";                                                                                                       // 7796
			} else if ( jQuery.isArray( val ) ) {                                                                             // 7797
				val = jQuery.map( val, function( value ) {                                                                       // 7798
					return value == null ? "" : value + "";                                                                         // 7799
				});                                                                                                              // 7800
			}                                                                                                                 // 7801
                                                                                                                     // 7802
			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];                           // 7803
                                                                                                                     // 7804
			// If set returns undefined, fall back to normal setting                                                          // 7805
			if ( !hooks || !("set" in hooks) || hooks.set( this, val, "value" ) === undefined ) {                             // 7806
				this.value = val;                                                                                                // 7807
			}                                                                                                                 // 7808
		});                                                                                                                // 7809
	}                                                                                                                   // 7810
});                                                                                                                  // 7811
                                                                                                                     // 7812
jQuery.extend({                                                                                                      // 7813
	valHooks: {                                                                                                         // 7814
		option: {                                                                                                          // 7815
			get: function( elem ) {                                                                                           // 7816
				var val = jQuery.find.attr( elem, "value" );                                                                     // 7817
				return val != null ?                                                                                             // 7818
					val :                                                                                                           // 7819
					jQuery.text( elem );                                                                                            // 7820
			}                                                                                                                 // 7821
		},                                                                                                                 // 7822
		select: {                                                                                                          // 7823
			get: function( elem ) {                                                                                           // 7824
				var value, option,                                                                                               // 7825
					options = elem.options,                                                                                         // 7826
					index = elem.selectedIndex,                                                                                     // 7827
					one = elem.type === "select-one" || index < 0,                                                                  // 7828
					values = one ? null : [],                                                                                       // 7829
					max = one ? index + 1 : options.length,                                                                         // 7830
					i = index < 0 ?                                                                                                 // 7831
						max :                                                                                                          // 7832
						one ? index : 0;                                                                                               // 7833
                                                                                                                     // 7834
				// Loop through all the selected options                                                                         // 7835
				for ( ; i < max; i++ ) {                                                                                         // 7836
					option = options[ i ];                                                                                          // 7837
                                                                                                                     // 7838
					// oldIE doesn't update selected after form reset (#2551)                                                       // 7839
					if ( ( option.selected || i === index ) &&                                                                      // 7840
							// Don't return options that are disabled or in a disabled optgroup                                           // 7841
							( support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null ) &&                      // 7842
							( !option.parentNode.disabled || !jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {                      // 7843
                                                                                                                     // 7844
						// Get the specific value for the option                                                                       // 7845
						value = jQuery( option ).val();                                                                                // 7846
                                                                                                                     // 7847
						// We don't need an array for one selects                                                                      // 7848
						if ( one ) {                                                                                                   // 7849
							return value;                                                                                                 // 7850
						}                                                                                                              // 7851
                                                                                                                     // 7852
						// Multi-Selects return an array                                                                               // 7853
						values.push( value );                                                                                          // 7854
					}                                                                                                               // 7855
				}                                                                                                                // 7856
                                                                                                                     // 7857
				return values;                                                                                                   // 7858
			},                                                                                                                // 7859
                                                                                                                     // 7860
			set: function( elem, value ) {                                                                                    // 7861
				var optionSet, option,                                                                                           // 7862
					options = elem.options,                                                                                         // 7863
					values = jQuery.makeArray( value ),                                                                             // 7864
					i = options.length;                                                                                             // 7865
                                                                                                                     // 7866
				while ( i-- ) {                                                                                                  // 7867
					option = options[ i ];                                                                                          // 7868
                                                                                                                     // 7869
					if ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) >= 0 ) {                                    // 7870
                                                                                                                     // 7871
						// Support: IE6                                                                                                // 7872
						// When new option element is added to select box we need to                                                   // 7873
						// force reflow of newly added node in order to workaround delay                                               // 7874
						// of initialization properties                                                                                // 7875
						try {                                                                                                          // 7876
							option.selected = optionSet = true;                                                                           // 7877
                                                                                                                     // 7878
						} catch ( _ ) {                                                                                                // 7879
                                                                                                                     // 7880
							// Will be executed only in IE6                                                                               // 7881
							option.scrollHeight;                                                                                          // 7882
						}                                                                                                              // 7883
                                                                                                                     // 7884
					} else {                                                                                                        // 7885
						option.selected = false;                                                                                       // 7886
					}                                                                                                               // 7887
				}                                                                                                                // 7888
                                                                                                                     // 7889
				// Force browsers to behave consistently when non-matching value is set                                          // 7890
				if ( !optionSet ) {                                                                                              // 7891
					elem.selectedIndex = -1;                                                                                        // 7892
				}                                                                                                                // 7893
                                                                                                                     // 7894
				return options;                                                                                                  // 7895
			}                                                                                                                 // 7896
		}                                                                                                                  // 7897
	}                                                                                                                   // 7898
});                                                                                                                  // 7899
                                                                                                                     // 7900
// Radios and checkboxes getter/setter                                                                               // 7901
jQuery.each([ "radio", "checkbox" ], function() {                                                                    // 7902
	jQuery.valHooks[ this ] = {                                                                                         // 7903
		set: function( elem, value ) {                                                                                     // 7904
			if ( jQuery.isArray( value ) ) {                                                                                  // 7905
				return ( elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0 );                                      // 7906
			}                                                                                                                 // 7907
		}                                                                                                                  // 7908
	};                                                                                                                  // 7909
	if ( !support.checkOn ) {                                                                                           // 7910
		jQuery.valHooks[ this ].get = function( elem ) {                                                                   // 7911
			// Support: Webkit                                                                                                // 7912
			// "" is returned instead of "on" if a value isn't specified                                                      // 7913
			return elem.getAttribute("value") === null ? "on" : elem.value;                                                   // 7914
		};                                                                                                                 // 7915
	}                                                                                                                   // 7916
});                                                                                                                  // 7917
                                                                                                                     // 7918
                                                                                                                     // 7919
                                                                                                                     // 7920
                                                                                                                     // 7921
var nodeHook, boolHook,                                                                                              // 7922
	attrHandle = jQuery.expr.attrHandle,                                                                                // 7923
	ruseDefault = /^(?:checked|selected)$/i,                                                                            // 7924
	getSetAttribute = support.getSetAttribute,                                                                          // 7925
	getSetInput = support.input;                                                                                        // 7926
                                                                                                                     // 7927
jQuery.fn.extend({                                                                                                   // 7928
	attr: function( name, value ) {                                                                                     // 7929
		return access( this, jQuery.attr, name, value, arguments.length > 1 );                                             // 7930
	},                                                                                                                  // 7931
                                                                                                                     // 7932
	removeAttr: function( name ) {                                                                                      // 7933
		return this.each(function() {                                                                                      // 7934
			jQuery.removeAttr( this, name );                                                                                  // 7935
		});                                                                                                                // 7936
	}                                                                                                                   // 7937
});                                                                                                                  // 7938
                                                                                                                     // 7939
jQuery.extend({                                                                                                      // 7940
	attr: function( elem, name, value ) {                                                                               // 7941
		var hooks, ret,                                                                                                    // 7942
			nType = elem.nodeType;                                                                                            // 7943
                                                                                                                     // 7944
		// don't get/set attributes on text, comment and attribute nodes                                                   // 7945
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {                                                        // 7946
			return;                                                                                                           // 7947
		}                                                                                                                  // 7948
                                                                                                                     // 7949
		// Fallback to prop when attributes are not supported                                                              // 7950
		if ( typeof elem.getAttribute === strundefined ) {                                                                 // 7951
			return jQuery.prop( elem, name, value );                                                                          // 7952
		}                                                                                                                  // 7953
                                                                                                                     // 7954
		// All attributes are lowercase                                                                                    // 7955
		// Grab necessary hook if one is defined                                                                           // 7956
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {                                                                   // 7957
			name = name.toLowerCase();                                                                                        // 7958
			hooks = jQuery.attrHooks[ name ] ||                                                                               // 7959
				( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );                                                   // 7960
		}                                                                                                                  // 7961
                                                                                                                     // 7962
		if ( value !== undefined ) {                                                                                       // 7963
                                                                                                                     // 7964
			if ( value === null ) {                                                                                           // 7965
				jQuery.removeAttr( elem, name );                                                                                 // 7966
                                                                                                                     // 7967
			} else if ( hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {                   // 7968
				return ret;                                                                                                      // 7969
                                                                                                                     // 7970
			} else {                                                                                                          // 7971
				elem.setAttribute( name, value + "" );                                                                           // 7972
				return value;                                                                                                    // 7973
			}                                                                                                                 // 7974
                                                                                                                     // 7975
		} else if ( hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ) {                                // 7976
			return ret;                                                                                                       // 7977
                                                                                                                     // 7978
		} else {                                                                                                           // 7979
			ret = jQuery.find.attr( elem, name );                                                                             // 7980
                                                                                                                     // 7981
			// Non-existent attributes return null, we normalize to undefined                                                 // 7982
			return ret == null ?                                                                                              // 7983
				undefined :                                                                                                      // 7984
				ret;                                                                                                             // 7985
		}                                                                                                                  // 7986
	},                                                                                                                  // 7987
                                                                                                                     // 7988
	removeAttr: function( elem, value ) {                                                                               // 7989
		var name, propName,                                                                                                // 7990
			i = 0,                                                                                                            // 7991
			attrNames = value && value.match( rnotwhite );                                                                    // 7992
                                                                                                                     // 7993
		if ( attrNames && elem.nodeType === 1 ) {                                                                          // 7994
			while ( (name = attrNames[i++]) ) {                                                                               // 7995
				propName = jQuery.propFix[ name ] || name;                                                                       // 7996
                                                                                                                     // 7997
				// Boolean attributes get special treatment (#10870)                                                             // 7998
				if ( jQuery.expr.match.bool.test( name ) ) {                                                                     // 7999
					// Set corresponding property to false                                                                          // 8000
					if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {                                            // 8001
						elem[ propName ] = false;                                             