(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                              //
// packages/http/test_responder.js                                                              //
//                                                                                              //
//////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                //
var TEST_RESPONDER_ROUTE = "/http_test_responder";                                              // 1
                                                                                                // 2
var respond = function(req, res) {                                                              // 3
                                                                                                // 4
  if (req.url.slice(0,5) === "/slow") {                                                         // 5
    setTimeout(function() {                                                                     // 6
      res.statusCode = 200;                                                                     // 7
      res.end("A SLOW RESPONSE");                                                               // 8
    }, 5000);                                                                                   // 9
    return;                                                                                     // 10
  } else if (req.url === "/fail") {                                                             // 11
    res.statusCode = 500;                                                                       // 12
    res.end("SOME SORT OF SERVER ERROR. foo" +                                                  // 13
            _.times(100, function () {                                                          // 14
              return "MAKE THIS LONG TO TEST THAT WE TRUNCATE";                                 // 15
            }).join(' '));                                                                      // 16
    return;                                                                                     // 17
  } else if (req.url === "/redirect") {                                                         // 18
    res.statusCode = 301;                                                                       // 19
    // XXX shouldn't be redirecting to a relative URL, per HTTP spec,                           // 20
    // but browsers etc. seem to tolerate it.                                                   // 21
    res.setHeader("Location", TEST_RESPONDER_ROUTE+"/foo");                                     // 22
    res.end("REDIRECT TO FOO");                                                                 // 23
    return;                                                                                     // 24
  } else if (req.url.slice(0,6) === "/login") {                                                 // 25
    var username = 'meteor';                                                                    // 26
    // get password from query string                                                           // 27
    var password = req.url.slice(7);                                                            // 28
    // realm is displayed in dialog box if one pops up, avoid confusion                         // 29
    var realm = TEST_RESPONDER_ROUTE+"/login";                                                  // 30
    var validate = function(user, pass) {                                                       // 31
      return user === username && pass === password;                                            // 32
    };                                                                                          // 33
    var checker = WebApp.__basicAuth__(validate, realm);                                        // 34
    var success = false;                                                                        // 35
    checker(req, res, function() {                                                              // 36
      success = true;                                                                           // 37
    });                                                                                         // 38
    if (! success)                                                                              // 39
      return;                                                                                   // 40
  } else if (req.url === "/headers") {                                                          // 41
    res.statusCode = 201;                                                                       // 42
    res.setHeader("A-Silly-Header", "Tis a");                                                   // 43
    res.setHeader("Another-Silly-Header", "Silly place.");                                      // 44
    res.end("A RESPONSE WITH SOME HEADERS");                                                    // 45
    return;                                                                                     // 46
  }                                                                                             // 47
                                                                                                // 48
  var chunks = [];                                                                              // 49
  req.setEncoding("utf8");                                                                      // 50
  req.on("data", function(chunk) {                                                              // 51
    chunks.push(chunk); });                                                                     // 52
  req.on("end", function() {                                                                    // 53
    var body = chunks.join('');                                                                 // 54
                                                                                                // 55
    if (body.charAt(0) === '{') {                                                               // 56
      body = JSON.parse(body);                                                                  // 57
    }                                                                                           // 58
                                                                                                // 59
    var response_data = {                                                                       // 60
      method: req.method,                                                                       // 61
      url: req.url,                                                                             // 62
      headers: req.headers,                                                                     // 63
      body: body                                                                                // 64
    };                                                                                          // 65
    var response_string = "";                                                                   // 66
    if (req.method !== "HEAD")                                                                  // 67
      response_string = JSON.stringify(response_data);                                          // 68
                                                                                                // 69
    res.statusCode = 200;                                                                       // 70
    res.setHeader("Content-Type", "application/json; charset=utf-8");                           // 71
    res.end(response_string);                                                                   // 72
  });                                                                                           // 73
                                                                                                // 74
};                                                                                              // 75
                                                                                                // 76
var run_responder = function() {                                                                // 77
  WebApp.connectHandlers.stack.unshift(                                                         // 78
    { route: TEST_RESPONDER_ROUTE, handle: respond });                                          // 79
};                                                                                              // 80
                                                                                                // 81
run_responder();                                                                                // 82
                                                                                                // 83
//////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                              //
// packages/http/httpcall_tests.js                                                              //
//                                                                                              //
//////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                //
// URL prefix for tests to talk to                                                              // 1
var _XHR_URL_PREFIX = "/http_test_responder";                                                   // 2
                                                                                                // 3
var url_base = function () {                                                                    // 4
  if (Meteor.isServer) {                                                                        // 5
    var address = WebApp.httpServer.address();                                                  // 6
    return "http://127.0.0.1:" + address.port;                                                  // 7
  } else {                                                                                      // 8
    return "";                                                                                  // 9
  }                                                                                             // 10
};                                                                                              // 11
                                                                                                // 12
var url_prefix = function () {                                                                  // 13
  if (Meteor.isServer && _XHR_URL_PREFIX.indexOf("http") !== 0) {                               // 14
    _XHR_URL_PREFIX = url_base() + _XHR_URL_PREFIX;                                             // 15
  }                                                                                             // 16
  return _XHR_URL_PREFIX;                                                                       // 17
};                                                                                              // 18
                                                                                                // 19
                                                                                                // 20
testAsyncMulti("httpcall - basic", [                                                            // 21
  function(test, expect) {                                                                      // 22
    var basic_get = function(url, options, expected_url) {                                      // 23
                                                                                                // 24
      var callback = function(error, result) {                                                  // 25
        test.isFalse(error);                                                                    // 26
        if (! error) {                                                                          // 27
          test.equal(typeof result, "object");                                                  // 28
          test.equal(result.statusCode, 200);                                                   // 29
                                                                                                // 30
          var data = result.data;                                                               // 31
                                                                                                // 32
          // allow dropping of final ? (which mobile browsers seem to do)                       // 33
          var allowed = [expected_url];                                                         // 34
          if (expected_url.slice(-1) === '?')                                                   // 35
            allowed.push(expected_url.slice(0, -1));                                            // 36
                                                                                                // 37
          test.include(allowed, expected_url);                                                  // 38
          test.equal(data.method, "GET");                                                       // 39
        }                                                                                       // 40
      };                                                                                        // 41
                                                                                                // 42
                                                                                                // 43
      HTTP.call("GET", url_prefix()+url, options, expect(callback));                            // 44
                                                                                                // 45
      if (Meteor.isServer) {                                                                    // 46
        // test sync version                                                                    // 47
        try {                                                                                   // 48
          var result = HTTP.call("GET", url_prefix()+url, options);                             // 49
          callback(undefined, result);                                                          // 50
        } catch (e) {                                                                           // 51
          callback(e, e.response);                                                              // 52
        }                                                                                       // 53
      }                                                                                         // 54
    };                                                                                          // 55
                                                                                                // 56
    basic_get("/foo", null, "/foo");                                                            // 57
    basic_get("/foo?", null, "/foo?");                                                          // 58
    basic_get("/foo?a=b", null, "/foo?a=b");                                                    // 59
    basic_get("/foo", {params: {fruit: "apple"}},                                               // 60
              "/foo?fruit=apple");                                                              // 61
    basic_get("/foo", {params: {fruit: "apple", dog: "Spot the dog"}},                          // 62
              "/foo?fruit=apple&dog=Spot+the+dog");                                             // 63
    basic_get("/foo?", {params: {fruit: "apple", dog: "Spot the dog"}},                         // 64
              "/foo?fruit=apple&dog=Spot+the+dog");                                             // 65
    basic_get("/foo?bar", {params: {fruit: "apple", dog: "Spot the dog"}},                      // 66
              "/foo?bar&fruit=apple&dog=Spot+the+dog");                                         // 67
    basic_get("/foo?bar", {params: {fruit: "apple", dog: "Spot the dog"},                       // 68
                           query: "baz"},                                                       // 69
              "/foo?baz&fruit=apple&dog=Spot+the+dog");                                         // 70
    basic_get("/foo", {params: {fruit: "apple", dog: "Spot the dog"},                           // 71
                       query: "baz"},                                                           // 72
              "/foo?baz&fruit=apple&dog=Spot+the+dog");                                         // 73
    basic_get("/foo?", {params: {fruit: "apple", dog: "Spot the dog"},                          // 74
                       query: "baz"},                                                           // 75
              "/foo?baz&fruit=apple&dog=Spot+the+dog");                                         // 76
    basic_get("/foo?bar", {query: ""}, "/foo?");                                                // 77
    basic_get("/foo?bar", {params: {fruit: "apple", dog: "Spot the dog"},                       // 78
                           query: ""},                                                          // 79
              "/foo?fruit=apple&dog=Spot+the+dog");                                             // 80
  }]);                                                                                          // 81
                                                                                                // 82
testAsyncMulti("httpcall - errors", [                                                           // 83
  function(test, expect) {                                                                      // 84
                                                                                                // 85
    // Accessing unknown server (should fail to make any connection)                            // 86
    var unknownServerCallback = function(error, result) {                                       // 87
      test.isTrue(error);                                                                       // 88
      test.isFalse(result);                                                                     // 89
      test.isFalse(error.response);                                                             // 90
    };                                                                                          // 91
                                                                                                // 92
    // 0.0.0.0 is an illegal IP address, and thus should always give an error.                  // 93
    // If your ISP is intercepting DNS misses and serving ads, an obviously                     // 94
    // invalid URL (http://asdf.asdf) might produce an HTTP response.                           // 95
    HTTP.call("GET", "http://0.0.0.0/", expect(unknownServerCallback));                         // 96
                                                                                                // 97
    if (Meteor.isServer) {                                                                      // 98
      // test sync version                                                                      // 99
      try {                                                                                     // 100
        var unknownServerResult = HTTP.call("GET", "http://0.0.0.0/");                          // 101
        unknownServerCallback(undefined, unknownServerResult);                                  // 102
      } catch (e) {                                                                             // 103
        unknownServerCallback(e, e.response);                                                   // 104
      }                                                                                         // 105
    }                                                                                           // 106
                                                                                                // 107
    // Server serves 500                                                                        // 108
    var error500Callback = function(error, result) {                                            // 109
      test.isTrue(error);                                                                       // 110
      test.isTrue(error.message.indexOf("500") !== -1); // message has statusCode               // 111
      test.isTrue(error.message.indexOf(                                                        // 112
        error.response.content.substring(0, 10)) !== -1); // message has part of content        // 113
                                                                                                // 114
      test.isTrue(result);                                                                      // 115
      test.isTrue(error.response);                                                              // 116
      test.equal(result, error.response);                                                       // 117
      test.equal(error.response.statusCode, 500);                                               // 118
                                                                                                // 119
      // in test_responder.js we make a very long response body, to make sure                   // 120
      // that we truncate messages. first of all, make sure we didn't make that                 // 121
      // message too short, so that we can be sure we're verifying that we truncate.            // 122
      test.isTrue(error.response.content.length > 520);                                         // 123
      test.isTrue(error.message.length < 520); // make sure we truncate.                        // 124
    };                                                                                          // 125
    HTTP.call("GET", url_prefix()+"/fail", expect(error500Callback));                           // 126
                                                                                                // 127
    if (Meteor.isServer) {                                                                      // 128
      // test sync version                                                                      // 129
      try {                                                                                     // 130
        var error500Result = HTTP.call("GET", url_prefix()+"/fail");                            // 131
        error500Callback(undefined, error500Result);                                            // 132
      } catch (e) {                                                                             // 133
        error500Callback(e, e.response);                                                        // 134
      }                                                                                         // 135
    }                                                                                           // 136
  }                                                                                             // 137
]);                                                                                             // 138
                                                                                                // 139
testAsyncMulti("httpcall - timeout", [                                                          // 140
  function(test, expect) {                                                                      // 141
                                                                                                // 142
    // Should time out                                                                          // 143
    var timeoutCallback = function(error, result) {                                             // 144
      test.isTrue(error);                                                                       // 145
      test.isFalse(result);                                                                     // 146
      test.isFalse(error.response);                                                             // 147
    };                                                                                          // 148
    var timeoutUrl = url_prefix()+"/slow-"+Random.id();                                         // 149
    HTTP.call(                                                                                  // 150
      "GET", timeoutUrl,                                                                        // 151
      { timeout: 500 },                                                                         // 152
      expect(timeoutCallback));                                                                 // 153
                                                                                                // 154
    if (Meteor.isServer) {                                                                      // 155
      // test sync version                                                                      // 156
      try {                                                                                     // 157
        var timeoutResult = HTTP.call("GET", timeoutUrl, { timeout: 500 });                     // 158
        timeoutCallback(undefined, timeoutResult);                                              // 159
      } catch (e) {                                                                             // 160
        timeoutCallback(e, e.response);                                                         // 161
      }                                                                                         // 162
    }                                                                                           // 163
                                                                                                // 164
    // Should not time out                                                                      // 165
    var noTimeoutCallback = function(error, result) {                                           // 166
      test.isFalse(error);                                                                      // 167
      test.isTrue(result);                                                                      // 168
      test.equal(result.statusCode, 200);                                                       // 169
      var data = result.data;                                                                   // 170
      test.equal(data.url.substring(0, 4), "/foo");                                             // 171
      test.equal(data.method, "GET");                                                           // 172
    };                                                                                          // 173
    var noTimeoutUrl = url_prefix()+"/foo-"+Random.id();                                        // 174
    HTTP.call(                                                                                  // 175
      "GET", noTimeoutUrl,                                                                      // 176
      { timeout: 2000 },                                                                        // 177
      expect(noTimeoutCallback));                                                               // 178
                                                                                                // 179
    if (Meteor.isServer) {                                                                      // 180
      // test sync version                                                                      // 181
      try {                                                                                     // 182
        var noTimeoutResult = HTTP.call("GET", noTimeoutUrl, { timeout: 2000 });                // 183
        noTimeoutCallback(undefined, noTimeoutResult);                                          // 184
      } catch (e) {                                                                             // 185
        noTimeoutCallback(e, e.response);                                                       // 186
      }                                                                                         // 187
    }                                                                                           // 188
  }                                                                                             // 189
]);                                                                                             // 190
                                                                                                // 191
testAsyncMulti("httpcall - redirect", [                                                         // 192
                                                                                                // 193
  function(test, expect) {                                                                      // 194
    // Test that we follow redirects by default                                                 // 195
    HTTP.call("GET", url_prefix()+"/redirect", expect(                                          // 196
      function(error, result) {                                                                 // 197
        test.isFalse(error);                                                                    // 198
        test.isTrue(result);                                                                    // 199
                                                                                                // 200
        // should be redirected transparently to /foo                                           // 201
        test.equal(result.statusCode, 200);                                                     // 202
        var data = result.data;                                                                 // 203
        test.equal(data.url, "/foo");                                                           // 204
        test.equal(data.method, "GET");                                                         // 205
      }));                                                                                      // 206
                                                                                                // 207
    // followRedirect option; can't be false on client                                          // 208
    _.each([false, true], function(followRedirects) {                                           // 209
      var do_it = function(should_work) {                                                       // 210
        var maybe_expect = should_work ? expect : _.identity;                                   // 211
        HTTP.call(                                                                              // 212
          "GET", url_prefix()+"/redirect",                                                      // 213
          {followRedirects: followRedirects},                                                   // 214
          maybe_expect(function(error, result) {                                                // 215
            test.isFalse(error);                                                                // 216
            test.isTrue(result);                                                                // 217
                                                                                                // 218
            if (followRedirects) {                                                              // 219
              // should be redirected transparently to /foo                                     // 220
              test.equal(result.statusCode, 200);                                               // 221
              var data = result.data;                                                           // 222
              test.equal(data.url, "/foo");                                                     // 223
              test.equal(data.method, "GET");                                                   // 224
            } else {                                                                            // 225
              // should see redirect                                                            // 226
              test.equal(result.statusCode, 301);                                               // 227
            }                                                                                   // 228
          }));                                                                                  // 229
      };                                                                                        // 230
      if (Meteor.isClient && ! followRedirects) {                                               // 231
        // not supported, should fail                                                           // 232
        test.throws(do_it);                                                                     // 233
      } else {                                                                                  // 234
        do_it(true);                                                                            // 235
      }                                                                                         // 236
    });                                                                                         // 237
  }                                                                                             // 238
                                                                                                // 239
]);                                                                                             // 240
                                                                                                // 241
testAsyncMulti("httpcall - methods", [                                                          // 242
                                                                                                // 243
  function(test, expect) {                                                                      // 244
    // non-get methods                                                                          // 245
    var test_method = function(meth, func_name) {                                               // 246
      func_name = func_name || meth.toLowerCase();                                              // 247
      HTTP[func_name](                                                                          // 248
        url_prefix()+"/foo",                                                                    // 249
        expect(function(error, result) {                                                        // 250
          test.isFalse(error);                                                                  // 251
          test.isTrue(result);                                                                  // 252
          test.equal(result.statusCode, 200);                                                   // 253
          var data = result.data;                                                               // 254
          test.equal(data.url, "/foo");                                                         // 255
                                                                                                // 256
          // IE <= 8 turns seems to turn POSTs with no body into                                // 257
          // GETs, inexplicably.                                                                // 258
          //                                                                                    // 259
          // XXX Except now it doesn't!? Not sure what changed, but                             // 260
          // these lines now break the test...                                                  // 261
          // if (Meteor.isClient && $.browser.msie && $.browser.version <= 8                    // 262
          //     && meth === "POST")                                                            // 263
          //   meth = "GET";                                                                    // 264
                                                                                                // 265
          test.equal(data.method, meth);                                                        // 266
        }));                                                                                    // 267
    };                                                                                          // 268
                                                                                                // 269
    test_method("GET");                                                                         // 270
    test_method("POST");                                                                        // 271
    test_method("PUT");                                                                         // 272
    test_method("DELETE", 'del');                                                               // 273
  },                                                                                            // 274
                                                                                                // 275
  function(test, expect) {                                                                      // 276
    // contents and data                                                                        // 277
    HTTP.call(                                                                                  // 278
      "POST", url_prefix()+"/foo",                                                              // 279
      { content: "Hello World!" },                                                              // 280
      expect(function(error, result) {                                                          // 281
        test.isFalse(error);                                                                    // 282
        test.isTrue(result);                                                                    // 283
        test.equal(result.statusCode, 200);                                                     // 284
        var data = result.data;                                                                 // 285
        test.equal(data.body, "Hello World!");                                                  // 286
      }));                                                                                      // 287
                                                                                                // 288
    HTTP.call(                                                                                  // 289
      "POST", url_prefix()+"/data-test",                                                        // 290
      { data: {greeting: "Hello World!"} },                                                     // 291
      expect(function(error, result) {                                                          // 292
        test.isFalse(error);                                                                    // 293
        test.isTrue(result);                                                                    // 294
        test.equal(result.statusCode, 200);                                                     // 295
        var data = result.data;                                                                 // 296
        test.equal(data.body, {greeting: "Hello World!"});                                      // 297
        // nb: some browsers include a charset here too.                                        // 298
        test.matches(data.headers['content-type'], /^application\/json\b/);                     // 299
      }));                                                                                      // 300
                                                                                                // 301
    HTTP.call(                                                                                  // 302
      "POST", url_prefix()+"/data-test-explicit",                                               // 303
      { data: {greeting: "Hello World!"},                                                       // 304
        headers: {'Content-Type': 'text/stupid'} },                                             // 305
      expect(function(error, result) {                                                          // 306
        test.isFalse(error);                                                                    // 307
        test.isTrue(result);                                                                    // 308
        test.equal(result.statusCode, 200);                                                     // 309
        var data = result.data;                                                                 // 310
        test.equal(data.body, {greeting: "Hello World!"});                                      // 311
        // nb: some browsers include a charset here too.                                        // 312
        test.matches(data.headers['content-type'], /^text\/stupid\b/);                          // 313
      }));                                                                                      // 314
  }                                                                                             // 315
]);                                                                                             // 316
                                                                                                // 317
testAsyncMulti("httpcall - http auth", [                                                        // 318
  function(test, expect) {                                                                      // 319
    // Test basic auth                                                                          // 320
                                                                                                // 321
    // Unfortunately, any failed auth will result in a browser                                  // 322
    // password prompt.  So we don't test auth failure, only                                    // 323
    // success.                                                                                 // 324
                                                                                                // 325
    // Random password breaks in Firefox, because Firefox incorrectly                           // 326
    // uses cached credentials even if we supply different ones:                                // 327
    // https://bugzilla.mozilla.org/show_bug.cgi?id=654348                                      // 328
    var password = 'rocks';                                                                     // 329
    //var password = Random.id().replace(/[^0-9a-zA-Z]/g, '');                                  // 330
    HTTP.call(                                                                                  // 331
      "GET", url_prefix()+"/login?"+password,                                                   // 332
      { auth: "meteor:"+password },                                                             // 333
      expect(function(error, result) {                                                          // 334
        // should succeed                                                                       // 335
        test.isFalse(error);                                                                    // 336
        test.isTrue(result);                                                                    // 337
        test.equal(result.statusCode, 200);                                                     // 338
        var data = result.data;                                                                 // 339
        test.equal(data.url, "/login?"+password);                                               // 340
      }));                                                                                      // 341
                                                                                                // 342
    // test fail on malformed username:password                                                 // 343
    test.throws(function() {                                                                    // 344
      HTTP.call(                                                                                // 345
        "GET", url_prefix()+"/login?"+password,                                                 // 346
        { auth: "fooooo" },                                                                     // 347
        function() { throw new Error("can't get here"); });                                     // 348
    });                                                                                         // 349
  }                                                                                             // 350
]);                                                                                             // 351
                                                                                                // 352
testAsyncMulti("httpcall - headers", [                                                          // 353
  function(test, expect) {                                                                      // 354
    HTTP.call(                                                                                  // 355
      "GET", url_prefix()+"/foo-with-headers",                                                  // 356
      {headers: { "Test-header": "Value",                                                       // 357
                  "another": "Value2" } },                                                      // 358
      expect(function(error, result) {                                                          // 359
        test.isFalse(error);                                                                    // 360
        test.isTrue(result);                                                                    // 361
                                                                                                // 362
        test.equal(result.statusCode, 200);                                                     // 363
        var data = result.data;                                                                 // 364
        test.equal(data.url, "/foo-with-headers");                                              // 365
        test.equal(data.method, "GET");                                                         // 366
        test.equal(data.headers['test-header'], "Value");                                       // 367
        test.equal(data.headers['another'], "Value2");                                          // 368
      }));                                                                                      // 369
                                                                                                // 370
    HTTP.call(                                                                                  // 371
      "GET", url_prefix()+"/headers",                                                           // 372
      expect(function(error, result) {                                                          // 373
        test.isFalse(error);                                                                    // 374
        test.isTrue(result);                                                                    // 375
                                                                                                // 376
        test.equal(result.statusCode, 201);                                                     // 377
        test.equal(result.headers['a-silly-header'], "Tis a");                                  // 378
        test.equal(result.headers['another-silly-header'], "Silly place.");                     // 379
      }));                                                                                      // 380
  }                                                                                             // 381
]);                                                                                             // 382
                                                                                                // 383
testAsyncMulti("httpcall - params", [                                                           // 384
  function(test, expect) {                                                                      // 385
    var do_test = function(method, url, params, opt_opts, expect_url, expect_body) {            // 386
      var opts = {};                                                                            // 387
      if (typeof opt_opts === "string") {                                                       // 388
        // opt_opts omitted                                                                     // 389
        expect_body = expect_url;                                                               // 390
        expect_url = opt_opts;                                                                  // 391
      } else {                                                                                  // 392
        opts = opt_opts;                                                                        // 393
      }                                                                                         // 394
      HTTP.call(                                                                                // 395
        method, url_prefix()+url,                                                               // 396
        _.extend({ params: params }, opts),                                                     // 397
        expect(function(error, result) {                                                        // 398
          test.isFalse(error);                                                                  // 399
          test.isTrue(result);                                                                  // 400
          test.equal(result.statusCode, 200);                                                   // 401
          if (method !== "HEAD") {                                                              // 402
            var data = result.data;                                                             // 403
            test.equal(data.method, method);                                                    // 404
            test.equal(data.url, expect_url);                                                   // 405
            test.equal(data.body, expect_body);                                                 // 406
          }                                                                                     // 407
      }));                                                                                      // 408
    };                                                                                          // 409
                                                                                                // 410
    do_test("GET", "/blah", {foo:"bar"}, "/blah?foo=bar", "");                                  // 411
    do_test("GET", "/", {foo:"bar", fruit:"apple"}, "/?foo=bar&fruit=apple", "");               // 412
    do_test("POST", "/", {foo:"bar", fruit:"apple"}, "/", "foo=bar&fruit=apple");               // 413
    do_test("POST", "/", {foo:"bar", fruit:"apple"}, "/", "foo=bar&fruit=apple");               // 414
    do_test("GET", "/", {'foo!':"bang!"}, {}, "/?foo%21=bang%21", "");                          // 415
    do_test("POST", "/", {'foo!':"bang!"}, {}, "/", "foo%21=bang%21");                          // 416
    do_test("POST", "/", {foo:"bar", fruit:"apple"}, {                                          // 417
      content: "stuff!"}, "/?foo=bar&fruit=apple", "stuff!");                                   // 418
    do_test("POST", "/", {foo:"bar", greeting:"Hello World"}, {                                 // 419
      content: "stuff!"}, "/?foo=bar&greeting=Hello+World", "stuff!");                          // 420
    do_test("POST", "/foo", {foo:"bar", greeting:"Hello World"},                                // 421
            "/foo", "foo=bar&greeting=Hello+World");                                            // 422
    do_test("HEAD", "/head", {foo:"bar"}, "/head?foo=bar", "");                                 // 423
    do_test("PUT", "/put", {foo:"bar"}, "/put", "foo=bar");                                     // 424
  }                                                                                             // 425
]);                                                                                             // 426
                                                                                                // 427
                                                                                                // 428
if (Meteor.isServer) {                                                                          // 429
  // This is testing the server's static file sending code, not the http                        // 430
  // package. It's here because it is very similar to the other tests                           // 431
  // here, even though it is testing something else.                                            // 432
  //                                                                                            // 433
  // client http library mangles paths before they are requested. only                          // 434
  // run this test on the server.                                                               // 435
  testAsyncMulti("httpcall - static file serving", [                                            // 436
    function(test, expect) {                                                                    // 437
      // Suppress error printing for this test (and for any other code that sets                // 438
      // the x-suppress-error header).                                                          // 439
      WebApp.suppressConnectErrors();                                                           // 440
                                                                                                // 441
      var do_test = function (path, code, match) {                                              // 442
        HTTP.get(                                                                               // 443
          url_base() + path,                                                                    // 444
          {headers: {'x-suppress-error': 'true'}},                                              // 445
          expect(function(error, result) {                                                      // 446
            test.equal(result.statusCode, code);                                                // 447
            if (match)                                                                          // 448
              test.matches(result.content, match);                                              // 449
          }));                                                                                  // 450
      };                                                                                        // 451
                                                                                                // 452
      // existing static file                                                                   // 453
      do_test("/packages/http/test_static.serveme", 200, /static file serving/);                // 454
                                                                                                // 455
      // no such file, so return the default app HTML.                                          // 456
      var getsAppHtml = [                                                                       // 457
        // This file doesn't exist.                                                             // 458
        "/nosuchfile",                                                                          // 459
                                                                                                // 460
        // Our static file serving doesn't process .. or its encoded version, so                // 461
        // any of these return the app HTML.                                                    // 462
        "/../nosuchfile",                                                                       // 463
        "/%2e%2e/nosuchfile",                                                                   // 464
        "/%2E%2E/nosuchfile",                                                                   // 465
        "/%2d%2d/nosuchfile",                                                                   // 466
        "/packages/http/../http/test_static.serveme",                                           // 467
        "/packages/http/%2e%2e/http/test_static.serveme",                                       // 468
        "/packages/http/%2E%2E/http/test_static.serveme",                                       // 469
        "/packages/http/../../packages/http/test_static.serveme",                               // 470
        "/packages/http/%2e%2e/%2e%2e/packages/http/test_static.serveme",                       // 471
        "/packages/http/%2E%2E/%2E%2E/packages/http/test_static.serveme",                       // 472
                                                                                                // 473
        // ... and they *definitely* shouldn't be able to escape the app bundle.                // 474
        "/packages/http/../../../../../../packages/http/test_static.serveme",                   // 475
        "/../../../../../../../../../../../bin/ls",                                             // 476
        "/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/bin/ls", // 477
        "/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/%2E%2E/bin/ls"  // 478
      ];                                                                                        // 479
                                                                                                // 480
      _.each(getsAppHtml, function (x) {                                                        // 481
        do_test(x, 200, /__meteor_runtime_config__ = {/);                                       // 482
      });                                                                                       // 483
    }                                                                                           // 484
  ]);                                                                                           // 485
}                                                                                               // 486
                                                                                                // 487
                                                                                                // 488
// TO TEST/ADD:                                                                                 // 489
// - https                                                                                      // 490
// - cookies?                                                                                   // 491
// - human-readable error reason/cause?                                                         // 492
// - data parse error                                                                           // 493
                                                                                                // 494
//////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
