(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                  //
// packages/html-tools/charref_tests.js                                                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                    //
var Scanner = HTMLTools.Scanner;                                                                                    // 1
var getCharacterReference = HTMLTools.Parse.getCharacterReference;                                                  // 2
                                                                                                                    // 3
Tinytest.add("html-tools - entities", function (test) {                                                             // 4
  var succeed = function (input, match, codepoints) {                                                               // 5
    if (typeof input === 'string')                                                                                  // 6
      input = {input: input};                                                                                       // 7
                                                                                                                    // 8
    // match arg is optional; codepoints is never a string                                                          // 9
    if (typeof match !== 'string') {                                                                                // 10
      codepoints = match;                                                                                           // 11
      match = input.input;                                                                                          // 12
    }                                                                                                               // 13
                                                                                                                    // 14
    var scanner = new Scanner(input.input);                                                                         // 15
    var result = getCharacterReference(scanner, input.inAttribute, input.allowedChar);                              // 16
    test.isTrue(result);                                                                                            // 17
    test.equal(scanner.pos, match.length);                                                                          // 18
    test.equal(result, {                                                                                            // 19
      t: 'CharRef',                                                                                                 // 20
      v: match,                                                                                                     // 21
      cp: _.map(codepoints,                                                                                         // 22
                function (x) { return (typeof x === 'string' ?                                                      // 23
                                       x.charCodeAt(0) : x); })                                                     // 24
    });                                                                                                             // 25
  };                                                                                                                // 26
                                                                                                                    // 27
  var ignore = function (input) {                                                                                   // 28
    if (typeof input === 'string')                                                                                  // 29
      input = {input: input};                                                                                       // 30
                                                                                                                    // 31
    var scanner = new Scanner(input.input);                                                                         // 32
    var result = getCharacterReference(scanner, input.inAttribute, input.allowedChar);                              // 33
    test.isFalse(result);                                                                                           // 34
    test.equal(scanner.pos, 0);                                                                                     // 35
  };                                                                                                                // 36
                                                                                                                    // 37
  var fatal = function (input, messageContains) {                                                                   // 38
    if (typeof input === 'string')                                                                                  // 39
      input = {input: input};                                                                                       // 40
                                                                                                                    // 41
    var scanner = new Scanner(input.input);                                                                         // 42
    var error;                                                                                                      // 43
    try {                                                                                                           // 44
      getCharacterReference(scanner, input.inAttribute, input.allowedChar);                                         // 45
    } catch (e) {                                                                                                   // 46
      error = e;                                                                                                    // 47
    }                                                                                                               // 48
    test.isTrue(error);                                                                                             // 49
    if (error)                                                                                                      // 50
      test.isTrue(messageContains && error.message.indexOf(messageContains) >= 0, error.message);                   // 51
  };                                                                                                                // 52
                                                                                                                    // 53
  ignore('a');                                                                                                      // 54
  ignore('&');                                                                                                      // 55
  ignore('&&');                                                                                                     // 56
  ignore('&\t');                                                                                                    // 57
  ignore('& ');                                                                                                     // 58
  fatal('&#', 'Invalid numerical character reference starting with &#');                                            // 59
  ignore('&a');                                                                                                     // 60
  fatal('&a;', 'Invalid character reference: &a;');                                                                 // 61
  ignore({input: '&"', allowedChar: '"'});                                                                          // 62
  ignore('&"');                                                                                                     // 63
                                                                                                                    // 64
  succeed('&gt;', ['>']);                                                                                           // 65
  fatal('&gt', 'Character reference requires semicolon');                                                           // 66
  ignore('&aaa');                                                                                                   // 67
  fatal('&gta', 'Character reference requires semicolon');                                                          // 68
  ignore({input: '&gta', inAttribute: true});                                                                       // 69
  fatal({input: '&gt=', inAttribute: true}, 'Character reference requires semicolon: &gt');                         // 70
                                                                                                                    // 71
  succeed('&gt;;', '&gt;', ['>']);                                                                                  // 72
                                                                                                                    // 73
  fatal('&asdflkj;', 'Invalid character reference: &asdflkj;');                                                     // 74
  fatal('&A0asdflkj;', 'Invalid character reference: &A0asdflkj;');                                                 // 75
  ignore('&A0asdflkj');                                                                                             // 76
                                                                                                                    // 77
  succeed('&zopf;', [120171]);                                                                                      // 78
  succeed('&acE;', [8766, 819]);                                                                                    // 79
                                                                                                                    // 80
  succeed('&#10;', [10]);                                                                                           // 81
  fatal('&#10', 'Invalid numerical character reference starting with &#');                                          // 82
  fatal('&#xg;', 'Invalid numerical character reference starting with &#');                                         // 83
  fatal('&#;', 'Invalid numerical character reference starting with &#');                                           // 84
  fatal('&#a;', 'Invalid numerical character reference starting with &#');                                          // 85
  fatal('&#a', 'Invalid numerical character reference starting with &#');                                           // 86
  fatal('&#z', 'Invalid numerical character reference starting with &#');                                           // 87
  succeed('&#000000000000010;', [10]);                                                                              // 88
  fatal('&#0001000000000010;', 'Numerical character reference too large: 1000000000010');                           // 89
  succeed('&#x00000000000000000000a;', [10]);                                                                       // 90
  fatal('&#x000100000000000a;', 'Numerical character reference too large: 0x100000000000a');                        // 91
  succeed('&#010;', [10]);                                                                                          // 92
  succeed('&#xa;', [10]);                                                                                           // 93
  succeed('&#Xa;', [10]);                                                                                           // 94
  succeed('&#XA;', [10]);                                                                                           // 95
  succeed('&#xA;', [10]);                                                                                           // 96
                                                                                                                    // 97
  fatal('&#0;', 'Illegal codepoint in numerical character reference: &#0;');                                        // 98
  fatal('&#x0;', 'Illegal codepoint in numerical character reference: &#x0;');                                      // 99
                                                                                                                    // 100
  fatal('&#xb;', 'Illegal codepoint in numerical character reference: &#xb;');                                      // 101
  succeed('&#xc;', [12]);                                                                                           // 102
  fatal('&#11;', 'Illegal codepoint in numerical character reference: &#11;');                                      // 103
  succeed('&#12;', [12]);                                                                                           // 104
                                                                                                                    // 105
  fatal('&#x10ffff;', 'Illegal codepoint in numerical character reference');                                        // 106
  fatal('&#x10fffe;', 'Illegal codepoint in numerical character reference');                                        // 107
  succeed('&#x10fffd;', [0x10fffd]);                                                                                // 108
                                                                                                                    // 109
  fatal('&#1114111;', 'Illegal codepoint in numerical character reference');                                        // 110
  fatal('&#1114110;', 'Illegal codepoint in numerical character reference');                                        // 111
  succeed('&#1114109;', [0x10fffd]);                                                                                // 112
                                                                                                                    // 113
});                                                                                                                 // 114
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                  //
// packages/html-tools/tokenize_tests.js                                                                            //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                    //
var Scanner = HTMLTools.Scanner;                                                                                    // 1
var getComment = HTMLTools.Parse.getComment;                                                                        // 2
var getDoctype = HTMLTools.Parse.getDoctype;                                                                        // 3
var getHTMLToken = HTMLTools.Parse.getHTMLToken;                                                                    // 4
                                                                                                                    // 5
// "tokenize" is not really a great operation for real use, because                                                 // 6
// it ignores the special content rules for tags like "style" and                                                   // 7
// "script".                                                                                                        // 8
var tokenize = function (input) {                                                                                   // 9
  var scanner = new Scanner(input);                                                                                 // 10
  var tokens = [];                                                                                                  // 11
  while (! scanner.isEOF()) {                                                                                       // 12
    var token = getHTMLToken(scanner);                                                                              // 13
    if (token)                                                                                                      // 14
      tokens.push(token);                                                                                           // 15
  }                                                                                                                 // 16
                                                                                                                    // 17
  return tokens;                                                                                                    // 18
};                                                                                                                  // 19
                                                                                                                    // 20
                                                                                                                    // 21
Tinytest.add("html-tools - comments", function (test) {                                                             // 22
  var succeed = function (input, content) {                                                                         // 23
    var scanner = new Scanner(input);                                                                               // 24
    var result = getComment(scanner);                                                                               // 25
    test.isTrue(result);                                                                                            // 26
    test.equal(scanner.pos, content.length + 7);                                                                    // 27
    test.equal(result, {                                                                                            // 28
      t: 'Comment',                                                                                                 // 29
      v: content                                                                                                    // 30
    });                                                                                                             // 31
  };                                                                                                                // 32
                                                                                                                    // 33
  var ignore = function (input) {                                                                                   // 34
    var scanner = new Scanner(input);                                                                               // 35
    var result = getComment(scanner);;                                                                              // 36
    test.isFalse(result);                                                                                           // 37
    test.equal(scanner.pos, 0);                                                                                     // 38
  };                                                                                                                // 39
                                                                                                                    // 40
  var fatal = function (input, messageContains) {                                                                   // 41
    var scanner = new Scanner(input);                                                                               // 42
    var error;                                                                                                      // 43
    try {                                                                                                           // 44
      getComment(scanner);                                                                                          // 45
    } catch (e) {                                                                                                   // 46
      error = e;                                                                                                    // 47
    }                                                                                                               // 48
    test.isTrue(error);                                                                                             // 49
    if (error)                                                                                                      // 50
      test.isTrue(messageContains && error.message.indexOf(messageContains) >= 0, error.message);                   // 51
  };                                                                                                                // 52
                                                                                                                    // 53
  test.equal(getComment(new Scanner("<!-- hello -->")),                                                             // 54
             { t: 'Comment', v: ' hello ' });                                                                       // 55
                                                                                                                    // 56
  ignore("<!DOCTYPE>");                                                                                             // 57
  ignore("<!-a");                                                                                                   // 58
  ignore("<--");                                                                                                    // 59
  ignore("<!");                                                                                                     // 60
  ignore("abc");                                                                                                    // 61
  ignore("<a");                                                                                                     // 62
                                                                                                                    // 63
  fatal('<!--', 'Unclosed');                                                                                        // 64
  fatal('<!---', 'Unclosed');                                                                                       // 65
  fatal('<!----', 'Unclosed');                                                                                      // 66
  fatal('<!-- -', 'Unclosed');                                                                                      // 67
  fatal('<!-- --', 'Unclosed');                                                                                     // 68
  fatal('<!-- -- abcd', 'Unclosed');                                                                                // 69
  fatal('<!-- ->', 'Unclosed');                                                                                     // 70
  fatal('<!-- a--b -->', 'cannot contain');                                                                         // 71
  fatal('<!--x--->', 'must end at first');                                                                          // 72
                                                                                                                    // 73
  fatal('<!-- a\u0000b -->', 'cannot contain');                                                                     // 74
  fatal('<!--\u0000 x-->', 'cannot contain');                                                                       // 75
                                                                                                                    // 76
  succeed('<!---->', '');                                                                                           // 77
  succeed('<!---x-->', '-x');                                                                                       // 78
  succeed('<!--x-->', 'x');                                                                                         // 79
  succeed('<!-- hello - - world -->', ' hello - - world ');                                                         // 80
});                                                                                                                 // 81
                                                                                                                    // 82
Tinytest.add("html-tools - doctype", function (test) {                                                              // 83
  var succeed = function (input, expectedProps) {                                                                   // 84
    var scanner = new Scanner(input);                                                                               // 85
    var result = getDoctype(scanner);                                                                               // 86
    test.isTrue(result);                                                                                            // 87
    test.equal(scanner.pos, result.v.length);                                                                       // 88
    test.equal(input.slice(0, result.v.length), result.v);                                                          // 89
    var actualProps = _.extend({}, result);                                                                         // 90
    delete actualProps.t;                                                                                           // 91
    delete actualProps.v;                                                                                           // 92
    test.equal(actualProps, expectedProps);                                                                         // 93
  };                                                                                                                // 94
                                                                                                                    // 95
  var fatal = function (input, messageContains) {                                                                   // 96
    var scanner = new Scanner(input);                                                                               // 97
    var error;                                                                                                      // 98
    try {                                                                                                           // 99
      getDoctype(scanner);                                                                                          // 100
    } catch (e) {                                                                                                   // 101
      error = e;                                                                                                    // 102
    }                                                                                                               // 103
    test.isTrue(error);                                                                                             // 104
    if (messageContains)                                                                                            // 105
      test.isTrue(error.message.indexOf(messageContains) >= 0, error.message);                                      // 106
  };                                                                                                                // 107
                                                                                                                    // 108
  test.equal(getDoctype(new Scanner("<!DOCTYPE html>x")),                                                           // 109
             { t: 'Doctype',                                                                                        // 110
               v: '<!DOCTYPE html>',                                                                                // 111
               name: 'html' });                                                                                     // 112
                                                                                                                    // 113
  test.equal(getDoctype(new Scanner("<!DOCTYPE html SYSTEM 'about:legacy-compat'>x")),                              // 114
             { t: 'Doctype',                                                                                        // 115
               v: "<!DOCTYPE html SYSTEM 'about:legacy-compat'>",                                                   // 116
               name: 'html',                                                                                        // 117
               systemId: 'about:legacy-compat' });                                                                  // 118
                                                                                                                    // 119
  test.equal(getDoctype(new Scanner("<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.0//EN'>x")),                         // 120
             { t: 'Doctype',                                                                                        // 121
               v: "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.0//EN'>",                                              // 122
               name: 'html',                                                                                        // 123
               publicId: '-//W3C//DTD HTML 4.0//EN' });                                                             // 124
                                                                                                                    // 125
  test.equal(getDoctype(new Scanner("<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.0//EN' 'http://www.w3.org/TR/html4/strict.dtd'>x")),
             { t: 'Doctype',                                                                                        // 127
               v: "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.0//EN' 'http://www.w3.org/TR/html4/strict.dtd'>",      // 128
               name: 'html',                                                                                        // 129
               publicId: '-//W3C//DTD HTML 4.0//EN',                                                                // 130
               systemId: 'http://www.w3.org/TR/html4/strict.dtd' });                                                // 131
                                                                                                                    // 132
  succeed('<!DOCTYPE html>', {name: 'html'});                                                                       // 133
  succeed('<!DOCTYPE htML>', {name: 'html'});                                                                       // 134
  succeed('<!DOCTYPE HTML>', {name: 'html'});                                                                       // 135
  succeed('<!doctype html>', {name: 'html'});                                                                       // 136
  succeed('<!doctYPE html>', {name: 'html'});                                                                       // 137
  succeed('<!DOCTYPE html \u000c>', {name: 'html'});                                                                // 138
  fatal('<!DOCTYPE', 'Expected space');                                                                             // 139
  fatal('<!DOCTYPE ', 'Malformed DOCTYPE');                                                                         // 140
  fatal('<!DOCTYPE  ', 'Malformed DOCTYPE');                                                                        // 141
  fatal('<!DOCTYPE>', 'Expected space');                                                                            // 142
  fatal('<!DOCTYPE >', 'Malformed DOCTYPE');                                                                        // 143
  fatal('<!DOCTYPE\u0000', 'Expected space');                                                                       // 144
  fatal('<!DOCTYPE \u0000', 'Malformed DOCTYPE');                                                                   // 145
  fatal('<!DOCTYPE html\u0000>', 'Malformed DOCTYPE');                                                              // 146
  fatal('<!DOCTYPE html', 'Malformed DOCTYPE');                                                                     // 147
                                                                                                                    // 148
  succeed('<!DOCTYPE html SYSTEM "about:legacy-compat">', {name: 'html', systemId: 'about:legacy-compat'});         // 149
  succeed('<!doctype HTML system "about:legacy-compat">', {name: 'html', systemId: 'about:legacy-compat'});         // 150
  succeed("<!DOCTYPE html SYSTEM 'about:legacy-compat'>", {name: 'html', systemId: 'about:legacy-compat'});         // 151
  succeed("<!dOcTyPe HtMl sYsTeM 'about:legacy-compat'>", {name: 'html', systemId: 'about:legacy-compat'});         // 152
  succeed('<!DOCTYPE  html\tSYSTEM\t"about:legacy-compat"   \t>', {name: 'html', systemId: 'about:legacy-compat'}); // 153
  fatal('<!DOCTYPE html SYSTE "about:legacy-compat">', 'Expected PUBLIC or SYSTEM');                                // 154
  fatal('<!DOCTYPE html SYSTE', 'Expected PUBLIC or SYSTEM');                                                       // 155
  fatal('<!DOCTYPE html SYSTEM"about:legacy-compat">', 'Expected space');                                           // 156
  fatal('<!DOCTYPE html SYSTEM');                                                                                   // 157
  fatal('<!DOCTYPE html SYSTEM ');                                                                                  // 158
  fatal('<!DOCTYPE html SYSTEM>');                                                                                  // 159
  fatal('<!DOCTYPE html SYSTEM >');                                                                                 // 160
  fatal('<!DOCTYPE html SYSTEM ">">');                                                                              // 161
  fatal('<!DOCTYPE html SYSTEM "\u0000about:legacy-compat">');                                                      // 162
  fatal('<!DOCTYPE html SYSTEM "about:legacy-compat\u0000">');                                                      // 163
  fatal('<!DOCTYPE html SYSTEM "');                                                                                 // 164
  fatal('<!DOCTYPE html SYSTEM "">');                                                                               // 165
  fatal('<!DOCTYPE html SYSTEM \'');                                                                                // 166
  fatal('<!DOCTYPE html SYSTEM\'a\'>');                                                                             // 167
  fatal('<!DOCTYPE html SYSTEM about:legacy-compat>');                                                              // 168
                                                                                                                    // 169
  succeed('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0//EN">',                                                      // 170
          { name: 'html',                                                                                           // 171
            publicId: '-//W3C//DTD HTML 4.0//EN'});                                                                 // 172
  succeed('<!DOCTYPE html PUBLIC \'-//W3C//DTD HTML 4.0//EN\'>',                                                    // 173
          { name: 'html',                                                                                           // 174
            publicId: '-//W3C//DTD HTML 4.0//EN'});                                                                 // 175
  succeed('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">',         // 176
          { name: 'html',                                                                                           // 177
            publicId: '-//W3C//DTD HTML 4.0//EN',                                                                   // 178
            systemId: 'http://www.w3.org/TR/REC-html40/strict.dtd'});                                               // 179
  succeed('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0//EN" \'http://www.w3.org/TR/REC-html40/strict.dtd\'>',       // 180
          { name: 'html',                                                                                           // 181
            publicId: '-//W3C//DTD HTML 4.0//EN',                                                                   // 182
            systemId: 'http://www.w3.org/TR/REC-html40/strict.dtd'});                                               // 183
  succeed('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' \'http://www.w3.org/TR/REC-html40/strict.dtd\'>',     // 184
          { name: 'html',                                                                                           // 185
            publicId: '-//W3C//DTD HTML 4.0//EN',                                                                   // 186
            systemId: 'http://www.w3.org/TR/REC-html40/strict.dtd'});                                               // 187
  succeed('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\'\t\'http://www.w3.org/TR/REC-html40/strict.dtd\'   >', // 188
          { name: 'html',                                                                                           // 189
            publicId: '-//W3C//DTD HTML 4.0//EN',                                                                   // 190
            systemId: 'http://www.w3.org/TR/REC-html40/strict.dtd'});                                               // 191
  fatal('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' \'http://www.w3.org/TR/REC-html40/strict.dtd\'');       // 192
  fatal('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' \'http://www.w3.org/TR/REC-html40/strict.dtd\'');       // 193
  fatal('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' \'http://www.w3.org/TR/REC-html40/strict.dtd');         // 194
  fatal('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' \'');                                                   // 195
  fatal('<!DOCTYPE html public \'-//W3C//DTD HTML 4.0//EN\' ');                                                     // 196
  fatal('<!DOCTYPE html public \'- ');                                                                              // 197
  fatal('<!DOCTYPE html public>');                                                                                  // 198
  fatal('<!DOCTYPE html public "-//W3C//DTD HTML 4.0//EN""http://www.w3.org/TR/REC-html40/strict.dtd">');           // 199
});                                                                                                                 // 200
                                                                                                                    // 201
Tinytest.add("html-tools - tokenize", function (test) {                                                             // 202
                                                                                                                    // 203
  var fatal = function (input, messageContains) {                                                                   // 204
    var error;                                                                                                      // 205
    try {                                                                                                           // 206
      tokenize(input);                                                                                              // 207
    } catch (e) {                                                                                                   // 208
      error = e;                                                                                                    // 209
    }                                                                                                               // 210
    test.isTrue(error);                                                                                             // 211
    if (messageContains)                                                                                            // 212
      test.isTrue(error.message.indexOf(messageContains) >= 0, error.message);                                      // 213
  };                                                                                                                // 214
                                                                                                                    // 215
                                                                                                                    // 216
  test.equal(tokenize(''), []);                                                                                     // 217
  test.equal(tokenize('abc'), [{t: 'Chars', v: 'abc'}]);                                                            // 218
  test.equal(tokenize('&'), [{t: 'Chars', v: '&'}]);                                                                // 219
  test.equal(tokenize('&amp;'), [{t: 'CharRef', v: '&amp;', cp: [38]}]);                                            // 220
  test.equal(tokenize('ok&#32;fine'),                                                                               // 221
             [{t: 'Chars', v: 'ok'},                                                                                // 222
              {t: 'CharRef', v: '&#32;', cp: [32]},                                                                 // 223
              {t: 'Chars', v: 'fine'}]);                                                                            // 224
                                                                                                                    // 225
  test.equal(tokenize('a<!--b-->c'),                                                                                // 226
             [{t: 'Chars',                                                                                          // 227
               v: 'a'},                                                                                             // 228
              {t: 'Comment',                                                                                        // 229
               v: 'b'},                                                                                             // 230
              {t: 'Chars',                                                                                          // 231
               v: 'c'}]);                                                                                           // 232
                                                                                                                    // 233
  test.equal(tokenize('<a>'), [{t: 'Tag', n: 'a'}]);                                                                // 234
                                                                                                                    // 235
  fatal('<');                                                                                                       // 236
  fatal('<x');                                                                                                      // 237
  fatal('<x ');                                                                                                     // 238
  fatal('<x a');                                                                                                    // 239
  fatal('<x a ');                                                                                                   // 240
  fatal('<x a =');                                                                                                  // 241
  fatal('<x a = ');                                                                                                 // 242
  fatal('<x a = b');                                                                                                // 243
  fatal('<x a = "b');                                                                                               // 244
  fatal('<x a = \'b');                                                                                              // 245
  fatal('<x a = b ');                                                                                               // 246
  fatal('<x a = b /');                                                                                              // 247
  test.equal(tokenize('<x a = b />'),                                                                               // 248
             [{t: 'Tag', n: 'x',                                                                                    // 249
               attrs: { a: [{t: 'Chars', v: 'b'}] },                                                                // 250
               isSelfClosing: true}]);                                                                              // 251
                                                                                                                    // 252
  test.equal(tokenize('<a>X</a>'),                                                                                  // 253
             [{t: 'Tag', n: 'a'},                                                                                   // 254
              {t: 'Chars', v: 'X'},                                                                                 // 255
              {t: 'Tag', n: 'a', isEnd: true}]);                                                                    // 256
                                                                                                                    // 257
  fatal('<x a a>'); // duplicate attribute value                                                                    // 258
  test.equal(tokenize('<a b  >'),                                                                                   // 259
             [{t: 'Tag', n: 'a', attrs: { b: [] }}]);                                                               // 260
  fatal('< a>');                                                                                                    // 261
  fatal('< /a>');                                                                                                   // 262
  fatal('</ a>');                                                                                                   // 263
                                                                                                                    // 264
  // Slash does not end an unquoted attribute, interestingly                                                        // 265
  test.equal(tokenize('<a b=/>'),                                                                                   // 266
             [{t: 'Tag', n: 'a', attrs: { b: [{t: 'Chars', v: '/'}] }}]);                                           // 267
                                                                                                                    // 268
  test.equal(tokenize('<a b="c" d=e f=\'g\' h \t>'),                                                                // 269
             [{t: 'Tag', n: 'a',                                                                                    // 270
               attrs: { b: [{t: 'Chars', v: 'c'}],                                                                  // 271
                        d: [{t: 'Chars', v: 'e'}],                                                                  // 272
                        f: [{t: 'Chars', v: 'g'}],                                                                  // 273
                        h: [] }}]);                                                                                 // 274
                                                                                                                    // 275
  fatal('</a b="c" d=e f=\'g\' h \t\u0000>');                                                                       // 276
  fatal('</a b="c" d=ef=\'g\' h \t>');                                                                              // 277
  fatal('</a b="c"d=e f=\'g\' h \t>');                                                                              // 278
                                                                                                                    // 279
  test.equal(tokenize('<a/>'), [{t: 'Tag', n: 'a', isSelfClosing: true}]);                                          // 280
                                                                                                                    // 281
  fatal('<a/ >');                                                                                                   // 282
  fatal('<a/b>');                                                                                                   // 283
  fatal('<a b=c`>');                                                                                                // 284
  fatal('<a b=c<>');                                                                                                // 285
                                                                                                                    // 286
  test.equal(tokenize('<a# b0="c@" d1=e2 f#=\'g  \' h \t>'),                                                        // 287
             [{t: 'Tag', n: 'a#',                                                                                   // 288
               attrs: { b0: [{t: 'Chars', v: 'c@'}],                                                                // 289
                        d1: [{t: 'Chars', v: 'e2'}],                                                                // 290
                        'f#': [{t: 'Chars', v: 'g  '}],                                                             // 291
                        h: [] }}]);                                                                                 // 292
                                                                                                                    // 293
  test.equal(tokenize('<div class=""></div>'),                                                                      // 294
             [{t: 'Tag', n: 'div', attrs: { 'class': [] }},                                                         // 295
              {t: 'Tag', n: 'div', isEnd: true}]);                                                                  // 296
                                                                                                                    // 297
  test.equal(tokenize('<div class="&">'),                                                                           // 298
             [{t: 'Tag', n: 'div', attrs: { 'class': [{t: 'Chars', v: '&'}] }}]);                                   // 299
  test.equal(tokenize('<div class=&>'),                                                                             // 300
             [{t: 'Tag', n: 'div', attrs: { 'class': [{t: 'Chars', v: '&'}] }}]);                                   // 301
  test.equal(tokenize('<div class=&amp;>'),                                                                         // 302
             [{t: 'Tag', n: 'div', attrs: { 'class': [{t: 'CharRef', v: '&amp;', cp: [38]}] }}]);                   // 303
                                                                                                                    // 304
  test.equal(tokenize('<div class=aa&&zopf;&acE;&bb>'),                                                             // 305
             [{t: 'Tag', n: 'div', attrs: { 'class': [                                                              // 306
               {t: 'Chars', v: 'aa&'},                                                                              // 307
               {t: 'CharRef', v: '&zopf;', cp: [120171]},                                                           // 308
               {t: 'CharRef', v: '&acE;', cp: [8766, 819]},                                                         // 309
               {t: 'Chars', v: '&bb'}                                                                               // 310
             ] }}]);                                                                                                // 311
                                                                                                                    // 312
  test.equal(tokenize('<div class="aa &&zopf;&acE;& bb">'),                                                         // 313
             [{t: 'Tag', n: 'div', attrs: { 'class': [                                                              // 314
               {t: 'Chars', v: 'aa &'},                                                                             // 315
               {t: 'CharRef', v: '&zopf;', cp: [120171]},                                                           // 316
               {t: 'CharRef', v: '&acE;', cp: [8766, 819]},                                                         // 317
               {t: 'Chars', v: '& bb'}                                                                              // 318
             ] }}]);                                                                                                // 319
                                                                                                                    // 320
  test.equal(tokenize('<a b="\'`<>&">'),                                                                            // 321
             [{t: 'Tag', n: 'a', attrs: { b: [{t: 'Chars', v: '\'`<>&'}] }}]);                                      // 322
  test.equal(tokenize('<a b=\'"`<>&\'>'),                                                                           // 323
             [{t: 'Tag', n: 'a', attrs: { b: [{t: 'Chars', v: '"`<>&'}] }}]);                                       // 324
                                                                                                                    // 325
  fatal('&gt');                                                                                                     // 326
  fatal('&gtc');                                                                                                    // 327
  test.equal(tokenize('<a b=&gtc>'),                                                                                // 328
             [{t: 'Tag', n: 'a', attrs: { b: [{t: 'Chars', v: '&gtc' }] }}]);                                       // 329
  test.equal(tokenize('<a b="&gtc">'),                                                                              // 330
             [{t: 'Tag', n: 'a', attrs: { b: [{t: 'Chars', v: '&gtc' }] }}]);                                       // 331
  fatal('<a b=&gt>');                                                                                               // 332
  fatal('<a b="&gt">');                                                                                             // 333
  fatal('<a b="&gt=">');                                                                                            // 334
                                                                                                                    // 335
  fatal('<!');                                                                                                      // 336
  fatal('<!x>');                                                                                                    // 337
                                                                                                                    // 338
  fatal('<a{{b}}>');                                                                                                // 339
  fatal('<{{a}}>');                                                                                                 // 340
  fatal('</a b=c>'); // end tag can't have attributes                                                               // 341
  fatal('</a/>'); // end tag can't be self-closing                                                                  // 342
  fatal('</a  />');                                                                                                 // 343
});                                                                                                                 // 344
                                                                                                                    // 345
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                  //
// packages/html-tools/parse_tests.js                                                                               //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                    //
var Scanner = HTMLTools.Scanner;                                                                                    // 1
var getContent = HTMLTools.Parse.getContent;                                                                        // 2
                                                                                                                    // 3
var CharRef = HTML.CharRef;                                                                                         // 4
var Comment = HTML.Comment;                                                                                         // 5
var TemplateTag = HTMLTools.TemplateTag;                                                                            // 6
var Attrs = HTML.Attrs;                                                                                             // 7
                                                                                                                    // 8
var BR = HTML.BR;                                                                                                   // 9
var HR = HTML.HR;                                                                                                   // 10
var INPUT = HTML.INPUT;                                                                                             // 11
var A = HTML.A;                                                                                                     // 12
var DIV = HTML.DIV;                                                                                                 // 13
var P = HTML.P;                                                                                                     // 14
var TEXTAREA = HTML.TEXTAREA;                                                                                       // 15
                                                                                                                    // 16
Tinytest.add("html-tools - parser getContent", function (test) {                                                    // 17
                                                                                                                    // 18
  var succeed = function (input, expected) {                                                                        // 19
    var endPos = input.indexOf('^^^');                                                                              // 20
    if (endPos < 0)                                                                                                 // 21
      endPos = input.length;                                                                                        // 22
                                                                                                                    // 23
    var scanner = new Scanner(input.replace('^^^', ''));                                                            // 24
    var result = getContent(scanner);                                                                               // 25
    test.equal(scanner.pos, endPos);                                                                                // 26
    test.equal(BlazeTools.toJS(result), BlazeTools.toJS(expected));                                                 // 27
  };                                                                                                                // 28
                                                                                                                    // 29
  var fatal = function (input, messageContains) {                                                                   // 30
    var scanner = new Scanner(input);                                                                               // 31
    var error;                                                                                                      // 32
    try {                                                                                                           // 33
      getContent(scanner);                                                                                          // 34
    } catch (e) {                                                                                                   // 35
      error = e;                                                                                                    // 36
    }                                                                                                               // 37
    test.isTrue(error);                                                                                             // 38
    if (messageContains)                                                                                            // 39
      test.isTrue(messageContains && error.message.indexOf(messageContains) >= 0, error.message);                   // 40
  };                                                                                                                // 41
                                                                                                                    // 42
                                                                                                                    // 43
  succeed('', null);                                                                                                // 44
  succeed('abc', 'abc');                                                                                            // 45
  succeed('abc^^^</x>', 'abc');                                                                                     // 46
  succeed('a&lt;b', ['a', CharRef({html: '&lt;', str: '<'}), 'b']);                                                 // 47
  succeed('<!-- x -->', Comment(' x '));                                                                            // 48
  succeed('&acE;', CharRef({html: '&acE;', str: '\u223e\u0333'}));                                                  // 49
  succeed('&zopf;', CharRef({html: '&zopf;', str: '\ud835\udd6b'}));                                                // 50
  succeed('&&>&g&gt;;', ['&&>&g', CharRef({html: '&gt;', str: '>'}), ';']);                                         // 51
                                                                                                                    // 52
  // Can't have an unescaped `&` if followed by certain names like `gt`                                             // 53
  fatal('&gt&');                                                                                                    // 54
  // tests for other failure cases                                                                                  // 55
  fatal('<');                                                                                                       // 56
                                                                                                                    // 57
  succeed('<br>', BR());                                                                                            // 58
  succeed('<br/>', BR());                                                                                           // 59
  fatal('<div/>', 'self-close');                                                                                    // 60
                                                                                                                    // 61
  succeed('<hr id=foo>', HR({id:'foo'}));                                                                           // 62
  succeed('<hr id=&lt;foo&gt;>', HR({id:[CharRef({html:'&lt;', str:'<'}),                                           // 63
                                         'foo',                                                                     // 64
                                         CharRef({html:'&gt;', str:'>'})]}));                                       // 65
  succeed('<input selected>', INPUT({selected: ''}));                                                               // 66
  succeed('<input selected/>', INPUT({selected: ''}));                                                              // 67
  succeed('<input selected />', INPUT({selected: ''}));                                                             // 68
  var FOO = HTML.getTag('foo');                                                                                     // 69
  succeed('<foo bar></foo>', FOO({bar: ''}));                                                                       // 70
  succeed('<foo bar baz ></foo>', FOO({bar: '', baz: ''}));                                                         // 71
  succeed('<foo bar=x baz qux=y blah ></foo>',                                                                      // 72
          FOO({bar: 'x', baz: '', qux: 'y', blah: ''}));                                                            // 73
  succeed('<foo bar="x" baz qux="y" blah ></foo>',                                                                  // 74
          FOO({bar: 'x', baz: '', qux: 'y', blah: ''}));                                                            // 75
  fatal('<input bar"baz">');                                                                                        // 76
  fatal('<input x="y"z >');                                                                                         // 77
  fatal('<input x=\'y\'z >');                                                                                       // 78
  succeed('<br x=&&&>', BR({x: '&&&'}));                                                                            // 79
  succeed('<br><br><br>', [BR(), BR(), BR()]);                                                                      // 80
  succeed('aaa<br>\nbbb<br>\nccc<br>', ['aaa', BR(), '\nbbb', BR(), '\nccc', BR()]);                                // 81
                                                                                                                    // 82
  succeed('<a></a>', A());                                                                                          // 83
  fatal('<');                                                                                                       // 84
  fatal('<a');                                                                                                      // 85
  fatal('<a>');                                                                                                     // 86
  fatal('<a><');                                                                                                    // 87
  fatal('<a></');                                                                                                   // 88
  fatal('<a></a');                                                                                                  // 89
                                                                                                                    // 90
  succeed('<a href="http://www.apple.com/">Apple</a>',                                                              // 91
          A({href: "http://www.apple.com/"}, 'Apple'));                                                             // 92
                                                                                                                    // 93
  (function () {                                                                                                    // 94
    var A = HTML.getTag('a');                                                                                       // 95
    var B = HTML.getTag('b');                                                                                       // 96
    var C = HTML.getTag('c');                                                                                       // 97
    var D = HTML.getTag('d');                                                                                       // 98
                                                                                                                    // 99
    succeed('<a>1<b>2<c>3<d>4</d>5</c>6</b>7</a>8',                                                                 // 100
            [A('1', B('2', C('3', D('4'), '5'), '6'), '7'), '8']);                                                  // 101
  })();                                                                                                             // 102
                                                                                                                    // 103
  fatal('<b>hello <i>there</b> world</i>');                                                                         // 104
                                                                                                                    // 105
  // XXX support implied end tags in cases allowed by the spec                                                      // 106
  fatal('<p>');                                                                                                     // 107
                                                                                                                    // 108
  fatal('<a>Foo</a/>');                                                                                             // 109
  fatal('<a>Foo</a b=c>');                                                                                          // 110
                                                                                                                    // 111
  succeed('<textarea>asdf</textarea>', TEXTAREA({value: "asdf"}));                                                  // 112
  succeed('<textarea x=y>asdf</textarea>', TEXTAREA({x: "y", value: "asdf"}));                                      // 113
  succeed('<textarea><p></textarea>', TEXTAREA({value: "<p>"}));                                                    // 114
  succeed('<textarea>a&amp;b</textarea>',                                                                           // 115
          TEXTAREA({value: ["a", CharRef({html: '&amp;', str: '&'}), "b"]}));                                       // 116
  succeed('<textarea></textarea</textarea>', TEXTAREA({value: "</textarea"}));                                      // 117
  // absorb up to one initial newline, as per HTML parsing spec                                                     // 118
  succeed('<textarea>\n</textarea>', TEXTAREA());                                                                   // 119
  succeed('<textarea>\nasdf</textarea>', TEXTAREA({value: "asdf"}));                                                // 120
  succeed('<textarea>\n\nasdf</textarea>', TEXTAREA({value: "\nasdf"}));                                            // 121
  succeed('<textarea>\n\n</textarea>', TEXTAREA({value: "\n"}));                                                    // 122
  succeed('<textarea>\nasdf\n</textarea>', TEXTAREA({value: "asdf\n"}));                                            // 123
  succeed('<textarea><!-- --></textarea>', TEXTAREA({value: "<!-- -->"}));                                          // 124
  succeed('<tExTaReA>asdf</TEXTarea>', TEXTAREA({value: "asdf"}));                                                  // 125
  fatal('<textarea>asdf');                                                                                          // 126
  fatal('<textarea>asdf</textarea');                                                                                // 127
  fatal('<textarea>&davidgreenspan;</textarea>');                                                                   // 128
  succeed('<textarea>&</textarea>', TEXTAREA({value: "&"}));                                                        // 129
  succeed('<textarea></textarea  \n<</textarea  \n>asdf',                                                           // 130
          [TEXTAREA({value: "</textarea  \n<"}), "asdf"]);                                                          // 131
  // regression test for a bug that happened with textarea content                                                  // 132
  // handling after an element with content                                                                         // 133
  succeed('<div>x</div><textarea></textarea>', [DIV("x"), TEXTAREA()]);                                             // 134
                                                                                                                    // 135
  // CR/LF behavior                                                                                                 // 136
  succeed('<br\r\n x>', BR({x:''}));                                                                                // 137
  succeed('<br\r x>', BR({x:''}));                                                                                  // 138
  succeed('<br x="y"\r\n>', BR({x:'y'}));                                                                           // 139
  succeed('<br x="y"\r>', BR({x:'y'}));                                                                             // 140
  succeed('<br x=\r\n"y">', BR({x:'y'}));                                                                           // 141
  succeed('<br x=\r"y">', BR({x:'y'}));                                                                             // 142
  succeed('<br x\r=\r"y">', BR({x:'y'}));                                                                           // 143
  succeed('<!--\r\n-->', Comment('\n'));                                                                            // 144
  succeed('<!--\r-->', Comment('\n'));                                                                              // 145
  succeed('<textarea>a\r\nb\r\nc</textarea>', TEXTAREA({value: 'a\nb\nc'}));                                        // 146
  succeed('<textarea>a\rb\rc</textarea>', TEXTAREA({value: 'a\nb\nc'}));                                            // 147
  succeed('<br x="\r\n\r\n">', BR({x:'\n\n'}));                                                                     // 148
  succeed('<br x="\r\r">', BR({x:'\n\n'}));                                                                         // 149
  succeed('<br x=y\r>', BR({x:'y'}));                                                                               // 150
  fatal('<br x=\r>');                                                                                               // 151
});                                                                                                                 // 152
                                                                                                                    // 153
Tinytest.add("html-tools - parseFragment", function (test) {                                                        // 154
  test.equal(BlazeTools.toJS(HTMLTools.parseFragment("<div><p id=foo>Hello</p></div>")),                            // 155
             BlazeTools.toJS(DIV(P({id:'foo'}, 'Hello'))));                                                         // 156
                                                                                                                    // 157
  _.each(['asdf</br>', '{{!foo}}</br>', '{{!foo}} </br>',                                                           // 158
          'asdf</a>', '{{!foo}}</a>', '{{!foo}} </a>'], function (badFrag) {                                        // 159
            test.throws(function() {                                                                                // 160
              HTMLTools.parseFragment(badFrag);                                                                     // 161
            }, /Unexpected HTML close tag/);                                                                        // 162
          });                                                                                                       // 163
                                                                                                                    // 164
  (function () {                                                                                                    // 165
    var p = HTMLTools.parseFragment('<p></p>');                                                                     // 166
    test.equal(p.tagName, 'p');                                                                                     // 167
    test.equal(p.attrs, null);                                                                                      // 168
    test.isTrue(p instanceof HTML.Tag);                                                                             // 169
    test.equal(p.children.length, 0);                                                                               // 170
  })();                                                                                                             // 171
                                                                                                                    // 172
  (function () {                                                                                                    // 173
    var p = HTMLTools.parseFragment('<p>x</p>');                                                                    // 174
    test.equal(p.tagName, 'p');                                                                                     // 175
    test.equal(p.attrs, null);                                                                                      // 176
    test.isTrue(p instanceof HTML.Tag);                                                                             // 177
    test.equal(p.children.length, 1);                                                                               // 178
    test.equal(p.children[0], 'x');                                                                                 // 179
  })();                                                                                                             // 180
                                                                                                                    // 181
  (function () {                                                                                                    // 182
    var p = HTMLTools.parseFragment('<p>x&#65;</p>');                                                               // 183
    test.equal(p.tagName, 'p');                                                                                     // 184
    test.equal(p.attrs, null);                                                                                      // 185
    test.isTrue(p instanceof HTML.Tag);                                                                             // 186
    test.equal(p.children.length, 2);                                                                               // 187
    test.equal(p.children[0], 'x');                                                                                 // 188
                                                                                                                    // 189
    test.isTrue(p.children[1] instanceof HTML.CharRef);                                                             // 190
    test.equal(p.children[1].html, '&#65;');                                                                        // 191
    test.equal(p.children[1].str, 'A');                                                                             // 192
  })();                                                                                                             // 193
                                                                                                                    // 194
  (function () {                                                                                                    // 195
    var pp = HTMLTools.parseFragment('<p>x</p><p>y</p>');                                                           // 196
    test.isTrue(pp instanceof Array);                                                                               // 197
    test.equal(pp.length, 2);                                                                                       // 198
                                                                                                                    // 199
    test.equal(pp[0].tagName, 'p');                                                                                 // 200
    test.equal(pp[0].attrs, null);                                                                                  // 201
    test.isTrue(pp[0] instanceof HTML.Tag);                                                                         // 202
    test.equal(pp[0].children.length, 1);                                                                           // 203
    test.equal(pp[0].children[0], 'x');                                                                             // 204
                                                                                                                    // 205
    test.equal(pp[1].tagName, 'p');                                                                                 // 206
    test.equal(pp[1].attrs, null);                                                                                  // 207
    test.isTrue(pp[1] instanceof HTML.Tag);                                                                         // 208
    test.equal(pp[1].children.length, 1);                                                                           // 209
    test.equal(pp[1].children[0], 'y');                                                                             // 210
  })();                                                                                                             // 211
                                                                                                                    // 212
  var scanner = new Scanner('asdf');                                                                                // 213
  scanner.pos = 1;                                                                                                  // 214
  test.equal(HTMLTools.parseFragment(scanner), 'sdf');                                                              // 215
                                                                                                                    // 216
  test.throws(function () {                                                                                         // 217
    var scanner = new Scanner('asdf</p>');                                                                          // 218
    scanner.pos = 1;                                                                                                // 219
    HTMLTools.parseFragment(scanner);                                                                               // 220
  });                                                                                                               // 221
});                                                                                                                 // 222
                                                                                                                    // 223
Tinytest.add("html-tools - getTemplateTag", function (test) {                                                       // 224
                                                                                                                    // 225
  // match a simple tag consisting of `{{`, an optional `!`, one                                                    // 226
  // or more ASCII letters, spaces or html tags, and a closing `}}`.                                                // 227
  var mustache = /^\{\{(!?[a-zA-Z 0-9</>]+)\}\}/;                                                                   // 228
                                                                                                                    // 229
  // This implementation of `getTemplateTag` looks for "{{" and if it                                               // 230
  // finds it, it will match the regex above or fail fatally trying.                                                // 231
  // The object it returns is opaque to the tokenizer/parser and can                                                // 232
  // be anything we want.                                                                                           // 233
  var getTemplateTag = function (scanner, position) {                                                               // 234
    if (! (scanner.peek() === '{' && // one-char peek is just an optimization                                       // 235
           scanner.rest().slice(0, 2) === '{{'))                                                                    // 236
      return null;                                                                                                  // 237
                                                                                                                    // 238
    var match = mustache.exec(scanner.rest());                                                                      // 239
    if (! match)                                                                                                    // 240
      scanner.fatal("Bad mustache");                                                                                // 241
                                                                                                                    // 242
    scanner.pos += match[0].length;                                                                                 // 243
                                                                                                                    // 244
    if (match[1].charAt(0) === '!')                                                                                 // 245
      return null; // `{{!foo}}` is like a comment                                                                  // 246
                                                                                                                    // 247
    return TemplateTag({ stuff: match[1] });                                                                        // 248
  };                                                                                                                // 249
                                                                                                                    // 250
                                                                                                                    // 251
                                                                                                                    // 252
  var succeed = function (input, expected) {                                                                        // 253
    var endPos = input.indexOf('^^^');                                                                              // 254
    if (endPos < 0)                                                                                                 // 255
      endPos = input.length;                                                                                        // 256
                                                                                                                    // 257
    var scanner = new Scanner(input.replace('^^^', ''));                                                            // 258
    scanner.getTemplateTag = getTemplateTag;                                                                        // 259
    var result;                                                                                                     // 260
    try {                                                                                                           // 261
      result = getContent(scanner);                                                                                 // 262
    } catch (e) {                                                                                                   // 263
      result = String(e);                                                                                           // 264
    }                                                                                                               // 265
    test.equal(scanner.pos, endPos);                                                                                // 266
    test.equal(BlazeTools.toJS(result), BlazeTools.toJS(expected));                                                 // 267
  };                                                                                                                // 268
                                                                                                                    // 269
  var fatal = function (input, messageContains) {                                                                   // 270
    var scanner = new Scanner(input);                                                                               // 271
    scanner.getTemplateTag = getTemplateTag;                                                                        // 272
    var error;                                                                                                      // 273
    try {                                                                                                           // 274
      getContent(scanner);                                                                                          // 275
    } catch (e) {                                                                                                   // 276
      error = e;                                                                                                    // 277
    }                                                                                                               // 278
    test.isTrue(error);                                                                                             // 279
    if (messageContains)                                                                                            // 280
      test.isTrue(messageContains && error.message.indexOf(messageContains) >= 0, error.message);                   // 281
  };                                                                                                                // 282
                                                                                                                    // 283
                                                                                                                    // 284
  succeed('{{foo}}', TemplateTag({stuff: 'foo'}));                                                                  // 285
                                                                                                                    // 286
  succeed('<a href=http://www.apple.com/>{{foo}}</a>',                                                              // 287
          A({href: "http://www.apple.com/"}, TemplateTag({stuff: 'foo'})));                                         // 288
                                                                                                                    // 289
  // tags not parsed in comments                                                                                    // 290
  succeed('<!--{{foo}}-->', Comment("{{foo}}"));                                                                    // 291
  succeed('<!--{{foo-->', Comment("{{foo"));                                                                        // 292
                                                                                                                    // 293
  succeed('&am{{foo}}p;', ['&am', TemplateTag({stuff: 'foo'}), 'p;']);                                              // 294
                                                                                                                    // 295
  // can't start a mustache and not finish it                                                                       // 296
  fatal('{{foo');                                                                                                   // 297
  fatal('<a>{{</a>');                                                                                               // 298
                                                                                                                    // 299
  // no mustache allowed in tag name                                                                                // 300
  fatal('<{{a}}>');                                                                                                 // 301
  fatal('<{{a}}b>');                                                                                                // 302
  fatal('<a{{b}}>');                                                                                                // 303
                                                                                                                    // 304
  // single curly brace is no biggie                                                                                // 305
  succeed('a{b', 'a{b');                                                                                            // 306
  succeed('<br x={ />', BR({x:'{'}));                                                                               // 307
  succeed('<br x={foo} />', BR({x:'{foo}'}));                                                                       // 308
                                                                                                                    // 309
  succeed('<br {{x}}>', BR(Attrs(TemplateTag({stuff: 'x'}))));                                                      // 310
  succeed('<br {{x}} {{y}}>', BR(Attrs(TemplateTag({stuff: 'x'}),                                                   // 311
                                       TemplateTag({stuff: 'y'}))));                                                // 312
  succeed('<br {{x}} y>', BR(Attrs({y: ''}, TemplateTag({stuff: 'x'}))));                                           // 313
  fatal('<br {{x}}y>');                                                                                             // 314
  fatal('<br {{x}}=y>');                                                                                            // 315
  succeed('<br x={{y}} z>', BR({x: TemplateTag({stuff: 'y'}), z: ''}));                                             // 316
  succeed('<br x=y{{z}}w>', BR({x: ['y', TemplateTag({stuff: 'z'}), 'w']}));                                        // 317
  succeed('<br x="y{{z}}w">', BR({x: ['y', TemplateTag({stuff: 'z'}), 'w']}));                                      // 318
  succeed('<br x="y {{z}}{{w}} v">', BR({x: ['y ', TemplateTag({stuff: 'z'}),                                       // 319
                                             TemplateTag({stuff: 'w'}), ' v']}));                                   // 320
  // Slash is parsed as part of unquoted attribute!  This is consistent with                                        // 321
  // the HTML tokenization spec.  It seems odd for some inputs but is probably                                      // 322
  // for cases like `<a href=http://foo.com/>` or `<a href=/foo/>`.                                                 // 323
  succeed('<br x={{y}}/>', BR({x: [TemplateTag({stuff: 'y'}), '/']}));                                              // 324
  succeed('<br x={{z}}{{w}}>', BR({x: [TemplateTag({stuff: 'z'}),                                                   // 325
                                       TemplateTag({stuff: 'w'})]}));                                               // 326
  fatal('<br x="y"{{z}}>');                                                                                         // 327
                                                                                                                    // 328
  succeed('<br x=&amp;>', BR({x:CharRef({html: '&amp;', str: '&'})}));                                              // 329
                                                                                                                    // 330
                                                                                                                    // 331
  // check tokenization of stache tags with spaces                                                                  // 332
  succeed('<br {{x 1}}>', BR(Attrs(TemplateTag({stuff: 'x 1'}))));                                                  // 333
  succeed('<br {{x 1}} {{y 2}}>', BR(Attrs(TemplateTag({stuff: 'x 1'}),                                             // 334
                                           TemplateTag({stuff: 'y 2'}))));                                          // 335
  succeed('<br {{x 1}} y>', BR(Attrs({y:''}, TemplateTag({stuff: 'x 1'}))));                                        // 336
  fatal('<br {{x 1}}y>');                                                                                           // 337
  fatal('<br {{x 1}}=y>');                                                                                          // 338
  succeed('<br x={{y 2}} z>', BR({x: TemplateTag({stuff: 'y 2'}), z: ''}));                                         // 339
  succeed('<br x=y{{z 3}}w>', BR({x: ['y', TemplateTag({stuff: 'z 3'}), 'w']}));                                    // 340
  succeed('<br x="y{{z 3}}w">', BR({x: ['y', TemplateTag({stuff: 'z 3'}), 'w']}));                                  // 341
  succeed('<br x="y {{z 3}}{{w 4}} v">', BR({x: ['y ', TemplateTag({stuff: 'z 3'}),                                 // 342
                                                 TemplateTag({stuff: 'w 4'}), ' v']}));                             // 343
  succeed('<br x={{y 2}}/>', BR({x: [TemplateTag({stuff: 'y 2'}), '/']}));                                          // 344
  succeed('<br x={{z 3}}{{w 4}}>', BR({x: [TemplateTag({stuff: 'z 3'}),                                             // 345
                                           TemplateTag({stuff: 'w 4'})]}));                                         // 346
                                                                                                                    // 347
  succeed('<p></p>', P());                                                                                          // 348
                                                                                                                    // 349
  succeed('x{{foo}}{{bar}}y', ['x', TemplateTag({stuff: 'foo'}),                                                    // 350
                               TemplateTag({stuff: 'bar'}), 'y']);                                                  // 351
  succeed('x{{!foo}}{{!bar}}y', 'xy');                                                                              // 352
  succeed('x{{!foo}}{{bar}}y', ['x', TemplateTag({stuff: 'bar'}), 'y']);                                            // 353
  succeed('x{{foo}}{{!bar}}y', ['x', TemplateTag({stuff: 'foo'}), 'y']);                                            // 354
  succeed('<div>{{!foo}}{{!bar}}</div>', DIV());                                                                    // 355
  succeed('<div>{{!foo}}<br />{{!bar}}</div>', DIV(BR()));                                                          // 356
  succeed('<div> {{!foo}} {{!bar}} </div>', DIV("   "));                                                            // 357
  succeed('<div> {{!foo}} <br /> {{!bar}}</div>', DIV("  ", BR(), " "));                                            // 358
  succeed('{{! <div></div> }}', null);                                                                              // 359
  succeed('{{!<div></div>}}', null);                                                                                // 360
                                                                                                                    // 361
  succeed('', null);                                                                                                // 362
  succeed('{{!foo}}', null);                                                                                        // 363
                                                                                                                    // 364
  succeed('<textarea {{a}} x=1 {{b}}></textarea>',                                                                  // 365
          TEXTAREA(Attrs({x:"1"}, TemplateTag({stuff: 'a'}),                                                        // 366
                         TemplateTag({stuff: 'b'}))));                                                              // 367
                                                                                                                    // 368
});                                                                                                                 // 369
                                                                                                                    // 370
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
