(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                             //
// packages/github/template.github_configure.js                                                //
//                                                                                             //
/////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                               //
                                                                                               // 1
Template.__define__("configureLoginServiceDialogForGithub", (function() {                      // 2
  var view = this;                                                                             // 3
  return [ HTML.Raw("<p>\n    First, you'll need to get a Github Client ID. Follow these steps:\n  </p>\n  "), HTML.OL("\n    ", HTML.Raw('<li>\n      Visit <a href="https://github.com/settings/applications/new" target="blank">https://github.com/settings/applications/new</a>\n    </li>'), "\n    ", HTML.LI("\n      Set Homepage URL to: ", HTML.SPAN({
    "class": "url"                                                                             // 5
  }, Blaze.View(function() {                                                                   // 6
    return Spacebars.mustache(view.lookup("siteUrl"));                                         // 7
  })), "\n    "), "\n    ", HTML.LI("\n      Set Authorization callback URL to: ", HTML.SPAN({ // 8
    "class": "url"                                                                             // 9
  }, Blaze.View(function() {                                                                   // 10
    return Spacebars.mustache(view.lookup("siteUrl"));                                         // 11
  }), "_oauth/github?close"), "\n    "), "\n  ") ];                                            // 12
}));                                                                                           // 13
                                                                                               // 14
/////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                             //
// packages/github/github_configure.js                                                         //
//                                                                                             //
/////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                               //
Template.configureLoginServiceDialogForGithub.siteUrl = function () {                          // 1
  return Meteor.absoluteUrl();                                                                 // 2
};                                                                                             // 3
                                                                                               // 4
Template.configureLoginServiceDialogForGithub.fields = function () {                           // 5
  return [                                                                                     // 6
    {property: 'clientId', label: 'Client ID'},                                                // 7
    {property: 'secret', label: 'Client Secret'}                                               // 8
  ];                                                                                           // 9
};                                                                                             // 10
/////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                             //
// packages/github/github_client.js                                                            //
//                                                                                             //
/////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                               //
Github = {};                                                                                   // 1
                                                                                               // 2
// Request Github credentials for the user                                                     // 3
// @param options {optional}                                                                   // 4
// @param credentialRequestCompleteCallback {Function} Callback function to call on            // 5
//   completion. Takes one argument, credentialToken on success, or Error on                   // 6
//   error.                                                                                    // 7
Github.requestCredential = function (options, credentialRequestCompleteCallback) {             // 8
  // support both (options, callback) and (callback).                                          // 9
  if (!credentialRequestCompleteCallback && typeof options === 'function') {                   // 10
    credentialRequestCompleteCallback = options;                                               // 11
    options = {};                                                                              // 12
  }                                                                                            // 13
                                                                                               // 14
  var config = ServiceConfiguration.configurations.findOne({service: 'github'});               // 15
  if (!config) {                                                                               // 16
    credentialRequestCompleteCallback && credentialRequestCompleteCallback(                    // 17
      new ServiceConfiguration.ConfigError());                                                 // 18
    return;                                                                                    // 19
  }                                                                                            // 20
  var credentialToken = Random.secret();                                                       // 21
                                                                                               // 22
  var scope = (options && options.requestPermissions) || [];                                   // 23
  var flatScope = _.map(scope, encodeURIComponent).join('+');                                  // 24
                                                                                               // 25
  var loginUrl =                                                                               // 26
        'https://github.com/login/oauth/authorize' +                                           // 27
        '?client_id=' + config.clientId +                                                      // 28
        '&scope=' + flatScope +                                                                // 29
        '&redirect_uri=' + Meteor.absoluteUrl('_oauth/github?close') +                         // 30
        '&state=' + credentialToken;                                                           // 31
                                                                                               // 32
  OAuth.showPopup(                                                                             // 33
    loginUrl,                                                                                  // 34
    _.bind(credentialRequestCompleteCallback, null, credentialToken),                          // 35
    {width: 900, height: 450}                                                                  // 36
  );                                                                                           // 37
};                                                                                             // 38
                                                                                               // 39
/////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
