(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/d3/d3.v3.js                                                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
d3 = function() {                                                                                                      // 1
  var d3 = {                                                                                                           // 2
    version: "3.1.4"                                                                                                   // 3
  };                                                                                                                   // 4
  if (!Date.now) Date.now = function() {                                                                               // 5
    return +new Date();                                                                                                // 6
  };                                                                                                                   // 7
  var d3_document = document, d3_window = window;                                                                      // 8
  try {                                                                                                                // 9
    d3_document.createElement("div").style.setProperty("opacity", 0, "");                                              // 10
  } catch (error) {                                                                                                    // 11
    var d3_style_prototype = d3_window.CSSStyleDeclaration.prototype, d3_style_setProperty = d3_style_prototype.setProperty;
    d3_style_prototype.setProperty = function(name, value, priority) {                                                 // 13
      d3_style_setProperty.call(this, name, value + "", priority);                                                     // 14
    };                                                                                                                 // 15
  }                                                                                                                    // 16
  d3.ascending = function(a, b) {                                                                                      // 17
    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;                                                                  // 18
  };                                                                                                                   // 19
  d3.descending = function(a, b) {                                                                                     // 20
    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;                                                                  // 21
  };                                                                                                                   // 22
  d3.min = function(array, f) {                                                                                        // 23
    var i = -1, n = array.length, a, b;                                                                                // 24
    if (arguments.length === 1) {                                                                                      // 25
      while (++i < n && ((a = array[i]) == null || a != a)) a = undefined;                                             // 26
      while (++i < n) if ((b = array[i]) != null && a > b) a = b;                                                      // 27
    } else {                                                                                                           // 28
      while (++i < n && ((a = f.call(array, array[i], i)) == null || a != a)) a = undefined;                           // 29
      while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;                                    // 30
    }                                                                                                                  // 31
    return a;                                                                                                          // 32
  };                                                                                                                   // 33
  d3.max = function(array, f) {                                                                                        // 34
    var i = -1, n = array.length, a, b;                                                                                // 35
    if (arguments.length === 1) {                                                                                      // 36
      while (++i < n && ((a = array[i]) == null || a != a)) a = undefined;                                             // 37
      while (++i < n) if ((b = array[i]) != null && b > a) a = b;                                                      // 38
    } else {                                                                                                           // 39
      while (++i < n && ((a = f.call(array, array[i], i)) == null || a != a)) a = undefined;                           // 40
      while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;                                    // 41
    }                                                                                                                  // 42
    return a;                                                                                                          // 43
  };                                                                                                                   // 44
  d3.extent = function(array, f) {                                                                                     // 45
    var i = -1, n = array.length, a, b, c;                                                                             // 46
    if (arguments.length === 1) {                                                                                      // 47
      while (++i < n && ((a = c = array[i]) == null || a != a)) a = c = undefined;                                     // 48
      while (++i < n) if ((b = array[i]) != null) {                                                                    // 49
        if (a > b) a = b;                                                                                              // 50
        if (c < b) c = b;                                                                                              // 51
      }                                                                                                                // 52
    } else {                                                                                                           // 53
      while (++i < n && ((a = c = f.call(array, array[i], i)) == null || a != a)) a = undefined;                       // 54
      while (++i < n) if ((b = f.call(array, array[i], i)) != null) {                                                  // 55
        if (a > b) a = b;                                                                                              // 56
        if (c < b) c = b;                                                                                              // 57
      }                                                                                                                // 58
    }                                                                                                                  // 59
    return [ a, c ];                                                                                                   // 60
  };                                                                                                                   // 61
  d3.sum = function(array, f) {                                                                                        // 62
    var s = 0, n = array.length, a, i = -1;                                                                            // 63
    if (arguments.length === 1) {                                                                                      // 64
      while (++i < n) if (!isNaN(a = +array[i])) s += a;                                                               // 65
    } else {                                                                                                           // 66
      while (++i < n) if (!isNaN(a = +f.call(array, array[i], i))) s += a;                                             // 67
    }                                                                                                                  // 68
    return s;                                                                                                          // 69
  };                                                                                                                   // 70
  function d3_number(x) {                                                                                              // 71
    return x != null && !isNaN(x);                                                                                     // 72
  }                                                                                                                    // 73
  d3.mean = function(array, f) {                                                                                       // 74
    var n = array.length, a, m = 0, i = -1, j = 0;                                                                     // 75
    if (arguments.length === 1) {                                                                                      // 76
      while (++i < n) if (d3_number(a = array[i])) m += (a - m) / ++j;                                                 // 77
    } else {                                                                                                           // 78
      while (++i < n) if (d3_number(a = f.call(array, array[i], i))) m += (a - m) / ++j;                               // 79
    }                                                                                                                  // 80
    return j ? m : undefined;                                                                                          // 81
  };                                                                                                                   // 82
  d3.quantile = function(values, p) {                                                                                  // 83
    var H = (values.length - 1) * p + 1, h = Math.floor(H), v = +values[h - 1], e = H - h;                             // 84
    return e ? v + e * (values[h] - v) : v;                                                                            // 85
  };                                                                                                                   // 86
  d3.median = function(array, f) {                                                                                     // 87
    if (arguments.length > 1) array = array.map(f);                                                                    // 88
    array = array.filter(d3_number);                                                                                   // 89
    return array.length ? d3.quantile(array.sort(d3.ascending), .5) : undefined;                                       // 90
  };                                                                                                                   // 91
  d3.bisector = function(f) {                                                                                          // 92
    return {                                                                                                           // 93
      left: function(a, x, lo, hi) {                                                                                   // 94
        if (arguments.length < 3) lo = 0;                                                                              // 95
        if (arguments.length < 4) hi = a.length;                                                                       // 96
        while (lo < hi) {                                                                                              // 97
          var mid = lo + hi >>> 1;                                                                                     // 98
          if (f.call(a, a[mid], mid) < x) lo = mid + 1; else hi = mid;                                                 // 99
        }                                                                                                              // 100
        return lo;                                                                                                     // 101
      },                                                                                                               // 102
      right: function(a, x, lo, hi) {                                                                                  // 103
        if (arguments.length < 3) lo = 0;                                                                              // 104
        if (arguments.length < 4) hi = a.length;                                                                       // 105
        while (lo < hi) {                                                                                              // 106
          var mid = lo + hi >>> 1;                                                                                     // 107
          if (x < f.call(a, a[mid], mid)) hi = mid; else lo = mid + 1;                                                 // 108
        }                                                                                                              // 109
        return lo;                                                                                                     // 110
      }                                                                                                                // 111
    };                                                                                                                 // 112
  };                                                                                                                   // 113
  var d3_bisector = d3.bisector(function(d) {                                                                          // 114
    return d;                                                                                                          // 115
  });                                                                                                                  // 116
  d3.bisectLeft = d3_bisector.left;                                                                                    // 117
  d3.bisect = d3.bisectRight = d3_bisector.right;                                                                      // 118
  d3.shuffle = function(array) {                                                                                       // 119
    var m = array.length, t, i;                                                                                        // 120
    while (m) {                                                                                                        // 121
      i = Math.random() * m-- | 0;                                                                                     // 122
      t = array[m], array[m] = array[i], array[i] = t;                                                                 // 123
    }                                                                                                                  // 124
    return array;                                                                                                      // 125
  };                                                                                                                   // 126
  d3.permute = function(array, indexes) {                                                                              // 127
    var permutes = [], i = -1, n = indexes.length;                                                                     // 128
    while (++i < n) permutes[i] = array[indexes[i]];                                                                   // 129
    return permutes;                                                                                                   // 130
  };                                                                                                                   // 131
  d3.zip = function() {                                                                                                // 132
    if (!(n = arguments.length)) return [];                                                                            // 133
    for (var i = -1, m = d3.min(arguments, d3_zipLength), zips = new Array(m); ++i < m; ) {                            // 134
      for (var j = -1, n, zip = zips[i] = new Array(n); ++j < n; ) {                                                   // 135
        zip[j] = arguments[j][i];                                                                                      // 136
      }                                                                                                                // 137
    }                                                                                                                  // 138
    return zips;                                                                                                       // 139
  };                                                                                                                   // 140
  function d3_zipLength(d) {                                                                                           // 141
    return d.length;                                                                                                   // 142
  }                                                                                                                    // 143
  d3.transpose = function(matrix) {                                                                                    // 144
    return d3.zip.apply(d3, matrix);                                                                                   // 145
  };                                                                                                                   // 146
  d3.keys = function(map) {                                                                                            // 147
    var keys = [];                                                                                                     // 148
    for (var key in map) keys.push(key);                                                                               // 149
    return keys;                                                                                                       // 150
  };                                                                                                                   // 151
  d3.values = function(map) {                                                                                          // 152
    var values = [];                                                                                                   // 153
    for (var key in map) values.push(map[key]);                                                                        // 154
    return values;                                                                                                     // 155
  };                                                                                                                   // 156
  d3.entries = function(map) {                                                                                         // 157
    var entries = [];                                                                                                  // 158
    for (var key in map) entries.push({                                                                                // 159
      key: key,                                                                                                        // 160
      value: map[key]                                                                                                  // 161
    });                                                                                                                // 162
    return entries;                                                                                                    // 163
  };                                                                                                                   // 164
  d3.merge = function(arrays) {                                                                                        // 165
    return Array.prototype.concat.apply([], arrays);                                                                   // 166
  };                                                                                                                   // 167
  d3.range = function(start, stop, step) {                                                                             // 168
    if (arguments.length < 3) {                                                                                        // 169
      step = 1;                                                                                                        // 170
      if (arguments.length < 2) {                                                                                      // 171
        stop = start;                                                                                                  // 172
        start = 0;                                                                                                     // 173
      }                                                                                                                // 174
    }                                                                                                                  // 175
    if ((stop - start) / step === Infinity) throw new Error("infinite range");                                         // 176
    var range = [], k = d3_range_integerScale(Math.abs(step)), i = -1, j;                                              // 177
    start *= k, stop *= k, step *= k;                                                                                  // 178
    if (step < 0) while ((j = start + step * ++i) > stop) range.push(j / k); else while ((j = start + step * ++i) < stop) range.push(j / k);
    return range;                                                                                                      // 180
  };                                                                                                                   // 181
  function d3_range_integerScale(x) {                                                                                  // 182
    var k = 1;                                                                                                         // 183
    while (x * k % 1) k *= 10;                                                                                         // 184
    return k;                                                                                                          // 185
  }                                                                                                                    // 186
  function d3_class(ctor, properties) {                                                                                // 187
    try {                                                                                                              // 188
      for (var key in properties) {                                                                                    // 189
        Object.defineProperty(ctor.prototype, key, {                                                                   // 190
          value: properties[key],                                                                                      // 191
          enumerable: false                                                                                            // 192
        });                                                                                                            // 193
      }                                                                                                                // 194
    } catch (e) {                                                                                                      // 195
      ctor.prototype = properties;                                                                                     // 196
    }                                                                                                                  // 197
  }                                                                                                                    // 198
  d3.map = function(object) {                                                                                          // 199
    var map = new d3_Map();                                                                                            // 200
    for (var key in object) map.set(key, object[key]);                                                                 // 201
    return map;                                                                                                        // 202
  };                                                                                                                   // 203
  function d3_Map() {}                                                                                                 // 204
  d3_class(d3_Map, {                                                                                                   // 205
    has: function(key) {                                                                                               // 206
      return d3_map_prefix + key in this;                                                                              // 207
    },                                                                                                                 // 208
    get: function(key) {                                                                                               // 209
      return this[d3_map_prefix + key];                                                                                // 210
    },                                                                                                                 // 211
    set: function(key, value) {                                                                                        // 212
      return this[d3_map_prefix + key] = value;                                                                        // 213
    },                                                                                                                 // 214
    remove: function(key) {                                                                                            // 215
      key = d3_map_prefix + key;                                                                                       // 216
      return key in this && delete this[key];                                                                          // 217
    },                                                                                                                 // 218
    keys: function() {                                                                                                 // 219
      var keys = [];                                                                                                   // 220
      this.forEach(function(key) {                                                                                     // 221
        keys.push(key);                                                                                                // 222
      });                                                                                                              // 223
      return keys;                                                                                                     // 224
    },                                                                                                                 // 225
    values: function() {                                                                                               // 226
      var values = [];                                                                                                 // 227
      this.forEach(function(key, value) {                                                                              // 228
        values.push(value);                                                                                            // 229
      });                                                                                                              // 230
      return values;                                                                                                   // 231
    },                                                                                                                 // 232
    entries: function() {                                                                                              // 233
      var entries = [];                                                                                                // 234
      this.forEach(function(key, value) {                                                                              // 235
        entries.push({                                                                                                 // 236
          key: key,                                                                                                    // 237
          value: value                                                                                                 // 238
        });                                                                                                            // 239
      });                                                                                                              // 240
      return entries;                                                                                                  // 241
    },                                                                                                                 // 242
    forEach: function(f) {                                                                                             // 243
      for (var key in this) {                                                                                          // 244
        if (key.charCodeAt(0) === d3_map_prefixCode) {                                                                 // 245
          f.call(this, key.substring(1), this[key]);                                                                   // 246
        }                                                                                                              // 247
      }                                                                                                                // 248
    }                                                                                                                  // 249
  });                                                                                                                  // 250
  var d3_map_prefix = "\0", d3_map_prefixCode = d3_map_prefix.charCodeAt(0);                                           // 251
  d3.nest = function() {                                                                                               // 252
    var nest = {}, keys = [], sortKeys = [], sortValues, rollup;                                                       // 253
    function map(mapType, array, depth) {                                                                              // 254
      if (depth >= keys.length) return rollup ? rollup.call(nest, array) : sortValues ? array.sort(sortValues) : array;
      var i = -1, n = array.length, key = keys[depth++], keyValue, object, setter, valuesByKey = new d3_Map(), values; // 256
      while (++i < n) {                                                                                                // 257
        if (values = valuesByKey.get(keyValue = key(object = array[i]))) {                                             // 258
          values.push(object);                                                                                         // 259
        } else {                                                                                                       // 260
          valuesByKey.set(keyValue, [ object ]);                                                                       // 261
        }                                                                                                              // 262
      }                                                                                                                // 263
      if (mapType) {                                                                                                   // 264
        object = mapType();                                                                                            // 265
        setter = function(keyValue, values) {                                                                          // 266
          object.set(keyValue, map(mapType, values, depth));                                                           // 267
        };                                                                                                             // 268
      } else {                                                                                                         // 269
        object = {};                                                                                                   // 270
        setter = function(keyValue, values) {                                                                          // 271
          object[keyValue] = map(mapType, values, depth);                                                              // 272
        };                                                                                                             // 273
      }                                                                                                                // 274
      valuesByKey.forEach(setter);                                                                                     // 275
      return object;                                                                                                   // 276
    }                                                                                                                  // 277
    function entries(map, depth) {                                                                                     // 278
      if (depth >= keys.length) return map;                                                                            // 279
      var array = [], sortKey = sortKeys[depth++];                                                                     // 280
      map.forEach(function(key, keyMap) {                                                                              // 281
        array.push({                                                                                                   // 282
          key: key,                                                                                                    // 283
          values: entries(keyMap, depth)                                                                               // 284
        });                                                                                                            // 285
      });                                                                                                              // 286
      return sortKey ? array.sort(function(a, b) {                                                                     // 287
        return sortKey(a.key, b.key);                                                                                  // 288
      }) : array;                                                                                                      // 289
    }                                                                                                                  // 290
    nest.map = function(array, mapType) {                                                                              // 291
      return map(mapType, array, 0);                                                                                   // 292
    };                                                                                                                 // 293
    nest.entries = function(array) {                                                                                   // 294
      return entries(map(d3.map, array, 0), 0);                                                                        // 295
    };                                                                                                                 // 296
    nest.key = function(d) {                                                                                           // 297
      keys.push(d);                                                                                                    // 298
      return nest;                                                                                                     // 299
    };                                                                                                                 // 300
    nest.sortKeys = function(order) {                                                                                  // 301
      sortKeys[keys.length - 1] = order;                                                                               // 302
      return nest;                                                                                                     // 303
    };                                                                                                                 // 304
    nest.sortValues = function(order) {                                                                                // 305
      sortValues = order;                                                                                              // 306
      return nest;                                                                                                     // 307
    };                                                                                                                 // 308
    nest.rollup = function(f) {                                                                                        // 309
      rollup = f;                                                                                                      // 310
      return nest;                                                                                                     // 311
    };                                                                                                                 // 312
    return nest;                                                                                                       // 313
  };                                                                                                                   // 314
  d3.set = function(array) {                                                                                           // 315
    var set = new d3_Set();                                                                                            // 316
    if (array) for (var i = 0; i < array.length; i++) set.add(array[i]);                                               // 317
    return set;                                                                                                        // 318
  };                                                                                                                   // 319
  function d3_Set() {}                                                                                                 // 320
  d3_class(d3_Set, {                                                                                                   // 321
    has: function(value) {                                                                                             // 322
      return d3_map_prefix + value in this;                                                                            // 323
    },                                                                                                                 // 324
    add: function(value) {                                                                                             // 325
      this[d3_map_prefix + value] = true;                                                                              // 326
      return value;                                                                                                    // 327
    },                                                                                                                 // 328
    remove: function(value) {                                                                                          // 329
      value = d3_map_prefix + value;                                                                                   // 330
      return value in this && delete this[value];                                                                      // 331
    },                                                                                                                 // 332
    values: function() {                                                                                               // 333
      var values = [];                                                                                                 // 334
      this.forEach(function(value) {                                                                                   // 335
        values.push(value);                                                                                            // 336
      });                                                                                                              // 337
      return values;                                                                                                   // 338
    },                                                                                                                 // 339
    forEach: function(f) {                                                                                             // 340
      for (var value in this) {                                                                                        // 341
        if (value.charCodeAt(0) === d3_map_prefixCode) {                                                               // 342
          f.call(this, value.substring(1));                                                                            // 343
        }                                                                                                              // 344
      }                                                                                                                // 345
    }                                                                                                                  // 346
  });                                                                                                                  // 347
  d3.behavior = {};                                                                                                    // 348
  d3.rebind = function(target, source) {                                                                               // 349
    var i = 1, n = arguments.length, method;                                                                           // 350
    while (++i < n) target[method = arguments[i]] = d3_rebind(target, source, source[method]);                         // 351
    return target;                                                                                                     // 352
  };                                                                                                                   // 353
  function d3_rebind(target, source, method) {                                                                         // 354
    return function() {                                                                                                // 355
      var value = method.apply(source, arguments);                                                                     // 356
      return value === source ? target : value;                                                                        // 357
    };                                                                                                                 // 358
  }                                                                                                                    // 359
  d3.dispatch = function() {                                                                                           // 360
    var dispatch = new d3_dispatch(), i = -1, n = arguments.length;                                                    // 361
    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);                                              // 362
    return dispatch;                                                                                                   // 363
  };                                                                                                                   // 364
  function d3_dispatch() {}                                                                                            // 365
  d3_dispatch.prototype.on = function(type, listener) {                                                                // 366
    var i = type.indexOf("."), name = "";                                                                              // 367
    if (i >= 0) {                                                                                                      // 368
      name = type.substring(i + 1);                                                                                    // 369
      type = type.substring(0, i);                                                                                     // 370
    }                                                                                                                  // 371
    if (type) return arguments.length < 2 ? this[type].on(name) : this[type].on(name, listener);                       // 372
    if (arguments.length === 2) {                                                                                      // 373
      if (listener == null) for (type in this) {                                                                       // 374
        if (this.hasOwnProperty(type)) this[type].on(name, null);                                                      // 375
      }                                                                                                                // 376
      return this;                                                                                                     // 377
    }                                                                                                                  // 378
  };                                                                                                                   // 379
  function d3_dispatch_event(dispatch) {                                                                               // 380
    var listeners = [], listenerByName = new d3_Map();                                                                 // 381
    function event() {                                                                                                 // 382
      var z = listeners, i = -1, n = z.length, l;                                                                      // 383
      while (++i < n) if (l = z[i].on) l.apply(this, arguments);                                                       // 384
      return dispatch;                                                                                                 // 385
    }                                                                                                                  // 386
    event.on = function(name, listener) {                                                                              // 387
      var l = listenerByName.get(name), i;                                                                             // 388
      if (arguments.length < 2) return l && l.on;                                                                      // 389
      if (l) {                                                                                                         // 390
        l.on = null;                                                                                                   // 391
        listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));                       // 392
        listenerByName.remove(name);                                                                                   // 393
      }                                                                                                                // 394
      if (listener) listeners.push(listenerByName.set(name, {                                                          // 395
        on: listener                                                                                                   // 396
      }));                                                                                                             // 397
      return dispatch;                                                                                                 // 398
    };                                                                                                                 // 399
    return event;                                                                                                      // 400
  }                                                                                                                    // 401
  d3.event = null;                                                                                                     // 402
  function d3_eventCancel() {                                                                                          // 403
    d3.event.stopPropagation();                                                                                        // 404
    d3.event.preventDefault();                                                                                         // 405
  }                                                                                                                    // 406
  function d3_eventSource() {                                                                                          // 407
    var e = d3.event, s;                                                                                               // 408
    while (s = e.sourceEvent) e = s;                                                                                   // 409
    return e;                                                                                                          // 410
  }                                                                                                                    // 411
  function d3_eventDispatch(target) {                                                                                  // 412
    var dispatch = new d3_dispatch(), i = 0, n = arguments.length;                                                     // 413
    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);                                              // 414
    dispatch.of = function(thiz, argumentz) {                                                                          // 415
      return function(e1) {                                                                                            // 416
        try {                                                                                                          // 417
          var e0 = e1.sourceEvent = d3.event;                                                                          // 418
          e1.target = target;                                                                                          // 419
          d3.event = e1;                                                                                               // 420
          dispatch[e1.type].apply(thiz, argumentz);                                                                    // 421
        } finally {                                                                                                    // 422
          d3.event = e0;                                                                                               // 423
        }                                                                                                              // 424
      };                                                                                                               // 425
    };                                                                                                                 // 426
    return dispatch;                                                                                                   // 427
  }                                                                                                                    // 428
  d3.mouse = function(container) {                                                                                     // 429
    return d3_mousePoint(container, d3_eventSource());                                                                 // 430
  };                                                                                                                   // 431
  var d3_mouse_bug44083 = /WebKit/.test(d3_window.navigator.userAgent) ? -1 : 0;                                       // 432
  function d3_mousePoint(container, e) {                                                                               // 433
    var svg = container.ownerSVGElement || container;                                                                  // 434
    if (svg.createSVGPoint) {                                                                                          // 435
      var point = svg.createSVGPoint();                                                                                // 436
      if (d3_mouse_bug44083 < 0 && (d3_window.scrollX || d3_window.scrollY)) {                                         // 437
        svg = d3.select(d3_document.body).append("svg").style("position", "absolute").style("top", 0).style("left", 0);
        var ctm = svg[0][0].getScreenCTM();                                                                            // 439
        d3_mouse_bug44083 = !(ctm.f || ctm.e);                                                                         // 440
        svg.remove();                                                                                                  // 441
      }                                                                                                                // 442
      if (d3_mouse_bug44083) {                                                                                         // 443
        point.x = e.pageX;                                                                                             // 444
        point.y = e.pageY;                                                                                             // 445
      } else {                                                                                                         // 446
        point.x = e.clientX;                                                                                           // 447
        point.y = e.clientY;                                                                                           // 448
      }                                                                                                                // 449
      point = point.matrixTransform(container.getScreenCTM().inverse());                                               // 450
      return [ point.x, point.y ];                                                                                     // 451
    }                                                                                                                  // 452
    var rect = container.getBoundingClientRect();                                                                      // 453
    return [ e.clientX - rect.left - container.clientLeft, e.clientY - rect.top - container.clientTop ];               // 454
  }                                                                                                                    // 455
  var d3_array = d3_arraySlice;                                                                                        // 456
  function d3_arrayCopy(pseudoarray) {                                                                                 // 457
    var i = -1, n = pseudoarray.length, array = [];                                                                    // 458
    while (++i < n) array.push(pseudoarray[i]);                                                                        // 459
    return array;                                                                                                      // 460
  }                                                                                                                    // 461
  function d3_arraySlice(pseudoarray) {                                                                                // 462
    return Array.prototype.slice.call(pseudoarray);                                                                    // 463
  }                                                                                                                    // 464
  try {                                                                                                                // 465
    d3_array(d3_document.documentElement.childNodes)[0].nodeType;                                                      // 466
  } catch (e) {                                                                                                        // 467
    d3_array = d3_arrayCopy;                                                                                           // 468
  }                                                                                                                    // 469
  var d3_arraySubclass = [].__proto__ ? function(array, prototype) {                                                   // 470
    array.__proto__ = prototype;                                                                                       // 471
  } : function(array, prototype) {                                                                                     // 472
    for (var property in prototype) array[property] = prototype[property];                                             // 473
  };                                                                                                                   // 474
  d3.touches = function(container, touches) {                                                                          // 475
    if (arguments.length < 2) touches = d3_eventSource().touches;                                                      // 476
    return touches ? d3_array(touches).map(function(touch) {                                                           // 477
      var point = d3_mousePoint(container, touch);                                                                     // 478
      point.identifier = touch.identifier;                                                                             // 479
      return point;                                                                                                    // 480
    }) : [];                                                                                                           // 481
  };                                                                                                                   // 482
  d3.behavior.drag = function() {                                                                                      // 483
    var event = d3_eventDispatch(drag, "drag", "dragstart", "dragend"), origin = null;                                 // 484
    function drag() {                                                                                                  // 485
      this.on("mousedown.drag", mousedown).on("touchstart.drag", mousedown);                                           // 486
    }                                                                                                                  // 487
    function mousedown() {                                                                                             // 488
      var target = this, event_ = event.of(target, arguments), eventTarget = d3.event.target, touchId = d3.event.touches ? d3.event.changedTouches[0].identifier : null, offset, origin_ = point(), moved = 0;
      var w = d3.select(d3_window).on(touchId != null ? "touchmove.drag-" + touchId : "mousemove.drag", dragmove).on(touchId != null ? "touchend.drag-" + touchId : "mouseup.drag", dragend, true);
      if (origin) {                                                                                                    // 491
        offset = origin.apply(target, arguments);                                                                      // 492
        offset = [ offset.x - origin_[0], offset.y - origin_[1] ];                                                     // 493
      } else {                                                                                                         // 494
        offset = [ 0, 0 ];                                                                                             // 495
      }                                                                                                                // 496
      if (touchId == null) d3_eventCancel();                                                                           // 497
      event_({                                                                                                         // 498
        type: "dragstart"                                                                                              // 499
      });                                                                                                              // 500
      function point() {                                                                                               // 501
        var p = target.parentNode;                                                                                     // 502
        return touchId != null ? d3.touches(p).filter(function(p) {                                                    // 503
          return p.identifier === touchId;                                                                             // 504
        })[0] : d3.mouse(p);                                                                                           // 505
      }                                                                                                                // 506
      function dragmove() {                                                                                            // 507
        if (!target.parentNode) return dragend();                                                                      // 508
        var p = point(), dx = p[0] - origin_[0], dy = p[1] - origin_[1];                                               // 509
        moved |= dx | dy;                                                                                              // 510
        origin_ = p;                                                                                                   // 511
        d3_eventCancel();                                                                                              // 512
        event_({                                                                                                       // 513
          type: "drag",                                                                                                // 514
          x: p[0] + offset[0],                                                                                         // 515
          y: p[1] + offset[1],                                                                                         // 516
          dx: dx,                                                                                                      // 517
          dy: dy                                                                                                       // 518
        });                                                                                                            // 519
      }                                                                                                                // 520
      function dragend() {                                                                                             // 521
        event_({                                                                                                       // 522
          type: "dragend"                                                                                              // 523
        });                                                                                                            // 524
        if (moved) {                                                                                                   // 525
          d3_eventCancel();                                                                                            // 526
          if (d3.event.target === eventTarget) w.on("click.drag", click, true);                                        // 527
        }                                                                                                              // 528
        w.on(touchId != null ? "touchmove.drag-" + touchId : "mousemove.drag", null).on(touchId != null ? "touchend.drag-" + touchId : "mouseup.drag", null);
      }                                                                                                                // 530
      function click() {                                                                                               // 531
        d3_eventCancel();                                                                                              // 532
        w.on("click.drag", null);                                                                                      // 533
      }                                                                                                                // 534
    }                                                                                                                  // 535
    drag.origin = function(x) {                                                                                        // 536
      if (!arguments.length) return origin;                                                                            // 537
      origin = x;                                                                                                      // 538
      return drag;                                                                                                     // 539
    };                                                                                                                 // 540
    return d3.rebind(drag, event, "on");                                                                               // 541
  };                                                                                                                   // 542
  function d3_selection(groups) {                                                                                      // 543
    d3_arraySubclass(groups, d3_selectionPrototype);                                                                   // 544
    return groups;                                                                                                     // 545
  }                                                                                                                    // 546
  var d3_select = function(s, n) {                                                                                     // 547
    return n.querySelector(s);                                                                                         // 548
  }, d3_selectAll = function(s, n) {                                                                                   // 549
    return n.querySelectorAll(s);                                                                                      // 550
  }, d3_selectRoot = d3_document.documentElement, d3_selectMatcher = d3_selectRoot.matchesSelector || d3_selectRoot.webkitMatchesSelector || d3_selectRoot.mozMatchesSelector || d3_selectRoot.msMatchesSelector || d3_selectRoot.oMatchesSelector, d3_selectMatches = function(n, s) {
    return d3_selectMatcher.call(n, s);                                                                                // 552
  };                                                                                                                   // 553
  if (typeof Sizzle === "function") {                                                                                  // 554
    d3_select = function(s, n) {                                                                                       // 555
      return Sizzle(s, n)[0] || null;                                                                                  // 556
    };                                                                                                                 // 557
    d3_selectAll = function(s, n) {                                                                                    // 558
      return Sizzle.uniqueSort(Sizzle(s, n));                                                                          // 559
    };                                                                                                                 // 560
    d3_selectMatches = Sizzle.matchesSelector;                                                                         // 561
  }                                                                                                                    // 562
  var d3_selectionPrototype = [];                                                                                      // 563
  d3.selection = function() {                                                                                          // 564
    return d3_selectionRoot;                                                                                           // 565
  };                                                                                                                   // 566
  d3.selection.prototype = d3_selectionPrototype;                                                                      // 567
  d3_selectionPrototype.select = function(selector) {                                                                  // 568
    var subgroups = [], subgroup, subnode, group, node;                                                                // 569
    if (typeof selector !== "function") selector = d3_selection_selector(selector);                                    // 570
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 571
      subgroups.push(subgroup = []);                                                                                   // 572
      subgroup.parentNode = (group = this[j]).parentNode;                                                              // 573
      for (var i = -1, n = group.length; ++i < n; ) {                                                                  // 574
        if (node = group[i]) {                                                                                         // 575
          subgroup.push(subnode = selector.call(node, node.__data__, i));                                              // 576
          if (subnode && "__data__" in node) subnode.__data__ = node.__data__;                                         // 577
        } else {                                                                                                       // 578
          subgroup.push(null);                                                                                         // 579
        }                                                                                                              // 580
      }                                                                                                                // 581
    }                                                                                                                  // 582
    return d3_selection(subgroups);                                                                                    // 583
  };                                                                                                                   // 584
  function d3_selection_selector(selector) {                                                                           // 585
    return function() {                                                                                                // 586
      return d3_select(selector, this);                                                                                // 587
    };                                                                                                                 // 588
  }                                                                                                                    // 589
  d3_selectionPrototype.selectAll = function(selector) {                                                               // 590
    var subgroups = [], subgroup, node;                                                                                // 591
    if (typeof selector !== "function") selector = d3_selection_selectorAll(selector);                                 // 592
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 593
      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {                                                 // 594
        if (node = group[i]) {                                                                                         // 595
          subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i)));                                  // 596
          subgroup.parentNode = node;                                                                                  // 597
        }                                                                                                              // 598
      }                                                                                                                // 599
    }                                                                                                                  // 600
    return d3_selection(subgroups);                                                                                    // 601
  };                                                                                                                   // 602
  function d3_selection_selectorAll(selector) {                                                                        // 603
    return function() {                                                                                                // 604
      return d3_selectAll(selector, this);                                                                             // 605
    };                                                                                                                 // 606
  }                                                                                                                    // 607
  var d3_nsPrefix = {                                                                                                  // 608
    svg: "http://www.w3.org/2000/svg",                                                                                 // 609
    xhtml: "http://www.w3.org/1999/xhtml",                                                                             // 610
    xlink: "http://www.w3.org/1999/xlink",                                                                             // 611
    xml: "http://www.w3.org/XML/1998/namespace",                                                                       // 612
    xmlns: "http://www.w3.org/2000/xmlns/"                                                                             // 613
  };                                                                                                                   // 614
  d3.ns = {                                                                                                            // 615
    prefix: d3_nsPrefix,                                                                                               // 616
    qualify: function(name) {                                                                                          // 617
      var i = name.indexOf(":"), prefix = name;                                                                        // 618
      if (i >= 0) {                                                                                                    // 619
        prefix = name.substring(0, i);                                                                                 // 620
        name = name.substring(i + 1);                                                                                  // 621
      }                                                                                                                // 622
      return d3_nsPrefix.hasOwnProperty(prefix) ? {                                                                    // 623
        space: d3_nsPrefix[prefix],                                                                                    // 624
        local: name                                                                                                    // 625
      } : name;                                                                                                        // 626
    }                                                                                                                  // 627
  };                                                                                                                   // 628
  d3_selectionPrototype.attr = function(name, value) {                                                                 // 629
    if (arguments.length < 2) {                                                                                        // 630
      if (typeof name === "string") {                                                                                  // 631
        var node = this.node();                                                                                        // 632
        name = d3.ns.qualify(name);                                                                                    // 633
        return name.local ? node.getAttributeNS(name.space, name.local) : node.getAttribute(name);                     // 634
      }                                                                                                                // 635
      for (value in name) this.each(d3_selection_attr(value, name[value]));                                            // 636
      return this;                                                                                                     // 637
    }                                                                                                                  // 638
    return this.each(d3_selection_attr(name, value));                                                                  // 639
  };                                                                                                                   // 640
  function d3_selection_attr(name, value) {                                                                            // 641
    name = d3.ns.qualify(name);                                                                                        // 642
    function attrNull() {                                                                                              // 643
      this.removeAttribute(name);                                                                                      // 644
    }                                                                                                                  // 645
    function attrNullNS() {                                                                                            // 646
      this.removeAttributeNS(name.space, name.local);                                                                  // 647
    }                                                                                                                  // 648
    function attrConstant() {                                                                                          // 649
      this.setAttribute(name, value);                                                                                  // 650
    }                                                                                                                  // 651
    function attrConstantNS() {                                                                                        // 652
      this.setAttributeNS(name.space, name.local, value);                                                              // 653
    }                                                                                                                  // 654
    function attrFunction() {                                                                                          // 655
      var x = value.apply(this, arguments);                                                                            // 656
      if (x == null) this.removeAttribute(name); else this.setAttribute(name, x);                                      // 657
    }                                                                                                                  // 658
    function attrFunctionNS() {                                                                                        // 659
      var x = value.apply(this, arguments);                                                                            // 660
      if (x == null) this.removeAttributeNS(name.space, name.local); else this.setAttributeNS(name.space, name.local, x);
    }                                                                                                                  // 662
    return value == null ? name.local ? attrNullNS : attrNull : typeof value === "function" ? name.local ? attrFunctionNS : attrFunction : name.local ? attrConstantNS : attrConstant;
  }                                                                                                                    // 664
  function d3_collapse(s) {                                                                                            // 665
    return s.trim().replace(/\s+/g, " ");                                                                              // 666
  }                                                                                                                    // 667
  d3.requote = function(s) {                                                                                           // 668
    return s.replace(d3_requote_re, "\\$&");                                                                           // 669
  };                                                                                                                   // 670
  var d3_requote_re = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;                                                               // 671
  d3_selectionPrototype.classed = function(name, value) {                                                              // 672
    if (arguments.length < 2) {                                                                                        // 673
      if (typeof name === "string") {                                                                                  // 674
        var node = this.node(), n = (name = name.trim().split(/^|\s+/g)).length, i = -1;                               // 675
        if (value = node.classList) {                                                                                  // 676
          while (++i < n) if (!value.contains(name[i])) return false;                                                  // 677
        } else {                                                                                                       // 678
          value = node.getAttribute("class");                                                                          // 679
          while (++i < n) if (!d3_selection_classedRe(name[i]).test(value)) return false;                              // 680
        }                                                                                                              // 681
        return true;                                                                                                   // 682
      }                                                                                                                // 683
      for (value in name) this.each(d3_selection_classed(value, name[value]));                                         // 684
      return this;                                                                                                     // 685
    }                                                                                                                  // 686
    return this.each(d3_selection_classed(name, value));                                                               // 687
  };                                                                                                                   // 688
  function d3_selection_classedRe(name) {                                                                              // 689
    return new RegExp("(?:^|\\s+)" + d3.requote(name) + "(?:\\s+|$)", "g");                                            // 690
  }                                                                                                                    // 691
  function d3_selection_classed(name, value) {                                                                         // 692
    name = name.trim().split(/\s+/).map(d3_selection_classedName);                                                     // 693
    var n = name.length;                                                                                               // 694
    function classedConstant() {                                                                                       // 695
      var i = -1;                                                                                                      // 696
      while (++i < n) name[i](this, value);                                                                            // 697
    }                                                                                                                  // 698
    function classedFunction() {                                                                                       // 699
      var i = -1, x = value.apply(this, arguments);                                                                    // 700
      while (++i < n) name[i](this, x);                                                                                // 701
    }                                                                                                                  // 702
    return typeof value === "function" ? classedFunction : classedConstant;                                            // 703
  }                                                                                                                    // 704
  function d3_selection_classedName(name) {                                                                            // 705
    var re = d3_selection_classedRe(name);                                                                             // 706
    return function(node, value) {                                                                                     // 707
      if (c = node.classList) return value ? c.add(name) : c.remove(name);                                             // 708
      var c = node.getAttribute("class") || "";                                                                        // 709
      if (value) {                                                                                                     // 710
        re.lastIndex = 0;                                                                                              // 711
        if (!re.test(c)) node.setAttribute("class", d3_collapse(c + " " + name));                                      // 712
      } else {                                                                                                         // 713
        node.setAttribute("class", d3_collapse(c.replace(re, " ")));                                                   // 714
      }                                                                                                                // 715
    };                                                                                                                 // 716
  }                                                                                                                    // 717
  d3_selectionPrototype.style = function(name, value, priority) {                                                      // 718
    var n = arguments.length;                                                                                          // 719
    if (n < 3) {                                                                                                       // 720
      if (typeof name !== "string") {                                                                                  // 721
        if (n < 2) value = "";                                                                                         // 722
        for (priority in name) this.each(d3_selection_style(priority, name[priority], value));                         // 723
        return this;                                                                                                   // 724
      }                                                                                                                // 725
      if (n < 2) return d3_window.getComputedStyle(this.node(), null).getPropertyValue(name);                          // 726
      priority = "";                                                                                                   // 727
    }                                                                                                                  // 728
    return this.each(d3_selection_style(name, value, priority));                                                       // 729
  };                                                                                                                   // 730
  function d3_selection_style(name, value, priority) {                                                                 // 731
    function styleNull() {                                                                                             // 732
      this.style.removeProperty(name);                                                                                 // 733
    }                                                                                                                  // 734
    function styleConstant() {                                                                                         // 735
      this.style.setProperty(name, value, priority);                                                                   // 736
    }                                                                                                                  // 737
    function styleFunction() {                                                                                         // 738
      var x = value.apply(this, arguments);                                                                            // 739
      if (x == null) this.style.removeProperty(name); else this.style.setProperty(name, x, priority);                  // 740
    }                                                                                                                  // 741
    return value == null ? styleNull : typeof value === "function" ? styleFunction : styleConstant;                    // 742
  }                                                                                                                    // 743
  d3_selectionPrototype.property = function(name, value) {                                                             // 744
    if (arguments.length < 2) {                                                                                        // 745
      if (typeof name === "string") return this.node()[name];                                                          // 746
      for (value in name) this.each(d3_selection_property(value, name[value]));                                        // 747
      return this;                                                                                                     // 748
    }                                                                                                                  // 749
    return this.each(d3_selection_property(name, value));                                                              // 750
  };                                                                                                                   // 751
  function d3_selection_property(name, value) {                                                                        // 752
    function propertyNull() {                                                                                          // 753
      delete this[name];                                                                                               // 754
    }                                                                                                                  // 755
    function propertyConstant() {                                                                                      // 756
      this[name] = value;                                                                                              // 757
    }                                                                                                                  // 758
    function propertyFunction() {                                                                                      // 759
      var x = value.apply(this, arguments);                                                                            // 760
      if (x == null) delete this[name]; else this[name] = x;                                                           // 761
    }                                                                                                                  // 762
    return value == null ? propertyNull : typeof value === "function" ? propertyFunction : propertyConstant;           // 763
  }                                                                                                                    // 764
  d3_selectionPrototype.text = function(value) {                                                                       // 765
    return arguments.length ? this.each(typeof value === "function" ? function() {                                     // 766
      var v = value.apply(this, arguments);                                                                            // 767
      this.textContent = v == null ? "" : v;                                                                           // 768
    } : value == null ? function() {                                                                                   // 769
      this.textContent = "";                                                                                           // 770
    } : function() {                                                                                                   // 771
      this.textContent = value;                                                                                        // 772
    }) : this.node().textContent;                                                                                      // 773
  };                                                                                                                   // 774
  d3_selectionPrototype.html = function(value) {                                                                       // 775
    return arguments.length ? this.each(typeof value === "function" ? function() {                                     // 776
      var v = value.apply(this, arguments);                                                                            // 777
      this.innerHTML = v == null ? "" : v;                                                                             // 778
    } : value == null ? function() {                                                                                   // 779
      this.innerHTML = "";                                                                                             // 780
    } : function() {                                                                                                   // 781
      this.innerHTML = value;                                                                                          // 782
    }) : this.node().innerHTML;                                                                                        // 783
  };                                                                                                                   // 784
  d3_selectionPrototype.append = function(name) {                                                                      // 785
    name = d3.ns.qualify(name);                                                                                        // 786
    function append() {                                                                                                // 787
      return this.appendChild(d3_document.createElementNS(this.namespaceURI, name));                                   // 788
    }                                                                                                                  // 789
    function appendNS() {                                                                                              // 790
      return this.appendChild(d3_document.createElementNS(name.space, name.local));                                    // 791
    }                                                                                                                  // 792
    return this.select(name.local ? appendNS : append);                                                                // 793
  };                                                                                                                   // 794
  d3_selectionPrototype.insert = function(name, before) {                                                              // 795
    name = d3.ns.qualify(name);                                                                                        // 796
    if (typeof before !== "function") before = d3_selection_selector(before);                                          // 797
    function insert(d, i) {                                                                                            // 798
      return this.insertBefore(d3_document.createElementNS(this.namespaceURI, name), before.call(this, d, i));         // 799
    }                                                                                                                  // 800
    function insertNS(d, i) {                                                                                          // 801
      return this.insertBefore(d3_document.createElementNS(name.space, name.local), before.call(this, d, i));          // 802
    }                                                                                                                  // 803
    return this.select(name.local ? insertNS : insert);                                                                // 804
  };                                                                                                                   // 805
  d3_selectionPrototype.remove = function() {                                                                          // 806
    return this.each(function() {                                                                                      // 807
      var parent = this.parentNode;                                                                                    // 808
      if (parent) parent.removeChild(this);                                                                            // 809
    });                                                                                                                // 810
  };                                                                                                                   // 811
  d3_selectionPrototype.data = function(value, key) {                                                                  // 812
    var i = -1, n = this.length, group, node;                                                                          // 813
    if (!arguments.length) {                                                                                           // 814
      value = new Array(n = (group = this[0]).length);                                                                 // 815
      while (++i < n) {                                                                                                // 816
        if (node = group[i]) {                                                                                         // 817
          value[i] = node.__data__;                                                                                    // 818
        }                                                                                                              // 819
      }                                                                                                                // 820
      return value;                                                                                                    // 821
    }                                                                                                                  // 822
    function bind(group, groupData) {                                                                                  // 823
      var i, n = group.length, m = groupData.length, n0 = Math.min(n, m), updateNodes = new Array(m), enterNodes = new Array(m), exitNodes = new Array(n), node, nodeData;
      if (key) {                                                                                                       // 825
        var nodeByKeyValue = new d3_Map(), dataByKeyValue = new d3_Map(), keyValues = [], keyValue;                    // 826
        for (i = -1; ++i < n; ) {                                                                                      // 827
          keyValue = key.call(node = group[i], node.__data__, i);                                                      // 828
          if (nodeByKeyValue.has(keyValue)) {                                                                          // 829
            exitNodes[i] = node;                                                                                       // 830
          } else {                                                                                                     // 831
            nodeByKeyValue.set(keyValue, node);                                                                        // 832
          }                                                                                                            // 833
          keyValues.push(keyValue);                                                                                    // 834
        }                                                                                                              // 835
        for (i = -1; ++i < m; ) {                                                                                      // 836
          keyValue = key.call(groupData, nodeData = groupData[i], i);                                                  // 837
          if (node = nodeByKeyValue.get(keyValue)) {                                                                   // 838
            updateNodes[i] = node;                                                                                     // 839
            node.__data__ = nodeData;                                                                                  // 840
          } else if (!dataByKeyValue.has(keyValue)) {                                                                  // 841
            enterNodes[i] = d3_selection_dataNode(nodeData);                                                           // 842
          }                                                                                                            // 843
          dataByKeyValue.set(keyValue, nodeData);                                                                      // 844
          nodeByKeyValue.remove(keyValue);                                                                             // 845
        }                                                                                                              // 846
        for (i = -1; ++i < n; ) {                                                                                      // 847
          if (nodeByKeyValue.has(keyValues[i])) {                                                                      // 848
            exitNodes[i] = group[i];                                                                                   // 849
          }                                                                                                            // 850
        }                                                                                                              // 851
      } else {                                                                                                         // 852
        for (i = -1; ++i < n0; ) {                                                                                     // 853
          node = group[i];                                                                                             // 854
          nodeData = groupData[i];                                                                                     // 855
          if (node) {                                                                                                  // 856
            node.__data__ = nodeData;                                                                                  // 857
            updateNodes[i] = node;                                                                                     // 858
          } else {                                                                                                     // 859
            enterNodes[i] = d3_selection_dataNode(nodeData);                                                           // 860
          }                                                                                                            // 861
        }                                                                                                              // 862
        for (;i < m; ++i) {                                                                                            // 863
          enterNodes[i] = d3_selection_dataNode(groupData[i]);                                                         // 864
        }                                                                                                              // 865
        for (;i < n; ++i) {                                                                                            // 866
          exitNodes[i] = group[i];                                                                                     // 867
        }                                                                                                              // 868
      }                                                                                                                // 869
      enterNodes.update = updateNodes;                                                                                 // 870
      enterNodes.parentNode = updateNodes.parentNode = exitNodes.parentNode = group.parentNode;                        // 871
      enter.push(enterNodes);                                                                                          // 872
      update.push(updateNodes);                                                                                        // 873
      exit.push(exitNodes);                                                                                            // 874
    }                                                                                                                  // 875
    var enter = d3_selection_enter([]), update = d3_selection([]), exit = d3_selection([]);                            // 876
    if (typeof value === "function") {                                                                                 // 877
      while (++i < n) {                                                                                                // 878
        bind(group = this[i], value.call(group, group.parentNode.__data__, i));                                        // 879
      }                                                                                                                // 880
    } else {                                                                                                           // 881
      while (++i < n) {                                                                                                // 882
        bind(group = this[i], value);                                                                                  // 883
      }                                                                                                                // 884
    }                                                                                                                  // 885
    update.enter = function() {                                                                                        // 886
      return enter;                                                                                                    // 887
    };                                                                                                                 // 888
    update.exit = function() {                                                                                         // 889
      return exit;                                                                                                     // 890
    };                                                                                                                 // 891
    return update;                                                                                                     // 892
  };                                                                                                                   // 893
  function d3_selection_dataNode(data) {                                                                               // 894
    return {                                                                                                           // 895
      __data__: data                                                                                                   // 896
    };                                                                                                                 // 897
  }                                                                                                                    // 898
  d3_selectionPrototype.datum = function(value) {                                                                      // 899
    return arguments.length ? this.property("__data__", value) : this.property("__data__");                            // 900
  };                                                                                                                   // 901
  d3_selectionPrototype.filter = function(filter) {                                                                    // 902
    var subgroups = [], subgroup, group, node;                                                                         // 903
    if (typeof filter !== "function") filter = d3_selection_filter(filter);                                            // 904
    for (var j = 0, m = this.length; j < m; j++) {                                                                     // 905
      subgroups.push(subgroup = []);                                                                                   // 906
      subgroup.parentNode = (group = this[j]).parentNode;                                                              // 907
      for (var i = 0, n = group.length; i < n; i++) {                                                                  // 908
        if ((node = group[i]) && filter.call(node, node.__data__, i)) {                                                // 909
          subgroup.push(node);                                                                                         // 910
        }                                                                                                              // 911
      }                                                                                                                // 912
    }                                                                                                                  // 913
    return d3_selection(subgroups);                                                                                    // 914
  };                                                                                                                   // 915
  function d3_selection_filter(selector) {                                                                             // 916
    return function() {                                                                                                // 917
      return d3_selectMatches(this, selector);                                                                         // 918
    };                                                                                                                 // 919
  }                                                                                                                    // 920
  d3_selectionPrototype.order = function() {                                                                           // 921
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 922
      for (var group = this[j], i = group.length - 1, next = group[i], node; --i >= 0; ) {                             // 923
        if (node = group[i]) {                                                                                         // 924
          if (next && next !== node.nextSibling) next.parentNode.insertBefore(node, next);                             // 925
          next = node;                                                                                                 // 926
        }                                                                                                              // 927
      }                                                                                                                // 928
    }                                                                                                                  // 929
    return this;                                                                                                       // 930
  };                                                                                                                   // 931
  d3_selectionPrototype.sort = function(comparator) {                                                                  // 932
    comparator = d3_selection_sortComparator.apply(this, arguments);                                                   // 933
    for (var j = -1, m = this.length; ++j < m; ) this[j].sort(comparator);                                             // 934
    return this.order();                                                                                               // 935
  };                                                                                                                   // 936
  function d3_selection_sortComparator(comparator) {                                                                   // 937
    if (!arguments.length) comparator = d3.ascending;                                                                  // 938
    return function(a, b) {                                                                                            // 939
      return !a - !b || comparator(a.__data__, b.__data__);                                                            // 940
    };                                                                                                                 // 941
  }                                                                                                                    // 942
  function d3_noop() {}                                                                                                // 943
  d3_selectionPrototype.on = function(type, listener, capture) {                                                       // 944
    var n = arguments.length;                                                                                          // 945
    if (n < 3) {                                                                                                       // 946
      if (typeof type !== "string") {                                                                                  // 947
        if (n < 2) listener = false;                                                                                   // 948
        for (capture in type) this.each(d3_selection_on(capture, type[capture], listener));                            // 949
        return this;                                                                                                   // 950
      }                                                                                                                // 951
      if (n < 2) return (n = this.node()["__on" + type]) && n._;                                                       // 952
      capture = false;                                                                                                 // 953
    }                                                                                                                  // 954
    return this.each(d3_selection_on(type, listener, capture));                                                        // 955
  };                                                                                                                   // 956
  function d3_selection_on(type, listener, capture) {                                                                  // 957
    var name = "__on" + type, i = type.indexOf("."), wrap = d3_selection_onListener;                                   // 958
    if (i > 0) type = type.substring(0, i);                                                                            // 959
    var filter = d3_selection_onFilters.get(type);                                                                     // 960
    if (filter) type = filter, wrap = d3_selection_onFilter;                                                           // 961
    function onRemove() {                                                                                              // 962
      var l = this[name];                                                                                              // 963
      if (l) {                                                                                                         // 964
        this.removeEventListener(type, l, l.$);                                                                        // 965
        delete this[name];                                                                                             // 966
      }                                                                                                                // 967
    }                                                                                                                  // 968
    function onAdd() {                                                                                                 // 969
      var l = wrap(listener, d3_array(arguments));                                                                     // 970
      onRemove.call(this);                                                                                             // 971
      this.addEventListener(type, this[name] = l, l.$ = capture);                                                      // 972
      l._ = listener;                                                                                                  // 973
    }                                                                                                                  // 974
    function removeAll() {                                                                                             // 975
      var re = new RegExp("^__on([^.]+)" + d3.requote(type) + "$"), match;                                             // 976
      for (var name in this) {                                                                                         // 977
        if (match = name.match(re)) {                                                                                  // 978
          var l = this[name];                                                                                          // 979
          this.removeEventListener(match[1], l, l.$);                                                                  // 980
          delete this[name];                                                                                           // 981
        }                                                                                                              // 982
      }                                                                                                                // 983
    }                                                                                                                  // 984
    return i ? listener ? onAdd : onRemove : listener ? d3_noop : removeAll;                                           // 985
  }                                                                                                                    // 986
  var d3_selection_onFilters = d3.map({                                                                                // 987
    mouseenter: "mouseover",                                                                                           // 988
    mouseleave: "mouseout"                                                                                             // 989
  });                                                                                                                  // 990
  d3_selection_onFilters.forEach(function(k) {                                                                         // 991
    if ("on" + k in d3_document) d3_selection_onFilters.remove(k);                                                     // 992
  });                                                                                                                  // 993
  function d3_selection_onListener(listener, argumentz) {                                                              // 994
    return function(e) {                                                                                               // 995
      var o = d3.event;                                                                                                // 996
      d3.event = e;                                                                                                    // 997
      argumentz[0] = this.__data__;                                                                                    // 998
      try {                                                                                                            // 999
        listener.apply(this, argumentz);                                                                               // 1000
      } finally {                                                                                                      // 1001
        d3.event = o;                                                                                                  // 1002
      }                                                                                                                // 1003
    };                                                                                                                 // 1004
  }                                                                                                                    // 1005
  function d3_selection_onFilter(listener, argumentz) {                                                                // 1006
    var l = d3_selection_onListener(listener, argumentz);                                                              // 1007
    return function(e) {                                                                                               // 1008
      var target = this, related = e.relatedTarget;                                                                    // 1009
      if (!related || related !== target && !(related.compareDocumentPosition(target) & 8)) {                          // 1010
        l.call(target, e);                                                                                             // 1011
      }                                                                                                                // 1012
    };                                                                                                                 // 1013
  }                                                                                                                    // 1014
  d3_selectionPrototype.each = function(callback) {                                                                    // 1015
    return d3_selection_each(this, function(node, i, j) {                                                              // 1016
      callback.call(node, node.__data__, i, j);                                                                        // 1017
    });                                                                                                                // 1018
  };                                                                                                                   // 1019
  function d3_selection_each(groups, callback) {                                                                       // 1020
    for (var j = 0, m = groups.length; j < m; j++) {                                                                   // 1021
      for (var group = groups[j], i = 0, n = group.length, node; i < n; i++) {                                         // 1022
        if (node = group[i]) callback(node, i, j);                                                                     // 1023
      }                                                                                                                // 1024
    }                                                                                                                  // 1025
    return groups;                                                                                                     // 1026
  }                                                                                                                    // 1027
  d3_selectionPrototype.call = function(callback) {                                                                    // 1028
    var args = d3_array(arguments);                                                                                    // 1029
    callback.apply(args[0] = this, args);                                                                              // 1030
    return this;                                                                                                       // 1031
  };                                                                                                                   // 1032
  d3_selectionPrototype.empty = function() {                                                                           // 1033
    return !this.node();                                                                                               // 1034
  };                                                                                                                   // 1035
  d3_selectionPrototype.node = function() {                                                                            // 1036
    for (var j = 0, m = this.length; j < m; j++) {                                                                     // 1037
      for (var group = this[j], i = 0, n = group.length; i < n; i++) {                                                 // 1038
        var node = group[i];                                                                                           // 1039
        if (node) return node;                                                                                         // 1040
      }                                                                                                                // 1041
    }                                                                                                                  // 1042
    return null;                                                                                                       // 1043
  };                                                                                                                   // 1044
  function d3_selection_enter(selection) {                                                                             // 1045
    d3_arraySubclass(selection, d3_selection_enterPrototype);                                                          // 1046
    return selection;                                                                                                  // 1047
  }                                                                                                                    // 1048
  var d3_selection_enterPrototype = [];                                                                                // 1049
  d3.selection.enter = d3_selection_enter;                                                                             // 1050
  d3.selection.enter.prototype = d3_selection_enterPrototype;                                                          // 1051
  d3_selection_enterPrototype.append = d3_selectionPrototype.append;                                                   // 1052
  d3_selection_enterPrototype.insert = d3_selectionPrototype.insert;                                                   // 1053
  d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;                                                     // 1054
  d3_selection_enterPrototype.node = d3_selectionPrototype.node;                                                       // 1055
  d3_selection_enterPrototype.select = function(selector) {                                                            // 1056
    var subgroups = [], subgroup, subnode, upgroup, group, node;                                                       // 1057
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 1058
      upgroup = (group = this[j]).update;                                                                              // 1059
      subgroups.push(subgroup = []);                                                                                   // 1060
      subgroup.parentNode = group.parentNode;                                                                          // 1061
      for (var i = -1, n = group.length; ++i < n; ) {                                                                  // 1062
        if (node = group[i]) {                                                                                         // 1063
          subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i));                     // 1064
          subnode.__data__ = node.__data__;                                                                            // 1065
        } else {                                                                                                       // 1066
          subgroup.push(null);                                                                                         // 1067
        }                                                                                                              // 1068
      }                                                                                                                // 1069
    }                                                                                                                  // 1070
    return d3_selection(subgroups);                                                                                    // 1071
  };                                                                                                                   // 1072
  d3_selectionPrototype.transition = function() {                                                                      // 1073
    var id = d3_transitionInheritId || ++d3_transitionId, subgroups = [], subgroup, node, transition = Object.create(d3_transitionInherit);
    transition.time = Date.now();                                                                                      // 1075
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 1076
      subgroups.push(subgroup = []);                                                                                   // 1077
      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {                                                 // 1078
        if (node = group[i]) d3_transitionNode(node, i, id, transition);                                               // 1079
        subgroup.push(node);                                                                                           // 1080
      }                                                                                                                // 1081
    }                                                                                                                  // 1082
    return d3_transition(subgroups, id);                                                                               // 1083
  };                                                                                                                   // 1084
  var d3_selectionRoot = d3_selection([ [ d3_document ] ]);                                                            // 1085
  d3_selectionRoot[0].parentNode = d3_selectRoot;                                                                      // 1086
  d3.select = function(selector) {                                                                                     // 1087
    return typeof selector === "string" ? d3_selectionRoot.select(selector) : d3_selection([ [ selector ] ]);          // 1088
  };                                                                                                                   // 1089
  d3.selectAll = function(selector) {                                                                                  // 1090
    return typeof selector === "string" ? d3_selectionRoot.selectAll(selector) : d3_selection([ d3_array(selector) ]); // 1091
  };                                                                                                                   // 1092
  d3.behavior.zoom = function() {                                                                                      // 1093
    var translate = [ 0, 0 ], translate0, scale = 1, scale0, scaleExtent = d3_behavior_zoomInfinity, event = d3_eventDispatch(zoom, "zoom"), x0, x1, y0, y1, touchtime;
    function zoom() {                                                                                                  // 1095
      this.on("mousedown.zoom", mousedown).on("mousemove.zoom", mousemove).on(d3_behavior_zoomWheel + ".zoom", mousewheel).on("dblclick.zoom", dblclick).on("touchstart.zoom", touchstart).on("touchmove.zoom", touchmove).on("touchend.zoom", touchstart);
    }                                                                                                                  // 1097
    zoom.translate = function(x) {                                                                                     // 1098
      if (!arguments.length) return translate;                                                                         // 1099
      translate = x.map(Number);                                                                                       // 1100
      rescale();                                                                                                       // 1101
      return zoom;                                                                                                     // 1102
    };                                                                                                                 // 1103
    zoom.scale = function(x) {                                                                                         // 1104
      if (!arguments.length) return scale;                                                                             // 1105
      scale = +x;                                                                                                      // 1106
      rescale();                                                                                                       // 1107
      return zoom;                                                                                                     // 1108
    };                                                                                                                 // 1109
    zoom.scaleExtent = function(x) {                                                                                   // 1110
      if (!arguments.length) return scaleExtent;                                                                       // 1111
      scaleExtent = x == null ? d3_behavior_zoomInfinity : x.map(Number);                                              // 1112
      return zoom;                                                                                                     // 1113
    };                                                                                                                 // 1114
    zoom.x = function(z) {                                                                                             // 1115
      if (!arguments.length) return x1;                                                                                // 1116
      x1 = z;                                                                                                          // 1117
      x0 = z.copy();                                                                                                   // 1118
      translate = [ 0, 0 ];                                                                                            // 1119
      scale = 1;                                                                                                       // 1120
      return zoom;                                                                                                     // 1121
    };                                                                                                                 // 1122
    zoom.y = function(z) {                                                                                             // 1123
      if (!arguments.length) return y1;                                                                                // 1124
      y1 = z;                                                                                                          // 1125
      y0 = z.copy();                                                                                                   // 1126
      translate = [ 0, 0 ];                                                                                            // 1127
      scale = 1;                                                                                                       // 1128
      return zoom;                                                                                                     // 1129
    };                                                                                                                 // 1130
    function location(p) {                                                                                             // 1131
      return [ (p[0] - translate[0]) / scale, (p[1] - translate[1]) / scale ];                                         // 1132
    }                                                                                                                  // 1133
    function point(l) {                                                                                                // 1134
      return [ l[0] * scale + translate[0], l[1] * scale + translate[1] ];                                             // 1135
    }                                                                                                                  // 1136
    function scaleTo(s) {                                                                                              // 1137
      scale = Math.max(scaleExtent[0], Math.min(scaleExtent[1], s));                                                   // 1138
    }                                                                                                                  // 1139
    function translateTo(p, l) {                                                                                       // 1140
      l = point(l);                                                                                                    // 1141
      translate[0] += p[0] - l[0];                                                                                     // 1142
      translate[1] += p[1] - l[1];                                                                                     // 1143
    }                                                                                                                  // 1144
    function rescale() {                                                                                               // 1145
      if (x1) x1.domain(x0.range().map(function(x) {                                                                   // 1146
        return (x - translate[0]) / scale;                                                                             // 1147
      }).map(x0.invert));                                                                                              // 1148
      if (y1) y1.domain(y0.range().map(function(y) {                                                                   // 1149
        return (y - translate[1]) / scale;                                                                             // 1150
      }).map(y0.invert));                                                                                              // 1151
    }                                                                                                                  // 1152
    function dispatch(event) {                                                                                         // 1153
      rescale();                                                                                                       // 1154
      d3.event.preventDefault();                                                                                       // 1155
      event({                                                                                                          // 1156
        type: "zoom",                                                                                                  // 1157
        scale: scale,                                                                                                  // 1158
        translate: translate                                                                                           // 1159
      });                                                                                                              // 1160
    }                                                                                                                  // 1161
    function mousedown() {                                                                                             // 1162
      var target = this, event_ = event.of(target, arguments), eventTarget = d3.event.target, moved = 0, w = d3.select(d3_window).on("mousemove.zoom", mousemove).on("mouseup.zoom", mouseup), l = location(d3.mouse(target));
      d3_window.focus();                                                                                               // 1164
      d3_eventCancel();                                                                                                // 1165
      function mousemove() {                                                                                           // 1166
        moved = 1;                                                                                                     // 1167
        translateTo(d3.mouse(target), l);                                                                              // 1168
        dispatch(event_);                                                                                              // 1169
      }                                                                                                                // 1170
      function mouseup() {                                                                                             // 1171
        if (moved) d3_eventCancel();                                                                                   // 1172
        w.on("mousemove.zoom", null).on("mouseup.zoom", null);                                                         // 1173
        if (moved && d3.event.target === eventTarget) w.on("click.zoom", click, true);                                 // 1174
      }                                                                                                                // 1175
      function click() {                                                                                               // 1176
        d3_eventCancel();                                                                                              // 1177
        w.on("click.zoom", null);                                                                                      // 1178
      }                                                                                                                // 1179
    }                                                                                                                  // 1180
    function mousewheel() {                                                                                            // 1181
      if (!translate0) translate0 = location(d3.mouse(this));                                                          // 1182
      scaleTo(Math.pow(2, d3_behavior_zoomDelta() * .002) * scale);                                                    // 1183
      translateTo(d3.mouse(this), translate0);                                                                         // 1184
      dispatch(event.of(this, arguments));                                                                             // 1185
    }                                                                                                                  // 1186
    function mousemove() {                                                                                             // 1187
      translate0 = null;                                                                                               // 1188
    }                                                                                                                  // 1189
    function dblclick() {                                                                                              // 1190
      var p = d3.mouse(this), l = location(p), k = Math.log(scale) / Math.LN2;                                         // 1191
      scaleTo(Math.pow(2, d3.event.shiftKey ? Math.ceil(k) - 1 : Math.floor(k) + 1));                                  // 1192
      translateTo(p, l);                                                                                               // 1193
      dispatch(event.of(this, arguments));                                                                             // 1194
    }                                                                                                                  // 1195
    function touchstart() {                                                                                            // 1196
      var touches = d3.touches(this), now = Date.now();                                                                // 1197
      scale0 = scale;                                                                                                  // 1198
      translate0 = {};                                                                                                 // 1199
      touches.forEach(function(t) {                                                                                    // 1200
        translate0[t.identifier] = location(t);                                                                        // 1201
      });                                                                                                              // 1202
      d3_eventCancel();                                                                                                // 1203
      if (touches.length === 1) {                                                                                      // 1204
        if (now - touchtime < 500) {                                                                                   // 1205
          var p = touches[0], l = location(touches[0]);                                                                // 1206
          scaleTo(scale * 2);                                                                                          // 1207
          translateTo(p, l);                                                                                           // 1208
          dispatch(event.of(this, arguments));                                                                         // 1209
        }                                                                                                              // 1210
        touchtime = now;                                                                                               // 1211
      }                                                                                                                // 1212
    }                                                                                                                  // 1213
    function touchmove() {                                                                                             // 1214
      var touches = d3.touches(this), p0 = touches[0], l0 = translate0[p0.identifier];                                 // 1215
      if (p1 = touches[1]) {                                                                                           // 1216
        var p1, l1 = translate0[p1.identifier];                                                                        // 1217
        p0 = [ (p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2 ];                                                             // 1218
        l0 = [ (l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2 ];                                                             // 1219
        scaleTo(d3.event.scale * scale0);                                                                              // 1220
      }                                                                                                                // 1221
      translateTo(p0, l0);                                                                                             // 1222
      touchtime = null;                                                                                                // 1223
      dispatch(event.of(this, arguments));                                                                             // 1224
    }                                                                                                                  // 1225
    return d3.rebind(zoom, event, "on");                                                                               // 1226
  };                                                                                                                   // 1227
  var d3_behavior_zoomInfinity = [ 0, Infinity ];                                                                      // 1228
  var d3_behavior_zoomDelta, d3_behavior_zoomWheel = "onwheel" in d3_document ? (d3_behavior_zoomDelta = function() {  // 1229
    return -d3.event.deltaY * (d3.event.deltaMode ? 120 : 1);                                                          // 1230
  }, "wheel") : "onmousewheel" in d3_document ? (d3_behavior_zoomDelta = function() {                                  // 1231
    return d3.event.wheelDelta;                                                                                        // 1232
  }, "mousewheel") : (d3_behavior_zoomDelta = function() {                                                             // 1233
    return -d3.event.detail;                                                                                           // 1234
  }, "MozMousePixelScroll");                                                                                           // 1235
  function d3_Color() {}                                                                                               // 1236
  d3_Color.prototype.toString = function() {                                                                           // 1237
    return this.rgb() + "";                                                                                            // 1238
  };                                                                                                                   // 1239
  d3.hsl = function(h, s, l) {                                                                                         // 1240
    return arguments.length === 1 ? h instanceof d3_Hsl ? d3_hsl(h.h, h.s, h.l) : d3_rgb_parse("" + h, d3_rgb_hsl, d3_hsl) : d3_hsl(+h, +s, +l);
  };                                                                                                                   // 1242
  function d3_hsl(h, s, l) {                                                                                           // 1243
    return new d3_Hsl(h, s, l);                                                                                        // 1244
  }                                                                                                                    // 1245
  function d3_Hsl(h, s, l) {                                                                                           // 1246
    this.h = h;                                                                                                        // 1247
    this.s = s;                                                                                                        // 1248
    this.l = l;                                                                                                        // 1249
  }                                                                                                                    // 1250
  var d3_hslPrototype = d3_Hsl.prototype = new d3_Color();                                                             // 1251
  d3_hslPrototype.brighter = function(k) {                                                                             // 1252
    k = Math.pow(.7, arguments.length ? k : 1);                                                                        // 1253
    return d3_hsl(this.h, this.s, this.l / k);                                                                         // 1254
  };                                                                                                                   // 1255
  d3_hslPrototype.darker = function(k) {                                                                               // 1256
    k = Math.pow(.7, arguments.length ? k : 1);                                                                        // 1257
    return d3_hsl(this.h, this.s, k * this.l);                                                                         // 1258
  };                                                                                                                   // 1259
  d3_hslPrototype.rgb = function() {                                                                                   // 1260
    return d3_hsl_rgb(this.h, this.s, this.l);                                                                         // 1261
  };                                                                                                                   // 1262
  function d3_hsl_rgb(h, s, l) {                                                                                       // 1263
    var m1, m2;                                                                                                        // 1264
    h = h % 360;                                                                                                       // 1265
    if (h < 0) h += 360;                                                                                               // 1266
    s = s < 0 ? 0 : s > 1 ? 1 : s;                                                                                     // 1267
    l = l < 0 ? 0 : l > 1 ? 1 : l;                                                                                     // 1268
    m2 = l <= .5 ? l * (1 + s) : l + s - l * s;                                                                        // 1269
    m1 = 2 * l - m2;                                                                                                   // 1270
    function v(h) {                                                                                                    // 1271
      if (h > 360) h -= 360; else if (h < 0) h += 360;                                                                 // 1272
      if (h < 60) return m1 + (m2 - m1) * h / 60;                                                                      // 1273
      if (h < 180) return m2;                                                                                          // 1274
      if (h < 240) return m1 + (m2 - m1) * (240 - h) / 60;                                                             // 1275
      return m1;                                                                                                       // 1276
    }                                                                                                                  // 1277
    function vv(h) {                                                                                                   // 1278
      return Math.round(v(h) * 255);                                                                                   // 1279
    }                                                                                                                  // 1280
    return d3_rgb(vv(h + 120), vv(h), vv(h - 120));                                                                    // 1281
  }                                                                                                                    // 1282
  var π = Math.PI, ε = 1e-6, d3_radians = π / 180, d3_degrees = 180 / π;                                               // 1283
  function d3_sgn(x) {                                                                                                 // 1284
    return x > 0 ? 1 : x < 0 ? -1 : 0;                                                                                 // 1285
  }                                                                                                                    // 1286
  function d3_acos(x) {                                                                                                // 1287
    return Math.acos(Math.max(-1, Math.min(1, x)));                                                                    // 1288
  }                                                                                                                    // 1289
  function d3_asin(x) {                                                                                                // 1290
    return x > 1 ? π / 2 : x < -1 ? -π / 2 : Math.asin(x);                                                             // 1291
  }                                                                                                                    // 1292
  function d3_sinh(x) {                                                                                                // 1293
    return (Math.exp(x) - Math.exp(-x)) / 2;                                                                           // 1294
  }                                                                                                                    // 1295
  function d3_cosh(x) {                                                                                                // 1296
    return (Math.exp(x) + Math.exp(-x)) / 2;                                                                           // 1297
  }                                                                                                                    // 1298
  function d3_haversin(x) {                                                                                            // 1299
    return (x = Math.sin(x / 2)) * x;                                                                                  // 1300
  }                                                                                                                    // 1301
  d3.hcl = function(h, c, l) {                                                                                         // 1302
    return arguments.length === 1 ? h instanceof d3_Hcl ? d3_hcl(h.h, h.c, h.l) : h instanceof d3_Lab ? d3_lab_hcl(h.l, h.a, h.b) : d3_lab_hcl((h = d3_rgb_lab((h = d3.rgb(h)).r, h.g, h.b)).l, h.a, h.b) : d3_hcl(+h, +c, +l);
  };                                                                                                                   // 1304
  function d3_hcl(h, c, l) {                                                                                           // 1305
    return new d3_Hcl(h, c, l);                                                                                        // 1306
  }                                                                                                                    // 1307
  function d3_Hcl(h, c, l) {                                                                                           // 1308
    this.h = h;                                                                                                        // 1309
    this.c = c;                                                                                                        // 1310
    this.l = l;                                                                                                        // 1311
  }                                                                                                                    // 1312
  var d3_hclPrototype = d3_Hcl.prototype = new d3_Color();                                                             // 1313
  d3_hclPrototype.brighter = function(k) {                                                                             // 1314
    return d3_hcl(this.h, this.c, Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)));                      // 1315
  };                                                                                                                   // 1316
  d3_hclPrototype.darker = function(k) {                                                                               // 1317
    return d3_hcl(this.h, this.c, Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)));                        // 1318
  };                                                                                                                   // 1319
  d3_hclPrototype.rgb = function() {                                                                                   // 1320
    return d3_hcl_lab(this.h, this.c, this.l).rgb();                                                                   // 1321
  };                                                                                                                   // 1322
  function d3_hcl_lab(h, c, l) {                                                                                       // 1323
    return d3_lab(l, Math.cos(h *= d3_radians) * c, Math.sin(h) * c);                                                  // 1324
  }                                                                                                                    // 1325
  d3.lab = function(l, a, b) {                                                                                         // 1326
    return arguments.length === 1 ? l instanceof d3_Lab ? d3_lab(l.l, l.a, l.b) : l instanceof d3_Hcl ? d3_hcl_lab(l.l, l.c, l.h) : d3_rgb_lab((l = d3.rgb(l)).r, l.g, l.b) : d3_lab(+l, +a, +b);
  };                                                                                                                   // 1328
  function d3_lab(l, a, b) {                                                                                           // 1329
    return new d3_Lab(l, a, b);                                                                                        // 1330
  }                                                                                                                    // 1331
  function d3_Lab(l, a, b) {                                                                                           // 1332
    this.l = l;                                                                                                        // 1333
    this.a = a;                                                                                                        // 1334
    this.b = b;                                                                                                        // 1335
  }                                                                                                                    // 1336
  var d3_lab_K = 18;                                                                                                   // 1337
  var d3_lab_X = .95047, d3_lab_Y = 1, d3_lab_Z = 1.08883;                                                             // 1338
  var d3_labPrototype = d3_Lab.prototype = new d3_Color();                                                             // 1339
  d3_labPrototype.brighter = function(k) {                                                                             // 1340
    return d3_lab(Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);                      // 1341
  };                                                                                                                   // 1342
  d3_labPrototype.darker = function(k) {                                                                               // 1343
    return d3_lab(Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);                        // 1344
  };                                                                                                                   // 1345
  d3_labPrototype.rgb = function() {                                                                                   // 1346
    return d3_lab_rgb(this.l, this.a, this.b);                                                                         // 1347
  };                                                                                                                   // 1348
  function d3_lab_rgb(l, a, b) {                                                                                       // 1349
    var y = (l + 16) / 116, x = y + a / 500, z = y - b / 200;                                                          // 1350
    x = d3_lab_xyz(x) * d3_lab_X;                                                                                      // 1351
    y = d3_lab_xyz(y) * d3_lab_Y;                                                                                      // 1352
    z = d3_lab_xyz(z) * d3_lab_Z;                                                                                      // 1353
    return d3_rgb(d3_xyz_rgb(3.2404542 * x - 1.5371385 * y - .4985314 * z), d3_xyz_rgb(-.969266 * x + 1.8760108 * y + .041556 * z), d3_xyz_rgb(.0556434 * x - .2040259 * y + 1.0572252 * z));
  }                                                                                                                    // 1355
  function d3_lab_hcl(l, a, b) {                                                                                       // 1356
    return d3_hcl(Math.atan2(b, a) * d3_degrees, Math.sqrt(a * a + b * b), l);                                         // 1357
  }                                                                                                                    // 1358
  function d3_lab_xyz(x) {                                                                                             // 1359
    return x > .206893034 ? x * x * x : (x - 4 / 29) / 7.787037;                                                       // 1360
  }                                                                                                                    // 1361
  function d3_xyz_lab(x) {                                                                                             // 1362
    return x > .008856 ? Math.pow(x, 1 / 3) : 7.787037 * x + 4 / 29;                                                   // 1363
  }                                                                                                                    // 1364
  function d3_xyz_rgb(r) {                                                                                             // 1365
    return Math.round(255 * (r <= .00304 ? 12.92 * r : 1.055 * Math.pow(r, 1 / 2.4) - .055));                          // 1366
  }                                                                                                                    // 1367
  d3.rgb = function(r, g, b) {                                                                                         // 1368
    return arguments.length === 1 ? r instanceof d3_Rgb ? d3_rgb(r.r, r.g, r.b) : d3_rgb_parse("" + r, d3_rgb, d3_hsl_rgb) : d3_rgb(~~r, ~~g, ~~b);
  };                                                                                                                   // 1370
  function d3_rgb(r, g, b) {                                                                                           // 1371
    return new d3_Rgb(r, g, b);                                                                                        // 1372
  }                                                                                                                    // 1373
  function d3_Rgb(r, g, b) {                                                                                           // 1374
    this.r = r;                                                                                                        // 1375
    this.g = g;                                                                                                        // 1376
    this.b = b;                                                                                                        // 1377
  }                                                                                                                    // 1378
  var d3_rgbPrototype = d3_Rgb.prototype = new d3_Color();                                                             // 1379
  d3_rgbPrototype.brighter = function(k) {                                                                             // 1380
    k = Math.pow(.7, arguments.length ? k : 1);                                                                        // 1381
    var r = this.r, g = this.g, b = this.b, i = 30;                                                                    // 1382
    if (!r && !g && !b) return d3_rgb(i, i, i);                                                                        // 1383
    if (r && r < i) r = i;                                                                                             // 1384
    if (g && g < i) g = i;                                                                                             // 1385
    if (b && b < i) b = i;                                                                                             // 1386
    return d3_rgb(Math.min(255, Math.floor(r / k)), Math.min(255, Math.floor(g / k)), Math.min(255, Math.floor(b / k)));
  };                                                                                                                   // 1388
  d3_rgbPrototype.darker = function(k) {                                                                               // 1389
    k = Math.pow(.7, arguments.length ? k : 1);                                                                        // 1390
    return d3_rgb(Math.floor(k * this.r), Math.floor(k * this.g), Math.floor(k * this.b));                             // 1391
  };                                                                                                                   // 1392
  d3_rgbPrototype.hsl = function() {                                                                                   // 1393
    return d3_rgb_hsl(this.r, this.g, this.b);                                                                         // 1394
  };                                                                                                                   // 1395
  d3_rgbPrototype.toString = function() {                                                                              // 1396
    return "#" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);                                         // 1397
  };                                                                                                                   // 1398
  function d3_rgb_hex(v) {                                                                                             // 1399
    return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);                                 // 1400
  }                                                                                                                    // 1401
  function d3_rgb_parse(format, rgb, hsl) {                                                                            // 1402
    var r = 0, g = 0, b = 0, m1, m2, name;                                                                             // 1403
    m1 = /([a-z]+)\((.*)\)/i.exec(format);                                                                             // 1404
    if (m1) {                                                                                                          // 1405
      m2 = m1[2].split(",");                                                                                           // 1406
      switch (m1[1]) {                                                                                                 // 1407
       case "hsl":                                                                                                     // 1408
        {                                                                                                              // 1409
          return hsl(parseFloat(m2[0]), parseFloat(m2[1]) / 100, parseFloat(m2[2]) / 100);                             // 1410
        }                                                                                                              // 1411
                                                                                                                       // 1412
       case "rgb":                                                                                                     // 1413
        {                                                                                                              // 1414
          return rgb(d3_rgb_parseNumber(m2[0]), d3_rgb_parseNumber(m2[1]), d3_rgb_parseNumber(m2[2]));                 // 1415
        }                                                                                                              // 1416
      }                                                                                                                // 1417
    }                                                                                                                  // 1418
    if (name = d3_rgb_names.get(format)) return rgb(name.r, name.g, name.b);                                           // 1419
    if (format != null && format.charAt(0) === "#") {                                                                  // 1420
      if (format.length === 4) {                                                                                       // 1421
        r = format.charAt(1);                                                                                          // 1422
        r += r;                                                                                                        // 1423
        g = format.charAt(2);                                                                                          // 1424
        g += g;                                                                                                        // 1425
        b = format.charAt(3);                                                                                          // 1426
        b += b;                                                                                                        // 1427
      } else if (format.length === 7) {                                                                                // 1428
        r = format.substring(1, 3);                                                                                    // 1429
        g = format.substring(3, 5);                                                                                    // 1430
        b = format.substring(5, 7);                                                                                    // 1431
      }                                                                                                                // 1432
      r = parseInt(r, 16);                                                                                             // 1433
      g = parseInt(g, 16);                                                                                             // 1434
      b = parseInt(b, 16);                                                                                             // 1435
    }                                                                                                                  // 1436
    return rgb(r, g, b);                                                                                               // 1437
  }                                                                                                                    // 1438
  function d3_rgb_hsl(r, g, b) {                                                                                       // 1439
    var min = Math.min(r /= 255, g /= 255, b /= 255), max = Math.max(r, g, b), d = max - min, h, s, l = (max + min) / 2;
    if (d) {                                                                                                           // 1441
      s = l < .5 ? d / (max + min) : d / (2 - max - min);                                                              // 1442
      if (r == max) h = (g - b) / d + (g < b ? 6 : 0); else if (g == max) h = (b - r) / d + 2; else h = (r - g) / d + 4;
      h *= 60;                                                                                                         // 1444
    } else {                                                                                                           // 1445
      s = h = 0;                                                                                                       // 1446
    }                                                                                                                  // 1447
    return d3_hsl(h, s, l);                                                                                            // 1448
  }                                                                                                                    // 1449
  function d3_rgb_lab(r, g, b) {                                                                                       // 1450
    r = d3_rgb_xyz(r);                                                                                                 // 1451
    g = d3_rgb_xyz(g);                                                                                                 // 1452
    b = d3_rgb_xyz(b);                                                                                                 // 1453
    var x = d3_xyz_lab((.4124564 * r + .3575761 * g + .1804375 * b) / d3_lab_X), y = d3_xyz_lab((.2126729 * r + .7151522 * g + .072175 * b) / d3_lab_Y), z = d3_xyz_lab((.0193339 * r + .119192 * g + .9503041 * b) / d3_lab_Z);
    return d3_lab(116 * y - 16, 500 * (x - y), 200 * (y - z));                                                         // 1455
  }                                                                                                                    // 1456
  function d3_rgb_xyz(r) {                                                                                             // 1457
    return (r /= 255) <= .04045 ? r / 12.92 : Math.pow((r + .055) / 1.055, 2.4);                                       // 1458
  }                                                                                                                    // 1459
  function d3_rgb_parseNumber(c) {                                                                                     // 1460
    var f = parseFloat(c);                                                                                             // 1461
    return c.charAt(c.length - 1) === "%" ? Math.round(f * 2.55) : f;                                                  // 1462
  }                                                                                                                    // 1463
  var d3_rgb_names = d3.map({                                                                                          // 1464
    aliceblue: "#f0f8ff",                                                                                              // 1465
    antiquewhite: "#faebd7",                                                                                           // 1466
    aqua: "#00ffff",                                                                                                   // 1467
    aquamarine: "#7fffd4",                                                                                             // 1468
    azure: "#f0ffff",                                                                                                  // 1469
    beige: "#f5f5dc",                                                                                                  // 1470
    bisque: "#ffe4c4",                                                                                                 // 1471
    black: "#000000",                                                                                                  // 1472
    blanchedalmond: "#ffebcd",                                                                                         // 1473
    blue: "#0000ff",                                                                                                   // 1474
    blueviolet: "#8a2be2",                                                                                             // 1475
    brown: "#a52a2a",                                                                                                  // 1476
    burlywood: "#deb887",                                                                                              // 1477
    cadetblue: "#5f9ea0",                                                                                              // 1478
    chartreuse: "#7fff00",                                                                                             // 1479
    chocolate: "#d2691e",                                                                                              // 1480
    coral: "#ff7f50",                                                                                                  // 1481
    cornflowerblue: "#6495ed",                                                                                         // 1482
    cornsilk: "#fff8dc",                                                                                               // 1483
    crimson: "#dc143c",                                                                                                // 1484
    cyan: "#00ffff",                                                                                                   // 1485
    darkblue: "#00008b",                                                                                               // 1486
    darkcyan: "#008b8b",                                                                                               // 1487
    darkgoldenrod: "#b8860b",                                                                                          // 1488
    darkgray: "#a9a9a9",                                                                                               // 1489
    darkgreen: "#006400",                                                                                              // 1490
    darkgrey: "#a9a9a9",                                                                                               // 1491
    darkkhaki: "#bdb76b",                                                                                              // 1492
    darkmagenta: "#8b008b",                                                                                            // 1493
    darkolivegreen: "#556b2f",                                                                                         // 1494
    darkorange: "#ff8c00",                                                                                             // 1495
    darkorchid: "#9932cc",                                                                                             // 1496
    darkred: "#8b0000",                                                                                                // 1497
    darksalmon: "#e9967a",                                                                                             // 1498
    darkseagreen: "#8fbc8f",                                                                                           // 1499
    darkslateblue: "#483d8b",                                                                                          // 1500
    darkslategray: "#2f4f4f",                                                                                          // 1501
    darkslategrey: "#2f4f4f",                                                                                          // 1502
    darkturquoise: "#00ced1",                                                                                          // 1503
    darkviolet: "#9400d3",                                                                                             // 1504
    deeppink: "#ff1493",                                                                                               // 1505
    deepskyblue: "#00bfff",                                                                                            // 1506
    dimgray: "#696969",                                                                                                // 1507
    dimgrey: "#696969",                                                                                                // 1508
    dodgerblue: "#1e90ff",                                                                                             // 1509
    firebrick: "#b22222",                                                                                              // 1510
    floralwhite: "#fffaf0",                                                                                            // 1511
    forestgreen: "#228b22",                                                                                            // 1512
    fuchsia: "#ff00ff",                                                                                                // 1513
    gainsboro: "#dcdcdc",                                                                                              // 1514
    ghostwhite: "#f8f8ff",                                                                                             // 1515
    gold: "#ffd700",                                                                                                   // 1516
    goldenrod: "#daa520",                                                                                              // 1517
    gray: "#808080",                                                                                                   // 1518
    green: "#008000",                                                                                                  // 1519
    greenyellow: "#adff2f",                                                                                            // 1520
    grey: "#808080",                                                                                                   // 1521
    honeydew: "#f0fff0",                                                                                               // 1522
    hotpink: "#ff69b4",                                                                                                // 1523
    indianred: "#cd5c5c",                                                                                              // 1524
    indigo: "#4b0082",                                                                                                 // 1525
    ivory: "#fffff0",                                                                                                  // 1526
    khaki: "#f0e68c",                                                                                                  // 1527
    lavender: "#e6e6fa",                                                                                               // 1528
    lavenderblush: "#fff0f5",                                                                                          // 1529
    lawngreen: "#7cfc00",                                                                                              // 1530
    lemonchiffon: "#fffacd",                                                                                           // 1531
    lightblue: "#add8e6",                                                                                              // 1532
    lightcoral: "#f08080",                                                                                             // 1533
    lightcyan: "#e0ffff",                                                                                              // 1534
    lightgoldenrodyellow: "#fafad2",                                                                                   // 1535
    lightgray: "#d3d3d3",                                                                                              // 1536
    lightgreen: "#90ee90",                                                                                             // 1537
    lightgrey: "#d3d3d3",                                                                                              // 1538
    lightpink: "#ffb6c1",                                                                                              // 1539
    lightsalmon: "#ffa07a",                                                                                            // 1540
    lightseagreen: "#20b2aa",                                                                                          // 1541
    lightskyblue: "#87cefa",                                                                                           // 1542
    lightslategray: "#778899",                                                                                         // 1543
    lightslategrey: "#778899",                                                                                         // 1544
    lightsteelblue: "#b0c4de",                                                                                         // 1545
    lightyellow: "#ffffe0",                                                                                            // 1546
    lime: "#00ff00",                                                                                                   // 1547
    limegreen: "#32cd32",                                                                                              // 1548
    linen: "#faf0e6",                                                                                                  // 1549
    magenta: "#ff00ff",                                                                                                // 1550
    maroon: "#800000",                                                                                                 // 1551
    mediumaquamarine: "#66cdaa",                                                                                       // 1552
    mediumblue: "#0000cd",                                                                                             // 1553
    mediumorchid: "#ba55d3",                                                                                           // 1554
    mediumpurple: "#9370db",                                                                                           // 1555
    mediumseagreen: "#3cb371",                                                                                         // 1556
    mediumslateblue: "#7b68ee",                                                                                        // 1557
    mediumspringgreen: "#00fa9a",                                                                                      // 1558
    mediumturquoise: "#48d1cc",                                                                                        // 1559
    mediumvioletred: "#c71585",                                                                                        // 1560
    midnightblue: "#191970",                                                                                           // 1561
    mintcream: "#f5fffa",                                                                                              // 1562
    mistyrose: "#ffe4e1",                                                                                              // 1563
    moccasin: "#ffe4b5",                                                                                               // 1564
    navajowhite: "#ffdead",                                                                                            // 1565
    navy: "#000080",                                                                                                   // 1566
    oldlace: "#fdf5e6",                                                                                                // 1567
    olive: "#808000",                                                                                                  // 1568
    olivedrab: "#6b8e23",                                                                                              // 1569
    orange: "#ffa500",                                                                                                 // 1570
    orangered: "#ff4500",                                                                                              // 1571
    orchid: "#da70d6",                                                                                                 // 1572
    palegoldenrod: "#eee8aa",                                                                                          // 1573
    palegreen: "#98fb98",                                                                                              // 1574
    paleturquoise: "#afeeee",                                                                                          // 1575
    palevioletred: "#db7093",                                                                                          // 1576
    papayawhip: "#ffefd5",                                                                                             // 1577
    peachpuff: "#ffdab9",                                                                                              // 1578
    peru: "#cd853f",                                                                                                   // 1579
    pink: "#ffc0cb",                                                                                                   // 1580
    plum: "#dda0dd",                                                                                                   // 1581
    powderblue: "#b0e0e6",                                                                                             // 1582
    purple: "#800080",                                                                                                 // 1583
    red: "#ff0000",                                                                                                    // 1584
    rosybrown: "#bc8f8f",                                                                                              // 1585
    royalblue: "#4169e1",                                                                                              // 1586
    saddlebrown: "#8b4513",                                                                                            // 1587
    salmon: "#fa8072",                                                                                                 // 1588
    sandybrown: "#f4a460",                                                                                             // 1589
    seagreen: "#2e8b57",                                                                                               // 1590
    seashell: "#fff5ee",                                                                                               // 1591
    sienna: "#a0522d",                                                                                                 // 1592
    silver: "#c0c0c0",                                                                                                 // 1593
    skyblue: "#87ceeb",                                                                                                // 1594
    slateblue: "#6a5acd",                                                                                              // 1595
    slategray: "#708090",                                                                                              // 1596
    slategrey: "#708090",                                                                                              // 1597
    snow: "#fffafa",                                                                                                   // 1598
    springgreen: "#00ff7f",                                                                                            // 1599
    steelblue: "#4682b4",                                                                                              // 1600
    tan: "#d2b48c",                                                                                                    // 1601
    teal: "#008080",                                                                                                   // 1602
    thistle: "#d8bfd8",                                                                                                // 1603
    tomato: "#ff6347",                                                                                                 // 1604
    turquoise: "#40e0d0",                                                                                              // 1605
    violet: "#ee82ee",                                                                                                 // 1606
    wheat: "#f5deb3",                                                                                                  // 1607
    white: "#ffffff",                                                                                                  // 1608
    whitesmoke: "#f5f5f5",                                                                                             // 1609
    yellow: "#ffff00",                                                                                                 // 1610
    yellowgreen: "#9acd32"                                                                                             // 1611
  });                                                                                                                  // 1612
  d3_rgb_names.forEach(function(key, value) {                                                                          // 1613
    d3_rgb_names.set(key, d3_rgb_parse(value, d3_rgb, d3_hsl_rgb));                                                    // 1614
  });                                                                                                                  // 1615
  function d3_functor(v) {                                                                                             // 1616
    return typeof v === "function" ? v : function() {                                                                  // 1617
      return v;                                                                                                        // 1618
    };                                                                                                                 // 1619
  }                                                                                                                    // 1620
  d3.functor = d3_functor;                                                                                             // 1621
  function d3_identity(d) {                                                                                            // 1622
    return d;                                                                                                          // 1623
  }                                                                                                                    // 1624
  d3.xhr = function(url, mimeType, callback) {                                                                         // 1625
    var xhr = {}, dispatch = d3.dispatch("progress", "load", "error"), headers = {}, response = d3_identity, request = new (d3_window.XDomainRequest && /^(http(s)?:)?\/\//.test(url) ? XDomainRequest : XMLHttpRequest)();
    "onload" in request ? request.onload = request.onerror = respond : request.onreadystatechange = function() {       // 1627
      request.readyState > 3 && respond();                                                                             // 1628
    };                                                                                                                 // 1629
    function respond() {                                                                                               // 1630
      var s = request.status;                                                                                          // 1631
      !s && request.responseText || s >= 200 && s < 300 || s === 304 ? dispatch.load.call(xhr, response.call(xhr, request)) : dispatch.error.call(xhr, request);
    }                                                                                                                  // 1633
    request.onprogress = function(event) {                                                                             // 1634
      var o = d3.event;                                                                                                // 1635
      d3.event = event;                                                                                                // 1636
      try {                                                                                                            // 1637
        dispatch.progress.call(xhr, request);                                                                          // 1638
      } finally {                                                                                                      // 1639
        d3.event = o;                                                                                                  // 1640
      }                                                                                                                // 1641
    };                                                                                                                 // 1642
    xhr.header = function(name, value) {                                                                               // 1643
      name = (name + "").toLowerCase();                                                                                // 1644
      if (arguments.length < 2) return headers[name];                                                                  // 1645
      if (value == null) delete headers[name]; else headers[name] = value + "";                                        // 1646
      return xhr;                                                                                                      // 1647
    };                                                                                                                 // 1648
    xhr.mimeType = function(value) {                                                                                   // 1649
      if (!arguments.length) return mimeType;                                                                          // 1650
      mimeType = value == null ? null : value + "";                                                                    // 1651
      return xhr;                                                                                                      // 1652
    };                                                                                                                 // 1653
    xhr.response = function(value) {                                                                                   // 1654
      response = value;                                                                                                // 1655
      return xhr;                                                                                                      // 1656
    };                                                                                                                 // 1657
    [ "get", "post" ].forEach(function(method) {                                                                       // 1658
      xhr[method] = function() {                                                                                       // 1659
        return xhr.send.apply(xhr, [ method ].concat(d3_array(arguments)));                                            // 1660
      };                                                                                                               // 1661
    });                                                                                                                // 1662
    xhr.send = function(method, data, callback) {                                                                      // 1663
      if (arguments.length === 2 && typeof data === "function") callback = data, data = null;                          // 1664
      request.open(method, url, true);                                                                                 // 1665
      if (mimeType != null && !("accept" in headers)) headers["accept"] = mimeType + ",*/*";                           // 1666
      if (request.setRequestHeader) for (var name in headers) request.setRequestHeader(name, headers[name]);           // 1667
      if (mimeType != null && request.overrideMimeType) request.overrideMimeType(mimeType);                            // 1668
      if (callback != null) xhr.on("error", callback).on("load", function(request) {                                   // 1669
        callback(null, request);                                                                                       // 1670
      });                                                                                                              // 1671
      request.send(data == null ? null : data);                                                                        // 1672
      return xhr;                                                                                                      // 1673
    };                                                                                                                 // 1674
    xhr.abort = function() {                                                                                           // 1675
      request.abort();                                                                                                 // 1676
      return xhr;                                                                                                      // 1677
    };                                                                                                                 // 1678
    d3.rebind(xhr, dispatch, "on");                                                                                    // 1679
    if (arguments.length === 2 && typeof mimeType === "function") callback = mimeType,                                 // 1680
    mimeType = null;                                                                                                   // 1681
    return callback == null ? xhr : xhr.get(d3_xhr_fixCallback(callback));                                             // 1682
  };                                                                                                                   // 1683
  function d3_xhr_fixCallback(callback) {                                                                              // 1684
    return callback.length === 1 ? function(error, request) {                                                          // 1685
      callback(error == null ? request : null);                                                                        // 1686
    } : callback;                                                                                                      // 1687
  }                                                                                                                    // 1688
  function d3_dsv(delimiter, mimeType) {                                                                               // 1689
    var reFormat = new RegExp('["' + delimiter + "\n]"), delimiterCode = delimiter.charCodeAt(0);                      // 1690
    function dsv(url, row, callback) {                                                                                 // 1691
      if (arguments.length < 3) callback = row, row = null;                                                            // 1692
      var xhr = d3.xhr(url, mimeType, callback);                                                                       // 1693
      xhr.row = function(_) {                                                                                          // 1694
        return arguments.length ? xhr.response((row = _) == null ? response : typedResponse(_)) : row;                 // 1695
      };                                                                                                               // 1696
      return xhr.row(row);                                                                                             // 1697
    }                                                                                                                  // 1698
    function response(request) {                                                                                       // 1699
      return dsv.parse(request.responseText);                                                                          // 1700
    }                                                                                                                  // 1701
    function typedResponse(f) {                                                                                        // 1702
      return function(request) {                                                                                       // 1703
        return dsv.parse(request.responseText, f);                                                                     // 1704
      };                                                                                                               // 1705
    }                                                                                                                  // 1706
    dsv.parse = function(text, f) {                                                                                    // 1707
      var o;                                                                                                           // 1708
      return dsv.parseRows(text, function(row, i) {                                                                    // 1709
        if (o) return o(row, i - 1);                                                                                   // 1710
        var a = new Function("d", "return {" + row.map(function(name, i) {                                             // 1711
          return JSON.stringify(name) + ": d[" + i + "]";                                                              // 1712
        }).join(",") + "}");                                                                                           // 1713
        o = f ? function(row, i) {                                                                                     // 1714
          return f(a(row), i);                                                                                         // 1715
        } : a;                                                                                                         // 1716
      });                                                                                                              // 1717
    };                                                                                                                 // 1718
    dsv.parseRows = function(text, f) {                                                                                // 1719
      var EOL = {}, EOF = {}, rows = [], N = text.length, I = 0, n = 0, t, eol;                                        // 1720
      function token() {                                                                                               // 1721
        if (I >= N) return EOF;                                                                                        // 1722
        if (eol) return eol = false, EOL;                                                                              // 1723
        var j = I;                                                                                                     // 1724
        if (text.charCodeAt(j) === 34) {                                                                               // 1725
          var i = j;                                                                                                   // 1726
          while (i++ < N) {                                                                                            // 1727
            if (text.charCodeAt(i) === 34) {                                                                           // 1728
              if (text.charCodeAt(i + 1) !== 34) break;                                                                // 1729
              ++i;                                                                                                     // 1730
            }                                                                                                          // 1731
          }                                                                                                            // 1732
          I = i + 2;                                                                                                   // 1733
          var c = text.charCodeAt(i + 1);                                                                              // 1734
          if (c === 13) {                                                                                              // 1735
            eol = true;                                                                                                // 1736
            if (text.charCodeAt(i + 2) === 10) ++I;                                                                    // 1737
          } else if (c === 10) {                                                                                       // 1738
            eol = true;                                                                                                // 1739
          }                                                                                                            // 1740
          return text.substring(j + 1, i).replace(/""/g, '"');                                                         // 1741
        }                                                                                                              // 1742
        while (I < N) {                                                                                                // 1743
          var c = text.charCodeAt(I++), k = 1;                                                                         // 1744
          if (c === 10) eol = true; else if (c === 13) {                                                               // 1745
            eol = true;                                                                                                // 1746
            if (text.charCodeAt(I) === 10) ++I, ++k;                                                                   // 1747
          } else if (c !== delimiterCode) continue;                                                                    // 1748
          return text.substring(j, I - k);                                                                             // 1749
        }                                                                                                              // 1750
        return text.substring(j);                                                                                      // 1751
      }                                                                                                                // 1752
      while ((t = token()) !== EOF) {                                                                                  // 1753
        var a = [];                                                                                                    // 1754
        while (t !== EOL && t !== EOF) {                                                                               // 1755
          a.push(t);                                                                                                   // 1756
          t = token();                                                                                                 // 1757
        }                                                                                                              // 1758
        if (f && !(a = f(a, n++))) continue;                                                                           // 1759
        rows.push(a);                                                                                                  // 1760
      }                                                                                                                // 1761
      return rows;                                                                                                     // 1762
    };                                                                                                                 // 1763
    dsv.format = function(rows) {                                                                                      // 1764
      if (Array.isArray(rows[0])) return dsv.formatRows(rows);                                                         // 1765
      var fieldSet = new d3_Set(), fields = [];                                                                        // 1766
      rows.forEach(function(row) {                                                                                     // 1767
        for (var field in row) {                                                                                       // 1768
          if (!fieldSet.has(field)) {                                                                                  // 1769
            fields.push(fieldSet.add(field));                                                                          // 1770
          }                                                                                                            // 1771
        }                                                                                                              // 1772
      });                                                                                                              // 1773
      return [ fields.map(formatValue).join(delimiter) ].concat(rows.map(function(row) {                               // 1774
        return fields.map(function(field) {                                                                            // 1775
          return formatValue(row[field]);                                                                              // 1776
        }).join(delimiter);                                                                                            // 1777
      })).join("\n");                                                                                                  // 1778
    };                                                                                                                 // 1779
    dsv.formatRows = function(rows) {                                                                                  // 1780
      return rows.map(formatRow).join("\n");                                                                           // 1781
    };                                                                                                                 // 1782
    function formatRow(row) {                                                                                          // 1783
      return row.map(formatValue).join(delimiter);                                                                     // 1784
    }                                                                                                                  // 1785
    function formatValue(text) {                                                                                       // 1786
      return reFormat.test(text) ? '"' + text.replace(/\"/g, '""') + '"' : text;                                       // 1787
    }                                                                                                                  // 1788
    return dsv;                                                                                                        // 1789
  }                                                                                                                    // 1790
  d3.csv = d3_dsv(",", "text/csv");                                                                                    // 1791
  d3.tsv = d3_dsv("\t", "text/tab-separated-values");                                                                  // 1792
  var d3_timer_id = 0, d3_timer_byId = {}, d3_timer_queue = null, d3_timer_interval, d3_timer_timeout;                 // 1793
  d3.timer = function(callback, delay, then) {                                                                         // 1794
    if (arguments.length < 3) {                                                                                        // 1795
      if (arguments.length < 2) delay = 0; else if (!isFinite(delay)) return;                                          // 1796
      then = Date.now();                                                                                               // 1797
    }                                                                                                                  // 1798
    var timer = d3_timer_byId[callback.id];                                                                            // 1799
    if (timer && timer.callback === callback) {                                                                        // 1800
      timer.then = then;                                                                                               // 1801
      timer.delay = delay;                                                                                             // 1802
    } else d3_timer_byId[callback.id = ++d3_timer_id] = d3_timer_queue = {                                             // 1803
      callback: callback,                                                                                              // 1804
      then: then,                                                                                                      // 1805
      delay: delay,                                                                                                    // 1806
      next: d3_timer_queue                                                                                             // 1807
    };                                                                                                                 // 1808
    if (!d3_timer_interval) {                                                                                          // 1809
      d3_timer_timeout = clearTimeout(d3_timer_timeout);                                                               // 1810
      d3_timer_interval = 1;                                                                                           // 1811
      d3_timer_frame(d3_timer_step);                                                                                   // 1812
    }                                                                                                                  // 1813
  };                                                                                                                   // 1814
  function d3_timer_step() {                                                                                           // 1815
    var elapsed, now = Date.now(), t1 = d3_timer_queue;                                                                // 1816
    while (t1) {                                                                                                       // 1817
      elapsed = now - t1.then;                                                                                         // 1818
      if (elapsed >= t1.delay) t1.flush = t1.callback(elapsed);                                                        // 1819
      t1 = t1.next;                                                                                                    // 1820
    }                                                                                                                  // 1821
    var delay = d3_timer_flush() - now;                                                                                // 1822
    if (delay > 24) {                                                                                                  // 1823
      if (isFinite(delay)) {                                                                                           // 1824
        clearTimeout(d3_timer_timeout);                                                                                // 1825
        d3_timer_timeout = setTimeout(d3_timer_step, delay);                                                           // 1826
      }                                                                                                                // 1827
      d3_timer_interval = 0;                                                                                           // 1828
    } else {                                                                                                           // 1829
      d3_timer_interval = 1;                                                                                           // 1830
      d3_timer_frame(d3_timer_step);                                                                                   // 1831
    }                                                                                                                  // 1832
  }                                                                                                                    // 1833
  d3.timer.flush = function() {                                                                                        // 1834
    var elapsed, now = Date.now(), t1 = d3_timer_queue;                                                                // 1835
    while (t1) {                                                                                                       // 1836
      elapsed = now - t1.then;                                                                                         // 1837
      if (!t1.delay) t1.flush = t1.callback(elapsed);                                                                  // 1838
      t1 = t1.next;                                                                                                    // 1839
    }                                                                                                                  // 1840
    d3_timer_flush();                                                                                                  // 1841
  };                                                                                                                   // 1842
  function d3_timer_flush() {                                                                                          // 1843
    var t0 = null, t1 = d3_timer_queue, then = Infinity;                                                               // 1844
    while (t1) {                                                                                                       // 1845
      if (t1.flush) {                                                                                                  // 1846
        delete d3_timer_byId[t1.callback.id];                                                                          // 1847
        t1 = t0 ? t0.next = t1.next : d3_timer_queue = t1.next;                                                        // 1848
      } else {                                                                                                         // 1849
        then = Math.min(then, t1.then + t1.delay);                                                                     // 1850
        t1 = (t0 = t1).next;                                                                                           // 1851
      }                                                                                                                // 1852
    }                                                                                                                  // 1853
    return then;                                                                                                       // 1854
  }                                                                                                                    // 1855
  var d3_timer_frame = d3_window.requestAnimationFrame || d3_window.webkitRequestAnimationFrame || d3_window.mozRequestAnimationFrame || d3_window.oRequestAnimationFrame || d3_window.msRequestAnimationFrame || function(callback) {
    setTimeout(callback, 17);                                                                                          // 1857
  };                                                                                                                   // 1858
  var d3_format_decimalPoint = ".", d3_format_thousandsSeparator = ",", d3_format_grouping = [ 3, 3 ];                 // 1859
  var d3_formatPrefixes = [ "y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y" ].map(d3_formatPrefix);
  d3.formatPrefix = function(value, precision) {                                                                       // 1861
    var i = 0;                                                                                                         // 1862
    if (value) {                                                                                                       // 1863
      if (value < 0) value *= -1;                                                                                      // 1864
      if (precision) value = d3.round(value, d3_format_precision(value, precision));                                   // 1865
      i = 1 + Math.floor(1e-12 + Math.log(value) / Math.LN10);                                                         // 1866
      i = Math.max(-24, Math.min(24, Math.floor((i <= 0 ? i + 1 : i - 1) / 3) * 3));                                   // 1867
    }                                                                                                                  // 1868
    return d3_formatPrefixes[8 + i / 3];                                                                               // 1869
  };                                                                                                                   // 1870
  function d3_formatPrefix(d, i) {                                                                                     // 1871
    var k = Math.pow(10, Math.abs(8 - i) * 3);                                                                         // 1872
    return {                                                                                                           // 1873
      scale: i > 8 ? function(d) {                                                                                     // 1874
        return d / k;                                                                                                  // 1875
      } : function(d) {                                                                                                // 1876
        return d * k;                                                                                                  // 1877
      },                                                                                                               // 1878
      symbol: d                                                                                                        // 1879
    };                                                                                                                 // 1880
  }                                                                                                                    // 1881
  d3.round = function(x, n) {                                                                                          // 1882
    return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);                                              // 1883
  };                                                                                                                   // 1884
  d3.format = function(specifier) {                                                                                    // 1885
    var match = d3_format_re.exec(specifier), fill = match[1] || " ", align = match[2] || ">", sign = match[3] || "", basePrefix = match[4] || "", zfill = match[5], width = +match[6], comma = match[7], precision = match[8], type = match[9], scale = 1, suffix = "", integer = false;
    if (precision) precision = +precision.substring(1);                                                                // 1887
    if (zfill || fill === "0" && align === "=") {                                                                      // 1888
      zfill = fill = "0";                                                                                              // 1889
      align = "=";                                                                                                     // 1890
      if (comma) width -= Math.floor((width - 1) / 4);                                                                 // 1891
    }                                                                                                                  // 1892
    switch (type) {                                                                                                    // 1893
     case "n":                                                                                                         // 1894
      comma = true;                                                                                                    // 1895
      type = "g";                                                                                                      // 1896
      break;                                                                                                           // 1897
                                                                                                                       // 1898
     case "%":                                                                                                         // 1899
      scale = 100;                                                                                                     // 1900
      suffix = "%";                                                                                                    // 1901
      type = "f";                                                                                                      // 1902
      break;                                                                                                           // 1903
                                                                                                                       // 1904
     case "p":                                                                                                         // 1905
      scale = 100;                                                                                                     // 1906
      suffix = "%";                                                                                                    // 1907
      type = "r";                                                                                                      // 1908
      break;                                                                                                           // 1909
                                                                                                                       // 1910
     case "b":                                                                                                         // 1911
     case "o":                                                                                                         // 1912
     case "x":                                                                                                         // 1913
     case "X":                                                                                                         // 1914
      if (basePrefix) basePrefix = "0" + type.toLowerCase();                                                           // 1915
                                                                                                                       // 1916
     case "c":                                                                                                         // 1917
     case "d":                                                                                                         // 1918
      integer = true;                                                                                                  // 1919
      precision = 0;                                                                                                   // 1920
      break;                                                                                                           // 1921
                                                                                                                       // 1922
     case "s":                                                                                                         // 1923
      scale = -1;                                                                                                      // 1924
      type = "r";                                                                                                      // 1925
      break;                                                                                                           // 1926
    }                                                                                                                  // 1927
    if (basePrefix === "#") basePrefix = "";                                                                           // 1928
    if (type == "r" && !precision) type = "g";                                                                         // 1929
    if (precision != null) {                                                                                           // 1930
      if (type == "g") precision = Math.max(1, Math.min(21, precision)); else if (type == "e" || type == "f") precision = Math.max(0, Math.min(20, precision));
    }                                                                                                                  // 1932
    type = d3_format_types.get(type) || d3_format_typeDefault;                                                         // 1933
    var zcomma = zfill && comma;                                                                                       // 1934
    return function(value) {                                                                                           // 1935
      if (integer && value % 1) return "";                                                                             // 1936
      var negative = value < 0 || value === 0 && 1 / value < 0 ? (value = -value, "-") : sign;                         // 1937
      if (scale < 0) {                                                                                                 // 1938
        var prefix = d3.formatPrefix(value, precision);                                                                // 1939
        value = prefix.scale(value);                                                                                   // 1940
        suffix = prefix.symbol;                                                                                        // 1941
      } else {                                                                                                         // 1942
        value *= scale;                                                                                                // 1943
      }                                                                                                                // 1944
      value = type(value, precision);                                                                                  // 1945
      if (!zfill && comma) value = d3_format_group(value);                                                             // 1946
      var length = basePrefix.length + value.length + (zcomma ? 0 : negative.length), padding = length < width ? new Array(length = width - length + 1).join(fill) : "";
      if (zcomma) value = d3_format_group(padding + value);                                                            // 1948
      if (d3_format_decimalPoint) value.replace(".", d3_format_decimalPoint);                                          // 1949
      negative += basePrefix;                                                                                          // 1950
      return (align === "<" ? negative + value + padding : align === ">" ? padding + negative + value : align === "^" ? padding.substring(0, length >>= 1) + negative + value + padding.substring(length) : negative + (zcomma ? value : padding + value)) + suffix;
    };                                                                                                                 // 1952
  };                                                                                                                   // 1953
  var d3_format_re = /(?:([^{])?([<>=^]))?([+\- ])?(#)?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i;                            // 1954
  var d3_format_types = d3.map({                                                                                       // 1955
    b: function(x) {                                                                                                   // 1956
      return x.toString(2);                                                                                            // 1957
    },                                                                                                                 // 1958
    c: function(x) {                                                                                                   // 1959
      return String.fromCharCode(x);                                                                                   // 1960
    },                                                                                                                 // 1961
    o: function(x) {                                                                                                   // 1962
      return x.toString(8);                                                                                            // 1963
    },                                                                                                                 // 1964
    x: function(x) {                                                                                                   // 1965
      return x.toString(16);                                                                                           // 1966
    },                                                                                                                 // 1967
    X: function(x) {                                                                                                   // 1968
      return x.toString(16).toUpperCase();                                                                             // 1969
    },                                                                                                                 // 1970
    g: function(x, p) {                                                                                                // 1971
      return x.toPrecision(p);                                                                                         // 1972
    },                                                                                                                 // 1973
    e: function(x, p) {                                                                                                // 1974
      return x.toExponential(p);                                                                                       // 1975
    },                                                                                                                 // 1976
    f: function(x, p) {                                                                                                // 1977
      return x.toFixed(p);                                                                                             // 1978
    },                                                                                                                 // 1979
    r: function(x, p) {                                                                                                // 1980
      return (x = d3.round(x, d3_format_precision(x, p))).toFixed(Math.max(0, Math.min(20, d3_format_precision(x * (1 + 1e-15), p))));
    }                                                                                                                  // 1982
  });                                                                                                                  // 1983
  function d3_format_precision(x, p) {                                                                                 // 1984
    return p - (x ? Math.ceil(Math.log(x) / Math.LN10) : 1);                                                           // 1985
  }                                                                                                                    // 1986
  function d3_format_typeDefault(x) {                                                                                  // 1987
    return x + "";                                                                                                     // 1988
  }                                                                                                                    // 1989
  var d3_format_group = d3_identity;                                                                                   // 1990
  if (d3_format_grouping) {                                                                                            // 1991
    var d3_format_groupingLength = d3_format_grouping.length;                                                          // 1992
    d3_format_group = function(value) {                                                                                // 1993
      var i = value.lastIndexOf("."), f = i >= 0 ? "." + value.substring(i + 1) : (i = value.length,                   // 1994
      ""), t = [], j = 0, g = d3_format_grouping[0];                                                                   // 1995
      while (i > 0 && g > 0) {                                                                                         // 1996
        t.push(value.substring(i -= g, i + g));                                                                        // 1997
        g = d3_format_grouping[j = (j + 1) % d3_format_groupingLength];                                                // 1998
      }                                                                                                                // 1999
      return t.reverse().join(d3_format_thousandsSeparator || "") + f;                                                 // 2000
    };                                                                                                                 // 2001
  }                                                                                                                    // 2002
  d3.geo = {};                                                                                                         // 2003
  d3.geo.stream = function(object, listener) {                                                                         // 2004
    if (d3_geo_streamObjectType.hasOwnProperty(object.type)) {                                                         // 2005
      d3_geo_streamObjectType[object.type](object, listener);                                                          // 2006
    } else {                                                                                                           // 2007
      d3_geo_streamGeometry(object, listener);                                                                         // 2008
    }                                                                                                                  // 2009
  };                                                                                                                   // 2010
  function d3_geo_streamGeometry(geometry, listener) {                                                                 // 2011
    if (d3_geo_streamGeometryType.hasOwnProperty(geometry.type)) {                                                     // 2012
      d3_geo_streamGeometryType[geometry.type](geometry, listener);                                                    // 2013
    }                                                                                                                  // 2014
  }                                                                                                                    // 2015
  var d3_geo_streamObjectType = {                                                                                      // 2016
    Feature: function(feature, listener) {                                                                             // 2017
      d3_geo_streamGeometry(feature.geometry, listener);                                                               // 2018
    },                                                                                                                 // 2019
    FeatureCollection: function(object, listener) {                                                                    // 2020
      var features = object.features, i = -1, n = features.length;                                                     // 2021
      while (++i < n) d3_geo_streamGeometry(features[i].geometry, listener);                                           // 2022
    }                                                                                                                  // 2023
  };                                                                                                                   // 2024
  var d3_geo_streamGeometryType = {                                                                                    // 2025
    Sphere: function(object, listener) {                                                                               // 2026
      listener.sphere();                                                                                               // 2027
    },                                                                                                                 // 2028
    Point: function(object, listener) {                                                                                // 2029
      var coordinate = object.coordinates;                                                                             // 2030
      listener.point(coordinate[0], coordinate[1]);                                                                    // 2031
    },                                                                                                                 // 2032
    MultiPoint: function(object, listener) {                                                                           // 2033
      var coordinates = object.coordinates, i = -1, n = coordinates.length, coordinate;                                // 2034
      while (++i < n) coordinate = coordinates[i], listener.point(coordinate[0], coordinate[1]);                       // 2035
    },                                                                                                                 // 2036
    LineString: function(object, listener) {                                                                           // 2037
      d3_geo_streamLine(object.coordinates, listener, 0);                                                              // 2038
    },                                                                                                                 // 2039
    MultiLineString: function(object, listener) {                                                                      // 2040
      var coordinates = object.coordinates, i = -1, n = coordinates.length;                                            // 2041
      while (++i < n) d3_geo_streamLine(coordinates[i], listener, 0);                                                  // 2042
    },                                                                                                                 // 2043
    Polygon: function(object, listener) {                                                                              // 2044
      d3_geo_streamPolygon(object.coordinates, listener);                                                              // 2045
    },                                                                                                                 // 2046
    MultiPolygon: function(object, listener) {                                                                         // 2047
      var coordinates = object.coordinates, i = -1, n = coordinates.length;                                            // 2048
      while (++i < n) d3_geo_streamPolygon(coordinates[i], listener);                                                  // 2049
    },                                                                                                                 // 2050
    GeometryCollection: function(object, listener) {                                                                   // 2051
      var geometries = object.geometries, i = -1, n = geometries.length;                                               // 2052
      while (++i < n) d3_geo_streamGeometry(geometries[i], listener);                                                  // 2053
    }                                                                                                                  // 2054
  };                                                                                                                   // 2055
  function d3_geo_streamLine(coordinates, listener, closed) {                                                          // 2056
    var i = -1, n = coordinates.length - closed, coordinate;                                                           // 2057
    listener.lineStart();                                                                                              // 2058
    while (++i < n) coordinate = coordinates[i], listener.point(coordinate[0], coordinate[1]);                         // 2059
    listener.lineEnd();                                                                                                // 2060
  }                                                                                                                    // 2061
  function d3_geo_streamPolygon(coordinates, listener) {                                                               // 2062
    var i = -1, n = coordinates.length;                                                                                // 2063
    listener.polygonStart();                                                                                           // 2064
    while (++i < n) d3_geo_streamLine(coordinates[i], listener, 1);                                                    // 2065
    listener.polygonEnd();                                                                                             // 2066
  }                                                                                                                    // 2067
  d3.geo.area = function(object) {                                                                                     // 2068
    d3_geo_areaSum = 0;                                                                                                // 2069
    d3.geo.stream(object, d3_geo_area);                                                                                // 2070
    return d3_geo_areaSum;                                                                                             // 2071
  };                                                                                                                   // 2072
  var d3_geo_areaSum, d3_geo_areaRingU, d3_geo_areaRingV;                                                              // 2073
  var d3_geo_area = {                                                                                                  // 2074
    sphere: function() {                                                                                               // 2075
      d3_geo_areaSum += 4 * π;                                                                                         // 2076
    },                                                                                                                 // 2077
    point: d3_noop,                                                                                                    // 2078
    lineStart: d3_noop,                                                                                                // 2079
    lineEnd: d3_noop,                                                                                                  // 2080
    polygonStart: function() {                                                                                         // 2081
      d3_geo_areaRingU = 1, d3_geo_areaRingV = 0;                                                                      // 2082
      d3_geo_area.lineStart = d3_geo_areaRingStart;                                                                    // 2083
    },                                                                                                                 // 2084
    polygonEnd: function() {                                                                                           // 2085
      var area = 2 * Math.atan2(d3_geo_areaRingV, d3_geo_areaRingU);                                                   // 2086
      d3_geo_areaSum += area < 0 ? 4 * π + area : area;                                                                // 2087
      d3_geo_area.lineStart = d3_geo_area.lineEnd = d3_geo_area.point = d3_noop;                                       // 2088
    }                                                                                                                  // 2089
  };                                                                                                                   // 2090
  function d3_geo_areaRingStart() {                                                                                    // 2091
    var λ00, φ00, λ0, cosφ0, sinφ0;                                                                                    // 2092
    d3_geo_area.point = function(λ, φ) {                                                                               // 2093
      d3_geo_area.point = nextPoint;                                                                                   // 2094
      λ0 = (λ00 = λ) * d3_radians, cosφ0 = Math.cos(φ = (φ00 = φ) * d3_radians / 2 + π / 4),                           // 2095
      sinφ0 = Math.sin(φ);                                                                                             // 2096
    };                                                                                                                 // 2097
    function nextPoint(λ, φ) {                                                                                         // 2098
      λ *= d3_radians;                                                                                                 // 2099
      φ = φ * d3_radians / 2 + π / 4;                                                                                  // 2100
      var dλ = λ - λ0, cosφ = Math.cos(φ), sinφ = Math.sin(φ), k = sinφ0 * sinφ, u0 = d3_geo_areaRingU, v0 = d3_geo_areaRingV, u = cosφ0 * cosφ + k * Math.cos(dλ), v = k * Math.sin(dλ);
      d3_geo_areaRingU = u0 * u - v0 * v;                                                                              // 2102
      d3_geo_areaRingV = v0 * u + u0 * v;                                                                              // 2103
      λ0 = λ, cosφ0 = cosφ, sinφ0 = sinφ;                                                                              // 2104
    }                                                                                                                  // 2105
    d3_geo_area.lineEnd = function() {                                                                                 // 2106
      nextPoint(λ00, φ00);                                                                                             // 2107
    };                                                                                                                 // 2108
  }                                                                                                                    // 2109
  d3.geo.bounds = d3_geo_bounds(d3_identity);                                                                          // 2110
  function d3_geo_bounds(projectStream) {                                                                              // 2111
    var x0, y0, x1, y1;                                                                                                // 2112
    var bound = {                                                                                                      // 2113
      point: boundPoint,                                                                                               // 2114
      lineStart: d3_noop,                                                                                              // 2115
      lineEnd: d3_noop,                                                                                                // 2116
      polygonStart: function() {                                                                                       // 2117
        bound.lineEnd = boundPolygonLineEnd;                                                                           // 2118
      },                                                                                                               // 2119
      polygonEnd: function() {                                                                                         // 2120
        bound.point = boundPoint;                                                                                      // 2121
      }                                                                                                                // 2122
    };                                                                                                                 // 2123
    function boundPoint(x, y) {                                                                                        // 2124
      if (x < x0) x0 = x;                                                                                              // 2125
      if (x > x1) x1 = x;                                                                                              // 2126
      if (y < y0) y0 = y;                                                                                              // 2127
      if (y > y1) y1 = y;                                                                                              // 2128
    }                                                                                                                  // 2129
    function boundPolygonLineEnd() {                                                                                   // 2130
      bound.point = bound.lineEnd = d3_noop;                                                                           // 2131
    }                                                                                                                  // 2132
    return function(feature) {                                                                                         // 2133
      y1 = x1 = -(x0 = y0 = Infinity);                                                                                 // 2134
      d3.geo.stream(feature, projectStream(bound));                                                                    // 2135
      return [ [ x0, y0 ], [ x1, y1 ] ];                                                                               // 2136
    };                                                                                                                 // 2137
  }                                                                                                                    // 2138
  d3.geo.centroid = function(object) {                                                                                 // 2139
    d3_geo_centroidDimension = d3_geo_centroidW = d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;          // 2140
    d3.geo.stream(object, d3_geo_centroid);                                                                            // 2141
    var m;                                                                                                             // 2142
    if (d3_geo_centroidW && Math.abs(m = Math.sqrt(d3_geo_centroidX * d3_geo_centroidX + d3_geo_centroidY * d3_geo_centroidY + d3_geo_centroidZ * d3_geo_centroidZ)) > ε) {
      return [ Math.atan2(d3_geo_centroidY, d3_geo_centroidX) * d3_degrees, Math.asin(Math.max(-1, Math.min(1, d3_geo_centroidZ / m))) * d3_degrees ];
    }                                                                                                                  // 2145
  };                                                                                                                   // 2146
  var d3_geo_centroidDimension, d3_geo_centroidW, d3_geo_centroidX, d3_geo_centroidY, d3_geo_centroidZ;                // 2147
  var d3_geo_centroid = {                                                                                              // 2148
    sphere: function() {                                                                                               // 2149
      if (d3_geo_centroidDimension < 2) {                                                                              // 2150
        d3_geo_centroidDimension = 2;                                                                                  // 2151
        d3_geo_centroidW = d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                                 // 2152
      }                                                                                                                // 2153
    },                                                                                                                 // 2154
    point: d3_geo_centroidPoint,                                                                                       // 2155
    lineStart: d3_geo_centroidLineStart,                                                                               // 2156
    lineEnd: d3_geo_centroidLineEnd,                                                                                   // 2157
    polygonStart: function() {                                                                                         // 2158
      if (d3_geo_centroidDimension < 2) {                                                                              // 2159
        d3_geo_centroidDimension = 2;                                                                                  // 2160
        d3_geo_centroidW = d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                                 // 2161
      }                                                                                                                // 2162
      d3_geo_centroid.lineStart = d3_geo_centroidRingStart;                                                            // 2163
    },                                                                                                                 // 2164
    polygonEnd: function() {                                                                                           // 2165
      d3_geo_centroid.lineStart = d3_geo_centroidLineStart;                                                            // 2166
    }                                                                                                                  // 2167
  };                                                                                                                   // 2168
  function d3_geo_centroidPoint(λ, φ) {                                                                                // 2169
    if (d3_geo_centroidDimension) return;                                                                              // 2170
    ++d3_geo_centroidW;                                                                                                // 2171
    λ *= d3_radians;                                                                                                   // 2172
    var cosφ = Math.cos(φ *= d3_radians);                                                                              // 2173
    d3_geo_centroidX += (cosφ * Math.cos(λ) - d3_geo_centroidX) / d3_geo_centroidW;                                    // 2174
    d3_geo_centroidY += (cosφ * Math.sin(λ) - d3_geo_centroidY) / d3_geo_centroidW;                                    // 2175
    d3_geo_centroidZ += (Math.sin(φ) - d3_geo_centroidZ) / d3_geo_centroidW;                                           // 2176
  }                                                                                                                    // 2177
  function d3_geo_centroidRingStart() {                                                                                // 2178
    var λ00, φ00;                                                                                                      // 2179
    d3_geo_centroidDimension = 1;                                                                                      // 2180
    d3_geo_centroidLineStart();                                                                                        // 2181
    d3_geo_centroidDimension = 2;                                                                                      // 2182
    var linePoint = d3_geo_centroid.point;                                                                             // 2183
    d3_geo_centroid.point = function(λ, φ) {                                                                           // 2184
      linePoint(λ00 = λ, φ00 = φ);                                                                                     // 2185
    };                                                                                                                 // 2186
    d3_geo_centroid.lineEnd = function() {                                                                             // 2187
      d3_geo_centroid.point(λ00, φ00);                                                                                 // 2188
      d3_geo_centroidLineEnd();                                                                                        // 2189
      d3_geo_centroid.lineEnd = d3_geo_centroidLineEnd;                                                                // 2190
    };                                                                                                                 // 2191
  }                                                                                                                    // 2192
  function d3_geo_centroidLineStart() {                                                                                // 2193
    var x0, y0, z0;                                                                                                    // 2194
    if (d3_geo_centroidDimension > 1) return;                                                                          // 2195
    if (d3_geo_centroidDimension < 1) {                                                                                // 2196
      d3_geo_centroidDimension = 1;                                                                                    // 2197
      d3_geo_centroidW = d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                                   // 2198
    }                                                                                                                  // 2199
    d3_geo_centroid.point = function(λ, φ) {                                                                           // 2200
      λ *= d3_radians;                                                                                                 // 2201
      var cosφ = Math.cos(φ *= d3_radians);                                                                            // 2202
      x0 = cosφ * Math.cos(λ);                                                                                         // 2203
      y0 = cosφ * Math.sin(λ);                                                                                         // 2204
      z0 = Math.sin(φ);                                                                                                // 2205
      d3_geo_centroid.point = nextPoint;                                                                               // 2206
    };                                                                                                                 // 2207
    function nextPoint(λ, φ) {                                                                                         // 2208
      λ *= d3_radians;                                                                                                 // 2209
      var cosφ = Math.cos(φ *= d3_radians), x = cosφ * Math.cos(λ), y = cosφ * Math.sin(λ), z = Math.sin(φ), w = Math.atan2(Math.sqrt((w = y0 * z - z0 * y) * w + (w = z0 * x - x0 * z) * w + (w = x0 * y - y0 * x) * w), x0 * x + y0 * y + z0 * z);
      d3_geo_centroidW += w;                                                                                           // 2211
      d3_geo_centroidX += w * (x0 + (x0 = x));                                                                         // 2212
      d3_geo_centroidY += w * (y0 + (y0 = y));                                                                         // 2213
      d3_geo_centroidZ += w * (z0 + (z0 = z));                                                                         // 2214
    }                                                                                                                  // 2215
  }                                                                                                                    // 2216
  function d3_geo_centroidLineEnd() {                                                                                  // 2217
    d3_geo_centroid.point = d3_geo_centroidPoint;                                                                      // 2218
  }                                                                                                                    // 2219
  function d3_geo_cartesian(spherical) {                                                                               // 2220
    var λ = spherical[0], φ = spherical[1], cosφ = Math.cos(φ);                                                        // 2221
    return [ cosφ * Math.cos(λ), cosφ * Math.sin(λ), Math.sin(φ) ];                                                    // 2222
  }                                                                                                                    // 2223
  function d3_geo_cartesianDot(a, b) {                                                                                 // 2224
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];                                                                    // 2225
  }                                                                                                                    // 2226
  function d3_geo_cartesianCross(a, b) {                                                                               // 2227
    return [ a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0] ];                        // 2228
  }                                                                                                                    // 2229
  function d3_geo_cartesianAdd(a, b) {                                                                                 // 2230
    a[0] += b[0];                                                                                                      // 2231
    a[1] += b[1];                                                                                                      // 2232
    a[2] += b[2];                                                                                                      // 2233
  }                                                                                                                    // 2234
  function d3_geo_cartesianScale(vector, k) {                                                                          // 2235
    return [ vector[0] * k, vector[1] * k, vector[2] * k ];                                                            // 2236
  }                                                                                                                    // 2237
  function d3_geo_cartesianNormalize(d) {                                                                              // 2238
    var l = Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);                                                        // 2239
    d[0] /= l;                                                                                                         // 2240
    d[1] /= l;                                                                                                         // 2241
    d[2] /= l;                                                                                                         // 2242
  }                                                                                                                    // 2243
  function d3_true() {                                                                                                 // 2244
    return true;                                                                                                       // 2245
  }                                                                                                                    // 2246
  function d3_geo_spherical(cartesian) {                                                                               // 2247
    return [ Math.atan2(cartesian[1], cartesian[0]), Math.asin(Math.max(-1, Math.min(1, cartesian[2]))) ];             // 2248
  }                                                                                                                    // 2249
  function d3_geo_sphericalEqual(a, b) {                                                                               // 2250
    return Math.abs(a[0] - b[0]) < ε && Math.abs(a[1] - b[1]) < ε;                                                     // 2251
  }                                                                                                                    // 2252
  function d3_geo_clipPolygon(segments, compare, inside, interpolate, listener) {                                      // 2253
    var subject = [], clip = [];                                                                                       // 2254
    segments.forEach(function(segment) {                                                                               // 2255
      if ((n = segment.length - 1) <= 0) return;                                                                       // 2256
      var n, p0 = segment[0], p1 = segment[n];                                                                         // 2257
      if (d3_geo_sphericalEqual(p0, p1)) {                                                                             // 2258
        listener.lineStart();                                                                                          // 2259
        for (var i = 0; i < n; ++i) listener.point((p0 = segment[i])[0], p0[1]);                                       // 2260
        listener.lineEnd();                                                                                            // 2261
        return;                                                                                                        // 2262
      }                                                                                                                // 2263
      var a = {                                                                                                        // 2264
        point: p0,                                                                                                     // 2265
        points: segment,                                                                                               // 2266
        other: null,                                                                                                   // 2267
        visited: false,                                                                                                // 2268
        entry: true,                                                                                                   // 2269
        subject: true                                                                                                  // 2270
      }, b = {                                                                                                         // 2271
        point: p0,                                                                                                     // 2272
        points: [ p0 ],                                                                                                // 2273
        other: a,                                                                                                      // 2274
        visited: false,                                                                                                // 2275
        entry: false,                                                                                                  // 2276
        subject: false                                                                                                 // 2277
      };                                                                                                               // 2278
      a.other = b;                                                                                                     // 2279
      subject.push(a);                                                                                                 // 2280
      clip.push(b);                                                                                                    // 2281
      a = {                                                                                                            // 2282
        point: p1,                                                                                                     // 2283
        points: [ p1 ],                                                                                                // 2284
        other: null,                                                                                                   // 2285
        visited: false,                                                                                                // 2286
        entry: false,                                                                                                  // 2287
        subject: true                                                                                                  // 2288
      };                                                                                                               // 2289
      b = {                                                                                                            // 2290
        point: p1,                                                                                                     // 2291
        points: [ p1 ],                                                                                                // 2292
        other: a,                                                                                                      // 2293
        visited: false,                                                                                                // 2294
        entry: true,                                                                                                   // 2295
        subject: false                                                                                                 // 2296
      };                                                                                                               // 2297
      a.other = b;                                                                                                     // 2298
      subject.push(a);                                                                                                 // 2299
      clip.push(b);                                                                                                    // 2300
    });                                                                                                                // 2301
    clip.sort(compare);                                                                                                // 2302
    d3_geo_clipPolygonLinkCircular(subject);                                                                           // 2303
    d3_geo_clipPolygonLinkCircular(clip);                                                                              // 2304
    if (!subject.length) return;                                                                                       // 2305
    if (inside) for (var i = 1, e = !inside(clip[0].point), n = clip.length; i < n; ++i) {                             // 2306
      clip[i].entry = e = !e;                                                                                          // 2307
    }                                                                                                                  // 2308
    var start = subject[0], current, points, point;                                                                    // 2309
    while (1) {                                                                                                        // 2310
      current = start;                                                                                                 // 2311
      while (current.visited) if ((current = current.next) === start) return;                                          // 2312
      points = current.points;                                                                                         // 2313
      listener.lineStart();                                                                                            // 2314
      do {                                                                                                             // 2315
        current.visited = current.other.visited = true;                                                                // 2316
        if (current.entry) {                                                                                           // 2317
          if (current.subject) {                                                                                       // 2318
            for (var i = 0; i < points.length; i++) listener.point((point = points[i])[0], point[1]);                  // 2319
          } else {                                                                                                     // 2320
            interpolate(current.point, current.next.point, 1, listener);                                               // 2321
          }                                                                                                            // 2322
          current = current.next;                                                                                      // 2323
        } else {                                                                                                       // 2324
          if (current.subject) {                                                                                       // 2325
            points = current.prev.points;                                                                              // 2326
            for (var i = points.length; --i >= 0; ) listener.point((point = points[i])[0], point[1]);                  // 2327
          } else {                                                                                                     // 2328
            interpolate(current.point, current.prev.point, -1, listener);                                              // 2329
          }                                                                                                            // 2330
          current = current.prev;                                                                                      // 2331
        }                                                                                                              // 2332
        current = current.other;                                                                                       // 2333
        points = current.points;                                                                                       // 2334
      } while (!current.visited);                                                                                      // 2335
      listener.lineEnd();                                                                                              // 2336
    }                                                                                                                  // 2337
  }                                                                                                                    // 2338
  function d3_geo_clipPolygonLinkCircular(array) {                                                                     // 2339
    if (!(n = array.length)) return;                                                                                   // 2340
    var n, i = 0, a = array[0], b;                                                                                     // 2341
    while (++i < n) {                                                                                                  // 2342
      a.next = b = array[i];                                                                                           // 2343
      b.prev = a;                                                                                                      // 2344
      a = b;                                                                                                           // 2345
    }                                                                                                                  // 2346
    a.next = b = array[0];                                                                                             // 2347
    b.prev = a;                                                                                                        // 2348
  }                                                                                                                    // 2349
  function d3_geo_clip(pointVisible, clipLine, interpolate) {                                                          // 2350
    return function(listener) {                                                                                        // 2351
      var line = clipLine(listener);                                                                                   // 2352
      var clip = {                                                                                                     // 2353
        point: point,                                                                                                  // 2354
        lineStart: lineStart,                                                                                          // 2355
        lineEnd: lineEnd,                                                                                              // 2356
        polygonStart: function() {                                                                                     // 2357
          clip.point = pointRing;                                                                                      // 2358
          clip.lineStart = ringStart;                                                                                  // 2359
          clip.lineEnd = ringEnd;                                                                                      // 2360
          invisible = false;                                                                                           // 2361
          invisibleArea = visibleArea = 0;                                                                             // 2362
          segments = [];                                                                                               // 2363
          listener.polygonStart();                                                                                     // 2364
        },                                                                                                             // 2365
        polygonEnd: function() {                                                                                       // 2366
          clip.point = point;                                                                                          // 2367
          clip.lineStart = lineStart;                                                                                  // 2368
          clip.lineEnd = lineEnd;                                                                                      // 2369
          segments = d3.merge(segments);                                                                               // 2370
          if (segments.length) {                                                                                       // 2371
            d3_geo_clipPolygon(segments, d3_geo_clipSort, null, interpolate, listener);                                // 2372
          } else if (visibleArea < -ε || invisible && invisibleArea < -ε) {                                            // 2373
            listener.lineStart();                                                                                      // 2374
            interpolate(null, null, 1, listener);                                                                      // 2375
            listener.lineEnd();                                                                                        // 2376
          }                                                                                                            // 2377
          listener.polygonEnd();                                                                                       // 2378
          segments = null;                                                                                             // 2379
        },                                                                                                             // 2380
        sphere: function() {                                                                                           // 2381
          listener.polygonStart();                                                                                     // 2382
          listener.lineStart();                                                                                        // 2383
          interpolate(null, null, 1, listener);                                                                        // 2384
          listener.lineEnd();                                                                                          // 2385
          listener.polygonEnd();                                                                                       // 2386
        }                                                                                                              // 2387
      };                                                                                                               // 2388
      function point(λ, φ) {                                                                                           // 2389
        if (pointVisible(λ, φ)) listener.point(λ, φ);                                                                  // 2390
      }                                                                                                                // 2391
      function pointLine(λ, φ) {                                                                                       // 2392
        line.point(λ, φ);                                                                                              // 2393
      }                                                                                                                // 2394
      function lineStart() {                                                                                           // 2395
        clip.point = pointLine;                                                                                        // 2396
        line.lineStart();                                                                                              // 2397
      }                                                                                                                // 2398
      function lineEnd() {                                                                                             // 2399
        clip.point = point;                                                                                            // 2400
        line.lineEnd();                                                                                                // 2401
      }                                                                                                                // 2402
      var segments, visibleArea, invisibleArea, invisible;                                                             // 2403
      var buffer = d3_geo_clipBufferListener(), ringListener = clipLine(buffer), ring;                                 // 2404
      function pointRing(λ, φ) {                                                                                       // 2405
        ringListener.point(λ, φ);                                                                                      // 2406
        ring.push([ λ, φ ]);                                                                                           // 2407
      }                                                                                                                // 2408
      function ringStart() {                                                                                           // 2409
        ringListener.lineStart();                                                                                      // 2410
        ring = [];                                                                                                     // 2411
      }                                                                                                                // 2412
      function ringEnd() {                                                                                             // 2413
        pointRing(ring[0][0], ring[0][1]);                                                                             // 2414
        ringListener.lineEnd();                                                                                        // 2415
        var clean = ringListener.clean(), ringSegments = buffer.buffer(), segment, n = ringSegments.length;            // 2416
        if (!n) {                                                                                                      // 2417
          invisible = true;                                                                                            // 2418
          invisibleArea += d3_geo_clipAreaRing(ring, -1);                                                              // 2419
          ring = null;                                                                                                 // 2420
          return;                                                                                                      // 2421
        }                                                                                                              // 2422
        ring = null;                                                                                                   // 2423
        if (clean & 1) {                                                                                               // 2424
          segment = ringSegments[0];                                                                                   // 2425
          visibleArea += d3_geo_clipAreaRing(segment, 1);                                                              // 2426
          var n = segment.length - 1, i = -1, point;                                                                   // 2427
          listener.lineStart();                                                                                        // 2428
          while (++i < n) listener.point((point = segment[i])[0], point[1]);                                           // 2429
          listener.lineEnd();                                                                                          // 2430
          return;                                                                                                      // 2431
        }                                                                                                              // 2432
        if (n > 1 && clean & 2) ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));                    // 2433
        segments.push(ringSegments.filter(d3_geo_clipSegmentLength1));                                                 // 2434
      }                                                                                                                // 2435
      return clip;                                                                                                     // 2436
    };                                                                                                                 // 2437
  }                                                                                                                    // 2438
  function d3_geo_clipSegmentLength1(segment) {                                                                        // 2439
    return segment.length > 1;                                                                                         // 2440
  }                                                                                                                    // 2441
  function d3_geo_clipBufferListener() {                                                                               // 2442
    var lines = [], line;                                                                                              // 2443
    return {                                                                                                           // 2444
      lineStart: function() {                                                                                          // 2445
        lines.push(line = []);                                                                                         // 2446
      },                                                                                                               // 2447
      point: function(λ, φ) {                                                                                          // 2448
        line.push([ λ, φ ]);                                                                                           // 2449
      },                                                                                                               // 2450
      lineEnd: d3_noop,                                                                                                // 2451
      buffer: function() {                                                                                             // 2452
        var buffer = lines;                                                                                            // 2453
        lines = [];                                                                                                    // 2454
        line = null;                                                                                                   // 2455
        return buffer;                                                                                                 // 2456
      },                                                                                                               // 2457
      rejoin: function() {                                                                                             // 2458
        if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));                                           // 2459
      }                                                                                                                // 2460
    };                                                                                                                 // 2461
  }                                                                                                                    // 2462
  function d3_geo_clipAreaRing(ring, invisible) {                                                                      // 2463
    if (!(n = ring.length)) return 0;                                                                                  // 2464
    var n, i = 0, area = 0, p = ring[0], λ = p[0], φ = p[1], cosφ = Math.cos(φ), x0 = Math.atan2(invisible * Math.sin(λ) * cosφ, Math.sin(φ)), y0 = 1 - invisible * Math.cos(λ) * cosφ, x1 = x0, x, y;
    while (++i < n) {                                                                                                  // 2466
      p = ring[i];                                                                                                     // 2467
      cosφ = Math.cos(φ = p[1]);                                                                                       // 2468
      x = Math.atan2(invisible * Math.sin(λ = p[0]) * cosφ, Math.sin(φ));                                              // 2469
      y = 1 - invisible * Math.cos(λ) * cosφ;                                                                          // 2470
      if (Math.abs(y0 - 2) < ε && Math.abs(y - 2) < ε) continue;                                                       // 2471
      if (Math.abs(y) < ε || Math.abs(y0) < ε) {} else if (Math.abs(Math.abs(x - x0) - π) < ε) {                       // 2472
        if (y + y0 > 2) area += 4 * (x - x0);                                                                          // 2473
      } else if (Math.abs(y0 - 2) < ε) area += 4 * (x - x1); else area += ((3 * π + x - x0) % (2 * π) - π) * (y0 + y); // 2474
      x1 = x0, x0 = x, y0 = y;                                                                                         // 2475
    }                                                                                                                  // 2476
    return area;                                                                                                       // 2477
  }                                                                                                                    // 2478
  function d3_geo_clipSort(a, b) {                                                                                     // 2479
    return ((a = a.point)[0] < 0 ? a[1] - π / 2 - ε : π / 2 - a[1]) - ((b = b.point)[0] < 0 ? b[1] - π / 2 - ε : π / 2 - b[1]);
  }                                                                                                                    // 2481
  var d3_geo_clipAntimeridian = d3_geo_clip(d3_true, d3_geo_clipAntimeridianLine, d3_geo_clipAntimeridianInterpolate); // 2482
  function d3_geo_clipAntimeridianLine(listener) {                                                                     // 2483
    var λ0 = NaN, φ0 = NaN, sλ0 = NaN, clean;                                                                          // 2484
    return {                                                                                                           // 2485
      lineStart: function() {                                                                                          // 2486
        listener.lineStart();                                                                                          // 2487
        clean = 1;                                                                                                     // 2488
      },                                                                                                               // 2489
      point: function(λ1, φ1) {                                                                                        // 2490
        var sλ1 = λ1 > 0 ? π : -π, dλ = Math.abs(λ1 - λ0);                                                             // 2491
        if (Math.abs(dλ - π) < ε) {                                                                                    // 2492
          listener.point(λ0, φ0 = (φ0 + φ1) / 2 > 0 ? π / 2 : -π / 2);                                                 // 2493
          listener.point(sλ0, φ0);                                                                                     // 2494
          listener.lineEnd();                                                                                          // 2495
          listener.lineStart();                                                                                        // 2496
          listener.point(sλ1, φ0);                                                                                     // 2497
          listener.point(λ1, φ0);                                                                                      // 2498
          clean = 0;                                                                                                   // 2499
        } else if (sλ0 !== sλ1 && dλ >= π) {                                                                           // 2500
          if (Math.abs(λ0 - sλ0) < ε) λ0 -= sλ0 * ε;                                                                   // 2501
          if (Math.abs(λ1 - sλ1) < ε) λ1 -= sλ1 * ε;                                                                   // 2502
          φ0 = d3_geo_clipAntimeridianIntersect(λ0, φ0, λ1, φ1);                                                       // 2503
          listener.point(sλ0, φ0);                                                                                     // 2504
          listener.lineEnd();                                                                                          // 2505
          listener.lineStart();                                                                                        // 2506
          listener.point(sλ1, φ0);                                                                                     // 2507
          clean = 0;                                                                                                   // 2508
        }                                                                                                              // 2509
        listener.point(λ0 = λ1, φ0 = φ1);                                                                              // 2510
        sλ0 = sλ1;                                                                                                     // 2511
      },                                                                                                               // 2512
      lineEnd: function() {                                                                                            // 2513
        listener.lineEnd();                                                                                            // 2514
        λ0 = φ0 = NaN;                                                                                                 // 2515
      },                                                                                                               // 2516
      clean: function() {                                                                                              // 2517
        return 2 - clean;                                                                                              // 2518
      }                                                                                                                // 2519
    };                                                                                                                 // 2520
  }                                                                                                                    // 2521
  function d3_geo_clipAntimeridianIntersect(λ0, φ0, λ1, φ1) {                                                          // 2522
    var cosφ0, cosφ1, sinλ0_λ1 = Math.sin(λ0 - λ1);                                                                    // 2523
    return Math.abs(sinλ0_λ1) > ε ? Math.atan((Math.sin(φ0) * (cosφ1 = Math.cos(φ1)) * Math.sin(λ1) - Math.sin(φ1) * (cosφ0 = Math.cos(φ0)) * Math.sin(λ0)) / (cosφ0 * cosφ1 * sinλ0_λ1)) : (φ0 + φ1) / 2;
  }                                                                                                                    // 2525
  function d3_geo_clipAntimeridianInterpolate(from, to, direction, listener) {                                         // 2526
    var φ;                                                                                                             // 2527
    if (from == null) {                                                                                                // 2528
      φ = direction * π / 2;                                                                                           // 2529
      listener.point(-π, φ);                                                                                           // 2530
      listener.point(0, φ);                                                                                            // 2531
      listener.point(π, φ);                                                                                            // 2532
      listener.point(π, 0);                                                                                            // 2533
      listener.point(π, -φ);                                                                                           // 2534
      listener.point(0, -φ);                                                                                           // 2535
      listener.point(-π, -φ);                                                                                          // 2536
      listener.point(-π, 0);                                                                                           // 2537
      listener.point(-π, φ);                                                                                           // 2538
    } else if (Math.abs(from[0] - to[0]) > ε) {                                                                        // 2539
      var s = (from[0] < to[0] ? 1 : -1) * π;                                                                          // 2540
      φ = direction * s / 2;                                                                                           // 2541
      listener.point(-s, φ);                                                                                           // 2542
      listener.point(0, φ);                                                                                            // 2543
      listener.point(s, φ);                                                                                            // 2544
    } else {                                                                                                           // 2545
      listener.point(to[0], to[1]);                                                                                    // 2546
    }                                                                                                                  // 2547
  }                                                                                                                    // 2548
  function d3_geo_clipCircle(radius) {                                                                                 // 2549
    var cr = Math.cos(radius), smallRadius = cr > 0, notHemisphere = Math.abs(cr) > ε, interpolate = d3_geo_circleInterpolate(radius, 6 * d3_radians);
    return d3_geo_clip(visible, clipLine, interpolate);                                                                // 2551
    function visible(λ, φ) {                                                                                           // 2552
      return Math.cos(λ) * Math.cos(φ) > cr;                                                                           // 2553
    }                                                                                                                  // 2554
    function clipLine(listener) {                                                                                      // 2555
      var point0, c0, v0, v00, clean;                                                                                  // 2556
      return {                                                                                                         // 2557
        lineStart: function() {                                                                                        // 2558
          v00 = v0 = false;                                                                                            // 2559
          clean = 1;                                                                                                   // 2560
        },                                                                                                             // 2561
        point: function(λ, φ) {                                                                                        // 2562
          var point1 = [ λ, φ ], point2, v = visible(λ, φ), c = smallRadius ? v ? 0 : code(λ, φ) : v ? code(λ + (λ < 0 ? π : -π), φ) : 0;
          if (!point0 && (v00 = v0 = v)) listener.lineStart();                                                         // 2564
          if (v !== v0) {                                                                                              // 2565
            point2 = intersect(point0, point1);                                                                        // 2566
            if (d3_geo_sphericalEqual(point0, point2) || d3_geo_sphericalEqual(point1, point2)) {                      // 2567
              point1[0] += ε;                                                                                          // 2568
              point1[1] += ε;                                                                                          // 2569
              v = visible(point1[0], point1[1]);                                                                       // 2570
            }                                                                                                          // 2571
          }                                                                                                            // 2572
          if (v !== v0) {                                                                                              // 2573
            clean = 0;                                                                                                 // 2574
            if (v) {                                                                                                   // 2575
              listener.lineStart();                                                                                    // 2576
              point2 = intersect(point1, point0);                                                                      // 2577
              listener.point(point2[0], point2[1]);                                                                    // 2578
            } else {                                                                                                   // 2579
              point2 = intersect(point0, point1);                                                                      // 2580
              listener.point(point2[0], point2[1]);                                                                    // 2581
              listener.lineEnd();                                                                                      // 2582
            }                                                                                                          // 2583
            point0 = point2;                                                                                           // 2584
          } else if (notHemisphere && point0 && smallRadius ^ v) {                                                     // 2585
            var t;                                                                                                     // 2586
            if (!(c & c0) && (t = intersect(point1, point0, true))) {                                                  // 2587
              clean = 0;                                                                                               // 2588
              if (smallRadius) {                                                                                       // 2589
                listener.lineStart();                                                                                  // 2590
                listener.point(t[0][0], t[0][1]);                                                                      // 2591
                listener.point(t[1][0], t[1][1]);                                                                      // 2592
                listener.lineEnd();                                                                                    // 2593
              } else {                                                                                                 // 2594
                listener.point(t[1][0], t[1][1]);                                                                      // 2595
                listener.lineEnd();                                                                                    // 2596
                listener.lineStart();                                                                                  // 2597
                listener.point(t[0][0], t[0][1]);                                                                      // 2598
              }                                                                                                        // 2599
            }                                                                                                          // 2600
          }                                                                                                            // 2601
          if (v && (!point0 || !d3_geo_sphericalEqual(point0, point1))) {                                              // 2602
            listener.point(point1[0], point1[1]);                                                                      // 2603
          }                                                                                                            // 2604
          point0 = point1, v0 = v, c0 = c;                                                                             // 2605
        },                                                                                                             // 2606
        lineEnd: function() {                                                                                          // 2607
          if (v0) listener.lineEnd();                                                                                  // 2608
          point0 = null;                                                                                               // 2609
        },                                                                                                             // 2610
        clean: function() {                                                                                            // 2611
          return clean | (v00 && v0) << 1;                                                                             // 2612
        }                                                                                                              // 2613
      };                                                                                                               // 2614
    }                                                                                                                  // 2615
    function intersect(a, b, two) {                                                                                    // 2616
      var pa = d3_geo_cartesian(a), pb = d3_geo_cartesian(b);                                                          // 2617
      var n1 = [ 1, 0, 0 ], n2 = d3_geo_cartesianCross(pa, pb), n2n2 = d3_geo_cartesianDot(n2, n2), n1n2 = n2[0], determinant = n2n2 - n1n2 * n1n2;
      if (!determinant) return !two && a;                                                                              // 2619
      var c1 = cr * n2n2 / determinant, c2 = -cr * n1n2 / determinant, n1xn2 = d3_geo_cartesianCross(n1, n2), A = d3_geo_cartesianScale(n1, c1), B = d3_geo_cartesianScale(n2, c2);
      d3_geo_cartesianAdd(A, B);                                                                                       // 2621
      var u = n1xn2, w = d3_geo_cartesianDot(A, u), uu = d3_geo_cartesianDot(u, u), t2 = w * w - uu * (d3_geo_cartesianDot(A, A) - 1);
      if (t2 < 0) return;                                                                                              // 2623
      var t = Math.sqrt(t2), q = d3_geo_cartesianScale(u, (-w - t) / uu);                                              // 2624
      d3_geo_cartesianAdd(q, A);                                                                                       // 2625
      q = d3_geo_spherical(q);                                                                                         // 2626
      if (!two) return q;                                                                                              // 2627
      var λ0 = a[0], λ1 = b[0], φ0 = a[1], φ1 = b[1], z;                                                               // 2628
      if (λ1 < λ0) z = λ0, λ0 = λ1, λ1 = z;                                                                            // 2629
      var δλ = λ1 - λ0, polar = Math.abs(δλ - π) < ε, meridian = polar || δλ < ε;                                      // 2630
      if (!polar && φ1 < φ0) z = φ0, φ0 = φ1, φ1 = z;                                                                  // 2631
      if (meridian ? polar ? φ0 + φ1 > 0 ^ q[1] < (Math.abs(q[0] - λ0) < ε ? φ0 : φ1) : φ0 <= q[1] && q[1] <= φ1 : δλ > π ^ (λ0 <= q[0] && q[0] <= λ1)) {
        var q1 = d3_geo_cartesianScale(u, (-w + t) / uu);                                                              // 2633
        d3_geo_cartesianAdd(q1, A);                                                                                    // 2634
        return [ q, d3_geo_spherical(q1) ];                                                                            // 2635
      }                                                                                                                // 2636
    }                                                                                                                  // 2637
    function code(λ, φ) {                                                                                              // 2638
      var r = smallRadius ? radius : π - radius, code = 0;                                                             // 2639
      if (λ < -r) code |= 1; else if (λ > r) code |= 2;                                                                // 2640
      if (φ < -r) code |= 4; else if (φ > r) code |= 8;                                                                // 2641
      return code;                                                                                                     // 2642
    }                                                                                                                  // 2643
  }                                                                                                                    // 2644
  var d3_geo_clipViewMAX = 1e9;                                                                                        // 2645
  function d3_geo_clipView(x0, y0, x1, y1) {                                                                           // 2646
    return function(listener) {                                                                                        // 2647
      var listener_ = listener, bufferListener = d3_geo_clipBufferListener(), segments, polygon, ring;                 // 2648
      var clip = {                                                                                                     // 2649
        point: point,                                                                                                  // 2650
        lineStart: lineStart,                                                                                          // 2651
        lineEnd: lineEnd,                                                                                              // 2652
        polygonStart: function() {                                                                                     // 2653
          listener = bufferListener;                                                                                   // 2654
          segments = [];                                                                                               // 2655
          polygon = [];                                                                                                // 2656
        },                                                                                                             // 2657
        polygonEnd: function() {                                                                                       // 2658
          listener = listener_;                                                                                        // 2659
          if ((segments = d3.merge(segments)).length) {                                                                // 2660
            listener.polygonStart();                                                                                   // 2661
            d3_geo_clipPolygon(segments, compare, inside, interpolate, listener);                                      // 2662
            listener.polygonEnd();                                                                                     // 2663
          } else if (insidePolygon([ x0, y0 ])) {                                                                      // 2664
            listener.polygonStart(), listener.lineStart();                                                             // 2665
            interpolate(null, null, 1, listener);                                                                      // 2666
            listener.lineEnd(), listener.polygonEnd();                                                                 // 2667
          }                                                                                                            // 2668
          segments = polygon = ring = null;                                                                            // 2669
        }                                                                                                              // 2670
      };                                                                                                               // 2671
      function inside(point) {                                                                                         // 2672
        var a = corner(point, -1), i = insidePolygon([ a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0 ]);               // 2673
        return i;                                                                                                      // 2674
      }                                                                                                                // 2675
      function insidePolygon(p) {                                                                                      // 2676
        var wn = 0, n = polygon.length, y = p[1];                                                                      // 2677
        for (var i = 0; i < n; ++i) {                                                                                  // 2678
          for (var j = 1, v = polygon[i], m = v.length, a = v[0]; j < m; ++j) {                                        // 2679
            b = v[j];                                                                                                  // 2680
            if (a[1] <= y) {                                                                                           // 2681
              if (b[1] > y && isLeft(a, b, p) > 0) ++wn;                                                               // 2682
            } else {                                                                                                   // 2683
              if (b[1] <= y && isLeft(a, b, p) < 0) --wn;                                                              // 2684
            }                                                                                                          // 2685
            a = b;                                                                                                     // 2686
          }                                                                                                            // 2687
        }                                                                                                              // 2688
        return wn !== 0;                                                                                               // 2689
      }                                                                                                                // 2690
      function isLeft(a, b, c) {                                                                                       // 2691
        return (b[0] - a[0]) * (c[1] - a[1]) - (c[0] - a[0]) * (b[1] - a[1]);                                          // 2692
      }                                                                                                                // 2693
      function interpolate(from, to, direction, listener) {                                                            // 2694
        var a = 0, a1 = 0;                                                                                             // 2695
        if (from == null || (a = corner(from, direction)) !== (a1 = corner(to, direction)) || comparePoints(from, to) < 0 ^ direction > 0) {
          do {                                                                                                         // 2697
            listener.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0);                                             // 2698
          } while ((a = (a + direction + 4) % 4) !== a1);                                                              // 2699
        } else {                                                                                                       // 2700
          listener.point(to[0], to[1]);                                                                                // 2701
        }                                                                                                              // 2702
      }                                                                                                                // 2703
      function visible(x, y) {                                                                                         // 2704
        return x0 <= x && x <= x1 && y0 <= y && y <= y1;                                                               // 2705
      }                                                                                                                // 2706
      function point(x, y) {                                                                                           // 2707
        if (visible(x, y)) listener.point(x, y);                                                                       // 2708
      }                                                                                                                // 2709
      var x__, y__, v__, x_, y_, v_, first;                                                                            // 2710
      function lineStart() {                                                                                           // 2711
        clip.point = linePoint;                                                                                        // 2712
        if (polygon) polygon.push(ring = []);                                                                          // 2713
        first = true;                                                                                                  // 2714
        v_ = false;                                                                                                    // 2715
        x_ = y_ = NaN;                                                                                                 // 2716
      }                                                                                                                // 2717
      function lineEnd() {                                                                                             // 2718
        if (segments) {                                                                                                // 2719
          linePoint(x__, y__);                                                                                         // 2720
          if (v__ && v_) bufferListener.rejoin();                                                                      // 2721
          segments.push(bufferListener.buffer());                                                                      // 2722
        }                                                                                                              // 2723
        clip.point = point;                                                                                            // 2724
        if (v_) listener.lineEnd();                                                                                    // 2725
      }                                                                                                                // 2726
      function linePoint(x, y) {                                                                                       // 2727
        x = Math.max(-d3_geo_clipViewMAX, Math.min(d3_geo_clipViewMAX, x));                                            // 2728
        y = Math.max(-d3_geo_clipViewMAX, Math.min(d3_geo_clipViewMAX, y));                                            // 2729
        var v = visible(x, y);                                                                                         // 2730
        if (polygon) ring.push([ x, y ]);                                                                              // 2731
        if (first) {                                                                                                   // 2732
          x__ = x, y__ = y, v__ = v;                                                                                   // 2733
          first = false;                                                                                               // 2734
          if (v) {                                                                                                     // 2735
            listener.lineStart();                                                                                      // 2736
            listener.point(x, y);                                                                                      // 2737
          }                                                                                                            // 2738
        } else {                                                                                                       // 2739
          if (v && v_) listener.point(x, y); else {                                                                    // 2740
            var a = [ x_, y_ ], b = [ x, y ];                                                                          // 2741
            if (clipLine(a, b)) {                                                                                      // 2742
              if (!v_) {                                                                                               // 2743
                listener.lineStart();                                                                                  // 2744
                listener.point(a[0], a[1]);                                                                            // 2745
              }                                                                                                        // 2746
              listener.point(b[0], b[1]);                                                                              // 2747
              if (!v) listener.lineEnd();                                                                              // 2748
            } else {                                                                                                   // 2749
              listener.lineStart();                                                                                    // 2750
              listener.point(x, y);                                                                                    // 2751
            }                                                                                                          // 2752
          }                                                                                                            // 2753
        }                                                                                                              // 2754
        x_ = x, y_ = y, v_ = v;                                                                                        // 2755
      }                                                                                                                // 2756
      return clip;                                                                                                     // 2757
    };                                                                                                                 // 2758
    function corner(p, direction) {                                                                                    // 2759
      return Math.abs(p[0] - x0) < ε ? direction > 0 ? 0 : 3 : Math.abs(p[0] - x1) < ε ? direction > 0 ? 2 : 1 : Math.abs(p[1] - y0) < ε ? direction > 0 ? 1 : 0 : direction > 0 ? 3 : 2;
    }                                                                                                                  // 2761
    function compare(a, b) {                                                                                           // 2762
      return comparePoints(a.point, b.point);                                                                          // 2763
    }                                                                                                                  // 2764
    function comparePoints(a, b) {                                                                                     // 2765
      var ca = corner(a, 1), cb = corner(b, 1);                                                                        // 2766
      return ca !== cb ? ca - cb : ca === 0 ? b[1] - a[1] : ca === 1 ? a[0] - b[0] : ca === 2 ? a[1] - b[1] : b[0] - a[0];
    }                                                                                                                  // 2768
    function clipLine(a, b) {                                                                                          // 2769
      var dx = b[0] - a[0], dy = b[1] - a[1], t = [ 0, 1 ];                                                            // 2770
      if (Math.abs(dx) < ε && Math.abs(dy) < ε) return x0 <= a[0] && a[0] <= x1 && y0 <= a[1] && a[1] <= y1;           // 2771
      if (d3_geo_clipViewT(x0 - a[0], dx, t) && d3_geo_clipViewT(a[0] - x1, -dx, t) && d3_geo_clipViewT(y0 - a[1], dy, t) && d3_geo_clipViewT(a[1] - y1, -dy, t)) {
        if (t[1] < 1) {                                                                                                // 2773
          b[0] = a[0] + t[1] * dx;                                                                                     // 2774
          b[1] = a[1] + t[1] * dy;                                                                                     // 2775
        }                                                                                                              // 2776
        if (t[0] > 0) {                                                                                                // 2777
          a[0] += t[0] * dx;                                                                                           // 2778
          a[1] += t[0] * dy;                                                                                           // 2779
        }                                                                                                              // 2780
        return true;                                                                                                   // 2781
      }                                                                                                                // 2782
      return false;                                                                                                    // 2783
    }                                                                                                                  // 2784
  }                                                                                                                    // 2785
  function d3_geo_clipViewT(num, denominator, t) {                                                                     // 2786
    if (Math.abs(denominator) < ε) return num <= 0;                                                                    // 2787
    var u = num / denominator;                                                                                         // 2788
    if (denominator > 0) {                                                                                             // 2789
      if (u > t[1]) return false;                                                                                      // 2790
      if (u > t[0]) t[0] = u;                                                                                          // 2791
    } else {                                                                                                           // 2792
      if (u < t[0]) return false;                                                                                      // 2793
      if (u < t[1]) t[1] = u;                                                                                          // 2794
    }                                                                                                                  // 2795
    return true;                                                                                                       // 2796
  }                                                                                                                    // 2797
  function d3_geo_compose(a, b) {                                                                                      // 2798
    function compose(x, y) {                                                                                           // 2799
      return x = a(x, y), b(x[0], x[1]);                                                                               // 2800
    }                                                                                                                  // 2801
    if (a.invert && b.invert) compose.invert = function(x, y) {                                                        // 2802
      return x = b.invert(x, y), x && a.invert(x[0], x[1]);                                                            // 2803
    };                                                                                                                 // 2804
    return compose;                                                                                                    // 2805
  }                                                                                                                    // 2806
  function d3_geo_resample(project) {                                                                                  // 2807
    var δ2 = .5, maxDepth = 16;                                                                                        // 2808
    function resample(stream) {                                                                                        // 2809
      var λ0, x0, y0, a0, b0, c0;                                                                                      // 2810
      var resample = {                                                                                                 // 2811
        point: point,                                                                                                  // 2812
        lineStart: lineStart,                                                                                          // 2813
        lineEnd: lineEnd,                                                                                              // 2814
        polygonStart: function() {                                                                                     // 2815
          stream.polygonStart();                                                                                       // 2816
          resample.lineStart = polygonLineStart;                                                                       // 2817
        },                                                                                                             // 2818
        polygonEnd: function() {                                                                                       // 2819
          stream.polygonEnd();                                                                                         // 2820
          resample.lineStart = lineStart;                                                                              // 2821
        }                                                                                                              // 2822
      };                                                                                                               // 2823
      function point(x, y) {                                                                                           // 2824
        x = project(x, y);                                                                                             // 2825
        stream.point(x[0], x[1]);                                                                                      // 2826
      }                                                                                                                // 2827
      function lineStart() {                                                                                           // 2828
        x0 = NaN;                                                                                                      // 2829
        resample.point = linePoint;                                                                                    // 2830
        stream.lineStart();                                                                                            // 2831
      }                                                                                                                // 2832
      function linePoint(λ, φ) {                                                                                       // 2833
        var c = d3_geo_cartesian([ λ, φ ]), p = project(λ, φ);                                                         // 2834
        resampleLineTo(x0, y0, λ0, a0, b0, c0, x0 = p[0], y0 = p[1], λ0 = λ, a0 = c[0], b0 = c[1], c0 = c[2], maxDepth, stream);
        stream.point(x0, y0);                                                                                          // 2836
      }                                                                                                                // 2837
      function lineEnd() {                                                                                             // 2838
        resample.point = point;                                                                                        // 2839
        stream.lineEnd();                                                                                              // 2840
      }                                                                                                                // 2841
      function polygonLineStart() {                                                                                    // 2842
        var λ00, φ00, x00, y00, a00, b00, c00;                                                                         // 2843
        lineStart();                                                                                                   // 2844
        resample.point = function(λ, φ) {                                                                              // 2845
          linePoint(λ00 = λ, φ00 = φ), x00 = x0, y00 = y0, a00 = a0, b00 = b0, c00 = c0;                               // 2846
          resample.point = linePoint;                                                                                  // 2847
        };                                                                                                             // 2848
        resample.lineEnd = function() {                                                                                // 2849
          resampleLineTo(x0, y0, λ0, a0, b0, c0, x00, y00, λ00, a00, b00, c00, maxDepth, stream);                      // 2850
          resample.lineEnd = lineEnd;                                                                                  // 2851
          lineEnd();                                                                                                   // 2852
        };                                                                                                             // 2853
      }                                                                                                                // 2854
      return resample;                                                                                                 // 2855
    }                                                                                                                  // 2856
    function resampleLineTo(x0, y0, λ0, a0, b0, c0, x1, y1, λ1, a1, b1, c1, depth, stream) {                           // 2857
      var dx = x1 - x0, dy = y1 - y0, d2 = dx * dx + dy * dy;                                                          // 2858
      if (d2 > 4 * δ2 && depth--) {                                                                                    // 2859
        var a = a0 + a1, b = b0 + b1, c = c0 + c1, m = Math.sqrt(a * a + b * b + c * c), φ2 = Math.asin(c /= m), λ2 = Math.abs(Math.abs(c) - 1) < ε ? (λ0 + λ1) / 2 : Math.atan2(b, a), p = project(λ2, φ2), x2 = p[0], y2 = p[1], dx2 = x2 - x0, dy2 = y2 - y0, dz = dy * dx2 - dx * dy2;
        if (dz * dz / d2 > δ2 || Math.abs((dx * dx2 + dy * dy2) / d2 - .5) > .3) {                                     // 2861
          resampleLineTo(x0, y0, λ0, a0, b0, c0, x2, y2, λ2, a /= m, b /= m, c, depth, stream);                        // 2862
          stream.point(x2, y2);                                                                                        // 2863
          resampleLineTo(x2, y2, λ2, a, b, c, x1, y1, λ1, a1, b1, c1, depth, stream);                                  // 2864
        }                                                                                                              // 2865
      }                                                                                                                // 2866
    }                                                                                                                  // 2867
    resample.precision = function(_) {                                                                                 // 2868
      if (!arguments.length) return Math.sqrt(δ2);                                                                     // 2869
      maxDepth = (δ2 = _ * _) > 0 && 16;                                                                               // 2870
      return resample;                                                                                                 // 2871
    };                                                                                                                 // 2872
    return resample;                                                                                                   // 2873
  }                                                                                                                    // 2874
  d3.geo.projection = d3_geo_projection;                                                                               // 2875
  d3.geo.projectionMutator = d3_geo_projectionMutator;                                                                 // 2876
  function d3_geo_projection(project) {                                                                                // 2877
    return d3_geo_projectionMutator(function() {                                                                       // 2878
      return project;                                                                                                  // 2879
    })();                                                                                                              // 2880
  }                                                                                                                    // 2881
  function d3_geo_projectionMutator(projectAt) {                                                                       // 2882
    var project, rotate, projectRotate, projectResample = d3_geo_resample(function(x, y) {                             // 2883
      x = project(x, y);                                                                                               // 2884
      return [ x[0] * k + δx, δy - x[1] * k ];                                                                         // 2885
    }), k = 150, x = 480, y = 250, λ = 0, φ = 0, δλ = 0, δφ = 0, δγ = 0, δx, δy, preclip = d3_geo_clipAntimeridian, postclip = d3_identity, clipAngle = null, clipExtent = null;
    function projection(point) {                                                                                       // 2887
      point = projectRotate(point[0] * d3_radians, point[1] * d3_radians);                                             // 2888
      return [ point[0] * k + δx, δy - point[1] * k ];                                                                 // 2889
    }                                                                                                                  // 2890
    function invert(point) {                                                                                           // 2891
      point = projectRotate.invert((point[0] - δx) / k, (δy - point[1]) / k);                                          // 2892
      return point && [ point[0] * d3_degrees, point[1] * d3_degrees ];                                                // 2893
    }                                                                                                                  // 2894
    projection.stream = function(stream) {                                                                             // 2895
      return d3_geo_projectionRadiansRotate(rotate, preclip(projectResample(postclip(stream))));                       // 2896
    };                                                                                                                 // 2897
    projection.clipAngle = function(_) {                                                                               // 2898
      if (!arguments.length) return clipAngle;                                                                         // 2899
      preclip = _ == null ? (clipAngle = _, d3_geo_clipAntimeridian) : d3_geo_clipCircle((clipAngle = +_) * d3_radians);
      return projection;                                                                                               // 2901
    };                                                                                                                 // 2902
    projection.clipExtent = function(_) {                                                                              // 2903
      if (!arguments.length) return clipExtent;                                                                        // 2904
      clipExtent = _;                                                                                                  // 2905
      postclip = _ == null ? d3_identity : d3_geo_clipView(_[0][0], _[0][1], _[1][0], _[1][1]);                        // 2906
      return projection;                                                                                               // 2907
    };                                                                                                                 // 2908
    projection.scale = function(_) {                                                                                   // 2909
      if (!arguments.length) return k;                                                                                 // 2910
      k = +_;                                                                                                          // 2911
      return reset();                                                                                                  // 2912
    };                                                                                                                 // 2913
    projection.translate = function(_) {                                                                               // 2914
      if (!arguments.length) return [ x, y ];                                                                          // 2915
      x = +_[0];                                                                                                       // 2916
      y = +_[1];                                                                                                       // 2917
      return reset();                                                                                                  // 2918
    };                                                                                                                 // 2919
    projection.center = function(_) {                                                                                  // 2920
      if (!arguments.length) return [ λ * d3_degrees, φ * d3_degrees ];                                                // 2921
      λ = _[0] % 360 * d3_radians;                                                                                     // 2922
      φ = _[1] % 360 * d3_radians;                                                                                     // 2923
      return reset();                                                                                                  // 2924
    };                                                                                                                 // 2925
    projection.rotate = function(_) {                                                                                  // 2926
      if (!arguments.length) return [ δλ * d3_degrees, δφ * d3_degrees, δγ * d3_degrees ];                             // 2927
      δλ = _[0] % 360 * d3_radians;                                                                                    // 2928
      δφ = _[1] % 360 * d3_radians;                                                                                    // 2929
      δγ = _.length > 2 ? _[2] % 360 * d3_radians : 0;                                                                 // 2930
      return reset();                                                                                                  // 2931
    };                                                                                                                 // 2932
    d3.rebind(projection, projectResample, "precision");                                                               // 2933
    function reset() {                                                                                                 // 2934
      projectRotate = d3_geo_compose(rotate = d3_geo_rotation(δλ, δφ, δγ), project);                                   // 2935
      var center = project(λ, φ);                                                                                      // 2936
      δx = x - center[0] * k;                                                                                          // 2937
      δy = y + center[1] * k;                                                                                          // 2938
      return projection;                                                                                               // 2939
    }                                                                                                                  // 2940
    return function() {                                                                                                // 2941
      project = projectAt.apply(this, arguments);                                                                      // 2942
      projection.invert = project.invert && invert;                                                                    // 2943
      return reset();                                                                                                  // 2944
    };                                                                                                                 // 2945
  }                                                                                                                    // 2946
  function d3_geo_projectionRadiansRotate(rotate, stream) {                                                            // 2947
    return {                                                                                                           // 2948
      point: function(x, y) {                                                                                          // 2949
        y = rotate(x * d3_radians, y * d3_radians), x = y[0];                                                          // 2950
        stream.point(x > π ? x - 2 * π : x < -π ? x + 2 * π : x, y[1]);                                                // 2951
      },                                                                                                               // 2952
      sphere: function() {                                                                                             // 2953
        stream.sphere();                                                                                               // 2954
      },                                                                                                               // 2955
      lineStart: function() {                                                                                          // 2956
        stream.lineStart();                                                                                            // 2957
      },                                                                                                               // 2958
      lineEnd: function() {                                                                                            // 2959
        stream.lineEnd();                                                                                              // 2960
      },                                                                                                               // 2961
      polygonStart: function() {                                                                                       // 2962
        stream.polygonStart();                                                                                         // 2963
      },                                                                                                               // 2964
      polygonEnd: function() {                                                                                         // 2965
        stream.polygonEnd();                                                                                           // 2966
      }                                                                                                                // 2967
    };                                                                                                                 // 2968
  }                                                                                                                    // 2969
  function d3_geo_equirectangular(λ, φ) {                                                                              // 2970
    return [ λ, φ ];                                                                                                   // 2971
  }                                                                                                                    // 2972
  (d3.geo.equirectangular = function() {                                                                               // 2973
    return d3_geo_projection(d3_geo_equirectangular);                                                                  // 2974
  }).raw = d3_geo_equirectangular.invert = d3_geo_equirectangular;                                                     // 2975
  d3.geo.rotation = function(rotate) {                                                                                 // 2976
    rotate = d3_geo_rotation(rotate[0] % 360 * d3_radians, rotate[1] * d3_radians, rotate.length > 2 ? rotate[2] * d3_radians : 0);
    function forward(coordinates) {                                                                                    // 2978
      coordinates = rotate(coordinates[0] * d3_radians, coordinates[1] * d3_radians);                                  // 2979
      return coordinates[0] *= d3_degrees, coordinates[1] *= d3_degrees, coordinates;                                  // 2980
    }                                                                                                                  // 2981
    forward.invert = function(coordinates) {                                                                           // 2982
      coordinates = rotate.invert(coordinates[0] * d3_radians, coordinates[1] * d3_radians);                           // 2983
      return coordinates[0] *= d3_degrees, coordinates[1] *= d3_degrees, coordinates;                                  // 2984
    };                                                                                                                 // 2985
    return forward;                                                                                                    // 2986
  };                                                                                                                   // 2987
  function d3_geo_rotation(δλ, δφ, δγ) {                                                                               // 2988
    return δλ ? δφ || δγ ? d3_geo_compose(d3_geo_rotationλ(δλ), d3_geo_rotationφγ(δφ, δγ)) : d3_geo_rotationλ(δλ) : δφ || δγ ? d3_geo_rotationφγ(δφ, δγ) : d3_geo_equirectangular;
  }                                                                                                                    // 2990
  function d3_geo_forwardRotationλ(δλ) {                                                                               // 2991
    return function(λ, φ) {                                                                                            // 2992
      return λ += δλ, [ λ > π ? λ - 2 * π : λ < -π ? λ + 2 * π : λ, φ ];                                               // 2993
    };                                                                                                                 // 2994
  }                                                                                                                    // 2995
  function d3_geo_rotationλ(δλ) {                                                                                      // 2996
    var rotation = d3_geo_forwardRotationλ(δλ);                                                                        // 2997
    rotation.invert = d3_geo_forwardRotationλ(-δλ);                                                                    // 2998
    return rotation;                                                                                                   // 2999
  }                                                                                                                    // 3000
  function d3_geo_rotationφγ(δφ, δγ) {                                                                                 // 3001
    var cosδφ = Math.cos(δφ), sinδφ = Math.sin(δφ), cosδγ = Math.cos(δγ), sinδγ = Math.sin(δγ);                        // 3002
    function rotation(λ, φ) {                                                                                          // 3003
      var cosφ = Math.cos(φ), x = Math.cos(λ) * cosφ, y = Math.sin(λ) * cosφ, z = Math.sin(φ), k = z * cosδφ + x * sinδφ;
      return [ Math.atan2(y * cosδγ - k * sinδγ, x * cosδφ - z * sinδφ), Math.asin(Math.max(-1, Math.min(1, k * cosδγ + y * sinδγ))) ];
    }                                                                                                                  // 3006
    rotation.invert = function(λ, φ) {                                                                                 // 3007
      var cosφ = Math.cos(φ), x = Math.cos(λ) * cosφ, y = Math.sin(λ) * cosφ, z = Math.sin(φ), k = z * cosδγ - y * sinδγ;
      return [ Math.atan2(y * cosδγ + z * sinδγ, x * cosδφ + k * sinδφ), Math.asin(Math.max(-1, Math.min(1, k * cosδφ - x * sinδφ))) ];
    };                                                                                                                 // 3010
    return rotation;                                                                                                   // 3011
  }                                                                                                                    // 3012
  d3.geo.circle = function() {                                                                                         // 3013
    var origin = [ 0, 0 ], angle, precision = 6, interpolate;                                                          // 3014
    function circle() {                                                                                                // 3015
      var center = typeof origin === "function" ? origin.apply(this, arguments) : origin, rotate = d3_geo_rotation(-center[0] * d3_radians, -center[1] * d3_radians, 0).invert, ring = [];
      interpolate(null, null, 1, {                                                                                     // 3017
        point: function(x, y) {                                                                                        // 3018
          ring.push(x = rotate(x, y));                                                                                 // 3019
          x[0] *= d3_degrees, x[1] *= d3_degrees;                                                                      // 3020
        }                                                                                                              // 3021
      });                                                                                                              // 3022
      return {                                                                                                         // 3023
        type: "Polygon",                                                                                               // 3024
        coordinates: [ ring ]                                                                                          // 3025
      };                                                                                                               // 3026
    }                                                                                                                  // 3027
    circle.origin = function(x) {                                                                                      // 3028
      if (!arguments.length) return origin;                                                                            // 3029
      origin = x;                                                                                                      // 3030
      return circle;                                                                                                   // 3031
    };                                                                                                                 // 3032
    circle.angle = function(x) {                                                                                       // 3033
      if (!arguments.length) return angle;                                                                             // 3034
      interpolate = d3_geo_circleInterpolate((angle = +x) * d3_radians, precision * d3_radians);                       // 3035
      return circle;                                                                                                   // 3036
    };                                                                                                                 // 3037
    circle.precision = function(_) {                                                                                   // 3038
      if (!arguments.length) return precision;                                                                         // 3039
      interpolate = d3_geo_circleInterpolate(angle * d3_radians, (precision = +_) * d3_radians);                       // 3040
      return circle;                                                                                                   // 3041
    };                                                                                                                 // 3042
    return circle.angle(90);                                                                                           // 3043
  };                                                                                                                   // 3044
  function d3_geo_circleInterpolate(radius, precision) {                                                               // 3045
    var cr = Math.cos(radius), sr = Math.sin(radius);                                                                  // 3046
    return function(from, to, direction, listener) {                                                                   // 3047
      if (from != null) {                                                                                              // 3048
        from = d3_geo_circleAngle(cr, from);                                                                           // 3049
        to = d3_geo_circleAngle(cr, to);                                                                               // 3050
        if (direction > 0 ? from < to : from > to) from += direction * 2 * π;                                          // 3051
      } else {                                                                                                         // 3052
        from = radius + direction * 2 * π;                                                                             // 3053
        to = radius;                                                                                                   // 3054
      }                                                                                                                // 3055
      var point;                                                                                                       // 3056
      for (var step = direction * precision, t = from; direction > 0 ? t > to : t < to; t -= step) {                   // 3057
        listener.point((point = d3_geo_spherical([ cr, -sr * Math.cos(t), -sr * Math.sin(t) ]))[0], point[1]);         // 3058
      }                                                                                                                // 3059
    };                                                                                                                 // 3060
  }                                                                                                                    // 3061
  function d3_geo_circleAngle(cr, point) {                                                                             // 3062
    var a = d3_geo_cartesian(point);                                                                                   // 3063
    a[0] -= cr;                                                                                                        // 3064
    d3_geo_cartesianNormalize(a);                                                                                      // 3065
    var angle = d3_acos(-a[1]);                                                                                        // 3066
    return ((-a[2] < 0 ? -angle : angle) + 2 * Math.PI - ε) % (2 * Math.PI);                                           // 3067
  }                                                                                                                    // 3068
  d3.geo.distance = function(a, b) {                                                                                   // 3069
    var Δλ = (b[0] - a[0]) * d3_radians, φ0 = a[1] * d3_radians, φ1 = b[1] * d3_radians, sinΔλ = Math.sin(Δλ), cosΔλ = Math.cos(Δλ), sinφ0 = Math.sin(φ0), cosφ0 = Math.cos(φ0), sinφ1 = Math.sin(φ1), cosφ1 = Math.cos(φ1), t;
    return Math.atan2(Math.sqrt((t = cosφ1 * sinΔλ) * t + (t = cosφ0 * sinφ1 - sinφ0 * cosφ1 * cosΔλ) * t), sinφ0 * sinφ1 + cosφ0 * cosφ1 * cosΔλ);
  };                                                                                                                   // 3072
  d3.geo.graticule = function() {                                                                                      // 3073
    var x1, x0, X1, X0, y1, y0, Y1, Y0, dx = 10, dy = dx, DX = 90, DY = 360, x, y, X, Y, precision = 2.5;              // 3074
    function graticule() {                                                                                             // 3075
      return {                                                                                                         // 3076
        type: "MultiLineString",                                                                                       // 3077
        coordinates: lines()                                                                                           // 3078
      };                                                                                                               // 3079
    }                                                                                                                  // 3080
    function lines() {                                                                                                 // 3081
      return d3.range(Math.ceil(X0 / DX) * DX, X1, DX).map(X).concat(d3.range(Math.ceil(Y0 / DY) * DY, Y1, DY).map(Y)).concat(d3.range(Math.ceil(x0 / dx) * dx, x1, dx).filter(function(x) {
        return Math.abs(x % DX) > ε;                                                                                   // 3083
      }).map(x)).concat(d3.range(Math.ceil(y0 / dy) * dy, y1, dy).filter(function(y) {                                 // 3084
        return Math.abs(y % DY) > ε;                                                                                   // 3085
      }).map(y));                                                                                                      // 3086
    }                                                                                                                  // 3087
    graticule.lines = function() {                                                                                     // 3088
      return lines().map(function(coordinates) {                                                                       // 3089
        return {                                                                                                       // 3090
          type: "LineString",                                                                                          // 3091
          coordinates: coordinates                                                                                     // 3092
        };                                                                                                             // 3093
      });                                                                                                              // 3094
    };                                                                                                                 // 3095
    graticule.outline = function() {                                                                                   // 3096
      return {                                                                                                         // 3097
        type: "Polygon",                                                                                               // 3098
        coordinates: [ X(X0).concat(Y(Y1).slice(1), X(X1).reverse().slice(1), Y(Y0).reverse().slice(1)) ]              // 3099
      };                                                                                                               // 3100
    };                                                                                                                 // 3101
    graticule.extent = function(_) {                                                                                   // 3102
      if (!arguments.length) return graticule.minorExtent();                                                           // 3103
      return graticule.majorExtent(_).minorExtent(_);                                                                  // 3104
    };                                                                                                                 // 3105
    graticule.majorExtent = function(_) {                                                                              // 3106
      if (!arguments.length) return [ [ X0, Y0 ], [ X1, Y1 ] ];                                                        // 3107
      X0 = +_[0][0], X1 = +_[1][0];                                                                                    // 3108
      Y0 = +_[0][1], Y1 = +_[1][1];                                                                                    // 3109
      if (X0 > X1) _ = X0, X0 = X1, X1 = _;                                                                            // 3110
      if (Y0 > Y1) _ = Y0, Y0 = Y1, Y1 = _;                                                                            // 3111
      return graticule.precision(precision);                                                                           // 3112
    };                                                                                                                 // 3113
    graticule.minorExtent = function(_) {                                                                              // 3114
      if (!arguments.length) return [ [ x0, y0 ], [ x1, y1 ] ];                                                        // 3115
      x0 = +_[0][0], x1 = +_[1][0];                                                                                    // 3116
      y0 = +_[0][1], y1 = +_[1][1];                                                                                    // 3117
      if (x0 > x1) _ = x0, x0 = x1, x1 = _;                                                                            // 3118
      if (y0 > y1) _ = y0, y0 = y1, y1 = _;                                                                            // 3119
      return graticule.precision(precision);                                                                           // 3120
    };                                                                                                                 // 3121
    graticule.step = function(_) {                                                                                     // 3122
      if (!arguments.length) return graticule.minorStep();                                                             // 3123
      return graticule.majorStep(_).minorStep(_);                                                                      // 3124
    };                                                                                                                 // 3125
    graticule.majorStep = function(_) {                                                                                // 3126
      if (!arguments.length) return [ DX, DY ];                                                                        // 3127
      DX = +_[0], DY = +_[1];                                                                                          // 3128
      return graticule;                                                                                                // 3129
    };                                                                                                                 // 3130
    graticule.minorStep = function(_) {                                                                                // 3131
      if (!arguments.length) return [ dx, dy ];                                                                        // 3132
      dx = +_[0], dy = +_[1];                                                                                          // 3133
      return graticule;                                                                                                // 3134
    };                                                                                                                 // 3135
    graticule.precision = function(_) {                                                                                // 3136
      if (!arguments.length) return precision;                                                                         // 3137
      precision = +_;                                                                                                  // 3138
      x = d3_geo_graticuleX(y0, y1, 90);                                                                               // 3139
      y = d3_geo_graticuleY(x0, x1, precision);                                                                        // 3140
      X = d3_geo_graticuleX(Y0, Y1, 90);                                                                               // 3141
      Y = d3_geo_graticuleY(X0, X1, precision);                                                                        // 3142
      return graticule;                                                                                                // 3143
    };                                                                                                                 // 3144
    return graticule.majorExtent([ [ -180, -90 + ε ], [ 180, 90 - ε ] ]).minorExtent([ [ -180, -80 - ε ], [ 180, 80 + ε ] ]);
  };                                                                                                                   // 3146
  function d3_geo_graticuleX(y0, y1, dy) {                                                                             // 3147
    var y = d3.range(y0, y1 - ε, dy).concat(y1);                                                                       // 3148
    return function(x) {                                                                                               // 3149
      return y.map(function(y) {                                                                                       // 3150
        return [ x, y ];                                                                                               // 3151
      });                                                                                                              // 3152
    };                                                                                                                 // 3153
  }                                                                                                                    // 3154
  function d3_geo_graticuleY(x0, x1, dx) {                                                                             // 3155
    var x = d3.range(x0, x1 - ε, dx).concat(x1);                                                                       // 3156
    return function(y) {                                                                                               // 3157
      return x.map(function(x) {                                                                                       // 3158
        return [ x, y ];                                                                                               // 3159
      });                                                                                                              // 3160
    };                                                                                                                 // 3161
  }                                                                                                                    // 3162
  function d3_source(d) {                                                                                              // 3163
    return d.source;                                                                                                   // 3164
  }                                                                                                                    // 3165
  function d3_target(d) {                                                                                              // 3166
    return d.target;                                                                                                   // 3167
  }                                                                                                                    // 3168
  d3.geo.greatArc = function() {                                                                                       // 3169
    var source = d3_source, source_, target = d3_target, target_;                                                      // 3170
    function greatArc() {                                                                                              // 3171
      return {                                                                                                         // 3172
        type: "LineString",                                                                                            // 3173
        coordinates: [ source_ || source.apply(this, arguments), target_ || target.apply(this, arguments) ]            // 3174
      };                                                                                                               // 3175
    }                                                                                                                  // 3176
    greatArc.distance = function() {                                                                                   // 3177
      return d3.geo.distance(source_ || source.apply(this, arguments), target_ || target.apply(this, arguments));      // 3178
    };                                                                                                                 // 3179
    greatArc.source = function(_) {                                                                                    // 3180
      if (!arguments.length) return source;                                                                            // 3181
      source = _, source_ = typeof _ === "function" ? null : _;                                                        // 3182
      return greatArc;                                                                                                 // 3183
    };                                                                                                                 // 3184
    greatArc.target = function(_) {                                                                                    // 3185
      if (!arguments.length) return target;                                                                            // 3186
      target = _, target_ = typeof _ === "function" ? null : _;                                                        // 3187
      return greatArc;                                                                                                 // 3188
    };                                                                                                                 // 3189
    greatArc.precision = function() {                                                                                  // 3190
      return arguments.length ? greatArc : 0;                                                                          // 3191
    };                                                                                                                 // 3192
    return greatArc;                                                                                                   // 3193
  };                                                                                                                   // 3194
  d3.geo.interpolate = function(source, target) {                                                                      // 3195
    return d3_geo_interpolate(source[0] * d3_radians, source[1] * d3_radians, target[0] * d3_radians, target[1] * d3_radians);
  };                                                                                                                   // 3197
  function d3_geo_interpolate(x0, y0, x1, y1) {                                                                        // 3198
    var cy0 = Math.cos(y0), sy0 = Math.sin(y0), cy1 = Math.cos(y1), sy1 = Math.sin(y1), kx0 = cy0 * Math.cos(x0), ky0 = cy0 * Math.sin(x0), kx1 = cy1 * Math.cos(x1), ky1 = cy1 * Math.sin(x1), d = 2 * Math.asin(Math.sqrt(d3_haversin(y1 - y0) + cy0 * cy1 * d3_haversin(x1 - x0))), k = 1 / Math.sin(d);
    var interpolate = d ? function(t) {                                                                                // 3200
      var B = Math.sin(t *= d) * k, A = Math.sin(d - t) * k, x = A * kx0 + B * kx1, y = A * ky0 + B * ky1, z = A * sy0 + B * sy1;
      return [ Math.atan2(y, x) * d3_degrees, Math.atan2(z, Math.sqrt(x * x + y * y)) * d3_degrees ];                  // 3202
    } : function() {                                                                                                   // 3203
      return [ x0 * d3_degrees, y0 * d3_degrees ];                                                                     // 3204
    };                                                                                                                 // 3205
    interpolate.distance = d;                                                                                          // 3206
    return interpolate;                                                                                                // 3207
  }                                                                                                                    // 3208
  d3.geo.length = function(object) {                                                                                   // 3209
    d3_geo_lengthSum = 0;                                                                                              // 3210
    d3.geo.stream(object, d3_geo_length);                                                                              // 3211
    return d3_geo_lengthSum;                                                                                           // 3212
  };                                                                                                                   // 3213
  var d3_geo_lengthSum;                                                                                                // 3214
  var d3_geo_length = {                                                                                                // 3215
    sphere: d3_noop,                                                                                                   // 3216
    point: d3_noop,                                                                                                    // 3217
    lineStart: d3_geo_lengthLineStart,                                                                                 // 3218
    lineEnd: d3_noop,                                                                                                  // 3219
    polygonStart: d3_noop,                                                                                             // 3220
    polygonEnd: d3_noop                                                                                                // 3221
  };                                                                                                                   // 3222
  function d3_geo_lengthLineStart() {                                                                                  // 3223
    var λ0, sinφ0, cosφ0;                                                                                              // 3224
    d3_geo_length.point = function(λ, φ) {                                                                             // 3225
      λ0 = λ * d3_radians, sinφ0 = Math.sin(φ *= d3_radians), cosφ0 = Math.cos(φ);                                     // 3226
      d3_geo_length.point = nextPoint;                                                                                 // 3227
    };                                                                                                                 // 3228
    d3_geo_length.lineEnd = function() {                                                                               // 3229
      d3_geo_length.point = d3_geo_length.lineEnd = d3_noop;                                                           // 3230
    };                                                                                                                 // 3231
    function nextPoint(λ, φ) {                                                                                         // 3232
      var sinφ = Math.sin(φ *= d3_radians), cosφ = Math.cos(φ), t = Math.abs((λ *= d3_radians) - λ0), cosΔλ = Math.cos(t);
      d3_geo_lengthSum += Math.atan2(Math.sqrt((t = cosφ * Math.sin(t)) * t + (t = cosφ0 * sinφ - sinφ0 * cosφ * cosΔλ) * t), sinφ0 * sinφ + cosφ0 * cosφ * cosΔλ);
      λ0 = λ, sinφ0 = sinφ, cosφ0 = cosφ;                                                                              // 3235
    }                                                                                                                  // 3236
  }                                                                                                                    // 3237
  function d3_geo_conic(projectAt) {                                                                                   // 3238
    var φ0 = 0, φ1 = π / 3, m = d3_geo_projectionMutator(projectAt), p = m(φ0, φ1);                                    // 3239
    p.parallels = function(_) {                                                                                        // 3240
      if (!arguments.length) return [ φ0 / π * 180, φ1 / π * 180 ];                                                    // 3241
      return m(φ0 = _[0] * π / 180, φ1 = _[1] * π / 180);                                                              // 3242
    };                                                                                                                 // 3243
    return p;                                                                                                          // 3244
  }                                                                                                                    // 3245
  function d3_geo_conicEqualArea(φ0, φ1) {                                                                             // 3246
    var sinφ0 = Math.sin(φ0), n = (sinφ0 + Math.sin(φ1)) / 2, C = 1 + sinφ0 * (2 * n - sinφ0), ρ0 = Math.sqrt(C) / n;  // 3247
    function forward(λ, φ) {                                                                                           // 3248
      var ρ = Math.sqrt(C - 2 * n * Math.sin(φ)) / n;                                                                  // 3249
      return [ ρ * Math.sin(λ *= n), ρ0 - ρ * Math.cos(λ) ];                                                           // 3250
    }                                                                                                                  // 3251
    forward.invert = function(x, y) {                                                                                  // 3252
      var ρ0_y = ρ0 - y;                                                                                               // 3253
      return [ Math.atan2(x, ρ0_y) / n, Math.asin((C - (x * x + ρ0_y * ρ0_y) * n * n) / (2 * n)) ];                    // 3254
    };                                                                                                                 // 3255
    return forward;                                                                                                    // 3256
  }                                                                                                                    // 3257
  (d3.geo.conicEqualArea = function() {                                                                                // 3258
    return d3_geo_conic(d3_geo_conicEqualArea);                                                                        // 3259
  }).raw = d3_geo_conicEqualArea;                                                                                      // 3260
  d3.geo.albersUsa = function() {                                                                                      // 3261
    var lower48 = d3.geo.conicEqualArea().rotate([ 98, 0 ]).center([ 0, 38 ]).parallels([ 29.5, 45.5 ]);               // 3262
    var alaska = d3.geo.conicEqualArea().rotate([ 160, 0 ]).center([ 0, 60 ]).parallels([ 55, 65 ]);                   // 3263
    var hawaii = d3.geo.conicEqualArea().rotate([ 160, 0 ]).center([ 0, 20 ]).parallels([ 8, 18 ]);                    // 3264
    var puertoRico = d3.geo.conicEqualArea().rotate([ 60, 0 ]).center([ 0, 10 ]).parallels([ 8, 18 ]);                 // 3265
    var alaskaInvert, hawaiiInvert, puertoRicoInvert;                                                                  // 3266
    function albersUsa(coordinates) {                                                                                  // 3267
      return projection(coordinates)(coordinates);                                                                     // 3268
    }                                                                                                                  // 3269
    function projection(point) {                                                                                       // 3270
      var lon = point[0], lat = point[1];                                                                              // 3271
      return lat > 50 ? alaska : lon < -140 ? hawaii : lat < 21 ? puertoRico : lower48;                                // 3272
    }                                                                                                                  // 3273
    albersUsa.invert = function(coordinates) {                                                                         // 3274
      return alaskaInvert(coordinates) || hawaiiInvert(coordinates) || puertoRicoInvert(coordinates) || lower48.invert(coordinates);
    };                                                                                                                 // 3276
    albersUsa.scale = function(x) {                                                                                    // 3277
      if (!arguments.length) return lower48.scale();                                                                   // 3278
      lower48.scale(x);                                                                                                // 3279
      alaska.scale(x * .6);                                                                                            // 3280
      hawaii.scale(x);                                                                                                 // 3281
      puertoRico.scale(x * 1.5);                                                                                       // 3282
      return albersUsa.translate(lower48.translate());                                                                 // 3283
    };                                                                                                                 // 3284
    albersUsa.translate = function(x) {                                                                                // 3285
      if (!arguments.length) return lower48.translate();                                                               // 3286
      var dz = lower48.scale(), dx = x[0], dy = x[1];                                                                  // 3287
      lower48.translate(x);                                                                                            // 3288
      alaska.translate([ dx - .4 * dz, dy + .17 * dz ]);                                                               // 3289
      hawaii.translate([ dx - .19 * dz, dy + .2 * dz ]);                                                               // 3290
      puertoRico.translate([ dx + .58 * dz, dy + .43 * dz ]);                                                          // 3291
      alaskaInvert = d3_geo_albersUsaInvert(alaska, [ [ -180, 50 ], [ -130, 72 ] ]);                                   // 3292
      hawaiiInvert = d3_geo_albersUsaInvert(hawaii, [ [ -164, 18 ], [ -154, 24 ] ]);                                   // 3293
      puertoRicoInvert = d3_geo_albersUsaInvert(puertoRico, [ [ -67.5, 17.5 ], [ -65, 19 ] ]);                         // 3294
      return albersUsa;                                                                                                // 3295
    };                                                                                                                 // 3296
    return albersUsa.scale(1e3);                                                                                       // 3297
  };                                                                                                                   // 3298
  function d3_geo_albersUsaInvert(projection, extent) {                                                                // 3299
    var a = projection(extent[0]), b = projection([ .5 * (extent[0][0] + extent[1][0]), extent[0][1] ]), c = projection([ extent[1][0], extent[0][1] ]), d = projection(extent[1]);
    var dya = b[1] - a[1], dxa = b[0] - a[0], dyb = c[1] - b[1], dxb = c[0] - b[0];                                    // 3301
    var ma = dya / dxa, mb = dyb / dxb;                                                                                // 3302
    var cx = .5 * (ma * mb * (a[1] - c[1]) + mb * (a[0] + b[0]) - ma * (b[0] + c[0])) / (mb - ma), cy = (.5 * (a[0] + b[0]) - cx) / ma + .5 * (a[1] + b[1]);
    var dx0 = d[0] - cx, dy0 = d[1] - cy, dx1 = a[0] - cx, dy1 = a[1] - cy, r0 = dx0 * dx0 + dy0 * dy0, r1 = dx1 * dx1 + dy1 * dy1;
    var a0 = Math.atan2(dy0, dx0), a1 = Math.atan2(dy1, dx1);                                                          // 3305
    return function(coordinates) {                                                                                     // 3306
      var dx = coordinates[0] - cx, dy = coordinates[1] - cy, r = dx * dx + dy * dy, a = Math.atan2(dy, dx);           // 3307
      if (r0 < r && r < r1 && a0 < a && a < a1) return projection.invert(coordinates);                                 // 3308
    };                                                                                                                 // 3309
  }                                                                                                                    // 3310
  var d3_geo_pathAreaSum, d3_geo_pathAreaPolygon, d3_geo_pathArea = {                                                  // 3311
    point: d3_noop,                                                                                                    // 3312
    lineStart: d3_noop,                                                                                                // 3313
    lineEnd: d3_noop,                                                                                                  // 3314
    polygonStart: function() {                                                                                         // 3315
      d3_geo_pathAreaPolygon = 0;                                                                                      // 3316
      d3_geo_pathArea.lineStart = d3_geo_pathAreaRingStart;                                                            // 3317
    },                                                                                                                 // 3318
    polygonEnd: function() {                                                                                           // 3319
      d3_geo_pathArea.lineStart = d3_geo_pathArea.lineEnd = d3_geo_pathArea.point = d3_noop;                           // 3320
      d3_geo_pathAreaSum += Math.abs(d3_geo_pathAreaPolygon / 2);                                                      // 3321
    }                                                                                                                  // 3322
  };                                                                                                                   // 3323
  function d3_geo_pathAreaRingStart() {                                                                                // 3324
    var x00, y00, x0, y0;                                                                                              // 3325
    d3_geo_pathArea.point = function(x, y) {                                                                           // 3326
      d3_geo_pathArea.point = nextPoint;                                                                               // 3327
      x00 = x0 = x, y00 = y0 = y;                                                                                      // 3328
    };                                                                                                                 // 3329
    function nextPoint(x, y) {                                                                                         // 3330
      d3_geo_pathAreaPolygon += y0 * x - x0 * y;                                                                       // 3331
      x0 = x, y0 = y;                                                                                                  // 3332
    }                                                                                                                  // 3333
    d3_geo_pathArea.lineEnd = function() {                                                                             // 3334
      nextPoint(x00, y00);                                                                                             // 3335
    };                                                                                                                 // 3336
  }                                                                                                                    // 3337
  function d3_geo_pathBuffer() {                                                                                       // 3338
    var pointCircle = d3_geo_pathCircle(4.5), buffer = [];                                                             // 3339
    var stream = {                                                                                                     // 3340
      point: point,                                                                                                    // 3341
      lineStart: function() {                                                                                          // 3342
        stream.point = pointLineStart;                                                                                 // 3343
      },                                                                                                               // 3344
      lineEnd: lineEnd,                                                                                                // 3345
      polygonStart: function() {                                                                                       // 3346
        stream.lineEnd = lineEndPolygon;                                                                               // 3347
      },                                                                                                               // 3348
      polygonEnd: function() {                                                                                         // 3349
        stream.lineEnd = lineEnd;                                                                                      // 3350
        stream.point = point;                                                                                          // 3351
      },                                                                                                               // 3352
      pointRadius: function(_) {                                                                                       // 3353
        pointCircle = d3_geo_pathCircle(_);                                                                            // 3354
        return stream;                                                                                                 // 3355
      },                                                                                                               // 3356
      result: function() {                                                                                             // 3357
        if (buffer.length) {                                                                                           // 3358
          var result = buffer.join("");                                                                                // 3359
          buffer = [];                                                                                                 // 3360
          return result;                                                                                               // 3361
        }                                                                                                              // 3362
      }                                                                                                                // 3363
    };                                                                                                                 // 3364
    function point(x, y) {                                                                                             // 3365
      buffer.push("M", x, ",", y, pointCircle);                                                                        // 3366
    }                                                                                                                  // 3367
    function pointLineStart(x, y) {                                                                                    // 3368
      buffer.push("M", x, ",", y);                                                                                     // 3369
      stream.point = pointLine;                                                                                        // 3370
    }                                                                                                                  // 3371
    function pointLine(x, y) {                                                                                         // 3372
      buffer.push("L", x, ",", y);                                                                                     // 3373
    }                                                                                                                  // 3374
    function lineEnd() {                                                                                               // 3375
      stream.point = point;                                                                                            // 3376
    }                                                                                                                  // 3377
    function lineEndPolygon() {                                                                                        // 3378
      buffer.push("Z");                                                                                                // 3379
    }                                                                                                                  // 3380
    return stream;                                                                                                     // 3381
  }                                                                                                                    // 3382
  var d3_geo_pathCentroid = {                                                                                          // 3383
    point: d3_geo_pathCentroidPoint,                                                                                   // 3384
    lineStart: d3_geo_pathCentroidLineStart,                                                                           // 3385
    lineEnd: d3_geo_pathCentroidLineEnd,                                                                               // 3386
    polygonStart: function() {                                                                                         // 3387
      d3_geo_pathCentroid.lineStart = d3_geo_pathCentroidRingStart;                                                    // 3388
    },                                                                                                                 // 3389
    polygonEnd: function() {                                                                                           // 3390
      d3_geo_pathCentroid.point = d3_geo_pathCentroidPoint;                                                            // 3391
      d3_geo_pathCentroid.lineStart = d3_geo_pathCentroidLineStart;                                                    // 3392
      d3_geo_pathCentroid.lineEnd = d3_geo_pathCentroidLineEnd;                                                        // 3393
    }                                                                                                                  // 3394
  };                                                                                                                   // 3395
  function d3_geo_pathCentroidPoint(x, y) {                                                                            // 3396
    if (d3_geo_centroidDimension) return;                                                                              // 3397
    d3_geo_centroidX += x;                                                                                             // 3398
    d3_geo_centroidY += y;                                                                                             // 3399
    ++d3_geo_centroidZ;                                                                                                // 3400
  }                                                                                                                    // 3401
  function d3_geo_pathCentroidLineStart() {                                                                            // 3402
    var x0, y0;                                                                                                        // 3403
    if (d3_geo_centroidDimension !== 1) {                                                                              // 3404
      if (d3_geo_centroidDimension < 1) {                                                                              // 3405
        d3_geo_centroidDimension = 1;                                                                                  // 3406
        d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                                                    // 3407
      } else return;                                                                                                   // 3408
    }                                                                                                                  // 3409
    d3_geo_pathCentroid.point = function(x, y) {                                                                       // 3410
      d3_geo_pathCentroid.point = nextPoint;                                                                           // 3411
      x0 = x, y0 = y;                                                                                                  // 3412
    };                                                                                                                 // 3413
    function nextPoint(x, y) {                                                                                         // 3414
      var dx = x - x0, dy = y - y0, z = Math.sqrt(dx * dx + dy * dy);                                                  // 3415
      d3_geo_centroidX += z * (x0 + x) / 2;                                                                            // 3416
      d3_geo_centroidY += z * (y0 + y) / 2;                                                                            // 3417
      d3_geo_centroidZ += z;                                                                                           // 3418
      x0 = x, y0 = y;                                                                                                  // 3419
    }                                                                                                                  // 3420
  }                                                                                                                    // 3421
  function d3_geo_pathCentroidLineEnd() {                                                                              // 3422
    d3_geo_pathCentroid.point = d3_geo_pathCentroidPoint;                                                              // 3423
  }                                                                                                                    // 3424
  function d3_geo_pathCentroidRingStart() {                                                                            // 3425
    var x00, y00, x0, y0;                                                                                              // 3426
    if (d3_geo_centroidDimension < 2) {                                                                                // 3427
      d3_geo_centroidDimension = 2;                                                                                    // 3428
      d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                                                      // 3429
    }                                                                                                                  // 3430
    d3_geo_pathCentroid.point = function(x, y) {                                                                       // 3431
      d3_geo_pathCentroid.point = nextPoint;                                                                           // 3432
      x00 = x0 = x, y00 = y0 = y;                                                                                      // 3433
    };                                                                                                                 // 3434
    function nextPoint(x, y) {                                                                                         // 3435
      var z = y0 * x - x0 * y;                                                                                         // 3436
      d3_geo_centroidX += z * (x0 + x);                                                                                // 3437
      d3_geo_centroidY += z * (y0 + y);                                                                                // 3438
      d3_geo_centroidZ += z * 3;                                                                                       // 3439
      x0 = x, y0 = y;                                                                                                  // 3440
    }                                                                                                                  // 3441
    d3_geo_pathCentroid.lineEnd = function() {                                                                         // 3442
      nextPoint(x00, y00);                                                                                             // 3443
    };                                                                                                                 // 3444
  }                                                                                                                    // 3445
  function d3_geo_pathContext(context) {                                                                               // 3446
    var pointRadius = 4.5;                                                                                             // 3447
    var stream = {                                                                                                     // 3448
      point: point,                                                                                                    // 3449
      lineStart: function() {                                                                                          // 3450
        stream.point = pointLineStart;                                                                                 // 3451
      },                                                                                                               // 3452
      lineEnd: lineEnd,                                                                                                // 3453
      polygonStart: function() {                                                                                       // 3454
        stream.lineEnd = lineEndPolygon;                                                                               // 3455
      },                                                                                                               // 3456
      polygonEnd: function() {                                                                                         // 3457
        stream.lineEnd = lineEnd;                                                                                      // 3458
        stream.point = point;                                                                                          // 3459
      },                                                                                                               // 3460
      pointRadius: function(_) {                                                                                       // 3461
        pointRadius = _;                                                                                               // 3462
        return stream;                                                                                                 // 3463
      },                                                                                                               // 3464
      result: d3_noop                                                                                                  // 3465
    };                                                                                                                 // 3466
    function point(x, y) {                                                                                             // 3467
      context.moveTo(x, y);                                                                                            // 3468
      context.arc(x, y, pointRadius, 0, 2 * π);                                                                        // 3469
    }                                                                                                                  // 3470
    function pointLineStart(x, y) {                                                                                    // 3471
      context.moveTo(x, y);                                                                                            // 3472
      stream.point = pointLine;                                                                                        // 3473
    }                                                                                                                  // 3474
    function pointLine(x, y) {                                                                                         // 3475
      context.lineTo(x, y);                                                                                            // 3476
    }                                                                                                                  // 3477
    function lineEnd() {                                                                                               // 3478
      stream.point = point;                                                                                            // 3479
    }                                                                                                                  // 3480
    function lineEndPolygon() {                                                                                        // 3481
      context.closePath();                                                                                             // 3482
    }                                                                                                                  // 3483
    return stream;                                                                                                     // 3484
  }                                                                                                                    // 3485
  d3.geo.path = function() {                                                                                           // 3486
    var pointRadius = 4.5, projection, context, projectStream, contextStream;                                          // 3487
    function path(object) {                                                                                            // 3488
      if (object) d3.geo.stream(object, projectStream(contextStream.pointRadius(typeof pointRadius === "function" ? +pointRadius.apply(this, arguments) : pointRadius)));
      return contextStream.result();                                                                                   // 3490
    }                                                                                                                  // 3491
    path.area = function(object) {                                                                                     // 3492
      d3_geo_pathAreaSum = 0;                                                                                          // 3493
      d3.geo.stream(object, projectStream(d3_geo_pathArea));                                                           // 3494
      return d3_geo_pathAreaSum;                                                                                       // 3495
    };                                                                                                                 // 3496
    path.centroid = function(object) {                                                                                 // 3497
      d3_geo_centroidDimension = d3_geo_centroidX = d3_geo_centroidY = d3_geo_centroidZ = 0;                           // 3498
      d3.geo.stream(object, projectStream(d3_geo_pathCentroid));                                                       // 3499
      return d3_geo_centroidZ ? [ d3_geo_centroidX / d3_geo_centroidZ, d3_geo_centroidY / d3_geo_centroidZ ] : undefined;
    };                                                                                                                 // 3501
    path.bounds = function(object) {                                                                                   // 3502
      return d3_geo_bounds(projectStream)(object);                                                                     // 3503
    };                                                                                                                 // 3504
    path.projection = function(_) {                                                                                    // 3505
      if (!arguments.length) return projection;                                                                        // 3506
      projectStream = (projection = _) ? _.stream || d3_geo_pathProjectStream(_) : d3_identity;                        // 3507
      return path;                                                                                                     // 3508
    };                                                                                                                 // 3509
    path.context = function(_) {                                                                                       // 3510
      if (!arguments.length) return context;                                                                           // 3511
      contextStream = (context = _) == null ? new d3_geo_pathBuffer() : new d3_geo_pathContext(_);                     // 3512
      return path;                                                                                                     // 3513
    };                                                                                                                 // 3514
    path.pointRadius = function(_) {                                                                                   // 3515
      if (!arguments.length) return pointRadius;                                                                       // 3516
      pointRadius = typeof _ === "function" ? _ : +_;                                                                  // 3517
      return path;                                                                                                     // 3518
    };                                                                                                                 // 3519
    return path.projection(d3.geo.albersUsa()).context(null);                                                          // 3520
  };                                                                                                                   // 3521
  function d3_geo_pathCircle(radius) {                                                                                 // 3522
    return "m0," + radius + "a" + radius + "," + radius + " 0 1,1 0," + -2 * radius + "a" + radius + "," + radius + " 0 1,1 0," + +2 * radius + "z";
  }                                                                                                                    // 3524
  function d3_geo_pathProjectStream(project) {                                                                         // 3525
    var resample = d3_geo_resample(function(λ, φ) {                                                                    // 3526
      return project([ λ * d3_degrees, φ * d3_degrees ]);                                                              // 3527
    });                                                                                                                // 3528
    return function(stream) {                                                                                          // 3529
      stream = resample(stream);                                                                                       // 3530
      return {                                                                                                         // 3531
        point: function(λ, φ) {                                                                                        // 3532
          stream.point(λ * d3_radians, φ * d3_radians);                                                                // 3533
        },                                                                                                             // 3534
        sphere: function() {                                                                                           // 3535
          stream.sphere();                                                                                             // 3536
        },                                                                                                             // 3537
        lineStart: function() {                                                                                        // 3538
          stream.lineStart();                                                                                          // 3539
        },                                                                                                             // 3540
        lineEnd: function() {                                                                                          // 3541
          stream.lineEnd();                                                                                            // 3542
        },                                                                                                             // 3543
        polygonStart: function() {                                                                                     // 3544
          stream.polygonStart();                                                                                       // 3545
        },                                                                                                             // 3546
        polygonEnd: function() {                                                                                       // 3547
          stream.polygonEnd();                                                                                         // 3548
        }                                                                                                              // 3549
      };                                                                                                               // 3550
    };                                                                                                                 // 3551
  }                                                                                                                    // 3552
  d3.geo.albers = function() {                                                                                         // 3553
    return d3.geo.conicEqualArea().parallels([ 29.5, 45.5 ]).rotate([ 98, 0 ]).center([ 0, 38 ]).scale(1e3);           // 3554
  };                                                                                                                   // 3555
  function d3_geo_azimuthal(scale, angle) {                                                                            // 3556
    function azimuthal(λ, φ) {                                                                                         // 3557
      var cosλ = Math.cos(λ), cosφ = Math.cos(φ), k = scale(cosλ * cosφ);                                              // 3558
      return [ k * cosφ * Math.sin(λ), k * Math.sin(φ) ];                                                              // 3559
    }                                                                                                                  // 3560
    azimuthal.invert = function(x, y) {                                                                                // 3561
      var ρ = Math.sqrt(x * x + y * y), c = angle(ρ), sinc = Math.sin(c), cosc = Math.cos(c);                          // 3562
      return [ Math.atan2(x * sinc, ρ * cosc), Math.asin(ρ && y * sinc / ρ) ];                                         // 3563
    };                                                                                                                 // 3564
    return azimuthal;                                                                                                  // 3565
  }                                                                                                                    // 3566
  var d3_geo_azimuthalEqualArea = d3_geo_azimuthal(function(cosλcosφ) {                                                // 3567
    return Math.sqrt(2 / (1 + cosλcosφ));                                                                              // 3568
  }, function(ρ) {                                                                                                     // 3569
    return 2 * Math.asin(ρ / 2);                                                                                       // 3570
  });                                                                                                                  // 3571
  (d3.geo.azimuthalEqualArea = function() {                                                                            // 3572
    return d3_geo_projection(d3_geo_azimuthalEqualArea);                                                               // 3573
  }).raw = d3_geo_azimuthalEqualArea;                                                                                  // 3574
  var d3_geo_azimuthalEquidistant = d3_geo_azimuthal(function(cosλcosφ) {                                              // 3575
    var c = Math.acos(cosλcosφ);                                                                                       // 3576
    return c && c / Math.sin(c);                                                                                       // 3577
  }, d3_identity);                                                                                                     // 3578
  (d3.geo.azimuthalEquidistant = function() {                                                                          // 3579
    return d3_geo_projection(d3_geo_azimuthalEquidistant);                                                             // 3580
  }).raw = d3_geo_azimuthalEquidistant;                                                                                // 3581
  function d3_geo_conicConformal(φ0, φ1) {                                                                             // 3582
    var cosφ0 = Math.cos(φ0), t = function(φ) {                                                                        // 3583
      return Math.tan(π / 4 + φ / 2);                                                                                  // 3584
    }, n = φ0 === φ1 ? Math.sin(φ0) : Math.log(cosφ0 / Math.cos(φ1)) / Math.log(t(φ1) / t(φ0)), F = cosφ0 * Math.pow(t(φ0), n) / n;
    if (!n) return d3_geo_mercator;                                                                                    // 3586
    function forward(λ, φ) {                                                                                           // 3587
      var ρ = Math.abs(Math.abs(φ) - π / 2) < ε ? 0 : F / Math.pow(t(φ), n);                                           // 3588
      return [ ρ * Math.sin(n * λ), F - ρ * Math.cos(n * λ) ];                                                         // 3589
    }                                                                                                                  // 3590
    forward.invert = function(x, y) {                                                                                  // 3591
      var ρ0_y = F - y, ρ = d3_sgn(n) * Math.sqrt(x * x + ρ0_y * ρ0_y);                                                // 3592
      return [ Math.atan2(x, ρ0_y) / n, 2 * Math.atan(Math.pow(F / ρ, 1 / n)) - π / 2 ];                               // 3593
    };                                                                                                                 // 3594
    return forward;                                                                                                    // 3595
  }                                                                                                                    // 3596
  (d3.geo.conicConformal = function() {                                                                                // 3597
    return d3_geo_conic(d3_geo_conicConformal);                                                                        // 3598
  }).raw = d3_geo_conicConformal;                                                                                      // 3599
  function d3_geo_conicEquidistant(φ0, φ1) {                                                                           // 3600
    var cosφ0 = Math.cos(φ0), n = φ0 === φ1 ? Math.sin(φ0) : (cosφ0 - Math.cos(φ1)) / (φ1 - φ0), G = cosφ0 / n + φ0;   // 3601
    if (Math.abs(n) < ε) return d3_geo_equirectangular;                                                                // 3602
    function forward(λ, φ) {                                                                                           // 3603
      var ρ = G - φ;                                                                                                   // 3604
      return [ ρ * Math.sin(n * λ), G - ρ * Math.cos(n * λ) ];                                                         // 3605
    }                                                                                                                  // 3606
    forward.invert = function(x, y) {                                                                                  // 3607
      var ρ0_y = G - y;                                                                                                // 3608
      return [ Math.atan2(x, ρ0_y) / n, G - d3_sgn(n) * Math.sqrt(x * x + ρ0_y * ρ0_y) ];                              // 3609
    };                                                                                                                 // 3610
    return forward;                                                                                                    // 3611
  }                                                                                                                    // 3612
  (d3.geo.conicEquidistant = function() {                                                                              // 3613
    return d3_geo_conic(d3_geo_conicEquidistant);                                                                      // 3614
  }).raw = d3_geo_conicEquidistant;                                                                                    // 3615
  var d3_geo_gnomonic = d3_geo_azimuthal(function(cosλcosφ) {                                                          // 3616
    return 1 / cosλcosφ;                                                                                               // 3617
  }, Math.atan);                                                                                                       // 3618
  (d3.geo.gnomonic = function() {                                                                                      // 3619
    return d3_geo_projection(d3_geo_gnomonic);                                                                         // 3620
  }).raw = d3_geo_gnomonic;                                                                                            // 3621
  function d3_geo_mercator(λ, φ) {                                                                                     // 3622
    return [ λ, Math.log(Math.tan(π / 4 + φ / 2)) ];                                                                   // 3623
  }                                                                                                                    // 3624
  d3_geo_mercator.invert = function(x, y) {                                                                            // 3625
    return [ x, 2 * Math.atan(Math.exp(y)) - π / 2 ];                                                                  // 3626
  };                                                                                                                   // 3627
  function d3_geo_mercatorProjection(project) {                                                                        // 3628
    var m = d3_geo_projection(project), scale = m.scale, translate = m.translate, clipExtent = m.clipExtent, clipAuto; // 3629
    m.scale = function() {                                                                                             // 3630
      var v = scale.apply(m, arguments);                                                                               // 3631
      return v === m ? clipAuto ? m.clipExtent(null) : m : v;                                                          // 3632
    };                                                                                                                 // 3633
    m.translate = function() {                                                                                         // 3634
      var v = translate.apply(m, arguments);                                                                           // 3635
      return v === m ? clipAuto ? m.clipExtent(null) : m : v;                                                          // 3636
    };                                                                                                                 // 3637
    m.clipExtent = function(_) {                                                                                       // 3638
      var v = clipExtent.apply(m, arguments);                                                                          // 3639
      if (v === m) {                                                                                                   // 3640
        if (clipAuto = _ == null) {                                                                                    // 3641
          var k = π * scale(), t = translate();                                                                        // 3642
          clipExtent([ [ t[0] - k, t[1] - k ], [ t[0] + k, t[1] + k ] ]);                                              // 3643
        }                                                                                                              // 3644
      } else if (clipAuto) {                                                                                           // 3645
        v = null;                                                                                                      // 3646
      }                                                                                                                // 3647
      return v;                                                                                                        // 3648
    };                                                                                                                 // 3649
    return m.clipExtent(null);                                                                                         // 3650
  }                                                                                                                    // 3651
  (d3.geo.mercator = function() {                                                                                      // 3652
    return d3_geo_mercatorProjection(d3_geo_mercator);                                                                 // 3653
  }).raw = d3_geo_mercator;                                                                                            // 3654
  var d3_geo_orthographic = d3_geo_azimuthal(function() {                                                              // 3655
    return 1;                                                                                                          // 3656
  }, Math.asin);                                                                                                       // 3657
  (d3.geo.orthographic = function() {                                                                                  // 3658
    return d3_geo_projection(d3_geo_orthographic);                                                                     // 3659
  }).raw = d3_geo_orthographic;                                                                                        // 3660
  var d3_geo_stereographic = d3_geo_azimuthal(function(cosλcosφ) {                                                     // 3661
    return 1 / (1 + cosλcosφ);                                                                                         // 3662
  }, function(ρ) {                                                                                                     // 3663
    return 2 * Math.atan(ρ);                                                                                           // 3664
  });                                                                                                                  // 3665
  (d3.geo.stereographic = function() {                                                                                 // 3666
    return d3_geo_projection(d3_geo_stereographic);                                                                    // 3667
  }).raw = d3_geo_stereographic;                                                                                       // 3668
  function d3_geo_transverseMercator(λ, φ) {                                                                           // 3669
    var B = Math.cos(φ) * Math.sin(λ);                                                                                 // 3670
    return [ Math.log((1 + B) / (1 - B)) / 2, Math.atan2(Math.tan(φ), Math.cos(λ)) ];                                  // 3671
  }                                                                                                                    // 3672
  d3_geo_transverseMercator.invert = function(x, y) {                                                                  // 3673
    return [ Math.atan2(d3_sinh(x), Math.cos(y)), d3_asin(Math.sin(y) / d3_cosh(x)) ];                                 // 3674
  };                                                                                                                   // 3675
  (d3.geo.transverseMercator = function() {                                                                            // 3676
    return d3_geo_mercatorProjection(d3_geo_transverseMercator);                                                       // 3677
  }).raw = d3_geo_transverseMercator;                                                                                  // 3678
  d3.geom = {};                                                                                                        // 3679
  d3.svg = {};                                                                                                         // 3680
  function d3_svg_line(projection) {                                                                                   // 3681
    var x = d3_svg_lineX, y = d3_svg_lineY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, tension = .7;
    function line(data) {                                                                                              // 3683
      var segments = [], points = [], i = -1, n = data.length, d, fx = d3_functor(x), fy = d3_functor(y);              // 3684
      function segment() {                                                                                             // 3685
        segments.push("M", interpolate(projection(points), tension));                                                  // 3686
      }                                                                                                                // 3687
      while (++i < n) {                                                                                                // 3688
        if (defined.call(this, d = data[i], i)) {                                                                      // 3689
          points.push([ +fx.call(this, d, i), +fy.call(this, d, i) ]);                                                 // 3690
        } else if (points.length) {                                                                                    // 3691
          segment();                                                                                                   // 3692
          points = [];                                                                                                 // 3693
        }                                                                                                              // 3694
      }                                                                                                                // 3695
      if (points.length) segment();                                                                                    // 3696
      return segments.length ? segments.join("") : null;                                                               // 3697
    }                                                                                                                  // 3698
    line.x = function(_) {                                                                                             // 3699
      if (!arguments.length) return x;                                                                                 // 3700
      x = _;                                                                                                           // 3701
      return line;                                                                                                     // 3702
    };                                                                                                                 // 3703
    line.y = function(_) {                                                                                             // 3704
      if (!arguments.length) return y;                                                                                 // 3705
      y = _;                                                                                                           // 3706
      return line;                                                                                                     // 3707
    };                                                                                                                 // 3708
    line.defined = function(_) {                                                                                       // 3709
      if (!arguments.length) return defined;                                                                           // 3710
      defined = _;                                                                                                     // 3711
      return line;                                                                                                     // 3712
    };                                                                                                                 // 3713
    line.interpolate = function(_) {                                                                                   // 3714
      if (!arguments.length) return interpolateKey;                                                                    // 3715
      if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
      return line;                                                                                                     // 3717
    };                                                                                                                 // 3718
    line.tension = function(_) {                                                                                       // 3719
      if (!arguments.length) return tension;                                                                           // 3720
      tension = _;                                                                                                     // 3721
      return line;                                                                                                     // 3722
    };                                                                                                                 // 3723
    return line;                                                                                                       // 3724
  }                                                                                                                    // 3725
  d3.svg.line = function() {                                                                                           // 3726
    return d3_svg_line(d3_identity);                                                                                   // 3727
  };                                                                                                                   // 3728
  function d3_svg_lineX(d) {                                                                                           // 3729
    return d[0];                                                                                                       // 3730
  }                                                                                                                    // 3731
  function d3_svg_lineY(d) {                                                                                           // 3732
    return d[1];                                                                                                       // 3733
  }                                                                                                                    // 3734
  var d3_svg_lineInterpolators = d3.map({                                                                              // 3735
    linear: d3_svg_lineLinear,                                                                                         // 3736
    "linear-closed": d3_svg_lineLinearClosed,                                                                          // 3737
    "step-before": d3_svg_lineStepBefore,                                                                              // 3738
    "step-after": d3_svg_lineStepAfter,                                                                                // 3739
    basis: d3_svg_lineBasis,                                                                                           // 3740
    "basis-open": d3_svg_lineBasisOpen,                                                                                // 3741
    "basis-closed": d3_svg_lineBasisClosed,                                                                            // 3742
    bundle: d3_svg_lineBundle,                                                                                         // 3743
    cardinal: d3_svg_lineCardinal,                                                                                     // 3744
    "cardinal-open": d3_svg_lineCardinalOpen,                                                                          // 3745
    "cardinal-closed": d3_svg_lineCardinalClosed,                                                                      // 3746
    monotone: d3_svg_lineMonotone                                                                                      // 3747
  });                                                                                                                  // 3748
  d3_svg_lineInterpolators.forEach(function(key, value) {                                                              // 3749
    value.key = key;                                                                                                   // 3750
    value.closed = /-closed$/.test(key);                                                                               // 3751
  });                                                                                                                  // 3752
  function d3_svg_lineLinear(points) {                                                                                 // 3753
    return points.join("L");                                                                                           // 3754
  }                                                                                                                    // 3755
  function d3_svg_lineLinearClosed(points) {                                                                           // 3756
    return d3_svg_lineLinear(points) + "Z";                                                                            // 3757
  }                                                                                                                    // 3758
  function d3_svg_lineStepBefore(points) {                                                                             // 3759
    var i = 0, n = points.length, p = points[0], path = [ p[0], ",", p[1] ];                                           // 3760
    while (++i < n) path.push("V", (p = points[i])[1], "H", p[0]);                                                     // 3761
    return path.join("");                                                                                              // 3762
  }                                                                                                                    // 3763
  function d3_svg_lineStepAfter(points) {                                                                              // 3764
    var i = 0, n = points.length, p = points[0], path = [ p[0], ",", p[1] ];                                           // 3765
    while (++i < n) path.push("H", (p = points[i])[0], "V", p[1]);                                                     // 3766
    return path.join("");                                                                                              // 3767
  }                                                                                                                    // 3768
  function d3_svg_lineCardinalOpen(points, tension) {                                                                  // 3769
    return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, points.length - 1), d3_svg_lineCardinalTangents(points, tension));
  }                                                                                                                    // 3771
  function d3_svg_lineCardinalClosed(points, tension) {                                                                // 3772
    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite((points.push(points[0]),     // 3773
    points), d3_svg_lineCardinalTangents([ points[points.length - 2] ].concat(points, [ points[1] ]), tension));       // 3774
  }                                                                                                                    // 3775
  function d3_svg_lineCardinal(points, tension) {                                                                      // 3776
    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
  }                                                                                                                    // 3778
  function d3_svg_lineHermite(points, tangents) {                                                                      // 3779
    if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {             // 3780
      return d3_svg_lineLinear(points);                                                                                // 3781
    }                                                                                                                  // 3782
    var quad = points.length != tangents.length, path = "", p0 = points[0], p = points[1], t0 = tangents[0], t = t0, pi = 1;
    if (quad) {                                                                                                        // 3784
      path += "Q" + (p[0] - t0[0] * 2 / 3) + "," + (p[1] - t0[1] * 2 / 3) + "," + p[0] + "," + p[1];                   // 3785
      p0 = points[1];                                                                                                  // 3786
      pi = 2;                                                                                                          // 3787
    }                                                                                                                  // 3788
    if (tangents.length > 1) {                                                                                         // 3789
      t = tangents[1];                                                                                                 // 3790
      p = points[pi];                                                                                                  // 3791
      pi++;                                                                                                            // 3792
      path += "C" + (p0[0] + t0[0]) + "," + (p0[1] + t0[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
      for (var i = 2; i < tangents.length; i++, pi++) {                                                                // 3794
        p = points[pi];                                                                                                // 3795
        t = tangents[i];                                                                                               // 3796
        path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];                                   // 3797
      }                                                                                                                // 3798
    }                                                                                                                  // 3799
    if (quad) {                                                                                                        // 3800
      var lp = points[pi];                                                                                             // 3801
      path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp[0] + "," + lp[1];                   // 3802
    }                                                                                                                  // 3803
    return path;                                                                                                       // 3804
  }                                                                                                                    // 3805
  function d3_svg_lineCardinalTangents(points, tension) {                                                              // 3806
    var tangents = [], a = (1 - tension) / 2, p0, p1 = points[0], p2 = points[1], i = 1, n = points.length;            // 3807
    while (++i < n) {                                                                                                  // 3808
      p0 = p1;                                                                                                         // 3809
      p1 = p2;                                                                                                         // 3810
      p2 = points[i];                                                                                                  // 3811
      tangents.push([ a * (p2[0] - p0[0]), a * (p2[1] - p0[1]) ]);                                                     // 3812
    }                                                                                                                  // 3813
    return tangents;                                                                                                   // 3814
  }                                                                                                                    // 3815
  function d3_svg_lineBasis(points) {                                                                                  // 3816
    if (points.length < 3) return d3_svg_lineLinear(points);                                                           // 3817
    var i = 1, n = points.length, pi = points[0], x0 = pi[0], y0 = pi[1], px = [ x0, x0, x0, (pi = points[1])[0] ], py = [ y0, y0, y0, pi[1] ], path = [ x0, ",", y0 ];
    d3_svg_lineBasisBezier(path, px, py);                                                                              // 3819
    while (++i < n) {                                                                                                  // 3820
      pi = points[i];                                                                                                  // 3821
      px.shift();                                                                                                      // 3822
      px.push(pi[0]);                                                                                                  // 3823
      py.shift();                                                                                                      // 3824
      py.push(pi[1]);                                                                                                  // 3825
      d3_svg_lineBasisBezier(path, px, py);                                                                            // 3826
    }                                                                                                                  // 3827
    i = -1;                                                                                                            // 3828
    while (++i < 2) {                                                                                                  // 3829
      px.shift();                                                                                                      // 3830
      px.push(pi[0]);                                                                                                  // 3831
      py.shift();                                                                                                      // 3832
      py.push(pi[1]);                                                                                                  // 3833
      d3_svg_lineBasisBezier(path, px, py);                                                                            // 3834
    }                                                                                                                  // 3835
    return path.join("");                                                                                              // 3836
  }                                                                                                                    // 3837
  function d3_svg_lineBasisOpen(points) {                                                                              // 3838
    if (points.length < 4) return d3_svg_lineLinear(points);                                                           // 3839
    var path = [], i = -1, n = points.length, pi, px = [ 0 ], py = [ 0 ];                                              // 3840
    while (++i < 3) {                                                                                                  // 3841
      pi = points[i];                                                                                                  // 3842
      px.push(pi[0]);                                                                                                  // 3843
      py.push(pi[1]);                                                                                                  // 3844
    }                                                                                                                  // 3845
    path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));      // 3846
    --i;                                                                                                               // 3847
    while (++i < n) {                                                                                                  // 3848
      pi = points[i];                                                                                                  // 3849
      px.shift();                                                                                                      // 3850
      px.push(pi[0]);                                                                                                  // 3851
      py.shift();                                                                                                      // 3852
      py.push(pi[1]);                                                                                                  // 3853
      d3_svg_lineBasisBezier(path, px, py);                                                                            // 3854
    }                                                                                                                  // 3855
    return path.join("");                                                                                              // 3856
  }                                                                                                                    // 3857
  function d3_svg_lineBasisClosed(points) {                                                                            // 3858
    var path, i = -1, n = points.length, m = n + 4, pi, px = [], py = [];                                              // 3859
    while (++i < 4) {                                                                                                  // 3860
      pi = points[i % n];                                                                                              // 3861
      px.push(pi[0]);                                                                                                  // 3862
      py.push(pi[1]);                                                                                                  // 3863
    }                                                                                                                  // 3864
    path = [ d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py) ];        // 3865
    --i;                                                                                                               // 3866
    while (++i < m) {                                                                                                  // 3867
      pi = points[i % n];                                                                                              // 3868
      px.shift();                                                                                                      // 3869
      px.push(pi[0]);                                                                                                  // 3870
      py.shift();                                                                                                      // 3871
      py.push(pi[1]);                                                                                                  // 3872
      d3_svg_lineBasisBezier(path, px, py);                                                                            // 3873
    }                                                                                                                  // 3874
    return path.join("");                                                                                              // 3875
  }                                                                                                                    // 3876
  function d3_svg_lineBundle(points, tension) {                                                                        // 3877
    var n = points.length - 1;                                                                                         // 3878
    if (n) {                                                                                                           // 3879
      var x0 = points[0][0], y0 = points[0][1], dx = points[n][0] - x0, dy = points[n][1] - y0, i = -1, p, t;          // 3880
      while (++i <= n) {                                                                                               // 3881
        p = points[i];                                                                                                 // 3882
        t = i / n;                                                                                                     // 3883
        p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);                                                         // 3884
        p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);                                                         // 3885
      }                                                                                                                // 3886
    }                                                                                                                  // 3887
    return d3_svg_lineBasis(points);                                                                                   // 3888
  }                                                                                                                    // 3889
  function d3_svg_lineDot4(a, b) {                                                                                     // 3890
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];                                                      // 3891
  }                                                                                                                    // 3892
  var d3_svg_lineBasisBezier1 = [ 0, 2 / 3, 1 / 3, 0 ], d3_svg_lineBasisBezier2 = [ 0, 1 / 3, 2 / 3, 0 ], d3_svg_lineBasisBezier3 = [ 0, 1 / 6, 2 / 3, 1 / 6 ];
  function d3_svg_lineBasisBezier(path, x, y) {                                                                        // 3894
    path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
  }                                                                                                                    // 3896
  function d3_svg_lineSlope(p0, p1) {                                                                                  // 3897
    return (p1[1] - p0[1]) / (p1[0] - p0[0]);                                                                          // 3898
  }                                                                                                                    // 3899
  function d3_svg_lineFiniteDifferences(points) {                                                                      // 3900
    var i = 0, j = points.length - 1, m = [], p0 = points[0], p1 = points[1], d = m[0] = d3_svg_lineSlope(p0, p1);     // 3901
    while (++i < j) {                                                                                                  // 3902
      m[i] = (d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]))) / 2;                                            // 3903
    }                                                                                                                  // 3904
    m[i] = d;                                                                                                          // 3905
    return m;                                                                                                          // 3906
  }                                                                                                                    // 3907
  function d3_svg_lineMonotoneTangents(points) {                                                                       // 3908
    var tangents = [], d, a, b, s, m = d3_svg_lineFiniteDifferences(points), i = -1, j = points.length - 1;            // 3909
    while (++i < j) {                                                                                                  // 3910
      d = d3_svg_lineSlope(points[i], points[i + 1]);                                                                  // 3911
      if (Math.abs(d) < 1e-6) {                                                                                        // 3912
        m[i] = m[i + 1] = 0;                                                                                           // 3913
      } else {                                                                                                         // 3914
        a = m[i] / d;                                                                                                  // 3915
        b = m[i + 1] / d;                                                                                              // 3916
        s = a * a + b * b;                                                                                             // 3917
        if (s > 9) {                                                                                                   // 3918
          s = d * 3 / Math.sqrt(s);                                                                                    // 3919
          m[i] = s * a;                                                                                                // 3920
          m[i + 1] = s * b;                                                                                            // 3921
        }                                                                                                              // 3922
      }                                                                                                                // 3923
    }                                                                                                                  // 3924
    i = -1;                                                                                                            // 3925
    while (++i <= j) {                                                                                                 // 3926
      s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));                   // 3927
      tangents.push([ s || 0, m[i] * s || 0 ]);                                                                        // 3928
    }                                                                                                                  // 3929
    return tangents;                                                                                                   // 3930
  }                                                                                                                    // 3931
  function d3_svg_lineMonotone(points) {                                                                               // 3932
    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
  }                                                                                                                    // 3934
  d3.geom.hull = function(vertices) {                                                                                  // 3935
    var x = d3_svg_lineX, y = d3_svg_lineY;                                                                            // 3936
    if (arguments.length) return hull(vertices);                                                                       // 3937
    function hull(data) {                                                                                              // 3938
      if (data.length < 3) return [];                                                                                  // 3939
      var fx = d3_functor(x), fy = d3_functor(y), n = data.length, vertices, plen = n - 1, points = [], stack = [], d, i, j, h = 0, x1, y1, x2, y2, u, v, a, sp;
      if (fx === d3_svg_lineX && y === d3_svg_lineY) vertices = data; else for (i = 0,                                 // 3941
      vertices = []; i < n; ++i) {                                                                                     // 3942
        vertices.push([ +fx.call(this, d = data[i], i), +fy.call(this, d, i) ]);                                       // 3943
      }                                                                                                                // 3944
      for (i = 1; i < n; ++i) {                                                                                        // 3945
        if (vertices[i][1] < vertices[h][1]) {                                                                         // 3946
          h = i;                                                                                                       // 3947
        } else if (vertices[i][1] == vertices[h][1]) {                                                                 // 3948
          h = vertices[i][0] < vertices[h][0] ? i : h;                                                                 // 3949
        }                                                                                                              // 3950
      }                                                                                                                // 3951
      for (i = 0; i < n; ++i) {                                                                                        // 3952
        if (i === h) continue;                                                                                         // 3953
        y1 = vertices[i][1] - vertices[h][1];                                                                          // 3954
        x1 = vertices[i][0] - vertices[h][0];                                                                          // 3955
        points.push({                                                                                                  // 3956
          angle: Math.atan2(y1, x1),                                                                                   // 3957
          index: i                                                                                                     // 3958
        });                                                                                                            // 3959
      }                                                                                                                // 3960
      points.sort(function(a, b) {                                                                                     // 3961
        return a.angle - b.angle;                                                                                      // 3962
      });                                                                                                              // 3963
      a = points[0].angle;                                                                                             // 3964
      v = points[0].index;                                                                                             // 3965
      u = 0;                                                                                                           // 3966
      for (i = 1; i < plen; ++i) {                                                                                     // 3967
        j = points[i].index;                                                                                           // 3968
        if (a == points[i].angle) {                                                                                    // 3969
          x1 = vertices[v][0] - vertices[h][0];                                                                        // 3970
          y1 = vertices[v][1] - vertices[h][1];                                                                        // 3971
          x2 = vertices[j][0] - vertices[h][0];                                                                        // 3972
          y2 = vertices[j][1] - vertices[h][1];                                                                        // 3973
          if (x1 * x1 + y1 * y1 >= x2 * x2 + y2 * y2) {                                                                // 3974
            points[i].index = -1;                                                                                      // 3975
          } else {                                                                                                     // 3976
            points[u].index = -1;                                                                                      // 3977
            a = points[i].angle;                                                                                       // 3978
            u = i;                                                                                                     // 3979
            v = j;                                                                                                     // 3980
          }                                                                                                            // 3981
        } else {                                                                                                       // 3982
          a = points[i].angle;                                                                                         // 3983
          u = i;                                                                                                       // 3984
          v = j;                                                                                                       // 3985
        }                                                                                                              // 3986
      }                                                                                                                // 3987
      stack.push(h);                                                                                                   // 3988
      for (i = 0, j = 0; i < 2; ++j) {                                                                                 // 3989
        if (points[j].index !== -1) {                                                                                  // 3990
          stack.push(points[j].index);                                                                                 // 3991
          i++;                                                                                                         // 3992
        }                                                                                                              // 3993
      }                                                                                                                // 3994
      sp = stack.length;                                                                                               // 3995
      for (;j < plen; ++j) {                                                                                           // 3996
        if (points[j].index === -1) continue;                                                                          // 3997
        while (!d3_geom_hullCCW(stack[sp - 2], stack[sp - 1], points[j].index, vertices)) {                            // 3998
          --sp;                                                                                                        // 3999
        }                                                                                                              // 4000
        stack[sp++] = points[j].index;                                                                                 // 4001
      }                                                                                                                // 4002
      var poly = [];                                                                                                   // 4003
      for (i = 0; i < sp; ++i) {                                                                                       // 4004
        poly.push(data[stack[i]]);                                                                                     // 4005
      }                                                                                                                // 4006
      return poly;                                                                                                     // 4007
    }                                                                                                                  // 4008
    hull.x = function(_) {                                                                                             // 4009
      return arguments.length ? (x = _, hull) : x;                                                                     // 4010
    };                                                                                                                 // 4011
    hull.y = function(_) {                                                                                             // 4012
      return arguments.length ? (y = _, hull) : y;                                                                     // 4013
    };                                                                                                                 // 4014
    return hull;                                                                                                       // 4015
  };                                                                                                                   // 4016
  function d3_geom_hullCCW(i1, i2, i3, v) {                                                                            // 4017
    var t, a, b, c, d, e, f;                                                                                           // 4018
    t = v[i1];                                                                                                         // 4019
    a = t[0];                                                                                                          // 4020
    b = t[1];                                                                                                          // 4021
    t = v[i2];                                                                                                         // 4022
    c = t[0];                                                                                                          // 4023
    d = t[1];                                                                                                          // 4024
    t = v[i3];                                                                                                         // 4025
    e = t[0];                                                                                                          // 4026
    f = t[1];                                                                                                          // 4027
    return (f - b) * (c - a) - (d - b) * (e - a) > 0;                                                                  // 4028
  }                                                                                                                    // 4029
  d3.geom.polygon = function(coordinates) {                                                                            // 4030
    coordinates.area = function() {                                                                                    // 4031
      var i = 0, n = coordinates.length, area = coordinates[n - 1][1] * coordinates[0][0] - coordinates[n - 1][0] * coordinates[0][1];
      while (++i < n) {                                                                                                // 4033
        area += coordinates[i - 1][1] * coordinates[i][0] - coordinates[i - 1][0] * coordinates[i][1];                 // 4034
      }                                                                                                                // 4035
      return area * .5;                                                                                                // 4036
    };                                                                                                                 // 4037
    coordinates.centroid = function(k) {                                                                               // 4038
      var i = -1, n = coordinates.length, x = 0, y = 0, a, b = coordinates[n - 1], c;                                  // 4039
      if (!arguments.length) k = -1 / (6 * coordinates.area());                                                        // 4040
      while (++i < n) {                                                                                                // 4041
        a = b;                                                                                                         // 4042
        b = coordinates[i];                                                                                            // 4043
        c = a[0] * b[1] - b[0] * a[1];                                                                                 // 4044
        x += (a[0] + b[0]) * c;                                                                                        // 4045
        y += (a[1] + b[1]) * c;                                                                                        // 4046
      }                                                                                                                // 4047
      return [ x * k, y * k ];                                                                                         // 4048
    };                                                                                                                 // 4049
    coordinates.clip = function(subject) {                                                                             // 4050
      var input, i = -1, n = coordinates.length, j, m, a = coordinates[n - 1], b, c, d;                                // 4051
      while (++i < n) {                                                                                                // 4052
        input = subject.slice();                                                                                       // 4053
        subject.length = 0;                                                                                            // 4054
        b = coordinates[i];                                                                                            // 4055
        c = input[(m = input.length) - 1];                                                                             // 4056
        j = -1;                                                                                                        // 4057
        while (++j < m) {                                                                                              // 4058
          d = input[j];                                                                                                // 4059
          if (d3_geom_polygonInside(d, a, b)) {                                                                        // 4060
            if (!d3_geom_polygonInside(c, a, b)) {                                                                     // 4061
              subject.push(d3_geom_polygonIntersect(c, d, a, b));                                                      // 4062
            }                                                                                                          // 4063
            subject.push(d);                                                                                           // 4064
          } else if (d3_geom_polygonInside(c, a, b)) {                                                                 // 4065
            subject.push(d3_geom_polygonIntersect(c, d, a, b));                                                        // 4066
          }                                                                                                            // 4067
          c = d;                                                                                                       // 4068
        }                                                                                                              // 4069
        a = b;                                                                                                         // 4070
      }                                                                                                                // 4071
      return subject;                                                                                                  // 4072
    };                                                                                                                 // 4073
    return coordinates;                                                                                                // 4074
  };                                                                                                                   // 4075
  function d3_geom_polygonInside(p, a, b) {                                                                            // 4076
    return (b[0] - a[0]) * (p[1] - a[1]) < (b[1] - a[1]) * (p[0] - a[0]);                                              // 4077
  }                                                                                                                    // 4078
  function d3_geom_polygonIntersect(c, d, a, b) {                                                                      // 4079
    var x1 = c[0], x3 = a[0], x21 = d[0] - x1, x43 = b[0] - x3, y1 = c[1], y3 = a[1], y21 = d[1] - y1, y43 = b[1] - y3, ua = (x43 * (y1 - y3) - y43 * (x1 - x3)) / (y43 * x21 - x43 * y21);
    return [ x1 + ua * x21, y1 + ua * y21 ];                                                                           // 4081
  }                                                                                                                    // 4082
  d3.geom.delaunay = function(vertices) {                                                                              // 4083
    var edges = vertices.map(function() {                                                                              // 4084
      return [];                                                                                                       // 4085
    }), triangles = [];                                                                                                // 4086
    d3_geom_voronoiTessellate(vertices, function(e) {                                                                  // 4087
      edges[e.region.l.index].push(vertices[e.region.r.index]);                                                        // 4088
    });                                                                                                                // 4089
    edges.forEach(function(edge, i) {                                                                                  // 4090
      var v = vertices[i], cx = v[0], cy = v[1];                                                                       // 4091
      edge.forEach(function(v) {                                                                                       // 4092
        v.angle = Math.atan2(v[0] - cx, v[1] - cy);                                                                    // 4093
      });                                                                                                              // 4094
      edge.sort(function(a, b) {                                                                                       // 4095
        return a.angle - b.angle;                                                                                      // 4096
      });                                                                                                              // 4097
      for (var j = 0, m = edge.length - 1; j < m; j++) {                                                               // 4098
        triangles.push([ v, edge[j], edge[j + 1] ]);                                                                   // 4099
      }                                                                                                                // 4100
    });                                                                                                                // 4101
    return triangles;                                                                                                  // 4102
  };                                                                                                                   // 4103
  d3.geom.voronoi = function(points) {                                                                                 // 4104
    var size = null, x = d3_svg_lineX, y = d3_svg_lineY, clip;                                                         // 4105
    if (arguments.length) return voronoi(points);                                                                      // 4106
    function voronoi(data) {                                                                                           // 4107
      var points, polygons = data.map(function() {                                                                     // 4108
        return [];                                                                                                     // 4109
      }), fx = d3_functor(x), fy = d3_functor(y), d, i, n = data.length, Z = 1e6;                                      // 4110
      if (fx === d3_svg_lineX && fy === d3_svg_lineY) points = data; else for (points = [],                            // 4111
      i = 0; i < n; ++i) {                                                                                             // 4112
        points.push([ +fx.call(this, d = data[i], i), +fy.call(this, d, i) ]);                                         // 4113
      }                                                                                                                // 4114
      d3_geom_voronoiTessellate(points, function(e) {                                                                  // 4115
        var s1, s2, x1, x2, y1, y2;                                                                                    // 4116
        if (e.a === 1 && e.b >= 0) {                                                                                   // 4117
          s1 = e.ep.r;                                                                                                 // 4118
          s2 = e.ep.l;                                                                                                 // 4119
        } else {                                                                                                       // 4120
          s1 = e.ep.l;                                                                                                 // 4121
          s2 = e.ep.r;                                                                                                 // 4122
        }                                                                                                              // 4123
        if (e.a === 1) {                                                                                               // 4124
          y1 = s1 ? s1.y : -Z;                                                                                         // 4125
          x1 = e.c - e.b * y1;                                                                                         // 4126
          y2 = s2 ? s2.y : Z;                                                                                          // 4127
          x2 = e.c - e.b * y2;                                                                                         // 4128
        } else {                                                                                                       // 4129
          x1 = s1 ? s1.x : -Z;                                                                                         // 4130
          y1 = e.c - e.a * x1;                                                                                         // 4131
          x2 = s2 ? s2.x : Z;                                                                                          // 4132
          y2 = e.c - e.a * x2;                                                                                         // 4133
        }                                                                                                              // 4134
        var v1 = [ x1, y1 ], v2 = [ x2, y2 ];                                                                          // 4135
        polygons[e.region.l.index].push(v1, v2);                                                                       // 4136
        polygons[e.region.r.index].push(v1, v2);                                                                       // 4137
      });                                                                                                              // 4138
      polygons = polygons.map(function(polygon, i) {                                                                   // 4139
        var cx = points[i][0], cy = points[i][1], angle = polygon.map(function(v) {                                    // 4140
          return Math.atan2(v[0] - cx, v[1] - cy);                                                                     // 4141
        }), order = d3.range(polygon.length).sort(function(a, b) {                                                     // 4142
          return angle[a] - angle[b];                                                                                  // 4143
        });                                                                                                            // 4144
        return order.filter(function(d, i) {                                                                           // 4145
          return !i || angle[d] - angle[order[i - 1]] > ε;                                                             // 4146
        }).map(function(d) {                                                                                           // 4147
          return polygon[d];                                                                                           // 4148
        });                                                                                                            // 4149
      });                                                                                                              // 4150
      polygons.forEach(function(polygon, i) {                                                                          // 4151
        var n = polygon.length;                                                                                        // 4152
        if (!n) return polygon.push([ -Z, -Z ], [ -Z, Z ], [ Z, Z ], [ Z, -Z ]);                                       // 4153
        if (n > 2) return;                                                                                             // 4154
        var p0 = points[i], p1 = polygon[0], p2 = polygon[1], x0 = p0[0], y0 = p0[1], x1 = p1[0], y1 = p1[1], x2 = p2[0], y2 = p2[1], dx = Math.abs(x2 - x1), dy = y2 - y1;
        if (Math.abs(dy) < ε) {                                                                                        // 4156
          var y = y0 < y1 ? -Z : Z;                                                                                    // 4157
          polygon.push([ -Z, y ], [ Z, y ]);                                                                           // 4158
        } else if (dx < ε) {                                                                                           // 4159
          var x = x0 < x1 ? -Z : Z;                                                                                    // 4160
          polygon.push([ x, -Z ], [ x, Z ]);                                                                           // 4161
        } else {                                                                                                       // 4162
          var y = (x2 - x1) * (y1 - y0) < (x1 - x0) * (y2 - y1) ? Z : -Z, z = Math.abs(dy) - dx;                       // 4163
          if (Math.abs(z) < ε) {                                                                                       // 4164
            polygon.push([ dy < 0 ? y : -y, y ]);                                                                      // 4165
          } else {                                                                                                     // 4166
            if (z > 0) y *= -1;                                                                                        // 4167
            polygon.push([ -Z, y ], [ Z, y ]);                                                                         // 4168
          }                                                                                                            // 4169
        }                                                                                                              // 4170
      });                                                                                                              // 4171
      if (clip) for (i = 0; i < n; ++i) clip(polygons[i]);                                                             // 4172
      for (i = 0; i < n; ++i) polygons[i].point = data[i];                                                             // 4173
      return polygons;                                                                                                 // 4174
    }                                                                                                                  // 4175
    voronoi.x = function(_) {                                                                                          // 4176
      return arguments.length ? (x = _, voronoi) : x;                                                                  // 4177
    };                                                                                                                 // 4178
    voronoi.y = function(_) {                                                                                          // 4179
      return arguments.length ? (y = _, voronoi) : y;                                                                  // 4180
    };                                                                                                                 // 4181
    voronoi.size = function(_) {                                                                                       // 4182
      if (!arguments.length) return size;                                                                              // 4183
      if (_ == null) {                                                                                                 // 4184
        clip = null;                                                                                                   // 4185
      } else {                                                                                                         // 4186
        size = [ +_[0], +_[1] ];                                                                                       // 4187
        clip = d3.geom.polygon([ [ 0, 0 ], [ 0, size[1] ], size, [ size[0], 0 ] ]).clip;                               // 4188
      }                                                                                                                // 4189
      return voronoi;                                                                                                  // 4190
    };                                                                                                                 // 4191
    voronoi.links = function(data) {                                                                                   // 4192
      var points, graph = data.map(function() {                                                                        // 4193
        return [];                                                                                                     // 4194
      }), links = [], fx = d3_functor(x), fy = d3_functor(y), d, i, n = data.length;                                   // 4195
      if (fx === d3_svg_lineX && fy === d3_svg_lineY) points = data; else for (i = 0; i < n; ++i) {                    // 4196
        points.push([ +fx.call(this, d = data[i], i), +fy.call(this, d, i) ]);                                         // 4197
      }                                                                                                                // 4198
      d3_geom_voronoiTessellate(points, function(e) {                                                                  // 4199
        var l = e.region.l.index, r = e.region.r.index;                                                                // 4200
        if (graph[l][r]) return;                                                                                       // 4201
        graph[l][r] = graph[r][l] = true;                                                                              // 4202
        links.push({                                                                                                   // 4203
          source: data[l],                                                                                             // 4204
          target: data[r]                                                                                              // 4205
        });                                                                                                            // 4206
      });                                                                                                              // 4207
      return links;                                                                                                    // 4208
    };                                                                                                                 // 4209
    voronoi.triangles = function(data) {                                                                               // 4210
      if (x === d3_svg_lineX && y === d3_svg_lineY) return d3.geom.delaunay(data);                                     // 4211
      var points, point, fx = d3_functor(x), fy = d3_functor(y), d, i, n;                                              // 4212
      for (i = 0, points = [], n = data.length; i < n; ++i) {                                                          // 4213
        point = [ +fx.call(this, d = data[i], i), +fy.call(this, d, i) ];                                              // 4214
        point.data = d;                                                                                                // 4215
        points.push(point);                                                                                            // 4216
      }                                                                                                                // 4217
      return d3.geom.delaunay(points).map(function(triangle) {                                                         // 4218
        return triangle.map(function(point) {                                                                          // 4219
          return point.data;                                                                                           // 4220
        });                                                                                                            // 4221
      });                                                                                                              // 4222
    };                                                                                                                 // 4223
    return voronoi;                                                                                                    // 4224
  };                                                                                                                   // 4225
  var d3_geom_voronoiOpposite = {                                                                                      // 4226
    l: "r",                                                                                                            // 4227
    r: "l"                                                                                                             // 4228
  };                                                                                                                   // 4229
  function d3_geom_voronoiTessellate(points, callback) {                                                               // 4230
    var Sites = {                                                                                                      // 4231
      list: points.map(function(v, i) {                                                                                // 4232
        return {                                                                                                       // 4233
          index: i,                                                                                                    // 4234
          x: v[0],                                                                                                     // 4235
          y: v[1]                                                                                                      // 4236
        };                                                                                                             // 4237
      }).sort(function(a, b) {                                                                                         // 4238
        return a.y < b.y ? -1 : a.y > b.y ? 1 : a.x < b.x ? -1 : a.x > b.x ? 1 : 0;                                    // 4239
      }),                                                                                                              // 4240
      bottomSite: null                                                                                                 // 4241
    };                                                                                                                 // 4242
    var EdgeList = {                                                                                                   // 4243
      list: [],                                                                                                        // 4244
      leftEnd: null,                                                                                                   // 4245
      rightEnd: null,                                                                                                  // 4246
      init: function() {                                                                                               // 4247
        EdgeList.leftEnd = EdgeList.createHalfEdge(null, "l");                                                         // 4248
        EdgeList.rightEnd = EdgeList.createHalfEdge(null, "l");                                                        // 4249
        EdgeList.leftEnd.r = EdgeList.rightEnd;                                                                        // 4250
        EdgeList.rightEnd.l = EdgeList.leftEnd;                                                                        // 4251
        EdgeList.list.unshift(EdgeList.leftEnd, EdgeList.rightEnd);                                                    // 4252
      },                                                                                                               // 4253
      createHalfEdge: function(edge, side) {                                                                           // 4254
        return {                                                                                                       // 4255
          edge: edge,                                                                                                  // 4256
          side: side,                                                                                                  // 4257
          vertex: null,                                                                                                // 4258
          l: null,                                                                                                     // 4259
          r: null                                                                                                      // 4260
        };                                                                                                             // 4261
      },                                                                                                               // 4262
      insert: function(lb, he) {                                                                                       // 4263
        he.l = lb;                                                                                                     // 4264
        he.r = lb.r;                                                                                                   // 4265
        lb.r.l = he;                                                                                                   // 4266
        lb.r = he;                                                                                                     // 4267
      },                                                                                                               // 4268
      leftBound: function(p) {                                                                                         // 4269
        var he = EdgeList.leftEnd;                                                                                     // 4270
        do {                                                                                                           // 4271
          he = he.r;                                                                                                   // 4272
        } while (he != EdgeList.rightEnd && Geom.rightOf(he, p));                                                      // 4273
        he = he.l;                                                                                                     // 4274
        return he;                                                                                                     // 4275
      },                                                                                                               // 4276
      del: function(he) {                                                                                              // 4277
        he.l.r = he.r;                                                                                                 // 4278
        he.r.l = he.l;                                                                                                 // 4279
        he.edge = null;                                                                                                // 4280
      },                                                                                                               // 4281
      right: function(he) {                                                                                            // 4282
        return he.r;                                                                                                   // 4283
      },                                                                                                               // 4284
      left: function(he) {                                                                                             // 4285
        return he.l;                                                                                                   // 4286
      },                                                                                                               // 4287
      leftRegion: function(he) {                                                                                       // 4288
        return he.edge == null ? Sites.bottomSite : he.edge.region[he.side];                                           // 4289
      },                                                                                                               // 4290
      rightRegion: function(he) {                                                                                      // 4291
        return he.edge == null ? Sites.bottomSite : he.edge.region[d3_geom_voronoiOpposite[he.side]];                  // 4292
      }                                                                                                                // 4293
    };                                                                                                                 // 4294
    var Geom = {                                                                                                       // 4295
      bisect: function(s1, s2) {                                                                                       // 4296
        var newEdge = {                                                                                                // 4297
          region: {                                                                                                    // 4298
            l: s1,                                                                                                     // 4299
            r: s2                                                                                                      // 4300
          },                                                                                                           // 4301
          ep: {                                                                                                        // 4302
            l: null,                                                                                                   // 4303
            r: null                                                                                                    // 4304
          }                                                                                                            // 4305
        };                                                                                                             // 4306
        var dx = s2.x - s1.x, dy = s2.y - s1.y, adx = dx > 0 ? dx : -dx, ady = dy > 0 ? dy : -dy;                      // 4307
        newEdge.c = s1.x * dx + s1.y * dy + (dx * dx + dy * dy) * .5;                                                  // 4308
        if (adx > ady) {                                                                                               // 4309
          newEdge.a = 1;                                                                                               // 4310
          newEdge.b = dy / dx;                                                                                         // 4311
          newEdge.c /= dx;                                                                                             // 4312
        } else {                                                                                                       // 4313
          newEdge.b = 1;                                                                                               // 4314
          newEdge.a = dx / dy;                                                                                         // 4315
          newEdge.c /= dy;                                                                                             // 4316
        }                                                                                                              // 4317
        return newEdge;                                                                                                // 4318
      },                                                                                                               // 4319
      intersect: function(el1, el2) {                                                                                  // 4320
        var e1 = el1.edge, e2 = el2.edge;                                                                              // 4321
        if (!e1 || !e2 || e1.region.r == e2.region.r) {                                                                // 4322
          return null;                                                                                                 // 4323
        }                                                                                                              // 4324
        var d = e1.a * e2.b - e1.b * e2.a;                                                                             // 4325
        if (Math.abs(d) < 1e-10) {                                                                                     // 4326
          return null;                                                                                                 // 4327
        }                                                                                                              // 4328
        var xint = (e1.c * e2.b - e2.c * e1.b) / d, yint = (e2.c * e1.a - e1.c * e2.a) / d, e1r = e1.region.r, e2r = e2.region.r, el, e;
        if (e1r.y < e2r.y || e1r.y == e2r.y && e1r.x < e2r.x) {                                                        // 4330
          el = el1;                                                                                                    // 4331
          e = e1;                                                                                                      // 4332
        } else {                                                                                                       // 4333
          el = el2;                                                                                                    // 4334
          e = e2;                                                                                                      // 4335
        }                                                                                                              // 4336
        var rightOfSite = xint >= e.region.r.x;                                                                        // 4337
        if (rightOfSite && el.side === "l" || !rightOfSite && el.side === "r") {                                       // 4338
          return null;                                                                                                 // 4339
        }                                                                                                              // 4340
        return {                                                                                                       // 4341
          x: xint,                                                                                                     // 4342
          y: yint                                                                                                      // 4343
        };                                                                                                             // 4344
      },                                                                                                               // 4345
      rightOf: function(he, p) {                                                                                       // 4346
        var e = he.edge, topsite = e.region.r, rightOfSite = p.x > topsite.x;                                          // 4347
        if (rightOfSite && he.side === "l") {                                                                          // 4348
          return 1;                                                                                                    // 4349
        }                                                                                                              // 4350
        if (!rightOfSite && he.side === "r") {                                                                         // 4351
          return 0;                                                                                                    // 4352
        }                                                                                                              // 4353
        if (e.a === 1) {                                                                                               // 4354
          var dyp = p.y - topsite.y, dxp = p.x - topsite.x, fast = 0, above = 0;                                       // 4355
          if (!rightOfSite && e.b < 0 || rightOfSite && e.b >= 0) {                                                    // 4356
            above = fast = dyp >= e.b * dxp;                                                                           // 4357
          } else {                                                                                                     // 4358
            above = p.x + p.y * e.b > e.c;                                                                             // 4359
            if (e.b < 0) {                                                                                             // 4360
              above = !above;                                                                                          // 4361
            }                                                                                                          // 4362
            if (!above) {                                                                                              // 4363
              fast = 1;                                                                                                // 4364
            }                                                                                                          // 4365
          }                                                                                                            // 4366
          if (!fast) {                                                                                                 // 4367
            var dxs = topsite.x - e.region.l.x;                                                                        // 4368
            above = e.b * (dxp * dxp - dyp * dyp) < dxs * dyp * (1 + 2 * dxp / dxs + e.b * e.b);                       // 4369
            if (e.b < 0) {                                                                                             // 4370
              above = !above;                                                                                          // 4371
            }                                                                                                          // 4372
          }                                                                                                            // 4373
        } else {                                                                                                       // 4374
          var yl = e.c - e.a * p.x, t1 = p.y - yl, t2 = p.x - topsite.x, t3 = yl - topsite.y;                          // 4375
          above = t1 * t1 > t2 * t2 + t3 * t3;                                                                         // 4376
        }                                                                                                              // 4377
        return he.side === "l" ? above : !above;                                                                       // 4378
      },                                                                                                               // 4379
      endPoint: function(edge, side, site) {                                                                           // 4380
        edge.ep[side] = site;                                                                                          // 4381
        if (!edge.ep[d3_geom_voronoiOpposite[side]]) return;                                                           // 4382
        callback(edge);                                                                                                // 4383
      },                                                                                                               // 4384
      distance: function(s, t) {                                                                                       // 4385
        var dx = s.x - t.x, dy = s.y - t.y;                                                                            // 4386
        return Math.sqrt(dx * dx + dy * dy);                                                                           // 4387
      }                                                                                                                // 4388
    };                                                                                                                 // 4389
    var EventQueue = {                                                                                                 // 4390
      list: [],                                                                                                        // 4391
      insert: function(he, site, offset) {                                                                             // 4392
        he.vertex = site;                                                                                              // 4393
        he.ystar = site.y + offset;                                                                                    // 4394
        for (var i = 0, list = EventQueue.list, l = list.length; i < l; i++) {                                         // 4395
          var next = list[i];                                                                                          // 4396
          if (he.ystar > next.ystar || he.ystar == next.ystar && site.x > next.vertex.x) {                             // 4397
            continue;                                                                                                  // 4398
          } else {                                                                                                     // 4399
            break;                                                                                                     // 4400
          }                                                                                                            // 4401
        }                                                                                                              // 4402
        list.splice(i, 0, he);                                                                                         // 4403
      },                                                                                                               // 4404
      del: function(he) {                                                                                              // 4405
        for (var i = 0, ls = EventQueue.list, l = ls.length; i < l && ls[i] != he; ++i) {}                             // 4406
        ls.splice(i, 1);                                                                                               // 4407
      },                                                                                                               // 4408
      empty: function() {                                                                                              // 4409
        return EventQueue.list.length === 0;                                                                           // 4410
      },                                                                                                               // 4411
      nextEvent: function(he) {                                                                                        // 4412
        for (var i = 0, ls = EventQueue.list, l = ls.length; i < l; ++i) {                                             // 4413
          if (ls[i] == he) return ls[i + 1];                                                                           // 4414
        }                                                                                                              // 4415
        return null;                                                                                                   // 4416
      },                                                                                                               // 4417
      min: function() {                                                                                                // 4418
        var elem = EventQueue.list[0];                                                                                 // 4419
        return {                                                                                                       // 4420
          x: elem.vertex.x,                                                                                            // 4421
          y: elem.ystar                                                                                                // 4422
        };                                                                                                             // 4423
      },                                                                                                               // 4424
      extractMin: function() {                                                                                         // 4425
        return EventQueue.list.shift();                                                                                // 4426
      }                                                                                                                // 4427
    };                                                                                                                 // 4428
    EdgeList.init();                                                                                                   // 4429
    Sites.bottomSite = Sites.list.shift();                                                                             // 4430
    var newSite = Sites.list.shift(), newIntStar;                                                                      // 4431
    var lbnd, rbnd, llbnd, rrbnd, bisector;                                                                            // 4432
    var bot, top, temp, p, v;                                                                                          // 4433
    var e, pm;                                                                                                         // 4434
    while (true) {                                                                                                     // 4435
      if (!EventQueue.empty()) {                                                                                       // 4436
        newIntStar = EventQueue.min();                                                                                 // 4437
      }                                                                                                                // 4438
      if (newSite && (EventQueue.empty() || newSite.y < newIntStar.y || newSite.y == newIntStar.y && newSite.x < newIntStar.x)) {
        lbnd = EdgeList.leftBound(newSite);                                                                            // 4440
        rbnd = EdgeList.right(lbnd);                                                                                   // 4441
        bot = EdgeList.rightRegion(lbnd);                                                                              // 4442
        e = Geom.bisect(bot, newSite);                                                                                 // 4443
        bisector = EdgeList.createHalfEdge(e, "l");                                                                    // 4444
        EdgeList.insert(lbnd, bisector);                                                                               // 4445
        p = Geom.intersect(lbnd, bisector);                                                                            // 4446
        if (p) {                                                                                                       // 4447
          EventQueue.del(lbnd);                                                                                        // 4448
          EventQueue.insert(lbnd, p, Geom.distance(p, newSite));                                                       // 4449
        }                                                                                                              // 4450
        lbnd = bisector;                                                                                               // 4451
        bisector = EdgeList.createHalfEdge(e, "r");                                                                    // 4452
        EdgeList.insert(lbnd, bisector);                                                                               // 4453
        p = Geom.intersect(bisector, rbnd);                                                                            // 4454
        if (p) {                                                                                                       // 4455
          EventQueue.insert(bisector, p, Geom.distance(p, newSite));                                                   // 4456
        }                                                                                                              // 4457
        newSite = Sites.list.shift();                                                                                  // 4458
      } else if (!EventQueue.empty()) {                                                                                // 4459
        lbnd = EventQueue.extractMin();                                                                                // 4460
        llbnd = EdgeList.left(lbnd);                                                                                   // 4461
        rbnd = EdgeList.right(lbnd);                                                                                   // 4462
        rrbnd = EdgeList.right(rbnd);                                                                                  // 4463
        bot = EdgeList.leftRegion(lbnd);                                                                               // 4464
        top = EdgeList.rightRegion(rbnd);                                                                              // 4465
        v = lbnd.vertex;                                                                                               // 4466
        Geom.endPoint(lbnd.edge, lbnd.side, v);                                                                        // 4467
        Geom.endPoint(rbnd.edge, rbnd.side, v);                                                                        // 4468
        EdgeList.del(lbnd);                                                                                            // 4469
        EventQueue.del(rbnd);                                                                                          // 4470
        EdgeList.del(rbnd);                                                                                            // 4471
        pm = "l";                                                                                                      // 4472
        if (bot.y > top.y) {                                                                                           // 4473
          temp = bot;                                                                                                  // 4474
          bot = top;                                                                                                   // 4475
          top = temp;                                                                                                  // 4476
          pm = "r";                                                                                                    // 4477
        }                                                                                                              // 4478
        e = Geom.bisect(bot, top);                                                                                     // 4479
        bisector = EdgeList.createHalfEdge(e, pm);                                                                     // 4480
        EdgeList.insert(llbnd, bisector);                                                                              // 4481
        Geom.endPoint(e, d3_geom_voronoiOpposite[pm], v);                                                              // 4482
        p = Geom.intersect(llbnd, bisector);                                                                           // 4483
        if (p) {                                                                                                       // 4484
          EventQueue.del(llbnd);                                                                                       // 4485
          EventQueue.insert(llbnd, p, Geom.distance(p, bot));                                                          // 4486
        }                                                                                                              // 4487
        p = Geom.intersect(bisector, rrbnd);                                                                           // 4488
        if (p) {                                                                                                       // 4489
          EventQueue.insert(bisector, p, Geom.distance(p, bot));                                                       // 4490
        }                                                                                                              // 4491
      } else {                                                                                                         // 4492
        break;                                                                                                         // 4493
      }                                                                                                                // 4494
    }                                                                                                                  // 4495
    for (lbnd = EdgeList.right(EdgeList.leftEnd); lbnd != EdgeList.rightEnd; lbnd = EdgeList.right(lbnd)) {            // 4496
      callback(lbnd.edge);                                                                                             // 4497
    }                                                                                                                  // 4498
  }                                                                                                                    // 4499
  d3.geom.quadtree = function(points, x1, y1, x2, y2) {                                                                // 4500
    var x = d3_svg_lineX, y = d3_svg_lineY, compat;                                                                    // 4501
    if (compat = arguments.length) {                                                                                   // 4502
      x = d3_geom_quadtreeCompatX;                                                                                     // 4503
      y = d3_geom_quadtreeCompatY;                                                                                     // 4504
      if (compat === 3) {                                                                                              // 4505
        y2 = y1;                                                                                                       // 4506
        x2 = x1;                                                                                                       // 4507
        y1 = x1 = 0;                                                                                                   // 4508
      }                                                                                                                // 4509
      return quadtree(points);                                                                                         // 4510
    }                                                                                                                  // 4511
    function quadtree(data) {                                                                                          // 4512
      var d, fx = d3_functor(x), fy = d3_functor(y), xs, ys, i, n, x1_, y1_, x2_, y2_;                                 // 4513
      if (x1 != null) {                                                                                                // 4514
        x1_ = x1, y1_ = y1, x2_ = x2, y2_ = y2;                                                                        // 4515
      } else {                                                                                                         // 4516
        x2_ = y2_ = -(x1_ = y1_ = Infinity);                                                                           // 4517
        xs = [], ys = [];                                                                                              // 4518
        n = data.length;                                                                                               // 4519
        if (compat) for (i = 0; i < n; ++i) {                                                                          // 4520
          d = data[i];                                                                                                 // 4521
          if (d.x < x1_) x1_ = d.x;                                                                                    // 4522
          if (d.y < y1_) y1_ = d.y;                                                                                    // 4523
          if (d.x > x2_) x2_ = d.x;                                                                                    // 4524
          if (d.y > y2_) y2_ = d.y;                                                                                    // 4525
          xs.push(d.x);                                                                                                // 4526
          ys.push(d.y);                                                                                                // 4527
        } else for (i = 0; i < n; ++i) {                                                                               // 4528
          var x_ = +fx(d = data[i], i), y_ = +fy(d, i);                                                                // 4529
          if (x_ < x1_) x1_ = x_;                                                                                      // 4530
          if (y_ < y1_) y1_ = y_;                                                                                      // 4531
          if (x_ > x2_) x2_ = x_;                                                                                      // 4532
          if (y_ > y2_) y2_ = y_;                                                                                      // 4533
          xs.push(x_);                                                                                                 // 4534
          ys.push(y_);                                                                                                 // 4535
        }                                                                                                              // 4536
      }                                                                                                                // 4537
      var dx = x2_ - x1_, dy = y2_ - y1_;                                                                              // 4538
      if (dx > dy) y2_ = y1_ + dx; else x2_ = x1_ + dy;                                                                // 4539
      function insert(n, d, x, y, x1, y1, x2, y2) {                                                                    // 4540
        if (isNaN(x) || isNaN(y)) return;                                                                              // 4541
        if (n.leaf) {                                                                                                  // 4542
          var nx = n.x, ny = n.y;                                                                                      // 4543
          if (nx != null) {                                                                                            // 4544
            if (Math.abs(nx - x) + Math.abs(ny - y) < .01) {                                                           // 4545
              insertChild(n, d, x, y, x1, y1, x2, y2);                                                                 // 4546
            } else {                                                                                                   // 4547
              var nPoint = n.point;                                                                                    // 4548
              n.x = n.y = n.point = null;                                                                              // 4549
              insertChild(n, nPoint, nx, ny, x1, y1, x2, y2);                                                          // 4550
              insertChild(n, d, x, y, x1, y1, x2, y2);                                                                 // 4551
            }                                                                                                          // 4552
          } else {                                                                                                     // 4553
            n.x = x, n.y = y, n.point = d;                                                                             // 4554
          }                                                                                                            // 4555
        } else {                                                                                                       // 4556
          insertChild(n, d, x, y, x1, y1, x2, y2);                                                                     // 4557
        }                                                                                                              // 4558
      }                                                                                                                // 4559
      function insertChild(n, d, x, y, x1, y1, x2, y2) {                                                               // 4560
        var sx = (x1 + x2) * .5, sy = (y1 + y2) * .5, right = x >= sx, bottom = y >= sy, i = (bottom << 1) + right;    // 4561
        n.leaf = false;                                                                                                // 4562
        n = n.nodes[i] || (n.nodes[i] = d3_geom_quadtreeNode());                                                       // 4563
        if (right) x1 = sx; else x2 = sx;                                                                              // 4564
        if (bottom) y1 = sy; else y2 = sy;                                                                             // 4565
        insert(n, d, x, y, x1, y1, x2, y2);                                                                            // 4566
      }                                                                                                                // 4567
      var root = d3_geom_quadtreeNode();                                                                               // 4568
      root.add = function(d) {                                                                                         // 4569
        insert(root, d, +fx(d, ++i), +fy(d, i), x1_, y1_, x2_, y2_);                                                   // 4570
      };                                                                                                               // 4571
      root.visit = function(f) {                                                                                       // 4572
        d3_geom_quadtreeVisit(f, root, x1_, y1_, x2_, y2_);                                                            // 4573
      };                                                                                                               // 4574
      i = -1;                                                                                                          // 4575
      if (x1 == null) {                                                                                                // 4576
        while (++i < n) {                                                                                              // 4577
          insert(root, data[i], xs[i], ys[i], x1_, y1_, x2_, y2_);                                                     // 4578
        }                                                                                                              // 4579
        --i;                                                                                                           // 4580
      } else data.forEach(root.add);                                                                                   // 4581
      xs = ys = data = d = null;                                                                                       // 4582
      return root;                                                                                                     // 4583
    }                                                                                                                  // 4584
    quadtree.x = function(_) {                                                                                         // 4585
      return arguments.length ? (x = _, quadtree) : x;                                                                 // 4586
    };                                                                                                                 // 4587
    quadtree.y = function(_) {                                                                                         // 4588
      return arguments.length ? (y = _, quadtree) : y;                                                                 // 4589
    };                                                                                                                 // 4590
    quadtree.size = function(_) {                                                                                      // 4591
      if (!arguments.length) return x1 == null ? null : [ x2, y2 ];                                                    // 4592
      if (_ == null) {                                                                                                 // 4593
        x1 = y1 = x2 = y2 = null;                                                                                      // 4594
      } else {                                                                                                         // 4595
        x1 = y1 = 0;                                                                                                   // 4596
        x2 = +_[0], y2 = +_[1];                                                                                        // 4597
      }                                                                                                                // 4598
      return quadtree;                                                                                                 // 4599
    };                                                                                                                 // 4600
    return quadtree;                                                                                                   // 4601
  };                                                                                                                   // 4602
  function d3_geom_quadtreeCompatX(d) {                                                                                // 4603
    return d.x;                                                                                                        // 4604
  }                                                                                                                    // 4605
  function d3_geom_quadtreeCompatY(d) {                                                                                // 4606
    return d.y;                                                                                                        // 4607
  }                                                                                                                    // 4608
  function d3_geom_quadtreeNode() {                                                                                    // 4609
    return {                                                                                                           // 4610
      leaf: true,                                                                                                      // 4611
      nodes: [],                                                                                                       // 4612
      point: null,                                                                                                     // 4613
      x: null,                                                                                                         // 4614
      y: null                                                                                                          // 4615
    };                                                                                                                 // 4616
  }                                                                                                                    // 4617
  function d3_geom_quadtreeVisit(f, node, x1, y1, x2, y2) {                                                            // 4618
    if (!f(node, x1, y1, x2, y2)) {                                                                                    // 4619
      var sx = (x1 + x2) * .5, sy = (y1 + y2) * .5, children = node.nodes;                                             // 4620
      if (children[0]) d3_geom_quadtreeVisit(f, children[0], x1, y1, sx, sy);                                          // 4621
      if (children[1]) d3_geom_quadtreeVisit(f, children[1], sx, y1, x2, sy);                                          // 4622
      if (children[2]) d3_geom_quadtreeVisit(f, children[2], x1, sy, sx, y2);                                          // 4623
      if (children[3]) d3_geom_quadtreeVisit(f, children[3], sx, sy, x2, y2);                                          // 4624
    }                                                                                                                  // 4625
  }                                                                                                                    // 4626
  d3.interpolateRgb = d3_interpolateRgb;                                                                               // 4627
  function d3_interpolateRgb(a, b) {                                                                                   // 4628
    a = d3.rgb(a);                                                                                                     // 4629
    b = d3.rgb(b);                                                                                                     // 4630
    var ar = a.r, ag = a.g, ab = a.b, br = b.r - ar, bg = b.g - ag, bb = b.b - ab;                                     // 4631
    return function(t) {                                                                                               // 4632
      return "#" + d3_rgb_hex(Math.round(ar + br * t)) + d3_rgb_hex(Math.round(ag + bg * t)) + d3_rgb_hex(Math.round(ab + bb * t));
    };                                                                                                                 // 4634
  }                                                                                                                    // 4635
  d3.transform = function(string) {                                                                                    // 4636
    var g = d3_document.createElementNS(d3.ns.prefix.svg, "g");                                                        // 4637
    return (d3.transform = function(string) {                                                                          // 4638
      g.setAttribute("transform", string);                                                                             // 4639
      var t = g.transform.baseVal.consolidate();                                                                       // 4640
      return new d3_transform(t ? t.matrix : d3_transformIdentity);                                                    // 4641
    })(string);                                                                                                        // 4642
  };                                                                                                                   // 4643
  function d3_transform(m) {                                                                                           // 4644
    var r0 = [ m.a, m.b ], r1 = [ m.c, m.d ], kx = d3_transformNormalize(r0), kz = d3_transformDot(r0, r1), ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz)) || 0;
    if (r0[0] * r1[1] < r1[0] * r0[1]) {                                                                               // 4646
      r0[0] *= -1;                                                                                                     // 4647
      r0[1] *= -1;                                                                                                     // 4648
      kx *= -1;                                                                                                        // 4649
      kz *= -1;                                                                                                        // 4650
    }                                                                                                                  // 4651
    this.rotate = (kx ? Math.atan2(r0[1], r0[0]) : Math.atan2(-r1[0], r1[1])) * d3_degrees;                            // 4652
    this.translate = [ m.e, m.f ];                                                                                     // 4653
    this.scale = [ kx, ky ];                                                                                           // 4654
    this.skew = ky ? Math.atan2(kz, ky) * d3_degrees : 0;                                                              // 4655
  }                                                                                                                    // 4656
  d3_transform.prototype.toString = function() {                                                                       // 4657
    return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
  };                                                                                                                   // 4659
  function d3_transformDot(a, b) {                                                                                     // 4660
    return a[0] * b[0] + a[1] * b[1];                                                                                  // 4661
  }                                                                                                                    // 4662
  function d3_transformNormalize(a) {                                                                                  // 4663
    var k = Math.sqrt(d3_transformDot(a, a));                                                                          // 4664
    if (k) {                                                                                                           // 4665
      a[0] /= k;                                                                                                       // 4666
      a[1] /= k;                                                                                                       // 4667
    }                                                                                                                  // 4668
    return k;                                                                                                          // 4669
  }                                                                                                                    // 4670
  function d3_transformCombine(a, b, k) {                                                                              // 4671
    a[0] += k * b[0];                                                                                                  // 4672
    a[1] += k * b[1];                                                                                                  // 4673
    return a;                                                                                                          // 4674
  }                                                                                                                    // 4675
  var d3_transformIdentity = {                                                                                         // 4676
    a: 1,                                                                                                              // 4677
    b: 0,                                                                                                              // 4678
    c: 0,                                                                                                              // 4679
    d: 1,                                                                                                              // 4680
    e: 0,                                                                                                              // 4681
    f: 0                                                                                                               // 4682
  };                                                                                                                   // 4683
  d3.interpolateNumber = d3_interpolateNumber;                                                                         // 4684
  function d3_interpolateNumber(a, b) {                                                                                // 4685
    b -= a;                                                                                                            // 4686
    return function(t) {                                                                                               // 4687
      return a + b * t;                                                                                                // 4688
    };                                                                                                                 // 4689
  }                                                                                                                    // 4690
  d3.interpolateTransform = d3_interpolateTransform;                                                                   // 4691
  function d3_interpolateTransform(a, b) {                                                                             // 4692
    var s = [], q = [], n, A = d3.transform(a), B = d3.transform(b), ta = A.translate, tb = B.translate, ra = A.rotate, rb = B.rotate, wa = A.skew, wb = B.skew, ka = A.scale, kb = B.scale;
    if (ta[0] != tb[0] || ta[1] != tb[1]) {                                                                            // 4694
      s.push("translate(", null, ",", null, ")");                                                                      // 4695
      q.push({                                                                                                         // 4696
        i: 1,                                                                                                          // 4697
        x: d3_interpolateNumber(ta[0], tb[0])                                                                          // 4698
      }, {                                                                                                             // 4699
        i: 3,                                                                                                          // 4700
        x: d3_interpolateNumber(ta[1], tb[1])                                                                          // 4701
      });                                                                                                              // 4702
    } else if (tb[0] || tb[1]) {                                                                                       // 4703
      s.push("translate(" + tb + ")");                                                                                 // 4704
    } else {                                                                                                           // 4705
      s.push("");                                                                                                      // 4706
    }                                                                                                                  // 4707
    if (ra != rb) {                                                                                                    // 4708
      if (ra - rb > 180) rb += 360; else if (rb - ra > 180) ra += 360;                                                 // 4709
      q.push({                                                                                                         // 4710
        i: s.push(s.pop() + "rotate(", null, ")") - 2,                                                                 // 4711
        x: d3_interpolateNumber(ra, rb)                                                                                // 4712
      });                                                                                                              // 4713
    } else if (rb) {                                                                                                   // 4714
      s.push(s.pop() + "rotate(" + rb + ")");                                                                          // 4715
    }                                                                                                                  // 4716
    if (wa != wb) {                                                                                                    // 4717
      q.push({                                                                                                         // 4718
        i: s.push(s.pop() + "skewX(", null, ")") - 2,                                                                  // 4719
        x: d3_interpolateNumber(wa, wb)                                                                                // 4720
      });                                                                                                              // 4721
    } else if (wb) {                                                                                                   // 4722
      s.push(s.pop() + "skewX(" + wb + ")");                                                                           // 4723
    }                                                                                                                  // 4724
    if (ka[0] != kb[0] || ka[1] != kb[1]) {                                                                            // 4725
      n = s.push(s.pop() + "scale(", null, ",", null, ")");                                                            // 4726
      q.push({                                                                                                         // 4727
        i: n - 4,                                                                                                      // 4728
        x: d3_interpolateNumber(ka[0], kb[0])                                                                          // 4729
      }, {                                                                                                             // 4730
        i: n - 2,                                                                                                      // 4731
        x: d3_interpolateNumber(ka[1], kb[1])                                                                          // 4732
      });                                                                                                              // 4733
    } else if (kb[0] != 1 || kb[1] != 1) {                                                                             // 4734
      s.push(s.pop() + "scale(" + kb + ")");                                                                           // 4735
    }                                                                                                                  // 4736
    n = q.length;                                                                                                      // 4737
    return function(t) {                                                                                               // 4738
      var i = -1, o;                                                                                                   // 4739
      while (++i < n) s[(o = q[i]).i] = o.x(t);                                                                        // 4740
      return s.join("");                                                                                               // 4741
    };                                                                                                                 // 4742
  }                                                                                                                    // 4743
  d3.interpolateObject = d3_interpolateObject;                                                                         // 4744
  function d3_interpolateObject(a, b) {                                                                                // 4745
    var i = {}, c = {}, k;                                                                                             // 4746
    for (k in a) {                                                                                                     // 4747
      if (k in b) {                                                                                                    // 4748
        i[k] = d3_interpolateByName(k)(a[k], b[k]);                                                                    // 4749
      } else {                                                                                                         // 4750
        c[k] = a[k];                                                                                                   // 4751
      }                                                                                                                // 4752
    }                                                                                                                  // 4753
    for (k in b) {                                                                                                     // 4754
      if (!(k in a)) {                                                                                                 // 4755
        c[k] = b[k];                                                                                                   // 4756
      }                                                                                                                // 4757
    }                                                                                                                  // 4758
    return function(t) {                                                                                               // 4759
      for (k in i) c[k] = i[k](t);                                                                                     // 4760
      return c;                                                                                                        // 4761
    };                                                                                                                 // 4762
  }                                                                                                                    // 4763
  d3.interpolateString = d3_interpolateString;                                                                         // 4764
  function d3_interpolateString(a, b) {                                                                                // 4765
    var m, i, j, s0 = 0, s1 = 0, s = [], q = [], n, o;                                                                 // 4766
    d3_interpolate_number.lastIndex = 0;                                                                               // 4767
    for (i = 0; m = d3_interpolate_number.exec(b); ++i) {                                                              // 4768
      if (m.index) s.push(b.substring(s0, s1 = m.index));                                                              // 4769
      q.push({                                                                                                         // 4770
        i: s.length,                                                                                                   // 4771
        x: m[0]                                                                                                        // 4772
      });                                                                                                              // 4773
      s.push(null);                                                                                                    // 4774
      s0 = d3_interpolate_number.lastIndex;                                                                            // 4775
    }                                                                                                                  // 4776
    if (s0 < b.length) s.push(b.substring(s0));                                                                        // 4777
    for (i = 0, n = q.length; (m = d3_interpolate_number.exec(a)) && i < n; ++i) {                                     // 4778
      o = q[i];                                                                                                        // 4779
      if (o.x == m[0]) {                                                                                               // 4780
        if (o.i) {                                                                                                     // 4781
          if (s[o.i + 1] == null) {                                                                                    // 4782
            s[o.i - 1] += o.x;                                                                                         // 4783
            s.splice(o.i, 1);                                                                                          // 4784
            for (j = i + 1; j < n; ++j) q[j].i--;                                                                      // 4785
          } else {                                                                                                     // 4786
            s[o.i - 1] += o.x + s[o.i + 1];                                                                            // 4787
            s.splice(o.i, 2);                                                                                          // 4788
            for (j = i + 1; j < n; ++j) q[j].i -= 2;                                                                   // 4789
          }                                                                                                            // 4790
        } else {                                                                                                       // 4791
          if (s[o.i + 1] == null) {                                                                                    // 4792
            s[o.i] = o.x;                                                                                              // 4793
          } else {                                                                                                     // 4794
            s[o.i] = o.x + s[o.i + 1];                                                                                 // 4795
            s.splice(o.i + 1, 1);                                                                                      // 4796
            for (j = i + 1; j < n; ++j) q[j].i--;                                                                      // 4797
          }                                                                                                            // 4798
        }                                                                                                              // 4799
        q.splice(i, 1);                                                                                                // 4800
        n--;                                                                                                           // 4801
        i--;                                                                                                           // 4802
      } else {                                                                                                         // 4803
        o.x = d3_interpolateNumber(parseFloat(m[0]), parseFloat(o.x));                                                 // 4804
      }                                                                                                                // 4805
    }                                                                                                                  // 4806
    while (i < n) {                                                                                                    // 4807
      o = q.pop();                                                                                                     // 4808
      if (s[o.i + 1] == null) {                                                                                        // 4809
        s[o.i] = o.x;                                                                                                  // 4810
      } else {                                                                                                         // 4811
        s[o.i] = o.x + s[o.i + 1];                                                                                     // 4812
        s.splice(o.i + 1, 1);                                                                                          // 4813
      }                                                                                                                // 4814
      n--;                                                                                                             // 4815
    }                                                                                                                  // 4816
    if (s.length === 1) {                                                                                              // 4817
      return s[0] == null ? q[0].x : function() {                                                                      // 4818
        return b;                                                                                                      // 4819
      };                                                                                                               // 4820
    }                                                                                                                  // 4821
    return function(t) {                                                                                               // 4822
      for (i = 0; i < n; ++i) s[(o = q[i]).i] = o.x(t);                                                                // 4823
      return s.join("");                                                                                               // 4824
    };                                                                                                                 // 4825
  }                                                                                                                    // 4826
  var d3_interpolate_number = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g;                                           // 4827
  d3.interpolate = d3_interpolate;                                                                                     // 4828
  function d3_interpolate(a, b) {                                                                                      // 4829
    var i = d3.interpolators.length, f;                                                                                // 4830
    while (--i >= 0 && !(f = d3.interpolators[i](a, b))) ;                                                             // 4831
    return f;                                                                                                          // 4832
  }                                                                                                                    // 4833
  function d3_interpolateByName(name) {                                                                                // 4834
    return name == "transform" ? d3_interpolateTransform : d3_interpolate;                                             // 4835
  }                                                                                                                    // 4836
  d3.interpolators = [ d3_interpolateObject, function(a, b) {                                                          // 4837
    return Array.isArray(b) && d3_interpolateArray(a, b);                                                              // 4838
  }, function(a, b) {                                                                                                  // 4839
    return (typeof a === "string" || typeof b === "string") && d3_interpolateString(a + "", b + "");                   // 4840
  }, function(a, b) {                                                                                                  // 4841
    return (typeof b === "string" ? d3_rgb_names.has(b) || /^(#|rgb\(|hsl\()/.test(b) : b instanceof d3_Color) && d3_interpolateRgb(a, b);
  }, function(a, b) {                                                                                                  // 4843
    return !isNaN(a = +a) && !isNaN(b = +b) && d3_interpolateNumber(a, b);                                             // 4844
  } ];                                                                                                                 // 4845
  d3.interpolateArray = d3_interpolateArray;                                                                           // 4846
  function d3_interpolateArray(a, b) {                                                                                 // 4847
    var x = [], c = [], na = a.length, nb = b.length, n0 = Math.min(a.length, b.length), i;                            // 4848
    for (i = 0; i < n0; ++i) x.push(d3_interpolate(a[i], b[i]));                                                       // 4849
    for (;i < na; ++i) c[i] = a[i];                                                                                    // 4850
    for (;i < nb; ++i) c[i] = b[i];                                                                                    // 4851
    return function(t) {                                                                                               // 4852
      for (i = 0; i < n0; ++i) c[i] = x[i](t);                                                                         // 4853
      return c;                                                                                                        // 4854
    };                                                                                                                 // 4855
  }                                                                                                                    // 4856
  var d3_ease_default = function() {                                                                                   // 4857
    return d3_identity;                                                                                                // 4858
  };                                                                                                                   // 4859
  var d3_ease = d3.map({                                                                                               // 4860
    linear: d3_ease_default,                                                                                           // 4861
    poly: d3_ease_poly,                                                                                                // 4862
    quad: function() {                                                                                                 // 4863
      return d3_ease_quad;                                                                                             // 4864
    },                                                                                                                 // 4865
    cubic: function() {                                                                                                // 4866
      return d3_ease_cubic;                                                                                            // 4867
    },                                                                                                                 // 4868
    sin: function() {                                                                                                  // 4869
      return d3_ease_sin;                                                                                              // 4870
    },                                                                                                                 // 4871
    exp: function() {                                                                                                  // 4872
      return d3_ease_exp;                                                                                              // 4873
    },                                                                                                                 // 4874
    circle: function() {                                                                                               // 4875
      return d3_ease_circle;                                                                                           // 4876
    },                                                                                                                 // 4877
    elastic: d3_ease_elastic,                                                                                          // 4878
    back: d3_ease_back,                                                                                                // 4879
    bounce: function() {                                                                                               // 4880
      return d3_ease_bounce;                                                                                           // 4881
    }                                                                                                                  // 4882
  });                                                                                                                  // 4883
  var d3_ease_mode = d3.map({                                                                                          // 4884
    "in": d3_identity,                                                                                                 // 4885
    out: d3_ease_reverse,                                                                                              // 4886
    "in-out": d3_ease_reflect,                                                                                         // 4887
    "out-in": function(f) {                                                                                            // 4888
      return d3_ease_reflect(d3_ease_reverse(f));                                                                      // 4889
    }                                                                                                                  // 4890
  });                                                                                                                  // 4891
  d3.ease = function(name) {                                                                                           // 4892
    var i = name.indexOf("-"), t = i >= 0 ? name.substring(0, i) : name, m = i >= 0 ? name.substring(i + 1) : "in";    // 4893
    t = d3_ease.get(t) || d3_ease_default;                                                                             // 4894
    m = d3_ease_mode.get(m) || d3_identity;                                                                            // 4895
    return d3_ease_clamp(m(t.apply(null, Array.prototype.slice.call(arguments, 1))));                                  // 4896
  };                                                                                                                   // 4897
  function d3_ease_clamp(f) {                                                                                          // 4898
    return function(t) {                                                                                               // 4899
      return t <= 0 ? 0 : t >= 1 ? 1 : f(t);                                                                           // 4900
    };                                                                                                                 // 4901
  }                                                                                                                    // 4902
  function d3_ease_reverse(f) {                                                                                        // 4903
    return function(t) {                                                                                               // 4904
      return 1 - f(1 - t);                                                                                             // 4905
    };                                                                                                                 // 4906
  }                                                                                                                    // 4907
  function d3_ease_reflect(f) {                                                                                        // 4908
    return function(t) {                                                                                               // 4909
      return .5 * (t < .5 ? f(2 * t) : 2 - f(2 - 2 * t));                                                              // 4910
    };                                                                                                                 // 4911
  }                                                                                                                    // 4912
  function d3_ease_quad(t) {                                                                                           // 4913
    return t * t;                                                                                                      // 4914
  }                                                                                                                    // 4915
  function d3_ease_cubic(t) {                                                                                          // 4916
    return t * t * t;                                                                                                  // 4917
  }                                                                                                                    // 4918
  function d3_ease_cubicInOut(t) {                                                                                     // 4919
    if (t <= 0) return 0;                                                                                              // 4920
    if (t >= 1) return 1;                                                                                              // 4921
    var t2 = t * t, t3 = t2 * t;                                                                                       // 4922
    return 4 * (t < .5 ? t3 : 3 * (t - t2) + t3 - .75);                                                                // 4923
  }                                                                                                                    // 4924
  function d3_ease_poly(e) {                                                                                           // 4925
    return function(t) {                                                                                               // 4926
      return Math.pow(t, e);                                                                                           // 4927
    };                                                                                                                 // 4928
  }                                                                                                                    // 4929
  function d3_ease_sin(t) {                                                                                            // 4930
    return 1 - Math.cos(t * π / 2);                                                                                    // 4931
  }                                                                                                                    // 4932
  function d3_ease_exp(t) {                                                                                            // 4933
    return Math.pow(2, 10 * (t - 1));                                                                                  // 4934
  }                                                                                                                    // 4935
  function d3_ease_circle(t) {                                                                                         // 4936
    return 1 - Math.sqrt(1 - t * t);                                                                                   // 4937
  }                                                                                                                    // 4938
  function d3_ease_elastic(a, p) {                                                                                     // 4939
    var s;                                                                                                             // 4940
    if (arguments.length < 2) p = .45;                                                                                 // 4941
    if (arguments.length) s = p / (2 * π) * Math.asin(1 / a); else a = 1, s = p / 4;                                   // 4942
    return function(t) {                                                                                               // 4943
      return 1 + a * Math.pow(2, 10 * -t) * Math.sin((t - s) * 2 * π / p);                                             // 4944
    };                                                                                                                 // 4945
  }                                                                                                                    // 4946
  function d3_ease_back(s) {                                                                                           // 4947
    if (!s) s = 1.70158;                                                                                               // 4948
    return function(t) {                                                                                               // 4949
      return t * t * ((s + 1) * t - s);                                                                                // 4950
    };                                                                                                                 // 4951
  }                                                                                                                    // 4952
  function d3_ease_bounce(t) {                                                                                         // 4953
    return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375;
  }                                                                                                                    // 4955
  d3.interpolateHcl = d3_interpolateHcl;                                                                               // 4956
  function d3_interpolateHcl(a, b) {                                                                                   // 4957
    a = d3.hcl(a);                                                                                                     // 4958
    b = d3.hcl(b);                                                                                                     // 4959
    var ah = a.h, ac = a.c, al = a.l, bh = b.h - ah, bc = b.c - ac, bl = b.l - al;                                     // 4960
    if (bh > 180) bh -= 360; else if (bh < -180) bh += 360;                                                            // 4961
    return function(t) {                                                                                               // 4962
      return d3_hcl_lab(ah + bh * t, ac + bc * t, al + bl * t) + "";                                                   // 4963
    };                                                                                                                 // 4964
  }                                                                                                                    // 4965
  d3.interpolateHsl = d3_interpolateHsl;                                                                               // 4966
  function d3_interpolateHsl(a, b) {                                                                                   // 4967
    a = d3.hsl(a);                                                                                                     // 4968
    b = d3.hsl(b);                                                                                                     // 4969
    var h0 = a.h, s0 = a.s, l0 = a.l, h1 = b.h - h0, s1 = b.s - s0, l1 = b.l - l0;                                     // 4970
    if (h1 > 180) h1 -= 360; else if (h1 < -180) h1 += 360;                                                            // 4971
    return function(t) {                                                                                               // 4972
      return d3_hsl_rgb(h0 + h1 * t, s0 + s1 * t, l0 + l1 * t) + "";                                                   // 4973
    };                                                                                                                 // 4974
  }                                                                                                                    // 4975
  d3.interpolateLab = d3_interpolateLab;                                                                               // 4976
  function d3_interpolateLab(a, b) {                                                                                   // 4977
    a = d3.lab(a);                                                                                                     // 4978
    b = d3.lab(b);                                                                                                     // 4979
    var al = a.l, aa = a.a, ab = a.b, bl = b.l - al, ba = b.a - aa, bb = b.b - ab;                                     // 4980
    return function(t) {                                                                                               // 4981
      return d3_lab_rgb(al + bl * t, aa + ba * t, ab + bb * t) + "";                                                   // 4982
    };                                                                                                                 // 4983
  }                                                                                                                    // 4984
  d3.interpolateRound = d3_interpolateRound;                                                                           // 4985
  function d3_interpolateRound(a, b) {                                                                                 // 4986
    b -= a;                                                                                                            // 4987
    return function(t) {                                                                                               // 4988
      return Math.round(a + b * t);                                                                                    // 4989
    };                                                                                                                 // 4990
  }                                                                                                                    // 4991
  function d3_uninterpolateNumber(a, b) {                                                                              // 4992
    b = b - (a = +a) ? 1 / (b - a) : 0;                                                                                // 4993
    return function(x) {                                                                                               // 4994
      return (x - a) * b;                                                                                              // 4995
    };                                                                                                                 // 4996
  }                                                                                                                    // 4997
  function d3_uninterpolateClamp(a, b) {                                                                               // 4998
    b = b - (a = +a) ? 1 / (b - a) : 0;                                                                                // 4999
    return function(x) {                                                                                               // 5000
      return Math.max(0, Math.min(1, (x - a) * b));                                                                    // 5001
    };                                                                                                                 // 5002
  }                                                                                                                    // 5003
  d3.layout = {};                                                                                                      // 5004
  d3.layout.bundle = function() {                                                                                      // 5005
    return function(links) {                                                                                           // 5006
      var paths = [], i = -1, n = links.length;                                                                        // 5007
      while (++i < n) paths.push(d3_layout_bundlePath(links[i]));                                                      // 5008
      return paths;                                                                                                    // 5009
    };                                                                                                                 // 5010
  };                                                                                                                   // 5011
  function d3_layout_bundlePath(link) {                                                                                // 5012
    var start = link.source, end = link.target, lca = d3_layout_bundleLeastCommonAncestor(start, end), points = [ start ];
    while (start !== lca) {                                                                                            // 5014
      start = start.parent;                                                                                            // 5015
      points.push(start);                                                                                              // 5016
    }                                                                                                                  // 5017
    var k = points.length;                                                                                             // 5018
    while (end !== lca) {                                                                                              // 5019
      points.splice(k, 0, end);                                                                                        // 5020
      end = end.parent;                                                                                                // 5021
    }                                                                                                                  // 5022
    return points;                                                                                                     // 5023
  }                                                                                                                    // 5024
  function d3_layout_bundleAncestors(node) {                                                                           // 5025
    var ancestors = [], parent = node.parent;                                                                          // 5026
    while (parent != null) {                                                                                           // 5027
      ancestors.push(node);                                                                                            // 5028
      node = parent;                                                                                                   // 5029
      parent = parent.parent;                                                                                          // 5030
    }                                                                                                                  // 5031
    ancestors.push(node);                                                                                              // 5032
    return ancestors;                                                                                                  // 5033
  }                                                                                                                    // 5034
  function d3_layout_bundleLeastCommonAncestor(a, b) {                                                                 // 5035
    if (a === b) return a;                                                                                             // 5036
    var aNodes = d3_layout_bundleAncestors(a), bNodes = d3_layout_bundleAncestors(b), aNode = aNodes.pop(), bNode = bNodes.pop(), sharedNode = null;
    while (aNode === bNode) {                                                                                          // 5038
      sharedNode = aNode;                                                                                              // 5039
      aNode = aNodes.pop();                                                                                            // 5040
      bNode = bNodes.pop();                                                                                            // 5041
    }                                                                                                                  // 5042
    return sharedNode;                                                                                                 // 5043
  }                                                                                                                    // 5044
  d3.layout.chord = function() {                                                                                       // 5045
    var chord = {}, chords, groups, matrix, n, padding = 0, sortGroups, sortSubgroups, sortChords;                     // 5046
    function relayout() {                                                                                              // 5047
      var subgroups = {}, groupSums = [], groupIndex = d3.range(n), subgroupIndex = [], k, x, x0, i, j;                // 5048
      chords = [];                                                                                                     // 5049
      groups = [];                                                                                                     // 5050
      k = 0, i = -1;                                                                                                   // 5051
      while (++i < n) {                                                                                                // 5052
        x = 0, j = -1;                                                                                                 // 5053
        while (++j < n) {                                                                                              // 5054
          x += matrix[i][j];                                                                                           // 5055
        }                                                                                                              // 5056
        groupSums.push(x);                                                                                             // 5057
        subgroupIndex.push(d3.range(n));                                                                               // 5058
        k += x;                                                                                                        // 5059
      }                                                                                                                // 5060
      if (sortGroups) {                                                                                                // 5061
        groupIndex.sort(function(a, b) {                                                                               // 5062
          return sortGroups(groupSums[a], groupSums[b]);                                                               // 5063
        });                                                                                                            // 5064
      }                                                                                                                // 5065
      if (sortSubgroups) {                                                                                             // 5066
        subgroupIndex.forEach(function(d, i) {                                                                         // 5067
          d.sort(function(a, b) {                                                                                      // 5068
            return sortSubgroups(matrix[i][a], matrix[i][b]);                                                          // 5069
          });                                                                                                          // 5070
        });                                                                                                            // 5071
      }                                                                                                                // 5072
      k = (2 * π - padding * n) / k;                                                                                   // 5073
      x = 0, i = -1;                                                                                                   // 5074
      while (++i < n) {                                                                                                // 5075
        x0 = x, j = -1;                                                                                                // 5076
        while (++j < n) {                                                                                              // 5077
          var di = groupIndex[i], dj = subgroupIndex[di][j], v = matrix[di][dj], a0 = x, a1 = x += v * k;              // 5078
          subgroups[di + "-" + dj] = {                                                                                 // 5079
            index: di,                                                                                                 // 5080
            subindex: dj,                                                                                              // 5081
            startAngle: a0,                                                                                            // 5082
            endAngle: a1,                                                                                              // 5083
            value: v                                                                                                   // 5084
          };                                                                                                           // 5085
        }                                                                                                              // 5086
        groups[di] = {                                                                                                 // 5087
          index: di,                                                                                                   // 5088
          startAngle: x0,                                                                                              // 5089
          endAngle: x,                                                                                                 // 5090
          value: (x - x0) / k                                                                                          // 5091
        };                                                                                                             // 5092
        x += padding;                                                                                                  // 5093
      }                                                                                                                // 5094
      i = -1;                                                                                                          // 5095
      while (++i < n) {                                                                                                // 5096
        j = i - 1;                                                                                                     // 5097
        while (++j < n) {                                                                                              // 5098
          var source = subgroups[i + "-" + j], target = subgroups[j + "-" + i];                                        // 5099
          if (source.value || target.value) {                                                                          // 5100
            chords.push(source.value < target.value ? {                                                                // 5101
              source: target,                                                                                          // 5102
              target: source                                                                                           // 5103
            } : {                                                                                                      // 5104
              source: source,                                                                                          // 5105
              target: target                                                                                           // 5106
            });                                                                                                        // 5107
          }                                                                                                            // 5108
        }                                                                                                              // 5109
      }                                                                                                                // 5110
      if (sortChords) resort();                                                                                        // 5111
    }                                                                                                                  // 5112
    function resort() {                                                                                                // 5113
      chords.sort(function(a, b) {                                                                                     // 5114
        return sortChords((a.source.value + a.target.value) / 2, (b.source.value + b.target.value) / 2);               // 5115
      });                                                                                                              // 5116
    }                                                                                                                  // 5117
    chord.matrix = function(x) {                                                                                       // 5118
      if (!arguments.length) return matrix;                                                                            // 5119
      n = (matrix = x) && matrix.length;                                                                               // 5120
      chords = groups = null;                                                                                          // 5121
      return chord;                                                                                                    // 5122
    };                                                                                                                 // 5123
    chord.padding = function(x) {                                                                                      // 5124
      if (!arguments.length) return padding;                                                                           // 5125
      padding = x;                                                                                                     // 5126
      chords = groups = null;                                                                                          // 5127
      return chord;                                                                                                    // 5128
    };                                                                                                                 // 5129
    chord.sortGroups = function(x) {                                                                                   // 5130
      if (!arguments.length) return sortGroups;                                                                        // 5131
      sortGroups = x;                                                                                                  // 5132
      chords = groups = null;                                                                                          // 5133
      return chord;                                                                                                    // 5134
    };                                                                                                                 // 5135
    chord.sortSubgroups = function(x) {                                                                                // 5136
      if (!arguments.length) return sortSubgroups;                                                                     // 5137
      sortSubgroups = x;                                                                                               // 5138
      chords = null;                                                                                                   // 5139
      return chord;                                                                                                    // 5140
    };                                                                                                                 // 5141
    chord.sortChords = function(x) {                                                                                   // 5142
      if (!arguments.length) return sortChords;                                                                        // 5143
      sortChords = x;                                                                                                  // 5144
      if (chords) resort();                                                                                            // 5145
      return chord;                                                                                                    // 5146
    };                                                                                                                 // 5147
    chord.chords = function() {                                                                                        // 5148
      if (!chords) relayout();                                                                                         // 5149
      return chords;                                                                                                   // 5150
    };                                                                                                                 // 5151
    chord.groups = function() {                                                                                        // 5152
      if (!groups) relayout();                                                                                         // 5153
      return groups;                                                                                                   // 5154
    };                                                                                                                 // 5155
    return chord;                                                                                                      // 5156
  };                                                                                                                   // 5157
  d3.layout.force = function() {                                                                                       // 5158
    var force = {}, event = d3.dispatch("start", "tick", "end"), size = [ 1, 1 ], drag, alpha, friction = .9, linkDistance = d3_layout_forceLinkDistance, linkStrength = d3_layout_forceLinkStrength, charge = -30, gravity = .1, theta = .8, nodes = [], links = [], distances, strengths, charges;
    function repulse(node) {                                                                                           // 5160
      return function(quad, x1, _, x2) {                                                                               // 5161
        if (quad.point !== node) {                                                                                     // 5162
          var dx = quad.cx - node.x, dy = quad.cy - node.y, dn = 1 / Math.sqrt(dx * dx + dy * dy);                     // 5163
          if ((x2 - x1) * dn < theta) {                                                                                // 5164
            var k = quad.charge * dn * dn;                                                                             // 5165
            node.px -= dx * k;                                                                                         // 5166
            node.py -= dy * k;                                                                                         // 5167
            return true;                                                                                               // 5168
          }                                                                                                            // 5169
          if (quad.point && isFinite(dn)) {                                                                            // 5170
            var k = quad.pointCharge * dn * dn;                                                                        // 5171
            node.px -= dx * k;                                                                                         // 5172
            node.py -= dy * k;                                                                                         // 5173
          }                                                                                                            // 5174
        }                                                                                                              // 5175
        return !quad.charge;                                                                                           // 5176
      };                                                                                                               // 5177
    }                                                                                                                  // 5178
    force.tick = function() {                                                                                          // 5179
      if ((alpha *= .99) < .005) {                                                                                     // 5180
        event.end({                                                                                                    // 5181
          type: "end",                                                                                                 // 5182
          alpha: alpha = 0                                                                                             // 5183
        });                                                                                                            // 5184
        return true;                                                                                                   // 5185
      }                                                                                                                // 5186
      var n = nodes.length, m = links.length, q, i, o, s, t, l, k, x, y;                                               // 5187
      for (i = 0; i < m; ++i) {                                                                                        // 5188
        o = links[i];                                                                                                  // 5189
        s = o.source;                                                                                                  // 5190
        t = o.target;                                                                                                  // 5191
        x = t.x - s.x;                                                                                                 // 5192
        y = t.y - s.y;                                                                                                 // 5193
        if (l = x * x + y * y) {                                                                                       // 5194
          l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;                                          // 5195
          x *= l;                                                                                                      // 5196
          y *= l;                                                                                                      // 5197
          t.x -= x * (k = s.weight / (t.weight + s.weight));                                                           // 5198
          t.y -= y * k;                                                                                                // 5199
          s.x += x * (k = 1 - k);                                                                                      // 5200
          s.y += y * k;                                                                                                // 5201
        }                                                                                                              // 5202
      }                                                                                                                // 5203
      if (k = alpha * gravity) {                                                                                       // 5204
        x = size[0] / 2;                                                                                               // 5205
        y = size[1] / 2;                                                                                               // 5206
        i = -1;                                                                                                        // 5207
        if (k) while (++i < n) {                                                                                       // 5208
          o = nodes[i];                                                                                                // 5209
          o.x += (x - o.x) * k;                                                                                        // 5210
          o.y += (y - o.y) * k;                                                                                        // 5211
        }                                                                                                              // 5212
      }                                                                                                                // 5213
      if (charge) {                                                                                                    // 5214
        d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);                                        // 5215
        i = -1;                                                                                                        // 5216
        while (++i < n) {                                                                                              // 5217
          if (!(o = nodes[i]).fixed) {                                                                                 // 5218
            q.visit(repulse(o));                                                                                       // 5219
          }                                                                                                            // 5220
        }                                                                                                              // 5221
      }                                                                                                                // 5222
      i = -1;                                                                                                          // 5223
      while (++i < n) {                                                                                                // 5224
        o = nodes[i];                                                                                                  // 5225
        if (o.fixed) {                                                                                                 // 5226
          o.x = o.px;                                                                                                  // 5227
          o.y = o.py;                                                                                                  // 5228
        } else {                                                                                                       // 5229
          o.x -= (o.px - (o.px = o.x)) * friction;                                                                     // 5230
          o.y -= (o.py - (o.py = o.y)) * friction;                                                                     // 5231
        }                                                                                                              // 5232
      }                                                                                                                // 5233
      event.tick({                                                                                                     // 5234
        type: "tick",                                                                                                  // 5235
        alpha: alpha                                                                                                   // 5236
      });                                                                                                              // 5237
    };                                                                                                                 // 5238
    force.nodes = function(x) {                                                                                        // 5239
      if (!arguments.length) return nodes;                                                                             // 5240
      nodes = x;                                                                                                       // 5241
      return force;                                                                                                    // 5242
    };                                                                                                                 // 5243
    force.links = function(x) {                                                                                        // 5244
      if (!arguments.length) return links;                                                                             // 5245
      links = x;                                                                                                       // 5246
      return force;                                                                                                    // 5247
    };                                                                                                                 // 5248
    force.size = function(x) {                                                                                         // 5249
      if (!arguments.length) return size;                                                                              // 5250
      size = x;                                                                                                        // 5251
      return force;                                                                                                    // 5252
    };                                                                                                                 // 5253
    force.linkDistance = function(x) {                                                                                 // 5254
      if (!arguments.length) return linkDistance;                                                                      // 5255
      linkDistance = typeof x === "function" ? x : +x;                                                                 // 5256
      return force;                                                                                                    // 5257
    };                                                                                                                 // 5258
    force.distance = force.linkDistance;                                                                               // 5259
    force.linkStrength = function(x) {                                                                                 // 5260
      if (!arguments.length) return linkStrength;                                                                      // 5261
      linkStrength = typeof x === "function" ? x : +x;                                                                 // 5262
      return force;                                                                                                    // 5263
    };                                                                                                                 // 5264
    force.friction = function(x) {                                                                                     // 5265
      if (!arguments.length) return friction;                                                                          // 5266
      friction = +x;                                                                                                   // 5267
      return force;                                                                                                    // 5268
    };                                                                                                                 // 5269
    force.charge = function(x) {                                                                                       // 5270
      if (!arguments.length) return charge;                                                                            // 5271
      charge = typeof x === "function" ? x : +x;                                                                       // 5272
      return force;                                                                                                    // 5273
    };                                                                                                                 // 5274
    force.gravity = function(x) {                                                                                      // 5275
      if (!arguments.length) return gravity;                                                                           // 5276
      gravity = +x;                                                                                                    // 5277
      return force;                                                                                                    // 5278
    };                                                                                                                 // 5279
    force.theta = function(x) {                                                                                        // 5280
      if (!arguments.length) return theta;                                                                             // 5281
      theta = +x;                                                                                                      // 5282
      return force;                                                                                                    // 5283
    };                                                                                                                 // 5284
    force.alpha = function(x) {                                                                                        // 5285
      if (!arguments.length) return alpha;                                                                             // 5286
      x = +x;                                                                                                          // 5287
      if (alpha) {                                                                                                     // 5288
        if (x > 0) alpha = x; else alpha = 0;                                                                          // 5289
      } else if (x > 0) {                                                                                              // 5290
        event.start({                                                                                                  // 5291
          type: "start",                                                                                               // 5292
          alpha: alpha = x                                                                                             // 5293
        });                                                                                                            // 5294
        d3.timer(force.tick);                                                                                          // 5295
      }                                                                                                                // 5296
      return force;                                                                                                    // 5297
    };                                                                                                                 // 5298
    force.start = function() {                                                                                         // 5299
      var i, j, n = nodes.length, m = links.length, w = size[0], h = size[1], neighbors, o;                            // 5300
      for (i = 0; i < n; ++i) {                                                                                        // 5301
        (o = nodes[i]).index = i;                                                                                      // 5302
        o.weight = 0;                                                                                                  // 5303
      }                                                                                                                // 5304
      for (i = 0; i < m; ++i) {                                                                                        // 5305
        o = links[i];                                                                                                  // 5306
        if (typeof o.source == "number") o.source = nodes[o.source];                                                   // 5307
        if (typeof o.target == "number") o.target = nodes[o.target];                                                   // 5308
        ++o.source.weight;                                                                                             // 5309
        ++o.target.weight;                                                                                             // 5310
      }                                                                                                                // 5311
      for (i = 0; i < n; ++i) {                                                                                        // 5312
        o = nodes[i];                                                                                                  // 5313
        if (isNaN(o.x)) o.x = position("x", w);                                                                        // 5314
        if (isNaN(o.y)) o.y = position("y", h);                                                                        // 5315
        if (isNaN(o.px)) o.px = o.x;                                                                                   // 5316
        if (isNaN(o.py)) o.py = o.y;                                                                                   // 5317
      }                                                                                                                // 5318
      distances = [];                                                                                                  // 5319
      if (typeof linkDistance === "function") for (i = 0; i < m; ++i) distances[i] = +linkDistance.call(this, links[i], i); else for (i = 0; i < m; ++i) distances[i] = linkDistance;
      strengths = [];                                                                                                  // 5321
      if (typeof linkStrength === "function") for (i = 0; i < m; ++i) strengths[i] = +linkStrength.call(this, links[i], i); else for (i = 0; i < m; ++i) strengths[i] = linkStrength;
      charges = [];                                                                                                    // 5323
      if (typeof charge === "function") for (i = 0; i < n; ++i) charges[i] = +charge.call(this, nodes[i], i); else for (i = 0; i < n; ++i) charges[i] = charge;
      function position(dimension, size) {                                                                             // 5325
        var neighbors = neighbor(i), j = -1, m = neighbors.length, x;                                                  // 5326
        while (++j < m) if (!isNaN(x = neighbors[j][dimension])) return x;                                             // 5327
        return Math.random() * size;                                                                                   // 5328
      }                                                                                                                // 5329
      function neighbor() {                                                                                            // 5330
        if (!neighbors) {                                                                                              // 5331
          neighbors = [];                                                                                              // 5332
          for (j = 0; j < n; ++j) {                                                                                    // 5333
            neighbors[j] = [];                                                                                         // 5334
          }                                                                                                            // 5335
          for (j = 0; j < m; ++j) {                                                                                    // 5336
            var o = links[j];                                                                                          // 5337
            neighbors[o.source.index].push(o.target);                                                                  // 5338
            neighbors[o.target.index].push(o.source);                                                                  // 5339
          }                                                                                                            // 5340
        }                                                                                                              // 5341
        return neighbors[i];                                                                                           // 5342
      }                                                                                                                // 5343
      return force.resume();                                                                                           // 5344
    };                                                                                                                 // 5345
    force.resume = function() {                                                                                        // 5346
      return force.alpha(.1);                                                                                          // 5347
    };                                                                                                                 // 5348
    force.stop = function() {                                                                                          // 5349
      return force.alpha(0);                                                                                           // 5350
    };                                                                                                                 // 5351
    force.drag = function() {                                                                                          // 5352
      if (!drag) drag = d3.behavior.drag().origin(d3_identity).on("dragstart.force", d3_layout_forceDragstart).on("drag.force", dragmove).on("dragend.force", d3_layout_forceDragend);
      if (!arguments.length) return drag;                                                                              // 5354
      this.on("mouseover.force", d3_layout_forceMouseover).on("mouseout.force", d3_layout_forceMouseout).call(drag);   // 5355
    };                                                                                                                 // 5356
    function dragmove(d) {                                                                                             // 5357
      d.px = d3.event.x, d.py = d3.event.y;                                                                            // 5358
      force.resume();                                                                                                  // 5359
    }                                                                                                                  // 5360
    return d3.rebind(force, event, "on");                                                                              // 5361
  };                                                                                                                   // 5362
  function d3_layout_forceDragstart(d) {                                                                               // 5363
    d.fixed |= 2;                                                                                                      // 5364
  }                                                                                                                    // 5365
  function d3_layout_forceDragend(d) {                                                                                 // 5366
    d.fixed &= ~6;                                                                                                     // 5367
  }                                                                                                                    // 5368
  function d3_layout_forceMouseover(d) {                                                                               // 5369
    d.fixed |= 4;                                                                                                      // 5370
    d.px = d.x, d.py = d.y;                                                                                            // 5371
  }                                                                                                                    // 5372
  function d3_layout_forceMouseout(d) {                                                                                // 5373
    d.fixed &= ~4;                                                                                                     // 5374
  }                                                                                                                    // 5375
  function d3_layout_forceAccumulate(quad, alpha, charges) {                                                           // 5376
    var cx = 0, cy = 0;                                                                                                // 5377
    quad.charge = 0;                                                                                                   // 5378
    if (!quad.leaf) {                                                                                                  // 5379
      var nodes = quad.nodes, n = nodes.length, i = -1, c;                                                             // 5380
      while (++i < n) {                                                                                                // 5381
        c = nodes[i];                                                                                                  // 5382
        if (c == null) continue;                                                                                       // 5383
        d3_layout_forceAccumulate(c, alpha, charges);                                                                  // 5384
        quad.charge += c.charge;                                                                                       // 5385
        cx += c.charge * c.cx;                                                                                         // 5386
        cy += c.charge * c.cy;                                                                                         // 5387
      }                                                                                                                // 5388
    }                                                                                                                  // 5389
    if (quad.point) {                                                                                                  // 5390
      if (!quad.leaf) {                                                                                                // 5391
        quad.point.x += Math.random() - .5;                                                                            // 5392
        quad.point.y += Math.random() - .5;                                                                            // 5393
      }                                                                                                                // 5394
      var k = alpha * charges[quad.point.index];                                                                       // 5395
      quad.charge += quad.pointCharge = k;                                                                             // 5396
      cx += k * quad.point.x;                                                                                          // 5397
      cy += k * quad.point.y;                                                                                          // 5398
    }                                                                                                                  // 5399
    quad.cx = cx / quad.charge;                                                                                        // 5400
    quad.cy = cy / quad.charge;                                                                                        // 5401
  }                                                                                                                    // 5402
  var d3_layout_forceLinkDistance = 20, d3_layout_forceLinkStrength = 1;                                               // 5403
  d3.layout.hierarchy = function() {                                                                                   // 5404
    var sort = d3_layout_hierarchySort, children = d3_layout_hierarchyChildren, value = d3_layout_hierarchyValue;      // 5405
    function recurse(node, depth, nodes) {                                                                             // 5406
      var childs = children.call(hierarchy, node, depth);                                                              // 5407
      node.depth = depth;                                                                                              // 5408
      nodes.push(node);                                                                                                // 5409
      if (childs && (n = childs.length)) {                                                                             // 5410
        var i = -1, n, c = node.children = [], v = 0, j = depth + 1, d;                                                // 5411
        while (++i < n) {                                                                                              // 5412
          d = recurse(childs[i], j, nodes);                                                                            // 5413
          d.parent = node;                                                                                             // 5414
          c.push(d);                                                                                                   // 5415
          v += d.value;                                                                                                // 5416
        }                                                                                                              // 5417
        if (sort) c.sort(sort);                                                                                        // 5418
        if (value) node.value = v;                                                                                     // 5419
      } else if (value) {                                                                                              // 5420
        node.value = +value.call(hierarchy, node, depth) || 0;                                                         // 5421
      }                                                                                                                // 5422
      return node;                                                                                                     // 5423
    }                                                                                                                  // 5424
    function revalue(node, depth) {                                                                                    // 5425
      var children = node.children, v = 0;                                                                             // 5426
      if (children && (n = children.length)) {                                                                         // 5427
        var i = -1, n, j = depth + 1;                                                                                  // 5428
        while (++i < n) v += revalue(children[i], j);                                                                  // 5429
      } else if (value) {                                                                                              // 5430
        v = +value.call(hierarchy, node, depth) || 0;                                                                  // 5431
      }                                                                                                                // 5432
      if (value) node.value = v;                                                                                       // 5433
      return v;                                                                                                        // 5434
    }                                                                                                                  // 5435
    function hierarchy(d) {                                                                                            // 5436
      var nodes = [];                                                                                                  // 5437
      recurse(d, 0, nodes);                                                                                            // 5438
      return nodes;                                                                                                    // 5439
    }                                                                                                                  // 5440
    hierarchy.sort = function(x) {                                                                                     // 5441
      if (!arguments.length) return sort;                                                                              // 5442
      sort = x;                                                                                                        // 5443
      return hierarchy;                                                                                                // 5444
    };                                                                                                                 // 5445
    hierarchy.children = function(x) {                                                                                 // 5446
      if (!arguments.length) return children;                                                                          // 5447
      children = x;                                                                                                    // 5448
      return hierarchy;                                                                                                // 5449
    };                                                                                                                 // 5450
    hierarchy.value = function(x) {                                                                                    // 5451
      if (!arguments.length) return value;                                                                             // 5452
      value = x;                                                                                                       // 5453
      return hierarchy;                                                                                                // 5454
    };                                                                                                                 // 5455
    hierarchy.revalue = function(root) {                                                                               // 5456
      revalue(root, 0);                                                                                                // 5457
      return root;                                                                                                     // 5458
    };                                                                                                                 // 5459
    return hierarchy;                                                                                                  // 5460
  };                                                                                                                   // 5461
  function d3_layout_hierarchyRebind(object, hierarchy) {                                                              // 5462
    d3.rebind(object, hierarchy, "sort", "children", "value");                                                         // 5463
    object.nodes = object;                                                                                             // 5464
    object.links = d3_layout_hierarchyLinks;                                                                           // 5465
    return object;                                                                                                     // 5466
  }                                                                                                                    // 5467
  function d3_layout_hierarchyChildren(d) {                                                                            // 5468
    return d.children;                                                                                                 // 5469
  }                                                                                                                    // 5470
  function d3_layout_hierarchyValue(d) {                                                                               // 5471
    return d.value;                                                                                                    // 5472
  }                                                                                                                    // 5473
  function d3_layout_hierarchySort(a, b) {                                                                             // 5474
    return b.value - a.value;                                                                                          // 5475
  }                                                                                                                    // 5476
  function d3_layout_hierarchyLinks(nodes) {                                                                           // 5477
    return d3.merge(nodes.map(function(parent) {                                                                       // 5478
      return (parent.children || []).map(function(child) {                                                             // 5479
        return {                                                                                                       // 5480
          source: parent,                                                                                              // 5481
          target: child                                                                                                // 5482
        };                                                                                                             // 5483
      });                                                                                                              // 5484
    }));                                                                                                               // 5485
  }                                                                                                                    // 5486
  d3.layout.partition = function() {                                                                                   // 5487
    var hierarchy = d3.layout.hierarchy(), size = [ 1, 1 ];                                                            // 5488
    function position(node, x, dx, dy) {                                                                               // 5489
      var children = node.children;                                                                                    // 5490
      node.x = x;                                                                                                      // 5491
      node.y = node.depth * dy;                                                                                        // 5492
      node.dx = dx;                                                                                                    // 5493
      node.dy = dy;                                                                                                    // 5494
      if (children && (n = children.length)) {                                                                         // 5495
        var i = -1, n, c, d;                                                                                           // 5496
        dx = node.value ? dx / node.value : 0;                                                                         // 5497
        while (++i < n) {                                                                                              // 5498
          position(c = children[i], x, d = c.value * dx, dy);                                                          // 5499
          x += d;                                                                                                      // 5500
        }                                                                                                              // 5501
      }                                                                                                                // 5502
    }                                                                                                                  // 5503
    function depth(node) {                                                                                             // 5504
      var children = node.children, d = 0;                                                                             // 5505
      if (children && (n = children.length)) {                                                                         // 5506
        var i = -1, n;                                                                                                 // 5507
        while (++i < n) d = Math.max(d, depth(children[i]));                                                           // 5508
      }                                                                                                                // 5509
      return 1 + d;                                                                                                    // 5510
    }                                                                                                                  // 5511
    function partition(d, i) {                                                                                         // 5512
      var nodes = hierarchy.call(this, d, i);                                                                          // 5513
      position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));                                                       // 5514
      return nodes;                                                                                                    // 5515
    }                                                                                                                  // 5516
    partition.size = function(x) {                                                                                     // 5517
      if (!arguments.length) return size;                                                                              // 5518
      size = x;                                                                                                        // 5519
      return partition;                                                                                                // 5520
    };                                                                                                                 // 5521
    return d3_layout_hierarchyRebind(partition, hierarchy);                                                            // 5522
  };                                                                                                                   // 5523
  d3.layout.pie = function() {                                                                                         // 5524
    var value = Number, sort = d3_layout_pieSortByValue, startAngle = 0, endAngle = 2 * π;                             // 5525
    function pie(data) {                                                                                               // 5526
      var values = data.map(function(d, i) {                                                                           // 5527
        return +value.call(pie, d, i);                                                                                 // 5528
      });                                                                                                              // 5529
      var a = +(typeof startAngle === "function" ? startAngle.apply(this, arguments) : startAngle);                    // 5530
      var k = ((typeof endAngle === "function" ? endAngle.apply(this, arguments) : endAngle) - a) / d3.sum(values);    // 5531
      var index = d3.range(data.length);                                                                               // 5532
      if (sort != null) index.sort(sort === d3_layout_pieSortByValue ? function(i, j) {                                // 5533
        return values[j] - values[i];                                                                                  // 5534
      } : function(i, j) {                                                                                             // 5535
        return sort(data[i], data[j]);                                                                                 // 5536
      });                                                                                                              // 5537
      var arcs = [];                                                                                                   // 5538
      index.forEach(function(i) {                                                                                      // 5539
        var d;                                                                                                         // 5540
        arcs[i] = {                                                                                                    // 5541
          data: data[i],                                                                                               // 5542
          value: d = values[i],                                                                                        // 5543
          startAngle: a,                                                                                               // 5544
          endAngle: a += d * k                                                                                         // 5545
        };                                                                                                             // 5546
      });                                                                                                              // 5547
      return arcs;                                                                                                     // 5548
    }                                                                                                                  // 5549
    pie.value = function(x) {                                                                                          // 5550
      if (!arguments.length) return value;                                                                             // 5551
      value = x;                                                                                                       // 5552
      return pie;                                                                                                      // 5553
    };                                                                                                                 // 5554
    pie.sort = function(x) {                                                                                           // 5555
      if (!arguments.length) return sort;                                                                              // 5556
      sort = x;                                                                                                        // 5557
      return pie;                                                                                                      // 5558
    };                                                                                                                 // 5559
    pie.startAngle = function(x) {                                                                                     // 5560
      if (!arguments.length) return startAngle;                                                                        // 5561
      startAngle = x;                                                                                                  // 5562
      return pie;                                                                                                      // 5563
    };                                                                                                                 // 5564
    pie.endAngle = function(x) {                                                                                       // 5565
      if (!arguments.length) return endAngle;                                                                          // 5566
      endAngle = x;                                                                                                    // 5567
      return pie;                                                                                                      // 5568
    };                                                                                                                 // 5569
    return pie;                                                                                                        // 5570
  };                                                                                                                   // 5571
  var d3_layout_pieSortByValue = {};                                                                                   // 5572
  d3.layout.stack = function() {                                                                                       // 5573
    var values = d3_identity, order = d3_layout_stackOrderDefault, offset = d3_layout_stackOffsetZero, out = d3_layout_stackOut, x = d3_layout_stackX, y = d3_layout_stackY;
    function stack(data, index) {                                                                                      // 5575
      var series = data.map(function(d, i) {                                                                           // 5576
        return values.call(stack, d, i);                                                                               // 5577
      });                                                                                                              // 5578
      var points = series.map(function(d) {                                                                            // 5579
        return d.map(function(v, i) {                                                                                  // 5580
          return [ x.call(stack, v, i), y.call(stack, v, i) ];                                                         // 5581
        });                                                                                                            // 5582
      });                                                                                                              // 5583
      var orders = order.call(stack, points, index);                                                                   // 5584
      series = d3.permute(series, orders);                                                                             // 5585
      points = d3.permute(points, orders);                                                                             // 5586
      var offsets = offset.call(stack, points, index);                                                                 // 5587
      var n = series.length, m = series[0].length, i, j, o;                                                            // 5588
      for (j = 0; j < m; ++j) {                                                                                        // 5589
        out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);                                                // 5590
        for (i = 1; i < n; ++i) {                                                                                      // 5591
          out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);                                    // 5592
        }                                                                                                              // 5593
      }                                                                                                                // 5594
      return data;                                                                                                     // 5595
    }                                                                                                                  // 5596
    stack.values = function(x) {                                                                                       // 5597
      if (!arguments.length) return values;                                                                            // 5598
      values = x;                                                                                                      // 5599
      return stack;                                                                                                    // 5600
    };                                                                                                                 // 5601
    stack.order = function(x) {                                                                                        // 5602
      if (!arguments.length) return order;                                                                             // 5603
      order = typeof x === "function" ? x : d3_layout_stackOrders.get(x) || d3_layout_stackOrderDefault;               // 5604
      return stack;                                                                                                    // 5605
    };                                                                                                                 // 5606
    stack.offset = function(x) {                                                                                       // 5607
      if (!arguments.length) return offset;                                                                            // 5608
      offset = typeof x === "function" ? x : d3_layout_stackOffsets.get(x) || d3_layout_stackOffsetZero;               // 5609
      return stack;                                                                                                    // 5610
    };                                                                                                                 // 5611
    stack.x = function(z) {                                                                                            // 5612
      if (!arguments.length) return x;                                                                                 // 5613
      x = z;                                                                                                           // 5614
      return stack;                                                                                                    // 5615
    };                                                                                                                 // 5616
    stack.y = function(z) {                                                                                            // 5617
      if (!arguments.length) return y;                                                                                 // 5618
      y = z;                                                                                                           // 5619
      return stack;                                                                                                    // 5620
    };                                                                                                                 // 5621
    stack.out = function(z) {                                                                                          // 5622
      if (!arguments.length) return out;                                                                               // 5623
      out = z;                                                                                                         // 5624
      return stack;                                                                                                    // 5625
    };                                                                                                                 // 5626
    return stack;                                                                                                      // 5627
  };                                                                                                                   // 5628
  function d3_layout_stackX(d) {                                                                                       // 5629
    return d.x;                                                                                                        // 5630
  }                                                                                                                    // 5631
  function d3_layout_stackY(d) {                                                                                       // 5632
    return d.y;                                                                                                        // 5633
  }                                                                                                                    // 5634
  function d3_layout_stackOut(d, y0, y) {                                                                              // 5635
    d.y0 = y0;                                                                                                         // 5636
    d.y = y;                                                                                                           // 5637
  }                                                                                                                    // 5638
  var d3_layout_stackOrders = d3.map({                                                                                 // 5639
    "inside-out": function(data) {                                                                                     // 5640
      var n = data.length, i, j, max = data.map(d3_layout_stackMaxIndex), sums = data.map(d3_layout_stackReduceSum), index = d3.range(n).sort(function(a, b) {
        return max[a] - max[b];                                                                                        // 5642
      }), top = 0, bottom = 0, tops = [], bottoms = [];                                                                // 5643
      for (i = 0; i < n; ++i) {                                                                                        // 5644
        j = index[i];                                                                                                  // 5645
        if (top < bottom) {                                                                                            // 5646
          top += sums[j];                                                                                              // 5647
          tops.push(j);                                                                                                // 5648
        } else {                                                                                                       // 5649
          bottom += sums[j];                                                                                           // 5650
          bottoms.push(j);                                                                                             // 5651
        }                                                                                                              // 5652
      }                                                                                                                // 5653
      return bottoms.reverse().concat(tops);                                                                           // 5654
    },                                                                                                                 // 5655
    reverse: function(data) {                                                                                          // 5656
      return d3.range(data.length).reverse();                                                                          // 5657
    },                                                                                                                 // 5658
    "default": d3_layout_stackOrderDefault                                                                             // 5659
  });                                                                                                                  // 5660
  var d3_layout_stackOffsets = d3.map({                                                                                // 5661
    silhouette: function(data) {                                                                                       // 5662
      var n = data.length, m = data[0].length, sums = [], max = 0, i, j, o, y0 = [];                                   // 5663
      for (j = 0; j < m; ++j) {                                                                                        // 5664
        for (i = 0, o = 0; i < n; i++) o += data[i][j][1];                                                             // 5665
        if (o > max) max = o;                                                                                          // 5666
        sums.push(o);                                                                                                  // 5667
      }                                                                                                                // 5668
      for (j = 0; j < m; ++j) {                                                                                        // 5669
        y0[j] = (max - sums[j]) / 2;                                                                                   // 5670
      }                                                                                                                // 5671
      return y0;                                                                                                       // 5672
    },                                                                                                                 // 5673
    wiggle: function(data) {                                                                                           // 5674
      var n = data.length, x = data[0], m = x.length, i, j, k, s1, s2, s3, dx, o, o0, y0 = [];                         // 5675
      y0[0] = o = o0 = 0;                                                                                              // 5676
      for (j = 1; j < m; ++j) {                                                                                        // 5677
        for (i = 0, s1 = 0; i < n; ++i) s1 += data[i][j][1];                                                           // 5678
        for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {                                                  // 5679
          for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {                               // 5680
            s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;                                                            // 5681
          }                                                                                                            // 5682
          s2 += s3 * data[i][j][1];                                                                                    // 5683
        }                                                                                                              // 5684
        y0[j] = o -= s1 ? s2 / s1 * dx : 0;                                                                            // 5685
        if (o < o0) o0 = o;                                                                                            // 5686
      }                                                                                                                // 5687
      for (j = 0; j < m; ++j) y0[j] -= o0;                                                                             // 5688
      return y0;                                                                                                       // 5689
    },                                                                                                                 // 5690
    expand: function(data) {                                                                                           // 5691
      var n = data.length, m = data[0].length, k = 1 / n, i, j, o, y0 = [];                                            // 5692
      for (j = 0; j < m; ++j) {                                                                                        // 5693
        for (i = 0, o = 0; i < n; i++) o += data[i][j][1];                                                             // 5694
        if (o) for (i = 0; i < n; i++) data[i][j][1] /= o; else for (i = 0; i < n; i++) data[i][j][1] = k;             // 5695
      }                                                                                                                // 5696
      for (j = 0; j < m; ++j) y0[j] = 0;                                                                               // 5697
      return y0;                                                                                                       // 5698
    },                                                                                                                 // 5699
    zero: d3_layout_stackOffsetZero                                                                                    // 5700
  });                                                                                                                  // 5701
  function d3_layout_stackOrderDefault(data) {                                                                         // 5702
    return d3.range(data.length);                                                                                      // 5703
  }                                                                                                                    // 5704
  function d3_layout_stackOffsetZero(data) {                                                                           // 5705
    var j = -1, m = data[0].length, y0 = [];                                                                           // 5706
    while (++j < m) y0[j] = 0;                                                                                         // 5707
    return y0;                                                                                                         // 5708
  }                                                                                                                    // 5709
  function d3_layout_stackMaxIndex(array) {                                                                            // 5710
    var i = 1, j = 0, v = array[0][1], k, n = array.length;                                                            // 5711
    for (;i < n; ++i) {                                                                                                // 5712
      if ((k = array[i][1]) > v) {                                                                                     // 5713
        j = i;                                                                                                         // 5714
        v = k;                                                                                                         // 5715
      }                                                                                                                // 5716
    }                                                                                                                  // 5717
    return j;                                                                                                          // 5718
  }                                                                                                                    // 5719
  function d3_layout_stackReduceSum(d) {                                                                               // 5720
    return d.reduce(d3_layout_stackSum, 0);                                                                            // 5721
  }                                                                                                                    // 5722
  function d3_layout_stackSum(p, d) {                                                                                  // 5723
    return p + d[1];                                                                                                   // 5724
  }                                                                                                                    // 5725
  d3.layout.histogram = function() {                                                                                   // 5726
    var frequency = true, valuer = Number, ranger = d3_layout_histogramRange, binner = d3_layout_histogramBinSturges;  // 5727
    function histogram(data, i) {                                                                                      // 5728
      var bins = [], values = data.map(valuer, this), range = ranger.call(this, values, i), thresholds = binner.call(this, range, values, i), bin, i = -1, n = values.length, m = thresholds.length - 1, k = frequency ? 1 : 1 / n, x;
      while (++i < m) {                                                                                                // 5730
        bin = bins[i] = [];                                                                                            // 5731
        bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);                                                          // 5732
        bin.y = 0;                                                                                                     // 5733
      }                                                                                                                // 5734
      if (m > 0) {                                                                                                     // 5735
        i = -1;                                                                                                        // 5736
        while (++i < n) {                                                                                              // 5737
          x = values[i];                                                                                               // 5738
          if (x >= range[0] && x <= range[1]) {                                                                        // 5739
            bin = bins[d3.bisect(thresholds, x, 1, m) - 1];                                                            // 5740
            bin.y += k;                                                                                                // 5741
            bin.push(data[i]);                                                                                         // 5742
          }                                                                                                            // 5743
        }                                                                                                              // 5744
      }                                                                                                                // 5745
      return bins;                                                                                                     // 5746
    }                                                                                                                  // 5747
    histogram.value = function(x) {                                                                                    // 5748
      if (!arguments.length) return valuer;                                                                            // 5749
      valuer = x;                                                                                                      // 5750
      return histogram;                                                                                                // 5751
    };                                                                                                                 // 5752
    histogram.range = function(x) {                                                                                    // 5753
      if (!arguments.length) return ranger;                                                                            // 5754
      ranger = d3_functor(x);                                                                                          // 5755
      return histogram;                                                                                                // 5756
    };                                                                                                                 // 5757
    histogram.bins = function(x) {                                                                                     // 5758
      if (!arguments.length) return binner;                                                                            // 5759
      binner = typeof x === "number" ? function(range) {                                                               // 5760
        return d3_layout_histogramBinFixed(range, x);                                                                  // 5761
      } : d3_functor(x);                                                                                               // 5762
      return histogram;                                                                                                // 5763
    };                                                                                                                 // 5764
    histogram.frequency = function(x) {                                                                                // 5765
      if (!arguments.length) return frequency;                                                                         // 5766
      frequency = !!x;                                                                                                 // 5767
      return histogram;                                                                                                // 5768
    };                                                                                                                 // 5769
    return histogram;                                                                                                  // 5770
  };                                                                                                                   // 5771
  function d3_layout_histogramBinSturges(range, values) {                                                              // 5772
    return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));                      // 5773
  }                                                                                                                    // 5774
  function d3_layout_histogramBinFixed(range, n) {                                                                     // 5775
    var x = -1, b = +range[0], m = (range[1] - b) / n, f = [];                                                         // 5776
    while (++x <= n) f[x] = m * x + b;                                                                                 // 5777
    return f;                                                                                                          // 5778
  }                                                                                                                    // 5779
  function d3_layout_histogramRange(values) {                                                                          // 5780
    return [ d3.min(values), d3.max(values) ];                                                                         // 5781
  }                                                                                                                    // 5782
  d3.layout.tree = function() {                                                                                        // 5783
    var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [ 1, 1 ];
    function tree(d, i) {                                                                                              // 5785
      var nodes = hierarchy.call(this, d, i), root = nodes[0];                                                         // 5786
      function firstWalk(node, previousSibling) {                                                                      // 5787
        var children = node.children, layout = node._tree;                                                             // 5788
        if (children && (n = children.length)) {                                                                       // 5789
          var n, firstChild = children[0], previousChild, ancestor = firstChild, child, i = -1;                        // 5790
          while (++i < n) {                                                                                            // 5791
            child = children[i];                                                                                       // 5792
            firstWalk(child, previousChild);                                                                           // 5793
            ancestor = apportion(child, previousChild, ancestor);                                                      // 5794
            previousChild = child;                                                                                     // 5795
          }                                                                                                            // 5796
          d3_layout_treeShift(node);                                                                                   // 5797
          var midpoint = .5 * (firstChild._tree.prelim + child._tree.prelim);                                          // 5798
          if (previousSibling) {                                                                                       // 5799
            layout.prelim = previousSibling._tree.prelim + separation(node, previousSibling);                          // 5800
            layout.mod = layout.prelim - midpoint;                                                                     // 5801
          } else {                                                                                                     // 5802
            layout.prelim = midpoint;                                                                                  // 5803
          }                                                                                                            // 5804
        } else {                                                                                                       // 5805
          if (previousSibling) {                                                                                       // 5806
            layout.prelim = previousSibling._tree.prelim + separation(node, previousSibling);                          // 5807
          }                                                                                                            // 5808
        }                                                                                                              // 5809
      }                                                                                                                // 5810
      function secondWalk(node, x) {                                                                                   // 5811
        node.x = node._tree.prelim + x;                                                                                // 5812
        var children = node.children;                                                                                  // 5813
        if (children && (n = children.length)) {                                                                       // 5814
          var i = -1, n;                                                                                               // 5815
          x += node._tree.mod;                                                                                         // 5816
          while (++i < n) {                                                                                            // 5817
            secondWalk(children[i], x);                                                                                // 5818
          }                                                                                                            // 5819
        }                                                                                                              // 5820
      }                                                                                                                // 5821
      function apportion(node, previousSibling, ancestor) {                                                            // 5822
        if (previousSibling) {                                                                                         // 5823
          var vip = node, vop = node, vim = previousSibling, vom = node.parent.children[0], sip = vip._tree.mod, sop = vop._tree.mod, sim = vim._tree.mod, som = vom._tree.mod, shift;
          while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {                          // 5825
            vom = d3_layout_treeLeft(vom);                                                                             // 5826
            vop = d3_layout_treeRight(vop);                                                                            // 5827
            vop._tree.ancestor = node;                                                                                 // 5828
            shift = vim._tree.prelim + sim - vip._tree.prelim - sip + separation(vim, vip);                            // 5829
            if (shift > 0) {                                                                                           // 5830
              d3_layout_treeMove(d3_layout_treeAncestor(vim, node, ancestor), node, shift);                            // 5831
              sip += shift;                                                                                            // 5832
              sop += shift;                                                                                            // 5833
            }                                                                                                          // 5834
            sim += vim._tree.mod;                                                                                      // 5835
            sip += vip._tree.mod;                                                                                      // 5836
            som += vom._tree.mod;                                                                                      // 5837
            sop += vop._tree.mod;                                                                                      // 5838
          }                                                                                                            // 5839
          if (vim && !d3_layout_treeRight(vop)) {                                                                      // 5840
            vop._tree.thread = vim;                                                                                    // 5841
            vop._tree.mod += sim - sop;                                                                                // 5842
          }                                                                                                            // 5843
          if (vip && !d3_layout_treeLeft(vom)) {                                                                       // 5844
            vom._tree.thread = vip;                                                                                    // 5845
            vom._tree.mod += sip - som;                                                                                // 5846
            ancestor = node;                                                                                           // 5847
          }                                                                                                            // 5848
        }                                                                                                              // 5849
        return ancestor;                                                                                               // 5850
      }                                                                                                                // 5851
      d3_layout_treeVisitAfter(root, function(node, previousSibling) {                                                 // 5852
        node._tree = {                                                                                                 // 5853
          ancestor: node,                                                                                              // 5854
          prelim: 0,                                                                                                   // 5855
          mod: 0,                                                                                                      // 5856
          change: 0,                                                                                                   // 5857
          shift: 0,                                                                                                    // 5858
          number: previousSibling ? previousSibling._tree.number + 1 : 0                                               // 5859
        };                                                                                                             // 5860
      });                                                                                                              // 5861
      firstWalk(root);                                                                                                 // 5862
      secondWalk(root, -root._tree.prelim);                                                                            // 5863
      var left = d3_layout_treeSearch(root, d3_layout_treeLeftmost), right = d3_layout_treeSearch(root, d3_layout_treeRightmost), deep = d3_layout_treeSearch(root, d3_layout_treeDeepest), x0 = left.x - separation(left, right) / 2, x1 = right.x + separation(right, left) / 2, y1 = deep.depth || 1;
      d3_layout_treeVisitAfter(root, function(node) {                                                                  // 5865
        node.x = (node.x - x0) / (x1 - x0) * size[0];                                                                  // 5866
        node.y = node.depth / y1 * size[1];                                                                            // 5867
        delete node._tree;                                                                                             // 5868
      });                                                                                                              // 5869
      return nodes;                                                                                                    // 5870
    }                                                                                                                  // 5871
    tree.separation = function(x) {                                                                                    // 5872
      if (!arguments.length) return separation;                                                                        // 5873
      separation = x;                                                                                                  // 5874
      return tree;                                                                                                     // 5875
    };                                                                                                                 // 5876
    tree.size = function(x) {                                                                                          // 5877
      if (!arguments.length) return size;                                                                              // 5878
      size = x;                                                                                                        // 5879
      return tree;                                                                                                     // 5880
    };                                                                                                                 // 5881
    return d3_layout_hierarchyRebind(tree, hierarchy);                                                                 // 5882
  };                                                                                                                   // 5883
  function d3_layout_treeSeparation(a, b) {                                                                            // 5884
    return a.parent == b.parent ? 1 : 2;                                                                               // 5885
  }                                                                                                                    // 5886
  function d3_layout_treeLeft(node) {                                                                                  // 5887
    var children = node.children;                                                                                      // 5888
    return children && children.length ? children[0] : node._tree.thread;                                              // 5889
  }                                                                                                                    // 5890
  function d3_layout_treeRight(node) {                                                                                 // 5891
    var children = node.children, n;                                                                                   // 5892
    return children && (n = children.length) ? children[n - 1] : node._tree.thread;                                    // 5893
  }                                                                                                                    // 5894
  function d3_layout_treeSearch(node, compare) {                                                                       // 5895
    var children = node.children;                                                                                      // 5896
    if (children && (n = children.length)) {                                                                           // 5897
      var child, n, i = -1;                                                                                            // 5898
      while (++i < n) {                                                                                                // 5899
        if (compare(child = d3_layout_treeSearch(children[i], compare), node) > 0) {                                   // 5900
          node = child;                                                                                                // 5901
        }                                                                                                              // 5902
      }                                                                                                                // 5903
    }                                                                                                                  // 5904
    return node;                                                                                                       // 5905
  }                                                                                                                    // 5906
  function d3_layout_treeRightmost(a, b) {                                                                             // 5907
    return a.x - b.x;                                                                                                  // 5908
  }                                                                                                                    // 5909
  function d3_layout_treeLeftmost(a, b) {                                                                              // 5910
    return b.x - a.x;                                                                                                  // 5911
  }                                                                                                                    // 5912
  function d3_layout_treeDeepest(a, b) {                                                                               // 5913
    return a.depth - b.depth;                                                                                          // 5914
  }                                                                                                                    // 5915
  function d3_layout_treeVisitAfter(node, callback) {                                                                  // 5916
    function visit(node, previousSibling) {                                                                            // 5917
      var children = node.children;                                                                                    // 5918
      if (children && (n = children.length)) {                                                                         // 5919
        var child, previousChild = null, i = -1, n;                                                                    // 5920
        while (++i < n) {                                                                                              // 5921
          child = children[i];                                                                                         // 5922
          visit(child, previousChild);                                                                                 // 5923
          previousChild = child;                                                                                       // 5924
        }                                                                                                              // 5925
      }                                                                                                                // 5926
      callback(node, previousSibling);                                                                                 // 5927
    }                                                                                                                  // 5928
    visit(node, null);                                                                                                 // 5929
  }                                                                                                                    // 5930
  function d3_layout_treeShift(node) {                                                                                 // 5931
    var shift = 0, change = 0, children = node.children, i = children.length, child;                                   // 5932
    while (--i >= 0) {                                                                                                 // 5933
      child = children[i]._tree;                                                                                       // 5934
      child.prelim += shift;                                                                                           // 5935
      child.mod += shift;                                                                                              // 5936
      shift += child.shift + (change += child.change);                                                                 // 5937
    }                                                                                                                  // 5938
  }                                                                                                                    // 5939
  function d3_layout_treeMove(ancestor, node, shift) {                                                                 // 5940
    ancestor = ancestor._tree;                                                                                         // 5941
    node = node._tree;                                                                                                 // 5942
    var change = shift / (node.number - ancestor.number);                                                              // 5943
    ancestor.change += change;                                                                                         // 5944
    node.change -= change;                                                                                             // 5945
    node.shift += shift;                                                                                               // 5946
    node.prelim += shift;                                                                                              // 5947
    node.mod += shift;                                                                                                 // 5948
  }                                                                                                                    // 5949
  function d3_layout_treeAncestor(vim, node, ancestor) {                                                               // 5950
    return vim._tree.ancestor.parent == node.parent ? vim._tree.ancestor : ancestor;                                   // 5951
  }                                                                                                                    // 5952
  d3.layout.pack = function() {                                                                                        // 5953
    var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort), padding = 0, size = [ 1, 1 ];                      // 5954
    function pack(d, i) {                                                                                              // 5955
      var nodes = hierarchy.call(this, d, i), root = nodes[0];                                                         // 5956
      root.x = 0;                                                                                                      // 5957
      root.y = 0;                                                                                                      // 5958
      d3_layout_treeVisitAfter(root, function(d) {                                                                     // 5959
        d.r = Math.sqrt(d.value);                                                                                      // 5960
      });                                                                                                              // 5961
      d3_layout_treeVisitAfter(root, d3_layout_packSiblings);                                                          // 5962
      var w = size[0], h = size[1], k = Math.max(2 * root.r / w, 2 * root.r / h);                                      // 5963
      if (padding > 0) {                                                                                               // 5964
        var dr = padding * k / 2;                                                                                      // 5965
        d3_layout_treeVisitAfter(root, function(d) {                                                                   // 5966
          d.r += dr;                                                                                                   // 5967
        });                                                                                                            // 5968
        d3_layout_treeVisitAfter(root, d3_layout_packSiblings);                                                        // 5969
        d3_layout_treeVisitAfter(root, function(d) {                                                                   // 5970
          d.r -= dr;                                                                                                   // 5971
        });                                                                                                            // 5972
        k = Math.max(2 * root.r / w, 2 * root.r / h);                                                                  // 5973
      }                                                                                                                // 5974
      d3_layout_packTransform(root, w / 2, h / 2, 1 / k);                                                              // 5975
      return nodes;                                                                                                    // 5976
    }                                                                                                                  // 5977
    pack.size = function(x) {                                                                                          // 5978
      if (!arguments.length) return size;                                                                              // 5979
      size = x;                                                                                                        // 5980
      return pack;                                                                                                     // 5981
    };                                                                                                                 // 5982
    pack.padding = function(_) {                                                                                       // 5983
      if (!arguments.length) return padding;                                                                           // 5984
      padding = +_;                                                                                                    // 5985
      return pack;                                                                                                     // 5986
    };                                                                                                                 // 5987
    return d3_layout_hierarchyRebind(pack, hierarchy);                                                                 // 5988
  };                                                                                                                   // 5989
  function d3_layout_packSort(a, b) {                                                                                  // 5990
    return a.value - b.value;                                                                                          // 5991
  }                                                                                                                    // 5992
  function d3_layout_packInsert(a, b) {                                                                                // 5993
    var c = a._pack_next;                                                                                              // 5994
    a._pack_next = b;                                                                                                  // 5995
    b._pack_prev = a;                                                                                                  // 5996
    b._pack_next = c;                                                                                                  // 5997
    c._pack_prev = b;                                                                                                  // 5998
  }                                                                                                                    // 5999
  function d3_layout_packSplice(a, b) {                                                                                // 6000
    a._pack_next = b;                                                                                                  // 6001
    b._pack_prev = a;                                                                                                  // 6002
  }                                                                                                                    // 6003
  function d3_layout_packIntersects(a, b) {                                                                            // 6004
    var dx = b.x - a.x, dy = b.y - a.y, dr = a.r + b.r;                                                                // 6005
    return dr * dr - dx * dx - dy * dy > .001;                                                                         // 6006
  }                                                                                                                    // 6007
  function d3_layout_packSiblings(node) {                                                                              // 6008
    if (!(nodes = node.children) || !(n = nodes.length)) return;                                                       // 6009
    var nodes, xMin = Infinity, xMax = -Infinity, yMin = Infinity, yMax = -Infinity, a, b, c, i, j, k, n;              // 6010
    function bound(node) {                                                                                             // 6011
      xMin = Math.min(node.x - node.r, xMin);                                                                          // 6012
      xMax = Math.max(node.x + node.r, xMax);                                                                          // 6013
      yMin = Math.min(node.y - node.r, yMin);                                                                          // 6014
      yMax = Math.max(node.y + node.r, yMax);                                                                          // 6015
    }                                                                                                                  // 6016
    nodes.forEach(d3_layout_packLink);                                                                                 // 6017
    a = nodes[0];                                                                                                      // 6018
    a.x = -a.r;                                                                                                        // 6019
    a.y = 0;                                                                                                           // 6020
    bound(a);                                                                                                          // 6021
    if (n > 1) {                                                                                                       // 6022
      b = nodes[1];                                                                                                    // 6023
      b.x = b.r;                                                                                                       // 6024
      b.y = 0;                                                                                                         // 6025
      bound(b);                                                                                                        // 6026
      if (n > 2) {                                                                                                     // 6027
        c = nodes[2];                                                                                                  // 6028
        d3_layout_packPlace(a, b, c);                                                                                  // 6029
        bound(c);                                                                                                      // 6030
        d3_layout_packInsert(a, c);                                                                                    // 6031
        a._pack_prev = c;                                                                                              // 6032
        d3_layout_packInsert(c, b);                                                                                    // 6033
        b = a._pack_next;                                                                                              // 6034
        for (i = 3; i < n; i++) {                                                                                      // 6035
          d3_layout_packPlace(a, b, c = nodes[i]);                                                                     // 6036
          var isect = 0, s1 = 1, s2 = 1;                                                                               // 6037
          for (j = b._pack_next; j !== b; j = j._pack_next, s1++) {                                                    // 6038
            if (d3_layout_packIntersects(j, c)) {                                                                      // 6039
              isect = 1;                                                                                               // 6040
              break;                                                                                                   // 6041
            }                                                                                                          // 6042
          }                                                                                                            // 6043
          if (isect == 1) {                                                                                            // 6044
            for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {                                       // 6045
              if (d3_layout_packIntersects(k, c)) {                                                                    // 6046
                break;                                                                                                 // 6047
              }                                                                                                        // 6048
            }                                                                                                          // 6049
          }                                                                                                            // 6050
          if (isect) {                                                                                                 // 6051
            if (s1 < s2 || s1 == s2 && b.r < a.r) d3_layout_packSplice(a, b = j); else d3_layout_packSplice(a = k, b); // 6052
            i--;                                                                                                       // 6053
          } else {                                                                                                     // 6054
            d3_layout_packInsert(a, c);                                                                                // 6055
            b = c;                                                                                                     // 6056
            bound(c);                                                                                                  // 6057
          }                                                                                                            // 6058
        }                                                                                                              // 6059
      }                                                                                                                // 6060
    }                                                                                                                  // 6061
    var cx = (xMin + xMax) / 2, cy = (yMin + yMax) / 2, cr = 0;                                                        // 6062
    for (i = 0; i < n; i++) {                                                                                          // 6063
      c = nodes[i];                                                                                                    // 6064
      c.x -= cx;                                                                                                       // 6065
      c.y -= cy;                                                                                                       // 6066
      cr = Math.max(cr, c.r + Math.sqrt(c.x * c.x + c.y * c.y));                                                       // 6067
    }                                                                                                                  // 6068
    node.r = cr;                                                                                                       // 6069
    nodes.forEach(d3_layout_packUnlink);                                                                               // 6070
  }                                                                                                                    // 6071
  function d3_layout_packLink(node) {                                                                                  // 6072
    node._pack_next = node._pack_prev = node;                                                                          // 6073
  }                                                                                                                    // 6074
  function d3_layout_packUnlink(node) {                                                                                // 6075
    delete node._pack_next;                                                                                            // 6076
    delete node._pack_prev;                                                                                            // 6077
  }                                                                                                                    // 6078
  function d3_layout_packTransform(node, x, y, k) {                                                                    // 6079
    var children = node.children;                                                                                      // 6080
    node.x = x += k * node.x;                                                                                          // 6081
    node.y = y += k * node.y;                                                                                          // 6082
    node.r *= k;                                                                                                       // 6083
    if (children) {                                                                                                    // 6084
      var i = -1, n = children.length;                                                                                 // 6085
      while (++i < n) d3_layout_packTransform(children[i], x, y, k);                                                   // 6086
    }                                                                                                                  // 6087
  }                                                                                                                    // 6088
  function d3_layout_packPlace(a, b, c) {                                                                              // 6089
    var db = a.r + c.r, dx = b.x - a.x, dy = b.y - a.y;                                                                // 6090
    if (db && (dx || dy)) {                                                                                            // 6091
      var da = b.r + c.r, dc = dx * dx + dy * dy;                                                                      // 6092
      da *= da;                                                                                                        // 6093
      db *= db;                                                                                                        // 6094
      var x = .5 + (db - da) / (2 * dc), y = Math.sqrt(Math.max(0, 2 * da * (db + dc) - (db -= dc) * db - da * da)) / (2 * dc);
      c.x = a.x + x * dx + y * dy;                                                                                     // 6096
      c.y = a.y + x * dy - y * dx;                                                                                     // 6097
    } else {                                                                                                           // 6098
      c.x = a.x + db;                                                                                                  // 6099
      c.y = a.y;                                                                                                       // 6100
    }                                                                                                                  // 6101
  }                                                                                                                    // 6102
  d3.layout.cluster = function() {                                                                                     // 6103
    var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [ 1, 1 ];
    function cluster(d, i) {                                                                                           // 6105
      var nodes = hierarchy.call(this, d, i), root = nodes[0], previousNode, x = 0;                                    // 6106
      d3_layout_treeVisitAfter(root, function(node) {                                                                  // 6107
        var children = node.children;                                                                                  // 6108
        if (children && children.length) {                                                                             // 6109
          node.x = d3_layout_clusterX(children);                                                                       // 6110
          node.y = d3_layout_clusterY(children);                                                                       // 6111
        } else {                                                                                                       // 6112
          node.x = previousNode ? x += separation(node, previousNode) : 0;                                             // 6113
          node.y = 0;                                                                                                  // 6114
          previousNode = node;                                                                                         // 6115
        }                                                                                                              // 6116
      });                                                                                                              // 6117
      var left = d3_layout_clusterLeft(root), right = d3_layout_clusterRight(root), x0 = left.x - separation(left, right) / 2, x1 = right.x + separation(right, left) / 2;
      d3_layout_treeVisitAfter(root, function(node) {                                                                  // 6119
        node.x = (node.x - x0) / (x1 - x0) * size[0];                                                                  // 6120
        node.y = (1 - (root.y ? node.y / root.y : 1)) * size[1];                                                       // 6121
      });                                                                                                              // 6122
      return nodes;                                                                                                    // 6123
    }                                                                                                                  // 6124
    cluster.separation = function(x) {                                                                                 // 6125
      if (!arguments.length) return separation;                                                                        // 6126
      separation = x;                                                                                                  // 6127
      return cluster;                                                                                                  // 6128
    };                                                                                                                 // 6129
    cluster.size = function(x) {                                                                                       // 6130
      if (!arguments.length) return size;                                                                              // 6131
      size = x;                                                                                                        // 6132
      return cluster;                                                                                                  // 6133
    };                                                                                                                 // 6134
    return d3_layout_hierarchyRebind(cluster, hierarchy);                                                              // 6135
  };                                                                                                                   // 6136
  function d3_layout_clusterY(children) {                                                                              // 6137
    return 1 + d3.max(children, function(child) {                                                                      // 6138
      return child.y;                                                                                                  // 6139
    });                                                                                                                // 6140
  }                                                                                                                    // 6141
  function d3_layout_clusterX(children) {                                                                              // 6142
    return children.reduce(function(x, child) {                                                                        // 6143
      return x + child.x;                                                                                              // 6144
    }, 0) / children.length;                                                                                           // 6145
  }                                                                                                                    // 6146
  function d3_layout_clusterLeft(node) {                                                                               // 6147
    var children = node.children;                                                                                      // 6148
    return children && children.length ? d3_layout_clusterLeft(children[0]) : node;                                    // 6149
  }                                                                                                                    // 6150
  function d3_layout_clusterRight(node) {                                                                              // 6151
    var children = node.children, n;                                                                                   // 6152
    return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;                         // 6153
  }                                                                                                                    // 6154
  d3.layout.treemap = function() {                                                                                     // 6155
    var hierarchy = d3.layout.hierarchy(), round = Math.round, size = [ 1, 1 ], padding = null, pad = d3_layout_treemapPadNull, sticky = false, stickies, mode = "squarify", ratio = .5 * (1 + Math.sqrt(5));
    function scale(children, k) {                                                                                      // 6157
      var i = -1, n = children.length, child, area;                                                                    // 6158
      while (++i < n) {                                                                                                // 6159
        area = (child = children[i]).value * (k < 0 ? 0 : k);                                                          // 6160
        child.area = isNaN(area) || area <= 0 ? 0 : area;                                                              // 6161
      }                                                                                                                // 6162
    }                                                                                                                  // 6163
    function squarify(node) {                                                                                          // 6164
      var children = node.children;                                                                                    // 6165
      if (children && children.length) {                                                                               // 6166
        var rect = pad(node), row = [], remaining = children.slice(), child, best = Infinity, score, u = mode === "slice" ? rect.dx : mode === "dice" ? rect.dy : mode === "slice-dice" ? node.depth & 1 ? rect.dy : rect.dx : Math.min(rect.dx, rect.dy), n;
        scale(remaining, rect.dx * rect.dy / node.value);                                                              // 6168
        row.area = 0;                                                                                                  // 6169
        while ((n = remaining.length) > 0) {                                                                           // 6170
          row.push(child = remaining[n - 1]);                                                                          // 6171
          row.area += child.area;                                                                                      // 6172
          if (mode !== "squarify" || (score = worst(row, u)) <= best) {                                                // 6173
            remaining.pop();                                                                                           // 6174
            best = score;                                                                                              // 6175
          } else {                                                                                                     // 6176
            row.area -= row.pop().area;                                                                                // 6177
            position(row, u, rect, false);                                                                             // 6178
            u = Math.min(rect.dx, rect.dy);                                                                            // 6179
            row.length = row.area = 0;                                                                                 // 6180
            best = Infinity;                                                                                           // 6181
          }                                                                                                            // 6182
        }                                                                                                              // 6183
        if (row.length) {                                                                                              // 6184
          position(row, u, rect, true);                                                                                // 6185
          row.length = row.area = 0;                                                                                   // 6186
        }                                                                                                              // 6187
        children.forEach(squarify);                                                                                    // 6188
      }                                                                                                                // 6189
    }                                                                                                                  // 6190
    function stickify(node) {                                                                                          // 6191
      var children = node.children;                                                                                    // 6192
      if (children && children.length) {                                                                               // 6193
        var rect = pad(node), remaining = children.slice(), child, row = [];                                           // 6194
        scale(remaining, rect.dx * rect.dy / node.value);                                                              // 6195
        row.area = 0;                                                                                                  // 6196
        while (child = remaining.pop()) {                                                                              // 6197
          row.push(child);                                                                                             // 6198
          row.area += child.area;                                                                                      // 6199
          if (child.z != null) {                                                                                       // 6200
            position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);                                       // 6201
            row.length = row.area = 0;                                                                                 // 6202
          }                                                                                                            // 6203
        }                                                                                                              // 6204
        children.forEach(stickify);                                                                                    // 6205
      }                                                                                                                // 6206
    }                                                                                                                  // 6207
    function worst(row, u) {                                                                                           // 6208
      var s = row.area, r, rmax = 0, rmin = Infinity, i = -1, n = row.length;                                          // 6209
      while (++i < n) {                                                                                                // 6210
        if (!(r = row[i].area)) continue;                                                                              // 6211
        if (r < rmin) rmin = r;                                                                                        // 6212
        if (r > rmax) rmax = r;                                                                                        // 6213
      }                                                                                                                // 6214
      s *= s;                                                                                                          // 6215
      u *= u;                                                                                                          // 6216
      return s ? Math.max(u * rmax * ratio / s, s / (u * rmin * ratio)) : Infinity;                                    // 6217
    }                                                                                                                  // 6218
    function position(row, u, rect, flush) {                                                                           // 6219
      var i = -1, n = row.length, x = rect.x, y = rect.y, v = u ? round(row.area / u) : 0, o;                          // 6220
      if (u == rect.dx) {                                                                                              // 6221
        if (flush || v > rect.dy) v = rect.dy;                                                                         // 6222
        while (++i < n) {                                                                                              // 6223
          o = row[i];                                                                                                  // 6224
          o.x = x;                                                                                                     // 6225
          o.y = y;                                                                                                     // 6226
          o.dy = v;                                                                                                    // 6227
          x += o.dx = Math.min(rect.x + rect.dx - x, v ? round(o.area / v) : 0);                                       // 6228
        }                                                                                                              // 6229
        o.z = true;                                                                                                    // 6230
        o.dx += rect.x + rect.dx - x;                                                                                  // 6231
        rect.y += v;                                                                                                   // 6232
        rect.dy -= v;                                                                                                  // 6233
      } else {                                                                                                         // 6234
        if (flush || v > rect.dx) v = rect.dx;                                                                         // 6235
        while (++i < n) {                                                                                              // 6236
          o = row[i];                                                                                                  // 6237
          o.x = x;                                                                                                     // 6238
          o.y = y;                                                                                                     // 6239
          o.dx = v;                                                                                                    // 6240
          y += o.dy = Math.min(rect.y + rect.dy - y, v ? round(o.area / v) : 0);                                       // 6241
        }                                                                                                              // 6242
        o.z = false;                                                                                                   // 6243
        o.dy += rect.y + rect.dy - y;                                                                                  // 6244
        rect.x += v;                                                                                                   // 6245
        rect.dx -= v;                                                                                                  // 6246
      }                                                                                                                // 6247
    }                                                                                                                  // 6248
    function treemap(d) {                                                                                              // 6249
      var nodes = stickies || hierarchy(d), root = nodes[0];                                                           // 6250
      root.x = 0;                                                                                                      // 6251
      root.y = 0;                                                                                                      // 6252
      root.dx = size[0];                                                                                               // 6253
      root.dy = size[1];                                                                                               // 6254
      if (stickies) hierarchy.revalue(root);                                                                           // 6255
      scale([ root ], root.dx * root.dy / root.value);                                                                 // 6256
      (stickies ? stickify : squarify)(root);                                                                          // 6257
      if (sticky) stickies = nodes;                                                                                    // 6258
      return nodes;                                                                                                    // 6259
    }                                                                                                                  // 6260
    treemap.size = function(x) {                                                                                       // 6261
      if (!arguments.length) return size;                                                                              // 6262
      size = x;                                                                                                        // 6263
      return treemap;                                                                                                  // 6264
    };                                                                                                                 // 6265
    treemap.padding = function(x) {                                                                                    // 6266
      if (!arguments.length) return padding;                                                                           // 6267
      function padFunction(node) {                                                                                     // 6268
        var p = x.call(treemap, node, node.depth);                                                                     // 6269
        return p == null ? d3_layout_treemapPadNull(node) : d3_layout_treemapPad(node, typeof p === "number" ? [ p, p, p, p ] : p);
      }                                                                                                                // 6271
      function padConstant(node) {                                                                                     // 6272
        return d3_layout_treemapPad(node, x);                                                                          // 6273
      }                                                                                                                // 6274
      var type;                                                                                                        // 6275
      pad = (padding = x) == null ? d3_layout_treemapPadNull : (type = typeof x) === "function" ? padFunction : type === "number" ? (x = [ x, x, x, x ],
      padConstant) : padConstant;                                                                                      // 6277
      return treemap;                                                                                                  // 6278
    };                                                                                                                 // 6279
    treemap.round = function(x) {                                                                                      // 6280
      if (!arguments.length) return round != Number;                                                                   // 6281
      round = x ? Math.round : Number;                                                                                 // 6282
      return treemap;                                                                                                  // 6283
    };                                                                                                                 // 6284
    treemap.sticky = function(x) {                                                                                     // 6285
      if (!arguments.length) return sticky;                                                                            // 6286
      sticky = x;                                                                                                      // 6287
      stickies = null;                                                                                                 // 6288
      return treemap;                                                                                                  // 6289
    };                                                                                                                 // 6290
    treemap.ratio = function(x) {                                                                                      // 6291
      if (!arguments.length) return ratio;                                                                             // 6292
      ratio = x;                                                                                                       // 6293
      return treemap;                                                                                                  // 6294
    };                                                                                                                 // 6295
    treemap.mode = function(x) {                                                                                       // 6296
      if (!arguments.length) return mode;                                                                              // 6297
      mode = x + "";                                                                                                   // 6298
      return treemap;                                                                                                  // 6299
    };                                                                                                                 // 6300
    return d3_layout_hierarchyRebind(treemap, hierarchy);                                                              // 6301
  };                                                                                                                   // 6302
  function d3_layout_treemapPadNull(node) {                                                                            // 6303
    return {                                                                                                           // 6304
      x: node.x,                                                                                                       // 6305
      y: node.y,                                                                                                       // 6306
      dx: node.dx,                                                                                                     // 6307
      dy: node.dy                                                                                                      // 6308
    };                                                                                                                 // 6309
  }                                                                                                                    // 6310
  function d3_layout_treemapPad(node, padding) {                                                                       // 6311
    var x = node.x + padding[3], y = node.y + padding[0], dx = node.dx - padding[1] - padding[3], dy = node.dy - padding[0] - padding[2];
    if (dx < 0) {                                                                                                      // 6313
      x += dx / 2;                                                                                                     // 6314
      dx = 0;                                                                                                          // 6315
    }                                                                                                                  // 6316
    if (dy < 0) {                                                                                                      // 6317
      y += dy / 2;                                                                                                     // 6318
      dy = 0;                                                                                                          // 6319
    }                                                                                                                  // 6320
    return {                                                                                                           // 6321
      x: x,                                                                                                            // 6322
      y: y,                                                                                                            // 6323
      dx: dx,                                                                                                          // 6324
      dy: dy                                                                                                           // 6325
    };                                                                                                                 // 6326
  }                                                                                                                    // 6327
  d3.random = {                                                                                                        // 6328
    normal: function(µ, σ) {                                                                                           // 6329
      var n = arguments.length;                                                                                        // 6330
      if (n < 2) σ = 1;                                                                                                // 6331
      if (n < 1) µ = 0;                                                                                                // 6332
      return function() {                                                                                              // 6333
        var x, y, r;                                                                                                   // 6334
        do {                                                                                                           // 6335
          x = Math.random() * 2 - 1;                                                                                   // 6336
          y = Math.random() * 2 - 1;                                                                                   // 6337
          r = x * x + y * y;                                                                                           // 6338
        } while (!r || r > 1);                                                                                         // 6339
        return µ + σ * x * Math.sqrt(-2 * Math.log(r) / r);                                                            // 6340
      };                                                                                                               // 6341
    },                                                                                                                 // 6342
    logNormal: function() {                                                                                            // 6343
      var random = d3.random.normal.apply(d3, arguments);                                                              // 6344
      return function() {                                                                                              // 6345
        return Math.exp(random());                                                                                     // 6346
      };                                                                                                               // 6347
    },                                                                                                                 // 6348
    irwinHall: function(m) {                                                                                           // 6349
      return function() {                                                                                              // 6350
        for (var s = 0, j = 0; j < m; j++) s += Math.random();                                                         // 6351
        return s / m;                                                                                                  // 6352
      };                                                                                                               // 6353
    }                                                                                                                  // 6354
  };                                                                                                                   // 6355
  d3.scale = {};                                                                                                       // 6356
  function d3_scaleExtent(domain) {                                                                                    // 6357
    var start = domain[0], stop = domain[domain.length - 1];                                                           // 6358
    return start < stop ? [ start, stop ] : [ stop, start ];                                                           // 6359
  }                                                                                                                    // 6360
  function d3_scaleRange(scale) {                                                                                      // 6361
    return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());                                    // 6362
  }                                                                                                                    // 6363
  function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {                                              // 6364
    var u = uninterpolate(domain[0], domain[1]), i = interpolate(range[0], range[1]);                                  // 6365
    return function(x) {                                                                                               // 6366
      return i(u(x));                                                                                                  // 6367
    };                                                                                                                 // 6368
  }                                                                                                                    // 6369
  function d3_scale_nice(domain, nice) {                                                                               // 6370
    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], dx;                                          // 6371
    if (x1 < x0) {                                                                                                     // 6372
      dx = i0, i0 = i1, i1 = dx;                                                                                       // 6373
      dx = x0, x0 = x1, x1 = dx;                                                                                       // 6374
    }                                                                                                                  // 6375
    if (nice = nice(x1 - x0)) {                                                                                        // 6376
      domain[i0] = nice.floor(x0);                                                                                     // 6377
      domain[i1] = nice.ceil(x1);                                                                                      // 6378
    }                                                                                                                  // 6379
    return domain;                                                                                                     // 6380
  }                                                                                                                    // 6381
  function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {                                            // 6382
    var u = [], i = [], j = 0, k = Math.min(domain.length, range.length) - 1;                                          // 6383
    if (domain[k] < domain[0]) {                                                                                       // 6384
      domain = domain.slice().reverse();                                                                               // 6385
      range = range.slice().reverse();                                                                                 // 6386
    }                                                                                                                  // 6387
    while (++j <= k) {                                                                                                 // 6388
      u.push(uninterpolate(domain[j - 1], domain[j]));                                                                 // 6389
      i.push(interpolate(range[j - 1], range[j]));                                                                     // 6390
    }                                                                                                                  // 6391
    return function(x) {                                                                                               // 6392
      var j = d3.bisect(domain, x, 1, k) - 1;                                                                          // 6393
      return i[j](u[j](x));                                                                                            // 6394
    };                                                                                                                 // 6395
  }                                                                                                                    // 6396
  d3.scale.linear = function() {                                                                                       // 6397
    return d3_scale_linear([ 0, 1 ], [ 0, 1 ], d3_interpolate, false);                                                 // 6398
  };                                                                                                                   // 6399
  function d3_scale_linear(domain, range, interpolate, clamp) {                                                        // 6400
    var output, input;                                                                                                 // 6401
    function rescale() {                                                                                               // 6402
      var linear = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear, uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;
      output = linear(domain, range, uninterpolate, interpolate);                                                      // 6404
      input = linear(range, domain, uninterpolate, d3_interpolate);                                                    // 6405
      return scale;                                                                                                    // 6406
    }                                                                                                                  // 6407
    function scale(x) {                                                                                                // 6408
      return output(x);                                                                                                // 6409
    }                                                                                                                  // 6410
    scale.invert = function(y) {                                                                                       // 6411
      return input(y);                                                                                                 // 6412
    };                                                                                                                 // 6413
    scale.domain = function(x) {                                                                                       // 6414
      if (!arguments.length) return domain;                                                                            // 6415
      domain = x.map(Number);                                                                                          // 6416
      return rescale();                                                                                                // 6417
    };                                                                                                                 // 6418
    scale.range = function(x) {                                                                                        // 6419
      if (!arguments.length) return range;                                                                             // 6420
      range = x;                                                                                                       // 6421
      return rescale();                                                                                                // 6422
    };                                                                                                                 // 6423
    scale.rangeRound = function(x) {                                                                                   // 6424
      return scale.range(x).interpolate(d3_interpolateRound);                                                          // 6425
    };                                                                                                                 // 6426
    scale.clamp = function(x) {                                                                                        // 6427
      if (!arguments.length) return clamp;                                                                             // 6428
      clamp = x;                                                                                                       // 6429
      return rescale();                                                                                                // 6430
    };                                                                                                                 // 6431
    scale.interpolate = function(x) {                                                                                  // 6432
      if (!arguments.length) return interpolate;                                                                       // 6433
      interpolate = x;                                                                                                 // 6434
      return rescale();                                                                                                // 6435
    };                                                                                                                 // 6436
    scale.ticks = function(m) {                                                                                        // 6437
      return d3_scale_linearTicks(domain, m);                                                                          // 6438
    };                                                                                                                 // 6439
    scale.tickFormat = function(m, format) {                                                                           // 6440
      return d3_scale_linearTickFormat(domain, m, format);                                                             // 6441
    };                                                                                                                 // 6442
    scale.nice = function() {                                                                                          // 6443
      d3_scale_nice(domain, d3_scale_linearNice);                                                                      // 6444
      return rescale();                                                                                                // 6445
    };                                                                                                                 // 6446
    scale.copy = function() {                                                                                          // 6447
      return d3_scale_linear(domain, range, interpolate, clamp);                                                       // 6448
    };                                                                                                                 // 6449
    return rescale();                                                                                                  // 6450
  }                                                                                                                    // 6451
  function d3_scale_linearRebind(scale, linear) {                                                                      // 6452
    return d3.rebind(scale, linear, "range", "rangeRound", "interpolate", "clamp");                                    // 6453
  }                                                                                                                    // 6454
  function d3_scale_linearNice(dx) {                                                                                   // 6455
    dx = Math.pow(10, Math.round(Math.log(dx) / Math.LN10) - 1);                                                       // 6456
    return dx && {                                                                                                     // 6457
      floor: function(x) {                                                                                             // 6458
        return Math.floor(x / dx) * dx;                                                                                // 6459
      },                                                                                                               // 6460
      ceil: function(x) {                                                                                              // 6461
        return Math.ceil(x / dx) * dx;                                                                                 // 6462
      }                                                                                                                // 6463
    };                                                                                                                 // 6464
  }                                                                                                                    // 6465
  function d3_scale_linearTickRange(domain, m) {                                                                       // 6466
    var extent = d3_scaleExtent(domain), span = extent[1] - extent[0], step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)), err = m / span * step;
    if (err <= .15) step *= 10; else if (err <= .35) step *= 5; else if (err <= .75) step *= 2;                        // 6468
    extent[0] = Math.ceil(extent[0] / step) * step;                                                                    // 6469
    extent[1] = Math.floor(extent[1] / step) * step + step * .5;                                                       // 6470
    extent[2] = step;                                                                                                  // 6471
    return extent;                                                                                                     // 6472
  }                                                                                                                    // 6473
  function d3_scale_linearTicks(domain, m) {                                                                           // 6474
    return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));                                                    // 6475
  }                                                                                                                    // 6476
  function d3_scale_linearTickFormat(domain, m, format) {                                                              // 6477
    var precision = -Math.floor(Math.log(d3_scale_linearTickRange(domain, m)[2]) / Math.LN10 + .01);                   // 6478
    return d3.format(format ? format.replace(d3_format_re, function(a, b, c, d, e, f, g, h, i, j) {                    // 6479
      return [ b, c, d, e, f, g, h, i || "." + (precision - (j === "%") * 2), j ].join("");                            // 6480
    }) : ",." + precision + "f");                                                                                      // 6481
  }                                                                                                                    // 6482
  d3.scale.log = function() {                                                                                          // 6483
    return d3_scale_log(d3.scale.linear().domain([ 0, Math.LN10 ]), 10, d3_scale_logp, d3_scale_powp);                 // 6484
  };                                                                                                                   // 6485
  function d3_scale_log(linear, base, log, pow) {                                                                      // 6486
    function scale(x) {                                                                                                // 6487
      return linear(log(x));                                                                                           // 6488
    }                                                                                                                  // 6489
    scale.invert = function(x) {                                                                                       // 6490
      return pow(linear.invert(x));                                                                                    // 6491
    };                                                                                                                 // 6492
    scale.domain = function(x) {                                                                                       // 6493
      if (!arguments.length) return linear.domain().map(pow);                                                          // 6494
      if (x[0] < 0) log = d3_scale_logn, pow = d3_scale_pown; else log = d3_scale_logp,                                // 6495
      pow = d3_scale_powp;                                                                                             // 6496
      linear.domain(x.map(log));                                                                                       // 6497
      return scale;                                                                                                    // 6498
    };                                                                                                                 // 6499
    scale.base = function(_) {                                                                                         // 6500
      if (!arguments.length) return base;                                                                              // 6501
      base = +_;                                                                                                       // 6502
      return scale;                                                                                                    // 6503
    };                                                                                                                 // 6504
    scale.nice = function() {                                                                                          // 6505
      linear.domain(d3_scale_nice(linear.domain(), d3_scale_logNice(base)));                                           // 6506
      return scale;                                                                                                    // 6507
    };                                                                                                                 // 6508
    scale.ticks = function() {                                                                                         // 6509
      var extent = d3_scaleExtent(linear.domain()), ticks = [];                                                        // 6510
      if (extent.every(isFinite)) {                                                                                    // 6511
        var b = Math.log(base), i = Math.floor(extent[0] / b), j = Math.ceil(extent[1] / b), u = pow(extent[0]), v = pow(extent[1]), n = base % 1 ? 2 : base;
        if (log === d3_scale_logn) {                                                                                   // 6513
          ticks.push(-Math.pow(base, -i));                                                                             // 6514
          for (;i++ < j; ) for (var k = n - 1; k > 0; k--) ticks.push(-Math.pow(base, -i) * k);                        // 6515
        } else {                                                                                                       // 6516
          for (;i < j; i++) for (var k = 1; k < n; k++) ticks.push(Math.pow(base, i) * k);                             // 6517
          ticks.push(Math.pow(base, i));                                                                               // 6518
        }                                                                                                              // 6519
        for (i = 0; ticks[i] < u; i++) {}                                                                              // 6520
        for (j = ticks.length; ticks[j - 1] > v; j--) {}                                                               // 6521
        ticks = ticks.slice(i, j);                                                                                     // 6522
      }                                                                                                                // 6523
      return ticks;                                                                                                    // 6524
    };                                                                                                                 // 6525
    scale.tickFormat = function(n, format) {                                                                           // 6526
      if (arguments.length < 2) format = d3_scale_logFormat;                                                           // 6527
      if (!arguments.length) return format;                                                                            // 6528
      var b = Math.log(base), k = Math.max(.1, n / scale.ticks().length), f = log === d3_scale_logn ? (e = -1e-12,     // 6529
      Math.floor) : (e = 1e-12, Math.ceil), e;                                                                         // 6530
      return function(d) {                                                                                             // 6531
        return d / pow(b * f(log(d) / b + e)) <= k ? format(d) : "";                                                   // 6532
      };                                                                                                               // 6533
    };                                                                                                                 // 6534
    scale.copy = function() {                                                                                          // 6535
      return d3_scale_log(linear.copy(), base, log, pow);                                                              // 6536
    };                                                                                                                 // 6537
    return d3_scale_linearRebind(scale, linear);                                                                       // 6538
  }                                                                                                                    // 6539
  var d3_scale_logFormat = d3.format(".0e");                                                                           // 6540
  function d3_scale_logp(x) {                                                                                          // 6541
    return Math.log(x < 0 ? 0 : x);                                                                                    // 6542
  }                                                                                                                    // 6543
  function d3_scale_powp(x) {                                                                                          // 6544
    return Math.exp(x);                                                                                                // 6545
  }                                                                                                                    // 6546
  function d3_scale_logn(x) {                                                                                          // 6547
    return -Math.log(x > 0 ? 0 : -x);                                                                                  // 6548
  }                                                                                                                    // 6549
  function d3_scale_pown(x) {                                                                                          // 6550
    return -Math.exp(-x);                                                                                              // 6551
  }                                                                                                                    // 6552
  function d3_scale_logNice(base) {                                                                                    // 6553
    base = Math.log(base);                                                                                             // 6554
    var nice = {                                                                                                       // 6555
      floor: function(x) {                                                                                             // 6556
        return Math.floor(x / base) * base;                                                                            // 6557
      },                                                                                                               // 6558
      ceil: function(x) {                                                                                              // 6559
        return Math.ceil(x / base) * base;                                                                             // 6560
      }                                                                                                                // 6561
    };                                                                                                                 // 6562
    return function() {                                                                                                // 6563
      return nice;                                                                                                     // 6564
    };                                                                                                                 // 6565
  }                                                                                                                    // 6566
  d3.scale.pow = function() {                                                                                          // 6567
    return d3_scale_pow(d3.scale.linear(), 1);                                                                         // 6568
  };                                                                                                                   // 6569
  function d3_scale_pow(linear, exponent) {                                                                            // 6570
    var powp = d3_scale_powPow(exponent), powb = d3_scale_powPow(1 / exponent);                                        // 6571
    function scale(x) {                                                                                                // 6572
      return linear(powp(x));                                                                                          // 6573
    }                                                                                                                  // 6574
    scale.invert = function(x) {                                                                                       // 6575
      return powb(linear.invert(x));                                                                                   // 6576
    };                                                                                                                 // 6577
    scale.domain = function(x) {                                                                                       // 6578
      if (!arguments.length) return linear.domain().map(powb);                                                         // 6579
      linear.domain(x.map(powp));                                                                                      // 6580
      return scale;                                                                                                    // 6581
    };                                                                                                                 // 6582
    scale.ticks = function(m) {                                                                                        // 6583
      return d3_scale_linearTicks(scale.domain(), m);                                                                  // 6584
    };                                                                                                                 // 6585
    scale.tickFormat = function(m, format) {                                                                           // 6586
      return d3_scale_linearTickFormat(scale.domain(), m, format);                                                     // 6587
    };                                                                                                                 // 6588
    scale.nice = function() {                                                                                          // 6589
      return scale.domain(d3_scale_nice(scale.domain(), d3_scale_linearNice));                                         // 6590
    };                                                                                                                 // 6591
    scale.exponent = function(x) {                                                                                     // 6592
      if (!arguments.length) return exponent;                                                                          // 6593
      var domain = scale.domain();                                                                                     // 6594
      powp = d3_scale_powPow(exponent = x);                                                                            // 6595
      powb = d3_scale_powPow(1 / exponent);                                                                            // 6596
      return scale.domain(domain);                                                                                     // 6597
    };                                                                                                                 // 6598
    scale.copy = function() {                                                                                          // 6599
      return d3_scale_pow(linear.copy(), exponent);                                                                    // 6600
    };                                                                                                                 // 6601
    return d3_scale_linearRebind(scale, linear);                                                                       // 6602
  }                                                                                                                    // 6603
  function d3_scale_powPow(e) {                                                                                        // 6604
    return function(x) {                                                                                               // 6605
      return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);                                                                // 6606
    };                                                                                                                 // 6607
  }                                                                                                                    // 6608
  d3.scale.sqrt = function() {                                                                                         // 6609
    return d3.scale.pow().exponent(.5);                                                                                // 6610
  };                                                                                                                   // 6611
  d3.scale.ordinal = function() {                                                                                      // 6612
    return d3_scale_ordinal([], {                                                                                      // 6613
      t: "range",                                                                                                      // 6614
      a: [ [] ]                                                                                                        // 6615
    });                                                                                                                // 6616
  };                                                                                                                   // 6617
  function d3_scale_ordinal(domain, ranger) {                                                                          // 6618
    var index, range, rangeBand;                                                                                       // 6619
    function scale(x) {                                                                                                // 6620
      return range[((index.get(x) || index.set(x, domain.push(x))) - 1) % range.length];                               // 6621
    }                                                                                                                  // 6622
    function steps(start, step) {                                                                                      // 6623
      return d3.range(domain.length).map(function(i) {                                                                 // 6624
        return start + step * i;                                                                                       // 6625
      });                                                                                                              // 6626
    }                                                                                                                  // 6627
    scale.domain = function(x) {                                                                                       // 6628
      if (!arguments.length) return domain;                                                                            // 6629
      domain = [];                                                                                                     // 6630
      index = new d3_Map();                                                                                            // 6631
      var i = -1, n = x.length, xi;                                                                                    // 6632
      while (++i < n) if (!index.has(xi = x[i])) index.set(xi, domain.push(xi));                                       // 6633
      return scale[ranger.t].apply(scale, ranger.a);                                                                   // 6634
    };                                                                                                                 // 6635
    scale.range = function(x) {                                                                                        // 6636
      if (!arguments.length) return range;                                                                             // 6637
      range = x;                                                                                                       // 6638
      rangeBand = 0;                                                                                                   // 6639
      ranger = {                                                                                                       // 6640
        t: "range",                                                                                                    // 6641
        a: arguments                                                                                                   // 6642
      };                                                                                                               // 6643
      return scale;                                                                                                    // 6644
    };                                                                                                                 // 6645
    scale.rangePoints = function(x, padding) {                                                                         // 6646
      if (arguments.length < 2) padding = 0;                                                                           // 6647
      var start = x[0], stop = x[1], step = (stop - start) / (Math.max(1, domain.length - 1) + padding);               // 6648
      range = steps(domain.length < 2 ? (start + stop) / 2 : start + step * padding / 2, step);                        // 6649
      rangeBand = 0;                                                                                                   // 6650
      ranger = {                                                                                                       // 6651
        t: "rangePoints",                                                                                              // 6652
        a: arguments                                                                                                   // 6653
      };                                                                                                               // 6654
      return scale;                                                                                                    // 6655
    };                                                                                                                 // 6656
    scale.rangeBands = function(x, padding, outerPadding) {                                                            // 6657
      if (arguments.length < 2) padding = 0;                                                                           // 6658
      if (arguments.length < 3) outerPadding = padding;                                                                // 6659
      var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = (stop - start) / (domain.length - padding + 2 * outerPadding);
      range = steps(start + step * outerPadding, step);                                                                // 6661
      if (reverse) range.reverse();                                                                                    // 6662
      rangeBand = step * (1 - padding);                                                                                // 6663
      ranger = {                                                                                                       // 6664
        t: "rangeBands",                                                                                               // 6665
        a: arguments                                                                                                   // 6666
      };                                                                                                               // 6667
      return scale;                                                                                                    // 6668
    };                                                                                                                 // 6669
    scale.rangeRoundBands = function(x, padding, outerPadding) {                                                       // 6670
      if (arguments.length < 2) padding = 0;                                                                           // 6671
      if (arguments.length < 3) outerPadding = padding;                                                                // 6672
      var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding)), error = stop - start - (domain.length - padding) * step;
      range = steps(start + Math.round(error / 2), step);                                                              // 6674
      if (reverse) range.reverse();                                                                                    // 6675
      rangeBand = Math.round(step * (1 - padding));                                                                    // 6676
      ranger = {                                                                                                       // 6677
        t: "rangeRoundBands",                                                                                          // 6678
        a: arguments                                                                                                   // 6679
      };                                                                                                               // 6680
      return scale;                                                                                                    // 6681
    };                                                                                                                 // 6682
    scale.rangeBand = function() {                                                                                     // 6683
      return rangeBand;                                                                                                // 6684
    };                                                                                                                 // 6685
    scale.rangeExtent = function() {                                                                                   // 6686
      return d3_scaleExtent(ranger.a[0]);                                                                              // 6687
    };                                                                                                                 // 6688
    scale.copy = function() {                                                                                          // 6689
      return d3_scale_ordinal(domain, ranger);                                                                         // 6690
    };                                                                                                                 // 6691
    return scale.domain(domain);                                                                                       // 6692
  }                                                                                                                    // 6693
  d3.scale.category10 = function() {                                                                                   // 6694
    return d3.scale.ordinal().range(d3_category10);                                                                    // 6695
  };                                                                                                                   // 6696
  d3.scale.category20 = function() {                                                                                   // 6697
    return d3.scale.ordinal().range(d3_category20);                                                                    // 6698
  };                                                                                                                   // 6699
  d3.scale.category20b = function() {                                                                                  // 6700
    return d3.scale.ordinal().range(d3_category20b);                                                                   // 6701
  };                                                                                                                   // 6702
  d3.scale.category20c = function() {                                                                                  // 6703
    return d3.scale.ordinal().range(d3_category20c);                                                                   // 6704
  };                                                                                                                   // 6705
  var d3_category10 = [ "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf" ];
  var d3_category20 = [ "#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c", "#98df8a", "#d62728", "#ff9896", "#9467bd", "#c5b0d5", "#8c564b", "#c49c94", "#e377c2", "#f7b6d2", "#7f7f7f", "#c7c7c7", "#bcbd22", "#dbdb8d", "#17becf", "#9edae5" ];
  var d3_category20b = [ "#393b79", "#5254a3", "#6b6ecf", "#9c9ede", "#637939", "#8ca252", "#b5cf6b", "#cedb9c", "#8c6d31", "#bd9e39", "#e7ba52", "#e7cb94", "#843c39", "#ad494a", "#d6616b", "#e7969c", "#7b4173", "#a55194", "#ce6dbd", "#de9ed6" ];
  var d3_category20c = [ "#3182bd", "#6baed6", "#9ecae1", "#c6dbef", "#e6550d", "#fd8d3c", "#fdae6b", "#fdd0a2", "#31a354", "#74c476", "#a1d99b", "#c7e9c0", "#756bb1", "#9e9ac8", "#bcbddc", "#dadaeb", "#636363", "#969696", "#bdbdbd", "#d9d9d9" ];
  d3.scale.quantile = function() {                                                                                     // 6710
    return d3_scale_quantile([], []);                                                                                  // 6711
  };                                                                                                                   // 6712
  function d3_scale_quantile(domain, range) {                                                                          // 6713
    var thresholds;                                                                                                    // 6714
    function rescale() {                                                                                               // 6715
      var k = 0, q = range.length;                                                                                     // 6716
      thresholds = [];                                                                                                 // 6717
      while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);                                                  // 6718
      return scale;                                                                                                    // 6719
    }                                                                                                                  // 6720
    function scale(x) {                                                                                                // 6721
      if (isNaN(x = +x)) return NaN;                                                                                   // 6722
      return range[d3.bisect(thresholds, x)];                                                                          // 6723
    }                                                                                                                  // 6724
    scale.domain = function(x) {                                                                                       // 6725
      if (!arguments.length) return domain;                                                                            // 6726
      domain = x.filter(function(d) {                                                                                  // 6727
        return !isNaN(d);                                                                                              // 6728
      }).sort(d3.ascending);                                                                                           // 6729
      return rescale();                                                                                                // 6730
    };                                                                                                                 // 6731
    scale.range = function(x) {                                                                                        // 6732
      if (!arguments.length) return range;                                                                             // 6733
      range = x;                                                                                                       // 6734
      return rescale();                                                                                                // 6735
    };                                                                                                                 // 6736
    scale.quantiles = function() {                                                                                     // 6737
      return thresholds;                                                                                               // 6738
    };                                                                                                                 // 6739
    scale.copy = function() {                                                                                          // 6740
      return d3_scale_quantile(domain, range);                                                                         // 6741
    };                                                                                                                 // 6742
    return rescale();                                                                                                  // 6743
  }                                                                                                                    // 6744
  d3.scale.quantize = function() {                                                                                     // 6745
    return d3_scale_quantize(0, 1, [ 0, 1 ]);                                                                          // 6746
  };                                                                                                                   // 6747
  function d3_scale_quantize(x0, x1, range) {                                                                          // 6748
    var kx, i;                                                                                                         // 6749
    function scale(x) {                                                                                                // 6750
      return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];                                               // 6751
    }                                                                                                                  // 6752
    function rescale() {                                                                                               // 6753
      kx = range.length / (x1 - x0);                                                                                   // 6754
      i = range.length - 1;                                                                                            // 6755
      return scale;                                                                                                    // 6756
    }                                                                                                                  // 6757
    scale.domain = function(x) {                                                                                       // 6758
      if (!arguments.length) return [ x0, x1 ];                                                                        // 6759
      x0 = +x[0];                                                                                                      // 6760
      x1 = +x[x.length - 1];                                                                                           // 6761
      return rescale();                                                                                                // 6762
    };                                                                                                                 // 6763
    scale.range = function(x) {                                                                                        // 6764
      if (!arguments.length) return range;                                                                             // 6765
      range = x;                                                                                                       // 6766
      return rescale();                                                                                                // 6767
    };                                                                                                                 // 6768
    scale.copy = function() {                                                                                          // 6769
      return d3_scale_quantize(x0, x1, range);                                                                         // 6770
    };                                                                                                                 // 6771
    return rescale();                                                                                                  // 6772
  }                                                                                                                    // 6773
  d3.scale.threshold = function() {                                                                                    // 6774
    return d3_scale_threshold([ .5 ], [ 0, 1 ]);                                                                       // 6775
  };                                                                                                                   // 6776
  function d3_scale_threshold(domain, range) {                                                                         // 6777
    function scale(x) {                                                                                                // 6778
      return range[d3.bisect(domain, x)];                                                                              // 6779
    }                                                                                                                  // 6780
    scale.domain = function(_) {                                                                                       // 6781
      if (!arguments.length) return domain;                                                                            // 6782
      domain = _;                                                                                                      // 6783
      return scale;                                                                                                    // 6784
    };                                                                                                                 // 6785
    scale.range = function(_) {                                                                                        // 6786
      if (!arguments.length) return range;                                                                             // 6787
      range = _;                                                                                                       // 6788
      return scale;                                                                                                    // 6789
    };                                                                                                                 // 6790
    scale.copy = function() {                                                                                          // 6791
      return d3_scale_threshold(domain, range);                                                                        // 6792
    };                                                                                                                 // 6793
    return scale;                                                                                                      // 6794
  }                                                                                                                    // 6795
  d3.scale.identity = function() {                                                                                     // 6796
    return d3_scale_identity([ 0, 1 ]);                                                                                // 6797
  };                                                                                                                   // 6798
  function d3_scale_identity(domain) {                                                                                 // 6799
    function identity(x) {                                                                                             // 6800
      return +x;                                                                                                       // 6801
    }                                                                                                                  // 6802
    identity.invert = identity;                                                                                        // 6803
    identity.domain = identity.range = function(x) {                                                                   // 6804
      if (!arguments.length) return domain;                                                                            // 6805
      domain = x.map(identity);                                                                                        // 6806
      return identity;                                                                                                 // 6807
    };                                                                                                                 // 6808
    identity.ticks = function(m) {                                                                                     // 6809
      return d3_scale_linearTicks(domain, m);                                                                          // 6810
    };                                                                                                                 // 6811
    identity.tickFormat = function(m, format) {                                                                        // 6812
      return d3_scale_linearTickFormat(domain, m, format);                                                             // 6813
    };                                                                                                                 // 6814
    identity.copy = function() {                                                                                       // 6815
      return d3_scale_identity(domain);                                                                                // 6816
    };                                                                                                                 // 6817
    return identity;                                                                                                   // 6818
  }                                                                                                                    // 6819
  d3.svg.arc = function() {                                                                                            // 6820
    var innerRadius = d3_svg_arcInnerRadius, outerRadius = d3_svg_arcOuterRadius, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle;
    function arc() {                                                                                                   // 6822
      var r0 = innerRadius.apply(this, arguments), r1 = outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) + d3_svg_arcOffset, a1 = endAngle.apply(this, arguments) + d3_svg_arcOffset, da = (a1 < a0 && (da = a0,
      a0 = a1, a1 = da), a1 - a0), df = da < π ? "0" : "1", c0 = Math.cos(a0), s0 = Math.sin(a0), c1 = Math.cos(a1), s1 = Math.sin(a1);
      return da >= d3_svg_arcMax ? r0 ? "M0," + r1 + "A" + r1 + "," + r1 + " 0 1,1 0," + -r1 + "A" + r1 + "," + r1 + " 0 1,1 0," + r1 + "M0," + r0 + "A" + r0 + "," + r0 + " 0 1,0 0," + -r0 + "A" + r0 + "," + r0 + " 0 1,0 0," + r0 + "Z" : "M0," + r1 + "A" + r1 + "," + r1 + " 0 1,1 0," + -r1 + "A" + r1 + "," + r1 + " 0 1,1 0," + r1 + "Z" : r0 ? "M" + r1 * c0 + "," + r1 * s0 + "A" + r1 + "," + r1 + " 0 " + df + ",1 " + r1 * c1 + "," + r1 * s1 + "L" + r0 * c1 + "," + r0 * s1 + "A" + r0 + "," + r0 + " 0 " + df + ",0 " + r0 * c0 + "," + r0 * s0 + "Z" : "M" + r1 * c0 + "," + r1 * s0 + "A" + r1 + "," + r1 + " 0 " + df + ",1 " + r1 * c1 + "," + r1 * s1 + "L0,0" + "Z";
    }                                                                                                                  // 6826
    arc.innerRadius = function(v) {                                                                                    // 6827
      if (!arguments.length) return innerRadius;                                                                       // 6828
      innerRadius = d3_functor(v);                                                                                     // 6829
      return arc;                                                                                                      // 6830
    };                                                                                                                 // 6831
    arc.outerRadius = function(v) {                                                                                    // 6832
      if (!arguments.length) return outerRadius;                                                                       // 6833
      outerRadius = d3_functor(v);                                                                                     // 6834
      return arc;                                                                                                      // 6835
    };                                                                                                                 // 6836
    arc.startAngle = function(v) {                                                                                     // 6837
      if (!arguments.length) return startAngle;                                                                        // 6838
      startAngle = d3_functor(v);                                                                                      // 6839
      return arc;                                                                                                      // 6840
    };                                                                                                                 // 6841
    arc.endAngle = function(v) {                                                                                       // 6842
      if (!arguments.length) return endAngle;                                                                          // 6843
      endAngle = d3_functor(v);                                                                                        // 6844
      return arc;                                                                                                      // 6845
    };                                                                                                                 // 6846
    arc.centroid = function() {                                                                                        // 6847
      var r = (innerRadius.apply(this, arguments) + outerRadius.apply(this, arguments)) / 2, a = (startAngle.apply(this, arguments) + endAngle.apply(this, arguments)) / 2 + d3_svg_arcOffset;
      return [ Math.cos(a) * r, Math.sin(a) * r ];                                                                     // 6849
    };                                                                                                                 // 6850
    return arc;                                                                                                        // 6851
  };                                                                                                                   // 6852
  var d3_svg_arcOffset = -π / 2, d3_svg_arcMax = 2 * π - 1e-6;                                                         // 6853
  function d3_svg_arcInnerRadius(d) {                                                                                  // 6854
    return d.innerRadius;                                                                                              // 6855
  }                                                                                                                    // 6856
  function d3_svg_arcOuterRadius(d) {                                                                                  // 6857
    return d.outerRadius;                                                                                              // 6858
  }                                                                                                                    // 6859
  function d3_svg_arcStartAngle(d) {                                                                                   // 6860
    return d.startAngle;                                                                                               // 6861
  }                                                                                                                    // 6862
  function d3_svg_arcEndAngle(d) {                                                                                     // 6863
    return d.endAngle;                                                                                                 // 6864
  }                                                                                                                    // 6865
  d3.svg.line.radial = function() {                                                                                    // 6866
    var line = d3_svg_line(d3_svg_lineRadial);                                                                         // 6867
    line.radius = line.x, delete line.x;                                                                               // 6868
    line.angle = line.y, delete line.y;                                                                                // 6869
    return line;                                                                                                       // 6870
  };                                                                                                                   // 6871
  function d3_svg_lineRadial(points) {                                                                                 // 6872
    var point, i = -1, n = points.length, r, a;                                                                        // 6873
    while (++i < n) {                                                                                                  // 6874
      point = points[i];                                                                                               // 6875
      r = point[0];                                                                                                    // 6876
      a = point[1] + d3_svg_arcOffset;                                                                                 // 6877
      point[0] = r * Math.cos(a);                                                                                      // 6878
      point[1] = r * Math.sin(a);                                                                                      // 6879
    }                                                                                                                  // 6880
    return points;                                                                                                     // 6881
  }                                                                                                                    // 6882
  function d3_svg_area(projection) {                                                                                   // 6883
    var x0 = d3_svg_lineX, x1 = d3_svg_lineX, y0 = 0, y1 = d3_svg_lineY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, interpolateReverse = interpolate, L = "L", tension = .7;
    function area(data) {                                                                                              // 6885
      var segments = [], points0 = [], points1 = [], i = -1, n = data.length, d, fx0 = d3_functor(x0), fy0 = d3_functor(y0), fx1 = x0 === x1 ? function() {
        return x;                                                                                                      // 6887
      } : d3_functor(x1), fy1 = y0 === y1 ? function() {                                                               // 6888
        return y;                                                                                                      // 6889
      } : d3_functor(y1), x, y;                                                                                        // 6890
      function segment() {                                                                                             // 6891
        segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
      }                                                                                                                // 6893
      while (++i < n) {                                                                                                // 6894
        if (defined.call(this, d = data[i], i)) {                                                                      // 6895
          points0.push([ x = +fx0.call(this, d, i), y = +fy0.call(this, d, i) ]);                                      // 6896
          points1.push([ +fx1.call(this, d, i), +fy1.call(this, d, i) ]);                                              // 6897
        } else if (points0.length) {                                                                                   // 6898
          segment();                                                                                                   // 6899
          points0 = [];                                                                                                // 6900
          points1 = [];                                                                                                // 6901
        }                                                                                                              // 6902
      }                                                                                                                // 6903
      if (points0.length) segment();                                                                                   // 6904
      return segments.length ? segments.join("") : null;                                                               // 6905
    }                                                                                                                  // 6906
    area.x = function(_) {                                                                                             // 6907
      if (!arguments.length) return x1;                                                                                // 6908
      x0 = x1 = _;                                                                                                     // 6909
      return area;                                                                                                     // 6910
    };                                                                                                                 // 6911
    area.x0 = function(_) {                                                                                            // 6912
      if (!arguments.length) return x0;                                                                                // 6913
      x0 = _;                                                                                                          // 6914
      return area;                                                                                                     // 6915
    };                                                                                                                 // 6916
    area.x1 = function(_) {                                                                                            // 6917
      if (!arguments.length) return x1;                                                                                // 6918
      x1 = _;                                                                                                          // 6919
      return area;                                                                                                     // 6920
    };                                                                                                                 // 6921
    area.y = function(_) {                                                                                             // 6922
      if (!arguments.length) return y1;                                                                                // 6923
      y0 = y1 = _;                                                                                                     // 6924
      return area;                                                                                                     // 6925
    };                                                                                                                 // 6926
    area.y0 = function(_) {                                                                                            // 6927
      if (!arguments.length) return y0;                                                                                // 6928
      y0 = _;                                                                                                          // 6929
      return area;                                                                                                     // 6930
    };                                                                                                                 // 6931
    area.y1 = function(_) {                                                                                            // 6932
      if (!arguments.length) return y1;                                                                                // 6933
      y1 = _;                                                                                                          // 6934
      return area;                                                                                                     // 6935
    };                                                                                                                 // 6936
    area.defined = function(_) {                                                                                       // 6937
      if (!arguments.length) return defined;                                                                           // 6938
      defined = _;                                                                                                     // 6939
      return area;                                                                                                     // 6940
    };                                                                                                                 // 6941
    area.interpolate = function(_) {                                                                                   // 6942
      if (!arguments.length) return interpolateKey;                                                                    // 6943
      if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
      interpolateReverse = interpolate.reverse || interpolate;                                                         // 6945
      L = interpolate.closed ? "M" : "L";                                                                              // 6946
      return area;                                                                                                     // 6947
    };                                                                                                                 // 6948
    area.tension = function(_) {                                                                                       // 6949
      if (!arguments.length) return tension;                                                                           // 6950
      tension = _;                                                                                                     // 6951
      return area;                                                                                                     // 6952
    };                                                                                                                 // 6953
    return area;                                                                                                       // 6954
  }                                                                                                                    // 6955
  d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;                                                                // 6956
  d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;                                                                // 6957
  d3.svg.area = function() {                                                                                           // 6958
    return d3_svg_area(d3_identity);                                                                                   // 6959
  };                                                                                                                   // 6960
  d3.svg.area.radial = function() {                                                                                    // 6961
    var area = d3_svg_area(d3_svg_lineRadial);                                                                         // 6962
    area.radius = area.x, delete area.x;                                                                               // 6963
    area.innerRadius = area.x0, delete area.x0;                                                                        // 6964
    area.outerRadius = area.x1, delete area.x1;                                                                        // 6965
    area.angle = area.y, delete area.y;                                                                                // 6966
    area.startAngle = area.y0, delete area.y0;                                                                         // 6967
    area.endAngle = area.y1, delete area.y1;                                                                           // 6968
    return area;                                                                                                       // 6969
  };                                                                                                                   // 6970
  d3.svg.chord = function() {                                                                                          // 6971
    var source = d3_source, target = d3_target, radius = d3_svg_chordRadius, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle;
    function chord(d, i) {                                                                                             // 6973
      var s = subgroup(this, source, d, i), t = subgroup(this, target, d, i);                                          // 6974
      return "M" + s.p0 + arc(s.r, s.p1, s.a1 - s.a0) + (equals(s, t) ? curve(s.r, s.p1, s.r, s.p0) : curve(s.r, s.p1, t.r, t.p0) + arc(t.r, t.p1, t.a1 - t.a0) + curve(t.r, t.p1, s.r, s.p0)) + "Z";
    }                                                                                                                  // 6976
    function subgroup(self, f, d, i) {                                                                                 // 6977
      var subgroup = f.call(self, d, i), r = radius.call(self, subgroup, i), a0 = startAngle.call(self, subgroup, i) + d3_svg_arcOffset, a1 = endAngle.call(self, subgroup, i) + d3_svg_arcOffset;
      return {                                                                                                         // 6979
        r: r,                                                                                                          // 6980
        a0: a0,                                                                                                        // 6981
        a1: a1,                                                                                                        // 6982
        p0: [ r * Math.cos(a0), r * Math.sin(a0) ],                                                                    // 6983
        p1: [ r * Math.cos(a1), r * Math.sin(a1) ]                                                                     // 6984
      };                                                                                                               // 6985
    }                                                                                                                  // 6986
    function equals(a, b) {                                                                                            // 6987
      return a.a0 == b.a0 && a.a1 == b.a1;                                                                             // 6988
    }                                                                                                                  // 6989
    function arc(r, p, a) {                                                                                            // 6990
      return "A" + r + "," + r + " 0 " + +(a > π) + ",1 " + p;                                                         // 6991
    }                                                                                                                  // 6992
    function curve(r0, p0, r1, p1) {                                                                                   // 6993
      return "Q 0,0 " + p1;                                                                                            // 6994
    }                                                                                                                  // 6995
    chord.radius = function(v) {                                                                                       // 6996
      if (!arguments.length) return radius;                                                                            // 6997
      radius = d3_functor(v);                                                                                          // 6998
      return chord;                                                                                                    // 6999
    };                                                                                                                 // 7000
    chord.source = function(v) {                                                                                       // 7001
      if (!arguments.length) return source;                                                                            // 7002
      source = d3_functor(v);                                                                                          // 7003
      return chord;                                                                                                    // 7004
    };                                                                                                                 // 7005
    chord.target = function(v) {                                                                                       // 7006
      if (!arguments.length) return target;                                                                            // 7007
      target = d3_functor(v);                                                                                          // 7008
      return chord;                                                                                                    // 7009
    };                                                                                                                 // 7010
    chord.startAngle = function(v) {                                                                                   // 7011
      if (!arguments.length) return startAngle;                                                                        // 7012
      startAngle = d3_functor(v);                                                                                      // 7013
      return chord;                                                                                                    // 7014
    };                                                                                                                 // 7015
    chord.endAngle = function(v) {                                                                                     // 7016
      if (!arguments.length) return endAngle;                                                                          // 7017
      endAngle = d3_functor(v);                                                                                        // 7018
      return chord;                                                                                                    // 7019
    };                                                                                                                 // 7020
    return chord;                                                                                                      // 7021
  };                                                                                                                   // 7022
  function d3_svg_chordRadius(d) {                                                                                     // 7023
    return d.radius;                                                                                                   // 7024
  }                                                                                                                    // 7025
  d3.svg.diagonal = function() {                                                                                       // 7026
    var source = d3_source, target = d3_target, projection = d3_svg_diagonalProjection;                                // 7027
    function diagonal(d, i) {                                                                                          // 7028
      var p0 = source.call(this, d, i), p3 = target.call(this, d, i), m = (p0.y + p3.y) / 2, p = [ p0, {               // 7029
        x: p0.x,                                                                                                       // 7030
        y: m                                                                                                           // 7031
      }, {                                                                                                             // 7032
        x: p3.x,                                                                                                       // 7033
        y: m                                                                                                           // 7034
      }, p3 ];                                                                                                         // 7035
      p = p.map(projection);                                                                                           // 7036
      return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];                                                        // 7037
    }                                                                                                                  // 7038
    diagonal.source = function(x) {                                                                                    // 7039
      if (!arguments.length) return source;                                                                            // 7040
      source = d3_functor(x);                                                                                          // 7041
      return diagonal;                                                                                                 // 7042
    };                                                                                                                 // 7043
    diagonal.target = function(x) {                                                                                    // 7044
      if (!arguments.length) return target;                                                                            // 7045
      target = d3_functor(x);                                                                                          // 7046
      return diagonal;                                                                                                 // 7047
    };                                                                                                                 // 7048
    diagonal.projection = function(x) {                                                                                // 7049
      if (!arguments.length) return projection;                                                                        // 7050
      projection = x;                                                                                                  // 7051
      return diagonal;                                                                                                 // 7052
    };                                                                                                                 // 7053
    return diagonal;                                                                                                   // 7054
  };                                                                                                                   // 7055
  function d3_svg_diagonalProjection(d) {                                                                              // 7056
    return [ d.x, d.y ];                                                                                               // 7057
  }                                                                                                                    // 7058
  d3.svg.diagonal.radial = function() {                                                                                // 7059
    var diagonal = d3.svg.diagonal(), projection = d3_svg_diagonalProjection, projection_ = diagonal.projection;       // 7060
    diagonal.projection = function(x) {                                                                                // 7061
      return arguments.length ? projection_(d3_svg_diagonalRadialProjection(projection = x)) : projection;             // 7062
    };                                                                                                                 // 7063
    return diagonal;                                                                                                   // 7064
  };                                                                                                                   // 7065
  function d3_svg_diagonalRadialProjection(projection) {                                                               // 7066
    return function() {                                                                                                // 7067
      var d = projection.apply(this, arguments), r = d[0], a = d[1] + d3_svg_arcOffset;                                // 7068
      return [ r * Math.cos(a), r * Math.sin(a) ];                                                                     // 7069
    };                                                                                                                 // 7070
  }                                                                                                                    // 7071
  d3.svg.symbol = function() {                                                                                         // 7072
    var type = d3_svg_symbolType, size = d3_svg_symbolSize;                                                            // 7073
    function symbol(d, i) {                                                                                            // 7074
      return (d3_svg_symbols.get(type.call(this, d, i)) || d3_svg_symbolCircle)(size.call(this, d, i));                // 7075
    }                                                                                                                  // 7076
    symbol.type = function(x) {                                                                                        // 7077
      if (!arguments.length) return type;                                                                              // 7078
      type = d3_functor(x);                                                                                            // 7079
      return symbol;                                                                                                   // 7080
    };                                                                                                                 // 7081
    symbol.size = function(x) {                                                                                        // 7082
      if (!arguments.length) return size;                                                                              // 7083
      size = d3_functor(x);                                                                                            // 7084
      return symbol;                                                                                                   // 7085
    };                                                                                                                 // 7086
    return symbol;                                                                                                     // 7087
  };                                                                                                                   // 7088
  function d3_svg_symbolSize() {                                                                                       // 7089
    return 64;                                                                                                         // 7090
  }                                                                                                                    // 7091
  function d3_svg_symbolType() {                                                                                       // 7092
    return "circle";                                                                                                   // 7093
  }                                                                                                                    // 7094
  function d3_svg_symbolCircle(size) {                                                                                 // 7095
    var r = Math.sqrt(size / π);                                                                                       // 7096
    return "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";               // 7097
  }                                                                                                                    // 7098
  var d3_svg_symbols = d3.map({                                                                                        // 7099
    circle: d3_svg_symbolCircle,                                                                                       // 7100
    cross: function(size) {                                                                                            // 7101
      var r = Math.sqrt(size / 5) / 2;                                                                                 // 7102
      return "M" + -3 * r + "," + -r + "H" + -r + "V" + -3 * r + "H" + r + "V" + -r + "H" + 3 * r + "V" + r + "H" + r + "V" + 3 * r + "H" + -r + "V" + r + "H" + -3 * r + "Z";
    },                                                                                                                 // 7104
    diamond: function(size) {                                                                                          // 7105
      var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)), rx = ry * d3_svg_symbolTan30;                               // 7106
      return "M0," + -ry + "L" + rx + ",0" + " 0," + ry + " " + -rx + ",0" + "Z";                                      // 7107
    },                                                                                                                 // 7108
    square: function(size) {                                                                                           // 7109
      var r = Math.sqrt(size) / 2;                                                                                     // 7110
      return "M" + -r + "," + -r + "L" + r + "," + -r + " " + r + "," + r + " " + -r + "," + r + "Z";                  // 7111
    },                                                                                                                 // 7112
    "triangle-down": function(size) {                                                                                  // 7113
      var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;                                 // 7114
      return "M0," + ry + "L" + rx + "," + -ry + " " + -rx + "," + -ry + "Z";                                          // 7115
    },                                                                                                                 // 7116
    "triangle-up": function(size) {                                                                                    // 7117
      var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;                                 // 7118
      return "M0," + -ry + "L" + rx + "," + ry + " " + -rx + "," + ry + "Z";                                           // 7119
    }                                                                                                                  // 7120
  });                                                                                                                  // 7121
  d3.svg.symbolTypes = d3_svg_symbols.keys();                                                                          // 7122
  var d3_svg_symbolSqrt3 = Math.sqrt(3), d3_svg_symbolTan30 = Math.tan(30 * d3_radians);                               // 7123
  function d3_transition(groups, id) {                                                                                 // 7124
    d3_arraySubclass(groups, d3_transitionPrototype);                                                                  // 7125
    groups.id = id;                                                                                                    // 7126
    return groups;                                                                                                     // 7127
  }                                                                                                                    // 7128
  var d3_transitionPrototype = [], d3_transitionId = 0, d3_transitionInheritId, d3_transitionInherit = {               // 7129
    ease: d3_ease_cubicInOut,                                                                                          // 7130
    delay: 0,                                                                                                          // 7131
    duration: 250                                                                                                      // 7132
  };                                                                                                                   // 7133
  d3_transitionPrototype.call = d3_selectionPrototype.call;                                                            // 7134
  d3_transitionPrototype.empty = d3_selectionPrototype.empty;                                                          // 7135
  d3_transitionPrototype.node = d3_selectionPrototype.node;                                                            // 7136
  d3.transition = function(selection) {                                                                                // 7137
    return arguments.length ? d3_transitionInheritId ? selection.transition() : selection : d3_selectionRoot.transition();
  };                                                                                                                   // 7139
  d3.transition.prototype = d3_transitionPrototype;                                                                    // 7140
  d3_transitionPrototype.select = function(selector) {                                                                 // 7141
    var id = this.id, subgroups = [], subgroup, subnode, node;                                                         // 7142
    if (typeof selector !== "function") selector = d3_selection_selector(selector);                                    // 7143
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 7144
      subgroups.push(subgroup = []);                                                                                   // 7145
      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {                                                 // 7146
        if ((node = group[i]) && (subnode = selector.call(node, node.__data__, i))) {                                  // 7147
          if ("__data__" in node) subnode.__data__ = node.__data__;                                                    // 7148
          d3_transitionNode(subnode, i, id, node.__transition__[id]);                                                  // 7149
          subgroup.push(subnode);                                                                                      // 7150
        } else {                                                                                                       // 7151
          subgroup.push(null);                                                                                         // 7152
        }                                                                                                              // 7153
      }                                                                                                                // 7154
    }                                                                                                                  // 7155
    return d3_transition(subgroups, id);                                                                               // 7156
  };                                                                                                                   // 7157
  d3_transitionPrototype.selectAll = function(selector) {                                                              // 7158
    var id = this.id, subgroups = [], subgroup, subnodes, node, subnode, transition;                                   // 7159
    if (typeof selector !== "function") selector = d3_selection_selectorAll(selector);                                 // 7160
    for (var j = -1, m = this.length; ++j < m; ) {                                                                     // 7161
      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {                                                 // 7162
        if (node = group[i]) {                                                                                         // 7163
          transition = node.__transition__[id];                                                                        // 7164
          subnodes = selector.call(node, node.__data__, i);                                                            // 7165
          subgroups.push(subgroup = []);                                                                               // 7166
          for (var k = -1, o = subnodes.length; ++k < o; ) {                                                           // 7167
            d3_transitionNode(subnode = subnodes[k], k, id, transition);                                               // 7168
            subgroup.push(subnode);                                                                                    // 7169
          }                                                                                                            // 7170
        }                                                                                                              // 7171
      }                                                                                                                // 7172
    }                                                                                                                  // 7173
    return d3_transition(subgroups, id);                                                                               // 7174
  };                                                                                                                   // 7175
  d3_transitionPrototype.filter = function(filter) {                                                                   // 7176
    var subgroups = [], subgroup, group, node;                                                                         // 7177
    if (typeof filter !== "function") filter = d3_selection_filter(filter);                                            // 7178
    for (var j = 0, m = this.length; j < m; j++) {                                                                     // 7179
      subgroups.push(subgroup = []);                                                                                   // 7180
      for (var group = this[j], i = 0, n = group.length; i < n; i++) {                                                 // 7181
        if ((node = group[i]) && filter.call(node, node.__data__, i)) {                                                // 7182
          subgroup.push(node);                                                                                         // 7183
        }                                                                                                              // 7184
      }                                                                                                                // 7185
    }                                                                                                                  // 7186
    return d3_transition(subgroups, this.id, this.time).ease(this.ease());                                             // 7187
  };                                                                                                                   // 7188
  d3_transitionPrototype.tween = function(name, tween) {                                                               // 7189
    var id = this.id;                                                                                                  // 7190
    if (arguments.length < 2) return this.node().__transition__[id].tween.get(name);                                   // 7191
    return d3_selection_each(this, tween == null ? function(node) {                                                    // 7192
      node.__transition__[id].tween.remove(name);                                                                      // 7193
    } : function(node) {                                                                                               // 7194
      node.__transition__[id].tween.set(name, tween);                                                                  // 7195
    });                                                                                                                // 7196
  };                                                                                                                   // 7197
  function d3_transition_tween(groups, name, value, tween) {                                                           // 7198
    var id = groups.id;                                                                                                // 7199
    return d3_selection_each(groups, typeof value === "function" ? function(node, i, j) {                              // 7200
      node.__transition__[id].tween.set(name, tween(value.call(node, node.__data__, i, j)));                           // 7201
    } : (value = tween(value), function(node) {                                                                        // 7202
      node.__transition__[id].tween.set(name, value);                                                                  // 7203
    }));                                                                                                               // 7204
  }                                                                                                                    // 7205
  d3_transitionPrototype.attr = function(nameNS, value) {                                                              // 7206
    if (arguments.length < 2) {                                                                                        // 7207
      for (value in nameNS) this.attr(value, nameNS[value]);                                                           // 7208
      return this;                                                                                                     // 7209
    }                                                                                                                  // 7210
    var interpolate = d3_interpolateByName(nameNS), name = d3.ns.qualify(nameNS);                                      // 7211
    function attrNull() {                                                                                              // 7212
      this.removeAttribute(name);                                                                                      // 7213
    }                                                                                                                  // 7214
    function attrNullNS() {                                                                                            // 7215
      this.removeAttributeNS(name.space, name.local);                                                                  // 7216
    }                                                                                                                  // 7217
    return d3_transition_tween(this, "attr." + nameNS, value, function(b) {                                            // 7218
      function attrString() {                                                                                          // 7219
        var a = this.getAttribute(name), i;                                                                            // 7220
        return a !== b && (i = interpolate(a, b), function(t) {                                                        // 7221
          this.setAttribute(name, i(t));                                                                               // 7222
        });                                                                                                            // 7223
      }                                                                                                                // 7224
      function attrStringNS() {                                                                                        // 7225
        var a = this.getAttributeNS(name.space, name.local), i;                                                        // 7226
        return a !== b && (i = interpolate(a, b), function(t) {                                                        // 7227
          this.setAttributeNS(name.space, name.local, i(t));                                                           // 7228
        });                                                                                                            // 7229
      }                                                                                                                // 7230
      return b == null ? name.local ? attrNullNS : attrNull : (b += "", name.local ? attrStringNS : attrString);       // 7231
    });                                                                                                                // 7232
  };                                                                                                                   // 7233
  d3_transitionPrototype.attrTween = function(nameNS, tween) {                                                         // 7234
    var name = d3.ns.qualify(nameNS);                                                                                  // 7235
    function attrTween(d, i) {                                                                                         // 7236
      var f = tween.call(this, d, i, this.getAttribute(name));                                                         // 7237
      return f && function(t) {                                                                                        // 7238
        this.setAttribute(name, f(t));                                                                                 // 7239
      };                                                                                                               // 7240
    }                                                                                                                  // 7241
    function attrTweenNS(d, i) {                                                                                       // 7242
      var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));                                     // 7243
      return f && function(t) {                                                                                        // 7244
        this.setAttributeNS(name.space, name.local, f(t));                                                             // 7245
      };                                                                                                               // 7246
    }                                                                                                                  // 7247
    return this.tween("attr." + nameNS, name.local ? attrTweenNS : attrTween);                                         // 7248
  };                                                                                                                   // 7249
  d3_transitionPrototype.style = function(name, value, priority) {                                                     // 7250
    var n = arguments.length;                                                                                          // 7251
    if (n < 3) {                                                                                                       // 7252
      if (typeof name !== "string") {                                                                                  // 7253
        if (n < 2) value = "";                                                                                         // 7254
        for (priority in name) this.style(priority, name[priority], value);                                            // 7255
        return this;                                                                                                   // 7256
      }                                                                                                                // 7257
      priority = "";                                                                                                   // 7258
    }                                                                                                                  // 7259
    var interpolate = d3_interpolateByName(name);                                                                      // 7260
    function styleNull() {                                                                                             // 7261
      this.style.removeProperty(name);                                                                                 // 7262
    }                                                                                                                  // 7263
    return d3_transition_tween(this, "style." + name, value, function(b) {                                             // 7264
      function styleString() {                                                                                         // 7265
        var a = d3_window.getComputedStyle(this, null).getPropertyValue(name), i;                                      // 7266
        return a !== b && (i = interpolate(a, b), function(t) {                                                        // 7267
          this.style.setProperty(name, i(t), priority);                                                                // 7268
        });                                                                                                            // 7269
      }                                                                                                                // 7270
      return b == null ? styleNull : (b += "", styleString);                                                           // 7271
    });                                                                                                                // 7272
  };                                                                                                                   // 7273
  d3_transitionPrototype.styleTween = function(name, tween, priority) {                                                // 7274
    if (arguments.length < 3) priority = "";                                                                           // 7275
    return this.tween("style." + name, function(d, i) {                                                                // 7276
      var f = tween.call(this, d, i, d3_window.getComputedStyle(this, null).getPropertyValue(name));                   // 7277
      return f && function(t) {                                                                                        // 7278
        this.style.setProperty(name, f(t), priority);                                                                  // 7279
      };                                                                                                               // 7280
    });                                                                                                                // 7281
  };                                                                                                                   // 7282
  d3_transitionPrototype.text = function(value) {                                                                      // 7283
    return d3_transition_tween(this, "text", value, d3_transition_text);                                               // 7284
  };                                                                                                                   // 7285
  function d3_transition_text(b) {                                                                                     // 7286
    if (b == null) b = "";                                                                                             // 7287
    return function() {                                                                                                // 7288
      this.textContent = b;                                                                                            // 7289
    };                                                                                                                 // 7290
  }                                                                                                                    // 7291
  d3_transitionPrototype.remove = function() {                                                                         // 7292
    return this.each("end.transition", function() {                                                                    // 7293
      var p;                                                                                                           // 7294
      if (!this.__transition__ && (p = this.parentNode)) p.removeChild(this);                                          // 7295
    });                                                                                                                // 7296
  };                                                                                                                   // 7297
  d3_transitionPrototype.ease = function(value) {                                                                      // 7298
    var id = this.id;                                                                                                  // 7299
    if (arguments.length < 1) return this.node().__transition__[id].ease;                                              // 7300
    if (typeof value !== "function") value = d3.ease.apply(d3, arguments);                                             // 7301
    return d3_selection_each(this, function(node) {                                                                    // 7302
      node.__transition__[id].ease = value;                                                                            // 7303
    });                                                                                                                // 7304
  };                                                                                                                   // 7305
  d3_transitionPrototype.delay = function(value) {                                                                     // 7306
    var id = this.id;                                                                                                  // 7307
    return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {                                // 7308
      node.__transition__[id].delay = value.call(node, node.__data__, i, j) | 0;                                       // 7309
    } : (value |= 0, function(node) {                                                                                  // 7310
      node.__transition__[id].delay = value;                                                                           // 7311
    }));                                                                                                               // 7312
  };                                                                                                                   // 7313
  d3_transitionPrototype.duration = function(value) {                                                                  // 7314
    var id = this.id;                                                                                                  // 7315
    return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {                                // 7316
      node.__transition__[id].duration = Math.max(1, value.call(node, node.__data__, i, j) | 0);                       // 7317
    } : (value = Math.max(1, value | 0), function(node) {                                                              // 7318
      node.__transition__[id].duration = value;                                                                        // 7319
    }));                                                                                                               // 7320
  };                                                                                                                   // 7321
  d3_transitionPrototype.each = function(type, listener) {                                                             // 7322
    var id = this.id;                                                                                                  // 7323
    if (arguments.length < 2) {                                                                                        // 7324
      var inherit = d3_transitionInherit, inheritId = d3_transitionInheritId;                                          // 7325
      d3_transitionInheritId = id;                                                                                     // 7326
      d3_selection_each(this, function(node, i, j) {                                                                   // 7327
        d3_transitionInherit = node.__transition__[id];                                                                // 7328
        type.call(node, node.__data__, i, j);                                                                          // 7329
      });                                                                                                              // 7330
      d3_transitionInherit = inherit;                                                                                  // 7331
      d3_transitionInheritId = inheritId;                                                                              // 7332
    } else {                                                                                                           // 7333
      d3_selection_each(this, function(node) {                                                                         // 7334
        node.__transition__[id].event.on(type, listener);                                                              // 7335
      });                                                                                                              // 7336
    }                                                                                                                  // 7337
    return this;                                                                                                       // 7338
  };                                                                                                                   // 7339
  d3_transitionPrototype.transition = function() {                                                                     // 7340
    var id0 = this.id, id1 = ++d3_transitionId, subgroups = [], subgroup, group, node, transition;                     // 7341
    for (var j = 0, m = this.length; j < m; j++) {                                                                     // 7342
      subgroups.push(subgroup = []);                                                                                   // 7343
      for (var group = this[j], i = 0, n = group.length; i < n; i++) {                                                 // 7344
        if (node = group[i]) {                                                                                         // 7345
          transition = Object.create(node.__transition__[id0]);                                                        // 7346
          transition.delay += transition.duration;                                                                     // 7347
          d3_transitionNode(node, i, id1, transition);                                                                 // 7348
        }                                                                                                              // 7349
        subgroup.push(node);                                                                                           // 7350
      }                                                                                                                // 7351
    }                                                                                                                  // 7352
    return d3_transition(subgroups, id1);                                                                              // 7353
  };                                                                                                                   // 7354
  function d3_transitionNode(node, i, id, inherit) {                                                                   // 7355
    var lock = node.__transition__ || (node.__transition__ = {                                                         // 7356
      active: 0,                                                                                                       // 7357
      count: 0                                                                                                         // 7358
    }), transition = lock[id];                                                                                         // 7359
    if (!transition) {                                                                                                 // 7360
      var time = inherit.time;                                                                                         // 7361
      transition = lock[id] = {                                                                                        // 7362
        tween: new d3_Map(),                                                                                           // 7363
        event: d3.dispatch("start", "end"),                                                                            // 7364
        time: time,                                                                                                    // 7365
        ease: inherit.ease,                                                                                            // 7366
        delay: inherit.delay,                                                                                          // 7367
        duration: inherit.duration                                                                                     // 7368
      };                                                                                                               // 7369
      ++lock.count;                                                                                                    // 7370
      d3.timer(function(elapsed) {                                                                                     // 7371
        var d = node.__data__, ease = transition.ease, event = transition.event, delay = transition.delay, duration = transition.duration, tweened = [];
        return delay <= elapsed ? start(elapsed) : d3.timer(start, delay, time), 1;                                    // 7373
        function start(elapsed) {                                                                                      // 7374
          if (lock.active > id) return stop();                                                                         // 7375
          lock.active = id;                                                                                            // 7376
          event.start.call(node, d, i);                                                                                // 7377
          transition.tween.forEach(function(key, value) {                                                              // 7378
            if (value = value.call(node, d, i)) {                                                                      // 7379
              tweened.push(value);                                                                                     // 7380
            }                                                                                                          // 7381
          });                                                                                                          // 7382
          if (!tick(elapsed)) d3.timer(tick, 0, time);                                                                 // 7383
          return 1;                                                                                                    // 7384
        }                                                                                                              // 7385
        function tick(elapsed) {                                                                                       // 7386
          if (lock.active !== id) return stop();                                                                       // 7387
          var t = (elapsed - delay) / duration, e = ease(t), n = tweened.length;                                       // 7388
          while (n > 0) {                                                                                              // 7389
            tweened[--n].call(node, e);                                                                                // 7390
          }                                                                                                            // 7391
          if (t >= 1) {                                                                                                // 7392
            stop();                                                                                                    // 7393
            event.end.call(node, d, i);                                                                                // 7394
            return 1;                                                                                                  // 7395
          }                                                                                                            // 7396
        }                                                                                                              // 7397
        function stop() {                                                                                              // 7398
          if (--lock.count) delete lock[id]; else delete node.__transition__;                                          // 7399
          return 1;                                                                                                    // 7400
        }                                                                                                              // 7401
      }, 0, time);                                                                                                     // 7402
      return transition;                                                                                               // 7403
    }                                                                                                                  // 7404
  }                                                                                                                    // 7405
  d3.svg.axis = function() {                                                                                           // 7406
    var scale = d3.scale.linear(), orient = d3_svg_axisDefaultOrient, tickMajorSize = 6, tickMinorSize = 6, tickEndSize = 6, tickPadding = 3, tickArguments_ = [ 10 ], tickValues = null, tickFormat_, tickSubdivide = 0;
    function axis(g) {                                                                                                 // 7408
      g.each(function() {                                                                                              // 7409
        var g = d3.select(this);                                                                                       // 7410
        var ticks = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments_) : scale.domain() : tickValues, tickFormat = tickFormat_ == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments_) : String : tickFormat_;
        var subticks = d3_svg_axisSubdivide(scale, ticks, tickSubdivide), subtick = g.selectAll(".tick.minor").data(subticks, String), subtickEnter = subtick.enter().insert("line", ".tick").attr("class", "tick minor").style("opacity", 1e-6), subtickExit = d3.transition(subtick.exit()).style("opacity", 1e-6).remove(), subtickUpdate = d3.transition(subtick).style("opacity", 1);
        var tick = g.selectAll(".tick.major").data(ticks, String), tickEnter = tick.enter().insert("g", "path").attr("class", "tick major").style("opacity", 1e-6), tickExit = d3.transition(tick.exit()).style("opacity", 1e-6).remove(), tickUpdate = d3.transition(tick).style("opacity", 1), tickTransform;
        var range = d3_scaleRange(scale), path = g.selectAll(".domain").data([ 0 ]), pathUpdate = (path.enter().append("path").attr("class", "domain"),
        d3.transition(path));                                                                                          // 7415
        var scale1 = scale.copy(), scale0 = this.__chart__ || scale1;                                                  // 7416
        this.__chart__ = scale1;                                                                                       // 7417
        tickEnter.append("line");                                                                                      // 7418
        tickEnter.append("text");                                                                                      // 7419
        var lineEnter = tickEnter.select("line"), lineUpdate = tickUpdate.select("line"), text = tick.select("text").text(tickFormat), textEnter = tickEnter.select("text"), textUpdate = tickUpdate.select("text");
        switch (orient) {                                                                                              // 7421
         case "bottom":                                                                                                // 7422
          {                                                                                                            // 7423
            tickTransform = d3_svg_axisX;                                                                              // 7424
            subtickEnter.attr("y2", tickMinorSize);                                                                    // 7425
            subtickUpdate.attr("x2", 0).attr("y2", tickMinorSize);                                                     // 7426
            lineEnter.attr("y2", tickMajorSize);                                                                       // 7427
            textEnter.attr("y", Math.max(tickMajorSize, 0) + tickPadding);                                             // 7428
            lineUpdate.attr("x2", 0).attr("y2", tickMajorSize);                                                        // 7429
            textUpdate.attr("x", 0).attr("y", Math.max(tickMajorSize, 0) + tickPadding);                               // 7430
            text.attr("dy", ".71em").style("text-anchor", "middle");                                                   // 7431
            pathUpdate.attr("d", "M" + range[0] + "," + tickEndSize + "V0H" + range[1] + "V" + tickEndSize);           // 7432
            break;                                                                                                     // 7433
          }                                                                                                            // 7434
                                                                                                                       // 7435
         case "top":                                                                                                   // 7436
          {                                                                                                            // 7437
            tickTransform = d3_svg_axisX;                                                                              // 7438
            subtickEnter.attr("y2", -tickMinorSize);                                                                   // 7439
            subtickUpdate.attr("x2", 0).attr("y2", -tickMinorSize);                                                    // 7440
            lineEnter.attr("y2", -tickMajorSize);                                                                      // 7441
            textEnter.attr("y", -(Math.max(tickMajorSize, 0) + tickPadding));                                          // 7442
            lineUpdate.attr("x2", 0).attr("y2", -tickMajorSize);                                                       // 7443
            textUpdate.attr("x", 0).attr("y", -(Math.max(tickMajorSize, 0) + tickPadding));                            // 7444
            text.attr("dy", "0em").style("text-anchor", "middle");                                                     // 7445
            pathUpdate.attr("d", "M" + range[0] + "," + -tickEndSize + "V0H" + range[1] + "V" + -tickEndSize);         // 7446
            break;                                                                                                     // 7447
          }                                                                                                            // 7448
                                                                                                                       // 7449
         case "left":                                                                                                  // 7450
          {                                                                                                            // 7451
            tickTransform = d3_svg_axisY;                                                                              // 7452
            subtickEnter.attr("x2", -tickMinorSize);                                                                   // 7453
            subtickUpdate.attr("x2", -tickMinorSize).attr("y2", 0);                                                    // 7454
            lineEnter.attr("x2", -tickMajorSize);                                                                      // 7455
            textEnter.attr("x", -(Math.max(tickMajorSize, 0) + tickPadding));                                          // 7456
            lineUpdate.attr("x2", -tickMajorSize).attr("y2", 0);                                                       // 7457
            textUpdate.attr("x", -(Math.max(tickMajorSize, 0) + tickPadding)).attr("y", 0);                            // 7458
            text.attr("dy", ".32em").style("text-anchor", "end");                                                      // 7459
            pathUpdate.attr("d", "M" + -tickEndSize + "," + range[0] + "H0V" + range[1] + "H" + -tickEndSize);         // 7460
            break;                                                                                                     // 7461
          }                                                                                                            // 7462
                                                                                                                       // 7463
         case "right":                                                                                                 // 7464
          {                                                                                                            // 7465
            tickTransform = d3_svg_axisY;                                                                              // 7466
            subtickEnter.attr("x2", tickMinorSize);                                                                    // 7467
            subtickUpdate.attr("x2", tickMinorSize).attr("y2", 0);                                                     // 7468
            lineEnter.attr("x2", tickMajorSize);                                                                       // 7469
            textEnter.attr("x", Math.max(tickMajorSize, 0) + tickPadding);                                             // 7470
            lineUpdate.attr("x2", tickMajorSize).attr("y2", 0);                                                        // 7471
            textUpdate.attr("x", Math.max(tickMajorSize, 0) + tickPadding).attr("y", 0);                               // 7472
            text.attr("dy", ".32em").style("text-anchor", "start");                                                    // 7473
            pathUpdate.attr("d", "M" + tickEndSize + "," + range[0] + "H0V" + range[1] + "H" + tickEndSize);           // 7474
            break;                                                                                                     // 7475
          }                                                                                                            // 7476
        }                                                                                                              // 7477
        if (scale.ticks) {                                                                                             // 7478
          tickEnter.call(tickTransform, scale0);                                                                       // 7479
          tickUpdate.call(tickTransform, scale1);                                                                      // 7480
          tickExit.call(tickTransform, scale1);                                                                        // 7481
          subtickEnter.call(tickTransform, scale0);                                                                    // 7482
          subtickUpdate.call(tickTransform, scale1);                                                                   // 7483
          subtickExit.call(tickTransform, scale1);                                                                     // 7484
        } else {                                                                                                       // 7485
          var dx = scale1.rangeBand() / 2, x = function(d) {                                                           // 7486
            return scale1(d) + dx;                                                                                     // 7487
          };                                                                                                           // 7488
          tickEnter.call(tickTransform, x);                                                                            // 7489
          tickUpdate.call(tickTransform, x);                                                                           // 7490
        }                                                                                                              // 7491
      });                                                                                                              // 7492
    }                                                                                                                  // 7493
    axis.scale = function(x) {                                                                                         // 7494
      if (!arguments.length) return scale;                                                                             // 7495
      scale = x;                                                                                                       // 7496
      return axis;                                                                                                     // 7497
    };                                                                                                                 // 7498
    axis.orient = function(x) {                                                                                        // 7499
      if (!arguments.length) return orient;                                                                            // 7500
      orient = x in d3_svg_axisOrients ? x + "" : d3_svg_axisDefaultOrient;                                            // 7501
      return axis;                                                                                                     // 7502
    };                                                                                                                 // 7503
    axis.ticks = function() {                                                                                          // 7504
      if (!arguments.length) return tickArguments_;                                                                    // 7505
      tickArguments_ = arguments;                                                                                      // 7506
      return axis;                                                                                                     // 7507
    };                                                                                                                 // 7508
    axis.tickValues = function(x) {                                                                                    // 7509
      if (!arguments.length) return tickValues;                                                                        // 7510
      tickValues = x;                                                                                                  // 7511
      return axis;                                                                                                     // 7512
    };                                                                                                                 // 7513
    axis.tickFormat = function(x) {                                                                                    // 7514
      if (!arguments.length) return tickFormat_;                                                                       // 7515
      tickFormat_ = x;                                                                                                 // 7516
      return axis;                                                                                                     // 7517
    };                                                                                                                 // 7518
    axis.tickSize = function(x, y) {                                                                                   // 7519
      if (!arguments.length) return tickMajorSize;                                                                     // 7520
      var n = arguments.length - 1;                                                                                    // 7521
      tickMajorSize = +x;                                                                                              // 7522
      tickMinorSize = n > 1 ? +y : tickMajorSize;                                                                      // 7523
      tickEndSize = n > 0 ? +arguments[n] : tickMajorSize;                                                             // 7524
      return axis;                                                                                                     // 7525
    };                                                                                                                 // 7526
    axis.tickPadding = function(x) {                                                                                   // 7527
      if (!arguments.length) return tickPadding;                                                                       // 7528
      tickPadding = +x;                                                                                                // 7529
      return axis;                                                                                                     // 7530
    };                                                                                                                 // 7531
    axis.tickSubdivide = function(x) {                                                                                 // 7532
      if (!arguments.length) return tickSubdivide;                                                                     // 7533
      tickSubdivide = +x;                                                                                              // 7534
      return axis;                                                                                                     // 7535
    };                                                                                                                 // 7536
    return axis;                                                                                                       // 7537
  };                                                                                                                   // 7538
  var d3_svg_axisDefaultOrient = "bottom", d3_svg_axisOrients = {                                                      // 7539
    top: 1,                                                                                                            // 7540
    right: 1,                                                                                                          // 7541
    bottom: 1,                                                                                                         // 7542
    left: 1                                                                                                            // 7543
  };                                                                                                                   // 7544
  function d3_svg_axisX(selection, x) {                                                                                // 7545
    selection.attr("transform", function(d) {                                                                          // 7546
      return "translate(" + x(d) + ",0)";                                                                              // 7547
    });                                                                                                                // 7548
  }                                                                                                                    // 7549
  function d3_svg_axisY(selection, y) {                                                                                // 7550
    selection.attr("transform", function(d) {                                                                          // 7551
      return "translate(0," + y(d) + ")";                                                                              // 7552
    });                                                                                                                // 7553
  }                                                                                                                    // 7554
  function d3_svg_axisSubdivide(scale, ticks, m) {                                                                     // 7555
    subticks = [];                                                                                                     // 7556
    if (m && ticks.length > 1) {                                                                                       // 7557
      var extent = d3_scaleExtent(scale.domain()), subticks, i = -1, n = ticks.length, d = (ticks[1] - ticks[0]) / ++m, j, v;
      while (++i < n) {                                                                                                // 7559
        for (j = m; --j > 0; ) {                                                                                       // 7560
          if ((v = +ticks[i] - j * d) >= extent[0]) {                                                                  // 7561
            subticks.push(v);                                                                                          // 7562
          }                                                                                                            // 7563
        }                                                                                                              // 7564
      }                                                                                                                // 7565
      for (--i, j = 0; ++j < m && (v = +ticks[i] + j * d) < extent[1]; ) {                                             // 7566
        subticks.push(v);                                                                                              // 7567
      }                                                                                                                // 7568
    }                                                                                                                  // 7569
    return subticks;                                                                                                   // 7570
  }                                                                                                                    // 7571
  d3.svg.brush = function() {                                                                                          // 7572
    var event = d3_eventDispatch(brush, "brushstart", "brush", "brushend"), x = null, y = null, resizes = d3_svg_brushResizes[0], extent = [ [ 0, 0 ], [ 0, 0 ] ], extentDomain;
    function brush(g) {                                                                                                // 7574
      g.each(function() {                                                                                              // 7575
        var g = d3.select(this), bg = g.selectAll(".background").data([ 0 ]), fg = g.selectAll(".extent").data([ 0 ]), tz = g.selectAll(".resize").data(resizes, String), e;
        g.style("pointer-events", "all").on("mousedown.brush", brushstart).on("touchstart.brush", brushstart);         // 7577
        bg.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair");
        fg.enter().append("rect").attr("class", "extent").style("cursor", "move");                                     // 7579
        tz.enter().append("g").attr("class", function(d) {                                                             // 7580
          return "resize " + d;                                                                                        // 7581
        }).style("cursor", function(d) {                                                                               // 7582
          return d3_svg_brushCursor[d];                                                                                // 7583
        }).append("rect").attr("x", function(d) {                                                                      // 7584
          return /[ew]$/.test(d) ? -3 : null;                                                                          // 7585
        }).attr("y", function(d) {                                                                                     // 7586
          return /^[ns]/.test(d) ? -3 : null;                                                                          // 7587
        }).attr("width", 6).attr("height", 6).style("visibility", "hidden");                                           // 7588
        tz.style("display", brush.empty() ? "none" : null);                                                            // 7589
        tz.exit().remove();                                                                                            // 7590
        if (x) {                                                                                                       // 7591
          e = d3_scaleRange(x);                                                                                        // 7592
          bg.attr("x", e[0]).attr("width", e[1] - e[0]);                                                               // 7593
          redrawX(g);                                                                                                  // 7594
        }                                                                                                              // 7595
        if (y) {                                                                                                       // 7596
          e = d3_scaleRange(y);                                                                                        // 7597
          bg.attr("y", e[0]).attr("height", e[1] - e[0]);                                                              // 7598
          redrawY(g);                                                                                                  // 7599
        }                                                                                                              // 7600
        redraw(g);                                                                                                     // 7601
      });                                                                                                              // 7602
    }                                                                                                                  // 7603
    function redraw(g) {                                                                                               // 7604
      g.selectAll(".resize").attr("transform", function(d) {                                                           // 7605
        return "translate(" + extent[+/e$/.test(d)][0] + "," + extent[+/^s/.test(d)][1] + ")";                         // 7606
      });                                                                                                              // 7607
    }                                                                                                                  // 7608
    function redrawX(g) {                                                                                              // 7609
      g.select(".extent").attr("x", extent[0][0]);                                                                     // 7610
      g.selectAll(".extent,.n>rect,.s>rect").attr("width", extent[1][0] - extent[0][0]);                               // 7611
    }                                                                                                                  // 7612
    function redrawY(g) {                                                                                              // 7613
      g.select(".extent").attr("y", extent[0][1]);                                                                     // 7614
      g.selectAll(".extent,.e>rect,.w>rect").attr("height", extent[1][1] - extent[0][1]);                              // 7615
    }                                                                                                                  // 7616
    function brushstart() {                                                                                            // 7617
      var target = this, eventTarget = d3.select(d3.event.target), event_ = event.of(target, arguments), g = d3.select(target), resizing = eventTarget.datum(), resizingX = !/^(n|s)$/.test(resizing) && x, resizingY = !/^(e|w)$/.test(resizing) && y, dragging = eventTarget.classed("extent"), center, origin = mouse(), offset;
      var w = d3.select(d3_window).on("mousemove.brush", brushmove).on("mouseup.brush", brushend).on("touchmove.brush", brushmove).on("touchend.brush", brushend).on("keydown.brush", keydown).on("keyup.brush", keyup);
      if (dragging) {                                                                                                  // 7620
        origin[0] = extent[0][0] - origin[0];                                                                          // 7621
        origin[1] = extent[0][1] - origin[1];                                                                          // 7622
      } else if (resizing) {                                                                                           // 7623
        var ex = +/w$/.test(resizing), ey = +/^n/.test(resizing);                                                      // 7624
        offset = [ extent[1 - ex][0] - origin[0], extent[1 - ey][1] - origin[1] ];                                     // 7625
        origin[0] = extent[ex][0];                                                                                     // 7626
        origin[1] = extent[ey][1];                                                                                     // 7627
      } else if (d3.event.altKey) center = origin.slice();                                                             // 7628
      g.style("pointer-events", "none").selectAll(".resize").style("display", null);                                   // 7629
      d3.select("body").style("cursor", eventTarget.style("cursor"));                                                  // 7630
      event_({                                                                                                         // 7631
        type: "brushstart"                                                                                             // 7632
      });                                                                                                              // 7633
      brushmove();                                                                                                     // 7634
      d3_eventCancel();                                                                                                // 7635
      function mouse() {                                                                                               // 7636
        var touches = d3.event.changedTouches;                                                                         // 7637
        return touches ? d3.touches(target, touches)[0] : d3.mouse(target);                                            // 7638
      }                                                                                                                // 7639
      function keydown() {                                                                                             // 7640
        if (d3.event.keyCode == 32) {                                                                                  // 7641
          if (!dragging) {                                                                                             // 7642
            center = null;                                                                                             // 7643
            origin[0] -= extent[1][0];                                                                                 // 7644
            origin[1] -= extent[1][1];                                                                                 // 7645
            dragging = 2;                                                                                              // 7646
          }                                                                                                            // 7647
          d3_eventCancel();                                                                                            // 7648
        }                                                                                                              // 7649
      }                                                                                                                // 7650
      function keyup() {                                                                                               // 7651
        if (d3.event.keyCode == 32 && dragging == 2) {                                                                 // 7652
          origin[0] += extent[1][0];                                                                                   // 7653
          origin[1] += extent[1][1];                                                                                   // 7654
          dragging = 0;                                                                                                // 7655
          d3_eventCancel();                                                                                            // 7656
        }                                                                                                              // 7657
      }                                                                                                                // 7658
      function brushmove() {                                                                                           // 7659
        var point = mouse(), moved = false;                                                                            // 7660
        if (offset) {                                                                                                  // 7661
          point[0] += offset[0];                                                                                       // 7662
          point[1] += offset[1];                                                                                       // 7663
        }                                                                                                              // 7664
        if (!dragging) {                                                                                               // 7665
          if (d3.event.altKey) {                                                                                       // 7666
            if (!center) center = [ (extent[0][0] + extent[1][0]) / 2, (extent[0][1] + extent[1][1]) / 2 ];            // 7667
            origin[0] = extent[+(point[0] < center[0])][0];                                                            // 7668
            origin[1] = extent[+(point[1] < center[1])][1];                                                            // 7669
          } else center = null;                                                                                        // 7670
        }                                                                                                              // 7671
        if (resizingX && move1(point, x, 0)) {                                                                         // 7672
          redrawX(g);                                                                                                  // 7673
          moved = true;                                                                                                // 7674
        }                                                                                                              // 7675
        if (resizingY && move1(point, y, 1)) {                                                                         // 7676
          redrawY(g);                                                                                                  // 7677
          moved = true;                                                                                                // 7678
        }                                                                                                              // 7679
        if (moved) {                                                                                                   // 7680
          redraw(g);                                                                                                   // 7681
          event_({                                                                                                     // 7682
            type: "brush",                                                                                             // 7683
            mode: dragging ? "move" : "resize"                                                                         // 7684
          });                                                                                                          // 7685
        }                                                                                                              // 7686
      }                                                                                                                // 7687
      function move1(point, scale, i) {                                                                                // 7688
        var range = d3_scaleRange(scale), r0 = range[0], r1 = range[1], position = origin[i], size = extent[1][i] - extent[0][i], min, max;
        if (dragging) {                                                                                                // 7690
          r0 -= position;                                                                                              // 7691
          r1 -= size + position;                                                                                       // 7692
        }                                                                                                              // 7693
        min = Math.max(r0, Math.min(r1, point[i]));                                                                    // 7694
        if (dragging) {                                                                                                // 7695
          max = (min += position) + size;                                                                              // 7696
        } else {                                                                                                       // 7697
          if (center) position = Math.max(r0, Math.min(r1, 2 * center[i] - min));                                      // 7698
          if (position < min) {                                                                                        // 7699
            max = min;                                                                                                 // 7700
            min = position;                                                                                            // 7701
          } else {                                                                                                     // 7702
            max = position;                                                                                            // 7703
          }                                                                                                            // 7704
        }                                                                                                              // 7705
        if (extent[0][i] !== min || extent[1][i] !== max) {                                                            // 7706
          extentDomain = null;                                                                                         // 7707
          extent[0][i] = min;                                                                                          // 7708
          extent[1][i] = max;                                                                                          // 7709
          return true;                                                                                                 // 7710
        }                                                                                                              // 7711
      }                                                                                                                // 7712
      function brushend() {                                                                                            // 7713
        brushmove();                                                                                                   // 7714
        g.style("pointer-events", "all").selectAll(".resize").style("display", brush.empty() ? "none" : null);         // 7715
        d3.select("body").style("cursor", null);                                                                       // 7716
        w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
        event_({                                                                                                       // 7718
          type: "brushend"                                                                                             // 7719
        });                                                                                                            // 7720
        d3_eventCancel();                                                                                              // 7721
      }                                                                                                                // 7722
    }                                                                                                                  // 7723
    brush.x = function(z) {                                                                                            // 7724
      if (!arguments.length) return x;                                                                                 // 7725
      x = z;                                                                                                           // 7726
      resizes = d3_svg_brushResizes[!x << 1 | !y];                                                                     // 7727
      return brush;                                                                                                    // 7728
    };                                                                                                                 // 7729
    brush.y = function(z) {                                                                                            // 7730
      if (!arguments.length) return y;                                                                                 // 7731
      y = z;                                                                                                           // 7732
      resizes = d3_svg_brushResizes[!x << 1 | !y];                                                                     // 7733
      return brush;                                                                                                    // 7734
    };                                                                                                                 // 7735
    brush.extent = function(z) {                                                                                       // 7736
      var x0, x1, y0, y1, t;                                                                                           // 7737
      if (!arguments.length) {                                                                                         // 7738
        z = extentDomain || extent;                                                                                    // 7739
        if (x) {                                                                                                       // 7740
          x0 = z[0][0], x1 = z[1][0];                                                                                  // 7741
          if (!extentDomain) {                                                                                         // 7742
            x0 = extent[0][0], x1 = extent[1][0];                                                                      // 7743
            if (x.invert) x0 = x.invert(x0), x1 = x.invert(x1);                                                        // 7744
            if (x1 < x0) t = x0, x0 = x1, x1 = t;                                                                      // 7745
          }                                                                                                            // 7746
        }                                                                                                              // 7747
        if (y) {                                                                                                       // 7748
          y0 = z[0][1], y1 = z[1][1];                                                                                  // 7749
          if (!extentDomain) {                                                                                         // 7750
            y0 = extent[0][1], y1 = extent[1][1];                                                                      // 7751
            if (y.invert) y0 = y.invert(y0), y1 = y.invert(y1);                                                        // 7752
            if (y1 < y0) t = y0, y0 = y1, y1 = t;                                                                      // 7753
          }                                                                                                            // 7754
        }                                                                                                              // 7755
        return x && y ? [ [ x0, y0 ], [ x1, y1 ] ] : x ? [ x0, x1 ] : y && [ y0, y1 ];                                 // 7756
      }                                                                                                                // 7757
      extentDomain = [ [ 0, 0 ], [ 0, 0 ] ];                                                                           // 7758
      if (x) {                                                                                                         // 7759
        x0 = z[0], x1 = z[1];                                                                                          // 7760
        if (y) x0 = x0[0], x1 = x1[0];                                                                                 // 7761
        extentDomain[0][0] = x0, extentDomain[1][0] = x1;                                                              // 7762
        if (x.invert) x0 = x(x0), x1 = x(x1);                                                                          // 7763
        if (x1 < x0) t = x0, x0 = x1, x1 = t;                                                                          // 7764
        extent[0][0] = x0 | 0, extent[1][0] = x1 | 0;                                                                  // 7765
      }                                                                                                                // 7766
      if (y) {                                                                                                         // 7767
        y0 = z[0], y1 = z[1];                                                                                          // 7768
        if (x) y0 = y0[1], y1 = y1[1];                                                                                 // 7769
        extentDomain[0][1] = y0, extentDomain[1][1] = y1;                                                              // 7770
        if (y.invert) y0 = y(y0), y1 = y(y1);                                                                          // 7771
        if (y1 < y0) t = y0, y0 = y1, y1 = t;                                                                          // 7772
        extent[0][1] = y0 | 0, extent[1][1] = y1 | 0;                                                                  // 7773
      }                                                                                                                // 7774
      return brush;                                                                                                    // 7775
    };                                                                                                                 // 7776
    brush.clear = function() {                                                                                         // 7777
      extentDomain = null;                                                                                             // 7778
      extent[0][0] = extent[0][1] = extent[1][0] = extent[1][1] = 0;                                                   // 7779
      return brush;                                                                                                    // 7780
    };                                                                                                                 // 7781
    brush.empty = function() {                                                                                         // 7782
      return x && extent[0][0] === extent[1][0] || y && extent[0][1] === extent[1][1];                                 // 7783
    };                                                                                                                 // 7784
    return d3.rebind(brush, event, "on");                                                                              // 7785
  };                                                                                                                   // 7786
  var d3_svg_brushCursor = {                                                                                           // 7787
    n: "ns-resize",                                                                                                    // 7788
    e: "ew-resize",                                                                                                    // 7789
    s: "ns-resize",                                                                                                    // 7790
    w: "ew-resize",                                                                                                    // 7791
    nw: "nwse-resize",                                                                                                 // 7792
    ne: "nesw-resize",                                                                                                 // 7793
    se: "nwse-resize",                                                                                                 // 7794
    sw: "nesw-resize"                                                                                                  // 7795
  };                                                                                                                   // 7796
  var d3_svg_brushResizes = [ [ "n", "e", "s", "w", "nw", "ne", "se", "sw" ], [ "e", "w" ], [ "n", "s" ], [] ];        // 7797
  d3.time = {};                                                                                                        // 7798
  var d3_time = Date, d3_time_daySymbols = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];
  function d3_time_utc() {                                                                                             // 7800
    this._ = new Date(arguments.length > 1 ? Date.UTC.apply(this, arguments) : arguments[0]);                          // 7801
  }                                                                                                                    // 7802
  d3_time_utc.prototype = {                                                                                            // 7803
    getDate: function() {                                                                                              // 7804
      return this._.getUTCDate();                                                                                      // 7805
    },                                                                                                                 // 7806
    getDay: function() {                                                                                               // 7807
      return this._.getUTCDay();                                                                                       // 7808
    },                                                                                                                 // 7809
    getFullYear: function() {                                                                                          // 7810
      return this._.getUTCFullYear();                                                                                  // 7811
    },                                                                                                                 // 7812
    getHours: function() {                                                                                             // 7813
      return this._.getUTCHours();                                                                                     // 7814
    },                                             