(function () {

///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
// packages/blaze-tools/token_tests.js                                           //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
                                                                                 //
Tinytest.add("blaze-tools - token parsers", function (test) {                    // 1
                                                                                 // 2
  var run = function (func, input, expected) {                                   // 3
    var scanner = new HTMLTools.Scanner('z' + input);                            // 4
    // make sure the parse function respects `scanner.pos`                       // 5
    scanner.pos = 1;                                                             // 6
    var result = func(scanner);                                                  // 7
    if (expected === null) {                                                     // 8
      test.equal(scanner.pos, 1);                                                // 9
      test.equal(result, null);                                                  // 10
    } else {                                                                     // 11
      test.isTrue(scanner.isEOF());                                              // 12
      test.equal(result, expected);                                              // 13
    }                                                                            // 14
  };                                                                             // 15
                                                                                 // 16
  var runValue = function (func, input, expectedValue) {                         // 17
    var expected;                                                                // 18
    if (expectedValue === null)                                                  // 19
      expected = null;                                                           // 20
    else                                                                         // 21
      expected = { text: input, value: expectedValue };                          // 22
    run(func, input, expected);                                                  // 23
  };                                                                             // 24
                                                                                 // 25
  var parseNumber = BlazeTools.parseNumber;                                      // 26
  var parseIdentifierName = BlazeTools.parseIdentifierName;                      // 27
  var parseStringLiteral = BlazeTools.parseStringLiteral;                        // 28
                                                                                 // 29
  runValue(parseNumber, "0", 0);                                                 // 30
  runValue(parseNumber, "-0", 0);                                                // 31
  runValue(parseNumber, "-", null);                                              // 32
  runValue(parseNumber, ".a", null);                                             // 33
  runValue(parseNumber, ".1", 0.1);                                              // 34
  runValue(parseNumber, "1.", 1);                                                // 35
  runValue(parseNumber, "1.1", 1.1);                                             // 36
  runValue(parseNumber, "0x", null);                                             // 37
  runValue(parseNumber, "0xa", 10);                                              // 38
  runValue(parseNumber, "-0xa", -10);                                            // 39
  runValue(parseNumber, "1e+1", 10);                                             // 40
                                                                                 // 41
  run(parseIdentifierName, "a", "a");                                            // 42
  run(parseIdentifierName, "true", "true");                                      // 43
  run(parseIdentifierName, "null", "null");                                      // 44
  run(parseIdentifierName, "if", "if");                                          // 45
  run(parseIdentifierName, "1", null);                                           // 46
  run(parseIdentifierName, "1a", null);                                          // 47
  run(parseIdentifierName, "+a", null);                                          // 48
  run(parseIdentifierName, "a1", "a1");                                          // 49
  run(parseIdentifierName, "a1a", "a1a");                                        // 50
  run(parseIdentifierName, "_a8f_f8d88_", "_a8f_f8d88_");                        // 51
                                                                                 // 52
  runValue(parseStringLiteral, '"a"', 'a');                                      // 53
  runValue(parseStringLiteral, '"\'"', "'");                                     // 54
  runValue(parseStringLiteral, '\'"\'', '"');                                    // 55
  runValue(parseStringLiteral, '"a\\\nb"', 'ab'); // line continuation           // 56
  runValue(parseStringLiteral, '"a\u0062c"', 'abc');                             // 57
  // Note: IE 8 doesn't correctly parse '\v' in JavaScript.                      // 58
  runValue(parseStringLiteral, '"\\0\\b\\f\\n\\r\\t\\v"', '\0\b\f\n\r\t\u000b'); // 59
  runValue(parseStringLiteral, '"\\x41"', 'A');                                  // 60
  runValue(parseStringLiteral, '"\\\\"', '\\');                                  // 61
  runValue(parseStringLiteral, '"\\\""', '\"');                                  // 62
  runValue(parseStringLiteral, '"\\\'"', '\'');                                  // 63
  runValue(parseStringLiteral, "'\\\\'", '\\');                                  // 64
  runValue(parseStringLiteral, "'\\\"'", '\"');                                  // 65
  runValue(parseStringLiteral, "'\\\''", '\'');                                  // 66
});                                                                              // 67
                                                                                 // 68
///////////////////////////////////////////////////////////////////////////////////

}).call(this);
