(function () {

////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                        //
// packages/accounts-password/password_tests.js                                           //
//                                                                                        //
////////////////////////////////////////////////////////////////////////////////////////////
                                                                                          //
Accounts._noConnectionCloseDelayForTest = true;                                           // 1
                                                                                          // 2
if (Meteor.isServer) {                                                                    // 3
  Meteor.methods({                                                                        // 4
    getUserId: function () {                                                              // 5
      return this.userId;                                                                 // 6
    }                                                                                     // 7
  });                                                                                     // 8
}                                                                                         // 9
                                                                                          // 10
if (Meteor.isClient) (function () {                                                       // 11
                                                                                          // 12
  // XXX note, only one test can do login/logout things at once! for                      // 13
  // now, that is this test.                                                              // 14
                                                                                          // 15
  Accounts._isolateLoginTokenForTest();                                                   // 16
                                                                                          // 17
  var logoutStep = function (test, expect) {                                              // 18
    Meteor.logout(expect(function (error) {                                               // 19
      test.equal(error, undefined);                                                       // 20
      test.equal(Meteor.user(), null);                                                    // 21
    }));                                                                                  // 22
  };                                                                                      // 23
  var loggedInAs = function (someUsername, test, expect) {                                // 24
    return expect(function (error) {                                                      // 25
      test.equal(error, undefined);                                                       // 26
      test.equal(Meteor.user().username, someUsername);                                   // 27
    });                                                                                   // 28
  };                                                                                      // 29
  var waitForLoggedOutStep = function (test, expect) {                                    // 30
    pollUntil(expect, function () {                                                       // 31
      return Meteor.userId() === null;                                                    // 32
    }, 10 * 1000, 100);                                                                   // 33
  };                                                                                      // 34
  var invalidateLoginsStep = function (test, expect) {                                    // 35
    Meteor.call("testInvalidateLogins", 'fail', expect(function (error) {                 // 36
      test.isFalse(error);                                                                // 37
    }));                                                                                  // 38
  };                                                                                      // 39
  var hideActualLoginErrorStep = function (test, expect) {                                // 40
    Meteor.call("testInvalidateLogins", 'hide', expect(function (error) {                 // 41
      test.isFalse(error);                                                                // 42
    }));                                                                                  // 43
  };                                                                                      // 44
  var validateLoginsStep = function (test, expect) {                                      // 45
    Meteor.call("testInvalidateLogins", false, expect(function (error) {                  // 46
      test.isFalse(error);                                                                // 47
    }));                                                                                  // 48
  };                                                                                      // 49
                                                                                          // 50
  testAsyncMulti("passwords - basic login with password", [                               // 51
    function (test, expect) {                                                             // 52
      // setup                                                                            // 53
      this.username = Random.id();                                                        // 54
      this.email = Random.id() + '-intercept@example.com';                                // 55
      this.password = 'password';                                                         // 56
                                                                                          // 57
      Accounts.createUser(                                                                // 58
        {username: this.username, email: this.email, password: this.password},            // 59
        loggedInAs(this.username, test, expect));                                         // 60
    },                                                                                    // 61
    function (test, expect) {                                                             // 62
      test.notEqual(Meteor.userId(), null);                                               // 63
    },                                                                                    // 64
    logoutStep,                                                                           // 65
    function (test, expect) {                                                             // 66
      Meteor.loginWithPassword(this.username, this.password,                              // 67
                               loggedInAs(this.username, test, expect));                  // 68
    },                                                                                    // 69
    logoutStep,                                                                           // 70
    // This next step tests reactive contexts which are reactive on                       // 71
    // Meteor.user().                                                                     // 72
    function (test, expect) {                                                             // 73
      // Set up a reactive context that only refreshes when Meteor.user() is              // 74
      // invalidated.                                                                     // 75
      var loaded = false;                                                                 // 76
      var handle = Deps.autorun(function () {                                             // 77
        if (Meteor.user() && Meteor.user().emails)                                        // 78
          loaded = true;                                                                  // 79
      });                                                                                 // 80
      // At the beginning, we're not logged in.                                           // 81
      test.isFalse(loaded);                                                               // 82
      Meteor.loginWithPassword(this.username, this.password, expect(function (error) {    // 83
        test.equal(error, undefined);                                                     // 84
        test.notEqual(Meteor.userId(), null);                                             // 85
        // By the time of the login callback, the user should be loaded.                  // 86
        test.isTrue(Meteor.user().emails);                                                // 87
        // Flushing should get us the rerun as well.                                      // 88
        Deps.flush();                                                                     // 89
        test.isTrue(loaded);                                                              // 90
        handle.stop();                                                                    // 91
      }));                                                                                // 92
    },                                                                                    // 93
    logoutStep,                                                                           // 94
    function (test, expect) {                                                             // 95
      Meteor.loginWithPassword({username: this.username}, this.password,                  // 96
                               loggedInAs(this.username, test, expect));                  // 97
    },                                                                                    // 98
    logoutStep,                                                                           // 99
    function (test, expect) {                                                             // 100
      Meteor.loginWithPassword(this.email, this.password,                                 // 101
                               loggedInAs(this.username, test, expect));                  // 102
    },                                                                                    // 103
    logoutStep,                                                                           // 104
    function (test, expect) {                                                             // 105
      Meteor.loginWithPassword({email: this.email}, this.password,                        // 106
                               loggedInAs(this.username, test, expect));                  // 107
    },                                                                                    // 108
    logoutStep                                                                            // 109
  ]);                                                                                     // 110
                                                                                          // 111
                                                                                          // 112
  testAsyncMulti("passwords - plain text passwords", [                                    // 113
    function (test, expect) {                                                             // 114
      // setup                                                                            // 115
      this.username = Random.id();                                                        // 116
      this.email = Random.id() + '-intercept@example.com';                                // 117
      this.password = 'password';                                                         // 118
                                                                                          // 119
      // create user with raw password (no API, need to invoke callLoginMethod            // 120
      // directly)                                                                        // 121
      Accounts.callLoginMethod({                                                          // 122
        methodName: 'createUser',                                                         // 123
        methodArguments: [{username: this.username, password: this.password}],            // 124
        userCallback: loggedInAs(this.username, test, expect)                             // 125
      });                                                                                 // 126
    },                                                                                    // 127
    logoutStep,                                                                           // 128
    // check can login normally with this password.                                       // 129
    function(test, expect) {                                                              // 130
      Meteor.loginWithPassword({username: this.username}, this.password,                  // 131
                               loggedInAs(this.username, test, expect));                  // 132
    },                                                                                    // 133
    logoutStep,                                                                           // 134
    // plain text password. no API for this, have to invoke callLoginMethod               // 135
    // directly.                                                                          // 136
    function (test, expect) {                                                             // 137
      Accounts.callLoginMethod({                                                          // 138
        // wrong password                                                                 // 139
        methodArguments: [{user: {username: this.username}, password: 'wrong'}],          // 140
        userCallback: expect(function (error) {                                           // 141
          test.isTrue(error);                                                             // 142
          test.isFalse(Meteor.user());                                                    // 143
        })});                                                                             // 144
    },                                                                                    // 145
    function (test, expect) {                                                             // 146
      Accounts.callLoginMethod({                                                          // 147
        // right password                                                                 // 148
        methodArguments: [{user: {username: this.username},                               // 149
                           password: this.password}],                                     // 150
        userCallback: loggedInAs(this.username, test, expect)                             // 151
      });                                                                                 // 152
    },                                                                                    // 153
    logoutStep                                                                            // 154
  ]);                                                                                     // 155
                                                                                          // 156
                                                                                          // 157
  testAsyncMulti("passwords - changing passwords", [                                      // 158
    function (test, expect) {                                                             // 159
      // setup                                                                            // 160
      this.username = Random.id();                                                        // 161
      this.email = Random.id() + '-intercept@example.com';                                // 162
      this.password = 'password';                                                         // 163
      this.password2 = 'password2';                                                       // 164
                                                                                          // 165
      Accounts.createUser(                                                                // 166
        {username: this.username, email: this.email, password: this.password},            // 167
        loggedInAs(this.username, test, expect));                                         // 168
    },                                                                                    // 169
    // change password with bad old password. we stay logged in.                          // 170
    function (test, expect) {                                                             // 171
      var self = this;                                                                    // 172
      Accounts.changePassword('wrong', 'doesntmatter', expect(function (error) {          // 173
        test.isTrue(error);                                                               // 174
        test.equal(Meteor.user().username, self.username);                                // 175
      }));                                                                                // 176
    },                                                                                    // 177
    // change password with good old password.                                            // 178
    function (test, expect) {                                                             // 179
      Accounts.changePassword(this.password, this.password2,                              // 180
                              loggedInAs(this.username, test, expect));                   // 181
    },                                                                                    // 182
    logoutStep,                                                                           // 183
    // old password, failed login                                                         // 184
    function (test, expect) {                                                             // 185
      Meteor.loginWithPassword(this.email, this.password, expect(function (error) {       // 186
        test.isTrue(error);                                                               // 187
        test.isFalse(Meteor.user());                                                      // 188
      }));                                                                                // 189
    },                                                                                    // 190
    // new password, success                                                              // 191
    function (test, expect) {                                                             // 192
      Meteor.loginWithPassword(this.email, this.password2,                                // 193
                               loggedInAs(this.username, test, expect));                  // 194
    },                                                                                    // 195
    logoutStep                                                                            // 196
  ]);                                                                                     // 197
                                                                                          // 198
  testAsyncMulti("passwords - changing password logs out other clients", [                // 199
    function (test, expect) {                                                             // 200
      this.username = Random.id();                                                        // 201
      this.email = Random.id() + '-intercept@example.com';                                // 202
      this.password = 'password';                                                         // 203
      this.password2 = 'password2';                                                       // 204
      Accounts.createUser(                                                                // 205
        { username: this.username, email: this.email, password: this.password },          // 206
        loggedInAs(this.username, test, expect));                                         // 207
    },                                                                                    // 208
    // Log in a second connection as this user.                                           // 209
    function (test, expect) {                                                             // 210
      var self = this;                                                                    // 211
                                                                                          // 212
      self.secondConn = DDP.connect(Meteor.absoluteUrl());                                // 213
      self.secondConn.call('login',                                                       // 214
                { user: { username: self.username }, password: self.password },           // 215
                expect(function (err, result) {                                           // 216
                  test.isFalse(err);                                                      // 217
                  self.secondConn.setUserId(result.id);                                   // 218
                  test.isTrue(self.secondConn.userId());                                  // 219
                                                                                          // 220
                  self.secondConn.onReconnect = function () {                             // 221
                    self.secondConn.apply(                                                // 222
                      'login',                                                            // 223
                      [{ resume: result.token }],                                         // 224
                      { wait: true },                                                     // 225
                      function (err, result) {                                            // 226
                        self.secondConn.setUserId(result && result.id || null);           // 227
                      }                                                                   // 228
                    );                                                                    // 229
                  };                                                                      // 230
                }));                                                                      // 231
    },                                                                                    // 232
    function (test, expect) {                                                             // 233
      var self = this;                                                                    // 234
      Accounts.changePassword(self.password, self.password2, expect(function (err) {      // 235
        test.isFalse(err);                                                                // 236
      }));                                                                                // 237
    },                                                                                    // 238
    // Now that we've changed the password, wait until the second                         // 239
    // connection gets logged out.                                                        // 240
    function (test, expect) {                                                             // 241
      var self = this;                                                                    // 242
      pollUntil(expect, function () {                                                     // 243
        return self.secondConn.userId() === null;                                         // 244
      }, 10 * 1000, 100);                                                                 // 245
    }                                                                                     // 246
  ]);                                                                                     // 247
                                                                                          // 248
                                                                                          // 249
  testAsyncMulti("passwords - new user hooks", [                                          // 250
    function (test, expect) {                                                             // 251
      // setup                                                                            // 252
      this.username = Random.id();                                                        // 253
      this.email = Random.id() + '-intercept@example.com';                                // 254
      this.password = 'password';                                                         // 255
    },                                                                                    // 256
    // test Accounts.validateNewUser                                                      // 257
    function(test, expect) {                                                              // 258
      Accounts.createUser(                                                                // 259
        {username: this.username, password: this.password,                                // 260
         // should fail the new user validators                                           // 261
         profile: {invalid: true}},                                                       // 262
        expect(function (error) {                                                         // 263
          test.equal(error.error, 403);                                                   // 264
          test.equal(error.reason, "User validation failed");                             // 265
        }));                                                                              // 266
    },                                                                                    // 267
    logoutStep,                                                                           // 268
    function(test, expect) {                                                              // 269
      Accounts.createUser(                                                                // 270
        {username: this.username, password: this.password,                                // 271
         // should fail the new user validator with a special                             // 272
         // exception                                                                     // 273
         profile: {invalidAndThrowException: true}},                                      // 274
        expect(function (error) {                                                         // 275
          test.equal(                                                                     // 276
            error.reason,                                                                 // 277
            "An exception thrown within Accounts.validateNewUser");                       // 278
        }));                                                                              // 279
    },                                                                                    // 280
    // test Accounts.onCreateUser                                                         // 281
    function(test, expect) {                                                              // 282
      Accounts.createUser(                                                                // 283
        {username: this.username, password: this.password,                                // 284
         testOnCreateUserHook: true},                                                     // 285
        loggedInAs(this.username, test, expect));                                         // 286
    },                                                                                    // 287
    function(test, expect) {                                                              // 288
      test.equal(Meteor.user().profile.touchedByOnCreateUser, true);                      // 289
    },                                                                                    // 290
    logoutStep                                                                            // 291
  ]);                                                                                     // 292
                                                                                          // 293
                                                                                          // 294
  testAsyncMulti("passwords - Meteor.user()", [                                           // 295
    function (test, expect) {                                                             // 296
      // setup                                                                            // 297
      this.username = Random.id();                                                        // 298
      this.password = 'password';                                                         // 299
                                                                                          // 300
      Accounts.createUser(                                                                // 301
        {username: this.username, password: this.password,                                // 302
         testOnCreateUserHook: true},                                                     // 303
        loggedInAs(this.username, test, expect));                                         // 304
    },                                                                                    // 305
    // test Meteor.user(). This test properly belongs in                                  // 306
    // accounts-base/accounts_tests.js, but this is where the tests that                  // 307
    // actually log in are.                                                               // 308
    function(test, expect) {                                                              // 309
      var self = this;                                                                    // 310
      var clientUser = Meteor.user();                                                     // 311
      Accounts.connection.call('testMeteorUser', expect(function (err, result) {          // 312
        test.equal(result._id, clientUser._id);                                           // 313
        test.equal(result.username, clientUser.username);                                 // 314
        test.equal(result.username, self.username);                                       // 315
        test.equal(result.profile.touchedByOnCreateUser, true);                           // 316
        test.equal(err, undefined);                                                       // 317
      }));                                                                                // 318
    },                                                                                    // 319
    function(test, expect) {                                                              // 320
      // Test that even with no published fields, we still have a document.               // 321
      Accounts.connection.call('clearUsernameAndProfile', expect(function() {             // 322
        test.isTrue(Meteor.userId());                                                     // 323
        var user = Meteor.user();                                                         // 324
        test.equal(user, {_id: Meteor.userId()});                                         // 325
      }));                                                                                // 326
    },                                                                                    // 327
    logoutStep,                                                                           // 328
    function(test, expect) {                                                              // 329
      var clientUser = Meteor.user();                                                     // 330
      test.equal(clientUser, null);                                                       // 331
      test.equal(Meteor.userId(), null);                                                  // 332
      Accounts.connection.call('testMeteorUser', expect(function (err, result) {          // 333
        test.equal(err, undefined);                                                       // 334
        test.equal(result, null);                                                         // 335
      }));                                                                                // 336
    }                                                                                     // 337
  ]);                                                                                     // 338
                                                                                          // 339
  testAsyncMulti("passwords - allow rules", [                                             // 340
    // create a second user to have an id for in a later test                             // 341
    function (test, expect) {                                                             // 342
      this.otherUsername = Random.id();                                                   // 343
      Accounts.createUser(                                                                // 344
        {username: this.otherUsername, password: 'dontcare',                              // 345
         testOnCreateUserHook: true},                                                     // 346
        loggedInAs(this.otherUsername, test, expect));                                    // 347
    },                                                                                    // 348
    function (test, expect) {                                                             // 349
      this.otherUserId = Meteor.userId();                                                 // 350
    },                                                                                    // 351
    function (test, expect) {                                                             // 352
      // real setup                                                                       // 353
      this.username = Random.id();                                                        // 354
      this.password = 'password';                                                         // 355
                                                                                          // 356
      Accounts.createUser(                                                                // 357
        {username: this.username, password: this.password,                                // 358
         testOnCreateUserHook: true},                                                     // 359
        loggedInAs(this.username, test, expect));                                         // 360
    },                                                                                    // 361
    // test the default Meteor.users allow rule. This test properly belongs in            // 362
    // accounts-base/accounts_tests.js, but this is where the tests that                  // 363
    // actually log in are.                                                               // 364
    function(test, expect) {                                                              // 365
      this.userId = Meteor.userId();                                                      // 366
      test.notEqual(this.userId, null);                                                   // 367
      test.notEqual(this.userId, this.otherUserId);                                       // 368
      // Can't update fields other than profile.                                          // 369
      Meteor.users.update(                                                                // 370
        this.userId, {$set: {disallowed: true, 'profile.updated': 42}},                   // 371
        expect(function (err) {                                                           // 372
          test.isTrue(err);                                                               // 373
          test.equal(err.error, 403);                                                     // 374
          test.isFalse(_.has(Meteor.user(), 'disallowed'));                               // 375
          test.isFalse(_.has(Meteor.user().profile, 'updated'));                          // 376
        }));                                                                              // 377
    },                                                                                    // 378
    function(test, expect) {                                                              // 379
      // Can't update another user.                                                       // 380
      Meteor.users.update(                                                                // 381
        this.otherUserId, {$set: {'profile.updated': 42}},                                // 382
        expect(function (err) {                                                           // 383
          test.isTrue(err);                                                               // 384
          test.equal(err.error, 403);                                                     // 385
        }));                                                                              // 386
    },                                                                                    // 387
    function(test, expect) {                                                              // 388
      // Can't update using a non-ID selector. (This one is thrown client-side.)          // 389
      test.throws(function () {                                                           // 390
        Meteor.users.update(                                                              // 391
          {username: this.username}, {$set: {'profile.updated': 42}});                    // 392
      });                                                                                 // 393
      test.isFalse(_.has(Meteor.user().profile, 'updated'));                              // 394
    },                                                                                    // 395
    function(test, expect) {                                                              // 396
      // Can update own profile using ID.                                                 // 397
      Meteor.users.update(                                                                // 398
        this.userId, {$set: {'profile.updated': 42}},                                     // 399
        expect(function (err) {                                                           // 400
          test.isFalse(err);                                                              // 401
          test.equal(42, Meteor.user().profile.updated);                                  // 402
        }));                                                                              // 403
    },                                                                                    // 404
    logoutStep                                                                            // 405
  ]);                                                                                     // 406
                                                                                          // 407
                                                                                          // 408
  testAsyncMulti("passwords - tokens", [                                                  // 409
    function (test, expect) {                                                             // 410
      // setup                                                                            // 411
      this.username = Random.id();                                                        // 412
      this.password = 'password';                                                         // 413
                                                                                          // 414
      Accounts.createUser(                                                                // 415
        {username: this.username, password: this.password},                               // 416
        loggedInAs(this.username, test, expect));                                         // 417
    },                                                                                    // 418
                                                                                          // 419
    function (test, expect) {                                                             // 420
      // we can't login with an invalid token                                             // 421
      var expectLoginError = expect(function (err) {                                      // 422
        test.isTrue(err);                                                                 // 423
      });                                                                                 // 424
      Meteor.loginWithToken('invalid', expectLoginError);                                 // 425
    },                                                                                    // 426
                                                                                          // 427
    function (test, expect) {                                                             // 428
      // we can login with a valid token                                                  // 429
      var expectLoginOK = expect(function (err) {                                         // 430
        test.isFalse(err);                                                                // 431
      });                                                                                 // 432
      Meteor.loginWithToken(Accounts._storedLoginToken(), expectLoginOK);                 // 433
    },                                                                                    // 434
                                                                                          // 435
    function (test, expect) {                                                             // 436
      // test logging out invalidates our token                                           // 437
      var expectLoginError = expect(function (err) {                                      // 438
        test.isTrue(err);                                                                 // 439
      });                                                                                 // 440
      var token = Accounts._storedLoginToken();                                           // 441
      test.isTrue(token);                                                                 // 442
      Meteor.logout(function () {                                                         // 443
        Meteor.loginWithToken(token, expectLoginError);                                   // 444
      });                                                                                 // 445
    },                                                                                    // 446
                                                                                          // 447
    function (test, expect) {                                                             // 448
      var self = this;                                                                    // 449
      // Test that login tokens get expired. We should get logged out when a              // 450
      // token expires, and not be able to log in again with the same token.              // 451
      var expectNoError = expect(function (err) {                                         // 452
        test.isFalse(err);                                                                // 453
      });                                                                                 // 454
                                                                                          // 455
      Meteor.loginWithPassword(this.username, this.password, function (error) {           // 456
        self.token = Accounts._storedLoginToken();                                        // 457
        test.isTrue(self.token);                                                          // 458
        expectNoError(error);                                                             // 459
        Accounts.connection.call("expireTokens");                                         // 460
      });                                                                                 // 461
    },                                                                                    // 462
    waitForLoggedOutStep,                                                                 // 463
    function (test, expect) {                                                             // 464
      var token = Accounts._storedLoginToken();                                           // 465
      test.isFalse(token);                                                                // 466
    },                                                                                    // 467
    function (test, expect) {                                                             // 468
      // Test that once expireTokens is finished, we can't login again with our           // 469
      // previous token.                                                                  // 470
      Meteor.loginWithToken(this.token, expect(function (err, result) {                   // 471
        test.isTrue(err);                                                                 // 472
        test.equal(Meteor.userId(), null);                                                // 473
      }));                                                                                // 474
    },                                                                                    // 475
    logoutStep,                                                                           // 476
    function (test, expect) {                                                             // 477
      var self = this;                                                                    // 478
      // Test that Meteor.logoutOtherClients logs out a second                            // 479
      // authentcated connection while leaving Accounts.connection                        // 480
      // logged in.                                                                       // 481
      var secondConn = DDP.connect(Meteor.absoluteUrl());                                 // 482
      var token;                                                                          // 483
                                                                                          // 484
      var expectSecondConnLoggedOut = expect(function (err, result) {                     // 485
        test.isTrue(err);                                                                 // 486
      });                                                                                 // 487
                                                                                          // 488
      var expectAccountsConnLoggedIn = expect(function (err, result) {                    // 489
        test.isFalse(err);                                                                // 490
      });                                                                                 // 491
                                                                                          // 492
      var expectSecondConnLoggedIn = expect(function (err, result) {                      // 493
        test.equal(result.token, token);                                                  // 494
        test.isFalse(err);                                                                // 495
        Meteor.logoutOtherClients(function (err) {                                        // 496
          test.isFalse(err);                                                              // 497
          secondConn.call('login', { resume: token },                                     // 498
                          expectSecondConnLoggedOut);                                     // 499
          Accounts.connection.call('login', {                                             // 500
            resume: Accounts._storedLoginToken()                                          // 501
          }, expectAccountsConnLoggedIn);                                                 // 502
        });                                                                               // 503
      });                                                                                 // 504
                                                                                          // 505
      Meteor.loginWithPassword(                                                           // 506
        self.username,                                                                    // 507
        self.password,                                                                    // 508
        expect(function (err) {                                                           // 509
          test.isFalse(err);                                                              // 510
          token = Accounts._storedLoginToken();                                           // 511
          test.isTrue(token);                                                             // 512
          secondConn.call('login', { resume: token },                                     // 513
                          expectSecondConnLoggedIn);                                      // 514
        })                                                                                // 515
      );                                                                                  // 516
    },                                                                                    // 517
    logoutStep,                                                                           // 518
                                                                                          // 519
    // The tests below this point are for the deprecated                                  // 520
    // `logoutOtherClients` method.                                                       // 521
                                                                                          // 522
    function (test, expect) {                                                             // 523
      var self = this;                                                                    // 524
                                                                                          // 525
      // Test that Meteor.logoutOtherClients logs out a second authenticated              // 526
      // connection while leaving Accounts.connection logged in.                          // 527
      var token;                                                                          // 528
      self.secondConn = DDP.connect(Meteor.absoluteUrl());                                // 529
                                                                                          // 530
      var expectLoginError = expect(function (err) {                                      // 531
        test.isTrue(err);                                                                 // 532
      });                                                                                 // 533
      var expectValidToken = expect(function (err, result) {                              // 534
        test.isFalse(err);                                                                // 535
        test.isTrue(result);                                                              // 536
        self.tokenFromLogoutOthers = result.token;                                        // 537
      });                                                                                 // 538
      var expectSecondConnLoggedIn = expect(function (err, result) {                      // 539
        test.equal(result.token, token);                                                  // 540
        test.isFalse(err);                                                                // 541
        // This test will fail if an unrelated reconnect triggers before the              // 542
        // connection is logged out. In general our tests aren't resilient to             // 543
        // mid-test reconnects.                                                           // 544
        self.secondConn.onReconnect = function () {                                       // 545
          self.secondConn.call("login", { resume: token }, expectLoginError);             // 546
        };                                                                                // 547
        Accounts.connection.call("logoutOtherClients", expectValidToken);                 // 548
      });                                                                                 // 549
                                                                                          // 550
      Meteor.loginWithPassword(this.username, this.password, expect(function (err) {      // 551
        test.isFalse(err);                                                                // 552
        token = Accounts._storedLoginToken();                                             // 553
        self.beforeLogoutOthersToken = token;                                             // 554
        test.isTrue(token);                                                               // 555
        self.secondConn.call("login", { resume: token },                                  // 556
                             expectSecondConnLoggedIn);                                   // 557
      }));                                                                                // 558
    },                                                                                    // 559
    // Test that logoutOtherClients logged out Accounts.connection and that the           // 560
    // previous token is no longer valid.                                                 // 561
    waitForLoggedOutStep,                                                                 // 562
    function (test, expect) {                                                             // 563
      var self = this;                                                                    // 564
      var token = Accounts._storedLoginToken();                                           // 565
      test.isFalse(token);                                                                // 566
      this.secondConn.close();                                                            // 567
      Meteor.loginWithToken(                                                              // 568
        self.beforeLogoutOthersToken,                                                     // 569
        expect(function (err) {                                                           // 570
          test.isTrue(err);                                                               // 571
          test.isFalse(Meteor.userId());                                                  // 572
        })                                                                                // 573
      );                                                                                  // 574
    },                                                                                    // 575
    // Test that logoutOtherClients returned a new token that we can use to               // 576
    // log in.                                                                            // 577
    function (test, expect) {                                                             // 578
      var self = this;                                                                    // 579
      Meteor.loginWithToken(                                                              // 580
        self.tokenFromLogoutOthers,                                                       // 581
        expect(function (err) {                                                           // 582
          test.isFalse(err);                                                              // 583
          test.isTrue(Meteor.userId());                                                   // 584
        })                                                                                // 585
      );                                                                                  // 586
    },                                                                                    // 587
    logoutStep,                                                                           // 588
                                                                                          // 589
                                                                                          // 590
                                                                                          // 591
    function (test, expect) {                                                             // 592
      var self = this;                                                                    // 593
      // Test that deleting a user logs out that user's connections.                      // 594
      Meteor.loginWithPassword(this.username, this.password, expect(function (err) {      // 595
        test.isFalse(err);                                                                // 596
        Accounts.connection.call("removeUser", self.username);                            // 597
      }));                                                                                // 598
    },                                                                                    // 599
    waitForLoggedOutStep                                                                  // 600
  ]);                                                                                     // 601
                                                                                          // 602
  testAsyncMulti("passwords - validateLoginAttempt", [                                    // 603
    function (test, expect) {                                                             // 604
      this.username = Random.id();                                                        // 605
      this.password = "password";                                                         // 606
                                                                                          // 607
      Accounts.createUser(                                                                // 608
        {username: this.username, password: this.password},                               // 609
        loggedInAs(this.username, test, expect));                                         // 610
    },                                                                                    // 611
    logoutStep,                                                                           // 612
    invalidateLoginsStep,                                                                 // 613
    function (test, expect) {                                                             // 614
      Meteor.loginWithPassword(                                                           // 615
        this.username,                                                                    // 616
        this.password,                                                                    // 617
        expect(function (error) {                                                         // 618
          test.isTrue(error);                                                             // 619
          test.equal(error.reason, "Login forbidden");                                    // 620
        })                                                                                // 621
      );                                                                                  // 622
    },                                                                                    // 623
    validateLoginsStep,                                                                   // 624
    function (test, expect) {                                                             // 625
      Meteor.loginWithPassword(                                                           // 626
        "no such user",                                                                   // 627
        "some password",                                                                  // 628
        expect(function (error) {                                                         // 629
          test.isTrue(error);                                                             // 630
          test.equal(error.reason, 'User not found');                                     // 631
        })                                                                                // 632
      );                                                                                  // 633
    },                                                                                    // 634
    hideActualLoginErrorStep,                                                             // 635
    function (test, expect) {                                                             // 636
      Meteor.loginWithPassword(                                                           // 637
        "no such user",                                                                   // 638
        "some password",                                                                  // 639
        expect(function (error) {                                                         // 640
          test.isTrue(error);                                                             // 641
          test.equal(error.reason, 'hide actual error');                                  // 642
        })                                                                                // 643
      );                                                                                  // 644
    },                                                                                    // 645
    validateLoginsStep                                                                    // 646
  ]);                                                                                     // 647
                                                                                          // 648
  testAsyncMulti("passwords - onLogin hook", [                                            // 649
    function (test, expect) {                                                             // 650
      Meteor.call("testCaptureLogins", expect(function (error) {                          // 651
        test.isFalse(error);                                                              // 652
      }));                                                                                // 653
    },                                                                                    // 654
    function (test, expect) {                                                             // 655
      this.username = Random.id();                                                        // 656
      this.password = "password";                                                         // 657
                                                                                          // 658
      Accounts.createUser(                                                                // 659
        {username: this.username, password: this.password},                               // 660
        loggedInAs(this.username, test, expect));                                         // 661
    },                                                                                    // 662
    function (test, expect) {                                                             // 663
      var self = this;                                                                    // 664
      Meteor.call("testFetchCapturedLogins", expect(function (error, logins) {            // 665
        test.isFalse(error);                                                              // 666
        test.equal(logins.length, 1);                                                     // 667
        var login = logins[0];                                                            // 668
        test.isTrue(login.successful);                                                    // 669
        var attempt = login.attempt;                                                      // 670
        test.equal(attempt.type, "password");                                             // 671
        test.isTrue(attempt.allowed);                                                     // 672
        test.equal(attempt.methodName, "createUser");                                     // 673
        test.equal(attempt.methodArguments[0].username, self.username);                   // 674
      }));                                                                                // 675
    }                                                                                     // 676
  ]);                                                                                     // 677
                                                                                          // 678
  testAsyncMulti("passwords - onLoginFailed hook", [                                      // 679
    function (test, expect) {                                                             // 680
      this.username = Random.id();                                                        // 681
      this.password = "password";                                                         // 682
                                                                                          // 683
      Accounts.createUser(                                                                // 684
        {username: this.username, password: this.password},                               // 685
        loggedInAs(this.username, test, expect));                                         // 686
    },                                                                                    // 687
    logoutStep,                                                                           // 688
    function (test, expect) {                                                             // 689
      Meteor.call("testCaptureLogins", expect(function (error) {                          // 690
        test.isFalse(error);                                                              // 691
      }));                                                                                // 692
    },                                                                                    // 693
    function (test, expect) {                                                             // 694
      Meteor.loginWithPassword(this.username, "incorrect", expect(function (error) {      // 695
        test.isTrue(error);                                                               // 696
      }));                                                                                // 697
    },                                                                                    // 698
    function (test, expect) {                                                             // 699
      Meteor.call("testFetchCapturedLogins", expect(function (error, logins) {            // 700
        test.isFalse(error);                                                              // 701
        test.equal(logins.length, 1);                                                     // 702
        var login = logins[0];                                                            // 703
        test.isFalse(login.successful);                                                   // 704
        var attempt = login.attempt;                                                      // 705
        test.equal(attempt.type, "password");                                             // 706
        test.isFalse(attempt.allowed);                                                    // 707
        test.equal(attempt.error.reason, "Incorrect password");                           // 708
      }));                                                                                // 709
    },                                                                                    // 710
    function (test, expect) {                                                             // 711
      Meteor.call("testCaptureLogins", expect(function (error) {                          // 712
        test.isFalse(error);                                                              // 713
      }));                                                                                // 714
    },                                                                                    // 715
    function (test, expect) {                                                             // 716
      Meteor.loginWithPassword("no such user", "incorrect", expect(function (error) {     // 717
        test.isTrue(error);                                                               // 718
      }));                                                                                // 719
    },                                                                                    // 720
    function (test, expect) {                                                             // 721
      Meteor.call("testFetchCapturedLogins", expect(function (error, logins) {            // 722
        test.isFalse(error);                                                              // 723
        test.equal(logins.length, 1);                                                     // 724
        var login = logins[0];                                                            // 725
        test.isFalse(login.successful);                                                   // 726
        var attempt = login.attempt;                                                      // 727
        test.equal(attempt.type, "password");                                             // 728
        test.isFalse(attempt.allowed);                                                    // 729
        test.equal(attempt.error.reason, "User not found");                               // 730
      }));                                                                                // 731
    }                                                                                     // 732
  ]);                                                                                     // 733
                                                                                          // 734
  testAsyncMulti("passwords - srp to bcrypt upgrade", [                                   // 735
    logoutStep,                                                                           // 736
    // Create user with old SRP credentials in the database.                              // 737
    function (test, expect) {                                                             // 738
      var self = this;                                                                    // 739
      Meteor.call("testCreateSRPUser", expect(function (error, result) {                  // 740
        test.isFalse(error);                                                              // 741
        self.username = result;                                                           // 742
      }));                                                                                // 743
    },                                                                                    // 744
    // We are able to login with the old style credentials in the database.               // 745
    function (test, expect) {                                                             // 746
      Meteor.loginWithPassword(this.username, 'abcdef', expect(function (error) {         // 747
        test.isFalse(error);                                                              // 748
      }));                                                                                // 749
    },                                                                                    // 750
    function (test, expect) {                                                             // 751
      Meteor.call("testSRPUpgrade", this.username, expect(function (error) {              // 752
        test.isFalse(error);                                                              // 753
      }));                                                                                // 754
    },                                                                                    // 755
    logoutStep,                                                                           // 756
    // After the upgrade to bcrypt we're still able to login.                             // 757
    function (test, expect) {                                                             // 758
      Meteor.loginWithPassword(this.username, 'abcdef', expect(function (error) {         // 759
        test.isFalse(error);                                                              // 760
      }));                                                                                // 761
    },                                                                                    // 762
    logoutStep,                                                                           // 763
    function (test, expect) {                                                             // 764
      Meteor.call("removeUser", this.username, expect(function (error) {                  // 765
        test.isFalse(error);                                                              // 766
      }));                                                                                // 767
    }                                                                                     // 768
  ]);                                                                                     // 769
                                                                                          // 770
  testAsyncMulti("passwords - srp to bcrypt upgrade via password change", [               // 771
    logoutStep,                                                                           // 772
    // Create user with old SRP credentials in the database.                              // 773
    function (test, expect) {                                                             // 774
      var self = this;                                                                    // 775
      Meteor.call("testCreateSRPUser", expect(function (error, result) {                  // 776
        test.isFalse(error);                                                              // 777
        self.username = result;                                                           // 778
      }));                                                                                // 779
    },                                                                                    // 780
    // Log in with the plaintext password handler, which should NOT upgrade us to bcrypt. // 781
    function (test, expect) {                                                             // 782
      Accounts.callLoginMethod({                                                          // 783
        methodName: "login",                                                              // 784
        methodArguments: [ { user: { username: this.username }, password: "abcdef" } ],   // 785
        userCallback: expect(function (err) {                                             // 786
          test.isFalse(err);                                                              // 787
        })                                                                                // 788
      });                                                                                 // 789
    },                                                                                    // 790
    function (test, expect) {                                                             // 791
      Meteor.call("testNoSRPUpgrade", this.username, expect(function (error) {            // 792
        test.isFalse(error);                                                              // 793
      }));                                                                                // 794
    },                                                                                    // 795
    // Changing our password should upgrade us to bcrypt.                                 // 796
    function (test, expect) {                                                             // 797
      Accounts.changePassword("abcdef", "abcdefg", expect(function (error) {              // 798
        test.isFalse(error);                                                              // 799
      }));                                                                                // 800
    },                                                                                    // 801
    function (test, expect) {                                                             // 802
      Meteor.call("testSRPUpgrade", this.username, expect(function (error) {              // 803
        test.isFalse(error);                                                              // 804
      }));                                                                                // 805
    },                                                                                    // 806
    // And after the upgrade we should be able to change our password again.              // 807
    function (test, expect) {                                                             // 808
      Accounts.changePassword("abcdefg", "abcdef", expect(function (error) {              // 809
        test.isFalse(error);                                                              // 810
      }));                                                                                // 811
    },                                                                                    // 812
    logoutStep                                                                            // 813
  ]);                                                                                     // 814
}) ();                                                                                    // 815
                                                                                          // 816
                                                                                          // 817
if (Meteor.isServer) (function () {                                                       // 818
                                                                                          // 819
  Tinytest.add(                                                                           // 820
    'passwords - setup more than one onCreateUserHook',                                   // 821
    function (test) {                                                                     // 822
      test.throws(function() {                                                            // 823
        Accounts.onCreateUser(function () {});                                            // 824
      });                                                                                 // 825
    });                                                                                   // 826
                                                                                          // 827
                                                                                          // 828
  Tinytest.add(                                                                           // 829
    'passwords - createUser hooks',                                                       // 830
    function (test) {                                                                     // 831
      var username = Random.id();                                                         // 832
      test.throws(function () {                                                           // 833
        // should fail the new user validators                                            // 834
        Accounts.createUser({username: username, profile: {invalid: true}});              // 835
      });                                                                                 // 836
                                                                                          // 837
      var userId = Accounts.createUser({username: username,                               // 838
                                        testOnCreateUserHook: true});                     // 839
                                                                                          // 840
      test.isTrue(userId);                                                                // 841
      var user = Meteor.users.findOne(userId);                                            // 842
      test.equal(user.profile.touchedByOnCreateUser, true);                               // 843
    });                                                                                   // 844
                                                                                          // 845
                                                                                          // 846
  Tinytest.add(                                                                           // 847
    'passwords - setPassword',                                                            // 848
    function (test) {                                                                     // 849
      var username = Random.id();                                                         // 850
                                                                                          // 851
      var userId = Accounts.createUser({username: username});                             // 852
                                                                                          // 853
      var user = Meteor.users.findOne(userId);                                            // 854
      // no services yet.                                                                 // 855
      test.equal(user.services.password, undefined);                                      // 856
                                                                                          // 857
      // set a new password.                                                              // 858
      Accounts.setPassword(userId, 'new password');                                       // 859
      user = Meteor.users.findOne(userId);                                                // 860
      var oldSaltedHash = user.services.password.bcrypt;                                  // 861
      test.isTrue(oldSaltedHash);                                                         // 862
                                                                                          // 863
      // reset with the same password, see we get a different salted hash                 // 864
      Accounts.setPassword(userId, 'new password');                                       // 865
      user = Meteor.users.findOne(userId);                                                // 866
      var newSaltedHash = user.services.password.bcrypt;                                  // 867
      test.isTrue(newSaltedHash);                                                         // 868
      test.notEqual(oldSaltedHash, newSaltedHash);                                        // 869
                                                                                          // 870
      // cleanup                                                                          // 871
      Meteor.users.remove(userId);                                                        // 872
    });                                                                                   // 873
                                                                                          // 874
                                                                                          // 875
  // This test properly belongs in accounts-base/accounts_tests.js, but                   // 876
  // this is where the tests that actually log in are.                                    // 877
  Tinytest.add('accounts - user() out of context', function (test) {                      // 878
    // basic server context, no method.                                                   // 879
    test.throws(function () {                                                             // 880
      Meteor.user();                                                                      // 881
    });                                                                                   // 882
  });                                                                                     // 883
                                                                                          // 884
  // XXX would be nice to test Accounts.config({forbidClientAccountCreation: true})       // 885
                                                                                          // 886
  Tinytest.addAsync(                                                                      // 887
    'passwords - login token observes get cleaned up',                                    // 888
    function (test, onComplete) {                                                         // 889
      var username = Random.id();                                                         // 890
      Accounts.createUser({                                                               // 891
        username: username,                                                               // 892
        password: 'password'                                                              // 893
      });                                                                                 // 894
                                                                                          // 895
      makeTestConnection(                                                                 // 896
        test,                                                                             // 897
        function (clientConn, serverConn) {                                               // 898
          serverConn.onClose(function () {                                                // 899
            test.isFalse(Accounts._getUserObserve(serverConn.id));                        // 900
            onComplete();                                                                 // 901
          });                                                                             // 902
          var result = clientConn.call('login', {                                         // 903
            user: {username: username},                                                   // 904
            password: 'password'                                                          // 905
          });                                                                             // 906
          test.isTrue(result);                                                            // 907
          var token = Accounts._getAccountData(serverConn.id, 'loginToken');              // 908
          test.isTrue(token);                                                             // 909
                                                                                          // 910
          // We poll here, instead of just checking `_getUserObserve`                     // 911
          // once, because the login method defers the creation of the                    // 912
          // observe, and setting up the observe yields, so we could end                  // 913
          // up here before the observe has been set up.                                  // 914
          simplePoll(                                                                     // 915
            function () {                                                                 // 916
              return !! Accounts._getUserObserve(serverConn.id);                          // 917
            },                                                                            // 918
            function () {                                                                 // 919
              test.isTrue(Accounts._getUserObserve(serverConn.id));                       // 920
              clientConn.disconnect();                                                    // 921
            },                                                                            // 922
            function () {                                                                 // 923
              test.fail("timed out waiting for user observe for connection " +            // 924
                        serverConn.id);                                                   // 925
              onComplete();                                                               // 926
            }                                                                             // 927
          );                                                                              // 928
        },                                                                                // 929
        onComplete                                                                        // 930
      );                                                                                  // 931
    }                                                                                     // 932
  );                                                                                      // 933
}) ();                                                                                    // 934
                                                                                          // 935
////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function () {

////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                        //
// packages/accounts-password/email_tests.js                                              //
//                                                                                        //
////////////////////////////////////////////////////////////////////////////////////////////
                                                                                          //
// intentionally initialize later so that we can debug tests after                        // 1
// they fail without trying to recreate a user with the same email                        // 2
// address                                                                                // 3
var email1;                                                                               // 4
var email2;                                                                               // 5
var email3;                                                                               // 6
var email4;                                                                               // 7
                                                                                          // 8
var resetPasswordToken;                                                                   // 9
var verifyEmailToken;                                                                     // 10
var enrollAccountToken;                                                                   // 11
                                                                                          // 12
Accounts._isolateLoginTokenForTest();                                                     // 13
                                                                                          // 14
testAsyncMulti("accounts emails - reset password flow", [                                 // 15
  function (test, expect) {                                                               // 16
    email1 = Random.id() + "-intercept@example.com";                                      // 17
    Accounts.createUser({email: email1, password: 'foobar'},                              // 18
                        expect(function (error) {                                         // 19
                          test.equal(error, undefined);                                   // 20
                        }));                                                              // 21
  },                                                                                      // 22
  function (test, expect) {                                                               // 23
    Accounts.forgotPassword({email: email1}, expect(function (error) {                    // 24
      test.equal(error, undefined);                                                       // 25
    }));                                                                                  // 26
  },                                                                                      // 27
  function (test, expect) {                                                               // 28
    Accounts.connection.call(                                                             // 29
      "getInterceptedEmails", email1, expect(function (error, result) {                   // 30
        test.equal(error, undefined);                                                     // 31
        test.notEqual(result, undefined);                                                 // 32
        test.equal(result.length, 2); // the first is the email verification              // 33
        var options = result[1];                                                          // 34
                                                                                          // 35
        var re = new RegExp(Meteor.absoluteUrl() + "#/reset-password/(\\S*)")             // 36
        var match = options.text.match(re);                                               // 37
        test.isTrue(match);                                                               // 38
        resetPasswordToken = match[1];                                                    // 39
        test.isTrue(options.html.match(re));                                              // 40
      }));                                                                                // 41
  },                                                                                      // 42
  function (test, expect) {                                                               // 43
    Accounts.resetPassword(resetPasswordToken, "newPassword", expect(function(error) {    // 44
      test.isFalse(error);                                                                // 45
    }));                                                                                  // 46
  },                                                                                      // 47
  function (test, expect) {                                                               // 48
    Meteor.logout(expect(function (error) {                                               // 49
      test.equal(error, undefined);                                                       // 50
      test.equal(Meteor.user(), null);                                                    // 51
    }));                                                                                  // 52
  },                                                                                      // 53
  function (test, expect) {                                                               // 54
    Meteor.loginWithPassword(                                                             // 55
      {email: email1}, "newPassword",                                                     // 56
      expect(function (error) {                                                           // 57
        test.isFalse(error);                                                              // 58
      }));                                                                                // 59
  },                                                                                      // 60
  function (test, expect) {                                                               // 61
    Meteor.logout(expect(function (error) {                                               // 62
      test.equal(error, undefined);                                                       // 63
      test.equal(Meteor.user(), null);                                                    // 64
    }));                                                                                  // 65
  }                                                                                       // 66
]);                                                                                       // 67
                                                                                          // 68
var getVerifyEmailToken = function (email, test, expect) {                                // 69
  Accounts.connection.call(                                                               // 70
    "getInterceptedEmails", email, expect(function (error, result) {                      // 71
      test.equal(error, undefined);                                                       // 72
      test.notEqual(result, undefined);                                                   // 73
      test.equal(result.length, 1);                                                       // 74
      var options = result[0];                                                            // 75
                                                                                          // 76
      var re = new RegExp(Meteor.absoluteUrl() + "#/verify-email/(\\S*)");                // 77
      var match = options.text.match(re);                                                 // 78
      test.isTrue(match);                                                                 // 79
      verifyEmailToken = match[1];                                                        // 80
      test.isTrue(options.html.match(re));                                                // 81
    }));                                                                                  // 82
};                                                                                        // 83
                                                                                          // 84
var loggedIn = function (test, expect) {                                                  // 85
  return expect(function (error) {                                                        // 86
    test.equal(error, undefined);                                                         // 87
    test.isTrue(Meteor.user());                                                           // 88
  });                                                                                     // 89
};                                                                                        // 90
                                                                                          // 91
testAsyncMulti("accounts emails - verify email flow", [                                   // 92
  function (test, expect) {                                                               // 93
    email2 = Random.id() + "-intercept@example.com";                                      // 94
    email3 = Random.id() + "-intercept@example.com";                                      // 95
    Accounts.createUser(                                                                  // 96
      {email: email2, password: 'foobar'},                                                // 97
      loggedIn(test, expect));                                                            // 98
  },                                                                                      // 99
  function (test, expect) {                                                               // 100
    test.equal(Meteor.user().emails.length, 1);                                           // 101
    test.equal(Meteor.user().emails[0].address, email2);                                  // 102
    test.isFalse(Meteor.user().emails[0].verified);                                       // 103
    // We should NOT be publishing things like verification tokens!                       // 104
    test.isFalse(_.has(Meteor.user(), 'services'));                                       // 105
  },                                                                                      // 106
  function (test, expect) {                                                               // 107
    getVerifyEmailToken(email2, test, expect);                                            // 108
  },                                                                                      // 109
  function (test, expect) {                                                               // 110
    // Log out, to test that verifyEmail logs us back in.                                 // 111
    Meteor.logout(expect(function (error) {                                               // 112
      test.equal(error, undefined);                                                       // 113
      test.equal(Meteor.user(), null);                                                    // 114
    }));                                                                                  // 115
  },                                                                                      // 116
  function (test, expect) {                                                               // 117
    Accounts.verifyEmail(verifyEmailToken,                                                // 118
                         loggedIn(test, expect));                                         // 119
  },                                                                                      // 120
  function (test, expect) {                                                               // 121
    test.equal(Meteor.user().emails.length, 1);                                           // 122
    test.equal(Meteor.user().emails[0].address, email2);                                  // 123
    test.isTrue(Meteor.user().emails[0].verified);                                        // 124
  },                                                                                      // 125
  function (test, expect) {                                                               // 126
    Accounts.connection.call(                                                             // 127
      "addEmailForTestAndVerify", email3,                                                 // 128
      expect(function (error, result) {                                                   // 129
        test.isFalse(error);                                                              // 130
        test.equal(Meteor.user().emails.length, 2);                                       // 131
        test.equal(Meteor.user().emails[1].address, email3);                              // 132
        test.isFalse(Meteor.user().emails[1].verified);                                   // 133
      }));                                                                                // 134
  },                                                                                      // 135
  function (test, expect) {                                                               // 136
    getVerifyEmailToken(email3, test, expect);                                            // 137
  },                                                                                      // 138
  function (test, expect) {                                                               // 139
    // Log out, to test that verifyEmail logs us back in. (And if we don't                // 140
    // do that, waitUntilLoggedIn won't be able to prevent race conditions.)              // 141
    Meteor.logout(expect(function (error) {                                               // 142
      test.equal(error, undefined);                                                       // 143
      test.equal(Meteor.user(), null);                                                    // 144
    }));                                                                                  // 145
  },                                                                                      // 146
  function (test, expect) {                                                               // 147
    Accounts.verifyEmail(verifyEmailToken,                                                // 148
                         loggedIn(test, expect));                                         // 149
  },                                                                                      // 150
  function (test, expect) {                                                               // 151
    test.equal(Meteor.user().emails[1].address, email3);                                  // 152
    test.isTrue(Meteor.user().emails[1].verified);                                        // 153
  },                                                                                      // 154
  function (test, expect) {                                                               // 155
    Meteor.logout(expect(function (error) {                                               // 156
      test.equal(error, undefined);                                                       // 157
      test.equal(Meteor.user(), null);                                                    // 158
    }));                                                                                  // 159
  }                                                                                       // 160
]);                                                                                       // 161
                                                                                          // 162
var getEnrollAccountToken = function (email, test, expect) {                              // 163
  Accounts.connection.call(                                                               // 164
    "getInterceptedEmails", email, expect(function (error, result) {                      // 165
      test.equal(error, undefined);                                                       // 166
      test.notEqual(result, undefined);                                                   // 167
      test.equal(result.length, 1);                                                       // 168
      var options = result[0];                                                            // 169
                                                                                          // 170
      var re = new RegExp(Meteor.absoluteUrl() + "#/enroll-account/(\\S*)")               // 171
      var match = options.text.match(re);                                                 // 172
      test.isTrue(match);                                                                 // 173
      enrollAccountToken = match[1];                                                      // 174
      test.isTrue(options.html.match(re));                                                // 175
    }));                                                                                  // 176
};                                                                                        // 177
                                                                                          // 178
testAsyncMulti("accounts emails - enroll account flow", [                                 // 179
  function (test, expect) {                                                               // 180
    email4 = Random.id() + "-intercept@example.com";                                      // 181
    Accounts.connection.call("createUserOnServer", email4,                                // 182
      expect(function (error, result) {                                                   // 183
        test.isFalse(error);                                                              // 184
        var user = result;                                                                // 185
        test.equal(user.emails.length, 1);                                                // 186
        test.equal(user.emails[0].address, email4);                                       // 187
        test.isFalse(user.emails[0].verified);                                            // 188
      }));                                                                                // 189
  },                                                                                      // 190
  function (test, expect) {                                                               // 191
    getEnrollAccountToken(email4, test, expect);                                          // 192
  },                                                                                      // 193
  function (test, expect) {                                                               // 194
    Accounts.resetPassword(enrollAccountToken, 'password',                                // 195
                           loggedIn(test, expect));                                       // 196
  },                                                                                      // 197
  function (test, expect) {                                                               // 198
    test.equal(Meteor.user().emails.length, 1);                                           // 199
    test.equal(Meteor.user().emails[0].address, email4);                                  // 200
    test.isTrue(Meteor.user().emails[0].verified);                                        // 201
  },                                                                                      // 202
  function (test, expect) {                                                               // 203
    Meteor.logout(expect(function (error) {                                               // 204
      test.equal(error, undefined);                                                       // 205
      test.equal(Meteor.user(), null);                                                    // 206
    }));                                                                                  // 207
  },                                                                                      // 208
  function (test, expect) {                                                               // 209
    Meteor.loginWithPassword({email: email4}, 'password',                                 // 210
                             loggedIn(test ,expect));                                     // 211
  },                                                                                      // 212
  function (test, expect) {                                                               // 213
    test.equal(Meteor.user().emails.length, 1);                                           // 214
    test.equal(Meteor.user().emails[0].address, email4);                                  // 215
    test.isTrue(Meteor.user().emails[0].verified);                                        // 216
  },                                                                                      // 217
  function (test, expect) {                                                               // 218
    Meteor.logout(expect(function (error) {                                               // 219
      test.equal(error, undefined);                                                       // 220
      test.equal(Meteor.user(), null);                                                    // 221
    }));                                                                                  // 222
  }                                                                                       // 223
]);                                                                                       // 224
                                                                                          // 225
////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
