(function () {

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                     //
// packages/accounts-base/accounts_tests.js                                                            //
//                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                       //
Meteor.methods({                                                                                       // 1
  getCurrentLoginToken: function () {                                                                  // 2
    return Accounts._getLoginToken(this.connection.id);                                                // 3
  }                                                                                                    // 4
});                                                                                                    // 5
                                                                                                       // 6
// XXX it'd be cool to also test that the right thing happens if options                               // 7
// *are* validated, but Accounts._options is global state which makes this hard                        // 8
// (impossible?)                                                                                       // 9
Tinytest.add('accounts - config validates keys', function (test) {                                     // 10
  test.throws(function () {                                                                            // 11
    Accounts.config({foo: "bar"});                                                                     // 12
  });                                                                                                  // 13
});                                                                                                    // 14
                                                                                                       // 15
                                                                                                       // 16
var idsInValidateNewUser = {};                                                                         // 17
Accounts.validateNewUser(function (user) {                                                             // 18
  idsInValidateNewUser[user._id] = true;                                                               // 19
  return true;                                                                                         // 20
});                                                                                                    // 21
                                                                                                       // 22
Tinytest.add('accounts - validateNewUser gets passed user with _id', function (test) {                 // 23
  var newUserId = Accounts.updateOrCreateUserFromExternalService('foobook', {id: Random.id()}).userId; // 24
  test.isTrue(newUserId in idsInValidateNewUser);                                                      // 25
});                                                                                                    // 26
                                                                                                       // 27
Tinytest.add('accounts - updateOrCreateUserFromExternalService - Facebook', function (test) {          // 28
  var facebookId = Random.id();                                                                        // 29
                                                                                                       // 30
  // create an account with facebook                                                                   // 31
  var uid1 = Accounts.updateOrCreateUserFromExternalService(                                           // 32
    'facebook', {id: facebookId, monkey: 42}, {profile: {foo: 1}}).id;                                 // 33
  var users = Meteor.users.find({"services.facebook.id": facebookId}).fetch();                         // 34
  test.length(users, 1);                                                                               // 35
  test.equal(users[0].profile.foo, 1);                                                                 // 36
  test.equal(users[0].services.facebook.monkey, 42);                                                   // 37
                                                                                                       // 38
  // create again with the same id, see that we get the same user.                                     // 39
  // it should update services.facebook but not profile.                                               // 40
  var uid2 = Accounts.updateOrCreateUserFromExternalService(                                           // 41
    'facebook', {id: facebookId, llama: 50},                                                           // 42
    {profile: {foo: 1000, bar: 2}}).id;                                                                // 43
  test.equal(uid1, uid2);                                                                              // 44
  users = Meteor.users.find({"services.facebook.id": facebookId}).fetch();                             // 45
  test.length(users, 1);                                                                               // 46
  test.equal(users[0].profile.foo, 1);                                                                 // 47
  test.equal(users[0].profile.bar, undefined);                                                         // 48
  test.equal(users[0].services.facebook.llama, 50);                                                    // 49
  // make sure we *don't* lose values not passed this call to                                          // 50
  // updateOrCreateUserFromExternalService                                                             // 51
  test.equal(users[0].services.facebook.monkey, 42);                                                   // 52
                                                                                                       // 53
  // cleanup                                                                                           // 54
  Meteor.users.remove(uid1);                                                                           // 55
});                                                                                                    // 56
                                                                                                       // 57
Tinytest.add('accounts - updateOrCreateUserFromExternalService - Weibo', function (test) {             // 58
  var weiboId1 = Random.id();                                                                          // 59
  var weiboId2 = Random.id();                                                                          // 60
                                                                                                       // 61
  // users that have different service ids get different users                                         // 62
  var uid1 = Accounts.updateOrCreateUserFromExternalService(                                           // 63
    'weibo', {id: weiboId1}, {profile: {foo: 1}}).id;                                                  // 64
  var uid2 = Accounts.updateOrCreateUserFromExternalService(                                           // 65
    'weibo', {id: weiboId2}, {profile: {bar: 2}}).id;                                                  // 66
  test.equal(Meteor.users.find({"services.weibo.id": {$in: [weiboId1, weiboId2]}}).count(), 2);        // 67
  test.equal(Meteor.users.findOne({"services.weibo.id": weiboId1}).profile.foo, 1);                    // 68
  test.equal(Meteor.users.findOne({"services.weibo.id": weiboId1}).emails, undefined);                 // 69
  test.equal(Meteor.users.findOne({"services.weibo.id": weiboId2}).profile.bar, 2);                    // 70
  test.equal(Meteor.users.findOne({"services.weibo.id": weiboId2}).emails, undefined);                 // 71
                                                                                                       // 72
  // cleanup                                                                                           // 73
  Meteor.users.remove(uid1);                                                                           // 74
  Meteor.users.remove(uid2);                                                                           // 75
});                                                                                                    // 76
                                                                                                       // 77
Tinytest.add('accounts - updateOrCreateUserFromExternalService - Twitter', function (test) {           // 78
  var twitterIdOld = parseInt(Random.hexString(4), 16);                                                // 79
  var twitterIdNew = ''+twitterIdOld;                                                                  // 80
                                                                                                       // 81
  // create an account with twitter using the old ID format of integer                                 // 82
  var uid1 = Accounts.updateOrCreateUserFromExternalService(                                           // 83
    'twitter', {id: twitterIdOld, monkey: 42}, {profile: {foo: 1}}).id;                                // 84
  var users = Meteor.users.find({"services.twitter.id": twitterIdOld}).fetch();                        // 85
  test.length(users, 1);                                                                               // 86
  test.equal(users[0].profile.foo, 1);                                                                 // 87
  test.equal(users[0].services.twitter.monkey, 42);                                                    // 88
                                                                                                       // 89
  // Update the account with the new ID format of string                                               // 90
  // test that the existing user is found, and that the ID                                             // 91
  // gets updated to a string value                                                                    // 92
  var uid2 = Accounts.updateOrCreateUserFromExternalService(                                           // 93
    'twitter', {id: twitterIdNew, monkey: 42}, {profile: {foo: 1}}).id;                                // 94
  test.equal(uid1, uid2);                                                                              // 95
  users = Meteor.users.find({"services.twitter.id": twitterIdNew}).fetch();                            // 96
  test.length(users, 1);                                                                               // 97
                                                                                                       // 98
  // cleanup                                                                                           // 99
  Meteor.users.remove(uid1);                                                                           // 100
});                                                                                                    // 101
                                                                                                       // 102
                                                                                                       // 103
Tinytest.add('accounts - insertUserDoc username', function (test) {                                    // 104
  var userIn = {                                                                                       // 105
    username: Random.id()                                                                              // 106
  };                                                                                                   // 107
                                                                                                       // 108
  // user does not already exist. create a user object with fields set.                                // 109
  var userId = Accounts.insertUserDoc(                                                                 // 110
    {profile: {name: 'Foo Bar'}},                                                                      // 111
    userIn                                                                                             // 112
  );                                                                                                   // 113
  var userOut = Meteor.users.findOne(userId);                                                          // 114
                                                                                                       // 115
  test.equal(typeof userOut.createdAt, 'object');                                                      // 116
  test.equal(userOut.profile.name, 'Foo Bar');                                                         // 117
  test.equal(userOut.username, userIn.username);                                                       // 118
                                                                                                       // 119
  // run the hook again. now the user exists, so it throws an error.                                   // 120
  test.throws(function () {                                                                            // 121
    Accounts.insertUserDoc(                                                                            // 122
      {profile: {name: 'Foo Bar'}},                                                                    // 123
      userIn                                                                                           // 124
    );                                                                                                 // 125
  });                                                                                                  // 126
                                                                                                       // 127
  // cleanup                                                                                           // 128
  Meteor.users.remove(userId);                                                                         // 129
});                                                                                                    // 130
                                                                                                       // 131
Tinytest.add('accounts - insertUserDoc email', function (test) {                                       // 132
  var email1 = Random.id();                                                                            // 133
  var email2 = Random.id();                                                                            // 134
  var email3 = Random.id();                                                                            // 135
  var userIn = {                                                                                       // 136
    emails: [{address: email1, verified: false},                                                       // 137
             {address: email2, verified: true}]                                                        // 138
  };                                                                                                   // 139
                                                                                                       // 140
  // user does not already exist. create a user object with fields set.                                // 141
  var userId = Accounts.insertUserDoc(                                                                 // 142
    {profile: {name: 'Foo Bar'}},                                                                      // 143
    userIn                                                                                             // 144
  );                                                                                                   // 145
  var userOut = Meteor.users.findOne(userId);                                                          // 146
                                                                                                       // 147
  test.equal(typeof userOut.createdAt, 'object');                                                      // 148
  test.equal(userOut.profile.name, 'Foo Bar');                                                         // 149
  test.equal(userOut.emails, userIn.emails);                                                           // 150
                                                                                                       // 151
  // run the hook again with the exact same emails.                                                    // 152
  // run the hook again. now the user exists, so it throws an error.                                   // 153
  test.throws(function () {                                                                            // 154
    Accounts.insertUserDoc(                                                                            // 155
      {profile: {name: 'Foo Bar'}},                                                                    // 156
      userIn                                                                                           // 157
    );                                                                                                 // 158
  });                                                                                                  // 159
                                                                                                       // 160
  // now with only one of them.                                                                        // 161
  test.throws(function () {                                                                            // 162
    Accounts.insertUserDoc(                                                                            // 163
      {}, {emails: [{address: email1}]}                                                                // 164
    );                                                                                                 // 165
  });                                                                                                  // 166
                                                                                                       // 167
  test.throws(function () {                                                                            // 168
    Accounts.insertUserDoc(                                                                            // 169
      {}, {emails: [{address: email2}]}                                                                // 170
    );                                                                                                 // 171
  });                                                                                                  // 172
                                                                                                       // 173
                                                                                                       // 174
  // a third email works.                                                                              // 175
  var userId3 = Accounts.insertUserDoc(                                                                // 176
      {}, {emails: [{address: email3}]}                                                                // 177
  );                                                                                                   // 178
  var user3 = Meteor.users.findOne(userId3);                                                           // 179
  test.equal(typeof user3.createdAt, 'object');                                                        // 180
                                                                                                       // 181
  // cleanup                                                                                           // 182
  Meteor.users.remove(userId);                                                                         // 183
  Meteor.users.remove(userId3);                                                                        // 184
});                                                                                                    // 185
                                                                                                       // 186
// More token expiration tests are in accounts-password                                                // 187
Tinytest.addAsync('accounts - expire numeric token', function (test, onComplete) {                     // 188
  var userIn = { username: Random.id() };                                                              // 189
  var userId = Accounts.insertUserDoc({ profile: {                                                     // 190
    name: 'Foo Bar'                                                                                    // 191
  } }, userIn);                                                                                        // 192
  var date = new Date(new Date() - 5000);                                                              // 193
  Meteor.users.update(userId, {                                                                        // 194
    $set: {                                                                                            // 195
      "services.resume.loginTokens": [{                                                                // 196
        hashedToken: Random.id(),                                                                      // 197
        when: date                                                                                     // 198
      }, {                                                                                             // 199
        hashedToken: Random.id(),                                                                      // 200
        when: +date                                                                                    // 201
      }]                                                                                               // 202
    }                                                                                                  // 203
  });                                                                                                  // 204
  var observe = Meteor.users.find(userId).observe({                                                    // 205
    changed: function (newUser) {                                                                      // 206
      if (newUser.services && newUser.services.resume &&                                               // 207
          _.isEmpty(newUser.services.resume.loginTokens)) {                                            // 208
        observe.stop();                                                                                // 209
        onComplete();                                                                                  // 210
      }                                                                                                // 211
    }                                                                                                  // 212
  });                                                                                                  // 213
  Accounts._expireTokens(new Date(), userId);                                                          // 214
});                                                                                                    // 215
                                                                                                       // 216
                                                                                                       // 217
// Login tokens used to be stored unhashed in the database.  We want                                   // 218
// to make sure users can still login after upgrading.                                                 // 219
var insertUnhashedLoginToken = function (userId, stampedToken) {                                       // 220
  Meteor.users.update(                                                                                 // 221
    userId,                                                                                            // 222
    {$push: {'services.resume.loginTokens': stampedToken}}                                             // 223
  );                                                                                                   // 224
};                                                                                                     // 225
                                                                                                       // 226
Tinytest.addAsync('accounts - login token', function (test, onComplete) {                              // 227
  // Test that we can login when the database contains a leftover                                      // 228
  // old style unhashed login token.                                                                   // 229
  var userId1 = Accounts.insertUserDoc({}, {username: Random.id()});                                   // 230
  var stampedToken = Accounts._generateStampedLoginToken();                                            // 231
  insertUnhashedLoginToken(userId1, stampedToken);                                                     // 232
  var connection = DDP.connect(Meteor.absoluteUrl());                                                  // 233
  connection.call('login', {resume: stampedToken.token});                                              // 234
  connection.disconnect();                                                                             // 235
                                                                                                       // 236
  // Steal the unhashed token from the database and use it to login.                                   // 237
  // This is a sanity check so that when we *can't* login with a                                       // 238
  // stolen *hashed* token, we know it's not a problem with the test.                                  // 239
  var userId2 = Accounts.insertUserDoc({}, {username: Random.id()});                                   // 240
  insertUnhashedLoginToken(userId2, Accounts._generateStampedLoginToken());                            // 241
  var stolenToken = Meteor.users.findOne(userId2).services.resume.loginTokens[0].token;                // 242
  test.isTrue(stolenToken);                                                                            // 243
  connection = DDP.connect(Meteor.absoluteUrl());                                                      // 244
  connection.call('login', {resume: stolenToken});                                                     // 245
  connection.disconnect();                                                                             // 246
                                                                                                       // 247
  // Now do the same thing, this time with a stolen hashed token.                                      // 248
  var userId3 = Accounts.insertUserDoc({}, {username: Random.id()});                                   // 249
  Accounts._insertLoginToken(userId3, Accounts._generateStampedLoginToken());                          // 250
  stolenToken = Meteor.users.findOne(userId3).services.resume.loginTokens[0].hashedToken;              // 251
  test.isTrue(stolenToken);                                                                            // 252
  connection = DDP.connect(Meteor.absoluteUrl());                                                      // 253
  // evil plan foiled                                                                                  // 254
  test.throws(                                                                                         // 255
    function () {                                                                                      // 256
      connection.call('login', {resume: stolenToken});                                                 // 257
    },                                                                                                 // 258
    /You\'ve been logged out by the server/                                                            // 259
  );                                                                                                   // 260
  connection.disconnect();                                                                             // 261
                                                                                                       // 262
  // Old style unhashed tokens are replaced by hashed tokens when                                      // 263
  // encountered.  This means that after someone logins once, the                                      // 264
  // old unhashed token is no longer available to be stolen.                                           // 265
  var userId4 = Accounts.insertUserDoc({}, {username: Random.id()});                                   // 266
  var stampedToken = Accounts._generateStampedLoginToken();                                            // 267
  insertUnhashedLoginToken(userId4, stampedToken);                                                     // 268
  connection = DDP.connect(Meteor.absoluteUrl());                                                      // 269
  connection.call('login', {resume: stampedToken.token});                                              // 270
  connection.disconnect();                                                                             // 271
                                                                                                       // 272
  // The token is no longer available to be stolen.                                                    // 273
  stolenToken = Meteor.users.findOne(userId4).services.resume.loginTokens[0].token;                    // 274
  test.isFalse(stolenToken);                                                                           // 275
                                                                                                       // 276
  // After the upgrade, the client can still login with their original                                 // 277
  // unhashed login token.                                                                             // 278
  connection = DDP.connect(Meteor.absoluteUrl());                                                      // 279
  connection.call('login', {resume: stampedToken.token});                                              // 280
  connection.disconnect();                                                                             // 281
                                                                                                       // 282
  onComplete();                                                                                        // 283
});                                                                                                    // 284
                                                                                                       // 285
Tinytest.addAsync(                                                                                     // 286
  'accounts - connection data cleaned up',                                                             // 287
  function (test, onComplete) {                                                                        // 288
    makeTestConnection(                                                                                // 289
      test,                                                                                            // 290
      function (clientConn, serverConn) {                                                              // 291
        // onClose callbacks are called in order, so we run after the                                  // 292
        // close callback in accounts.                                                                 // 293
        serverConn.onClose(function () {                                                               // 294
          test.isFalse(Accounts._getAccountData(serverConn.id, 'connection'));                         // 295
          onComplete();                                                                                // 296
        });                                                                                            // 297
                                                                                                       // 298
        test.isTrue(Accounts._getAccountData(serverConn.id, 'connection'));                            // 299
        serverConn.close();                                                                            // 300
      },                                                                                               // 301
      onComplete                                                                                       // 302
    );                                                                                                 // 303
  }                                                                                                    // 304
);                                                                                                     // 305
                                                                                                       // 306
Tinytest.add(                                                                                          // 307
  'accounts - get new token',                                                                          // 308
  function (test) {                                                                                    // 309
    // Test that the `getNewToken` method returns us a valid token, with                               // 310
    // the same expiration as our original token.                                                      // 311
    var userId = Accounts.insertUserDoc({}, { username: Random.id() });                                // 312
    var stampedToken = Accounts._generateStampedLoginToken();                                          // 313
    Accounts._insertLoginToken(userId, stampedToken);                                                  // 314
    var conn = DDP.connect(Meteor.absoluteUrl());                                                      // 315
    conn.call('login', { resume: stampedToken.token });                                                // 316
    test.equal(conn.call('getCurrentLoginToken'),                                                      // 317
               Accounts._hashLoginToken(stampedToken.token));                                          // 318
                                                                                                       // 319
    var newTokenResult = conn.call('getNewToken');                                                     // 320
    test.equal(newTokenResult.tokenExpires,                                                            // 321
               Accounts._tokenExpiration(stampedToken.when));                                          // 322
    test.equal(conn.call('getCurrentLoginToken'),                                                      // 323
               Accounts._hashLoginToken(newTokenResult.token));                                        // 324
    conn.disconnect();                                                                                 // 325
                                                                                                       // 326
    // A second connection should be able to log in with the new token                                 // 327
    // we got.                                                                                         // 328
    var secondConn = DDP.connect(Meteor.absoluteUrl());                                                // 329
    secondConn.call('login', { resume: newTokenResult.token });                                        // 330
    secondConn.disconnect();                                                                           // 331
  }                                                                                                    // 332
);                                                                                                     // 333
                                                                                                       // 334
Tinytest.addAsync(                                                                                     // 335
  'accounts - remove other tokens',                                                                    // 336
  function (test, onComplete) {                                                                        // 337
    // Test that the `removeOtherTokens` method removes all tokens other                               // 338
    // than the caller's token, thereby logging out and closing other                                  // 339
    // connections.                                                                                    // 340
    var userId = Accounts.insertUserDoc({}, { username: Random.id() });                                // 341
    var stampedTokens = [];                                                                            // 342
    var conns = [];                                                                                    // 343
                                                                                                       // 344
    _.times(2, function (i) {                                                                          // 345
      stampedTokens.push(Accounts._generateStampedLoginToken());                                       // 346
      Accounts._insertLoginToken(userId, stampedTokens[i]);                                            // 347
      var conn = DDP.connect(Meteor.absoluteUrl());                                                    // 348
      conn.call('login', { resume: stampedTokens[i].token });                                          // 349
      test.equal(conn.call('getCurrentLoginToken'),                                                    // 350
                 Accounts._hashLoginToken(stampedTokens[i].token));                                    // 351
      conns.push(conn);                                                                                // 352
    });                                                                                                // 353
                                                                                                       // 354
    conns[0].call('removeOtherTokens');                                                                // 355
    simplePoll(                                                                                        // 356
      function () {                                                                                    // 357
        var tokens = _.map(conns, function (conn) {                                                    // 358
          return conn.call('getCurrentLoginToken');                                                    // 359
        });                                                                                            // 360
        return ! tokens[1] &&                                                                          // 361
          tokens[0] === Accounts._hashLoginToken(stampedTokens[0].token);                              // 362
      },                                                                                               // 363
      function () { // success                                                                         // 364
        _.each(conns, function (conn) {                                                                // 365
          conn.disconnect();                                                                           // 366
        });                                                                                            // 367
        onComplete();                                                                                  // 368
      },                                                                                               // 369
      function () { // timed out                                                                       // 370
        throw new Error("accounts - remove other tokens timed out");                                   // 371
      }                                                                                                // 372
    );                                                                                                 // 373
  }                                                                                                    // 374
);                                                                                                     // 375
                                                                                                       // 376
/////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);
